;	SCCSID = @(#)pridefs.asm	4.4 85/07/17
title	3.00 Print Utility

;MS-DOS PSPRINT/PRINT program for background printing of text files
;	to the list device.
;
;  IBM SERVER VERSION
;
;	 INT 28H is a software interrupt generated by the  DOS
;	 in  its  I/O  wait  loops.   This spooler can be assembled for
;	 operation using only this interrupt  which  is  portable  from
;	 system to  system.  It may also be assembled to use a hardware
;	 timer interrupt in addition to  the  software	INT  28H.   The
;	 purpose  of  using hardware interrupts is to allow printing to
;	 continue during programs which do not	enter  the  system  and
;	 therefore causes the INT 28H to go away.  A timer interrupt is
;	 chosen in preference to a  "printer  buffer  empty"  interrupt
;	 because  PRINT  in the timer form is generic.	It can be given
;	 the name of any currently installed character	device	as  the
;	 "printer",  this  makes  it  portable  to  devices  which  are
;	 installed by the user even in the hardware case.  It could  be
;	 modified to use a buffer empty interrupt (no code is given for
;	 this case), if this is done the PROMPT and BADMES messages and
;	 their associated  code should be removed as PRINT will then be
;	 device specific.
;
;	V1.00	07/03/82
;	V2.00	07/05/83	A.Reynolds
;		New INT 2FH interface, Pathnames, context switch.
;	V2.50	09/14/83	M.A.Ulloa
;		Turned it back to a print
;		11/21/83	M.A.Ulloa
;		Repaired bug in file cancel code
;		11/28/83	M.A.Ulloa
;		Added int 23 and 24 handlers to transient.
;		01/27/84	M.A.Ulloa
;		Allways checks for valid drive.
;	V3.00	02/03/84	M.A.Ulloa
;		Partitioned so as to assemble on a PC
;		By the by, it is V3.00 now.
;		05/23/85	K.G.Schulmeisters
;		Chains into INT19 (bootstrap) to unhook
;		INT_1C (timer) and INT_15 (AT's Wait On Event)
;


;	Aaron's rambling:
;
; BEWARE ALL YEE WHO ENTER HERE.
;    PRINT is an amazingly complex program.  MS-DOS versions below 3.00 are
;    NOT re-entrant, this means that this utility is basically not a
;    possibility.  It gets by on the fact that it is written by the same
;    person who wrote the OS.  Since you are not that person, you must be very
;    careful about making any modification to this utility.  There are a
;    number of things which may seem to be unnecessary on first examination.
;    BEWARE, almost every line of code is there for a very good reason.  The
;    order of things is very carefully chosen.	PRINT is full of potential
;    windows, make sure that you do not open one by careless modification.  Do
;    not look for a lot of help from the comments, a complete explanation
;    would probably fill a book.  A succesful modifier will have an in-depth
;    knowledge of the internal function of MS-DOS, and of the PRINT utility
;    itself through in depth study of the comments AND the code.


subttl	General Definition
page


FALSE	EQU	0
TRUE	EQU	NOT FALSE

;IBM	EQU	TRUE
;IBMVER	EQU	IBM
;MSVER	EQU	FALSE

include version.inc

	IF	MSVER
HARDINT EQU	FALSE			;No hardware ints
AINT	EQU	FALSE			;No need to do interrupt acknowledge
	ENDIF

	IF	IBM
HARDINT EQU	TRUE
INTLOC	EQU	1CH			;Hardware interrupt location (Timer)
REBOOT	EQU	19H			;ROM BIOS "Bootstrap"
AINT	EQU	TRUE			;Acknowledge interrupts
EOI	EQU	20H			;End Of Interrupt "instruction"
AKPORT	EQU	20H			;Interrupt Acknowledge port
	ENDIF

;  The following values have to do with the ERRCNT variable and the CNTMES
;  message.  The values define levels at wich it is assumed an off-line error
;  exists.  ERRCNT1 defines the value of ERRCNT above which the CNTMES message
;  is printed by the transient.  ERRCNT2 defines the value of ERRCNT above
;  which the resident will give up trying to print messages on the printer, it
;  is much greater than ERRCNT1 because a much tighter loop is involved.  The
;  bounding event which determines the correct value is the time required to
;  do a form feed.

	IF	IBM
ERRCNT1 EQU	1500
ERRCNT2 EQU	20000
	ELSE
ERRCNT1 EQU	1500
ERRCNT2 EQU	20000
	ENDIF


;WARNING DANGER WARNING:
;   PRINT is a systems utility. It is clearly understood that it may have
;   to be entirely re-written for future versions of MS-DOS. The following
;   TWO vectors are version specific, they may not exist at all in future
;   versions. If they do exist, they may function differently.
; ANY PROGRAM WHICH IMITATES PRINTS USE OF THESE VECTORS IS ALSO A SYSTEMS
; UTILITY AND IS THEREFORE NOT VERSION PORTABLE IN ANY WAY SHAPE OR FORM.
; YOU HAVE BEEN WARNED, "I DID IT THE SAME WAY PRINT DID" IS NOT AN REASON
; TO EXPECT A PROGRAM TO WORK ON FUTURE VERSIONS OF MS-DOS.

SOFTINT EQU	28H			;Software interrupt generated by DOS
ComInt	EQU	2FH			;Communications interrupt used by PSPRINT
					;    Multiplex number 0 and 1

;----- Default (and Minimal) Print queue length
DefQueueLen equ 10			; 10 files worth
MinQueueLen equ 4			; 4 files worth min
MaxQueueLen equ 32			; 32 files worth max.

;----- Maximum length of a file name (incl nul)
MaxFileLen equ	64

; **************** Bogosity Warning *****************
;  Below is the equate that MaxFile SHOULD be.	Since the 3.0/3.1 documentation
;  documents each queue entry as being 64 chars long.  Yes it is known that
;  that causes Print to misbehave on files deep in trees.  But for
;  compatibilities sake, IBM insisted that we change the code back to the
;  way it was.
;MaxFileLen equ  63 + 2 + 12		 ; 63 characters as Command.com's
					;	  max. path length
					; 2  character for the Drive ext.
					; 12 characters for the max. valid
					;    DOS filename


.xlist
.xcref
BREAK	MACRO	subtitle
	SUBTTL	subtitle
	PAGE
ENDM

stdin	    EQU     0
stdout	    EQU     1
stderr	    EQU     2
stdaux	    EQU     3
stdprn	    EQU     4

	INCLUDE DEVSYM.INC
	INCLUDE SYSCALL.INC
	INCLUDE ERROR.INC
	INCLUDE SYSVAR.INC
	INCLUDE FIND.INC
	include dpl.inc
	INCLUDE PDB.INC
	INCLUDE SYSCALL.INC
	INCLUDE MI.INC
	include versiona.inc
.list
.cref


error_busy		EQU	9
error_queue_full	EQU	8
error_name_too_long	EQU	12

IF1
	IF	IBM
	%out	IBM VERSION
	ELSE
	%out	MS-DOS VERSION
	ENDIF
ENDIF

BREAK	<Segment Definitions>


CodeR	Segment public para
CodeR	EndS

Code	Segment public para
Code	EndS

Data	Segment public byte
Data	EndS

Stack	Segment Stack
Stack	Ends

DG	group	Code,Data,Stack

SaveReg MACRO	reglist 		;; push those registers
IRP reg,<reglist>
	PUSH	reg
ENDM
ENDM
.xcref	SaveReg

RestoreReg  MACRO   reglist		;; pop those registers
IRP reg,<reglist>
	POP	reg
ENDM
ENDM
