#pragma once

// Includes
#include "D3D10ProxyDriver.h"
#include "stringutils.h"

// Defines
#define DDISETPFN(PFN,TYPE) TYPE PFN(TYPE)
#define STRLENGTH 256

// Enums
enum PROXY_SETUP
{
	PROXY_SETUP_OK,
	PROXY_SETUP_PROXY_DLL_FAILED,
	PROXY_SETUP_DEVICE_DLL_FAILED,
};

enum PROXY_LISTENERS
{
	PROXY_LISTENERS_OK,
	PROXY_LISTENERS_10_DDI_DEVFUNCTS_FAILED,
	PROXY_LISTENERS_10_1DDI_DEVFUNCTS_FAILED
};

////////////////////////

class CProxyRef10
{
public:
	CProxyRef10( void );
	~CProxyRef10( void );

	PROXY_SETUP		Setup( tstring d3d10DeviceDLL = "", PD_CREATE_DEVICE_FP* createDeviceCallback = NULL );
	HRESULT			CreateDevice1(ID3D10Device1** ppDevice, D3D10_FEATURE_LEVEL1 fl = D3D10_FEATURE_LEVEL_10_1, UINT createDeviceFlags = D3D10_CREATE_DEVICE_SINGLETHREADED);
	HRESULT			CreateDevice(ID3D10Device** ppDevice, UINT createDeviceFlags = D3D10_CREATE_DEVICE_SINGLETHREADED);
	HMODULE			GetProxyDriverHandle();
	PROXY_LISTENERS	CaptureDriverListenerFunctions();

protected:
	PROXY_SETUP		LoadProxyDriverDLL( tstring );
	void			SetCreateDeviceCallback(PD_CREATE_DEVICE_FP*);

public:
	// Here are the setter functions for the device function pointers
	DDISETPFN( SetDDI_ConstantBufferUpdateSubresourceUP, PFND3D10DDI_RESOURCEUPDATESUBRESOURCEUP );
	DDISETPFN( SetDDI_VsSetConstantBuffers, PFND3D10DDI_SETCONSTANTBUFFERS );
	DDISETPFN( SetDDI_PSSetShaderResources, PFND3D10DDI_SETSHADERRESOURCES );
	DDISETPFN( SetDDI_PsSetShader, PFND3D10DDI_SETSHADER );
	DDISETPFN( SetDDI_PSSetSamplers, PFND3D10DDI_SETSAMPLERS );
	DDISETPFN( SetDDI_VsSetShader, PFND3D10DDI_SETSHADER );
	DDISETPFN( SetDDI_DrawIndexed, PFND3D10DDI_DRAWINDEXED );
	DDISETPFN( SetDDI_Draw, PFND3D10DDI_DRAW );
	DDISETPFN( SetDDI_DynamicIABufferMapNoOverwrite, PFND3D10DDI_RESOURCEMAP );
	DDISETPFN( SetDDI_DynamicIABufferUnmap, PFND3D10DDI_RESOURCEUNMAP );
	DDISETPFN( SetDDI_DynamicConstantBufferMapDiscard, PFND3D10DDI_RESOURCEMAP );
	DDISETPFN( SetDDI_DynamicIABufferMapDiscard, PFND3D10DDI_RESOURCEMAP );
	DDISETPFN( SetDDI_DynamicConstantBufferUnmap, PFND3D10DDI_RESOURCEUNMAP );
	DDISETPFN( SetDDI_PsSetConstantBuffers, PFND3D10DDI_SETCONSTANTBUFFERS );
	DDISETPFN( SetDDI_IaSetInputLayout, PFND3D10DDI_SETINPUTLAYOUT );
	DDISETPFN( SetDDI_IaSetVertexBuffers, PFND3D10DDI_IA_SETVERTEXBUFFERS );
	DDISETPFN( SetDDI_IaSetIndexBuffer, PFND3D10DDI_IA_SETINDEXBUFFER );

	DDISETPFN( SetDDI_DrawIndexedInstanced, PFND3D10DDI_DRAWINDEXEDINSTANCED );
	DDISETPFN( SetDDI_DrawInstanced, PFND3D10DDI_DRAWINSTANCED );
	DDISETPFN( SetDDI_DynamicResourceMapDiscard, PFND3D10DDI_RESOURCEMAP );
	DDISETPFN( SetDDI_DynamicResourceUnmap, PFND3D10DDI_RESOURCEUNMAP );
	DDISETPFN( SetDDI_GsSetConstantBuffers, PFND3D10DDI_SETCONSTANTBUFFERS );
	DDISETPFN( SetDDI_GsSetShader, PFND3D10DDI_SETSHADER );
	DDISETPFN( SetDDI_IaSetTopology, PFND3D10DDI_IA_SETTOPOLOGY );
	DDISETPFN( SetDDI_StagingResourceMap, PFND3D10DDI_RESOURCEMAP );
	DDISETPFN( SetDDI_StagingResourceUnmap, PFND3D10DDI_RESOURCEUNMAP );
	DDISETPFN( SetDDI_VSSetShaderResources, PFND3D10DDI_SETSHADERRESOURCES );
	DDISETPFN( SetDDI_VSSetSamplers, PFND3D10DDI_SETSAMPLERS );
	DDISETPFN( SetDDI_GSSetShaderResources, PFND3D10DDI_SETSHADERRESOURCES );

	
	DDISETPFN( SetDDI_GSSetSamplers, PFND3D10DDI_SETSAMPLERS );
    DDISETPFN( SetDDI_SetRenderTargets, PFND3D10DDI_SETRENDERTARGETS );
	DDISETPFN( SetDDI_ShaderResourceViewReadAfterWriteHazard, PFND3D10DDI_SHADERRESOURCEVIEWREADAFTERWRITEHAZARD);
	DDISETPFN( SetDDI_ResourceReadAfterWriteHazard, PFND3D10DDI_RESOURCEREADAFTERWRITEHAZARD);
	DDISETPFN( SetDDI_SetBlendState, PFND3D10DDI_SETBLENDSTATE);
    DDISETPFN( SetDDI_SetDepthStencilState, PFND3D10DDI_SETDEPTHSTENCILSTATE);
    DDISETPFN( SetDDI_SetRasterizerState, PFND3D10DDI_SETRASTERIZERSTATE);
    DDISETPFN( SetDDI_QueryEnd, PFND3D10DDI_QUERYEND);
    DDISETPFN( SetDDI_QueryBegin, PFND3D10DDI_QUERYBEGIN);
    DDISETPFN( SetDDI_ResourceCopyRegion, PFND3D10DDI_RESOURCECOPYREGION);
	DDISETPFN( SetDDI_ResourceUpdateSubresourceUP, PFND3D10DDI_RESOURCEUPDATESUBRESOURCEUP);
    DDISETPFN( SetDDI_SOSetTargets, PFND3D10DDI_SO_SETTARGETS);
    DDISETPFN( SetDDI_DrawAuto, PFND3D10DDI_DRAWAUTO);
	DDISETPFN( SetDDI_SetViewports, PFND3D10DDI_SETVIEWPORTS);
	DDISETPFN( SetDDI_SetScissorRects, PFND3D10DDI_SETSCISSORRECTS);
	DDISETPFN( SetDDI_ClearRenderTargetView, PFND3D10DDI_CLEARRENDERTARGETVIEW);
	DDISETPFN( SetDDI_ClearDepthStencilView, PFND3D10DDI_CLEARDEPTHSTENCILVIEW);
    DDISETPFN( SetDDI_SetPredication, PFND3D10DDI_SETPREDICATION);
    DDISETPFN( SetDDI_QueryGetData, PFND3D10DDI_QUERYGETDATA);
    DDISETPFN( SetDDI_Flush, PFND3D10DDI_FLUSH);
    DDISETPFN( SetDDI_GenerateMips, PFND3D10DDI_GENMIPS);
	DDISETPFN( SetDDI_ResourceCopy, PFND3D10DDI_RESOURCECOPY);
    DDISETPFN( SetDDI_ResourceResolveSubresource, PFND3D10DDI_RESOURCERESOLVESUBRESOURCE);

	DDISETPFN( SetDDI_ResourceMap, PFND3D10DDI_RESOURCEMAP);
    DDISETPFN( SetDDI_ResourceUnmap, PFND3D10DDI_RESOURCEUNMAP);
	DDISETPFN( SetDDI_ResourceIsStagingBusy, PFND3D10DDI_RESOURCEISSTAGINGBUSY);

	DDISETPFN( SetDDI_RelocateDeviceFuncs10_1, PFND3D10_1DDI_RELOCATEDEVICEFUNCS);
	DDISETPFN( SetDDI_RelocateDeviceFuncs10, PFND3D10DDI_RELOCATEDEVICEFUNCS);

	DDISETPFN( SetDDI_CalcPrivateResourceSize, PFND3D10DDI_CALCPRIVATERESOURCESIZE);
    DDISETPFN( SetDDI_CalcPrivateOpenedResourceSize, PFND3D10DDI_CALCPRIVATEOPENEDRESOURCESIZE); 
	DDISETPFN( SetDDI_CreateResource, PFND3D10DDI_CREATERESOURCE );
    DDISETPFN( SetDDI_OpenResource, PFND3D10DDI_OPENRESOURCE);
	DDISETPFN( SetDDI_DestroyResource, PFND3D10DDI_DESTROYRESOURCE);
	DDISETPFN( SetDDI_CalcPrivateShaderResourceViewSize10, PFND3D10DDI_CALCPRIVATESHADERRESOURCEVIEWSIZE);
	DDISETPFN( SetDDI_CalcPrivateShaderResourceViewSize10_1, PFND3D10_1DDI_CALCPRIVATESHADERRESOURCEVIEWSIZE);
	DDISETPFN( SetDDI_CreateShaderResourceView10, PFND3D10DDI_CREATESHADERRESOURCEVIEW); // Check this one
	DDISETPFN( SetDDI_CreateShaderResourceView10_1, PFND3D10_1DDI_CREATESHADERRESOURCEVIEW); // Check this one
    DDISETPFN( SetDDI_DestroyShaderResourceView, PFND3D10DDI_DESTROYSHADERRESOURCEVIEW);
    DDISETPFN( SetDDI_CalcPrivateRenderTargetViewSize, PFND3D10DDI_CALCPRIVATERENDERTARGETVIEWSIZE);
	DDISETPFN( SetDDI_CreateRenderTargetView, PFND3D10DDI_CREATERENDERTARGETVIEW);
	DDISETPFN( SetDDI_DestroyRenderTargetView, PFND3D10DDI_DESTROYRENDERTARGETVIEW);
	DDISETPFN( SetDDI_CalcPrivateDepthStencilViewSize, PFND3D10DDI_CALCPRIVATEDEPTHSTENCILVIEWSIZE);
	DDISETPFN( SetDDI_CreateDepthStencilView, PFND3D10DDI_CREATEDEPTHSTENCILVIEW);
	DDISETPFN( SetDDI_DestroyDepthStencilView, PFND3D10DDI_DESTROYDEPTHSTENCILVIEW);
	DDISETPFN( SetDDI_CalcPrivateElementLayoutSize, PFND3D10DDI_CALCPRIVATEELEMENTLAYOUTSIZE);
    DDISETPFN( SetDDI_CreateElementLayout, PFND3D10DDI_CREATEELEMENTLAYOUT);
    DDISETPFN( SetDDI_DestroyElementLayout, PFND3D10DDI_DESTROYELEMENTLAYOUT);
    DDISETPFN( SetDDI_CalcPrivateBlendStateSize10, PFND3D10DDI_CALCPRIVATEBLENDSTATESIZE);
	DDISETPFN( SetDDI_CalcPrivateBlendStateSize10_1, PFND3D10_1DDI_CALCPRIVATEBLENDSTATESIZE);
    DDISETPFN( SetDDI_CreateBlendState10, PFND3D10DDI_CREATEBLENDSTATE);
	DDISETPFN( SetDDI_CreateBlendState10_1, PFND3D10_1DDI_CREATEBLENDSTATE);
    DDISETPFN( SetDDI_DestroyBlendState, PFND3D10DDI_DESTROYBLENDSTATE);
    DDISETPFN( SetDDI_CalcPrivateDepthStencilStateSize, PFND3D10DDI_CALCPRIVATEDEPTHSTENCILSTATESIZE);
    DDISETPFN( SetDDI_CreateDepthStencilState, PFND3D10DDI_CREATEDEPTHSTENCILSTATE);
    DDISETPFN( SetDDI_DestroyDepthStencilState, PFND3D10DDI_DESTROYDEPTHSTENCILSTATE);
    DDISETPFN( SetDDI_CalcPrivateRasterizerStateSize, PFND3D10DDI_CALCPRIVATERASTERIZERSTATESIZE);
    DDISETPFN( SetDDI_CreateRasterizerState, PFND3D10DDI_CREATERASTERIZERSTATE);
    DDISETPFN( SetDDI_DestroyRasterizerState, PFND3D10DDI_DESTROYRASTERIZERSTATE);
    DDISETPFN( SetDDI_CalcPrivateShaderSize, PFND3D10DDI_CALCPRIVATESHADERSIZE);
    DDISETPFN( SetDDI_CreateVertexShader, PFND3D10DDI_CREATEVERTEXSHADER);
    DDISETPFN( SetDDI_CreateGeometryShader, PFND3D10DDI_CREATEGEOMETRYSHADER);
    DDISETPFN( SetDDI_CreatePixelShader, PFND3D10DDI_CREATEPIXELSHADER);
    DDISETPFN( SetDDI_CalcPrivateGeometryShaderWithStreamOutputSize, PFND3D10DDI_CALCPRIVATEGEOMETRYSHADERWITHSTREAMOUTPUT);
    DDISETPFN( SetDDI_CreateGeometryShaderWithStreamOutput, PFND3D10DDI_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT);
    DDISETPFN( SetDDI_DestroyShader, PFND3D10DDI_DESTROYSHADER);
    DDISETPFN( SetDDI_CalcPrivateSamplerSize, PFND3D10DDI_CALCPRIVATESAMPLERSIZE);
    DDISETPFN( SetDDI_CreateSampler, PFND3D10DDI_CREATESAMPLER);
    DDISETPFN( SetDDI_DestroySampler, PFND3D10DDI_DESTROYSAMPLER);
    DDISETPFN( SetDDI_CalcPrivateQuerySize, PFND3D10DDI_CALCPRIVATEQUERYSIZE);
    DDISETPFN( SetDDI_CreateQuery, PFND3D10DDI_CREATEQUERY);
    DDISETPFN( SetDDI_DestroyQuery, PFND3D10DDI_DESTROYQUERY);

    DDISETPFN( SetDDI_CheckFormatSupport, PFND3D10DDI_CHECKFORMATSUPPORT);
    DDISETPFN( SetDDI_CheckMultisampleQualityLevels, PFND3D10DDI_CHECKMULTISAMPLEQUALITYLEVELS);
    DDISETPFN( SetDDI_CheckCounterInfo, PFND3D10DDI_CHECKCOUNTERINFO);
    DDISETPFN( SetDDI_CheckCounter, PFND3D10DDI_CHECKCOUNTER);

	DDISETPFN( SetDDI_DestroyDevice, PFND3D10DDI_DESTROYDEVICE);
    DDISETPFN( SetDDI_SetTextFilter, PFND3D10DDI_SETTEXTFILTERSIZE);

#if !defined( REF10_LDK_BUILD )
#ifdef D3D10PSGP
	DDISETPFN( SetDDI_IaResetPrimitiveID, PFND3D10DDI_RESETPRIMITIVEID);
	DDISETPFN( SetDDI_IaSetVertexPipelineOutput, PFND3D10DDI_SETVERTEXPIPELINEOUTPUT);
#endif
#endif

private:
	template <typename _T> _T SetDDIHelper(_T callBackFn, _T* pfn10, _T* pfn10_1);

	PD_GET_DEVICE_DLL_FP PD_GetDeviceDLL;
	PD_GET_DEVICE_VERSION_FP PD_GetDeviceVersion;

	HMODULE			m_hD3D10ProxyDLL;	// This is the handle to the proxy driver dll
	PROXY_SETUP		m_proxySetup;
	UINT			m_deviceVersion;
	char			m_dllName[STRLENGTH];

	D3D10_1DDI_DEVICEFUNCS* m_pD3D10_1DDI_DEVFUNCS;
	D3D10DDI_DEVICEFUNCS*	m_pD3D10DDI_DEVFUNCS;
};
