/*++

Copyright (c) 2011  Microsoft Corporation

Module Name:

    syminfo.c

--*/

#include "common.h"


#define DECLARE_TYPE(Name) Name _DECL_##Name

//
// typedefs usb.h should have included
//
typedef struct _URB_HEADER
URB_HEADER, *PURB_HEADER;

typedef struct _URB_SELECT_INTERFACE
URB_SELECT_INTERFACE, *PURB_SELECT_INTERFACE;

typedef struct _URB_SELECT_CONFIGURATION
URB_SELECT_CONFIGURATION, *PURB_SELECT_CONFIGURATION;

typedef struct _URB_GET_CURRENT_FRAME_NUMBER
URB_GET_CURRENT_FRAME_NUMBER, *PURB_GET_CURRENT_FRAME_NUMBER;

typedef struct _URB_BULK_OR_INTERRUPT_TRANSFER 
URB_BULK_OR_INTERRUPT_TRANSFER, *PURB_BULK_OR_INTERRUPT_TRANSFER;

typedef struct _URB_CONTROL_DESCRIPTOR_REQUEST
URB_CONTROL_DESCRIPTOR_REQUEST, *PURB_CONTROL_DESCRIPTOR_REQUEST;

typedef struct _URB_CONTROL_GET_STATUS_REQUEST
URB_CONTROL_GET_STATUS_REQUEST, *PURB_CONTROL_GET_STATUS_REQUEST;

typedef struct _URB_CONTROL_VENDOR_OR_CLASS_REQUEST
URB_CONTROL_VENDOR_OR_CLASS_REQUEST, *PURB_CONTROL_VENDOR_OR_CLASS_REQUEST;

typedef struct _URB_OS_FEATURE_DESCRIPTOR_REQUEST 
URB_OS_FEATURE_DESCRIPTOR_REQUEST, *PURB_OS_FEATURE_DESCRIPTOR_REQUEST;

typedef struct _URB_PIPE_REQUEST 
URB_PIPE_REQUEST, *PURB_PIPE_REQUEST;

typedef struct _URB_CONTROL_TRANSFER
URB_CONTROL_TRANSFER, *PURB_CONTROL_TRANSFER;

typedef struct _URB_CONTROL_TRANSFER_EX
URB_CONTROL_TRANSFER_EX, *PURB_CONTROL_TRANSFER_EX;

typedef struct _URB_CONTROL_GET_CONFIGURATION_REQUEST
URB_CONTROL_GET_CONFIGURATION_REQUEST, *PURB_CONTROL_GET_CONFIGURATION_REQUEST;

typedef struct _URB_CONTROL_FEATURE_REQUEST
URB_CONTROL_FEATURE_REQUEST, *PURB_CONTROL_FEATURE_REQUEST;

typedef struct _URB_CONTROL_GET_INTERFACE_REQUEST
URB_CONTROL_GET_INTERFACE_REQUEST, *PURB_CONTROL_GET_INTERFACE_REQUEST;

typedef struct _URB_ISOCH_TRANSFER
URB_ISOCH_TRANSFER, *PURB_ISOCH_TRANSFER;


//
// Keep the following list sorted
//
DECLARE_TYPE (BUS_CONTEXT);
DECLARE_TYPE (DEBUG_LOG);
DECLARE_TYPE (DEVH_REF_OBJ);
DECLARE_TYPE (DEVICE_CAPABILITIES);
DECLARE_TYPE (DEVICE_EXTENSION);
DECLARE_TYPE (DEVICE_OBJECT);
DECLARE_TYPE (DM_TIMER_FLAGS);
DECLARE_TYPE (DRIVER_OBJECT);
DECLARE_TYPE (ENDPOINT_PARAMETERS);
DECLARE_TYPE (FDO_EXTENSION);
DECLARE_TYPE (FDO_FLAGS);
DECLARE_TYPE (frame_rec);
DECLARE_TYPE (HC);
DECLARE_TYPE (HCD_ENDPOINT);
DECLARE_TYPE (HCD_TRANSFER_CONTEXT);
DECLARE_TYPE (microframe_rec);
DECLARE_TYPE (MINIPORT_ISO_PACKET);
DECLARE_TYPE (MINIPORT_ISO_TRANSFER);
DECLARE_TYPE (PDO_EXTENSION);
DECLARE_TYPE (POWER_FLAGS);
DECLARE_TYPE (SCATTER_GATHER_ENTRY);
DECLARE_TYPE (TRANSACTION_TRANSLATOR);
DECLARE_TYPE (TRANSFER_PARAMETERS);
DECLARE_TYPE (TRANSFER_SG_ENTRY);
DECLARE_TYPE (TRANSFER_SG_LIST);
DECLARE_TYPE (TT);
DECLARE_TYPE (TT_REF_OBJ);
DECLARE_TYPE (UNICODE_STRING);
DECLARE_TYPE (URB_BULK_OR_INTERRUPT_TRANSFER);
DECLARE_TYPE (URB_CONTROL_DESCRIPTOR_REQUEST);
DECLARE_TYPE (URB_CONTROL_FEATURE_REQUEST);
DECLARE_TYPE (URB_CONTROL_GET_CONFIGURATION_REQUEST);
DECLARE_TYPE (URB_CONTROL_GET_INTERFACE_REQUEST);
DECLARE_TYPE (URB_CONTROL_GET_STATUS_REQUEST);
DECLARE_TYPE (URB_CONTROL_TRANSFER_EX);
DECLARE_TYPE (URB_CONTROL_VENDOR_OR_CLASS_REQUEST);
DECLARE_TYPE (URB_HEADER);
DECLARE_TYPE (URB_ISOCH_TRANSFER);
DECLARE_TYPE (URB_OS_FEATURE_DESCRIPTOR_REQUEST);
DECLARE_TYPE (URB_PIPE_REQUEST);
DECLARE_TYPE (URB_SELECT_CONFIGURATION);
DECLARE_TYPE (URB_SELECT_INTERFACE);
DECLARE_TYPE (USB_ABORT_PIPE_CONTEXT);
DECLARE_TYPE (USB_IOREQUEST_CONTEXT);
DECLARE_TYPE (USB2_EP);
DECLARE_TYPE (USB2LIB_ENDPOINT_CONTEXT);
DECLARE_TYPE (USB2LIB_HC_CONTEXT);
DECLARE_TYPE (USBD_CONFIG_HANDLE);
DECLARE_TYPE (USBD_DEVICE_HANDLE);
DECLARE_TYPE (USBD_INTERFACE_HANDLE_I);
DECLARE_TYPE (USBD_PIPE_HANDLE_I);
DECLARE_TYPE (USBOBJ_REF);
DECLARE_TYPE (USBPORT_COMMON_BUFFER);
DECLARE_TYPE (USBPORT_MINIPORT_DRIVER);
DECLARE_TYPE (USBPORT_REG_CACHE_ENTRY);
DECLARE_TYPE (USBPORT_REGISTRATION_PACKET);
DECLARE_TYPE (XDPC_CONTEXT);


//
// Make it build
//

int __cdecl main() {
    return 0;
}