#ifndef D3DLIGHTCAPS_PARALLELPOINT
	#define D3DLIGHTCAPS_PARALLELPOINT      0x00000008L /* Parallel point lights supported */
#endif

#ifndef D3DDEVCAPS_HWVERTEXBUFFER
	#define D3DDEVCAPS_HWVERTEXBUFFER       0x02000000L
#endif

#ifndef D3DDEVCAPS_HWINDEXBUFFER
	#define D3DDEVCAPS_HWINDEXBUFFER        0x04000000L
#endif

#ifndef D3DDEVCAPS_SUBVOLUMELOCK
	#define D3DDEVCAPS_SUBVOLUMELOCK           0x08000000L
#endif

#ifndef D3DPMISCCAPS_FOGINFVF
	#define D3DPMISCCAPS_FOGINFVF           0x00002000L
#endif

//-------------------------------------------------------------------------------------------------------------------------------------------------------------
//	Version match masks -
//		They include every flag the must not be set for that version
//-------------------------------------------------------------------------------------------------------------------------------------------------------------
#define VM_DX8_CAPS2MASK			( D3DCAPS2_CANAUTOGENMIPMAP | D3DCAPS2_CANSHARERESOURCE )
#define VM_DX8_CAPS3MASK			( D3DCAPS3_LINEAR_TO_SRGB_PRESENTATION | D3DCAPS3_COPY_TO_VIDMEM | D3DCAPS3_COPY_TO_SYSTEMMEM ) //| D3DCAPS3_MANAGEDDEVICE )
#define VM_DX8_DESTBLENDMASK		( D3DPBLENDCAPS_BLENDFACTOR | D3DPBLENDCAPS_SRCCOLOR2 | D3DPBLENDCAPS_INVSRCCOLOR2 )
//#define VM_DX8_DEVMASK				( D3DDEVCAPS_HWVERTEXBUFFER | D3DDEVCAPS_HWINDEXBUFFER | D3DDEVCAPS_SUBVOLUMELOCK | D3DDEVCAPS_USERMODEDRIVER )
#define VM_DX8_MISCPRIMMASK			( D3DPMISCCAPS_INDEPENDENTWRITEMASKS | D3DPMISCCAPS_PERSTAGECONSTANT | D3DPMISCCAPS_FOGANDSPECULARALPHA | D3DPMISCCAPS_SEPARATEALPHABLEND | D3DPMISCCAPS_MRTINDEPENDENTBITDEPTHS | D3DPMISCCAPS_MRTPOSTPIXELSHADERBLENDING | D3DPMISCCAPS_FOGVERTEXCLAMPED | D3DPMISCCAPS_POSTBLENDSRGBCONVERT ) //| D3DPMISCCAPS_FOGINFVF )
#define VM_DX8_LINEMASK				( D3DLINECAPS_ANTIALIAS )
#define VM_DX8_RASTERMASK			( D3DPRASTERCAPS_SCISSORTEST | D3DPRASTERCAPS_SLOPESCALEDEPTHBIAS | D3DPRASTERCAPS_DEPTHBIAS | D3DPRASTERCAPS_MULTISAMPLE_TOGGLE )
#define VM_DX8_TEXTUREMASK			( D3DPTEXTURECAPS_NOPROJECTEDBUMPENV )
#define VM_DX8_TEXTUREFILTERMASK	( D3DPTFILTERCAPS_MINFPYRAMIDALQUAD | D3DPTFILTERCAPS_MINFGAUSSIANQUAD | D3DPTFILTERCAPS_CONVOLUTIONMONO )
#define VM_DX8_STENCILMASK			( D3DSTENCILCAPS_TWOSIDED )
#define VM_DX8_VERTEXPROCESSMASK	( D3DVTXPCAPS_TEXGEN_SPHEREMAP | D3DVTXPCAPS_NO_TEXGEN_NONLOCALVIEWER )

#define VM_DX7_DESTBLENDMASK		VM_DX8_DESTBLENDMASK
//#define VM_DX7_DEVMASK				( VM_DX8_DEVMASK | ( D3DDEVCAPS_PUREDEVICE | D3DDEVCAPS_QUINTICRTPATCHES | D3DDEVCAPS_RTPATCHES | D3DDEVCAPS_RTPATCHHANDLEZERO | D3DDEVCAPS_NPATCHES ) )
#define VM_DX7_DEVMASK				( D3DDEVCAPS_PUREDEVICE | D3DDEVCAPS_QUINTICRTPATCHES | D3DDEVCAPS_RTPATCHES | D3DDEVCAPS_RTPATCHHANDLEZERO | D3DDEVCAPS_NPATCHES )
#define VM_DX7_MISCPRIMMASK			( VM_DX8_MISCPRIMMASK | ( D3DPMISCCAPS_COLORWRITEENABLE | D3DPMISCCAPS_CLIPPLANESCALEDPOINTS | D3DPMISCCAPS_CLIPTLVERTS | D3DPMISCCAPS_TSSARGTEMP | D3DPMISCCAPS_BLENDOP | D3DPMISCCAPS_NULLREFERENCE ) )
#define VM_DX7_RASTERMASK			( VM_DX8_RASTERMASK | ( D3DPRASTERCAPS_COLORPERSPECTIVE | D3DPRASTERCAPS_STRETCHBLTMULTISAMPLE ) )
#define VM_DX7_DESTBLENDMASK		VM_DX8_DESTBLENDMASK
#define VM_DX7_TEXTUREMASK			( VM_DX8_TEXTUREMASK | ( D3DPTEXTURECAPS_VOLUMEMAP | D3DPTEXTURECAPS_MIPMAP | D3DPTEXTURECAPS_MIPVOLUMEMAP | D3DPTEXTURECAPS_MIPCUBEMAP | D3DPTEXTURECAPS_CUBEMAP_POW2 | D3DPTEXTURECAPS_VOLUMEMAP_POW2 ) )
#define VM_DX7_TEXTUREFILTERMASK	( VM_DX8_TEXTUREFILTERMASK | ( D3DPTFILTERCAPS_MAGFPYRAMIDALQUAD | D3DPTFILTERCAPS_MAGFGAUSSIANQUAD ) )
#define VM_DX7_TEXTUREADDRESSMASK	( D3DPTADDRESSCAPS_MIRRORONCE )
#define VM_DX7_TEXTUREOPMASK		( D3DTEXOPCAPS_MULTIPLYADD | D3DTEXOPCAPS_LERP )
#define VM_DX7_STENCILMASK			VM_DX8_STENCILMASK
#define VM_DX7_FVFMASK				( D3DFVFCAPS_PSIZE )
#define VM_DX7_VERTEXPROCESSMASK	( VM_DX8_VERTEXPROCESSMASK | ( D3DVTXPCAPS_TWEENING | D3DVTXPCAPS_NO_VSDT_UBYTE4 ) )

#define VM_DX6_DESTBLENDMASK		VM_DX7_DESTBLENDMASK
#define VM_DX6_DEVMASK				( VM_DX7_DEVMASK | ( D3DDEVCAPS_HWTRANSFORMANDLIGHT | D3DDEVCAPS_CANBLTSYSTONONLOCAL | D3DDEVCAPS_HWRASTERIZATION ) )
#define VM_DX6_MISCPRIMMASK			VM_DX7_MISCPRIMMASK
#define VM_DX6_RASTERMASK			VM_DX7_RASTERMASK
#define VM_DX6_DESTBLENDMASK		VM_DX7_DESTBLENDMASK
#define VM_DX6_TEXTUREMASK			( VM_DX7_TEXTUREMASK | ( D3DPTEXTURECAPS_PROJECTED | D3DPTEXTURECAPS_CUBEMAP | D3DPTEXTURECAPS_COLORKEYBLEND ) )
#define VM_DX6_TEXTUREFILTERMASK	VM_DX7_TEXTUREFILTERMASK
#define VM_DX6_TEXTUREADDRESSMASK	VM_DX7_TEXTUREADDRESSMASK
#define VM_DX6_TEXTUREOPMASK		VM_DX7_TEXTUREOPMASK
#define VM_DX6_STENCILMASK			VM_DX7_STENCILMASK
#define VM_DX6_FVFMASK				VM_DX7_FVFMASK

//-------------------------------------------------------------------------------------------------------------------------------------------------------------
//	Consistency masks -
//		They include every flag that is permissable for that version.
//		This includes the flags above, to prevent double display of a failure, and then a warning.
//-------------------------------------------------------------------------------------------------------------------------------------------------------------
#define C_DX9_VSHADERCAPSMASK		( 0xFFFFFFFF ^ D3DVS20CAPS_PREDICATION )

#define C_DX9_PSHADERCAPSMASK		( 0xFFFFFFFF ^ ( D3DPS20CAPS_ARBITRARYSWIZZLE | D3DPS20CAPS_GRADIENTINSTRUCTIONS | D3DPS20CAPS_PREDICATION | D3DPS20CAPS_NODEPENDENTREADLIMIT | D3DPS20CAPS_NOTEXINSTRUCTIONLIMIT ) )

#define C_DX9_CAPSMASK				C_DX8_CAPSMASK
#define C_DX8_CAPSMASK				( 0xFFFFFFFF ^ D3DCAPS_READ_SCANLINE )

#define C_DX91_CAPS2MASK			( 0xFFFFFFFF ^ ( D3DCAPS2_FULLSCREENGAMMA | D3DCAPS2_CANCALIBRATEGAMMA | D3DCAPS2_CANMANAGERESOURCE | D3DCAPS2_DYNAMICTEXTURES | D3DCAPS2_CANAUTOGENMIPMAP | D3DCAPS2_CANSHARERESOURCE ) )
#define C_DX9_CAPS2MASK				( 0xFFFFFFFF ^ ( D3DCAPS2_FULLSCREENGAMMA | D3DCAPS2_CANCALIBRATEGAMMA | D3DCAPS2_CANMANAGERESOURCE | D3DCAPS2_DYNAMICTEXTURES | D3DCAPS2_CANAUTOGENMIPMAP ) )
#define C_DX8_CAPS2MASK				( 0xFFFFFFFF ^ ( ( D3DCAPS2_NO2DDURING3DSCENE | D3DCAPS2_FULLSCREENGAMMA | D3DCAPS2_CANRENDERWINDOWED | D3DCAPS2_CANCALIBRATEGAMMA | D3DCAPS2_CANMANAGERESOURCE | D3DCAPS2_DYNAMICTEXTURES ) | VM_DX8_CAPS2MASK ) ) //Include versionmatch values to prevent additional warnings

#define C_DX9_CAPS3MASK				( 0xFFFFFFFF ^ ( D3DCAPS3_ALPHA_FULLSCREEN_FLIP_OR_DISCARD | D3DCAPS3_LINEAR_TO_SRGB_PRESENTATION | D3DCAPS3_COPY_TO_VIDMEM | D3DCAPS3_COPY_TO_SYSTEMMEM ) )
#define C_DX8_CAPS3MASK				( 0xFFFFFFFF ^ ( ( D3DCAPS3_ALPHA_FULLSCREEN_FLIP_OR_DISCARD ) | VM_DX8_CAPS3MASK ) ) //Include versionmatch values to prevent additional warnings

#define C_DX9_PRESENTMASK			C_DX8_PRESENTMASK
#define C_DX8_PRESENTMASK			( 0xFFFFFFFF ^ ( D3DPRESENT_INTERVAL_DEFAULT | D3DPRESENT_INTERVAL_ONE | D3DPRESENT_INTERVAL_TWO | D3DPRESENT_INTERVAL_THREE | D3DPRESENT_INTERVAL_FOUR | D3DPRESENT_INTERVAL_IMMEDIATE ) )

#define C_DX9_CURSORMASK			C_DX8_CURSORMASK
#define C_DX8_CURSORMASK			( 0xFFFFFFFF ^ ( D3DCURSORCAPS_COLOR | D3DCURSORCAPS_LOWRES ) )

#define C_DX9_DEVMASK				C_DX8_DEVMASK
#define C_DX8_DEVMASK				( 0xFFFFFFFF ^ ( D3DDEVCAPS_EXECUTESYSTEMMEMORY | D3DDEVCAPS_EXECUTEVIDEOMEMORY | D3DDEVCAPS_TLVERTEXSYSTEMMEMORY | D3DDEVCAPS_TLVERTEXVIDEOMEMORY | D3DDEVCAPS_TEXTURESYSTEMMEMORY | D3DDEVCAPS_TEXTUREVIDEOMEMORY | D3DDEVCAPS_DRAWPRIMTLVERTEX | D3DDEVCAPS_CANRENDERAFTERFLIP | D3DDEVCAPS_TEXTURENONLOCALVIDMEM | D3DDEVCAPS_DRAWPRIMITIVES2 | D3DDEVCAPS_SEPARATETEXTUREMEMORIES | D3DDEVCAPS_DRAWPRIMITIVES2EX | D3DDEVCAPS_HWTRANSFORMANDLIGHT | D3DDEVCAPS_CANBLTSYSTONONLOCAL | D3DDEVCAPS_HWRASTERIZATION | D3DDEVCAPS_PUREDEVICE | D3DDEVCAPS_QUINTICRTPATCHES | D3DDEVCAPS_RTPATCHES | D3DDEVCAPS_RTPATCHHANDLEZERO | D3DDEVCAPS_NPATCHES ) )
#define C_DX7_DEVMASK				( 0xFFFFFFFF ^ ( ( D3DDEVCAPS_FLOATTLVERTEX | D3DDEVCAPS_SORTINCREASINGZ | D3DDEVCAPS_SORTDECREASINGZ | D3DDEVCAPS_SORTEXACT | D3DDEVCAPS_EXECUTESYSTEMMEMORY | D3DDEVCAPS_EXECUTEVIDEOMEMORY | D3DDEVCAPS_TLVERTEXSYSTEMMEMORY | D3DDEVCAPS_TLVERTEXVIDEOMEMORY | D3DDEVCAPS_TEXTURESYSTEMMEMORY | D3DDEVCAPS_TEXTUREVIDEOMEMORY | D3DDEVCAPS_DRAWPRIMTLVERTEX | D3DDEVCAPS_CANRENDERAFTERFLIP | D3DDEVCAPS_TEXTURENONLOCALVIDMEM | D3DDEVCAPS_DRAWPRIMITIVES2 | D3DDEVCAPS_SEPARATETEXTUREMEMORIES | D3DDEVCAPS_DRAWPRIMITIVES2EX | D3DDEVCAPS_HWTRANSFORMANDLIGHT | D3DDEVCAPS_CANBLTSYSTONONLOCAL | D3DDEVCAPS_HWRASTERIZATION ) | VM_DX7_DEVMASK ) ) //include versionmatch values to prevent additional warnings
#define C_DX6_DEVMASK				( 0xFFFFFFFF ^ ( ( D3DDEVCAPS_FLOATTLVERTEX | D3DDEVCAPS_SORTINCREASINGZ | D3DDEVCAPS_SORTDECREASINGZ | D3DDEVCAPS_SORTEXACT | D3DDEVCAPS_EXECUTESYSTEMMEMORY | D3DDEVCAPS_EXECUTEVIDEOMEMORY | D3DDEVCAPS_TLVERTEXSYSTEMMEMORY | D3DDEVCAPS_TLVERTEXVIDEOMEMORY | D3DDEVCAPS_TEXTURESYSTEMMEMORY | D3DDEVCAPS_TEXTUREVIDEOMEMORY | D3DDEVCAPS_DRAWPRIMTLVERTEX | D3DDEVCAPS_CANRENDERAFTERFLIP | D3DDEVCAPS_TEXTURENONLOCALVIDMEM | D3DDEVCAPS_DRAWPRIMITIVES2 | D3DDEVCAPS_SEPARATETEXTUREMEMORIES | D3DDEVCAPS_DRAWPRIMITIVES2EX ) | VM_DX6_DEVMASK ) ) //include versionmatch values to prevent additional warnings

#define C_DX9_MISCPRIMMASK			( 0xFFFFFFFF ^ ( D3DPMISCCAPS_MASKZ | D3DPMISCCAPS_CULLNONE | D3DPMISCCAPS_CULLCW | D3DPMISCCAPS_CULLCCW | D3DPMISCCAPS_COLORWRITEENABLE | D3DPMISCCAPS_CLIPPLANESCALEDPOINTS | D3DPMISCCAPS_CLIPTLVERTS | D3DPMISCCAPS_TSSARGTEMP | D3DPMISCCAPS_BLENDOP | D3DPMISCCAPS_NULLREFERENCE | D3DPMISCCAPS_INDEPENDENTWRITEMASKS | D3DPMISCCAPS_PERSTAGECONSTANT | D3DPMISCCAPS_FOGANDSPECULARALPHA | D3DPMISCCAPS_SEPARATEALPHABLEND | D3DPMISCCAPS_MRTINDEPENDENTBITDEPTHS | D3DPMISCCAPS_MRTPOSTPIXELSHADERBLENDING | D3DPMISCCAPS_FOGVERTEXCLAMPED | D3DPMISCCAPS_POSTBLENDSRGBCONVERT ) )
#define C_DX8_MISCPRIMMASK			( 0xFFFFFFFF ^ ( ( D3DPMISCCAPS_MASKZ | D3DPMISCCAPS_LINEPATTERNREP | D3DPMISCCAPS_CULLNONE | D3DPMISCCAPS_CULLCW | D3DPMISCCAPS_CULLCCW | D3DPMISCCAPS_COLORWRITEENABLE | D3DPMISCCAPS_CLIPPLANESCALEDPOINTS | D3DPMISCCAPS_CLIPTLVERTS | D3DPMISCCAPS_TSSARGTEMP | D3DPMISCCAPS_BLENDOP | D3DPMISCCAPS_NULLREFERENCE ) | VM_DX8_MISCPRIMMASK ) ) //Include versionmatch values to prevent additional warnings
#define C_DX7_MISCPRIMMASK			( C_DX6_MISCPRIMMASK ) //include versionmatch values to prevent additional warnings
#define C_DX6_MISCPRIMMASK			( 0xFFFFFFFF ^ ( ( D3DPMISCCAPS_MASKPLANES | D3DPMISCCAPS_MASKZ | D3DPMISCCAPS_LINEPATTERNREP | D3DPMISCCAPS_CONFORMANT | D3DPMISCCAPS_CULLNONE | D3DPMISCCAPS_CULLCW | D3DPMISCCAPS_CULLCCW ) | VM_DX7_MISCPRIMMASK ) ) //Include versionmatch values to prevent additional warnings

#define C_DX9_LINEMASK				( 0xFFFFFFFF ^ ( D3DLINECAPS_TEXTURE | D3DLINECAPS_ZTEST | D3DLINECAPS_BLEND | D3DLINECAPS_ALPHACMP | D3DLINECAPS_FOG | D3DLINECAPS_ANTIALIAS ) )
#define C_DX8_LINEMASK				( 0xFFFFFFFF ^ ( ( D3DLINECAPS_TEXTURE | D3DLINECAPS_ZTEST | D3DLINECAPS_BLEND | D3DLINECAPS_ALPHACMP | D3DLINECAPS_FOG ) | VM_DX8_LINEMASK ) ) //include versionmatch values to prevent additional warnings

#define C_DX9_RASTERMASK			( 0xFFFFFFFF ^ ( D3DPRASTERCAPS_DITHER | D3DPRASTERCAPS_ZTEST | D3DPRASTERCAPS_FOGVERTEX | D3DPRASTERCAPS_FOGTABLE | D3DPRASTERCAPS_MIPMAPLODBIAS | D3DPRASTERCAPS_ZBUFFERLESSHSR | D3DPRASTERCAPS_FOGRANGE | D3DPRASTERCAPS_ANISOTROPY | D3DPRASTERCAPS_WBUFFER | D3DPRASTERCAPS_WFOG | D3DPRASTERCAPS_ZFOG | D3DPRASTERCAPS_COLORPERSPECTIVE | D3DPRASTERCAPS_SCISSORTEST | D3DPRASTERCAPS_SLOPESCALEDEPTHBIAS | D3DPRASTERCAPS_DEPTHBIAS | D3DPRASTERCAPS_MULTISAMPLE_TOGGLE ) )
#define C_DX8_RASTERMASK			( 0xFFFFFFFF ^ ( ( D3DPRASTERCAPS_DITHER | D3DPRASTERCAPS_PAT | D3DPRASTERCAPS_ZTEST | D3DPRASTERCAPS_FOGVERTEX | D3DPRASTERCAPS_FOGTABLE | D3DPRASTERCAPS_ANTIALIASEDGES | D3DPRASTERCAPS_MIPMAPLODBIAS | D3DPRASTERCAPS_ZBIAS | D3DPRASTERCAPS_ZBUFFERLESSHSR | D3DPRASTERCAPS_FOGRANGE | D3DPRASTERCAPS_ANISOTROPY | D3DPRASTERCAPS_WBUFFER | D3DPRASTERCAPS_WFOG | D3DPRASTERCAPS_ZFOG | D3DPRASTERCAPS_COLORPERSPECTIVE | D3DPRASTERCAPS_STRETCHBLTMULTISAMPLE ) | VM_DX8_RASTERMASK ) ) //Include versionmatch values to prevent additional warnings
#define C_DX7_RASTERMASK			( 0xFFFFFFFF ^ ( ( D3DPRASTERCAPS_DITHER | D3DPRASTERCAPS_ROP2 | D3DPRASTERCAPS_XOR | D3DPRASTERCAPS_PAT | D3DPRASTERCAPS_ZTEST | D3DPRASTERCAPS_SUBPIXEL | D3DPRASTERCAPS_SUBPIXELX | D3DPRASTERCAPS_FOGVERTEX | D3DPRASTERCAPS_FOGTABLE | D3DPRASTERCAPS_STIPPLE | D3DPRASTERCAPS_ANTIALIASSORTDEPENDENT | D3DPRASTERCAPS_ANTIALIASSORTINDEPENDENT | D3DPRASTERCAPS_ANTIALIASEDGES | D3DPRASTERCAPS_MIPMAPLODBIAS | D3DPRASTERCAPS_ZBIAS | D3DPRASTERCAPS_ZBUFFERLESSHSR | D3DPRASTERCAPS_FOGRANGE | D3DPRASTERCAPS_ANISOTROPY | D3DPRASTERCAPS_WBUFFER | D3DPRASTERCAPS_TRANSLUCENTSORTINDEPENDENT | D3DPRASTERCAPS_WFOG | D3DPRASTERCAPS_ZFOG ) | VM_DX7_RASTERMASK ) ) //include versionmatch values to prevent additional warnings
#define C_DX6_RASTERMASK			( 0xFFFFFFFF ^ ( ( D3DPRASTERCAPS_DITHER | D3DPRASTERCAPS_ROP2 | D3DPRASTERCAPS_XOR | D3DPRASTERCAPS_PAT | D3DPRASTERCAPS_ZTEST | D3DPRASTERCAPS_SUBPIXEL | D3DPRASTERCAPS_SUBPIXELX | D3DPRASTERCAPS_FOGVERTEX | D3DPRASTERCAPS_FOGTABLE | D3DPRASTERCAPS_STIPPLE | D3DPRASTERCAPS_ANTIALIASSORTDEPENDENT | D3DPRASTERCAPS_ANTIALIASSORTINDEPENDENT | D3DPRASTERCAPS_ANTIALIASEDGES | D3DPRASTERCAPS_MIPMAPLODBIAS | D3DPRASTERCAPS_ZBIAS | D3DPRASTERCAPS_ZBUFFERLESSHSR | D3DPRASTERCAPS_FOGRANGE | D3DPRASTERCAPS_ANISOTROPY ) | VM_DX6_RASTERMASK ) ) //include versionmatch values to prevent additional warnings

#define C_DX9_ALPHACMPMASK			C_DX6_ALPHACMPMASK
#define C_DX8_ALPHACMPMASK			C_DX6_ALPHACMPMASK
#define C_DX7_ALPHACMPMASK			C_DX6_ALPHACMPMASK
#define C_DX6_ALPHACMPMASK			( 0xFFFFFFFF ^ ( D3DPCMPCAPS_NEVER | D3DPCMPCAPS_LESS | D3DPCMPCAPS_EQUAL | D3DPCMPCAPS_LESSEQUAL | D3DPCMPCAPS_GREATER | D3DPCMPCAPS_NOTEQUAL | D3DPCMPCAPS_GREATEREQUAL | D3DPCMPCAPS_ALWAYS ) )

#define C_DX91_DESTBLENDMASK		( 0xFFFFFFFF ^ ( D3DPBLENDCAPS_ZERO | D3DPBLENDCAPS_ONE | D3DPBLENDCAPS_SRCCOLOR | D3DPBLENDCAPS_INVSRCCOLOR | D3DPBLENDCAPS_SRCALPHA | D3DPBLENDCAPS_INVSRCALPHA | D3DPBLENDCAPS_DESTALPHA | D3DPBLENDCAPS_INVDESTALPHA | D3DPBLENDCAPS_DESTCOLOR | D3DPBLENDCAPS_INVDESTCOLOR | D3DPBLENDCAPS_SRCALPHASAT | D3DPBLENDCAPS_BOTHSRCALPHA | D3DPBLENDCAPS_BOTHINVSRCALPHA | D3DPBLENDCAPS_BLENDFACTOR | D3DPBLENDCAPS_SRCCOLOR2 | D3DPBLENDCAPS_INVSRCCOLOR2 ) )
#define C_DX9_DESTBLENDMASK			( 0xFFFFFFFF ^ ( D3DPBLENDCAPS_ZERO | D3DPBLENDCAPS_ONE | D3DPBLENDCAPS_SRCCOLOR | D3DPBLENDCAPS_INVSRCCOLOR | D3DPBLENDCAPS_SRCALPHA | D3DPBLENDCAPS_INVSRCALPHA | D3DPBLENDCAPS_DESTALPHA | D3DPBLENDCAPS_INVDESTALPHA | D3DPBLENDCAPS_DESTCOLOR | D3DPBLENDCAPS_INVDESTCOLOR | D3DPBLENDCAPS_SRCALPHASAT | D3DPBLENDCAPS_BOTHSRCALPHA | D3DPBLENDCAPS_BOTHINVSRCALPHA | D3DPBLENDCAPS_BLENDFACTOR ) )
#define C_DX8_DESTBLENDMASK			( C_DX6_DESTBLENDMASK ) //Include versionmatch values to prevent additional warnings
#define C_DX7_DESTBLENDMASK			( C_DX6_DESTBLENDMASK ) //Include versionmatch values to prevent additional warnings
#define C_DX6_DESTBLENDMASK			( 0xFFFFFFFF ^ ( ( D3DPBLENDCAPS_ZERO | D3DPBLENDCAPS_ONE | D3DPBLENDCAPS_SRCCOLOR | D3DPBLENDCAPS_INVSRCCOLOR | D3DPBLENDCAPS_SRCALPHA | D3DPBLENDCAPS_INVSRCALPHA | D3DPBLENDCAPS_DESTALPHA | D3DPBLENDCAPS_INVDESTALPHA | D3DPBLENDCAPS_DESTCOLOR | D3DPBLENDCAPS_INVDESTCOLOR | D3DPBLENDCAPS_SRCALPHASAT | D3DPBLENDCAPS_BOTHSRCALPHA | D3DPBLENDCAPS_BOTHINVSRCALPHA ) | VM_DX8_DESTBLENDMASK ) ) //Include versionmatch values to prevent additional warnings

#define C_DX9_SHADEMASK				C_DX8_SHADEMASK
#define C_DX8_SHADEMASK				( 0xFFFFFFFF ^ ( D3DPSHADECAPS_COLORGOURAUDRGB | D3DPSHADECAPS_SPECULARGOURAUDRGB | D3DPSHADECAPS_ALPHAGOURAUDBLEND | D3DPSHADECAPS_FOGGOURAUD ) )
#define C_DX7_SHADEMASK				C_DX6_SHADEMASK
#define C_DX6_SHADEMASK				( 0xFFFFFFFF ^ ( D3DPSHADECAPS_COLORFLATMONO | D3DPSHADECAPS_COLORFLATRGB | D3DPSHADECAPS_COLORGOURAUDMONO | D3DPSHADECAPS_COLORGOURAUDRGB | D3DPSHADECAPS_COLORPHONGMONO | D3DPSHADECAPS_COLORPHONGRGB | D3DPSHADECAPS_SPECULARFLATMONO | D3DPSHADECAPS_SPECULARFLATRGB | D3DPSHADECAPS_SPECULARGOURAUDMONO | D3DPSHADECAPS_SPECULARGOURAUDRGB | D3DPSHADECAPS_SPECULARPHONGMONO | D3DPSHADECAPS_SPECULARPHONGRGB | D3DPSHADECAPS_ALPHAFLATBLEND | D3DPSHADECAPS_ALPHAFLATSTIPPLED | D3DPSHADECAPS_ALPHAGOURAUDBLEND | D3DPSHADECAPS_ALPHAGOURAUDSTIPPLED | D3DPSHADECAPS_ALPHAPHONGBLEND | D3DPSHADECAPS_ALPHAPHONGSTIPPLED | D3DPSHADECAPS_FOGFLAT | D3DPSHADECAPS_FOGGOURAUD | D3DPSHADECAPS_FOGPHONG ) )

#define C_DX9_TEXTUREMASK			( 0xFFFFFFFF ^ ( D3DPTEXTURECAPS_PERSPECTIVE | D3DPTEXTURECAPS_POW2 | D3DPTEXTURECAPS_ALPHA | D3DPTEXTURECAPS_SQUAREONLY | D3DPTEXTURECAPS_TEXREPEATNOTSCALEDBYSIZE | D3DPTEXTURECAPS_ALPHAPALETTE | D3DPTEXTURECAPS_NONPOW2CONDITIONAL | D3DPTEXTURECAPS_PROJECTED | D3DPTEXTURECAPS_CUBEMAP | D3DPTEXTURECAPS_VOLUMEMAP | D3DPTEXTURECAPS_MIPMAP | D3DPTEXTURECAPS_MIPVOLUMEMAP | D3DPTEXTURECAPS_MIPCUBEMAP | D3DPTEXTURECAPS_CUBEMAP_POW2 | D3DPTEXTURECAPS_VOLUMEMAP_POW2 | D3DPTEXTURECAPS_NOPROJECTEDBUMPENV ) )
#define C_DX8_TEXTUREMASK			( 0xFFFFFFFF ^ ( ( D3DPTEXTURECAPS_PERSPECTIVE | D3DPTEXTURECAPS_POW2 | D3DPTEXTURECAPS_ALPHA | D3DPTEXTURECAPS_SQUAREONLY | D3DPTEXTURECAPS_TEXREPEATNOTSCALEDBYSIZE | D3DPTEXTURECAPS_ALPHAPALETTE | D3DPTEXTURECAPS_NONPOW2CONDITIONAL | D3DPTEXTURECAPS_PROJECTED | D3DPTEXTURECAPS_CUBEMAP | D3DPTEXTURECAPS_VOLUMEMAP | D3DPTEXTURECAPS_MIPMAP | D3DPTEXTURECAPS_MIPVOLUMEMAP | D3DPTEXTURECAPS_MIPCUBEMAP | D3DPTEXTURECAPS_CUBEMAP_POW2 | D3DPTEXTURECAPS_VOLUMEMAP_POW2 ) | VM_DX8_TEXTUREMASK ) ) //include versionmatch values to prevent additional warnings
#define C_DX7_TEXTUREMASK			( 0xFFFFFFFF ^ ( ( D3DPTEXTURECAPS_PERSPECTIVE | D3DPTEXTURECAPS_POW2 | D3DPTEXTURECAPS_ALPHA | D3DPTEXTURECAPS_TRANSPARENCY | D3DPTEXTURECAPS_BORDER | D3DPTEXTURECAPS_SQUAREONLY | D3DPTEXTURECAPS_TEXREPEATNOTSCALEDBYSIZE | D3DPTEXTURECAPS_ALPHAPALETTE | D3DPTEXTURECAPS_NONPOW2CONDITIONAL | D3DPTEXTURECAPS_PROJECTED | D3DPTEXTURECAPS_CUBEMAP | D3DPTEXTURECAPS_COLORKEYBLEND ) | VM_DX7_TEXTUREMASK ) ) //include versionmatch values to prevent additional warnings
#define C_DX6_TEXTUREMASK			( 0xFFFFFFFF ^ ( ( D3DPTEXTURECAPS_PERSPECTIVE | D3DPTEXTURECAPS_POW2 | D3DPTEXTURECAPS_ALPHA | D3DPTEXTURECAPS_TRANSPARENCY | D3DPTEXTURECAPS_BORDER | D3DPTEXTURECAPS_SQUAREONLY | D3DPTEXTURECAPS_TEXREPEATNOTSCALEDBYSIZE | D3DPTEXTURECAPS_ALPHAPALETTE | D3DPTEXTURECAPS_NONPOW2CONDITIONAL ) | VM_DX6_TEXTUREMASK ) ) //include versionmatch values to prevent additional warnings )

#define C_DX91_TEXTUREFILTERMASK	( 0xFFFFFFFF ^ ( D3DPTFILTERCAPS_MINFPOINT | D3DPTFILTERCAPS_MINFLINEAR | D3DPTFILTERCAPS_MINFANISOTROPIC | D3DPTFILTERCAPS_MINFPYRAMIDALQUAD | D3DPTFILTERCAPS_MINFGAUSSIANQUAD | D3DPTFILTERCAPS_MIPFPOINT | D3DPTFILTERCAPS_MIPFLINEAR | D3DPTFILTERCAPS_MAGFPOINT | D3DPTFILTERCAPS_MAGFLINEAR | D3DPTFILTERCAPS_MAGFANISOTROPIC | D3DPTFILTERCAPS_MAGFPYRAMIDALQUAD | D3DPTFILTERCAPS_MAGFGAUSSIANQUAD | D3DPTFILTERCAPS_CONVOLUTIONMONO ) )
#define C_DX9_TEXTUREFILTERMASK		( 0xFFFFFFFF ^ ( D3DPTFILTERCAPS_MINFPOINT | D3DPTFILTERCAPS_MINFLINEAR | D3DPTFILTERCAPS_MINFANISOTROPIC | D3DPTFILTERCAPS_MINFPYRAMIDALQUAD | D3DPTFILTERCAPS_MINFGAUSSIANQUAD | D3DPTFILTERCAPS_MIPFPOINT | D3DPTFILTERCAPS_MIPFLINEAR | D3DPTFILTERCAPS_MAGFPOINT | D3DPTFILTERCAPS_MAGFLINEAR | D3DPTFILTERCAPS_MAGFANISOTROPIC | D3DPTFILTERCAPS_MAGFPYRAMIDALQUAD | D3DPTFILTERCAPS_MAGFGAUSSIANQUAD ) )
#define C_DX8_TEXTUREFILTERMASK		( 0xFFFFFFFF ^ ( ( D3DPTFILTERCAPS_MINFPOINT | D3DPTFILTERCAPS_MINFLINEAR | D3DPTFILTERCAPS_MINFANISOTROPIC | D3DPTFILTERCAPS_MIPFPOINT | D3DPTFILTERCAPS_MIPFLINEAR | D3DPTFILTERCAPS_MAGFPOINT | D3DPTFILTERCAPS_MAGFLINEAR | D3DPTFILTERCAPS_MAGFANISOTROPIC | D3DPTFILTERCAPS_MAGFAFLATCUBIC | D3DPTFILTERCAPS_MAGFGAUSSIANCUBIC ) | VM_DX8_TEXTUREFILTERMASK ) ) //include versionmatch values to prevent additional warnings
#define C_DX7_TEXTUREFILTERMASK		( C_DX6_TEXTUREFILTERMASK ) //include versionmatch values to prevent additional warnings
#define C_DX6_TEXTUREFILTERMASK		( 0xFFFFFFFF ^ ( ( D3DPTFILTERCAPS_NEAREST | D3DPTFILTERCAPS_LINEAR | D3DPTFILTERCAPS_MIPNEAREST | D3DPTFILTERCAPS_MIPLINEAR | D3DPTFILTERCAPS_LINEARMIPNEAREST | D3DPTFILTERCAPS_LINEARMIPLINEAR | D3DPTFILTERCAPS_MINFPOINT | D3DPTFILTERCAPS_MINFLINEAR | D3DPTFILTERCAPS_MINFANISOTROPIC | D3DPTFILTERCAPS_MIPFPOINT | D3DPTFILTERCAPS_MIPFLINEAR | D3DPTFILTERCAPS_MAGFPOINT | D3DPTFILTERCAPS_MAGFLINEAR | D3DPTFILTERCAPS_MAGFANISOTROPIC | D3DPTFILTERCAPS_MAGFAFLATCUBIC | D3DPTFILTERCAPS_MAGFGAUSSIANCUBIC ) | VM_DX8_TEXTUREFILTERMASK ) ) //include versionmatch values to prevent additional warnings

#define C_DX9_STRETCHFILTERMASK		( 0xFFFFFFFF ^ ( D3DPTFILTERCAPS_MINFPOINT | D3DPTFILTERCAPS_MINFLINEAR | D3DPTFILTERCAPS_MAGFPOINT | D3DPTFILTERCAPS_MAGFLINEAR ) )

#define C_DX7_TEXTUREBLENDMASK		C_DX6_TEXTUREBLENDMASK
#define C_DX6_TEXTUREBLENDMASK		( 0xFFFFFFFF ^ ( D3DPTBLENDCAPS_DECAL | D3DPTBLENDCAPS_MODULATE | D3DPTBLENDCAPS_DECALALPHA | D3DPTBLENDCAPS_MODULATEALPHA | D3DPTBLENDCAPS_DECALMASK | D3DPTBLENDCAPS_MODULATEMASK | D3DPTBLENDCAPS_COPY | D3DPTBLENDCAPS_ADD ) )

#define C_DX9_TEXTUREADDRESSMASK	C_DX8_TEXTUREADDRESSMASK
#define C_DX8_TEXTUREADDRESSMASK	( 0xFFFFFFFF ^ ( D3DPTADDRESSCAPS_WRAP | D3DPTADDRESSCAPS_MIRROR | D3DPTADDRESSCAPS_CLAMP | D3DPTADDRESSCAPS_BORDER | D3DPTADDRESSCAPS_INDEPENDENTUV | D3DPTADDRESSCAPS_MIRRORONCE ) )
#define C_DX7_TEXTUREADDRESSMASK	( C_DX6_TEXTUREADDRESSMASK ) //include versionmatch values to prevent additional warnings
#define C_DX6_TEXTUREADDRESSMASK	( 0xFFFFFFFF ^ ( ( D3DPTADDRESSCAPS_WRAP | D3DPTADDRESSCAPS_MIRROR | D3DPTADDRESSCAPS_CLAMP | D3DPTADDRESSCAPS_BORDER | D3DPTADDRESSCAPS_INDEPENDENTUV ) | VM_DX7_TEXTUREADDRESSMASK ) ) //include versionmatch values to prevent additional warnings

#define C_DX9_STENCILMASK			( 0xFFFFFFFF ^ ( D3DSTENCILCAPS_KEEP | D3DSTENCILCAPS_ZERO | D3DSTENCILCAPS_REPLACE | D3DSTENCILCAPS_INCRSAT | D3DSTENCILCAPS_DECRSAT | D3DSTENCILCAPS_INVERT | D3DSTENCILCAPS_INCR | D3DSTENCILCAPS_DECR | D3DSTENCILCAPS_TWOSIDED ) )
#define C_DX8_STENCILMASK			( C_DX6_STENCILMASK ) //include versionmatch values to prevent additional warnings
#define C_DX7_STENCILMASK			( C_DX6_STENCILMASK ) //include versionmatch values to prevent additional warnings
#define C_DX6_STENCILMASK			( 0xFFFFFFFF ^ ( ( D3DSTENCILCAPS_KEEP | D3DSTENCILCAPS_ZERO | D3DSTENCILCAPS_REPLACE | D3DSTENCILCAPS_INCRSAT | D3DSTENCILCAPS_DECRSAT | D3DSTENCILCAPS_INVERT | D3DSTENCILCAPS_INCR | D3DSTENCILCAPS_DECR ) | VM_DX8_STENCILMASK ) ) //include versionmatch values to prevent additional warnings

#define C_DX9_TEXTUREOPMASK			C_DX8_TEXTUREOPMASK
#define C_DX8_TEXTUREOPMASK			( 0xFFFFFFFF ^ ( D3DTEXOPCAPS_DISABLE | D3DTEXOPCAPS_SELECTARG1 | D3DTEXOPCAPS_SELECTARG2 | D3DTEXOPCAPS_MODULATE | D3DTEXOPCAPS_MODULATE2X | D3DTEXOPCAPS_MODULATE4X | D3DTEXOPCAPS_ADD | D3DTEXOPCAPS_ADDSIGNED | D3DTEXOPCAPS_ADDSIGNED2X | D3DTEXOPCAPS_SUBTRACT | D3DTEXOPCAPS_ADDSMOOTH | D3DTEXOPCAPS_BLENDDIFFUSEALPHA | D3DTEXOPCAPS_BLENDTEXTUREALPHA | D3DTEXOPCAPS_BLENDFACTORALPHA | D3DTEXOPCAPS_BLENDTEXTUREALPHAPM | D3DTEXOPCAPS_BLENDCURRENTALPHA | D3DTEXOPCAPS_PREMODULATE | D3DTEXOPCAPS_MODULATEALPHA_ADDCOLOR | D3DTEXOPCAPS_MODULATECOLOR_ADDALPHA | D3DTEXOPCAPS_MODULATEINVALPHA_ADDCOLOR | D3DTEXOPCAPS_MODULATEINVCOLOR_ADDALPHA | D3DTEXOPCAPS_BUMPENVMAP | D3DTEXOPCAPS_BUMPENVMAPLUMINANCE | D3DTEXOPCAPS_DOTPRODUCT3 | D3DTEXOPCAPS_MULTIPLYADD | D3DTEXOPCAPS_LERP ) )
#define C_DX7_TEXTUREOPMASK			( C_DX6_TEXTUREOPMASK ) //include versionmatch values to prevent additional warnings
#define C_DX6_TEXTUREOPMASK			( 0xFFFFFFFF ^ ( ( D3DTEXOPCAPS_DISABLE | D3DTEXOPCAPS_SELECTARG1 | D3DTEXOPCAPS_SELECTARG2 | D3DTEXOPCAPS_MODULATE | D3DTEXOPCAPS_MODULATE2X | D3DTEXOPCAPS_MODULATE4X | D3DTEXOPCAPS_ADD | D3DTEXOPCAPS_ADDSIGNED | D3DTEXOPCAPS_ADDSIGNED2X | D3DTEXOPCAPS_SUBTRACT | D3DTEXOPCAPS_ADDSMOOTH | D3DTEXOPCAPS_BLENDDIFFUSEALPHA | D3DTEXOPCAPS_BLENDTEXTUREALPHA | D3DTEXOPCAPS_BLENDFACTORALPHA | D3DTEXOPCAPS_BLENDTEXTUREALPHAPM | D3DTEXOPCAPS_BLENDCURRENTALPHA | D3DTEXOPCAPS_PREMODULATE | D3DTEXOPCAPS_MODULATEALPHA_ADDCOLOR | D3DTEXOPCAPS_MODULATECOLOR_ADDALPHA | D3DTEXOPCAPS_MODULATEINVALPHA_ADDCOLOR | D3DTEXOPCAPS_MODULATEINVCOLOR_ADDALPHA | D3DTEXOPCAPS_BUMPENVMAP | D3DTEXOPCAPS_BUMPENVMAPLUMINANCE | D3DTEXOPCAPS_DOTPRODUCT3 ) | VM_DX7_TEXTUREOPMASK ) ) //include versionmatch values to prevent additional warnings

#define C_DX9_FVFMASK				C_DX8_FVFMASK
#define C_DX8_FVFMASK				( 0xFFFFFFFF ^ ( D3DFVFCAPS_TEXCOORDCOUNTMASK | D3DFVFCAPS_DONOTSTRIPELEMENTS | D3DFVFCAPS_PSIZE ) )
#define C_DX7_FVFMASK				( C_DX6_FVFMASK ) //include versionmatch values to prevent additional warnings
#define C_DX6_FVFMASK				( 0xFFFFFFFF ^ ( ( D3DFVFCAPS_TEXCOORDCOUNTMASK | D3DFVFCAPS_DONOTSTRIPELEMENTS ) | VM_DX7_FVFMASK ) ) //include versionmatch values to prevent additional warnings

#define C_DX9_VERTEXPROCESSMASK		( 0xFFFFFFFF ^ ( D3DVTXPCAPS_TEXGEN | D3DVTXPCAPS_MATERIALSOURCE7 | D3DVTXPCAPS_DIRECTIONALLIGHTS | D3DVTXPCAPS_POSITIONALLIGHTS | D3DVTXPCAPS_LOCALVIEWER | D3DVTXPCAPS_TWEENING | D3DVTXPCAPS_TEXGEN_SPHEREMAP | D3DVTXPCAPS_NO_TEXGEN_NONLOCALVIEWER ) )
#define C_DX8_VERTEXPROCESSMASK		( 0xFFFFFFFF ^ ( ( D3DVTXPCAPS_TEXGEN | D3DVTXPCAPS_MATERIALSOURCE7 | D3DVTXPCAPS_DIRECTIONALLIGHTS | D3DVTXPCAPS_POSITIONALLIGHTS | D3DVTXPCAPS_LOCALVIEWER | D3DVTXPCAPS_TWEENING | D3DVTXPCAPS_NO_VSDT_UBYTE4 ) | VM_DX8_VERTEXPROCESSMASK ) ) //include versionmatch values to prevent additional failures
#define C_DX7_VERTEXPROCESSMASK		( 0xFFFFFFFF ^ ( ( D3DVTXPCAPS_TEXGEN | D3DVTXPCAPS_MATERIALSOURCE7 | D3DVTXPCAPS_VERTEXFOG | D3DVTXPCAPS_DIRECTIONALLIGHTS | D3DVTXPCAPS_POSITIONALLIGHTS | D3DVTXPCAPS_LOCALVIEWER ) | VM_DX7_VERTEXPROCESSMASK ) ) //include versionmatch values to prevent additional failures

#define C_DX9_DEV2MASK				( 0xFFFFFFFF ^ ( D3DDEVCAPS2_STREAMOFFSET | D3DDEVCAPS2_DMAPNPATCH | D3DDEVCAPS2_ADAPTIVETESSRTPATCH | D3DDEVCAPS2_ADAPTIVETESSNPATCH | D3DDEVCAPS2_CAN_STRETCHRECT_FROM_TEXTURES | D3DDEVCAPS2_PRESAMPLEDDMAPNPATCH | D3DDEVCAPS2_VERTEXELEMENTSCANSHARESTREAMOFFSET ) )

#define C_DX9_DECLTYPEMASK			( 0xFFFFFFFF ^ ( D3DDTCAPS_UBYTE4 | D3DDTCAPS_UBYTE4N | D3DDTCAPS_SHORT2N | D3DDTCAPS_SHORT4N | D3DDTCAPS_USHORT2N | D3DDTCAPS_USHORT4N | D3DDTCAPS_UDEC3 | D3DDTCAPS_DEC3N | D3DDTCAPS_FLOAT16_2 | D3DDTCAPS_FLOAT16_4 ) )

#define C_DX6_LIGHTMODELMASK		( 0xFFFFFFFF ^ ( D3DLIGHTINGMODEL_RGB | D3DLIGHTINGMODEL_MONO ) )
#define C_DX6_TRANSFORMMASK			( 0xFFFFFFFF ^ D3DTRANSFORMCAPS_CLIP )
#define C_DX6_COLORMODELMASK		( 0xFFFFFFFF ^ ( D3DCOLOR_MONO | D3DCOLOR_RGB ) )
#define C_DX6_FLAGMASK				( 0xFFFFFFFF ^ ( D3DDD_COLORMODEL | D3DDD_DEVCAPS | D3DDD_TRANSFORMCAPS | D3DDD_LIGHTINGCAPS | D3DDD_BCLIPPING | D3DDD_LINECAPS | D3DDD_TRICAPS | D3DDD_DEVICERENDERBITDEPTH | D3DDD_DEVICEZBUFFERBITDEPTH | D3DDD_MAXBUFFERSIZE | D3DDD_MAXVERTEXCOUNT ) )
#define C_DX6_LIGHTMASK				( 0xFFFFFFFF ^ ( D3DLIGHTCAPS_POINT | D3DLIGHTCAPS_SPOT | D3DLIGHTCAPS_DIRECTIONAL | D3DLIGHTCAPS_PARALLELPOINT ) )

#define C_DX7_BITDEPTH				C_DX6_BITDEPTH
#define C_DX6_BITDEPTH				( 0xFFFFFFFF ^ ( DDBD_8 | DDBD_16 | DDBD_24 | DDBD_32 ) )