#pragma once

#include <windows.h>
#include "WexTestClass.h"
#include "XMLConfig.h"
#include "MFTDiagTestDLLCommon.h"
#include "MFTDTaefBase.h"
#include "XMLConfig.h"

BEGIN_MODULE()
    MODULE_PROPERTY(L"Feature", L"WLKDecDXVA_HEVC_TAEF")
    MODULE_PROPERTY(L"ThreadingModel", L"MTA")
END_MODULE()

#pragma prefast(push)
#pragma prefast(disable:28718, "disabling warning for test code")

class CWLKDecDXVA_HEVC_TAEF : public WEX::TestClass<CWLKDecDXVA_HEVC_TAEF>, public CMFTDTaefBase
{
public:
    CWLKDecDXVA_HEVC_TAEF(void);
    ~CWLKDecDXVA_HEVC_TAEF(void);

    BEGIN_TEST_CLASS(CWLKDecDXVA_HEVC_TAEF)
    END_TEST_CLASS()

    TEST_CLASS_SETUP(InitializeTestClass)
    TEST_CLASS_CLEANUP(FinalizeTestClass)

    BEGIN_TEST_METHOD(HEVCPlaybackTest50)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"41536727-C037-4B4F-9227-634664D63840")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"e134ccca-96e0-4819-97bf-4da36c8e0266")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCPlaybackTest50")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC Playback test")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Motion_FastCam_Action_03_1920x1080p24f_lowlevel_main.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCPlaybackTest51)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"78305018-E01C-4A87-BBF7-45527C340E94")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"3a19767b-dc30-4fc3-9730-1a163c8a4eba")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCPlaybackTest51")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC Playback test")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Motion_FastCam_Action_03_1920x1080p24f_3834kbps_randomaccess_main.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCPlaybackTest52)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"5CECD6ED-DFEE-4F84-AB83-26005690A43D")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"3ffd86f7-17f9-409d-b8a4-291a18a43384")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCPlaybackTest52")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC Playback test")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Texture_High_01_320x240p30f_lowdelay_main.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCPlaybackTest53)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"B81745A1-7547-4C70-8063-535AB597ED97")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"81b756e8-e293-44bc-9240-81867046b3c8")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCPlaybackTest53")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC Playback test")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Texture_SkinTones_05_352x288p15f_intra_main.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCPlaybackTest54)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"C0479B40-565A-42A7-B546-F5AC075106DC")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"38193069-bdac-4011-b075-7ab224efe767")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCPlaybackTest54")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC Playback test")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Texture_SkinTones_05_352x288p15f_randomaccess_main.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCPlaybackTest55)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"FA601143-8C83-460C-A312-3903A75A0F66")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"570050a4-b990-41fe-a7e9-d02ddbedcd3d")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCPlaybackTest55")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC Playback test")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Texture_SkinTones_05_352x288p25f_lowdelay_P_main.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCPlaybackTest56)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"71EFD94C-B1E3-492A-8C86-5EF206858C35")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"067c4524-7369-4f83-9d6a-a22e184f9f02")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCPlaybackTest56")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC Playback test")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Texture_SkinTones_08_320x240p24f_lowdelay_P_main.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCPlaybackTest57)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"1F25AF52-46A3-4007-98C7-E5A510C4DF39")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"ea2ec717-0c56-4287-9ed0-294a8a6ff9d5")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCPlaybackTest57")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC Playback test")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Difficult_Edge_02_720x480i30f_intra_main.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCPlaybackTest58)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"25A0C7B1-6D0B-4708-8241-E974A906A04F")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"14b97854-5f38-4f74-a2b7-c847ca4c4599")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCPlaybackTest58")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC Playback test")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Difficult_Edge_02_720x480p30f_1739kbps_randomaccess_main.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCPlaybackTest59)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"0558AF45-6823-46E2-A9F6-57C266AE3655")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"d2b2d392-6291-4eaa-a054-061277fa9f46")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCPlaybackTest59")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC Playback test")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Difficult_Edge_06_720x576i25f_lowdelay_P_main.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCPlaybackTest60)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"8148D97C-6289-46A6-A8E6-801AE1EE281D")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"1ee98ee0-f857-4494-b5a1-0a3c81e96b26")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCPlaybackTest60")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC Playback test")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Difficult_Edge_06_720x576p25f_randomaccess_main.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCPlaybackTest61)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"7F04736C-C001-4373-A3A4-E28A5CFB4190")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"1dbeafa5-039c-46ef-9175-19fbdff9fdbf")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCPlaybackTest61")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC Playback test")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Motion_DifDirect_01_1280x720p24f_2983kbps_randomaccess_main.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCPlaybackTest62)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"449562E2-D722-4C9D-BD0C-BEB852A456C6")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"7352f325-275e-4dc1-ae0c-97b41a5d0b76")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCPlaybackTest62")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC Playback test")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Motion_FastCam_Action_03_1920x1080i30f_intra_main.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCPlaybackTest63)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"D9D60AAE-0530-41C0-ACDE-D4ABD7033E4C")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"231363b3-4323-40aa-b428-c15e378cfab8")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCPlaybackTest63")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC Playback test")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Motion_FastCam_Action_03_1920x1080i30f_lowdelay_P_main.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCPlaybackTest64)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"9297FEF2-07CF-4E5E-B34B-B0045043FC25")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"166e6566-a151-4190-8775-3ad6976914c6")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCPlaybackTest64")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC Playback test")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Motion_FastCam_Action_03_1920x1080p24f_intra_main.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCPlaybackTest65)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"C546E79B-B13A-4407-8F8D-A8563645AED2")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"f27c294f-8a85-44c1-8235-865ff8daa60b")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCPlaybackTest65")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC Playback test")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\modechange.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCFuzzTest120)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"109E4A16-E56C-45DD-A942-8EB8C3ACBACB")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"070dca7c-3aee-47d5-9e95-06c26a058e4a")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCFuzzTest120")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC Fuzz test")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Difficult_Edge_06_720x576i25f_intra_main_fuzzed.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCFuzzTest121)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"57AEBAF9-834A-4A4E-B95D-166463F7926A")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"b7a04b8d-4549-48fc-a004-5d3028abc0fe")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCFuzzTest121")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC Fuzz test")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Difficult_Edge_06_720x576p25f_lowdelay_main_fuzzed.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCFuzzTest122)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"44C5B101-A7EA-4482-A48B-737CAF9211E7")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"5f0a44ab-3f46-4dbd-88e1-b0d1c8e61d2c")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCFuzzTest122")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC Fuzz test")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Motion_FastCam_Action_03_1920x1080i30f_lowdelay_main_fuzzed.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCFuzzTest123)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"05D7D9DE-225A-4C34-A702-3925E675C544")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"de9f07a5-0530-4663-ac88-d335410fbaa6")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCFuzzTest123")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC Fuzz test")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Motion_FastCam_Action_03_1920x1080p24f_randomacess_fuzzed.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCFuzzTest124)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"F898B049-A3C1-4E89-8D15-196FA56EAF3A")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"a274d33b-7d7b-40f4-8da6-828cd596d782")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCFuzzTest124")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC Fuzz test")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Texture_High_01_320x240p30f_lowdelay_main_fuzzed.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCFuzzTest125)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"2F4F4BC8-D3D6-4BF0-907B-B814A5FC5726")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"d3b00dd3-75f2-41cc-beae-4a0437502323")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCFuzzTest125")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC Fuzz test")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Texture_SkinTones_08_320x240p24f_lowlevel_main_fuzzed.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCQualityTest230)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"C39B9743-9DD7-4EC8-B740-5321DF214A1F")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"8cd57118-e6d5-4ed7-9760-391069c8dea9")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCQualityTest230")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC VisualValidation (Quality) test")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Difficult_Edge_02_720x480i30f_lowdelay_main.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCQualityTest231)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"C3C1BF98-ED23-44AE-8A0A-2F9993028777")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"8b3cdb77-8519-443f-b856-7c13e483bfc5")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCQualityTest231")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC VisualValidation (Quality) test")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Difficult_Edge_02_720x480i30f_lowdelay_P_main.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCQualityTest232)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"DCC31981-EF39-4253-BB30-8B0EA338C6A2")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"596f6d25-52b9-47d4-ac5e-f352cdf48fd8")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCQualityTest232")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC VisualValidation (Quality) test")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Difficult_Edge_02_720x480p24f_lowdelay_P_main.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCQualityTest233)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"95DE71F1-24D1-4FED-B882-18FA6D1EFE43")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"622b32af-1b53-43e4-977f-0dcc14d7d213")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCQualityTest233")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC VisualValidation (Quality) test")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Difficult_Edge_02_720x480p30f_560kbps_randomaccess_main.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCQualityTest234)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"466736B3-2737-4FF6-8D3A-35C62D7AD04E")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"a7c7a4e2-6b7a-4d28-aee1-21974c7f4959")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCQualityTest234")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC VisualValidation (Quality) test")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Difficult_Edge_02_720x480p30f_intra_main.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCQualityTest235)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"EC102A5C-9896-4DE1-8558-779047CBCDB6")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"b3e6c16a-f526-422b-af60-57fc3e7eb6cf")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCQualityTest235")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC VisualValidation (Quality) test")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Difficult_Edge_02_720x480p30f_lowdelay_main.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCQualityTest236)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"DC9C1FEB-F2E4-4EED-B3DB-71141765B253")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"09ca506a-96ae-4951-a944-55997be4877f")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCQualityTest236")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC VisualValidation (Quality) test")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Difficult_Edge_02_720x480p30f_lowdelay_P_main.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCQualityTest237)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"98E4ED1A-7527-4840-9D59-F7EA8BE6525C")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"0a30e827-0489-4bf8-b5be-e1e498382110")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCQualityTest237")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC VisualValidation (Quality) test")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Difficult_Edge_02_720x480p30f_1047kbps_randomaccess_main.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCQualityTest238)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"2A1672F1-29F7-44EC-BA53-CC9BEB627156")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"97f64340-1bf2-4a14-93ed-b5a151eddf3f")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCQualityTest238")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC VisualValidation (Quality) test")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Difficult_Edge_06_720x576i25f_intra_main.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCQualityTest239)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"E4ACDBEB-9EE4-4C90-8901-EA2C17042665")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"8b709fc2-3b5c-44ba-989f-b1e4339ff34d")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCQualityTest239")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC VisualValidation (Quality) test")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Difficult_Edge_06_720x576i25f_randomaccess_main.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCQualityTest240)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"4AB47D41-482C-4AD6-82B4-7632AF30C1A6")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"d69c2fbc-b4f9-4e70-8177-80a5e74d0ac5")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCQualityTest240")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC VisualValidation (Quality) test")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Difficult_Edge_06_720x576p25f_intra_main.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCQualityTest241)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"F56A4ABE-84FE-4283-8A6B-FA323B58FE66")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"39fc9fd4-f14d-4e4c-a9d6-e3304b5e3877")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCQualityTest241")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC VisualValidation (Quality) test")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Difficult_Edge_06_720x576p25f_lowdelay_main.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCQualityTest242)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"7737A44B-5E30-41BE-86B5-5F5B4C4BB458")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"54b56f1f-a74b-4222-8fcd-681ed0f467d6")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCQualityTest242")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC VisualValidation (Quality) test")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Motion_DifDirect_01_1280x720p24f_intra_main.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCQualityTest243)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"D021CFFC-68B0-43F0-B6B3-0BFD8BA84B89")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"3d6719f6-6e41-4f31-812f-7cc773fff163")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCQualityTest243")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC VisualValidation (Quality) test")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Motion_DifDirect_01_1280x720p24f_lowdelay_P_main.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCQualityTest244)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"CD3666F5-6A06-4E49-AA36-8E086E983263")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"dbacf3e8-cc98-4c04-b420-de179939d0a9")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCQualityTest244")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC VisualValidation (Quality) test")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Motion_DifDirect_01_1280x720p24f_2340kbps_randomaccess_main.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCQualityTest245)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"B99C8970-F1D9-44B9-BD6A-47E29178B3F6")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"b38e9296-ff22-4ab7-8463-3c559b0c0cb5")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCQualityTest245")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC VisualValidation (Quality) test")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Motion_FastCam_Action_03_1920x1080i30f_lowdelay_main.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCQualityTest246)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"AFEECACB-58C8-43D5-B2BA-B0044E924B16")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"933e6dd3-f45b-44eb-9007-e0886b248fbc")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCQualityTest246")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC VisualValidation (Quality) test")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Motion_FastCam_Action_03_1920x1080p24f_5760kbps_randomaccess_main.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCQualityTest247)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"0FE6AB2F-59B3-4A57-AF3E-F8780AF85F91")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"d714afa5-7748-4f73-bb44-ddaedddcc54a")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCQualityTest247")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC VisualValidation (Quality) test")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Motion_FastCam_Action_03_1920x1080p24f_lowdelay_P_main.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCQualityTest248)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"2A72DB7C-F727-4757-97E2-2421376677CF")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"6a92cb1a-e916-4fa4-a828-f346f0af3f8a")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCQualityTest248")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC VisualValidation (Quality) test")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Texture_High_01_320x240p30f_randomaccess_main.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCQualityTest249)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"3D1B84EF-455C-4C75-BB50-843FD9658C88")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"e2b5e4d8-d162-4e1a-beb8-6c6966bbb064")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCQualityTest249")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC VisualValidation (Quality) test")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Texture_SkinTones_05_352x288p15f_lowdelay_main.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCQualityTest250)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"13CE4219-7F9A-406D-8278-F2E1889B91DD")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"19a6c826-a030-4529-8a39-f591e60d3258")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCQualityTest250")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC VisualValidation (Quality) test")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Texture_SkinTones_05_352x288p15f_lowdelay_P_main.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCQualityTest251)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"08606C79-2E4C-46B1-83FE-73A066FEACA9")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"643eb645-862d-4cf7-a097-d98aae125ad6")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCQualityTest251")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC VisualValidation (Quality) test")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Texture_SkinTones_05_352x288p25f_intra_main.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCQualityTest252)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"E7E89C51-7B7D-4528-9A39-2F0766FC3C53")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"5130c3f8-ba38-4ece-b195-58869c44de53")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCQualityTest252")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC VisualValidation (Quality) test")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Texture_SkinTones_05_352x288p25f_lowdelay_main.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCQualityTest253)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"9CDF12A0-C1B4-479D-9592-CC5CF38C9E84")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"ecc88d11-f9e4-48ed-b301-5c142a48a4ce")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCQualityTest253")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC VisualValidation (Quality) test")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Texture_SkinTones_08_320x240p24f_lowlevel_main.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCQualityTest254)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"D19BCF59-88EA-4560-B815-0F728BF6B9A1")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"af267c2d-9455-4a4c-a6e9-14f60d61a052")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCQualityTest254")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC VisualValidation (Quality) test")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Texture_SkinTones_08_320x240p24f_randomaccess_main.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCQualityTest255)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"C0008D3B-01BA-47D8-AF6B-C3AA2CFB5A0C")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"05c8c8eb-08d6-4999-8b12-12188d817cd9")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCQualityTest255")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC VisualValidation (Quality) test UHD 3840x2160 multiple tiles")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\HEVC_3840x2160_64tiles_sao_cross_tile.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCQualityTest256)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"4F31B371-96D1-49F8-A9E2-B7C5783C71C7")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"db7b6587-97e3-49f7-a8ea-ba752986faf5")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCQualityTest256")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC VisualValidation (Quality) test UHD 3840x2160 multiple tiles no sao cross tile")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\HEVC_3840x2160_64tiles_sao_no_cross_tile.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCQualityTest257)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"5DC28C8D-BA75-479F-8817-99D49E94AC72")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"c5b64aa9-d814-4c8f-844a-51689628a89b")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCQualityTest257")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC VisualValidation (Quality) test 4k 4096x2160 multiple tiles")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\HEVC_4096x2160_64tiles_sao_cross_tile.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCQualityTest258)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"8DF67E81-2F58-4F06-89BB-52443B7BF2BC")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"ddb15b61-3a3f-47ae-84b0-927242218290")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCQualityTest258")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC VisualValidation (Quality) test 4k 4096x2160 multiple tiles no sao cross tile")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\HEVC_4096x2160_64tiles_sao_no_cross_tile.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCStressTest310)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"875DE39C-FB5D-4950-916D-FE891B287EDB")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"488ddb5b-58fe-405e-992f-3473aab7b87f")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCStressTest310")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"120")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"120")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC Stress test")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Difficult_Edge_06_720x576p25f_lowdelay_P_main.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCStressTest311)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"3F859C89-553F-42A7-A083-130F1C85F86B")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"e9661d15-f046-40b9-b0bd-ffd7c70d1998")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCStressTest311")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"120")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"120")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC Stress test")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Motion_FastCam_Action_03_1920x1080p24f_4278kbps_randomaccess_main.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCStressTest312)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"4F6642B5-C57C-4940-87AB-EA936E1E9F75")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"28b597b9-925d-4a7a-a63f-5b0d839f9605")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCStressTest312")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"120")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"120")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC Stress test")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Texture_High_01_320x240p30f_lowdelay_P_main.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCMultiInstanceTest410)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"EC655496-B230-4E6D-9BC4-8F3983A8D72F")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"2d17e0da-4834-465f-a3f8-6d850f67bfe9")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCMultiInstanceTest410")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC multiinstance test")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Difficult_Edge_02_720x480i30f_randomaccess_main.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCMultiInstanceTest411)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"73D8A2EE-1D0C-42FD-8874-165435EEF6DC")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"898fc713-05a9-420b-a0b3-c01c7ef8d4b0")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCMultiInstanceTest411")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC multiinstance test")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Difficult_Edge_02_720x480p24f_intra_main.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCMultiInstanceTest412)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"1022FF97-3AF1-483C-B068-D24C195A0421")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"54a2fb7e-7f55-4d3f-a1be-3c60b1413bb7")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCMultiInstanceTest412")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC multiinstance test")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Difficult_Edge_06_720x576i25f_lowdelay_main.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCMultiInstanceTest413)
    TEST_METHOD_PROPERTY(L"Kits.TestId", L"626713CC-0A5C-4CD6-9582-E7DD58946731")
    TEST_METHOD_PROPERTY(L"Kits.TestId2", L"349454fa-c70b-4b38-9488-10f0f78ef469")
    TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCMultiInstanceTest413")
    TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
    TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
    TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
    TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
    TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
    TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
    TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
    TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
    TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC multiinstance test")
    TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
    TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
    TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
    TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
    TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
    TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Texture_High_01_320x240p30f_intra_main.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCMultiInstanceTest414)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"0E071706-0B78-4AE9-A2EE-AD959078EB03")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"6a34b2d1-3e3a-4bcc-9e35-769c9080209b")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCMultiInstanceTest414")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC multiinstance test")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Texture_SkinTones_05_352x288p25f_randomaccess_main.mp4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(HEVCMultiInstanceTest415)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"CBE14EC3-E33D-4DAC-BF30-CE8708F7BA9F")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"149b6e56-ebdf-492f-ac50-cb66d3a3876f")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"HEVCMultiInstanceTest415")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"HEVC multiinstance test")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Texture_SkinTones_08_320x240p24f_intra_main.mp4")
    END_TEST_METHOD() 

    BEGIN_TEST_METHOD(CustomXML)
        TEST_METHOD_PROPERTY(L"CustomXML", L"TRUE")
    END_TEST_METHOD()

protected:
    HRESULT RunTestsWithIDs(const DWORD* pdwTestIDs, const DWORD dwNumTestIDs);
    HRESULT RunActualTest(const DWORD dwTestID, const GUID* pGUIDMFTUnderTest, const WCHAR* pszHWURL);
    HRESULT GetGUIDsToTest(const DWORD dwTestID, GUID pGUIDsToTest[], WCHAR* pppszHWURLs[], const DWORD dwMaxGUIDsToTest, DWORD *pdwNumGUIDs);
    HRESULT VerifyHWRegKeys(void);
};

#pragma prefast(pop)
