// Copyright(C) Microsoft. All rights reserved.

//
// UMATest.cpp
//
// Description:
//
//  Shell98 Module Implementation for UMA Test Application
//

#include "stdafx.h"
#include "TestType.h"

CMyModule _Module; // ATL module

#ifdef BUILD_TAEF
#define ENABLE_HLK_CERTIFICATION() \
    BEGIN_TEST_METHOD_PROPERTIES() \
        TEST_METHOD_PROPERTY(L"HCKCategory", L"Certification") \
    END_TEST_METHOD_PROPERTIES()
#else
#define ENABLE_HLK_CERTIFICATION()
#endif

//
// Test Case Info Structure
//
BEGIN_TEST_CASE_INFO(UMATest, CEndpointModule)
//    [TEST ID]   [Test Case Name]                                                      [TEST CASE FLAGS]    [DEVICE TYPE FLAGS]                                                    [NA]  [N/A]  [TEST CASE FUNCTION POINTER]                            [TEST CASE GUID]
    DEVICE_TEST_PARENT( "",         "User Mode Audio Test",                                               0,                   0,                                                                     0,    NULL,  NULL,                                                   "{a061bce0-625b-4d87-84a0-50036d32430f}")
    DEVICE_TEST_PARENT( "",         " API Tests",                                                         0,                   0,                                                                     0,    NULL,  NULL,                                                   "{5020fffc-8b8d-4d42-b00e-fca98f218aee}")
    DEVICE_TEST_PARENT( "",         "  IAudioClient",                                                     0,                   0,                                                                     0,    NULL,  NULL,                                                   "{5645f9b5-ff10-444f-9fc1-d8a8e1157422}")
    DEVICE_TEST_PARENT( "",         "   Valid Scenarios",                                                 0,                   0,                                                                     0,    NULL,  NULL,                                                   "{8a1da59e-1b7b-4bef-8d54-8fa5a36e64b9}")
    DEVICE_TEST_METHOD( "1.1.1",    "    GetService",                                                     0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_AudioClient_GetService_Valid,                        "{5862dbb1-52a6-4f2a-928b-782c494f3dc2}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.1.2",    "    GetBufferSize",                                                  0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_AudioClient_GetBufferSize_Valid,                     "{ac495a73-f578-4907-b952-b76b18467d39}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.1.3",    "    GetStreamLatency",                                               0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_AudioClient_GetStreamLatency_Valid,                  "{2b9bd341-aaa7-4af9-be46-d08463d35153}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.1.4",    "    SetEventHandle",                                                 0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_AudioClient_SetEventHandle_Valid,                    "{78820e2b-4f38-4c8a-927b-f812898ac092}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.1.6",    "    Activate via AudioInterface (async)",                            0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_AudioClient_ActivateViaAudioInterfaceAsync,          "{e29c4fc2-c9f3-4ea0-97bf-5c8e82fcffd8}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_PARENT( "",         "   Invalid Scenarios",                                               0,                   0,                                                                     0,    NULL,  NULL,                                                   "{c5736865-204d-47d5-9f29-f2f5d9d15d00}")
    DEVICE_TEST_METHOD( "1.2.1",    "    GetService",                                                     0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_AudioClient_GetService_Invalid,                      "{23612b72-7a5f-4a13-acd2-2d7de1a58457}")
    DEVICE_TEST_METHOD( "1.2.2",    "    IsFormatSupported",                                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_AudioClient_IsFormatSupported_Invalid,               "{8c399606-8995-4789-99ca-8b16c83e343a}")
    DEVICE_TEST_METHOD( "1.2.3",    "    Initialize",                                                     0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_AudioClient_Initialize_Invalid,                      "{3e5ea8b7-1fe2-414d-8dc8-76889315d84b}")
    DEVICE_TEST_METHOD( "1.2.4",    "    GetBufferSize",                                                  0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_AudioClient_GetBufferSize_Invalid,                   "{4849cb7e-2299-413e-954b-359fc6c8ed24}")
    DEVICE_TEST_METHOD( "1.2.5",    "    GetStreamLatency",                                               0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_AudioClient_GetStreamLatency_Invalid,                "{27150d2a-7749-4d11-b92d-74f32ac8e1a9}")
    DEVICE_TEST_METHOD( "1.2.6",    "    GetCurrentPadding",                                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_AudioClient_GetCurrentPadding_Invalid,               "{fcb3ebbd-0f2e-4492-9deb-e94d82a103fc}")
    DEVICE_TEST_METHOD( "1.2.7",    "    DisconnectService",                                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_AudioClient_DisconnectService_Invalid,               "{cf62000c-14f3-4016-90bd-1260b44f56aa}")
    DEVICE_TEST_METHOD( "1.2.8",    "    QueryInterface",                                                 0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_AudioClient_QueryInterface_Invalid,                  "{eb56994e-910c-4803-ade8-fd31b46574cc}")
    DEVICE_TEST_METHOD( "1.2.9",    "    GetMixFormat",                                                   0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_AudioClient_GetMixFormat_Invalid,                    "{7f96baf0-ca7b-4dcb-9d04-ce4e74f1df62}")
    DEVICE_TEST_METHOD( "1.2.10",   "    SetEventHandle",                                                 0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_AudioClient_SetEventHandle_Invalid,                  "{b58434ba-8ce6-4515-bb76-15755bc7dc22}")        
    DEVICE_TEST_PARENT( "",         "  IAudioClient2",                                                    0,                   0,                                                                     0,    NULL,  NULL,                                                   "{E31DABF1-0834-4570-90C6-034D9333C162}")
    DEVICE_TEST_PARENT( "",         "   Valid Scenarios",                                                 0,                   0,                                                                     0,    NULL,  NULL,                                                   "{591A593F-11C7-443A-B5EA-8E9F0C23F2FE}")
    DEVICE_TEST_METHOD( "1.3.1",    "    IsOffloadCapable",                                               0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_AudioClient2_IsOffloadCapable_Valid,                 "{144B6C64-1E76-4252-8274-BEDABDE86FA7}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.3.2",    "    SetClientProperties",                                            0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_AudioClient2_SetClientProperties_Valid,              "{4B5D574E-79F4-44B9-ACDA-701727BA6E3D}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.3.3",    "    GetBufferSizeLimits",                                            0,                   DEVICE_TYPE_RENDEROFFLOAD,                                             0,    NULL,  TC_AudioClient2_GetBufferSizeLimits_Valid,              "{0DFC6313-1EF0-4408-AAB0-8E7076473874}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_PARENT( "",         "   Invalid Scenarios",                                               0,                   0,                                                                     0,    NULL,  NULL,                                                   "{64CC188C-6088-4DC2-8A6B-E7CFA9640A23}")
    DEVICE_TEST_METHOD( "1.4.1",    "    IsOffloadCapable",                                               0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_AudioClient2_IsOffloadCapable_Invalid,               "{4871A0FD-8A3B-4878-BC77-BB6F4070F094}")
    DEVICE_TEST_METHOD( "1.4.2",    "    SetClientProperties",                                            0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_AudioClient2_SetClientProperties_Invalid,            "{8C4F7A04-2338-4707-8557-7EBC07FC0DD7}")
    DEVICE_TEST_METHOD( "1.4.3",    "    GetBufferSizeLimits",                                            0,                   DEVICE_TYPE_RENDEROFFLOAD,                                             0,    NULL,  TC_AudioClient2_GetBufferSizeLimits_Invalid,            "{3416D2E7-E311-4D20-91EE-517BEB9878E3}")
    DEVICE_TEST_METHOD( "1.4.4",    "    TimerDrivenOffload",                                             0,                   DEVICE_TYPE_RENDEROFFLOAD,                                             0,    NULL,  TC_AudioClient2_TimerDrivenOffload_Invalid,             "{0BA8A38C-72A8-4C59-35AC-772E2381ED03}")
    DEVICE_TEST_PARENT( "",         "  IAudioRenderClient",                                               0,                   0,                                                                     0,    NULL,  NULL,                                                   "{8497e1b7-bbd9-4295-89db-df99bae831ef}")
    DEVICE_TEST_PARENT( "",         "   Invalid Scenarios",                                               0,                   0,                                                                     0,    NULL,  NULL,                                                   "{343d4158-6732-4d4d-8072-baa49e2e9cd8}")
    DEVICE_TEST_METHOD( "1.5.1",    "    GetBuffer",                                                      0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_AudioRenderClient_GetBuffer_Invalid,                 "{f893aade-b4c3-4047-94b2-de802b9a77df}")        
    DEVICE_TEST_METHOD( "1.5.2",    "    GetBuffer (hacker)",                                             TESTFLAG_DISABLED,   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_AudioRenderClient_GetBuffer_Hacker_Invalid,          "{3bfcd664-3b4f-4bd1-b28f-84e0ccbd6942}")        
    DEVICE_TEST_METHOD( "1.5.3",    "    ReleaseBuffer",                                                  0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_AudioRenderClient_ReleaseBuffer_Invalid,             "{58456362-bcca-45c6-96af-78e131a512d3}")
    DEVICE_TEST_PARENT( "",         "  IAudioCaptureClient",                                              0,                   0,                                                                     0,    NULL,  NULL,                                                   "{ffa533f4-d8e1-4aa1-974d-46a127bb9af7}")
    DEVICE_TEST_PARENT( "",         "   Invalid Scenarios",                                               0,                   0,                                                                     0,    NULL,  NULL,                                                   "{a79fcb6d-588d-4859-8a95-e025fcf02b93}")
    DEVICE_TEST_METHOD( "1.6.1",    "    GetBuffer",                                                      0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_AudioCaptureClient_GetBuffer_Invalid,                "{783b5bfe-bf7b-41c0-9be4-3ca2ddd38525}")        
    DEVICE_TEST_METHOD( "1.6.2",    "    GetBuffer (hacker)",                                             TESTFLAG_DISABLED,   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_AudioCaptureClient_GetBuffer_Hacker_Invalid,         "{e564bcd6-813a-492e-9312-1f7c9811e72d}")        
    DEVICE_TEST_METHOD( "1.6.3",    "    ReleaseBuffer",                                                  0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_AudioCaptureClient_ReleaseBuffer_Invalid,            "{eac5f0cd-44ea-4bd5-a74a-f97eb052b69c}")        
    DEVICE_TEST_PARENT( "",         "  IAudioClock",                                                      0,                   0,                                                                     0,    NULL,  NULL,                                                   "{2a6e4e6b-e08f-4c1b-83be-4d89c3d493a8}")
    DEVICE_TEST_PARENT( "",         "   Invalid Scenarios",                                               0,                   0,                                                                     0,    NULL,  NULL,                                                   "{0bd67874-07b1-4850-a569-5eca1debad99}")
    DEVICE_TEST_METHOD( "1.7.1",    "    GetPosition",                                                    0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE,                                0,    NULL,  TC_AudioClock_GetPosition_Invalid,                      "{a0e640c4-e86a-4d75-ba55-30cc1e0d29b3}")        
    DEVICE_TEST_METHOD( "1.7.2",    "    GetFrequency",                                                   0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE,                                0,    NULL,  TC_AudioClock_GetFrequency_Invalid,                     "{a4c604c4-2063-4ea6-8e82-c9969d99b661}")        
    DEVICE_TEST_METHOD( "1.7.3",    "    GetCharacteristics",                                             0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE,                                0,    NULL,  TC_AudioClock_GetCharacteristics_Invalid,               "{a817b9e2-2004-41b7-9e3a-7ebb219b9914}")        
    DEVICE_TEST_PARENT( "",         "  IPolicyConfig",                                                    0,                   0,                                                                     0,    NULL,  NULL,                                                   "{484f0302-d968-49e3-ad2c-bb2060f55083}")
    DEVICE_TEST_PARENT( "",         "   Invalid Scenarios",                                               0,                   0,                                                                     0,    NULL,  NULL,                                                   "{e961fd39-760a-49dd-b314-64eb5e7a8130}")
    DEVICE_TEST_METHOD( "1.8.1",    "    GetDeviceFormat",                                                TESTFLAG_DISABLED,   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE,                                0,    NULL,  TC_PolicyConfig_GetDeviceFormat_Invalid,                "{fd8c323a-4d8b-4baa-b5ea-8d307b8177b7}")        
    DEVICE_TEST_METHOD( "1.8.2",    "    GetMixFormat",                                                   TESTFLAG_DISABLED,   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE,                                0,    NULL,  TC_PolicyConfig_GetMixFormat_Invalid,                   "{5155d055-f51c-416f-b27b-9ec23e2e8a64}")        
    DEVICE_TEST_METHOD( "1.8.3",    "    SetDeviceFormat",                                                TESTFLAG_DISABLED,   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE,                                0,    NULL,  TC_PolicyConfig_SetDeviceFormat_Invalid,                "{fa2d4297-9f2f-48b2-a11f-9c343d2e3e06}")        
    DEVICE_TEST_METHOD( "1.8.4",    "    GetProcessingPeriod",                                            TESTFLAG_DISABLED,   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE,                                0,    NULL,  TC_PolicyConfig_GetProcessingPeriod_Invalid,            "{c9299fd8-4dcd-4402-b14c-c371de64bc0a}")        
    DEVICE_TEST_METHOD( "1.8.5",    "    SetProcessingPeriod",                                            TESTFLAG_DISABLED,   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE,                                0,    NULL,  TC_PolicyConfig_SetProcessingPeriod_Invalid,            "{ccfbd9e3-e039-43ee-aa39-3ca9ca40bb3d}")        
    DEVICE_TEST_METHOD( "1.8.6",    "    GetShareMode",                                                   TESTFLAG_DISABLED,   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE,                                0,    NULL,  TC_PolicyConfig_GetShareMode_Invalid,                   "{bf53652e-faa9-41f4-a3aa-0a1e96e92dc2}")        
    DEVICE_TEST_METHOD( "1.8.7",    "    SetShareMode",                                                   TESTFLAG_DISABLED,   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE,                                0,    NULL,  TC_PolicyConfig_SetShareMode_Invalid,                   "{9117765a-62c5-4824-8ab4-6c847b3546af}")        
    DEVICE_TEST_METHOD( "1.8.8",    "    SetDefaultEndpoint",                                             TESTFLAG_DISABLED,   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE,                                0,    NULL,  TC_PolicyConfig_SetDefaultEndpoint_Invalid,             "{0296f4f2-456e-4fc1-a0c2-450afd6e6a08}")        
    DEVICE_TEST_METHOD( "1.8.9",    "    SetEndpointVisibility",                                          0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE,                                0,    NULL,  TC_PolicyConfig_SetEndpointVisibility_Invalid,          "{9d95c994-3672-4c12-a174-591719fe8acf}")        
    DEVICE_TEST_PARENT( "",         "  ISimpleAudioVolume",                                               0,                   0,                                                                     0,    NULL,  NULL,                                                   "{13864816-6887-4225-baaf-f3f277d7a99b}")
    DEVICE_TEST_PARENT( "",         "   Valid Scenarios",                                                 0,                   0,                                                                     0,    NULL,  NULL,                                                   "{05fb669a-b167-44e3-bc40-cf9ca34ce006}")
    DEVICE_TEST_METHOD( "1.9.1",    "    SetMasterVolume Basic Functionality",                            0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_SimpleAudioVolume_SetMasterVolume_Basic0,            "{67fefc12-b4ef-4df6-b5bc-71f8619e4429}")        
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.9.2",    "    SetMasterVolume Volumes in [0,1]",                               0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_SimpleAudioVolume_SetMasterVolume_Valid0,            "{2c30aca4-907f-4f4f-9341-d11250b569f9}")        
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.9.3",    "    Get/Set Mute Basic Functionality",                               0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_SimpleAudioVolume_GetSetMute_Basic0,                 "{8b1a85f0-9555-482c-b196-436be03e77c2}")        
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_PARENT( "",         "   Invalid Scenarios",                                               0,                   0,                                                                     0,    NULL,  NULL,                                                   "{05fb669a-b167-44e3-bc40-cf9ca34ce006}")
    DEVICE_TEST_METHOD( "1.10.1",    "    SetMasterVolume (<0)",                                           0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_SimpleAudioVolume_SetMasterVolume_Invalid0,          "{7507a5c2-1dfe-4be3-bee4-583416ca52c6}")        
    DEVICE_TEST_METHOD( "1.10.2",    "    SetMasterVolume (>1)",                                           0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_SimpleAudioVolume_SetMasterVolume_Invalid1,          "{90e0a259-ec7f-4efe-b2ee-06394592570b}")        
    DEVICE_TEST_METHOD( "1.10.3",    "    GetMasterVolume (NULL)",                                         0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_SimpleAudioVolume_GetMasterVolume_Invalid0,          "{cc2befa7-2989-4bd0-9ab0-43a3ed377728}")        
    DEVICE_TEST_METHOD( "1.10.4",    "    GetMute (NULL)",                                                 0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_SimpleAudioVolume_GetMute_Invalid0,                  "{cccb9538-7fdc-42b9-9ab3-7b6d46d05d75}")        
    DEVICE_TEST_METHOD( "1.10.5",    "    DisconnectService",                                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_SimpleAudioVolume_DisconnectService,                 "{bca5affa-c9ad-4031-9167-8d5ef297dbad}")        
    DEVICE_TEST_PARENT( "",         "  IChannelAudioVolume",                                              0,                   0,                                                                     0,    NULL,  NULL,                                                   "{592fb447-f02c-4e5a-8d75-f6b1609c3d30}")
    DEVICE_TEST_PARENT( "",         "   Valid Scenarios",                                                 0,                   0,                                                                     0,    NULL,  NULL,                                                   "{05fb669a-b167-44e3-bc40-cf9ca34ce006}")
    DEVICE_TEST_METHOD( "1.11.1",    "    GetChannelCount Basic Functionality",                            0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_ChannelAudioVolume_GetChannelCount_Valid0,           "{10cd7edb-1de9-4187-aa74-3985c0d6c920}")        
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.11.2",    "    SetChannelVolume Basic Functionality",                           0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_ChannelAudioVolume_SetChannelVolume_Valid0,          "{98da95df-a296-49cb-8faa-7cf21d46dfd1}")        
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.11.3",    "    SetChannelVolume Simple Scenarios",                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_ChannelAudioVolume_SetChannelVolume_Valid1,          "{38f49b86-ebc3-40eb-a368-780fc61a83b8}")        
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.11.4",    "    GetAllVolumes/SetAllVolumes Basic Functionality",                0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_ChannelAudioVolume_GetSetAllVolumes_Valid0,          "{d290bee9-666e-4446-9f45-a8ad21b05822}")        
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.11.5",    "    GetAllVolumes/SetAllVolumes Simple Scenarios",                   0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_ChannelAudioVolume_GetSetAllVolumes_Valid1,          "{2ec673fd-5c80-4c6e-a39b-47959771fbc7}")        
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_PARENT( "",         "   Invalid Scenarios",                                               0,                   0,                                                                     0,    NULL,  NULL,                                                   "{26498e5d-5e03-49df-b11f-1ed3a5a0e734}")
    DEVICE_TEST_METHOD( "1.12.1",   "    GetChannelCount NULL Param",                                     0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_ChannelAudioVolume_GetChannelCount_Invalid0,         "{a8553271-b36b-4bbf-b636-9ac2fd4c5917}")        
    DEVICE_TEST_METHOD( "1.12.2",   "    SetChannelVolume (<0)",                                          0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_ChannelAudioVolume_SetChannelVolume_Invalid0,        "{b0a36932-0d62-4ddb-b21a-944b1ecf3ef5}")        
    DEVICE_TEST_METHOD( "1.12.3",   "    SetChannelVolume (>1)",                                          0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_ChannelAudioVolume_SetChannelVolume_Invalid1,        "{9aa7cff7-85b9-4605-aca7-972e122d4927}")        
    DEVICE_TEST_METHOD( "1.12.4",   "    SetChannelVolume Invalid Channels",                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_ChannelAudioVolume_SetChannelVolume_Invalid2,        "{6137ac67-e20c-47e6-b14a-f23b12022367}")        
    DEVICE_TEST_METHOD( "1.12.5",   "    GetChannelVolume NULL Param",                                    0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_ChannelAudioVolume_GetChannelVolume_Invalid0,        "{103bcfa8-f8f4-4240-b6d2-88ab9a6cd16e}")        
    DEVICE_TEST_METHOD( "1.12.6",   "    GetChannelVolume Invalid Channels",                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_ChannelAudioVolume_GetChannelVolume_Invalid1,        "{d4153925-44fc-4ab5-a656-71cf5ce14cfa}")        
    DEVICE_TEST_METHOD( "1.12.7",   "    GetChannelVolume NULL Param + Invalid Channels",                 0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_ChannelAudioVolume_GetChannelVolume_Invalid2,        "{09015149-5381-4913-b7f5-3b7aa9df134e}")
    DEVICE_TEST_METHOD( "1.12.8",   "    SetAllVolumes NULL Param",                                       0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_ChannelAudioVolume_SetAllVolumes_Invalid0,           "{335c5159-7913-49d8-9e80-ab0e81c1db10}")        
    DEVICE_TEST_METHOD( "1.12.9",   "    SetAllVolumes Bad Channel Count",                                0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_ChannelAudioVolume_SetAllVolumes_Invalid1,           "{5734aaee-a1a6-4fb5-b751-6001bdbdcfc1}")        
    DEVICE_TEST_METHOD( "1.12.10",  "    SetAllVolumes Bad Attenuations",                                 0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_ChannelAudioVolume_SetAllVolumes_Invalid2,           "{15bc918c-c379-4ad2-9930-f9de9f54ffd1}")        
    DEVICE_TEST_METHOD( "1.12.11",  "    SetAllVolumes Multiple Invalid Params",                          0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_ChannelAudioVolume_SetAllVolumes_Invalid3,           "{81064958-c6e4-4eb5-9a2f-de7db3447d69}")        
    DEVICE_TEST_METHOD( "1.12.12",  "    GetAllVolumes NULL Param",                                       0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_ChannelAudioVolume_GetAllVolumes_Invalid0,           "{4735f422-2521-4505-9e58-8b6b50def5bf}")        
    DEVICE_TEST_METHOD( "1.12.13",  "    GetAllVolumes Bad Channel Count",                                0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_ChannelAudioVolume_GetAllVolumes_Invalid1,           "{85cf913a-f5f4-4cae-b684-24e09d20932b}")        
    DEVICE_TEST_METHOD( "1.12.14",  "    GetAllVolumes Multiple Invalid Params",                          0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_ChannelAudioVolume_GetAllVolumes_Invalid2,           "{a05853af-a9ee-4f81-90b6-7174c27121f9}")        
    DEVICE_TEST_METHOD( "1.12.14",  "    DisconnectService",                                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_ChannelAudioVolume_DisconnectService,                "{571c41c8-0eb3-41c3-b228-3a5faed6a5e7}")        
    DEVICE_TEST_PARENT( "",         "  IAudioStreamVolume",                                               0,                   0,                                                                     0,    NULL,  NULL,                                                   "{5e45f521-ad3c-4a9e-aea6-e9c56dc0ba54}")
    DEVICE_TEST_PARENT( "",         "   Valid Scenarios",                                                 0,                   0,                                                                     0,    NULL,  NULL,                                                   "{f637cbf7-fcd4-4b6b-852f-6aa210b469d8}")
    DEVICE_TEST_METHOD( "1.13.1",   "    GetChannelCount Basic Functionality",                            0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_StreamAudioVolume_GetChannelCount_Valid0,            "{3851986a-e882-4a5d-98e2-2bcacdc4aaac}")        
    DEVICE_TEST_METHOD( "1.13.2",   "    GetChannelVolume/SetChannelVolume Basic Functionality",          0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_StreamAudioVolume_GetSetChannelVolume_Valid0,        "{8fcd38a9-f1c9-4607-8a47-2640baf10165}")        
    DEVICE_TEST_METHOD( "1.13.3",   "    GetAllVolumes/SetAllVolumes Basic Functionality",                0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_StreamAudioVolume_GetSetAllVolumes_Valid0,           "{64619b50-cc74-4627-a73d-61c409eb34d7}")        
    DEVICE_TEST_METHOD( "1.13.4",   "    GetAllVolumes/SetAllVolumes Extensive Tests",                    0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_StreamAudioVolume_GetSetAllVolumes_Valid1,           "{cf2bc5bb-6b2b-443f-8b96-f6bf6195b73b}")        
    DEVICE_TEST_PARENT( "",         "   Invalid Scenarios",                                               0,                   0,                                                                     0,    NULL,  NULL,                                                   "{f12c44ed-25e5-47de-96b8-6932333dfbe4}")
    DEVICE_TEST_METHOD( "1.14.1",   "    GetChannelCount",                                                0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_StreamAudioVolume_GetChannelCount_Invalid0,          "{0ce0e433-08a8-40c4-8ee5-76d7f40cfb57}")        
    DEVICE_TEST_METHOD( "1.14.2",   "    SetChannelVolume",                                               0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_StreamAudioVolume_SetChannelVolume_Invalid0,         "{bf561c66-6a78-4c13-a17f-d8fda38e7c3f}")        
    DEVICE_TEST_METHOD( "1.14.3",   "    GetChannelVolume",                                               0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_StreamAudioVolume_GetChannelVolume_Invalid0,         "{39e08829-c1f2-49ce-a078-9570ea1fdcb7}")        
    DEVICE_TEST_METHOD( "1.14.4",   "    GetAllVolumes",                                                  0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_StreamAudioVolume_GetAllVolumes_Invalid0,            "{241d7fe5-bae7-4268-baed-e8c84e5137c9}")        
    DEVICE_TEST_METHOD( "1.14.5",   "    SetAllVolumes",                                                  0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_StreamAudioVolume_SetAllVolumes_Invalid0,            "{975a01bd-6f2c-42d5-9571-30cb41ade012}")        
    DEVICE_TEST_METHOD( "1.14.6",   "    DisconnectService",                                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_StreamAudioVolume_DisconnectService,                 "{13849572-e9b0-4512-a776-5343c8276a18}")        
    DEVICE_TEST_PARENT( "",         "  IAudioSessionControl",                                             0,                   0,                                                                     0,    NULL,  NULL,                                                   "{16b7e1ec-c157-4b62-988c-c8ce674603b0}")
    DEVICE_TEST_PARENT( "",         "   Valid Scenarios",                                                 0,                   0,                                                                     0,    NULL,  NULL,                                                   "{1f6cc925-1544-4b68-82d3-cb01b9e87a31}")
    DEVICE_TEST_METHOD( "1.15.1",   "    GetSessionIdentifier/GetSessionInstnaceIdentifier Basic",        0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_AudioSessionControl_GetSessionID_Valid0,             "{b63be2ef-c09d-4300-93eb-01acafe76b4e}")
    DEVICE_TEST_METHOD( "1.15.2",   "    GetState Basic",                                                 0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_AudioSessionControl_GetState_Valid0,                 "{fecbfaeb-e70a-4200-a531-cdc4aea96ffc}")
    DEVICE_TEST_METHOD( "1.15.3",   "    GetState Extended",                                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_AudioSessionControl_GetState_Valid1,                 "{ec7eacac-e31d-481a-b121-9d50e71adaa8}")
    DEVICE_TEST_METHOD( "1.15.4",   "    GetLastActivation Basic",                                        0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_AudioSessionControl_GetLastActication_Valid0,        "{a3c7a266-c9c9-4207-a834-63e104b4f2a7}")
    DEVICE_TEST_METHOD( "1.15.5",   "    GetLastActivation Extended",                                     0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_AudioSessionControl_GetLastActication_Valid1,        "{839f2cfc-24c6-4bba-8987-eedb9a0f1509}")
    DEVICE_TEST_METHOD( "1.15.6",   "    GetLastInactivation Basic",                                      0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_AudioSessionControl_GetLastInactivation_Valid0,      "{e20e01ae-4327-418d-822f-3ff1f353a7c1}")
    DEVICE_TEST_METHOD( "1.15.7",   "    GetLastInactivation Extended",                                   0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_AudioSessionControl_GetLastInactivation_Valid1,      "{41f5397b-e341-4902-b910-0e064e5e1471}")
    DEVICE_TEST_METHOD( "1.15.8",   "    GetDisplayName Basic",                                           0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_AudioSessionControl_GetDisplayName_Valid0,           "{e4404fbe-7a67-469a-ae59-391918586236}")
    DEVICE_TEST_METHOD( "1.15.9",   "    SetDisplayName Basic",                                           0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_AudioSessionControl_SetDisplayName_Valid0,           "{49c227c1-e7bf-454e-8892-e8da4f2229b2}")
    DEVICE_TEST_METHOD( "1.15.10",  "    SetDisplayName Extended",                                        0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_AudioSessionControl_SetDisplayName_Valid1,           "{2465e792-2277-439c-ac41-82d1a55dd1c1}")
    DEVICE_TEST_METHOD( "1.15.11",  "    GetIconPath Basic",                                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_AudioSessionControl_GetIconPath_Valid0,              "{ef2d28d1-03df-407d-9a80-b2eaf8df3cd0}")
    DEVICE_TEST_METHOD( "1.15.12",  "    SetIconPath Basic",                                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_AudioSessionControl_SetIconPath_Valid0,              "{25ac5dc5-69da-4ad9-9337-93da27bd8ba3}")
    DEVICE_TEST_METHOD( "1.15.13",  "    GetGroupingParam Basic",                                         0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_AudioSessionControl_GetGroupingParam_Valid0,         "{cf267a59-95e1-4742-ae81-0fba68134279}")
    DEVICE_TEST_METHOD( "1.15.14",  "    SetGroupingParam Basic",                                         0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_AudioSessionControl_SetGroupingParam_Valid0,         "{f0dc3a7d-5e88-4853-882f-fc4fe8d6a045}")
    DEVICE_TEST_METHOD( "1.15.15",  "    Register/Unregister AudioSessionNotifications Basic",            0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_AudioSessionControl_Notifications_Valid0,            "{02e8e7fb-3a2a-4f34-837b-fc87788fb680}")
    DEVICE_TEST_METHOD( "1.15.16",  "    Register/Unregister AudioSessionNotifications No-Delete",        0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_AudioSessionControl_Notifications_Valid1,            "{611bf321-a110-42c1-a01d-6d6f5a44b0c4}")
    DEVICE_TEST_METHOD( "1.15.17",  "    GetProcessId",                                                   0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_AudioSessionControl_GetProcessId,                    "{62457395-7cee-4731-88f5-eeccad06a8aa}")
    DEVICE_TEST_PARENT( "",         "   Invalid Scenarios",                                               0,                   0,                                                                     0,    NULL,  NULL,                                                   "{e077bcf8-21a6-4657-ac52-3d0de4c029ec}")
    DEVICE_TEST_METHOD( "1.16.1",   "    GetSessionIdentifier",                                           0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_AudioSessionControl_GetSessionID_Invalid0,           "{6331493b-2382-4146-91fd-38039bc2e5d2}")
    DEVICE_TEST_METHOD( "1.16.2",   "    GetState",                                                       0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_AudioSessionControl_GetState_Invalid0,               "{07ce6b6b-f0eb-43c8-a726-ea6ea4a2159f}")
    DEVICE_TEST_METHOD( "1.16.3",   "    GetLastActivation",                                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_AudioSessionControl_GetLastActivation_Invalid0,      "{93eb8e96-d7a7-4f25-b386-e4bbf57c0db9}")
    DEVICE_TEST_METHOD( "1.16.4",   "    GetLastInactivation",                                            0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_AudioSessionControl_GetLastInactivation_Invalid0,    "{e4a91d56-8b73-4bad-a2cf-dbf1fc5735a9}")
    DEVICE_TEST_METHOD( "1.16.5",   "    GetDisplayName",                                                 0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_AudioSessionControl_GetDisplayName_Invalid0,         "{63ee4afd-fa9f-40bf-be95-cdb621244d7a}")
    DEVICE_TEST_METHOD( "1.16.6",   "    SetDisplayName",                                                 0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_AudioSessionControl_SetDisplayName_Invalid0,         "{cfc35a8c-7cf1-4370-97fa-fd07b5af8905}")
    DEVICE_TEST_METHOD( "1.16.7",   "    GetGroupingParam",                                               0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_AudioSessionControl_GetGroupingParam_Invalid0,       "{89786f90-752d-44be-8d73-599da92143b1}")
    DEVICE_TEST_METHOD( "1.16.8",   "    AddAudioSessionNotification",                                    0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_AudioSessionControl_AddAudioSesNotif_Invalid0,       "{adac5846-9fdb-4c94-ae17-1e134e89da65}")
    DEVICE_TEST_METHOD( "1.16.9",   "    DeleteAudioSessionNotification",                                 0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_AudioSessionControl_DelAudioSesNotif_Invalid0,       "{0a9f3a3a-f1f6-41f3-8aeb-e3dcaabf7e9b}")
    DEVICE_TEST_METHOD( "1.16.10",  "    GetProcessId",                                                   0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_AudioSessionControl_GetProcessId_Invalid0,           "{fc6cf073-ce09-4a3e-a968-0b2c8d2f2f24}")
    DEVICE_TEST_METHOD( "1.16.11",  "    DisconnectService",                                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_AudioSessionControl_DisconnectService_Invalid0,      "{3fa99964-bbbf-4415-b2b2-2420236605db}")
    DEVICE_TEST_PARENT( "",         "  IAudioEndpointVolume",                                             0,                   0,                                                                     0,    NULL,  NULL,                                                   "{55a7d3c2-cc45-45ca-8325-23fde78e9105}")
    DEVICE_TEST_PARENT( "",         "   Valid Scenarios",                                                 0,                   0,                                                                     0,    NULL,  NULL,                                                   "{2a421ab2-c4d8-4511-b848-7d267c7bf082}")
    DEVICE_TEST_METHOD( "1.17.1",   "    SetMasterVolumeLevel: Basic",                                    0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_EndpointVolume_SetMasterVol_Valid0,                  "{4838c17e-fe2b-4c47-98e4-364967fc9010}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.17.2",   "    SetMasterVolumeLevel: Fade",                                     0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_EndpointVolume_SetMasterVol_Valid1,                  "{b40368d1-2a46-45e3-9b1f-bddd94c81674}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.17.3",   "    SetMasterVolumeLevel: Crop Fade",                                0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_EndpointVolume_SetMasterVol_Valid2,                  "{dd2912ed-9bca-4bc0-a573-7dbf97878109}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.17.4",   "    SetMasterVolumeLevel: Rapid Fade",                               0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_EndpointVolume_SetMasterVol_Valid3,                  "{33061683-aa64-4888-9aaf-817a1f9fcaab}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.17.5",   "    SetMasterVolumeLevelScalar: Basic",                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_EndpointVolume_SetMasterVol_Scalar_Valid0,           "{ee6d9fc7-bea9-4608-b2cb-4c017a653206}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.17.6",   "    SetMasterVolumeLevelScalar: Fade",                               0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_EndpointVolume_SetMasterVol_Scalar_Valid1,           "{aeb45311-fda5-4110-825d-cf9b3ee4ad2b}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.17.7",   "    SetMasterVolumeLevelScalar: Crop Fade",                          0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_EndpointVolume_SetMasterVol_Scalar_Valid2,           "{a70f13c2-f475-47ab-bd31-09ee7677d426}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.17.8",   "    SetMasterVolumeLevelScalar: Rapid Fade",                         0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_EndpointVolume_SetMasterVol_Scalar_Valid3,           "{0514f2cd-691b-423c-8913-6bc27f127a02}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.17.9",   "    SetMute: Basic",                                                 0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_EndpointVolume_SetMute_Valid0,                       "{168a362a-78d4-401e-9ec9-396e74684cd8}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.17.10",  "    SetMute: Rapid",                                                 0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_EndpointVolume_SetMute_Valid1,                       "{0b230058-ffbc-458c-859a-46d35e72e9a0}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.17.11",  "    Volume Stepping: Basic",                                         0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_EndpointVolume_VolumeStepping_Valid1,                "{c3f4238f-bea9-4024-86d9-c5615daacf85}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.17.12",  "    Volume Stepping: Extended",                                      0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_EndpointVolume_VolumeStepping_Valid2,                "{1766e704-f2d5-425e-9679-f09eff30a2c4}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.17.13",  "    GetChannelCount: Basic",                                         0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_EndpointVolume_GetChannelCount_Valid1,               "{c027d6d6-7012-4009-a8fd-b2e95ed02957}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.17.14",  "    SetChannelVolumeLevel: Basic",                                   0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_EndpointVolume_SetChannelVolumeLevel_Valid1,         "{50029be1-3d31-41bc-b125-40a43a104ece}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.17.15",  "    SetChannelVolumeLevel: Fade",                                    0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_EndpointVolume_SetChannelVolumeLevel_Valid2,         "{fff7e386-42c8-431a-9442-8bf9c062a6ce}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.17.16",  "    SetChannelVolumeLevel: Cross-Fade",                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_EndpointVolume_SetChannelVolumeLevel_Valid3,         "{a544ddae-ae0b-44bd-bee6-c5eb389f99c7}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.17.17",  "    SetChannelVolumeLevel: Cropped-Fade",                            0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_EndpointVolume_SetChannelVolumeLevel_Valid4,         "{8d17215f-67f2-47b2-b101-a10c3fff0d45}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.17.18",  "    SetChannelVolumeLevel: Rapid-Fade",                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_EndpointVolume_SetChannelVolumeLevel_Valid5,         "{634dcd4b-3ccc-4711-ac88-99972c8dd4d7}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.17.19",  "    SetChannelVolumeLevelScalar: Basic",                             0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_EndpointVolume_SetChannelVolumeLevelScalar_Valid1,   "{28ae57b8-b158-4dfc-9325-b6c96ec74fdd}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.17.20",  "    SetChannelVolumeLevelScalar: Fade",                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_EndpointVolume_SetChannelVolumeLevelScalar_Valid2,   "{0a09e27a-5a12-417a-ac81-d6817379c47a}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.17.21",  "    SetChannelVolumeLevelScalar: Cross-Fade",                        0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_EndpointVolume_SetChannelVolumeLevelScalar_Valid3,   "{0ae6dd70-234d-4aa5-b11b-e54e3b33ee9c}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.17.22",  "    SetChannelVolumeLevelScalar: Cropped-Fade",                      0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_EndpointVolume_SetChannelVolumeLevelScalar_Valid4,   "{c72a5f7e-eb3c-490a-adfd-ec370d41e367}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.17.23",  "    SetChannelVolumeLevelScalar: Rapid-Fade",                        0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_EndpointVolume_SetChannelVolumeLevelScalar_Valid5,   "{97303b44-725c-43fd-af81-c2fbe9792844}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.17.24",  "    QueryHardwareSupport: Basic",                                    0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_EndpointVolume_QueryHardwareSupport_Valid1,          "{b2fbffd9-d54a-4c18-952a-8158e980a42d}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.17.25",  "    GetVolumeRange: Basic",                                          0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_EndpointVolume_GetVolumeRange_Valid1,                "{555af232-2ee6-4e89-a5e3-e9476c8d14de}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_PARENT( "",         "   Invalid Scenarios",                                               0,                   0,                                                                     0,    NULL,  NULL,                                                   "{b24754a1-8a21-4537-996e-c73865f73ac3}")
    DEVICE_TEST_METHOD( "1.18.1",   "    GetMasterVolumeLevel NULL Param",                                0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_EndpointVolume_GetMasterVol_Invalid0,                "{f1ffa847-8b9e-47df-bcb3-1b8cd5b693f4}")
    DEVICE_TEST_METHOD( "1.18.2",   "    GetMasterVolumeLevelScalar NULL Param",                          0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_EndpointVolume_GetMasterVol_Scalar_Invalid0,         "{8d20553a-4d5c-43ff-8c04-c394cd5a78e1}")
    DEVICE_TEST_METHOD( "1.18.3",   "    GetMute NULL Param",                                             0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_EndpointVolume_GetMute_Invalid0,                     "{ed762b15-f2fe-40be-93d8-15dcd7c35f63}")
    DEVICE_TEST_METHOD( "1.18.4",   "    VolumeStepping: Invalid",                                        0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_EndpointVolume_VolumeStepping_Invalid0,              "{728e91c7-c87e-4ce2-a786-1dc16e127428}")
    DEVICE_TEST_METHOD( "1.18.5",   "    GetChannelCount: NULL Param",                                    0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_EndpointVolume_GetChannelCount_Invalid0,             "{4c107b60-52aa-4258-82cd-4e07097e45ab}")
    DEVICE_TEST_METHOD( "1.18.6",   "    SetChannelVolumeLevel: Invalid channel count",                   0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_EndpointVolume_SetChannelVolumeLevel_Invalid0,       "{e55eb8b6-2355-46c1-94ae-fda9ee3bef55}")
    DEVICE_TEST_METHOD( "1.18.7",   "    SetChannelVolumeLevelScalar: Invalid channel count",             0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_EndpointVolume_SetChannelVolumeLevelScalar_Invalid0, "{fb424b9e-f5ca-43e4-94de-d4bffcb10d20}")
    DEVICE_TEST_METHOD( "1.18.8",   "    GetChannelVolumeLevel NULL Param",                               0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_EndpointVolume_GetChannelVolumeLevel_Invalid0,       "{d368799c-12af-4827-a6e0-2de3c7137218}")
    DEVICE_TEST_METHOD( "1.18.9",   "    GetChannelVolumeLevelScalar NULL Param",                         0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_EndpointVolume_GetChannelVolumeLevelScalar_Invalid0, "{4fcd9ad9-bef1-40b8-a255-4c130e72b390}")
    DEVICE_TEST_METHOD( "1.18.10",  "    QueryHardwareSupport NULL Param",                                0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_EndpointVolume_QueryHardwareSupport_Invalid0,        "{a6046b5d-0f5f-4660-a013-d22a2efc6c7e}")
    DEVICE_TEST_METHOD( "1.18.11",  "    GetVolumeRange: Invalid",                                        0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_EndpointVolume_GetVolumeRange_Invalid1,              "{ccb734bd-74f2-46e1-a77f-ea664cfc9e85}")
    DEVICE_TEST_METHOD( "1.18.12",  "    Disconnect Service",                                             0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_EndpointVolume_DisconnectService_Invalid0,           "{e3086f06-fde4-4239-94bd-fc47fbfdc7a1}")
    DEVICE_TEST_PARENT( "",         "  IAudioMeterInformation",                                           0,                   0,                                                                     0,    NULL,  NULL,                                                   "{92a8ba7c-0312-4cd0-ba12-005bb14da394}")
    DEVICE_TEST_PARENT( "",         "   Valid Scenarios",                                                 0,                   0,                                                                     0,    NULL,  NULL,                                                   "{33767776-2df8-41c2-88b2-962ead5036c8}")
    DEVICE_TEST_METHOD( "1.19.1",   "    Metering APO Basic Valid Scenarios",                             0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_AudioMeterInf_Valid0,                                "{b898294e-f04d-4358-b79f-7b8290cac4dc}")
    DEVICE_TEST_METHOD( "1.19.2",   "    Metering APO Extended Valid Scenarios",                          0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_AudioMeterInf_Valid1,                                "{64294dfa-5f92-455d-a8cf-42333559d9ca}")
    DEVICE_TEST_PARENT( "",         "   Invalid Scenarios",                                               0,                   0,                                                                     0,    NULL,  NULL,                                                   "{d0b6d4d9-6024-4558-a774-56461140cc84}")
    DEVICE_TEST_METHOD( "1.20.1",   "    Metering APO Invalid Params",                                    0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_AudioMeterInf_Invalid0,                              "{224dceca-a0f5-4a21-bf0b-4f67d568fb2a}")
    DEVICE_TEST_METHOD( "1.20.2",   "    Disconnect Service",                                             0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_AudioMeterInf_DisconnectService,                     "{c9f1ef70-3dd2-4f3f-9bcd-5b3c7e1ac058}")
    DEVICE_TEST_PARENT( "",         "  Per-Stream Eventing Scenarios",                                    0,                   0,                                                                     0,    NULL,  NULL,                                                   "{9a48a1cb-d468-45fd-b705-1bbb6477c054}")
    DEVICE_TEST_METHOD( "1.21.1",   "   ISimpleAudioVolume Volume-Level Eventing",                        0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_PerStreamEvents_Scenario1,                           "{688ded31-37ef-4694-bd28-0a33aa410f5f}")
    DEVICE_TEST_METHOD( "1.21.2",   "   ISimpleAudioVolume Mute Eventing",                                0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_PerStreamEvents_Scenario2,                           "{2f334098-6d80-4b8c-b8a3-78e375b7aec9}")
    DEVICE_TEST_METHOD( "1.21.3",   "   IAudioSessionControl SetGroupingParam Eventing",                  0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_PerStreamEvents_Scenario3,                           "{35926be9-47be-48b3-812c-a99de0b5b970}")
    DEVICE_TEST_METHOD( "1.21.4",   "   ISimpleAudioVolume Fading",                                       0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_PerStreamEvents_Scenario4,                           "{44a37e94-7010-422b-b9b6-929f694ed27e}")
    DEVICE_TEST_METHOD( "1.21.5",   "   IAudioSessionControl DisplayNameChanged Eventing",                0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_PerStreamEvents_Scenario5,                           "{a36435f1-833f-4594-ade1-5a825dbf204b}")
    DEVICE_TEST_METHOD( "1.21.6",   "   IAudioSessionControl IconPathChanged Eventing",                   0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_PerStreamEvents_Scenario6,                           "{638ca7b3-2179-45a4-afae-a96a3c1db309}")
    DEVICE_TEST_METHOD( "1.21.7",   "   IAudioSessionControl ChannelVolume Eventing",                     0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_PerStreamEvents_Scenario7,                           "{2eb5c974-b529-4f51-ba7f-427b178096fd}")
    DEVICE_TEST_METHOD( "1.21.8",   "   IAudioSessionControl ChannelVolume Cross-Fade Eventing",          0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_PerStreamEvents_Scenario8,                           "{048f207d-5532-4f54-b963-9fadf6122512}")
    DEVICE_TEST_METHOD( "1.21.9",   "   IAudioSessionEvents Device Format Changed",                       TESTFLAG_DISABLED,   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_PerStreamEvents_Scenario9,                           "{771547e5-aa10-4077-8649-da135b119bd9}")
    DEVICE_TEST_PARENT( "",         "  Per-Endpoint Eventing Scenarios",                                  0,                   0,                                                                     0,    NULL,  NULL,                                                   "{93001af6-c5fc-494c-bb88-7a1616492769}")
    DEVICE_TEST_PARENT( "",         "   Valid Scenarios",                                                 0,                   0,                                                                     0,    NULL,  NULL,                                                   "{022d01ca-7216-4122-b64d-ad168c3dd0d1}")
    DEVICE_TEST_METHOD( "1.22.1",   "    RegisterControlChangeNotify Basic Scenario",                     0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_PerEndpointEvents_Scenario1,                         "{fa1462ec-cd2c-42d9-90ae-448e568c1a34}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.22.2",   "    UnregisterControlChangeNotify Basic Scenario",                   0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_PerEndpointEvents_Scenario2,                         "{f946d971-b979-454e-a346-bfafe89c43c1}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.22.3",   "    Endpoint Volume Eventing Tests",                                 0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_PerEndpointEvents_Scenario3,                         "{5de6b4ea-139c-4a29-a644-9842f13cca31}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_PARENT( "",         "   Invalid Scenarios",                                               0,                   0,                                                                     0,    NULL,  NULL,                                                   "{e2a82f33-1d19-4152-a7c7-5aaf6763f481}")
    DEVICE_TEST_METHOD( "1.23.1",   "    RegisterControlChangeNotify Invalid Scenario",                   0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_PerEndpointEvents_ScenarioIV1,                       "{b5708f75-8484-485e-b479-abf56fe9435b}")
    DEVICE_TEST_PARENT( "",         "  AudioSession Management",                                          0,                   0,                                                                     0,    NULL,  NULL,                                                   "{b3c3567b-7327-4194-b8d4-528adaf98535}")
    DEVICE_TEST_PARENT( "",         "   GetSessionEnumerator",                                            0,                   0,                                                                     0,    NULL,  NULL,                                                   "{a282fdfc-1caf-48f5-8389-4bf2f607409b}")
    DEVICE_TEST_METHOD( "1.24.1",   "    GetSessionEnumerator: Basic",                                    0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_SessionManagement_GetSessionEnum_Valid1,             "{ec468129-7c2e-461e-b875-ab0811823d4b}")
    DEVICE_TEST_METHOD( "1.24.2",   "    GetSessionEnumerator: Extended",                                 0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_SessionManagement_GetSessionEnum_Valid2,             "{0a89e943-c3d2-46e9-aaa2-228cd7ec1bb2}")
    DEVICE_TEST_METHOD( "1.24.3",   "    GetSessionEnumerator: Multiple New Sessions",                    0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_SessionManagement_GetSessionEnum_Valid3,             "{cfedd3b9-efed-4747-9c88-659e8460f7dc}")
    DEVICE_TEST_PARENT( "",         "   AddSessionNotification",                                          0,                   0,                                                                     0,    NULL,  NULL,                                                   "{15cedf11-f1e5-46e4-9b56-a703f4b4e9e4}")
    DEVICE_TEST_METHOD( "1.25.1",   "    AddSessionNotification: Basic",                                  0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_SessionManagement_AddSessionNotif_Valid1,            "{e5821b54-25ad-4818-96f5-7c1ded48774f}")
    DEVICE_TEST_METHOD( "1.25.2",   "    AddSessionNotification: Audio Stream Arrival",                   0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_SessionManagement_AddSessionNotif_Valid2,            "{8eb516e9-f246-4605-bbd5-45ad92ea260e}")
    DEVICE_TEST_METHOD( "1.25.3",   "    AddSessionNotification: Empty Session",                          0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_SessionManagement_AddSessionNotif_Valid3,            "{e9806ef2-5ae5-4e58-a605-93cb010dc6b8}")
    DEVICE_TEST_METHOD( "1.25.4",   "    AddSessionNotification: Multiple Handlers",                      0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_SessionManagement_AddSessionNotif_Valid4,            "{a2de2608-3a6e-4248-85dd-789bcb23a52d}")
    DEVICE_TEST_PARENT( "",         "   DeleteSessionNotification",                                       0,                   0,                                                                     0,    NULL,  NULL,                                                   "{2bf24326-7cc1-4f3e-b265-f4507f366849}")
    DEVICE_TEST_METHOD( "1.26.1",   "    Basic Verification",                                             0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_SessionManagement_DeleteSessionNotif_Valid1,         "{1c4c3c80-ffea-45e8-bd4f-e34f7c0014f6}")
    DEVICE_TEST_PARENT( "",         "   GetAudioSession",                                                 0,                   0,                                                                     0,    NULL,  NULL,                                                   "{cfcdc52b-e22a-430b-bc28-0a94f0838680}")
    DEVICE_TEST_METHOD( "1.27.1",   "    Get Single New Session",                                         0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_SessionManagement_GetSession_Valid1,                 "{643b4b93-053e-4a9a-b282-dc91732dc638}")
    DEVICE_TEST_METHOD( "1.27.2",   "    Get Single Existing Session",                                    0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_SessionManagement_GetSession_Valid2,                 "{19690685-532e-4e02-be86-20721db5cfcd}")
    DEVICE_TEST_METHOD( "1.27.3",   "    Get Multiple New Sessions",                                      0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_SessionManagement_GetSession_Valid3,                 "{a66e5a9a-59be-4cf3-9bea-2eb2d81efa9e}")
    DEVICE_TEST_METHOD( "1.27.4",   "    Get Multiple Existing Sessions",                                 0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_SessionManagement_GetSession_Valid4,                 "{35662b7c-769e-47d8-a57b-dc5387d0dca2}")
    DEVICE_TEST_PARENT( "",         "   Invalid Scenarios",                                               0,                   0,                                                                     0,    NULL,  NULL,                                                   "{c4b87cf1-29ca-4669-a15e-8ad7d706c135}")
    DEVICE_TEST_METHOD( "1.28.1",   "    AddSessionNotification NULL Param",                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_SessionManagement_AddSessionNotif_Invalid1,          "{706ca987-8ebd-444c-8001-00cf56cf2bc1}")
    DEVICE_TEST_METHOD( "1.28.2",   "    DeleteNotification NULL Param",                                  0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_SessionManagement_DeleteSessionNotif_Invalid1,       "{0bba415c-2c3a-42ad-b2c2-3adfb64aa4e2}")
    DEVICE_TEST_METHOD( "1.28.3",   "    Disconnect Service",                                             0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_SessionManagement_DisconnectService,                 "{5d198da9-2589-4d0d-ac27-a219029ccea6}")
    DEVICE_TEST_PARENT( "",         "  Audio Ducking",                                                    0,                   0,                                                                     0,    NULL,  NULL,                                                   "{c85d74f2-84ce-4fb6-a9c9-be140509b0a3}")
    DEVICE_TEST_PARENT( "",         "   Valid Scenarios",                                                 0,                   0,                                                                     0,    NULL,  NULL,                                                   "{312a963c-80d7-473e-a997-4c0e2886216f}")
    DEVICE_TEST_METHOD( "1.29.1",  "    Notification Subscribe/Unsubscribe Verification",                0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE,                                0,    NULL,  TC_DuckingNotification_BasicSubscription,               "{d11c4043-7cc3-4b1b-8c8b-a6bb894a806a}")
    DEVICE_TEST_METHOD( "1.29.2",  "    Verify Notification Received (Explicit Subscribe)",              0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_DuckingNotification_VerifyExplicitSubscrNotif,       "{acd9f99c-c907-4e1f-ba66-59dab0f86e7b}")
    DEVICE_TEST_METHOD( "1.29.3",  "    Verify Notification Received (Implicit Subscribe)",              0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_DuckingNotification_VerifyImplicitSubscrNotif,       "{e57dad8d-0d9d-4de5-866b-3e7dc410f0ef}")
    DEVICE_TEST_METHOD( "1.29.4",  "    Verify Notification Not Received (Subscribe/Unsubscribe)",       0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE,                                0,    NULL,  TC_DuckingNotification_SubscrUnsubscr,                  "{d8a39525-9f97-4a33-880b-f0fd30ffa76c}")
    DEVICE_TEST_METHOD( "1.29.5",  "    Verify Notification Not Received (No ID Intersection)",          0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_DuckingNotification_NoIDIntersect,                   "{ee010c49-f9aa-411f-9d65-30059d7d989a}")
    DEVICE_TEST_METHOD( "1.29.6",  "    Notifications for Multiple Communications Sessions",             0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE,                                0,    NULL,  TC_DuckingNotification_MultipleCommSessions,            "{d3991498-da3c-475f-b5ef-487f4d5b7cc3}")
    DEVICE_TEST_METHOD( "1.29.7",  "    SetDuckingPreferences Basic Functionality",                      0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE,                                0,    NULL,  TC_Ducking_SetDuckingPreferenceBasic,                   "{fe39d237-d58f-4bcc-af14-6af736817549}")
    DEVICE_TEST_METHOD( "1.29.8",  "    DuckingState E2E Test",                                          0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE,                                0,    NULL,  TC_Ducking_DuckingStateE2E,                             "{bd463eda-1268-4d9c-a41a-002772e3a9f4}")
    DEVICE_TEST_PARENT( "",         "  IAudioClockAdjustment",                                            0,                   0,                                                                     0,    NULL,  NULL,                                                   "{c2e74684-f2aa-485d-9d6c-d3a2c9b43d99}")
    DEVICE_TEST_PARENT( "",         "   Valid Scenarios",                                                 0,                   0,                                                                     0,    NULL,  NULL,                                                   "{8aa47433-d35d-4e44-833d-7acbb6e1b59c}")
    DEVICE_TEST_METHOD( "1.30.1",   "    Various Valid Sample Rates",                                     0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_ClockRateAdjust_Valid1,                              "{359f72f7-694a-4f7b-b45d-ca2b9abe9728}")
    DEVICE_TEST_METHOD( "1.30.2",   "    Loopback verify No SR change",                                   TESTFLAG_DISABLED,   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_ClockRateAdjust_Valid2,                              "{27d92811-c876-4301-ae2e-195cba95d14d}")
    DEVICE_TEST_METHOD( "1.30.3",   "    Loopback verify 1% SR increase",                                 TESTFLAG_DISABLED,   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_ClockRateAdjust_Valid3,                              "{097bd77e-d219-42d9-a9a3-2fdeec581174}")
    DEVICE_TEST_METHOD( "1.30.4",   "    Loopback verify 5% SR increase",                                 TESTFLAG_DISABLED,   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_ClockRateAdjust_Valid4,                              "{d8ea1842-9c4a-40e6-850b-89627cc24d8f}")
    DEVICE_TEST_METHOD( "1.30.5",   "    Loopback verify 10% SR increase",                                TESTFLAG_DISABLED,   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_ClockRateAdjust_Valid5,                              "{77562945-47fb-449c-ac12-62f72069593d}")
    DEVICE_TEST_METHOD( "1.30.6",   "    Loopback verify 1% SR decrease",                                 TESTFLAG_DISABLED,   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_ClockRateAdjust_Valid6,                              "{760ecc6c-e8e5-49e5-9de6-9051e54429b8}")
    DEVICE_TEST_METHOD( "1.30.7",   "    Loopback verify 5% SR decrease",                                 TESTFLAG_DISABLED,   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_ClockRateAdjust_Valid7,                              "{da80dc0b-dd43-4347-8f84-5893f7fb2ccc}")
    DEVICE_TEST_METHOD( "1.30.8",   "    Loopback verify 10% SR decrease",                                TESTFLAG_DISABLED,   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_ClockRateAdjust_Valid8,                              "{14601e1c-1b98-44b3-80d5-c3d6a5cb7459}")
    DEVICE_TEST_PARENT( "",         "   Invalid Scenarios",                                               0,                   0,                                                                     0,    NULL,  NULL,                                                   "{29513f9e-b935-4efe-bac1-d4e956d46b07}")
    DEVICE_TEST_METHOD( "1.31.1",   "    Various Invalid Sample Rates",                                   0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_ClockRateAdjust_Invalid1,                            "{059ff757-b0a7-4477-ab08-cccfbae905ec}")
    DEVICE_TEST_PARENT( "",         "  Generic Activation Tests",                                         0,                   0,                                                                     0,    NULL,  NULL,                                                   "{c2e74684-f2aa-485d-9d6c-d3a2c9b43d99}")
    DEVICE_TEST_PARENT( "",         "   Valid Scenarios",                                                 0,                   0,                                                                     0,    NULL,  NULL,                                                   "{8aa47433-d35d-4e44-833d-7acbb6e1b59c}")
    DEVICE_TEST_METHOD( "1.31.2",   "    Generic Async Activation Testing for All Interfaces",            0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_ActivateAsync_AllApplicable,                         "{efafc8a7-d4e4-46ae-8848-a9e6c234c3b5}")
    DEVICE_TEST_PARENT( "",         " Streaming Tests",                                                   0,                   0,                                                                     0,    NULL,  NULL,                                                   "{764b7650-4ba4-4979-94c5-cb30bbb9d0d5}")
    DEVICE_TEST_PARENT( "",         "  Render Streaming Tests",                                           0,                   0,                                                                     0,    NULL,  NULL,                                                   "{cf008b27-4a2e-455e-b747-0a12c2eb2d2c}")
    DEVICE_TEST_PARENT( "",         "   Shared Mode",                                                     0,                   0,                                                                     0,    NULL,  NULL,                                                   "{195c8cf1-39d1-48fa-a4cf-8250181add23}")
    DEVICE_TEST_PARENT( "",         "    Timer-Push Shared Render",                                       0,                   0,                                                                     0,    NULL,  NULL,                                                   "{73016afb-8e19-458e-9c20-fb0c624ca923}")
    DEVICE_TEST_METHOD( "1.32.1",   "     Shared Mode Render (PUSH)",                                     0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Shared_Push,                                  "{a99fd679-f342-47f0-9603-536956337220}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.32.2",   "     Shared Mode Render w/ SW Loopback Detect (PUSH)",               0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Shared_Push_SWLoopback,                       "{71e950e4-0d49-47e7-a1f2-0c86793cf777}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_PARENT( "",         "    Event-Pull Shared Render",                                       0,                   0,                                                                     0,    NULL,  NULL,                                                   "{73016afb-8e19-458e-9c20-fb0c624ca923}")
    DEVICE_TEST_METHOD( "1.33.1",   "     Shared Mode Render (PULL)",                                     0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Shared_Pull,                                  "{4b4dfcb4-9d86-4bfe-b426-25a5c9e754f0}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.33.2",   "     Shared Mode Render w/ SW Loopback Detect (PULL)",               0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Shared_Pull_SWLoopback,                       "{37f0d510-7e33-4c61-9767-8150b81dbb7c}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_PARENT( "",         "   Compat Mode",                                                     0,                   0,                                                                     0,    NULL,  NULL,                                                   "{e6431d24-784d-4497-8d48-c7503e7a62af}")
    DEVICE_TEST_PARENT( "",         "    Timer-Push Compat Render",                                       0,                   0,                                                                     0,    NULL,  NULL,                                                   "{e6f7baa1-1314-4bba-ad61-e82d6576c0e7}")
    DEVICE_TEST_METHOD( "1.34.1",   "     192K / 32-bit / 1 ch WAVEFORMATEX",                             0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_0,                                "{ee9ea74b-7088-48c2-b1c1-09db377d095e}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.2",   "     11K / 8-bit / 1 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_1,                                "{77ee3d6f-f96f-40f1-b333-5a3017af6dae}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.3",   "     22K / 32-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_2,                                "{fb21497b-461d-4412-9c86-9d3ff3819a66}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.4",   "     3K / 16-bit / 2 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_3,                                "{ccca4c74-8e85-46b4-ae79-8d0e12ce81f6}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.5",   "     96K / 24-bit / 1 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_4,                                "{49561eac-522a-44cb-add8-b0138d5c2796}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.6",   "     64K / 8-bit / 1 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_5,                                "{32bb3f84-ff9e-4a23-a366-8b55fa58c332}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.7",   "     96K / 8-bit / 2 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_6,                                "{22ec3a7e-dd82-4745-b4f5-b975d68a65f1}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.8",   "     96K / 8-bit / 2 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_7,                                "{90cb5a16-2411-485a-8c9c-7be10e84960a}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.9",   "     48K / 24-bit / 1 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_8,                                "{e38d09be-98a5-43f2-9f24-722b6d5b1e96}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.10",  "     48K / 16-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_9,                                "{95084f31-591a-4e66-a98b-882233d1a2eb}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.11",  "     64K / 32-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_10,                               "{464bdeab-059a-42bc-9305-289e3c00bf4b}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.12",  "     11.025K / 24-bit / 2 ch WAVEFORMATEX",                          0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_11,                               "{216189a4-d1ec-459d-880b-11fa6be3a1a1}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.13",  "     192K / 16-bit / 2 ch WAVEFORMATEX",                             0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_12,                               "{62a83353-331d-4c8d-96db-b0fe1ff46c70}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.14",  "     8K / 24-bit / 1 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_13,                               "{12aae071-5b88-4824-a92b-b07c417b0286}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.15",  "     44.1K / 32-bit / 2 ch WAVEFORMATEX",                            0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_14,                               "{f9bb4dde-7343-4d78-ba10-2b9c07180869}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.16",  "     32K / 8-bit / 2 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_15,                               "{8bfa4f00-9706-42d7-86c8-ec8e045c6188}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.17",  "     32K / 24-bit / 1 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_16,                               "{a5f0bed5-aa3d-427c-86cd-de2fee324eb9}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.18",  "     44.1K / 8-bit / 1 ch WAVEFORMATEX",                             0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_17,                               "{aa28e9a0-a6a3-4b32-87b4-a6300039aa32}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.19",  "     3K / 24-bit / 1 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_18,                               "{2ed85b62-ad7f-47fa-a172-6e13e168d731}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.20",  "     22.05K / 16-bit / 1 ch WAVEFORMATEX",                           0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_19,                               "{0fa2b456-dc01-4a8e-bdff-8441ff3ccebd}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.21",  "     48K / 24-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_20,                               "{4cb4017c-7374-4358-ad2a-76e978844868}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.22",  "     48K / 32-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_21,                               "{1031f9de-e510-4f12-8083-a4ecba14926f}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.23",  "     44.1K / 16-bit / 2 ch WAVEFORMATEX",                            0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_22,                               "{5c972cd3-6e70-4f5c-b69d-b8f2109ae16d}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.24",  "     96K / 16-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_23,                               "{b7ac547f-ce30-47be-81e1-979d20acced3}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.25",  "     16K / 16-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_24,                               "{1a10f4fc-6f29-4574-bea6-997a901dae2e}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.26",  "     11.025K / 16-bit / 2 ch WAVEFORMATEX",                          0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_25,                               "{42404f13-05e0-4a33-8637-67a7163921a6}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.27",  "     22.05 / 16-bit / 2 ch WAVEFORMATEX",                            0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_26,                               "{11f9791c-f399-4799-9e52-7eac0492c092}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.28",  "     64K / 16-bit / 8 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_27,                               "{b141634e-c6ae-4bfb-aa11-b1d06c51fd96}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.29",  "     16K / 24-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_28,                               "{97bbef63-2faa-4360-a932-b93c18de547e}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.30",  "     64K / 24-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_29,                               "{368f1e0e-ddd0-4e63-ab81-4766a89bd1c4}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.31",  "     11.025K / 32-bit / 8 ch WAVEFORMATEXENSIBLE",                   0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_30,                               "{9f74c25a-c805-4c81-9353-0a711b0f9caa}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.32",  "     32K / 16-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_31,                               "{a67c871b-8b60-432d-b740-211055724ddd}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.33",  "     3K / 8-bit / 8 ch WAVEFORMATEXENSIBLE",                         0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_32,                               "{26836531-141a-41f1-ae29-cc139bd61831}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.34",  "     88.2K / 32-bit / 6 ch WAVEFORMATEXENSIBLE",                     0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_33,                               "{4cd37f05-e30b-4395-bd6b-b10110b117b5}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.35",  "     96K / 32-bit / 8 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_34,                               "{d468ddf1-fe92-4f5d-98ba-551e865a9d15}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.36",  "     16K / 8-bit / 6 ch WAVEFORMATEXENSIBLE",                        0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_35,                               "{99da6e3d-369c-4c49-a4c0-079a2a994bfb}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.37",  "     3K / 32-bit / 6 ch WAVEFORMATEXENSIBLE",                        0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_36,                               "{edb8261e-d478-49ee-b251-d731470cb6c1}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.38",  "     8K / 8-bit / 6 ch WAVEFORMATEXENSIBLE",                         0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_37,                               "{b52b4e7f-f4e7-4faa-a4db-5889dbb7406b}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.39",  "     48K / 8-bit / 8 ch WAVEFORMATEXENSIBLE",                        0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_38,                               "{44d4705c-8845-4489-99d9-a157cb395528}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.40",  "     96K / 16-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_39,                               "{4e40e46d-12a4-41c9-9485-78770880cb12}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.41",  "     11.025K / 16-bit / 6 ch WAVEFORMATEXENSIBLE",                   0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_40,                               "{c7b64d9e-f5f5-4fc9-971d-36b02e7d7ed6}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.42",  "     192K / 24-bit / 8 ch WAVEFORMATEXENSIBLE",                      0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_41,                               "{107ead51-1df5-4e2c-84ae-4f02312ac427}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.43",  "     8K / 32-bit / 8 ch WAVEFORMATEXENSIBLE",                        0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_42,                               "{709ec033-a880-4a82-84fb-ca397beeb66c}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.44",  "     88.2K / 24-bit / 24 ch WAVEFORMATEXENSIBLE",                    0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_43,                               "{7e0c7db2-b1bd-4733-b5a0-053e8d50e39e}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.45",  "     22.05K / 24-bit / 8 ch WAVEFORMATEXENSIBLE",                    0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_44,                               "{cff1c2d2-2462-4996-ac58-b56f9369d010}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.46",  "     48K / 32-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_45,                               "{22c50f67-a604-4d5e-81de-dd1f1c0a94dc}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.47",  "     192K / 8-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_46,                               "{ed5aa5f7-9817-44c1-9743-10e2a85755a5}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.48",  "     32K / 32-bit / 8 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_47,                               "{47ad6694-e19e-493e-9504-e3700b88b6f9}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.49",  "     44.1K / 24-bit / 6 ch WAVEFORMATEXENSIBLE",                     0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_48,                               "{de238bad-6236-43cd-a6b0-47ceb69e0f19}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.50",  "     22.05K / 8-bit / 6 ch WAVEFORMATEXENSIBLE",                     0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_49,                               "{74c41635-6854-481b-8828-718576bb7581}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.51",  "     44.1K / 16-bit / 8 ch WAVEFORMATEXENSIBLE",                     0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_50,                               "{efdef549-da84-42ff-a2cf-19dfb46c0906}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.52",  "     16K / 32-bit / 32 ch WAVEFORMATEXENSIBLE",                      0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_51,                               "{988814c8-abab-4ba6-8f00-687368fd7075}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.53",  "     88.2K / 8-bit / 8 ch WAVEFORMATEXENSIBLE",                      0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_52,                               "{5f3f3138-9f13-427b-af37-e639176d6f34}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.54",  "     16K / 16-bit / 16 ch WAVEFORMATEXENSIBLE",                      0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_53,                               "{09c43cda-9e65-4300-a728-d3af5099c40a}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.55",  "     48K / 32-bit (20) / 2 ch WAVEFORMATEXENSIBLE",                  0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_54,                               "{3c1d4a08-9dc0-4dd8-9f20-27bb1704fb58}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.56",  "     48K / 32-bit (24) / 2 ch WAVEFORMATEXENSIBLE",                  0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_55,                               "{13cca1bc-2c1c-437f-bff9-79a9b578ad47}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.57",  "     48K / 32-bit (32) / 2 ch WAVEFORMATEXENSIBLE",                  0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_56,                               "{6d63f55a-ee77-4fc5-9e7d-5d2eec5ed52d}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.58",  "     48K / 16-bit / 4 ch (QUAD) WAVEFORMATEXENSIBLE",                0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_57,                               "{2879dd34-c4c4-4602-b990-a2f584076775}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.59",  "     48K / 16-bit / 4 ch (SURROUND WAVEFORMATEXENSIBLE",             0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_58,                               "{e0ccd53e-7feb-47e8-a4ed-cc25b2cb6eb0}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.60",  "     48K / 16-bit / 6 ch (5.1) WAVEFORMATEXENSIBLE",                 0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_59,                               "{b9403cac-6645-4f37-aee2-3a35775be3af}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.61",  "     48K / 16-bit / 8 ch (7.1) WAVEFORMATEXENSIBLE",                 0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_60,                               "{44753284-c731-44da-84ad-261a6bcc2edb}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.62",  "     48K / 16-bit / 1 ch (MONO) WAVEFORMATEXENSIBLE",                0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_61,                               "{00756012-d07d-4083-9707-0baf2b557eff}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.34.63",  "     48K / 16-bit / 2 ch (STEREO) WAVEFORMATEXENSIBLE",              0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_Push_62,                               "{809cbeaf-10f8-43df-874e-99eda0c40385}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_PARENT( "",         "    Event-Pull Compat Render",                                       0,                   0,                                                                     0,    NULL,  NULL,                                                   "{7e01db3f-e7a4-400a-8179-5d3bb09351d9}")
    DEVICE_TEST_METHOD( "1.35.1",   "     192K / 32-bit / 1 ch WAVEFORMATEX",                             0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_0,                                "{8bc6a570-28c9-4580-bed7-d567e900a34f}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.2",   "     11K  / 8-bit / 1 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_1,                                "{dac831ad-ebac-4879-b6bc-2be1ed12d9c1}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.3",   "     22K / 32-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_2,                                "{33fe2e76-25ba-4ed8-a395-e7d738215fcb}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.4",   "     3K / 16-bit / 2 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_3,                                "{51f2fa9f-4674-47d9-9570-46d40bfc5347}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.5",   "     82.2K / 16-bit / 1 ch WAVEFORMATEX",                            0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_4,                                "{a964495f-7755-43ec-a94e-3edf248a80cc}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.6",   "     96K / 24-bit / 1 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_5,                                "{34f96c3f-47bb-4650-8f1f-df225627e1b6}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.7",   "     64K / 8-bit / 1 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_6,                                "{f41ac99b-ef2f-4397-a663-cf2fcaf22a47}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.8",   "     96K / 8-bit / 2 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_7,                                "{421854b9-44c4-4b71-9f52-6e62cb1c4ffd}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.9",   "     48K / 24-bit / 1 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_8,                                "{dcf26e76-41a1-4993-beaa-ea5d8a2f3526}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.10",  "     48K / 16-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_9,                                "{7a9ca517-6cf3-4265-ac6f-384935dc525b}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.11",  "     64K / 32-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_10,                               "{4e655cb3-9139-4fe4-937f-910513134178}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.12",  "     11.025K / 24-bit / 2 ch WAVEFORMATEX",                          0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_11,                               "{fff829fa-2cff-4de4-8ee5-87631bc4f3a1}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.13",  "     192K / 16-bit / 2 ch WAVEFORMATEX",                             0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_12,                               "{e6c37d49-c250-4588-aca0-c55d56064fdc}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.14",  "     8K / 24-bit / 1 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_13,                               "{f26109c7-da7d-4c3c-9237-268ef5dd3559}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.15",  "     44.1K / 32-bit / 2 ch WAVEFORMATEX",                            0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_14,                               "{336e3644-bd60-4ab9-8b17-15b226c2317d}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.16",  "     32K / 8-bit / 2 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_15,                               "{818e44e9-2125-4c8e-8dd7-ab36c0ff523b}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.17",  "     32K / 24-bit / 1 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_16,                               "{ba374a6e-a46d-4b57-9a74-6388807353a7}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.18",  "     44.1K / 8-bit / 1 ch WAVEFORMATEX",                             0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_17,                               "{3969d898-9923-4848-b59a-9ced13b82085}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.19",  "     3K / 24-bit / 1 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_18,                               "{b4cdb486-4a26-46d5-b8b4-ebc54c8b5b8c}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.20",  "     22.05K / 16-bit / 1 ch WAVEFORMATEX",                           0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_19,                               "{d150b890-c0d5-40e4-8266-23cf4858b79d}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.21",  "     48K / 24-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_20,                               "{a35f960a-3302-49a7-8c01-aafe15f1a243}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.22",  "     48K / 32-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_21,                               "{3469f2c1-7b2f-434e-9688-10dba7afcbcf}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.23",  "     44.1K / 16-bit / 2 ch WAVEFORMATEX",                            0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_22,                               "{30eb52da-c473-4760-8cba-84a0f0ecc21a}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.24",  "     96K / 16-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_23,                               "{87557b4a-e6b6-4983-9445-c31ae50ffccf}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.25",  "     16K / 16-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_24,                               "{82c63455-b753-4e32-96c4-4a72a8c847e4}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.26",  "     11.025K / 16-bit / 2 ch WAVEFORMATEX",                          0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_25,                               "{bf0485ad-42d5-489c-9a0d-52d55935c09d}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.27",  "     22.05 / 16-bit / 2 ch WAVEFORMATEX",                            0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_26,                               "{2c192424-4195-4073-a3da-a0f4a5ee3e2e}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.28",  "     64K / 16-bit / 8 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_27,                               "{6831ea42-afe8-4c6a-aba6-53b90555e362}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.29",  "     16K / 24-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_28,                               "{5e7b4870-bd3a-45fb-862d-b5e35bf43256}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.30",  "     64K / 24-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_29,                               "{0c6fc59d-9136-4f97-a6e7-207001273717}")        
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.31",  "     11.025K / 32-bit / 8 ch WAVEFORMATEXENSIBLE",                   0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_30,                               "{d0c9fbe5-61b0-4610-a879-d0e710105f9d}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.32",  "     32K / 16-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_31,                               "{34358e68-5e34-475b-b453-8352926a2749}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.33",  "     3K / 8-bit / 8 ch WAVEFORMATEXENSIBLE",                         0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_32,                               "{8347a320-d950-427b-9f37-dea03d3a1231}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.34",  "     88.2K / 32-bit / 6 ch WAVEFORMATEXENSIBLE",                     0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_33,                               "{4164a2f0-cb99-44eb-9a0b-d1a2e87b3a7a}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.35",  "     96K / 32-bit / 8 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_34,                               "{e95d624c-6983-4b62-8821-23ce1bab4df1}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.36",  "     16K / 8-bit / 6 ch WAVEFORMATEXENSIBLE",                        0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_35,                               "{115ec17b-30c3-4ece-957d-63d6f5036d58}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.37",  "     3K / 32-bit / 6 ch WAVEFORMATEXENSIBLE",                        0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_36,                               "{d501259e-4c10-4265-b1c6-82f9014f6c50}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.38",  "     8K / 8-bit / 6 ch WAVEFORMATEXENSIBLE",                         0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_37,                               "{a8f20f55-60a0-4a95-a0f6-9668275f2a83}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.39",  "     48K / 8-bit / 8 ch WAVEFORMATEXENSIBLE",                        0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_38,                               "{67b59afd-b792-47c2-8f2b-6d72e625b1d5}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.40",  "     96K / 16-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_39,                               "{49c71d27-cc78-483d-8633-1e113e66adee}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.41",  "     11.025K / 16-bit / 6 ch WAVEFORMATEXENSIBLE",                   0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_40,                               "{d096285f-b5fb-4792-9c73-f5e5f66a0039}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.42",  "     192K / 24-bit / 8 ch WAVEFORMATEXENSIBLE",                      0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_41,                               "{e3cbf208-ad8f-40de-a7ae-ea9a4372f5a0}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.43",  "     8K / 32-bit / 8 ch WAVEFORMATEXENSIBLE",                        0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_42,                               "{f878de39-d445-43cf-b485-be924810f1d0}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.44",  "     88.2K / 24-bit / 24 ch WAVEFORMATEXENSIBLE",                    0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_43,                               "{35059151-80de-42ae-82a6-9d3a765dfcb5}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.45",  "     22.05K / 24-bit / 8 ch WAVEFORMATEXENSIBLE",                    0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_44,                               "{02a6ced3-3492-4300-a31a-ae3ad3e913f8}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.46",  "     48K / 32-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_45,                               "{c83d90eb-c223-459d-9f84-8fb9f392391b}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.47",  "     192K / 8-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_46,                               "{1e3deab4-2299-46a4-8075-1ca679a7b11f}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.48",  "     32K / 32-bit / 8 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_47,                               "{8f70d418-e85a-4b9d-b54a-b7c29f0017cc}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.49",  "     44.1K / 24-bit / 6 ch WAVEFORMATEXENSIBLE",                     0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_48,                               "{584d2168-d1a0-4601-9002-074cb7a9da93}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.50",  "     22.05K / 8-bit / 6 ch WAVEFORMATEXENSIBLE",                     0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_49,                               "{023be427-71cb-4ce2-86fe-bda787e24f27}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.51",  "     44.1K / 16-bit / 8 ch WAVEFORMATEXENSIBLE",                     0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_50,                               "{4a58fcb5-bdab-41a2-90f9-b48191070462}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.52",  "     16K / 32-bit / 32 ch WAVEFORMATEXENSIBLE",                      0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_51,                               "{43599704-1f42-4b63-afa0-a14e640c8d7f}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.53",  "     88.2K / 8-bit / 8 ch WAVEFORMATEXENSIBLE",                      0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_52,                               "{b14ae76e-e067-48f5-ac63-5f99f4f8cac8}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.54",  "     16K / 16-bit / 16 ch WAVEFORMATEXENSIBLE",                      0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_53,                               "{2e282536-8008-4acc-a49e-20d5cc7ee7fa}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.55",  "     48K / 32-bit (20) / 2 ch WAVEFORMATEXENSIBLE",                  0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_54,                               "{81135fac-e96e-4532-856c-ca4571c7a269}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.56",  "     48K / 32-bit (24) / 2 ch WAVEFORMATEXENSIBLE",                  0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_55,                               "{0e491063-efdc-4375-8e36-e5b2abe57e8f}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.57",  "     48K / 32-bit (32) / 2 ch WAVEFORMATEXENSIBLE",                  0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_56,                               "{89b952f9-882a-4feb-a2e8-34ebd6afae32}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.58",  "     48K / 16-bit / 4 ch (QUAD) WAVEFORMATEXENSIBLE",                0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_57,                               "{9db35044-9207-46af-ac62-f928b3f79741}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.59",  "     48K / 16-bit / 4 ch (SURROUND WAVEFORMATEXENSIBLE",             0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_58,                               "{f5eaa2b2-8ac3-4a4c-8760-8cbc4a511760}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.60",  "     48K / 16-bit / 6 ch (5.1) WAVEFORMATEXENSIBLE",                 0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_59,                               "{0be645a0-1ca9-4c61-ba59-f72fd60bd498}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.61",  "     48K / 16-bit / 8 ch (7.1) WAVEFORMATEXENSIBLE",                 0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_60,                               "{7159c809-97f3-46a4-9a08-787ee302bc4e}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.62",  "     48K / 16-bit / 1 ch (MONO) WAVEFORMATEXENSIBLE",                0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_61,                               "{254ed46b-6ed3-432d-9154-fba84e7cc237}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.35.63",  "     48K / 16-bit / 2 ch (STEREO) WAVEFORMATEXENSIBLE",              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_Pull_62,                               "{3887302e-939d-4287-a309-8d8a55aceadc}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_PARENT( "",         "   Compat Mode (SRC Default Quality)",                               0,                   0,                                                                     0,    NULL,  NULL,                                                   "{D1DC92D1-474D-4CF1-88A5-57C1E2B0150F}")
    DEVICE_TEST_PARENT( "",         "    Timer-Push Compat Render",                                       0,                   0,                                                                     0,    NULL,  NULL,                                                   "{F1181ABA-8173-4775-9E6A-AE8B9C549C73}")
    DEVICE_TEST_METHOD( "1.36.1",   "     192K / 32-bit / 1 ch WAVEFORMATEX",                             0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_0,                   "{CC5B894B-F287-4925-A962-FAC3C81FBC2A}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.2",   "     11K / 8-bit / 1 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_1,                   "{29068163-4F14-4717-B1BB-2004E833CAF3}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.3",   "     22K / 32-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_2,                   "{4A66DC07-E9A6-4F9B-BD81-6050C293A60F}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.4",   "     3K / 16-bit / 2 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_3,                   "{EEE4638B-DCE1-4B4D-8BFB-E42FF161C33F}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.5",   "     96K / 24-bit / 1 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_4,                   "{A3A0247D-A382-46D2-BE98-8B04427B2FA2}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.6",   "     64K / 8-bit / 1 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_5,                   "{E38AE93C-0CB6-4540-B68F-0F705915596E}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.7",   "     96K / 8-bit / 2 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_6,                   "{0A694001-64D5-4D34-B864-86FEF15C0F83}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.8",   "     96K / 8-bit / 2 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_7,                   "{388A1F85-3FAD-42FF-9088-9B203B114C8D}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.9",   "     48K / 24-bit / 1 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_8,                   "{C9724D72-A3F6-43AA-89F4-9AA64530853A}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.10",  "     48K / 16-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_9,                   "{B2DF4413-268E-4199-BF85-E32F03559707}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.11",  "     64K / 32-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_10,                  "{F8435BA0-FDBC-4C82-9ED6-8678859BA399}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.12",  "     11.025K / 24-bit / 2 ch WAVEFORMATEX",                          0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_11,                  "{4C441EFC-FE88-494D-98F1-1C9787DD90ED}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.13",  "     192K / 16-bit / 2 ch WAVEFORMATEX",                             0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_12,                  "{2A43D6A6-31C5-49E1-843A-9F54E003F220}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.14",  "     8K / 24-bit / 1 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_13,                  "{3DDFAE6F-5CCF-4633-A4C3-1A77B01A3183}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.15",  "     44.1K / 32-bit / 2 ch WAVEFORMATEX",                            0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_14,                  "{7ED7E407-4EFE-4D0F-A6A7-9EDF2B8CEB4D}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.16",  "     32K / 8-bit / 2 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_15,                  "{21590605-4601-4231-9592-5DADF6CE0926}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.17",  "     32K / 24-bit / 1 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_16,                  "{02808CFF-935B-4526-9B65-AB85399C3CE3}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.18",  "     44.1K / 8-bit / 1 ch WAVEFORMATEX",                             0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_17,                  "{EE42F0B2-683E-4721-8AA0-FE318BEC9C46}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.19",  "     3K / 24-bit / 1 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_18,                  "{DCA01767-86C8-4C0A-B7F5-B36BDCCC2A9E}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.20",  "     22.05K / 16-bit / 1 ch WAVEFORMATEX",                           0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_19,                  "{D9B0B902-D6F2-4226-895A-64A19FA17E20}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.21",  "     48K / 24-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_20,                  "{96AEF1E8-323F-430F-8263-C6422DFEB06B}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.22",  "     48K / 32-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_21,                  "{0DD531E5-7E4C-4338-9B09-06F1C02AC8ED}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.23",  "     44.1K / 16-bit / 2 ch WAVEFORMATEX",                            0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_22,                  "{EA237332-7B33-4E71-B60D-DFE8E260443C}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.24",  "     96K / 16-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_23,                  "{B0B1CECD-D0A4-4AAE-9973-61E5ACBB4F42}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.25",  "     16K / 16-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_24,                  "{E1489762-1A48-4555-A763-8FF5D2D0E0C3}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.26",  "     11.025K / 16-bit / 2 ch WAVEFORMATEX",                          0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_25,                  "{4373544E-EF30-4F9B-AAE0-88A177E79AC2}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.27",  "     22.05 / 16-bit / 2 ch WAVEFORMATEX",                            0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_26,                  "{FF9570B1-1A44-4ECC-BA71-8D5FC6156E1F}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.28",  "     64K / 16-bit / 8 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_27,                  "{CF438649-85FB-4CF4-97E0-96794AC7C478}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.29",  "     16K / 24-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_28,                  "{11977072-6505-44A4-9E1A-49E43C75DE41}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.30",  "     64K / 24-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_29,                  "{4218F394-28E2-45DA-95CB-5EC2165A31E4}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.31",  "     11.025K / 32-bit / 8 ch WAVEFORMATEXENSIBLE",                   0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_30,                  "{DB949024-7CF5-4CE9-9890-2D75FEBD6ED6}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.32",  "     32K / 16-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_31,                  "{57CADCC9-35C1-4AD7-914A-52F863EAC518}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.33",  "     3K / 8-bit / 8 ch WAVEFORMATEXENSIBLE",                         0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_32,                  "{FE4C105B-21E9-4338-8A1A-6C9BF7009E51}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.34",  "     88.2K / 32-bit / 6 ch WAVEFORMATEXENSIBLE",                     0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_33,                  "{4288C12A-697D-4301-8596-8A1293F5E810}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.35",  "     96K / 32-bit / 8 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_34,                  "{2BAD204A-D2B6-4989-B2AE-E5821C7AF9CE}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.36",  "     16K / 8-bit / 6 ch WAVEFORMATEXENSIBLE",                        0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_35,                  "{F27CA130-510E-457D-9434-21F7622B2C2E}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.37",  "     3K / 32-bit / 6 ch WAVEFORMATEXENSIBLE",                        0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_36,                  "{09980740-F5B7-4261-BD89-1BC44300DB37}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.38",  "     8K / 8-bit / 6 ch WAVEFORMATEXENSIBLE",                         0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_37,                  "{071E9C03-EA96-4682-9DFF-C5BD62DDB4B1}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.39",  "     48K / 8-bit / 8 ch WAVEFORMATEXENSIBLE",                        0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_38,                  "{C7EB4DFB-BEB1-4E35-B3C4-FBEE922853EF}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.40",  "     96K / 16-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_39,                  "{603E1563-00DD-4450-9562-E39F71825619}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.41",  "     11.025K / 16-bit / 6 ch WAVEFORMATEXENSIBLE",                   0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_40,                  "{8C2BAB1B-24B0-4E5D-9374-866FE7D60A9D}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.42",  "     192K / 24-bit / 8 ch WAVEFORMATEXENSIBLE",                      0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_41,                  "{75BA40BF-D234-4858-B76D-EC4B4E8249CC}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.43",  "     8K / 32-bit / 8 ch WAVEFORMATEXENSIBLE",                        0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_42,                  "{EB71F17E-F674-4AFA-A738-10A50FFC979D}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.44",  "     88.2K / 24-bit / 24 ch WAVEFORMATEXENSIBLE",                    0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_43,                  "{7AA021B1-9F7A-41D5-BE93-F8116D181AD9}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.45",  "     22.05K / 24-bit / 8 ch WAVEFORMATEXENSIBLE",                    0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_44,                  "{044E128F-E041-419D-BEDA-734B6F7EDA6F}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.46",  "     48K / 32-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_45,                  "{26F3B53E-E59B-4D86-BC13-E7941D231CBC}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.47",  "     192K / 8-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_46,                  "{D6EFAEAF-B10B-41E5-9B07-4FDC201643A6}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.48",  "     32K / 32-bit / 8 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_47,                  "{8D841F9D-4323-45E9-8884-94FA1A71EE36}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.49",  "     44.1K / 24-bit / 6 ch WAVEFORMATEXENSIBLE",                     0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_48,                  "{E7C1EFAC-CB05-472E-A325-A1D663B682F0}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.50",  "     22.05K / 8-bit / 6 ch WAVEFORMATEXENSIBLE",                     0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_49,                  "{B016E598-4515-4F26-A032-996BE0FB97BE}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.51",  "     44.1K / 16-bit / 8 ch WAVEFORMATEXENSIBLE",                     0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_50,                  "{97F7D825-B8DC-4BAC-9512-6EFFC11408EF}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.52",  "     16K / 32-bit / 32 ch WAVEFORMATEXENSIBLE",                      0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_51,                  "{737F3440-3BB0-4414-8DD3-C45833682AFC}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.53",  "     88.2K / 8-bit / 8 ch WAVEFORMATEXENSIBLE",                      0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_52,                  "{77F15EA7-3C05-49DC-9972-7C0DD182DACF}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.54",  "     16K / 16-bit / 16 ch WAVEFORMATEXENSIBLE",                      0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_53,                  "{FFFC8008-84D8-49FF-80B6-4091E062C1A8}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.55",  "     48K / 32-bit (20) / 2 ch WAVEFORMATEXENSIBLE",                  0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_54,                  "{8AA56BB6-2FE4-4B25-85A3-1636B329E347}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.56",  "     48K / 32-bit (24) / 2 ch WAVEFORMATEXENSIBLE",                  0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_55,                  "{BE640B3A-6FA3-47D4-922C-2BDC71C93FDC}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.57",  "     48K / 32-bit (32) / 2 ch WAVEFORMATEXENSIBLE",                  0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_56,                  "{1380072A-34F9-48CD-B9F5-7D7BA74E6E55}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.58",  "     48K / 16-bit / 4 ch (QUAD) WAVEFORMATEXENSIBLE",                0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_57,                  "{6D710A6F-3B22-4709-9D5C-9448A085743A}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.59",  "     48K / 16-bit / 4 ch (SURROUND WAVEFORMATEXENSIBLE",             0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_58,                  "{328F9A79-2FFA-4BD2-ADF4-AA1D4B990F91}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.60",  "     48K / 16-bit / 6 ch (5.1) WAVEFORMATEXENSIBLE",                 0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_59,                  "{185F4C28-2FFD-43FD-80EF-DB0C6752D2CD}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.61",  "     48K / 16-bit / 8 ch (7.1) WAVEFORMATEXENSIBLE",                 0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_60,                  "{6E3A485B-AA9B-400F-A5DD-2260F31C2233}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.62",  "     48K / 16-bit / 1 ch (MONO) WAVEFORMATEXENSIBLE",                0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_61,                  "{1D0CDF47-6ADC-4BD2-AC26-D364B0923099}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.36.63",  "     48K / 16-bit / 2 ch (STEREO) WAVEFORMATEXENSIBLE",              0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Render_Compat_SRC_Enhanced_Push_62,                  "{FAE7A85E-A425-4DD1-8452-2FA16675CDC8}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_PARENT( "",         "    Event-Pull Compat Render",                                       0,                   0,                                                                     0,    NULL,  NULL,                                                   "{13AA528E-272D-4BCD-8031-7E58317052D5}")
    DEVICE_TEST_METHOD( "1.37.1",   "     192K / 32-bit / 1 ch WAVEFORMATEX",                             0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_0,                   "{F5FB297B-9A8C-4870-B16B-952332001FB4}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.2",   "     11K  / 8-bit / 1 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_1,                   "{C39C121F-5880-47CE-91A0-AAD376754A8C}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.3",   "     22K / 32-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_2,                   "{634015A9-014E-4BAD-A6A4-727C20650F07}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.4",   "     3K / 16-bit / 2 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_3,                   "{66B88C43-C041-4DB9-AAA6-712FC8989CA0}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.5",   "     82.2K / 16-bit / 1 ch WAVEFORMATEX",                            0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_4,                   "{2AEFD97B-30FC-488E-88D3-188A69F1C199}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.6",   "     96K / 24-bit / 1 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_5,                   "{18F3A53D-2214-4FED-A003-108946DA7D48}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.7",   "     64K / 8-bit / 1 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_6,                   "{507CB65C-35C3-41E3-B388-CFE02322850A}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.8",   "     96K / 8-bit / 2 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_7,                   "{76844303-F6AB-4451-8E9D-A62139BE705E}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.9",   "     48K / 24-bit / 1 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_8,                   "{BD50B948-27C5-4EDA-90BE-F4AC9091A000}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.10",  "     48K / 16-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_9,                   "{73086268-E39D-4530-95C5-44A3D5290251}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.11",  "     64K / 32-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_10,                  "{866A6D0B-3BFE-491F-9EA2-C7537D664D9D}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.12",  "     11.025K / 24-bit / 2 ch WAVEFORMATEX",                          0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_11,                  "{CB41C8A3-6CF0-45CA-9088-4AE2CE9F7905}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.13",  "     192K / 16-bit / 2 ch WAVEFORMATEX",                             0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_12,                  "{DBF6D664-D472-4F7A-AB82-C430C126EC31}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.14",  "     8K / 24-bit / 1 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_13,                  "{B2F19BE0-4203-4BD7-8682-D3177A923B52}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.15",  "     44.1K / 32-bit / 2 ch WAVEFORMATEX",                            0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_14,                  "{383CD8C2-2EA8-482A-B09C-C2FB95240C29}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.16",  "     32K / 8-bit / 2 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_15,                  "{85551F32-E030-4D53-AD25-48EA55B11D58}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.17",  "     32K / 24-bit / 1 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_16,                  "{CA545A74-858A-4FA3-AA6F-E6839C0F18F5}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.18",  "     44.1K / 8-bit / 1 ch WAVEFORMATEX",                             0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_17,                  "{AA2D15E1-8DCF-4E11-B04D-779F451F8271}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.19",  "     3K / 24-bit / 1 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_18,                  "{4E4DD7FA-7380-456B-B51B-6FCAA474405D}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.20",  "     22.05K / 16-bit / 1 ch WAVEFORMATEX",                           0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_19,                  "{10F943CA-3AC1-4B66-B4CE-0AF4C2B57ABD}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.21",  "     48K / 24-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_20,                  "{E2F7A91A-3C3B-4AEA-9553-0DF91A089B8C}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.22",  "     48K / 32-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_21,                  "{68B2A0A8-D333-4A11-9DD2-87487F148923}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.23",  "     44.1K / 16-bit / 2 ch WAVEFORMATEX",                            0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_22,                  "{742C8EFE-34D6-432F-AA65-55FA3111DB9C}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.24",  "     96K / 16-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_23,                  "{6D664A7B-F0D0-44E9-93B3-37A7F2A0C241}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.25",  "     16K / 16-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_24,                  "{812904BE-F489-4A4C-9C41-6BDFBE9E948E}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.26",  "     11.025K / 16-bit / 2 ch WAVEFORMATEX",                          0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_25,                  "{AFB03332-0701-4616-8009-952B9DE06BDE}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.27",  "     22.05 / 16-bit / 2 ch WAVEFORMATEX",                            0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_26,                  "{CB83AA11-9EE9-4BED-8D7E-5CD1D5854228}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.28",  "     64K / 16-bit / 8 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_27,                  "{5CC945E9-F84B-404F-8B4F-15905149608C}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.29",  "     16K / 24-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_28,                  "{207A677E-9975-4A6D-9951-48B329CAA092}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.30",  "     64K / 24-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_29,                  "{63F32D19-4AE1-4A5B-A6B0-DCC43D44BBA7}")        
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.31",  "     11.025K / 32-bit / 8 ch WAVEFORMATEXENSIBLE",                   0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_30,                  "{95379756-08AE-403E-9F0B-C246B2171034}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.32",  "     32K / 16-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_31,                  "{43CFCE22-FB0A-414B-A714-526F006F96CC}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.33",  "     3K / 8-bit / 8 ch WAVEFORMATEXENSIBLE",                         0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_32,                  "{92381706-F3A7-498D-960E-CB9B93494C5D}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.34",  "     88.2K / 32-bit / 6 ch WAVEFORMATEXENSIBLE",                     0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_33,                  "{183B55A1-7F2D-44E1-AB5E-EBA3362F0C71}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.35",  "     96K / 32-bit / 8 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_34,                  "{06E209AD-E45A-4B6C-804C-326D3406B841}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.36",  "     16K / 8-bit / 6 ch WAVEFORMATEXENSIBLE",                        0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_35,                  "{25614013-7FEE-4A7E-A8C2-4998267DD599}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.37",  "     3K / 32-bit / 6 ch WAVEFORMATEXENSIBLE",                        0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_36,                  "{53231AC5-59DB-4FB4-947C-0C4D692F5595}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.38",  "     8K / 8-bit / 6 ch WAVEFORMATEXENSIBLE",                         0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_37,                  "{2DC011D8-BC9C-4A36-8245-B667229B47B4}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.39",  "     48K / 8-bit / 8 ch WAVEFORMATEXENSIBLE",                        0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_38,                  "{3D2B97B4-E547-4A4A-A925-ED54E8C86F7A}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.40",  "     96K / 16-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_39,                  "{674941D4-1BF9-4184-9FC9-D9D773F17CBC}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.41",  "     11.025K / 16-bit / 6 ch WAVEFORMATEXENSIBLE",                   0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_40,                  "{399DE67D-0257-426E-8DA0-04012AD38D66}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.42",  "     192K / 24-bit / 8 ch WAVEFORMATEXENSIBLE",                      0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_41,                  "{3F744F22-5B0F-43C1-AF69-AD0172293035}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.43",  "     8K / 32-bit / 8 ch WAVEFORMATEXENSIBLE",                        0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_42,                  "{1402B583-2FD1-4D52-AAFC-A6C8F94E339E}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.44",  "     88.2K / 24-bit / 24 ch WAVEFORMATEXENSIBLE",                    0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_43,                  "{5FB24FAC-5E1D-42FB-B16B-84106E6DC7D8}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.45",  "     22.05K / 24-bit / 8 ch WAVEFORMATEXENSIBLE",                    0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_44,                  "{BFBD61C9-D878-4AD9-9688-1AE41C728B7A}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.46",  "     48K / 32-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_45,                  "{32D39031-24CC-4B2F-98D7-4F21EF6E49B0}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.47",  "     192K / 8-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_46,                  "{AF6916EB-DBF7-4346-A68F-8ACC11BF589C}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.48",  "     32K / 32-bit / 8 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_47,                  "{49192881-9AD2-4499-BE54-BCC01F91D2B2}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.49",  "     44.1K / 24-bit / 6 ch WAVEFORMATEXENSIBLE",                     0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_48,                  "{888B3718-6089-4FB9-A344-BA4FF63AE9F1}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.50",  "     22.05K / 8-bit / 6 ch WAVEFORMATEXENSIBLE",                     0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_49,                  "{03C30D29-7962-47DF-B9A9-7191D3865DC5}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.51",  "     44.1K / 16-bit / 8 ch WAVEFORMATEXENSIBLE",                     0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_50,                  "{194C00F8-7956-4604-A900-54018FB7FE5A}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.52",  "     16K / 32-bit / 32 ch WAVEFORMATEXENSIBLE",                      0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_51,                  "{3CD12F8A-EF9E-4C79-AC85-B09FD1C783E9}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.53",  "     88.2K / 8-bit / 8 ch WAVEFORMATEXENSIBLE",                      0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_52,                  "{23EF55B9-2B5C-47D5-AA21-498D8F102459}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.54",  "     16K / 16-bit / 16 ch WAVEFORMATEXENSIBLE",                      0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_53,                  "{95EC8CEA-ED0B-48C1-87CC-E6FD7F6E7C9D}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.55",  "     48K / 32-bit (20) / 2 ch WAVEFORMATEXENSIBLE",                  0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_54,                  "{12B2DB3E-2B49-405D-AA11-26DE5C0F2FF7}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.56",  "     48K / 32-bit (24) / 2 ch WAVEFORMATEXENSIBLE",                  0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_55,                  "{6B697226-0C87-4264-9C37-8A6436AA4EA5}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.57",  "     48K / 32-bit (32) / 2 ch WAVEFORMATEXENSIBLE",                  0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_56,                  "{66B0F662-0AF3-4451-A015-BAB474199FA9}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.58",  "     48K / 16-bit / 4 ch (QUAD) WAVEFORMATEXENSIBLE",                0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_57,                  "{1BD05CE6-5AAA-4E84-805D-751B8A9277D5}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.59",  "     48K / 16-bit / 4 ch (SURROUND WAVEFORMATEXENSIBLE",             0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_58,                  "{8E31AAC9-5F0C-4B49-A3DB-ACE6ECDD4541}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.60",  "     48K / 16-bit / 6 ch (5.1) WAVEFORMATEXENSIBLE",                 0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_59,                  "{8A8473B6-1D19-4EDF-BDFA-7D3C9908EB59}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.61",  "     48K / 16-bit / 8 ch (7.1) WAVEFORMATEXENSIBLE",                 0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_60,                  "{C9FCF700-1C2E-45A7-9F79-4601E139928E}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.62",  "     48K / 16-bit / 1 ch (MONO) WAVEFORMATEXENSIBLE",                0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_61,                  "{899C791A-0FCE-4353-BE64-6C026F30E5CA}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.37.63",  "     48K / 16-bit / 2 ch (STEREO) WAVEFORMATEXENSIBLE",              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Compat_SRC_Enhanced_Pull_62,                  "{DD086006-950D-4DEC-87B3-13F9AFEAC40C}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_PARENT( "",         "   Exclusive Mode",                                                  0,                   0,                                                                     0,    NULL,  NULL,                                                   "{ec32ffc9-a997-45e7-8752-cf2a67201147}")
    DEVICE_TEST_PARENT( "",         "    Timer-Push Exclusive Render",                                    0,                   0,                                                                     0,    NULL,  NULL,                                                   "{26a9cee7-d723-4445-af95-619d62ecac93}")
    DEVICE_TEST_METHOD( "1.38.1",   "     192K / 32-bit / 1 ch WAVEFORMATEX",                             0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_0,                             "{55ef8048-e13a-42e4-8a4a-e68f3f72bfff}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.2",   "     11K / 8-bit / 1 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_1,                             "{ee764c61-5242-41b9-a2df-fd22f338c252}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.3",   "     22K / 32-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_2,                             "{3f729126-7bf4-4887-b780-816503eb5dfa}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.4",   "     3K / 16-bit / 2 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_3,                             "{f3e57f9d-e7ee-4d8e-bf31-ab9d6dd711e9}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.5",   "     96K / 24-bit / 1 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_4,                             "{b7345aaf-851a-48fb-bbbf-912c40a2871f}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.6",   "     64K / 8-bit / 1 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_5,                             "{1330b534-4413-4a6e-8656-fe0a0dc98d5b}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.7",   "     96K / 8-bit / 2 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_6,                             "{13dfe60e-9f31-4fbe-933e-5010fb136055}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.8",   "     96K / 8-bit / 2 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_7,                             "{07aa0cbf-e96b-4ae5-8983-844b108cb7ec}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.9",   "     48K / 24-bit / 1 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_8,                             "{3efc367b-6fe9-4002-9da9-345342689367}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.10",  "     48K / 16-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_9,                             "{07ebd017-d2ae-427c-ab84-a0cca1c59628}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.11",  "     64K / 32-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_10,                            "{48fc9116-e56c-4320-b3ef-3cef30cde683}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.12",  "     11.025K / 24-bit / 2 ch WAVEFORMATEX",                          0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_11,                            "{0f3443f2-05d6-4b42-b819-ecb6de9aa1c5}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.13",  "     192K / 16-bit / 2 ch WAVEFORMATEX",                             0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_12,                            "{6adc2681-f5fd-4711-a156-988badf79bc8}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.14",  "     8K / 24-bit / 1 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_13,                            "{2609c574-ba44-4979-b5cc-d7fb3311cf3f}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.15",  "     44.1K / 32-bit / 2 ch WAVEFORMATEX",                            0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_14,                            "{e1126ec3-bf51-4dca-b67e-1ed9430044bc}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.16",  "     32K / 8-bit / 2 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_15,                            "{739b3b5a-0d6c-4b9a-bdfc-9579159baf57}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.17",  "     32K / 24-bit / 1 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_16,                            "{5a3a98e7-7c5c-4127-8044-4ec1e98dcafb}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.18",  "     44.1K / 8-bit / 1 ch WAVEFORMATEX",                             0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_17,                            "{d6bec246-302d-4ced-a2d5-288e35571222}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.19",  "     3K / 24-bit / 1 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_18,                            "{e89ebe0a-f842-4a1c-b408-46cabb75a11c}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.20",  "     22.05K / 16-bit / 1 ch WAVEFORMATEX",                           0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_19,                            "{bd665741-ee70-4f72-add2-308955c7ed84}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.21",  "     48K / 24-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_20,                            "{9152a551-e0c0-4867-821b-275e4606adc7}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.22",  "     48K / 32-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_21,                            "{942008e9-9031-4aee-bac4-475a1b8280d3}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.23",  "     44.1K / 16-bit / 2 ch WAVEFORMATEX",                            0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_22,                            "{5eac1cac-ebd5-458e-871f-b861aae770ba}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.24",  "     96K / 16-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_23,                            "{240d7e86-69bd-41b1-ae1b-7c1381f9a749}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.25",  "     16K / 16-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_24,                            "{69377bd5-5df7-43ee-a39f-7ad37cf2204d}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.26",  "     11.025K / 16-bit / 2 ch WAVEFORMATEX",                          0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_25,                            "{47b21f7a-95bd-45b0-8cee-94c3a5c9534a}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.27",  "     22.05 / 16-bit / 2 ch WAVEFORMATEX",                            0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_26,                            "{9ef71471-5a9e-4646-8297-78e584e120ee}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.28",  "     64K / 16-bit / 8 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_27,                            "{34dccb0f-444d-470c-a00a-9de86923f51b}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.29",  "     16K / 24-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_28,                            "{91530e31-ba6d-4a63-8c1b-466cb14e797f}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.30",  "     64K / 24-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_29,                            "{e195653c-9f4e-4197-bce3-2601c06b8ff4}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.31",  "     11.025K / 32-bit / 8 ch WAVEFORMATEXENSIBLE",                   0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_30,                            "{3bf69567-9505-4400-a806-71493ba39ec5}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.32",  "     32K / 16-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_31,                            "{cd9a4c08-ab84-4dfe-b1a5-aa92c310d449}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.33",  "     3K / 8-bit / 8 ch WAVEFORMATEXENSIBLE",                         0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_32,                            "{28912291-feec-4d53-bbd0-b842f864117e}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.34",  "     88.2K / 32-bit / 6 ch WAVEFORMATEXENSIBLE",                     0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_33,                            "{637b41e4-4049-4a45-9286-af6ff1780716}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.35",  "     96K / 32-bit / 8 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_34,                            "{910c0c1a-beb9-4aa8-8dce-6e7312875c07}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.36",  "     16K / 8-bit / 6 ch WAVEFORMATEXENSIBLE",                        0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_35,                            "{e4c6337a-b4ba-4e7a-8e03-8f6c1d7f5bb1}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.37",  "     3K / 32-bit / 6 ch WAVEFORMATEXENSIBLE",                        0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_36,                            "{4cdaefcd-1345-4cf2-bc33-229fb8f7848a}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.38",  "     8K / 8-bit / 6 ch WAVEFORMATEXENSIBLE",                         0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_37,                            "{96e639c2-0441-4dd5-9d50-5d62bbb30420}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.39",  "     48K / 8-bit / 8 ch WAVEFORMATEXENSIBLE",                        0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_38,                            "{89da5e1d-102a-4635-b98d-49cc3dc34f90}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.40",  "     96K / 16-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_39,                            "{171d0e24-df8b-435d-a70e-84d637539ffb}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.41",  "     11.025K / 16-bit / 6 ch WAVEFORMATEXENSIBLE",                   0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_40,                            "{80d979d8-552d-49a7-9cab-2d54c9a43c80}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.42",  "     192K / 24-bit / 8 ch WAVEFORMATEXENSIBLE",                      0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_41,                            "{1b606ea0-758a-4d76-bca2-88252d53e3a5}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.43",  "     8K / 32-bit / 8 ch WAVEFORMATEXENSIBLE",                        0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_42,                            "{77fb141b-bbd7-4f3e-aa2a-88ff2f9f4f32}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.44",  "     88.2K / 24-bit / 24 ch WAVEFORMATEXENSIBLE",                    0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_43,                            "{e65e42d9-ef34-45de-8920-89e65e67c67a}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.45",  "     22.05K / 24-bit / 8 ch WAVEFORMATEXENSIBLE",                    0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_44,                            "{2d729389-cfc6-4eb3-b49e-129e47dee82a}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.46",  "     48K / 32-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_45,                            "{c53456ea-77aa-4322-bbd7-a56bb10742c8}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.47",  "     192K / 8-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_46,                            "{a34933dd-3d24-4e99-bdfd-53370f9a0c07}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.48",  "     32K / 32-bit / 8 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_47,                            "{ff4c829b-bb4f-4b9f-afb7-efc8e0081ce0}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.49",  "     44.1K / 24-bit / 6 ch WAVEFORMATEXENSIBLE",                     0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_48,                            "{bb0b1cbc-e0a7-4500-8387-c0ff8835f605}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.50",  "     22.05K / 8-bit / 6 ch WAVEFORMATEXENSIBLE",                     0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_49,                            "{f9777ea2-2aff-4550-abe5-c1552c34d45b}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.51",  "     44.1K / 16-bit / 8 ch WAVEFORMATEXENSIBLE",                     0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_50,                            "{16bd6b4e-17de-4318-819a-f087e1996321}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.52",  "     16K / 32-bit / 32 ch WAVEFORMATEXENSIBLE",                      0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_51,                            "{9c5d50bf-2636-45b6-8eaf-646f94785d04}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.53",  "     88.2K / 8-bit / 8 ch WAVEFORMATEXENSIBLE",                      0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_52,                            "{04ca724e-0ad8-4e2a-84e2-a1fb4c805f21}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.54",  "     16K / 16-bit / 16 ch WAVEFORMATEXENSIBLE",                      0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_53,                            "{19af1ec3-6b2b-409a-af7a-5d71952f8eff}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.55",  "     48K / 32-bit (20) / 2 ch WAVEFORMATEXENSIBLE",                  0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_54,                            "{46456cc4-9ea9-46ca-9ee2-f1518c2eee67}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.56",  "     48K / 32-bit (24) / 2 ch WAVEFORMATEXENSIBLE",                  0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_55,                            "{7d3a3b10-486d-428d-9360-15a13bd10145}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.57",  "     48K / 32-bit (32) / 2 ch WAVEFORMATEXENSIBLE",                  0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_56,                            "{d66a0c2e-8f55-4bd4-aba1-76840f9c4550}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.58",  "     48K / 16-bit / 4 ch (QUAD) WAVEFORMATEXENSIBLE",                0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_57,                            "{c5502876-dd45-49a1-933c-3da412f37dd3}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.59",  "     48K / 16-bit / 4 ch (SURROUND WAVEFORMATEXENSIBLE",             0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_58,                            "{0e51bbde-c0b2-45db-9893-559e06b80617}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.60",  "     48K / 16-bit / 6 ch (5.1) WAVEFORMATEXENSIBLE",                 0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_59,                            "{2802f6a2-2a09-45f6-9a9c-37df2e30fb0b}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.61",  "     48K / 16-bit / 8 ch (7.1) WAVEFORMATEXENSIBLE",                 0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_60,                            "{65f697f7-e546-48de-a5f0-c4de32f1ff53}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.62",  "     48K / 16-bit / 1 ch (MONO) WAVEFORMATEXENSIBLE",                0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_61,                            "{ddd3cf1d-6803-415a-98ff-236bbf88eb10}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.38.63",  "     48K / 16-bit / 2 ch (STEREO) WAVEFORMATEXENSIBLE",              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Push_62,                            "{d21280d0-93d5-4ed0-95bb-84891e48e840}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_PARENT( "",         "    Event-Pull Exclusive Render",                                    0,                   0,                                                                     0,    NULL,  NULL,                                                   "{bf5988e4-dfe1-4b96-b043-f332d401c6a1}")
    DEVICE_TEST_METHOD( "1.39.1",   "     192K / 32-bit / 1 ch WAVEFORMATEX",                             0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_0,                             "{436b6e58-bc5a-4b24-86e9-9977da82d20a}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.2",   "     11K / 8-bit / 1 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_1,                             "{e7fe76cc-a315-4c20-951a-909fb8d686fd}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.3",   "     22K / 32-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_2,                             "{b7d8f2b9-aca8-46f5-80ae-9d8fcb5ab5d7}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.4",   "     3K / 16-bit / 2 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_3,                             "{4c853202-1229-420c-b783-9486e6c966c3}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.5",   "     96K / 24-bit / 1 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_4,                             "{55ac6369-8799-4e01-8eb3-7449c89b0f62}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.6",   "     64K / 8-bit / 1 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_5,                             "{819c245f-05e4-43cf-b0ab-a2397d5ad136}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.7",   "     96K / 8-bit / 2 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_6,                             "{bbb95f71-6089-4ab3-82e9-9ae419cf7306}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.8",   "     96K / 8-bit / 2 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_7,                             "{5e58c7c5-226b-4905-95fc-149e6fc8b2c8}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.9",   "     48K / 24-bit / 1 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_8,                             "{688cacdf-fdc3-40dc-a833-1050dfbaf322}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.10",  "     48K / 16-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_9,                             "{1f2e60e8-8025-4e9d-8a45-cc508fe21cdb}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.11",  "     64K / 32-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_10,                            "{00918256-34b1-44d3-8f64-65cad1f17e8d}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.12",  "     11.025K / 24-bit / 2 ch WAVEFORMATEX",                          0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_11,                            "{5e55f997-6487-410c-a9f8-5dfcd7096a29}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.13",  "     192K / 16-bit / 2 ch WAVEFORMATEX",                             0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_12,                            "{a47c71d5-f7b5-4688-9032-f672003fa23a}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.14",  "     8K / 24-bit / 1 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_13,                            "{0692cc1f-7353-4a28-bde3-1ee644b5e926}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.15",  "     44.1K / 32-bit / 2 ch WAVEFORMATEX",                            0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_14,                            "{5502340d-9c61-428e-b68c-d41c5f33ae10}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.16",  "     32K / 8-bit / 2 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_15,                            "{2b63d865-1a28-4aa3-9b76-f510418c77d6}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.17",  "     32K / 24-bit / 1 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_16,                            "{77f133ea-28f1-43b9-b704-a715d0e3078e}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.18",  "     44.1K / 8-bit / 1 ch WAVEFORMATEX",                             0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_17,                            "{8a2731c1-6d94-4309-b523-da1f9da205bb}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.19",  "     3K / 24-bit / 1 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_18,                            "{c0c68b70-77a3-41f5-b42d-a013216fd5aa}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.20",  "     22.05K / 16-bit / 1 ch WAVEFORMATEX",                           0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_19,                            "{b5b46991-6809-4565-acd4-c67f36730a3d}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.21",  "     48K / 24-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_20,                            "{72b3c190-f43f-43df-9d03-7f505f9e9ee6}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.22",  "     48K / 32-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_21,                            "{2bf633a5-5268-4dd8-ad61-502b7b0d0afb}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.23",  "     44.1K / 16-bit / 2 ch WAVEFORMATEX",                            0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_22,                            "{941ebfbb-be9a-4831-bfa2-bf81ec7b2399}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.24",  "     96K / 16-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_23,                            "{8d8be6bd-c1e5-45a1-a67f-f6c49998a0f1}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.25",  "     16K / 16-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_24,                            "{91e81234-b15e-4f55-85dd-542c2a27784b}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.26",  "     11.025K / 16-bit / 2 ch WAVEFORMATEX",                          0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_25,                            "{cbea9d8d-6144-4ab3-a097-39f2f7cf51da}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.27",  "     22.05 / 16-bit / 2 ch WAVEFORMATEX",                            0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_26,                            "{721c8552-48da-4c80-a20c-671e8fe84ba8}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.28",  "     64K / 16-bit / 8 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_27,                            "{bb72aabf-fea7-44e8-97ae-eacc5218ab7a}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.29",  "     16K / 24-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_28,                            "{091fa913-aebb-4176-bab9-30f4532d7a57}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.30",  "     64K / 24-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_29,                            "{591ae9fa-b135-4750-ab12-246eb59d59d7}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.31",  "     11.025K / 32-bit / 8 ch WAVEFORMATEXENSIBLE",                   0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_30,                            "{f4d14ad8-dc0d-46f1-bba2-663f41fa6cf6}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.32",  "     32K / 16-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_31,                            "{c731de0a-b34c-47ff-9e83-c72f1df0dd40}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.33",  "     3K / 8-bit / 8 ch WAVEFORMATEXENSIBLE",                         0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_32,                            "{95c59e3f-597d-45bf-ad0e-8d660347b907}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.34",  "     88.2K / 32-bit / 6 ch WAVEFORMATEXENSIBLE",                     0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_33,                            "{5b5fd50c-a9d8-4aad-95a6-f6949f2abd80}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.35",  "     96K / 32-bit / 8 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_34,                            "{03b8ab40-44fb-487b-9130-637365fdfa7d}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.36",  "     16K / 8-bit / 6 ch WAVEFORMATEXENSIBLE",                        0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_35,                            "{06338bdb-6f46-4da3-a3a5-1751842d1ecb}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.37",  "     3K / 32-bit / 6 ch WAVEFORMATEXENSIBLE",                        0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_36,                            "{c732f8de-ca44-470d-8286-8f03c12776fa}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.38",  "     8K / 8-bit / 6 ch WAVEFORMATEXENSIBLE",                         0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_37,                            "{a517ad1b-2cde-488c-8652-838e2926796d}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.39",  "     48K / 8-bit / 8 ch WAVEFORMATEXENSIBLE",                        0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_38,                            "{6475ad75-08c5-4962-a5c3-8e073f0b8aab}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.40",  "     96K / 16-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_39,                            "{d08ab1f8-ba56-4bfe-8a4a-ad02f5273c69}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.41",  "     11.025K / 16-bit / 6 ch WAVEFORMATEXENSIBLE",                   0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_40,                            "{9c5bbb31-d694-43ee-a246-8fb87d1d5377}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.42",  "     192K / 24-bit / 8 ch WAVEFORMATEXENSIBLE",                      0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_41,                            "{3e372850-cb0b-4d65-ad8f-6a47b1f08807}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.43",  "     8K / 32-bit / 8 ch WAVEFORMATEXENSIBLE",                        0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_42,                            "{f7f37e68-3071-450b-866c-4048096cb099}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.44",  "     88.2K / 24-bit / 24 ch WAVEFORMATEXENSIBLE",                    0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_43,                            "{170421f0-b760-4209-b1fd-64c5db9380ad}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.45",  "     22.05K / 24-bit / 8 ch WAVEFORMATEXENSIBLE",                    0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_44,                            "{9fc156bf-9811-4e71-a882-006029607ead}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.46",  "     48K / 32-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_45,                            "{15820cd1-6bb3-4c12-a423-0148496b8044}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.47",  "     192K / 8-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_46,                            "{aecc45dd-74b5-41fd-b6f6-7b67872dd11e}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.48",  "     32K / 32-bit / 8 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_47,                            "{733e6441-ec37-4260-baad-a553dea419b2}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.49",  "     44.1K / 24-bit / 6 ch WAVEFORMATEXENSIBLE",                     0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_48,                            "{b44d85c3-1f33-4b0a-b527-504b160c73a4}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.50",  "     22.05K / 8-bit / 6 ch WAVEFORMATEXENSIBLE",                     0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_49,                            "{370cc908-0819-4ad0-80b7-6176847419ce}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.51",  "     44.1K / 16-bit / 8 ch WAVEFORMATEXENSIBLE",                     0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_50,                            "{5fe737e7-b4da-477e-93b8-3b93ad800033}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.52",  "     16K / 32-bit / 32 ch WAVEFORMATEXENSIBLE",                      0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_51,                            "{6aa2bb20-78e8-4c3e-8c39-f085f02d10b2}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.53",  "     88.2K / 8-bit / 8 ch WAVEFORMATEXENSIBLE",                      0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_52,                            "{dd7c5da8-36c2-4135-a7b4-418ca1c02c06}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.54",  "     16K / 16-bit / 16 ch WAVEFORMATEXENSIBLE",                      0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_53,                            "{285b41bb-2f88-40c9-8eb5-68ef098dcf55}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.55",  "     48K / 32-bit (20) / 2 ch WAVEFORMATEXENSIBLE",                  0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_54,                            "{52f82c2f-ffcf-4f52-920f-52324cdbd63a}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.56",  "     48K / 32-bit (24) / 2 ch WAVEFORMATEXENSIBLE",                  0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_55,                            "{bc2013fc-0726-4381-8a2a-9152404dd26d}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.57",  "     48K / 32-bit (32) / 2 ch WAVEFORMATEXENSIBLE",                  0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_56,                            "{13e5d777-5c98-4fc7-bfc6-4993010152f3}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.58",  "     48K / 16-bit / 4 ch (QUAD) WAVEFORMATEXENSIBLE",                0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_57,                            "{1c6173b2-ed4a-4a6f-92e1-ca2ee91232b2}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.59",  "     48K / 16-bit / 4 ch (SURROUND WAVEFORMATEXENSIBLE",             0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_58,                            "{b4d289db-0675-4e3b-85c8-160f53dc3d7d}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.60",  "     48K / 16-bit / 6 ch (5.1) WAVEFORMATEXENSIBLE",                 0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_59,                            "{b5654c1f-3d8b-402a-beb2-055f2f9b1543}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.61",  "     48K / 16-bit / 8 ch (7.1) WAVEFORMATEXENSIBLE",                 0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_60,                            "{61bb7f82-ed7c-4a05-b265-2bb1b6e0440c}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.62",  "     48K / 16-bit / 1 ch (MONO) WAVEFORMATEXENSIBLE",                0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_61,                            "{a896069a-b5ce-425b-bb60-90453770bfba}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.39.63",  "     48K / 16-bit / 2 ch (STEREO) WAVEFORMATEXENSIBLE",              0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Render_Exclusive_Pull_62,                            "{df4c718a-b1e6-4b1b-9c4d-c69090ad25db}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_PARENT( "",         "  Capture Streaming Tests",                                          0,                   0,                                                                     0,    NULL,  NULL,                                                   "{d7b685ee-8c93-45c6-9bd5-33ce2afd71a2}")
    DEVICE_TEST_PARENT( "",         "   Shared Mode",                                                     0,                   0,                                                                     0,    NULL,  NULL,                                                   "{72d76b3e-87a1-41cd-999a-1ab24504733a}")
    DEVICE_TEST_PARENT( "",         "    Timer-Push Shared Capture",                                      0,                   0,                                                                     0,    NULL,  NULL,                                                   "{fa75a933-62f7-4748-98e3-202ea265eef9}")
    DEVICE_TEST_METHOD( "1.40.1",   "     Shared Mode Capture (PULL)",                                    0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Shared_Push,                                 "{6cef9ef2-3898-41d1-8c15-a21b95c4760b}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_PARENT( "",         "    Event-Pull Shared Capture",                                      0,                   0,                                                                     0,    NULL,  NULL,                                                   "{726fe676-360d-40f0-81da-e614d1782338}")
    DEVICE_TEST_METHOD( "1.41.1",   "     Shared Mode Capture (PULL)",                                    0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Shared_Pull,                                 "{d1f51180-6dfd-490a-8886-d842763c9149}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_PARENT( "",         "   Compat Mode",                                                     0,                   0,                                                                     0,    NULL,  NULL,                                                   "{bbca0b46-2847-416f-be2f-35ffd6a961c5}")
    DEVICE_TEST_PARENT( "",         "    Timer-Push Compat Capture",                                      0,                   0,                                                                     0,    NULL,  NULL,                                                   "{96176c0e-2f45-4299-a05d-e4cc15ed706a}")
    DEVICE_TEST_METHOD( "1.42.1",   "     192K / 32-bit / 1 ch WAVEFORMATEX",                             0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_0,                               "{68bbde0c-f0c4-4538-912b-bdc98b8ccb6c}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.2",   "     11K / 8-bit / 1 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_1,                               "{c29636a1-09f9-420e-88ce-9e044851fa76}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.3",   "     22K / 32-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_2,                               "{dfb8a63a-14a1-4540-8062-b0d0171dd2c9}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.4",   "     3K / 16-bit / 2 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_3,                               "{179c96fa-706d-4e04-815a-0887ad06d040}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.5",   "     96K / 24-bit / 1 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_4,                               "{027438f1-58f0-4cf6-9c4e-205ac08fba0d}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.6",   "     64K / 8-bit / 1 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_5,                               "{60eb387d-c82f-479e-b611-918de0415703}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.7",   "     96K / 8-bit / 2 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_6,                               "{e01b01a9-816f-4ec2-888b-c1aa134bda78}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.8",   "     96K / 8-bit / 2 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_7,                               "{60a395d5-3bb3-406e-93d8-916a4e05248e}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.9",   "     48K / 24-bit / 1 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_8,                               "{396854e7-b158-446c-bb2c-783e930e83e7}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.10",  "     48K / 16-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_9,                               "{8584e2ef-598a-46b7-9cd9-4d9df1b3ba12}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.11",  "     64K / 32-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_10,                              "{2a11abc8-e3e7-4fa4-aa06-998b135f24cb}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.12",  "     11.025K / 24-bit / 2 ch WAVEFORMATEX",                          0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_11,                              "{c38d7720-a32e-4162-83f1-c26e204c49a7}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.13",  "     192K / 16-bit / 2 ch WAVEFORMATEX",                             0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_12,                              "{e367ceab-1c82-4b51-bb66-93c98617e9f8}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.14",  "     8K / 24-bit / 1 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_13,                              "{00201d32-af64-41a4-bc70-2316c5601598}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.15",  "     44.1K / 32-bit / 2 ch WAVEFORMATEX",                            0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_14,                              "{d4a9d17c-7baf-4e95-959a-700258f89089}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.16",  "     32K / 8-bit / 2 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_15,                              "{02215134-84f8-4fbb-9f56-4ac64a75f1fa}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.17",  "     32K / 24-bit / 1 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_16,                              "{0bf393f7-bb3a-4da4-8a83-0824420105b8}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.18",  "     44.1K / 8-bit / 1 ch WAVEFORMATEX",                             0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_17,                              "{d60b02a2-0a9f-48a5-91e4-ae1d316a1848}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.19",  "     3K / 24-bit / 1 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_18,                              "{bcb30496-1d30-410f-b0ad-c5acc91e436f}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.20",  "     22.05K / 16-bit / 1 ch WAVEFORMATEX",                           0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_19,                              "{0a42e91d-d30c-4438-bc95-280c03b3e5d5}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.21",  "     48K / 24-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_20,                              "{3792584a-c05e-4f23-adc2-96aeb9fbfd8e}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.22",  "     48K / 32-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_21,                              "{6117a417-b09a-4b6b-9ab9-2393a8479c1c}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.23",  "     44.1K / 16-bit / 2 ch WAVEFORMATEX",                            0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_22,                              "{5760b6f3-61e4-4691-9dbf-4fc1fd0b9546}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.24",  "     96K / 16-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_23,                              "{fa6ef4f0-8f3a-4164-853d-9dc426448540}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.25",  "     16K / 16-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_24,                              "{29a3d37e-5115-455a-a9ed-d487aedfc2f3}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.26",  "     11.025K / 16-bit / 2 ch WAVEFORMATEX",                          0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_25,                              "{3bf905e4-9852-4b5d-b13d-6938cf1e4ba7}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.27",  "     22.05 / 16-bit / 2 ch WAVEFORMATEX",                            0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_26,                              "{85cfec11-6581-4751-91b0-bb691af3b304}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.28",  "     64K / 16-bit / 8 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_27,                              "{ecd03253-52ee-40b3-92cf-e80404463403}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.29",  "     16K / 24-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_28,                              "{732014bd-6f7e-4b73-9fbd-8721edc9ec36}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.30",  "     64K / 24-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_29,                              "{794b8c36-57a3-42f3-b1fa-4c074bff2f70}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.31",  "     11.025K / 32-bit / 8 ch WAVEFORMATEXENSIBLE",                   0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_30,                              "{b0f85b98-eff9-4dd8-8822-a2ad756b21c6}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.32",  "     32K / 16-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_31,                              "{1b83b820-da0d-4cb1-a797-d59d9a51e64a}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.33",  "     3K / 8-bit / 8 ch WAVEFORMATEXENSIBLE",                         0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_32,                              "{82d13d82-c777-432e-96a3-8fe2a4f679f7}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.34",  "     88.2K / 32-bit / 6 ch WAVEFORMATEXENSIBLE",                     0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_33,                              "{594c7c93-1fda-4984-8b91-bc40e7e91a0a}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.35",  "     96K / 32-bit / 8 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_34,                              "{7c561dc6-e1c5-4b54-b91c-18294120f262}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.36",  "     16K / 8-bit / 6 ch WAVEFORMATEXENSIBLE",                        0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_35,                              "{2191cfdd-24d8-477a-965a-f0fad7e409d9}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.37",  "     3K / 32-bit / 6 ch WAVEFORMATEXENSIBLE",                        0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_36,                              "{b5b1deee-1bf5-44fa-a10e-b0a5de288c6b}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.38",  "     8K / 8-bit / 6 ch WAVEFORMATEXENSIBLE",                         0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_37,                              "{5500fb1d-5e6c-4a01-82f0-bc474cde61a6}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.39",  "     48K / 8-bit / 8 ch WAVEFORMATEXENSIBLE",                        0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_38,                              "{aaa6df2d-2fdd-40b2-b7dd-91e18926b80b}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.40",  "     96K / 16-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_39,                              "{f270c4c5-8bc8-4c55-ad0d-c747c702eecf}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.41",  "     11.025K / 16-bit / 6 ch WAVEFORMATEXENSIBLE",                   0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_40,                              "{939668fb-2ca3-447a-a297-3a28b6ab1cd1}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.42",  "     192K / 24-bit / 8 ch WAVEFORMATEXENSIBLE",                      0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_41,                              "{ffacc5ed-af5f-4f12-b319-1f4c72a7672c}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.43",  "     8K / 32-bit / 8 ch WAVEFORMATEXENSIBLE",                        0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_42,                              "{7dff61e0-fc74-48cb-8c2d-7059179d422e}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.44",  "     88.2K / 24-bit / 24 ch WAVEFORMATEXENSIBLE",                    0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_43,                              "{df288f77-a18d-4554-a59d-d43ae20b36c4}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.45",  "     22.05K / 24-bit / 8 ch WAVEFORMATEXENSIBLE",                    0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_44,                              "{a941f030-a813-429d-8e7e-e08581f70a12}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.46",  "     48K / 32-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_45,                              "{e1c8037a-0fc8-458f-9431-f51af0a1472a}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.47",  "     192K / 8-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_46,                              "{6c93eb87-4cd5-4890-93ed-e155fd8c4d26}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.48",  "     32K / 32-bit / 8 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_47,                              "{74d51afa-a4bd-48bd-8e4c-9506940ee729}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.49",  "     44.1K / 24-bit / 6 ch WAVEFORMATEXENSIBLE",                     0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_48,                              "{bbf6128e-4fb2-4dba-b5b1-cc3ea5c710a8}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.50",  "     22.05K / 8-bit / 6 ch WAVEFORMATEXENSIBLE",                     0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_49,                              "{5b1554a7-4439-4890-913d-701512fc6fac}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.51",  "     44.1K / 16-bit / 8 ch WAVEFORMATEXENSIBLE",                     0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_50,                              "{6ade51da-38e5-4583-8399-0774a47e640f}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.52",  "     16K / 32-bit / 32 ch WAVEFORMATEXENSIBLE",                      0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_51,                              "{abff1330-8018-4e05-aefb-c4e30126e217}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.53",  "     88.2K / 8-bit / 8 ch WAVEFORMATEXENSIBLE",                      0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_52,                              "{c3258016-b41e-4e0a-aeb8-44a225b4d2ce}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.54",  "     16K / 16-bit / 16 ch WAVEFORMATEXENSIBLE",                      0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_53,                              "{a570f43c-e91e-4b48-ad2f-21735f42b354}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.55",  "     48K / 32-bit (20) / 2 ch WAVEFORMATEXENSIBLE",                  0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_54,                              "{7ccd0d1b-7b32-431c-91d4-dc417b8f8c37}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.56",  "     48K / 32-bit (24) / 2 ch WAVEFORMATEXENSIBLE",                  0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_55,                              "{9617adc9-763d-41d6-8a04-3edd5317e602}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.57",  "     48K / 32-bit (32) / 2 ch WAVEFORMATEXENSIBLE",                  0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_56,                              "{815afcef-b8af-45f8-8a2a-c04083013bc8}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.58",  "     48K / 16-bit / 4 ch (QUAD) WAVEFORMATEXENSIBLE",                0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_57,                              "{dc25fd41-9d6b-476a-a934-bc856ea6caad}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.59",  "     48K / 16-bit / 4 ch (SURROUND WAVEFORMATEXENSIBLE",             0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_58,                              "{62055a1c-6be5-4fda-9883-3043b6644214}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.60",  "     48K / 16-bit / 6 ch (5.1) WAVEFORMATEXENSIBLE",                 0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_59,                              "{25cf747a-2789-4dec-bc3a-593cc194662e}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.61",  "     48K / 16-bit / 8 ch (7.1) WAVEFORMATEXENSIBLE",                 0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_60,                              "{5bfbe028-6a86-484e-a02f-2fe4b69a0262}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.62",  "     48K / 16-bit / 1 ch (MONO) WAVEFORMATEXENSIBLE",                0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_61,                              "{d2ecf25e-efcc-4696-96f7-f4e211405331}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.42.63",  "     48K / 16-bit / 2 ch (STEREO) WAVEFORMATEXENSIBLE",              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Push_62,                              "{6d532ba0-9894-472d-a290-e29306e84a7e}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_PARENT( "",         "    Event-Pull Compat Capture",                                      0,                   0,                                                                     0,    NULL,  NULL,                                                   "{2f508f0d-f797-4a7b-a10e-c2682e25f6c3}")
    DEVICE_TEST_METHOD( "1.43.1",   "     192K / 32-bit / 1 ch WAVEFORMATEX",                             0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_0,                               "{65ded6c0-e90e-47a0-bf30-76d720f403f2}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.2",   "     11K / 8-bit / 1 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_1,                               "{1999ed70-0c83-4770-bc61-9a44a02b4529}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.3",   "     22K / 32-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_2,                               "{45641f02-908b-4b5d-8d6d-fb2ab85c1898}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.4",   "     3K / 16-bit / 2 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_3,                               "{ef6131c0-a2bc-49f0-990f-9c83e7044dc4}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.5",   "     96K / 24-bit / 1 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_4,                               "{e6d459da-3720-4dfb-a9ee-295b45cccf3b}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.6",   "     64K / 8-bit / 1 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_5,                               "{0e374d38-cd91-4dda-baa8-785250e5b011}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.7",   "     96K / 8-bit / 2 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_6,                               "{f2631107-f564-4b77-b2a3-974bac990e8e}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.8",   "     96K / 8-bit / 2 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_7,                               "{235a5bd2-55ef-4b6b-ae96-d77c5581e953}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.9",   "     48K / 24-bit / 1 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_8,                               "{8f6fd3f8-09d3-4111-b260-cebb4d553072}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.10",  "     48K / 16-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_9,                               "{dc3608cb-554c-40ad-b13e-0a9c7f2a8769}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.11",  "     64K / 32-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_10,                              "{27718436-8631-4919-b73b-369e0b55ceea}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.12",  "     11.025K / 24-bit / 2 ch WAVEFORMATEX",                          0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_11,                              "{cead8786-42d9-4159-95d7-28c90630ee33}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.13",  "     192K / 16-bit / 2 ch WAVEFORMATEX",                             0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_12,                              "{6e7a2771-ed8d-4e37-bdc9-5357bd09ef82}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.14",  "     8K / 24-bit / 1 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_13,                              "{787c225a-46e0-47cc-99e7-a00e219a8e4f}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.15",  "     44.1K / 32-bit / 2 ch WAVEFORMATEX",                            0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_14,                              "{322cec49-efbc-4422-9ae6-2fe2f56101e4}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.16",  "     32K / 8-bit / 2 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_15,                              "{bf5e64f3-d955-4f2e-907f-ddce8c7fa772}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.17",  "     32K / 24-bit / 1 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_16,                              "{262d4338-6041-4ef1-ae51-04ed62218507}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.18",  "     44.1K / 8-bit / 1 ch WAVEFORMATEX",                             0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_17,                              "{83da24fa-e45a-4eef-83e9-8ceb3b4f73ba}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.19",  "     3K / 24-bit / 1 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_18,                              "{72b95bec-fb19-414f-8a43-9957d51adb70}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.20",  "     22.05K / 16-bit / 1 ch WAVEFORMATEX",                           0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_19,                              "{ba6fd0c9-7f51-4f8d-afea-a5ac93d5e4d8}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.21",  "     48K / 24-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_20,                              "{da2b4d51-c774-488b-b49a-4e25c62f0ce9}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.22",  "     48K / 32-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_21,                              "{7a69a723-3433-46c3-a97a-903edfadf27b}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.23",  "     44.1K / 16-bit / 2 ch WAVEFORMATEX",                            0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_22,                              "{e4b97c46-772f-4fbc-a4e3-cedd60454e3a}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.24",  "     96K / 16-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_23,                              "{094e2a95-bbe4-41f0-903d-be1dd4306d13}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.25",  "     16K / 16-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_24,                              "{8d734318-e1a5-4616-98de-09f96d4d09bf}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.26",  "     11.025K / 16-bit / 2 ch WAVEFORMATEX",                          0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_25,                              "{ccc1fd7d-7f4f-42c1-bc9a-deafe35f9370}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.27",  "     22.05 / 16-bit / 2 ch WAVEFORMATEX",                            0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_26,                              "{1d6e7cf6-1084-4b14-8af6-6ccdf49c05b2}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.28",  "     64K / 16-bit / 8 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_27,                              "{8c3c2e09-1428-4687-aa2c-2cb37656663f}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.29",  "     16K / 24-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_28,                              "{2537c25c-b479-4786-9a5f-100da4d99962}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.30",  "     64K / 24-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_29,                              "{763da409-7906-493e-96a8-38510113b7e9}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.31",  "     11.025K / 32-bit / 8 ch WAVEFORMATEXENSIBLE",                   0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_30,                              "{b7706297-1d6e-4358-a1f5-59fc11f18837}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.32",  "     32K / 16-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_31,                              "{b35e73f4-c66f-4ce2-a255-cd8282b3014b}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.33",  "     3K / 8-bit / 8 ch WAVEFORMATEXENSIBLE",                         0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_32,                              "{f14c3c3f-7881-49ad-91cb-ff40d0ec18bf}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.34",  "     88.2K / 32-bit / 6 ch WAVEFORMATEXENSIBLE",                     0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_33,                              "{470ff2d1-a81d-4648-9bb6-ce57b7d0501c}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.35",  "     96K / 32-bit / 8 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_34,                              "{0b79a25d-93d6-4877-88dd-2642f9823dca}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.36",  "     16K / 8-bit / 6 ch WAVEFORMATEXENSIBLE",                        0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_35,                              "{17b16f12-48d2-489b-b23c-ef42400d1fe5}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.37",  "     3K / 32-bit / 6 ch WAVEFORMATEXENSIBLE",                        0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_36,                              "{cb15ee27-5dbb-4272-97aa-6d6d0c84fee2}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.38",  "     8K / 8-bit / 6 ch WAVEFORMATEXENSIBLE",                         0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_37,                              "{9f62c565-6524-472a-9703-1b34f302b846}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.39",  "     48K / 8-bit / 8 ch WAVEFORMATEXENSIBLE",                        0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_38,                              "{23fccd2b-fb33-4710-8550-230288735bdc}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.40",  "     96K / 16-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_39,                              "{be016418-1756-4cca-8f63-b91be7b33972}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.41",  "     11.025K / 16-bit / 6 ch WAVEFORMATEXENSIBLE",                   0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_40,                              "{50af23dd-e99d-42b4-bb28-daf53cc25c14}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.42",  "     192K / 24-bit / 8 ch WAVEFORMATEXENSIBLE",                      0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_41,                              "{bc05a11e-e702-468d-a4dd-33d5a7386f8e}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.43",  "     8K / 32-bit / 8 ch WAVEFORMATEXENSIBLE",                        0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_42,                              "{cd0e417f-0dbc-4843-80eb-6517a89f7d21}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.44",  "     88.2K / 24-bit / 24 ch WAVEFORMATEXENSIBLE",                    0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_43,                              "{c6df96ed-027d-45a1-82a7-b3025adfd191}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.45",  "     22.05K / 24-bit / 8 ch WAVEFORMATEXENSIBLE",                    0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_44,                              "{f9fdb636-db0a-49e1-b36f-2fd2f8aaf3bc}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.46",  "     48K / 32-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_45,                              "{56868ff5-551c-4268-9066-925257f8c05c}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.47",  "     192K / 8-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_46,                              "{76619b67-edc7-4a83-af36-c7581f8445f1}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.48",  "     32K / 32-bit / 8 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_47,                              "{eb904240-5340-455f-be25-936518febcfe}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.49",  "     44.1K / 24-bit / 6 ch WAVEFORMATEXENSIBLE",                     0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_48,                              "{8101ffe3-bfdb-4b49-9fe3-b97231f544b8}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.50",  "     22.05K / 8-bit / 6 ch WAVEFORMATEXENSIBLE",                     0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_49,                              "{653a5cdc-02f4-40a0-9871-7e6ceff96b98}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.51",  "     44.1K / 16-bit / 8 ch WAVEFORMATEXENSIBLE",                     0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_50,                              "{d027e385-6cba-4898-ab39-cd074704f9f0}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.52",  "     16K / 32-bit / 32 ch WAVEFORMATEXENSIBLE",                      0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_51,                              "{e3ea7580-f4de-4c99-9001-13ac4ea6771e}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.53",  "     88.2K / 8-bit / 8 ch WAVEFORMATEXENSIBLE",                      0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_52,                              "{af9be46b-9068-4f31-a4cd-d01328fc06f1}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.54",  "     16K / 16-bit / 16 ch WAVEFORMATEXENSIBLE",                      0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_53,                              "{5ffd1396-7eaa-48f4-b01b-c797fe999f85}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.55",  "     48K / 32-bit (20) / 2 ch WAVEFORMATEXENSIBLE",                  0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_54,                              "{96f288d8-e7d0-4764-9ea9-7cd9ce4b60ba}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.56",  "     48K / 32-bit (24) / 2 ch WAVEFORMATEXENSIBLE",                  0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_55,                              "{4ee6c61b-9afd-4bf6-ba6e-4a5388ae1785}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.57",  "     48K / 32-bit (32) / 2 ch WAVEFORMATEXENSIBLE",                  0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_56,                              "{fb30a3b5-7d88-4a3f-bf97-274a655a8fb2}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.58",  "     48K / 16-bit / 4 ch (QUAD) WAVEFORMATEXENSIBLE",                0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_57,                              "{dbe58dc4-ebab-474e-9d7f-f7aef6c32be5}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.59",  "     48K / 16-bit / 4 ch (SURROUND WAVEFORMATEXENSIBLE",             0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_58,                              "{5a51bc56-b103-4d1d-b1ee-b9e5e69dc86a}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.60",  "     48K / 16-bit / 6 ch (5.1) WAVEFORMATEXENSIBLE",                 0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_59,                              "{b98a1b74-b5ec-4c16-ab04-0f4516762956}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.61",  "     48K / 16-bit / 8 ch (7.1) WAVEFORMATEXENSIBLE",                 0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_60,                              "{5d8a7376-7531-465c-aa0a-b6b97e809a66}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.62",  "     48K / 16-bit / 1 ch (MONO) WAVEFORMATEXENSIBLE",                0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_61,                              "{c2b9c1fd-5cd8-4e0c-9107-c35228991eaa}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.43.63",  "     48K / 16-bit / 2 ch (STEREO) WAVEFORMATEXENSIBLE",              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_Pull_62,                              "{d2af0f24-66cf-4b4c-8130-e3856be0af00}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_PARENT( "",         "   Compat Mode (SRC Default Quality)",                               0,                   0,                                                                     0,    NULL,  NULL,                                                   "{1D29DE9A-5ADE-4FB1-A6AA-5B4E832F5A2B}")
    DEVICE_TEST_PARENT( "",         "    Timer-Push Compat Capture",                                      0,                   0,                                                                     0,    NULL,  NULL,                                                   "{6F894D7B-1FCB-4F55-AF0E-B5D5805FCD17}")
    DEVICE_TEST_METHOD( "1.44.1",   "     192K / 32-bit / 1 ch WAVEFORMATEX",                             0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_0,     	            "{B1FF0527-CAAB-40E4-8F23-74A3CFDEBA99}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.2",   "     11K / 8-bit / 1 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_1,                        "{182EE788-E6B2-4E77-ABFB-8FCA18007E96}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.3",   "     22K / 32-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_2,                        "{32815C65-3E58-4C20-A79C-6C9AA2B73D35}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.4",   "     3K / 16-bit / 2 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_3,                        "{24D4AE1E-0A1C-4F49-8608-DDEBD10788CF}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.5",   "     96K / 24-bit / 1 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_4,                        "{2226F3E5-A06C-4262-81D1-4D52A0CD3D7B}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.6",   "     64K / 8-bit / 1 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_5,                        "{41417F3E-BFC1-480F-AF52-5B89CE8AEF5B}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.7",   "     96K / 8-bit / 2 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_6,                        "{8CDEA713-5A3F-4943-B4C4-B1C7D41C7810}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.8",   "     96K / 8-bit / 2 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_7,                        "{106D8BDD-DEEC-48FC-9DCA-78DDEEDDC5D4}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.9",   "     48K / 24-bit / 1 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_8,                        "{D661C615-410A-4742-970F-429DAAD26CC0}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.10",  "     48K / 16-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_9,                        "{721F2065-C51C-42AE-9045-C8961A78C881}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.11",  "     64K / 32-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_10,                       "{496F424E-E44A-42A3-8D80-C7FB59F6CCE9}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.12",  "     11.025K / 24-bit / 2 ch WAVEFORMATEX",                          0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_11,                       "{B526BA6B-71C2-41DB-9981-05BB67052A49}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.13",  "     192K / 16-bit / 2 ch WAVEFORMATEX",                             0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_12,                       "{CC801E43-38FF-4B34-9785-6B9B3185D877}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.14",  "     8K / 24-bit / 1 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_13,                       "{AC79F52C-A201-4947-85EA-7EB1B1B83B9A}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.15",  "     44.1K / 32-bit / 2 ch WAVEFORMATEX",                            0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_14,                       "{212A6276-DCFE-4D48-B42C-521334F223AD}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.16",  "     32K / 8-bit / 2 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_15,                       "{4BB540FA-766D-42E6-85F5-6E7832DB0011}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.17",  "     32K / 24-bit / 1 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_16,                       "{56CB59F0-27B5-4675-9FCD-AC9924756EB3}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.18",  "     44.1K / 8-bit / 1 ch WAVEFORMATEX",                             0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_17,                       "{23DCF7DD-F03D-440A-A4AC-BB26C20AF7A4}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.19",  "     3K / 24-bit / 1 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_18,                       "{8FC2FBB6-6BF5-4937-A728-6634653A86F0}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.20",  "     22.05K / 16-bit / 1 ch WAVEFORMATEX",                           0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_19,                       "{92ACA47C-E8F5-4975-986D-279E675C7560}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.21",  "     48K / 24-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_20,                       "{75DCF608-6D4C-430B-9F38-906167F593AA}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.22",  "     48K / 32-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_21,                       "{53DE6744-1D10-4BB2-8DE3-C0A3358E008B}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.23",  "     44.1K / 16-bit / 2 ch WAVEFORMATEX",                            0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_22,                       "{295CF9F4-E53D-40C6-BF66-B45949379C36}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.24",  "     96K / 16-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_23,                       "{088B37C3-4622-4C22-A0F2-28862928FBCE}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.25",  "     16K / 16-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_24,                       "{F970A7FF-B834-473A-BAF7-D5F8E5E82341}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.26",  "     11.025K / 16-bit / 2 ch WAVEFORMATEX",                          0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_25,                       "{B1E63270-6D4D-477F-B9FA-5073DD766BDB}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.27",  "     22.05 / 16-bit / 2 ch WAVEFORMATEX",                            0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_26,                       "{75B32549-9073-4EF0-90E7-A14FE41BEBEA}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.28",  "     64K / 16-bit / 8 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_27,                       "{B447B8B5-127E-43A8-9E18-F90668C2D90F}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.29",  "     16K / 24-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_28,                       "{F78E8ABD-85EE-457F-8301-18D57F012DE6}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.30",  "     64K / 24-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_29,                       "{0F9068CA-4675-4B87-A275-3050F38D9202}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.31",  "     11.025K / 32-bit / 8 ch WAVEFORMATEXENSIBLE",                   0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_30,                       "{1F421C99-3154-4727-96E6-8251231DECA0}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.32",  "     32K / 16-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_31,                       "{A587C995-AD3D-4E46-B200-0CA45EB8F4BB}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.33",  "     3K / 8-bit / 8 ch WAVEFORMATEXENSIBLE",                         0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_32,                       "{852161BC-2C57-46B2-BC4D-18723B989601}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.34",  "     88.2K / 32-bit / 6 ch WAVEFORMATEXENSIBLE",                     0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_33,                       "{0ED124DF-A269-41B6-866D-ADF536FEF862}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.35",  "     96K / 32-bit / 8 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_34,                       "{18845780-218F-46B3-B629-37D66042D0E3}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.36",  "     16K / 8-bit / 6 ch WAVEFORMATEXENSIBLE",                        0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_35,                       "{D6E234B8-BD1B-4222-90E2-DB35F728D59C}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.37",  "     3K / 32-bit / 6 ch WAVEFORMATEXENSIBLE",                        0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_36,                       "{F097CDAA-984B-4A4C-A2FD-1A119A28EAF6}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.38",  "     8K / 8-bit / 6 ch WAVEFORMATEXENSIBLE",                         0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_37,                       "{C568E9E0-5BDA-4A05-B23D-4CD7D288E18A}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.39",  "     48K / 8-bit / 8 ch WAVEFORMATEXENSIBLE",                        0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_38,                       "{0D89BC63-82C7-41CA-BCA6-E75FC5D91F2E}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.40",  "     96K / 16-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_39,                       "{9CAD7A0B-A89D-43F8-BEBE-355DB12431AF}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.41",  "     11.025K / 16-bit / 6 ch WAVEFORMATEXENSIBLE",                   0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_40,                       "{ECA6DF83-321A-4456-84EC-4FA5B2A7EC0E}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.42",  "     192K / 24-bit / 8 ch WAVEFORMATEXENSIBLE",                      0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_41,                       "{C1585036-A24E-48D1-8F8B-CCB9AAB61002}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.43",  "     8K / 32-bit / 8 ch WAVEFORMATEXENSIBLE",                        0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_42,                       "{1B990F67-E16E-4188-BF27-4DC4AF9965D5}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.44",  "     88.2K / 24-bit / 24 ch WAVEFORMATEXENSIBLE",                    0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_43,                       "{C31841E8-0960-470F-A6B7-876AE3A04810}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.45",  "     22.05K / 24-bit / 8 ch WAVEFORMATEXENSIBLE",                    0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_44,                       "{2A080F99-7CEE-4FB5-ACB5-F040675C10F0}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.46",  "     48K / 32-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_45,                       "{B729AF61-ECF6-42CE-841A-CDC236845E07}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.47",  "     192K / 8-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_46,                       "{703DF077-BE3B-4D2F-88B4-935711FCB656}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.48",  "     32K / 32-bit / 8 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_47,                       "{EA9A09C9-7FF1-497A-98CB-F5889AC6CBDB}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.49",  "     44.1K / 24-bit / 6 ch WAVEFORMATEXENSIBLE",                     0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_48,                       "{5609593D-0737-43CD-A64A-BFB917EA492D}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.50",  "     22.05K / 8-bit / 6 ch WAVEFORMATEXENSIBLE",                     0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_49,                       "{C6EDF256-94AF-47D7-8078-613C125E2DE0}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.51",  "     44.1K / 16-bit / 8 ch WAVEFORMATEXENSIBLE",                     0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_50,                       "{41C65A2F-F842-4CD6-B0D9-AD117E68B985}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.52",  "     16K / 32-bit / 32 ch WAVEFORMATEXENSIBLE",                      0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_51,                       "{D3B01BE6-93A2-470C-8734-6E1C7434FAEB}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.53",  "     88.2K / 8-bit / 8 ch WAVEFORMATEXENSIBLE",                      0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_52,                       "{776611D8-C13D-4FE8-9509-0DDB86D90B37}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.54",  "     16K / 16-bit / 16 ch WAVEFORMATEXENSIBLE",                      0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_53,                       "{F946521D-38CD-4B3D-A61E-4D78FE69DA1A}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.55",  "     48K / 32-bit (20) / 2 ch WAVEFORMATEXENSIBLE",                  0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_54,                       "{BCF080F0-8CF6-42D0-8DF5-083FBE6879D9}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.56",  "     48K / 32-bit (24) / 2 ch WAVEFORMATEXENSIBLE",                  0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_55,                       "{76AC3E64-A0D9-4E86-8CF9-8034808188B7}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.57",  "     48K / 32-bit (32) / 2 ch WAVEFORMATEXENSIBLE",                  0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_56,                       "{8AB41D19-7867-4A31-8151-985357DEB0DF}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.58",  "     48K / 16-bit / 4 ch (QUAD) WAVEFORMATEXENSIBLE",                0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_57,                       "{D12A0EB2-8B97-4986-9A36-78F77A4567CB}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.59",  "     48K / 16-bit / 4 ch (SURROUND WAVEFORMATEXENSIBLE",             0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_58,                       "{A65D8C9B-BD6E-49D6-9AF8-C4DB5A4344AD}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.60",  "     48K / 16-bit / 6 ch (5.1) WAVEFORMATEXENSIBLE",                 0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_59,                       "{993D7EE9-5C70-4A5A-A172-83E3F0DD1C6F}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.61",  "     48K / 16-bit / 8 ch (7.1) WAVEFORMATEXENSIBLE",                 0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_60,                       "{1370FBEC-7B9F-4DBC-8C0D-BE260BFAC6EB}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.62",  "     48K / 16-bit / 1 ch (MONO) WAVEFORMATEXENSIBLE",                0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_61,                       "{2A177930-FFA8-4839-8340-86E551AF6C68}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.44.63",  "     48K / 16-bit / 2 ch (STEREO) WAVEFORMATEXENSIBLE",              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Push_62,                       "{71F3DAC3-2019-4044-AB9F-CA263A922134}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_PARENT( "",         "    Event-Pull Compat Capture",                                      0,                   0,                                                                     0,    NULL,  NULL,                                                   "{FADA2FBF-77F5-4CC9-8483-6AD403A0C999}")
    DEVICE_TEST_METHOD( "1.45.1",   "     192K / 32-bit / 1 ch WAVEFORMATEX",                             0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_0,                        "{2895E2C3-2465-4D98-AF48-78755B6E6E04}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.2",   "     11K / 8-bit / 1 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_1,                        "{CF4A6B0B-3305-4134-BD84-2C35048A9CEF}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.3",   "     22K / 32-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_2,                        "{A2BEF03A-4F65-4F01-80CD-6E4142B49664}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.4",   "     3K / 16-bit / 2 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_3,                        "{BC0EDAAD-9CEB-4A2E-B8AF-95BF776ECB96}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.5",   "     96K / 24-bit / 1 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_4,                        "{8AB73471-B86C-4313-A826-8B59AEF64417}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.6",   "     64K / 8-bit / 1 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_5,                        "{EF374232-B80B-4C1E-B531-17C6690CC9F0}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.7",   "     96K / 8-bit / 2 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_6,                        "{D94986F0-CAED-46AE-9167-8FE3A23AEBF6}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.8",   "     96K / 8-bit / 2 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_7,                        "{02EDBAE2-FC85-4B94-8D2B-5F83CFCB5B26}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.9",   "     48K / 24-bit / 1 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_8,                        "{50DAAE6D-27DD-48E8-BD40-BC708160D3ED}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.10",  "     48K / 16-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_9,                        "{FB3C0601-1E00-4B38-98C1-8ABF74D54572}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.11",  "     64K / 32-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_10,                       "{B24FB5CF-59A9-41A6-8AC2-F38E4BC26EB9}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.12",  "     11.025K / 24-bit / 2 ch WAVEFORMATEX",                          0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_11,                       "{98DD0217-DBEE-4545-95A9-0B729D331DB9}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.13",  "     192K / 16-bit / 2 ch WAVEFORMATEX",                             0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_12,                       "{A4C092DE-A284-4EBC-B487-62EDBA51BA57}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.14",  "     8K / 24-bit / 1 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_13,                       "{AF8F883D-B5B2-4518-8481-BCEFDF280E88}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.15",  "     44.1K / 32-bit / 2 ch WAVEFORMATEX",                            0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_14,                       "{3C483472-BFB2-4553-BF3B-97AC97ED8F27}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.16",  "     32K / 8-bit / 2 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_15,                       "{DCAE5590-937C-415F-B5BD-E54132A4B24C}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.17",  "     32K / 24-bit / 1 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_16,                       "{996F6A1C-7082-4138-B47C-5FCFD886BD0F}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.18",  "     44.1K / 8-bit / 1 ch WAVEFORMATEX",                             0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_17,                       "{A4074FD0-1355-4D69-A269-70B1DC01B167}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.19",  "     3K / 24-bit / 1 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_18,                       "{007471B6-EC88-4E0B-B7C8-4E22CBEAF8E4}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.20",  "     22.05K / 16-bit / 1 ch WAVEFORMATEX",                           0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_19,                       "{2172483A-072F-444A-8317-FB73E478A74F}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.21",  "     48K / 24-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_20,                       "{D7BB9B31-6208-4A5A-8DB0-98612C80DD98}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.22",  "     48K / 32-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_21,                       "{1A9BF1CB-190F-4A24-AC50-EB243540DC27}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.23",  "     44.1K / 16-bit / 2 ch WAVEFORMATEX",                            0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_22,                       "{35FB2A70-B186-4DA3-B290-3B4E9A5F2CC8}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.24",  "     96K / 16-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_23,                       "{73956F7E-73E3-4675-9B5D-77CA9FD20520}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.25",  "     16K / 16-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_24,                       "{ECE2301D-6C6F-4DFA-91E1-527910EE0966}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.26",  "     11.025K / 16-bit / 2 ch WAVEFORMATEX",                          0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_25,                       "{ED1C7933-6F41-4C64-9404-C239928607FD}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.27",  "     22.05 / 16-bit / 2 ch WAVEFORMATEX",                            0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_26,                       "{882B0478-0DCB-49C5-A0FB-D0491D65BEF4}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.28",  "     64K / 16-bit / 8 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_27,                       "{90FF6048-60F0-4BB9-8D9E-D68DF99E0C89}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.29",  "     16K / 24-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_28,                       "{A16818BE-B604-497E-9392-7537CDD4BD1B}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.30",  "     64K / 24-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_29,                       "{0A024FB3-2705-43E6-8949-621F15E5A899}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.31",  "     11.025K / 32-bit / 8 ch WAVEFORMATEXENSIBLE",                   0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_30,                       "{B4AB341A-D09A-4ADB-9DAF-41CA6D28BFC7}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.32",  "     32K / 16-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_31,                       "{55C39BB2-72EA-46BF-B0DB-BADEC1245EE5}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.33",  "     3K / 8-bit / 8 ch WAVEFORMATEXENSIBLE",                         0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_32,                       "{4EA87572-33CD-4A0D-BCB4-FE8ECEDE4556}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.34",  "     88.2K / 32-bit / 6 ch WAVEFORMATEXENSIBLE",                     0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_33,                       "{39BE28E7-1743-4B8C-9B08-7D43DE56A128}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.35",  "     96K / 32-bit / 8 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_34,                       "{41E79E31-C2AD-4CB4-BF76-54C47122E927}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.36",  "     16K / 8-bit / 6 ch WAVEFORMATEXENSIBLE",                        0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_35,                       "{3717CF34-F8CE-4E07-B889-0C7BBBC64CAF}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.37",  "     3K / 32-bit / 6 ch WAVEFORMATEXENSIBLE",                        0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_36,                       "{956C541F-27F4-4863-A9F3-4EDE3FB19A89}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.38",  "     8K / 8-bit / 6 ch WAVEFORMATEXENSIBLE",                         0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_37,                       "{77637ADC-E263-423A-848B-354F35C507F4}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.39",  "     48K / 8-bit / 8 ch WAVEFORMATEXENSIBLE",                        0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_38,                       "{EDA5FCE2-671B-425B-BFCF-E31160549367}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.40",  "     96K / 16-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_39,                       "{D1E2B61B-702A-484F-B2E9-4F6877A971BE}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.41",  "     11.025K / 16-bit / 6 ch WAVEFORMATEXENSIBLE",                   0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_40,                       "{626F1BDA-08AF-4642-970D-CAEFB6BD8CA8}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.42",  "     192K / 24-bit / 8 ch WAVEFORMATEXENSIBLE",                      0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_41,                       "{070D227B-DCD8-498B-AA7E-DE02FCB09F90}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.43",  "     8K / 32-bit / 8 ch WAVEFORMATEXENSIBLE",                        0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_42,                       "{88799FF3-6D86-4A0B-9F83-735BDA8BAD2E}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.44",  "     88.2K / 24-bit / 24 ch WAVEFORMATEXENSIBLE",                    0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_43,                       "{8A243519-AA3C-4D0A-8309-581C773268B4}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.45",  "     22.05K / 24-bit / 8 ch WAVEFORMATEXENSIBLE",                    0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_44,                       "{33B0CC08-AD4D-4CA2-A781-37FE327BFB14}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.46",  "     48K / 32-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_45,                       "{862FF900-07F0-433D-868F-1CA44E5E82D1}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.47",  "     192K / 8-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_46,                       "{CAD9EEF9-0CF3-4286-A517-2EF7158FA7F8}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.48",  "     32K / 32-bit / 8 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_47,                       "{79661D1C-862D-496F-9A4E-2D0714C7E5DF}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.49",  "     44.1K / 24-bit / 6 ch WAVEFORMATEXENSIBLE",                     0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_48,                       "{CE856AF0-02C3-4919-B5FE-286DF8E47E9D}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.50",  "     22.05K / 8-bit / 6 ch WAVEFORMATEXENSIBLE",                     0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_49,                       "{621F1EAE-853A-4814-AEB6-99D45E89B545}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.51",  "     44.1K / 16-bit / 8 ch WAVEFORMATEXENSIBLE",                     0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_50,                       "{FACCE043-D7C5-4ACD-AFB7-F239EEF38067}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.52",  "     16K / 32-bit / 32 ch WAVEFORMATEXENSIBLE",                      0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_51,                       "{55BEDD36-4381-4FED-A051-04F4A401A923}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.53",  "     88.2K / 8-bit / 8 ch WAVEFORMATEXENSIBLE",                      0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_52,                       "{5A71AE65-1BB2-4E46-947E-EA74D35FBFF8}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.54",  "     16K / 16-bit / 16 ch WAVEFORMATEXENSIBLE",                      0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_53,                       "{FD92623A-AB39-4EEC-A072-A21D45CE01D0}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.55",  "     48K / 32-bit (20) / 2 ch WAVEFORMATEXENSIBLE",                  0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_54,                       "{BD795DAA-D17A-46EF-AE57-66A7B18521B1}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.56",  "     48K / 32-bit (24) / 2 ch WAVEFORMATEXENSIBLE",                  0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_55,                       "{342F19BA-1C6B-4011-8F36-073DCE10FA56}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.57",  "     48K / 32-bit (32) / 2 ch WAVEFORMATEXENSIBLE",                  0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_56,                       "{DD94FEA2-B41C-40BB-BB52-6A881827939D}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.58",  "     48K / 16-bit / 4 ch (QUAD) WAVEFORMATEXENSIBLE",                0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_57,                       "{C1F5B211-899D-4D35-92CA-095E2B45EBDB}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.59",  "     48K / 16-bit / 4 ch (SURROUND WAVEFORMATEXENSIBLE",             0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_58,                       "{88A530B5-9879-4DA9-A482-E6E325F50392}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.60",  "     48K / 16-bit / 6 ch (5.1) WAVEFORMATEXENSIBLE",                 0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_59,                       "{4DFFE91E-3A0F-48F2-AF6D-1BFAB316A389}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.61",  "     48K / 16-bit / 8 ch (7.1) WAVEFORMATEXENSIBLE",                 0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_60,                       "{CE044F44-9A7B-4BA7-8A99-FCA1228D9941}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.62",  "     48K / 16-bit / 1 ch (MONO) WAVEFORMATEXENSIBLE",                0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_61,                       "{B9BFB650-3250-4820-B829-CB6B12F07618}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.45.63",  "     48K / 16-bit / 2 ch (STEREO) WAVEFORMATEXENSIBLE",              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Compat_SRC_Enhanced_Pull_62,                       "{4A634F34-C8A7-473F-A433-8E73BDD97521}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_PARENT( "",         "   Exclusive Mode",                                                  0,                   0,                                                                     0,    NULL,  NULL,                                                   "{2ff2f8c2-8063-4d61-a145-b89e8294cdbd}")
    DEVICE_TEST_PARENT( "",         "    Timer-Push Exclusive Capture",                                   0,                   0,                                                                     0,    NULL,  NULL,                                                   "{7ddaa051-94b1-429d-9eab-094ed8d831ce}")
    DEVICE_TEST_METHOD( "1.46.1",   "     192K / 32-bit / 1 ch WAVEFORMATEX",                             0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_0,                            "{396328c1-48c7-438f-9ec7-71c636aa2369}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.2",   "     11K / 8-bit / 1 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_1,                            "{ed11d933-3276-4e12-a9b5-9205f0438ace}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.3",   "     22K / 32-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_2,                            "{fb7ee8dd-5ac9-4eaa-b430-793ebaf2aecc}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.4",   "     3K / 16-bit / 2 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_3,                            "{d88c0530-d47b-4b67-a631-649dfd1ed888}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.5",   "     96K / 24-bit / 1 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_4,                            "{9bc33e7b-24b6-45a3-9b06-414d1112a925}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.6",   "     64K / 8-bit / 1 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_5,                            "{c84143a3-e22a-4f1e-bc88-4b1a1a541d25}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.7",   "     96K / 8-bit / 2 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_6,                            "{c417b70d-ec66-4810-9f9f-fb651703be93}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.8",   "     96K / 8-bit / 2 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_7,                            "{95b0180f-8892-4129-a72f-c76ed86d88f3}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.9",   "     48K / 24-bit / 1 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_8,                            "{a4f2235f-e516-41bc-8be4-cd2cd68c39a0}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.10",  "     48K / 16-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_9,                            "{b89143d8-e664-4445-a7a7-7b93480e219d}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.11",  "     64K / 32-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_10,                           "{f7853337-3c6e-4db2-b56a-d6e6e61c34e6}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.12",  "     11.025K / 24-bit / 2 ch WAVEFORMATEX",                          0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_11,                           "{30eedada-3179-4cda-bafd-9403706543eb}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.13",  "     192K / 16-bit / 2 ch WAVEFORMATEX",                             0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_12,                           "{fae926be-0062-49b8-9902-05490798a409}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.14",  "     8K / 24-bit / 1 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_13,                           "{c9c6927e-babe-4406-8dbe-072526209215}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.15",  "     44.1K / 32-bit / 2 ch WAVEFORMATEX",                            0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_14,                           "{cb3d5bea-a74a-4151-a462-22b908999ffc}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.16",  "     32K / 8-bit / 2 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_15,                           "{14b43803-f87e-49d8-9f0e-6a2928673df3}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.17",  "     32K / 24-bit / 1 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_16,                           "{34cb6dc8-dca1-49bc-9357-0d5e8ebdd9ee}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.18",  "     44.1K / 8-bit / 1 ch WAVEFORMATEX",                             0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_17,                           "{fee7fb44-fbe2-46f2-b48a-d835a64f40d6}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.19",  "     3K / 24-bit / 1 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_18,                           "{2dc48035-2f16-447e-8213-7717c277f3d2}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.20",  "     22.05K / 16-bit / 1 ch WAVEFORMATEX",                           0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_19,                           "{1d3c8f14-c217-4586-979a-4b5cecacdf81}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.21",  "     48K / 24-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_20,                           "{d60aaa21-3b62-4e18-af3f-8cf2f214b34a}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.22",  "     48K / 32-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_21,                           "{cfe13486-4b73-43ce-9fda-34944604f9bd}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.23",  "     44.1K / 16-bit / 2 ch WAVEFORMATEX",                            0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_22,                           "{72fb26d3-9803-4d91-b9db-efbb7b6f6e07}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.24",  "     96K / 16-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_23,                           "{64fbc375-ffb0-4c26-a6d1-7b5b3fd7b586}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.25",  "     16K / 16-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_24,                           "{525c1d70-f1be-43f9-a12b-f23b08dbc8b1}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.26",  "     11.025K / 16-bit / 2 ch WAVEFORMATEX",                          0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_25,                           "{97ce4cb8-7c9f-4322-b48e-e253f9b146ce}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.27",  "     22.05 / 16-bit / 2 ch WAVEFORMATEX",                            0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_26,                           "{ea0963e1-427c-45b3-894a-930ded815538}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.28",  "     64K / 16-bit / 8 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_27,                           "{f038153c-5c8f-4ba4-a39b-132d1fcca3f8}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.29",  "     16K / 24-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_28,                           "{b4fead98-f25f-496d-95fe-06049432a2e3}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.30",  "     64K / 24-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_29,                           "{4e8a6ac0-e609-4ede-9c96-6b095bfd465c}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.31",  "     11.025K / 32-bit / 8 ch WAVEFORMATEXENSIBLE",                   0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_30,                           "{1c471cf1-3200-4751-bd09-4535d6178199}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.32",  "     32K / 16-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_31,                           "{0a4c5a6f-0c94-4d4f-b934-cb8ef16e1876}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.33",  "     3K / 8-bit / 8 ch WAVEFORMATEXENSIBLE",                         0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_32,                           "{487220a3-89b6-423c-8278-dab95a92fa8d}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.34",  "     88.2K / 32-bit / 6 ch WAVEFORMATEXENSIBLE",                     0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_33,                           "{164e2304-6c58-41a8-9416-d9d88c87f78c}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.35",  "     96K / 32-bit / 8 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_34,                           "{73679235-c2f9-49d0-85b6-64d16a3ebf03}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.36",  "     16K / 8-bit / 6 ch WAVEFORMATEXENSIBLE",                        0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_35,                           "{1c42504c-2e9b-4c71-8ebd-82e5c0bd8b3a}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.37",  "     3K / 32-bit / 6 ch WAVEFORMATEXENSIBLE",                        0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_36,                           "{50b83fdf-a7dc-41d4-8153-394f2dd70b37}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.38",  "     8K / 8-bit / 6 ch WAVEFORMATEXENSIBLE",                         0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_37,                           "{0f953203-f59e-460d-bb21-9d2fd308a61b}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.39",  "     48K / 8-bit / 8 ch WAVEFORMATEXENSIBLE",                        0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_38,                           "{35b92196-3333-42fb-9692-43f444466fe6}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.40",  "     96K / 16-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_39,                           "{1900243e-3927-48d0-bf72-b69ab5dd3ef8}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.41",  "     11.025K / 16-bit / 6 ch WAVEFORMATEXENSIBLE",                   0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_40,                           "{d72b1609-368a-40a1-a41b-c4950fab713c}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.42",  "     192K / 24-bit / 8 ch WAVEFORMATEXENSIBLE",                      0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_41,                           "{2ba13d15-e616-4a68-8fa5-45914da9625d}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.43",  "     8K / 32-bit / 8 ch WAVEFORMATEXENSIBLE",                        0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_42,                           "{29578753-f48e-43c9-a96c-2aa24e3d97dd}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.44",  "     88.2K / 24-bit / 24 ch WAVEFORMATEXENSIBLE",                    0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_43,                           "{9b9f961d-d28a-4c2c-a0ca-01ca572ea37b}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.45",  "     22.05K / 24-bit / 8 ch WAVEFORMATEXENSIBLE",                    0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_44,                           "{d85c32f3-9f3f-43d0-bb3d-66d4f5cc858c}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.46",  "     48K / 32-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_45,                           "{e856c355-d24c-4b8c-b1e9-be6a5bc406b7}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.47",  "     192K / 8-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_46,                           "{bafc2749-c433-41d4-87fe-86411d4100a8}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.48",  "     32K / 32-bit / 8 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_47,                           "{6c5d0765-6409-4e5a-9a5f-10496144cb09}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.49",  "     44.1K / 24-bit / 6 ch WAVEFORMATEXENSIBLE",                     0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_48,                           "{a04a5c97-8480-4f44-9bff-3391164ac79f}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.50",  "     22.05K / 8-bit / 6 ch WAVEFORMATEXENSIBLE",                     0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_49,                           "{f5a53ac1-542d-4c81-8fee-cf00d32baadc}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.51",  "     44.1K / 16-bit / 8 ch WAVEFORMATEXENSIBLE",                     0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_50,                           "{0b4517c8-2be8-4d05-a547-cb1acf31d59d}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.52",  "     16K / 32-bit / 32 ch WAVEFORMATEXENSIBLE",                      0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_51,                           "{a02429ba-4796-42f8-a90a-2e430a22e816}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.53",  "     88.2K / 8-bit / 8 ch WAVEFORMATEXENSIBLE",                      0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_52,                           "{697d136a-1700-4fd0-b3a2-9ba04f68d10e}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.54",  "     16K / 16-bit / 16 ch WAVEFORMATEXENSIBLE",                      0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_53,                           "{4fd953f4-c025-404f-9d93-ae15938503c7}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.55",  "     48K / 32-bit (20) / 2 ch WAVEFORMATEXENSIBLE",                  0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_54,                           "{31f2dfff-5612-4696-87d6-0786aa6b463a}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.56",  "     48K / 32-bit (24) / 2 ch WAVEFORMATEXENSIBLE",                  0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_55,                           "{5453c7c5-37ed-45fc-81a3-533aa92b334d}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.57",  "     48K / 32-bit (32) / 2 ch WAVEFORMATEXENSIBLE",                  0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_56,                           "{76fa90d4-eb13-4b5e-9bed-fdf47c937cb0}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.58",  "     48K / 16-bit / 4 ch (QUAD) WAVEFORMATEXENSIBLE",                0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_57,                           "{e276f451-8cd3-4e8d-8bb9-9889a77c0f37}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.59",  "     48K / 16-bit / 4 ch (SURROUND WAVEFORMATEXENSIBLE",             0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_58,                           "{812b8c01-1cc7-448c-a24e-ac478134cd22}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.60",  "     48K / 16-bit / 6 ch (5.1) WAVEFORMATEXENSIBLE",                 0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_59,                           "{fc858e98-6892-443a-afb6-ef4ce38c904e}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.61",  "     48K / 16-bit / 8 ch (7.1) WAVEFORMATEXENSIBLE",                 0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_60,                           "{86cd686f-5737-49e9-bb14-c28ead5e0ccc}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.62",  "     48K / 16-bit / 1 ch (MONO) WAVEFORMATEXENSIBLE",                0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_61,                           "{dd7b7f97-6b56-4ab5-8fde-327c7b55da22}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.46.63",  "     48K / 16-bit / 2 ch (STEREO) WAVEFORMATEXENSIBLE",              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Push_62,                           "{161215a4-7bcf-4003-a208-f9c4f039d7fd}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_PARENT( "",         "    Event-Pull Exclusive Capture",                                   0,                   0,                                                                     0,    NULL,  NULL,                                                   "{d458b379-915c-42cb-8d08-b490e59bac2f}")
    DEVICE_TEST_METHOD( "1.47.1",   "     192K / 32-bit / 1 ch WAVEFORMATEX",                             0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_0,                            "{89512043-654b-4f7e-be85-61ec4da067d0}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.2",   "     11K / 8-bit / 1 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_1,                            "{a7d1f5c6-e234-497f-b450-0b1d09249577}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.3",   "     22K / 32-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_2,                            "{039797c5-5038-4f06-a2f0-0ccea6a9af65}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.4",   "     3K / 16-bit / 2 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_3,                            "{9c3b90cd-4011-4072-af3f-618db9a0ee2c}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.5",   "     96K / 24-bit / 1 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_4,                            "{731669f1-549d-4b4e-9082-0ca334301745}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.6",   "     64K / 8-bit / 1 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_5,                            "{d0d891c6-77ee-4e79-acfc-3e68dc9a322b}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.7",   "     96K / 8-bit / 2 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_6,                            "{28153184-9621-4421-b43e-db5d823c33ff}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.8",   "     96K / 8-bit / 2 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_7,                            "{98f93b83-2786-4e4b-8b83-e265a022ed1b}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.9",   "     48K / 24-bit / 1 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_8,                            "{0baec211-c2d7-49fb-9311-19752ca26f94}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.10",  "     48K / 16-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_9,                            "{1a3cb1c5-7647-494c-ab8a-249f18e7298d}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.11",  "     64K / 32-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_10,                           "{c0991ef9-d43a-4112-94ad-63f7e9cb6639}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.12",  "     11.025K / 24-bit / 2 ch WAVEFORMATEX",                          0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_11,                           "{e031f52d-a625-47aa-a0a5-d9fb30051a60}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.13",  "     192K / 16-bit / 2 ch WAVEFORMATEX",                             0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_12,                           "{4a4dd61f-7553-4df5-a7a4-0e40940b8a48}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.14",  "     8K / 24-bit / 1 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_13,                           "{37810bad-00e9-46fa-97ee-cb78fc3510e3}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.15",  "     44.1K / 32-bit / 2 ch WAVEFORMATEX",                            0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_14,                           "{cceea0de-0f59-410d-b89a-561443c6993b}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.16",  "     32K / 8-bit / 2 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_15,                           "{0c78abe5-bb12-4a77-9d3f-e8e908327480}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.17",  "     32K / 24-bit / 1 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_16,                           "{0bcda2ac-8f81-4690-8bf4-b4b6da88ccce}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.18",  "     44.1K / 8-bit / 1 ch WAVEFORMATEX",                             0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_17,                           "{edbe0407-0b65-4538-9855-f5ca236539a2}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.19",  "     3K / 24-bit / 1 ch WAVEFORMATEX",                               0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_18,                           "{145428ec-2039-41c3-8d47-d9c98038d626}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.20",  "     22.05K / 16-bit / 1 ch WAVEFORMATEX",                           0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_19,                           "{a44e0f99-f4de-435e-8647-28cdf164b3ab}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.21",  "     48K / 24-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_20,                           "{05589b9f-7e88-44e2-8ca5-fdcf055d32d8}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.22",  "     48K / 32-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_21,                           "{8cf528cb-8963-40fc-820c-a56bdaaba53e}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.23",  "     44.1K / 16-bit / 2 ch WAVEFORMATEX",                            0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_22,                           "{a160126c-ddf7-40c7-844a-0cd352bec219}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.24",  "     96K / 16-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_23,                           "{734a4677-3ad4-4944-a106-54ecd4aac234}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.25",  "     16K / 16-bit / 2 ch WAVEFORMATEX",                              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_24,                           "{9106d148-1bec-4b87-97c0-f6421a852046}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.26",  "     11.025K / 16-bit / 2 ch WAVEFORMATEX",                          0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_25,                           "{eab32271-61b6-4220-b7c2-2b0cfb1e1d86}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.27",  "     22.05 / 16-bit / 2 ch WAVEFORMATEX",                            0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_26,                           "{903e38a5-5445-4a46-842e-a65e9bb96408}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.28",  "     64K / 16-bit / 8 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_27,                           "{946829f0-2858-4b9d-a1ca-3e01f0ad1d92}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.29",  "     16K / 24-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_28,                           "{18b061b5-0e00-4d11-9e41-c05d14d569ef}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.30",  "     64K / 24-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_29,                           "{ab70943f-c90d-43e9-9620-54508e75882f}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.31",  "     11.025K / 32-bit / 8 ch WAVEFORMATEXENSIBLE",                   0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_30,                           "{5f2e90e6-a1f3-4f36-96d4-0cbcf49b4424}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.32",  "     32K / 16-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_31,                           "{8f59fdb2-c6b8-4794-ab05-8b0f344cb479}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.33",  "     3K / 8-bit / 8 ch WAVEFORMATEXENSIBLE",                         0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_32,                           "{bdf1c4d3-4785-47a3-8901-0ab78bb2b11b}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.34",  "     88.2K / 32-bit / 6 ch WAVEFORMATEXENSIBLE",                     0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_33,                           "{fc5240d1-a87b-4d09-b51d-d684ad92671b}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.35",  "     96K / 32-bit / 8 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_34,                           "{07710503-8400-44ed-bd64-e1d8fbd92d95}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.36",  "     16K / 8-bit / 6 ch WAVEFORMATEXENSIBLE",                        0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_35,                           "{5a1a2d39-c2cf-49a3-9d7d-f03ec5faf935}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.37",  "     3K / 32-bit / 6 ch WAVEFORMATEXENSIBLE",                        0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_36,                           "{8a125eb7-8b2a-448b-b224-fbae952f6de6}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.38",  "     8K / 8-bit / 6 ch WAVEFORMATEXENSIBLE",                         0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_37,                           "{bc7e668e-878f-42e9-9ad6-b3d90015f266}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.39",  "     48K / 8-bit / 8 ch WAVEFORMATEXENSIBLE",                        0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_38,                           "{cffa0e72-409a-47eb-9dd8-f5ba440707c6}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.40",  "     96K / 16-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_39,                           "{28fa31c7-fae9-4d5a-8620-6dc06d6c4283}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.41",  "     11.025K / 16-bit / 6 ch WAVEFORMATEXENSIBLE",                   0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_40,                           "{50e8d8b5-a25b-400e-98d5-7d0e450f4a82}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.42",  "     192K / 24-bit / 8 ch WAVEFORMATEXENSIBLE",                      0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_41,                           "{5ca89643-24b3-4120-85f7-ad847d5583e7}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.43",  "     8K / 32-bit / 8 ch WAVEFORMATEXENSIBLE",                        0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_42,                           "{58c0e35c-86c0-4de9-aeb9-8ef023e354ce}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.44",  "     88.2K / 24-bit / 24 ch WAVEFORMATEXENSIBLE",                    0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_43,                           "{69492cec-2302-4e91-a8d1-9e38055f83d1}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.45",  "     22.05K / 24-bit / 8 ch WAVEFORMATEXENSIBLE",                    0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_44,                           "{9b2833f0-d1a0-40d3-8f83-28a67245ec5a}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.46",  "     48K / 32-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_45,                           "{b1dbe030-29c6-4c04-8009-32bf3cacbb0d}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.47",  "     192K / 8-bit / 6 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_46,                           "{2f4d3cfa-1719-4993-96af-d764c7f48174}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.48",  "     32K / 32-bit / 8 ch WAVEFORMATEXENSIBLE",                       0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_47,                           "{056a084b-426e-4470-889e-052604eafd35}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.49",  "     44.1K / 24-bit / 6 ch WAVEFORMATEXENSIBLE",                     0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_48,                           "{445fa796-0c29-4b24-b1cf-69d926c33ed3}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.50",  "     22.05K / 8-bit / 6 ch WAVEFORMATEXENSIBLE",                     0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_49,                           "{b944cb29-85b0-4a27-97c7-b40a4c6ef9c5}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.51",  "     44.1K / 16-bit / 8 ch WAVEFORMATEXENSIBLE",                     0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_50,                           "{2310ce67-dd5a-44b2-b5ce-6ed151ac7f62}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.52",  "     16K / 32-bit / 32 ch WAVEFORMATEXENSIBLE",                      0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_51,                           "{91309075-7d7a-419b-aeb9-5049fdca4994}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.53",  "     88.2K / 8-bit / 8 ch WAVEFORMATEXENSIBLE",                      0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_52,                           "{5406175d-0262-4424-8b3c-16da9de3db54}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.54",  "     16K / 16-bit / 16 ch WAVEFORMATEXENSIBLE",                      0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_53,                           "{71d86643-48ea-4223-b01d-06e4a555a076}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.55",  "     48K / 32-bit (20) / 2 ch WAVEFORMATEXENSIBLE",                  0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_54,                           "{6d2594ed-b7ec-4bb6-9101-55619a999ebd}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.56",  "     48K / 32-bit (24) / 2 ch WAVEFORMATEXENSIBLE",                  0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_55,                           "{ab2aa34d-e93e-412b-b815-41179a9ca7ed}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.57",  "     48K / 32-bit (32) / 2 ch WAVEFORMATEXENSIBLE",                  0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_56,                           "{b6399e79-4db8-4a1d-91f9-82877e706a88}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.58",  "     48K / 16-bit / 4 ch (QUAD) WAVEFORMATEXENSIBLE",                0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_57,                           "{1b46551f-8616-430f-8ce5-3f3bbab77558}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.59",  "     48K / 16-bit / 4 ch (SURROUND WAVEFORMATEXENSIBLE",             0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_58,                           "{73717d2d-9889-47aa-86c4-d798f3ac38dc}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.60",  "     48K / 16-bit / 6 ch (5.1) WAVEFORMATEXENSIBLE",                 0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_59,                           "{edf00f17-183a-4d37-8a92-53636ef14437}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.61",  "     48K / 16-bit / 8 ch (7.1) WAVEFORMATEXENSIBLE",                 0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_60,                           "{56643601-7d16-4fca-b2bd-9667d49fc50a}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.62",  "     48K / 16-bit / 1 ch (MONO) WAVEFORMATEXENSIBLE",                0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_61,                           "{7a732add-3f36-46f1-b82d-f70c649564d3}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.47.63",  "     48K / 16-bit / 2 ch (STEREO) WAVEFORMATEXENSIBLE",              0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_Capture_Exclusive_Pull_62,                           "{a0c20b03-3308-4add-88d7-7db3edfbecad}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_PARENT( "",         "  Loopback Streaming Tests",                                         0,                   0,                                                                     0,    NULL,  NULL,                                                   "{b69fe706-611b-4fd9-abef-500c7d0cd685}")
    DEVICE_TEST_METHOD( "1.48.1",   "   Timer-Push Loopback Streaming (Shared)",                          0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Loopback_Push_Shared,                                "{574f5aa3-4f82-4406-a535-50f37ec7f42d}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.48.2",   "   Timer-Push Loopback Streaming (Compat)",                          0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Loopback_Push_Compat,                                "{7B4BE3C0-B008-4AB6-BFAC-E3242B0FB189}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.48.3",   "   Timer-Push Loopback Streaming (Compat Enhanced)",                 0,                   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_Loopback_Push_Compat_Enhanced,                       "{C5B9E63D-3BE8-463D-8391-2427B5D97CE2}")
        ENABLE_HLK_CERTIFICATION()
    // Add event-driven loopback tests for devices that support offload only. Software loopback does not support event driven capture for now.
    DEVICE_TEST_METHOD( "1.48.4",   "   Event-Pull Loopback Streaming (Shared)",                          0,                   DEVICE_TYPE_RENDEROFFLOAD,                                             0,    NULL,  TC_Loopback_Pull_Shared,                                "{0a9547f1-deb6-4ad0-ad3d-6c500491031d}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.48.5",   "   Event-Pull Loopback Streaming (Compat)",                          0,                   DEVICE_TYPE_RENDEROFFLOAD,                                             0,    NULL,  TC_Loopback_Pull_Compat,                                "{1E0F8FF0-00C4-4B72-A4E1-7E676AC854F7}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.48.6",   "   Event-Pull Loopback Streaming (Compat Enhanced)",                 0,                   DEVICE_TYPE_RENDEROFFLOAD,                                             0,    NULL,  TC_Loopback_Pull_Compat_Enhanced,                       "{6C93E942-19D3-40AF-BA13-57A1D71A6458}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_PARENT( "",         " Endpoint Streaming Property Tests",                                 0,                   0,                                                                     0,    NULL,  NULL,                                                   "{5AA67518-61D6-4A16-B788-CAC904AB3718}")
    DEVICE_TEST_METHOD( "1.49.1",   "  Validate Allow Hardware Acceleration Setting",                     TESTFLAG_DISABLED,   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  TC_EndpointProperty_HardwareAcceleration,               "{C22F5C51-F50B-44E5-BD75-2286EBB1FA60}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_PARENT( "",         " KS Instances Tests",                                                0,                   0,                                                                     0,    NULL,  NULL,                                                   "{BD9B6EAD-4EFE-4C42-3172-07D5E372E2CE}")
    DEVICE_TEST_METHOD( "1.50.1",   "  Validate KS instance counts (Media Foundation)",                   TESTFLAG_DISABLED,   DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_KSInstance_MF,                                       "{C772A6BD-1C95-469E-14C0-E131803458AF}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.50.2",   "  Validate KS instance counts (DSound)",                             TESTFLAG_DISABLED,   DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDER,                                0,    NULL,  TC_KSInstance_DSound,                                   "{0DA83239-ABB6-44E1-24FC-992E100D08BE}")
    DEVICE_TEST_METHOD( "1.50.3",   "  Validate KS instance counts (WinMM)",                              TESTFLAG_DISABLED,   DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDER,                                0,    NULL,  TC_KSInstance_WinMM,                                    "{7433D1EE-7EFA-40F2-920B-AD0EFD34263D}")
    DEVICE_TEST_METHOD( "1.50.4",   "  Validate KS instance counts (WASAPI shared / offload)",            TESTFLAG_DISABLED,   DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,      0,    NULL,  TC_KSInstance_WasapiShared,                             "{8ED8C6D9-115F-4314-0FAF-0E6521D11D33}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_METHOD( "1.50.5",   "  Validate KS instance counts (WASAPI exclusive)",                   TESTFLAG_DISABLED,   DEVICE_TYPE_CAPTURE|DEVICE_TYPE_RENDER,                                0,    NULL,  TC_KSInstance_WasapiExclusive,                          "{BB308142-23FF-4170-677C-16FCAF6CDD0F}")
        ENABLE_HLK_CERTIFICATION()
    DEVICE_TEST_PARENT( "",         " UMATestStreaming",                                                  0,                   0,                                                                     0,    NULL,  NULL,                                                   "{8BD4877E-07E9-4A01-0F4F-EF32124AB04C}")
    DEVICE_TEST_METHOD( "1.51.1",   "  UMATestStreaming render loop",                                     0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_UmaTestStreaming_RenderLoop,                         "{BFEABBD4-BBE0-4F28-6420-F9890C491272}")
    DEVICE_TEST_METHOD( "1.51.2",   "  UMATestStreaming capture loop",                                    0,                   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  TC_UmaTestStreaming_CaptureLoop,                        "{3A2E04CC-5E4B-4E08-4196-EE91C5179870}")
    DEVICE_TEST_PARENT( "",         " Security Tests",                                                    0,                   0,                                                                     0,    NULL,  NULL,                                                   "{f3f8d09c-46d3-4a68-9001-aee2830fa5d3}")
    DEVICE_TEST_METHOD( "1.100.1",  "  Stream rogue float values",                                        0,                   DEVICE_TYPE_RENDER,                                                    0,    NULL,  TC_Security_InvalidFloatStreaming,                      "{2d87112a-ffe3-49a8-85f4-81b39b1f5ddc}")
    DEVICE_TEST_PARENT( "",         " Stress Tests",                                                      0,                   0,                                                                     0,    NULL,  NULL,                                                   "{8b750760-bd2a-4e1c-b648-68d87568ea15}")
    DEVICE_TEST_METHOD( "1.200.1",  "  AudioSession Creation Stress",                                     TESTFLAG_DISABLED,   DEVICE_TYPE_RENDER,                                                    0,    NULL,  Tc_AudioSessionStress,                                  "{239eab6b-b500-44e8-80e4-9cc62ecaefc3}")
    DEVICE_TEST_METHOD( "1.200.2",  "  Render Stress",                                                    TESTFLAG_DISABLED,   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  Tc_SessionVolumeStress,                                 "{de3dc950-c29e-49c3-a80e-372013b1a984}")
//    DEVICE_TEST_METHOD( "1.200.3",  "  Capture Stress",                                                 TESTFLAG_DISABLED,   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  Tc_SessionVolumeStress,                                 "{6673570b-5ffc-4464-910f-a50493beb0d0}")
    DEVICE_TEST_PARENT( "",         " Longhaul Tests",                                                    0,                   0,                                                                     0,    NULL,  NULL,                                                   "{0b9ad0cf-1a83-4abb-ad06-ed57baa038ad}")
    DEVICE_TEST_METHOD( "1.300.1",  "  Longhaul Render Test",                                             TESTFLAG_DISABLED,   DEVICE_TYPE_RENDER|DEVICE_TYPE_RENDEROFFLOAD,                          0,    NULL,  Tc_RenderLonghaul,                                      "{40954884-3e37-4e13-9cc3-82effd2eb2c9}")
    DEVICE_TEST_METHOD( "1.300.2",  "  Longhaul Capture Test",                                            TESTFLAG_DISABLED,   DEVICE_TYPE_CAPTURE,                                                   0,    NULL,  Tc_CaptureLonghaul,                                     "{f749afa2-ff91-439b-9716-72b93574642b}")

END_TEST_CASE_INFO(UMATest)

//
// Function Implementations Required by Endpoint Module
//
#ifndef BUILD_TAEF
DV_TCINFO* GetTestCaseInfo()
{
    return rgTestCaseInfo;
}

UINT32 GetNumTestCases()
{
    return sizeof(rgTestCaseInfo)/sizeof(rgTestCaseInfo[0]);
}

LPSTR GetAppName()
{
    return "User Mode Audio Test";
}

UINT32 GetIconID()
{
    return APPICON;
}

UINT32 GetAppID()
{
    return 2222;
}
#endif // !BUILD_TAEF

EDataFlow GetDeviceDataFlow()
{
    return eAll;
}

DWORD GetStateMask()
{
    return DEVICE_STATE_ACTIVE;
}

bool CheckMachineConfig(IBasicLog* /*pLog*/)
{
    return true;
}

#ifdef BUILD_TAEF
IBasicLog * g_pBasicLog = NULL;
#endif
