//*****************************************************************************
//***                        THIS FILE IS GENERATED                        ****
//***                       DO NOT MODIFY THIS FILE !!!                    ****
//*****************************************************************************
//*****************************************************************************
//* File: D3DWrapped.h
//* 
//* Description: 
//*     Base D3D wrapper class declarations.
//*
//*****************************************************************************

// Ignore Prefast warnings 26060 (Range Precondition violation) and 28930 (Unused assignment of pointer variable)
#pragma warning( disable: 26060 )
#pragma warning( disable: 28930 )

#pragma once
#include "D3DWrappedTypes.h"
#include "assert.h"
#include "Handle.h"


////////////////////////////////////////////////////////////
//
// Wrapper typedefs
//
////////////////////////////////////////////////////////////
typedef RECT D3D_RECT;


////////////////////////////////////////////////////////////
//
// Wrapper classes
//
////////////////////////////////////////////////////////////



////////////////////////////////////////////////////////////
//
// CDeviceChild
//
////////////////////////////////////////////////////////////

class CDeviceChild : public virtual WindowsTest::CRefObject
{
public:
    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D10DeviceChild **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }
    virtual void GetInterfacePtr( ID3D11DeviceChild **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }

    ////////////////////////////////////////////////////////////
    // Sub object accessors (for Multi-Wrapper classes)
    ////////////////////////////////////////////////////////////
    virtual CDeviceChild *GetSubDeviceChild( int index ) = 0;
    virtual int GetSubObjectCount() const = 0;

    ////////////////////////////////////////////////////////////
    // GetDevice
    ////////////////////////////////////////////////////////////
    virtual void GetDevice(  CDevice ** ppDevice );

    ////////////////////////////////////////////////////////////
    // GetPrivateData
    ////////////////////////////////////////////////////////////
    virtual NRESULT GetPrivateData(  REFGUID guid, UINT * pDataSize, void * pData );

    ////////////////////////////////////////////////////////////
    // SetPrivateData
    ////////////////////////////////////////////////////////////
    virtual NRESULT SetPrivateData(  REFGUID guid, UINT DataSize, const void * pData );

    ////////////////////////////////////////////////////////////
    // SetPrivateDataInterface
    ////////////////////////////////////////////////////////////
    virtual NRESULT SetPrivateDataInterface(  REFGUID guid, const IUnknown * pData );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////
};


////////////////////////////////////////////////////////////
//
// CDepthStencilState
//
////////////////////////////////////////////////////////////

class CDepthStencilState : public virtual CDeviceChild
{
public:
    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D10DepthStencilState **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }
    virtual void GetInterfacePtr( ID3D11DepthStencilState **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }

    ////////////////////////////////////////////////////////////
    // Sub object accessors (for Multi-Wrapper classes)
    ////////////////////////////////////////////////////////////
    virtual CDepthStencilState *GetSubDepthStencilState( int index ) = 0;
    virtual IUnknown *GetIUnknown() = 0;
    virtual void SetSubDepthStencilState( int index, CDepthStencilState *pDepthStencilState ) = 0;
    virtual CDepthStencilState *Src() = 0;
    virtual CDepthStencilState *Ref() = 0;

    ////////////////////////////////////////////////////////////
    // GetDesc
    ////////////////////////////////////////////////////////////
    virtual void GetDesc(  D3D_DEPTH_STENCIL_DESC * pDesc );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////
};


////////////////////////////////////////////////////////////
//
// CBlendState
//
////////////////////////////////////////////////////////////

class CBlendState : public virtual CDeviceChild
{
public:
    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D10BlendState **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }
    virtual void GetInterfacePtr( ID3D11BlendState **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }

    ////////////////////////////////////////////////////////////
    // Sub object accessors (for Multi-Wrapper classes)
    ////////////////////////////////////////////////////////////
    virtual CBlendState *GetSubBlendState( int index ) = 0;
    virtual IUnknown *GetIUnknown() = 0;
    virtual void SetSubBlendState( int index, CBlendState *pBlendState ) = 0;
    virtual CBlendState *Src() = 0;
    virtual CBlendState *Ref() = 0;

    ////////////////////////////////////////////////////////////
    // GetDesc
    ////////////////////////////////////////////////////////////
    virtual void GetDesc(  D3D_BLEND_DESC * pDesc );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////
};


////////////////////////////////////////////////////////////
//
// CRasterizerState
//
////////////////////////////////////////////////////////////

class CRasterizerState : public virtual CDeviceChild
{
public:
    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D10RasterizerState **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }
    virtual void GetInterfacePtr( ID3D11RasterizerState **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }

    ////////////////////////////////////////////////////////////
    // Sub object accessors (for Multi-Wrapper classes)
    ////////////////////////////////////////////////////////////
    virtual CRasterizerState *GetSubRasterizerState( int index ) = 0;
    virtual IUnknown *GetIUnknown() = 0;
    virtual void SetSubRasterizerState( int index, CRasterizerState *pRasterizerState ) = 0;
    virtual CRasterizerState *Src() = 0;
    virtual CRasterizerState *Ref() = 0;

    ////////////////////////////////////////////////////////////
    // GetDesc
    ////////////////////////////////////////////////////////////
    virtual void GetDesc(  D3D_RASTERIZER_DESC * pDesc );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////
};


////////////////////////////////////////////////////////////
//
// CResource
//
////////////////////////////////////////////////////////////

class CResource : public virtual CDeviceChild
{
public:
    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D10Resource **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }
    virtual void GetInterfacePtr( ID3D11Resource **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }

    ////////////////////////////////////////////////////////////
    // Sub object accessors (for Multi-Wrapper classes)
    ////////////////////////////////////////////////////////////
    virtual CResource *GetSubResource( int index ) = 0;

    ////////////////////////////////////////////////////////////
    // GetType
    ////////////////////////////////////////////////////////////
    virtual void GetType(  D3D_RESOURCE_DIMENSION * rType );

    ////////////////////////////////////////////////////////////
    // SetEvictionPriority
    ////////////////////////////////////////////////////////////
    virtual void SetEvictionPriority(  UINT EvictionPriority );

    ////////////////////////////////////////////////////////////
    // GetEvictionPriority
    ////////////////////////////////////////////////////////////
    virtual UINT GetEvictionPriority(  );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////
};


////////////////////////////////////////////////////////////
//
// CBuffer
//
////////////////////////////////////////////////////////////

class CBuffer : public virtual CResource
{
public:
    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D10Buffer **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }
    virtual void GetInterfacePtr( ID3D11Buffer **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }

    ////////////////////////////////////////////////////////////
    // Sub object accessors (for Multi-Wrapper classes)
    ////////////////////////////////////////////////////////////
    virtual CBuffer *GetSubBuffer( int index ) = 0;
    virtual IUnknown *GetIUnknown() = 0;
    virtual void SetSubBuffer( int index, CBuffer *pBuffer ) = 0;
    virtual CBuffer *Src() = 0;
    virtual CBuffer *Ref() = 0;

    ////////////////////////////////////////////////////////////
    // Map
    ////////////////////////////////////////////////////////////
    virtual NRESULT Map(  D3D_MAP MapType, UINT MapFlags, void ** ppData );

    ////////////////////////////////////////////////////////////
    // Unmap
    ////////////////////////////////////////////////////////////
    virtual void Unmap(  );

    ////////////////////////////////////////////////////////////
    // GetDesc
    ////////////////////////////////////////////////////////////
    virtual void GetDesc(  D3D_BUFFER_DESC * pDesc );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////
};


////////////////////////////////////////////////////////////
//
// CTexture1D
//
////////////////////////////////////////////////////////////

class CTexture1D : public virtual CResource
{
public:
    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D10Texture1D **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }
    virtual void GetInterfacePtr( ID3D11Texture1D **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }

    ////////////////////////////////////////////////////////////
    // Sub object accessors (for Multi-Wrapper classes)
    ////////////////////////////////////////////////////////////
    virtual CTexture1D *GetSubTexture1D( int index ) = 0;
    virtual IUnknown *GetIUnknown() = 0;
    virtual void SetSubTexture1D( int index, CTexture1D *pTexture1D ) = 0;
    virtual CTexture1D *Src() = 0;
    virtual CTexture1D *Ref() = 0;

    ////////////////////////////////////////////////////////////
    // Map
    ////////////////////////////////////////////////////////////
    virtual NRESULT Map(  UINT Subresource, D3D_MAP MapType, UINT MapFlags, void ** ppData );

    ////////////////////////////////////////////////////////////
    // Unmap
    ////////////////////////////////////////////////////////////
    virtual void Unmap(  UINT Subresource );

    ////////////////////////////////////////////////////////////
    // GetDesc
    ////////////////////////////////////////////////////////////
    virtual void GetDesc(  D3D_TEXTURE1D_DESC * pDesc );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////
};


////////////////////////////////////////////////////////////
//
// CTexture2D
//
////////////////////////////////////////////////////////////

class CTexture2D : public virtual CResource
{
public:
    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D10Texture2D **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }
    virtual void GetInterfacePtr( ID3D11Texture2D **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }

    ////////////////////////////////////////////////////////////
    // Sub object accessors (for Multi-Wrapper classes)
    ////////////////////////////////////////////////////////////
    virtual CTexture2D *GetSubTexture2D( int index ) = 0;
    virtual IUnknown *GetIUnknown() = 0;
    virtual void SetSubTexture2D( int index, CTexture2D *pTexture2D ) = 0;
    virtual CTexture2D *Src() = 0;
    virtual CTexture2D *Ref() = 0;

    ////////////////////////////////////////////////////////////
    // Map
    ////////////////////////////////////////////////////////////
    virtual NRESULT Map(  UINT Subresource, D3D_MAP MapType, UINT MapFlags, D3D_MAPPED_TEXTURE2D * pMappedTex2D );

    ////////////////////////////////////////////////////////////
    // Unmap
    ////////////////////////////////////////////////////////////
    virtual void Unmap(  UINT Subresource );

    ////////////////////////////////////////////////////////////
    // GetDesc
    ////////////////////////////////////////////////////////////
    virtual void GetDesc(  D3D_TEXTURE2D_DESC * pDesc );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////
};


////////////////////////////////////////////////////////////
//
// CTexture3D
//
////////////////////////////////////////////////////////////

class CTexture3D : public virtual CResource
{
public:
    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D10Texture3D **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }
    virtual void GetInterfacePtr( ID3D11Texture3D **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }

    ////////////////////////////////////////////////////////////
    // Sub object accessors (for Multi-Wrapper classes)
    ////////////////////////////////////////////////////////////
    virtual CTexture3D *GetSubTexture3D( int index ) = 0;
    virtual IUnknown *GetIUnknown() = 0;
    virtual void SetSubTexture3D( int index, CTexture3D *pTexture3D ) = 0;
    virtual CTexture3D *Src() = 0;
    virtual CTexture3D *Ref() = 0;

    ////////////////////////////////////////////////////////////
    // Map
    ////////////////////////////////////////////////////////////
    virtual NRESULT Map(  UINT Subresource, D3D_MAP MapType, UINT MapFlags, D3D_MAPPED_TEXTURE3D * pMappedTex3D );

    ////////////////////////////////////////////////////////////
    // Unmap
    ////////////////////////////////////////////////////////////
    virtual void Unmap(  UINT Subresource );

    ////////////////////////////////////////////////////////////
    // GetDesc
    ////////////////////////////////////////////////////////////
    virtual void GetDesc(  D3D_TEXTURE3D_DESC * pDesc );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////
};


////////////////////////////////////////////////////////////
//
// CView
//
////////////////////////////////////////////////////////////

class CView : public virtual CDeviceChild
{
public:
    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D10View **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }
    virtual void GetInterfacePtr( ID3D11View **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }

    ////////////////////////////////////////////////////////////
    // Sub object accessors (for Multi-Wrapper classes)
    ////////////////////////////////////////////////////////////
    virtual CView *GetSubView( int index ) = 0;

    ////////////////////////////////////////////////////////////
    // GetResource
    ////////////////////////////////////////////////////////////
    virtual void GetResource(  CResource ** ppResource );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////
};


////////////////////////////////////////////////////////////
//
// CShaderResourceView
//
////////////////////////////////////////////////////////////

class CShaderResourceView : public virtual CView
{
public:
    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D10ShaderResourceView **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }
    virtual void GetInterfacePtr( ID3D11ShaderResourceView **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }

    ////////////////////////////////////////////////////////////
    // Sub object accessors (for Multi-Wrapper classes)
    ////////////////////////////////////////////////////////////
    virtual CShaderResourceView *GetSubShaderResourceView( int index ) = 0;
    virtual IUnknown *GetIUnknown() = 0;
    virtual void SetSubShaderResourceView( int index, CShaderResourceView *pShaderResourceView ) = 0;
    virtual CShaderResourceView *Src() = 0;
    virtual CShaderResourceView *Ref() = 0;

    ////////////////////////////////////////////////////////////
    // GetDesc
    ////////////////////////////////////////////////////////////
    virtual void GetDesc(  D3D_SHADER_RESOURCE_VIEW_DESC * pDesc );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////
};


////////////////////////////////////////////////////////////
//
// CRenderTargetView
//
////////////////////////////////////////////////////////////

class CRenderTargetView : public virtual CView
{
public:
    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D10RenderTargetView **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }
    virtual void GetInterfacePtr( ID3D11RenderTargetView **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }

    ////////////////////////////////////////////////////////////
    // Sub object accessors (for Multi-Wrapper classes)
    ////////////////////////////////////////////////////////////
    virtual CRenderTargetView *GetSubRenderTargetView( int index ) = 0;
    virtual IUnknown *GetIUnknown() = 0;
    virtual void SetSubRenderTargetView( int index, CRenderTargetView *pRenderTargetView ) = 0;
    virtual CRenderTargetView *Src() = 0;
    virtual CRenderTargetView *Ref() = 0;

    ////////////////////////////////////////////////////////////
    // GetDesc
    ////////////////////////////////////////////////////////////
    virtual void GetDesc(  D3D_RENDER_TARGET_VIEW_DESC * pDesc );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////
};


////////////////////////////////////////////////////////////
//
// CDepthStencilView
//
////////////////////////////////////////////////////////////

class CDepthStencilView : public virtual CView
{
public:
    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D10DepthStencilView **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }
    virtual void GetInterfacePtr( ID3D11DepthStencilView **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }

    ////////////////////////////////////////////////////////////
    // Sub object accessors (for Multi-Wrapper classes)
    ////////////////////////////////////////////////////////////
    virtual CDepthStencilView *GetSubDepthStencilView( int index ) = 0;
    virtual IUnknown *GetIUnknown() = 0;
    virtual void SetSubDepthStencilView( int index, CDepthStencilView *pDepthStencilView ) = 0;
    virtual CDepthStencilView *Src() = 0;
    virtual CDepthStencilView *Ref() = 0;

    ////////////////////////////////////////////////////////////
    // GetDesc
    ////////////////////////////////////////////////////////////
    virtual void GetDesc(  D3D_DEPTH_STENCIL_VIEW_DESC * pDesc );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////
};


////////////////////////////////////////////////////////////
//
// CVertexShader
//
////////////////////////////////////////////////////////////

class CVertexShader : public virtual CDeviceChild
{
public:
    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D10VertexShader **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }
    virtual void GetInterfacePtr( ID3D11VertexShader **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }

    ////////////////////////////////////////////////////////////
    // Sub object accessors (for Multi-Wrapper classes)
    ////////////////////////////////////////////////////////////
    virtual CVertexShader *GetSubVertexShader( int index ) = 0;
    virtual IUnknown *GetIUnknown() = 0;
    virtual void SetSubVertexShader( int index, CVertexShader *pVertexShader ) = 0;
    virtual CVertexShader *Src() = 0;
    virtual CVertexShader *Ref() = 0;


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////
};


////////////////////////////////////////////////////////////
//
// CGeometryShader
//
////////////////////////////////////////////////////////////

class CGeometryShader : public virtual CDeviceChild
{
public:
    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D10GeometryShader **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }
    virtual void GetInterfacePtr( ID3D11GeometryShader **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }

    ////////////////////////////////////////////////////////////
    // Sub object accessors (for Multi-Wrapper classes)
    ////////////////////////////////////////////////////////////
    virtual CGeometryShader *GetSubGeometryShader( int index ) = 0;
    virtual IUnknown *GetIUnknown() = 0;
    virtual void SetSubGeometryShader( int index, CGeometryShader *pGeometryShader ) = 0;
    virtual CGeometryShader *Src() = 0;
    virtual CGeometryShader *Ref() = 0;


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////
};


////////////////////////////////////////////////////////////
//
// CPixelShader
//
////////////////////////////////////////////////////////////

class CPixelShader : public virtual CDeviceChild
{
public:
    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D10PixelShader **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }
    virtual void GetInterfacePtr( ID3D11PixelShader **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }

    ////////////////////////////////////////////////////////////
    // Sub object accessors (for Multi-Wrapper classes)
    ////////////////////////////////////////////////////////////
    virtual CPixelShader *GetSubPixelShader( int index ) = 0;
    virtual IUnknown *GetIUnknown() = 0;
    virtual void SetSubPixelShader( int index, CPixelShader *pPixelShader ) = 0;
    virtual CPixelShader *Src() = 0;
    virtual CPixelShader *Ref() = 0;


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////
};


////////////////////////////////////////////////////////////
//
// CInputLayout
//
////////////////////////////////////////////////////////////

class CInputLayout : public virtual CDeviceChild
{
public:
    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D10InputLayout **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }
    virtual void GetInterfacePtr( ID3D11InputLayout **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }

    ////////////////////////////////////////////////////////////
    // Sub object accessors (for Multi-Wrapper classes)
    ////////////////////////////////////////////////////////////
    virtual CInputLayout *GetSubInputLayout( int index ) = 0;
    virtual IUnknown *GetIUnknown() = 0;
    virtual void SetSubInputLayout( int index, CInputLayout *pInputLayout ) = 0;
    virtual CInputLayout *Src() = 0;
    virtual CInputLayout *Ref() = 0;


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////
};


////////////////////////////////////////////////////////////
//
// CSamplerState
//
////////////////////////////////////////////////////////////

class CSamplerState : public virtual CDeviceChild
{
public:
    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D10SamplerState **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }
    virtual void GetInterfacePtr( ID3D11SamplerState **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }

    ////////////////////////////////////////////////////////////
    // Sub object accessors (for Multi-Wrapper classes)
    ////////////////////////////////////////////////////////////
    virtual CSamplerState *GetSubSamplerState( int index ) = 0;
    virtual IUnknown *GetIUnknown() = 0;
    virtual void SetSubSamplerState( int index, CSamplerState *pSamplerState ) = 0;
    virtual CSamplerState *Src() = 0;
    virtual CSamplerState *Ref() = 0;

    ////////////////////////////////////////////////////////////
    // GetDesc
    ////////////////////////////////////////////////////////////
    virtual void GetDesc(  D3D_SAMPLER_DESC * pDesc );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////
};


////////////////////////////////////////////////////////////
//
// CAsynchronous
//
////////////////////////////////////////////////////////////

class CAsynchronous : public virtual CDeviceChild
{
public:
    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D10Asynchronous **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }
    virtual void GetInterfacePtr( ID3D11Asynchronous **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }

    ////////////////////////////////////////////////////////////
    // Sub object accessors (for Multi-Wrapper classes)
    ////////////////////////////////////////////////////////////
    virtual CAsynchronous *GetSubAsynchronous( int index ) = 0;

    ////////////////////////////////////////////////////////////
    // Begin
    ////////////////////////////////////////////////////////////
    virtual void Begin(  );

    ////////////////////////////////////////////////////////////
    // End
    ////////////////////////////////////////////////////////////
    virtual void End(  );

    ////////////////////////////////////////////////////////////
    // GetData
    ////////////////////////////////////////////////////////////
    virtual NRESULT GetData(  void * pData, UINT DataSize, UINT GetDataFlags );

    ////////////////////////////////////////////////////////////
    // GetDataSize
    ////////////////////////////////////////////////////////////
    virtual UINT GetDataSize(  );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////
};


////////////////////////////////////////////////////////////
//
// CQuery
//
////////////////////////////////////////////////////////////

class CQuery : public virtual CAsynchronous
{
public:
    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D10Query **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }
    virtual void GetInterfacePtr( ID3D11Query **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }

    ////////////////////////////////////////////////////////////
    // Sub object accessors (for Multi-Wrapper classes)
    ////////////////////////////////////////////////////////////
    virtual CQuery *GetSubQuery( int index ) = 0;

    ////////////////////////////////////////////////////////////
    // GetDesc
    ////////////////////////////////////////////////////////////
    virtual void GetDesc(  D3D_QUERY_DESC * pDesc );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////
};


////////////////////////////////////////////////////////////
//
// CPredicate
//
////////////////////////////////////////////////////////////

class CPredicate : public virtual CQuery
{
public:
    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D10Predicate **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }
    virtual void GetInterfacePtr( ID3D11Predicate **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }

    ////////////////////////////////////////////////////////////
    // Sub object accessors (for Multi-Wrapper classes)
    ////////////////////////////////////////////////////////////
    virtual CPredicate *GetSubPredicate( int index ) = 0;
    virtual IUnknown *GetIUnknown() = 0;
    virtual void SetSubPredicate( int index, CPredicate *pPredicate ) = 0;
    virtual CPredicate *Src() = 0;
    virtual CPredicate *Ref() = 0;


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////
};


////////////////////////////////////////////////////////////
//
// CCounter
//
////////////////////////////////////////////////////////////

class CCounter : public virtual CAsynchronous
{
public:
    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D10Counter **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }
    virtual void GetInterfacePtr( ID3D11Counter **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }

    ////////////////////////////////////////////////////////////
    // Sub object accessors (for Multi-Wrapper classes)
    ////////////////////////////////////////////////////////////
    virtual CCounter *GetSubCounter( int index ) = 0;
    virtual IUnknown *GetIUnknown() = 0;
    virtual void SetSubCounter( int index, CCounter *pCounter ) = 0;
    virtual CCounter *Src() = 0;
    virtual CCounter *Ref() = 0;

    ////////////////////////////////////////////////////////////
    // GetDesc
    ////////////////////////////////////////////////////////////
    virtual void GetDesc(  D3D_COUNTER_DESC * pDesc );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////
};


////////////////////////////////////////////////////////////
//
// CDevice
//
////////////////////////////////////////////////////////////

class CDevice : public virtual WindowsTest::CRefObject
{
public:
    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D10Device **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }
    virtual void GetInterfacePtr( ID3D10Device1 **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }
    virtual void GetInterfacePtr( ID3D11Device **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }

    ////////////////////////////////////////////////////////////
    // Sub object accessors (for Multi-Wrapper classes)
    ////////////////////////////////////////////////////////////
    virtual CDevice *GetSubDevice( int index ) = 0;
    virtual IUnknown *GetIUnknown() = 0;
    virtual void SetSubDevice( int index, CDevice *pDevice ) = 0;
    virtual CDevice *Src() = 0;
    virtual CDevice *Ref() = 0;
    virtual int GetSubObjectCount() const = 0;

    ////////////////////////////////////////////////////////////
    // VSSetConstantBuffers
    ////////////////////////////////////////////////////////////
    virtual void VSSetConstantBuffers(  UINT StartSlot, UINT NumBuffers, CBuffer *const * ppConstantBuffers );

    virtual void VSSetConstantBuffers1( UINT StartSlot, UINT NumBuffers, CBuffer *const* ppConstantBuffers, UINT32 const* pOffsets, UINT32 const* ppNumConstants );

    ////////////////////////////////////////////////////////////
    // PSSetShaderResources
    ////////////////////////////////////////////////////////////
    virtual void PSSetShaderResources(  UINT StartSlot, UINT NumViews, CShaderResourceView *const * ppShaderResourceViews );

    ////////////////////////////////////////////////////////////
    // PSSetShader
    ////////////////////////////////////////////////////////////
    virtual void PSSetShader(  CPixelShader * pPixelShader );

    ////////////////////////////////////////////////////////////
    // PSSetSamplers
    ////////////////////////////////////////////////////////////
    virtual void PSSetSamplers(  UINT StartSlot, UINT NumSamplers, CSamplerState *const * ppSamplers );

    ////////////////////////////////////////////////////////////
    // VSSetShader
    ////////////////////////////////////////////////////////////
    virtual void VSSetShader(  CVertexShader * pVertexShader );

    ////////////////////////////////////////////////////////////
    // DrawIndexed
    ////////////////////////////////////////////////////////////
    virtual void DrawIndexed(  UINT IndexCount, UINT StartIndexLocation, INT BaseVertexLocation );

    ////////////////////////////////////////////////////////////
    // Draw
    ////////////////////////////////////////////////////////////
    virtual void Draw(  UINT VertexCount, UINT StartVertexLocation );

    ////////////////////////////////////////////////////////////
    // PSSetConstantBuffers
    ////////////////////////////////////////////////////////////
    virtual void PSSetConstantBuffers(  UINT StartSlot, UINT NumBuffers, CBuffer *const * ppConstantBuffers );

    virtual void PSSetConstantBuffers1( UINT StartSlot, UINT NumBuffers, CBuffer *const* ppConstantBuffers, UINT32 const* pOffsets, UINT32 const* ppNumConstants );

    ////////////////////////////////////////////////////////////
    // IASetInputLayout
    ////////////////////////////////////////////////////////////
    virtual void IASetInputLayout(  CInputLayout * pInputLayout );

    ////////////////////////////////////////////////////////////
    // IASetVertexBuffers
    ////////////////////////////////////////////////////////////
    virtual void IASetVertexBuffers(  UINT StartSlot, UINT NumBuffers, CBuffer *const * ppVertexBuffers, const UINT * pStrides, const UINT * pOffsets );

    ////////////////////////////////////////////////////////////
    // IASetIndexBuffer
    ////////////////////////////////////////////////////////////
    virtual void IASetIndexBuffer(  CBuffer * pIndexBuffer, DXGI_FORMAT Format, UINT Offset );

    ////////////////////////////////////////////////////////////
    // DrawIndexedInstanced
    ////////////////////////////////////////////////////////////
    virtual void DrawIndexedInstanced(  UINT IndexCountPerInstance, UINT InstanceCount, UINT StartIndexLocation, INT BaseVertexLocation, UINT StartInstanceLocation );

    ////////////////////////////////////////////////////////////
    // DrawInstanced
    ////////////////////////////////////////////////////////////
    virtual void DrawInstanced(  UINT VertexCountPerInstance, UINT InstanceCount, UINT StartVertexLocation, UINT StartInstanceLocation );

    ////////////////////////////////////////////////////////////
    // GSSetConstantBuffers
    ////////////////////////////////////////////////////////////
    virtual void GSSetConstantBuffers(  UINT StartSlot, UINT NumBuffers, CBuffer *const * ppConstantBuffers );

    ////////////////////////////////////////////////////////////
    // GSSetShader
    ////////////////////////////////////////////////////////////
    virtual void GSSetShader(  CGeometryShader * pShader );

    ////////////////////////////////////////////////////////////
    // IASetPrimitiveTopology
    ////////////////////////////////////////////////////////////
    virtual void IASetPrimitiveTopology(  D3D_PRIMITIVE_TOPOLOGY Topology );

    ////////////////////////////////////////////////////////////
    // VSSetShaderResources
    ////////////////////////////////////////////////////////////
    virtual void VSSetShaderResources(  UINT StartSlot, UINT NumViews, CShaderResourceView *const * ppShaderResourceViews );

    ////////////////////////////////////////////////////////////
    // VSSetSamplers
    ////////////////////////////////////////////////////////////
    virtual void VSSetSamplers(  UINT StartSlot, UINT NumSamplers, CSamplerState *const * ppSamplers );

    ////////////////////////////////////////////////////////////
    // SetPredication
    ////////////////////////////////////////////////////////////
    virtual void SetPredication(  CPredicate * pPredicate, BOOL PredicateValue );

    ////////////////////////////////////////////////////////////
    // GSSetShaderResources
    ////////////////////////////////////////////////////////////
    virtual void GSSetShaderResources(  UINT StartSlot, UINT NumViews, CShaderResourceView *const * ppShaderResourceViews );

    ////////////////////////////////////////////////////////////
    // GSSetSamplers
    ////////////////////////////////////////////////////////////
    virtual void GSSetSamplers(  UINT StartSlot, UINT NumSamplers, CSamplerState *const * ppSamplers );

    ////////////////////////////////////////////////////////////
    // OMSetRenderTargets
    ////////////////////////////////////////////////////////////
    virtual void OMSetRenderTargets(  UINT NumViews, CRenderTargetView *const * ppRenderTargetViews, CDepthStencilView * pDepthStencilView );

    ////////////////////////////////////////////////////////////
    // OMSetBlendState
    ////////////////////////////////////////////////////////////
    virtual void OMSetBlendState(  CBlendState * pBlendState, const FLOAT BlendFactor[4], UINT SampleMask );

    ////////////////////////////////////////////////////////////
    // OMSetDepthStencilState
    ////////////////////////////////////////////////////////////
    virtual void OMSetDepthStencilState(  CDepthStencilState * pDepthStencilState, UINT StencilRef );

    ////////////////////////////////////////////////////////////
    // SOSetTargets
    ////////////////////////////////////////////////////////////
    virtual void SOSetTargets(  UINT NumBuffers, CBuffer *const * ppSOTargets, const UINT * pOffsets );

    ////////////////////////////////////////////////////////////
    // DrawAuto
    ////////////////////////////////////////////////////////////
    virtual void DrawAuto(  );

    ////////////////////////////////////////////////////////////
    // RSSetState
    ////////////////////////////////////////////////////////////
    virtual void RSSetState(  CRasterizerState * pRasterizerState );

    ////////////////////////////////////////////////////////////
    // RSSetViewports
    ////////////////////////////////////////////////////////////
    virtual void RSSetViewports(  UINT NumViewports, const D3D_VIEWPORT * pViewports );

    ////////////////////////////////////////////////////////////
    // RSSetScissorRects
    ////////////////////////////////////////////////////////////
    virtual void RSSetScissorRects(  UINT NumRects, const D3D_RECT * pRects );

    ////////////////////////////////////////////////////////////
    // CopySubresourceRegion
    ////////////////////////////////////////////////////////////
    virtual void CopySubresourceRegion(  CResource * pDstResource, UINT DstSubresource, UINT DstX, UINT DstY, UINT DstZ, CResource * pSrcResource, UINT SrcSubresource, const D3D_BOX * pSrcBox );

    ////////////////////////////////////////////////////////////
    // CopyResource
    ////////////////////////////////////////////////////////////
    virtual void CopyResource(  CResource * pDstResource, CResource * pSrcResource );

    ////////////////////////////////////////////////////////////
    // UpdateSubresource
    ////////////////////////////////////////////////////////////
    virtual void UpdateSubresource(  CResource * pDstResource, UINT DstSubresource, const D3D_BOX * pDstBox, const void * pSrcData, UINT SrcRowPitch, UINT SrcDepthPitch );

    ////////////////////////////////////////////////////////////
    // ClearRenderTargetView
    ////////////////////////////////////////////////////////////
    virtual void ClearRenderTargetView(  CRenderTargetView * pRenderTargetView, const FLOAT ColorRGBA[4] );

    ////////////////////////////////////////////////////////////
    // ClearDepthStencilView
    ////////////////////////////////////////////////////////////
    virtual void ClearDepthStencilView(  CDepthStencilView * pDepthStencilView, UINT ClearFlags, FLOAT Depth, UINT8 Stencil );

    ////////////////////////////////////////////////////////////
    // GenerateMips
    ////////////////////////////////////////////////////////////
    virtual void GenerateMips(  CShaderResourceView * pShaderResourceView );

    ////////////////////////////////////////////////////////////
    // ResolveSubresource
    ////////////////////////////////////////////////////////////
    virtual void ResolveSubresource(  CResource * pDstResource, UINT DstSubresource, CResource * pSrcResource, UINT SrcSubresource, DXGI_FORMAT Format );

    ////////////////////////////////////////////////////////////
    // VSGetConstantBuffers
    ////////////////////////////////////////////////////////////
    virtual void VSGetConstantBuffers(  UINT StartSlot, UINT NumBuffers, CBuffer ** ppConstantBuffers );

    ////////////////////////////////////////////////////////////
    // PSGetShaderResources
    ////////////////////////////////////////////////////////////
    virtual void PSGetShaderResources(  UINT StartSlot, UINT NumViews, CShaderResourceView ** ppShaderResourceViews );

    ////////////////////////////////////////////////////////////
    // PSGetShader
    ////////////////////////////////////////////////////////////
    virtual void PSGetShader(  CPixelShader ** ppPixelShader );

    ////////////////////////////////////////////////////////////
    // PSGetSamplers
    ////////////////////////////////////////////////////////////
    virtual void PSGetSamplers(  UINT StartSlot, UINT NumSamplers, CSamplerState ** ppSamplers );

    ////////////////////////////////////////////////////////////
    // VSGetShader
    ////////////////////////////////////////////////////////////
    virtual void VSGetShader(  CVertexShader ** ppVertexShader );

    ////////////////////////////////////////////////////////////
    // PSGetConstantBuffers
    ////////////////////////////////////////////////////////////
    virtual void PSGetConstantBuffers(  UINT StartSlot, UINT NumBuffers, CBuffer ** ppConstantBuffers );

    ////////////////////////////////////////////////////////////
    // IAGetInputLayout
    ////////////////////////////////////////////////////////////
    virtual void IAGetInputLayout(  CInputLayout ** ppInputLayout );

    ////////////////////////////////////////////////////////////
    // IAGetVertexBuffers
    ////////////////////////////////////////////////////////////
    virtual void IAGetVertexBuffers(  UINT StartSlot, UINT NumBuffers, CBuffer ** ppVertexBuffers, UINT * pStrides, UINT * pOffsets );

    ////////////////////////////////////////////////////////////
    // IAGetIndexBuffer
    ////////////////////////////////////////////////////////////
    virtual void IAGetIndexBuffer(  CBuffer ** pIndexBuffer, DXGI_FORMAT * Format, UINT * Offset );

    ////////////////////////////////////////////////////////////
    // GSGetConstantBuffers
    ////////////////////////////////////////////////////////////
    virtual void GSGetConstantBuffers(  UINT StartSlot, UINT NumBuffers, CBuffer ** ppConstantBuffers );

    ////////////////////////////////////////////////////////////
    // GSGetShader
    ////////////////////////////////////////////////////////////
    virtual void GSGetShader(  CGeometryShader ** ppGeometryShader );

    ////////////////////////////////////////////////////////////
    // IAGetPrimitiveTopology
    ////////////////////////////////////////////////////////////
    virtual void IAGetPrimitiveTopology(  D3D_PRIMITIVE_TOPOLOGY * pTopology );

    ////////////////////////////////////////////////////////////
    // VSGetShaderResources
    ////////////////////////////////////////////////////////////
    virtual void VSGetShaderResources(  UINT StartSlot, UINT NumViews, CShaderResourceView ** ppShaderResourceViews );

    ////////////////////////////////////////////////////////////
    // VSGetSamplers
    ////////////////////////////////////////////////////////////
    virtual void VSGetSamplers(  UINT StartSlot, UINT NumSamplers, CSamplerState ** ppSamplers );

    ////////////////////////////////////////////////////////////
    // GetPredication
    ////////////////////////////////////////////////////////////
    virtual void GetPredication(  CPredicate ** ppPredicate, BOOL * pPredicateValue );

    ////////////////////////////////////////////////////////////
    // GSGetShaderResources
    ////////////////////////////////////////////////////////////
    virtual void GSGetShaderResources(  UINT StartSlot, UINT NumViews, CShaderResourceView ** ppShaderResourceViews );

    ////////////////////////////////////////////////////////////
    // GSGetSamplers
    ////////////////////////////////////////////////////////////
    virtual void GSGetSamplers(  UINT StartSlot, UINT NumSamplers, CSamplerState ** ppSamplers );

    ////////////////////////////////////////////////////////////
    // OMGetRenderTargets
    ////////////////////////////////////////////////////////////
    virtual void OMGetRenderTargets(  UINT NumViews, CRenderTargetView ** ppRenderTargetViews, CDepthStencilView ** ppDepthStencilView );

    ////////////////////////////////////////////////////////////
    // OMGetBlendState
    ////////////////////////////////////////////////////////////
    virtual void OMGetBlendState(  CBlendState ** ppBlendState, FLOAT BlendFactor[4], UINT * pSampleMask );

    ////////////////////////////////////////////////////////////
    // OMGetDepthStencilState
    ////////////////////////////////////////////////////////////
    virtual void OMGetDepthStencilState(  CDepthStencilState ** ppDepthStencilState, UINT * pStencilRef );

    ////////////////////////////////////////////////////////////
    // SOGetTargets
    ////////////////////////////////////////////////////////////
    virtual void SOGetTargets(  UINT NumBuffers, CBuffer ** ppSOTargets, UINT * pOffsets );

    ////////////////////////////////////////////////////////////
    // RSGetState
    ////////////////////////////////////////////////////////////
    virtual void RSGetState(  CRasterizerState ** ppRasterizerState );

    ////////////////////////////////////////////////////////////
    // RSGetViewports
    ////////////////////////////////////////////////////////////
    virtual void RSGetViewports(  UINT * NumViewports, D3D_VIEWPORT * pViewports );

    ////////////////////////////////////////////////////////////
    // RSGetScissorRects
    ////////////////////////////////////////////////////////////
    virtual void RSGetScissorRects(  UINT * NumRects, D3D_RECT * pRects );

    ////////////////////////////////////////////////////////////
    // GetDeviceRemovedReason
    ////////////////////////////////////////////////////////////
    virtual NRESULT GetDeviceRemovedReason(  );

    ////////////////////////////////////////////////////////////
    // SetExceptionMode
    ////////////////////////////////////////////////////////////
    virtual NRESULT SetExceptionMode(  UINT RaiseFlags );

    ////////////////////////////////////////////////////////////
    // GetExceptionMode
    ////////////////////////////////////////////////////////////
    virtual UINT GetExceptionMode(  );

    ////////////////////////////////////////////////////////////
    // GetPrivateData
    ////////////////////////////////////////////////////////////
    virtual NRESULT GetPrivateData(  REFGUID guid, UINT * pDataSize, void * pData );

    ////////////////////////////////////////////////////////////
    // SetPrivateData
    ////////////////////////////////////////////////////////////
    virtual NRESULT SetPrivateData(  REFGUID guid, UINT DataSize, const void * pData );

    ////////////////////////////////////////////////////////////
    // SetPrivateDataInterface
    ////////////////////////////////////////////////////////////
    virtual NRESULT SetPrivateDataInterface(  REFGUID guid, const IUnknown * pData );

    ////////////////////////////////////////////////////////////
    // ClearState
    ////////////////////////////////////////////////////////////
    virtual void ClearState(  );

    ////////////////////////////////////////////////////////////
    // Flush
    ////////////////////////////////////////////////////////////
    virtual void Flush(  );

    ////////////////////////////////////////////////////////////
    // CreateBuffer
    ////////////////////////////////////////////////////////////
    virtual NRESULT CreateBuffer(  const D3D_BUFFER_DESC * pDesc, const D3D_SUBRESOURCE_DATA * pInitialData, CBuffer ** ppBuffer );

    ////////////////////////////////////////////////////////////
    // CreateTexture1D
    ////////////////////////////////////////////////////////////
    virtual NRESULT CreateTexture1D(  const D3D_TEXTURE1D_DESC * pDesc, const D3D_SUBRESOURCE_DATA * pInitialData, CTexture1D ** ppTexture1D );

    ////////////////////////////////////////////////////////////
    // CreateTexture2D
    ////////////////////////////////////////////////////////////
    virtual NRESULT CreateTexture2D(  const D3D_TEXTURE2D_DESC * pDesc, const D3D_SUBRESOURCE_DATA * pInitialData, CTexture2D ** ppTexture2D );

    ////////////////////////////////////////////////////////////
    // CreateTexture3D
    ////////////////////////////////////////////////////////////
    virtual NRESULT CreateTexture3D(  const D3D_TEXTURE3D_DESC * pDesc, const D3D_SUBRESOURCE_DATA * pInitialData, CTexture3D ** ppTexture3D );

    ////////////////////////////////////////////////////////////
    // CreateShaderResourceView
    ////////////////////////////////////////////////////////////
    virtual NRESULT CreateShaderResourceView(  CResource * pResource, const D3D_SHADER_RESOURCE_VIEW_DESC * pDesc, CShaderResourceView ** ppSRView );

    ////////////////////////////////////////////////////////////
    // CreateRenderTargetView
    ////////////////////////////////////////////////////////////
    virtual NRESULT CreateRenderTargetView(  CResource * pResource, const D3D_RENDER_TARGET_VIEW_DESC * pDesc, CRenderTargetView ** ppRTView );

    ////////////////////////////////////////////////////////////
    // CreateDepthStencilView
    ////////////////////////////////////////////////////////////
    virtual NRESULT CreateDepthStencilView(  CResource * pResource, const D3D_DEPTH_STENCIL_VIEW_DESC * pDesc, CDepthStencilView ** ppDepthStencilView );

    ////////////////////////////////////////////////////////////
    // CreateInputLayout
    ////////////////////////////////////////////////////////////
    virtual NRESULT CreateInputLayout(  const D3D_INPUT_ELEMENT_DESC * pInputElementDescs, UINT NumElements, const void * pShaderBytecodeWithInputSignature, SIZE_T BytecodeLength, CInputLayout ** ppInputLayout );

    ////////////////////////////////////////////////////////////
    // CreateVertexShader
    ////////////////////////////////////////////////////////////
    virtual NRESULT CreateVertexShader(  const void * pShaderBytecode, SIZE_T BytecodeLength, CVertexShader ** ppVertexShader );

    ////////////////////////////////////////////////////////////
    // CreateGeometryShader
    ////////////////////////////////////////////////////////////
    virtual NRESULT CreateGeometryShader(  const void * pShaderBytecode, SIZE_T BytecodeLength, CGeometryShader ** ppGeometryShader );

    ////////////////////////////////////////////////////////////
    // CreateGeometryShaderWithStreamOutput
    ////////////////////////////////////////////////////////////
    virtual NRESULT CreateGeometryShaderWithStreamOutput(  const void * pShaderBytecode, SIZE_T BytecodeLength, const D3D_SO_DECLARATION_ENTRY * pSODeclaration, UINT NumEntries, UINT OutputStreamStride, CGeometryShader ** ppGeometryShader );

    ////////////////////////////////////////////////////////////
    // CreatePixelShader
    ////////////////////////////////////////////////////////////
    virtual NRESULT CreatePixelShader(  const void * pShaderBytecode, SIZE_T BytecodeLength, CPixelShader ** ppPixelShader );

    ////////////////////////////////////////////////////////////
    // CreateBlendState
    ////////////////////////////////////////////////////////////
    virtual NRESULT CreateBlendState(  const D3D_BLEND_DESC * pBlendStateDesc, CBlendState ** ppBlendState );

    ////////////////////////////////////////////////////////////
    // CreateDepthStencilState
    ////////////////////////////////////////////////////////////
    virtual NRESULT CreateDepthStencilState(  const D3D_DEPTH_STENCIL_DESC * pDepthStencilDesc, CDepthStencilState ** ppDepthStencilState );

    ////////////////////////////////////////////////////////////
    // CreateRasterizerState
    ////////////////////////////////////////////////////////////
    virtual NRESULT CreateRasterizerState(  const D3D_RASTERIZER_DESC * pRasterizerDesc, CRasterizerState ** ppRasterizerState );

    ////////////////////////////////////////////////////////////
    // CreateSamplerState
    ////////////////////////////////////////////////////////////
    virtual NRESULT CreateSamplerState(  const D3D_SAMPLER_DESC * pSamplerDesc, CSamplerState ** ppSamplerState );

    ////////////////////////////////////////////////////////////
    // CreateQuery
    ////////////////////////////////////////////////////////////
    virtual NRESULT CreateQuery(  const D3D_QUERY_DESC * pQueryDesc, CQuery ** ppQuery );

    ////////////////////////////////////////////////////////////
    // CreatePredicate
    ////////////////////////////////////////////////////////////
    virtual NRESULT CreatePredicate(  const D3D_QUERY_DESC * pPredicateDesc, CPredicate ** ppPredicate );

    ////////////////////////////////////////////////////////////
    // CreateCounter
    ////////////////////////////////////////////////////////////
    virtual NRESULT CreateCounter(  const D3D_COUNTER_DESC * pCounterDesc, CCounter ** ppCounter );

    ////////////////////////////////////////////////////////////
    // CheckFormatSupport
    ////////////////////////////////////////////////////////////
    virtual NRESULT CheckFormatSupport(  DXGI_FORMAT Format, UINT * pFormatSupport );

    ////////////////////////////////////////////////////////////
    // CheckMultisampleQualityLevels
    ////////////////////////////////////////////////////////////
    virtual NRESULT CheckMultisampleQualityLevels(  DXGI_FORMAT Format, UINT SampleCount, UINT * pNumQualityLevels );

    ////////////////////////////////////////////////////////////
    // CheckCounterInfo
    ////////////////////////////////////////////////////////////
    virtual void CheckCounterInfo(  D3D_COUNTER_INFO * pCounterInfo );

    ////////////////////////////////////////////////////////////
    // CheckCounter
    ////////////////////////////////////////////////////////////
    virtual NRESULT CheckCounter(  const D3D_COUNTER_DESC * pDesc, D3D_COUNTER_TYPE * pType, UINT * pActiveCounters, LPSTR szName, UINT * pNameLength, LPSTR szUnits, UINT * pUnitsLength, LPSTR szDescription, UINT * pDescriptionLength );

    ////////////////////////////////////////////////////////////
    // GetCreationFlags
    ////////////////////////////////////////////////////////////
    virtual UINT GetCreationFlags(  );

    ////////////////////////////////////////////////////////////
    // OpenSharedResource
    ////////////////////////////////////////////////////////////
    virtual NRESULT OpenSharedResource(  HANDLE hResource, REFIID ReturnedInterface, void ** ppResource );

    ////////////////////////////////////////////////////////////
    // SetTextFilterSize
    ////////////////////////////////////////////////////////////
    virtual void SetTextFilterSize(  UINT Width, UINT Height );

    ////////////////////////////////////////////////////////////
    // GetTextFilterSize
    ////////////////////////////////////////////////////////////
    virtual void GetTextFilterSize(  UINT * pWidth, UINT * pHeight );

    ////////////////////////////////////////////////////////////
    // CreateShaderResourceView1
    ////////////////////////////////////////////////////////////
    virtual NRESULT CreateShaderResourceView1(  CResource * pResource, const D3D_SHADER_RESOURCE_VIEW_DESC1 * pDesc, CShaderResourceView1 ** ppSRView );

    ////////////////////////////////////////////////////////////
    // CreateBlendState1
    ////////////////////////////////////////////////////////////
    virtual NRESULT CreateBlendState1(  const D3D_BLEND_DESC1 * pBlendStateDesc, CBlendState1 ** ppBlendState );

    ////////////////////////////////////////////////////////////
    // GetFeatureLevel
    ////////////////////////////////////////////////////////////
    virtual D3D_FEATURE_LEVEL1 GetFeatureLevel(  );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////
    virtual HRESULT CreateTexture2DFromSwapChain( IDXGISwapChain **ppSwapChain, CTexture2D ** ppTexture2D );
    virtual HRESULT CreateDebug( CDebug ** ppDebug );
    virtual HRESULT CreateInfoQueue( CInfoQueue ** ppInfoQueue );
    virtual HRESULT CreateMultithread( CMultithread ** ppMultithread );
    virtual HRESULT CreateSwitchToRef( CSwitchToRef **ppSwitchToRef );
};


////////////////////////////////////////////////////////////
//
// CMultithread
//
////////////////////////////////////////////////////////////

class CMultithread : public virtual WindowsTest::CRefObject
{
public:
    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D10Multithread **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }

    ////////////////////////////////////////////////////////////
    // Sub object accessors (for Multi-Wrapper classes)
    ////////////////////////////////////////////////////////////
    virtual CMultithread *GetSubMultithread( int index ) = 0;
    virtual IUnknown *GetIUnknown() = 0;
    virtual void SetSubMultithread( int index, CMultithread *pMultithread ) = 0;
    virtual CMultithread *Src() = 0;
    virtual CMultithread *Ref() = 0;
    virtual int GetSubObjectCount() const = 0;

    ////////////////////////////////////////////////////////////
    // Enter
    ////////////////////////////////////////////////////////////
    virtual void Enter(  );

    ////////////////////////////////////////////////////////////
    // Leave
    ////////////////////////////////////////////////////////////
    virtual void Leave(  );

    ////////////////////////////////////////////////////////////
    // SetMultithreadProtected
    ////////////////////////////////////////////////////////////
    virtual BOOL SetMultithreadProtected(  BOOL bMTProtect );

    ////////////////////////////////////////////////////////////
    // GetMultithreadProtected
    ////////////////////////////////////////////////////////////
    virtual BOOL GetMultithreadProtected(  );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////
};


////////////////////////////////////////////////////////////
//
// CDebug
//
////////////////////////////////////////////////////////////

class CDebug : public virtual WindowsTest::CRefObject
{
public:
    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D10Debug **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }
    virtual void GetInterfacePtr( ID3D11Debug **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }

    ////////////////////////////////////////////////////////////
    // Sub object accessors (for Multi-Wrapper classes)
    ////////////////////////////////////////////////////////////
    virtual CDebug *GetSubDebug( int index ) = 0;
    virtual IUnknown *GetIUnknown() = 0;
    virtual void SetSubDebug( int index, CDebug *pDebug ) = 0;
    virtual CDebug *Src() = 0;
    virtual CDebug *Ref() = 0;
    virtual int GetSubObjectCount() const = 0;

    ////////////////////////////////////////////////////////////
    // SetFeatureMask
    ////////////////////////////////////////////////////////////
    virtual NRESULT SetFeatureMask(  UINT Mask );

    ////////////////////////////////////////////////////////////
    // GetFeatureMask
    ////////////////////////////////////////////////////////////
    virtual UINT GetFeatureMask(  );

    ////////////////////////////////////////////////////////////
    // SetPresentPerRenderOpDelay
    ////////////////////////////////////////////////////////////
    virtual NRESULT SetPresentPerRenderOpDelay(  UINT Milliseconds );

    ////////////////////////////////////////////////////////////
    // GetPresentPerRenderOpDelay
    ////////////////////////////////////////////////////////////
    virtual UINT GetPresentPerRenderOpDelay(  );

    ////////////////////////////////////////////////////////////
    // SetSwapChain
    ////////////////////////////////////////////////////////////
    virtual NRESULT SetSwapChain(  IDXGISwapChain * pSwapChain );

    ////////////////////////////////////////////////////////////
    // GetSwapChain
    ////////////////////////////////////////////////////////////
    virtual NRESULT GetSwapChain(  IDXGISwapChain ** ppSwapChain );

    ////////////////////////////////////////////////////////////
    // Validate
    ////////////////////////////////////////////////////////////
    virtual NRESULT Validate(  );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////
};


////////////////////////////////////////////////////////////
//
// CSwitchToRef
//
////////////////////////////////////////////////////////////

class CSwitchToRef : public virtual WindowsTest::CRefObject
{
public:
    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D10SwitchToRef **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }
    virtual void GetInterfacePtr( ID3D11SwitchToRef **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }

    ////////////////////////////////////////////////////////////
    // Sub object accessors (for Multi-Wrapper classes)
    ////////////////////////////////////////////////////////////
    virtual CSwitchToRef *GetSubSwitchToRef( int index ) = 0;
    virtual IUnknown *GetIUnknown() = 0;
    virtual void SetSubSwitchToRef( int index, CSwitchToRef *pSwitchToRef ) = 0;
    virtual CSwitchToRef *Src() = 0;
    virtual CSwitchToRef *Ref() = 0;
    virtual int GetSubObjectCount() const = 0;

    ////////////////////////////////////////////////////////////
    // SetUseRef
    ////////////////////////////////////////////////////////////
    virtual BOOL SetUseRef(  BOOL UseRef );

    ////////////////////////////////////////////////////////////
    // GetUseRef
    ////////////////////////////////////////////////////////////
    virtual BOOL GetUseRef(  );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////
};


////////////////////////////////////////////////////////////
//
// CInfoQueue
//
////////////////////////////////////////////////////////////

class CInfoQueue : public virtual WindowsTest::CRefObject
{
public:
    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D10InfoQueue **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }
    virtual void GetInterfacePtr( ID3D11InfoQueue **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }

    ////////////////////////////////////////////////////////////
    // Sub object accessors (for Multi-Wrapper classes)
    ////////////////////////////////////////////////////////////
    virtual CInfoQueue *GetSubInfoQueue( int index ) = 0;
    virtual IUnknown *GetIUnknown() = 0;
    virtual void SetSubInfoQueue( int index, CInfoQueue *pInfoQueue ) = 0;
    virtual CInfoQueue *Src() = 0;
    virtual CInfoQueue *Ref() = 0;
    virtual int GetSubObjectCount() const = 0;

    ////////////////////////////////////////////////////////////
    // SetMessageCountLimit
    ////////////////////////////////////////////////////////////
    virtual NRESULT SetMessageCountLimit(  UINT64 MessageCountLimit );

    ////////////////////////////////////////////////////////////
    // ClearStoredMessages
    ////////////////////////////////////////////////////////////
    virtual void ClearStoredMessages(  );

    ////////////////////////////////////////////////////////////
    // GetMessage
    ////////////////////////////////////////////////////////////
    virtual NRESULT GetMessage(  UINT64 MessageIndex, D3D_MESSAGE * pMessage, SIZE_T * pMessageByteLength );

    ////////////////////////////////////////////////////////////
    // GetNumMessagesAllowedByStorageFilter
    ////////////////////////////////////////////////////////////
    virtual UINT64 GetNumMessagesAllowedByStorageFilter(  );

    ////////////////////////////////////////////////////////////
    // GetNumMessagesDeniedByStorageFilter
    ////////////////////////////////////////////////////////////
    virtual UINT64 GetNumMessagesDeniedByStorageFilter(  );

    ////////////////////////////////////////////////////////////
    // GetNumStoredMessages
    ////////////////////////////////////////////////////////////
    virtual UINT64 GetNumStoredMessages(  );

    ////////////////////////////////////////////////////////////
    // GetNumStoredMessagesAllowedByRetrievalFilter
    ////////////////////////////////////////////////////////////
    virtual UINT64 GetNumStoredMessagesAllowedByRetrievalFilter(  );

    ////////////////////////////////////////////////////////////
    // GetNumMessagesDiscardedByMessageCountLimit
    ////////////////////////////////////////////////////////////
    virtual UINT64 GetNumMessagesDiscardedByMessageCountLimit(  );

    ////////////////////////////////////////////////////////////
    // GetMessageCountLimit
    ////////////////////////////////////////////////////////////
    virtual UINT64 GetMessageCountLimit(  );

    ////////////////////////////////////////////////////////////
    // AddStorageFilterEntries
    ////////////////////////////////////////////////////////////
    virtual NRESULT AddStorageFilterEntries(  D3D_INFO_QUEUE_FILTER * pFilter );

    ////////////////////////////////////////////////////////////
    // GetStorageFilter
    ////////////////////////////////////////////////////////////
    virtual NRESULT GetStorageFilter(  D3D_INFO_QUEUE_FILTER * pFilter, SIZE_T * pFilterByteLength );

    ////////////////////////////////////////////////////////////
    // ClearStorageFilter
    ////////////////////////////////////////////////////////////
    virtual void ClearStorageFilter(  );

    ////////////////////////////////////////////////////////////
    // PushEmptyStorageFilter
    ////////////////////////////////////////////////////////////
    virtual NRESULT PushEmptyStorageFilter(  );

    ////////////////////////////////////////////////////////////
    // PushCopyOfStorageFilter
    ////////////////////////////////////////////////////////////
    virtual NRESULT PushCopyOfStorageFilter(  );

    ////////////////////////////////////////////////////////////
    // PushStorageFilter
    ////////////////////////////////////////////////////////////
    virtual NRESULT PushStorageFilter(  D3D_INFO_QUEUE_FILTER * pFilter );

    ////////////////////////////////////////////////////////////
    // PopStorageFilter
    ////////////////////////////////////////////////////////////
    virtual void PopStorageFilter(  );

    ////////////////////////////////////////////////////////////
    // GetStorageFilterStackSize
    ////////////////////////////////////////////////////////////
    virtual UINT GetStorageFilterStackSize(  );

    ////////////////////////////////////////////////////////////
    // AddRetrievalFilterEntries
    ////////////////////////////////////////////////////////////
    virtual NRESULT AddRetrievalFilterEntries(  D3D_INFO_QUEUE_FILTER * pFilter );

    ////////////////////////////////////////////////////////////
    // GetRetrievalFilter
    ////////////////////////////////////////////////////////////
    virtual NRESULT GetRetrievalFilter(  D3D_INFO_QUEUE_FILTER * pFilter, SIZE_T * pFilterByteLength );

    ////////////////////////////////////////////////////////////
    // ClearRetrievalFilter
    ////////////////////////////////////////////////////////////
    virtual void ClearRetrievalFilter(  );

    ////////////////////////////////////////////////////////////
    // PushEmptyRetrievalFilter
    ////////////////////////////////////////////////////////////
    virtual NRESULT PushEmptyRetrievalFilter(  );

    ////////////////////////////////////////////////////////////
    // PushCopyOfRetrievalFilter
    ////////////////////////////////////////////////////////////
    virtual NRESULT PushCopyOfRetrievalFilter(  );

    ////////////////////////////////////////////////////////////
    // PushRetrievalFilter
    ////////////////////////////////////////////////////////////
    virtual NRESULT PushRetrievalFilter(  D3D_INFO_QUEUE_FILTER * pFilter );

    ////////////////////////////////////////////////////////////
    // PopRetrievalFilter
    ////////////////////////////////////////////////////////////
    virtual void PopRetrievalFilter(  );

    ////////////////////////////////////////////////////////////
    // GetRetrievalFilterStackSize
    ////////////////////////////////////////////////////////////
    virtual UINT GetRetrievalFilterStackSize(  );

    ////////////////////////////////////////////////////////////
    // AddMessage
    ////////////////////////////////////////////////////////////
    virtual NRESULT AddMessage(  D3D_MESSAGE_CATEGORY Category, D3D_MESSAGE_SEVERITY Severity, D3D_MESSAGE_ID ID, LPCSTR pDescription );

    ////////////////////////////////////////////////////////////
    // AddApplicationMessage
    ////////////////////////////////////////////////////////////
    virtual NRESULT AddApplicationMessage(  D3D_MESSAGE_SEVERITY Severity, LPCSTR pDescription );

    ////////////////////////////////////////////////////////////
    // SetBreakOnCategory
    ////////////////////////////////////////////////////////////
    virtual NRESULT SetBreakOnCategory(  D3D_MESSAGE_CATEGORY Category, BOOL bEnable );

    ////////////////////////////////////////////////////////////
    // SetBreakOnSeverity
    ////////////////////////////////////////////////////////////
    virtual NRESULT SetBreakOnSeverity(  D3D_MESSAGE_SEVERITY Severity, BOOL bEnable );

    ////////////////////////////////////////////////////////////
    // SetBreakOnID
    ////////////////////////////////////////////////////////////
    virtual NRESULT SetBreakOnID(  D3D_MESSAGE_ID ID, BOOL bEnable );

    ////////////////////////////////////////////////////////////
    // GetBreakOnCategory
    ////////////////////////////////////////////////////////////
    virtual BOOL GetBreakOnCategory(  D3D_MESSAGE_CATEGORY Category );

    ////////////////////////////////////////////////////////////
    // GetBreakOnSeverity
    ////////////////////////////////////////////////////////////
    virtual BOOL GetBreakOnSeverity(  D3D_MESSAGE_SEVERITY Severity );

    ////////////////////////////////////////////////////////////
    // GetBreakOnID
    ////////////////////////////////////////////////////////////
    virtual BOOL GetBreakOnID(  D3D_MESSAGE_ID ID );

    ////////////////////////////////////////////////////////////
    // SetMuteDebugOutput
    ////////////////////////////////////////////////////////////
    virtual void SetMuteDebugOutput(  BOOL bMute );

    ////////////////////////////////////////////////////////////
    // GetMuteDebugOutput
    ////////////////////////////////////////////////////////////
    virtual BOOL GetMuteDebugOutput(  );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////
};


////////////////////////////////////////////////////////////
//
// CBlob
//
////////////////////////////////////////////////////////////

class CBlob : public virtual WindowsTest::CRefObject
{
public:
    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D10Blob **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }
    virtual void GetInterfacePtr( ID3D11Blob **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }

    ////////////////////////////////////////////////////////////
    // Sub object accessors (for Multi-Wrapper classes)
    ////////////////////////////////////////////////////////////
    virtual CBlob *GetSubBlob( int index ) = 0;
    virtual IUnknown *GetIUnknown() = 0;
    virtual void SetSubBlob( int index, CBlob *pBlob ) = 0;
    virtual CBlob *Src() = 0;
    virtual CBlob *Ref() = 0;
    virtual int GetSubObjectCount() const = 0;

    ////////////////////////////////////////////////////////////
    // QueryInterface
    ////////////////////////////////////////////////////////////
    virtual NRESULT QueryInterface(  REFIID iid, LPVOID * ppv );

    ////////////////////////////////////////////////////////////
    // GetBufferPointer
    ////////////////////////////////////////////////////////////
    virtual LPVOID GetBufferPointer(  );

    ////////////////////////////////////////////////////////////
    // GetBufferSize
    ////////////////////////////////////////////////////////////
    virtual SIZE_T GetBufferSize(  );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////
};


////////////////////////////////////////////////////////////
//
// CBlendState1
//
////////////////////////////////////////////////////////////

class CBlendState1 : public virtual CBlendState
{
public:
    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D10BlendState1 **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }
    virtual void GetInterfacePtr( ID3D11BlendState **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }

    ////////////////////////////////////////////////////////////
    // Sub object accessors (for Multi-Wrapper classes)
    ////////////////////////////////////////////////////////////
    virtual CBlendState1 *GetSubBlendState1( int index ) = 0;
    virtual IUnknown *GetIUnknown() = 0;
    virtual void SetSubBlendState1( int index, CBlendState1 *pBlendState1 ) = 0;
    virtual CBlendState1 *Src() = 0;
    virtual CBlendState1 *Ref() = 0;

    ////////////////////////////////////////////////////////////
    // GetDesc1
    ////////////////////////////////////////////////////////////
    virtual void GetDesc1(  D3D_BLEND_DESC1 * pDesc );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////
};


////////////////////////////////////////////////////////////
//
// CShaderResourceView1
//
////////////////////////////////////////////////////////////

class CShaderResourceView1 : public virtual CShaderResourceView
{
public:
    ////////////////////////////////////////////////////////////
    // GetInterfacePtr
    ////////////////////////////////////////////////////////////
    virtual void GetInterfacePtr( ID3D10ShaderResourceView1 **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }
    virtual void GetInterfacePtr( ID3D11ShaderResourceView **ppInterface ) { throw( WRAPPER_METHOD_UNSUPPORTED ); }

    ////////////////////////////////////////////////////////////
    // Sub object accessors (for Multi-Wrapper classes)
    ////////////////////////////////////////////////////////////
    virtual CShaderResourceView1 *GetSubShaderResourceView1( int index ) = 0;
    virtual IUnknown *GetIUnknown() = 0;
    virtual void SetSubShaderResourceView1( int index, CShaderResourceView1 *pShaderResourceView1 ) = 0;
    virtual CShaderResourceView1 *Src() = 0;
    virtual CShaderResourceView1 *Ref() = 0;

    ////////////////////////////////////////////////////////////
    // GetDesc1
    ////////////////////////////////////////////////////////////
    virtual void GetDesc1(  D3D_SHADER_RESOURCE_VIEW_DESC1 * pDesc );


    ////////////////////////////////////////////////////////////
    // Extra Methods
    ////////////////////////////////////////////////////////////
};
