#include "DXGIFMT.h"

DXGI_FORMAT_INFO DXGIFormats[] =
{
{    DXGI_FORMAT_UNKNOWN                                     , 0,                 0},
{    DXGI_FORMAT_R32G32B32A32_TYPELESS                       , 1,                 128},
{        DXGI_FORMAT_R32G32B32A32_FLOAT                      , 2,                 128},
{        DXGI_FORMAT_R32G32B32A32_UINT                       , 3,                 128},
{        DXGI_FORMAT_R32G32B32A32_SINT                       , 4,                 128},
{    DXGI_FORMAT_R32G32B32_TYPELESS                          , 5,                 96},
{        DXGI_FORMAT_R32G32B32_FLOAT                         , 6,                 96},
{        DXGI_FORMAT_R32G32B32_UINT                          , 7,                 96},
{        DXGI_FORMAT_R32G32B32_SINT                          , 8,                 96},
{    DXGI_FORMAT_R16G16B16A16_TYPELESS                       , 9,                 64},
{       DXGI_FORMAT_R16G16B16A16_FLOAT                       , 10,                64},
{        DXGI_FORMAT_R16G16B16A16_UNORM                      , 11,                64},
{        DXGI_FORMAT_R16G16B16A16_UINT                       , 12,                64},
{        DXGI_FORMAT_R16G16B16A16_SNORM                      , 13,                64},
{        DXGI_FORMAT_R16G16B16A16_SINT                       , 14,                64},
{    DXGI_FORMAT_R32G32_TYPELESS                             , 15,                64},
{        DXGI_FORMAT_R32G32_FLOAT                            , 16,                64},
{        DXGI_FORMAT_R32G32_UINT                             , 17,                64},
{        DXGI_FORMAT_R32G32_SINT                             , 18,                64},
{    DXGI_FORMAT_R32G8X24_TYPELESS                           , 19,                64},
{        DXGI_FORMAT_D32_FLOAT_S8X24_UINT                    , 20,                64},
{        DXGI_FORMAT_R32_FLOAT_X8X24_TYPELESS                , 21,                64},
{        DXGI_FORMAT_X32_TYPELESS_G8X24_UINT                 , 22,                64},
{    DXGI_FORMAT_R10G10B10A2_TYPELESS                        , 23,                32},
{        DXGI_FORMAT_R10G10B10A2_UNORM                       , 24,                32},
{        DXGI_FORMAT_R10G10B10A2_UINT                        , 25,                32},
{        DXGI_FORMAT_R11G11B10_FLOAT                         , 26,                32},
{        DXGI_FORMAT_R10G10B10_XR_BIAS_A2_UNORM              , 27,                32}, 
{    DXGI_FORMAT_R8G8B8A8_TYPELESS                           , 28,                32},
{        DXGI_FORMAT_R8G8B8A8_UNORM                          , 29,                32},
{        DXGI_FORMAT_R8G8B8A8_UNORM_SRGB                     , 30,                32},
{        DXGI_FORMAT_R8G8B8A8_UINT                           , 31,                32},
{        DXGI_FORMAT_R8G8B8A8_SNORM                          , 32,                32},
{        DXGI_FORMAT_R8G8B8A8_SINT                           , 33,                32},
{    DXGI_FORMAT_R16G16_TYPELESS                             , 34,                32},
{        DXGI_FORMAT_R16G16_FLOAT                            , 35,                32},
{        DXGI_FORMAT_R16G16_UNORM                            , 36,                32},
{        DXGI_FORMAT_R16G16_UINT                             , 37,                32},
{        DXGI_FORMAT_R16G16_SNORM                            , 38,                32},
{        DXGI_FORMAT_R16G16_SINT                             , 39,                32},
{    DXGI_FORMAT_R32_TYPELESS                                , 40,                32},
{        DXGI_FORMAT_D32_FLOAT                               , 41,                32},
{        DXGI_FORMAT_R32_FLOAT                               , 42,                32},
{        DXGI_FORMAT_R32_UINT                                , 43,                32},
{        DXGI_FORMAT_R32_SINT                                , 44,                32},
{    DXGI_FORMAT_R24G8_TYPELESS                              , 45,                32},
{        DXGI_FORMAT_D24_UNORM_S8_UINT                       , 46,                32},
{        DXGI_FORMAT_R24_UNORM_X8_TYPELESS                   , 47,                32},
{        DXGI_FORMAT_X24_TYPELESS_G8_UINT                    , 48,                32},
{    DXGI_FORMAT_R8G8_TYPELESS                               , 49,                16},
{        DXGI_FORMAT_R8G8_UNORM                              , 50,                16},
{        DXGI_FORMAT_R8G8_UINT                               , 51,                16},
{        DXGI_FORMAT_R8G8_SNORM                              , 52,                16},
{        DXGI_FORMAT_R8G8_SINT                               , 53,                16},
{    DXGI_FORMAT_R16_TYPELESS                                , 54,                16},
{        DXGI_FORMAT_R16_FLOAT                               , 55,                16},
{        DXGI_FORMAT_D16_UNORM                               , 56,                16},
{        DXGI_FORMAT_R16_UNORM                               , 57,                16},
{        DXGI_FORMAT_R16_UINT                                , 58,                16},
{        DXGI_FORMAT_R16_SNORM                               , 59,                16},
{        DXGI_FORMAT_R16_SINT                                , 60,                16},
{    DXGI_FORMAT_R8_TYPELESS                                 , 61,                8},
{        DXGI_FORMAT_R8_UNORM                                , 62,                8},
{        DXGI_FORMAT_R8_UINT                                 , 63,                8},
{        DXGI_FORMAT_R8_SNORM                                , 64,                8},
{        DXGI_FORMAT_R8_SINT                                 , 65,                8},
{    DXGI_FORMAT_A8_UNORM                                    , 66,                8},
{    DXGI_FORMAT_R1_UNORM                                    , 67,                1},
{    DXGI_FORMAT_R9G9B9E5_SHAREDEXP                          , 68,                16},
{    DXGI_FORMAT_R8G8_B8G8_UNORM                             , 69,                0},
{    DXGI_FORMAT_B8G8R8A8_UNORM_SRGB                         , 70,                0},
{    DXGI_FORMAT_G8R8_G8B8_UNORM                             , 71,                0},
{    DXGI_FORMAT_BC1_UNORM                                   , 72,                0},
{    DXGI_FORMAT_BC1_UNORM_SRGB                              , 73,                0},
{    DXGI_FORMAT_BC2_UNORM                                   , 74,                0},
{    DXGI_FORMAT_BC2_UNORM_SRGB                              , 75,                0},
{    DXGI_FORMAT_BC3_UNORM                                   , 76,                0},
{    DXGI_FORMAT_BC3_UNORM_SRGB                              , 77,                0},
{    DXGI_FORMAT_BC4_UNORM                                   , 78,                0},
{    DXGI_FORMAT_BC4_SNORM                                   , 79,                0},
{    DXGI_FORMAT_BC5_UNORM                                   , 80,                0},
{    DXGI_FORMAT_BC5_SNORM                                   , 81,                0}
};

CONST UINT cuiNoOfFormats = sizeof(DXGIFormats) / sizeof(DXGI_FORMAT_INFO);

CONST DXGI_FORMAT_INFO* FindFormatRecord(DXGI_FORMAT dxgiformatSearch)
{
	if (cuiNoOfFormats)
	{
		UINT uiFormatIndex = 0;

		do
		{
			if ((DXGIFormats[uiFormatIndex]).dxgiformat == dxgiformatSearch)
				return &(DXGIFormats[uiFormatIndex]);
		}
		while ((++uiFormatIndex) < cuiNoOfFormats);
	}

	return NULL;
}
