/*** 
*guids.h
*
*Purpose:
*  This file defines all GUIDS the Unix project could not find defined 
*  elsewhere.  If you know where the proper place for some of these 
*  GUID definitions are, remove these and use the other ones.
*
*  Actually, most of these if not all are in comdefs.h
*  Unfortunately they use __declspec(uuid), though.  We might want to 
*  run a script past those and generate this file...  (davidd)
*
*Implementation Notes:
*
*****************************************************************************/

#include <obguid.h>
#include <clsid.h>
#include <urlmon.h>
#include <oleguid.h>
#include <coguid.h>
#include <olectl.h>


DEFINE_OLEGUID(CLSID_DfMarshal,		0x0000030b, 0, 0);

DEFINE_OLEGUID(IID_IDispatch,		0x00020400L, 0, 0);
DEFINE_OLEGUID(IID_IEnumVARIANT,	0x00020404L, 0, 0);
DEFINE_OLEGUID(IID_ITypeInfo,		0x00020401L, 0, 0);
DEFINE_OLEGUID(IID_ITypeLib,		0x00020402L, 0, 0);
DEFINE_OLEGUID(IID_ITypeComp,		0x00020403L, 0, 0);
DEFINE_OLEGUID(IID_ICreateTypeInfo,	0x00020405L, 0, 0);
DEFINE_OLEGUID(IID_ICreateTypeLib,	0x00020406L, 0, 0);
DEFINE_OLEGUID(IID_ICreateTypeInfo2,    0x0002040eL, 0, 0);
DEFINE_OLEGUID(IID_ITypeInfo2,          0x00020412L, 0, 0);

DEFINE_OLEGUID(IID_StdOle,		0x00020430L, 0, 0);

DEFINE_OLEGUID(CLSID_PSRemoteTypeInfo, 	0x00020424, 0, 0);

/* Because we don't have oledb_i.c, we need this IID defined here */
/* // Begin oledb_i.c */

DEFINE_GUID(IID_IRowsetChapterMember,
  0x0c733aa8L, 0x2a1c, 0x11ce, 0xad, 0xe5, 0x00, 0xaa, 0x00, 0x44, 0x77,0x3d);

/* // End oledb_i.c */


/* // {3E42C004-6BFD-17E2-B4CC-0800208359F5} */
DEFINE_GUID(IID_IWindowStatus,
  0x3E42C004L, 0x6BFD, 0x17E2, 0xB4, 0xCC, 0x08, 0x00, 0x20, 0x83, 0x59, 0xF5);

/* // {1CF2B120-547D-101B-8E65-08002B2BD119} */
DEFINE_GUID(IID_IErrorInfo,
  0x1CF2B120L, 0x547D, 0x101B, 0x8E, 0x65, 0x08, 0x00, 0x2B, 0x2B, 0xD1, 0x19);

/* // {22F03340-547D-101B-8E65-08002B2BD119} */
DEFINE_GUID(IID_ICreateErrorInfo,
  0x22F03340L, 0x547D, 0x101B, 0x8E, 0x65, 0x08, 0x00, 0x2B, 0x2B, 0xD1, 0x19);

/* // {DF0B3D60-548F-101B-8E65-08002B2BD119} */
DEFINE_GUID(IID_ISupportErrorInfo,
  0xDF0B3D60L, 0x548F, 0x101B, 0x8E, 0x65, 0x08, 0x00, 0x2B, 0x2B, 0xD1, 0x19);

/* // {0000001d-0000-0000-c000-000000000046} */
DEFINE_GUID(IID_IMallocSpy,
  0x0000001DL, 0x0000, 0x0000, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46);

// For IE
DEFINE_GUID(CLSID_URLMoniker,
  0x79eac9e0,0xbaf9,0x11ce,0x8c,0x82,0x00,0xaa,0x00,0x4b,0xa9,0x0b);

DEFINE_GUID(CLSID_MsgBand,
  0x07B8F010,0x9E21,0x11d1,0xA8,0x2E,0x08,0x00,0x09,0xDC,0x53,0x35);

// following are added for MFC4.2
DEFINE_GUID(IID_IBoundObject,
	0x9BFBBC00,0xEFF1,0x101A,0x84,0xED,0x00,0xAA,0x00,0x34,0x1D,0x07);
DEFINE_GUID(IID_IBoundObjectSite,
	0x9BFBBC01,0xEFF1,0x101A,0x84,0xED,0x00,0xAA,0x00,0x34,0x1D,0x07);

/* {DB526CC0-D188-11cd-AD48-00AA003C9CB6} */
DEFINE_GUID(IID_INotifyDBEvents,
0xdb526cc0, 0xd188, 0x11cd, 0xad, 0x48, 0x0, 0xaa, 0x0, 0x3c, 0x9c, 0xb6);

/* {9F6AA700-D188-11cd-AD48-00AA003C9CB6} */
DEFINE_GUID(IID_ICursor,
0x9f6aa700, 0xd188, 0x11cd, 0xad, 0x48, 0x0, 0xaa, 0x0, 0x3c, 0x9c, 0xb6);

/* {ACFF0690-D188-11cd-AD48-00AA003C9CB6} */
DEFINE_GUID(IID_ICursorMove,
0xacff0690, 0xd188, 0x11cd, 0xad, 0x48, 0x0, 0xaa, 0x0, 0x3c, 0x9c, 0xb6);

/* {D14216A0-D188-11cd-AD48-00AA003C9CB6} */
DEFINE_GUID(IID_ICursorUpdateARow,
0xd14216a0, 0xd188, 0x11cd, 0xad, 0x48, 0x0, 0xaa, 0x0, 0x3c, 0x9c, 0xb6);

/* Xiao-Yu ???? I couldn't find definition for the following IIDs even on
 * the lasted 4.2 enterprise edition CD.  So just defined some dummy values 
 * here to get MFC lib linked.  All the IIDs here need to be defined
 * once we find Microsoft's definition for them.
 */
DEFINE_GUID(IID_IDefViewBrowser,
0xaddf68db, 0xca3c, 0x11cf, 0x9e, 0x84, 0x00, 0x00, 0x00, 0xf8, 0x80, 0xbf); 

// A bunch of IID's formerly in olectlid.h.
DEFINE_GUID(IID_IEnumConnections,0xB196B287,0xBAB4,0x101A,0xB6,0x9C,0x00,0xAA,0x00,0x34,0x1D,0x07);
DEFINE_GUID(IID_IConnectionPoint,0xB196B286,0xBAB4,0x101A,0xB6,0x9C,0x00,0xAA,0x00,0x34,0x1D,0x07);
DEFINE_GUID(IID_IEnumConnectionPoints,0xB196B285,0xBAB4,0x101A,0xB6,0x9C,0x00,0xAA,0x00,0x34,0x1D,0x07);
DEFINE_GUID(IID_IConnectionPointContainer,0xB196B284,0xBAB4,0x101A,0xB6,0x9C,0x00,0xAA,0x00,0x34,0x1D,0x07);
DEFINE_GUID(IID_IClassFactory2,0xB196B28F,0xBAB4,0x101A,0xB6,0x9C,0x00,0xAA,0x00,0x34,0x1D,0x07);
DEFINE_GUID(IID_IProvideClassInfo,0xB196B283,0xBAB4,0x101A,0xB6,0x9C,0x00,0xAA,0x00,0x34,0x1D,0x07);
DEFINE_GUID(IID_IProvideClassInfo2,0xA6BC3AC0,0xDBAA,0x11CE,0x9D,0xE3,0x00,0xAA,0x00,0x4B,0xB8,0x51);
DEFINE_GUID(IID_IOleControl,0xB196B288,0xBAB4,0x101A,0xB6,0x9C,0x00,0xAA,0x00,0x34,0x1D,0x07);
DEFINE_GUID(IID_IOleControlSite,0xB196B289,0xBAB4,0x101A,0xB6,0x9C,0x00,0xAA,0x00,0x34,0x1D,0x07);
DEFINE_GUID(IID_IPropertyPage,0xB196B28D,0xBAB4,0x101A,0xB6,0x9C,0x00,0xAA,0x00,0x34,0x1D,0x07);
DEFINE_GUID(IID_IPropertyPage2,0x01E44665,0x24AC,0x101B,0x84,0xED,0x08,0x00,0x2B,0x2E,0xC7,0x13);
DEFINE_GUID(IID_IPropertyPageSite,0xB196B28C,0xBAB4,0x101A,0xB6,0x9C,0x00,0xAA,0x00,0x34,0x1D,0x07);
DEFINE_GUID(IID_IPropertyNotifySink,0x9BFBBC02,0xEFF1,0x101A,0x84,0xED,0x00,0xAA,0x00,0x34,0x1D,0x07);
DEFINE_GUID(IID_ISpecifyPropertyPages,0xB196B28B,0xBAB4,0x101A,0xB6,0x9C,0x00,0xAA,0x00,0x34,0x1D,0x07);
DEFINE_GUID(IID_IPersistMemory,0xBD1AE5E0,0xA6AE,0x11CE,0xBD,0x37,0x50,0x42,0x00,0xC1,0x00,0x00);
DEFINE_GUID(IID_IPersistStreamInit,0x7FD52380,0x4E07,0x101B,0xAE,0x2D,0x08,0x00,0x2B,0x2E,0xC7,0x13);
DEFINE_GUID(IID_IPersistPropertyBag,0x37D84F60,0x42CB,0x11CE,0x81,0x35,0x00,0xAA,0x00,0x4B,0xB8,0x51);
DEFINE_GUID(IID_ISimpleFrameSite,0x742B0E01,0x14E6,0x101B,0x91,0x4E,0x00,0xAA,0x00,0x30,0x0C,0xAB);
DEFINE_GUID(IID_IFont,0xBEF6E002,0xA874,0x101A,0x8B,0xBA,0x00,0xAA,0x00,0x30,0x0C,0xAB);
DEFINE_GUID(IID_IPicture,0x7BF80980,0xBF32,0x101A,0x8B,0xBB,0x00,0xAA,0x00,0x30,0x0C,0xAB);
DEFINE_GUID(IID_IFontDisp,0xBEF6E003,0xA874,0x101A,0x8B,0xBA,0x00,0xAA,0x00,0x30,0x0C,0xAB);
DEFINE_GUID(IID_IPictureDisp,0x7BF80981,0xBF32,0x101A,0x8B,0xBB,0x00,0xAA,0x00,0x30,0x0C,0xAB);
DEFINE_GUID(IID_IAdviseSinkEx,0x3AF24290,0x0C96,0x11CE,0xA0,0xCF,0x00,0xAA,0x00,0x60,0x0A,0xB8);
DEFINE_GUID(IID_IOleInPlaceObjectWindowless,0x1C2056CC,0x5EF4,0x101B,0x8B,0xC8,0x00,0xAA,0x00,0x3E,0x3B,0x29);
DEFINE_GUID(IID_IOleInPlaceSiteEx,0x9C2CAD80,0x3424,0x11CF,0xB6,0x70,0x00,0xAA,0x00,0x4C,0xD6,0xD8);
DEFINE_GUID(IID_IOleInPlaceSiteWindowless,0x922EADA0,0x3424,0x11CF,0xB6,0x70,0x00,0xAA,0x00,0x4C,0xD6,0xD8);
DEFINE_GUID(IID_IViewObjectEx,0x3AF24292,0x0C96,0x11CE,0xA0,0xCF,0x00,0xAA,0x00,0x60,0x0A,0xB8);
DEFINE_GUID(IID_IOleUndoUnit,0x894AD3B0,0xEF97,0x11CE,0x9B,0xC9,0x00,0xAA,0x00,0x60,0x8E,0x01);
DEFINE_GUID(IID_IOleParentUndoUnit,0xA1FAF330,0xEF97,0x11CE,0x9B,0xC9,0x00,0xAA,0x00,0x60,0x8E,0x01);
DEFINE_GUID(IID_IEnumOleUndoUnits,0xB3E7C340,0xEF97,0x11CE,0x9B,0xC9,0x00,0xAA,0x00,0x60,0x8E,0x01);
DEFINE_GUID(IID_IOleUndoManager,0xD001F200,0xEF97,0x11CE,0x9B,0xC9,0x00,0xAA,0x00,0x60,0x8E,0x01);
DEFINE_GUID(IID_IQuickActivate,0xCF51ED10,0x62FE,0x11CF,0xBF,0x86,0x00,0xA0,0xC9,0x03,0x48,0x36);
DEFINE_GUID(IID_IPointerInactive,0x55980BA0,0x35AA,0x11CF,0xB6,0x71,0x00,0xAA,0x00,0x4C,0xD6,0xD8);
DEFINE_GUID(IID_IObjectWithSite,0xFC4801A3,0x2BA9,0x11CF,0xA2,0x29,0x00,0xAA,0x00,0x3D,0x73,0x52);
DEFINE_GUID(IID_IErrorLog,0x3127CA40,0x446E,0x11CE,0x81,0x35,0x00,0xAA,0x00,0x4B,0xB8,0x51);
DEFINE_GUID(IID_IPropertyBag,0x55272A00,0x42CB,0x11CE,0x81,0x35,0x00,0xAA,0x00,0x4B,0xB8,0x51);
DEFINE_GUID(IID_IPerPropertyBrowsing,0x376BD3AA,0x3845,0x101B,0x84,0xED,0x08,0x00,0x2B,0x2E,0xC7,0x13);
DEFINE_GUID(IID_IClientSecurity,     0x0000013d,0x0000,0x0000,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);
DEFINE_GUID(IID_IRichEditOleCallback,0x00020d03,0x0000,0x0000,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x46);

// Stuff from java/common/inc/pdlgguid.h (in permdlg.lib)
DEFINE_GUID(IID_IJavaZonePermissionEditor, 0x85347F8A,0xC8B7,0x11d0,0x88,0x23,0x00,0xC0,0x4F,0xB6,0x7C,0x84);
DEFINE_GUID(CLSID_JavaRuntimeConfiguration, 0x004CE610,0xCCD1,0x11d0,0xA9,0xBA,0x00,0xA0,0xC9,0x08,0xDB,0x5E);

// Stuff for old trident 4.0


DEFINE_GUID(DIID_DispIHTMLLinkElement, 0x3050f524,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLFormElement, 0x3050f510,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLControlElement, 0x3050f53f,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLTextElement, 0x3050f537,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLTextContainer, 0x3050f53e,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLImgElement, 0x3050f51c,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLBodyElement, 0x3050f507,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLFontElement, 0x3050f512,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLAnchorElement, 0x3050f502,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLLabelElement, 0x3050f522,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLListElement, 0x3050f525,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLUListElement, 0x3050f538,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLOListElement, 0x3050f52a,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLLIElement, 0x3050f523,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLBlockElement, 0x3050f506,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLDivElement, 0x3050f50c,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLDDElement, 0x3050f50b,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLDTElement, 0x3050f50d,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLBRElement, 0x3050f53a,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLDListElement, 0x3050f53b,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLHRElement, 0x3050f53d,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLParaElement, 0x3050f52c,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLHeaderElement, 0x3050f515,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLSelectElement, 0x3050f531,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLOptionElement, 0x3050f52b,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLTextAreaElement, 0x3050f521,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLButtonElement, 0x3050f51f,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLMarqueeElement, 0x3050f527,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLTitleElement, 0x3050f516,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLMetaElement, 0x3050f517,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLBaseElement, 0x3050f518,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLIsIndexElement, 0x3050f519,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLNextIdElement, 0x3050f51a,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLBaseFontElement, 0x3050f504,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLUnknownElement, 0x3050f539,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLEmbedElement, 0x3050f52e,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLMapElement, 0x3050f526,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLAreaElement, 0x3050f503,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLTableCaption, 0x3050f508,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLCommentElement, 0x3050f50a,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLPhraseElement, 0x3050f52d,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLSpanElement, 0x3050f548,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLTable, 0x3050f532,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLTableCol, 0x3050f533,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLTableSection, 0x3050f534,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLTableRow, 0x3050f535,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLTableCell, 0x3050f536,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLScriptElement, 0x3050f530,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLNoShowElement, 0x3050f528,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLObjectElement, 0x3050f529,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLFrameBase, 0x3050f541,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLFrameElement, 0x3050f513,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLIFrameElement, 0x3050f51b,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLDivPosition, 0x3050f50f,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLFieldSetElement, 0x3050f545,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLLegendElement, 0x3050f546,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLSpanFlow, 0x3050f544,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLFrameSetElement, 0x3050f514,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLBGsound, 0x3050f53c,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);
DEFINE_GUID(DIID_DispIHTMLStyleElement, 0x3050f511,0x98b5,0x11cf,0xbb,0x82,0x00,0xaa,0x00,0xbd,0xce,0x0b);

DEFINE_GUID(CLSID_OfflineTrayAgent,
    0xE8BB6DC0,0x6B4E,0x11d0,0x92,0xDB,0x00,0xA0,0xC9,0x0C,0x2B,0xD7);
DEFINE_GUID(CLSID_ConnectionAgent,
    0xE6CC6978,0x6B6E,0x11D0,0xBE,0xCA,0x00,0xC0,0x4F,0xD9,0x40,0xBE);

