//+---------------------------------------------------------------------------
//
//  Microsoft Forms
//  Copyright (C) Microsoft Corporation, 1994-1996
//
//  File:       htmdesc.cxx
//
//  Contents:   Tag descriptors, for mapping tag strings to ETAGs,
//              describing parsing rules, etc.
//
//----------------------------------------------------------------------------

#include "headers.hxx"

#ifndef X_FORMKRNL_HXX_
#define X_FORMKRNL_HXX_
#include "formkrnl.hxx"
#endif

#ifndef X_HTM_HXX_
#define X_HTM_HXX_
#include "htm.hxx"
#endif

#ifndef X_COMMENT_HXX_
#define X_COMMENT_HXX_
#include "comment.hxx"
#endif

#ifndef X_TXTELEMS_HXX_
#define X_TXTELEMS_HXX_
#include "txtelems.hxx"
#endif

#ifndef X_IMGELEM_HXX_
#define X_IMGELEM_HXX_
#include "imgelem.hxx"
#endif

#ifndef X_DIV_HXX_
#define X_DIV_HXX_
#include "div.hxx"
#endif

#ifndef X_EBODY_HXX_
#define X_EBODY_HXX_
#include "ebody.hxx"
#endif

#ifndef X_TABLE_HXX_
#define X_TABLE_HXX_
#include "table.hxx"
#endif

#ifndef X_EPHRASE_HXX_
#define X_EPHRASE_HXX_
#include "ephrase.hxx"
#endif

#ifndef X_ELIST_HXX_
#define X_ELIST_HXX_
#include "elist.hxx"
#endif

#ifndef X_ELI_HXX_
#define X_ELI_HXX_
#include "eli.hxx"
#endif

#ifndef X_EDD_HXX_
#define X_EDD_HXX_
#include "edd.hxx"
#endif

#ifndef X_EDT_HXX_
#define X_EDT_HXX_
#include "edt.hxx"
#endif

#ifndef X_EULIST_HXX_
#define X_EULIST_HXX_
#include "eulist.hxx"
#endif

#ifndef X_EDLIST_HXX_
#define X_EDLIST_HXX_
#include "edlist.hxx"
#endif

#ifndef X_EOLIST_HXX_
#define X_EOLIST_HXX_
#include "eolist.hxx"
#endif

#ifndef X_EHEADER_HXX_
#define X_EHEADER_HXX_
#include "eheader.hxx"
#endif

#ifndef X_LAYOUT_HXX_
#define X_LAYOUT_HXX_
#include "layout.hxx"
#endif

#ifndef X_FLOWLYT_HXX_
#define X_FLOWLYT_HXX_
#include "flowlyt.hxx"
#endif

#ifndef X_HRLYT_HXX_
#define X_HRLYT_HXX_
#include "hrlyt.hxx"
#endif

#ifndef X_EHR_HXX_
#define X_EHR_HXX_
#include "ehr.hxx"
#endif

#ifndef X_EBR_HXX_
#define X_EBR_HXX_
#include "ebr.hxx"
#endif

#ifndef X_EBLOCK_HXX_
#define X_EBLOCK_HXX_
#include "eblock.hxx"
#endif

#ifndef X_EPARA_HXX_
#define X_EPARA_HXX_
#include "epara.hxx"
#endif

#ifndef X_BTNHLPER_HXX_
#define X_BTNHLPER_HXX_
#include "btnhlper.hxx"
#endif

#ifndef X_INPUTTXT_HXX_
#define X_INPUTTXT_HXX_
#include "inputtxt.hxx"
#endif

#ifndef X_TEXTAREA_HXX_
#define X_TEXTAREA_HXX_
#include "textarea.hxx"
#endif

#ifndef X_INPUTBTN_HXX_
#define X_INPUTBTN_HXX_
#include "inputbtn.hxx"
#endif

#ifndef X_MARQUEE_HXX_
#define X_MARQUEE_HXX_
#include "marquee.hxx"
#endif

#ifndef X_EFORM_HXX_
#define X_EFORM_HXX_
#include "eform.hxx"
#endif

#ifndef X_ESELECT_HXX_
#define X_ESELECT_HXX_
#include "eselect.hxx"
#endif

#ifndef X_EOPTION_HXX_
#define X_EOPTION_HXX_
#include "eoption.hxx"
#endif

#ifndef X_EOBJECT_HXX_
#define X_EOBJECT_HXX_
#include "eobject.hxx"
#endif

#ifndef X_PLUGINST_HXX_
#define X_PLUGINST_HXX_
#include "pluginst.hxx"
#endif

#ifndef X_FRAME_HXX_
#define X_FRAME_HXX_
#include "frame.hxx"
#endif

#ifndef X_INPUTTXT_HXX_
#define X_INPUTTXT_HXX_
#include "inputtxt.hxx"
#endif

#ifndef X_HYPLNK_HXX_
#define X_HYPLNK_HXX_
#include "hyplnk.hxx"
#endif

#ifndef X_EANCHOR_HXX_
#define X_EANCHOR_HXX_
#include "eanchor.hxx"
#endif

#ifndef X_ELABEL_HXX_
#define X_ELABEL_HXX_
#include "elabel.hxx"
#endif

#ifndef X_HEDELEMS_HXX_
#define X_HEDELEMS_HXX_
#include "hedelems.hxx"
#endif

#ifndef X_EFONT_HXX_
#define X_EFONT_HXX_
#include "efont.hxx"
#endif

#ifndef X_EAREA_HXX_
#define X_EAREA_HXX_
#include "earea.hxx"
#endif

#ifndef X_EMAP_HXX_
#define X_EMAP_HXX_
#include "emap.hxx"
#endif

#ifndef X_ESTYLE_HXX_
#define X_ESTYLE_HXX_
#include "estyle.hxx"
#endif

#ifndef X_FRAMESET_HXX_
#define X_FRAMESET_HXX_
#include "frameset.hxx"
#endif

#ifndef X_ESCRIPT_HXX_
#define X_ESCRIPT_HXX_
#include "escript.hxx"
#endif

#ifndef X_ENOSHOW_HXX_
#define X_ENOSHOW_HXX_
#include "enoshow.hxx"
#endif

#ifndef X_ELINK_HXX_
#define X_ELINK_HXX_
#include "elink.hxx"
#endif

#ifndef X_EBGSOUND_HXX_
#define X_EBGSOUND_HXX_
#include "ebgsound.hxx"
#endif

#ifndef X_E1D_HXX_
#define X_E1D_HXX_
#include "e1d.hxx"
#endif

#ifndef X_GENERIC_HXX_
#define X_GENERIC_HXX_
#include "generic.hxx"
#endif

#ifndef X_ASSOC_HXX_
#define X_ASSOC_HXX_
#include "assoc.hxx"
#endif

#ifndef X_TXTSLAVE_HXX_
#define X_TXTSLAVE_HXX_
#include "txtslave.hxx"
#endif

#define _cxx_
#include "tags.h"

HRESULT CreateHtmBodyParseCtx(CHtmParseCtx **pphpx, CElement *pel, CHtmParseCtx *phpxParent);
HRESULT CreateHtmCommentParseCtx(CHtmParseCtx **pphpx, CElement *pel, CHtmParseCtx *phpxParent);
HRESULT CreateHtmFramesetParseCtx(CHtmParseCtx **pphpx, CElement *pel, CHtmParseCtx *phpxParent);
HRESULT CreateHtmFrameParseCtx(CHtmParseCtx **pphpx, CElement *pel, CHtmParseCtx *phpxParent);
HRESULT CreateHtmGenericParseCtx(CHtmParseCtx **pphpx, CElement *pel, CHtmParseCtx *phpxParent);
HRESULT CreateHtmHeadParseCtx(CHtmParseCtx **pphpx, CElement *pel, CHtmParseCtx *phpxParent);
HRESULT CreateHtmIframeParseCtx(CHtmParseCtx **pphpx, CElement *pel, CHtmParseCtx *phpxParent);
HRESULT CreateHtmNoShowParseCtx(CHtmParseCtx **pphpx, CElement *pel, CHtmParseCtx *phpxParent);
HRESULT CreateHtmObjectParseCtx(CHtmParseCtx **pphpx, CElement *pel, CHtmParseCtx *phpxParent);
HRESULT CreateHtmPreParseCtx(CHtmParseCtx **pphpx, CElement *pel, CHtmParseCtx *phpxParent);
HRESULT CreateHtmScriptParseCtx(CHtmParseCtx **pphpx, CElement *pel, CHtmParseCtx *phpxParent);
HRESULT CreateHtmStyleParseCtx(CHtmParseCtx **pphpx, CElement *pel, CHtmParseCtx *phpxParent);
HRESULT CreateHtmTextareaParseCtx(CHtmParseCtx **pphpx, CElement *pel, CHtmParseCtx *phpxParent);
HRESULT CreateHtmTextParseCtx(CHtmParseCtx **pphpx, CElement *pel, CHtmParseCtx *phpxParent);
HRESULT CreateHtmTitleParseCtx(CHtmParseCtx **pphpx, CElement *pel, CHtmParseCtx *phpxParent);
HRESULT CreateHtmSelectParseCtx(CHtmParseCtx **pphpx, CElement *pel, CHtmParseCtx *phpxParent);

//+---------------------------------------------------------------------------
//
//  Parse classes
//
//  If not otherwise specified, parseclass fields default to the following
//  values (numerically zero):
//
//  CHtmlParseClass hpcDefault =
//  {
//      SCOPE_EMPTY,        // _scope
//      TEXTTYPE_NEVER,     // _texttype
//      NULL,               // _atagEndContainers   -- REQUIRED --
//      NULL,               // _atagBeginContainers -- REQUIRED --
//      NULL,               // _atagProhibitedContainers
//      NULL,               // _atagRequiredContainers
//      ETAG_NULL,          // _etagDefaultContainer
//      FALSE,              // _fQueueForRequired
//      TEXTSCOPE_NEUTRAL,  // _textscope
//      ETAG_NULL,          // _etagTextSubcontainer
//      NULL,               // _atagMatch
//      ETAG_NULL,          // _etagUnmatchedSubstitute
//      NULL,               // _pfnHpxCreator
//      FALSE,              // _fMerge
//      ETAG_NULL,          // _etagImplicitChild
//      FALSE,              // _fCloseImplicitChild
//  };
//
//  The meaning of the parse table entries:
//
//  _scope determines default implicit end-tag behavior. The values are:
//      SCOPE_EMPTY: an end tag is implied immediately after a begin tag
//      SCOPE_NESTED: an automatic end tag is implied when a parent or
//                    further ancestor that is also SCOPE_NESTED is closed
//      SCOPE_OVERLAP: no default end-tags are implied
//
//      implicit end-tags can also be generated in other situations
//
//  _texttype is ALWAYS if the begin tag should be treated like a piece
//      of text with respect to _textscope and _textsubcontainer of
//      ancestors (see _textscope and _textsubcontainer).
//
//  _atagEndContainers is a set of strict End Containers of this tag.
//      1. An end tag of this tag will only match the lowest open element
//         if it is not an ancestor of a currently open End Container element.
//      2. If an End Container ancestor closes, this kind of element is
//         automatically closed (an automatic end tag is implied).
//
//      For example, <TD> is an End Container for <B> because </B>
//      does not match a B element that is an ancestor of an open TD
//      and because if an open TD closes, any open child B elements
//      are automatically closed.
//
//  _atagBeginContainers is a set of Begin Containers of this tag.
//      When looking for required containers, prohibited containers, and
//      masking containers, the parser never searches above a Begin Container
//      element.
//
//----------------------------------------------------------------------------

//      SCOPE_EMPTY,        // _scope
//      TEXTTYPE_NEVER,     // _texttype
//      NULL,               // _atagEndContainers   -- REQUIRED --
//      NULL,               // _atagBeginContainers -- REQUIRED --
//      NULL,               // _atagMaskingContainers
//      NULL,               // _atagProhibitedContainers
//      NULL,               // _atagRequiredContainers
//      ETAG_NULL,          // _etagDefaultContainer
//      FALSE,              // _fQueueForRequired
//      TEXTSCOPE_NEUTRAL,  // _textscope
//      ETAG_NULL,          // _etagTextSubcontainer
//      NULL,               // _atagMatch
//      ETAG_NULL,          // _etagUnmatchedSubstitute
//      NULL,               // _pfnHpxCreator
//      FALSE,              // _fMerge
//      ETAG_NULL,          // _etagImplicitChild
//      FALSE,              // _fCloseImplicitChild
//  };


ELEMENT_TAG s_atagNull[] = {ETAG_NULL};
ELEMENT_TAG s_atagHtml[] = {ETAG_HTML, ETAG_NULL};
ELEMENT_TAG s_atagHead[] = {ETAG_HEAD, ETAG_NULL};
ELEMENT_TAG s_atagBody[] = {ETAG_BODY, ETAG_NULL};
ELEMENT_TAG s_atagBodyGeneric[] = {ETAG_BODY, ETAG_GENERIC, ETAG_NULL};
ELEMENT_TAG s_atagBodyHead[] = {ETAG_BODY, ETAG_HEAD, ETAG_NULL};
ELEMENT_TAG s_atagBodyHeadFrameSet[] = {ETAG_BODY, ETAG_HEAD, ETAG_FRAMESET, ETAG_NULL};
ELEMENT_TAG s_atagOverlapBoundary[] = {ETAG_BUTTON, ETAG_CAPTION, ETAG_HTML, ETAG_MARQUEE, /* ETAG_HTMLAREA, */ ETAG_TD, ETAG_TH, ETAG_NULL};
ELEMENT_TAG s_atagOverlapRequired[] = {ETAG_BODY, ETAG_BUTTON, ETAG_CAPTION, ETAG_GENERIC, ETAG_MARQUEE, /* ETAG_HTMLAREA, */ ETAG_TD, ETAG_TH, ETAG_NULL};
ELEMENT_TAG s_atagPBoundary[] = {ETAG_BLOCKQUOTE, ETAG_BODY, ETAG_BUTTON, ETAG_CAPTION, ETAG_DIR, ETAG_DL, ETAG_LISTING, ETAG_MARQUEE, ETAG_MENU, ETAG_OL, ETAG_PRE, /* ETAG_HTMLAREA, */ ETAG_TABLE, ETAG_TBODY, ETAG_TC, ETAG_TD, ETAG_TFOOT, ETAG_TH, ETAG_THEAD, ETAG_TR, ETAG_UL, ETAG_NULL};
ELEMENT_TAG s_atagPBoundaryGeneric[] = {ETAG_BLOCKQUOTE, ETAG_BODY, ETAG_BUTTON, ETAG_CAPTION, ETAG_DIR, ETAG_DL, ETAG_GENERIC, ETAG_LISTING, ETAG_MARQUEE, ETAG_MENU, ETAG_OL, ETAG_PRE, /* ETAG_HTMLAREA, */ ETAG_TABLE, ETAG_TBODY, ETAG_TC, ETAG_TD, ETAG_TFOOT, ETAG_TH, ETAG_THEAD, ETAG_TR, ETAG_UL, ETAG_NULL};
ELEMENT_TAG s_atagNestBoundary[] = {ETAG_BODY, ETAG_BUTTON, ETAG_CAPTION, ETAG_HEAD, ETAG_MARQUEE, /* ETAG_HTMLAREA, */ ETAG_TABLE, ETAG_TBODY, ETAG_TC, ETAG_TD, ETAG_TFOOT, ETAG_TH, ETAG_THEAD, ETAG_TR, ETAG_NULL};
ELEMENT_TAG s_atagLiteral[] = {ETAG_COMMENT, ETAG_SCRIPT, ETAG_STYLE, ETAG_TEXTAREA, ETAG_GENERIC_LITERAL, ETAG_TITLE_TAG, ETAG_NULL};
ELEMENT_TAG s_atagButton[] = {ETAG_BUTTON, ETAG_NULL};
ELEMENT_TAG s_atagBasefont[] = {ETAG_BASEFONT, ETAG_NULL};
ELEMENT_TAG s_atagA[] = {ETAG_A, ETAG_NULL};
ELEMENT_TAG s_atagNobr[] = {ETAG_NOBR, ETAG_NULL};
ELEMENT_TAG s_atagP[] = {ETAG_P, ETAG_NULL};
ELEMENT_TAG s_atagFieldset[] = {ETAG_FIELDSET, ETAG_NULL};
ELEMENT_TAG s_atagLiP[] = {ETAG_LI, ETAG_P, ETAG_NULL};
ELEMENT_TAG s_atagList[] = {ETAG_DL, ETAG_MENU, ETAG_OL, ETAG_UL, ETAG_NULL};
ELEMENT_TAG s_atagListCloses[] = {ETAG_DD, ETAG_DT, ETAG_LI, ETAG_P, ETAG_NULL};
ELEMENT_TAG s_atagDdDtP[] = {ETAG_DD, ETAG_DT, ETAG_P, ETAG_NULL};
ELEMENT_TAG s_atagSelect[] = {ETAG_SELECT, ETAG_NULL};
ELEMENT_TAG s_atagOption[] = {ETAG_OPTION, ETAG_NULL};
ELEMENT_TAG s_atagIframe[] = {ETAG_IFRAME, ETAG_NULL};
ELEMENT_TAG s_atagForm[] = {ETAG_FORM, ETAG_NULL};
ELEMENT_TAG s_atagNoShow[] = {ETAG_NOEMBED, ETAG_NOSCRIPT, ETAG_NOFRAMES, ETAG_NULL};
ELEMENT_TAG s_atagFormHead[] = {ETAG_FORM, ETAG_HEAD, ETAG_NULL};
ELEMENT_TAG s_atagTable[] = {ETAG_TABLE, ETAG_NULL};
ELEMENT_TAG s_atagTableTr[] = {ETAG_TABLE, ETAG_TR, ETAG_NULL};
ELEMENT_TAG s_atagTdCloses[] = {ETAG_TC, ETAG_TD, ETAG_TH, ETAG_CAPTION, ETAG_COLGROUP, ETAG_SELECT, ETAG_OPTION, ETAG_NULL};
ELEMENT_TAG s_atagTrCloses[] = {ETAG_TR, ETAG_CAPTION, ETAG_COLGROUP, ETAG_TC, ETAG_SELECT, ETAG_OPTION, ETAG_NULL};
ELEMENT_TAG s_atagColCloses[] = {ETAG_THEAD, ETAG_TBODY, ETAG_TFOOT, ETAG_CAPTION, ETAG_TC, ETAG_SELECT, ETAG_OPTION, ETAG_NULL};
ELEMENT_TAG s_atagTbodyCloses[] = {ETAG_THEAD, ETAG_TBODY, ETAG_TFOOT, ETAG_COLGROUP, ETAG_CAPTION, ETAG_TC, ETAG_SELECT, ETAG_OPTION, ETAG_NULL};
ELEMENT_TAG s_atagTableCloses[] = {ETAG_TABLE, ETAG_TC, ETAG_SELECT, ETAG_OPTION, ETAG_NULL};
ELEMENT_TAG s_atagEndTr[] = {ETAG_THEAD, ETAG_TBODY, ETAG_TFOOT, ETAG_TABLE, ETAG_TD, ETAG_TH, ETAG_CAPTION, ETAG_NULL}; // NS compat: Bug 21464
ELEMENT_TAG s_atagAppletObject[] = {ETAG_APPLET, ETAG_OBJECT, ETAG_NULL};
ELEMENT_TAG s_atagTr[] = {ETAG_TR, ETAG_NULL};
ELEMENT_TAG s_atagTbodyTfootThead[] = {ETAG_TBODY, ETAG_TFOOT, ETAG_THEAD, ETAG_NULL};
ELEMENT_TAG s_atagColgroupTable[] = {ETAG_COLGROUP, ETAG_TABLE, ETAG_NULL};
ELEMENT_TAG s_atagTableCellCaption[] = {ETAG_CAPTION, ETAG_TABLE, ETAG_TC, ETAG_TD, ETAG_TH, ETAG_NULL};
ELEMENT_TAG s_atagColgroup[] = {ETAG_COLGROUP, ETAG_NULL};
ELEMENT_TAG s_atagObjectApplet[] = {ETAG_OBJECT, ETAG_APPLET, ETAG_NULL};
ELEMENT_TAG s_atagFrameset[]  = {ETAG_FRAMESET, ETAG_NULL};
ELEMENT_TAG s_atagEOFProhibited[] = {ETAG_APPLET, ETAG_COMMENT, ETAG_OBJECT, ETAG_SCRIPT, ETAG_STYLE, ETAG_TITLE_ELEMENT, ETAG_GENERIC_LITERAL, ETAG_NOSCRIPT, ETAG_NOFRAMES, ETAG_NOEMBED, ETAG_IFRAME, ETAG_NULL };


//+------------------------------------------------------------------------
//
//  Function:   MergableTags
//
//  Synopsis:   Returns TRUE if tags can be merged with MergeTag
//
//-------------------------------------------------------------------------
ELEMENT_TAG s_atagTitles[] = {ETAG_TITLE_ELEMENT, ETAG_TITLE_TAG, ETAG_NULL};
ELEMENT_TAG *s_aatagMergable[] = {s_atagTitles, NULL};

BOOL
MergableTags(ELEMENT_TAG etag1, ELEMENT_TAG etag2)
{
    if (etag1 == etag2)
        return TRUE;
        
    ELEMENT_TAG **patag;

    for (patag = s_aatagMergable; *patag; patag += 1)
    {
        if (IsEtagInSet(etag1, *patag) && IsEtagInSet(etag2, *patag))
            return TRUE;
    }
    
    return FALSE;
}

// Special parsing class for unknown tags - address is tested for equality


// ETAG_UNKNOWN

CHtmlParseClass s_hpcUnknown =
{
    SCOPE_EMPTY,                    // _scope
    TEXTTYPE_NEVER,                 // _texttype
    s_atagNull,                     // _atagEndContainers
    s_atagNull,                     // _atagBeginContainers
    NULL,                           // _atagMaskingContainers
    NULL,                           // _atagProhibitedContainers
    NULL,                           // _atagRequiredContainers
    ETAG_NULL,                      // _etagDefaultContainer
    FALSE,                          // _fQueueForRequired
    TEXTSCOPE_NEUTRAL,              // _textscope
    ETAG_NULL,                      // _etagTextSubcontainer
    NULL,                           // _atagMatch
    ETAG_NULL,                      // _etagUnmatchedSubstitute
    NULL,                           // _pfnHpxCreator
    FALSE,                          // _fMerge
    ETAG_NULL,                      // _etagImplicitChild
    FALSE,                          // _fCloseImplicitChild
};

// ROOT

// The ROOT element is never created - it exists in every tree.
// It excludes text, and implies a BODY element if text is injected.

static CHtmlParseClass s_hpcRoot =
{
    SCOPE_NESTED,                   // _scope
    TEXTTYPE_NEVER,                 // _texttype
    s_atagNull,                     // _atagEndContainers
    s_atagNull,                     // _atagBeginContainers
    NULL,                           // _atagMaskingContainers
    NULL,                           // _atagProhibitedContainers
    NULL,                           // _atagRequiredContainers
    ETAG_NULL,                      // _etagDefaultContainer
    FALSE,                          // _fQueueForRequired
    TEXTSCOPE_EXCLUDE,              // _textscope
    ETAG_BODY,                      // _etagTextSubcontainer
    NULL,                           // _atagMatch
    ETAG_NULL,                      // _etagUnmatchedSubstitute
    NULL,                           // _pfnHpxCreator
    FALSE,                          // _fMerge
    ETAG_NULL,                      // _etagImplicitChild
    FALSE,                          // _fCloseImplicitChild
};

// HTML

// The HTML element can be explicitly or implicitly created (it is required by the HEAD and BODY).
// It immediately implies the HEAD subcontainer
// HTML excludes text (text implies a BODY)



static CHtmlParseClass s_hpcHtml =
{
    SCOPE_NESTED,                   // _scope
    TEXTTYPE_NEVER,                 // _texttype
    s_atagHtml,                     // _atagEndContainers
    s_atagHtml,                     // _atagBeginContainers
    s_atagHtml,                     // _atagMaskingContainers       ; HTML in another HTML is masked
    NULL,                           // _atagProhibitedContainers
    NULL,                           // _atagRequiredContainers
    ETAG_NULL,                      // _etagDefaultContainer
    FALSE,                          // _fQueueForRequired
    TEXTSCOPE_EXCLUDE,              // _textscope                   ; exclude text
    ETAG_BODY,                      // _etagTextSubcontainer        ; if text appears inside, it implies a BODY
    NULL,                           // _atagMatch
    ETAG_NULL,                      // _etagUnmatchedSubstitute
    NULL,                           // _pfnHpxCreator
    TRUE,                           // _fMerge                      ; IE5 bug 43801: merge HTML tags
    ETAG_HEAD,                      // _etagImplicitChild           ; HTML always has a HEAD child
    FALSE,                          // _fCloseImplicitChild         ; the child is left open
};

// HEAD

// The HEAD element will be implicitly created by the HTML element
// If HEAD tags are nested inside the HEAD section, they will be merged
// HEAD excludes text (text implies a BODY, which will close the HEAD)

static CHtmlParseClass s_hpcHead =
{
    SCOPE_NESTED,                   // _scope
    TEXTTYPE_NEVER,                 // _texttype
    s_atagHtml,                     // _atagEndContainers           ; HEAD is strictly contained by HTML
    s_atagHtml,                     // _atagBeginContainers         ; HEAD tag parse does not search above containing HTML
    s_atagBodyHead,                 // _atagMaskingContainers       ; HEAD tag in a BODY is masked
    NULL,                           // _atagProhibitedContainers
    s_atagHtml,                     // _atagRequiredContainers      ; HEAD tag requires an HTML tag
    ETAG_HTML,                      // _etagDefaultContainer        ; HEAD implies HTML if one isn't present
    FALSE,                          // _fQueueForRequired
    TEXTSCOPE_NEUTRAL,              // _textscope
    ETAG_NULL,                      // _etagTextSubcontainer
    NULL,                           // _atagMatch
    ETAG_NULL,                      // _etagUnmatchedSubstitute
    CreateHtmHeadParseCtx,          // _pfnHpxCreator
    TRUE,                           // _fMerge                      ; HEAD tag in a HEAD is merged
    ETAG_TITLE_ELEMENT,             // _etagImplicitChild           ; HEAD always has a TITLE child
    TRUE,                           // _fCloseImplicitChild         ; the child is implicitly closed
};

// BODY

static CHtmlParseClass s_hpcBody =
{
    SCOPE_NESTED,                   // _scope
    TEXTTYPE_NEVER,                 // _texttype
    s_atagHtml,                     // _atagEndContainers           ; BODY is strictly contained by HTML
    s_atagHtml,                     // _atagBeginContainers         ; BODY tag parse does not search above containing HTML
    s_atagBody,                     // _atagMaskingContainers
    s_atagHead,                     // _atagProhibitedContainers    ; closes any open HEAD
    s_atagHtml,                     // _atagRequiredContainers      ; BODY tag requires an HTML tag
    ETAG_HTML,                      // _etagDefaultContainer        ; BODY implies HTML if one isn't present
    FALSE,                          // _fQueueForRequired
    TEXTSCOPE_INCLUDE,              // _textscope                   ; BODY can contain text
    ETAG_NULL,                      // _etagTextSubcontainer
    NULL,                           // _atagMatch
    ETAG_NULL,                      // _etagUnmatchedSubstitute
    CreateHtmBodyParseCtx,          // _pfnHpxCreator
    TRUE,                           // _fMerge                      ; BODY tag in a BODY is merged
    ETAG_NULL,                      // _etagImplicitChild
    FALSE,                          // _fCloseImplicitChild
};

// BGSOUND, LINK, META, NEXTID, PARAM

static CHtmlParseClass s_hpcEmpty =
{
    SCOPE_EMPTY,                    // _scope
    TEXTTYPE_NEVER,                 // _texttype
    s_atagNull,                     // _atagEndContainers           ; end tags are irrelevant
    s_atagHtml,                     // _atagBeginContainers         ; when requiring BODY/HEAD, stop searching at HTML
    NULL,                           // _atagMaskingContainers
    NULL,                           // _atagProhibitedContainers
    s_atagBodyHead,                 // _atagRequiredContainers      ; must appear inside a BODY or HEAD
    ETAG_HEAD,                      // _etagDefaultContainer        ; if neither is present, imply a HEAD
    FALSE,                          // _fQueueForRequired
    TEXTSCOPE_NEUTRAL,              // _textscope
    ETAG_NULL,                      // _etagTextSubcontainer
    NULL,                           // _atagMatch
    ETAG_NULL,                      // _etagUnmatchedSubstitute
    NULL,                           // _pfnHpxCreator
    FALSE,                          // _fMerge
    ETAG_NULL,                      // _etagImplicitChild
    FALSE,                          // _fCloseImplicitChild
};


// AREA

// TODO: remove BASE

static CHtmlParseClass s_hpcArea =
{
    SCOPE_EMPTY,                    // _scope
    TEXTTYPE_QUERY,                 // _texttype                    ; area is text-like when pasting
    s_atagNull,                     // _atagEndContainers           ; end tags are irrelevant
    s_atagHtml,                     // _atagBeginContainers         ; when requiring BODY/HEAD, stop searching at HTML
    NULL,                           // _atagMaskingContainers
    NULL,                           // _atagProhibitedContainers
    s_atagBodyHead,                 // _atagRequiredContainers      ; must appear inside a BODY or HEAD
    ETAG_HEAD,                      // _etagDefaultContainer        ; if neither is present, imply a HEAD
    FALSE,                          // _fQueueForRequired
    TEXTSCOPE_NEUTRAL,              // _textscope
    ETAG_NULL,                      // _etagTextSubcontainer
    NULL,                           // _atagMatch
    ETAG_NULL,                      // _etagUnmatchedSubstitute
    NULL,                           // _pfnHpxCreator
    FALSE,                          // _fMerge
    ETAG_NULL,                      // _etagImplicitChild
    FALSE,                          // _fCloseImplicitChild
};


// BR, EMBED, IMG, INPUTTXT, ISINDEX, WBR

static CHtmlParseClass s_hpcEmptyText =
{
    SCOPE_EMPTY,                    // _scope
    TEXTTYPE_ALWAYS,                // _texttype                    ; these empty tags are textlike
    s_atagNull,                     // _atagEndContainers
    s_atagHtml,                     // _atagBeginContainers         ; when requiring BODY/HEAD, stop searching at HTML
    NULL,                           // _atagMaskingContainers
    NULL,                           // _atagProhibitedContainers
    s_atagBodyHead,                 // _atagRequiredContainers      ; must appear inside a BODY or HEAD (note that "textlike" will normally ensure BODY already)
    ETAG_BODY,                      // _etagDefaultContainer        ; if neither is present, imply a BODY
    FALSE,                          // _fQueueForRequired
    TEXTSCOPE_NEUTRAL,              // _textscope
    ETAG_NULL,                      // _etagTextSubcontainer
    NULL,                           // _atagMatch
    ETAG_NULL,                      // _etagUnmatchedSubstitute
    NULL,                           // _pfnHpxCreator
    FALSE,                          // _fMerge
    ETAG_NULL,                      // _etagImplicitChild
    FALSE,                          // _fCloseImplicitChild
};

// ACRONYM, B, BDO, BIG, BLINK, CITE, CODE, DEL, DFN, EM, FONT,
// I, INS, KBD, LABEL, Q, S, SAMP, SMALL, STRIKE, STRONG, SUB,
// SUP, TT, U, VAR

static CHtmlParseClass s_hpcOverlap =
{
    SCOPE_OVERLAP,                  // _scope
    TEXTTYPE_QUERY,                 // _texttype
    s_atagOverlapBoundary,          // _atagEndContainers           ; don't match end tags beyond TD-like boundaries
    s_atagOverlapBoundary,          // _atagBeginContainers
    NULL,                           // _atagMaskingContainers
    NULL,                           // _atagProhibitedContainers
    s_atagOverlapRequired,          // _atagRequiredContainers      ; must appear inside a BODY or TD-like container
    ETAG_BODY,                      // _etagDefaultContainer        ; if none is present, queue for a BODY
    TRUE,                           // _fQueueForRequired           ; queue
    TEXTSCOPE_NEUTRAL,              // _textscope
    ETAG_NULL,                      // _etagTextSubcontainer
    NULL,                           // _atagMatch
    ETAG_NULL,                      // _etagUnmatchedSubstitute
    NULL,                           // _pfnHpxCreator
    FALSE,                          // _fMerge
    ETAG_NULL,                      // _etagImplicitChild
    FALSE,                          // _fCloseImplicitChild
};


// MAP: map can overlap tags which can even overlap <TD>s etc

// MAP

static CHtmlParseClass s_hpcMap =
{
    SCOPE_OVERLAP,                  // _scope
    TEXTTYPE_QUERY,                 // _texttype                    ; map is text-like when pasting
    s_atagNull,                     // _atagEndContainers
    s_atagHtml,                     // _atagBeginContainers
    NULL,                           // _atagMaskingContainers
    NULL,                           // _atagProhibitedContainers
    s_atagBodyHead,                 // _atagRequiredContainers      ; must appear inside a BODY or HEAD
    ETAG_HEAD,                      // _etagDefaultContainer        ; if neither is present, imply a HEAD
    FALSE,                          // _fQueueForRequired
    TEXTSCOPE_NEUTRAL,              // _textscope
    ETAG_NULL,                      // _etagTextSubcontainer
    NULL,                           // _atagMatch
    ETAG_NULL,                      // _etagUnmatchedSubstitute
    NULL,                           // _pfnHpxCreator
    FALSE,                          // _fMerge
    ETAG_NULL,                      // _etagImplicitChild
    FALSE,                          // _fCloseImplicitChild
};


// overlapping tags which can even overlap <TD>s etc

// BASE, NOEMBED_OFF, NOFRAMES_OFF, NOSCRIPT_OFF

static CHtmlParseClass s_hpcUnderlap =
{
    SCOPE_OVERLAP,                  // _scope
    TEXTTYPE_NEVER,                 // _texttype
    s_atagNull,                     // _atagEndContainers
    s_atagHtml,                     // _atagBeginContainers
    NULL,                           // _atagMaskingContainers
    NULL,                           // _atagProhibitedContainers
    s_atagBodyHead,                 // _atagRequiredContainers      ; must appear inside a BODY or HEAD
    ETAG_HEAD,                      // _etagDefaultContainer        ; if neither is present, imply a HEAD
    FALSE,                          // _fQueueForRequired
    TEXTSCOPE_NEUTRAL,              // _textscope
    ETAG_NULL,                      // _etagTextSubcontainer
    NULL,                           // _atagMatch
    ETAG_NULL,                      // _etagUnmatchedSubstitute
    NULL,                           // _pfnHpxCreator
    FALSE,                          // _fMerge
    ETAG_NULL,                      // _etagImplicitChild
    FALSE,                          // _fCloseImplicitChild
};


// FORM:
// FORMs can overlap anything, but they mask themselves

static CHtmlParseClass s_hpcForm =
{
    SCOPE_OVERLAP,                  // _scope
    TEXTTYPE_QUERY,                 // _texttype                    ; forms are text-like when pasting
    s_atagNull,                     // _atagEndContainers
    s_atagHtml,                     // _atagBeginContainers
    s_atagForm,                     // _atagMaskingContainers
    NULL,                           // _atagProhibitedContainers
    s_atagBodyHead,                 // _atagRequiredContainers      ; must appear inside a BODY or HEAD
    ETAG_HEAD,                      // _etagDefaultContainer        ; if neither is present, imply a HEAD
    FALSE,                          // _fQueueForRequired
    TEXTSCOPE_NEUTRAL,              // _textscope
    ETAG_NULL,                      // _etagTextSubcontainer
    NULL,                           // _atagMatch
    ETAG_NULL,                      // _etagUnmatchedSubstitute
    NULL,                           // _pfnHpxCreator
    FALSE,                          // _fMerge
    ETAG_NULL,                      // _etagImplicitChild
    FALSE,                          // _fCloseImplicitChild
};

// GENERIC

static CHtmlParseClass s_hpcGeneric =
{
    SCOPE_OVERLAP,                  // _scope
    TEXTTYPE_QUERY,                 // _texttype                    ; text-like when pasting.  What a hack!  (anandra)
    s_atagNull,                     // _atagEndContainers
    s_atagHtml,                     // _atagBeginContainers
    NULL,                           // _atagMaskingContainers
    NULL,                           // _atagProhibitedContainers
    s_atagBodyHead,                 // _atagRequiredContainers      ; must appear inside a BODY or HEAD, or TD-like container
    ETAG_HEAD,                      // _etagDefaultContainer        ; if none is present, imply a HEAD
    FALSE,                          // _fQueueForRequired
    TEXTSCOPE_INCLUDE,              // _textscope
    ETAG_NULL,                      // _etagTextSubcontainer
    NULL,                           // _atagMatch
    ETAG_NULL,                      // _etagUnmatchedSubstitute
    NULL,                           // _pfnHpxCreator
    FALSE,                          // _fMerge
    ETAG_NULL,                      // _etagImplicitChild
    FALSE,                          // _fCloseImplicitChild
};


// GENERIC_LITERAL

static CHtmlParseClass s_hpcGenericLiteral =
{
    SCOPE_NESTED,                   // _scope
    TEXTTYPE_QUERY,                 // _texttype                    ; text-like when pasting
    s_atagNull,                     // _atagEndContainers           ; don't match end tags beyond TD-like boundaries
    s_atagHtml,                     // _atagBeginContainers
    NULL,                           // _atagMaskingContainers
    NULL,                           // _atagProhibitedContainers
    s_atagBodyHead,                 // _atagRequiredContainers      ; must appear inside a BODY or HEAD, or TD-like container
    ETAG_HEAD,                      // _etagDefaultContainer        ; if none is present, imply a HEAD
    FALSE,                          // _fQueueForRequired
    TEXTSCOPE_INCLUDE,              // _textscope
    ETAG_NULL,                      // _etagTextSubcontainer
    NULL,                           // _atagMatch
    ETAG_NULL,                      // _etagUnmatchedSubstitute
    CreateHtmGenericParseCtx,       // _pfnHpxCreator
    FALSE,                          // _fMerge
    ETAG_NULL,                      // _etagImplicitChild
    FALSE,                          // _fCloseImplicitChild
};


// DEFAULT:

static CHtmlParseClass s_hpcDefault =
{
    SCOPE_NESTED,                   // _scope
    TEXTTYPE_NEVER,                 // _texttype
    s_atagNull,                     // _atagEndContainers
    s_atagNull,                     // _atagBeginContainers
    NULL,                           // _atagMaskingContainers
    NULL,                           // _atagProhibitedContainers
    NULL,                           // _atagRequiredContainers
    ETAG_NULL,                      // _etagDefaultContainer
    FALSE,                          // _fQueueForRequired
    TEXTSCOPE_EXCLUDE,              // _textscope
    ETAG_BODY,                      // _etagTextSubcontainer
    NULL,                           // _atagMatch
    ETAG_NULL,                      // _etagUnmatchedSubstitute
    NULL,                           // _pfnHpxCreator
    FALSE,                          // _fMerge
    ETAG_NULL,                      // _etagImplicitChild
    FALSE,                          // _fCloseImplicitChild
};

// COMMENT:
// COMMENTs are literal, and specify a COMMENT context.

static CHtmlParseClass s_hpcComment =
{
    SCOPE_NESTED,                   // _scope
    TEXTTYPE_NEVER,                 // _texttype
    s_atagNull,                     // _atagEndContainers
    s_atagHtml,                     // _atagBeginContainers
    NULL,                           // _atagMaskingContainers
    NULL,                           // _atagProhibitedContainers
    s_atagBodyHead,                 // _atagRequiredContainers      ; must appear inside a BODY or HEAD
    ETAG_HEAD,                      // _etagDefaultContainer        ; if neither is present, imply a HEAD
    FALSE,                          // _fQueueForRequired
    TEXTSCOPE_INCLUDE,              // _textscope                   ; able to contain text
    ETAG_NULL,                      // _etagTextSubcontainer
    NULL,                           // _atagMatch
    ETAG_NULL,                      // _etagUnmatchedSubstitute
    CreateHtmCommentParseCtx,       // _pfnHpxCreator               ; create a CommentParseCtx
    FALSE,                          // _fMerge
    ETAG_NULL,                      // _etagImplicitChild
    FALSE,                          // _fCloseImplicitChild
};


// TITLE:
// TITLEs are literal, and specify a TITLE context.

// The first parse context is used to parse a title tag; note that the title tag is unique in that
// it is able to be parsed being entered in the tree; it is released as soon as it is finished
// being parsed

static CHtmlParseClass s_hpcTitleTag =
{
    SCOPE_NESTED,                   // _scope
    TEXTTYPE_NEVER,                 // _texttype
    s_atagNull,                     // _atagEndContainers
    s_atagHtml,                     // _atagBeginContainers
    NULL,                           // _atagMaskingContainers
    NULL,                           // _atagProhibitedContainers
    s_atagBodyHead,                 // _atagRequiredContainers      ; must appear inside a BODY or HEAD
    ETAG_HEAD,                      // _etagDefaultContainer        ; if neither is present, imply a HEAD
    FALSE,                          // _fQueueForRequired
    TEXTSCOPE_INCLUDE,              // _textscope                   ; able to contain text
    ETAG_NULL,                      // _etagTextSubcontainer
    NULL,                           // _atagMatch
    ETAG_NULL,                      // _etagUnmatchedSubstitute
    CreateHtmTitleParseCtx,         // _pfnHpxCreator               ; create a TitleParseCtx
    TRUE,                           // _fMerge
    ETAG_NULL,                      // _etagImplicitChild
    FALSE,                          // _fCloseImplicitChild
};

// The title element is automatically placed at the beginning of the <HEAD> by the parser
// Should have identical rules as TitleTag except that it doesn't have a context

static CHtmlParseClass s_hpcTitleElement =
{
    SCOPE_NESTED,                   // _scope
    TEXTTYPE_NEVER,                 // _texttype
    s_atagNull,                     // _atagEndContainers
    s_atagHtml,                     // _atagBeginContainers
    NULL,                           // _atagMaskingContainers
    NULL,                           // _atagProhibitedContainers
    s_atagBodyHead,                 // _atagRequiredContainers      ; must appear inside a BODY or HEAD
    ETAG_HEAD,                      // _etagDefaultContainer        ; if neither is present, imply a HEAD
    FALSE,                          // _fQueueForRequired
    TEXTSCOPE_INCLUDE,              // _textscope                   ; able to contain text
    ETAG_NULL,                      // _etagTextSubcontainer
    NULL,                           // _atagMatch
    ETAG_NULL,                      // _etagUnmatchedSubstitute
    NULL,                           // _pfnHpxCreator               ; create a TitleParseCtx
    TRUE,                           // _fMerge
    ETAG_NULL,                      // _etagImplicitChild
    FALSE,                          // _fCloseImplicitChild
};

// SCRIPT:
// SCRIPTs are literal, and specify a SCRIPT context.

static CHtmlParseClass s_hpcScript =
{
    SCOPE_NESTED,                   // _scope
    TEXTTYPE_NEVER,                 // _texttype
    s_atagNull,                     // _atagEndContainers
    s_atagHtml,                     // _atagBeginContainers
    NULL,                           // _atagMaskingContainers
    NULL,                           // _atagProhibitedContainers
    s_atagBodyHead,                 // _atagRequiredContainers      ; must appear inside a BODY or HEAD
    ETAG_HEAD,                      // _etagDefaultContainer        ; if neither is present, imply a HEAD
    FALSE,                          // _fQueueForRequired
    TEXTSCOPE_INCLUDE,              // _textscope                   ; able to contain text
    ETAG_NULL,                      // _etagTextSubcontainer
    NULL,                           // _atagMatch
    ETAG_NULL,                      // _etagUnmatchedSubstitute
    CreateHtmScriptParseCtx,        // _pfnHpxCreator               ; create a ScriptParseCtx
    FALSE,                          // _fMerge
    ETAG_NULL,                      // _etagImplicitChild
    FALSE,                          // _fCloseImplicitChild
};


// STYLE:
// STYLEs are literal, and specify a STYLE context

static CHtmlParseClass s_hpcStyle =
{
    SCOPE_NESTED,                   // _scope
    TEXTTYPE_NEVER,                 // _texttype
    s_atagNull,                     // _atagEndContainers
    s_atagHtml,                     // _atagBeginContainers
    NULL,                           // _atagMaskingContainers
    NULL,                           // _atagProhibitedContainers
    s_atagBodyHead,                 // _atagRequiredContainers      ; must appear inside a BODY or HEAD
    ETAG_HEAD,                      // _etagDefaultContainer        ; if neither is present, imply a HEAD
    FALSE,                          // _fQueueForRequired
    TEXTSCOPE_INCLUDE,              // _textscope                   ; able to contain text
    ETAG_NULL,                      // _etagTextSubcontainer
    NULL,                           // _atagMatch
    ETAG_NULL,                      // _etagUnmatchedSubstitute
    CreateHtmStyleParseCtx,         // _pfnHpxCreator               ; create a StyleParseCtx
    FALSE,                          // _fMerge
    ETAG_NULL,                      // _etagImplicitChild
    FALSE,                          // _fCloseImplicitChild
};


// TEXTAREA:
// TEXTAREAs are literal, and specify a TEXTAREA context

static CHtmlParseClass s_hpcTextarea =
{
    SCOPE_NESTED,                   // _scope
    TEXTTYPE_ALWAYS,                // _texttype                    ; textlike; force BODY etc
    s_atagNull,                     // _atagEndContainers
    s_atagHtml,                     // _atagBeginContainers
    s_atagButton,                   // _atagMaskingContainers       ; hidden by BUTTON container
    s_atagSelect,                   // _atagProhibitedContainers    ; close previously open SELECT
    s_atagBodyHead,                 // _atagRequiredContainers      ; must appear inside a BODY or HEAD
    ETAG_BODY,                      // _etagDefaultContainer        ; if neither is present, imply a BODY
    FALSE,                          // _fQueueForRequired
    TEXTSCOPE_INCLUDE,              // _textscope                   ; able to contain text
    ETAG_NULL,                      // _etagTextSubcontainer
    NULL,                           // _atagMatch
    ETAG_NULL,                      // _etagUnmatchedSubstitute
    CreateHtmPreParseCtx,           // _pfnHpxCreator               ; create a StyleParseCtx
    FALSE,                          // _fMerge
    ETAG_NULL,                      // _etagImplicitChild
    FALSE,                          // _fCloseImplicitChild
};

// NOEMBED, NOFRAMES, NOSCRIPT
// These tag define a context that turns all their contents into unknown tags

static CHtmlParseClass s_hpcNoShow =
{
    SCOPE_NESTED,                   // _scope
    TEXTTYPE_NEVER,                 // _texttype
    s_atagNull,                     // _atagEndContainers
    s_atagHtml,                     // _atagBeginContainers
    NULL,                           // _atagMaskingContainers
    s_atagNoShow,                   // _atagProhibitedContainers
    s_atagBodyHeadFrameSet,         // _atagRequiredContainers      ; must appear inside a BODY or HEAD or FRAMESET
    ETAG_HEAD,                      // _etagDefaultContainer        ; if neither is present, imply a HEAD
    FALSE,                          // _fQueueForRequired
    TEXTSCOPE_INCLUDE,              // _textscope                   ; able to contain text
    ETAG_NULL,                      // _etagTextSubcontainer
    NULL,                           // _atagMatch
    ETAG_NULL,                      // _etagUnmatchedSubstitute
    CreateHtmNoShowParseCtx,        // _pfnHpxCreator               ; create a NoshowParseCtx
    FALSE,                          // _fMerge
    ETAG_NULL,                      // _etagImplicitChild
    FALSE,                          // _fCloseImplicitChild
};

// IFRAME:
// IFRAMEs have their own context which hides contents

static CHtmlParseClass s_hpcIframe =
{
    SCOPE_NESTED,                   // _scope
    TEXTTYPE_ALWAYS,                // _texttype                    ; textlike; force BODY etc
    s_atagNull,                     // _atagEndContainers
    s_atagHtml,                     // _atagBeginContainers
    NULL,                           // _atagMaskingContainers
    s_atagIframe,                   // _atagProhibitedContainers    ; close a previously open IFRAME
    s_atagBody,                     // _atagRequiredContainers      ; must appear inside a BODY
    ETAG_BODY,                      // _etagDefaultContainer        ; if not present, imply a BODY
    FALSE,                          // _fQueueForRequired
    TEXTSCOPE_INCLUDE,              // _textscope                   ; able to contain text
    ETAG_NULL,                      // _etagTextSubcontainer
    NULL,                           // _atagMatch
    ETAG_NULL,                      // _etagUnmatchedSubstitute
    CreateHtmIframeParseCtx,        // _pfnHpxCreator               ; create an IframeParseCtx
    FALSE,                          // _fMerge
    ETAG_NULL,                      // _etagImplicitChild
    FALSE,                          // _fCloseImplicitChild
};


// BASEFONT

static CHtmlParseClass s_hpcBasefont =
{
    SCOPE_OVERLAP,                  // _scope
    TEXTTYPE_QUERY,                 // _texttype                    ; basefont is text-like when pasting
    s_atagOverlapBoundary,          // _atagEndContainers           ; close at TD-like boundaries
    s_atagHtml,                     // _atagBeginContainers
    NULL,                           // _atagMaskingContainers
    s_atagBasefont,                 // _atagProhibitedContainers    ; close any previously open BASEFONT
    s_atagBodyHead,                 // _atagRequiredContainers      ; must appear inside a BODY or HEAD
    ETAG_HEAD,                      // _etagDefaultContainer        ; if neither is present, imply a HEAD
    FALSE,                          // _fQueueForRequired
    TEXTSCOPE_NEUTRAL,              // _textscope
    ETAG_NULL,                      // _etagTextSubcontainer
    NULL,                           // _atagMatch
    ETAG_NULL,                      // _etagUnmatchedSubstitute
    NULL,                           // _pfnHpxCreator
    FALSE,                          // _fMerge
    ETAG_NULL,                      // _etagImplicitChild
    FALSE,                          // _fCloseImplicitChild
};


// HYPERLINKS:
// A tags end <A> tags

static CHtmlParseClass s_hpcAnchor =
{
    SCOPE_OVERLAP,                  // _scope
    TEXTTYPE_QUERY,                 // _texttype
    s_atagOverlapBoundary,          // _atagEndContainers           ; close at TD-like boundaries
    s_atagOverlapBoundary,          // _atagBeginContainers
    s_atagButton,                   // _atagMaskingContainers       ; hide when inside BUTTON
    s_atagA,                        // _atagProhibitedContainers    ; close any previously open A
    s_atagOverlapRequired,          // _atagRequiredContainers      ; must appear inside a BODY or HEAD
    ETAG_BODY,                      // _etagDefaultContainer        ; if neither is present, queue for a BODY
    TRUE,                           // _fQueueForRequired           ; queue
    TEXTSCOPE_NEUTRAL,              // _textscope
    ETAG_NULL,                      // _etagTextSubcontainer
    NULL,                           // _atagMatch
    ETAG_NULL,                      // _etagUnmatchedSubstitute
    NULL,                           // _pfnHpxCreator
    FALSE,                          // _fMerge
    ETAG_NULL,                      // _etagImplicitChild
    FALSE,                          // _fCloseImplicitChild
};


// NOBR:
// NOBR tags end <NOBR> tags

static CHtmlParseClass s_hpcNobr =
{
    SCOPE_OVERLAP,                  // _scope
    TEXTTYPE_NEVER,                 // _texttype
    s_atagOverlapBoundary,          // _atagEndContainers           ; close at TD-like boundaries
    s_atagHtml,                     // _atagBeginContainers
    NULL,                           // _atagMaskingContainers
    s_atagNobr,                     // _atagProhibitedContainers    ; close any previously open NOBR
    s_atagBodyGeneric,              // _atagRequiredContainers      ; must appear inside a BODY or GENERIC
    ETAG_BODY,                      // _etagDefaultContainer        ; if neither is present, imply a BODY
    TRUE,                           // _fQueueForRequired
    TEXTSCOPE_NEUTRAL,              // _textscope
    ETAG_NULL,                      // _etagTextSubcontainer
    NULL,                           // _atagMatch
    ETAG_NULL,                      // _etagUnmatchedSubstitute
    NULL,                           // _pfnHpxCreator
    FALSE,                          // _fMerge
    ETAG_NULL,                      // _etagImplicitChild
    FALSE,                          // _fCloseImplicitChild
};

// BR:
// end-BR tags become BR tags

static CHtmlParseClass s_hpcBr =
{
    SCOPE_EMPTY,                    // _scope
    TEXTTYPE_ALWAYS,                // _texttype                    ; textlike; force BODY etc
    s_atagNull,                     // _atagEndContainers
    s_atagHtml,                     // _atagBeginContainers         ; when requiring BODY/HEAD, stop searching at HTML
    NULL,                           // _atagMaskingContainers
    NULL,                           // _atagProhibitedContainers
    s_atagBodyHead,                 // _atagRequiredContainers      ; must appear inside a BODY or HEAD (note that "textlike" will normally ensure BODY already)
    ETAG_BODY,                      // _etagDefaultContainer        ; if neither is present, imply a BODY
    FALSE,                          // _fQueueForRequired
    TEXTSCOPE_NEUTRAL,              // _textscope
    ETAG_NULL,                      // _etagTextSubcontainer
    NULL,                           // _atagMatch
    ETAG_IMPLICIT_BEGIN,            // _etagUnmatchedSubstitute     ; </BR> becomes <BR>
    NULL,                           // _pfnHpxCreator
    FALSE,                          // _fMerge
    ETAG_NULL,                      // _etagImplicitChild
    FALSE,                          // _fCloseImplicitChild
};


// PARAGRAPHS:
// Paragraph tags (P, ADDRESS,...) end <P>s unless nested inside <UL>s etc
// An unmatched close tag implies a begin tag right before it


// ADDRESS, BLOCKQUOTE, DIR, FIELDSET, P, FIELDSET

static CHtmlParseClass s_hpcParagraph =
{
    SCOPE_NESTED,                   // _scope
    TEXTTYPE_QUERY,                 // _texttype                    ; textlike; force BODY etc (now forced by _atagRequired
    s_atagNestBoundary,             // _atagEndContainers           ; close at TABLE-like boundaries
    s_atagPBoundary,                // _atagBeginContainers
    NULL,                           // _atagMaskingContainers
    s_atagP,                        // _atagProhibitedContainers    ; close any previously open P
    s_atagPBoundaryGeneric,         // _atagRequiredContainers      ; must appear inside a BODY or P boundary container
    ETAG_BODY,                      // _etagDefaultContainer        ; if none is present, imply a BODY
    TRUE,                           // _fQueueForRequired           ; yes, queue when in HEAD
    TEXTSCOPE_NEUTRAL,              // _textscope
    ETAG_NULL,                      // _etagTextSubcontainer
    NULL,                           // _atagMatch
    ETAG_IMPLICIT_BEGIN,            // _etagUnmatchedSubstitute     ; if only the end tag appears, imply the begin tag
    NULL,                           // _pfnHpxCreator
    FALSE,                          // _fMerge
    ETAG_NULL,                      // _etagImplicitChild
    FALSE,                          // _fCloseImplicitChild
};

#if NEVER

// DL, MENU, OL, UL // replaced by hpcParagraph to be compat with IE4 and fix IE5 bug 39509

static CHtmlParseClass s_hpcList =
{
    SCOPE_NESTED,                   // _scope
    TEXTTYPE_ALWAYS,                // _texttype                    ; textlike; force BODY etc
    s_atagNestBoundary,             // _atagEndContainers           ; close at TABLE-like boundaries
    s_atagPBoundary,                // _atagBeginContainers
    NULL,                           // _atagMaskingContainers
    s_atagListCloses,               // _atagProhibitedContainers    ; close any previously open P
    s_atagPBoundaryGeneric,         // _atagRequiredContainers      ; must appear inside a BODY or P boundary container
    ETAG_BODY,                      // _etagDefaultContainer        ; if none is present, imply a BODY
    TRUE,                           // _fQueueForRequired           ; yes, queue when in HEAD
    TEXTSCOPE_NEUTRAL,              // _textscope
    ETAG_NULL,                      // _etagTextSubcontainer
    NULL,                           // _atagMatch
    ETAG_IMPLICIT_BEGIN,            // _etagUnmatchedSubstitute     ; if only the end tag appears, imply the begin tag
    NULL,                           // _pfnHpxCreator
    FALSE,                          // _fMerge
    ETAG_NULL,                      // _etagImplicitChild
    FALSE,                          // _fCloseImplicitChild
};

#endif

// LISTING, PLAINTEXT, PRE, XMP

static CHtmlParseClass s_hpcPre =
{
    SCOPE_NESTED,                   // _scope
    TEXTTYPE_ALWAYS,                // _texttype                    ; textlike; force BODY etc
    s_atagNestBoundary,             // _atagEndContainers           ; close at TABLE-like boundaries
    s_atagPBoundary,                // _atagBeginContainers
    NULL,                           // _atagMaskingContainers
    s_atagP,                        // _atagProhibitedContainers    ; close any previously open P
    s_atagPBoundary,                // _atagRequiredContainers      ; must appear inside a BODY or P boundary container
    ETAG_BODY,                      // _etagDefaultContainer        ; if none is present, imply a BODY
    FALSE,                          // _fQueueForRequired
    TEXTSCOPE_NEUTRAL,              // _textscope
    ETAG_NULL,                      // _etagTextSubcontainer
    NULL,                           // _atagMatch
    ETAG_IMPLICIT_BEGIN,            // _etagUnmatchedSubstitute     ; if only the end tag appears, imply the begin tag
    CreateHtmPreParseCtx,           // _pfnHpxCreator
    FALSE,                          // _fMerge
    ETAG_NULL,                      // _etagImplicitChild
    FALSE,                          // _fCloseImplicitChild
};

// LEGEND

static CHtmlParseClass s_hpcLegend =
{
    SCOPE_NESTED,                   // _scope
    TEXTTYPE_ALWAYS,                // _texttype                    ; textlike; force BODY etc
    s_atagNestBoundary,             // _atagEndContainers           ; close at TABLE-like boundaries
    s_atagHtml,                     // _atagBeginContainers
    NULL,                           // _atagMaskingContainers
    NULL,                           // _atagProhibitedContainers
    s_atagFieldset,                 // _atagRequiredContainers      ; must appear inside a FIELDSET
    ETAG_NULL,                      // _etagDefaultContainer        ; if neither is present, unknownify
    FALSE,                          // _fQueueForRequired
    TEXTSCOPE_NEUTRAL,              // _textscope
    ETAG_NULL,                      // _etagTextSubcontainer
    NULL,                           // _atagMatch
    ETAG_NULL,                      // _etagUnmatchedSubstitute
    NULL,                           // _pfnHpxCreator
    FALSE,                          // _fMerge
    ETAG_NULL,                      // _etagImplicitChild
    FALSE,                          // _fCloseImplicitChild
};


// CENTER tag:
// Closes paragraphs (see IE4 bug 29566) been requested that it shouldn't (IE5 bug 1379) but we haven't changed the behavior
// if we have an unmatched end CENTER, add an implicit begin CENTER
static CHtmlParseClass s_hpcCenter =
{
    SCOPE_OVERLAP,                  // _scope
    TEXTTYPE_NEVER,                 // _texttype
    s_atagOverlapBoundary,          // _atagEndContainers           ; close at TD-like boundaries
    s_atagPBoundary,                // _atagBeginContainers         ; prohibited+required container is P-like
    NULL,                           // _atagMaskingContainers
    s_atagP,                        // _atagProhibitedContainers    ; closes P
    s_atagPBoundaryGeneric,         // _atagRequiredContainers      ; match _atagBeginContainers
    ETAG_BODY,                      // _etagDefaultContainer        ; if none is present, queue for BODY
    TRUE,                           // _fQueueForRequired           ; yes, queue
    TEXTSCOPE_NEUTRAL,              // _textscope
    ETAG_NULL,                      // _etagTextSubcontainer
    NULL,                           // _atagMatch
    ETAG_IMPLICIT_BEGIN,            // _etagUnmatchedSubstitute     ; if only the end tag appears, imply the begin tag
    NULL,                           // _pfnHpxCreator
    FALSE,                          // _fMerge
    ETAG_NULL,                      // _etagImplicitChild
    FALSE,                          // _fCloseImplicitChild
};

// Hx:
// Header tags are similar to paragraph tags, but they have overlapping scope.

// H1, H2, H3, H4, H5, H6

ELEMENT_TAG s_atagHeaders[] = {ETAG_H1, ETAG_H2, ETAG_H3, ETAG_H4, ETAG_H5, ETAG_H6, ETAG_NULL};

static CHtmlParseClass s_hpcHeader =
{
    SCOPE_OVERLAP,                  // _scope
    TEXTTYPE_NEVER,                 // _texttype
    s_atagOverlapBoundary,          // _atagEndContainers           ; close at TD-like boundaries
    s_atagPBoundary,                // _atagBeginContainers
    NULL,                           // _atagMaskingContainers
    s_atagP,                        // _atagProhibitedContainers    ; close any previously open P
    s_atagPBoundaryGeneric,         // _atagRequiredContainers      ; must appear inside a BODY or P boundary container
    ETAG_BODY,                      // _etagDefaultContainer        ; if none is present, queue for a BODY
    TRUE,                           // _fQueueForRequired           ; yes, queue
    TEXTSCOPE_NEUTRAL,              // _textscope
    ETAG_NULL,                      // _etagTextSubcontainer
    s_atagHeaders,                  // _atagMatch                   ; any </Hx> can match any other <Hy>
    ETAG_IMPLICIT_BEGIN,            // _etagUnmatchedSubstitute     ; if only the end tag appears, imply the begin tag
    NULL,                           // _pfnHpxCreator
    FALSE,                          // _fMerge
    ETAG_NULL,                      // _etagImplicitChild
    FALSE,                          // _fCloseImplicitChild
};

// HR:
// HRs close the preceding paragraph.

static CHtmlParseClass s_hpcHr =
{
    SCOPE_EMPTY,                    // _scope
    TEXTTYPE_ALWAYS,                // _texttype                    ; textlike; force BODY etc
    s_atagNull,                     // _atagEndContainers           ; end tags are irrelevant
    s_atagPBoundary,                // _atagBeginContainers         ; when closing Ps stop searching at TABLE-like boundaries
    NULL,                           // _atagMaskingContainers
    s_atagP,                        // _atagProhibitedContainers    ; closes P
    s_atagPBoundary,                // _atagRequiredContainers      ; must appear inside a BODY or TABLE-like container
    ETAG_BODY,                      // _etagDefaultContainer        ; if none is present, imply a BODY
    FALSE,                          // _fQueueForRequired
    TEXTSCOPE_NEUTRAL,              // _textscope
    ETAG_NULL,                      // _etagTextSubcontainer
    NULL,                           // _atagMatch
    ETAG_NULL,                      // _etagUnmatchedSubstitute
    NULL,                           // _pfnHpxCreator
    FALSE,                          // _fMerge
    ETAG_NULL,                      // _etagImplicitChild
    FALSE,                          // _fCloseImplicitChild
};



// LISTS:
// LIs close LIs; DDs and DTs close DDs and DTs

// LI

static CHtmlParseClass s_hpcLI =
{
    SCOPE_NESTED,                   // _scope
    TEXTTYPE_ALWAYS,                // _texttype                    ; textlike; force BODY etc
    s_atagNestBoundary,             // _atagEndContainers           ; close at TABLE-like boundaries
    s_atagPBoundary,                // _atagBeginContainers
    NULL,                           // _atagMaskingContainers
    s_atagLiP,                      // _atagProhibitedContainers    ; close any previously open LI or P
    s_atagPBoundary,                // _atagRequiredContainers      ; must appear inside a BODY or P-boundary container
    ETAG_BODY,                      // _etagDefaultContainer        ; if none is present, imply a BODY
    FALSE,                          // _fQueueForRequired
    TEXTSCOPE_NEUTRAL,              // _textscope
    ETAG_NULL,                      // _etagTextSubcontainer
    NULL,                           // _atagMatch
    ETAG_NULL,                      // _etagUnmatchedSubstitute
    NULL,                           // _pfnHpxCreator
    FALSE,                          // _fMerge
    ETAG_NULL,                      // _etagImplicitChild
    FALSE,                          // _fCloseImplicitChild
};


// DD, DT

static CHtmlParseClass s_hpcDDDT =
{
    SCOPE_NESTED,                   // _scope
    TEXTTYPE_ALWAYS,                // _texttype                    ; textlike; force BODY etc
    s_atagNestBoundary,             // _atagEndContainers           ; close at TABLE-like boundaries
    s_atagPBoundary,                // _atagBeginContainers
    NULL,                           // _atagMaskingContainers
    s_atagDdDtP,                    // _atagProhibitedContainers    ; close any previously open DD, DT, or P
    s_atagPBoundary,                // _atagRequiredContainers      ; must appear inside a BODY or P-boundary container
    ETAG_BODY,                      // _etagDefaultContainer        ; if none is present, imply a BODY
    FALSE,                          // _fQueueForRequired
    TEXTSCOPE_NEUTRAL,              // _textscope
    ETAG_NULL,                      // _etagTextSubcontainer
    NULL,                           // _atagMatch
    ETAG_NULL,                      // _etagUnmatchedSubstitute
    NULL,                           // _pfnHpxCreator
    FALSE,                          // _fMerge
    ETAG_NULL,                      // _etagImplicitChild
    FALSE,                          // _fCloseImplicitChild
};

// SELECT:
// SELECTs specify a SELECT context

static CHtmlParseClass s_hpcSelect =
{
    SCOPE_NESTED,                   // _scope
    TEXTTYPE_ALWAYS,                // _texttype                    ; textlike; force BODY etc
    s_atagNull,                     // _atagEndContainers           ; irrelevant
    s_atagHtml,                     // _atagBeginContainers
    s_atagButton,                   // _atagMaskingContainers
    s_atagSelect,                   // _atagProhibitedContainers    ; close any previously open SELECT
    s_atagBody,                     // _atagRequiredContainers      ; must appear inside a BODY
    ETAG_BODY,                      // _etagDefaultContainer        ; if none is present, imply a BODY
    FALSE,                          // _fQueueForRequired
    TEXTSCOPE_INCLUDE,              // _textscope
    ETAG_NULL,                      // _etagTextSubcontainer
    NULL,                           // _atagMatch
    ETAG_NULL,                      // _etagUnmatchedSubstitute
    CreateHtmSelectParseCtx,        // _pfnHpxCreator
    FALSE,                          // _fMerge
    ETAG_NULL,                      // _etagImplicitChild
    FALSE,                          // _fCloseImplicitChild
};


// OPTION:
// OPTIONs accept text, and should only appear inside a SELECT

static CHtmlParseClass s_hpcOption =
{
    SCOPE_NESTED,                   // _scope
    TEXTTYPE_NEVER,                 // _texttype
    s_atagSelect,                   // _atagEndContainers           ; if a SELECT container ends, the OPTION ends
    s_atagSelect,                   // _atagBeginContainers
    NULL,                           // _atagMaskingContainers
    s_atagOption,                   // _atagProhibitedContainers    ; close any previously open SELECT
    s_atagSelect,                   // _atagRequiredContainers      ; must appear inside a SELECT
    ETAG_NULL,                      // _etagDefaultContainer        ; if none is present, unknownify
    FALSE,                          // _fQueueForRequired
    TEXTSCOPE_INCLUDE,              // _textscope
    ETAG_NULL,                      // _etagTextSubcontainer
    NULL,                           // _atagMatch
    ETAG_NULL,                      // _etagUnmatchedSubstitute
    NULL,                           // _pfnHpxCreator
    FALSE,                          // _fMerge
    ETAG_NULL,                      // _etagImplicitChild
    FALSE,                          // _fCloseImplicitChild
};

// OBJECT/APPLET:
// OBJECTs and APPLETs have their own context which accepts params

static CHtmlParseClass s_hpcObjectApplet =
{
    SCOPE_NESTED,                   // _scope
    TEXTTYPE_QUERY,                 // _texttype                    ; textlike unless in HEAD in cases; see CHtmHeadParseCtx
    s_atagHtml,                     // _atagEndContainers
    s_atagHtml,                     // _atagBeginContainers
    NULL,                           // _atagMaskingContainers
    s_atagAppletObject,             // _atagProhibitedContainers    ; close any previously open APPLET or OBJECT
    s_atagBodyHead,                 // _atagRequiredContainers      ; must appear inside a BODY or HEAD (note textlike will usually imply BODY)
    ETAG_HEAD,                      // _etagDefaultContainer        ; if none is present, imply HEAD
    FALSE,                          // _fQueueForRequired
    TEXTSCOPE_INCLUDE,              // _textscope
    ETAG_NULL,                      // _etagTextSubcontainer
    NULL,                           // _atagMatch
    ETAG_NULL,                      // _etagUnmatchedSubstitute
    CreateHtmObjectParseCtx,        // _pfnHpxCreator
    FALSE,                          // _fMerge
    ETAG_NULL,                      // _etagImplicitChild
    FALSE,                          // _fCloseImplicitChild
};

// HTMLAREA:
// HTMLAREA have their own context for storing text

#ifdef  NEVER
static CHtmlParseClass s_hpcRichtext =
{
    SCOPE_NESTED,                   // _scope
    TEXTTYPE_ALWAYS,                // _texttype                    ; textlike; force BODY etc
    s_atagNull,                     // _atagEndContainers
    s_atagHtml,                     // _atagBeginContainers
    s_atagButton,                   // _atagMaskingContainers       ; hidden by BUTTON container
    s_atagSelect,                   // _atagProhibitedContainers    ; close previously open SELECT
    s_atagBodyHead,                 // _atagRequiredContainers      ; must appear inside a BODY or HEAD
    ETAG_BODY,                      // _etagDefaultContainer        ; if neither is present, imply a BODY
    FALSE,                          // _fQueueForRequired
    TEXTSCOPE_INCLUDE,              // _textscope                   ; able to contain text
    ETAG_NULL,                      // _etagTextSubcontainer
    NULL,                           // _atagMatch
    ETAG_NULL,                      // _etagUnmatchedSubstitute
    NULL,                           // _pfnHpxCreator
    FALSE,                          // _fMerge
    ETAG_NULL,                      // _etagImplicitChild
    FALSE,                          // _fCloseImplicitChild
};
#endif


// MARQUEE:

static CHtmlParseClass s_hpcMarquee =
{
    SCOPE_NESTED,                   // _scope
    TEXTTYPE_ALWAYS,                // _texttype                    ; textlike; force BODY etc
    s_atagHtml,                     // _atagEndContainers
    s_atagHtml,                     // _atagBeginContainers
    NULL,                           // _atagMaskingContainers
    NULL,                           // _atagProhibitedContainers
    s_atagBody,                     // _atagRequiredContainers      ; must appear inside a BODY
    ETAG_BODY,                      // _etagDefaultContainer        ; if none is present, imply BODY
    FALSE,                          // _fQueueForRequired
    TEXTSCOPE_INCLUDE,              // _textscope
    ETAG_NULL,                      // _etagTextSubcontainer
    NULL,                           // _atagMatch
    ETAG_NULL,                      // _etagUnmatchedSubstitute
    NULL,                           // _pfnHpxCreator
    FALSE,                          // _fMerge
    ETAG_NULL,                      // _etagImplicitChild
    FALSE,                          // _fCloseImplicitChild
};

// TABLES:
// Tables contain sections, which contain rows, which contain cells.
// <TR>s and <TBODY>s are implied where needed, but <TABLE>s are not implied.
// Cells, rows, and sections are implicitly closed by their peers
// <COLGROUP> is similar to a section, but is implicitly closed by cells and rows

ELEMENT_TAG s_atagTableEndRootContainers[] = {ETAG_TABLE, ETAG_NULL};
ELEMENT_TAG s_atagTableBeginRootContainers[] = {ETAG_BODY, ETAG_TC, ETAG_TD, ETAG_TH, ETAG_CAPTION, ETAG_TABLE, ETAG_NULL};
ELEMENT_TAG s_atagTableProhibitedContainers[] = {ETAG_TABLE, ETAG_TC, ETAG_SELECT, ETAG_OPTION, ETAG_NULL};

ELEMENT_TAG s_atagTCellRootContainers[] = {ETAG_TR, ETAG_TABLE, ETAG_NULL};
ELEMENT_TAG s_atagTCellProhibitedContainers[] = {ETAG_TC, ETAG_TD, ETAG_TH, ETAG_CAPTION, ETAG_COLGROUP, ETAG_SELECT, ETAG_OPTION, ETAG_NULL};
ELEMENT_TAG s_atagTCellRequiredContainers[] = {ETAG_TR, ETAG_NULL};

ELEMENT_TAG s_atagTRowBeginContainers[] = {ETAG_THEAD, ETAG_TBODY, ETAG_TFOOT, ETAG_TABLE, ETAG_NULL};
ELEMENT_TAG s_atagTRowEndContainers[] = {ETAG_THEAD, ETAG_TBODY, ETAG_TFOOT, ETAG_TABLE, ETAG_TD, ETAG_TH, ETAG_CAPTION, ETAG_NULL}; // NS compat: Bug 21464
ELEMENT_TAG s_atagTRowProhibitedContainers[] = {ETAG_TR, ETAG_CAPTION, ETAG_COLGROUP, ETAG_TC, ETAG_SELECT, ETAG_OPTION, ETAG_NULL};
ELEMENT_TAG s_atagTRowRequiredContainers[] = {ETAG_THEAD, ETAG_TBODY, ETAG_TFOOT, ETAG_NULL};

ELEMENT_TAG s_atagTSectionBeginContainers[] = {ETAG_TABLE, ETAG_NULL};
ELEMENT_TAG s_atagTSectionEndContainers[] = {ETAG_TABLE, /* ETAG_TD, ETAG_TH, ETAG_CAPTION,*/ ETAG_NULL}; // see bugs 22924, 21464
ELEMENT_TAG s_atagTSectionProhibitedContainers[] = {ETAG_THEAD, ETAG_TBODY, ETAG_TFOOT, ETAG_COLGROUP, ETAG_CAPTION, ETAG_TC, ETAG_SELECT, ETAG_OPTION, ETAG_NULL};
ELEMENT_TAG s_atagTSectionRequiredContainers[] = {ETAG_TABLE, ETAG_NULL};

ELEMENT_TAG s_atagTColRootContainers[] = {ETAG_COLGROUP, ETAG_TABLE, ETAG_NULL};
ELEMENT_TAG s_atagTColProhibitedContainers[] = {ETAG_THEAD, ETAG_TBODY, ETAG_TFOOT, ETAG_CAPTION, ETAG_TC, ETAG_SELECT, ETAG_OPTION, ETAG_NULL};
ELEMENT_TAG s_atagTColRequiredContainers[] = {ETAG_COLGROUP, ETAG_NULL};

ELEMENT_TAG s_atagTCRootContainers[] = {ETAG_TABLE, ETAG_NULL};
ELEMENT_TAG s_atagTCProhibitedContainers[] = {ETAG_TC, ETAG_TD, ETAG_TH, ETAG_CAPTION, ETAG_COLGROUP, ETAG_SELECT, ETAG_OPTION, ETAG_NULL};
ELEMENT_TAG s_atagTCRequiredContainers[] = {ETAG_TABLE, ETAG_NULL};

// TD, TH

static CHtmlParseClass s_hpcTCell =
{
    SCOPE_NESTED,                   // _scope
    TEXTTYPE_NEVER,                 // _texttype
    s_atagTableTr,                  // _atagEndContainers           ; end when container TR ends; nested TABLE hides end TDs
    s_atagTable,                    // _atagBeginContainers         ; don't search beyond container TABLE
    NULL,                           // _atagMaskingContainers
    s_atagTdCloses,                 // _atagProhibitedContainers
    s_atagTr,                       // _atagRequiredContainers      ; must appear inside a TR
    ETAG_TR,                        // _etagDefaultContainer        ; if none is present, imply TR
    FALSE,                          // _fQueueForRequired
    TEXTSCOPE_INCLUDE,              // _textscope
    ETAG_NULL,                      // _etagTextSubcontainer
    NULL,                           // _atagMatch
    ETAG_NULL,                      // _etagUnmatchedSubstitute
    CreateHtmTextParseCtx,          // _pfnHpxCreator
    FALSE,                          // _fMerge
    ETAG_NULL,                      // _etagImplicitChild
    FALSE,                          // _fCloseImplicitChild
};

// TC

// table compatibility cell - used to wrap text when it appears inside a disallowed table context

static CHtmlParseClass s_hpcTC =
{
    SCOPE_NESTED,                   // _scope
    TEXTTYPE_NEVER,                 // _texttype
    s_atagTable,                    // _atagEndContainers           ; nested TABLE hides end TCs
    s_atagTable,                    // _atagBeginContainers         ; don't search beyond container TABLE
    NULL,                           // _atagMaskingContainers
    s_atagTdCloses,                 // _atagProhibitedContainers    ; same as TD
    s_atagTable,                    // _atagRequiredContainers      ; must appear inside a table
    ETAG_NULL,                      // _etagDefaultContainer
    FALSE,                          // _fQueueForRequired
    TEXTSCOPE_INCLUDE,              // _textscope
    ETAG_NULL,                      // _etagTextSubcontainer
    NULL,                           // _atagMatch
    ETAG_NULL,                      // _etagUnmatchedSubstitute
    NULL,                           // _pfnHpxCreator
    FALSE,                          // _fMerge
    ETAG_NULL,                      // _etagImplicitChild
    FALSE,                          // _fCloseImplicitChild
};


// TR


static CHtmlParseClass s_hpcTRow =
{
    SCOPE_NESTED,                   // _scope
    TEXTTYPE_NEVER,                 // _texttype
    s_atagEndTr,                    // _atagEndContainers           ; * Nested TABLE, TD hides /TR; end when container TBODY ends
    s_atagTable,                    // _atagBeginContainers         ; don't search beyond container TABLE
    NULL,                           // _atagMaskingContainers
    s_atagTrCloses,                 // _atagProhibitedContainers
    s_atagTbodyTfootThead,          // _atagRequiredContainers      ; must appear inside a TBODY, TFOOt, THEAD
    ETAG_TBODY,                     // _etagDefaultContainer        ; if none is present, imply TBODY
    FALSE,                          // _fQueueForRequired
    TEXTSCOPE_EXCLUDE,              // _textscope                   ; don't accept text directly
    ETAG_TC,                        // _etagTextSubcontainer        ; if text appears, wrap it in a TC
    NULL,                           // _atagMatch
    ETAG_TD,                        // _etagUnmatchedSubstitute     ; NS compat bug 22985/56944: /TR ends TD but does not end table row
    NULL,                           // _pfnHpxCreator
    FALSE,                          // _fMerge
    ETAG_NULL,                      // _etagImplicitChild
    FALSE,                          // _fCloseImplicitChild
};

// * Note that NS compat: Bug 21464 forces us to include TD and TH in the list of containers that end TR.
// This is because in the sequence <TABLE><TR><TD></TR>, the </TR> does not match the <TR>, because it
// is apparently hidden by the <TD>.



// COL

static CHtmlParseClass s_hpcTCol =
{
    SCOPE_EMPTY,                    // _scope
    TEXTTYPE_NEVER,                 // _texttype
    s_atagNull,                     // _atagEndContainers           ; irrelevant
    s_atagColgroupTable,            // _atagBeginContainers         ; don't search beyond container COLGROUP, TABLE
    NULL,                           // _atagMaskingContainers
    s_atagColCloses,                // _atagProhibitedContainers
    s_atagColgroup,                 // _atagRequiredContainers      ; must appear inside a COLGROUP
    ETAG_COLGROUP,                  // _etagDefaultContainer        ; if none is present, imply COLGROUP
    FALSE,                          // _fQueueForRequired
    TEXTSCOPE_NEUTRAL,              // _textscope
    ETAG_NULL,                      // _etagTextSubcontainer
    NULL,                           // _atagMatch
    ETAG_NULL,                      // _etagUnmatchedSubstitute
    NULL,                           // _pfnHpxCreator
    FALSE,                          // _fMerge
    ETAG_NULL,                      // _etagImplicitChild
    FALSE,                          // _fCloseImplicitChild
};

// COLGROUP, TBODY, TFOOT, THEAD

static CHtmlParseClass s_hpcTSection =
{
    SCOPE_NESTED,                   // _scope
    TEXTTYPE_NEVER,                 // _texttype
    s_atagTable,                    // _atagEndContainers           ; see bugs 22924, 21464
    s_atagTable,                    // _atagEndcontainers
    NULL,                           // _atagMaskingContainers
    s_atagTbodyCloses,              // _atagProhibitedContainers
    s_atagTable,                    // _atagRequiredContainers      ; requires a TABLE
    ETAG_NULL,                      // _etagDefaultContainer        ; none present, unknownify
    FALSE,                          // _fQueueForRequired
    TEXTSCOPE_EXCLUDE,              // _textscope
    ETAG_TC,                        // _etagTextSubcontainer        ; wrap disallowed text inside a TC
    NULL,                           // _atagMatch
    ETAG_NULL,                      // _etagUnmatchedSubstitute
    NULL,                           // _pfnHpxCreator
    FALSE,                          // _fMerge
    ETAG_NULL,                      // _etagImplicitChild
    FALSE,                          // _fCloseImplicitChild
};

// CAPTION

// same as TBODY, but can contain text

static CHtmlParseClass s_hpcCaption =
{
    SCOPE_NESTED,                   // _scope
    TEXTTYPE_NEVER,                 // _texttype
    s_atagTable,                    // _atagEndContainers
    s_atagTable,                    // _atagBeginContainers
    NULL,                           // _atagMaskingContainers
    s_atagTbodyCloses,              // _atagProhibitedContainers
    s_atagTable,                    // _atagRequiredContainers      ; requires a TABLE
    ETAG_NULL,                      // _etagDefaultContainer        ; none present, unknownify
    FALSE,                          // _fQueueForRequired
    TEXTSCOPE_INCLUDE,              // _textscope
    ETAG_NULL,                      // _etagTextSubcontainer
    NULL,                           // _atagMatch
    ETAG_NULL,                      // _etagUnmatchedSubstitute
    NULL,                           // _pfnHpxCreator
    FALSE,                          // _fMerge
    ETAG_NULL,                      // _etagImplicitChild
    FALSE,                          // _fCloseImplicitChild
};

// TABLE

static CHtmlParseClass s_hpcTable =
{
    SCOPE_NESTED,                   // _scope
    TEXTTYPE_ALWAYS,                // _texttype                    ; textlike; force BODY etc
    s_atagTable,                    // _atagEndContainers
    s_atagTableCellCaption,         // _atagBeginContainers         ; allow nesting inside TD, CAPTION, TABLE
    NULL,                           // _atagMaskingContainers
    s_atagTableCloses,              // _atagProhibitedContainers    ; close prevous TABLE, TC, SELECT, OPTION
    NULL,                           // _atagRequiredContainers
    ETAG_NULL,                      // _etagDefaultContainer
    FALSE,                          // _fQueueForRequired
    TEXTSCOPE_EXCLUDE,              // _textscope                   ; exclude text
    ETAG_TC,                        // _etagTextSubcontainer        ; wrap contained text in a TC
    NULL,                           // _atagMatch
    ETAG_NULL,                      // _etagUnmatchedSubstitute
    NULL,                           // _pfnHpxCreator
    FALSE,                          // _fMerge
    ETAG_NULL,                      // _etagImplicitChild
    FALSE,                          // _fCloseImplicitChild
};



// BUTTON:
// BUTTONs are text edits...
ELEMENT_TAG s_atagButtonProhibitedContainers[] = {ETAG_BUTTON, ETAG_NULL};

static CHtmlParseClass s_hpcButton =
{
    SCOPE_NESTED,                   // _scope
    TEXTTYPE_ALWAYS,                // _texttype                    ; textlike; force BODY etc
    s_atagNestBoundary,             // _atagEndContainers
    s_atagNestBoundary,             // _atagBeginContainers         ; TABLE-like container boundaries
    NULL,                           // _atagMaskingContainers
    s_atagButton,                   // _atagProhibitedContainers    ; close previously open BUTTON
    NULL,                           // _atagRequiredContainers
    ETAG_NULL,                      // _etagDefaultContainer
    FALSE,                          // _fQueueForRequired
    TEXTSCOPE_INCLUDE,              // _textscope                   ; exclude text
    ETAG_NULL,                      // _etagTextSubcontainer        ; wrap contained text in a TC
    NULL,                           // _atagMatch
    ETAG_NULL,                      // _etagUnmatchedSubstitute
    NULL,                           // _pfnHpxCreator
    FALSE,                          // _fMerge
    ETAG_NULL,                      // _etagImplicitChild
    FALSE,                          // _fCloseImplicitChild
};

// INPUT:
// INPUTs are textbox, buttons, checkbox ...
static CHtmlParseClass s_hpcInput =
{
    SCOPE_EMPTY,                    // _scope
    TEXTTYPE_QUERY,                 // _texttype                    ; textlike only if not hidden; see CHtmTopParseCtx::QueryTextlike
    s_atagNull,                     // _atagEndContainers
    s_atagHtml,                     // _atagBeginContainers         ; when requiring BODY/HEAD, stop searching at HTML
    s_atagButton,                   // _atagMaskingContainers       ; hidden by BUTTON
    s_atagSelect,                   // _atagProhibitedContainers    ; close previously open SELECT
    s_atagBodyHead,                 // _atagRequiredContainers      ; must appear inside a BODY or HEAD (note that "textlike" will normally ensure BODY already)
    ETAG_HEAD,                      // _etagDefaultContainer        ; if neither is present, imply a HEAD
    FALSE,                          // _fQueueForRequired
    TEXTSCOPE_NEUTRAL,              // _textscope
    ETAG_NULL,                      // _etagTextSubcontainer
    NULL,                           // _atagMatch
    ETAG_NULL,                      // _etagUnmatchedSubstitute
    NULL,                           // _pfnHpxCreator
    FALSE,                          // _fMerge
    ETAG_NULL,                      // _etagImplicitChild
    FALSE,                          // _fCloseImplicitChild
};


// Frame and frameset have special classes for bug 54592:
// A <FORM> must be closed before they begin

// FRAME

static CHtmlParseClass s_hpcFrame =
{
    SCOPE_EMPTY,                    // _scope
    TEXTTYPE_NEVER,                 // _texttype
    s_atagNull,                     // _atagEndContainers
    s_atagNull,                     // _atagBeginContainers
    NULL,                           // _atagMaskingContainers
    s_atagForm,                     // _atagProhibitedContainers
    s_atagFrameset,                 // _atagRequiredContainers
    ETAG_NULL,                      // _etagDefaultContainer
    FALSE,                          // _fQueueForRequired
    TEXTSCOPE_NEUTRAL,              // _textscope
    ETAG_NULL,                      // _etagTextSubcontainer
    NULL,                           // _atagMatch
    ETAG_NULL,                      // _etagUnmatchedSubstitute
    CreateHtmFrameParseCtx,         // _pfnHpxCreator
    FALSE,                          // _fMerge
    ETAG_NULL,                      // _etagImplicitChild
    FALSE,                          // _fCloseImplicitChild
};

// FRAMESET

static CHtmlParseClass s_hpcFrameset =
{
    SCOPE_NESTED,                   // _scope
    TEXTTYPE_NEVER,                 // _texttype
    s_atagNull,                     // _atagEndContainers
    s_atagNull,                     // _atagBeginContainers
    NULL,                           // _atagMaskingContainers
    s_atagFormHead,                 // _atagProhibitedContainers
    NULL,                           // _atagRequiredContainers
    ETAG_NULL,                      // _etagDefaultContainer
    FALSE,                          // _fQueueForRequired
    TEXTSCOPE_INCLUDE,              // _textscope
    ETAG_NULL,                      // _etagTextSubcontainer
    NULL,                           // _atagMatch
    ETAG_NULL,                      // _etagUnmatchedSubstitute
    CreateHtmFramesetParseCtx,      // _pfnHpxCreator
    FALSE,                          // _fMerge
    ETAG_NULL,                      // _etagImplicitChild
    FALSE,                          // _fCloseImplicitChild
};

// RAW_COMMENT

static CHtmlParseClass s_hpcRawComment =
{
    SCOPE_EMPTY,                    // _scope
    TEXTTYPE_NEVER,                 // _texttype
    s_atagNull,                     // _atagEndContainers           ; end tags are irrelevant
    s_atagNull,                     // _atagBeginContainers         ; begin tags are irrelevant
    NULL,                           // _atagMaskingContainers
    NULL,                           // _atagProhibitedContainers
    NULL,                           // _atagRequiredContainers
    ETAG_NULL,                      // _etagDefaultContainer
    FALSE,                          // _fQueueForRequired
    TEXTSCOPE_NEUTRAL,              // _textscope
    ETAG_NULL,                      // _etagTextSubcontainer
    NULL,                           // _atagMatch
    ETAG_NULL,                      // _etagUnmatchedSubstitute
    NULL,                           // _pfnHpxCreator
    FALSE,                          // _fMerge
    ETAG_NULL,                      // _etagImplicitChild
    FALSE,                          // _fCloseImplicitChild
};


// RUBY ADDITIONS

// RUBY tag
ELEMENT_TAG s_atagRubyProhibited[] = {ETAG_RUBY, ETAG_RT, ETAG_NULL};

static CHtmlParseClass s_hpcRuby =
{
    SCOPE_OVERLAP,                  // _scope
    TEXTTYPE_NEVER,                 // _texttype
    s_atagOverlapBoundary,          // _atagEndContainers           ; don't match end tags beyond TD-like boundaries
    s_atagOverlapBoundary,          // _atagBeginContainers
    NULL,                           // _atagMaskingContainers
    s_atagRubyProhibited,           // _atagProhibitedContainers
    s_atagOverlapRequired,          // _atagRequiredContainers      ; must appear inside a BODY or TD-like container
    ETAG_BODY,                      // _etagDefaultContainer        ; if none is present, queue for a BODY
    FALSE,                          // _fQueueForRequired           ; queue
    TEXTSCOPE_NEUTRAL,              // _textscope
    ETAG_NULL,                      // _etagTextSubcontainer
    NULL,                           // _atagMatch
    ETAG_NULL,                      // _etagUnmatchedSubstitute
    NULL,                           // _pfnHpxCreator
    FALSE,                          // _fMerge
    ETAG_NULL,                      // _etagImplicitChild
    FALSE,                          // _fCloseImplicitChild
};

// RT tag
ELEMENT_TAG s_atagRTBoundary[] = {ETAG_BUTTON, ETAG_CAPTION, ETAG_HTML, ETAG_MARQUEE, /* ETAG_HTMLAREA, */ ETAG_TD, ETAG_TH, ETAG_RUBY, ETAG_NULL};
ELEMENT_TAG s_atagRTRequired[] = {ETAG_RUBY, ETAG_NULL};
ELEMENT_TAG s_atagRTProhibited[]  = {ETAG_RT, ETAG_RP, ETAG_NULL};

static CHtmlParseClass s_hpcRubyText =
{
    SCOPE_OVERLAP,                  // _scope
    TEXTTYPE_NEVER,                 // _texttype
    s_atagRTBoundary,	            // _atagEndContainers           ; don't match end tags beyond RUBY boundary
    s_atagRTBoundary,               // _atagBeginContainers
    NULL,                           // _atagMaskingContainers
    s_atagRTProhibited,             // _atagProhibitedContainers
    s_atagRTRequired,               // _atagRequiredContainers      ; must appear inside a RUBY container
    ETAG_NULL,                      // _etagDefaultContainer        
    FALSE,                          // _fQueueForRequired           ; queue
    TEXTSCOPE_NEUTRAL,              // _textscope
    ETAG_NULL,                      // _etagTextSubcontainer
    NULL,                           // _atagMatch
    ETAG_NULL,                      // _etagUnmatchedSubstitute
    NULL,                           // _pfnHpxCreator
    FALSE,                          // _fMerge
    ETAG_NULL,                      // _etagImplicitChild
    FALSE,                          // _fCloseImplicitChild
};

// RP tag
ELEMENT_TAG s_atagRPBoundary[] = {ETAG_BUTTON, ETAG_CAPTION, ETAG_HTML, ETAG_MARQUEE, /* ETAG_HTMLAREA, */ ETAG_TD, ETAG_TH, ETAG_RUBY, ETAG_RT, ETAG_NULL};
ELEMENT_TAG s_atagRPProhibited[]  = {ETAG_RP, ETAG_NULL};

static CHtmlParseClass s_hpcRubyParen =
{
    SCOPE_OVERLAP,                  // _scope
    TEXTTYPE_NEVER,                 // _texttype
    s_atagRPBoundary,	            // _atagEndContainers           ; don't match end tags beyond RUBY boundary
    s_atagRTBoundary,               // _atagBeginContainers
    NULL,                           // _atagMaskingContainers
    s_atagRPProhibited,             // _atagProhibitedContainers
    s_atagRTRequired,               // _atagRequiredContainers      ; must appear inside a RUBY container
    ETAG_NULL,                      // _etagDefaultContainer        
    FALSE,                          // _fQueueForRequired           ; queue
    TEXTSCOPE_NEUTRAL,              // _textscope
    ETAG_NULL,                      // _etagTextSubcontainer
    NULL,                           // _atagMatch
    ETAG_NULL,                      // _etagUnmatchedSubstitute
    NULL,                           // _pfnHpxCreator
    FALSE,                          // _fMerge
    ETAG_NULL,                      // _etagImplicitChild
    FALSE,                          // _fCloseImplicitChild
};

// the hash table of tag names

CPtrBagCi<ELEMENT_TAG> g_bKnownTags(&g_tagasc);

// the tagdescs

const CTagDesc g_atagdesc[] =
{
    { _T(""),               &s_hpcEmpty,                    CTextElement::CreateElement,
                            TAGDESC_TEXTLESS                },
    { _T(""),               &s_hpcUnknown,                  CUnknownElement::CreateElement,
                            TAGDESC_TEXTLESS                |
                            TAGDESC_SLOWPROCESS             },
    { SZTAG_A,              &s_hpcAnchor,                   CAnchorElement::CreateElement,
                            0                               },
    { SZTAG_ACRONYM,        &s_hpcOverlap,                  CPhraseElement::CreateElement,
                            TAGDESC_EDITREMOVABLE           },
    { SZTAG_ADDRESS,        &s_hpcParagraph,                CBlockElement::CreateElement,
                            TAGDESC_BLOCKELEMENT            |
                            TAGDESC_SAVENBSPIFEMPTY         |
                            TAGDESC_BLKSTYLEDD              },
    { SZTAG_APPLET,         &s_hpcObjectApplet,             CObjectElement::CreateElement,
                            TAGDESC_TEXTLESS                |
                            TAGDESC_WAITATEND               |
                            TAGDESC_SPECIALTOKEN            },
    { SZTAG_AREA,           &s_hpcArea,                     CAreaElement::CreateElement,
                            TAGDESC_TEXTLESS                },
    { SZTAG_B,              &s_hpcOverlap,                  CPhraseElement::CreateElement,
                            TAGDESC_EDITREMOVABLE           },
    { SZTAG_BASE,           &s_hpcUnderlap,                 CBaseElement::CreateElement,
                            TAGDESC_SPECIALTOKEN            |
                            TAGDESC_NEVERSAVEEND            },
    { SZTAG_BASEFONT,       &s_hpcBasefont,                 CBaseFontElement::CreateElement,
                            0                               },
    { SZTAG_BDO,            &s_hpcOverlap,                  CPhraseElement::CreateElement,
                            TAGDESC_EDITREMOVABLE           },
    { SZTAG_BGSOUND,        &s_hpcEmpty,                    CBGsound::CreateElement,
                            TAGDESC_SPECIALTOKEN            |
                            TAGDESC_TEXTLESS                },
    { SZTAG_BIG,            &s_hpcOverlap,                  CPhraseElement::CreateElement,
                            TAGDESC_EDITREMOVABLE           },
    { SZTAG_BLINK,          &s_hpcOverlap,                  CPhraseElement::CreateElement,
                            TAGDESC_EDITREMOVABLE           },
    { SZTAG_BLOCKQUOTE,     &s_hpcParagraph,                CBlockElement::CreateElement,
                            TAGDESC_BLOCKELEMENT            |
                            TAGDESC_SAVENBSPIFEMPTY         |
                            TAGDESC_SAVEINDENT              |
                            TAGDESC_SPLITBLOCKINLIST        |
                            TAGDESC_EDITREMOVABLE           },
    { SZTAG_BODY,           &s_hpcBody,                     CBodyElement::CreateElement,
                            TAGDESC_BLOCKELEMENT            |
                            TAGDESC_SAVENBSPIFEMPTY         |
                            TAGDESC_SAVEALWAYSEND           |
                            TAGDESC_ACCEPTHTML              |
                            TAGDESC_SPECIALTOKEN            |
                            TAGDESC_CONTAINER               |
                            TAGDESC_SLOWPROCESS             },
    { SZTAG_BR,             &s_hpcBr,                       CBRElement::CreateElement,
                            TAGDESC_TEXTLESS                },
    { SZTAG_BUTTON,         &s_hpcButton,                   CButton::CreateElement,
                            TAGDESC_SAVENBSPIFEMPTY         |
                            TAGDESC_ACCEPTHTML              |
                            TAGDESC_CONTAINER               },
    { SZTAG_CAPTION,        &s_hpcCaption,                  CTableCaption::CreateElement,
                            TAGDESC_BLOCKELEMENT            |
                            TAGDESC_ACCEPTHTML              |
                            TAGDESC_SAVENBSPIFEMPTY         },
    { SZTAG_CENTER,         &s_hpcCenter,                   CBlockElement::CreateElement,
                            TAGDESC_BLOCKELEMENT            |
                            TAGDESC_SAVENBSPIFEMPTY         },
    { SZTAG_CITE,           &s_hpcOverlap,                  CPhraseElement::CreateElement,
                            TAGDESC_EDITREMOVABLE           },
    { SZTAG_CODE,           &s_hpcOverlap,                  CPhraseElement::CreateElement,
                            TAGDESC_EDITREMOVABLE           },
    { SZTAG_COL,            &s_hpcTCol,                     CTableCol::CreateElement,
                            TAGDESC_TEXTLESS                |
                            TAGDESC_BLOCKELEMENT            |
                            TAGDESC_SAVENBSPIFEMPTY         },
    { SZTAG_COLGROUP,       &s_hpcTSection,                 CTableCol::CreateElement,
                            TAGDESC_BLOCKELEMENT            |
                            TAGDESC_SAVENBSPIFEMPTY         },
    { SZTAG_COMMENT,        &s_hpcComment,                  CCommentElement::CreateElement,
                            TAGDESC_TEXTLESS                |
                            TAGDESC_LITERALTAG              |
                            TAGDESC_LITERALENT              },
    { SZTAG_DD,             &s_hpcDDDT,                     CDDElement::CreateElement,
                            TAGDESC_BLOCKELEMENT            |
                            TAGDESC_SAVENBSPIFEMPTY         |
                            TAGDESC_LISTITEM                |
                            TAGDESC_BLKSTYLEDD              },
    { _T(""),               &s_hpcDefault,                  CTextElement::CreateElement,
                            TAGDESC_TEXTLESS                },
    { SZTAG_DEL,            &s_hpcOverlap,                  CPhraseElement::CreateElement,
                            TAGDESC_EDITREMOVABLE           },
    { SZTAG_DFN,            &s_hpcOverlap,                  CPhraseElement::CreateElement,
                            TAGDESC_EDITREMOVABLE           },
    { SZTAG_DIR,            &s_hpcParagraph,                CListElement::CreateElement,
                            TAGDESC_BLOCKELEMENT            |
                            TAGDESC_SAVENBSPIFEMPTY         |
                            TAGDESC_LIST                    |
                            TAGDESC_BLKSTYLEDD              },
    { SZTAG_DIV,            &s_hpcParagraph,                CDivElement::CreateElement,
                            TAGDESC_BLOCKELEMENT            |
                            TAGDESC_SAVENBSPIFEMPTY         |
                            TAGDESC_ALIGN                   |
                            TAGDESC_SPLITBLOCKINLIST        },
    { SZTAG_DL,             &s_hpcParagraph,                CDListElement::CreateElement,
                            TAGDESC_BLOCKELEMENT            |
                            TAGDESC_SAVENBSPIFEMPTY         |
                            TAGDESC_LIST                    |
                            TAGDESC_BLKSTYLEDD              |
                            TAGDESC_SAVEINDENT              },
    { SZTAG_DT,             &s_hpcDDDT,                     CDTElement::CreateElement,
                            TAGDESC_BLOCKELEMENT            |
                            TAGDESC_SAVENBSPIFEMPTY         |
                            TAGDESC_LISTITEM                |
                            TAGDESC_BLKSTYLEDD              },
    { SZTAG_EM,             &s_hpcOverlap,                  CPhraseElement::CreateElement,
                            TAGDESC_EDITREMOVABLE           },
    { SZTAG_EMBED,          &s_hpcEmptyText,                CPluginSite::CreateElement,
                            TAGDESC_TEXTLESS                },
    { SZTAG_FIELDSET,       &s_hpcParagraph,                CFieldSetElement::CreateElement,
                            TAGDESC_BLOCKELEMENT            |
                            TAGDESC_SAVENBSPIFEMPTY         |
                            TAGDESC_ALIGN                   |
                            TAGDESC_SPLITBLOCKINLIST        |
                            TAGDESC_ACCEPTHTML              },
    { SZTAG_FONT,           &s_hpcOverlap,                  CFontElement::CreateElement,
                            TAGDESC_EDITREMOVABLE           },
    { SZTAG_FORM,           &s_hpcForm,                     CFormElement::CreateElement,
                            TAGDESC_BLOCKELEMENT            |
                            TAGDESC_SAVENBSPIFEMPTY         |
                            TAGDESC_SLOWPROCESS             },
    { SZTAG_FRAME,          &s_hpcFrame,                    CFrameElement::CreateElement,
                            TAGDESC_TEXTLESS                },
    { SZTAG_FRAMESET,       &s_hpcFrameset,                 CFrameSetSite::CreateElement,
                            TAGDESC_SPECIALTOKEN            |
                            TAGDESC_SLOWPROCESS             },
    { SZTAG_H1,             &s_hpcHeader,                   CHeaderElement::CreateElement,
                            TAGDESC_BLOCKELEMENT            |
                            TAGDESC_SAVENBSPIFEMPTY         |
                            TAGDESC_HEADER                  |
                            TAGDESC_BLKSTYLEDD              |
                            TAGDESC_ALIGN                   |
                            TAGDESC_SPLITBLOCKINLIST        },
    { SZTAG_H2,             &s_hpcHeader,                   CHeaderElement::CreateElement,
                            TAGDESC_BLOCKELEMENT            |
                            TAGDESC_SAVENBSPIFEMPTY         |
                            TAGDESC_HEADER                  |
                            TAGDESC_BLKSTYLEDD              |
                            TAGDESC_ALIGN                   |
                            TAGDESC_SPLITBLOCKINLIST        },
    { SZTAG_H3,             &s_hpcHeader,                   CHeaderElement::CreateElement,
                            TAGDESC_BLOCKELEMENT            |
                            TAGDESC_SAVENBSPIFEMPTY         |
                            TAGDESC_HEADER                  |
                            TAGDESC_BLKSTYLEDD              |
                            TAGDESC_ALIGN                   |
                            TAGDESC_SPLITBLOCKINLIST        },
    { SZTAG_H4,             &s_hpcHeader,                   CHeaderElement::CreateElement,
                            TAGDESC_BLOCKELEMENT            |
                            TAGDESC_SAVENBSPIFEMPTY         |
                            TAGDESC_HEADER                  |
                            TAGDESC_BLKSTYLEDD              |
                            TAGDESC_ALIGN                   |
                            TAGDESC_SPLITBLOCKINLIST        },
    { SZTAG_H5,             &s_hpcHeader,                   CHeaderElement::CreateElement,
                            TAGDESC_BLOCKELEMENT            |
                            TAGDESC_SAVENBSPIFEMPTY         |
                            TAGDESC_HEADER                  |
                            TAGDESC_BLKSTYLEDD              |
                            TAGDESC_ALIGN                   |
                            TAGDESC_SPLITBLOCKINLIST        },
    { SZTAG_H6,             &s_hpcHeader,                   CHeaderElement::CreateElement,
                            TAGDESC_BLOCKELEMENT            |
                            TAGDESC_SAVENBSPIFEMPTY         |
                            TAGDESC_HEADER                  |
                            TAGDESC_BLKSTYLEDD              |
                            TAGDESC_ALIGN                   |
                            TAGDESC_SPLITBLOCKINLIST        },
    { SZTAG_HEAD,           &s_hpcHead,                     CHeadElement::CreateElement,
                            TAGDESC_SAVEALWAYSEND           },
    { SZTAG_HR,             &s_hpcHr,                       CHRElement::CreateElement,
                            TAGDESC_TEXTLESS                |
                            TAGDESC_OWNLINE                 },
    { SZTAG_HTML,           &s_hpcHtml,                     CHtmlElement::CreateElement,
                            TAGDESC_SAVEALWAYSEND           |
                            TAGDESC_ENTER_TREE_IMMEDIATELY  |
                            TAGDESC_SLOWPROCESS             },
    { SZTAG_I,              &s_hpcOverlap,                  CPhraseElement::CreateElement,
                            TAGDESC_EDITREMOVABLE           },
    { SZTAG_IFRAME,         &s_hpcIframe,                   CIFrameElement::CreateElement,
                            TAGDESC_TEXTLESS                |
                            TAGDESC_SAVEALWAYSEND           |
                            TAGDESC_SPECIALTOKEN            },
    { SZTAG_IMG,            &s_hpcEmptyText,                CImgElement::CreateElement,
                            TAGDESC_TEXTLESS                |
                            TAGDESC_SPECIALTOKEN            },
    { SZTAG_INPUT,          &s_hpcInput,                    CreateInputElement,
                            TAGDESC_TEXTLESS                |
                            TAGDESC_CONTAINER               |
                            TAGDESC_SPECIALTOKEN            |
                            TAGDESC_LOGICALINVISUAL         },
    { _T(""),/*TXTSLAVE*/   &s_hpcEmpty,                    CTxtSlave::CreateElement,
                            TAGDESC_LITERALTAG              |
                            TAGDESC_SAVEALWAYSEND           |
                            TAGDESC_BLOCKELEMENT            |
                            TAGDESC_SAVENBSPIFEMPTY         |
                            TAGDESC_SAVEINDENT              |
                            TAGDESC_XSMBEGIN                |
                            TAGDESC_LOGICALINVISUAL         |
                            TAGDESC_CONTAINER               },
    { SZTAG_INS,            &s_hpcOverlap,                  CPhraseElement::CreateElement,
                            TAGDESC_EDITREMOVABLE           },
    { SZTAG_ISINDEX,        &s_hpcEmptyText,                CIsIndexElement::CreateElement,
                            TAGDESC_TEXTLESS                |
                            TAGDESC_SLOWPROCESS             },
    { SZTAG_KBD,            &s_hpcOverlap,                  CPhraseElement::CreateElement,
                            TAGDESC_EDITREMOVABLE           },
    { SZTAG_LABEL,          &s_hpcOverlap,                  CLabelElement::CreateElement,
                            0                               },
    { SZTAG_LEGEND,         &s_hpcLegend,                   CLegendElement::CreateElement,
                            TAGDESC_BLOCKELEMENT            |
                            TAGDESC_SAVENBSPIFEMPTY         |
                            TAGDESC_OWNLINE                 |
                            TAGDESC_ACCEPTHTML              |
                            TAGDESC_CONTAINER               },
    { SZTAG_LI,             &s_hpcLI,                       CLIElement::CreateElement,
                            TAGDESC_BLOCKELEMENT            |
                            TAGDESC_LISTITEM                },
    { SZTAG_LINK,           &s_hpcEmpty,                    CLinkElement::CreateElement,
                            TAGDESC_TEXTLESS                |
                            TAGDESC_SPECIALTOKEN            |
                            TAGDESC_WAITATSTART             |
                            TAGDESC_DONTWAITFORINPLACE      },
    { SZTAG_LISTING,        &s_hpcPre,                      CBlockElement::CreateElement,
                            TAGDESC_BLOCKELEMENT            |
                            TAGDESC_SAVEALWAYSEND           |
                            TAGDESC_SAVENBSPIFEMPTY         },
    { SZTAG_MAP,            &s_hpcMap,                      CMapElement::CreateElement,
                            TAGDESC_SAVEINDENT              },
    { SZTAG_MARQUEE,        &s_hpcMarquee,                  CMarquee::CreateElement,
                            TAGDESC_BLOCKELEMENT            |
                            TAGDESC_SAVENBSPIFEMPTY         |
                            TAGDESC_ACCEPTHTML              |
                            TAGDESC_CONTAINER               },
    { SZTAG_MENU,           &s_hpcParagraph,                CListElement::CreateElement,
                            TAGDESC_BLOCKELEMENT            |
                            TAGDESC_SAVENBSPIFEMPTY         |
                            TAGDESC_LIST                    |
                            TAGDESC_BLKSTYLEDD              |
                            TAGDESC_SAVEINDENT              },
    { SZTAG_META,           &s_hpcEmpty,                    CMetaElement::CreateElement,
                            TAGDESC_TEXTLESS                |
                            TAGDESC_SPECIALTOKEN            |
                            TAGDESC_SAVETAGOWNLINE          },
    { SZTAG_NEXTID,         &s_hpcEmpty,                    CNextIdElement::CreateElement,
                            TAGDESC_TEXTLESS                },
    { SZTAG_NOBR,           &s_hpcNobr,                     CPhraseElement::CreateElement,
                            TAGDESC_EDITREMOVABLE           },
    { SZTAG_NOEMBED,        &s_hpcNoShow,                   CNoShowElement::CreateElement,
                            TAGDESC_TEXTLESS                |
                            TAGDESC_SLOWPROCESS             |
                            TAGDESC_SPECIALTOKEN            },
    { SZTAG_NOEMBED, /*OFF*/&s_hpcUnderlap,                 CNoShowElement::CreateElement,
                            0                               },
    { SZTAG_NOFRAMES,       &s_hpcNoShow,                   CNoShowElement::CreateElement,
                            TAGDESC_TEXTLESS                |
                            TAGDESC_SPECIALTOKEN            },
    { SZTAG_NOFRAMES,/*OFF*/&s_hpcUnderlap,                 CNoShowElement::CreateElement,
                            0                               },
    { SZTAG_NOSCRIPT,       &s_hpcNoShow,                   CNoShowElement::CreateElement,
                            TAGDESC_TEXTLESS                |
                            TAGDESC_SLOWPROCESS             |
                            TAGDESC_SPECIALTOKEN            },
    { SZTAG_NOSCRIPT,/*OFF*/&s_hpcUnderlap,                 CNoShowElement::CreateElement,
                            0                               },
    { SZTAG_OBJECT,         &s_hpcObjectApplet,             CObjectElement::CreateElement,
                            TAGDESC_TEXTLESS                |
                            TAGDESC_SAVENBSPIFEMPTY         |
                            TAGDESC_LOGICALINVISUAL         |
                            TAGDESC_WAITATEND               |
                            TAGDESC_SPECIALTOKEN            },
    { SZTAG_OL,             &s_hpcParagraph,                COListElement::CreateElement,
                            TAGDESC_BLOCKELEMENT            |
                            TAGDESC_LIST                    |
                            TAGDESC_BLKSTYLEDD              |
                            TAGDESC_SAVEINDENT              },
    { SZTAG_OPTION,         &s_hpcOption,                   COptionElement::CreateElement,
                            0                               },
    { SZTAG_P,              &s_hpcParagraph,                CParaElement::CreateElement,
                            TAGDESC_BLOCKELEMENT            |
                            TAGDESC_SAVENBSPIFEMPTY         |
                            TAGDESC_BLKSTYLEDD              |
                            TAGDESC_ALIGN                   |
                            TAGDESC_SAVENBSPIFEMPTY         },
    { SZTAG_PARAM,          &s_hpcEmpty,                    CTextElement::CreateElement,
                            TAGDESC_TEXTLESS                },
    { SZTAG_PLAINTEXT,      &s_hpcPre,                      CBlockElement::CreateElement,
                            TAGDESC_BLOCKELEMENT            |
                            TAGDESC_SAVENBSPIFEMPTY         |
                            TAGDESC_SAVEALWAYSEND           |
                            TAGDESC_LITERALTAG              |
                            TAGDESC_LITERALENT              |
                            TAGDESC_SPECIALTOKEN            },
    { SZTAG_PRE,            &s_hpcPre,                      CBlockElement::CreateElement,
                            TAGDESC_BLOCKELEMENT            |
                            TAGDESC_SAVENBSPIFEMPTY         |
                            TAGDESC_SAVEALWAYSEND           |
                            TAGDESC_BLKSTYLEDD              },
    { SZTAG_Q,              &s_hpcOverlap,                  CPhraseElement::CreateElement,
                            TAGDESC_EDITREMOVABLE           },
#ifdef  NEVER
    { SZTAG_HTMLAREA,       &s_hpcRichtext,                 CRichtext::CreateElement,
                            TAGDESC_SAVEINDENT              |
                            TAGDESC_SAVEALWAYSEND           |
                            TAGDESC_SAVENBSPIFEMPTY         |
                            TAGDESC_ACCEPTHTML              |
                            TAGDESC_CONTAINER               },
#endif
    { _T(""),               &s_hpcRoot,                     CTextElement::CreateElement,
                            TAGDESC_ACCEPTHTML              |
// Do NOT make the root a container
//               BAD  --->    TAGDESC_CONTAINER             |
                            TAGDESC_BLOCKELEMENT            },
    { SZTAG_RP,             &s_hpcRubyParen,                CPhraseElement::CreateElement,
                            TAGDESC_EDITREMOVABLE           },
    { SZTAG_RT,             &s_hpcRubyText,                 CPhraseElement::CreateElement,
                            TAGDESC_EDITREMOVABLE           },
    { SZTAG_RUBY,           &s_hpcRuby,                     CPhraseElement::CreateElement,
                            TAGDESC_EDITREMOVABLE           },
    { SZTAG_S,              &s_hpcOverlap,                  CPhraseElement::CreateElement,
                            TAGDESC_EDITREMOVABLE           },
    { SZTAG_SAMP,           &s_hpcOverlap,                  CPhraseElement::CreateElement,
                            TAGDESC_EDITREMOVABLE           },
    { SZTAG_SCRIPT,         &s_hpcScript,                   CScriptElement::CreateElement,
                            TAGDESC_TEXTLESS                |
                            TAGDESC_SAVEALWAYSEND           |
                            TAGDESC_LITERALTAG              |
                            TAGDESC_LITERALENT              |
                            TAGDESC_SPECIALTOKEN            |
                            TAGDESC_WAITATEND               },
    { SZTAG_SELECT,         &s_hpcSelect,                   CSelectElement::CreateElement,
                            TAGDESC_SAVEINDENT              |
                            TAGDESC_LOGICALINVISUAL         },
    { SZTAG_SMALL,          &s_hpcOverlap,                  CPhraseElement::CreateElement,
                            TAGDESC_EDITREMOVABLE           },
    { SZTAG_SPAN,           &s_hpcOverlap,                  CSpanElement::CreateElement,
                            0                               },
    { SZTAG_STRIKE,         &s_hpcOverlap,                  CPhraseElement::CreateElement,
                            TAGDESC_EDITREMOVABLE           },
    { SZTAG_STRONG,         &s_hpcOverlap,                  CPhraseElement::CreateElement,
                            TAGDESC_EDITREMOVABLE           },
    { SZTAG_STYLE,          &s_hpcStyle,                    CStyleElement::CreateElement,
                            TAGDESC_TEXTLESS                |
                            TAGDESC_SAVEALWAYSEND           |
                            TAGDESC_LITERALTAG              |
                            TAGDESC_LITERALENT              },
    { SZTAG_SUB,            &s_hpcOverlap,                  CPhraseElement::CreateElement,
                            TAGDESC_EDITREMOVABLE           },
    { SZTAG_SUP,            &s_hpcOverlap,                  CPhraseElement::CreateElement,
                            TAGDESC_EDITREMOVABLE           },
    { SZTAG_TABLE,          &s_hpcTable,                    CTable::CreateElement,
                            TAGDESC_BLOCKELEMENT            |
                            TAGDESC_SAVENBSPIFEMPTY         |
                            TAGDESC_WONTBREAKLINE           |
                            TAGDESC_SPECIALTOKEN            |
                            TAGDESC_SAVEINDENT              },
    { SZTAG_TBODY,          &s_hpcTSection,                 CTableSection::CreateElement,
                            TAGDESC_BLOCKELEMENT            |
                            TAGDESC_SAVENBSPIFEMPTY         },
    { _T(""),/*TC*/         &s_hpcTC,                       CTableCaption::CreateElement,
                            TAGDESC_BLOCKELEMENT            |
                            TAGDESC_SAVENBSPIFEMPTY         |
                            TAGDESC_ACCEPTHTML              },
    { SZTAG_TD,             &s_hpcTCell,                    CTableCell::CreateElement,
                            TAGDESC_BLOCKELEMENT            |
                            TAGDESC_SAVENBSPIFEMPTY         |
                            TAGDESC_ACCEPTHTML              |
                            TAGDESC_SAVEINDENT              },
    { SZTAG_TEXTAREA,       &s_hpcTextarea,                 CTextArea::CreateElement,
                            TAGDESC_LITERALTAG              |
                            TAGDESC_SAVEALWAYSEND           |
                            TAGDESC_SAVENBSPIFEMPTY         |
                            TAGDESC_SAVEINDENT              |
                            TAGDESC_LOGICALINVISUAL         |
                            TAGDESC_CONTAINER               },
    { SZTAG_TFOOT,          &s_hpcTSection,                 CTableSection::CreateElement,
                            TAGDESC_BLOCKELEMENT            |
                            TAGDESC_SAVENBSPIFEMPTY         },
    { SZTAG_TH,             &s_hpcTCell,                    CTableCell::CreateElement,
                            TAGDESC_BLOCKELEMENT            |
                            TAGDESC_SAVENBSPIFEMPTY         |
                            TAGDESC_ACCEPTHTML              |
                            TAGDESC_SAVEINDENT              },
    { SZTAG_THEAD,          &s_hpcTSection,                 CTableSection::CreateElement,
                            TAGDESC_BLOCKELEMENT            |
                            TAGDESC_SAVENBSPIFEMPTY         },
    { SZTAG_TITLE,          &s_hpcTitleTag,                 CTextElement::CreateElement,
                            TAGDESC_LITERALTAG              |
                            TAGDESC_SAVEALWAYSEND           |
                            TAGDESC_LITCTX                  },
    { SZTAG_TR,             &s_hpcTRow,                     CTableRow::CreateElement,
                            TAGDESC_BLOCKELEMENT            |
                            TAGDESC_SAVENBSPIFEMPTY         |
                            TAGDESC_SAVEINDENT              },
    { SZTAG_TT,             &s_hpcOverlap,                  CPhraseElement::CreateElement,
                            TAGDESC_EDITREMOVABLE           },
    { SZTAG_U,              &s_hpcOverlap,                  CPhraseElement::CreateElement,
                            TAGDESC_EDITREMOVABLE           },
    { SZTAG_UL,             &s_hpcParagraph,                CUListElement::CreateElement,
                            TAGDESC_BLOCKELEMENT            |
                            TAGDESC_LIST                    |
                            TAGDESC_BLKSTYLEDD              |
                            TAGDESC_SAVEINDENT              },
    { SZTAG_VAR,            &s_hpcOverlap,                  CPhraseElement::CreateElement,
                            TAGDESC_EDITREMOVABLE           },
    { SZTAG_WBR,            &s_hpcEmptyText,                CTextElement::CreateElement,
                            TAGDESC_TEXTLESS                },
    { SZTAG_XMP,            &s_hpcPre,                      CBlockElement::CreateElement,
                            TAGDESC_BLOCKELEMENT            |
                            TAGDESC_SAVEALWAYSEND           |
                            TAGDESC_SAVENBSPIFEMPTY         |
                            TAGDESC_LITERALTAG              |
                            TAGDESC_LITERALENT              },
    // ETAG_GENERIC
    { _T(""),               &s_hpcGeneric,                  CGenericElement::CreateElement,
                            0                               },
    // ETAG_GENERIC_LITERAL
    { _T(""),               &s_hpcGenericLiteral,           CGenericElement::CreateElement,
                            TAGDESC_TEXTLESS                |
                            TAGDESC_LITERALTAG              |
                            TAGDESC_LITERALENT              },
    // ETAG_GENERIC_BUILTIN
    { _T(""),               &s_hpcGeneric,                  CGenericElement::CreateElement,
                            0                               },
    // ETAG_TITLE_ELEMENT
    { SZTAG_TITLE,          &s_hpcTitleElement,             CTitleElement::CreateElement,
                            TAGDESC_LITERALTAG              |
                            TAGDESC_TEXTLESS                |
                            TAGDESC_SAVEALWAYSEND           },
    { SZTAG_RAW_COMMENT,    &s_hpcRawComment,               CCommentElement::CreateElement,
                            TAGDESC_TEXTLESS                },
    // ETAG_RAW_SOURCE
    { _T(""),               &s_hpcEmpty,                    CTextElement::CreateElement,
                            TAGDESC_TEXTLESS                },
    // ETAG_RAW_TEXT
    { _T(""),               &s_hpcEmpty,                    CTextElement::CreateElement,
                            TAGDESC_TEXTLESS                },
    // ETAG_RAW_EOF
    { _T(""),               &s_hpcEmpty,                    CTextElement::CreateElement,
                            TAGDESC_TEXTLESS                },
    // ETAG_RAW_CODEPAGE
    { _T(""),               &s_hpcEmpty,                    CTextElement::CreateElement,
                            TAGDESC_TEXTLESS                |
                            TAGDESC_WAITATEND               | // WAITATEND: blocks when _fRestart==TRUE
                            TAGDESC_SLOWPROCESS             },
    // ETAG_RAW_BEGINFRAG
    { _T(""),               &s_hpcEmpty,                    CTextElement::CreateElement,
                            TAGDESC_TEXTLESS                |
                            TAGDESC_SLOWPROCESS             },
    // ETAG_RAW_ENDFRAG
    { _T(""),               &s_hpcEmpty,                    CTextElement::CreateElement,
                            TAGDESC_TEXTLESS                |
                            TAGDESC_SLOWPROCESS             },
    // ETAG_RAW_BEGINSEL
    { _T(""),               &s_hpcEmpty,                    CTextElement::CreateElement,
                            TAGDESC_TEXTLESS                |
                            TAGDESC_SLOWPROCESS             },
    // ETAG_RAW_ENDSEL
    { _T(""),               &s_hpcEmpty,                    CTextElement::CreateElement,
                            TAGDESC_TEXTLESS                |
                            TAGDESC_SLOWPROCESS             },
    // ETAG_RAW_DOCSIZE
    { _T(""),               &s_hpcEmpty,                    CTextElement::CreateElement,
                            TAGDESC_TEXTLESS                |
                            TAGDESC_SLOWPROCESS             },
#ifdef VSTUDIO7
    //ETAG_RAW_FACTORY
    { _T(""),               &s_hpcEmpty,                    CTextElement::CreateElement,
                            TAGDESC_WAITATSTART             |
                            TAGDESC_SLOWPROCESS             |
                            TAGDESC_TEXTLESS                |
                            TAGDESC_SPECIALTOKEN            },
    //ETAG_RAW_TAGSOURCE
    { _T(""),               &s_hpcEmpty,                    CTextElement::CreateElement,
                            TAGDESC_SLOWPROCESS             |
                            TAGDESC_TEXTLESS                |
                            TAGDESC_SPECIALTOKEN            },
#endif //VSTUDIO7

    // ETAG_RAW_TEXTFRAG
    { _T(""),               &s_hpcEmpty,                    CTextElement::CreateElement,
                            0                               },
                            
    // ETAG_RAW_INCLUDE
    { _T(""),               &s_hpcEmpty,                    CTextElement::CreateElement,
                            TAGDESC_WAITATSTART             |
                            TAGDESC_TEXTLESS                |
                            TAGDESC_SLOWPROCESS             |
                            TAGDESC_SPECIALTOKEN            },
};

//+------------------------------------------------------------------------
//
//  Member:     HpcFromEtag
//
//  Synopsis:   returns the parse class for the etag
//
//  Arguments:  tag (ELEMENT_TAG)
//
//  Returns:    CHtmlParseClass *
//
//-------------------------------------------------------------------------
CHtmlParseClass *
HpcFromEtag(ELEMENT_TAG tag)
{
    const CTagDesc *ptd = TagDescFromEtag(tag);

    Assert(ptd);

    return ptd ? ptd->_pParseClass : 0;
}

//+------------------------------------------------------------------------
//
//  Member:     TagProhibitedContainer(ELEMENT_TAG tag1, tag2)
//
//  Synopsis:   returns TRUE if tag2 is a prohibited container of tag1.
//
//  Arguments:  tag1, tag2 (ELEMENT_TAG)
//
//  Returns:    BOOL
//
//-------------------------------------------------------------------------

BOOL
TagProhibitedContainer(ELEMENT_TAG tag1, ELEMENT_TAG tag2)
{
    CHtmlParseClass * phpc1 = HpcFromEtag(tag1);

    return phpc1 && phpc1->_atagProhibitedContainers &&
        IsEtagInSet(tag2, phpc1->_atagProhibitedContainers);
}

//+------------------------------------------------------------------------
//
//  Member:     TagProhibitedContainer(ELEMENT_TAG tag1, tag2)
//
//  Synopsis:   returns TRUE if tag1 is an end container of tag2.
//
//  Arguments:  tag1, tag2 (ELEMENT_TAG)
//
//  Returns:    BOOL
//
//-------------------------------------------------------------------------

BOOL
TagEndContainer(ELEMENT_TAG tag1, ELEMENT_TAG tag2)
{
    CHtmlParseClass * phpc1 = HpcFromEtag(tag1);

    return phpc1 && phpc1->_atagEndContainers &&
        IsEtagInSet(tag2, phpc1->_atagEndContainers);
}

//+------------------------------------------------------------------------
//
//  Member:     TagHasNoEndTag(ELEMENT_TAG tag)
//
//  Synopsis:   returns TRUE if tag should not have an end tag
//
//  Arguments:  tag (ELEMENT_TAG)
//
//  Returns:    BOOL
//
//-------------------------------------------------------------------------

BOOL
TagHasNoEndTag(ELEMENT_TAG tag)
{
    CHtmlParseClass * phpc = HpcFromEtag(tag);
    const CTagDesc *ptd = TagDescFromEtag(tag);

    return  !phpc || phpc->_scope == SCOPE_EMPTY 
        ||  !ptd || ptd->HasFlag( TAGDESC_NEVERSAVEEND );
}
