/*++ 

Copyright (c) 1996  Microsoft Corporation

Module Name:

    datardr.c

Abstract:
       
    a file containing the constant data structures used by the Performance
    Monitor data for the Redirector Performance data objects

Created:

    Bob Watson  22-Oct-1996

Revision History:

    None.

--*/
//
//  Include Files
//

#include <windows.h>
#include <winperf.h>
#include <ntprfctr.h>
#include <perfutil.h>
#include "datardr.h"

// dummy variable for field sizing.
static RDR_COUNTER_DATA   rcd;

//
//  Constant structure initializations 
//      defined in datardr.h
//

RDR_DATA_DEFINITION RdrDataDefinition = {
    {   sizeof(RDR_DATA_DEFINITION) + sizeof(RDR_COUNTER_DATA),
        sizeof(RDR_DATA_DEFINITION),
        sizeof(PERF_OBJECT_TYPE),
        REDIRECTOR_OBJECT_TITLE_INDEX,
        0,
        263,
        0,
        PERF_DETAIL_NOVICE,
        (sizeof(RDR_DATA_DEFINITION)-sizeof(PERF_OBJECT_TYPE))/
        sizeof(PERF_COUNTER_DEFINITION),
        0,
        -1,
        UNICODE_CODE_PAGE,
        {0L,0L},
        {0L,0L}        
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        388,
        0,
        389,
        0,
        -4,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_BULK_COUNT,
        sizeof (rcd.Bytes),
        (DWORD)(ULONG_PTR)&((PRDR_COUNTER_DATA)0)->Bytes
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        406,
        0,
        391,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_COUNTER,
        sizeof (rcd.IoOperations),
        (DWORD)(ULONG_PTR)&((PRDR_COUNTER_DATA)0)->IoOperations
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        400,
        0,
        401,
        0,
        -1,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_BULK_COUNT,
        sizeof (rcd.Smbs),
        (DWORD)(ULONG_PTR)&((PRDR_COUNTER_DATA)0)->Smbs
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        264,
        0,
        265,
        0,
        -4,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_BULK_COUNT,
        sizeof (rcd.BytesReceived),
        (DWORD)(ULONG_PTR)&((PRDR_COUNTER_DATA)0)->BytesReceived
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        266,
        0,
        267,
        0,
        -1,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_BULK_COUNT,
        sizeof (rcd.SmbsReceived),
        (DWORD)(ULONG_PTR)&((PRDR_COUNTER_DATA)0)->SmbsReceived
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        268,
        0,
        269,
        0,
        -4,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_BULK_COUNT,
        sizeof (rcd.PagingReadBytesRequested),
        (DWORD)(ULONG_PTR)&((PRDR_COUNTER_DATA)0)->PagingReadBytesRequested
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        270,
        0,
        271,
        0,
        -4,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_BULK_COUNT,
        sizeof (rcd.NonPagingReadBytesRequested),
        (DWORD)(ULONG_PTR)&((PRDR_COUNTER_DATA)0)->NonPagingReadBytesRequested
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        272,
        0,
        273,
        0,
        -4,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_BULK_COUNT,
        sizeof (rcd.CacheReadBytesRequested),
        (DWORD)(ULONG_PTR)&((PRDR_COUNTER_DATA)0)->CacheReadBytesRequested
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        274,
        0,
        275,
        0,
        -4,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_BULK_COUNT,
        sizeof (rcd.NetworkReadBytesRequested),
        (DWORD)(ULONG_PTR)&((PRDR_COUNTER_DATA)0)->NetworkReadBytesRequested
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        276,
        0,
        277,
        0,
        -4,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_BULK_COUNT,
        sizeof (rcd.BytesTransmitted),
        (DWORD)(ULONG_PTR)&((PRDR_COUNTER_DATA)0)->BytesTransmitted
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        278,
        0,
        279,
        0,
        -1,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_BULK_COUNT,
        sizeof (rcd.SmbsTransmitted),
        (DWORD)(ULONG_PTR)&((PRDR_COUNTER_DATA)0)->SmbsTransmitted
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        280,
        0,
        281,
        0,
        -4,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_BULK_COUNT,
        sizeof (rcd.PagingReadBytesRequested),
        (DWORD)(ULONG_PTR)&((PRDR_COUNTER_DATA)0)->PagingReadBytesRequested
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        282,
        0,
        283,
        0,
        -4,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_BULK_COUNT,
        sizeof (rcd.NonPagingWriteBytesRequested),
        (DWORD)(ULONG_PTR)&((PRDR_COUNTER_DATA)0)->NonPagingWriteBytesRequested
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        284,
        0,
        285,
        0,
        -4,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_BULK_COUNT,
        sizeof (rcd.CacheWriteBytesRequested),
        (DWORD)(ULONG_PTR)&((PRDR_COUNTER_DATA)0)->CacheWriteBytesRequested
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        286,
        0,
        287,
        0,
        -4,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_BULK_COUNT,
        sizeof (rcd.NetworkWriteBytesRequested),
        (DWORD)(ULONG_PTR)&((PRDR_COUNTER_DATA)0)->NetworkWriteBytesRequested
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        10,
        0,
        289,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_COUNTER,
        sizeof (rcd.ReadOperations),
        (DWORD)(ULONG_PTR)&((PRDR_COUNTER_DATA)0)->ReadOperations
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        290,
        0,
        291,
        0,
        -1,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof (rcd.RandomReadOperations),
        (DWORD)(ULONG_PTR)&((PRDR_COUNTER_DATA)0)->RandomReadOperations
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        292,
        0,
        293,
        0,
        -1,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof (rcd.ReadSmbs),
        (DWORD)(ULONG_PTR)&((PRDR_COUNTER_DATA)0)->ReadSmbs
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        294,
        0,
        295,
        0,
        0,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_COUNTER,
        sizeof (rcd.LargeReadSmbs),
        (DWORD)(ULONG_PTR)&((PRDR_COUNTER_DATA)0)->LargeReadSmbs
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        296,
        0,
        297,
        0,
        -1,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_COUNTER,
        sizeof (rcd.SmallReadSmbs),
        (DWORD)(ULONG_PTR)&((PRDR_COUNTER_DATA)0)->SmallReadSmbs
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        12,
        0,
        299,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_COUNTER,
        sizeof (rcd.WriteOperations),
        (DWORD)(ULONG_PTR)&((PRDR_COUNTER_DATA)0)->WriteOperations
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        300,
        0,
        301,
        0,
        -1,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof (rcd.RandomWriteOperations),
        (DWORD)(ULONG_PTR)&((PRDR_COUNTER_DATA)0)->RandomWriteOperations
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        302,
        0,
        303,
        0,
        -1,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof (rcd.WriteSmbs),
        (DWORD)(ULONG_PTR)&((PRDR_COUNTER_DATA)0)->WriteSmbs
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        304,
        0,
        305,
        0,
        0,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_COUNTER,
        sizeof (rcd.LargeWriteSmbs),
        (DWORD)(ULONG_PTR)&((PRDR_COUNTER_DATA)0)->LargeWriteSmbs
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        306,
        0,
        307,
        0,
        -1,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_COUNTER,
        sizeof (rcd.SmallWriteSmbs),
        (DWORD)(ULONG_PTR)&((PRDR_COUNTER_DATA)0)->SmallWriteSmbs
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        308,
        0,
        309,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof (rcd.RawReadsDenied),
        (DWORD)(ULONG_PTR)&((PRDR_COUNTER_DATA)0)->RawReadsDenied
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        310,
        0,
        311,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof (rcd.RawWritesDenied),
        (DWORD)(ULONG_PTR)&((PRDR_COUNTER_DATA)0)->RawWritesDenied
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        312,
        0,
        313,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_COUNTER,
        sizeof (rcd.NetworkErrors),
        (DWORD)(ULONG_PTR)&((PRDR_COUNTER_DATA)0)->NetworkErrors
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        314,
        0,
        315,
        0,
        0,
        PERF_DETAIL_NOVICE,
        PERF_COUNTER_RAWCOUNT,
        sizeof (rcd.Sessions),
        (DWORD)(ULONG_PTR)&((PRDR_COUNTER_DATA)0)->Sessions
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        316,
        0,
        317,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof (rcd.Reconnects),
        (DWORD)(ULONG_PTR)&((PRDR_COUNTER_DATA)0)->Reconnects
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        318,
        0,
        319,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof (rcd.CoreConnects),
        (DWORD)(ULONG_PTR)&((PRDR_COUNTER_DATA)0)->CoreConnects
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        320,
        0,
        321,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof (rcd.Lanman20Connects),
        (DWORD)(ULONG_PTR)&((PRDR_COUNTER_DATA)0)->Lanman20Connects
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        322,
        0,
        323,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof (rcd.Lanman21Connects),
        (DWORD)(ULONG_PTR)&((PRDR_COUNTER_DATA)0)->Lanman21Connects
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        324,
        0,
        325,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof (rcd.LanmanNtConnects),
        (DWORD)(ULONG_PTR)&((PRDR_COUNTER_DATA)0)->LanmanNtConnects
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        326,
        0,
        327,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof (rcd.ServerDisconnects),
        (DWORD)(ULONG_PTR)&((PRDR_COUNTER_DATA)0)->ServerDisconnects
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        328,
        0,
        329,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof (rcd.HungSessions),
        (DWORD)(ULONG_PTR)&((PRDR_COUNTER_DATA)0)->HungSessions
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        392,
        0,
        393,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_RAWCOUNT,
        sizeof (rcd.CurrentCommands),
        (DWORD)(ULONG_PTR)&((PRDR_COUNTER_DATA)0)->CurrentCommands
    }
};

