//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// This source code is licensed under Microsoft Shared Source License
// Version 1.0 for Windows CE.
// For a copy of the license visit http://go.microsoft.com/fwlink/?LinkId=3223.
//
//+----------------------------------------------------------------------------
//
//
// File:    enwsdlop.cpp
//
// Contents:
//
//  implementation file
//
//        IEnumWSDLService  Interface implemenation
//
//-----------------------------------------------------------------------------
#include "headers.h"
#include "enwsdlse.h"

#ifdef UNDER_CE
#include "WinCEUtils.h"
#endif


BEGIN_INTERFACE_MAP(CEnumWSDLService)
    ADD_IUNKNOWN(CEnumWSDLService, IEnumWSDLService)
    ADD_INTERFACE(CEnumWSDLService, IEnumWSDLService)
END_INTERFACE_MAP(CEnumWSDLService)




/////////////////////////////////////////////////////////////////////////////




/////////////////////////////////////////////////////////////////////////////////////////////////////////
//  function: CEnumWSDLService::CEnumWSDLService()
//
//  parameters:
//
//  description:
//
//  returns:
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////
CEnumWSDLService::CEnumWSDLService()
{
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////



/////////////////////////////////////////////////////////////////////////////////////////////////////////
//  function: CEnumWSDLService::~CEnumWSDLService()
//
//  parameters:
//
//  description:
//
//  returns:
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////
CEnumWSDLService::~CEnumWSDLService()
{
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////





/////////////////////////////////////////////////////////////////////////////////////////////////////////
//  function: HRESULT CEnumWSDLService::Next(long celt, IWSDLService **ppWSDLService, long *pulFetched)
//
//  parameters:
//
//  description:
//
//
//  returns:
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////
HRESULT CEnumWSDLService::Next(long celt, IWSDLService **ppWSDLService, long *pulFetched)
{
    return(m_serviceList.Next(celt, ppWSDLService, pulFetched));
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////



/////////////////////////////////////////////////////////////////////////////////////////////////////////
//  function: HRESULT CEnumWSDLService::Skip(long celt)
//
//  parameters:
//
//  description:
//
//  returns:
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////
HRESULT CEnumWSDLService::Skip(long celt)
{
    return(m_serviceList.Skip(celt));
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////////////////////////////////
//  function: HRESULT CEnumWSDLService::Reset(void)
//
//  parameters:
//
//  description:
//
//  returns:
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////
HRESULT CEnumWSDLService::Reset(void)
{
    return(m_serviceList.Reset());
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////////////////////////////////
//  function: HRESULT CEnumWSDLService::Clone(IEnumWSDLService **ppenum)
//
//  parameters:
//
//  description:
//
//
//  returns:
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////
HRESULT CEnumWSDLService::Clone(IEnumWSDLService **ppenum)
{
    HRESULT hr = S_OK;
    CEnumWSDLService *pServices;
    pServices = new CSoapObject<CEnumWSDLService>(INITIAL_REFERENCE);
    CHK_BOOL(pServices, E_OUTOFMEMORY);
    CHK(pServices->Copy(this));
    pServices->Reset();
    *ppenum = pServices;
Cleanup:
    return (hr);
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////////////////////////////////
//  function: HRESULT CEnumWSDLService::Copy(CEnumWSDLService *pOrg)
//
//  parameters:
//
//  description:
//
//
//  returns:
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////
HRESULT CEnumWSDLService::Copy(CEnumWSDLService *pOrg)
{
    return (pOrg->m_serviceList.Clone(m_serviceList));
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////



/////////////////////////////////////////////////////////////////////////////////////////////////////////
//  function: HRESULT CEnumWSDLService::Find(BSTR bstrServiceToFind, IWSDLService **ppIWSDLService)
//
//  parameters:
//
//  description:
//
//  returns:
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////
HRESULT CEnumWSDLService::Find(BSTR bstrServiceToFind, IWSDLService **ppIWSDLService)
{
    return(m_serviceList.Find(bstrServiceToFind, ppIWSDLService));
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////




/////////////////////////////////////////////////////////////////////////////////////////////////////////
//  function: HRESULT CEnumWSDLService::Add(IWSDLService *pWSDLService)
//
//  parameters:
//
//  description:
//
//  returns:
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////
HRESULT CEnumWSDLService::Add(IWSDLService *pWSDLService)
{
    return(m_serviceList.Add(pWSDLService));
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////



/////////////////////////////////////////////////////////////////////////////////////////////////////////
//  function: HRESULT CEnumWSDLService::Size(long *pulSize)
//
//  parameters:
//
//  description:
//
//  returns:
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////
HRESULT CEnumWSDLService::Size(long *pulSize)
{
    return(m_serviceList.Size(pulSize));
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////
