//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// This source code is licensed under Microsoft Shared Source License
// Version 1.0 for Windows CE.
// For a copy of the license visit http://go.microsoft.com/fwlink/?LinkId=3223.
//
#pragma once
#include "TestIDs.h"

#include <tux.h>


TESTPROCAPI TuxTest(UINT uTuxMsg, TPPARAM tpParam, LPFUNCTION_TABLE_ENTRY lpFTE);

//
// Tux Function Table Entry
//
FUNCTION_TABLE_ENTRY g_lpFTE[] = {

//|                                              Description                                                             | Tree  | TestProc |             Unique ID for            |          |
//|                                              of Test Case                                                            | Depth |   Arg    |               test case              | TestProc |
//+----------------------------------------------------------------------------------------------------------------------+-------+----------+--------------------------------------+----------+
{ TEXT("Driver comparison tests                                                                                  "),        0,         0,                                     0,    NULL  },

//
// Culling Tests
//
{ TEXT("(CullTest) D3DMCULL_NONE Test; X-Axis Rotation Step #1                                                   "),        1,         0,             D3DMQA_CULLTEST_BASE+  0, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_NONE Test; X-Axis Rotation Step #2                                                   "),        1,         0,             D3DMQA_CULLTEST_BASE+  1, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_NONE Test; X-Axis Rotation Step #3                                                   "),        1,         0,             D3DMQA_CULLTEST_BASE+  2, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_NONE Test; X-Axis Rotation Step #4                                                   "),        1,         0,             D3DMQA_CULLTEST_BASE+  3, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_NONE Test; X-Axis Rotation Step #5                                                   "),        1,         0,             D3DMQA_CULLTEST_BASE+  4, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_NONE Test; X-Axis Rotation Step #6                                                   "),        1,         0,             D3DMQA_CULLTEST_BASE+  5, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_NONE Test; X-Axis Rotation Step #7                                                   "),        1,         0,             D3DMQA_CULLTEST_BASE+  6, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_NONE Test; X-Axis Rotation Step #8                                                   "),        1,         0,             D3DMQA_CULLTEST_BASE+  7, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_NONE Test; Y-Axis Rotation Step #1                                                   "),        1,         0,             D3DMQA_CULLTEST_BASE+  8, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_NONE Test; Y-Axis Rotation Step #2                                                   "),        1,         0,             D3DMQA_CULLTEST_BASE+  9, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_NONE Test; Y-Axis Rotation Step #3                                                   "),        1,         0,             D3DMQA_CULLTEST_BASE+ 10, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_NONE Test; Y-Axis Rotation Step #4                                                   "),        1,         0,             D3DMQA_CULLTEST_BASE+ 11, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_NONE Test; Y-Axis Rotation Step #5                                                   "),        1,         0,             D3DMQA_CULLTEST_BASE+ 12, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_NONE Test; Y-Axis Rotation Step #6                                                   "),        1,         0,             D3DMQA_CULLTEST_BASE+ 13, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_NONE Test; Y-Axis Rotation Step #7                                                   "),        1,         0,             D3DMQA_CULLTEST_BASE+ 14, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_NONE Test; Y-Axis Rotation Step #8                                                   "),        1,         0,             D3DMQA_CULLTEST_BASE+ 15, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_NONE Test; Z-Axis Rotation Step #1                                                   "),        1,         0,             D3DMQA_CULLTEST_BASE+ 16, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_NONE Test; Z-Axis Rotation Step #2                                                   "),        1,         0,             D3DMQA_CULLTEST_BASE+ 17, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_NONE Test; Z-Axis Rotation Step #3                                                   "),        1,         0,             D3DMQA_CULLTEST_BASE+ 18, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_NONE Test; Z-Axis Rotation Step #4                                                   "),        1,         0,             D3DMQA_CULLTEST_BASE+ 19, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_NONE Test; Z-Axis Rotation Step #5                                                   "),        1,         0,             D3DMQA_CULLTEST_BASE+ 20, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_NONE Test; Z-Axis Rotation Step #6                                                   "),        1,         0,             D3DMQA_CULLTEST_BASE+ 21, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_NONE Test; Z-Axis Rotation Step #7                                                   "),        1,         0,             D3DMQA_CULLTEST_BASE+ 22, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_NONE Test; Z-Axis Rotation Step #8                                                   "),        1,         0,             D3DMQA_CULLTEST_BASE+ 23, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_CW Test; X-Axis Rotation Step #1                                                     "),        1,         0,             D3DMQA_CULLTEST_BASE+ 24, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_CW Test; X-Axis Rotation Step #2                                                     "),        1,         0,             D3DMQA_CULLTEST_BASE+ 25, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_CW Test; X-Axis Rotation Step #3                                                     "),        1,         0,             D3DMQA_CULLTEST_BASE+ 26, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_CW Test; X-Axis Rotation Step #4                                                     "),        1,         0,             D3DMQA_CULLTEST_BASE+ 27, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_CW Test; X-Axis Rotation Step #5                                                     "),        1,         0,             D3DMQA_CULLTEST_BASE+ 28, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_CW Test; X-Axis Rotation Step #6                                                     "),        1,         0,             D3DMQA_CULLTEST_BASE+ 29, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_CW Test; X-Axis Rotation Step #7                                                     "),        1,         0,             D3DMQA_CULLTEST_BASE+ 30, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_CW Test; X-Axis Rotation Step #8                                                     "),        1,         0,             D3DMQA_CULLTEST_BASE+ 31, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_CW Test; Y-Axis Rotation Step #1                                                     "),        1,         0,             D3DMQA_CULLTEST_BASE+ 32, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_CW Test; Y-Axis Rotation Step #2                                                     "),        1,         0,             D3DMQA_CULLTEST_BASE+ 33, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_CW Test; Y-Axis Rotation Step #3                                                     "),        1,         0,             D3DMQA_CULLTEST_BASE+ 34, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_CW Test; Y-Axis Rotation Step #4                                                     "),        1,         0,             D3DMQA_CULLTEST_BASE+ 35, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_CW Test; Y-Axis Rotation Step #5                                                     "),        1,         0,             D3DMQA_CULLTEST_BASE+ 36, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_CW Test; Y-Axis Rotation Step #6                                                     "),        1,         0,             D3DMQA_CULLTEST_BASE+ 37, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_CW Test; Y-Axis Rotation Step #7                                                     "),        1,         0,             D3DMQA_CULLTEST_BASE+ 38, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_CW Test; Y-Axis Rotation Step #8                                                     "),        1,         0,             D3DMQA_CULLTEST_BASE+ 39, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_CW Test; Z-Axis Rotation Step #1                                                     "),        1,         0,             D3DMQA_CULLTEST_BASE+ 40, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_CW Test; Z-Axis Rotation Step #2                                                     "),        1,         0,             D3DMQA_CULLTEST_BASE+ 41, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_CW Test; Z-Axis Rotation Step #3                                                     "),        1,         0,             D3DMQA_CULLTEST_BASE+ 42, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_CW Test; Z-Axis Rotation Step #4                                                     "),        1,         0,             D3DMQA_CULLTEST_BASE+ 43, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_CW Test; Z-Axis Rotation Step #5                                                     "),        1,         0,             D3DMQA_CULLTEST_BASE+ 44, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_CW Test; Z-Axis Rotation Step #6                                                     "),        1,         0,             D3DMQA_CULLTEST_BASE+ 45, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_CW Test; Z-Axis Rotation Step #7                                                     "),        1,         0,             D3DMQA_CULLTEST_BASE+ 46, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_CW Test; Z-Axis Rotation Step #8                                                     "),        1,         0,             D3DMQA_CULLTEST_BASE+ 47, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_CCW Test; X-Axis Rotation Step #1                                                    "),        1,         0,             D3DMQA_CULLTEST_BASE+ 48, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_CCW Test; X-Axis Rotation Step #2                                                    "),        1,         0,             D3DMQA_CULLTEST_BASE+ 49, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_CCW Test; X-Axis Rotation Step #3                                                    "),        1,         0,             D3DMQA_CULLTEST_BASE+ 50, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_CCW Test; X-Axis Rotation Step #4                                                    "),        1,         0,             D3DMQA_CULLTEST_BASE+ 51, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_CCW Test; X-Axis Rotation Step #5                                                    "),        1,         0,             D3DMQA_CULLTEST_BASE+ 52, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_CCW Test; X-Axis Rotation Step #6                                                    "),        1,         0,             D3DMQA_CULLTEST_BASE+ 53, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_CCW Test; X-Axis Rotation Step #7                                                    "),        1,         0,             D3DMQA_CULLTEST_BASE+ 54, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_CCW Test; X-Axis Rotation Step #8                                                    "),        1,         0,             D3DMQA_CULLTEST_BASE+ 55, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_CCW Test; Y-Axis Rotation Step #1                                                    "),        1,         0,             D3DMQA_CULLTEST_BASE+ 56, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_CCW Test; Y-Axis Rotation Step #2                                                    "),        1,         0,             D3DMQA_CULLTEST_BASE+ 57, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_CCW Test; Y-Axis Rotation Step #3                                                    "),        1,         0,             D3DMQA_CULLTEST_BASE+ 58, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_CCW Test; Y-Axis Rotation Step #4                                                    "),        1,         0,             D3DMQA_CULLTEST_BASE+ 59, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_CCW Test; Y-Axis Rotation Step #5                                                    "),        1,         0,             D3DMQA_CULLTEST_BASE+ 60, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_CCW Test; Y-Axis Rotation Step #6                                                    "),        1,         0,             D3DMQA_CULLTEST_BASE+ 61, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_CCW Test; Y-Axis Rotation Step #7                                                    "),        1,         0,             D3DMQA_CULLTEST_BASE+ 62, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_CCW Test; Y-Axis Rotation Step #8                                                    "),        1,         0,             D3DMQA_CULLTEST_BASE+ 63, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_CCW Test; Z-Axis Rotation Step #1                                                    "),        1,         0,             D3DMQA_CULLTEST_BASE+ 64, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_CCW Test; Z-Axis Rotation Step #2                                                    "),        1,         0,             D3DMQA_CULLTEST_BASE+ 65, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_CCW Test; Z-Axis Rotation Step #3                                                    "),        1,         0,             D3DMQA_CULLTEST_BASE+ 66, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_CCW Test; Z-Axis Rotation Step #4                                                    "),        1,         0,             D3DMQA_CULLTEST_BASE+ 67, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_CCW Test; Z-Axis Rotation Step #5                                                    "),        1,         0,             D3DMQA_CULLTEST_BASE+ 68, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_CCW Test; Z-Axis Rotation Step #6                                                    "),        1,         0,             D3DMQA_CULLTEST_BASE+ 69, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_CCW Test; Z-Axis Rotation Step #7                                                    "),        1,         0,             D3DMQA_CULLTEST_BASE+ 70, TuxTest  },
{ TEXT("(CullTest) D3DMCULL_CCW Test; Z-Axis Rotation Step #8                                                    "),        1,         0,             D3DMQA_CULLTEST_BASE+ 71, TuxTest  },
//                                                                       
// Lighting tests
//
{ TEXT("(LightTest) D3DMRS_LIGHTING==FALSE Test                                                                  "),        1,         0,            D3DMQA_LIGHTTEST_BASE+  0, TuxTest  },
{ TEXT("(LightTest) D3DMRS_COLORVERTEX==FALSE Diffuse Test                                                       "),        1,         0,            D3DMQA_LIGHTTEST_BASE+  1, TuxTest  },
{ TEXT("(LightTest) D3DMRS_COLORVERTEX==FALSE Specular Test                                                      "),        1,         0,            D3DMQA_LIGHTTEST_BASE+  2, TuxTest  },
{ TEXT("(LightTest) D3DMRS_COLORVERTEX==FALSE Ambient Test                                                       "),        1,         0,            D3DMQA_LIGHTTEST_BASE+  3, TuxTest  },
{ TEXT("(LightTest) D3DMRS_AMBIENTMATERIALSOURCE==D3DMMCS_COLOR1 Test                                            "),        1,         0,            D3DMQA_LIGHTTEST_BASE+  4, TuxTest  },
{ TEXT("(LightTest) D3DMRS_AMBIENTMATERIALSOURCE==D3DMMCS_COLOR2 Test                                            "),        1,         0,            D3DMQA_LIGHTTEST_BASE+  5, TuxTest  },
{ TEXT("(LightTest) D3DMRS_AMBIENTMATERIALSOURCE==D3DMMCS_MATERIAL Test                                          "),        1,         0,            D3DMQA_LIGHTTEST_BASE+  6, TuxTest  },
{ TEXT("(LightTest) D3DMRS_DIFFUSEMATERIALSOURCE==D3DMMCS_COLOR1 Test                                            "),        1,         0,            D3DMQA_LIGHTTEST_BASE+  7, TuxTest  },
{ TEXT("(LightTest) D3DMRS_DIFFUSEMATERIALSOURCE==D3DMMCS_COLOR2 Test                                            "),        1,         0,            D3DMQA_LIGHTTEST_BASE+  8, TuxTest  },
{ TEXT("(LightTest) D3DMRS_DIFFUSEMATERIALSOURCE==D3DMMCS_MATERIAL Test                                          "),        1,         0,            D3DMQA_LIGHTTEST_BASE+  9, TuxTest  },
{ TEXT("(LightTest) D3DMRS_SPECULARMATERIALSOURCE==D3DMMCS_COLOR1 Test (D3DMRS_SPECULARENABLE==FALSE)            "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 10, TuxTest  },
{ TEXT("(LightTest) D3DMRS_SPECULARMATERIALSOURCE==D3DMMCS_COLOR2 Test (D3DMRS_SPECULARENABLE==FALSE)            "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 11, TuxTest  },
{ TEXT("(LightTest) D3DMRS_SPECULARMATERIALSOURCE==D3DMMCS_MATERIAL Test (D3DMRS_SPECULARENABLE==FALSE)          "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 12, TuxTest  },
{ TEXT("(LightTest) D3DMRS_SPECULARMATERIALSOURCE==D3DMMCS_COLOR1 Test (D3DMRS_SPECULARENABLE==TRUE)             "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 13, TuxTest  },
{ TEXT("(LightTest) D3DMRS_SPECULARMATERIALSOURCE==D3DMMCS_COLOR2 Test (D3DMRS_SPECULARENABLE==TRUE)             "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 14, TuxTest  },
{ TEXT("(LightTest) D3DMRS_SPECULARMATERIALSOURCE==D3DMMCS_MATERIAL Test (D3DMRS_SPECULARENABLE==TRUE)           "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 15, TuxTest  },
{ TEXT("(LightTest) Ambient Lighting Test (mult between Ca and Ga)                                               "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 16, TuxTest  },
{ TEXT("(LightTest) Ambient Lighting Test (add between Ga and Lai)                                               "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 17, TuxTest  },
{ TEXT("(LightTest) Specular Lighting Halfway Vector Basic Test (D3DMRS_LOCALVIEWER==FALSE)                      "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 18, TuxTest  },
{ TEXT("(LightTest) Specular Lighting Halfway Vector Basic Test (D3DMRS_LOCALVIEWER==TRUE)                       "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 19, TuxTest  },
{ TEXT("(LightTest) Specular Lighting Directional Light Test (D3DMRS_LOCALVIEWER==FALSE): Direction Vector #1    "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 20, TuxTest  },
{ TEXT("(LightTest) Specular Lighting Directional Light Test (D3DMRS_LOCALVIEWER==FALSE): Direction Vector #2    "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 21, TuxTest  },
{ TEXT("(LightTest) Specular Lighting Directional Light Test (D3DMRS_LOCALVIEWER==FALSE): Direction Vector #3    "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 22, TuxTest  },
{ TEXT("(LightTest) Specular Lighting Directional Light Test (D3DMRS_LOCALVIEWER==FALSE): Direction Vector #4    "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 23, TuxTest  },
{ TEXT("(LightTest) Specular Lighting Directional Light Test (D3DMRS_LOCALVIEWER==FALSE): Direction Vector #5    "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 24, TuxTest  },
{ TEXT("(LightTest) Specular Lighting Directional Light Test (D3DMRS_LOCALVIEWER==FALSE): Direction Vector #6    "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 25, TuxTest  },
{ TEXT("(LightTest) Specular Lighting Directional Light Test (D3DMRS_LOCALVIEWER==FALSE): Direction Vector #7    "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 26, TuxTest  },
{ TEXT("(LightTest) Specular Lighting Directional Light Test (D3DMRS_LOCALVIEWER==TRUE): Direction Vector #1     "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 27, TuxTest  },
{ TEXT("(LightTest) Specular Lighting Directional Light Test (D3DMRS_LOCALVIEWER==TRUE): Direction Vector #2     "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 28, TuxTest  },
{ TEXT("(LightTest) Specular Lighting Directional Light Test (D3DMRS_LOCALVIEWER==TRUE): Direction Vector #3     "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 29, TuxTest  },
{ TEXT("(LightTest) Specular Lighting Directional Light Test (D3DMRS_LOCALVIEWER==TRUE): Direction Vector #4     "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 30, TuxTest  },
{ TEXT("(LightTest) Specular Lighting Directional Light Test (D3DMRS_LOCALVIEWER==TRUE): Direction Vector #5     "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 31, TuxTest  },
{ TEXT("(LightTest) Specular Lighting Directional Light Test (D3DMRS_LOCALVIEWER==TRUE): Direction Vector #6     "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 32, TuxTest  },
{ TEXT("(LightTest) Specular Lighting Directional Light Test (D3DMRS_LOCALVIEWER==TRUE): Direction Vector #7     "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 33, TuxTest  },
{ TEXT("(LightTest) Specular Lighting Directional Light Test (D3DMLIGHT.Specular==Red)                           "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 34, TuxTest  },
{ TEXT("(LightTest) Specular Lighting Directional Light Test (D3DMLIGHT.Specular==Green)                         "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 35, TuxTest  },
{ TEXT("(LightTest) Specular Lighting Directional Light Test (D3DMLIGHT.Specular==Blue)                          "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 36, TuxTest  },
{ TEXT("(LightTest) Specular Lighting Directional Light Vector Length Test (short)                               "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 37, TuxTest  },
{ TEXT("(LightTest) Specular Lighting Directional Light Vector Length Test (normalized)                          "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 38, TuxTest  },
{ TEXT("(LightTest) Specular Lighting Directional Light Vector Length Test (long)                                "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 39, TuxTest  },
{ TEXT("(LightTest) Specular Lighting Directional Light Test (Material Power == 0.0f)                            "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 40, TuxTest  },
{ TEXT("(LightTest) Specular Lighting Directional Light Test (Material Power == 0.5f)                            "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 41, TuxTest  },
{ TEXT("(LightTest) Specular Lighting Directional Light Test (Material Power == 1.0f)                            "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 42, TuxTest  },
{ TEXT("(LightTest) Specular Lighting Directional Light Test (Material Power == 2.0f)                            "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 43, TuxTest  },
{ TEXT("(LightTest) Specular Lighting Directional Light Test (Material Power == 10.0f)                           "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 44, TuxTest  },
{ TEXT("(LightTest) Specular Lighting Point Light Test; D3DMLIGHT.Position #1                                    "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 45, TuxTest  },
{ TEXT("(LightTest) Specular Lighting Point Light Test; D3DMLIGHT.Position #2                                    "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 46, TuxTest  },
{ TEXT("(LightTest) Specular Lighting Point Light Test; D3DMLIGHT.Position #3                                    "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 47, TuxTest  },
{ TEXT("(LightTest) Specular Lighting Point Light Test; D3DMLIGHT.Position #4                                    "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 48, TuxTest  },
{ TEXT("(LightTest) Specular Lighting Point Light Test; D3DMLIGHT.Position #5                                    "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 49, TuxTest  },
{ TEXT("(LightTest) Specular Lighting Point Light Test; D3DMLIGHT.Range == 1.0f                                  "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 50, TuxTest  },
{ TEXT("(LightTest) Specular Lighting Point Light Test; D3DMLIGHT.Range == 2.0f                                  "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 51, TuxTest  },
{ TEXT("(LightTest) Specular Lighting Point Light Test; D3DMLIGHT.Range == 3.0f                                  "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 52, TuxTest  },
{ TEXT("(LightTest) Specular Lighting Point Light Test; D3DMLIGHT.Range == 4.0f                                  "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 53, TuxTest  },
{ TEXT("(LightTest) Specular Lighting Point Light Test; D3DMLIGHT.Range == 5.0f                                  "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 54, TuxTest  },
{ TEXT("(LightTest) Specular Lighting Point Light Test; constant attenuation (Attenuation0)                      "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 55, TuxTest  },
{ TEXT("(LightTest) Specular Lighting Point Light Test; linear attenuation (Attenuation1)                        "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 56, TuxTest  },
{ TEXT("(LightTest) Specular Lighting Point Light Test; quadratic attenuation (Attenuation2)                     "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 57, TuxTest  },
{ TEXT("(LightTest) Diffuse Lighting Directional Light Test: Direction Vector #1                                 "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 58, TuxTest  },
{ TEXT("(LightTest) Diffuse Lighting Directional Light Test: Direction Vector #2                                 "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 59, TuxTest  },
{ TEXT("(LightTest) Diffuse Lighting Directional Light Test: Direction Vector #3                                 "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 60, TuxTest  },
{ TEXT("(LightTest) Diffuse Lighting Directional Light Test: Direction Vector #4                                 "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 61, TuxTest  },
{ TEXT("(LightTest) Diffuse Lighting Directional Light Test: Direction Vector #5                                 "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 62, TuxTest  },
{ TEXT("(LightTest) Diffuse Lighting Directional Light Test: Direction Vector #6                                 "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 63, TuxTest  },
{ TEXT("(LightTest) Diffuse Lighting Directional Light Test: Direction Vector #7                                 "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 64, TuxTest  },
{ TEXT("(LightTest) Diffuse Lighting Directional Light Test (D3DMLIGHT.Diffuse==Red)                             "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 65, TuxTest  },
{ TEXT("(LightTest) Diffuse Lighting Directional Light Test (D3DMLIGHT.Diffuse==Green)                           "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 66, TuxTest  },
{ TEXT("(LightTest) Diffuse Lighting Directional Light Test (D3DMLIGHT.Diffuse==Blue)                            "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 67, TuxTest  },
{ TEXT("(LightTest) Diffuse Lighting Directional Light Vector Length Test (short)                                "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 68, TuxTest  },
{ TEXT("(LightTest) Diffuse Lighting Directional Light Vector Length Test (normalized)                           "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 69, TuxTest  },
{ TEXT("(LightTest) Diffuse Lighting Directional Light Vector Length Test (long)                                 "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 70, TuxTest  },
{ TEXT("(LightTest) Diffuse Lighting Point Light Test; D3DMLIGHT.Position #1                                     "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 71, TuxTest  },
{ TEXT("(LightTest) Diffuse Lighting Point Light Test; D3DMLIGHT.Position #2                                     "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 72, TuxTest  },
{ TEXT("(LightTest) Diffuse Lighting Point Light Test; D3DMLIGHT.Position #3                                     "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 73, TuxTest  },
{ TEXT("(LightTest) Diffuse Lighting Point Light Test; D3DMLIGHT.Position #4                                     "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 74, TuxTest  },
{ TEXT("(LightTest) Diffuse Lighting Point Light Test; D3DMLIGHT.Position #5                                     "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 75, TuxTest  },
{ TEXT("(LightTest) Diffuse Lighting Point Light Test; D3DMLIGHT.Range == 5.0f                                   "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 76, TuxTest  },
{ TEXT("(LightTest) Diffuse Lighting Point Light Test; D3DMLIGHT.Range == 5.5f                                   "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 77, TuxTest  },
{ TEXT("(LightTest) Diffuse Lighting Point Light Test; D3DMLIGHT.Range == 6.0f                                   "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 78, TuxTest  },
{ TEXT("(LightTest) Diffuse Lighting Point Light Test; D3DMLIGHT.Range == 6.5f                                   "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 79, TuxTest  },
{ TEXT("(LightTest) Diffuse Lighting Point Light Test; D3DMLIGHT.Range == 7.0f                                   "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 80, TuxTest  },
{ TEXT("(LightTest) Diffuse Lighting Point Light Test; constant attenuation (Attenuation0)                       "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 81, TuxTest  },
{ TEXT("(LightTest) Diffuse Lighting Point Light Test; linear attenuation (Attenuation1)                         "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 82, TuxTest  },
{ TEXT("(LightTest) Diffuse Lighting Point Light Test; quadratic attenuation (Attenuation2)                      "),        1,         0,            D3DMQA_LIGHTTEST_BASE+ 83, TuxTest  },

//
// Depth Buffer Test Cases
//
{ TEXT("(DepthBufferTest) D3DMCLEAR_ZBUFFER Test (Depth #1)                                                      "),        1,         0,         D3DMQA_DEPTHBUFTEST_BASE+  0, TuxTest  },
{ TEXT("(DepthBufferTest) D3DMCLEAR_ZBUFFER Test (Depth #2)                                                      "),        1,         0,         D3DMQA_DEPTHBUFTEST_BASE+  1, TuxTest  },
{ TEXT("(DepthBufferTest) D3DMCLEAR_ZBUFFER Test (Depth #3)                                                      "),        1,         0,         D3DMQA_DEPTHBUFTEST_BASE+  2, TuxTest  },
{ TEXT("(DepthBufferTest) D3DMCLEAR_ZBUFFER Test (Depth #4)                                                      "),        1,         0,         D3DMQA_DEPTHBUFTEST_BASE+  3, TuxTest  },
{ TEXT("(DepthBufferTest) D3DMCLEAR_ZBUFFER Test (Depth #5)                                                      "),        1,         0,         D3DMQA_DEPTHBUFTEST_BASE+  4, TuxTest  },
{ TEXT("(DepthBufferTest) D3DMCLEAR_ZBUFFER Test (Depth #6)                                                      "),        1,         0,         D3DMQA_DEPTHBUFTEST_BASE+  5, TuxTest  },
{ TEXT("(DepthBufferTest) D3DMCLEAR_ZBUFFER Test (Depth #7)                                                      "),        1,         0,         D3DMQA_DEPTHBUFTEST_BASE+  6, TuxTest  },
{ TEXT("(DepthBufferTest) D3DMCLEAR_ZBUFFER Test (Depth #8)                                                      "),        1,         0,         D3DMQA_DEPTHBUFTEST_BASE+  7, TuxTest  },
{ TEXT("(DepthBufferTest) D3DMCLEAR_ZBUFFER Test (Depth #9)                                                      "),        1,         0,         D3DMQA_DEPTHBUFTEST_BASE+  8, TuxTest  },
{ TEXT("(DepthBufferTest) D3DMCLEAR_ZBUFFER Test (Depth #10)                                                     "),        1,         0,         D3DMQA_DEPTHBUFTEST_BASE+  9, TuxTest  },
{ TEXT("(DepthBufferTest) D3DMCLEAR_ZBUFFER Test (Depth #11)                                                     "),        1,         0,         D3DMQA_DEPTHBUFTEST_BASE+ 10, TuxTest  },
{ TEXT("(DepthBufferTest) D3DMRS_ZFUNC Test (D3DMCMP_LESSEQUAL)                                                  "),        1,         0,         D3DMQA_DEPTHBUFTEST_BASE+ 11, TuxTest  },
{ TEXT("(DepthBufferTest) D3DMRS_ZFUNC Test (D3DMCMP_NEVER)                                                      "),        1,         0,         D3DMQA_DEPTHBUFTEST_BASE+ 12, TuxTest  },
{ TEXT("(DepthBufferTest) D3DMRS_ZFUNC Test (D3DMCMP_LESS)                                                       "),        1,         0,         D3DMQA_DEPTHBUFTEST_BASE+ 13, TuxTest  },
{ TEXT("(DepthBufferTest) D3DMRS_ZFUNC Test (D3DMCMP_EQUAL)                                                      "),        1,         0,         D3DMQA_DEPTHBUFTEST_BASE+ 14, TuxTest  },
{ TEXT("(DepthBufferTest) D3DMRS_ZFUNC Test (D3DMCMP_LESSEQUAL)                                                  "),        1,         0,         D3DMQA_DEPTHBUFTEST_BASE+ 15, TuxTest  },
{ TEXT("(DepthBufferTest) D3DMRS_ZFUNC Test (D3DMCMP_GREATER)                                                    "),        1,         0,         D3DMQA_DEPTHBUFTEST_BASE+ 16, TuxTest  },
{ TEXT("(DepthBufferTest) D3DMRS_ZFUNC Test (D3DMCMP_NOTEQUAL)                                                   "),        1,         0,         D3DMQA_DEPTHBUFTEST_BASE+ 17, TuxTest  },
{ TEXT("(DepthBufferTest) D3DMRS_ZFUNC Test (D3DMCMP_GREATEREQUAL)                                               "),        1,         0,         D3DMQA_DEPTHBUFTEST_BASE+ 18, TuxTest  },
{ TEXT("(DepthBufferTest) D3DMRS_ZFUNC Test (D3DMCMP_ALWAYS)                                                     "),        1,         0,         D3DMQA_DEPTHBUFTEST_BASE+ 19, TuxTest  },
{ TEXT("(DepthBufferTest) D3DMRS_ZENABLE Test (D3DMZB_FALSE)                                                     "),        1,         0,         D3DMQA_DEPTHBUFTEST_BASE+ 20, TuxTest  },
{ TEXT("(DepthBufferTest) D3DMRS_ZWRITEENABLE Test (FALSE)                                                       "),        1,         0,         D3DMQA_DEPTHBUFTEST_BASE+ 21, TuxTest  },
                 
//
// Primitive rasterization test
//

{ TEXT("(PrimRastTest) DrawPrim(D3DMPT_POINTLIST)                                                                "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+  0,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(D3DMPT_LINELIST)                                                                 "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+  1,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(D3DMPT_LINESTRIP)                                                                "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+  2,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(D3DMPT_TRIANGLELIST)                                                             "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+  3,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(D3DMPT_TRIANGLESTRIP)                                                            "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+  4,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(D3DMPT_TRIANGLEFAN)                                                              "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+  5,   TuxTest },
{ TEXT("(PrimRastTest) DrawIndexedPrim(D3DMPT_POINTLIST)                                                         "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+  6,   TuxTest },
{ TEXT("(PrimRastTest) DrawIndexedPrim(D3DMPT_LINELIST)                                                          "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+  7,   TuxTest },
{ TEXT("(PrimRastTest) DrawIndexedPrim(D3DMPT_LINESTRIP)                                                         "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+  8,   TuxTest },
{ TEXT("(PrimRastTest) DrawIndexedPrim(D3DMPT_TRIANGLELIST)                                                      "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+  9,   TuxTest },
{ TEXT("(PrimRastTest) DrawIndexedPrim(D3DMPT_TRIANGLESTRIP)                                                     "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 10,   TuxTest },
{ TEXT("(PrimRastTest) DrawIndexedPrim(D3DMPT_TRIANGLEFAN)                                                       "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 11,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(Partial D3DMPT_POINTLIST)                                                        "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 12,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(Partial D3DMPT_LINELIST)                                                         "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 13,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(Partial D3DMPT_LINESTRIP)                                                        "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 14,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(Partial D3DMPT_TRIANGLELIST)                                                     "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 15,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(Partial D3DMPT_TRIANGLESTRIP)                                                    "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 16,   TuxTest },
{ TEXT("(PrimRastTest) DrawIndexedPrim(Partial D3DMPT_POINTLIST)                                                 "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 17,   TuxTest },
{ TEXT("(PrimRastTest) DrawIndexedPrim(Partial D3DMPT_LINELIST)                                                  "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 18,   TuxTest },
{ TEXT("(PrimRastTest) DrawIndexedPrim(Partial D3DMPT_LINESTRIP)                                                 "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 19,   TuxTest },
{ TEXT("(PrimRastTest) DrawIndexedPrim(Partial D3DMPT_TRIANGLELIST)                                              "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 20,   TuxTest },
{ TEXT("(PrimRastTest) DrawIndexedPrim(Partial D3DMPT_TRIANGLESTRIP)                                             "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 21,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(D3DMPT_POINTLIST,     Write: R                                                   "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 22,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(D3DMPT_LINELIST,      Write: R                                                   "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 23,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(D3DMPT_LINESTRIP,     Write: R                                                   "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 24,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(D3DMPT_TRIANGLELIST,  Write: R                                                   "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 25,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(D3DMPT_TRIANGLESTRIP, Write: R                                                   "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 26,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(D3DMPT_TRIANGLEFAN,   Write: R                                                   "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 27,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(D3DMPT_POINTLIST,     Write: G                                                   "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 28,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(D3DMPT_LINELIST,      Write: G                                                   "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 29,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(D3DMPT_LINESTRIP,     Write: G                                                   "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 30,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(D3DMPT_TRIANGLELIST,  Write: G                                                   "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 31,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(D3DMPT_TRIANGLESTRIP, Write: G                                                   "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 32,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(D3DMPT_TRIANGLEFAN,   Write: G                                                   "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 33,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(D3DMPT_POINTLIST,     Write: B                                                   "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 34,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(D3DMPT_LINELIST,      Write: B                                                   "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 35,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(D3DMPT_LINESTRIP,     Write: B                                                   "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 36,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(D3DMPT_TRIANGLELIST,  Write: B                                                   "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 37,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(D3DMPT_TRIANGLESTRIP, Write: B                                                   "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 38,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(D3DMPT_TRIANGLEFAN,   Write: B                                                   "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 39,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(D3DMPT_POINTLIST,     Write: RG                                                  "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 40,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(D3DMPT_LINELIST,      Write: RG                                                  "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 41,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(D3DMPT_LINESTRIP,     Write: RG                                                  "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 42,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(D3DMPT_TRIANGLELIST,  Write: RG                                                  "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 43,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(D3DMPT_TRIANGLESTRIP, Write: RG                                                  "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 44,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(D3DMPT_TRIANGLEFAN,   Write: RG                                                  "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 45,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(D3DMPT_POINTLIST,     Write: RB                                                  "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 46,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(D3DMPT_LINELIST,      Write: RB                                                  "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 47,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(D3DMPT_LINESTRIP,     Write: RB                                                  "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 48,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(D3DMPT_TRIANGLELIST,  Write: RB                                                  "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 49,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(D3DMPT_TRIANGLESTRIP, Write: RB                                                  "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 50,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(D3DMPT_TRIANGLEFAN,   Write: RB                                                  "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 51,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(D3DMPT_POINTLIST,     Write: GB                                                  "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 52,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(D3DMPT_LINELIST,      Write: GB                                                  "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 53,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(D3DMPT_LINESTRIP,     Write: GB                                                  "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 54,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(D3DMPT_TRIANGLELIST,  Write: GB                                                  "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 55,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(D3DMPT_TRIANGLESTRIP, Write: GB                                                  "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 56,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(D3DMPT_TRIANGLEFAN,   Write: GB                                                  "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 57,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(Point Fill D3DMPT_POINTLIST)                                                     "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 58,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(Point Fill D3DMPT_LINELIST)                                                      "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 59,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(Point Fill D3DMPT_LINESTRIP)                                                     "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 60,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(Point Fill D3DMPT_TRIANGLELIST)                                                  "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 61,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(Point Fill D3DMPT_TRIANGLESTRIP)                                                 "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 62,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(Point Fill D3DMPT_TRIANGLEFAN)                                                   "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 63,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(Wire Fill D3DMPT_POINTLIST)                                                      "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 64,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(Wire Fill D3DMPT_LINELIST)                                                       "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 65,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(Wire Fill D3DMPT_LINESTRIP)                                                      "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 66,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(Wire Fill D3DMPT_TRIANGLELIST)                                                   "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 67,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(Wire Fill D3DMPT_TRIANGLESTRIP)                                                  "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 68,   TuxTest },
{ TEXT("(PrimRastTest) DrawPrim(Wire Fill D3DMPT_TRIANGLEFAN)                                                    "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 69,   TuxTest },
{ TEXT("(PrimRastTest) Fixed Point DrawPrim(D3DMPT_POINTLIST)                                                    "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 70,   TuxTest },
{ TEXT("(PrimRastTest) Fixed Point DrawPrim(D3DMPT_LINELIST)                                                     "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 71,   TuxTest },
{ TEXT("(PrimRastTest) Fixed Point DrawPrim(D3DMPT_LINESTRIP)                                                    "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 72,   TuxTest },
{ TEXT("(PrimRastTest) Fixed Point DrawPrim(D3DMPT_TRIANGLELIST)                                                 "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 73,   TuxTest },
{ TEXT("(PrimRastTest) Fixed Point DrawPrim(D3DMPT_TRIANGLESTRIP)                                                "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 74,   TuxTest },
{ TEXT("(PrimRastTest) Fixed Point DrawPrim(D3DMPT_TRIANGLEFAN)                                                  "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 75,   TuxTest },
{ TEXT("(PrimRastTest) Fixed Point DrawIndexedPrim(D3DMPT_POINTLIST)                                             "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 76,   TuxTest },
{ TEXT("(PrimRastTest) Fixed Point DrawIndexedPrim(D3DMPT_LINELIST)                                              "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 77,   TuxTest },
{ TEXT("(PrimRastTest) Fixed Point DrawIndexedPrim(D3DMPT_LINESTRIP)                                             "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 78,   TuxTest },
{ TEXT("(PrimRastTest) Fixed Point DrawIndexedPrim(D3DMPT_TRIANGLELIST)                                          "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 79,   TuxTest },
{ TEXT("(PrimRastTest) Fixed Point DrawIndexedPrim(D3DMPT_TRIANGLESTRIP)                                         "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 80,   TuxTest },
{ TEXT("(PrimRastTest) Fixed Point DrawIndexedPrim(D3DMPT_TRIANGLEFAN)                                           "),        1,         0,        D3DMQA_PRIMRASTTEST_BASE+ 81,   TuxTest },

{ TEXT("(ClipTest) Triangle Clip: Left Frustum Plane;   FVF: Diffuse;       Shade:  Gouraud;  Fill:  Solid       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+  0  ,   TuxTest },    
{ TEXT("(ClipTest) Triangle Clip: Right Frustum Plane;  FVF: Diffuse;       Shade:  Gouraud;  Fill:  Solid       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+  1  ,   TuxTest },             
{ TEXT("(ClipTest) Triangle Clip: Top Frustum Plane;    FVF: Diffuse;       Shade:  Gouraud;  Fill:  Solid       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+  2  ,   TuxTest },         
{ TEXT("(ClipTest) Triangle Clip: Bottom Frustum Plane; FVF: Diffuse;       Shade:  Gouraud;  Fill:  Solid       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+  3  ,   TuxTest },         
{ TEXT("(ClipTest) Triangle Clip: Near Frustum Plane;   FVF: Diffuse;       Shade:  Gouraud;  Fill:  Solid       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+  4  ,   TuxTest },         
{ TEXT("(ClipTest) Triangle Clip: Far Frustum Plane;    FVF: Diffuse;       Shade:  Gouraud;  Fill:  Solid       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+  5  ,   TuxTest },         
{ TEXT("(ClipTest) Triangle Clip: Left Frustum Plane;   FVF: Diffuse+Spec;  Shade:  Gouraud;  Fill:  Solid       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+  6  ,   TuxTest },         
{ TEXT("(ClipTest) Triangle Clip: Right Frustum Plane;  FVF: Diffuse+Spec;  Shade:  Gouraud;  Fill:  Solid       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+  7  ,   TuxTest },         
{ TEXT("(ClipTest) Triangle Clip: Top Frustum Plane;    FVF: Diffuse+Spec;  Shade:  Gouraud;  Fill:  Solid       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+  8  ,   TuxTest },         
{ TEXT("(ClipTest) Triangle Clip: Bottom Frustum Plane; FVF: Diffuse+Spec;  Shade:  Gouraud;  Fill:  Solid       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+  9  ,   TuxTest },         
{ TEXT("(ClipTest) Triangle Clip: Near Frustum Plane;   FVF: Diffuse+Spec;  Shade:  Gouraud;  Fill:  Solid       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 10  ,   TuxTest },         
{ TEXT("(ClipTest) Triangle Clip: Far Frustum Plane;    FVF: Diffuse+Spec;  Shade:  Gouraud;  Fill:  Solid       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 11  ,   TuxTest },         
{ TEXT("(ClipTest) Triangle Clip: Left Frustum Plane;   FVF: Diffuse;       Shade:  Flat;     Fill:  Solid       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 12  ,   TuxTest },         
{ TEXT("(ClipTest) Triangle Clip: Right Frustum Plane;  FVF: Diffuse;       Shade:  Flat;     Fill:  Solid       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 13  ,   TuxTest },         
{ TEXT("(ClipTest) Triangle Clip: Top Frustum Plane;    FVF: Diffuse;       Shade:  Flat;     Fill:  Solid       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 14  ,   TuxTest },         
{ TEXT("(ClipTest) Triangle Clip: Bottom Frustum Plane; FVF: Diffuse;       Shade:  Flat;     Fill:  Solid       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 15  ,   TuxTest },         
{ TEXT("(ClipTest) Triangle Clip: Near Frustum Plane;   FVF: Diffuse;       Shade:  Flat;     Fill:  Solid       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 16  ,   TuxTest },         
{ TEXT("(ClipTest) Triangle Clip: Far Frustum Plane;    FVF: Diffuse;       Shade:  Flat;     Fill:  Solid       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 17  ,   TuxTest },         
{ TEXT("(ClipTest) Triangle Clip: Left Frustum Plane;   FVF: Diffuse+Spec;  Shade:  Flat;     Fill:  Solid       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 18  ,   TuxTest },         
{ TEXT("(ClipTest) Triangle Clip: Right Frustum Plane;  FVF: Diffuse+Spec;  Shade:  Flat;     Fill:  Solid       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 19  ,   TuxTest },         
{ TEXT("(ClipTest) Triangle Clip: Top Frustum Plane;    FVF: Diffuse+Spec;  Shade:  Flat;     Fill:  Solid       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 20  ,   TuxTest },         
{ TEXT("(ClipTest) Triangle Clip: Bottom Frustum Plane; FVF: Diffuse+Spec;  Shade:  Flat;     Fill:  Solid       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 21  ,   TuxTest },         
{ TEXT("(ClipTest) Triangle Clip: Near Frustum Plane;   FVF: Diffuse+Spec;  Shade:  Flat;     Fill:  Solid       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 22  ,   TuxTest },         
{ TEXT("(ClipTest) Triangle Clip: Far Frustum Plane;    FVF: Diffuse+Spec;  Shade:  Flat;     Fill:  Solid       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 23  ,   TuxTest },         
{ TEXT("(ClipTest) Triangle Clip: Left Frustum Plane;   FVF: Diffuse;       Shade:  Gouraud;  Fill:  Line        "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 24  ,   TuxTest },         
{ TEXT("(ClipTest) Triangle Clip: Right Frustum Plane;  FVF: Diffuse;       Shade:  Gouraud;  Fill:  Line        "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 25  ,   TuxTest },         
{ TEXT("(ClipTest) Triangle Clip: Top Frustum Plane;    FVF: Diffuse;       Shade:  Gouraud;  Fill:  Line        "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 26  ,   TuxTest },         
{ TEXT("(ClipTest) Triangle Clip: Bottom Frustum Plane; FVF: Diffuse;       Shade:  Gouraud;  Fill:  Line        "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 27  ,   TuxTest },         
{ TEXT("(ClipTest) Triangle Clip: Near Frustum Plane;   FVF: Diffuse;       Shade:  Gouraud;  Fill:  Line        "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 28  ,   TuxTest },         
{ TEXT("(ClipTest) Triangle Clip: Far Frustum Plane;    FVF: Diffuse;       Shade:  Gouraud;  Fill:  Line        "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 29  ,   TuxTest },         
{ TEXT("(ClipTest) Triangle Clip: Left Frustum Plane;   FVF: Diffuse+Spec;  Shade:  Gouraud;  Fill:  Line        "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 30  ,   TuxTest },         
{ TEXT("(ClipTest) Triangle Clip: Right Frustum Plane;  FVF: Diffuse+Spec;  Shade:  Gouraud;  Fill:  Line        "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 31  ,   TuxTest },         
{ TEXT("(ClipTest) Triangle Clip: Top Frustum Plane;    FVF: Diffuse+Spec;  Shade:  Gouraud;  Fill:  Line        "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 32  ,   TuxTest },         
{ TEXT("(ClipTest) Triangle Clip: Bottom Frustum Plane; FVF: Diffuse+Spec;  Shade:  Gouraud;  Fill:  Line        "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 33  ,   TuxTest },         
{ TEXT("(ClipTest) Triangle Clip: Near Frustum Plane;   FVF: Diffuse+Spec;  Shade:  Gouraud;  Fill:  Line        "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 34  ,   TuxTest },         
{ TEXT("(ClipTest) Triangle Clip: Far Frustum Plane;    FVF: Diffuse+Spec;  Shade:  Gouraud;  Fill:  Line        "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 35  ,   TuxTest },         
{ TEXT("(ClipTest) Triangle Clip: Left Frustum Plane;   FVF: Diffuse;       Shade:  Flat;     Fill:  Line        "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 36  ,   TuxTest },
{ TEXT("(ClipTest) Triangle Clip: Right Frustum Plane;  FVF: Diffuse;       Shade:  Flat;     Fill:  Line        "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 37  ,   TuxTest },
{ TEXT("(ClipTest) Triangle Clip: Top Frustum Plane;    FVF: Diffuse;       Shade:  Flat;     Fill:  Line        "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 38  ,   TuxTest },
{ TEXT("(ClipTest) Triangle Clip: Bottom Frustum Plane; FVF: Diffuse;       Shade:  Flat;     Fill:  Line        "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 39  ,   TuxTest },
{ TEXT("(ClipTest) Triangle Clip: Near Frustum Plane;   FVF: Diffuse;       Shade:  Flat;     Fill:  Line        "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 40  ,   TuxTest },
{ TEXT("(ClipTest) Triangle Clip: Far Frustum Plane;    FVF: Diffuse;       Shade:  Flat;     Fill:  Line        "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 41  ,   TuxTest },
{ TEXT("(ClipTest) Triangle Clip: Left Frustum Plane;   FVF: Diffuse+Spec;  Shade:  Flat;     Fill:  Line        "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 42  ,   TuxTest },
{ TEXT("(ClipTest) Triangle Clip: Right Frustum Plane;  FVF: Diffuse+Spec;  Shade:  Flat;     Fill:  Line        "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 43  ,   TuxTest },
{ TEXT("(ClipTest) Triangle Clip: Top Frustum Plane;    FVF: Diffuse+Spec;  Shade:  Flat;     Fill:  Line        "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 44  ,   TuxTest },
{ TEXT("(ClipTest) Triangle Clip: Bottom Frustum Plane; FVF: Diffuse+Spec;  Shade:  Flat;     Fill:  Line        "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 45  ,   TuxTest },
{ TEXT("(ClipTest) Triangle Clip: Near Frustum Plane;   FVF: Diffuse+Spec;  Shade:  Flat;     Fill:  Line        "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 46  ,   TuxTest },
{ TEXT("(ClipTest) Triangle Clip: Far Frustum Plane;    FVF: Diffuse+Spec;  Shade:  Flat;     Fill:  Line        "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 47  ,   TuxTest },
{ TEXT("(ClipTest) Triangle Clip: Left Frustum Plane;   FVF: Diffuse;       Shade:  Gouraud;  Fill:  Point       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 48  ,   TuxTest },
{ TEXT("(ClipTest) Triangle Clip: Right Frustum Plane;  FVF: Diffuse;       Shade:  Gouraud;  Fill:  Point       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 49  ,   TuxTest },
{ TEXT("(ClipTest) Triangle Clip: Top Frustum Plane;    FVF: Diffuse;       Shade:  Gouraud;  Fill:  Point       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 50  ,   TuxTest },
{ TEXT("(ClipTest) Triangle Clip: Bottom Frustum Plane; FVF: Diffuse;       Shade:  Gouraud;  Fill:  Point       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 51  ,   TuxTest },
{ TEXT("(ClipTest) Triangle Clip: Near Frustum Plane;   FVF: Diffuse;       Shade:  Gouraud;  Fill:  Point       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 52  ,   TuxTest },
{ TEXT("(ClipTest) Triangle Clip: Far Frustum Plane;    FVF: Diffuse;       Shade:  Gouraud;  Fill:  Point       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 53  ,   TuxTest },
{ TEXT("(ClipTest) Triangle Clip: Left Frustum Plane;   FVF: Diffuse+Spec;  Shade:  Gouraud;  Fill:  Point       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 54  ,   TuxTest },
{ TEXT("(ClipTest) Triangle Clip: Right Frustum Plane;  FVF: Diffuse+Spec;  Shade:  Gouraud;  Fill:  Point       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 55  ,   TuxTest },
{ TEXT("(ClipTest) Triangle Clip: Top Frustum Plane;    FVF: Diffuse+Spec;  Shade:  Gouraud;  Fill:  Point       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 56  ,   TuxTest },
{ TEXT("(ClipTest) Triangle Clip: Bottom Frustum Plane; FVF: Diffuse+Spec;  Shade:  Gouraud;  Fill:  Point       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 57  ,   TuxTest },
{ TEXT("(ClipTest) Triangle Clip: Near Frustum Plane;   FVF: Diffuse+Spec;  Shade:  Gouraud;  Fill:  Point       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 58  ,   TuxTest },
{ TEXT("(ClipTest) Triangle Clip: Far Frustum Plane;    FVF: Diffuse+Spec;  Shade:  Gouraud;  Fill:  Point       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 59  ,   TuxTest },
{ TEXT("(ClipTest) Triangle Clip: Left Frustum Plane;   FVF: Diffuse;       Shade:  Flat;     Fill:  Point       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 60  ,   TuxTest },
{ TEXT("(ClipTest) Triangle Clip: Right Frustum Plane;  FVF: Diffuse;       Shade:  Flat;     Fill:  Point       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 61  ,   TuxTest },
{ TEXT("(ClipTest) Triangle Clip: Top Frustum Plane;    FVF: Diffuse;       Shade:  Flat;     Fill:  Point       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 62  ,   TuxTest },
{ TEXT("(ClipTest) Triangle Clip: Bottom Frustum Plane; FVF: Diffuse;       Shade:  Flat;     Fill:  Point       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 63  ,   TuxTest },
{ TEXT("(ClipTest) Triangle Clip: Near Frustum Plane;   FVF: Diffuse;       Shade:  Flat;     Fill:  Point       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 64  ,   TuxTest },
{ TEXT("(ClipTest) Triangle Clip: Far Frustum Plane;    FVF: Diffuse;       Shade:  Flat;     Fill:  Point       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 65  ,   TuxTest },
{ TEXT("(ClipTest) Triangle Clip: Left Frustum Plane;   FVF: Diffuse+Spec;  Shade:  Flat;     Fill:  Point       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 66  ,   TuxTest },
{ TEXT("(ClipTest) Triangle Clip: Right Frustum Plane;  FVF: Diffuse+Spec;  Shade:  Flat;     Fill:  Point       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 67  ,   TuxTest },
{ TEXT("(ClipTest) Triangle Clip: Top Frustum Plane;    FVF: Diffuse+Spec;  Shade:  Flat;     Fill:  Point       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 68  ,   TuxTest },
{ TEXT("(ClipTest) Triangle Clip: Bottom Frustum Plane; FVF: Diffuse+Spec;  Shade:  Flat;     Fill:  Point       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 69  ,   TuxTest },
{ TEXT("(ClipTest) Triangle Clip: Near Frustum Plane;   FVF: Diffuse+Spec;  Shade:  Flat;     Fill:  Point       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 70  ,   TuxTest },
{ TEXT("(ClipTest) Triangle Clip: Far Frustum Plane;    FVF: Diffuse+Spec;  Shade:  Flat;     Fill:  Point       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 71  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Left Frustum Plane;       FVF: Diffuse;       Shade:  Gouraud;  Fill:  Solid       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 72  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Right Frustum Plane;      FVF: Diffuse;       Shade:  Gouraud;  Fill:  Solid       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 73  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Top Frustum Plane;        FVF: Diffuse;       Shade:  Gouraud;  Fill:  Solid       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 74  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Bottom Frustum Plane;     FVF: Diffuse;       Shade:  Gouraud;  Fill:  Solid       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 75  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Near Frustum Plane;       FVF: Diffuse;       Shade:  Gouraud;  Fill:  Solid       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 76  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Far Frustum Plane;        FVF: Diffuse;       Shade:  Gouraud;  Fill:  Solid       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 77  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Left Frustum Plane;       FVF: Diffuse+Spec;  Shade:  Gouraud;  Fill:  Solid       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 78  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Right Frustum Plane;      FVF: Diffuse+Spec;  Shade:  Gouraud;  Fill:  Solid       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 79  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Top Frustum Plane;        FVF: Diffuse+Spec;  Shade:  Gouraud;  Fill:  Solid       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 80  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Bottom Frustum Plane;     FVF: Diffuse+Spec;  Shade:  Gouraud;  Fill:  Solid       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 81  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Near Frustum Plane;       FVF: Diffuse+Spec;  Shade:  Gouraud;  Fill:  Solid       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 82  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Far Frustum Plane;        FVF: Diffuse+Spec;  Shade:  Gouraud;  Fill:  Solid       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 83  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Left Frustum Plane;       FVF: Diffuse;       Shade:  Flat;     Fill:  Solid       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 84  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Right Frustum Plane;      FVF: Diffuse;       Shade:  Flat;     Fill:  Solid       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 85  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Top Frustum Plane;        FVF: Diffuse;       Shade:  Flat;     Fill:  Solid       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 86  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Bottom Frustum Plane;     FVF: Diffuse;       Shade:  Flat;     Fill:  Solid       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 87  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Near Frustum Plane;       FVF: Diffuse;       Shade:  Flat;     Fill:  Solid       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 88  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Far Frustum Plane;        FVF: Diffuse;       Shade:  Flat;     Fill:  Solid       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 89  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Left Frustum Plane;       FVF: Diffuse+Spec;  Shade:  Flat;     Fill:  Solid       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 90  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Right Frustum Plane;      FVF: Diffuse+Spec;  Shade:  Flat;     Fill:  Solid       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 91  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Top Frustum Plane;        FVF: Diffuse+Spec;  Shade:  Flat;     Fill:  Solid       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 92  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Bottom Frustum Plane;     FVF: Diffuse+Spec;  Shade:  Flat;     Fill:  Solid       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 93  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Near Frustum Plane;       FVF: Diffuse+Spec;  Shade:  Flat;     Fill:  Solid       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 94  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Far Frustum Plane;        FVF: Diffuse+Spec;  Shade:  Flat;     Fill:  Solid       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 95  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Left Frustum Plane;       FVF: Diffuse;       Shade:  Gouraud;  Fill:  Line        "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 96  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Right Frustum Plane;      FVF: Diffuse;       Shade:  Gouraud;  Fill:  Line        "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 97  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Top Frustum Plane;        FVF: Diffuse;       Shade:  Gouraud;  Fill:  Line        "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 98  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Bottom Frustum Plane;     FVF: Diffuse;       Shade:  Gouraud;  Fill:  Line        "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+ 99  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Near Frustum Plane;       FVF: Diffuse;       Shade:  Gouraud;  Fill:  Line        "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+100  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Far Frustum Plane;        FVF: Diffuse;       Shade:  Gouraud;  Fill:  Line        "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+101  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Left Frustum Plane;       FVF: Diffuse+Spec;  Shade:  Gouraud;  Fill:  Line        "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+102  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Right Frustum Plane;      FVF: Diffuse+Spec;  Shade:  Gouraud;  Fill:  Line        "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+103  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Top Frustum Plane;        FVF: Diffuse+Spec;  Shade:  Gouraud;  Fill:  Line        "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+104  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Bottom Frustum Plane;     FVF: Diffuse+Spec;  Shade:  Gouraud;  Fill:  Line        "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+105  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Near Frustum Plane;       FVF: Diffuse+Spec;  Shade:  Gouraud;  Fill:  Line        "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+106  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Far Frustum Plane;        FVF: Diffuse+Spec;  Shade:  Gouraud;  Fill:  Line        "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+107  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Left Frustum Plane;       FVF: Diffuse;       Shade:  Flat;     Fill:  Line        "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+108  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Right Frustum Plane;      FVF: Diffuse;       Shade:  Flat;     Fill:  Line        "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+109  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Top Frustum Plane;        FVF: Diffuse;       Shade:  Flat;     Fill:  Line        "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+110  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Bottom Frustum Plane;     FVF: Diffuse;       Shade:  Flat;     Fill:  Line        "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+111  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Near Frustum Plane;       FVF: Diffuse;       Shade:  Flat;     Fill:  Line        "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+112  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Far Frustum Plane;        FVF: Diffuse;       Shade:  Flat;     Fill:  Line        "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+113  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Left Frustum Plane;       FVF: Diffuse+Spec;  Shade:  Flat;     Fill:  Line        "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+114  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Right Frustum Plane;      FVF: Diffuse+Spec;  Shade:  Flat;     Fill:  Line        "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+115  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Top Frustum Plane;        FVF: Diffuse+Spec;  Shade:  Flat;     Fill:  Line        "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+116  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Bottom Frustum Plane;     FVF: Diffuse+Spec;  Shade:  Flat;     Fill:  Line        "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+117  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Near Frustum Plane;       FVF: Diffuse+Spec;  Shade:  Flat;     Fill:  Line        "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+118  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Far Frustum Plane;        FVF: Diffuse+Spec;  Shade:  Flat;     Fill:  Line        "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+119  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Left Frustum Plane;       FVF: Diffuse;       Shade:  Gouraud;  Fill:  Point       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+120  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Right Frustum Plane;      FVF: Diffuse;       Shade:  Gouraud;  Fill:  Point       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+121  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Top Frustum Plane;        FVF: Diffuse;       Shade:  Gouraud;  Fill:  Point       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+122  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Bottom Frustum Plane;     FVF: Diffuse;       Shade:  Gouraud;  Fill:  Point       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+123  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Near Frustum Plane;       FVF: Diffuse;       Shade:  Gouraud;  Fill:  Point       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+124  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Far Frustum Plane;        FVF: Diffuse;       Shade:  Gouraud;  Fill:  Point       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+125  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Left Frustum Plane;       FVF: Diffuse+Spec;  Shade:  Gouraud;  Fill:  Point       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+126  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Right Frustum Plane;      FVF: Diffuse+Spec;  Shade:  Gouraud;  Fill:  Point       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+127  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Top Frustum Plane;        FVF: Diffuse+Spec;  Shade:  Gouraud;  Fill:  Point       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+128  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Bottom Frustum Plane;     FVF: Diffuse+Spec;  Shade:  Gouraud;  Fill:  Point       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+129  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Near Frustum Plane;       FVF: Diffuse+Spec;  Shade:  Gouraud;  Fill:  Point       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+130  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Far Frustum Plane;        FVF: Diffuse+Spec;  Shade:  Gouraud;  Fill:  Point       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+131  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Left Frustum Plane;       FVF: Diffuse;       Shade:  Flat;     Fill:  Point       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+132  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Right Frustum Plane;      FVF: Diffuse;       Shade:  Flat;     Fill:  Point       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+133  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Top Frustum Plane;        FVF: Diffuse;       Shade:  Flat;     Fill:  Point       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+134  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Bottom Frustum Plane;     FVF: Diffuse;       Shade:  Flat;     Fill:  Point       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+135  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Near Frustum Plane;       FVF: Diffuse;       Shade:  Flat;     Fill:  Point       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+136  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Far Frustum Plane;        FVF: Diffuse;       Shade:  Flat;     Fill:  Point       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+137  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Left Frustum Plane;       FVF: Diffuse+Spec;  Shade:  Flat;     Fill:  Point       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+138  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Right Frustum Plane;      FVF: Diffuse+Spec;  Shade:  Flat;     Fill:  Point       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+139  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Top Frustum Plane;        FVF: Diffuse+Spec;  Shade:  Flat;     Fill:  Point       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+140  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Bottom Frustum Plane;     FVF: Diffuse+Spec;  Shade:  Flat;     Fill:  Point       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+141  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Near Frustum Plane;       FVF: Diffuse+Spec;  Shade:  Flat;     Fill:  Point       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+142  ,   TuxTest },
{ TEXT("(ClipTest) Line Clip: Far Frustum Plane;        FVF: Diffuse+Spec;  Shade:  Flat;     Fill:  Point       "),        1,         0,      D3DMQA_CLIPPINGTEST_BASE+143  ,   TuxTest },

//
// FVF Tests
//
{ TEXT("(FVFTest) Fltpoint prims with 1D tex coords (vert)                                                       "),        1,         0,               D3DMQA_FVFTEST_BASE + 0, TuxTest  },
{ TEXT("(FVFTest) Fltpoint prims with 1D tex coords (horiz)                                                      "),        1,         0,               D3DMQA_FVFTEST_BASE + 1, TuxTest  },
{ TEXT("(FVFTest) Fltpoint prims with 1 set 2D tex coords                                                        "),        1,         0,               D3DMQA_FVFTEST_BASE + 2, TuxTest  },
{ TEXT("(FVFTest) Fltpoint prims with 2 sets 2D tex coords                                                       "),        1,         0,               D3DMQA_FVFTEST_BASE + 3, TuxTest  },
{ TEXT("(FVFTest) Fltpoint prims with 3 sets 2D tex coords                                                       "),        1,         0,               D3DMQA_FVFTEST_BASE + 4, TuxTest  },
{ TEXT("(FVFTest) Fltpoint prims with 4 sets 2D tex coords                                                       "),        1,         0,               D3DMQA_FVFTEST_BASE + 5, TuxTest  },
{ TEXT("(FVFTest) Fltpoint prims with 1 set 2D tex coords; blended with diffuse (gouraud)                        "),        1,         0,               D3DMQA_FVFTEST_BASE + 6, TuxTest  },
{ TEXT("(FVFTest) Fltpoint prims with 1 set 2D tex coords; blended with diffuse (flat)                           "),        1,         0,               D3DMQA_FVFTEST_BASE + 7, TuxTest  },
{ TEXT("(FVFTest) Fltpoint prims with 1 set 2D tex coords; blended with specular (gouraud)                       "),        1,         0,               D3DMQA_FVFTEST_BASE + 8, TuxTest  },
{ TEXT("(FVFTest) Fltpoint prims with 1 set 2D tex coords; blended with specular (flat)                          "),        1,         0,               D3DMQA_FVFTEST_BASE + 9, TuxTest  },
{ TEXT("(FVFTest) Fltpoint prims with diffuse (gouraud shade)                                                    "),        1,         0,               D3DMQA_FVFTEST_BASE +10, TuxTest  },
{ TEXT("(FVFTest) Fltpoint prims with diffuse (flat shade)                                                       "),        1,         0,               D3DMQA_FVFTEST_BASE +11, TuxTest  },
{ TEXT("(FVFTest) Fltpoint prims with specular (gouraud shade)                                                   "),        1,         0,               D3DMQA_FVFTEST_BASE +12, TuxTest  },
{ TEXT("(FVFTest) Fltpoint prims with specular (flat shade)                                                      "),        1,         0,               D3DMQA_FVFTEST_BASE +13, TuxTest  },
{ TEXT("(FVFTest) Fltpoint prims with diffuse + specular (gouraud shade)                                         "),        1,         0,               D3DMQA_FVFTEST_BASE +14, TuxTest  },
{ TEXT("(FVFTest) Fltpoint prims with diffuse + specular (flat shade)                                            "),        1,         0,               D3DMQA_FVFTEST_BASE +15, TuxTest  },
{ TEXT("(FVFTest) Fltpoint prims - position only                                                                 "),        1,         0,               D3DMQA_FVFTEST_BASE +16, TuxTest  },
{ TEXT("(FVFTest) Fltpoint prims (pos 1) with 1D tex coords                                                      "),        1,         0,               D3DMQA_FVFTEST_BASE +17, TuxTest  },
{ TEXT("(FVFTest) Fltpoint prims (pos 2) with 1D tex coords                                                      "),        1,         0,               D3DMQA_FVFTEST_BASE +18, TuxTest  },
{ TEXT("(FVFTest) Fltpoint prims (pos 3) with 1D tex coords                                                      "),        1,         0,               D3DMQA_FVFTEST_BASE +19, TuxTest  },
{ TEXT("(FVFTest) Fltpoint prims (pos 4) with 1D tex coords                                                      "),        1,         0,               D3DMQA_FVFTEST_BASE +20, TuxTest  },
{ TEXT("(FVFTest) Fltpoint prims (pos 5) with 1D tex coords                                                      "),        1,         0,               D3DMQA_FVFTEST_BASE +21, TuxTest  },
{ TEXT("(FVFTest) Fltpoint prims (pos 1) with 2D tex coords                                                      "),        1,         0,               D3DMQA_FVFTEST_BASE +22, TuxTest  },
{ TEXT("(FVFTest) Fltpoint prims (pos 2) with 2D tex coords                                                      "),        1,         0,               D3DMQA_FVFTEST_BASE +23, TuxTest  },
{ TEXT("(FVFTest) Fltpoint prims (pos 3) with 2D tex coords                                                      "),        1,         0,               D3DMQA_FVFTEST_BASE +24, TuxTest  },
{ TEXT("(FVFTest) Fltpoint prims (pos 4) with 2D tex coords                                                      "),        1,         0,               D3DMQA_FVFTEST_BASE +25, TuxTest  },
{ TEXT("(FVFTest) Fltpoint prims (pos 5) with 2D tex coords                                                      "),        1,         0,               D3DMQA_FVFTEST_BASE +26, TuxTest  },
{ TEXT("(FVFTest) Fltpoint projected to 1D tex coords (vert)                                                     "),        1,         0,               D3DMQA_FVFTEST_BASE +27, TuxTest  },
{ TEXT("(FVFTest) Fltpoint projected to 1D tex coords (horiz)                                                    "),        1,         0,               D3DMQA_FVFTEST_BASE +28, TuxTest  },
{ TEXT("(FVFTest) Fltpoint projected to 2D tex coords                                                            "),        1,         0,               D3DMQA_FVFTEST_BASE +29, TuxTest  },
{ TEXT("(FVFTest) Fltpoint projected to 1D tex coords (vert); blended with diffuse (gouraud)                     "),        1,         0,               D3DMQA_FVFTEST_BASE +30, TuxTest  },
{ TEXT("(FVFTest) Fltpoint projected to 1D tex coords (vert); blended with diffuse (flat)                        "),        1,         0,               D3DMQA_FVFTEST_BASE +31, TuxTest  },
{ TEXT("(FVFTest) Fltpoint projected to 1D tex coords (horiz); blended with diffuse (gouraud)                    "),        1,         0,               D3DMQA_FVFTEST_BASE +32, TuxTest  },
{ TEXT("(FVFTest) Fltpoint projected to 1D tex coords (horiz); blended with diffuse (flat)                       "),        1,         0,               D3DMQA_FVFTEST_BASE +33, TuxTest  },
{ TEXT("(FVFTest) Fltpoint projected to 2D tex coords; blended with diffuse (gouraud)                            "),        1,         0,               D3DMQA_FVFTEST_BASE +34, TuxTest  },
{ TEXT("(FVFTest) Fltpoint projected to 2D tex coords; blended with diffuse (flat)                               "),        1,         0,               D3DMQA_FVFTEST_BASE +35, TuxTest  },
{ TEXT("(FVFTest) Fltpoint projected to 1D tex coords (vert); blended with specular (gouraud)                    "),        1,         0,               D3DMQA_FVFTEST_BASE +36, TuxTest  },
{ TEXT("(FVFTest) Fltpoint projected to 1D tex coords (vert); blended with specular  (flat)                      "),        1,         0,               D3DMQA_FVFTEST_BASE +37, TuxTest  },
{ TEXT("(FVFTest) Fltpoint projected to 1D tex coords (horiz); blended with specular (gouraud)                   "),        1,         0,               D3DMQA_FVFTEST_BASE +38, TuxTest  },
{ TEXT("(FVFTest) Fltpoint projected to 1D tex coords (horiz); blended with specular (flat)                      "),        1,         0,               D3DMQA_FVFTEST_BASE +39, TuxTest  },
{ TEXT("(FVFTest) Fltpoint projected to 2D tex coords; blended with specular (gouraud)                           "),        1,         0,               D3DMQA_FVFTEST_BASE +40, TuxTest  },
{ TEXT("(FVFTest) Fltpoint projected to 2D tex coords; blended with specular (flat)                              "),        1,         0,               D3DMQA_FVFTEST_BASE +41, TuxTest  },


//
// Fog Tests
//
{ TEXT("(FogTest) Pixel Fog (Z-Based) Basic Test                                                                 "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+  0  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (Z-Based) Basic Test, D3DMRS_FOGENABLE disabled                                      "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+  1  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (W-Based) Basic Test                                                                 "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+  2  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (W-Based) Basic Test, D3DMRS_FOGENABLE disabled                                      "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+  3  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (Z-Based) D3DMRS_FOGSTART Test #1                                                    "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+  4  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (Z-Based) D3DMRS_FOGSTART Test #2                                                    "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+  5  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (Z-Based) D3DMRS_FOGSTART Test #3                                                    "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+  6  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (Z-Based) D3DMRS_FOGSTART Test #4                                                    "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+  7  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (Z-Based) D3DMRS_FOGSTART Test #5                                                    "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+  8  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (Z-Based) D3DMRS_FOGSTART Test #6                                                    "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+  9  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (Z-Based) D3DMRS_FOGEND Test #1                                                      "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+ 10  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (Z-Based) D3DMRS_FOGEND Test #2                                                      "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+ 11  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (Z-Based) D3DMRS_FOGEND Test #3                                                      "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+ 12  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (Z-Based) D3DMRS_FOGEND Test #4                                                      "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+ 13  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (Z-Based) D3DMRS_FOGEND Test #5                                                      "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+ 14  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (Z-Based) D3DMRS_FOGEND Test #6                                                      "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+ 15  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (Z-Based) D3DMRS_FOGCOLOR Red Test #1                                                "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+ 16  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (Z-Based) D3DMRS_FOGCOLOR Red Test #2                                                "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+ 17  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (Z-Based) D3DMRS_FOGCOLOR Red Test #3                                                "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+ 18  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (Z-Based) D3DMRS_FOGCOLOR Red Test #4                                                "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+ 19  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (Z-Based) D3DMRS_FOGCOLOR Green Test #1                                              "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+ 20  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (Z-Based) D3DMRS_FOGCOLOR Green Test #2                                              "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+ 21  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (Z-Based) D3DMRS_FOGCOLOR Green Test #3                                              "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+ 22  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (Z-Based) D3DMRS_FOGCOLOR Green Test #4                                              "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+ 23  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (Z-Based) D3DMRS_FOGCOLOR Blue Test #1                                               "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+ 24  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (Z-Based) D3DMRS_FOGCOLOR Blue Test #2                                               "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+ 25  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (Z-Based) D3DMRS_FOGCOLOR Blue Test #3                                               "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+ 26  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (Z-Based) D3DMRS_FOGCOLOR Blue Test #4                                               "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+ 27  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (Z-Based) D3DMRS_FOGCOLOR Yellow Test                                                "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+ 28  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (Z-Based) D3DMRS_FOGCOLOR Cyan Test                                                  "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+ 29  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (Z-Based) D3DMRS_FOGCOLOR Magenta Test                                               "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+ 30  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (Z-Based) EXP Density Test #1                                                        "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+ 31  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (Z-Based) EXP Density Test #2                                                        "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+ 32  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (Z-Based) EXP Density Test #3                                                        "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+ 33  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (Z-Based) EXP Density Test #4                                                        "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+ 34  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (Z-Based) EXP Density Test #5                                                        "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+ 35  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (Z-Based) EXP Density Test #6                                                        "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+ 36  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (Z-Based) EXP Density Test #7                                                        "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+ 37  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (Z-Based) EXP Density Test #8                                                        "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+ 38  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (Z-Based) EXP Density Test #9                                                        "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+ 39  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (Z-Based) EXP Density Test #10                                                       "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+ 40  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (Z-Based) EXP2 Density Test #1                                                       "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+ 41  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (Z-Based) EXP2 Density Test #2                                                       "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+ 42  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (Z-Based) EXP2 Density Test #3                                                       "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+ 43  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (Z-Based) EXP2 Density Test #4                                                       "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+ 44  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (Z-Based) EXP2 Density Test #5                                                       "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+ 45  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (Z-Based) EXP2 Density Test #6                                                       "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+ 46  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (Z-Based) EXP2 Density Test #7                                                       "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+ 47  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (Z-Based) EXP2 Density Test #8                                                       "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+ 48  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (Z-Based) EXP2 Density Test #9                                                       "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+ 49  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (Z-Based) EXP2 Density Test #10                                                      "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+ 50  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (W-Based) D3DMRS_FOGSTART Test #1                                                    "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+ 51  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (W-Based) D3DMRS_FOGSTART Test #2                                                    "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+ 52  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (W-Based) D3DMRS_FOGSTART Test #3                                                    "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+ 53  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (W-Based) D3DMRS_FOGSTART Test #4                                                    "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+ 54  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (W-Based) D3DMRS_FOGSTART Test #5                                                    "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+ 55  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (W-Based) D3DMRS_FOGEND Test #1                                                      "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+ 56  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (W-Based) D3DMRS_FOGEND Test #2                                                      "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+ 57  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (W-Based) D3DMRS_FOGEND Test #3                                                      "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+ 58  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (W-Based) D3DMRS_FOGEND Test #4                                                      "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+ 59  ,   TuxTest },
{ TEXT("(FogTest) Pixel Fog (W-Based) D3DMRS_FOGEND Test #5                                                      "),        1,         0,  D3DMQA_PIXELFOGTEST_BASE+ 60  ,   TuxTest },
{ TEXT("(FogTest) Custom Fog Basic Test                                                                          "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+  0  ,   TuxTest },
{ TEXT("(FogTest) Custom Fog Basic Test, D3DMRS_FOGENABLE disabled                                               "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+  1  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Depth-Based) Basic Test                                                            "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+  2  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Depth-Based) Basic Test, D3DMRS_FOGENABLE disabled                                 "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+  3  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Depth-Based) D3DMRS_FOGSTART/D3DMRS_FOGEND Test #1                                 "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+  4  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Depth-Based) D3DMRS_FOGSTART/D3DMRS_FOGEND Test #2                                 "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+  5  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Depth-Based) D3DMRS_FOGSTART/D3DMRS_FOGEND Test #3                                 "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+  6  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Depth-Based) D3DMRS_FOGSTART/D3DMRS_FOGEND Test #4                                 "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+  7  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Depth-Based) D3DMRS_FOGSTART/D3DMRS_FOGEND Test #5                                 "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+  8  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Depth-Based) D3DMRS_FOGSTART/D3DMRS_FOGEND Test #6                                 "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+  9  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Depth-Based) D3DMRS_FOGSTART/D3DMRS_FOGEND Test #7                                 "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+ 10  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Depth-Based) D3DMRS_FOGSTART/D3DMRS_FOGEND Test #8                                 "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+ 11  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Depth-Based) D3DMRS_FOGSTART/D3DMRS_FOGEND Test #9                                 "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+ 12  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Depth-Based) D3DMRS_FOGSTART/D3DMRS_FOGEND Test #10                                "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+ 13  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Depth-Based) D3DMRS_FOGSTART/D3DMRS_FOGEND Test #11                                "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+ 14  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Depth-Based) D3DMRS_FOGSTART/D3DMRS_FOGEND Test #12                                "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+ 15  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Depth-Based) D3DMRS_FOGCOLOR Red Test #1                                           "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+ 16  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Depth-Based) D3DMRS_FOGCOLOR Red Test #2                                           "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+ 17  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Depth-Based) D3DMRS_FOGCOLOR Red Test #3                                           "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+ 18  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Depth-Based) D3DMRS_FOGCOLOR Red Test #4                                           "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+ 19  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Depth-Based) D3DMRS_FOGCOLOR Green Test #1                                         "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+ 20  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Depth-Based) D3DMRS_FOGCOLOR Green Test #2                                         "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+ 21  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Depth-Based) D3DMRS_FOGCOLOR Green Test #3                                         "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+ 22  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Depth-Based) D3DMRS_FOGCOLOR Green Test #4                                         "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+ 23  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Depth-Based) D3DMRS_FOGCOLOR Blue Test #1                                          "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+ 24  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Depth-Based) D3DMRS_FOGCOLOR Blue Test #2                                          "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+ 25  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Depth-Based) D3DMRS_FOGCOLOR Blue Test #3                                          "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+ 26  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Depth-Based) D3DMRS_FOGCOLOR Blue Test #4                                          "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+ 27  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Depth-Based) D3DMRS_FOGCOLOR Yellow Test                                           "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+ 28  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Depth-Based) D3DMRS_FOGCOLOR Cyan Test                                             "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+ 29  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Depth-Based) D3DMRS_FOGCOLOR Magenta Test                                          "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+ 30  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Depth-Based) EXP Density Test #1                                                   "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+ 31  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Depth-Based) EXP Density Test #2                                                   "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+ 32  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Depth-Based) EXP Density Test #3                                                   "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+ 33  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Depth-Based) EXP Density Test #4                                                   "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+ 34  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Depth-Based) EXP Density Test #5                                                   "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+ 35  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Depth-Based) EXP Density Test #6                                                   "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+ 36  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Depth-Based) EXP Density Test #7                                                   "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+ 37  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Depth-Based) EXP Density Test #8                                                   "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+ 38  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Depth-Based) EXP Density Test #9                                                   "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+ 39  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Depth-Based) EXP Density Test #10                                                  "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+ 40  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Depth-Based) EXP2 Density Test #1                                                  "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+ 41  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Depth-Based) EXP2 Density Test #2                                                  "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+ 42  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Depth-Based) EXP2 Density Test #3                                                  "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+ 43  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Depth-Based) EXP2 Density Test #4                                                  "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+ 44  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Depth-Based) EXP2 Density Test #5                                                  "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+ 45  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Depth-Based) EXP2 Density Test #6                                                  "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+ 46  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Depth-Based) EXP2 Density Test #7                                                  "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+ 47  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Depth-Based) EXP2 Density Test #8                                                  "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+ 48  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Depth-Based) EXP2 Density Test #9                                                  "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+ 49  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Depth-Based) EXP2 Density Test #10                                                 "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+ 50  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Range-Based) D3DMRS_FOGSTART Test #1                                               "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+ 51  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Range-Based) D3DMRS_FOGSTART Test #2                                               "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+ 52  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Range-Based) D3DMRS_FOGSTART Test #3                                               "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+ 53  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Range-Based) D3DMRS_FOGSTART Test #4                                               "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+ 54  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Range-Based) D3DMRS_FOGSTART Test #5                                               "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+ 55  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Range-Based) D3DMRS_FOGEND Test #1                                                 "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+ 56  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Range-Based) D3DMRS_FOGEND Test #2                                                 "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+ 57  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Range-Based) D3DMRS_FOGEND Test #3                                                 "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+ 58  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Range-Based) D3DMRS_FOGEND Test #4                                                 "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+ 59  ,   TuxTest },
{ TEXT("(FogTest) Vertex Fog (Range-Based) D3DMRS_FOGEND Test #5                                                 "),        1,         0, D3DMQA_VERTEXFOGTEST_BASE+ 60  ,   TuxTest },

//
// Mip-Map Test Cases
//
{ TEXT("(MipMapTest) MIP_POINT; MAG_POINT; MIN_POINT; LOD Bias =-2.0f                                             "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+  0, TuxTest  },
{ TEXT("(MipMapTest) MIP_POINT; MAG_POINT; MIN_POINT; LOD Bias =-1.5f                                             "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+  1, TuxTest  },
{ TEXT("(MipMapTest) MIP_POINT; MAG_POINT; MIN_POINT; LOD Bias =-1.0f                                             "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+  2, TuxTest  },
{ TEXT("(MipMapTest) MIP_POINT; MAG_POINT; MIN_POINT; LOD Bias =-0.5f                                             "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+  3, TuxTest  },
{ TEXT("(MipMapTest) MIP_POINT; MAG_POINT; MIN_POINT; LOD Bias = 0.0f                                             "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+  4, TuxTest  },
{ TEXT("(MipMapTest) MIP_POINT; MAG_POINT; MIN_POINT; LOD Bias = 0.5f                                             "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+  5, TuxTest  },
{ TEXT("(MipMapTest) MIP_POINT; MAG_POINT; MIN_POINT; LOD Bias = 1.0f                                             "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+  6, TuxTest  },
{ TEXT("(MipMapTest) MIP_POINT; MAG_POINT; MIN_POINT; LOD Bias = 1.5f                                             "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+  7, TuxTest  },
{ TEXT("(MipMapTest) MIP_POINT; MAG_POINT; MIN_POINT; LOD Bias = 2.0f                                             "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+  8, TuxTest  },
{ TEXT("(MipMapTest) Mip Level Test (for devices that support point filtering); Isolating Level 0 of 7           "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+  9, TuxTest  },
{ TEXT("(MipMapTest) Mip Level Test (for devices that support point filtering); Isolating Level 1 of 7           "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+ 10, TuxTest  },
{ TEXT("(MipMapTest) Mip Level Test (for devices that support point filtering); Isolating Level 2 of 7           "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+ 11, TuxTest  },
{ TEXT("(MipMapTest) Mip Level Test (for devices that support point filtering); Isolating Level 3 of 7           "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+ 12, TuxTest  },
{ TEXT("(MipMapTest) Mip Level Test (for devices that support point filtering); Isolating Level 4 of 7           "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+ 13, TuxTest  },
{ TEXT("(MipMapTest) Mip Level Test (for devices that support point filtering); Isolating Level 5 of 7           "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+ 14, TuxTest  },
{ TEXT("(MipMapTest) Mip Level Test (for devices that support point filtering); Isolating Level 6 of 7           "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+ 15, TuxTest  },
{ TEXT("(MipMapTest) Mip Level Test (for devices that support point filtering); Isolating Level 7 of 7           "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+ 16, TuxTest  },
{ TEXT("(MipMapTest) Mip Level Test (for devices that support linear filtering); Isolating Level 0 of 7          "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+ 17, TuxTest  },
{ TEXT("(MipMapTest) Mip Level Test (for devices that support linear filtering); Isolating Level 1 of 7          "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+ 18, TuxTest  },
{ TEXT("(MipMapTest) Mip Level Test (for devices that support linear filtering); Isolating Level 2 of 7          "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+ 19, TuxTest  },
{ TEXT("(MipMapTest) Mip Level Test (for devices that support linear filtering); Isolating Level 3 of 7          "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+ 20, TuxTest  },
{ TEXT("(MipMapTest) Mip Level Test (for devices that support linear filtering); Isolating Level 4 of 7          "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+ 21, TuxTest  },
{ TEXT("(MipMapTest) Mip Level Test (for devices that support linear filtering); Isolating Level 5 of 7          "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+ 22, TuxTest  },
{ TEXT("(MipMapTest) Mip Level Test (for devices that support linear filtering); Isolating Level 6 of 7          "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+ 23, TuxTest  },
{ TEXT("(MipMapTest) Mip Level Test (for devices that support linear filtering); Isolating Level 7 of 7          "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+ 24, TuxTest  },
{ TEXT("(MipMapTest) Mip Level Test (for devices that support anisotropic filtering); Isolating Level 0 of 7     "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+ 25, TuxTest  },
{ TEXT("(MipMapTest) Mip Level Test (for devices that support anisotropic filtering); Isolating Level 1 of 7     "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+ 26, TuxTest  },
{ TEXT("(MipMapTest) Mip Level Test (for devices that support anisotropic filtering); Isolating Level 2 of 7     "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+ 27, TuxTest  },
{ TEXT("(MipMapTest) Mip Level Test (for devices that support anisotropic filtering); Isolating Level 3 of 7     "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+ 28, TuxTest  },
{ TEXT("(MipMapTest) Mip Level Test (for devices that support anisotropic filtering); Isolating Level 4 of 7     "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+ 29, TuxTest  },
{ TEXT("(MipMapTest) Mip Level Test (for devices that support anisotropic filtering); Isolating Level 5 of 7     "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+ 30, TuxTest  },
{ TEXT("(MipMapTest) Mip Level Test (for devices that support anisotropic filtering); Isolating Level 6 of 7     "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+ 31, TuxTest  },
{ TEXT("(MipMapTest) Mip Level Test (for devices that support anisotropic filtering); Isolating Level 7 of 7     "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+ 32, TuxTest  },
{ TEXT("(MipMapTest) Mip Filtering/Sampling Test for MIP_NONE;   MAG_POINT;       MIN_POINT                      "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+ 33, TuxTest  },
{ TEXT("(MipMapTest) Mip Filtering/Sampling Test for MIP_NONE;   MAG_POINT;       MIN_LINEAR                     "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+ 34, TuxTest  },
{ TEXT("(MipMapTest) Mip Filtering/Sampling Test for MIP_NONE;   MAG_POINT;       MIN_ANISOTROPIC                "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+ 35, TuxTest  },
{ TEXT("(MipMapTest) Mip Filtering/Sampling Test for MIP_NONE;   MAG_LINEAR;      MIN_POINT                      "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+ 36, TuxTest  },
{ TEXT("(MipMapTest) Mip Filtering/Sampling Test for MIP_NONE;   MAG_LINEAR;      MIN_LINEAR                     "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+ 37, TuxTest  },
{ TEXT("(MipMapTest) Mip Filtering/Sampling Test for MIP_NONE;   MAG_LINEAR;      MIN_ANISOTROPIC                "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+ 38, TuxTest  },
{ TEXT("(MipMapTest) Mip Filtering/Sampling Test for MIP_NONE;   MAG_ANISOTROPIC; MIN_POINT                      "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+ 39, TuxTest  },
{ TEXT("(MipMapTest) Mip Filtering/Sampling Test for MIP_NONE;   MAG_ANISOTROPIC; MIN_LINEAR                     "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+ 40, TuxTest  },
{ TEXT("(MipMapTest) Mip Filtering/Sampling Test for MIP_NONE;   MAG_ANISOTROPIC; MIN_ANISOTROPIC                "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+ 41, TuxTest  },
{ TEXT("(MipMapTest) Mip Filtering/Sampling Test for MIP_POINT;  MAG_POINT;       MIN_POINT                      "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+ 42, TuxTest  },
{ TEXT("(MipMapTest) Mip Filtering/Sampling Test for MIP_POINT;  MAG_POINT;       MIN_LINEAR                     "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+ 43, TuxTest  },
{ TEXT("(MipMapTest) Mip Filtering/Sampling Test for MIP_POINT;  MAG_POINT;       MIN_ANISOTROPIC                "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+ 44, TuxTest  },
{ TEXT("(MipMapTest) Mip Filtering/Sampling Test for MIP_POINT;  MAG_LINEAR;      MIN_POINT                      "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+ 45, TuxTest  },
{ TEXT("(MipMapTest) Mip Filtering/Sampling Test for MIP_POINT;  MAG_LINEAR;      MIN_LINEAR                     "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+ 46, TuxTest  },
{ TEXT("(MipMapTest) Mip Filtering/Sampling Test for MIP_POINT;  MAG_LINEAR;      MIN_ANISOTROPIC                "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+ 47, TuxTest  },
{ TEXT("(MipMapTest) Mip Filtering/Sampling Test for MIP_POINT;  MAG_ANISOTROPIC; MIN_POINT                      "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+ 48, TuxTest  },
{ TEXT("(MipMapTest) Mip Filtering/Sampling Test for MIP_POINT;  MAG_ANISOTROPIC; MIN_LINEAR                     "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+ 49, TuxTest  },
{ TEXT("(MipMapTest) Mip Filtering/Sampling Test for MIP_POINT;  MAG_ANISOTROPIC; MIN_ANISOTROPIC                "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+ 50, TuxTest  },
{ TEXT("(MipMapTest) Mip Filtering/Sampling Test for MIP_LINEAR; MAG_POINT;       MIN_POINT                      "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+ 51, TuxTest  },
{ TEXT("(MipMapTest) Mip Filtering/Sampling Test for MIP_LINEAR; MAG_POINT;       MIN_LINEAR                     "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+ 52, TuxTest  },
{ TEXT("(MipMapTest) Mip Filtering/Sampling Test for MIP_LINEAR; MAG_POINT;       MIN_ANISOTROPIC                "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+ 53, TuxTest  },
{ TEXT("(MipMapTest) Mip Filtering/Sampling Test for MIP_LINEAR; MAG_LINEAR;      MIN_POINT                      "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+ 54, TuxTest  },
{ TEXT("(MipMapTest) Mip Filtering/Sampling Test for MIP_LINEAR; MAG_LINEAR;      MIN_LINEAR                     "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+ 55, TuxTest  },
{ TEXT("(MipMapTest) Mip Filtering/Sampling Test for MIP_LINEAR; MAG_LINEAR;      MIN_ANISOTROPIC                "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+ 56, TuxTest  },
{ TEXT("(MipMapTest) Mip Filtering/Sampling Test for MIP_LINEAR; MAG_ANISOTROPIC; MIN_POINT                      "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+ 57, TuxTest  },
{ TEXT("(MipMapTest) Mip Filtering/Sampling Test for MIP_LINEAR; MAG_ANISOTROPIC; MIN_LINEAR                     "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+ 58, TuxTest  },
{ TEXT("(MipMapTest) Mip Filtering/Sampling Test for MIP_LINEAR; MAG_ANISOTROPIC; MIN_ANISOTROPIC                "),        1,         0,           D3DMQA_MIPMAPTEST_BASE+ 59, TuxTest  },

//
// Transformation Tests
//
{ TEXT("(TransTest) X   Rotation in D3DMTS_WORLD, Frame #1                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+  0,   TuxTest },
{ TEXT("(TransTest) X   Rotation in D3DMTS_WORLD, Frame #2                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+  1,   TuxTest },
{ TEXT("(TransTest) X   Rotation in D3DMTS_WORLD, Frame #3                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+  2,   TuxTest },
{ TEXT("(TransTest) X   Rotation in D3DMTS_WORLD, Frame #4                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+  3,   TuxTest },
{ TEXT("(TransTest) X   Rotation in D3DMTS_WORLD, Frame #5                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+  4,   TuxTest },
{ TEXT("(TransTest) Y   Rotation in D3DMTS_WORLD, Frame #1                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+  5,   TuxTest },
{ TEXT("(TransTest) Y   Rotation in D3DMTS_WORLD, Frame #2                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+  6,   TuxTest },
{ TEXT("(TransTest) Y   Rotation in D3DMTS_WORLD, Frame #3                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+  7,   TuxTest },
{ TEXT("(TransTest) Y   Rotation in D3DMTS_WORLD, Frame #4                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+  8,   TuxTest },
{ TEXT("(TransTest) Y   Rotation in D3DMTS_WORLD, Frame #5                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+  9,   TuxTest },
{ TEXT("(TransTest) Z   Rotation in D3DMTS_WORLD, Frame #1                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 10,   TuxTest },
{ TEXT("(TransTest) Z   Rotation in D3DMTS_WORLD, Frame #2                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 11,   TuxTest },
{ TEXT("(TransTest) Z   Rotation in D3DMTS_WORLD, Frame #3                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 12,   TuxTest },
{ TEXT("(TransTest) Z   Rotation in D3DMTS_WORLD, Frame #4                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 13,   TuxTest },
{ TEXT("(TransTest) Z   Rotation in D3DMTS_WORLD, Frame #5                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 14,   TuxTest },
{ TEXT("(TransTest) XY  Rotation in D3DMTS_WORLD, Frame #1                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 15,   TuxTest },
{ TEXT("(TransTest) XY  Rotation in D3DMTS_WORLD, Frame #2                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 16,   TuxTest },
{ TEXT("(TransTest) XY  Rotation in D3DMTS_WORLD, Frame #3                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 17,   TuxTest },
{ TEXT("(TransTest) XY  Rotation in D3DMTS_WORLD, Frame #4                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 18,   TuxTest },
{ TEXT("(TransTest) XY  Rotation in D3DMTS_WORLD, Frame #5                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 19,   TuxTest },
{ TEXT("(TransTest) XY  Rotation in D3DMTS_WORLD, Frame #6                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 20,   TuxTest },
{ TEXT("(TransTest) XY  Rotation in D3DMTS_WORLD, Frame #7                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 21,   TuxTest },
{ TEXT("(TransTest) XY  Rotation in D3DMTS_WORLD, Frame #8                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 22,   TuxTest },
{ TEXT("(TransTest) XY  Rotation in D3DMTS_WORLD, Frame #9                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 23,   TuxTest },
{ TEXT("(TransTest) XY  Rotation in D3DMTS_WORLD, Frame #10                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 24,   TuxTest },
{ TEXT("(TransTest) XY  Rotation in D3DMTS_WORLD, Frame #11                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 25,   TuxTest },
{ TEXT("(TransTest) XY  Rotation in D3DMTS_WORLD, Frame #12                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 26,   TuxTest },
{ TEXT("(TransTest) XY  Rotation in D3DMTS_WORLD, Frame #13                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 27,   TuxTest },
{ TEXT("(TransTest) XY  Rotation in D3DMTS_WORLD, Frame #14                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 28,   TuxTest },
{ TEXT("(TransTest) XY  Rotation in D3DMTS_WORLD, Frame #15                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 29,   TuxTest },
{ TEXT("(TransTest) XY  Rotation in D3DMTS_WORLD, Frame #16                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 30,   TuxTest },
{ TEXT("(TransTest) XZ  Rotation in D3DMTS_WORLD, Frame #1                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 31,   TuxTest },
{ TEXT("(TransTest) XZ  Rotation in D3DMTS_WORLD, Frame #2                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 32,   TuxTest },
{ TEXT("(TransTest) XZ  Rotation in D3DMTS_WORLD, Frame #3                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 33,   TuxTest },
{ TEXT("(TransTest) XZ  Rotation in D3DMTS_WORLD, Frame #4                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 34,   TuxTest },
{ TEXT("(TransTest) XZ  Rotation in D3DMTS_WORLD, Frame #5                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 35,   TuxTest },
{ TEXT("(TransTest) XZ  Rotation in D3DMTS_WORLD, Frame #6                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 36,   TuxTest },
{ TEXT("(TransTest) XZ  Rotation in D3DMTS_WORLD, Frame #7                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 37,   TuxTest },
{ TEXT("(TransTest) XZ  Rotation in D3DMTS_WORLD, Frame #8                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 38,   TuxTest },
{ TEXT("(TransTest) XZ  Rotation in D3DMTS_WORLD, Frame #9                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 39,   TuxTest },
{ TEXT("(TransTest) XZ  Rotation in D3DMTS_WORLD, Frame #10                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 40,   TuxTest },
{ TEXT("(TransTest) XZ  Rotation in D3DMTS_WORLD, Frame #11                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 41,   TuxTest },
{ TEXT("(TransTest) XZ  Rotation in D3DMTS_WORLD, Frame #12                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 42,   TuxTest },
{ TEXT("(TransTest) XZ  Rotation in D3DMTS_WORLD, Frame #13                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 43,   TuxTest },
{ TEXT("(TransTest) XZ  Rotation in D3DMTS_WORLD, Frame #14                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 44,   TuxTest },
{ TEXT("(TransTest) XZ  Rotation in D3DMTS_WORLD, Frame #15                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 45,   TuxTest },
{ TEXT("(TransTest) XZ  Rotation in D3DMTS_WORLD, Frame #16                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 46,   TuxTest },
{ TEXT("(TransTest) YX  Rotation in D3DMTS_WORLD, Frame #1                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 47,   TuxTest },
{ TEXT("(TransTest) YX  Rotation in D3DMTS_WORLD, Frame #2                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 48,   TuxTest },
{ TEXT("(TransTest) YX  Rotation in D3DMTS_WORLD, Frame #3                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 49,   TuxTest },
{ TEXT("(TransTest) YX  Rotation in D3DMTS_WORLD, Frame #4                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 50,   TuxTest },
{ TEXT("(TransTest) YX  Rotation in D3DMTS_WORLD, Frame #5                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 51,   TuxTest },
{ TEXT("(TransTest) YX  Rotation in D3DMTS_WORLD, Frame #6                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 52,   TuxTest },
{ TEXT("(TransTest) YX  Rotation in D3DMTS_WORLD, Frame #7                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 53,   TuxTest },
{ TEXT("(TransTest) YX  Rotation in D3DMTS_WORLD, Frame #8                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 54,   TuxTest },
{ TEXT("(TransTest) YX  Rotation in D3DMTS_WORLD, Frame #9                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 55,   TuxTest },
{ TEXT("(TransTest) YX  Rotation in D3DMTS_WORLD, Frame #10                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 56,   TuxTest },
{ TEXT("(TransTest) YX  Rotation in D3DMTS_WORLD, Frame #11                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 57,   TuxTest },
{ TEXT("(TransTest) YX  Rotation in D3DMTS_WORLD, Frame #12                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 58,   TuxTest },
{ TEXT("(TransTest) YX  Rotation in D3DMTS_WORLD, Frame #13                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 59,   TuxTest },
{ TEXT("(TransTest) YX  Rotation in D3DMTS_WORLD, Frame #14                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 60,   TuxTest },
{ TEXT("(TransTest) YX  Rotation in D3DMTS_WORLD, Frame #15                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 61,   TuxTest },
{ TEXT("(TransTest) YX  Rotation in D3DMTS_WORLD, Frame #16                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 62,   TuxTest },
{ TEXT("(TransTest) YZ  Rotation in D3DMTS_WORLD, Frame #1                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 63,   TuxTest },
{ TEXT("(TransTest) YZ  Rotation in D3DMTS_WORLD, Frame #2                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 64,   TuxTest },
{ TEXT("(TransTest) YZ  Rotation in D3DMTS_WORLD, Frame #3                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 65,   TuxTest },
{ TEXT("(TransTest) YZ  Rotation in D3DMTS_WORLD, Frame #4                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 66,   TuxTest },
{ TEXT("(TransTest) YZ  Rotation in D3DMTS_WORLD, Frame #5                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 67,   TuxTest },
{ TEXT("(TransTest) YZ  Rotation in D3DMTS_WORLD, Frame #6                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 68,   TuxTest },
{ TEXT("(TransTest) YZ  Rotation in D3DMTS_WORLD, Frame #7                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 69,   TuxTest },
{ TEXT("(TransTest) YZ  Rotation in D3DMTS_WORLD, Frame #8                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 70,   TuxTest },
{ TEXT("(TransTest) YZ  Rotation in D3DMTS_WORLD, Frame #9                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 71,   TuxTest },
{ TEXT("(TransTest) YZ  Rotation in D3DMTS_WORLD, Frame #10                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 72,   TuxTest },
{ TEXT("(TransTest) YZ  Rotation in D3DMTS_WORLD, Frame #11                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 73,   TuxTest },
{ TEXT("(TransTest) YZ  Rotation in D3DMTS_WORLD, Frame #12                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 74,   TuxTest },
{ TEXT("(TransTest) YZ  Rotation in D3DMTS_WORLD, Frame #13                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 75,   TuxTest },
{ TEXT("(TransTest) YZ  Rotation in D3DMTS_WORLD, Frame #14                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 76,   TuxTest },
{ TEXT("(TransTest) YZ  Rotation in D3DMTS_WORLD, Frame #15                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 77,   TuxTest },
{ TEXT("(TransTest) YZ  Rotation in D3DMTS_WORLD, Frame #16                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 78,   TuxTest },
{ TEXT("(TransTest) ZX  Rotation in D3DMTS_WORLD, Frame #1                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 79,   TuxTest },
{ TEXT("(TransTest) ZX  Rotation in D3DMTS_WORLD, Frame #2                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 80,   TuxTest },
{ TEXT("(TransTest) ZX  Rotation in D3DMTS_WORLD, Frame #3                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 81,   TuxTest },
{ TEXT("(TransTest) ZX  Rotation in D3DMTS_WORLD, Frame #4                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 82,   TuxTest },
{ TEXT("(TransTest) ZX  Rotation in D3DMTS_WORLD, Frame #5                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 83,   TuxTest },
{ TEXT("(TransTest) ZX  Rotation in D3DMTS_WORLD, Frame #6                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 84,   TuxTest },
{ TEXT("(TransTest) ZX  Rotation in D3DMTS_WORLD, Frame #7                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 85,   TuxTest },
{ TEXT("(TransTest) ZX  Rotation in D3DMTS_WORLD, Frame #8                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 86,   TuxTest },
{ TEXT("(TransTest) ZX  Rotation in D3DMTS_WORLD, Frame #9                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 87,   TuxTest },
{ TEXT("(TransTest) ZX  Rotation in D3DMTS_WORLD, Frame #10                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 88,   TuxTest },
{ TEXT("(TransTest) ZX  Rotation in D3DMTS_WORLD, Frame #11                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 89,   TuxTest },
{ TEXT("(TransTest) ZX  Rotation in D3DMTS_WORLD, Frame #12                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 90,   TuxTest },
{ TEXT("(TransTest) ZX  Rotation in D3DMTS_WORLD, Frame #13                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 91,   TuxTest },
{ TEXT("(TransTest) ZX  Rotation in D3DMTS_WORLD, Frame #14                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 92,   TuxTest },
{ TEXT("(TransTest) ZX  Rotation in D3DMTS_WORLD, Frame #15                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 93,   TuxTest },
{ TEXT("(TransTest) ZX  Rotation in D3DMTS_WORLD, Frame #16                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 94,   TuxTest },
{ TEXT("(TransTest) ZY  Rotation in D3DMTS_WORLD, Frame #1                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 95,   TuxTest },
{ TEXT("(TransTest) ZY  Rotation in D3DMTS_WORLD, Frame #2                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 96,   TuxTest },
{ TEXT("(TransTest) ZY  Rotation in D3DMTS_WORLD, Frame #3                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 97,   TuxTest },
{ TEXT("(TransTest) ZY  Rotation in D3DMTS_WORLD, Frame #4                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 98,   TuxTest },
{ TEXT("(TransTest) ZY  Rotation in D3DMTS_WORLD, Frame #5                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+ 99,   TuxTest },
{ TEXT("(TransTest) ZY  Rotation in D3DMTS_WORLD, Frame #6                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+100,   TuxTest },
{ TEXT("(TransTest) ZY  Rotation in D3DMTS_WORLD, Frame #7                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+101,   TuxTest },
{ TEXT("(TransTest) ZY  Rotation in D3DMTS_WORLD, Frame #8                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+102,   TuxTest },
{ TEXT("(TransTest) ZY  Rotation in D3DMTS_WORLD, Frame #9                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+103,   TuxTest },
{ TEXT("(TransTest) ZY  Rotation in D3DMTS_WORLD, Frame #10                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+104,   TuxTest },
{ TEXT("(TransTest) ZY  Rotation in D3DMTS_WORLD, Frame #11                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+105,   TuxTest },
{ TEXT("(TransTest) ZY  Rotation in D3DMTS_WORLD, Frame #12                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+106,   TuxTest },
{ TEXT("(TransTest) ZY  Rotation in D3DMTS_WORLD, Frame #13                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+107,   TuxTest },
{ TEXT("(TransTest) ZY  Rotation in D3DMTS_WORLD, Frame #14                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+108,   TuxTest },
{ TEXT("(TransTest) ZY  Rotation in D3DMTS_WORLD, Frame #15                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+109,   TuxTest },
{ TEXT("(TransTest) ZY  Rotation in D3DMTS_WORLD, Frame #16                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+110,   TuxTest },
{ TEXT("(TransTest) XYZ Rotation in D3DMTS_WORLD, Frame #1                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+111,   TuxTest },
{ TEXT("(TransTest) XYZ Rotation in D3DMTS_WORLD, Frame #2                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+112,   TuxTest },
{ TEXT("(TransTest) XYZ Rotation in D3DMTS_WORLD, Frame #3                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+113,   TuxTest },
{ TEXT("(TransTest) XYZ Rotation in D3DMTS_WORLD, Frame #4                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+114,   TuxTest },
{ TEXT("(TransTest) XYZ Rotation in D3DMTS_WORLD, Frame #5                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+115,   TuxTest },
{ TEXT("(TransTest) XYZ Rotation in D3DMTS_WORLD, Frame #6                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+116,   TuxTest },
{ TEXT("(TransTest) XYZ Rotation in D3DMTS_WORLD, Frame #7                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+117,   TuxTest },
{ TEXT("(TransTest) XYZ Rotation in D3DMTS_WORLD, Frame #8                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+118,   TuxTest },
{ TEXT("(TransTest) XYZ Rotation in D3DMTS_WORLD, Frame #9                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+119,   TuxTest },
{ TEXT("(TransTest) XYZ Rotation in D3DMTS_WORLD, Frame #10                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+120,   TuxTest },
{ TEXT("(TransTest) XYZ Rotation in D3DMTS_WORLD, Frame #11                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+121,   TuxTest },
{ TEXT("(TransTest) XYZ Rotation in D3DMTS_WORLD, Frame #12                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+122,   TuxTest },
{ TEXT("(TransTest) XYZ Rotation in D3DMTS_WORLD, Frame #13                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+123,   TuxTest },
{ TEXT("(TransTest) XYZ Rotation in D3DMTS_WORLD, Frame #14                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+124,   TuxTest },
{ TEXT("(TransTest) XYZ Rotation in D3DMTS_WORLD, Frame #15                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+125,   TuxTest },
{ TEXT("(TransTest) XYZ Rotation in D3DMTS_WORLD, Frame #16                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+126,   TuxTest },
{ TEXT("(TransTest) XYZ Rotation in D3DMTS_WORLD, Frame #17                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+127,   TuxTest },
{ TEXT("(TransTest) XYZ Rotation in D3DMTS_WORLD, Frame #18                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+128,   TuxTest },
{ TEXT("(TransTest) XYZ Rotation in D3DMTS_WORLD, Frame #19                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+129,   TuxTest },
{ TEXT("(TransTest) XYZ Rotation in D3DMTS_WORLD, Frame #20                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+130,   TuxTest },
{ TEXT("(TransTest) XYZ Rotation in D3DMTS_WORLD, Frame #21                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+131,   TuxTest },
{ TEXT("(TransTest) XYZ Rotation in D3DMTS_WORLD, Frame #22                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+132,   TuxTest },
{ TEXT("(TransTest) XYZ Rotation in D3DMTS_WORLD, Frame #23                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+133,   TuxTest },
{ TEXT("(TransTest) XYZ Rotation in D3DMTS_WORLD, Frame #24                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+134,   TuxTest },
{ TEXT("(TransTest) XYZ Rotation in D3DMTS_WORLD, Frame #25                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+135,   TuxTest },
{ TEXT("(TransTest) XYZ Rotation in D3DMTS_WORLD, Frame #26                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+136,   TuxTest },
{ TEXT("(TransTest) XYZ Rotation in D3DMTS_WORLD, Frame #27                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+137,   TuxTest },
{ TEXT("(TransTest) XZY Rotation in D3DMTS_WORLD, Frame #1                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+138,   TuxTest },
{ TEXT("(TransTest) XZY Rotation in D3DMTS_WORLD, Frame #2                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+139,   TuxTest },
{ TEXT("(TransTest) XZY Rotation in D3DMTS_WORLD, Frame #3                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+140,   TuxTest },
{ TEXT("(TransTest) XZY Rotation in D3DMTS_WORLD, Frame #4                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+141,   TuxTest },
{ TEXT("(TransTest) XZY Rotation in D3DMTS_WORLD, Frame #5                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+142,   TuxTest },
{ TEXT("(TransTest) XZY Rotation in D3DMTS_WORLD, Frame #6                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+143,   TuxTest },
{ TEXT("(TransTest) XZY Rotation in D3DMTS_WORLD, Frame #7                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+144,   TuxTest },
{ TEXT("(TransTest) XZY Rotation in D3DMTS_WORLD, Frame #8                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+145,   TuxTest },
{ TEXT("(TransTest) XZY Rotation in D3DMTS_WORLD, Frame #9                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+146,   TuxTest },
{ TEXT("(TransTest) XZY Rotation in D3DMTS_WORLD, Frame #10                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+147,   TuxTest },
{ TEXT("(TransTest) XZY Rotation in D3DMTS_WORLD, Frame #11                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+148,   TuxTest },
{ TEXT("(TransTest) XZY Rotation in D3DMTS_WORLD, Frame #12                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+149,   TuxTest },
{ TEXT("(TransTest) XZY Rotation in D3DMTS_WORLD, Frame #13                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+150,   TuxTest },
{ TEXT("(TransTest) XZY Rotation in D3DMTS_WORLD, Frame #14                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+151,   TuxTest },
{ TEXT("(TransTest) XZY Rotation in D3DMTS_WORLD, Frame #15                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+152,   TuxTest },
{ TEXT("(TransTest) XZY Rotation in D3DMTS_WORLD, Frame #16                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+153,   TuxTest },
{ TEXT("(TransTest) XZY Rotation in D3DMTS_WORLD, Frame #17                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+154,   TuxTest },
{ TEXT("(TransTest) XZY Rotation in D3DMTS_WORLD, Frame #18                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+155,   TuxTest },
{ TEXT("(TransTest) XZY Rotation in D3DMTS_WORLD, Frame #19                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+156,   TuxTest },
{ TEXT("(TransTest) XZY Rotation in D3DMTS_WORLD, Frame #20                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+157,   TuxTest },
{ TEXT("(TransTest) XZY Rotation in D3DMTS_WORLD, Frame #21                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+158,   TuxTest },
{ TEXT("(TransTest) XZY Rotation in D3DMTS_WORLD, Frame #22                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+159,   TuxTest },
{ TEXT("(TransTest) XZY Rotation in D3DMTS_WORLD, Frame #23                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+160,   TuxTest },
{ TEXT("(TransTest) XZY Rotation in D3DMTS_WORLD, Frame #24                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+161,   TuxTest },
{ TEXT("(TransTest) XZY Rotation in D3DMTS_WORLD, Frame #25                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+162,   TuxTest },
{ TEXT("(TransTest) XZY Rotation in D3DMTS_WORLD, Frame #26                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+163,   TuxTest },
{ TEXT("(TransTest) XZY Rotation in D3DMTS_WORLD, Frame #27                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+164,   TuxTest },
{ TEXT("(TransTest) YXZ Rotation in D3DMTS_WORLD, Frame #1                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+165,   TuxTest },
{ TEXT("(TransTest) YXZ Rotation in D3DMTS_WORLD, Frame #2                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+166,   TuxTest },
{ TEXT("(TransTest) YXZ Rotation in D3DMTS_WORLD, Frame #3                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+167,   TuxTest },
{ TEXT("(TransTest) YXZ Rotation in D3DMTS_WORLD, Frame #4                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+168,   TuxTest },
{ TEXT("(TransTest) YXZ Rotation in D3DMTS_WORLD, Frame #5                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+169,   TuxTest },
{ TEXT("(TransTest) YXZ Rotation in D3DMTS_WORLD, Frame #6                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+170,   TuxTest },
{ TEXT("(TransTest) YXZ Rotation in D3DMTS_WORLD, Frame #7                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+171,   TuxTest },
{ TEXT("(TransTest) YXZ Rotation in D3DMTS_WORLD, Frame #8                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+172,   TuxTest },
{ TEXT("(TransTest) YXZ Rotation in D3DMTS_WORLD, Frame #9                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+173,   TuxTest },
{ TEXT("(TransTest) YXZ Rotation in D3DMTS_WORLD, Frame #10                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+174,   TuxTest },
{ TEXT("(TransTest) YXZ Rotation in D3DMTS_WORLD, Frame #11                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+175,   TuxTest },
{ TEXT("(TransTest) YXZ Rotation in D3DMTS_WORLD, Frame #12                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+176,   TuxTest },
{ TEXT("(TransTest) YXZ Rotation in D3DMTS_WORLD, Frame #13                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+177,   TuxTest },
{ TEXT("(TransTest) YXZ Rotation in D3DMTS_WORLD, Frame #14                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+178,   TuxTest },
{ TEXT("(TransTest) YXZ Rotation in D3DMTS_WORLD, Frame #15                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+179,   TuxTest },
{ TEXT("(TransTest) YXZ Rotation in D3DMTS_WORLD, Frame #16                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+180,   TuxTest },
{ TEXT("(TransTest) YXZ Rotation in D3DMTS_WORLD, Frame #17                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+181,   TuxTest },
{ TEXT("(TransTest) YXZ Rotation in D3DMTS_WORLD, Frame #18                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+182,   TuxTest },
{ TEXT("(TransTest) YXZ Rotation in D3DMTS_WORLD, Frame #19                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+183,   TuxTest },
{ TEXT("(TransTest) YXZ Rotation in D3DMTS_WORLD, Frame #20                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+184,   TuxTest },
{ TEXT("(TransTest) YXZ Rotation in D3DMTS_WORLD, Frame #21                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+185,   TuxTest },
{ TEXT("(TransTest) YXZ Rotation in D3DMTS_WORLD, Frame #22                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+186,   TuxTest },
{ TEXT("(TransTest) YXZ Rotation in D3DMTS_WORLD, Frame #23                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+187,   TuxTest },
{ TEXT("(TransTest) YXZ Rotation in D3DMTS_WORLD, Frame #24                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+188,   TuxTest },
{ TEXT("(TransTest) YXZ Rotation in D3DMTS_WORLD, Frame #25                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+189,   TuxTest },
{ TEXT("(TransTest) YXZ Rotation in D3DMTS_WORLD, Frame #26                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+190,   TuxTest },
{ TEXT("(TransTest) YXZ Rotation in D3DMTS_WORLD, Frame #27                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+191,   TuxTest },
{ TEXT("(TransTest) YZX Rotation in D3DMTS_WORLD, Frame #1                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+192,   TuxTest },
{ TEXT("(TransTest) YZX Rotation in D3DMTS_WORLD, Frame #2                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+193,   TuxTest },
{ TEXT("(TransTest) YZX Rotation in D3DMTS_WORLD, Frame #3                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+194,   TuxTest },
{ TEXT("(TransTest) YZX Rotation in D3DMTS_WORLD, Frame #4                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+195,   TuxTest },
{ TEXT("(TransTest) YZX Rotation in D3DMTS_WORLD, Frame #5                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+196,   TuxTest },
{ TEXT("(TransTest) YZX Rotation in D3DMTS_WORLD, Frame #6                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+197,   TuxTest },
{ TEXT("(TransTest) YZX Rotation in D3DMTS_WORLD, Frame #7                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+198,   TuxTest },
{ TEXT("(TransTest) YZX Rotation in D3DMTS_WORLD, Frame #8                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+199,   TuxTest },
{ TEXT("(TransTest) YZX Rotation in D3DMTS_WORLD, Frame #9                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+200,   TuxTest },
{ TEXT("(TransTest) YZX Rotation in D3DMTS_WORLD, Frame #10                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+201,   TuxTest },
{ TEXT("(TransTest) YZX Rotation in D3DMTS_WORLD, Frame #11                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+202,   TuxTest },
{ TEXT("(TransTest) YZX Rotation in D3DMTS_WORLD, Frame #12                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+203,   TuxTest },
{ TEXT("(TransTest) YZX Rotation in D3DMTS_WORLD, Frame #13                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+204,   TuxTest },
{ TEXT("(TransTest) YZX Rotation in D3DMTS_WORLD, Frame #14                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+205,   TuxTest },
{ TEXT("(TransTest) YZX Rotation in D3DMTS_WORLD, Frame #15                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+206,   TuxTest },
{ TEXT("(TransTest) YZX Rotation in D3DMTS_WORLD, Frame #16                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+207,   TuxTest },
{ TEXT("(TransTest) YZX Rotation in D3DMTS_WORLD, Frame #17                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+208,   TuxTest },
{ TEXT("(TransTest) YZX Rotation in D3DMTS_WORLD, Frame #18                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+209,   TuxTest },
{ TEXT("(TransTest) YZX Rotation in D3DMTS_WORLD, Frame #19                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+210,   TuxTest },
{ TEXT("(TransTest) YZX Rotation in D3DMTS_WORLD, Frame #20                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+211,   TuxTest },
{ TEXT("(TransTest) YZX Rotation in D3DMTS_WORLD, Frame #21                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+212,   TuxTest },
{ TEXT("(TransTest) YZX Rotation in D3DMTS_WORLD, Frame #22                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+213,   TuxTest },
{ TEXT("(TransTest) YZX Rotation in D3DMTS_WORLD, Frame #23                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+214,   TuxTest },
{ TEXT("(TransTest) YZX Rotation in D3DMTS_WORLD, Frame #24                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+215,   TuxTest },
{ TEXT("(TransTest) YZX Rotation in D3DMTS_WORLD, Frame #25                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+216,   TuxTest },
{ TEXT("(TransTest) YZX Rotation in D3DMTS_WORLD, Frame #26                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+217,   TuxTest },
{ TEXT("(TransTest) YZX Rotation in D3DMTS_WORLD, Frame #27                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+218,   TuxTest },
{ TEXT("(TransTest) ZXY Rotation in D3DMTS_WORLD, Frame #1                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+219,   TuxTest },
{ TEXT("(TransTest) ZXY Rotation in D3DMTS_WORLD, Frame #2                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+220,   TuxTest },
{ TEXT("(TransTest) ZXY Rotation in D3DMTS_WORLD, Frame #3                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+221,   TuxTest },
{ TEXT("(TransTest) ZXY Rotation in D3DMTS_WORLD, Frame #4                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+222,   TuxTest },
{ TEXT("(TransTest) ZXY Rotation in D3DMTS_WORLD, Frame #5                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+223,   TuxTest },
{ TEXT("(TransTest) ZXY Rotation in D3DMTS_WORLD, Frame #6                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+224,   TuxTest },
{ TEXT("(TransTest) ZXY Rotation in D3DMTS_WORLD, Frame #7                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+225,   TuxTest },
{ TEXT("(TransTest) ZXY Rotation in D3DMTS_WORLD, Frame #8                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+226,   TuxTest },
{ TEXT("(TransTest) ZXY Rotation in D3DMTS_WORLD, Frame #9                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+227,   TuxTest },
{ TEXT("(TransTest) ZXY Rotation in D3DMTS_WORLD, Frame #10                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+228,   TuxTest },
{ TEXT("(TransTest) ZXY Rotation in D3DMTS_WORLD, Frame #11                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+229,   TuxTest },
{ TEXT("(TransTest) ZXY Rotation in D3DMTS_WORLD, Frame #12                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+230,   TuxTest },
{ TEXT("(TransTest) ZXY Rotation in D3DMTS_WORLD, Frame #13                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+231,   TuxTest },
{ TEXT("(TransTest) ZXY Rotation in D3DMTS_WORLD, Frame #14                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+232,   TuxTest },
{ TEXT("(TransTest) ZXY Rotation in D3DMTS_WORLD, Frame #15                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+233,   TuxTest },
{ TEXT("(TransTest) ZXY Rotation in D3DMTS_WORLD, Frame #16                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+234,   TuxTest },
{ TEXT("(TransTest) ZXY Rotation in D3DMTS_WORLD, Frame #17                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+235,   TuxTest },
{ TEXT("(TransTest) ZXY Rotation in D3DMTS_WORLD, Frame #18                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+236,   TuxTest },
{ TEXT("(TransTest) ZXY Rotation in D3DMTS_WORLD, Frame #19                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+237,   TuxTest },
{ TEXT("(TransTest) ZXY Rotation in D3DMTS_WORLD, Frame #20                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+238,   TuxTest },
{ TEXT("(TransTest) ZXY Rotation in D3DMTS_WORLD, Frame #21                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+239,   TuxTest },
{ TEXT("(TransTest) ZXY Rotation in D3DMTS_WORLD, Frame #22                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+240,   TuxTest },
{ TEXT("(TransTest) ZXY Rotation in D3DMTS_WORLD, Frame #23                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+241,   TuxTest },
{ TEXT("(TransTest) ZXY Rotation in D3DMTS_WORLD, Frame #24                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+242,   TuxTest },
{ TEXT("(TransTest) ZXY Rotation in D3DMTS_WORLD, Frame #25                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+243,   TuxTest },
{ TEXT("(TransTest) ZXY Rotation in D3DMTS_WORLD, Frame #26                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+244,   TuxTest },
{ TEXT("(TransTest) ZXY Rotation in D3DMTS_WORLD, Frame #27                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+245,   TuxTest },
{ TEXT("(TransTest) ZYX Rotation in D3DMTS_WORLD, Frame #1                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+246,   TuxTest },
{ TEXT("(TransTest) ZYX Rotation in D3DMTS_WORLD, Frame #2                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+247,   TuxTest },
{ TEXT("(TransTest) ZYX Rotation in D3DMTS_WORLD, Frame #3                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+248,   TuxTest },
{ TEXT("(TransTest) ZYX Rotation in D3DMTS_WORLD, Frame #4                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+249,   TuxTest },
{ TEXT("(TransTest) ZYX Rotation in D3DMTS_WORLD, Frame #5                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+250,   TuxTest },
{ TEXT("(TransTest) ZYX Rotation in D3DMTS_WORLD, Frame #6                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+251,   TuxTest },
{ TEXT("(TransTest) ZYX Rotation in D3DMTS_WORLD, Frame #7                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+252,   TuxTest },
{ TEXT("(TransTest) ZYX Rotation in D3DMTS_WORLD, Frame #8                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+253,   TuxTest },
{ TEXT("(TransTest) ZYX Rotation in D3DMTS_WORLD, Frame #9                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+254,   TuxTest },
{ TEXT("(TransTest) ZYX Rotation in D3DMTS_WORLD, Frame #10                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+255,   TuxTest },
{ TEXT("(TransTest) ZYX Rotation in D3DMTS_WORLD, Frame #11                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+256,   TuxTest },
{ TEXT("(TransTest) ZYX Rotation in D3DMTS_WORLD, Frame #12                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+257,   TuxTest },
{ TEXT("(TransTest) ZYX Rotation in D3DMTS_WORLD, Frame #13                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+258,   TuxTest },
{ TEXT("(TransTest) ZYX Rotation in D3DMTS_WORLD, Frame #14                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+259,   TuxTest },
{ TEXT("(TransTest) ZYX Rotation in D3DMTS_WORLD, Frame #15                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+260,   TuxTest },
{ TEXT("(TransTest) ZYX Rotation in D3DMTS_WORLD, Frame #16                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+261,   TuxTest },
{ TEXT("(TransTest) ZYX Rotation in D3DMTS_WORLD, Frame #17                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+262,   TuxTest },
{ TEXT("(TransTest) ZYX Rotation in D3DMTS_WORLD, Frame #18                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+263,   TuxTest },
{ TEXT("(TransTest) ZYX Rotation in D3DMTS_WORLD, Frame #19                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+264,   TuxTest },
{ TEXT("(TransTest) ZYX Rotation in D3DMTS_WORLD, Frame #20                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+265,   TuxTest },
{ TEXT("(TransTest) ZYX Rotation in D3DMTS_WORLD, Frame #21                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+266,   TuxTest },
{ TEXT("(TransTest) ZYX Rotation in D3DMTS_WORLD, Frame #22                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+267,   TuxTest },
{ TEXT("(TransTest) ZYX Rotation in D3DMTS_WORLD, Frame #23                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+268,   TuxTest },
{ TEXT("(TransTest) ZYX Rotation in D3DMTS_WORLD, Frame #24                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+269,   TuxTest },
{ TEXT("(TransTest) ZYX Rotation in D3DMTS_WORLD, Frame #25                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+270,   TuxTest },
{ TEXT("(TransTest) ZYX Rotation in D3DMTS_WORLD, Frame #26                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+271,   TuxTest },
{ TEXT("(TransTest) ZYX Rotation in D3DMTS_WORLD, Frame #27                                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+272,   TuxTest },
{ TEXT("(TransTest) X   Rotation in D3DMTS_VIEW, Frame #1                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+273,   TuxTest },
{ TEXT("(TransTest) X   Rotation in D3DMTS_VIEW, Frame #2                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+274,   TuxTest },
{ TEXT("(TransTest) X   Rotation in D3DMTS_VIEW, Frame #3                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+275,   TuxTest },
{ TEXT("(TransTest) X   Rotation in D3DMTS_VIEW, Frame #4                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+276,   TuxTest },
{ TEXT("(TransTest) X   Rotation in D3DMTS_VIEW, Frame #5                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+277,   TuxTest },
{ TEXT("(TransTest) Y   Rotation in D3DMTS_VIEW, Frame #1                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+278,   TuxTest },
{ TEXT("(TransTest) Y   Rotation in D3DMTS_VIEW, Frame #2                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+279,   TuxTest },
{ TEXT("(TransTest) Y   Rotation in D3DMTS_VIEW, Frame #3                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+280,   TuxTest },
{ TEXT("(TransTest) Y   Rotation in D3DMTS_VIEW, Frame #4                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+281,   TuxTest },
{ TEXT("(TransTest) Y   Rotation in D3DMTS_VIEW, Frame #5                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+282,   TuxTest },
{ TEXT("(TransTest) Z   Rotation in D3DMTS_VIEW, Frame #1                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+283,   TuxTest },
{ TEXT("(TransTest) Z   Rotation in D3DMTS_VIEW, Frame #2                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+284,   TuxTest },
{ TEXT("(TransTest) Z   Rotation in D3DMTS_VIEW, Frame #3                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+285,   TuxTest },
{ TEXT("(TransTest) Z   Rotation in D3DMTS_VIEW, Frame #4                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+286,   TuxTest },
{ TEXT("(TransTest) Z   Rotation in D3DMTS_VIEW, Frame #5                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+287,   TuxTest },
{ TEXT("(TransTest) XY  Rotation in D3DMTS_VIEW, Frame #1                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+288,   TuxTest },
{ TEXT("(TransTest) XY  Rotation in D3DMTS_VIEW, Frame #2                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+289,   TuxTest },
{ TEXT("(TransTest) XY  Rotation in D3DMTS_VIEW, Frame #3                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+290,   TuxTest },
{ TEXT("(TransTest) XY  Rotation in D3DMTS_VIEW, Frame #4                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+291,   TuxTest },
{ TEXT("(TransTest) XY  Rotation in D3DMTS_VIEW, Frame #5                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+292,   TuxTest },
{ TEXT("(TransTest) XY  Rotation in D3DMTS_VIEW, Frame #6                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+293,   TuxTest },
{ TEXT("(TransTest) XY  Rotation in D3DMTS_VIEW, Frame #7                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+294,   TuxTest },
{ TEXT("(TransTest) XY  Rotation in D3DMTS_VIEW, Frame #8                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+295,   TuxTest },
{ TEXT("(TransTest) XY  Rotation in D3DMTS_VIEW, Frame #9                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+296,   TuxTest },
{ TEXT("(TransTest) XY  Rotation in D3DMTS_VIEW, Frame #10                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+297,   TuxTest },
{ TEXT("(TransTest) XY  Rotation in D3DMTS_VIEW, Frame #11                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+298,   TuxTest },
{ TEXT("(TransTest) XY  Rotation in D3DMTS_VIEW, Frame #12                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+299,   TuxTest },
{ TEXT("(TransTest) XY  Rotation in D3DMTS_VIEW, Frame #13                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+300,   TuxTest },
{ TEXT("(TransTest) XY  Rotation in D3DMTS_VIEW, Frame #14                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+301,   TuxTest },
{ TEXT("(TransTest) XY  Rotation in D3DMTS_VIEW, Frame #15                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+302,   TuxTest },
{ TEXT("(TransTest) XY  Rotation in D3DMTS_VIEW, Frame #16                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+303,   TuxTest },
{ TEXT("(TransTest) XZ  Rotation in D3DMTS_VIEW, Frame #1                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+304,   TuxTest },
{ TEXT("(TransTest) XZ  Rotation in D3DMTS_VIEW, Frame #2                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+305,   TuxTest },
{ TEXT("(TransTest) XZ  Rotation in D3DMTS_VIEW, Frame #3                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+306,   TuxTest },
{ TEXT("(TransTest) XZ  Rotation in D3DMTS_VIEW, Frame #4                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+307,   TuxTest },
{ TEXT("(TransTest) XZ  Rotation in D3DMTS_VIEW, Frame #5                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+308,   TuxTest },
{ TEXT("(TransTest) XZ  Rotation in D3DMTS_VIEW, Frame #6                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+309,   TuxTest },
{ TEXT("(TransTest) XZ  Rotation in D3DMTS_VIEW, Frame #7                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+310,   TuxTest },
{ TEXT("(TransTest) XZ  Rotation in D3DMTS_VIEW, Frame #8                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+311,   TuxTest },
{ TEXT("(TransTest) XZ  Rotation in D3DMTS_VIEW, Frame #9                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+312,   TuxTest },
{ TEXT("(TransTest) XZ  Rotation in D3DMTS_VIEW, Frame #10                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+313,   TuxTest },
{ TEXT("(TransTest) XZ  Rotation in D3DMTS_VIEW, Frame #11                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+314,   TuxTest },
{ TEXT("(TransTest) XZ  Rotation in D3DMTS_VIEW, Frame #12                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+315,   TuxTest },
{ TEXT("(TransTest) XZ  Rotation in D3DMTS_VIEW, Frame #13                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+316,   TuxTest },
{ TEXT("(TransTest) XZ  Rotation in D3DMTS_VIEW, Frame #14                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+317,   TuxTest },
{ TEXT("(TransTest) XZ  Rotation in D3DMTS_VIEW, Frame #15                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+318,   TuxTest },
{ TEXT("(TransTest) XZ  Rotation in D3DMTS_VIEW, Frame #16                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+319,   TuxTest },
{ TEXT("(TransTest) YX  Rotation in D3DMTS_VIEW, Frame #1                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+320,   TuxTest },
{ TEXT("(TransTest) YX  Rotation in D3DMTS_VIEW, Frame #2                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+321,   TuxTest },
{ TEXT("(TransTest) YX  Rotation in D3DMTS_VIEW, Frame #3                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+322,   TuxTest },
{ TEXT("(TransTest) YX  Rotation in D3DMTS_VIEW, Frame #4                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+323,   TuxTest },
{ TEXT("(TransTest) YX  Rotation in D3DMTS_VIEW, Frame #5                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+324,   TuxTest },
{ TEXT("(TransTest) YX  Rotation in D3DMTS_VIEW, Frame #6                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+325,   TuxTest },
{ TEXT("(TransTest) YX  Rotation in D3DMTS_VIEW, Frame #7                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+326,   TuxTest },
{ TEXT("(TransTest) YX  Rotation in D3DMTS_VIEW, Frame #8                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+327,   TuxTest },
{ TEXT("(TransTest) YX  Rotation in D3DMTS_VIEW, Frame #9                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+328,   TuxTest },
{ TEXT("(TransTest) YX  Rotation in D3DMTS_VIEW, Frame #10                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+329,   TuxTest },
{ TEXT("(TransTest) YX  Rotation in D3DMTS_VIEW, Frame #11                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+330,   TuxTest },
{ TEXT("(TransTest) YX  Rotation in D3DMTS_VIEW, Frame #12                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+331,   TuxTest },
{ TEXT("(TransTest) YX  Rotation in D3DMTS_VIEW, Frame #13                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+332,   TuxTest },
{ TEXT("(TransTest) YX  Rotation in D3DMTS_VIEW, Frame #14                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+333,   TuxTest },
{ TEXT("(TransTest) YX  Rotation in D3DMTS_VIEW, Frame #15                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+334,   TuxTest },
{ TEXT("(TransTest) YX  Rotation in D3DMTS_VIEW, Frame #16                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+335,   TuxTest },
{ TEXT("(TransTest) YZ  Rotation in D3DMTS_VIEW, Frame #1                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+336,   TuxTest },
{ TEXT("(TransTest) YZ  Rotation in D3DMTS_VIEW, Frame #2                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+337,   TuxTest },
{ TEXT("(TransTest) YZ  Rotation in D3DMTS_VIEW, Frame #3                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+338,   TuxTest },
{ TEXT("(TransTest) YZ  Rotation in D3DMTS_VIEW, Frame #4                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+339,   TuxTest },
{ TEXT("(TransTest) YZ  Rotation in D3DMTS_VIEW, Frame #5                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+340,   TuxTest },
{ TEXT("(TransTest) YZ  Rotation in D3DMTS_VIEW, Frame #6                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+341,   TuxTest },
{ TEXT("(TransTest) YZ  Rotation in D3DMTS_VIEW, Frame #7                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+342,   TuxTest },
{ TEXT("(TransTest) YZ  Rotation in D3DMTS_VIEW, Frame #8                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+343,   TuxTest },
{ TEXT("(TransTest) YZ  Rotation in D3DMTS_VIEW, Frame #9                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+344,   TuxTest },
{ TEXT("(TransTest) YZ  Rotation in D3DMTS_VIEW, Frame #10                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+345,   TuxTest },
{ TEXT("(TransTest) YZ  Rotation in D3DMTS_VIEW, Frame #11                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+346,   TuxTest },
{ TEXT("(TransTest) YZ  Rotation in D3DMTS_VIEW, Frame #12                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+347,   TuxTest },
{ TEXT("(TransTest) YZ  Rotation in D3DMTS_VIEW, Frame #13                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+348,   TuxTest },
{ TEXT("(TransTest) YZ  Rotation in D3DMTS_VIEW, Frame #14                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+349,   TuxTest },
{ TEXT("(TransTest) YZ  Rotation in D3DMTS_VIEW, Frame #15                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+350,   TuxTest },
{ TEXT("(TransTest) YZ  Rotation in D3DMTS_VIEW, Frame #16                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+351,   TuxTest },
{ TEXT("(TransTest) ZX  Rotation in D3DMTS_VIEW, Frame #1                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+352,   TuxTest },
{ TEXT("(TransTest) ZX  Rotation in D3DMTS_VIEW, Frame #2                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+353,   TuxTest },
{ TEXT("(TransTest) ZX  Rotation in D3DMTS_VIEW, Frame #3                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+354,   TuxTest },
{ TEXT("(TransTest) ZX  Rotation in D3DMTS_VIEW, Frame #4                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+355,   TuxTest },
{ TEXT("(TransTest) ZX  Rotation in D3DMTS_VIEW, Frame #5                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+356,   TuxTest },
{ TEXT("(TransTest) ZX  Rotation in D3DMTS_VIEW, Frame #6                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+357,   TuxTest },
{ TEXT("(TransTest) ZX  Rotation in D3DMTS_VIEW, Frame #7                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+358,   TuxTest },
{ TEXT("(TransTest) ZX  Rotation in D3DMTS_VIEW, Frame #8                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+359,   TuxTest },
{ TEXT("(TransTest) ZX  Rotation in D3DMTS_VIEW, Frame #9                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+360,   TuxTest },
{ TEXT("(TransTest) ZX  Rotation in D3DMTS_VIEW, Frame #10                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+361,   TuxTest },
{ TEXT("(TransTest) ZX  Rotation in D3DMTS_VIEW, Frame #11                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+362,   TuxTest },
{ TEXT("(TransTest) ZX  Rotation in D3DMTS_VIEW, Frame #12                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+363,   TuxTest },
{ TEXT("(TransTest) ZX  Rotation in D3DMTS_VIEW, Frame #13                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+364,   TuxTest },
{ TEXT("(TransTest) ZX  Rotation in D3DMTS_VIEW, Frame #14                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+365,   TuxTest },
{ TEXT("(TransTest) ZX  Rotation in D3DMTS_VIEW, Frame #15                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+366,   TuxTest },
{ TEXT("(TransTest) ZX  Rotation in D3DMTS_VIEW, Frame #16                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+367,   TuxTest },
{ TEXT("(TransTest) ZY  Rotation in D3DMTS_VIEW, Frame #1                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+368,   TuxTest },
{ TEXT("(TransTest) ZY  Rotation in D3DMTS_VIEW, Frame #2                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+369,   TuxTest },
{ TEXT("(TransTest) ZY  Rotation in D3DMTS_VIEW, Frame #3                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+370,   TuxTest },
{ TEXT("(TransTest) ZY  Rotation in D3DMTS_VIEW, Frame #4                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+371,   TuxTest },
{ TEXT("(TransTest) ZY  Rotation in D3DMTS_VIEW, Frame #5                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+372,   TuxTest },
{ TEXT("(TransTest) ZY  Rotation in D3DMTS_VIEW, Frame #6                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+373,   TuxTest },
{ TEXT("(TransTest) ZY  Rotation in D3DMTS_VIEW, Frame #7                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+374,   TuxTest },
{ TEXT("(TransTest) ZY  Rotation in D3DMTS_VIEW, Frame #8                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+375,   TuxTest },
{ TEXT("(TransTest) ZY  Rotation in D3DMTS_VIEW, Frame #9                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+376,   TuxTest },
{ TEXT("(TransTest) ZY  Rotation in D3DMTS_VIEW, Frame #10                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+377,   TuxTest },
{ TEXT("(TransTest) ZY  Rotation in D3DMTS_VIEW, Frame #11                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+378,   TuxTest },
{ TEXT("(TransTest) ZY  Rotation in D3DMTS_VIEW, Frame #12                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+379,   TuxTest },
{ TEXT("(TransTest) ZY  Rotation in D3DMTS_VIEW, Frame #13                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+380,   TuxTest },
{ TEXT("(TransTest) ZY  Rotation in D3DMTS_VIEW, Frame #14                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+381,   TuxTest },
{ TEXT("(TransTest) ZY  Rotation in D3DMTS_VIEW, Frame #15                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+382,   TuxTest },
{ TEXT("(TransTest) ZY  Rotation in D3DMTS_VIEW, Frame #16                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+383,   TuxTest },
{ TEXT("(TransTest) XYZ Rotation in D3DMTS_VIEW, Frame #1                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+384,   TuxTest },
{ TEXT("(TransTest) XYZ Rotation in D3DMTS_VIEW, Frame #2                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+385,   TuxTest },
{ TEXT("(TransTest) XYZ Rotation in D3DMTS_VIEW, Frame #3                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+386,   TuxTest },
{ TEXT("(TransTest) XYZ Rotation in D3DMTS_VIEW, Frame #4                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+387,   TuxTest },
{ TEXT("(TransTest) XYZ Rotation in D3DMTS_VIEW, Frame #5                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+388,   TuxTest },
{ TEXT("(TransTest) XYZ Rotation in D3DMTS_VIEW, Frame #6                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+389,   TuxTest },
{ TEXT("(TransTest) XYZ Rotation in D3DMTS_VIEW, Frame #7                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+390,   TuxTest },
{ TEXT("(TransTest) XYZ Rotation in D3DMTS_VIEW, Frame #8                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+391,   TuxTest },
{ TEXT("(TransTest) XYZ Rotation in D3DMTS_VIEW, Frame #9                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+392,   TuxTest },
{ TEXT("(TransTest) XYZ Rotation in D3DMTS_VIEW, Frame #10                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+393,   TuxTest },
{ TEXT("(TransTest) XYZ Rotation in D3DMTS_VIEW, Frame #11                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+394,   TuxTest },
{ TEXT("(TransTest) XYZ Rotation in D3DMTS_VIEW, Frame #12                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+395,   TuxTest },
{ TEXT("(TransTest) XYZ Rotation in D3DMTS_VIEW, Frame #13                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+396,   TuxTest },
{ TEXT("(TransTest) XYZ Rotation in D3DMTS_VIEW, Frame #14                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+397,   TuxTest },
{ TEXT("(TransTest) XYZ Rotation in D3DMTS_VIEW, Frame #15                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+398,   TuxTest },
{ TEXT("(TransTest) XYZ Rotation in D3DMTS_VIEW, Frame #16                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+399,   TuxTest },
{ TEXT("(TransTest) XYZ Rotation in D3DMTS_VIEW, Frame #17                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+400,   TuxTest },
{ TEXT("(TransTest) XYZ Rotation in D3DMTS_VIEW, Frame #18                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+401,   TuxTest },
{ TEXT("(TransTest) XYZ Rotation in D3DMTS_VIEW, Frame #19                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+402,   TuxTest },
{ TEXT("(TransTest) XYZ Rotation in D3DMTS_VIEW, Frame #20                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+403,   TuxTest },
{ TEXT("(TransTest) XYZ Rotation in D3DMTS_VIEW, Frame #21                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+404,   TuxTest },
{ TEXT("(TransTest) XYZ Rotation in D3DMTS_VIEW, Frame #22                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+405,   TuxTest },
{ TEXT("(TransTest) XYZ Rotation in D3DMTS_VIEW, Frame #23                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+406,   TuxTest },
{ TEXT("(TransTest) XYZ Rotation in D3DMTS_VIEW, Frame #24                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+407,   TuxTest },
{ TEXT("(TransTest) XYZ Rotation in D3DMTS_VIEW, Frame #25                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+408,   TuxTest },
{ TEXT("(TransTest) XYZ Rotation in D3DMTS_VIEW, Frame #26                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+409,   TuxTest },
{ TEXT("(TransTest) XYZ Rotation in D3DMTS_VIEW, Frame #27                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+410,   TuxTest },
{ TEXT("(TransTest) XZY Rotation in D3DMTS_VIEW, Frame #1                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+411,   TuxTest },
{ TEXT("(TransTest) XZY Rotation in D3DMTS_VIEW, Frame #2                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+412,   TuxTest },
{ TEXT("(TransTest) XZY Rotation in D3DMTS_VIEW, Frame #3                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+413,   TuxTest },
{ TEXT("(TransTest) XZY Rotation in D3DMTS_VIEW, Frame #4                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+414,   TuxTest },
{ TEXT("(TransTest) XZY Rotation in D3DMTS_VIEW, Frame #5                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+415,   TuxTest },
{ TEXT("(TransTest) XZY Rotation in D3DMTS_VIEW, Frame #6                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+416,   TuxTest },
{ TEXT("(TransTest) XZY Rotation in D3DMTS_VIEW, Frame #7                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+417,   TuxTest },
{ TEXT("(TransTest) XZY Rotation in D3DMTS_VIEW, Frame #8                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+418,   TuxTest },
{ TEXT("(TransTest) XZY Rotation in D3DMTS_VIEW, Frame #9                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+419,   TuxTest },
{ TEXT("(TransTest) XZY Rotation in D3DMTS_VIEW, Frame #10                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+420,   TuxTest },
{ TEXT("(TransTest) XZY Rotation in D3DMTS_VIEW, Frame #11                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+421,   TuxTest },
{ TEXT("(TransTest) XZY Rotation in D3DMTS_VIEW, Frame #12                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+422,   TuxTest },
{ TEXT("(TransTest) XZY Rotation in D3DMTS_VIEW, Frame #13                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+423,   TuxTest },
{ TEXT("(TransTest) XZY Rotation in D3DMTS_VIEW, Frame #14                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+424,   TuxTest },
{ TEXT("(TransTest) XZY Rotation in D3DMTS_VIEW, Frame #15                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+425,   TuxTest },
{ TEXT("(TransTest) XZY Rotation in D3DMTS_VIEW, Frame #16                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+426,   TuxTest },
{ TEXT("(TransTest) XZY Rotation in D3DMTS_VIEW, Frame #17                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+427,   TuxTest },
{ TEXT("(TransTest) XZY Rotation in D3DMTS_VIEW, Frame #18                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+428,   TuxTest },
{ TEXT("(TransTest) XZY Rotation in D3DMTS_VIEW, Frame #19                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+429,   TuxTest },
{ TEXT("(TransTest) XZY Rotation in D3DMTS_VIEW, Frame #20                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+430,   TuxTest },
{ TEXT("(TransTest) XZY Rotation in D3DMTS_VIEW, Frame #21                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+431,   TuxTest },
{ TEXT("(TransTest) XZY Rotation in D3DMTS_VIEW, Frame #22                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+432,   TuxTest },
{ TEXT("(TransTest) XZY Rotation in D3DMTS_VIEW, Frame #23                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+433,   TuxTest },
{ TEXT("(TransTest) XZY Rotation in D3DMTS_VIEW, Frame #24                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+434,   TuxTest },
{ TEXT("(TransTest) XZY Rotation in D3DMTS_VIEW, Frame #25                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+435,   TuxTest },
{ TEXT("(TransTest) XZY Rotation in D3DMTS_VIEW, Frame #26                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+436,   TuxTest },
{ TEXT("(TransTest) XZY Rotation in D3DMTS_VIEW, Frame #27                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+437,   TuxTest },
{ TEXT("(TransTest) YXZ Rotation in D3DMTS_VIEW, Frame #1                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+438,   TuxTest },
{ TEXT("(TransTest) YXZ Rotation in D3DMTS_VIEW, Frame #2                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+439,   TuxTest },
{ TEXT("(TransTest) YXZ Rotation in D3DMTS_VIEW, Frame #3                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+440,   TuxTest },
{ TEXT("(TransTest) YXZ Rotation in D3DMTS_VIEW, Frame #4                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+441,   TuxTest },
{ TEXT("(TransTest) YXZ Rotation in D3DMTS_VIEW, Frame #5                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+442,   TuxTest },
{ TEXT("(TransTest) YXZ Rotation in D3DMTS_VIEW, Frame #6                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+443,   TuxTest },
{ TEXT("(TransTest) YXZ Rotation in D3DMTS_VIEW, Frame #7                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+444,   TuxTest },
{ TEXT("(TransTest) YXZ Rotation in D3DMTS_VIEW, Frame #8                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+445,   TuxTest },
{ TEXT("(TransTest) YXZ Rotation in D3DMTS_VIEW, Frame #9                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+446,   TuxTest },
{ TEXT("(TransTest) YXZ Rotation in D3DMTS_VIEW, Frame #10                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+447,   TuxTest },
{ TEXT("(TransTest) YXZ Rotation in D3DMTS_VIEW, Frame #11                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+448,   TuxTest },
{ TEXT("(TransTest) YXZ Rotation in D3DMTS_VIEW, Frame #12                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+449,   TuxTest },
{ TEXT("(TransTest) YXZ Rotation in D3DMTS_VIEW, Frame #13                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+450,   TuxTest },
{ TEXT("(TransTest) YXZ Rotation in D3DMTS_VIEW, Frame #14                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+451,   TuxTest },
{ TEXT("(TransTest) YXZ Rotation in D3DMTS_VIEW, Frame #15                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+452,   TuxTest },
{ TEXT("(TransTest) YXZ Rotation in D3DMTS_VIEW, Frame #16                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+453,   TuxTest },
{ TEXT("(TransTest) YXZ Rotation in D3DMTS_VIEW, Frame #17                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+454,   TuxTest },
{ TEXT("(TransTest) YXZ Rotation in D3DMTS_VIEW, Frame #18                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+455,   TuxTest },
{ TEXT("(TransTest) YXZ Rotation in D3DMTS_VIEW, Frame #19                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+456,   TuxTest },
{ TEXT("(TransTest) YXZ Rotation in D3DMTS_VIEW, Frame #20                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+457,   TuxTest },
{ TEXT("(TransTest) YXZ Rotation in D3DMTS_VIEW, Frame #21                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+458,   TuxTest },
{ TEXT("(TransTest) YXZ Rotation in D3DMTS_VIEW, Frame #22                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+459,   TuxTest },
{ TEXT("(TransTest) YXZ Rotation in D3DMTS_VIEW, Frame #23                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+460,   TuxTest },
{ TEXT("(TransTest) YXZ Rotation in D3DMTS_VIEW, Frame #24                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+461,   TuxTest },
{ TEXT("(TransTest) YXZ Rotation in D3DMTS_VIEW, Frame #25                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+462,   TuxTest },
{ TEXT("(TransTest) YXZ Rotation in D3DMTS_VIEW, Frame #26                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+463,   TuxTest },
{ TEXT("(TransTest) YXZ Rotation in D3DMTS_VIEW, Frame #27                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+464,   TuxTest },
{ TEXT("(TransTest) YZX Rotation in D3DMTS_VIEW, Frame #1                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+465,   TuxTest },
{ TEXT("(TransTest) YZX Rotation in D3DMTS_VIEW, Frame #2                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+466,   TuxTest },
{ TEXT("(TransTest) YZX Rotation in D3DMTS_VIEW, Frame #3                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+467,   TuxTest },
{ TEXT("(TransTest) YZX Rotation in D3DMTS_VIEW, Frame #4                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+468,   TuxTest },
{ TEXT("(TransTest) YZX Rotation in D3DMTS_VIEW, Frame #5                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+469,   TuxTest },
{ TEXT("(TransTest) YZX Rotation in D3DMTS_VIEW, Frame #6                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+470,   TuxTest },
{ TEXT("(TransTest) YZX Rotation in D3DMTS_VIEW, Frame #7                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+471,   TuxTest },
{ TEXT("(TransTest) YZX Rotation in D3DMTS_VIEW, Frame #8                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+472,   TuxTest },
{ TEXT("(TransTest) YZX Rotation in D3DMTS_VIEW, Frame #9                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+473,   TuxTest },
{ TEXT("(TransTest) YZX Rotation in D3DMTS_VIEW, Frame #10                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+474,   TuxTest },
{ TEXT("(TransTest) YZX Rotation in D3DMTS_VIEW, Frame #11                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+475,   TuxTest },
{ TEXT("(TransTest) YZX Rotation in D3DMTS_VIEW, Frame #12                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+476,   TuxTest },
{ TEXT("(TransTest) YZX Rotation in D3DMTS_VIEW, Frame #13                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+477,   TuxTest },
{ TEXT("(TransTest) YZX Rotation in D3DMTS_VIEW, Frame #14                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+478,   TuxTest },
{ TEXT("(TransTest) YZX Rotation in D3DMTS_VIEW, Frame #15                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+479,   TuxTest },
{ TEXT("(TransTest) YZX Rotation in D3DMTS_VIEW, Frame #16                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+480,   TuxTest },
{ TEXT("(TransTest) YZX Rotation in D3DMTS_VIEW, Frame #17                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+481,   TuxTest },
{ TEXT("(TransTest) YZX Rotation in D3DMTS_VIEW, Frame #18                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+482,   TuxTest },
{ TEXT("(TransTest) YZX Rotation in D3DMTS_VIEW, Frame #19                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+483,   TuxTest },
{ TEXT("(TransTest) YZX Rotation in D3DMTS_VIEW, Frame #20                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+484,   TuxTest },
{ TEXT("(TransTest) YZX Rotation in D3DMTS_VIEW, Frame #21                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+485,   TuxTest },
{ TEXT("(TransTest) YZX Rotation in D3DMTS_VIEW, Frame #22                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+486,   TuxTest },
{ TEXT("(TransTest) YZX Rotation in D3DMTS_VIEW, Frame #23                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+487,   TuxTest },
{ TEXT("(TransTest) YZX Rotation in D3DMTS_VIEW, Frame #24                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+488,   TuxTest },
{ TEXT("(TransTest) YZX Rotation in D3DMTS_VIEW, Frame #25                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+489,   TuxTest },
{ TEXT("(TransTest) YZX Rotation in D3DMTS_VIEW, Frame #26                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+490,   TuxTest },
{ TEXT("(TransTest) YZX Rotation in D3DMTS_VIEW, Frame #27                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+491,   TuxTest },
{ TEXT("(TransTest) ZXY Rotation in D3DMTS_VIEW, Frame #1                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+492,   TuxTest },
{ TEXT("(TransTest) ZXY Rotation in D3DMTS_VIEW, Frame #2                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+493,   TuxTest },
{ TEXT("(TransTest) ZXY Rotation in D3DMTS_VIEW, Frame #3                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+494,   TuxTest },
{ TEXT("(TransTest) ZXY Rotation in D3DMTS_VIEW, Frame #4                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+495,   TuxTest },
{ TEXT("(TransTest) ZXY Rotation in D3DMTS_VIEW, Frame #5                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+496,   TuxTest },
{ TEXT("(TransTest) ZXY Rotation in D3DMTS_VIEW, Frame #6                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+497,   TuxTest },
{ TEXT("(TransTest) ZXY Rotation in D3DMTS_VIEW, Frame #7                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+498,   TuxTest },
{ TEXT("(TransTest) ZXY Rotation in D3DMTS_VIEW, Frame #8                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+499,   TuxTest },
{ TEXT("(TransTest) ZXY Rotation in D3DMTS_VIEW, Frame #9                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+500,   TuxTest },
{ TEXT("(TransTest) ZXY Rotation in D3DMTS_VIEW, Frame #10                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+501,   TuxTest },
{ TEXT("(TransTest) ZXY Rotation in D3DMTS_VIEW, Frame #11                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+502,   TuxTest },
{ TEXT("(TransTest) ZXY Rotation in D3DMTS_VIEW, Frame #12                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+503,   TuxTest },
{ TEXT("(TransTest) ZXY Rotation in D3DMTS_VIEW, Frame #13                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+504,   TuxTest },
{ TEXT("(TransTest) ZXY Rotation in D3DMTS_VIEW, Frame #14                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+505,   TuxTest },
{ TEXT("(TransTest) ZXY Rotation in D3DMTS_VIEW, Frame #15                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+506,   TuxTest },
{ TEXT("(TransTest) ZXY Rotation in D3DMTS_VIEW, Frame #16                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+507,   TuxTest },
{ TEXT("(TransTest) ZXY Rotation in D3DMTS_VIEW, Frame #17                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+508,   TuxTest },
{ TEXT("(TransTest) ZXY Rotation in D3DMTS_VIEW, Frame #18                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+509,   TuxTest },
{ TEXT("(TransTest) ZXY Rotation in D3DMTS_VIEW, Frame #19                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+510,   TuxTest },
{ TEXT("(TransTest) ZXY Rotation in D3DMTS_VIEW, Frame #20                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+511,   TuxTest },
{ TEXT("(TransTest) ZXY Rotation in D3DMTS_VIEW, Frame #21                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+512,   TuxTest },
{ TEXT("(TransTest) ZXY Rotation in D3DMTS_VIEW, Frame #22                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+513,   TuxTest },
{ TEXT("(TransTest) ZXY Rotation in D3DMTS_VIEW, Frame #23                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+514,   TuxTest },
{ TEXT("(TransTest) ZXY Rotation in D3DMTS_VIEW, Frame #24                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+515,   TuxTest },
{ TEXT("(TransTest) ZXY Rotation in D3DMTS_VIEW, Frame #25                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+516,   TuxTest },
{ TEXT("(TransTest) ZXY Rotation in D3DMTS_VIEW, Frame #26                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+517,   TuxTest },
{ TEXT("(TransTest) ZXY Rotation in D3DMTS_VIEW, Frame #27                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+518,   TuxTest },
{ TEXT("(TransTest) ZYX Rotation in D3DMTS_VIEW, Frame #1                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+519,   TuxTest },
{ TEXT("(TransTest) ZYX Rotation in D3DMTS_VIEW, Frame #2                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+520,   TuxTest },
{ TEXT("(TransTest) ZYX Rotation in D3DMTS_VIEW, Frame #3                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+521,   TuxTest },
{ TEXT("(TransTest) ZYX Rotation in D3DMTS_VIEW, Frame #4                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+522,   TuxTest },
{ TEXT("(TransTest) ZYX Rotation in D3DMTS_VIEW, Frame #5                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+523,   TuxTest },
{ TEXT("(TransTest) ZYX Rotation in D3DMTS_VIEW, Frame #6                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+524,   TuxTest },
{ TEXT("(TransTest) ZYX Rotation in D3DMTS_VIEW, Frame #7                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+525,   TuxTest },
{ TEXT("(TransTest) ZYX Rotation in D3DMTS_VIEW, Frame #8                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+526,   TuxTest },
{ TEXT("(TransTest) ZYX Rotation in D3DMTS_VIEW, Frame #9                                                        "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+527,   TuxTest },
{ TEXT("(TransTest) ZYX Rotation in D3DMTS_VIEW, Frame #10                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+528,   TuxTest },
{ TEXT("(TransTest) ZYX Rotation in D3DMTS_VIEW, Frame #11                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+529,   TuxTest },
{ TEXT("(TransTest) ZYX Rotation in D3DMTS_VIEW, Frame #12                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+530,   TuxTest },
{ TEXT("(TransTest) ZYX Rotation in D3DMTS_VIEW, Frame #13                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+531,   TuxTest },
{ TEXT("(TransTest) ZYX Rotation in D3DMTS_VIEW, Frame #14                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+532,   TuxTest },
{ TEXT("(TransTest) ZYX Rotation in D3DMTS_VIEW, Frame #15                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+533,   TuxTest },
{ TEXT("(TransTest) ZYX Rotation in D3DMTS_VIEW, Frame #16                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+534,   TuxTest },
{ TEXT("(TransTest) ZYX Rotation in D3DMTS_VIEW, Frame #17                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+535,   TuxTest },
{ TEXT("(TransTest) ZYX Rotation in D3DMTS_VIEW, Frame #18                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+536,   TuxTest },
{ TEXT("(TransTest) ZYX Rotation in D3DMTS_VIEW, Frame #19                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+537,   TuxTest },
{ TEXT("(TransTest) ZYX Rotation in D3DMTS_VIEW, Frame #20                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+538,   TuxTest },
{ TEXT("(TransTest) ZYX Rotation in D3DMTS_VIEW, Frame #21                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+539,   TuxTest },
{ TEXT("(TransTest) ZYX Rotation in D3DMTS_VIEW, Frame #22                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+540,   TuxTest },
{ TEXT("(TransTest) ZYX Rotation in D3DMTS_VIEW, Frame #23                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+541,   TuxTest },
{ TEXT("(TransTest) ZYX Rotation in D3DMTS_VIEW, Frame #24                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+542,   TuxTest },
{ TEXT("(TransTest) ZYX Rotation in D3DMTS_VIEW, Frame #25                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+543,   TuxTest },
{ TEXT("(TransTest) ZYX Rotation in D3DMTS_VIEW, Frame #26                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+544,   TuxTest },
{ TEXT("(TransTest) ZYX Rotation in D3DMTS_VIEW, Frame #27                                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+545,   TuxTest },
{ TEXT("(TransTest) X   Rotation in D3DMTS_WORLD, Frame #1 (Fixed Point)                                         "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+546,   TuxTest },
{ TEXT("(TransTest) Y   Rotation in D3DMTS_WORLD, Frame #1 (Fixed Point)                                         "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+547,   TuxTest },
{ TEXT("(TransTest) Z   Rotation in D3DMTS_WORLD, Frame #1 (Fixed Point)                                         "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+548,   TuxTest },
{ TEXT("(TransTest) XY  Rotation in D3DMTS_WORLD, Frame #1 (Fixed Point)                                         "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+549,   TuxTest },
{ TEXT("(TransTest) XZ  Rotation in D3DMTS_WORLD, Frame #1 (Fixed Point)                                         "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+550,   TuxTest },
{ TEXT("(TransTest) YX  Rotation in D3DMTS_WORLD, Frame #1 (Fixed Point)                                         "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+551,   TuxTest },
{ TEXT("(TransTest) YZ  Rotation in D3DMTS_WORLD, Frame #1 (Fixed Point)                                         "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+552,   TuxTest },
{ TEXT("(TransTest) ZX  Rotation in D3DMTS_WORLD, Frame #1 (Fixed Point)                                         "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+553,   TuxTest },
{ TEXT("(TransTest) ZY  Rotation in D3DMTS_WORLD, Frame #1 (Fixed Point)                                         "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+554,   TuxTest },
{ TEXT("(TransTest) XYZ Rotation in D3DMTS_WORLD, Frame #1 (Fixed Point)                                         "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+555,   TuxTest },
{ TEXT("(TransTest) XZY Rotation in D3DMTS_WORLD, Frame #1 (Fixed Point)                                         "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+556,   TuxTest },
{ TEXT("(TransTest) YXZ Rotation in D3DMTS_WORLD, Frame #1 (Fixed Point)                                         "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+557,   TuxTest },
{ TEXT("(TransTest) YZX Rotation in D3DMTS_WORLD, Frame #1 (Fixed Point)                                         "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+558,   TuxTest },
{ TEXT("(TransTest) ZXY Rotation in D3DMTS_WORLD, Frame #1 (Fixed Point)                                         "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+559,   TuxTest },
{ TEXT("(TransTest) ZYX Rotation in D3DMTS_WORLD, Frame #1 (Fixed Point)                                         "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+560,   TuxTest },
{ TEXT("(TransTest) X   Rotation in D3DMTS_VIEW, Frame #1 (Fixed Point)                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+561,   TuxTest },
{ TEXT("(TransTest) Y   Rotation in D3DMTS_VIEW, Frame #1 (Fixed Point)                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+562,   TuxTest },
{ TEXT("(TransTest) Z   Rotation in D3DMTS_VIEW, Frame #1 (Fixed Point)                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+563,   TuxTest },
{ TEXT("(TransTest) XY  Rotation in D3DMTS_VIEW, Frame #1 (Fixed Point)                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+564,   TuxTest },
{ TEXT("(TransTest) XZ  Rotation in D3DMTS_VIEW, Frame #1 (Fixed Point)                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+565,   TuxTest },
{ TEXT("(TransTest) YX  Rotation in D3DMTS_VIEW, Frame #1 (Fixed Point)                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+566,   TuxTest },
{ TEXT("(TransTest) YZ  Rotation in D3DMTS_VIEW, Frame #1 (Fixed Point)                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+567,   TuxTest },
{ TEXT("(TransTest) ZX  Rotation in D3DMTS_VIEW, Frame #1 (Fixed Point)                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+568,   TuxTest },
{ TEXT("(TransTest) ZY  Rotation in D3DMTS_VIEW, Frame #1 (Fixed Point)                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+569,   TuxTest },
{ TEXT("(TransTest) XYZ Rotation in D3DMTS_VIEW, Frame #1 (Fixed Point)                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+570,   TuxTest },
{ TEXT("(TransTest) XZY Rotation in D3DMTS_VIEW, Frame #1 (Fixed Point)                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+571,   TuxTest },
{ TEXT("(TransTest) YXZ Rotation in D3DMTS_VIEW, Frame #1 (Fixed Point)                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+572,   TuxTest },
{ TEXT("(TransTest) YZX Rotation in D3DMTS_VIEW, Frame #1 (Fixed Point)                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+573,   TuxTest },
{ TEXT("(TransTest) ZXY Rotation in D3DMTS_VIEW, Frame #1 (Fixed Point)                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+574,   TuxTest },
{ TEXT("(TransTest) ZYX Rotation in D3DMTS_VIEW, Frame #1 (Fixed Point)                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+575,   TuxTest },
{ TEXT("(TransTest) X   Scale in D3DMTS_WORLD, Frame #1                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+576,   TuxTest },
{ TEXT("(TransTest) X   Scale in D3DMTS_WORLD, Frame #2                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+577,   TuxTest },
{ TEXT("(TransTest) X   Scale in D3DMTS_WORLD, Frame #3                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+578,   TuxTest },
{ TEXT("(TransTest) X   Scale in D3DMTS_WORLD, Frame #4                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+579,   TuxTest },
{ TEXT("(TransTest) X   Scale in D3DMTS_WORLD, Frame #5                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+580,   TuxTest },
{ TEXT("(TransTest) Y   Scale in D3DMTS_WORLD, Frame #1                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+581,   TuxTest },
{ TEXT("(TransTest) Y   Scale in D3DMTS_WORLD, Frame #2                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+582,   TuxTest },
{ TEXT("(TransTest) Y   Scale in D3DMTS_WORLD, Frame #3                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+583,   TuxTest },
{ TEXT("(TransTest) Y   Scale in D3DMTS_WORLD, Frame #4                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+584,   TuxTest },
{ TEXT("(TransTest) Y   Scale in D3DMTS_WORLD, Frame #5                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+585,   TuxTest },
{ TEXT("(TransTest) Z   Scale in D3DMTS_WORLD, Frame #1                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+586,   TuxTest },
{ TEXT("(TransTest) Z   Scale in D3DMTS_WORLD, Frame #2                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+587,   TuxTest },
{ TEXT("(TransTest) Z   Scale in D3DMTS_WORLD, Frame #3                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+588,   TuxTest },
{ TEXT("(TransTest) Z   Scale in D3DMTS_WORLD, Frame #4                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+589,   TuxTest },
{ TEXT("(TransTest) Z   Scale in D3DMTS_WORLD, Frame #5                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+590,   TuxTest },
{ TEXT("(TransTest) XY  Scale in D3DMTS_WORLD, Frame #1                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+591,   TuxTest },
{ TEXT("(TransTest) XY  Scale in D3DMTS_WORLD, Frame #2                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+592,   TuxTest },
{ TEXT("(TransTest) XY  Scale in D3DMTS_WORLD, Frame #3                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+593,   TuxTest },
{ TEXT("(TransTest) XY  Scale in D3DMTS_WORLD, Frame #4                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+594,   TuxTest },
{ TEXT("(TransTest) XY  Scale in D3DMTS_WORLD, Frame #5                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+595,   TuxTest },
{ TEXT("(TransTest) XY  Scale in D3DMTS_WORLD, Frame #6                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+596,   TuxTest },
{ TEXT("(TransTest) XY  Scale in D3DMTS_WORLD, Frame #7                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+597,   TuxTest },
{ TEXT("(TransTest) XY  Scale in D3DMTS_WORLD, Frame #8                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+598,   TuxTest },
{ TEXT("(TransTest) XY  Scale in D3DMTS_WORLD, Frame #9                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+599,   TuxTest },
{ TEXT("(TransTest) XY  Scale in D3DMTS_WORLD, Frame #10                                                         "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+600,   TuxTest },
{ TEXT("(TransTest) XY  Scale in D3DMTS_WORLD, Frame #11                                                         "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+601,   TuxTest },
{ TEXT("(TransTest) XY  Scale in D3DMTS_WORLD, Frame #12                                                         "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+602,   TuxTest },
{ TEXT("(TransTest) XY  Scale in D3DMTS_WORLD, Frame #13                                                         "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+603,   TuxTest },
{ TEXT("(TransTest) XY  Scale in D3DMTS_WORLD, Frame #14                                                         "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+604,   TuxTest },
{ TEXT("(TransTest) XY  Scale in D3DMTS_WORLD, Frame #15                                                         "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+605,   TuxTest },
{ TEXT("(TransTest) XY  Scale in D3DMTS_WORLD, Frame #16                                                         "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+606,   TuxTest },
{ TEXT("(TransTest) XZ  Scale in D3DMTS_WORLD, Frame #1                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+607,   TuxTest },
{ TEXT("(TransTest) XZ  Scale in D3DMTS_WORLD, Frame #2                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+608,   TuxTest },
{ TEXT("(TransTest) XZ  Scale in D3DMTS_WORLD, Frame #3                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+609,   TuxTest },
{ TEXT("(TransTest) XZ  Scale in D3DMTS_WORLD, Frame #4                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+610,   TuxTest },
{ TEXT("(TransTest) XZ  Scale in D3DMTS_WORLD, Frame #5                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+611,   TuxTest },
{ TEXT("(TransTest) XZ  Scale in D3DMTS_WORLD, Frame #6                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+612,   TuxTest },
{ TEXT("(TransTest) XZ  Scale in D3DMTS_WORLD, Frame #7                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+613,   TuxTest },
{ TEXT("(TransTest) XZ  Scale in D3DMTS_WORLD, Frame #8                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+614,   TuxTest },
{ TEXT("(TransTest) XZ  Scale in D3DMTS_WORLD, Frame #9                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+615,   TuxTest },
{ TEXT("(TransTest) XZ  Scale in D3DMTS_WORLD, Frame #10                                                         "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+616,   TuxTest },
{ TEXT("(TransTest) XZ  Scale in D3DMTS_WORLD, Frame #11                                                         "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+617,   TuxTest },
{ TEXT("(TransTest) XZ  Scale in D3DMTS_WORLD, Frame #12                                                         "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+618,   TuxTest },
{ TEXT("(TransTest) XZ  Scale in D3DMTS_WORLD, Frame #13                                                         "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+619,   TuxTest },
{ TEXT("(TransTest) XZ  Scale in D3DMTS_WORLD, Frame #14                                                         "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+620,   TuxTest },
{ TEXT("(TransTest) XZ  Scale in D3DMTS_WORLD, Frame #15                                                         "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+621,   TuxTest },
{ TEXT("(TransTest) XZ  Scale in D3DMTS_WORLD, Frame #16                                                         "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+622,   TuxTest },
{ TEXT("(TransTest) YZ  Scale in D3DMTS_WORLD, Frame #1                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+623,   TuxTest },
{ TEXT("(TransTest) YZ  Scale in D3DMTS_WORLD, Frame #2                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+624,   TuxTest },
{ TEXT("(TransTest) YZ  Scale in D3DMTS_WORLD, Frame #3                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+625,   TuxTest },
{ TEXT("(TransTest) YZ  Scale in D3DMTS_WORLD, Frame #4                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+626,   TuxTest },
{ TEXT("(TransTest) YZ  Scale in D3DMTS_WORLD, Frame #5                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+627,   TuxTest },
{ TEXT("(TransTest) YZ  Scale in D3DMTS_WORLD, Frame #6                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+628,   TuxTest },
{ TEXT("(TransTest) YZ  Scale in D3DMTS_WORLD, Frame #7                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+629,   TuxTest },
{ TEXT("(TransTest) YZ  Scale in D3DMTS_WORLD, Frame #8                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+630,   TuxTest },
{ TEXT("(TransTest) YZ  Scale in D3DMTS_WORLD, Frame #9                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+631,   TuxTest },
{ TEXT("(TransTest) YZ  Scale in D3DMTS_WORLD, Frame #10                                                         "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+632,   TuxTest },
{ TEXT("(TransTest) YZ  Scale in D3DMTS_WORLD, Frame #11                                                         "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+633,   TuxTest },
{ TEXT("(TransTest) YZ  Scale in D3DMTS_WORLD, Frame #12                                                         "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+634,   TuxTest },
{ TEXT("(TransTest) YZ  Scale in D3DMTS_WORLD, Frame #13                                                         "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+635,   TuxTest },
{ TEXT("(TransTest) YZ  Scale in D3DMTS_WORLD, Frame #14                                                         "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+636,   TuxTest },
{ TEXT("(TransTest) YZ  Scale in D3DMTS_WORLD, Frame #15                                                         "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+637,   TuxTest },
{ TEXT("(TransTest) YZ  Scale in D3DMTS_WORLD, Frame #16                                                         "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+638,   TuxTest },
{ TEXT("(TransTest) XYZ Scale in D3DMTS_WORLD, Frame #1                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+639,   TuxTest },
{ TEXT("(TransTest) XYZ Scale in D3DMTS_WORLD, Frame #2                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+640,   TuxTest },
{ TEXT("(TransTest) XYZ Scale in D3DMTS_WORLD, Frame #3                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+641,   TuxTest },
{ TEXT("(TransTest) XYZ Scale in D3DMTS_WORLD, Frame #4                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+642,   TuxTest },
{ TEXT("(TransTest) XYZ Scale in D3DMTS_WORLD, Frame #5                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+643,   TuxTest },
{ TEXT("(TransTest) XYZ Scale in D3DMTS_WORLD, Frame #6                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+644,   TuxTest },
{ TEXT("(TransTest) XYZ Scale in D3DMTS_WORLD, Frame #7                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+645,   TuxTest },
{ TEXT("(TransTest) XYZ Scale in D3DMTS_WORLD, Frame #8                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+646,   TuxTest },
{ TEXT("(TransTest) XYZ Scale in D3DMTS_WORLD, Frame #9                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+647,   TuxTest },
{ TEXT("(TransTest) XYZ Scale in D3DMTS_WORLD, Frame #10                                                         "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+648,   TuxTest },
{ TEXT("(TransTest) XYZ Scale in D3DMTS_WORLD, Frame #11                                                         "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+649,   TuxTest },
{ TEXT("(TransTest) XYZ Scale in D3DMTS_WORLD, Frame #12                                                         "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+650,   TuxTest },
{ TEXT("(TransTest) XYZ Scale in D3DMTS_WORLD, Frame #13                                                         "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+651,   TuxTest },
{ TEXT("(TransTest) XYZ Scale in D3DMTS_WORLD, Frame #14                                                         "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+652,   TuxTest },
{ TEXT("(TransTest) XYZ Scale in D3DMTS_WORLD, Frame #15                                                         "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+653,   TuxTest },
{ TEXT("(TransTest) XYZ Scale in D3DMTS_WORLD, Frame #16                                                         "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+654,   TuxTest },
{ TEXT("(TransTest) XYZ Scale in D3DMTS_WORLD, Frame #17                                                         "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+655,   TuxTest },
{ TEXT("(TransTest) XYZ Scale in D3DMTS_WORLD, Frame #18                                                         "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+656,   TuxTest },
{ TEXT("(TransTest) XYZ Scale in D3DMTS_WORLD, Frame #19                                                         "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+657,   TuxTest },
{ TEXT("(TransTest) XYZ Scale in D3DMTS_WORLD, Frame #20                                                         "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+658,   TuxTest },
{ TEXT("(TransTest) XYZ Scale in D3DMTS_WORLD, Frame #21                                                         "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+659,   TuxTest },
{ TEXT("(TransTest) XYZ Scale in D3DMTS_WORLD, Frame #22                                                         "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+660,   TuxTest },
{ TEXT("(TransTest) XYZ Scale in D3DMTS_WORLD, Frame #23                                                         "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+661,   TuxTest },
{ TEXT("(TransTest) XYZ Scale in D3DMTS_WORLD, Frame #24                                                         "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+662,   TuxTest },
{ TEXT("(TransTest) XYZ Scale in D3DMTS_WORLD, Frame #25                                                         "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+663,   TuxTest },
{ TEXT("(TransTest) XYZ Scale in D3DMTS_WORLD, Frame #26                                                         "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+664,   TuxTest },
{ TEXT("(TransTest) XYZ Scale in D3DMTS_WORLD, Frame #27                                                         "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+665,   TuxTest },
{ TEXT("(TransTest) X   Scale in D3DMTS_VIEW, Frame #1                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+666,   TuxTest },
{ TEXT("(TransTest) X   Scale in D3DMTS_VIEW, Frame #2                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+667,   TuxTest },
{ TEXT("(TransTest) X   Scale in D3DMTS_VIEW, Frame #3                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+668,   TuxTest },
{ TEXT("(TransTest) X   Scale in D3DMTS_VIEW, Frame #4                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+669,   TuxTest },
{ TEXT("(TransTest) X   Scale in D3DMTS_VIEW, Frame #5                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+670,   TuxTest },
{ TEXT("(TransTest) Y   Scale in D3DMTS_VIEW, Frame #1                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+671,   TuxTest },
{ TEXT("(TransTest) Y   Scale in D3DMTS_VIEW, Frame #2                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+672,   TuxTest },
{ TEXT("(TransTest) Y   Scale in D3DMTS_VIEW, Frame #3                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+673,   TuxTest },
{ TEXT("(TransTest) Y   Scale in D3DMTS_VIEW, Frame #4                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+674,   TuxTest },
{ TEXT("(TransTest) Y   Scale in D3DMTS_VIEW, Frame #5                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+675,   TuxTest },
{ TEXT("(TransTest) Z   Scale in D3DMTS_VIEW, Frame #1                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+676,   TuxTest },
{ TEXT("(TransTest) Z   Scale in D3DMTS_VIEW, Frame #2                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+677,   TuxTest },
{ TEXT("(TransTest) Z   Scale in D3DMTS_VIEW, Frame #3                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+678,   TuxTest },
{ TEXT("(TransTest) Z   Scale in D3DMTS_VIEW, Frame #4                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+679,   TuxTest },
{ TEXT("(TransTest) Z   Scale in D3DMTS_VIEW, Frame #5                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+680,   TuxTest },
{ TEXT("(TransTest) XY  Scale in D3DMTS_VIEW, Frame #1                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+681,   TuxTest },
{ TEXT("(TransTest) XY  Scale in D3DMTS_VIEW, Frame #2                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+682,   TuxTest },
{ TEXT("(TransTest) XY  Scale in D3DMTS_VIEW, Frame #3                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+683,   TuxTest },
{ TEXT("(TransTest) XY  Scale in D3DMTS_VIEW, Frame #4                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+684,   TuxTest },
{ TEXT("(TransTest) XY  Scale in D3DMTS_VIEW, Frame #5                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+685,   TuxTest },
{ TEXT("(TransTest) XY  Scale in D3DMTS_VIEW, Frame #6                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+686,   TuxTest },
{ TEXT("(TransTest) XY  Scale in D3DMTS_VIEW, Frame #7                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+687,   TuxTest },
{ TEXT("(TransTest) XY  Scale in D3DMTS_VIEW, Frame #8                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+688,   TuxTest },
{ TEXT("(TransTest) XY  Scale in D3DMTS_VIEW, Frame #9                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+689,   TuxTest },
{ TEXT("(TransTest) XY  Scale in D3DMTS_VIEW, Frame #10                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+690,   TuxTest },
{ TEXT("(TransTest) XY  Scale in D3DMTS_VIEW, Frame #11                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+691,   TuxTest },
{ TEXT("(TransTest) XY  Scale in D3DMTS_VIEW, Frame #12                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+692,   TuxTest },
{ TEXT("(TransTest) XY  Scale in D3DMTS_VIEW, Frame #13                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+693,   TuxTest },
{ TEXT("(TransTest) XY  Scale in D3DMTS_VIEW, Frame #14                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+694,   TuxTest },
{ TEXT("(TransTest) XY  Scale in D3DMTS_VIEW, Frame #15                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+695,   TuxTest },
{ TEXT("(TransTest) XY  Scale in D3DMTS_VIEW, Frame #16                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+696,   TuxTest },
{ TEXT("(TransTest) XZ  Scale in D3DMTS_VIEW, Frame #1                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+697,   TuxTest },
{ TEXT("(TransTest) XZ  Scale in D3DMTS_VIEW, Frame #2                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+698,   TuxTest },
{ TEXT("(TransTest) XZ  Scale in D3DMTS_VIEW, Frame #3                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+699,   TuxTest },
{ TEXT("(TransTest) XZ  Scale in D3DMTS_VIEW, Frame #4                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+700,   TuxTest },
{ TEXT("(TransTest) XZ  Scale in D3DMTS_VIEW, Frame #5                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+701,   TuxTest },
{ TEXT("(TransTest) XZ  Scale in D3DMTS_VIEW, Frame #6                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+702,   TuxTest },
{ TEXT("(TransTest) XZ  Scale in D3DMTS_VIEW, Frame #7                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+703,   TuxTest },
{ TEXT("(TransTest) XZ  Scale in D3DMTS_VIEW, Frame #8                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+704,   TuxTest },
{ TEXT("(TransTest) XZ  Scale in D3DMTS_VIEW, Frame #9                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+705,   TuxTest },
{ TEXT("(TransTest) XZ  Scale in D3DMTS_VIEW, Frame #10                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+706,   TuxTest },
{ TEXT("(TransTest) XZ  Scale in D3DMTS_VIEW, Frame #11                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+707,   TuxTest },
{ TEXT("(TransTest) XZ  Scale in D3DMTS_VIEW, Frame #12                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+708,   TuxTest },
{ TEXT("(TransTest) XZ  Scale in D3DMTS_VIEW, Frame #13                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+709,   TuxTest },
{ TEXT("(TransTest) XZ  Scale in D3DMTS_VIEW, Frame #14                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+710,   TuxTest },
{ TEXT("(TransTest) XZ  Scale in D3DMTS_VIEW, Frame #15                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+711,   TuxTest },
{ TEXT("(TransTest) XZ  Scale in D3DMTS_VIEW, Frame #16                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+712,   TuxTest },
{ TEXT("(TransTest) YZ  Scale in D3DMTS_VIEW, Frame #1                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+713,   TuxTest },
{ TEXT("(TransTest) YZ  Scale in D3DMTS_VIEW, Frame #2                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+714,   TuxTest },
{ TEXT("(TransTest) YZ  Scale in D3DMTS_VIEW, Frame #3                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+715,   TuxTest },
{ TEXT("(TransTest) YZ  Scale in D3DMTS_VIEW, Frame #4                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+716,   TuxTest },
{ TEXT("(TransTest) YZ  Scale in D3DMTS_VIEW, Frame #5                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+717,   TuxTest },
{ TEXT("(TransTest) YZ  Scale in D3DMTS_VIEW, Frame #6                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+718,   TuxTest },
{ TEXT("(TransTest) YZ  Scale in D3DMTS_VIEW, Frame #7                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+719,   TuxTest },
{ TEXT("(TransTest) YZ  Scale in D3DMTS_VIEW, Frame #8                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+720,   TuxTest },
{ TEXT("(TransTest) YZ  Scale in D3DMTS_VIEW, Frame #9                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+721,   TuxTest },
{ TEXT("(TransTest) YZ  Scale in D3DMTS_VIEW, Frame #10                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+722,   TuxTest },
{ TEXT("(TransTest) YZ  Scale in D3DMTS_VIEW, Frame #11                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+723,   TuxTest },
{ TEXT("(TransTest) YZ  Scale in D3DMTS_VIEW, Frame #12                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+724,   TuxTest },
{ TEXT("(TransTest) YZ  Scale in D3DMTS_VIEW, Frame #13                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+725,   TuxTest },
{ TEXT("(TransTest) YZ  Scale in D3DMTS_VIEW, Frame #14                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+726,   TuxTest },
{ TEXT("(TransTest) YZ  Scale in D3DMTS_VIEW, Frame #15                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+727,   TuxTest },
{ TEXT("(TransTest) YZ  Scale in D3DMTS_VIEW, Frame #16                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+728,   TuxTest },
{ TEXT("(TransTest) XYZ Scale in D3DMTS_VIEW, Frame #1                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+729,   TuxTest },
{ TEXT("(TransTest) XYZ Scale in D3DMTS_VIEW, Frame #2                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+730,   TuxTest },
{ TEXT("(TransTest) XYZ Scale in D3DMTS_VIEW, Frame #3                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+731,   TuxTest },
{ TEXT("(TransTest) XYZ Scale in D3DMTS_VIEW, Frame #4                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+732,   TuxTest },
{ TEXT("(TransTest) XYZ Scale in D3DMTS_VIEW, Frame #5                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+733,   TuxTest },
{ TEXT("(TransTest) XYZ Scale in D3DMTS_VIEW, Frame #6                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+734,   TuxTest },
{ TEXT("(TransTest) XYZ Scale in D3DMTS_VIEW, Frame #7                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+735,   TuxTest },
{ TEXT("(TransTest) XYZ Scale in D3DMTS_VIEW, Frame #8                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+736,   TuxTest },
{ TEXT("(TransTest) XYZ Scale in D3DMTS_VIEW, Frame #9                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+737,   TuxTest },
{ TEXT("(TransTest) XYZ Scale in D3DMTS_VIEW, Frame #10                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+738,   TuxTest },
{ TEXT("(TransTest) XYZ Scale in D3DMTS_VIEW, Frame #11                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+739,   TuxTest },
{ TEXT("(TransTest) XYZ Scale in D3DMTS_VIEW, Frame #12                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+740,   TuxTest },
{ TEXT("(TransTest) XYZ Scale in D3DMTS_VIEW, Frame #13                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+741,   TuxTest },
{ TEXT("(TransTest) XYZ Scale in D3DMTS_VIEW, Frame #14                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+742,   TuxTest },
{ TEXT("(TransTest) XYZ Scale in D3DMTS_VIEW, Frame #15                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+743,   TuxTest },
{ TEXT("(TransTest) XYZ Scale in D3DMTS_VIEW, Frame #16                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+744,   TuxTest },
{ TEXT("(TransTest) XYZ Scale in D3DMTS_VIEW, Frame #17                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+745,   TuxTest },
{ TEXT("(TransTest) XYZ Scale in D3DMTS_VIEW, Frame #18                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+746,   TuxTest },
{ TEXT("(TransTest) XYZ Scale in D3DMTS_VIEW, Frame #19                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+747,   TuxTest },
{ TEXT("(TransTest) XYZ Scale in D3DMTS_VIEW, Frame #20                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+748,   TuxTest },
{ TEXT("(TransTest) XYZ Scale in D3DMTS_VIEW, Frame #21                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+749,   TuxTest },
{ TEXT("(TransTest) XYZ Scale in D3DMTS_VIEW, Frame #22                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+750,   TuxTest },
{ TEXT("(TransTest) XYZ Scale in D3DMTS_VIEW, Frame #23                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+751,   TuxTest },
{ TEXT("(TransTest) XYZ Scale in D3DMTS_VIEW, Frame #24                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+752,   TuxTest },
{ TEXT("(TransTest) XYZ Scale in D3DMTS_VIEW, Frame #25                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+753,   TuxTest },
{ TEXT("(TransTest) XYZ Scale in D3DMTS_VIEW, Frame #26                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+754,   TuxTest },
{ TEXT("(TransTest) XYZ Scale in D3DMTS_VIEW, Frame #27                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+755,   TuxTest },
{ TEXT("(TransTest) X   Scale in D3DMTS_WORLD, Frame #1 (Fixed Point)                                            "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+756,   TuxTest },
{ TEXT("(TransTest) Y   Scale in D3DMTS_WORLD, Frame #1 (Fixed Point)                                            "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+757,   TuxTest },
{ TEXT("(TransTest) Z   Scale in D3DMTS_WORLD, Frame #1 (Fixed Point)                                            "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+758,   TuxTest },
{ TEXT("(TransTest) XY  Scale in D3DMTS_WORLD, Frame #1 (Fixed Point)                                            "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+759,   TuxTest },
{ TEXT("(TransTest) XZ  Scale in D3DMTS_WORLD, Frame #1 (Fixed Point)                                            "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+760,   TuxTest },
{ TEXT("(TransTest) YZ  Scale in D3DMTS_WORLD, Frame #1 (Fixed Point)                                            "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+761,   TuxTest },
{ TEXT("(TransTest) XYZ Scale in D3DMTS_WORLD, Frame #1 (Fixed Point)                                            "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+762,   TuxTest },
{ TEXT("(TransTest) X   Scale in D3DMTS_VIEW, Frame #1 (Fixed Point)                                             "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+763,   TuxTest },
{ TEXT("(TransTest) Y   Scale in D3DMTS_VIEW, Frame #1 (Fixed Point)                                             "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+764,   TuxTest },
{ TEXT("(TransTest) Z   Scale in D3DMTS_VIEW, Frame #1 (Fixed Point)                                             "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+765,   TuxTest },
{ TEXT("(TransTest) XY  Scale in D3DMTS_VIEW, Frame #1 (Fixed Point)                                             "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+766,   TuxTest },
{ TEXT("(TransTest) XZ  Scale in D3DMTS_VIEW, Frame #1 (Fixed Point)                                             "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+767,   TuxTest },
{ TEXT("(TransTest) YZ  Scale in D3DMTS_VIEW, Frame #1 (Fixed Point)                                             "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+768,   TuxTest },
{ TEXT("(TransTest) XYZ Scale in D3DMTS_VIEW, Frame #1 (Fixed Point)                                             "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+769,   TuxTest },
{ TEXT("(TransTest) XY  Shear in D3DMTS_WORLD, Frame #1                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+770,   TuxTest },
{ TEXT("(TransTest) XY  Shear in D3DMTS_WORLD, Frame #2                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+771,   TuxTest },
{ TEXT("(TransTest) XY  Shear in D3DMTS_WORLD, Frame #3                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+772,   TuxTest },
{ TEXT("(TransTest) XY  Shear in D3DMTS_WORLD, Frame #4                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+773,   TuxTest },
{ TEXT("(TransTest) XY  Shear in D3DMTS_WORLD, Frame #5                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+774,   TuxTest },
{ TEXT("(TransTest) XZ  Shear in D3DMTS_WORLD, Frame #1                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+775,   TuxTest },
{ TEXT("(TransTest) XZ  Shear in D3DMTS_WORLD, Frame #2                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+776,   TuxTest },
{ TEXT("(TransTest) XZ  Shear in D3DMTS_WORLD, Frame #3                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+777,   TuxTest },
{ TEXT("(TransTest) XZ  Shear in D3DMTS_WORLD, Frame #4                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+778,   TuxTest },
{ TEXT("(TransTest) XZ  Shear in D3DMTS_WORLD, Frame #5                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+779,   TuxTest },
{ TEXT("(TransTest) YX  Shear in D3DMTS_WORLD, Frame #1                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+780,   TuxTest },
{ TEXT("(TransTest) YX  Shear in D3DMTS_WORLD, Frame #2                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+781,   TuxTest },
{ TEXT("(TransTest) YX  Shear in D3DMTS_WORLD, Frame #3                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+782,   TuxTest },
{ TEXT("(TransTest) YX  Shear in D3DMTS_WORLD, Frame #4                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+783,   TuxTest },
{ TEXT("(TransTest) YX  Shear in D3DMTS_WORLD, Frame #5                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+784,   TuxTest },
{ TEXT("(TransTest) YZ  Shear in D3DMTS_WORLD, Frame #1                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+785,   TuxTest },
{ TEXT("(TransTest) YZ  Shear in D3DMTS_WORLD, Frame #2                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+786,   TuxTest },
{ TEXT("(TransTest) YZ  Shear in D3DMTS_WORLD, Frame #3                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+787,   TuxTest },
{ TEXT("(TransTest) YZ  Shear in D3DMTS_WORLD, Frame #4                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+788,   TuxTest },
{ TEXT("(TransTest) YZ  Shear in D3DMTS_WORLD, Frame #5                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+789,   TuxTest },
{ TEXT("(TransTest) ZX  Shear in D3DMTS_WORLD, Frame #1                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+790,   TuxTest },
{ TEXT("(TransTest) ZX  Shear in D3DMTS_WORLD, Frame #2                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+791,   TuxTest },
{ TEXT("(TransTest) ZX  Shear in D3DMTS_WORLD, Frame #3                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+792,   TuxTest },
{ TEXT("(TransTest) ZX  Shear in D3DMTS_WORLD, Frame #4                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+793,   TuxTest },
{ TEXT("(TransTest) ZX  Shear in D3DMTS_WORLD, Frame #5                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+794,   TuxTest },
{ TEXT("(TransTest) ZY  Shear in D3DMTS_WORLD, Frame #1                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+795,   TuxTest },
{ TEXT("(TransTest) ZY  Shear in D3DMTS_WORLD, Frame #2                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+796,   TuxTest },
{ TEXT("(TransTest) ZY  Shear in D3DMTS_WORLD, Frame #3                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+797,   TuxTest },
{ TEXT("(TransTest) ZY  Shear in D3DMTS_WORLD, Frame #4                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+798,   TuxTest },
{ TEXT("(TransTest) ZY  Shear in D3DMTS_WORLD, Frame #5                                                          "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+799,   TuxTest },
{ TEXT("(TransTest) XY  Shear in D3DMTS_VIEW, Frame #1                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+800,   TuxTest },
{ TEXT("(TransTest) XY  Shear in D3DMTS_VIEW, Frame #2                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+801,   TuxTest },
{ TEXT("(TransTest) XY  Shear in D3DMTS_VIEW, Frame #3                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+802,   TuxTest },
{ TEXT("(TransTest) XY  Shear in D3DMTS_VIEW, Frame #4                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+803,   TuxTest },
{ TEXT("(TransTest) XY  Shear in D3DMTS_VIEW, Frame #5                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+804,   TuxTest },
{ TEXT("(TransTest) XZ  Shear in D3DMTS_VIEW, Frame #1                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+805,   TuxTest },
{ TEXT("(TransTest) XZ  Shear in D3DMTS_VIEW, Frame #2                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+806,   TuxTest },
{ TEXT("(TransTest) XZ  Shear in D3DMTS_VIEW, Frame #3                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+807,   TuxTest },
{ TEXT("(TransTest) XZ  Shear in D3DMTS_VIEW, Frame #4                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+808,   TuxTest },
{ TEXT("(TransTest) XZ  Shear in D3DMTS_VIEW, Frame #5                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+809,   TuxTest },
{ TEXT("(TransTest) YX  Shear in D3DMTS_VIEW, Frame #1                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+810,   TuxTest },
{ TEXT("(TransTest) YX  Shear in D3DMTS_VIEW, Frame #2                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+811,   TuxTest },
{ TEXT("(TransTest) YX  Shear in D3DMTS_VIEW, Frame #3                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+812,   TuxTest },
{ TEXT("(TransTest) YX  Shear in D3DMTS_VIEW, Frame #4                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+813,   TuxTest },
{ TEXT("(TransTest) YX  Shear in D3DMTS_VIEW, Frame #5                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+814,   TuxTest },
{ TEXT("(TransTest) YZ  Shear in D3DMTS_VIEW, Frame #1                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+815,   TuxTest },
{ TEXT("(TransTest) YZ  Shear in D3DMTS_VIEW, Frame #2                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+816,   TuxTest },
{ TEXT("(TransTest) YZ  Shear in D3DMTS_VIEW, Frame #3                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+817,   TuxTest },
{ TEXT("(TransTest) YZ  Shear in D3DMTS_VIEW, Frame #4                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+818,   TuxTest },
{ TEXT("(TransTest) YZ  Shear in D3DMTS_VIEW, Frame #5                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+819,   TuxTest },
{ TEXT("(TransTest) ZX  Shear in D3DMTS_VIEW, Frame #1                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+820,   TuxTest },
{ TEXT("(TransTest) ZX  Shear in D3DMTS_VIEW, Frame #2                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+821,   TuxTest },
{ TEXT("(TransTest) ZX  Shear in D3DMTS_VIEW, Frame #3                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+822,   TuxTest },
{ TEXT("(TransTest) ZX  Shear in D3DMTS_VIEW, Frame #4                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+823,   TuxTest },
{ TEXT("(TransTest) ZX  Shear in D3DMTS_VIEW, Frame #5                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+824,   TuxTest },
{ TEXT("(TransTest) ZY  Shear in D3DMTS_VIEW, Frame #1                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+825,   TuxTest },
{ TEXT("(TransTest) ZY  Shear in D3DMTS_VIEW, Frame #2                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+826,   TuxTest },
{ TEXT("(TransTest) ZY  Shear in D3DMTS_VIEW, Frame #3                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+827,   TuxTest },
{ TEXT("(TransTest) ZY  Shear in D3DMTS_VIEW, Frame #4                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+828,   TuxTest },
{ TEXT("(TransTest) ZY  Shear in D3DMTS_VIEW, Frame #5                                                           "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+829,   TuxTest },
{ TEXT("(TransTest) XY  Shear in D3DMTS_WORLD, Frame #1 (Fixed Point)                                            "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+830,   TuxTest },
{ TEXT("(TransTest) XZ  Shear in D3DMTS_WORLD, Frame #1 (Fixed Point)                                            "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+831,   TuxTest },
{ TEXT("(TransTest) YX  Shear in D3DMTS_WORLD, Frame #1 (Fixed Point)                                            "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+832,   TuxTest },
{ TEXT("(TransTest) YZ  Shear in D3DMTS_WORLD, Frame #1 (Fixed Point)                                            "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+833,   TuxTest },
{ TEXT("(TransTest) ZX  Shear in D3DMTS_WORLD, Frame #1 (Fixed Point)                                            "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+834,   TuxTest },
{ TEXT("(TransTest) ZY  Shear in D3DMTS_WORLD, Frame #1 (Fixed Point)                                            "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+835,   TuxTest },
{ TEXT("(TransTest) XY  Shear in D3DMTS_VIEW, Frame #1 (Fixed Point)                                             "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+836,   TuxTest },
{ TEXT("(TransTest) XZ  Shear in D3DMTS_VIEW, Frame #1 (Fixed Point)                                             "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+837,   TuxTest },
{ TEXT("(TransTest) YX  Shear in D3DMTS_VIEW, Frame #1 (Fixed Point)                                             "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+838,   TuxTest },
{ TEXT("(TransTest) YZ  Shear in D3DMTS_VIEW, Frame #1 (Fixed Point)                                             "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+839,   TuxTest },
{ TEXT("(TransTest) ZX  Shear in D3DMTS_VIEW, Frame #1 (Fixed Point)                                             "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+840,   TuxTest },
{ TEXT("(TransTest) ZY  Shear in D3DMTS_VIEW, Frame #1 (Fixed Point)                                             "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+841,   TuxTest },
{ TEXT("(TransTest) X   Translation in D3DMTS_WORLD, Frame #1                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+842,   TuxTest },
{ TEXT("(TransTest) X   Translation in D3DMTS_WORLD, Frame #2                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+843,   TuxTest },
{ TEXT("(TransTest) X   Translation in D3DMTS_WORLD, Frame #3                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+844,   TuxTest },
{ TEXT("(TransTest) X   Translation in D3DMTS_WORLD, Frame #4                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+845,   TuxTest },
{ TEXT("(TransTest) X   Translation in D3DMTS_WORLD, Frame #5                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+846,   TuxTest },
{ TEXT("(TransTest) Y   Translation in D3DMTS_WORLD, Frame #1                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+847,   TuxTest },
{ TEXT("(TransTest) Y   Translation in D3DMTS_WORLD, Frame #2                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+848,   TuxTest },
{ TEXT("(TransTest) Y   Translation in D3DMTS_WORLD, Frame #3                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+849,   TuxTest },
{ TEXT("(TransTest) Y   Translation in D3DMTS_WORLD, Frame #4                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+850,   TuxTest },
{ TEXT("(TransTest) Y   Translation in D3DMTS_WORLD, Frame #5                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+851,   TuxTest },
{ TEXT("(TransTest) Z   Translation in D3DMTS_WORLD, Frame #1                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+852,   TuxTest },
{ TEXT("(TransTest) Z   Translation in D3DMTS_WORLD, Frame #2                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+853,   TuxTest },
{ TEXT("(TransTest) Z   Translation in D3DMTS_WORLD, Frame #3                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+854,   TuxTest },
{ TEXT("(TransTest) Z   Translation in D3DMTS_WORLD, Frame #4                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+855,   TuxTest },
{ TEXT("(TransTest) Z   Translation in D3DMTS_WORLD, Frame #5                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+856,   TuxTest },
{ TEXT("(TransTest) XY  Translation in D3DMTS_WORLD, Frame #1                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+857,   TuxTest },
{ TEXT("(TransTest) XY  Translation in D3DMTS_WORLD, Frame #2                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+858,   TuxTest },
{ TEXT("(TransTest) XY  Translation in D3DMTS_WORLD, Frame #3                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+859,   TuxTest },
{ TEXT("(TransTest) XY  Translation in D3DMTS_WORLD, Frame #4                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+860,   TuxTest },
{ TEXT("(TransTest) XY  Translation in D3DMTS_WORLD, Frame #5                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+861,   TuxTest },
{ TEXT("(TransTest) XY  Translation in D3DMTS_WORLD, Frame #6                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+862,   TuxTest },
{ TEXT("(TransTest) XY  Translation in D3DMTS_WORLD, Frame #7                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+863,   TuxTest },
{ TEXT("(TransTest) XY  Translation in D3DMTS_WORLD, Frame #8                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+864,   TuxTest },
{ TEXT("(TransTest) XY  Translation in D3DMTS_WORLD, Frame #9                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+865,   TuxTest },
{ TEXT("(TransTest) XY  Translation in D3DMTS_WORLD, Frame #10                                                   "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+866,   TuxTest },
{ TEXT("(TransTest) XY  Translation in D3DMTS_WORLD, Frame #11                                                   "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+867,   TuxTest },
{ TEXT("(TransTest) XY  Translation in D3DMTS_WORLD, Frame #12                                                   "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+868,   TuxTest },
{ TEXT("(TransTest) XY  Translation in D3DMTS_WORLD, Frame #13                                                   "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+869,   TuxTest },
{ TEXT("(TransTest) XY  Translation in D3DMTS_WORLD, Frame #14                                                   "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+870,   TuxTest },
{ TEXT("(TransTest) XY  Translation in D3DMTS_WORLD, Frame #15                                                   "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+871,   TuxTest },
{ TEXT("(TransTest) XY  Translation in D3DMTS_WORLD, Frame #16                                                   "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+872,   TuxTest },
{ TEXT("(TransTest) XZ  Translation in D3DMTS_WORLD, Frame #1                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+873,   TuxTest },
{ TEXT("(TransTest) XZ  Translation in D3DMTS_WORLD, Frame #2                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+874,   TuxTest },
{ TEXT("(TransTest) XZ  Translation in D3DMTS_WORLD, Frame #3                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+875,   TuxTest },
{ TEXT("(TransTest) XZ  Translation in D3DMTS_WORLD, Frame #4                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+876,   TuxTest },
{ TEXT("(TransTest) XZ  Translation in D3DMTS_WORLD, Frame #5                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+877,   TuxTest },
{ TEXT("(TransTest) XZ  Translation in D3DMTS_WORLD, Frame #6                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+878,   TuxTest },
{ TEXT("(TransTest) XZ  Translation in D3DMTS_WORLD, Frame #7                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+879,   TuxTest },
{ TEXT("(TransTest) XZ  Translation in D3DMTS_WORLD, Frame #8                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+880,   TuxTest },
{ TEXT("(TransTest) XZ  Translation in D3DMTS_WORLD, Frame #9                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+881,   TuxTest },
{ TEXT("(TransTest) XZ  Translation in D3DMTS_WORLD, Frame #10                                                   "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+882,   TuxTest },
{ TEXT("(TransTest) XZ  Translation in D3DMTS_WORLD, Frame #11                                                   "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+883,   TuxTest },
{ TEXT("(TransTest) XZ  Translation in D3DMTS_WORLD, Frame #12                                                   "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+884,   TuxTest },
{ TEXT("(TransTest) XZ  Translation in D3DMTS_WORLD, Frame #13                                                   "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+885,   TuxTest },
{ TEXT("(TransTest) XZ  Translation in D3DMTS_WORLD, Frame #14                                                   "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+886,   TuxTest },
{ TEXT("(TransTest) XZ  Translation in D3DMTS_WORLD, Frame #15                                                   "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+887,   TuxTest },
{ TEXT("(TransTest) XZ  Translation in D3DMTS_WORLD, Frame #16                                                   "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+888,   TuxTest },
{ TEXT("(TransTest) YZ  Translation in D3DMTS_WORLD, Frame #1                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+889,   TuxTest },
{ TEXT("(TransTest) YZ  Translation in D3DMTS_WORLD, Frame #2                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+890,   TuxTest },
{ TEXT("(TransTest) YZ  Translation in D3DMTS_WORLD, Frame #3                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+891,   TuxTest },
{ TEXT("(TransTest) YZ  Translation in D3DMTS_WORLD, Frame #4                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+892,   TuxTest },
{ TEXT("(TransTest) YZ  Translation in D3DMTS_WORLD, Frame #5                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+893,   TuxTest },
{ TEXT("(TransTest) YZ  Translation in D3DMTS_WORLD, Frame #6                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+894,   TuxTest },
{ TEXT("(TransTest) YZ  Translation in D3DMTS_WORLD, Frame #7                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+895,   TuxTest },
{ TEXT("(TransTest) YZ  Translation in D3DMTS_WORLD, Frame #8                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+896,   TuxTest },
{ TEXT("(TransTest) YZ  Translation in D3DMTS_WORLD, Frame #9                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+897,   TuxTest },
{ TEXT("(TransTest) YZ  Translation in D3DMTS_WORLD, Frame #10                                                   "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+898,   TuxTest },
{ TEXT("(TransTest) YZ  Translation in D3DMTS_WORLD, Frame #11                                                   "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+899,   TuxTest },
{ TEXT("(TransTest) YZ  Translation in D3DMTS_WORLD, Frame #12                                                   "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+900,   TuxTest },
{ TEXT("(TransTest) YZ  Translation in D3DMTS_WORLD, Frame #13                                                   "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+901,   TuxTest },
{ TEXT("(TransTest) YZ  Translation in D3DMTS_WORLD, Frame #14                                                   "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+902,   TuxTest },
{ TEXT("(TransTest) YZ  Translation in D3DMTS_WORLD, Frame #15                                                   "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+903,   TuxTest },
{ TEXT("(TransTest) YZ  Translation in D3DMTS_WORLD, Frame #16                                                   "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+904,   TuxTest },
{ TEXT("(TransTest) XYZ Translation in D3DMTS_WORLD, Frame #1                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+905,   TuxTest },
{ TEXT("(TransTest) XYZ Translation in D3DMTS_WORLD, Frame #2                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+906,   TuxTest },
{ TEXT("(TransTest) XYZ Translation in D3DMTS_WORLD, Frame #3                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+907,   TuxTest },
{ TEXT("(TransTest) XYZ Translation in D3DMTS_WORLD, Frame #4                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+908,   TuxTest },
{ TEXT("(TransTest) XYZ Translation in D3DMTS_WORLD, Frame #5                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+909,   TuxTest },
{ TEXT("(TransTest) XYZ Translation in D3DMTS_WORLD, Frame #6                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+910,   TuxTest },
{ TEXT("(TransTest) XYZ Translation in D3DMTS_WORLD, Frame #7                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+911,   TuxTest },
{ TEXT("(TransTest) XYZ Translation in D3DMTS_WORLD, Frame #8                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+912,   TuxTest },
{ TEXT("(TransTest) XYZ Translation in D3DMTS_WORLD, Frame #9                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+913,   TuxTest },
{ TEXT("(TransTest) XYZ Translation in D3DMTS_WORLD, Frame #10                                                   "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+914,   TuxTest },
{ TEXT("(TransTest) XYZ Translation in D3DMTS_WORLD, Frame #11                                                   "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+915,   TuxTest },
{ TEXT("(TransTest) XYZ Translation in D3DMTS_WORLD, Frame #12                                                   "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+916,   TuxTest },
{ TEXT("(TransTest) XYZ Translation in D3DMTS_WORLD, Frame #13                                                   "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+917,   TuxTest },
{ TEXT("(TransTest) XYZ Translation in D3DMTS_WORLD, Frame #14                                                   "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+918,   TuxTest },
{ TEXT("(TransTest) XYZ Translation in D3DMTS_WORLD, Frame #15                                                   "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+919,   TuxTest },
{ TEXT("(TransTest) XYZ Translation in D3DMTS_WORLD, Frame #16                                                   "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+920,   TuxTest },
{ TEXT("(TransTest) XYZ Translation in D3DMTS_WORLD, Frame #17                                                   "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+921,   TuxTest },
{ TEXT("(TransTest) XYZ Translation in D3DMTS_WORLD, Frame #18                                                   "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+922,   TuxTest },
{ TEXT("(TransTest) XYZ Translation in D3DMTS_WORLD, Frame #19                                                   "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+923,   TuxTest },
{ TEXT("(TransTest) XYZ Translation in D3DMTS_WORLD, Frame #20                                                   "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+924,   TuxTest },
{ TEXT("(TransTest) XYZ Translation in D3DMTS_WORLD, Frame #21                                                   "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+925,   TuxTest },
{ TEXT("(TransTest) XYZ Translation in D3DMTS_WORLD, Frame #22                                                   "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+926,   TuxTest },
{ TEXT("(TransTest) XYZ Translation in D3DMTS_WORLD, Frame #23                                                   "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+927,   TuxTest },
{ TEXT("(TransTest) XYZ Translation in D3DMTS_WORLD, Frame #24                                                   "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+928,   TuxTest },
{ TEXT("(TransTest) XYZ Translation in D3DMTS_WORLD, Frame #25                                                   "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+929,   TuxTest },
{ TEXT("(TransTest) XYZ Translation in D3DMTS_WORLD, Frame #26                                                   "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+930,   TuxTest },
{ TEXT("(TransTest) XYZ Translation in D3DMTS_WORLD, Frame #27                                                   "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+931,   TuxTest },
{ TEXT("(TransTest) X   Translation in D3DMTS_VIEW, Frame #1                                                     "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+932,   TuxTest },
{ TEXT("(TransTest) X   Translation in D3DMTS_VIEW, Frame #2                                                     "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+933,   TuxTest },
{ TEXT("(TransTest) X   Translation in D3DMTS_VIEW, Frame #3                                                     "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+934,   TuxTest },
{ TEXT("(TransTest) X   Translation in D3DMTS_VIEW, Frame #4                                                     "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+935,   TuxTest },
{ TEXT("(TransTest) X   Translation in D3DMTS_VIEW, Frame #5                                                     "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+936,   TuxTest },
{ TEXT("(TransTest) Y   Translation in D3DMTS_VIEW, Frame #1                                                     "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+937,   TuxTest },
{ TEXT("(TransTest) Y   Translation in D3DMTS_VIEW, Frame #2                                                     "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+938,   TuxTest },
{ TEXT("(TransTest) Y   Translation in D3DMTS_VIEW, Frame #3                                                     "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+939,   TuxTest },
{ TEXT("(TransTest) Y   Translation in D3DMTS_VIEW, Frame #4                                                     "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+940,   TuxTest },
{ TEXT("(TransTest) Y   Translation in D3DMTS_VIEW, Frame #5                                                     "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+941,   TuxTest },
{ TEXT("(TransTest) Z   Translation in D3DMTS_VIEW, Frame #1                                                     "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+942,   TuxTest },
{ TEXT("(TransTest) Z   Translation in D3DMTS_VIEW, Frame #2                                                     "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+943,   TuxTest },
{ TEXT("(TransTest) Z   Translation in D3DMTS_VIEW, Frame #3                                                     "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+944,   TuxTest },
{ TEXT("(TransTest) Z   Translation in D3DMTS_VIEW, Frame #4                                                     "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+945,   TuxTest },
{ TEXT("(TransTest) Z   Translation in D3DMTS_VIEW, Frame #5                                                     "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+946,   TuxTest },
{ TEXT("(TransTest) XY  Translation in D3DMTS_VIEW, Frame #1                                                     "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+947,   TuxTest },
{ TEXT("(TransTest) XY  Translation in D3DMTS_VIEW, Frame #2                                                     "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+948,   TuxTest },
{ TEXT("(TransTest) XY  Translation in D3DMTS_VIEW, Frame #3                                                     "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+949,   TuxTest },
{ TEXT("(TransTest) XY  Translation in D3DMTS_VIEW, Frame #4                                                     "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+950,   TuxTest },
{ TEXT("(TransTest) XY  Translation in D3DMTS_VIEW, Frame #5                                                     "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+951,   TuxTest },
{ TEXT("(TransTest) XY  Translation in D3DMTS_VIEW, Frame #6                                                     "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+952,   TuxTest },
{ TEXT("(TransTest) XY  Translation in D3DMTS_VIEW, Frame #7                                                     "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+953,   TuxTest },
{ TEXT("(TransTest) XY  Translation in D3DMTS_VIEW, Frame #8                                                     "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+954,   TuxTest },
{ TEXT("(TransTest) XY  Translation in D3DMTS_VIEW, Frame #9                                                     "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+955,   TuxTest },
{ TEXT("(TransTest) XY  Translation in D3DMTS_VIEW, Frame #10                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+956,   TuxTest },
{ TEXT("(TransTest) XY  Translation in D3DMTS_VIEW, Frame #11                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+957,   TuxTest },
{ TEXT("(TransTest) XY  Translation in D3DMTS_VIEW, Frame #12                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+958,   TuxTest },
{ TEXT("(TransTest) XY  Translation in D3DMTS_VIEW, Frame #13                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+959,   TuxTest },
{ TEXT("(TransTest) XY  Translation in D3DMTS_VIEW, Frame #14                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+960,   TuxTest },
{ TEXT("(TransTest) XY  Translation in D3DMTS_VIEW, Frame #15                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+961,   TuxTest },
{ TEXT("(TransTest) XY  Translation in D3DMTS_VIEW, Frame #16                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+962,   TuxTest },
{ TEXT("(TransTest) XZ  Translation in D3DMTS_VIEW, Frame #1                                                     "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+963,   TuxTest },
{ TEXT("(TransTest) XZ  Translation in D3DMTS_VIEW, Frame #2                                                     "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+964,   TuxTest },
{ TEXT("(TransTest) XZ  Translation in D3DMTS_VIEW, Frame #3                                                     "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+965,   TuxTest },
{ TEXT("(TransTest) XZ  Translation in D3DMTS_VIEW, Frame #4                                                     "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+966,   TuxTest },
{ TEXT("(TransTest) XZ  Translation in D3DMTS_VIEW, Frame #5                                                     "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+967,   TuxTest },
{ TEXT("(TransTest) XZ  Translation in D3DMTS_VIEW, Frame #6                                                     "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+968,   TuxTest },
{ TEXT("(TransTest) XZ  Translation in D3DMTS_VIEW, Frame #7                                                     "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+969,   TuxTest },
{ TEXT("(TransTest) XZ  Translation in D3DMTS_VIEW, Frame #8                                                     "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+970,   TuxTest },
{ TEXT("(TransTest) XZ  Translation in D3DMTS_VIEW, Frame #9                                                     "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+971,   TuxTest },
{ TEXT("(TransTest) XZ  Translation in D3DMTS_VIEW, Frame #10                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+972,   TuxTest },
{ TEXT("(TransTest) XZ  Translation in D3DMTS_VIEW, Frame #11                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+973,   TuxTest },
{ TEXT("(TransTest) XZ  Translation in D3DMTS_VIEW, Frame #12                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+974,   TuxTest },
{ TEXT("(TransTest) XZ  Translation in D3DMTS_VIEW, Frame #13                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+975,   TuxTest },
{ TEXT("(TransTest) XZ  Translation in D3DMTS_VIEW, Frame #14                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+976,   TuxTest },
{ TEXT("(TransTest) XZ  Translation in D3DMTS_VIEW, Frame #15                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+977,   TuxTest },
{ TEXT("(TransTest) XZ  Translation in D3DMTS_VIEW, Frame #16                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+978,   TuxTest },
{ TEXT("(TransTest) YZ  Translation in D3DMTS_VIEW, Frame #1                                                     "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+979,   TuxTest },
{ TEXT("(TransTest) YZ  Translation in D3DMTS_VIEW, Frame #2                                                     "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+980,   TuxTest },
{ TEXT("(TransTest) YZ  Translation in D3DMTS_VIEW, Frame #3                                                     "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+981,   TuxTest },
{ TEXT("(TransTest) YZ  Translation in D3DMTS_VIEW, Frame #4                                                     "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+982,   TuxTest },
{ TEXT("(TransTest) YZ  Translation in D3DMTS_VIEW, Frame #5                                                     "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+983,   TuxTest },
{ TEXT("(TransTest) YZ  Translation in D3DMTS_VIEW, Frame #6                                                     "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+984,   TuxTest },
{ TEXT("(TransTest) YZ  Translation in D3DMTS_VIEW, Frame #7                                                     "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+985,   TuxTest },
{ TEXT("(TransTest) YZ  Translation in D3DMTS_VIEW, Frame #8                                                     "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+986,   TuxTest },
{ TEXT("(TransTest) YZ  Translation in D3DMTS_VIEW, Frame #9                                                     "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+987,   TuxTest },
{ TEXT("(TransTest) YZ  Translation in D3DMTS_VIEW, Frame #10                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+988,   TuxTest },
{ TEXT("(TransTest) YZ  Translation in D3DMTS_VIEW, Frame #11                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+989,   TuxTest },
{ TEXT("(TransTest) YZ  Translation in D3DMTS_VIEW, Frame #12                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+990,   TuxTest },
{ TEXT("(TransTest) YZ  Translation in D3DMTS_VIEW, Frame #13                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+991,   TuxTest },
{ TEXT("(TransTest) YZ  Translation in D3DMTS_VIEW, Frame #14                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+992,   TuxTest },
{ TEXT("(TransTest) YZ  Translation in D3DMTS_VIEW, Frame #15                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+993,   TuxTest },
{ TEXT("(TransTest) YZ  Translation in D3DMTS_VIEW, Frame #16                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+994,   TuxTest },
{ TEXT("(TransTest) XYZ Translation in D3DMTS_VIEW, Frame #1                                                     "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+995,   TuxTest },
{ TEXT("(TransTest) XYZ Translation in D3DMTS_VIEW, Frame #2                                                     "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+996,   TuxTest },
{ TEXT("(TransTest) XYZ Translation in D3DMTS_VIEW, Frame #3                                                     "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+997,   TuxTest },
{ TEXT("(TransTest) XYZ Translation in D3DMTS_VIEW, Frame #4                                                     "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+998,   TuxTest },
{ TEXT("(TransTest) XYZ Translation in D3DMTS_VIEW, Frame #5                                                     "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+999,   TuxTest },
{ TEXT("(TransTest) XYZ Translation in D3DMTS_VIEW, Frame #6                                                     "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+1000,   TuxTest },
{ TEXT("(TransTest) XYZ Translation in D3DMTS_VIEW, Frame #7                                                     "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+1001,   TuxTest },
{ TEXT("(TransTest) XYZ Translation in D3DMTS_VIEW, Frame #8                                                     "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+1002,   TuxTest },
{ TEXT("(TransTest) XYZ Translation in D3DMTS_VIEW, Frame #9                                                     "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+1003,   TuxTest },
{ TEXT("(TransTest) XYZ Translation in D3DMTS_VIEW, Frame #10                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+1004,   TuxTest },
{ TEXT("(TransTest) XYZ Translation in D3DMTS_VIEW, Frame #11                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+1005,   TuxTest },
{ TEXT("(TransTest) XYZ Translation in D3DMTS_VIEW, Frame #12                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+1006,   TuxTest },
{ TEXT("(TransTest) XYZ Translation in D3DMTS_VIEW, Frame #13                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+1007,   TuxTest },
{ TEXT("(TransTest) XYZ Translation in D3DMTS_VIEW, Frame #14                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+1008,   TuxTest },
{ TEXT("(TransTest) XYZ Translation in D3DMTS_VIEW, Frame #15                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+1009,   TuxTest },
{ TEXT("(TransTest) XYZ Translation in D3DMTS_VIEW, Frame #16                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+1010,   TuxTest },
{ TEXT("(TransTest) XYZ Translation in D3DMTS_VIEW, Frame #17                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+1011,   TuxTest },
{ TEXT("(TransTest) XYZ Translation in D3DMTS_VIEW, Frame #18                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+1012,   TuxTest },
{ TEXT("(TransTest) XYZ Translation in D3DMTS_VIEW, Frame #19                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+1013,   TuxTest },
{ TEXT("(TransTest) XYZ Translation in D3DMTS_VIEW, Frame #20                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+1014,   TuxTest },
{ TEXT("(TransTest) XYZ Translation in D3DMTS_VIEW, Frame #21                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+1015,   TuxTest },
{ TEXT("(TransTest) XYZ Translation in D3DMTS_VIEW, Frame #22                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+1016,   TuxTest },
{ TEXT("(TransTest) XYZ Translation in D3DMTS_VIEW, Frame #23                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+1017,   TuxTest },
{ TEXT("(TransTest) XYZ Translation in D3DMTS_VIEW, Frame #24                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+1018,   TuxTest },
{ TEXT("(TransTest) XYZ Translation in D3DMTS_VIEW, Frame #25                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+1019,   TuxTest },
{ TEXT("(TransTest) XYZ Translation in D3DMTS_VIEW, Frame #26                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+1020,   TuxTest },
{ TEXT("(TransTest) XYZ Translation in D3DMTS_VIEW, Frame #27                                                    "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+1021,   TuxTest },
{ TEXT("(TransTest) X   Translation in D3DMTS_WORLD, Frame #1 (Fixed Point)                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+1022,   TuxTest },
{ TEXT("(TransTest) Y   Translation in D3DMTS_WORLD, Frame #1 (Fixed Point)                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+1023,   TuxTest },
{ TEXT("(TransTest) Z   Translation in D3DMTS_WORLD, Frame #1 (Fixed Point)                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+1024,   TuxTest },
{ TEXT("(TransTest) XY  Translation in D3DMTS_WORLD, Frame #1 (Fixed Point)                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+1025,   TuxTest },
{ TEXT("(TransTest) XZ  Translation in D3DMTS_WORLD, Frame #1 (Fixed Point)                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+1026,   TuxTest },
{ TEXT("(TransTest) YZ  Translation in D3DMTS_WORLD, Frame #1 (Fixed Point)                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+1027,   TuxTest },
{ TEXT("(TransTest) XYZ Translation in D3DMTS_WORLD, Frame #1 (Fixed Point)                                      "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+1028,   TuxTest },
{ TEXT("(TransTest) X   Translation in D3DMTS_VIEW, Frame #1 (Fixed Point)                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+1029,   TuxTest },
{ TEXT("(TransTest) Y   Translation in D3DMTS_VIEW, Frame #1 (Fixed Point)                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+1030,   TuxTest },
{ TEXT("(TransTest) Z   Translation in D3DMTS_VIEW, Frame #1 (Fixed Point)                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+1031,   TuxTest },
{ TEXT("(TransTest) XY  Translation in D3DMTS_VIEW, Frame #1 (Fixed Point)                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+1032,   TuxTest },
{ TEXT("(TransTest) XZ  Translation in D3DMTS_VIEW, Frame #1 (Fixed Point)                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+1033,   TuxTest },
{ TEXT("(TransTest) YZ  Translation in D3DMTS_VIEW, Frame #1 (Fixed Point)                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+1034,   TuxTest },
{ TEXT("(TransTest) XYZ Translation in D3DMTS_VIEW, Frame #1 (Fixed Point)                                       "),        1,         0,        D3DMQA_TRANSFORMTEST_BASE+1035,   TuxTest },

//
// StretchRect tests
//
{ TEXT("(StretchRectTest) Plain Image Source,      Backbuffer Destination,       POINT filter,  Stretch              "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+  0  ,   TuxTest },
{ TEXT("(StretchRectTest) Plain Image Source,      Backbuffer Destination,       POINT filter,  Shrink               "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+  1  ,   TuxTest },
{ TEXT("(StretchRectTest) Plain Image Source,      Backbuffer Destination,       POINT filter,  Copy (no stretching) "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+  2  ,   TuxTest },
//{ TEXT("(StretchRectTest) Plain Image Source,      Plain Image Destination,      POINT filter,  Stretch              "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+  3  ,   TuxTest },
//{ TEXT("(StretchRectTest) Plain Image Source,      Plain Image Destination,      POINT filter,  Shrink               "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+  4  ,   TuxTest },
{ TEXT("(StretchRectTest) Plain Image Source,      Plain Image Destination,      POINT filter,  Copy (no stretching) "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+  5  ,   TuxTest },
{ TEXT("(StretchRectTest) Plain Image Source,      Texture (SYSMEM) Destination, POINT filter,  Stretch              "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+  6  ,   TuxTest },
{ TEXT("(StretchRectTest) Plain Image Source,      Texture (SYSMEM) Destination, POINT filter,  Shrink               "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+  7  ,   TuxTest },
{ TEXT("(StretchRectTest) Plain Image Source,      Texture (SYSMEM) Destination, POINT filter,  Copy (no stretching) "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+  8  ,   TuxTest },
{ TEXT("(StretchRectTest) Plain Image Source,      Texture (VIDMEM) Destination, POINT filter,  Stretch              "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+  9  ,   TuxTest },
{ TEXT("(StretchRectTest) Plain Image Source,      Texture (VIDMEM) Destination, POINT filter,  Shrink               "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 10  ,   TuxTest },
{ TEXT("(StretchRectTest) Plain Image Source,      Texture (VIDMEM) Destination, POINT filter,  Copy (no stretching) "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 11  ,   TuxTest },
//{ TEXT("(StretchRectTest) Backbuffer Source,       Plain Image Destination,      POINT filter,  Stretch              "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 12  ,   TuxTest },
//{ TEXT("(StretchRectTest) Backbuffer Source,       Plain Image Destination,      POINT filter,  Shrink               "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 13  ,   TuxTest },
//{ TEXT("(StretchRectTest) Backbuffer Source,       Plain Image Destination,      POINT filter,  Copy (no stretching) "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 14  ,   TuxTest },
{ TEXT("(StretchRectTest) Backbuffer Source,       Texture (SYSMEM) Destination, POINT filter,  Stretch              "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 15  ,   TuxTest },
{ TEXT("(StretchRectTest) Backbuffer Source,       Texture (SYSMEM) Destination, POINT filter,  Shrink               "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 16  ,   TuxTest },
{ TEXT("(StretchRectTest) Backbuffer Source,       Texture (SYSMEM) Destination, POINT filter,  Copy (no stretching) "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 17  ,   TuxTest },
{ TEXT("(StretchRectTest) Backbuffer Source,       Texture (VIDMEM) Destination, POINT filter,  Stretch              "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 18  ,   TuxTest },
{ TEXT("(StretchRectTest) Backbuffer Source,       Texture (VIDMEM) Destination, POINT filter,  Shrink               "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 19  ,   TuxTest },
{ TEXT("(StretchRectTest) Backbuffer Source,       Texture (VIDMEM) Destination, POINT filter,  Copy (no stretching) "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 20  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (SYSMEM) Source, Backbuffer Destination,       POINT filter,  Stretch              "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 21  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (SYSMEM) Source, Backbuffer Destination,       POINT filter,  Shrink               "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 22  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (SYSMEM) Source, Backbuffer Destination,       POINT filter,  Copy (no stretching) "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 23  ,   TuxTest },
//{ TEXT("(StretchRectTest) Texture (SYSMEM) Source, Plain Image Destination,      POINT filter,  Stretch              "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 24  ,   TuxTest },
//{ TEXT("(StretchRectTest) Texture (SYSMEM) Source, Plain Image Destination,      POINT filter,  Shrink               "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 25  ,   TuxTest },
//{ TEXT("(StretchRectTest) Texture (SYSMEM) Source, Plain Image Destination,      POINT filter,  Copy (no stretching) "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 26  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (SYSMEM) Source, Texture (SYSMEM) Destination, POINT filter,  Stretch              "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 27  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (SYSMEM) Source, Texture (SYSMEM) Destination, POINT filter,  Shrink               "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 28  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (SYSMEM) Source, Texture (SYSMEM) Destination, POINT filter,  Copy (no stretching) "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 29  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (SYSMEM) Source, Texture (VIDMEM) Destination, POINT filter,  Stretch              "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 30  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (SYSMEM) Source, Texture (VIDMEM) Destination, POINT filter,  Shrink               "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 31  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (SYSMEM) Source, Texture (VIDMEM) Destination, POINT filter,  Copy (no stretching) "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 32  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (VIDMEM) Source, Backbuffer Destination,       POINT filter,  Stretch              "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 33  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (VIDMEM) Source, Backbuffer Destination,       POINT filter,  Shrink               "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 34  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (VIDMEM) Source, Backbuffer Destination,       POINT filter,  Copy (no stretching) "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 35  ,   TuxTest },
//{ TEXT("(StretchRectTest) Texture (VIDMEM) Source, Plain Image Destination,      POINT filter,  Stretch              "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 36  ,   TuxTest },
//{ TEXT("(StretchRectTest) Texture (VIDMEM) Source, Plain Image Destination,      POINT filter,  Shrink               "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 37  ,   TuxTest },
//{ TEXT("(StretchRectTest) Texture (VIDMEM) Source, Plain Image Destination,      POINT filter,  Copy (no stretching) "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 38  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (VIDMEM) Source, Texture (SYSMEM) Destination, POINT filter,  Stretch              "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 39  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (VIDMEM) Source, Texture (SYSMEM) Destination, POINT filter,  Shrink               "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 40  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (VIDMEM) Source, Texture (SYSMEM) Destination, POINT filter,  Copy (no stretching) "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 41  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (VIDMEM) Source, Texture (VIDMEM) Destination, POINT filter,  Stretch              "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 42  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (VIDMEM) Source, Texture (VIDMEM) Destination, POINT filter,  Shrink               "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 43  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (VIDMEM) Source, Texture (VIDMEM) Destination, POINT filter,  Copy (no stretching) "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 44  ,   TuxTest },
{ TEXT("(StretchRectTest) Plain Image Source,      Backbuffer Destination,       LINEAR filter, Stretch              "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 45  ,   TuxTest },
{ TEXT("(StretchRectTest) Plain Image Source,      Backbuffer Destination,       LINEAR filter, Shrink               "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 46  ,   TuxTest },
{ TEXT("(StretchRectTest) Plain Image Source,      Backbuffer Destination,       LINEAR filter, Copy (no stretching) "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 47  ,   TuxTest },
//{ TEXT("(StretchRectTest) Plain Image Source,      Plain Image Destination,      LINEAR filter, Stretch              "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 48  ,   TuxTest },
//{ TEXT("(StretchRectTest) Plain Image Source,      Plain Image Destination,      LINEAR filter, Shrink               "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 49  ,   TuxTest },
{ TEXT("(StretchRectTest) Plain Image Source,      Plain Image Destination,      LINEAR filter, Copy (no stretching) "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 50  ,   TuxTest },
{ TEXT("(StretchRectTest) Plain Image Source,      Texture (SYSMEM) Destination, LINEAR filter, Stretch              "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 51  ,   TuxTest },
{ TEXT("(StretchRectTest) Plain Image Source,      Texture (SYSMEM) Destination, LINEAR filter, Shrink               "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 52  ,   TuxTest },
{ TEXT("(StretchRectTest) Plain Image Source,      Texture (SYSMEM) Destination, LINEAR filter, Copy (no stretching) "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 53  ,   TuxTest },
{ TEXT("(StretchRectTest) Plain Image Source,      Texture (VIDMEM) Destination, LINEAR filter, Stretch              "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 54  ,   TuxTest },
{ TEXT("(StretchRectTest) Plain Image Source,      Texture (VIDMEM) Destination, LINEAR filter, Shrink               "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 55  ,   TuxTest },
{ TEXT("(StretchRectTest) Plain Image Source,      Texture (VIDMEM) Destination, LINEAR filter, Copy (no stretching) "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 56  ,   TuxTest },
//{ TEXT("(StretchRectTest) Backbuffer Source,       Plain Image Destination,      LINEAR filter, Stretch              "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 57  ,   TuxTest },
//{ TEXT("(StretchRectTest) Backbuffer Source,       Plain Image Destination,      LINEAR filter, Shrink               "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 58  ,   TuxTest },
//{ TEXT("(StretchRectTest) Backbuffer Source,       Plain Image Destination,      LINEAR filter, Copy (no stretching) "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 59  ,   TuxTest },
{ TEXT("(StretchRectTest) Backbuffer Source,       Texture (SYSMEM) Destination, LINEAR filter, Stretch              "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 60  ,   TuxTest },
{ TEXT("(StretchRectTest) Backbuffer Source,       Texture (SYSMEM) Destination, LINEAR filter, Shrink               "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 61  ,   TuxTest },
{ TEXT("(StretchRectTest) Backbuffer Source,       Texture (SYSMEM) Destination, LINEAR filter, Copy (no stretching) "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 62  ,   TuxTest },
{ TEXT("(StretchRectTest) Backbuffer Source,       Texture (VIDMEM) Destination, LINEAR filter, Stretch              "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 63  ,   TuxTest },
{ TEXT("(StretchRectTest) Backbuffer Source,       Texture (VIDMEM) Destination, LINEAR filter, Shrink               "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 64  ,   TuxTest },
{ TEXT("(StretchRectTest) Backbuffer Source,       Texture (VIDMEM) Destination, LINEAR filter, Copy (no stretching) "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 65  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (SYSMEM) Source, Backbuffer Destination,       LINEAR filter, Stretch              "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 66  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (SYSMEM) Source, Backbuffer Destination,       LINEAR filter, Shrink               "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 67  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (SYSMEM) Source, Backbuffer Destination,       LINEAR filter, Copy (no stretching) "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 68  ,   TuxTest },
//{ TEXT("(StretchRectTest) Texture (SYSMEM) Source, Plain Image Destination,      LINEAR filter, Stretch              "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 69  ,   TuxTest },
//{ TEXT("(StretchRectTest) Texture (SYSMEM) Source, Plain Image Destination,      LINEAR filter, Shrink               "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 70  ,   TuxTest },
//{ TEXT("(StretchRectTest) Texture (SYSMEM) Source, Plain Image Destination,      LINEAR filter, Copy (no stretching) "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 71  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (SYSMEM) Source, Texture (SYSMEM) Destination, LINEAR filter, Stretch              "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 72  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (SYSMEM) Source, Texture (SYSMEM) Destination, LINEAR filter, Shrink               "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 73  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (SYSMEM) Source, Texture (SYSMEM) Destination, LINEAR filter, Copy (no stretching) "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 74  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (SYSMEM) Source, Texture (VIDMEM) Destination, LINEAR filter, Stretch              "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 75  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (SYSMEM) Source, Texture (VIDMEM) Destination, LINEAR filter, Shrink               "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 76  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (SYSMEM) Source, Texture (VIDMEM) Destination, LINEAR filter, Copy (no stretching) "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 77  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (VIDMEM) Source, Backbuffer Destination,       LINEAR filter, Stretch              "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 78  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (VIDMEM) Source, Backbuffer Destination,       LINEAR filter, Shrink               "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 79  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (VIDMEM) Source, Backbuffer Destination,       LINEAR filter, Copy (no stretching) "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 80  ,   TuxTest },
//{ TEXT("(StretchRectTest) Texture (VIDMEM) Source, Plain Image Destination,      LINEAR filter, Stretch              "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 81  ,   TuxTest },
//{ TEXT("(StretchRectTest) Texture (VIDMEM) Source, Plain Image Destination,      LINEAR filter, Shrink               "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 82  ,   TuxTest },
//{ TEXT("(StretchRectTest) Texture (VIDMEM) Source, Plain Image Destination,      LINEAR filter, Copy (no stretching) "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 83  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (VIDMEM) Source, Texture (SYSMEM) Destination, LINEAR filter, Stretch              "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 84  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (VIDMEM) Source, Texture (SYSMEM) Destination, LINEAR filter, Shrink               "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 85  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (VIDMEM) Source, Texture (SYSMEM) Destination, LINEAR filter, Copy (no stretching) "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 86  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (VIDMEM) Source, Texture (VIDMEM) Destination, LINEAR filter, Stretch              "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 87  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (VIDMEM) Source, Texture (VIDMEM) Destination, LINEAR filter, Shrink               "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 88  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (VIDMEM) Source, Texture (VIDMEM) Destination, LINEAR filter, Copy (no stretching) "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 89  ,   TuxTest },
{ TEXT("(StretchRectTest) Plain Image Source,      Backbuffer Destination,       NONE filter,   Stretch              "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 90  ,   TuxTest },
{ TEXT("(StretchRectTest) Plain Image Source,      Backbuffer Destination,       NONE filter,   Shrink               "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 91  ,   TuxTest },
{ TEXT("(StretchRectTest) Plain Image Source,      Backbuffer Destination,       NONE filter,   Copy (no stretching) "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 92  ,   TuxTest },
//{ TEXT("(StretchRectTest) Plain Image Source,      Plain Image Destination,      NONE filter,   Stretch              "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 93  ,   TuxTest },
//{ TEXT("(StretchRectTest) Plain Image Source,      Plain Image Destination,      NONE filter,   Shrink               "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 94  ,   TuxTest },
{ TEXT("(StretchRectTest) Plain Image Source,      Plain Image Destination,      NONE filter,   Copy (no stretching) "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 95  ,   TuxTest },
{ TEXT("(StretchRectTest) Plain Image Source,      Texture (SYSMEM) Destination, NONE filter,   Stretch              "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 96  ,   TuxTest },
{ TEXT("(StretchRectTest) Plain Image Source,      Texture (SYSMEM) Destination, NONE filter,   Shrink               "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 97  ,   TuxTest },
{ TEXT("(StretchRectTest) Plain Image Source,      Texture (SYSMEM) Destination, NONE filter,   Copy (no stretching) "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 98  ,   TuxTest },
{ TEXT("(StretchRectTest) Plain Image Source,      Texture (VIDMEM) Destination, NONE filter,   Stretch              "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+ 99  ,   TuxTest },
{ TEXT("(StretchRectTest) Plain Image Source,      Texture (VIDMEM) Destination, NONE filter,   Shrink               "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+100  ,   TuxTest },
{ TEXT("(StretchRectTest) Plain Image Source,      Texture (VIDMEM) Destination, NONE filter,   Copy (no stretching) "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+101  ,   TuxTest },
//{ TEXT("(StretchRectTest) Backbuffer Source,       Plain Image Destination,      NONE filter,   Stretch              "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+102  ,   TuxTest },
//{ TEXT("(StretchRectTest) Backbuffer Source,       Plain Image Destination,      NONE filter,   Shrink               "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+103  ,   TuxTest },
//{ TEXT("(StretchRectTest) Backbuffer Source,       Plain Image Destination,      NONE filter,   Copy (no stretching) "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+104  ,   TuxTest },
{ TEXT("(StretchRectTest) Backbuffer Source,       Texture (SYSMEM) Destination, NONE filter,   Stretch              "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+105  ,   TuxTest },
{ TEXT("(StretchRectTest) Backbuffer Source,       Texture (SYSMEM) Destination, NONE filter,   Shrink               "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+106  ,   TuxTest },
{ TEXT("(StretchRectTest) Backbuffer Source,       Texture (SYSMEM) Destination, NONE filter,   Copy (no stretching) "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+107  ,   TuxTest },
{ TEXT("(StretchRectTest) Backbuffer Source,       Texture (VIDMEM) Destination, NONE filter,   Stretch              "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+108  ,   TuxTest },
{ TEXT("(StretchRectTest) Backbuffer Source,       Texture (VIDMEM) Destination, NONE filter,   Shrink               "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+109  ,   TuxTest },
{ TEXT("(StretchRectTest) Backbuffer Source,       Texture (VIDMEM) Destination, NONE filter,   Copy (no stretching) "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+110  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (SYSMEM) Source, Backbuffer Destination,       NONE filter,   Stretch              "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+111  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (SYSMEM) Source, Backbuffer Destination,       NONE filter,   Shrink               "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+112  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (SYSMEM) Source, Backbuffer Destination,       NONE filter,   Copy (no stretching) "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+113  ,   TuxTest },
//{ TEXT("(StretchRectTest) Texture (SYSMEM) Source, Plain Image Destination,      NONE filter,   Stretch              "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+114  ,   TuxTest },
//{ TEXT("(StretchRectTest) Texture (SYSMEM) Source, Plain Image Destination,      NONE filter,   Shrink               "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+115  ,   TuxTest },
//{ TEXT("(StretchRectTest) Texture (SYSMEM) Source, Plain Image Destination,      NONE filter,   Copy (no stretching) "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+116  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (SYSMEM) Source, Texture (SYSMEM) Destination, NONE filter,   Stretch              "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+117  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (SYSMEM) Source, Texture (SYSMEM) Destination, NONE filter,   Shrink               "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+118  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (SYSMEM) Source, Texture (SYSMEM) Destination, NONE filter,   Copy (no stretching) "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+119  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (SYSMEM) Source, Texture (VIDMEM) Destination, NONE filter,   Stretch              "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+120  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (SYSMEM) Source, Texture (VIDMEM) Destination, NONE filter,   Shrink               "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+121  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (SYSMEM) Source, Texture (VIDMEM) Destination, NONE filter,   Copy (no stretching) "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+122  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (VIDMEM) Source, Backbuffer Destination,       NONE filter,   Stretch              "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+123  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (VIDMEM) Source, Backbuffer Destination,       NONE filter,   Shrink               "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+124  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (VIDMEM) Source, Backbuffer Destination,       NONE filter,   Copy (no stretching) "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+125  ,   TuxTest },
//{ TEXT("(StretchRectTest) Texture (VIDMEM) Source, Plain Image Destination,      NONE filter,   Stretch              "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+126  ,   TuxTest },
//{ TEXT("(StretchRectTest) Texture (VIDMEM) Source, Plain Image Destination,      NONE filter,   Shrink               "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+127  ,   TuxTest },
//{ TEXT("(StretchRectTest) Texture (VIDMEM) Source, Plain Image Destination,      NONE filter,   Copy (no stretching) "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+128  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (VIDMEM) Source, Texture (SYSMEM) Destination, NONE filter,   Stretch              "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+129  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (VIDMEM) Source, Texture (SYSMEM) Destination, NONE filter,   Shrink               "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+130  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (VIDMEM) Source, Texture (SYSMEM) Destination, NONE filter,   Copy (no stretching) "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+131  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (VIDMEM) Source, Texture (VIDMEM) Destination, NONE filter,   Stretch              "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+132  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (VIDMEM) Source, Texture (VIDMEM) Destination, NONE filter,   Shrink               "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+133  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (VIDMEM) Source, Texture (VIDMEM) Destination, NONE filter,   Copy (no stretching) "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+134  ,   TuxTest },
{ TEXT("(StretchRectTest) Plain Image Source,      Backbuffer Destination,       LINEAR filter, Stretch, Edgy source "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+135  ,   TuxTest },
//{ TEXT("(StretchRectTest) Plain Image Source,      Plain Image Destination,      LINEAR filter, Stretch, Edgy source "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+136  ,   TuxTest },
{ TEXT("(StretchRectTest) Plain Image Source,      Texture (SYSMEM) Destination, LINEAR filter, Stretch, Edgy source "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+137  ,   TuxTest },
{ TEXT("(StretchRectTest) Plain Image Source,      Texture (VIDMEM) Destination, LINEAR filter, Stretch, Edgy source "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+138  ,   TuxTest },
//{ TEXT("(StretchRectTest) Backbuffer Source,       Plain Image Destination,      LINEAR filter, Stretch, Edgy source "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+139  ,   TuxTest },
{ TEXT("(StretchRectTest) Backbuffer Source,       Texture (SYSMEM) Destination, LINEAR filter, Stretch, Edgy source "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+140  ,   TuxTest },
{ TEXT("(StretchRectTest) Backbuffer Source,       Texture (VIDMEM) Destination, LINEAR filter, Stretch, Edgy source "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+141  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (SYSMEM) Source, Backbuffer Destination,       LINEAR filter, Stretch, Edgy source "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+142  ,   TuxTest },
//{ TEXT("(StretchRectTest) Texture (SYSMEM) Source, Plain Image Destination,      LINEAR filter, Stretch, Edgy source "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+143  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (SYSMEM) Source, Texture (SYSMEM) Destination, LINEAR filter, Stretch, Edgy source "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+144  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (SYSMEM) Source, Texture (VIDMEM) Destination, LINEAR filter, Stretch, Edgy source "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+145  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (VIDMEM) Source, Backbuffer Destination,       LINEAR filter, Stretch, Edgy source "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+146  ,   TuxTest },
//{ TEXT("(StretchRectTest) Texture (VIDMEM) Source, Plain Image Destination,      LINEAR filter, Stretch, Edgy source "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+147  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (VIDMEM) Source, Texture (SYSMEM) Destination, LINEAR filter, Stretch, Edgy source "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+148  ,   TuxTest },
{ TEXT("(StretchRectTest) Texture (VIDMEM) Source, Texture (VIDMEM) Destination, LINEAR filter, Stretch, Edgy source "),        1,         0,   D3DMQA_STRETCHRECTTEST_BASE+149  ,   TuxTest },


{ TEXT("(CopyRectsTest) Plain Image Source,        Backbuffer Destination,       Full Surface                          "),        1,         0,   D3DMQA_COPYRECTSTEST_BASE+  0  ,   TuxTest },
{ TEXT("(CopyRectsTest) Plain Image Source,        Backbuffer Destination,       Source but no destination             "),        1,         0,   D3DMQA_COPYRECTSTEST_BASE+  1  ,   TuxTest },
{ TEXT("(CopyRectsTest) Plain Image Source,        Backbuffer Destination,       Source and destination                "),        1,         0,   D3DMQA_COPYRECTSTEST_BASE+  2  ,   TuxTest },
{ TEXT("(CopyRectsTest) Plain Image Source,        Plain Image Destination,      Full Surface                          "),        1,         0,   D3DMQA_COPYRECTSTEST_BASE+  3  ,   TuxTest },
{ TEXT("(CopyRectsTest) Plain Image Source,        Plain Image Destination,      Source but no destination             "),        1,         0,   D3DMQA_COPYRECTSTEST_BASE+  4  ,   TuxTest },
{ TEXT("(CopyRectsTest) Plain Image Source,        Plain Image Destination,      Source and destination                "),        1,         0,   D3DMQA_COPYRECTSTEST_BASE+  5  ,   TuxTest },
//{ TEXT("(CopyRectsTest) Plain Image Source,        Texture (SYSMEM) Destination, Full Surface                          "),        1,         0,   D3DMQA_COPYRECTSTEST_BASE+  6  ,   TuxTest },
{ TEXT("(CopyRectsTest) Plain Image Source,        Texture (SYSMEM) Destination, Source but no destination             "),        1,         0,   D3DMQA_COPYRECTSTEST_BASE+  7  ,   TuxTest },
{ TEXT("(CopyRectsTest) Plain Image Source,        Texture (SYSMEM) Destination, Source and destination                "),        1,         0,   D3DMQA_COPYRECTSTEST_BASE+  8  ,   TuxTest },
//{ TEXT("(CopyRectsTest) Plain Image Source,        Texture (VIDMEM) Destination, Full Surface                          "),        1,         0,   D3DMQA_COPYRECTSTEST_BASE+  9  ,   TuxTest },
{ TEXT("(CopyRectsTest) Plain Image Source,        Texture (VIDMEM) Destination, Source but no destination             "),        1,         0,   D3DMQA_COPYRECTSTEST_BASE+ 10  ,   TuxTest },
{ TEXT("(CopyRectsTest) Plain Image Source,        Texture (VIDMEM) Destination, Source and destination                "),        1,         0,   D3DMQA_COPYRECTSTEST_BASE+ 11  ,   TuxTest },
{ TEXT("(CopyRectsTest) Backbuffer Source,         Plain Image Destination,      Full Surface                          "),        1,         0,   D3DMQA_COPYRECTSTEST_BASE+ 12  ,   TuxTest },
{ TEXT("(CopyRectsTest) Backbuffer Source,         Plain Image Destination,      Source but no destination             "),        1,         0,   D3DMQA_COPYRECTSTEST_BASE+ 13  ,   TuxTest },
{ TEXT("(CopyRectsTest) Backbuffer Source,         Plain Image Destination,      Source and destination                "),        1,         0,   D3DMQA_COPYRECTSTEST_BASE+ 14  ,   TuxTest },
//{ TEXT("(CopyRectsTest) Backbuffer Source,         Texture (SYSMEM) Destination, Full Surface                          "),        1,         0,   D3DMQA_COPYRECTSTEST_BASE+ 15  ,   TuxTest },
{ TEXT("(CopyRectsTest) Backbuffer Source,         Texture (SYSMEM) Destination, Source but no destination             "),        1,         0,   D3DMQA_COPYRECTSTEST_BASE+ 16  ,   TuxTest },
{ TEXT("(CopyRectsTest) Backbuffer Source,         Texture (SYSMEM) Destination, Source and destination                "),        1,         0,   D3DMQA_COPYRECTSTEST_BASE+ 17  ,   TuxTest },
//{ TEXT("(CopyRectsTest) Backbuffer Source,         Texture (VIDMEM) Destination, Full Surface                          "),        1,         0,   D3DMQA_COPYRECTSTEST_BASE+ 18  ,   TuxTest },
{ TEXT("(CopyRectsTest) Backbuffer Source,         Texture (VIDMEM) Destination, Source but no destination             "),        1,         0,   D3DMQA_COPYRECTSTEST_BASE+ 19  ,   TuxTest },
{ TEXT("(CopyRectsTest) Backbuffer Source,         Texture (VIDMEM) Destination, Source and destination                "),        1,         0,   D3DMQA_COPYRECTSTEST_BASE+ 20  ,   TuxTest },
//{ TEXT("(CopyRectsTest) Texture (SYSMEM) Source,   Backbuffer Destination,       Full Surface                          "),        1,         0,   D3DMQA_COPYRECTSTEST_BASE+ 21  ,   TuxTest },
{ TEXT("(CopyRectsTest) Texture (SYSMEM) Source,   Backbuffer Destination,       Source but no destination             "),        1,         0,   D3DMQA_COPYRECTSTEST_BASE+ 22  ,   TuxTest },
{ TEXT("(CopyRectsTest) Texture (SYSMEM) Source,   Backbuffer Destination,       Source and destination                "),        1,         0,   D3DMQA_COPYRECTSTEST_BASE+ 23  ,   TuxTest },
//{ TEXT("(CopyRectsTest) Texture (SYSMEM) Source,   Plain Image Destination,      Full Surface                          "),        1,         0,   D3DMQA_COPYRECTSTEST_BASE+ 24  ,   TuxTest },
{ TEXT("(CopyRectsTest) Texture (SYSMEM) Source,   Plain Image Destination,      Source but no destination             "),        1,         0,   D3DMQA_COPYRECTSTEST_BASE+ 25  ,   TuxTest },
{ TEXT("(CopyRectsTest) Texture (SYSMEM) Source,   Plain Image Destination,      Source and destination                "),        1,         0,   D3DMQA_COPYRECTSTEST_BASE+ 26  ,   TuxTest },
{ TEXT("(CopyRectsTest) Texture (SYSMEM) Source,   Texture (SYSMEM) Destination, Full Surface                          "),        1,         0,   D3DMQA_COPYRECTSTEST_BASE+ 27  ,   TuxTest },
{ TEXT("(CopyRectsTest) Texture (SYSMEM) Source,   Texture (SYSMEM) Destination, Source but no destination             "),        1,         0,   D3DMQA_COPYRECTSTEST_BASE+ 28  ,   TuxTest },
{ TEXT("(CopyRectsTest) Texture (SYSMEM) Source,   Texture (SYSMEM) Destination, Source and destination                "),        1,         0,   D3DMQA_COPYRECTSTEST_BASE+ 29  ,   TuxTest },
{ TEXT("(CopyRectsTest) Texture (SYSMEM) Source,   Texture (VIDMEM) Destination, Full Surface                          "),        1,         0,   D3DMQA_COPYRECTSTEST_BASE+ 30  ,   TuxTest },
{ TEXT("(CopyRectsTest) Texture (SYSMEM) Source,   Texture (VIDMEM) Destination, Source but no destination             "),        1,         0,   D3DMQA_COPYRECTSTEST_BASE+ 31  ,   TuxTest },
{ TEXT("(CopyRectsTest) Texture (SYSMEM) Source,   Texture (VIDMEM) Destination, Source and destination                "),        1,         0,   D3DMQA_COPYRECTSTEST_BASE+ 32  ,   TuxTest },
//{ TEXT("(CopyRectsTest) Texture (VIDMEM) Source,   Backbuffer Destination,       Full Surface                          "),        1,         0,   D3DMQA_COPYRECTSTEST_BASE+ 33  ,   TuxTest },
{ TEXT("(CopyRectsTest) Texture (VIDMEM) Source,   Backbuffer Destination,       Source but no destination             "),        1,         0,   D3DMQA_COPYRECTSTEST_BASE+ 34  ,   TuxTest },
{ TEXT("(CopyRectsTest) Texture (VIDMEM) Source,   Backbuffer Destination,       Source and destination                "),        1,         0,   D3DMQA_COPYRECTSTEST_BASE+ 35  ,   TuxTest },
//{ TEXT("(CopyRectsTest) Texture (VIDMEM) Source,   Plain Image Destination,      Full Surface                          "),        1,         0,   D3DMQA_COPYRECTSTEST_BASE+ 36  ,   TuxTest },
{ TEXT("(CopyRectsTest) Texture (VIDMEM) Source,   Plain Image Destination,      Source but no destination             "),        1,         0,   D3DMQA_COPYRECTSTEST_BASE+ 37  ,   TuxTest },
{ TEXT("(CopyRectsTest) Texture (VIDMEM) Source,   Plain Image Destination,      Source and destination                "),        1,         0,   D3DMQA_COPYRECTSTEST_BASE+ 38  ,   TuxTest },
{ TEXT("(CopyRectsTest) Texture (VIDMEM) Source,   Texture (SYSMEM) Destination, Full Surface                          "),        1,         0,   D3DMQA_COPYRECTSTEST_BASE+ 39  ,   TuxTest },
{ TEXT("(CopyRectsTest) Texture (VIDMEM) Source,   Texture (SYSMEM) Destination, Source but no destination             "),        1,         0,   D3DMQA_COPYRECTSTEST_BASE+ 40  ,   TuxTest },
{ TEXT("(CopyRectsTest) Texture (VIDMEM) Source,   Texture (SYSMEM) Destination, Source and destination                "),        1,         0,   D3DMQA_COPYRECTSTEST_BASE+ 41  ,   TuxTest },
{ TEXT("(CopyRectsTest) Texture (VIDMEM) Source,   Texture (VIDMEM) Destination, Full Surface                          "),        1,         0,   D3DMQA_COPYRECTSTEST_BASE+ 42  ,   TuxTest },
{ TEXT("(CopyRectsTest) Texture (VIDMEM) Source,   Texture (VIDMEM) Destination, Source but no destination             "),        1,         0,   D3DMQA_COPYRECTSTEST_BASE+ 43  ,   TuxTest },
{ TEXT("(CopyRectsTest) Texture (VIDMEM) Source,   Texture (VIDMEM) Destination, Source and destination                "),        1,         0,   D3DMQA_COPYRECTSTEST_BASE+ 44  ,   TuxTest },

{ TEXT("(ColorFillTest) Plain Image Surface,      Fullscreen                                                           "),        1,         0,   D3DMQA_COLORFILLTEST_BASE+  0  ,   TuxTest },
{ TEXT("(ColorFillTest) Plain Image Surface,      Big Rects                                                            "),        1,         0,   D3DMQA_COLORFILLTEST_BASE+  1  ,   TuxTest },
{ TEXT("(ColorFillTest) Plain Image Surface,      Small Rects                                                          "),        1,         0,   D3DMQA_COLORFILLTEST_BASE+  2  ,   TuxTest },
{ TEXT("(ColorFillTest) BackBuffer Surface,       Fullscreen                                                           "),        1,         0,   D3DMQA_COLORFILLTEST_BASE+  3  ,   TuxTest },
{ TEXT("(ColorFillTest) BackBuffer Surface,       Big Rects                                                            "),        1,         0,   D3DMQA_COLORFILLTEST_BASE+  4  ,   TuxTest },
{ TEXT("(ColorFillTest) BackBuffer Surface,       Small Rects                                                          "),        1,         0,   D3DMQA_COLORFILLTEST_BASE+  5  ,   TuxTest },
{ TEXT("(ColorFillTest) Texture (SYSMEM) Surface, Fullscreen                                                           "),        1,         0,   D3DMQA_COLORFILLTEST_BASE+  6  ,   TuxTest },
{ TEXT("(ColorFillTest) Texture (SYSMEM) Surface, Big Rects                                                            "),        1,         0,   D3DMQA_COLORFILLTEST_BASE+  7  ,   TuxTest },
{ TEXT("(ColorFillTest) Texture (SYSMEM) Surface, Small Rects                                                          "),        1,         0,   D3DMQA_COLORFILLTEST_BASE+  8  ,   TuxTest },
{ TEXT("(ColorFillTest) Texture (VIDMEM) Surface, Fullscreen                                                           "),        1,         0,   D3DMQA_COLORFILLTEST_BASE+  9  ,   TuxTest },
{ TEXT("(ColorFillTest) Texture (VIDMEM) Surface, Big Rects                                                            "),        1,         0,   D3DMQA_COLORFILLTEST_BASE+ 10  ,   TuxTest },
{ TEXT("(ColorFillTest) Texture (VIDMEM) Surface, Small Rects                                                          "),        1,         0,   D3DMQA_COLORFILLTEST_BASE+ 11  ,   TuxTest },

{ TEXT("(LastPixelTest) D3DMRS_LASTPIXEL==FALSE with D3DMPT_LINELIST Test  (D3DMRS_ZFUNC = D3DMCMP_LESSEQUAL)          "),        1,         0,   D3DMQA_LASTPIXELTEST_BASE+  0  ,   TuxTest },
{ TEXT("(LastPixelTest) D3DMRS_LASTPIXEL==TRUE with D3DMPT_LINELIST Test   (D3DMRS_ZFUNC = D3DMCMP_LESSEQUAL)          "),        1,         0,   D3DMQA_LASTPIXELTEST_BASE+  1  ,   TuxTest },
{ TEXT("(LastPixelTest) D3DMRS_LASTPIXEL==FALSE with D3DMPT_LINESTRIP Test (D3DMRS_ZFUNC = D3DMCMP_LESSEQUAL)          "),        1,         0,   D3DMQA_LASTPIXELTEST_BASE+  2  ,   TuxTest },
{ TEXT("(LastPixelTest) D3DMRS_LASTPIXEL==TRUE with D3DMPT_LINESTRIP Test  (D3DMRS_ZFUNC = D3DMCMP_LESSEQUAL)          "),        1,         0,   D3DMQA_LASTPIXELTEST_BASE+  3  ,   TuxTest },
{ TEXT("(LastPixelTest) D3DMRS_LASTPIXEL==FALSE with D3DMPT_LINELIST Test  (D3DMRS_ZFUNC = D3DMCMP_LESS)               "),        1,         0,   D3DMQA_LASTPIXELTEST_BASE+  4  ,   TuxTest },
{ TEXT("(LastPixelTest) D3DMRS_LASTPIXEL==TRUE with D3DMPT_LINELIST Test   (D3DMRS_ZFUNC = D3DMCMP_LESS)               "),        1,         0,   D3DMQA_LASTPIXELTEST_BASE+  5  ,   TuxTest },
{ TEXT("(LastPixelTest) D3DMRS_LASTPIXEL==FALSE with D3DMPT_LINESTRIP Test (D3DMRS_ZFUNC = D3DMCMP_LESS)               "),        1,         0,   D3DMQA_LASTPIXELTEST_BASE+  6  ,   TuxTest },
{ TEXT("(LastPixelTest) D3DMRS_LASTPIXEL==TRUE with D3DMPT_LINESTRIP Test  (D3DMRS_ZFUNC = D3DMCMP_LESS)               "),        1,         0,   D3DMQA_LASTPIXELTEST_BASE+  7  ,   TuxTest },

{ TEXT("(TexWrapTest) 1D Texture Coordinates, D3DMWRAPCOORD_0,       No Clipping                                       "),         1,         0,   D3DMQA_TEXWRAPTEST_BASE+ 0 , TuxTest},
{ TEXT("(TexWrapTest) 1D Texture Coordinates, D3DMWRAPCOORD_0,       Clipping                                          "),         1,         0,   D3DMQA_TEXWRAPTEST_BASE+ 1 , TuxTest},
{ TEXT("(TexWrapTest) 2D Texture Coordinates, D3DMWRAPCOORD_0,       No Clipping                                       "),         1,         0,   D3DMQA_TEXWRAPTEST_BASE+ 2 , TuxTest},
{ TEXT("(TexWrapTest) 2D Texture Coordinates, D3DMWRAPCOORD_1,       No Clipping                                       "),         1,         0,   D3DMQA_TEXWRAPTEST_BASE+ 3 , TuxTest},
{ TEXT("(TexWrapTest) 2D Texture Coordinates, D3DMWRAPCOORD_0 and 1, No Clipping                                       "),         1,         0,   D3DMQA_TEXWRAPTEST_BASE+ 4 , TuxTest},
{ TEXT("(TexWrapTest) 2D Texture Coordinates, D3DMWRAPCOORD_0,       Horizontal Clipping                               "),         1,         0,   D3DMQA_TEXWRAPTEST_BASE+ 5 , TuxTest},
{ TEXT("(TexWrapTest) 2D Texture Coordinates, D3DMWRAPCOORD_1,       Horizontal Clipping                               "),         1,         0,   D3DMQA_TEXWRAPTEST_BASE+ 6 , TuxTest},
{ TEXT("(TexWrapTest) 2D Texture Coordinates, D3DMWRAPCOORD_0 and 1, Horizontal Clipping                               "),         1,         0,   D3DMQA_TEXWRAPTEST_BASE+ 7 , TuxTest},
{ TEXT("(TexWrapTest) 2D Texture Coordinates, D3DMWRAPCOORD_0,       Vertical Clipping                                 "),         1,         0,   D3DMQA_TEXWRAPTEST_BASE+ 8 , TuxTest},
{ TEXT("(TexWrapTest) 2D Texture Coordinates, D3DMWRAPCOORD_1,       Vertical Clipping                                 "),         1,         0,   D3DMQA_TEXWRAPTEST_BASE+ 9 , TuxTest},
{ TEXT("(TexWrapTest) 2D Texture Coordinates, D3DMWRAPCOORD_0 and 1, Vertical Clipping                                 "),         1,         0,   D3DMQA_TEXWRAPTEST_BASE+10 , TuxTest},
{ TEXT("(TexWrapTest) 2D Texture Coordinates, D3DMWRAPCOORD_0,       Horizontal and Vertical Clipping                  "),         1,         0,   D3DMQA_TEXWRAPTEST_BASE+11 , TuxTest},
{ TEXT("(TexWrapTest) 2D Texture Coordinates, D3DMWRAPCOORD_1,       Horizontal and Vertical Clipping                  "),         1,         0,   D3DMQA_TEXWRAPTEST_BASE+12 , TuxTest},
{ TEXT("(TexWrapTest) 2D Texture Coordinates, D3DMWRAPCOORD_0 and 1, Horizontal and Vertical Clipping                  "),         1,         0,   D3DMQA_TEXWRAPTEST_BASE+13 , TuxTest},

{ TEXT("(AlphaTestTest) Texture Alpha, D3DMCMP_ALWAYS,       ALPHAREF = 0                                              "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+  0 , TuxTest},
{ TEXT("(AlphaTestTest) Texture Alpha, D3DMCMP_ALWAYS,       ALPHAREF = 1                                              "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+  1 , TuxTest},
{ TEXT("(AlphaTestTest) Texture Alpha, D3DMCMP_ALWAYS,       ALPHAREF = 126                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+  2 , TuxTest},
{ TEXT("(AlphaTestTest) Texture Alpha, D3DMCMP_ALWAYS,       ALPHAREF = 127                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+  3 , TuxTest},
{ TEXT("(AlphaTestTest) Texture Alpha, D3DMCMP_ALWAYS,       ALPHAREF = 128                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+  4 , TuxTest},
{ TEXT("(AlphaTestTest) Texture Alpha, D3DMCMP_ALWAYS,       ALPHAREF = 254                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+  5 , TuxTest},
{ TEXT("(AlphaTestTest) Texture Alpha, D3DMCMP_ALWAYS,       ALPHAREF = 255                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+  6 , TuxTest},
{ TEXT("(AlphaTestTest) Texture Alpha, D3DMCMP_NEVER,        ALPHAREF = 0                                              "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+  7 , TuxTest},
{ TEXT("(AlphaTestTest) Texture Alpha, D3DMCMP_NEVER,        ALPHAREF = 1                                              "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+  8 , TuxTest},
{ TEXT("(AlphaTestTest) Texture Alpha, D3DMCMP_NEVER,        ALPHAREF = 126                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+  9 , TuxTest},
{ TEXT("(AlphaTestTest) Texture Alpha, D3DMCMP_NEVER,        ALPHAREF = 127                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 10 , TuxTest},
{ TEXT("(AlphaTestTest) Texture Alpha, D3DMCMP_NEVER,        ALPHAREF = 128                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 11 , TuxTest},
{ TEXT("(AlphaTestTest) Texture Alpha, D3DMCMP_NEVER,        ALPHAREF = 254                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 12 , TuxTest},
{ TEXT("(AlphaTestTest) Texture Alpha, D3DMCMP_NEVER,        ALPHAREF = 255                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 13 , TuxTest},
{ TEXT("(AlphaTestTest) Texture Alpha, D3DMCMP_LESS,         ALPHAREF = 0                                              "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 14 , TuxTest},
{ TEXT("(AlphaTestTest) Texture Alpha, D3DMCMP_LESS,         ALPHAREF = 1                                              "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 15 , TuxTest},
{ TEXT("(AlphaTestTest) Texture Alpha, D3DMCMP_LESS,         ALPHAREF = 126                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 16 , TuxTest},
{ TEXT("(AlphaTestTest) Texture Alpha, D3DMCMP_LESS,         ALPHAREF = 127                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 17 , TuxTest},
{ TEXT("(AlphaTestTest) Texture Alpha, D3DMCMP_LESS,         ALPHAREF = 128                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 18 , TuxTest},
{ TEXT("(AlphaTestTest) Texture Alpha, D3DMCMP_LESS,         ALPHAREF = 254                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 19 , TuxTest},
{ TEXT("(AlphaTestTest) Texture Alpha, D3DMCMP_LESS,         ALPHAREF = 255                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 20 , TuxTest},
{ TEXT("(AlphaTestTest) Texture Alpha, D3DMCMP_EQUAL,        ALPHAREF = 0                                              "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 21 , TuxTest},
{ TEXT("(AlphaTestTest) Texture Alpha, D3DMCMP_EQUAL,        ALPHAREF = 1                                              "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 22 , TuxTest},
{ TEXT("(AlphaTestTest) Texture Alpha, D3DMCMP_EQUAL,        ALPHAREF = 126                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 23 , TuxTest},
{ TEXT("(AlphaTestTest) Texture Alpha, D3DMCMP_EQUAL,        ALPHAREF = 127                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 24 , TuxTest},
{ TEXT("(AlphaTestTest) Texture Alpha, D3DMCMP_EQUAL,        ALPHAREF = 128                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 25 , TuxTest},
{ TEXT("(AlphaTestTest) Texture Alpha, D3DMCMP_EQUAL,        ALPHAREF = 254                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 26 , TuxTest},
{ TEXT("(AlphaTestTest) Texture Alpha, D3DMCMP_EQUAL,        ALPHAREF = 255                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 27 , TuxTest},
{ TEXT("(AlphaTestTest) Texture Alpha, D3DMCMP_LESSEQUAL,    ALPHAREF = 0                                              "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 28 , TuxTest},
{ TEXT("(AlphaTestTest) Texture Alpha, D3DMCMP_LESSEQUAL,    ALPHAREF = 1                                              "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 29 , TuxTest},
{ TEXT("(AlphaTestTest) Texture Alpha, D3DMCMP_LESSEQUAL,    ALPHAREF = 126                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 30 , TuxTest},
{ TEXT("(AlphaTestTest) Texture Alpha, D3DMCMP_LESSEQUAL,    ALPHAREF = 127                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 31 , TuxTest},
{ TEXT("(AlphaTestTest) Texture Alpha, D3DMCMP_LESSEQUAL,    ALPHAREF = 128                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 32 , TuxTest},
{ TEXT("(AlphaTestTest) Texture Alpha, D3DMCMP_LESSEQUAL,    ALPHAREF = 254                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 33 , TuxTest},
{ TEXT("(AlphaTestTest) Texture Alpha, D3DMCMP_LESSEQUAL,    ALPHAREF = 255                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 34 , TuxTest},
{ TEXT("(AlphaTestTest) Texture Alpha, D3DMCMP_GREATER,      ALPHAREF = 0                                              "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 35 , TuxTest},
{ TEXT("(AlphaTestTest) Texture Alpha, D3DMCMP_GREATER,      ALPHAREF = 1                                              "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 36 , TuxTest},
{ TEXT("(AlphaTestTest) Texture Alpha, D3DMCMP_GREATER,      ALPHAREF = 126                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 37 , TuxTest},
{ TEXT("(AlphaTestTest) Texture Alpha, D3DMCMP_GREATER,      ALPHAREF = 127                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 38 , TuxTest},
{ TEXT("(AlphaTestTest) Texture Alpha, D3DMCMP_GREATER,      ALPHAREF = 128                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 39 , TuxTest},
{ TEXT("(AlphaTestTest) Texture Alpha, D3DMCMP_GREATER,      ALPHAREF = 254                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 40 , TuxTest},
{ TEXT("(AlphaTestTest) Texture Alpha, D3DMCMP_GREATER,      ALPHAREF = 255                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 41 , TuxTest},
{ TEXT("(AlphaTestTest) Texture Alpha, D3DMCMP_NOTEQUAL,     ALPHAREF = 0                                              "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 42 , TuxTest},
{ TEXT("(AlphaTestTest) Texture Alpha, D3DMCMP_NOTEQUAL,     ALPHAREF = 1                                              "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 43 , TuxTest},
{ TEXT("(AlphaTestTest) Texture Alpha, D3DMCMP_NOTEQUAL,     ALPHAREF = 126                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 44 , TuxTest},
{ TEXT("(AlphaTestTest) Texture Alpha, D3DMCMP_NOTEQUAL,     ALPHAREF = 127                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 45 , TuxTest},
{ TEXT("(AlphaTestTest) Texture Alpha, D3DMCMP_NOTEQUAL,     ALPHAREF = 128                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 46 , TuxTest},
{ TEXT("(AlphaTestTest) Texture Alpha, D3DMCMP_NOTEQUAL,     ALPHAREF = 254                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 47 , TuxTest},
{ TEXT("(AlphaTestTest) Texture Alpha, D3DMCMP_NOTEQUAL,     ALPHAREF = 255                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 48 , TuxTest},
{ TEXT("(AlphaTestTest) Texture Alpha, D3DMCMP_GREATEREQUAL, ALPHAREF = 0                                              "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 49 , TuxTest},
{ TEXT("(AlphaTestTest) Texture Alpha, D3DMCMP_GREATEREQUAL, ALPHAREF = 1                                              "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 50 , TuxTest},
{ TEXT("(AlphaTestTest) Texture Alpha, D3DMCMP_GREATEREQUAL, ALPHAREF = 126                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 51 , TuxTest},
{ TEXT("(AlphaTestTest) Texture Alpha, D3DMCMP_GREATEREQUAL, ALPHAREF = 127                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 52 , TuxTest},
{ TEXT("(AlphaTestTest) Texture Alpha, D3DMCMP_GREATEREQUAL, ALPHAREF = 128                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 53 , TuxTest},
{ TEXT("(AlphaTestTest) Texture Alpha, D3DMCMP_GREATEREQUAL, ALPHAREF = 254                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 54 , TuxTest},
{ TEXT("(AlphaTestTest) Texture Alpha, D3DMCMP_GREATEREQUAL, ALPHAREF = 255                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 55 , TuxTest},
{ TEXT("(AlphaTestTest) Diffuse Alpha, D3DMCMP_ALWAYS,       ALPHAREF = 0                                              "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 56 , TuxTest},
{ TEXT("(AlphaTestTest) Diffuse Alpha, D3DMCMP_ALWAYS,       ALPHAREF = 1                                              "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 57 , TuxTest},
{ TEXT("(AlphaTestTest) Diffuse Alpha, D3DMCMP_ALWAYS,       ALPHAREF = 126                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 58 , TuxTest},
{ TEXT("(AlphaTestTest) Diffuse Alpha, D3DMCMP_ALWAYS,       ALPHAREF = 127                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 59 , TuxTest},
{ TEXT("(AlphaTestTest) Diffuse Alpha, D3DMCMP_ALWAYS,       ALPHAREF = 128                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 60 , TuxTest},
{ TEXT("(AlphaTestTest) Diffuse Alpha, D3DMCMP_ALWAYS,       ALPHAREF = 254                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 61 , TuxTest},
{ TEXT("(AlphaTestTest) Diffuse Alpha, D3DMCMP_ALWAYS,       ALPHAREF = 255                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 62 , TuxTest},
{ TEXT("(AlphaTestTest) Diffuse Alpha, D3DMCMP_NEVER,        ALPHAREF = 0                                              "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 63 , TuxTest},
{ TEXT("(AlphaTestTest) Diffuse Alpha, D3DMCMP_NEVER,        ALPHAREF = 1                                              "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 64 , TuxTest},
{ TEXT("(AlphaTestTest) Diffuse Alpha, D3DMCMP_NEVER,        ALPHAREF = 126                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 65 , TuxTest},
{ TEXT("(AlphaTestTest) Diffuse Alpha, D3DMCMP_NEVER,        ALPHAREF = 127                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 66 , TuxTest},
{ TEXT("(AlphaTestTest) Diffuse Alpha, D3DMCMP_NEVER,        ALPHAREF = 128                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 67 , TuxTest},
{ TEXT("(AlphaTestTest) Diffuse Alpha, D3DMCMP_NEVER,        ALPHAREF = 254                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 68 , TuxTest},
{ TEXT("(AlphaTestTest) Diffuse Alpha, D3DMCMP_NEVER,        ALPHAREF = 255                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 69 , TuxTest},
{ TEXT("(AlphaTestTest) Diffuse Alpha, D3DMCMP_LESS,         ALPHAREF = 0                                              "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 70 , TuxTest},
{ TEXT("(AlphaTestTest) Diffuse Alpha, D3DMCMP_LESS,         ALPHAREF = 1                                              "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 71 , TuxTest},
{ TEXT("(AlphaTestTest) Diffuse Alpha, D3DMCMP_LESS,         ALPHAREF = 126                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 72 , TuxTest},
{ TEXT("(AlphaTestTest) Diffuse Alpha, D3DMCMP_LESS,         ALPHAREF = 127                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 73 , TuxTest},
{ TEXT("(AlphaTestTest) Diffuse Alpha, D3DMCMP_LESS,         ALPHAREF = 128                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 74 , TuxTest},
{ TEXT("(AlphaTestTest) Diffuse Alpha, D3DMCMP_LESS,         ALPHAREF = 254                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 75 , TuxTest},
{ TEXT("(AlphaTestTest) Diffuse Alpha, D3DMCMP_LESS,         ALPHAREF = 255                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 76 , TuxTest},
{ TEXT("(AlphaTestTest) Diffuse Alpha, D3DMCMP_EQUAL,        ALPHAREF = 0                                              "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 77 , TuxTest},
{ TEXT("(AlphaTestTest) Diffuse Alpha, D3DMCMP_EQUAL,        ALPHAREF = 1                                              "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 78 , TuxTest},
{ TEXT("(AlphaTestTest) Diffuse Alpha, D3DMCMP_EQUAL,        ALPHAREF = 126                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 79 , TuxTest},
{ TEXT("(AlphaTestTest) Diffuse Alpha, D3DMCMP_EQUAL,        ALPHAREF = 127                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 80 , TuxTest},
{ TEXT("(AlphaTestTest) Diffuse Alpha, D3DMCMP_EQUAL,        ALPHAREF = 128                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 81 , TuxTest},
{ TEXT("(AlphaTestTest) Diffuse Alpha, D3DMCMP_EQUAL,        ALPHAREF = 254                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 82 , TuxTest},
{ TEXT("(AlphaTestTest) Diffuse Alpha, D3DMCMP_EQUAL,        ALPHAREF = 255                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 83 , TuxTest},
{ TEXT("(AlphaTestTest) Diffuse Alpha, D3DMCMP_LESSEQUAL,    ALPHAREF = 0                                              "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 84 , TuxTest},
{ TEXT("(AlphaTestTest) Diffuse Alpha, D3DMCMP_LESSEQUAL,    ALPHAREF = 1                                              "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 85 , TuxTest},
{ TEXT("(AlphaTestTest) Diffuse Alpha, D3DMCMP_LESSEQUAL,    ALPHAREF = 126                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 86 , TuxTest},
{ TEXT("(AlphaTestTest) Diffuse Alpha, D3DMCMP_LESSEQUAL,    ALPHAREF = 127                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 87 , TuxTest},
{ TEXT("(AlphaTestTest) Diffuse Alpha, D3DMCMP_LESSEQUAL,    ALPHAREF = 128                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 88 , TuxTest},
{ TEXT("(AlphaTestTest) Diffuse Alpha, D3DMCMP_LESSEQUAL,    ALPHAREF = 254                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 89 , TuxTest},
{ TEXT("(AlphaTestTest) Diffuse Alpha, D3DMCMP_LESSEQUAL,    ALPHAREF = 255                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 90 , TuxTest},
{ TEXT("(AlphaTestTest) Diffuse Alpha, D3DMCMP_GREATER,      ALPHAREF = 0                                              "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 91 , TuxTest},
{ TEXT("(AlphaTestTest) Diffuse Alpha, D3DMCMP_GREATER,      ALPHAREF = 1                                              "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 92 , TuxTest},
{ TEXT("(AlphaTestTest) Diffuse Alpha, D3DMCMP_GREATER,      ALPHAREF = 126                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 93 , TuxTest},
{ TEXT("(AlphaTestTest) Diffuse Alpha, D3DMCMP_GREATER,      ALPHAREF = 127                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 94 , TuxTest},
{ TEXT("(AlphaTestTest) Diffuse Alpha, D3DMCMP_GREATER,      ALPHAREF = 128                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 95 , TuxTest},
{ TEXT("(AlphaTestTest) Diffuse Alpha, D3DMCMP_GREATER,      ALPHAREF = 254                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 96 , TuxTest},
{ TEXT("(AlphaTestTest) Diffuse Alpha, D3DMCMP_GREATER,      ALPHAREF = 255                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 97 , TuxTest},
{ TEXT("(AlphaTestTest) Diffuse Alpha, D3DMCMP_NOTEQUAL,     ALPHAREF = 0                                              "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 98 , TuxTest},
{ TEXT("(AlphaTestTest) Diffuse Alpha, D3DMCMP_NOTEQUAL,     ALPHAREF = 1                                              "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+ 99 , TuxTest},
{ TEXT("(AlphaTestTest) Diffuse Alpha, D3DMCMP_NOTEQUAL,     ALPHAREF = 126                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+100 , TuxTest},
{ TEXT("(AlphaTestTest) Diffuse Alpha, D3DMCMP_NOTEQUAL,     ALPHAREF = 127                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+101 , TuxTest},
{ TEXT("(AlphaTestTest) Diffuse Alpha, D3DMCMP_NOTEQUAL,     ALPHAREF = 128                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+102 , TuxTest},
{ TEXT("(AlphaTestTest) Diffuse Alpha, D3DMCMP_NOTEQUAL,     ALPHAREF = 254                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+103 , TuxTest},
{ TEXT("(AlphaTestTest) Diffuse Alpha, D3DMCMP_NOTEQUAL,     ALPHAREF = 255                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+104 , TuxTest},
{ TEXT("(AlphaTestTest) Diffuse Alpha, D3DMCMP_GREATEREQUAL, ALPHAREF = 0                                              "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+105 , TuxTest},
{ TEXT("(AlphaTestTest) Diffuse Alpha, D3DMCMP_GREATEREQUAL, ALPHAREF = 1                                              "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+106 , TuxTest},
{ TEXT("(AlphaTestTest) Diffuse Alpha, D3DMCMP_GREATEREQUAL, ALPHAREF = 126                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+107 , TuxTest},
{ TEXT("(AlphaTestTest) Diffuse Alpha, D3DMCMP_GREATEREQUAL, ALPHAREF = 127                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+108 , TuxTest},
{ TEXT("(AlphaTestTest) Diffuse Alpha, D3DMCMP_GREATEREQUAL, ALPHAREF = 128                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+109 , TuxTest},
{ TEXT("(AlphaTestTest) Diffuse Alpha, D3DMCMP_GREATEREQUAL, ALPHAREF = 254                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+110 , TuxTest},
{ TEXT("(AlphaTestTest) Diffuse Alpha, D3DMCMP_GREATEREQUAL, ALPHAREF = 255                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+111 , TuxTest},
{ TEXT("(AlphaTestTest) Tex*Dif Alpha, D3DMCMP_ALWAYS,       ALPHAREF = 0                                              "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+112 , TuxTest},
{ TEXT("(AlphaTestTest) Tex*Dif Alpha, D3DMCMP_ALWAYS,       ALPHAREF = 1                                              "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+113 , TuxTest},
{ TEXT("(AlphaTestTest) Tex*Dif Alpha, D3DMCMP_ALWAYS,       ALPHAREF = 126                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+114 , TuxTest},
{ TEXT("(AlphaTestTest) Tex*Dif Alpha, D3DMCMP_ALWAYS,       ALPHAREF = 127                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+115 , TuxTest},
{ TEXT("(AlphaTestTest) Tex*Dif Alpha, D3DMCMP_ALWAYS,       ALPHAREF = 128                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+116 , TuxTest},
{ TEXT("(AlphaTestTest) Tex*Dif Alpha, D3DMCMP_ALWAYS,       ALPHAREF = 254                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+117 , TuxTest},
{ TEXT("(AlphaTestTest) Tex*Dif Alpha, D3DMCMP_ALWAYS,       ALPHAREF = 255                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+118 , TuxTest},
{ TEXT("(AlphaTestTest) Tex*Dif Alpha, D3DMCMP_NEVER,        ALPHAREF = 0                                              "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+119 , TuxTest},
{ TEXT("(AlphaTestTest) Tex*Dif Alpha, D3DMCMP_NEVER,        ALPHAREF = 1                                              "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+120 , TuxTest},
{ TEXT("(AlphaTestTest) Tex*Dif Alpha, D3DMCMP_NEVER,        ALPHAREF = 126                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+121 , TuxTest},
{ TEXT("(AlphaTestTest) Tex*Dif Alpha, D3DMCMP_NEVER,        ALPHAREF = 127                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+122 , TuxTest},
{ TEXT("(AlphaTestTest) Tex*Dif Alpha, D3DMCMP_NEVER,        ALPHAREF = 128                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+123 , TuxTest},
{ TEXT("(AlphaTestTest) Tex*Dif Alpha, D3DMCMP_NEVER,        ALPHAREF = 254                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+124 , TuxTest},
{ TEXT("(AlphaTestTest) Tex*Dif Alpha, D3DMCMP_NEVER,        ALPHAREF = 255                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+125 , TuxTest},
{ TEXT("(AlphaTestTest) Tex*Dif Alpha, D3DMCMP_LESS,         ALPHAREF = 0                                              "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+126 , TuxTest},
{ TEXT("(AlphaTestTest) Tex*Dif Alpha, D3DMCMP_LESS,         ALPHAREF = 1                                              "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+127 , TuxTest},
{ TEXT("(AlphaTestTest) Tex*Dif Alpha, D3DMCMP_LESS,         ALPHAREF = 126                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+128 , TuxTest},
{ TEXT("(AlphaTestTest) Tex*Dif Alpha, D3DMCMP_LESS,         ALPHAREF = 127                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+129 , TuxTest},
{ TEXT("(AlphaTestTest) Tex*Dif Alpha, D3DMCMP_LESS,         ALPHAREF = 128                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+130 , TuxTest},
{ TEXT("(AlphaTestTest) Tex*Dif Alpha, D3DMCMP_LESS,         ALPHAREF = 254                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+131 , TuxTest},
{ TEXT("(AlphaTestTest) Tex*Dif Alpha, D3DMCMP_LESS,         ALPHAREF = 255                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+132 , TuxTest},
{ TEXT("(AlphaTestTest) Tex*Dif Alpha, D3DMCMP_EQUAL,        ALPHAREF = 0                                              "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+133 , TuxTest},
{ TEXT("(AlphaTestTest) Tex*Dif Alpha, D3DMCMP_EQUAL,        ALPHAREF = 1                                              "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+134 , TuxTest},
{ TEXT("(AlphaTestTest) Tex*Dif Alpha, D3DMCMP_EQUAL,        ALPHAREF = 126                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+135 , TuxTest},
{ TEXT("(AlphaTestTest) Tex*Dif Alpha, D3DMCMP_EQUAL,        ALPHAREF = 127                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+136 , TuxTest},
{ TEXT("(AlphaTestTest) Tex*Dif Alpha, D3DMCMP_EQUAL,        ALPHAREF = 128                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+137 , TuxTest},
{ TEXT("(AlphaTestTest) Tex*Dif Alpha, D3DMCMP_EQUAL,        ALPHAREF = 254                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+138 , TuxTest},
{ TEXT("(AlphaTestTest) Tex*Dif Alpha, D3DMCMP_EQUAL,        ALPHAREF = 255                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+139 , TuxTest},
{ TEXT("(AlphaTestTest) Tex*Dif Alpha, D3DMCMP_LESSEQUAL,    ALPHAREF = 0                                              "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+140 , TuxTest},
{ TEXT("(AlphaTestTest) Tex*Dif Alpha, D3DMCMP_LESSEQUAL,    ALPHAREF = 1                                              "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+141 , TuxTest},
{ TEXT("(AlphaTestTest) Tex*Dif Alpha, D3DMCMP_LESSEQUAL,    ALPHAREF = 126                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+142 , TuxTest},
{ TEXT("(AlphaTestTest) Tex*Dif Alpha, D3DMCMP_LESSEQUAL,    ALPHAREF = 127                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+143 , TuxTest},
{ TEXT("(AlphaTestTest) Tex*Dif Alpha, D3DMCMP_LESSEQUAL,    ALPHAREF = 128                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+144 , TuxTest},
{ TEXT("(AlphaTestTest) Tex*Dif Alpha, D3DMCMP_LESSEQUAL,    ALPHAREF = 254                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+145 , TuxTest},
{ TEXT("(AlphaTestTest) Tex*Dif Alpha, D3DMCMP_LESSEQUAL,    ALPHAREF = 255                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+146 , TuxTest},
{ TEXT("(AlphaTestTest) Tex*Dif Alpha, D3DMCMP_GREATER,      ALPHAREF = 0                                              "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+147 , TuxTest},
{ TEXT("(AlphaTestTest) Tex*Dif Alpha, D3DMCMP_GREATER,      ALPHAREF = 1                                              "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+148 , TuxTest},
{ TEXT("(AlphaTestTest) Tex*Dif Alpha, D3DMCMP_GREATER,      ALPHAREF = 126                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+149 , TuxTest},
{ TEXT("(AlphaTestTest) Tex*Dif Alpha, D3DMCMP_GREATER,      ALPHAREF = 127                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+150 , TuxTest},
{ TEXT("(AlphaTestTest) Tex*Dif Alpha, D3DMCMP_GREATER,      ALPHAREF = 128                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+151 , TuxTest},
{ TEXT("(AlphaTestTest) Tex*Dif Alpha, D3DMCMP_GREATER,      ALPHAREF = 254                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+152 , TuxTest},
{ TEXT("(AlphaTestTest) Tex*Dif Alpha, D3DMCMP_GREATER,      ALPHAREF = 255                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+153 , TuxTest},
{ TEXT("(AlphaTestTest) Tex*Dif Alpha, D3DMCMP_NOTEQUAL,     ALPHAREF = 0                                              "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+154 , TuxTest},
{ TEXT("(AlphaTestTest) Tex*Dif Alpha, D3DMCMP_NOTEQUAL,     ALPHAREF = 1                                              "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+155 , TuxTest},
{ TEXT("(AlphaTestTest) Tex*Dif Alpha, D3DMCMP_NOTEQUAL,     ALPHAREF = 126                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+156 , TuxTest},
{ TEXT("(AlphaTestTest) Tex*Dif Alpha, D3DMCMP_NOTEQUAL,     ALPHAREF = 127                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+157 , TuxTest},
{ TEXT("(AlphaTestTest) Tex*Dif Alpha, D3DMCMP_NOTEQUAL,     ALPHAREF = 128                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+158 , TuxTest},
{ TEXT("(AlphaTestTest) Tex*Dif Alpha, D3DMCMP_NOTEQUAL,     ALPHAREF = 254                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+159 , TuxTest},
{ TEXT("(AlphaTestTest) Tex*Dif Alpha, D3DMCMP_NOTEQUAL,     ALPHAREF = 255                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+160 , TuxTest},
{ TEXT("(AlphaTestTest) Tex*Dif Alpha, D3DMCMP_GREATEREQUAL, ALPHAREF = 0                                              "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+161 , TuxTest},
{ TEXT("(AlphaTestTest) Tex*Dif Alpha, D3DMCMP_GREATEREQUAL, ALPHAREF = 1                                              "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+162 , TuxTest},
{ TEXT("(AlphaTestTest) Tex*Dif Alpha, D3DMCMP_GREATEREQUAL, ALPHAREF = 126                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+163 , TuxTest},
{ TEXT("(AlphaTestTest) Tex*Dif Alpha, D3DMCMP_GREATEREQUAL, ALPHAREF = 127                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+164 , TuxTest},
{ TEXT("(AlphaTestTest) Tex*Dif Alpha, D3DMCMP_GREATEREQUAL, ALPHAREF = 128                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+165 , TuxTest},
{ TEXT("(AlphaTestTest) Tex*Dif Alpha, D3DMCMP_GREATEREQUAL, ALPHAREF = 254                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+166 , TuxTest},
{ TEXT("(AlphaTestTest) Tex*Dif Alpha, D3DMCMP_GREATEREQUAL, ALPHAREF = 255                                            "),         1,         0,   D3DMQA_ALPHATESTTEST_BASE+167 , TuxTest},

{ TEXT("(DepthBiasTest) Depth Bias, Bias =  0.0                                                                        "),         1,         0,   D3DMQA_DEPTHBIASTEST_BASE+  0 , TuxTest},
{ TEXT("(DepthBiasTest) Depth Bias, Bias =  0.001                                                                      "),         1,         0,   D3DMQA_DEPTHBIASTEST_BASE+  1 , TuxTest},
{ TEXT("(DepthBiasTest) Depth Bias, Bias = -0.001                                                                      "),         1,         0,   D3DMQA_DEPTHBIASTEST_BASE+  2 , TuxTest},
{ TEXT("(DepthBiasTest) Depth Bias, Bias =  0.5                                                                        "),         1,         0,   D3DMQA_DEPTHBIASTEST_BASE+  3 , TuxTest},
{ TEXT("(DepthBiasTest) Depth Bias, Bias = -0.5                                                                        "),         1,         0,   D3DMQA_DEPTHBIASTEST_BASE+  4 , TuxTest},
{ TEXT("(DepthBiasTest) Slope Scale Depth Bias, Y Direction, Bias =  0.57                                              "),         1,         0,   D3DMQA_DEPTHBIASTEST_BASE+  5 , TuxTest},
{ TEXT("(DepthBiasTest) Slope Scale Depth Bias, Y Direction, Bias = -0.57                                              "),         1,         0,   D3DMQA_DEPTHBIASTEST_BASE+  6 , TuxTest},
{ TEXT("(DepthBiasTest) Slope Scale Depth Bias, X Direction, Bias =  0.57                                              "),         1,         0,   D3DMQA_DEPTHBIASTEST_BASE+  7 , TuxTest},
{ TEXT("(DepthBiasTest) Slope Scale Depth Bias, X Direction, Bias = -0.57                                              "),         1,         0,   D3DMQA_DEPTHBIASTEST_BASE+  8 , TuxTest},

{ TEXT("(SwapChainTest) Present whole RECT                                                                             "),         1,         0,  D3DMQA_SWAPCHAINTEST_BASE+   0, TuxTest},
{ TEXT("(SwapChainTest) Present left-side   to left-side                                                               "),         1,         0,  D3DMQA_SWAPCHAINTEST_BASE+   1, TuxTest},
{ TEXT("(SwapChainTest) Present right-side  to right-side                                                              "),         1,         0,  D3DMQA_SWAPCHAINTEST_BASE+   2, TuxTest},
{ TEXT("(SwapChainTest) Present top-side    to top-side                                                                "),         1,         0,  D3DMQA_SWAPCHAINTEST_BASE+   3, TuxTest},
{ TEXT("(SwapChainTest) Present bottom-side to bottom-side                                                             "),         1,         0,  D3DMQA_SWAPCHAINTEST_BASE+   4, TuxTest},
{ TEXT("(SwapChainTest) Present left-side   to right-side                                                              "),         1,         0,  D3DMQA_SWAPCHAINTEST_BASE+   5, TuxTest},
{ TEXT("(SwapChainTest) Present right-side  to left-side                                                               "),         1,         0,  D3DMQA_SWAPCHAINTEST_BASE+   6, TuxTest},
{ TEXT("(SwapChainTest) Present top-side    to bottom-side                                                             "),         1,         0,  D3DMQA_SWAPCHAINTEST_BASE+   7, TuxTest},
{ TEXT("(SwapChainTest) Present bottom-side to top-side                                                                "),         1,         0,  D3DMQA_SWAPCHAINTEST_BASE+   8, TuxTest},
{ TEXT("(SwapChainTest) Present left-side   to whole viewport                                                          "),         1,         0,  D3DMQA_SWAPCHAINTEST_BASE+   9, TuxTest},
{ TEXT("(SwapChainTest) Present right-side  to whole viewport                                                          "),         1,         0,  D3DMQA_SWAPCHAINTEST_BASE+  10, TuxTest},
{ TEXT("(SwapChainTest) Present top-side    to whole viewport                                                          "),         1,         0,  D3DMQA_SWAPCHAINTEST_BASE+  11, TuxTest},
{ TEXT("(SwapChainTest) Present bottom-side to whole viewport                                                          "),         1,         0,  D3DMQA_SWAPCHAINTEST_BASE+  12, TuxTest},

{ TEXT("(OverDrawTest) Overdraw test with D3DMCULL_NONE, primitive draw order #1 (D3DMPT_TRIANGLELIST)                 "),         1,         0,   D3DMQA_OVERDRAWTEST_BASE+   0, TuxTest},
{ TEXT("(OverDrawTest) Overdraw test with D3DMCULL_CCW, primitive draw order #1  (D3DMPT_TRIANGLELIST)                 "),         1,         0,   D3DMQA_OVERDRAWTEST_BASE+   1, TuxTest},
{ TEXT("(OverDrawTest) Overdraw test with D3DMCULL_CW, primitive draw order #1   (D3DMPT_TRIANGLELIST)                 "),         1,         0,   D3DMQA_OVERDRAWTEST_BASE+   2, TuxTest},
{ TEXT("(OverDrawTest) Overdraw test with D3DMCULL_NONE, primitive draw order #2 (D3DMPT_TRIANGLELIST)                 "),         1,         0,   D3DMQA_OVERDRAWTEST_BASE+   3, TuxTest},
{ TEXT("(OverDrawTest) Overdraw test with D3DMCULL_CCW, primitive draw order #2  (D3DMPT_TRIANGLELIST)                 "),         1,         0,   D3DMQA_OVERDRAWTEST_BASE+   4, TuxTest},
{ TEXT("(OverDrawTest) Overdraw test with D3DMCULL_CW, primitive draw order #2   (D3DMPT_TRIANGLELIST)                 "),         1,         0,   D3DMQA_OVERDRAWTEST_BASE+   5, TuxTest},
{ TEXT("(OverDrawTest) Overdraw test with D3DMCULL_NONE, primitive draw order #1 (D3DMPT_TRIANGLESTRIP)                "),         1,         0,   D3DMQA_OVERDRAWTEST_BASE+   6, TuxTest},
{ TEXT("(OverDrawTest) Overdraw test with D3DMCULL_CCW, primitive draw order #1  (D3DMPT_TRIANGLESTRIP)                "),         1,         0,   D3DMQA_OVERDRAWTEST_BASE+   7, TuxTest},
{ TEXT("(OverDrawTest) Overdraw test with D3DMCULL_CW, primitive draw order #1   (D3DMPT_TRIANGLESTRIP)                "),         1,         0,   D3DMQA_OVERDRAWTEST_BASE+   8, TuxTest},
{ TEXT("(OverDrawTest) Overdraw test with D3DMCULL_NONE, primitive draw order #2 (D3DMPT_TRIANGLESTRIP)                "),         1,         0,   D3DMQA_OVERDRAWTEST_BASE+   9, TuxTest},
{ TEXT("(OverDrawTest) Overdraw test with D3DMCULL_CCW, primitive draw order #2  (D3DMPT_TRIANGLESTRIP)                "),         1,         0,   D3DMQA_OVERDRAWTEST_BASE+  10, TuxTest},
{ TEXT("(OverDrawTest) Overdraw test with D3DMCULL_CW, primitive draw order #2   (D3DMPT_TRIANGLESTRIP)                "),         1,         0,   D3DMQA_OVERDRAWTEST_BASE+  11, TuxTest},

{ TEXT("(TexStageTest) D3DMTOP_SELECTARG1 with no D3DMTA_OPTIONMASK options; Test  #1                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+   0, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG1 with no D3DMTA_OPTIONMASK options; Test  #2                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+   1, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG1 with no D3DMTA_OPTIONMASK options; Test  #3                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+   2, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG1 with no D3DMTA_OPTIONMASK options; Test  #4                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+   3, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG1 with no D3DMTA_OPTIONMASK options; Test  #5                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+   4, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG1 with no D3DMTA_OPTIONMASK options; Test  #6                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+   5, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG1 with no D3DMTA_OPTIONMASK options; Test  #7                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+   6, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG1 with no D3DMTA_OPTIONMASK options; Test  #8                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+   7, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG1 with no D3DMTA_OPTIONMASK options; Test  #9                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+   8, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG1 with no D3DMTA_OPTIONMASK options; Test #10                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+   9, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG1 with no D3DMTA_OPTIONMASK options; Test #11                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  10, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG1 with no D3DMTA_OPTIONMASK options; Test #12                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  11, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG1 with no D3DMTA_OPTIONMASK options; Test #13                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  12, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG1 with no D3DMTA_OPTIONMASK options; Test #14                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  13, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG1 with no D3DMTA_OPTIONMASK options; Test #15                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  14, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG1 with no D3DMTA_OPTIONMASK options; Test #16                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  15, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG1 with no D3DMTA_OPTIONMASK options; Test #17                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  16, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG1 with no D3DMTA_OPTIONMASK options; Test #18                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  17, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG1 with no D3DMTA_OPTIONMASK options; Test #19                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  18, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG1 with no D3DMTA_OPTIONMASK options; Test #20                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  19, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG1 with no D3DMTA_OPTIONMASK options; Test #21                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  20, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG1 with no D3DMTA_OPTIONMASK options; Test #22                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  21, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG1 with no D3DMTA_OPTIONMASK options; Test #23                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  22, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG1 with no D3DMTA_OPTIONMASK options; Test #24                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  23, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG1 with D3DMTA_COMPLEMENT; Test #1                                              "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  24, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG1 with D3DMTA_COMPLEMENT; Test #2                                              "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  25, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG1 with D3DMTA_COMPLEMENT; Test #3                                              "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  26, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG1 with D3DMTA_COMPLEMENT; Test #4                                              "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  27, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG1 with D3DMTA_ALPHAREPLICATE; Test #1                                          "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  28, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG1 with D3DMTA_ALPHAREPLICATE; Test #2                                          "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  29, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG1 with D3DMTA_ALPHAREPLICATE; Test #3                                          "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  30, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG1 with D3DMTA_ALPHAREPLICATE; Test #4                                          "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  31, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG2 with no D3DMTA_OPTIONMASK options; Test  #1                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  32, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG2 with no D3DMTA_OPTIONMASK options; Test  #2                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  33, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG2 with no D3DMTA_OPTIONMASK options; Test  #3                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  34, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG2 with no D3DMTA_OPTIONMASK options; Test  #4                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  35, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG2 with no D3DMTA_OPTIONMASK options; Test  #5                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  36, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG2 with no D3DMTA_OPTIONMASK options; Test  #6                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  37, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG2 with no D3DMTA_OPTIONMASK options; Test  #7                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  38, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG2 with no D3DMTA_OPTIONMASK options; Test  #8                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  39, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG2 with no D3DMTA_OPTIONMASK options; Test  #9                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  40, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG2 with no D3DMTA_OPTIONMASK options; Test #10                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  41, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG2 with no D3DMTA_OPTIONMASK options; Test #11                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  42, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG2 with no D3DMTA_OPTIONMASK options; Test #12                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  43, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG2 with no D3DMTA_OPTIONMASK options; Test #13                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  44, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG2 with no D3DMTA_OPTIONMASK options; Test #14                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  45, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG2 with no D3DMTA_OPTIONMASK options; Test #15                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  46, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG2 with no D3DMTA_OPTIONMASK options; Test #16                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  47, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG2 with no D3DMTA_OPTIONMASK options; Test #17                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  48, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG2 with no D3DMTA_OPTIONMASK options; Test #18                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  49, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG2 with no D3DMTA_OPTIONMASK options; Test #19                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  50, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG2 with no D3DMTA_OPTIONMASK options; Test #20                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  51, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG2 with no D3DMTA_OPTIONMASK options; Test #21                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  52, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG2 with no D3DMTA_OPTIONMASK options; Test #22                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  53, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG2 with no D3DMTA_OPTIONMASK options; Test #23                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  54, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG2 with no D3DMTA_OPTIONMASK options; Test #24                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  55, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG2 with D3DMTA_COMPLEMENT; Test #1                                              "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  56, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG2 with D3DMTA_COMPLEMENT; Test #2                                              "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  57, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG2 with D3DMTA_COMPLEMENT; Test #3                                              "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  58, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG2 with D3DMTA_COMPLEMENT; Test #4                                              "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  59, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG2 with D3DMTA_ALPHAREPLICATE; Test #1                                          "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  60, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG2 with D3DMTA_ALPHAREPLICATE; Test #2                                          "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  61, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG2 with D3DMTA_ALPHAREPLICATE; Test #3                                          "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  62, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SELECTARG2 with D3DMTA_ALPHAREPLICATE; Test #4                                          "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  63, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE with no D3DMTA_OPTIONMASK options; Test  #1                                    "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  64, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE with no D3DMTA_OPTIONMASK options; Test  #2                                    "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  65, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE with no D3DMTA_OPTIONMASK options; Test  #3                                    "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  66, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE with no D3DMTA_OPTIONMASK options; Test  #4                                    "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  67, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE with no D3DMTA_OPTIONMASK options; Test  #5                                    "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  68, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE with no D3DMTA_OPTIONMASK options; Test  #6                                    "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  69, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE with no D3DMTA_OPTIONMASK options; Test  #7                                    "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  70, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE with no D3DMTA_OPTIONMASK options; Test  #8                                    "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  71, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE with no D3DMTA_OPTIONMASK options; Test  #9                                    "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  72, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE with no D3DMTA_OPTIONMASK options; Test #10                                    "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  73, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE with no D3DMTA_OPTIONMASK options; Test #11                                    "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  74, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE with no D3DMTA_OPTIONMASK options; Test #12                                    "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  75, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE with D3DMTA_COMPLEMENT; Test  #1                                               "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  76, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE with D3DMTA_COMPLEMENT; Test  #2                                               "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  77, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE with D3DMTA_COMPLEMENT; Test  #3                                               "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  78, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE with D3DMTA_COMPLEMENT; Test  #4                                               "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  79, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE with D3DMTA_ALPHAREPLICATE; Test  #1                                           "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  80, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE with D3DMTA_ALPHAREPLICATE; Test  #2                                           "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  81, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE with D3DMTA_ALPHAREPLICATE; Test  #3                                           "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  82, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE with D3DMTA_ALPHAREPLICATE; Test  #4                                           "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  83, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE2X with no D3DMTA_OPTIONMASK options; Test  #1                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  84, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE2X with no D3DMTA_OPTIONMASK options; Test  #2                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  85, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE2X with no D3DMTA_OPTIONMASK options; Test  #3                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  86, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE2X with no D3DMTA_OPTIONMASK options; Test  #4                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  87, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE2X with no D3DMTA_OPTIONMASK options; Test  #5                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  88, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE2X with no D3DMTA_OPTIONMASK options; Test  #6                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  89, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE2X with no D3DMTA_OPTIONMASK options; Test  #7                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  90, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE2X with no D3DMTA_OPTIONMASK options; Test  #8                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  91, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE2X with no D3DMTA_OPTIONMASK options; Test  #9                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  92, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE2X with no D3DMTA_OPTIONMASK options; Test #10                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  93, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE2X with no D3DMTA_OPTIONMASK options; Test #11                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  94, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE2X with no D3DMTA_OPTIONMASK options; Test #12                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  95, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE2X with D3DMTA_COMPLEMENT; Test  #1                                             "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  96, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE2X with D3DMTA_COMPLEMENT; Test  #2                                             "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  97, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE2X with D3DMTA_COMPLEMENT; Test  #3                                             "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  98, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE2X with D3DMTA_COMPLEMENT; Test  #4                                             "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+  99, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE2X with D3DMTA_ALPHAREPLICATE; Test  #1                                         "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 100, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE2X with D3DMTA_ALPHAREPLICATE; Test  #2                                         "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 101, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE2X with D3DMTA_ALPHAREPLICATE; Test  #3                                         "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 102, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE2X with D3DMTA_ALPHAREPLICATE; Test  #4                                         "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 103, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE4X with no D3DMTA_OPTIONMASK options; Test  #1                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 104, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE4X with no D3DMTA_OPTIONMASK options; Test  #2                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 105, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE4X with no D3DMTA_OPTIONMASK options; Test  #3                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 106, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE4X with no D3DMTA_OPTIONMASK options; Test  #4                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 107, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE4X with no D3DMTA_OPTIONMASK options; Test  #5                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 108, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE4X with no D3DMTA_OPTIONMASK options; Test  #6                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 109, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE4X with no D3DMTA_OPTIONMASK options; Test  #7                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 110, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE4X with no D3DMTA_OPTIONMASK options; Test  #8                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 111, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE4X with no D3DMTA_OPTIONMASK options; Test  #9                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 112, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE4X with no D3DMTA_OPTIONMASK options; Test #10                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 113, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE4X with no D3DMTA_OPTIONMASK options; Test #11                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 114, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE4X with no D3DMTA_OPTIONMASK options; Test #12                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 115, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE4X with D3DMTA_COMPLEMENT; Test  #1                                             "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 116, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE4X with D3DMTA_COMPLEMENT; Test  #2                                             "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 117, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE4X with D3DMTA_COMPLEMENT; Test  #3                                             "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 118, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE4X with D3DMTA_COMPLEMENT; Test  #4                                             "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 119, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE4X with D3DMTA_ALPHAREPLICATE; Test  #1                                         "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 120, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE4X with D3DMTA_ALPHAREPLICATE; Test  #2                                         "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 121, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE4X with D3DMTA_ALPHAREPLICATE; Test  #3                                         "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 122, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MODULATE4X with D3DMTA_ALPHAREPLICATE; Test  #4                                         "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 123, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADD with no D3DMTA_OPTIONMASK options; Test  #1                                         "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 124, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADD with no D3DMTA_OPTIONMASK options; Test  #2                                         "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 125, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADD with no D3DMTA_OPTIONMASK options; Test  #3                                         "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 126, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADD with no D3DMTA_OPTIONMASK options; Test  #4                                         "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 127, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADD with no D3DMTA_OPTIONMASK options; Test  #5                                         "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 128, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADD with no D3DMTA_OPTIONMASK options; Test  #6                                         "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 129, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADD with no D3DMTA_OPTIONMASK options; Test  #7                                         "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 130, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADD with no D3DMTA_OPTIONMASK options; Test  #8                                         "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 131, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADD with no D3DMTA_OPTIONMASK options; Test  #9                                         "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 132, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADD with no D3DMTA_OPTIONMASK options; Test #10                                         "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 133, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADD with no D3DMTA_OPTIONMASK options; Test #11                                         "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 134, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADD with no D3DMTA_OPTIONMASK options; Test #12                                         "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 135, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADD with D3DMTA_COMPLEMENT; Test  #1                                                    "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 136, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADD with D3DMTA_COMPLEMENT; Test  #2                                                    "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 137, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADD with D3DMTA_COMPLEMENT; Test  #3                                                    "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 138, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADD with D3DMTA_COMPLEMENT; Test  #4                                                    "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 139, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADD with D3DMTA_ALPHAREPLICATE; Test  #1                                                "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 140, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADD with D3DMTA_ALPHAREPLICATE; Test  #2                                                "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 141, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADD with D3DMTA_ALPHAREPLICATE; Test  #3                                                "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 142, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADD with D3DMTA_ALPHAREPLICATE; Test  #4                                                "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 143, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSIGNED with no D3DMTA_OPTIONMASK options; Test  #1                                   "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 144, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSIGNED with no D3DMTA_OPTIONMASK options; Test  #2                                   "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 145, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSIGNED with no D3DMTA_OPTIONMASK options; Test  #3                                   "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 146, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSIGNED with no D3DMTA_OPTIONMASK options; Test  #4                                   "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 147, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSIGNED with no D3DMTA_OPTIONMASK options; Test  #5                                   "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 148, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSIGNED with no D3DMTA_OPTIONMASK options; Test  #6                                   "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 149, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSIGNED with no D3DMTA_OPTIONMASK options; Test  #7                                   "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 150, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSIGNED with no D3DMTA_OPTIONMASK options; Test  #8                                   "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 151, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSIGNED with no D3DMTA_OPTIONMASK options; Test  #9                                   "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 152, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSIGNED with no D3DMTA_OPTIONMASK options; Test #10                                   "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 153, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSIGNED with no D3DMTA_OPTIONMASK options; Test #11                                   "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 154, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSIGNED with no D3DMTA_OPTIONMASK options; Test #12                                   "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 155, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSIGNED with D3DMTA_COMPLEMENT; Test  #1                                              "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 156, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSIGNED with D3DMTA_COMPLEMENT; Test  #2                                              "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 157, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSIGNED with D3DMTA_COMPLEMENT; Test  #3                                              "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 158, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSIGNED with D3DMTA_COMPLEMENT; Test  #4                                              "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 159, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSIGNED with D3DMTA_ALPHAREPLICATE; Test  #1                                          "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 160, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSIGNED with D3DMTA_ALPHAREPLICATE; Test  #2                                          "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 161, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSIGNED with D3DMTA_ALPHAREPLICATE; Test  #3                                          "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 162, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSIGNED with D3DMTA_ALPHAREPLICATE; Test  #4                                          "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 163, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSIGNED2X with no D3DMTA_OPTIONMASK options; Test  #1                                 "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 164, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSIGNED2X with no D3DMTA_OPTIONMASK options; Test  #2                                 "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 165, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSIGNED2X with no D3DMTA_OPTIONMASK options; Test  #3                                 "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 166, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSIGNED2X with no D3DMTA_OPTIONMASK options; Test  #4                                 "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 167, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSIGNED2X with no D3DMTA_OPTIONMASK options; Test  #5                                 "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 168, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSIGNED2X with no D3DMTA_OPTIONMASK options; Test  #6                                 "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 169, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSIGNED2X with no D3DMTA_OPTIONMASK options; Test  #7                                 "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 170, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSIGNED2X with no D3DMTA_OPTIONMASK options; Test  #8                                 "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 171, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSIGNED2X with no D3DMTA_OPTIONMASK options; Test  #9                                 "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 172, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSIGNED2X with no D3DMTA_OPTIONMASK options; Test #10                                 "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 173, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSIGNED2X with no D3DMTA_OPTIONMASK options; Test #11                                 "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 174, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSIGNED2X with no D3DMTA_OPTIONMASK options; Test #12                                 "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 175, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSIGNED2X with D3DMTA_COMPLEMENT; Test  #1                                            "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 176, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSIGNED2X with D3DMTA_COMPLEMENT; Test  #2                                            "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 177, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSIGNED2X with D3DMTA_COMPLEMENT; Test  #3                                            "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 178, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSIGNED2X with D3DMTA_COMPLEMENT; Test  #4                                            "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 179, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSIGNED2X with D3DMTA_ALPHAREPLICATE; Test  #1                                        "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 180, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSIGNED2X with D3DMTA_ALPHAREPLICATE; Test  #2                                        "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 181, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSIGNED2X with D3DMTA_ALPHAREPLICATE; Test  #3                                        "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 182, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSIGNED2X with D3DMTA_ALPHAREPLICATE; Test  #4                                        "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 183, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SUBTRACT with no D3DMTA_OPTIONMASK options; Test  #1                                    "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 184, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SUBTRACT with no D3DMTA_OPTIONMASK options; Test  #2                                    "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 185, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SUBTRACT with no D3DMTA_OPTIONMASK options; Test  #3                                    "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 186, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SUBTRACT with no D3DMTA_OPTIONMASK options; Test  #4                                    "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 187, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SUBTRACT with no D3DMTA_OPTIONMASK options; Test  #5                                    "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 188, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SUBTRACT with no D3DMTA_OPTIONMASK options; Test  #6                                    "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 189, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SUBTRACT with no D3DMTA_OPTIONMASK options; Test  #7                                    "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 190, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SUBTRACT with no D3DMTA_OPTIONMASK options; Test  #8                                    "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 191, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SUBTRACT with no D3DMTA_OPTIONMASK options; Test  #9                                    "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 192, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SUBTRACT with no D3DMTA_OPTIONMASK options; Test #10                                    "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 193, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SUBTRACT with no D3DMTA_OPTIONMASK options; Test #11                                    "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 194, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SUBTRACT with no D3DMTA_OPTIONMASK options; Test #12                                    "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 195, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SUBTRACT with D3DMTA_COMPLEMENT; Test  #1                                               "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 196, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SUBTRACT with D3DMTA_COMPLEMENT; Test  #2                                               "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 197, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SUBTRACT with D3DMTA_COMPLEMENT; Test  #3                                               "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 198, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SUBTRACT with D3DMTA_COMPLEMENT; Test  #4                                               "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 199, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SUBTRACT with D3DMTA_ALPHAREPLICATE; Test  #1                                           "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 200, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SUBTRACT with D3DMTA_ALPHAREPLICATE; Test  #2                                           "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 201, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SUBTRACT with D3DMTA_ALPHAREPLICATE; Test  #3                                           "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 202, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_SUBTRACT with D3DMTA_ALPHAREPLICATE; Test  #4                                           "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 203, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSMOOTH with no D3DMTA_OPTIONMASK options; Test  #1                                   "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 204, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSMOOTH with no D3DMTA_OPTIONMASK options; Test  #2                                   "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 205, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSMOOTH with no D3DMTA_OPTIONMASK options; Test  #3                                   "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 206, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSMOOTH with no D3DMTA_OPTIONMASK options; Test  #4                                   "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 207, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSMOOTH with no D3DMTA_OPTIONMASK options; Test  #5                                   "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 208, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSMOOTH with no D3DMTA_OPTIONMASK options; Test  #6                                   "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 209, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSMOOTH with no D3DMTA_OPTIONMASK options; Test  #7                                   "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 210, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSMOOTH with no D3DMTA_OPTIONMASK options; Test  #8                                   "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 211, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSMOOTH with no D3DMTA_OPTIONMASK options; Test  #9                                   "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 212, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSMOOTH with no D3DMTA_OPTIONMASK options; Test #10                                   "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 213, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSMOOTH with no D3DMTA_OPTIONMASK options; Test #11                                   "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 214, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSMOOTH with no D3DMTA_OPTIONMASK options; Test #12                                   "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 215, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSMOOTH with D3DMTA_COMPLEMENT; Test  #1                                              "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 216, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSMOOTH with D3DMTA_COMPLEMENT; Test  #2                                              "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 217, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSMOOTH with D3DMTA_COMPLEMENT; Test  #3                                              "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 218, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSMOOTH with D3DMTA_COMPLEMENT; Test  #4                                              "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 219, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSMOOTH with D3DMTA_ALPHAREPLICATE; Test  #1                                          "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 220, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSMOOTH with D3DMTA_ALPHAREPLICATE; Test  #2                                          "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 221, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSMOOTH with D3DMTA_ALPHAREPLICATE; Test  #3                                          "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 222, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_ADDSMOOTH with D3DMTA_ALPHAREPLICATE; Test  #4                                          "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 223, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_BLENDDIFFUSEALPHA with no D3DMTA_OPTIONMASK options; Test  #1                           "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 224, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_BLENDDIFFUSEALPHA with no D3DMTA_OPTIONMASK options; Test  #2                           "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 225, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_BLENDDIFFUSEALPHA with no D3DMTA_OPTIONMASK options; Test  #3                           "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 226, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_BLENDDIFFUSEALPHA with no D3DMTA_OPTIONMASK options; Test  #4                           "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 227, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_BLENDDIFFUSEALPHA with no D3DMTA_OPTIONMASK options; Test  #5                           "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 228, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_BLENDDIFFUSEALPHA with no D3DMTA_OPTIONMASK options; Test  #6                           "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 229, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_BLENDDIFFUSEALPHA with D3DMTA_COMPLEMENT; Test  #1                                      "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 230, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_BLENDDIFFUSEALPHA with D3DMTA_COMPLEMENT; Test  #2                                      "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 231, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_BLENDDIFFUSEALPHA with D3DMTA_COMPLEMENT; Test  #3                                      "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 232, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_BLENDDIFFUSEALPHA with D3DMTA_ALPHAREPLICATE; Test  #1                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 233, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_BLENDDIFFUSEALPHA with D3DMTA_ALPHAREPLICATE; Test  #2                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 234, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_BLENDDIFFUSEALPHA with D3DMTA_ALPHAREPLICATE; Test  #3                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 235, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_BLENDTEXTUREALPHA with no D3DMTA_OPTIONMASK options; Test  #1                           "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 236, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_BLENDTEXTUREALPHA with no D3DMTA_OPTIONMASK options; Test  #2                           "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 237, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_BLENDTEXTUREALPHA with no D3DMTA_OPTIONMASK options; Test  #3                           "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 238, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_BLENDTEXTUREALPHA with no D3DMTA_OPTIONMASK options; Test  #4                           "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 239, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_BLENDTEXTUREALPHA with no D3DMTA_OPTIONMASK options; Test  #5                           "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 240, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_BLENDTEXTUREALPHA with no D3DMTA_OPTIONMASK options; Test  #6                           "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 241, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_BLENDTEXTUREALPHA with D3DMTA_COMPLEMENT; Test  #1                                      "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 242, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_BLENDTEXTUREALPHA with D3DMTA_COMPLEMENT; Test  #2                                      "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 243, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_BLENDTEXTUREALPHA with D3DMTA_COMPLEMENT; Test  #3                                      "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 244, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_BLENDTEXTUREALPHA with D3DMTA_ALPHAREPLICATE; Test  #1                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 245, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_BLENDTEXTUREALPHA with D3DMTA_ALPHAREPLICATE; Test  #2                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 246, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_BLENDTEXTUREALPHA with D3DMTA_ALPHAREPLICATE; Test  #3                                  "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 247, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_BLENDFACTORALPHA with no D3DMTA_OPTIONMASK options; Test  #1                            "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 248, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_BLENDFACTORALPHA with no D3DMTA_OPTIONMASK options; Test  #2                            "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 249, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_BLENDFACTORALPHA with no D3DMTA_OPTIONMASK options; Test  #3                            "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 250, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_BLENDFACTORALPHA with no D3DMTA_OPTIONMASK options; Test  #4                            "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 251, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_BLENDFACTORALPHA with no D3DMTA_OPTIONMASK options; Test  #5                            "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 252, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_BLENDFACTORALPHA with no D3DMTA_OPTIONMASK options; Test  #6                            "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 253, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_BLENDFACTORALPHA with D3DMTA_COMPLEMENT; Test  #1                                       "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 254, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_BLENDFACTORALPHA with D3DMTA_COMPLEMENT; Test  #2                                       "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 255, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_BLENDFACTORALPHA with D3DMTA_COMPLEMENT; Test  #3                                       "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 256, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_BLENDFACTORALPHA with D3DMTA_ALPHAREPLICATE; Test  #1                                   "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 257, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_BLENDFACTORALPHA with D3DMTA_ALPHAREPLICATE; Test  #2                                   "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 258, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_BLENDFACTORALPHA with D3DMTA_ALPHAREPLICATE; Test  #3                                   "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 259, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_BLENDTEXTUREALPHAPM with no D3DMTA_OPTIONMASK options; Test  #1                         "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 260, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_BLENDTEXTUREALPHAPM with no D3DMTA_OPTIONMASK options; Test  #2                         "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 261, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_BLENDTEXTUREALPHAPM with no D3DMTA_OPTIONMASK options; Test  #3                         "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 262, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_BLENDTEXTUREALPHAPM with no D3DMTA_OPTIONMASK options; Test  #4                         "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 263, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_BLENDTEXTUREALPHAPM with no D3DMTA_OPTIONMASK options; Test  #5                         "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 264, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_BLENDTEXTUREALPHAPM with no D3DMTA_OPTIONMASK options; Test  #6                         "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 265, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_BLENDTEXTUREALPHAPM with D3DMTA_COMPLEMENT; Test  #1                                    "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 266, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_BLENDTEXTUREALPHAPM with D3DMTA_COMPLEMENT; Test  #2                                    "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 267, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_BLENDTEXTUREALPHAPM with D3DMTA_COMPLEMENT; Test  #3                                    "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 268, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_BLENDTEXTUREALPHAPM with D3DMTA_ALPHAREPLICATE; Test  #1                                "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 269, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_BLENDTEXTUREALPHAPM with D3DMTA_ALPHAREPLICATE; Test  #2                                "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 270, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_BLENDTEXTUREALPHAPM with D3DMTA_ALPHAREPLICATE; Test  #3                                "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 271, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MULTIPLYADD with no D3DMTA_OPTIONMASK options; Test  #1                                 "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 272, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MULTIPLYADD with no D3DMTA_OPTIONMASK options; Test  #2                                 "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 273, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MULTIPLYADD with no D3DMTA_OPTIONMASK options; Test  #3                                 "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 274, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MULTIPLYADD with no D3DMTA_OPTIONMASK options; Test  #4                                 "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 275, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MULTIPLYADD with no D3DMTA_OPTIONMASK options; Test  #5                                 "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 276, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MULTIPLYADD with no D3DMTA_OPTIONMASK options; Test  #6                                 "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 277, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MULTIPLYADD with no D3DMTA_OPTIONMASK options; Test  #7                                 "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 278, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MULTIPLYADD with no D3DMTA_OPTIONMASK options; Test  #8                                 "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 279, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MULTIPLYADD with no D3DMTA_OPTIONMASK options; Test  #9                                 "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 280, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MULTIPLYADD with no D3DMTA_OPTIONMASK options; Test #10                                 "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 281, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MULTIPLYADD with no D3DMTA_OPTIONMASK options; Test #11                                 "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 282, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MULTIPLYADD with no D3DMTA_OPTIONMASK options; Test #12                                 "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 283, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MULTIPLYADD with no D3DMTA_OPTIONMASK options; Test #13                                 "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 284, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MULTIPLYADD with no D3DMTA_OPTIONMASK options; Test #14                                 "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 285, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MULTIPLYADD with no D3DMTA_OPTIONMASK options; Test #15                                 "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 286, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MULTIPLYADD with no D3DMTA_OPTIONMASK options; Test #16                                 "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 287, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MULTIPLYADD with no D3DMTA_OPTIONMASK options; Test #17                                 "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 288, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MULTIPLYADD with no D3DMTA_OPTIONMASK options; Test #18                                 "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 289, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MULTIPLYADD with no D3DMTA_OPTIONMASK options; Test #19                                 "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 290, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MULTIPLYADD with no D3DMTA_OPTIONMASK options; Test #20                                 "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 291, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MULTIPLYADD with no D3DMTA_OPTIONMASK options; Test #21                                 "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 292, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MULTIPLYADD with no D3DMTA_OPTIONMASK options; Test #22                                 "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 293, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MULTIPLYADD with no D3DMTA_OPTIONMASK options; Test #23                                 "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 294, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MULTIPLYADD with no D3DMTA_OPTIONMASK options; Test #24                                 "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 295, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MULTIPLYADD with D3DMTA_COMPLEMENT; Test  #1                                            "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 296, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MULTIPLYADD with D3DMTA_COMPLEMENT; Test  #2                                            "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 297, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MULTIPLYADD with D3DMTA_COMPLEMENT; Test  #3                                            "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 298, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MULTIPLYADD with D3DMTA_COMPLEMENT; Test  #4                                            "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 299, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MULTIPLYADD with D3DMTA_COMPLEMENT; Test  #5                                            "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 300, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MULTIPLYADD with D3DMTA_COMPLEMENT; Test  #6                                            "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 301, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MULTIPLYADD with D3DMTA_COMPLEMENT; Test  #7                                            "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 302, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MULTIPLYADD with D3DMTA_COMPLEMENT; Test  #8                                            "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 303, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MULTIPLYADD with D3DMTA_COMPLEMENT; Test  #9                                            "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 304, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MULTIPLYADD with D3DMTA_COMPLEMENT; Test #10                                            "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 305, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MULTIPLYADD with D3DMTA_COMPLEMENT; Test #11                                            "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 306, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MULTIPLYADD with D3DMTA_COMPLEMENT; Test #12                                            "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 307, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MULTIPLYADD with D3DMTA_ALPHAREPLICATE; Test  #1                                        "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 308, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MULTIPLYADD with D3DMTA_ALPHAREPLICATE; Test  #2                                        "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 309, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MULTIPLYADD with D3DMTA_ALPHAREPLICATE; Test  #3                                        "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 310, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MULTIPLYADD with D3DMTA_ALPHAREPLICATE; Test  #4                                        "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 311, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MULTIPLYADD with D3DMTA_ALPHAREPLICATE; Test  #5                                        "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 312, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MULTIPLYADD with D3DMTA_ALPHAREPLICATE; Test  #6                                        "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 313, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MULTIPLYADD with D3DMTA_ALPHAREPLICATE; Test  #7                                        "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 314, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MULTIPLYADD with D3DMTA_ALPHAREPLICATE; Test  #8                                        "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 315, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MULTIPLYADD with D3DMTA_ALPHAREPLICATE; Test  #9                                        "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 316, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MULTIPLYADD with D3DMTA_ALPHAREPLICATE; Test #10                                        "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 317, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MULTIPLYADD with D3DMTA_ALPHAREPLICATE; Test #11                                        "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 318, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_MULTIPLYADD with D3DMTA_ALPHAREPLICATE; Test #12                                        "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 319, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_LERP with no D3DMTA_OPTIONMASK options; Test  #1                                        "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 320, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_LERP with no D3DMTA_OPTIONMASK options; Test  #2                                        "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 321, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_LERP with no D3DMTA_OPTIONMASK options; Test  #3                                        "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 322, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_LERP with no D3DMTA_OPTIONMASK options; Test  #4                                        "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 323, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_LERP with no D3DMTA_OPTIONMASK options; Test  #5                                        "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 324, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_LERP with no D3DMTA_OPTIONMASK options; Test  #6                                        "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 325, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_LERP with no D3DMTA_OPTIONMASK options; Test  #7                                        "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 326, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_LERP with no D3DMTA_OPTIONMASK options; Test  #8                                        "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 327, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_LERP with no D3DMTA_OPTIONMASK options; Test  #9                                        "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 328, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_LERP with no D3DMTA_OPTIONMASK options; Test #10                                        "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 329, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_LERP with no D3DMTA_OPTIONMASK options; Test #11                                        "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 330, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_LERP with no D3DMTA_OPTIONMASK options; Test #12                                        "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 331, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_LERP with no D3DMTA_OPTIONMASK options; Test #13                                        "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 332, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_LERP with no D3DMTA_OPTIONMASK options; Test #14                                        "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 333, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_LERP with no D3DMTA_OPTIONMASK options; Test #15                                        "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 334, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_LERP with no D3DMTA_OPTIONMASK options; Test #16                                        "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 335, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_LERP with no D3DMTA_OPTIONMASK options; Test #17                                        "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 336, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_LERP with no D3DMTA_OPTIONMASK options; Test #18                                        "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 337, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_LERP with no D3DMTA_OPTIONMASK options; Test #19                                        "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 338, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_LERP with no D3DMTA_OPTIONMASK options; Test #20                                        "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 339, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_LERP with no D3DMTA_OPTIONMASK options; Test #21                                        "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 340, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_LERP with no D3DMTA_OPTIONMASK options; Test #22                                        "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 341, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_LERP with no D3DMTA_OPTIONMASK options; Test #23                                        "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 342, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_LERP with no D3DMTA_OPTIONMASK options; Test #24                                        "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 343, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_LERP with D3DMTA_COMPLEMENT; Test  #1                                                   "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 344, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_LERP with D3DMTA_COMPLEMENT; Test  #2                                                   "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 345, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_LERP with D3DMTA_COMPLEMENT; Test  #3                                                   "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 346, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_LERP with D3DMTA_COMPLEMENT; Test  #4                                                   "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 347, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_LERP with D3DMTA_COMPLEMENT; Test  #5                                                   "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 348, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_LERP with D3DMTA_COMPLEMENT; Test  #6                                                   "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 349, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_LERP with D3DMTA_COMPLEMENT; Test  #7                                                   "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 350, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_LERP with D3DMTA_COMPLEMENT; Test  #8                                                   "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 351, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_LERP with D3DMTA_COMPLEMENT; Test  #9                                                   "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 352, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_LERP with D3DMTA_COMPLEMENT; Test #10                                                   "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 353, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_LERP with D3DMTA_COMPLEMENT; Test #11                                                   "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 354, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_LERP with D3DMTA_COMPLEMENT; Test #12                                                   "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 355, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_LERP with D3DMTA_ALPHAREPLICATE; Test  #1                                               "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 356, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_LERP with D3DMTA_ALPHAREPLICATE; Test  #2                                               "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 357, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_LERP with D3DMTA_ALPHAREPLICATE; Test  #3                                               "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 358, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_LERP with D3DMTA_ALPHAREPLICATE; Test  #4                                               "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 359, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_LERP with D3DMTA_ALPHAREPLICATE; Test  #5                                               "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 360, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_LERP with D3DMTA_ALPHAREPLICATE; Test  #6                                               "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 361, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_LERP with D3DMTA_ALPHAREPLICATE; Test  #7                                               "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 362, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_LERP with D3DMTA_ALPHAREPLICATE; Test  #8                                               "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 363, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_LERP with D3DMTA_ALPHAREPLICATE; Test  #9                                               "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 364, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_LERP with D3DMTA_ALPHAREPLICATE; Test #10                                               "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 365, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_LERP with D3DMTA_ALPHAREPLICATE; Test #11                                               "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 366, TuxTest},
{ TEXT("(TexStageTest) D3DMTOP_LERP with D3DMTA_ALPHAREPLICATE; Test #12                                               "),         1,         0,   D3DMQA_TEXSTAGETEST_BASE+ 367, TuxTest},

{ NULL,                                                                                                                     0,         0,                                    0,      NULL }
};

//  Processes messages from the TUX shell.
SHELLPROCAPI    ShellProc(UINT, SPPARAM);

// Shell info structure (contains instance handle, window handle, DLL handle, command line args, etc.)
SPS_SHELL_INFO   *g_pShellInfo;



