//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// This source code is licensed under Microsoft Shared Source License
// Version 1.0 for Windows CE.
// For a copy of the license visit http://go.microsoft.com/fwlink/?LinkId=3223.
//
#pragma once

#include <tux.h>
#include "VerifTestCases.h"

//
// Test IDs for IDirect3DMobileDevice::ProcessVertices
//

//
// Functionality tests
//
#define D3DMQA_PROCVERTSTEST_BASE            1
#define D3DMQA_PROCVERTSTEST_MAX           104

#define D3DQAID_PV_MULTTEST                  1
#define D3DQAID_PV_ADDTEST                   2
#define D3DQAID_PV_TEXTRANS                  3
#define D3DQAID_PV_PERSPROJ                  4
#define D3DQAID_PV_ORTHPROJ                  5
#define D3DQAID_PV_VIEWPORT                  6
#define D3DQAID_PV_DIFFUSE_MATERIAL_SOURCE   7
#define D3DQAID_PV_SPECULAR_MATERIAL_SOURCE  8
#define D3DQAID_PV_SPECULAR_POWER            9
#define D3DQAID_PV_HALFWAYVEC               10
#define D3DQAID_PV_NONLOCALVIEWER           11
#define D3DQAID_PV_GLOBALAMBIENT            12
#define D3DQAID_PV_LOCALAMBIENT             13

//
// Misc ProcessVertices tests
//
#define D3DQAID_PV_NOSTREAMSOURCE               101
#define D3DQAID_PV_STREAMSOURCE                 102
#define D3DQAID_PV_DONOTCOPYDATA                103
#define D3DQAID_PV_NOTENOUGHVERTS               104

//
// Other test ids are derived from \d3d\mobile\includes header files
//

TESTPROCAPI TuxTest(UINT uTuxMsg, TPPARAM tpParam, LPFUNCTION_TABLE_ENTRY lpFTE);

//
// Tux Function Table Entry for driver verification tests
//
FUNCTION_TABLE_ENTRY g_lpFTE[] = {


//|                                              Description                                                             | Tree  | TestProc |             Unique ID for            |          |
//|                                              of Test Case                                                            | Depth |   Arg    |               test case              | TestProc |
//+----------------------------------------------------------------------------------------------------------------------+-------+----------+--------------------------------------+----------+
{ TEXT("Driver Verification Tests                             "),                                                                  0,         0,   0                                      , NULL     },
{ TEXT("(ProcessVerticesTest) World/View Matrix Mult Test     "),                                                                  1,         0,   D3DQAID_PV_MULTTEST                    , TuxTest  },
{ TEXT("(ProcessVerticesTest) World/View Translation Test     "),                                                                  1,         0,   D3DQAID_PV_ADDTEST                     , TuxTest  },
{ TEXT("(ProcessVerticesTest) Texture Coordinate Rotation Test"),                                                                  1,         0,   D3DQAID_PV_TEXTRANS                    , TuxTest  },
{ TEXT("(ProcessVerticesTest) Perspective Projection Test     "),                                                                  1,         0,   D3DQAID_PV_PERSPROJ                    , TuxTest  },
{ TEXT("(ProcessVerticesTest) Orthographic Projection Test    "),                                                                  1,         0,   D3DQAID_PV_ORTHPROJ                    , TuxTest  },
{ TEXT("(ProcessVerticesTest) Viewport Test                   "),                                                                  1,         0,   D3DQAID_PV_VIEWPORT                    , TuxTest  },
{ TEXT("(ProcessVerticesTest) Diffuse Material Source Test    "),                                                                  1,         0,   D3DQAID_PV_DIFFUSE_MATERIAL_SOURCE     , TuxTest  },
{ TEXT("(ProcessVerticesTest) Specular Material Source Test   "),                                                                  1,         0,   D3DQAID_PV_SPECULAR_MATERIAL_SOURCE    , TuxTest  },
{ TEXT("(ProcessVerticesTest) Specular Power Test             "),                                                                  1,         0,   D3DQAID_PV_SPECULAR_POWER              , TuxTest  },
{ TEXT("(ProcessVerticesTest) Halfway Vector Test             "),                                                                  1,         0,   D3DQAID_PV_HALFWAYVEC                  , TuxTest  },
{ TEXT("(ProcessVerticesTest) Non-Local Viewer Test           "),                                                                  1,         0,   D3DQAID_PV_NONLOCALVIEWER              , TuxTest  },
{ TEXT("(ProcessVerticesTest) Global Ambient Lighting Test    "),                                                                  1,         0,   D3DQAID_PV_GLOBALAMBIENT               , TuxTest  },
{ TEXT("(ProcessVerticesTest) Local Ambient Lighting Test     "),                                                                  1,         0,   D3DQAID_PV_LOCALAMBIENT                , TuxTest  },
{ TEXT("(ProcessVerticesTest) No Stream Source Test           "),                                                                  1,         0,   D3DQAID_PV_NOSTREAMSOURCE              , TuxTest  },
{ TEXT("(ProcessVerticesTest) Valid Stream Source Test        "),                                                                  1,         0,   D3DQAID_PV_STREAMSOURCE                , TuxTest  },
{ TEXT("(ProcessVerticesTest) D3DMPV_DONOTCOPYDATA Buffer Test"),                                                                  1,         0,   D3DQAID_PV_DONOTCOPYDATA               , TuxTest  },
{ TEXT("(ProcessVerticesTest) Insufficient Vertices Test      "),                                                                  1,         0,   D3DQAID_PV_NOTENOUGHVERTS              , TuxTest  },

{ TEXT("(BlendTest) Source: D3DBLEND_ZERO        ; Dest: D3DBLEND_ZERO            , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+  0 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ZERO        ; Dest: D3DBLEND_ONE             , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+  1 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ZERO        ; Dest: D3DBLEND_SRCCOLOR        , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+  2 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ZERO        ; Dest: D3DBLEND_INVSRCCOLOR     , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+  3 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ZERO        ; Dest: D3DBLEND_SRCALPHA        , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+  4 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ZERO        ; Dest: D3DBLEND_INVSRCALPHA     , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+  5 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ZERO        ; Dest: D3DBLEND_DESTALPHA       , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+  6 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ZERO        ; Dest: D3DBLEND_INVDESTALPHA    , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+  7 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ZERO        ; Dest: D3DBLEND_DESTCOLOR       , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+  8 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ZERO        ; Dest: D3DBLEND_INVDESTCOLOR    , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+  9 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ZERO        ; Dest: D3DBLEND_SRCALPHASAT     , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 10 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ONE         ; Dest: D3DBLEND_ZERO            , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 11 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ONE         ; Dest: D3DBLEND_ONE             , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 12 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ONE         ; Dest: D3DBLEND_SRCCOLOR        , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 13 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ONE         ; Dest: D3DBLEND_INVSRCCOLOR     , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 14 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ONE         ; Dest: D3DBLEND_SRCALPHA        , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 15 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ONE         ; Dest: D3DBLEND_INVSRCALPHA     , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 16 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ONE         ; Dest: D3DBLEND_DESTALPHA       , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 17 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ONE         ; Dest: D3DBLEND_INVDESTALPHA    , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 18 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ONE         ; Dest: D3DBLEND_DESTCOLOR       , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 19 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ONE         ; Dest: D3DBLEND_INVDESTCOLOR    , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 20 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ONE         ; Dest: D3DBLEND_SRCALPHASAT     , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 21 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCCOLOR    ; Dest: D3DBLEND_ZERO            , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 22 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCCOLOR    ; Dest: D3DBLEND_ONE             , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 23 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCCOLOR    ; Dest: D3DBLEND_SRCCOLOR        , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 24 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCCOLOR    ; Dest: D3DBLEND_INVSRCCOLOR     , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 25 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCCOLOR    ; Dest: D3DBLEND_SRCALPHA        , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 26 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCCOLOR    ; Dest: D3DBLEND_INVSRCALPHA     , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 27 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCCOLOR    ; Dest: D3DBLEND_DESTALPHA       , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 28 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCCOLOR    ; Dest: D3DBLEND_INVDESTALPHA    , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 29 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCCOLOR    ; Dest: D3DBLEND_DESTCOLOR       , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 30 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCCOLOR    ; Dest: D3DBLEND_INVDESTCOLOR    , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 31 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCCOLOR    ; Dest: D3DBLEND_SRCALPHASAT     , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 32 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCCOLOR ; Dest: D3DBLEND_ZERO            , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 33 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCCOLOR ; Dest: D3DBLEND_ONE             , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 34 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCCOLOR ; Dest: D3DBLEND_SRCCOLOR        , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 35 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCCOLOR ; Dest: D3DBLEND_INVSRCCOLOR     , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 36 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCCOLOR ; Dest: D3DBLEND_SRCALPHA        , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 37 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCCOLOR ; Dest: D3DBLEND_INVSRCALPHA     , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 38 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCCOLOR ; Dest: D3DBLEND_DESTALPHA       , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 39 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCCOLOR ; Dest: D3DBLEND_INVDESTALPHA    , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 40 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCCOLOR ; Dest: D3DBLEND_DESTCOLOR       , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 41 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCCOLOR ; Dest: D3DBLEND_INVDESTCOLOR    , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 42 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCCOLOR ; Dest: D3DBLEND_SRCALPHASAT     , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 43 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHA    ; Dest: D3DBLEND_ZERO            , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 44 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHA    ; Dest: D3DBLEND_ONE             , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 45 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHA    ; Dest: D3DBLEND_SRCCOLOR        , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 46 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHA    ; Dest: D3DBLEND_INVSRCCOLOR     , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 47 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHA    ; Dest: D3DBLEND_SRCALPHA        , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 48 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHA    ; Dest: D3DBLEND_INVSRCALPHA     , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 49 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHA    ; Dest: D3DBLEND_DESTALPHA       , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 50 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHA    ; Dest: D3DBLEND_INVDESTALPHA    , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 51 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHA    ; Dest: D3DBLEND_DESTCOLOR       , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 52 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHA    ; Dest: D3DBLEND_INVDESTCOLOR    , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 53 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHA    ; Dest: D3DBLEND_SRCALPHASAT     , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 54 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCALPHA ; Dest: D3DBLEND_ZERO            , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 55 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCALPHA ; Dest: D3DBLEND_ONE             , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 56 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCALPHA ; Dest: D3DBLEND_SRCCOLOR        , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 57 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCALPHA ; Dest: D3DBLEND_INVSRCCOLOR     , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 58 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCALPHA ; Dest: D3DBLEND_SRCALPHA        , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 59 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCALPHA ; Dest: D3DBLEND_INVSRCALPHA     , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 60 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCALPHA ; Dest: D3DBLEND_DESTALPHA       , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 61 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCALPHA ; Dest: D3DBLEND_INVDESTALPHA    , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 62 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCALPHA ; Dest: D3DBLEND_DESTCOLOR       , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 63 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCALPHA ; Dest: D3DBLEND_INVDESTCOLOR    , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 64 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCALPHA ; Dest: D3DBLEND_SRCALPHASAT     , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 65 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTALPHA   ; Dest: D3DBLEND_ZERO            , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 66 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTALPHA   ; Dest: D3DBLEND_ONE             , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 67 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTALPHA   ; Dest: D3DBLEND_SRCCOLOR        , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 68 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTALPHA   ; Dest: D3DBLEND_INVSRCCOLOR     , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 69 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTALPHA   ; Dest: D3DBLEND_SRCALPHA        , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 70 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTALPHA   ; Dest: D3DBLEND_INVSRCALPHA     , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 71 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTALPHA   ; Dest: D3DBLEND_DESTALPHA       , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 72 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTALPHA   ; Dest: D3DBLEND_INVDESTALPHA    , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 73 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTALPHA   ; Dest: D3DBLEND_DESTCOLOR       , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 74 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTALPHA   ; Dest: D3DBLEND_INVDESTCOLOR    , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 75 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTALPHA   ; Dest: D3DBLEND_SRCALPHASAT     , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 76 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTALPHA; Dest: D3DBLEND_ZERO            , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 77 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTALPHA; Dest: D3DBLEND_ONE             , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 78 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTALPHA; Dest: D3DBLEND_SRCCOLOR        , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 79 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTALPHA; Dest: D3DBLEND_INVSRCCOLOR     , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 80 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTALPHA; Dest: D3DBLEND_SRCALPHA        , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 81 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTALPHA; Dest: D3DBLEND_INVSRCALPHA     , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 82 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTALPHA; Dest: D3DBLEND_DESTALPHA       , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 83 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTALPHA; Dest: D3DBLEND_INVDESTALPHA    , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 84 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTALPHA; Dest: D3DBLEND_DESTCOLOR       , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 85 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTALPHA; Dest: D3DBLEND_INVDESTCOLOR    , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 86 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTALPHA; Dest: D3DBLEND_SRCALPHASAT     , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 87 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTCOLOR   ; Dest: D3DBLEND_ZERO            , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 88 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTCOLOR   ; Dest: D3DBLEND_ONE             , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 89 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTCOLOR   ; Dest: D3DBLEND_SRCCOLOR        , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 90 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTCOLOR   ; Dest: D3DBLEND_INVSRCCOLOR     , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 91 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTCOLOR   ; Dest: D3DBLEND_SRCALPHA        , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 92 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTCOLOR   ; Dest: D3DBLEND_INVSRCALPHA     , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 93 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTCOLOR   ; Dest: D3DBLEND_DESTALPHA       , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 94 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTCOLOR   ; Dest: D3DBLEND_INVDESTALPHA    , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 95 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTCOLOR   ; Dest: D3DBLEND_DESTCOLOR       , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 96 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTCOLOR   ; Dest: D3DBLEND_INVDESTCOLOR    , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 97 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTCOLOR   ; Dest: D3DBLEND_SRCALPHASAT     , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 98 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTCOLOR; Dest: D3DBLEND_ZERO            , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+ 99 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTCOLOR; Dest: D3DBLEND_ONE             , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+100 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTCOLOR; Dest: D3DBLEND_SRCCOLOR        , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+101 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTCOLOR; Dest: D3DBLEND_INVSRCCOLOR     , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+102 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTCOLOR; Dest: D3DBLEND_SRCALPHA        , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+103 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTCOLOR; Dest: D3DBLEND_INVSRCALPHA     , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+104 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTCOLOR; Dest: D3DBLEND_DESTALPHA       , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+105 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTCOLOR; Dest: D3DBLEND_INVDESTALPHA    , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+106 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTCOLOR; Dest: D3DBLEND_DESTCOLOR       , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+107 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTCOLOR; Dest: D3DBLEND_INVDESTCOLOR    , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+108 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTCOLOR; Dest: D3DBLEND_SRCALPHASAT     , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+109 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHASAT ; Dest: D3DBLEND_ZERO            , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+110 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHASAT ; Dest: D3DBLEND_ONE             , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+111 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHASAT ; Dest: D3DBLEND_SRCCOLOR        , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+112 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHASAT ; Dest: D3DBLEND_INVSRCCOLOR     , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+113 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHASAT ; Dest: D3DBLEND_SRCALPHA        , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+114 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHASAT ; Dest: D3DBLEND_INVSRCALPHA     , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+115 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHASAT ; Dest: D3DBLEND_DESTALPHA       , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+116 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHASAT ; Dest: D3DBLEND_INVDESTALPHA    , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+117 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHASAT ; Dest: D3DBLEND_DESTCOLOR       , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+118 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHASAT ; Dest: D3DBLEND_INVDESTCOLOR    , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+119 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHASAT ; Dest: D3DBLEND_SRCALPHASAT     , D3DBLENDOP_ADD                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+120 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ZERO        ; Dest: D3DBLEND_ZERO            , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+121 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ZERO        ; Dest: D3DBLEND_ONE             , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+122 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ZERO        ; Dest: D3DBLEND_SRCCOLOR        , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+123 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ZERO        ; Dest: D3DBLEND_INVSRCCOLOR     , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+124 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ZERO        ; Dest: D3DBLEND_SRCALPHA        , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+125 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ZERO        ; Dest: D3DBLEND_INVSRCALPHA     , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+126 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ZERO        ; Dest: D3DBLEND_DESTALPHA       , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+127 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ZERO        ; Dest: D3DBLEND_INVDESTALPHA    , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+128 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ZERO        ; Dest: D3DBLEND_DESTCOLOR       , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+129 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ZERO        ; Dest: D3DBLEND_INVDESTCOLOR    , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+130 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ZERO        ; Dest: D3DBLEND_SRCALPHASAT     , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+131 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ONE         ; Dest: D3DBLEND_ZERO            , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+132 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ONE         ; Dest: D3DBLEND_ONE             , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+133 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ONE         ; Dest: D3DBLEND_SRCCOLOR        , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+134 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ONE         ; Dest: D3DBLEND_INVSRCCOLOR     , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+135 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ONE         ; Dest: D3DBLEND_SRCALPHA        , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+136 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ONE         ; Dest: D3DBLEND_INVSRCALPHA     , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+137 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ONE         ; Dest: D3DBLEND_DESTALPHA       , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+138 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ONE         ; Dest: D3DBLEND_INVDESTALPHA    , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+139 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ONE         ; Dest: D3DBLEND_DESTCOLOR       , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+140 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ONE         ; Dest: D3DBLEND_INVDESTCOLOR    , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+141 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ONE         ; Dest: D3DBLEND_SRCALPHASAT     , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+142 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCCOLOR    ; Dest: D3DBLEND_ZERO            , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+143 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCCOLOR    ; Dest: D3DBLEND_ONE             , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+144 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCCOLOR    ; Dest: D3DBLEND_SRCCOLOR        , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+145 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCCOLOR    ; Dest: D3DBLEND_INVSRCCOLOR     , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+146 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCCOLOR    ; Dest: D3DBLEND_SRCALPHA        , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+147 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCCOLOR    ; Dest: D3DBLEND_INVSRCALPHA     , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+148 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCCOLOR    ; Dest: D3DBLEND_DESTALPHA       , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+149 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCCOLOR    ; Dest: D3DBLEND_INVDESTALPHA    , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+150 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCCOLOR    ; Dest: D3DBLEND_DESTCOLOR       , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+151 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCCOLOR    ; Dest: D3DBLEND_INVDESTCOLOR    , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+152 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCCOLOR    ; Dest: D3DBLEND_SRCALPHASAT     , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+153 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCCOLOR ; Dest: D3DBLEND_ZERO            , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+154 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCCOLOR ; Dest: D3DBLEND_ONE             , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+155 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCCOLOR ; Dest: D3DBLEND_SRCCOLOR        , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+156 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCCOLOR ; Dest: D3DBLEND_INVSRCCOLOR     , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+157 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCCOLOR ; Dest: D3DBLEND_SRCALPHA        , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+158 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCCOLOR ; Dest: D3DBLEND_INVSRCALPHA     , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+159 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCCOLOR ; Dest: D3DBLEND_DESTALPHA       , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+160 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCCOLOR ; Dest: D3DBLEND_INVDESTALPHA    , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+161 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCCOLOR ; Dest: D3DBLEND_DESTCOLOR       , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+162 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCCOLOR ; Dest: D3DBLEND_INVDESTCOLOR    , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+163 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCCOLOR ; Dest: D3DBLEND_SRCALPHASAT     , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+164 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHA    ; Dest: D3DBLEND_ZERO            , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+165 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHA    ; Dest: D3DBLEND_ONE             , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+166 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHA    ; Dest: D3DBLEND_SRCCOLOR        , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+167 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHA    ; Dest: D3DBLEND_INVSRCCOLOR     , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+168 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHA    ; Dest: D3DBLEND_SRCALPHA        , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+169 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHA    ; Dest: D3DBLEND_INVSRCALPHA     , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+170 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHA    ; Dest: D3DBLEND_DESTALPHA       , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+171 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHA    ; Dest: D3DBLEND_INVDESTALPHA    , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+172 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHA    ; Dest: D3DBLEND_DESTCOLOR       , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+173 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHA    ; Dest: D3DBLEND_INVDESTCOLOR    , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+174 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHA    ; Dest: D3DBLEND_SRCALPHASAT     , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+175 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCALPHA ; Dest: D3DBLEND_ZERO            , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+176 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCALPHA ; Dest: D3DBLEND_ONE             , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+177 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCALPHA ; Dest: D3DBLEND_SRCCOLOR        , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+178 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCALPHA ; Dest: D3DBLEND_INVSRCCOLOR     , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+179 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCALPHA ; Dest: D3DBLEND_SRCALPHA        , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+180 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCALPHA ; Dest: D3DBLEND_INVSRCALPHA     , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+181 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCALPHA ; Dest: D3DBLEND_DESTALPHA       , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+182 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCALPHA ; Dest: D3DBLEND_INVDESTALPHA    , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+183 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCALPHA ; Dest: D3DBLEND_DESTCOLOR       , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+184 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCALPHA ; Dest: D3DBLEND_INVDESTCOLOR    , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+185 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCALPHA ; Dest: D3DBLEND_SRCALPHASAT     , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+186 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTALPHA   ; Dest: D3DBLEND_ZERO            , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+187 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTALPHA   ; Dest: D3DBLEND_ONE             , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+188 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTALPHA   ; Dest: D3DBLEND_SRCCOLOR        , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+189 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTALPHA   ; Dest: D3DBLEND_INVSRCCOLOR     , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+190 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTALPHA   ; Dest: D3DBLEND_SRCALPHA        , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+191 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTALPHA   ; Dest: D3DBLEND_INVSRCALPHA     , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+192 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTALPHA   ; Dest: D3DBLEND_DESTALPHA       , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+193 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTALPHA   ; Dest: D3DBLEND_INVDESTALPHA    , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+194 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTALPHA   ; Dest: D3DBLEND_DESTCOLOR       , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+195 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTALPHA   ; Dest: D3DBLEND_INVDESTCOLOR    , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+196 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTALPHA   ; Dest: D3DBLEND_SRCALPHASAT     , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+197 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTALPHA; Dest: D3DBLEND_ZERO            , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+198 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTALPHA; Dest: D3DBLEND_ONE             , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+199 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTALPHA; Dest: D3DBLEND_SRCCOLOR        , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+200 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTALPHA; Dest: D3DBLEND_INVSRCCOLOR     , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+201 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTALPHA; Dest: D3DBLEND_SRCALPHA        , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+202 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTALPHA; Dest: D3DBLEND_INVSRCALPHA     , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+203 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTALPHA; Dest: D3DBLEND_DESTALPHA       , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+204 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTALPHA; Dest: D3DBLEND_INVDESTALPHA    , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+205 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTALPHA; Dest: D3DBLEND_DESTCOLOR       , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+206 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTALPHA; Dest: D3DBLEND_INVDESTCOLOR    , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+207 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTALPHA; Dest: D3DBLEND_SRCALPHASAT     , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+208 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTCOLOR   ; Dest: D3DBLEND_ZERO            , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+209 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTCOLOR   ; Dest: D3DBLEND_ONE             , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+210 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTCOLOR   ; Dest: D3DBLEND_SRCCOLOR        , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+211 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTCOLOR   ; Dest: D3DBLEND_INVSRCCOLOR     , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+212 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTCOLOR   ; Dest: D3DBLEND_SRCALPHA        , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+213 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTCOLOR   ; Dest: D3DBLEND_INVSRCALPHA     , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+214 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTCOLOR   ; Dest: D3DBLEND_DESTALPHA       , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+215 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTCOLOR   ; Dest: D3DBLEND_INVDESTALPHA    , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+216 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTCOLOR   ; Dest: D3DBLEND_DESTCOLOR       , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+217 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTCOLOR   ; Dest: D3DBLEND_INVDESTCOLOR    , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+218 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTCOLOR   ; Dest: D3DBLEND_SRCALPHASAT     , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+219 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTCOLOR; Dest: D3DBLEND_ZERO            , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+220 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTCOLOR; Dest: D3DBLEND_ONE             , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+221 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTCOLOR; Dest: D3DBLEND_SRCCOLOR        , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+222 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTCOLOR; Dest: D3DBLEND_INVSRCCOLOR     , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+223 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTCOLOR; Dest: D3DBLEND_SRCALPHA        , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+224 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTCOLOR; Dest: D3DBLEND_INVSRCALPHA     , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+225 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTCOLOR; Dest: D3DBLEND_DESTALPHA       , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+226 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTCOLOR; Dest: D3DBLEND_INVDESTALPHA    , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+227 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTCOLOR; Dest: D3DBLEND_DESTCOLOR       , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+228 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTCOLOR; Dest: D3DBLEND_INVDESTCOLOR    , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+229 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTCOLOR; Dest: D3DBLEND_SRCALPHASAT     , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+230 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHASAT ; Dest: D3DBLEND_ZERO            , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+231 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHASAT ; Dest: D3DBLEND_ONE             , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+232 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHASAT ; Dest: D3DBLEND_SRCCOLOR        , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+233 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHASAT ; Dest: D3DBLEND_INVSRCCOLOR     , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+234 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHASAT ; Dest: D3DBLEND_SRCALPHA        , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+235 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHASAT ; Dest: D3DBLEND_INVSRCALPHA     , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+236 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHASAT ; Dest: D3DBLEND_DESTALPHA       , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+237 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHASAT ; Dest: D3DBLEND_INVDESTALPHA    , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+238 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHASAT ; Dest: D3DBLEND_DESTCOLOR       , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+239 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHASAT ; Dest: D3DBLEND_INVDESTCOLOR    , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+240 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHASAT ; Dest: D3DBLEND_SRCALPHASAT     , D3DBLENDOP_SUBTRACT                "),         1,         0,   D3DMQA_BLENDTEST_BASE+241 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ZERO        ; Dest: D3DBLEND_ZERO            , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+242 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ZERO        ; Dest: D3DBLEND_ONE             , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+243 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ZERO        ; Dest: D3DBLEND_SRCCOLOR        , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+244 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ZERO        ; Dest: D3DBLEND_INVSRCCOLOR     , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+245 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ZERO        ; Dest: D3DBLEND_SRCALPHA        , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+246 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ZERO        ; Dest: D3DBLEND_INVSRCALPHA     , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+247 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ZERO        ; Dest: D3DBLEND_DESTALPHA       , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+248 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ZERO        ; Dest: D3DBLEND_INVDESTALPHA    , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+249 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ZERO        ; Dest: D3DBLEND_DESTCOLOR       , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+250 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ZERO        ; Dest: D3DBLEND_INVDESTCOLOR    , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+251 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ZERO        ; Dest: D3DBLEND_SRCALPHASAT     , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+252 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ONE         ; Dest: D3DBLEND_ZERO            , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+253 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ONE         ; Dest: D3DBLEND_ONE             , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+254 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ONE         ; Dest: D3DBLEND_SRCCOLOR        , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+255 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ONE         ; Dest: D3DBLEND_INVSRCCOLOR     , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+256 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ONE         ; Dest: D3DBLEND_SRCALPHA        , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+257 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ONE         ; Dest: D3DBLEND_INVSRCALPHA     , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+258 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ONE         ; Dest: D3DBLEND_DESTALPHA       , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+259 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ONE         ; Dest: D3DBLEND_INVDESTALPHA    , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+260 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ONE         ; Dest: D3DBLEND_DESTCOLOR       , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+261 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ONE         ; Dest: D3DBLEND_INVDESTCOLOR    , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+262 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ONE         ; Dest: D3DBLEND_SRCALPHASAT     , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+263 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCCOLOR    ; Dest: D3DBLEND_ZERO            , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+264 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCCOLOR    ; Dest: D3DBLEND_ONE             , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+265 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCCOLOR    ; Dest: D3DBLEND_SRCCOLOR        , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+266 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCCOLOR    ; Dest: D3DBLEND_INVSRCCOLOR     , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+267 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCCOLOR    ; Dest: D3DBLEND_SRCALPHA        , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+268 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCCOLOR    ; Dest: D3DBLEND_INVSRCALPHA     , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+269 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCCOLOR    ; Dest: D3DBLEND_DESTALPHA       , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+270 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCCOLOR    ; Dest: D3DBLEND_INVDESTALPHA    , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+271 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCCOLOR    ; Dest: D3DBLEND_DESTCOLOR       , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+272 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCCOLOR    ; Dest: D3DBLEND_INVDESTCOLOR    , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+273 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCCOLOR    ; Dest: D3DBLEND_SRCALPHASAT     , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+274 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCCOLOR ; Dest: D3DBLEND_ZERO            , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+275 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCCOLOR ; Dest: D3DBLEND_ONE             , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+276 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCCOLOR ; Dest: D3DBLEND_SRCCOLOR        , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+277 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCCOLOR ; Dest: D3DBLEND_INVSRCCOLOR     , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+278 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCCOLOR ; Dest: D3DBLEND_SRCALPHA        , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+279 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCCOLOR ; Dest: D3DBLEND_INVSRCALPHA     , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+280 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCCOLOR ; Dest: D3DBLEND_DESTALPHA       , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+281 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCCOLOR ; Dest: D3DBLEND_INVDESTALPHA    , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+282 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCCOLOR ; Dest: D3DBLEND_DESTCOLOR       , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+283 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCCOLOR ; Dest: D3DBLEND_INVDESTCOLOR    , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+284 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCCOLOR ; Dest: D3DBLEND_SRCALPHASAT     , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+285 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHA    ; Dest: D3DBLEND_ZERO            , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+286 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHA    ; Dest: D3DBLEND_ONE             , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+287 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHA    ; Dest: D3DBLEND_SRCCOLOR        , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+288 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHA    ; Dest: D3DBLEND_INVSRCCOLOR     , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+289 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHA    ; Dest: D3DBLEND_SRCALPHA        , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+290 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHA    ; Dest: D3DBLEND_INVSRCALPHA     , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+291 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHA    ; Dest: D3DBLEND_DESTALPHA       , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+292 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHA    ; Dest: D3DBLEND_INVDESTALPHA    , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+293 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHA    ; Dest: D3DBLEND_DESTCOLOR       , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+294 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHA    ; Dest: D3DBLEND_INVDESTCOLOR    , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+295 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHA    ; Dest: D3DBLEND_SRCALPHASAT     , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+296 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCALPHA ; Dest: D3DBLEND_ZERO            , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+297 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCALPHA ; Dest: D3DBLEND_ONE             , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+298 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCALPHA ; Dest: D3DBLEND_SRCCOLOR        , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+299 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCALPHA ; Dest: D3DBLEND_INVSRCCOLOR     , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+300 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCALPHA ; Dest: D3DBLEND_SRCALPHA        , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+301 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCALPHA ; Dest: D3DBLEND_INVSRCALPHA     , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+302 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCALPHA ; Dest: D3DBLEND_DESTALPHA       , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+303 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCALPHA ; Dest: D3DBLEND_INVDESTALPHA    , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+304 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCALPHA ; Dest: D3DBLEND_DESTCOLOR       , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+305 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCALPHA ; Dest: D3DBLEND_INVDESTCOLOR    , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+306 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCALPHA ; Dest: D3DBLEND_SRCALPHASAT     , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+307 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTALPHA   ; Dest: D3DBLEND_ZERO            , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+308 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTALPHA   ; Dest: D3DBLEND_ONE             , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+309 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTALPHA   ; Dest: D3DBLEND_SRCCOLOR        , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+310 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTALPHA   ; Dest: D3DBLEND_INVSRCCOLOR     , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+311 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTALPHA   ; Dest: D3DBLEND_SRCALPHA        , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+312 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTALPHA   ; Dest: D3DBLEND_INVSRCALPHA     , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+313 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTALPHA   ; Dest: D3DBLEND_DESTALPHA       , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+314 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTALPHA   ; Dest: D3DBLEND_INVDESTALPHA    , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+315 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTALPHA   ; Dest: D3DBLEND_DESTCOLOR       , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+316 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTALPHA   ; Dest: D3DBLEND_INVDESTCOLOR    , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+317 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTALPHA   ; Dest: D3DBLEND_SRCALPHASAT     , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+318 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTALPHA; Dest: D3DBLEND_ZERO            , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+319 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTALPHA; Dest: D3DBLEND_ONE             , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+320 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTALPHA; Dest: D3DBLEND_SRCCOLOR        , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+321 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTALPHA; Dest: D3DBLEND_INVSRCCOLOR     , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+322 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTALPHA; Dest: D3DBLEND_SRCALPHA        , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+323 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTALPHA; Dest: D3DBLEND_INVSRCALPHA     , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+324 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTALPHA; Dest: D3DBLEND_DESTALPHA       , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+325 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTALPHA; Dest: D3DBLEND_INVDESTALPHA    , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+326 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTALPHA; Dest: D3DBLEND_DESTCOLOR       , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+327 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTALPHA; Dest: D3DBLEND_INVDESTCOLOR    , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+328 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTALPHA; Dest: D3DBLEND_SRCALPHASAT     , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+329 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTCOLOR   ; Dest: D3DBLEND_ZERO            , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+330 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTCOLOR   ; Dest: D3DBLEND_ONE             , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+331 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTCOLOR   ; Dest: D3DBLEND_SRCCOLOR        , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+332 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTCOLOR   ; Dest: D3DBLEND_INVSRCCOLOR     , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+333 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTCOLOR   ; Dest: D3DBLEND_SRCALPHA        , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+334 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTCOLOR   ; Dest: D3DBLEND_INVSRCALPHA     , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+335 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTCOLOR   ; Dest: D3DBLEND_DESTALPHA       , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+336 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTCOLOR   ; Dest: D3DBLEND_INVDESTALPHA    , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+337 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTCOLOR   ; Dest: D3DBLEND_DESTCOLOR       , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+338 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTCOLOR   ; Dest: D3DBLEND_INVDESTCOLOR    , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+339 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTCOLOR   ; Dest: D3DBLEND_SRCALPHASAT     , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+340 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTCOLOR; Dest: D3DBLEND_ZERO            , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+341 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTCOLOR; Dest: D3DBLEND_ONE             , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+342 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTCOLOR; Dest: D3DBLEND_SRCCOLOR        , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+343 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTCOLOR; Dest: D3DBLEND_INVSRCCOLOR     , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+344 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTCOLOR; Dest: D3DBLEND_SRCALPHA        , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+345 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTCOLOR; Dest: D3DBLEND_INVSRCALPHA     , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+346 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTCOLOR; Dest: D3DBLEND_DESTALPHA       , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+347 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTCOLOR; Dest: D3DBLEND_INVDESTALPHA    , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+348 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTCOLOR; Dest: D3DBLEND_DESTCOLOR       , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+349 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTCOLOR; Dest: D3DBLEND_INVDESTCOLOR    , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+350 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTCOLOR; Dest: D3DBLEND_SRCALPHASAT     , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+351 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHASAT ; Dest: D3DBLEND_ZERO            , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+352 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHASAT ; Dest: D3DBLEND_ONE             , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+353 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHASAT ; Dest: D3DBLEND_SRCCOLOR        , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+354 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHASAT ; Dest: D3DBLEND_INVSRCCOLOR     , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+355 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHASAT ; Dest: D3DBLEND_SRCALPHA        , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+356 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHASAT ; Dest: D3DBLEND_INVSRCALPHA     , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+357 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHASAT ; Dest: D3DBLEND_DESTALPHA       , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+358 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHASAT ; Dest: D3DBLEND_INVDESTALPHA    , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+359 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHASAT ; Dest: D3DBLEND_DESTCOLOR       , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+360 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHASAT ; Dest: D3DBLEND_INVDESTCOLOR    , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+361 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHASAT ; Dest: D3DBLEND_SRCALPHASAT     , D3DBLENDOP_REVSUBTRACT             "),         1,         0,   D3DMQA_BLENDTEST_BASE+362 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ZERO        ; Dest: D3DBLEND_ZERO            , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+363 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ZERO        ; Dest: D3DBLEND_ONE             , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+364 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ZERO        ; Dest: D3DBLEND_SRCCOLOR        , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+365 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ZERO        ; Dest: D3DBLEND_INVSRCCOLOR     , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+366 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ZERO        ; Dest: D3DBLEND_SRCALPHA        , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+367 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ZERO        ; Dest: D3DBLEND_INVSRCALPHA     , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+368 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ZERO        ; Dest: D3DBLEND_DESTALPHA       , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+369 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ZERO        ; Dest: D3DBLEND_INVDESTALPHA    , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+370 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ZERO        ; Dest: D3DBLEND_DESTCOLOR       , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+371 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ZERO        ; Dest: D3DBLEND_INVDESTCOLOR    , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+372 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ZERO        ; Dest: D3DBLEND_SRCALPHASAT     , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+373 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ONE         ; Dest: D3DBLEND_ZERO            , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+374 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ONE         ; Dest: D3DBLEND_ONE             , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+375 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ONE         ; Dest: D3DBLEND_SRCCOLOR        , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+376 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ONE         ; Dest: D3DBLEND_INVSRCCOLOR     , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+377 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ONE         ; Dest: D3DBLEND_SRCALPHA        , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+378 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ONE         ; Dest: D3DBLEND_INVSRCALPHA     , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+379 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ONE         ; Dest: D3DBLEND_DESTALPHA       , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+380 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ONE         ; Dest: D3DBLEND_INVDESTALPHA    , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+381 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ONE         ; Dest: D3DBLEND_DESTCOLOR       , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+382 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ONE         ; Dest: D3DBLEND_INVDESTCOLOR    , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+383 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ONE         ; Dest: D3DBLEND_SRCALPHASAT     , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+384 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCCOLOR    ; Dest: D3DBLEND_ZERO            , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+385 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCCOLOR    ; Dest: D3DBLEND_ONE             , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+386 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCCOLOR    ; Dest: D3DBLEND_SRCCOLOR        , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+387 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCCOLOR    ; Dest: D3DBLEND_INVSRCCOLOR     , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+388 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCCOLOR    ; Dest: D3DBLEND_SRCALPHA        , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+389 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCCOLOR    ; Dest: D3DBLEND_INVSRCALPHA     , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+390 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCCOLOR    ; Dest: D3DBLEND_DESTALPHA       , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+391 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCCOLOR    ; Dest: D3DBLEND_INVDESTALPHA    , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+392 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCCOLOR    ; Dest: D3DBLEND_DESTCOLOR       , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+393 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCCOLOR    ; Dest: D3DBLEND_INVDESTCOLOR    , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+394 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCCOLOR    ; Dest: D3DBLEND_SRCALPHASAT     , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+395 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCCOLOR ; Dest: D3DBLEND_ZERO            , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+396 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCCOLOR ; Dest: D3DBLEND_ONE             , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+397 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCCOLOR ; Dest: D3DBLEND_SRCCOLOR        , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+398 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCCOLOR ; Dest: D3DBLEND_INVSRCCOLOR     , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+399 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCCOLOR ; Dest: D3DBLEND_SRCALPHA        , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+400 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCCOLOR ; Dest: D3DBLEND_INVSRCALPHA     , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+401 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCCOLOR ; Dest: D3DBLEND_DESTALPHA       , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+402 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCCOLOR ; Dest: D3DBLEND_INVDESTALPHA    , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+403 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCCOLOR ; Dest: D3DBLEND_DESTCOLOR       , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+404 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCCOLOR ; Dest: D3DBLEND_INVDESTCOLOR    , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+405 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCCOLOR ; Dest: D3DBLEND_SRCALPHASAT     , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+406 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHA    ; Dest: D3DBLEND_ZERO            , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+407 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHA    ; Dest: D3DBLEND_ONE             , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+408 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHA    ; Dest: D3DBLEND_SRCCOLOR        , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+409 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHA    ; Dest: D3DBLEND_INVSRCCOLOR     , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+410 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHA    ; Dest: D3DBLEND_SRCALPHA        , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+411 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHA    ; Dest: D3DBLEND_INVSRCALPHA     , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+412 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHA    ; Dest: D3DBLEND_DESTALPHA       , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+413 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHA    ; Dest: D3DBLEND_INVDESTALPHA    , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+414 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHA    ; Dest: D3DBLEND_DESTCOLOR       , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+415 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHA    ; Dest: D3DBLEND_INVDESTCOLOR    , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+416 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHA    ; Dest: D3DBLEND_SRCALPHASAT     , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+417 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCALPHA ; Dest: D3DBLEND_ZERO            , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+418 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCALPHA ; Dest: D3DBLEND_ONE             , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+419 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCALPHA ; Dest: D3DBLEND_SRCCOLOR        , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+420 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCALPHA ; Dest: D3DBLEND_INVSRCCOLOR     , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+421 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCALPHA ; Dest: D3DBLEND_SRCALPHA        , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+422 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCALPHA ; Dest: D3DBLEND_INVSRCALPHA     , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+423 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCALPHA ; Dest: D3DBLEND_DESTALPHA       , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+424 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCALPHA ; Dest: D3DBLEND_INVDESTALPHA    , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+425 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCALPHA ; Dest: D3DBLEND_DESTCOLOR       , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+426 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCALPHA ; Dest: D3DBLEND_INVDESTCOLOR    , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+427 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCALPHA ; Dest: D3DBLEND_SRCALPHASAT     , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+428 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTALPHA   ; Dest: D3DBLEND_ZERO            , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+429 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTALPHA   ; Dest: D3DBLEND_ONE             , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+430 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTALPHA   ; Dest: D3DBLEND_SRCCOLOR        , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+431 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTALPHA   ; Dest: D3DBLEND_INVSRCCOLOR     , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+432 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTALPHA   ; Dest: D3DBLEND_SRCALPHA        , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+433 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTALPHA   ; Dest: D3DBLEND_INVSRCALPHA     , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+434 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTALPHA   ; Dest: D3DBLEND_DESTALPHA       , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+435 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTALPHA   ; Dest: D3DBLEND_INVDESTALPHA    , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+436 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTALPHA   ; Dest: D3DBLEND_DESTCOLOR       , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+437 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTALPHA   ; Dest: D3DBLEND_INVDESTCOLOR    , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+438 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTALPHA   ; Dest: D3DBLEND_SRCALPHASAT     , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+439 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTALPHA; Dest: D3DBLEND_ZERO            , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+440 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTALPHA; Dest: D3DBLEND_ONE             , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+441 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTALPHA; Dest: D3DBLEND_SRCCOLOR        , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+442 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTALPHA; Dest: D3DBLEND_INVSRCCOLOR     , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+443 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTALPHA; Dest: D3DBLEND_SRCALPHA        , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+444 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTALPHA; Dest: D3DBLEND_INVSRCALPHA     , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+445 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTALPHA; Dest: D3DBLEND_DESTALPHA       , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+446 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTALPHA; Dest: D3DBLEND_INVDESTALPHA    , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+447 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTALPHA; Dest: D3DBLEND_DESTCOLOR       , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+448 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTALPHA; Dest: D3DBLEND_INVDESTCOLOR    , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+449 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTALPHA; Dest: D3DBLEND_SRCALPHASAT     , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+450 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTCOLOR   ; Dest: D3DBLEND_ZERO            , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+451 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTCOLOR   ; Dest: D3DBLEND_ONE             , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+452 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTCOLOR   ; Dest: D3DBLEND_SRCCOLOR        , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+453 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTCOLOR   ; Dest: D3DBLEND_INVSRCCOLOR     , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+454 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTCOLOR   ; Dest: D3DBLEND_SRCALPHA        , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+455 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTCOLOR   ; Dest: D3DBLEND_INVSRCALPHA     , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+456 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTCOLOR   ; Dest: D3DBLEND_DESTALPHA       , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+457 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTCOLOR   ; Dest: D3DBLEND_INVDESTALPHA    , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+458 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTCOLOR   ; Dest: D3DBLEND_DESTCOLOR       , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+459 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTCOLOR   ; Dest: D3DBLEND_INVDESTCOLOR    , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+460 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTCOLOR   ; Dest: D3DBLEND_SRCALPHASAT     , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+461 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTCOLOR; Dest: D3DBLEND_ZERO            , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+462 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTCOLOR; Dest: D3DBLEND_ONE             , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+463 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTCOLOR; Dest: D3DBLEND_SRCCOLOR        , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+464 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTCOLOR; Dest: D3DBLEND_INVSRCCOLOR     , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+465 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTCOLOR; Dest: D3DBLEND_SRCALPHA        , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+466 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTCOLOR; Dest: D3DBLEND_INVSRCALPHA     , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+467 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTCOLOR; Dest: D3DBLEND_DESTALPHA       , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+468 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTCOLOR; Dest: D3DBLEND_INVDESTALPHA    , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+469 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTCOLOR; Dest: D3DBLEND_DESTCOLOR       , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+470 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTCOLOR; Dest: D3DBLEND_INVDESTCOLOR    , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+471 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTCOLOR; Dest: D3DBLEND_SRCALPHASAT     , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+472 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHASAT ; Dest: D3DBLEND_ZERO            , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+473 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHASAT ; Dest: D3DBLEND_ONE             , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+474 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHASAT ; Dest: D3DBLEND_SRCCOLOR        , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+475 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHASAT ; Dest: D3DBLEND_INVSRCCOLOR     , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+476 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHASAT ; Dest: D3DBLEND_SRCALPHA        , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+477 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHASAT ; Dest: D3DBLEND_INVSRCALPHA     , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+478 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHASAT ; Dest: D3DBLEND_DESTALPHA       , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+479 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHASAT ; Dest: D3DBLEND_INVDESTALPHA    , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+480 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHASAT ; Dest: D3DBLEND_DESTCOLOR       , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+481 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHASAT ; Dest: D3DBLEND_INVDESTCOLOR    , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+482 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHASAT ; Dest: D3DBLEND_SRCALPHASAT     , D3DBLENDOP_MIN                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+483 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ZERO        ; Dest: D3DBLEND_ZERO            , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+484 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ZERO        ; Dest: D3DBLEND_ONE             , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+485 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ZERO        ; Dest: D3DBLEND_SRCCOLOR        , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+486 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ZERO        ; Dest: D3DBLEND_INVSRCCOLOR     , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+487 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ZERO        ; Dest: D3DBLEND_SRCALPHA        , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+488 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ZERO        ; Dest: D3DBLEND_INVSRCALPHA     , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+489 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ZERO        ; Dest: D3DBLEND_DESTALPHA       , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+490 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ZERO        ; Dest: D3DBLEND_INVDESTALPHA    , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+491 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ZERO        ; Dest: D3DBLEND_DESTCOLOR       , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+492 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ZERO        ; Dest: D3DBLEND_INVDESTCOLOR    , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+493 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ZERO        ; Dest: D3DBLEND_SRCALPHASAT     , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+494 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ONE         ; Dest: D3DBLEND_ZERO            , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+495 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ONE         ; Dest: D3DBLEND_ONE             , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+496 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ONE         ; Dest: D3DBLEND_SRCCOLOR        , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+497 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ONE         ; Dest: D3DBLEND_INVSRCCOLOR     , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+498 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ONE         ; Dest: D3DBLEND_SRCALPHA        , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+499 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ONE         ; Dest: D3DBLEND_INVSRCALPHA     , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+500 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ONE         ; Dest: D3DBLEND_DESTALPHA       , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+501 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ONE         ; Dest: D3DBLEND_INVDESTALPHA    , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+502 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ONE         ; Dest: D3DBLEND_DESTCOLOR       , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+503 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ONE         ; Dest: D3DBLEND_INVDESTCOLOR    , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+504 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_ONE         ; Dest: D3DBLEND_SRCALPHASAT     , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+505 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCCOLOR    ; Dest: D3DBLEND_ZERO            , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+506 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCCOLOR    ; Dest: D3DBLEND_ONE             , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+507 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCCOLOR    ; Dest: D3DBLEND_SRCCOLOR        , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+508 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCCOLOR    ; Dest: D3DBLEND_INVSRCCOLOR     , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+509 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCCOLOR    ; Dest: D3DBLEND_SRCALPHA        , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+510 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCCOLOR    ; Dest: D3DBLEND_INVSRCALPHA     , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+511 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCCOLOR    ; Dest: D3DBLEND_DESTALPHA       , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+512 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCCOLOR    ; Dest: D3DBLEND_INVDESTALPHA    , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+513 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCCOLOR    ; Dest: D3DBLEND_DESTCOLOR       , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+514 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCCOLOR    ; Dest: D3DBLEND_INVDESTCOLOR    , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+515 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCCOLOR    ; Dest: D3DBLEND_SRCALPHASAT     , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+516 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCCOLOR ; Dest: D3DBLEND_ZERO            , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+517 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCCOLOR ; Dest: D3DBLEND_ONE             , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+518 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCCOLOR ; Dest: D3DBLEND_SRCCOLOR        , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+519 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCCOLOR ; Dest: D3DBLEND_INVSRCCOLOR     , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+520 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCCOLOR ; Dest: D3DBLEND_SRCALPHA        , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+521 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCCOLOR ; Dest: D3DBLEND_INVSRCALPHA     , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+522 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCCOLOR ; Dest: D3DBLEND_DESTALPHA       , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+523 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCCOLOR ; Dest: D3DBLEND_INVDESTALPHA    , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+524 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCCOLOR ; Dest: D3DBLEND_DESTCOLOR       , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+525 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCCOLOR ; Dest: D3DBLEND_INVDESTCOLOR    , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+526 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCCOLOR ; Dest: D3DBLEND_SRCALPHASAT     , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+527 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHA    ; Dest: D3DBLEND_ZERO            , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+528 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHA    ; Dest: D3DBLEND_ONE             , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+529 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHA    ; Dest: D3DBLEND_SRCCOLOR        , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+530 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHA    ; Dest: D3DBLEND_INVSRCCOLOR     , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+531 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHA    ; Dest: D3DBLEND_SRCALPHA        , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+532 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHA    ; Dest: D3DBLEND_INVSRCALPHA     , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+533 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHA    ; Dest: D3DBLEND_DESTALPHA       , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+534 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHA    ; Dest: D3DBLEND_INVDESTALPHA    , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+535 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHA    ; Dest: D3DBLEND_DESTCOLOR       , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+536 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHA    ; Dest: D3DBLEND_INVDESTCOLOR    , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+537 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHA    ; Dest: D3DBLEND_SRCALPHASAT     , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+538 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCALPHA ; Dest: D3DBLEND_ZERO            , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+539 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCALPHA ; Dest: D3DBLEND_ONE             , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+540 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCALPHA ; Dest: D3DBLEND_SRCCOLOR        , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+541 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCALPHA ; Dest: D3DBLEND_INVSRCCOLOR     , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+542 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCALPHA ; Dest: D3DBLEND_SRCALPHA        , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+543 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCALPHA ; Dest: D3DBLEND_INVSRCALPHA     , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+544 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCALPHA ; Dest: D3DBLEND_DESTALPHA       , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+545 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCALPHA ; Dest: D3DBLEND_INVDESTALPHA    , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+546 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCALPHA ; Dest: D3DBLEND_DESTCOLOR       , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+547 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCALPHA ; Dest: D3DBLEND_INVDESTCOLOR    , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+548 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVSRCALPHA ; Dest: D3DBLEND_SRCALPHASAT     , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+549 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTALPHA   ; Dest: D3DBLEND_ZERO            , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+550 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTALPHA   ; Dest: D3DBLEND_ONE             , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+551 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTALPHA   ; Dest: D3DBLEND_SRCCOLOR        , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+552 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTALPHA   ; Dest: D3DBLEND_INVSRCCOLOR     , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+553 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTALPHA   ; Dest: D3DBLEND_SRCALPHA        , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+554 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTALPHA   ; Dest: D3DBLEND_INVSRCALPHA     , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+555 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTALPHA   ; Dest: D3DBLEND_DESTALPHA       , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+556 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTALPHA   ; Dest: D3DBLEND_INVDESTALPHA    , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+557 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTALPHA   ; Dest: D3DBLEND_DESTCOLOR       , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+558 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTALPHA   ; Dest: D3DBLEND_INVDESTCOLOR    , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+559 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTALPHA   ; Dest: D3DBLEND_SRCALPHASAT     , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+560 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTALPHA; Dest: D3DBLEND_ZERO            , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+561 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTALPHA; Dest: D3DBLEND_ONE             , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+562 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTALPHA; Dest: D3DBLEND_SRCCOLOR        , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+563 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTALPHA; Dest: D3DBLEND_INVSRCCOLOR     , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+564 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTALPHA; Dest: D3DBLEND_SRCALPHA        , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+565 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTALPHA; Dest: D3DBLEND_INVSRCALPHA     , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+566 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTALPHA; Dest: D3DBLEND_DESTALPHA       , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+567 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTALPHA; Dest: D3DBLEND_INVDESTALPHA    , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+568 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTALPHA; Dest: D3DBLEND_DESTCOLOR       , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+569 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTALPHA; Dest: D3DBLEND_INVDESTCOLOR    , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+570 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTALPHA; Dest: D3DBLEND_SRCALPHASAT     , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+571 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTCOLOR   ; Dest: D3DBLEND_ZERO            , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+572 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTCOLOR   ; Dest: D3DBLEND_ONE             , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+573 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTCOLOR   ; Dest: D3DBLEND_SRCCOLOR        , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+574 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTCOLOR   ; Dest: D3DBLEND_INVSRCCOLOR     , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+575 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTCOLOR   ; Dest: D3DBLEND_SRCALPHA        , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+576 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTCOLOR   ; Dest: D3DBLEND_INVSRCALPHA     , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+577 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTCOLOR   ; Dest: D3DBLEND_DESTALPHA       , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+578 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTCOLOR   ; Dest: D3DBLEND_INVDESTALPHA    , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+579 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTCOLOR   ; Dest: D3DBLEND_DESTCOLOR       , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+580 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTCOLOR   ; Dest: D3DBLEND_INVDESTCOLOR    , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+581 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_DESTCOLOR   ; Dest: D3DBLEND_SRCALPHASAT     , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+582 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTCOLOR; Dest: D3DBLEND_ZERO            , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+583 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTCOLOR; Dest: D3DBLEND_ONE             , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+584 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTCOLOR; Dest: D3DBLEND_SRCCOLOR        , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+585 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTCOLOR; Dest: D3DBLEND_INVSRCCOLOR     , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+586 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTCOLOR; Dest: D3DBLEND_SRCALPHA        , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+587 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTCOLOR; Dest: D3DBLEND_INVSRCALPHA     , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+588 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTCOLOR; Dest: D3DBLEND_DESTALPHA       , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+589 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTCOLOR; Dest: D3DBLEND_INVDESTALPHA    , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+590 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTCOLOR; Dest: D3DBLEND_DESTCOLOR       , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+591 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTCOLOR; Dest: D3DBLEND_INVDESTCOLOR    , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+592 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_INVDESTCOLOR; Dest: D3DBLEND_SRCALPHASAT     , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+593 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHASAT ; Dest: D3DBLEND_ZERO            , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+594 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHASAT ; Dest: D3DBLEND_ONE             , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+595 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHASAT ; Dest: D3DBLEND_SRCCOLOR        , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+596 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHASAT ; Dest: D3DBLEND_INVSRCCOLOR     , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+597 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHASAT ; Dest: D3DBLEND_SRCALPHA        , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+598 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHASAT ; Dest: D3DBLEND_INVSRCALPHA     , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+599 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHASAT ; Dest: D3DBLEND_DESTALPHA       , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+600 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHASAT ; Dest: D3DBLEND_INVDESTALPHA    , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+601 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHASAT ; Dest: D3DBLEND_DESTCOLOR       , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+602 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHASAT ; Dest: D3DBLEND_INVDESTCOLOR    , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+603 , TuxTest},
{ TEXT("(BlendTest) Source: D3DBLEND_SRCALPHASAT ; Dest: D3DBLEND_SRCALPHASAT     , D3DBLENDOP_MAX                     "),         1,         0,   D3DMQA_BLENDTEST_BASE+604 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:NEVER; FMT:D15S1; ACTUAL:GREATER)                                                "),         1,         0, D3DMQA_STENCILTEST_BASE+  0 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:NEVER; FMT:D15S1; ACTUAL:EQUAL)                                                  "),         1,         0, D3DMQA_STENCILTEST_BASE+  1 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:NEVER; FMT:D15S1; ACTUAL:LESS)                                                   "),         1,         0, D3DMQA_STENCILTEST_BASE+  2 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:LESS; FMT:D15S1; ACTUAL:GREATER)                                                 "),         1,         0, D3DMQA_STENCILTEST_BASE+  3 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:LESS; FMT:D15S1; ACTUAL:EQUAL)                                                   "),         1,         0, D3DMQA_STENCILTEST_BASE+  4 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:LESS; FMT:D15S1; ACTUAL:LESS)                                                    "),         1,         0, D3DMQA_STENCILTEST_BASE+  5 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:EQUAL; FMT:D15S1; ACTUAL:GREATER)                                                "),         1,         0, D3DMQA_STENCILTEST_BASE+  6 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:EQUAL; FMT:D15S1; ACTUAL:EQUAL)                                                  "),         1,         0, D3DMQA_STENCILTEST_BASE+  7 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:EQUAL; FMT:D15S1; ACTUAL:LESS)                                                   "),         1,         0, D3DMQA_STENCILTEST_BASE+  8 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:LESSEQUAL; FMT:D15S1; ACTUAL:GREATER)                                            "),         1,         0, D3DMQA_STENCILTEST_BASE+  9 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:LESSEQUAL; FMT:D15S1; ACTUAL:EQUAL)                                              "),         1,         0, D3DMQA_STENCILTEST_BASE+ 10 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:LESSEQUAL; FMT:D15S1; ACTUAL:LESS)                                               "),         1,         0, D3DMQA_STENCILTEST_BASE+ 11 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:GREATER; FMT:D15S1; ACTUAL:GREATER)                                              "),         1,         0, D3DMQA_STENCILTEST_BASE+ 12 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:GREATER; FMT:D15S1; ACTUAL:EQUAL)                                                "),         1,         0, D3DMQA_STENCILTEST_BASE+ 13 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:GREATER; FMT:D15S1; ACTUAL:LESS)                                                 "),         1,         0, D3DMQA_STENCILTEST_BASE+ 14 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:NOTEQUAL; FMT:D15S1; ACTUAL:GREATER)                                             "),         1,         0, D3DMQA_STENCILTEST_BASE+ 15 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:NOTEQUAL; FMT:D15S1; ACTUAL:EQUAL)                                               "),         1,         0, D3DMQA_STENCILTEST_BASE+ 16 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:NOTEQUAL; FMT:D15S1; ACTUAL:LESS)                                                "),         1,         0, D3DMQA_STENCILTEST_BASE+ 17 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:GREATEREQUAL; FMT:D15S1; ACTUAL:GREATER)                                         "),         1,         0, D3DMQA_STENCILTEST_BASE+ 18 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:GREATEREQUAL; FMT:D15S1; ACTUAL:EQUAL)                                           "),         1,         0, D3DMQA_STENCILTEST_BASE+ 19 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:GREATEREQUAL; FMT:D15S1; ACTUAL:LESS)                                            "),         1,         0, D3DMQA_STENCILTEST_BASE+ 20 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:ALWAYS; FMT:D15S1; ACTUAL:GREATER)                                               "),         1,         0, D3DMQA_STENCILTEST_BASE+ 21 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:ALWAYS; FMT:D15S1; ACTUAL:EQUAL)                                                 "),         1,         0, D3DMQA_STENCILTEST_BASE+ 22 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:ALWAYS; FMT:D15S1; ACTUAL:LESS)                                                  "),         1,         0, D3DMQA_STENCILTEST_BASE+ 23 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:NEVER; FMT:D24S8; ACTUAL:GREATER)                                                "),         1,         0, D3DMQA_STENCILTEST_BASE+ 24 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:NEVER; FMT:D24S8; ACTUAL:EQUAL)                                                  "),         1,         0, D3DMQA_STENCILTEST_BASE+ 25 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:NEVER; FMT:D24S8; ACTUAL:LESS)                                                   "),         1,         0, D3DMQA_STENCILTEST_BASE+ 26 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:LESS; FMT:D24S8; ACTUAL:GREATER)                                                 "),         1,         0, D3DMQA_STENCILTEST_BASE+ 27 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:LESS; FMT:D24S8; ACTUAL:EQUAL)                                                   "),         1,         0, D3DMQA_STENCILTEST_BASE+ 28 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:LESS; FMT:D24S8; ACTUAL:LESS)                                                    "),         1,         0, D3DMQA_STENCILTEST_BASE+ 29 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:EQUAL; FMT:D24S8; ACTUAL:GREATER)                                                "),         1,         0, D3DMQA_STENCILTEST_BASE+ 30 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:EQUAL; FMT:D24S8; ACTUAL:EQUAL)                                                  "),         1,         0, D3DMQA_STENCILTEST_BASE+ 31 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:EQUAL; FMT:D24S8; ACTUAL:LESS)                                                   "),         1,         0, D3DMQA_STENCILTEST_BASE+ 32 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:LESSEQUAL; FMT:D24S8; ACTUAL:GREATER)                                            "),         1,         0, D3DMQA_STENCILTEST_BASE+ 33 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:LESSEQUAL; FMT:D24S8; ACTUAL:EQUAL)                                              "),         1,         0, D3DMQA_STENCILTEST_BASE+ 34 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:LESSEQUAL; FMT:D24S8; ACTUAL:LESS)                                               "),         1,         0, D3DMQA_STENCILTEST_BASE+ 35 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:GREATER; FMT:D24S8; ACTUAL:GREATER)                                              "),         1,         0, D3DMQA_STENCILTEST_BASE+ 36 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:GREATER; FMT:D24S8; ACTUAL:EQUAL)                                                "),         1,         0, D3DMQA_STENCILTEST_BASE+ 37 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:GREATER; FMT:D24S8; ACTUAL:LESS)                                                 "),         1,         0, D3DMQA_STENCILTEST_BASE+ 38 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:NOTEQUAL; FMT:D24S8; ACTUAL:GREATER)                                             "),         1,         0, D3DMQA_STENCILTEST_BASE+ 39 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:NOTEQUAL; FMT:D24S8; ACTUAL:EQUAL)                                               "),         1,         0, D3DMQA_STENCILTEST_BASE+ 40 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:NOTEQUAL; FMT:D24S8; ACTUAL:LESS)                                                "),         1,         0, D3DMQA_STENCILTEST_BASE+ 41 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:GREATEREQUAL; FMT:D24S8; ACTUAL:GREATER)                                         "),         1,         0, D3DMQA_STENCILTEST_BASE+ 42 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:GREATEREQUAL; FMT:D24S8; ACTUAL:EQUAL)                                           "),         1,         0, D3DMQA_STENCILTEST_BASE+ 43 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:GREATEREQUAL; FMT:D24S8; ACTUAL:LESS)                                            "),         1,         0, D3DMQA_STENCILTEST_BASE+ 44 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:ALWAYS; FMT:D24S8; ACTUAL:GREATER)                                               "),         1,         0, D3DMQA_STENCILTEST_BASE+ 45 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:ALWAYS; FMT:D24S8; ACTUAL:EQUAL)                                                 "),         1,         0, D3DMQA_STENCILTEST_BASE+ 46 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:ALWAYS; FMT:D24S8; ACTUAL:LESS)                                                  "),         1,         0, D3DMQA_STENCILTEST_BASE+ 47 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:NEVER; FMT:D24X4S4; ACTUAL:GREATER)                                              "),         1,         0, D3DMQA_STENCILTEST_BASE+ 48 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:NEVER; FMT:D24X4S4; ACTUAL:EQUAL)                                                "),         1,         0, D3DMQA_STENCILTEST_BASE+ 49 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:NEVER; FMT:D24X4S4; ACTUAL:LESS)                                                 "),         1,         0, D3DMQA_STENCILTEST_BASE+ 50 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:LESS; FMT:D24X4S4; ACTUAL:GREATER)                                               "),         1,         0, D3DMQA_STENCILTEST_BASE+ 51 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:LESS; FMT:D24X4S4; ACTUAL:EQUAL)                                                 "),         1,         0, D3DMQA_STENCILTEST_BASE+ 52 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:LESS; FMT:D24X4S4; ACTUAL:LESS)                                                  "),         1,         0, D3DMQA_STENCILTEST_BASE+ 53 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:EQUAL; FMT:D24X4S4; ACTUAL:GREATER)                                              "),         1,         0, D3DMQA_STENCILTEST_BASE+ 54 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:EQUAL; FMT:D24X4S4; ACTUAL:EQUAL)                                                "),         1,         0, D3DMQA_STENCILTEST_BASE+ 55 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:EQUAL; FMT:D24X4S4; ACTUAL:LESS)                                                 "),         1,         0, D3DMQA_STENCILTEST_BASE+ 56 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:LESSEQUAL; FMT:D24X4S4; ACTUAL:GREATER)                                          "),         1,         0, D3DMQA_STENCILTEST_BASE+ 57 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:LESSEQUAL; FMT:D24X4S4; ACTUAL:EQUAL)                                            "),         1,         0, D3DMQA_STENCILTEST_BASE+ 58 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:LESSEQUAL; FMT:D24X4S4; ACTUAL:LESS)                                             "),         1,         0, D3DMQA_STENCILTEST_BASE+ 59 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:GREATER; FMT:D24X4S4; ACTUAL:GREATER)                                            "),         1,         0, D3DMQA_STENCILTEST_BASE+ 60 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:GREATER; FMT:D24X4S4; ACTUAL:EQUAL)                                              "),         1,         0, D3DMQA_STENCILTEST_BASE+ 61 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:GREATER; FMT:D24X4S4; ACTUAL:LESS)                                               "),         1,         0, D3DMQA_STENCILTEST_BASE+ 62 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:NOTEQUAL; FMT:D24X4S4; ACTUAL:GREATER)                                           "),         1,         0, D3DMQA_STENCILTEST_BASE+ 63 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:NOTEQUAL; FMT:D24X4S4; ACTUAL:EQUAL)                                             "),         1,         0, D3DMQA_STENCILTEST_BASE+ 64 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:NOTEQUAL; FMT:D24X4S4; ACTUAL:LESS)                                              "),         1,         0, D3DMQA_STENCILTEST_BASE+ 65 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:GREATEREQUAL; FMT:D24X4S4; ACTUAL:GREATER)                                       "),         1,         0, D3DMQA_STENCILTEST_BASE+ 66 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:GREATEREQUAL; FMT:D24X4S4; ACTUAL:EQUAL)                                         "),         1,         0, D3DMQA_STENCILTEST_BASE+ 67 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:GREATEREQUAL; FMT:D24X4S4; ACTUAL:LESS)                                          "),         1,         0, D3DMQA_STENCILTEST_BASE+ 68 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:ALWAYS; FMT:D24X4S4; ACTUAL:GREATER)                                             "),         1,         0, D3DMQA_STENCILTEST_BASE+ 69 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:ALWAYS; FMT:D24X4S4; ACTUAL:EQUAL)                                               "),         1,         0, D3DMQA_STENCILTEST_BASE+ 70 , TuxTest},
{ TEXT("(StencilTest) STENCILFUNC(CMP:ALWAYS; FMT:D24X4S4; ACTUAL:LESS)                                                "),         1,         0, D3DMQA_STENCILTEST_BASE+ 71 , TuxTest},
{ TEXT("(StencilTest) STENCILPASS(OP:KEEP   ; FMT:D15S1)                                                               "),         1,         0, D3DMQA_STENCILTEST_BASE+ 72 , TuxTest},
{ TEXT("(StencilTest) STENCILPASS(OP:ZERO   ; FMT:D15S1)                                                               "),         1,         0, D3DMQA_STENCILTEST_BASE+ 73 , TuxTest},
{ TEXT("(StencilTest) STENCILPASS(OP:REPLACE; FMT:D15S1)                                                               "),         1,         0, D3DMQA_STENCILTEST_BASE+ 74 , TuxTest},
{ TEXT("(StencilTest) STENCILPASS(OP:INCRSAT; FMT:D15S1)                                                               "),         1,         0, D3DMQA_STENCILTEST_BASE+ 75 , TuxTest},
{ TEXT("(StencilTest) STENCILPASS(OP:DECRSAT; FMT:D15S1)                                                               "),         1,         0, D3DMQA_STENCILTEST_BASE+ 76 , TuxTest},
{ TEXT("(StencilTest) STENCILPASS(OP:INVERT ; FMT:D15S1)                                                               "),         1,         0, D3DMQA_STENCILTEST_BASE+ 77 , TuxTest},
{ TEXT("(StencilTest) STENCILPASS(OP:INCR   ; FMT:D15S1)                                                               "),         1,         0, D3DMQA_STENCILTEST_BASE+ 78 , TuxTest},
{ TEXT("(StencilTest) STENCILPASS(OP:DECR   ; FMT:D15S1)                                                               "),         1,         0, D3DMQA_STENCILTEST_BASE+ 79 , TuxTest},
{ TEXT("(StencilTest) STENCILPASS(OP:KEEP   ; FMT:D24S8)                                                               "),         1,         0, D3DMQA_STENCILTEST_BASE+ 80 , TuxTest},
{ TEXT("(StencilTest) STENCILPASS(OP:ZERO   ; FMT:D24S8)                                                               "),         1,         0, D3DMQA_STENCILTEST_BASE+ 81 , TuxTest},
{ TEXT("(StencilTest) STENCILPASS(OP:REPLACE; FMT:D24S8)                                                               "),         1,         0, D3DMQA_STENCILTEST_BASE+ 82 , TuxTest},
{ TEXT("(StencilTest) STENCILPASS(OP:INCRSAT; FMT:D24S8)                                                               "),         1,         0, D3DMQA_STENCILTEST_BASE+ 83 , TuxTest},
{ TEXT("(StencilTest) STENCILPASS(OP:DECRSAT; FMT:D24S8)                                                               "),         1,         0, D3DMQA_STENCILTEST_BASE+ 84 , TuxTest},
{ TEXT("(StencilTest) STENCILPASS(OP:INVERT ; FMT:D24S8)                                                               "),         1,         0, D3DMQA_STENCILTEST_BASE+ 85 , TuxTest},
{ TEXT("(StencilTest) STENCILPASS(OP:INCR   ; FMT:D24S8)                                                               "),         1,         0, D3DMQA_STENCILTEST_BASE+ 86 , TuxTest},
{ TEXT("(StencilTest) STENCILPASS(OP:DECR   ; FMT:D24S8)                                                               "),         1,         0, D3DMQA_STENCILTEST_BASE+ 87 , TuxTest},
{ TEXT("(StencilTest) STENCILPASS(OP:KEEP   ; FMT:D24X4S4)                                                             "),         1,         0, D3DMQA_STENCILTEST_BASE+ 88 , TuxTest},
{ TEXT("(StencilTest) STENCILPASS(OP:ZERO   ; FMT:D24X4S4)                                                             "),         1,         0, D3DMQA_STENCILTEST_BASE+ 89 , TuxTest},
{ TEXT("(StencilTest) STENCILPASS(OP:REPLACE; FMT:D24X4S4)                                                             "),         1,         0, D3DMQA_STENCILTEST_BASE+ 90 , TuxTest},
{ TEXT("(StencilTest) STENCILPASS(OP:INCRSAT; FMT:D24X4S4)                                                             "),         1,         0, D3DMQA_STENCILTEST_BASE+ 91 , TuxTest},
{ TEXT("(StencilTest) STENCILPASS(OP:DECRSAT; FMT:D24X4S4)                                                             "),         1,         0, D3DMQA_STENCILTEST_BASE+ 92 , TuxTest},
{ TEXT("(StencilTest) STENCILPASS(OP:INVERT ; FMT:D24X4S4)                                                             "),         1,         0, D3DMQA_STENCILTEST_BASE+ 93 , TuxTest},
{ TEXT("(StencilTest) STENCILPASS(OP:INCR   ; FMT:D24X4S4)                                                             "),         1,         0, D3DMQA_STENCILTEST_BASE+ 94 , TuxTest},
{ TEXT("(StencilTest) STENCILPASS(OP:DECR   ; FMT:D24X4S4)                                                             "),         1,         0, D3DMQA_STENCILTEST_BASE+ 95 , TuxTest},
{ TEXT("(StencilTest) STENCILFAIL(OP:KEEP   ; FMT:D15S1)                                                               "),         1,         0, D3DMQA_STENCILTEST_BASE+ 96 , TuxTest},
{ TEXT("(StencilTest) STENCILFAIL(OP:ZERO   ; FMT:D15S1)                                                               "),         1,         0, D3DMQA_STENCILTEST_BASE+ 97 , TuxTest},
{ TEXT("(StencilTest) STENCILFAIL(OP:REPLACE; FMT:D15S1)                                                               "),         1,         0, D3DMQA_STENCILTEST_BASE+ 98 , TuxTest},
{ TEXT("(StencilTest) STENCILFAIL(OP:INCRSAT; FMT:D15S1)                                                               "),         1,         0, D3DMQA_STENCILTEST_BASE+ 99 , TuxTest},
{ TEXT("(StencilTest) STENCILFAIL(OP:DECRSAT; FMT:D15S1)                                                               "),         1,         0, D3DMQA_STENCILTEST_BASE+100 , TuxTest},
{ TEXT("(StencilTest) STENCILFAIL(OP:INVERT ; FMT:D15S1)                                                               "),         1,         0, D3DMQA_STENCILTEST_BASE+101 , TuxTest},
{ TEXT("(StencilTest) STENCILFAIL(OP:INCR   ; FMT:D15S1)                                                               "),         1,         0, D3DMQA_STENCILTEST_BASE+102 , TuxTest},
{ TEXT("(StencilTest) STENCILFAIL(OP:DECR   ; FMT:D15S1)                                                               "),         1,         0, D3DMQA_STENCILTEST_BASE+103 , TuxTest},
{ TEXT("(StencilTest) STENCILFAIL(OP:KEEP   ; FMT:D24S8)                                                               "),         1,         0, D3DMQA_STENCILTEST_BASE+104 , TuxTest},
{ TEXT("(StencilTest) STENCILFAIL(OP:ZERO   ; FMT:D24S8)                                                               "),         1,         0, D3DMQA_STENCILTEST_BASE+105 , TuxTest},
{ TEXT("(StencilTest) STENCILFAIL(OP:REPLACE; FMT:D24S8)                                                               "),         1,         0, D3DMQA_STENCILTEST_BASE+106 , TuxTest},
{ TEXT("(StencilTest) STENCILFAIL(OP:INCRSAT; FMT:D24S8)                                                               "),         1,         0, D3DMQA_STENCILTEST_BASE+107 , TuxTest},
{ TEXT("(StencilTest) STENCILFAIL(OP:DECRSAT; FMT:D24S8)                                                               "),         1,         0, D3DMQA_STENCILTEST_BASE+108 , TuxTest},
{ TEXT("(StencilTest) STENCILFAIL(OP:INVERT ; FMT:D24S8)                                                               "),         1,         0, D3DMQA_STENCILTEST_BASE+109 , TuxTest},
{ TEXT("(StencilTest) STENCILFAIL(OP:INCR   ; FMT:D24S8)                                                               "),         1,         0, D3DMQA_STENCILTEST_BASE+110 , TuxTest},
{ TEXT("(StencilTest) STENCILFAIL(OP:DECR   ; FMT:D24S8)                                                               "),         1,         0, D3DMQA_STENCILTEST_BASE+111 , TuxTest},
{ TEXT("(StencilTest) STENCILFAIL(OP:KEEP   ; FMT:D24X4S4)                                                             "),         1,         0, D3DMQA_STENCILTEST_BASE+112 , TuxTest},
{ TEXT("(StencilTest) STENCILFAIL(OP:ZERO   ; FMT:D24X4S4)                                                             "),         1,         0, D3DMQA_STENCILTEST_BASE+113 , TuxTest},
{ TEXT("(StencilTest) STENCILFAIL(OP:REPLACE; FMT:D24X4S4)                                                             "),         1,         0, D3DMQA_STENCILTEST_BASE+114 , TuxTest},
{ TEXT("(StencilTest) STENCILFAIL(OP:INCRSAT; FMT:D24X4S4)                                                             "),         1,         0, D3DMQA_STENCILTEST_BASE+115 , TuxTest},
{ TEXT("(StencilTest) STENCILFAIL(OP:DECRSAT; FMT:D24X4S4)                                                             "),         1,         0, D3DMQA_STENCILTEST_BASE+116 , TuxTest},
{ TEXT("(StencilTest) STENCILFAIL(OP:INVERT ; FMT:D24X4S4)                                                             "),         1,         0, D3DMQA_STENCILTEST_BASE+117 , TuxTest},
{ TEXT("(StencilTest) STENCILFAIL(OP:INCR   ; FMT:D24X4S4)                                                             "),         1,         0, D3DMQA_STENCILTEST_BASE+118 , TuxTest},
{ TEXT("(StencilTest) STENCILFAIL(OP:DECR   ; FMT:D24X4S4)                                                             "),         1,         0, D3DMQA_STENCILTEST_BASE+119 , TuxTest},
{ TEXT("(StencilTest) STENCILMASK(VARIATION:1 ; FMT:D15S1)                                                             "),         1,         0, D3DMQA_STENCILTEST_BASE+120 , TuxTest},
{ TEXT("(StencilTest) STENCILMASK(VARIATION:2 ; FMT:D15S1)                                                             "),         1,         0, D3DMQA_STENCILTEST_BASE+121 , TuxTest},
{ TEXT("(StencilTest) STENCILMASK(VARIATION:3 ; FMT:D15S1)                                                             "),         1,         0, D3DMQA_STENCILTEST_BASE+122 , TuxTest},
{ TEXT("(StencilTest) STENCILMASK(VARIATION:4 ; FMT:D15S1)                                                             "),         1,         0, D3DMQA_STENCILTEST_BASE+123 , TuxTest},
{ TEXT("(StencilTest) STENCILMASK(VARIATION:5 ; FMT:D15S1)                                                             "),         1,         0, D3DMQA_STENCILTEST_BASE+124 , TuxTest},
{ TEXT("(StencilTest) STENCILMASK(VARIATION:6 ; FMT:D15S1)                                                             "),         1,         0, D3DMQA_STENCILTEST_BASE+125 , TuxTest},
{ TEXT("(StencilTest) STENCILMASK(VARIATION:1 ; FMT:D24S8)                                                             "),         1,         0, D3DMQA_STENCILTEST_BASE+126 , TuxTest},
{ TEXT("(StencilTest) STENCILMASK(VARIATION:2 ; FMT:D24S8)                                                             "),         1,         0, D3DMQA_STENCILTEST_BASE+127 , TuxTest},
{ TEXT("(StencilTest) STENCILMASK(VARIATION:3 ; FMT:D24S8)                                                             "),         1,         0, D3DMQA_STENCILTEST_BASE+128 , TuxTest},
{ TEXT("(StencilTest) STENCILMASK(VARIATION:4 ; FMT:D24S8)                                                             "),         1,         0, D3DMQA_STENCILTEST_BASE+129 , TuxTest},
{ TEXT("(StencilTest) STENCILMASK(VARIATION:5 ; FMT:D24S8)                                                             "),         1,         0, D3DMQA_STENCILTEST_BASE+130 , TuxTest},
{ TEXT("(StencilTest) STENCILMASK(VARIATION:6 ; FMT:D24S8)                                                             "),         1,         0, D3DMQA_STENCILTEST_BASE+131 , TuxTest},
{ TEXT("(StencilTest) STENCILMASK(VARIATION:7 ; FMT:D24S8)                                                             "),         1,         0, D3DMQA_STENCILTEST_BASE+132 , TuxTest},
{ TEXT("(StencilTest) STENCILMASK(VARIATION:8 ; FMT:D24S8)                                                             "),         1,         0, D3DMQA_STENCILTEST_BASE+133 , TuxTest},
{ TEXT("(StencilTest) STENCILMASK(VARIATION:9 ; FMT:D24S8)                                                             "),         1,         0, D3DMQA_STENCILTEST_BASE+134 , TuxTest},
{ TEXT("(StencilTest) STENCILMASK(VARIATION:10; FMT:D24S8)                                                             "),         1,         0, D3DMQA_STENCILTEST_BASE+135 , TuxTest},
{ TEXT("(StencilTest) STENCILMASK(VARIATION:1 ; FMT:D24X4S4)                                                           "),         1,         0, D3DMQA_STENCILTEST_BASE+136 , TuxTest},
{ TEXT("(StencilTest) STENCILMASK(VARIATION:2 ; FMT:D24X4S4)                                                           "),         1,         0, D3DMQA_STENCILTEST_BASE+137 , TuxTest},
{ TEXT("(StencilTest) STENCILMASK(VARIATION:3 ; FMT:D24X4S4)                                                           "),         1,         0, D3DMQA_STENCILTEST_BASE+138 , TuxTest},
{ TEXT("(StencilTest) STENCILMASK(VARIATION:4 ; FMT:D24X4S4)                                                           "),         1,         0, D3DMQA_STENCILTEST_BASE+139 , TuxTest},
{ TEXT("(StencilTest) STENCILMASK(VARIATION:5 ; FMT:D24X4S4)                                                           "),         1,         0, D3DMQA_STENCILTEST_BASE+140 , TuxTest},
{ TEXT("(StencilTest) STENCILMASK(VARIATION:6 ; FMT:D24X4S4)                                                           "),         1,         0, D3DMQA_STENCILTEST_BASE+141 , TuxTest},
{ TEXT("(StencilTest) STENCILMASK(VARIATION:7 ; FMT:D24X4S4)                                                           "),         1,         0, D3DMQA_STENCILTEST_BASE+142 , TuxTest},
{ TEXT("(StencilTest) STENCILMASK(VARIATION:8 ; FMT:D24X4S4)                                                           "),         1,         0, D3DMQA_STENCILTEST_BASE+143 , TuxTest},
{ TEXT("(StencilTest) STENCILMASK(VARIATION:9 ; FMT:D24X4S4)                                                           "),         1,         0, D3DMQA_STENCILTEST_BASE+144 , TuxTest},
{ TEXT("(StencilTest) STENCILMASK(VARIATION:10; FMT:D24X4S4)                                                           "),         1,         0, D3DMQA_STENCILTEST_BASE+145 , TuxTest},

{ TEXT("(ResManTest) D3DMRTYPE_VERTEXBUFFER Resource Eviction Test                                                     "),         1,         0,  D3DMQA_RESMANTEST_BASE+  0 , TuxTest},
{ TEXT("(ResManTest) D3DMRTYPE_INDEXBUFFER Resource Eviction Test                                                      "),         1,         0,  D3DMQA_RESMANTEST_BASE+  1 , TuxTest},
{ TEXT("(ResManTest) D3DMRTYPE_TEXTURE Resource Eviction Test                                                          "),         1,         0,  D3DMQA_RESMANTEST_BASE+  2 , TuxTest},

{ NULL,                                                                                                                            0,         0,                           0 , NULL   }
};

//  Processes messages from the TUX shell.
SHELLPROCAPI    ShellProc(UINT, SPPARAM);

// Shell info structure (contains instance handle, window handle, DLL handle, command line args, etc.)
SPS_SHELL_INFO   *g_pShellInfo;

