//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// This source code is licensed under Microsoft Shared Source License
// Version 1.0 for Windows CE.
// For a copy of the license visit http://go.microsoft.com/fwlink/?LinkId=3223.
//
#pragma once

//
// Test IDs for all Direct3D Mobile interface tests
//

#define D3DQAID_IDIRECT3DMOBILE_BASE               0
#define D3DQAID_IDIRECT3DMOBILE_MAX                17

#define D3DQAID_IDIRECT3DMOBILEDEVICE_BASE         100
#define D3DQAID_IDIRECT3DMOBILEDEVICE_MAX          171

#define D3DQAID_IDIRECT3DMOBILEINDEXBUFFER_BASE    200
#define D3DQAID_IDIRECT3DMOBILEINDEXBUFFER_MAX     211

#define D3DQAID_IDIRECT3DMOBILESURFACE_BASE        300
#define D3DQAID_IDIRECT3DMOBILESURFACE_MAX         310

#define D3DQAID_IDIRECT3DMOBILETEXTURE_BASE        400
#define D3DQAID_IDIRECT3DMOBILETEXTURE_MAX         428

#define D3DQAID_IDIRECT3DMOBILEVERTEXBUFFER_BASE   500
#define D3DQAID_IDIRECT3DMOBILEVERTEXBUFFER_MAX    511

// This one gets a separate ordinal because it is likely to cause a hang, and we don't want
// to block the rest of the tests.
#define D3DQAID_IDIRECT3DPSL_BASE                  2000
#define D3DQAID_IDIRECT3DPSL_MAX                   2001

//
// Test IDs for IDirect3DMobile interface tests
//
#define D3DQAID_OBJ_QUERYINTERFACE                     ( 1 + D3DQAID_IDIRECT3DMOBILE_BASE)
#define D3DQAID_OBJ_ADDREF                             ( 2 + D3DQAID_IDIRECT3DMOBILE_BASE)
#define D3DQAID_OBJ_RELEASE                            ( 3 + D3DQAID_IDIRECT3DMOBILE_BASE)
#define D3DQAID_OBJ_REGISTERSOFTWAREDEVICE             ( 4 + D3DQAID_IDIRECT3DMOBILE_BASE)
#define D3DQAID_OBJ_GETADAPTERCOUNT                    ( 5 + D3DQAID_IDIRECT3DMOBILE_BASE)
#define D3DQAID_OBJ_GETADAPTERIDENTIFIER               ( 6 + D3DQAID_IDIRECT3DMOBILE_BASE)
#define D3DQAID_OBJ_GETADAPTERMODECOUNT                ( 7 + D3DQAID_IDIRECT3DMOBILE_BASE)
#define D3DQAID_OBJ_ENUMADAPTERMODES                   ( 8 + D3DQAID_IDIRECT3DMOBILE_BASE)
#define D3DQAID_OBJ_GETADAPTERDISPLAYMODE              ( 9 + D3DQAID_IDIRECT3DMOBILE_BASE)
#define D3DQAID_OBJ_CHECKDEVICETYPE                    (10 + D3DQAID_IDIRECT3DMOBILE_BASE)
#define D3DQAID_OBJ_CHECKDEVICEFORMAT                  (11 + D3DQAID_IDIRECT3DMOBILE_BASE)
#define D3DQAID_OBJ_CHECKDEVICEMULTISAMPLETYPE         (12 + D3DQAID_IDIRECT3DMOBILE_BASE)
#define D3DQAID_OBJ_CHECKDEPTHSTENCILMATCH             (13 + D3DQAID_IDIRECT3DMOBILE_BASE)
#define D3DQAID_OBJ_CHECKPROFILE                       (14 + D3DQAID_IDIRECT3DMOBILE_BASE)
#define D3DQAID_OBJ_GETDEVICECAPS                      (15 + D3DQAID_IDIRECT3DMOBILE_BASE)
#define D3DQAID_OBJ_CREATEDEVICE                       (16 + D3DQAID_IDIRECT3DMOBILE_BASE)
#define D3DQAID_OBJ_CHECKDEVICEFORMATCONVERSION        (17 + D3DQAID_IDIRECT3DMOBILE_BASE)


//
// Test IDs for IDirect3DMobileDevice interface tests
//
#define D3DQAID_DEV_QUERYINTERFACE                     ( 1 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_TESTCOOPERATIVELEVEL               ( 2 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_GETAVAILABLEPOOLMEM                ( 3 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_RESOURCEMANAGERDISCARDBYTES        ( 4 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_GETDIRECT3D                        ( 5 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_GETDEVICECAPS                      ( 6 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_GETDISPLAYMODE                     ( 7 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_GETCREATIONPARAMETERS              ( 8 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_CREATEADDITIONALSWAPCHAIN          (12 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_RESET                              (13 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_PRESENT                            (14 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_GETBACKBUFFER	                   (15 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_CREATETEXTURE                      (16 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_CREATEVERTEXBUFFER                 (17 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_CREATEINDEXBUFFER                  (18 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_CREATERENDERTARGET                 (19 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_CREATEDEPTHSTENCILSURFACE          (20 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_CREATEIMAGESURFACE                 (21 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_COPYRECTS                          (22 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE) 
#define D3DQAID_DEV_UPDATETEXTURE                      (23 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_GETFRONTBUFFER                     (24 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_SETRENDERTARGET                    (25 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_GETRENDERTARGET                    (26 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_GETDEPTHSTENCILSURFACE             (27 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_BEGINSCENE                         (28 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_ENDSCENE                           (29 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_CLEAR                              (30 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_SETTRANSFORM                       (31 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_GETTRANSFORM                       (32 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_SETVIEWPORT                        (33 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_GETVIEWPORT                        (34 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_SETMATERIAL                        (35 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_GETMATERIAL                        (36 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_SETLIGHT                           (37 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_GETLIGHT                           (38 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_LIGHTENABLE                        (39 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_GETLIGHTENABLE                     (40 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_SETRENDERSTATE                     (41 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_GETRENDERSTATE                     (42 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_SETCLIPSTATUS                      (43 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_GETCLIPSTATUS                      (44 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_GETTEXTURE                         (45 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_SETTEXTURE                         (46 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_GETTEXTURESTAGESTATE               (47 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_SETTEXTURESTAGESTATE               (48 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_VALIDATEDEVICE                     (49 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_GETINFO                            (50 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_SETPALETTEENTRIES                  (51 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_GETPALETTEENTRIES                  (52 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_SETCURRENTTEXTUREPALETTE           (53 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_GETCURRENTTEXTUREPALETTE           (54 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_DRAWPRIMITIVE                      (55 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_DRAWINDEXEDPRIMITIVE               (56 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_PROCESSVERTICES                    (57 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_SETSTREAMSOURCE                    (58 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_GETSTREAMSOURCE                    (59 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_SETINDICES                         (60 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_GETINDICES                         (61 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_STRETCHRECT                        (62 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_COLORFILL                          (63 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
// Misc:
#define D3DQAID_DEV_VERIFYAUTOMIPLEVELEXTENTS          (64 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_PRESENTATIONINTERVAL               (65 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_SWAPEFFECTMULTISAMPLEMISMATCH      (66 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_PRESENTFLAGMULTISAMPLEMISMATCH     (67 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_VERIFYBACKBUFLIMITSWAPEFFECTCOPY   (68 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_SWAPCHAINMANIPDURINGRESET          (69 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_COMMANDBUFREFCOUNTING              (70 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
#define D3DQAID_DEV_OBJECTCREATE                       (71 + D3DQAID_IDIRECT3DMOBILEDEVICE_BASE)
// This one gets a separate ordinal because it is likely to cause a hang, and we don't want
// to block the rest of the tests.
#define D3DQAID_DEV_PSLRANDOMIZER                      ( 1 + D3DQAID_IDIRECT3DPSL_BASE)

//
// Test IDs for IDirect3DMobileIndexBuffer interface tests
//
#define D3DQAID_IB_QUERYINTERFACE                      ( 1 + D3DQAID_IDIRECT3DMOBILEINDEXBUFFER_BASE)
#define D3DQAID_IB_ADDREF                              ( 2 + D3DQAID_IDIRECT3DMOBILEINDEXBUFFER_BASE)
#define D3DQAID_IB_RELEASE                             ( 3 + D3DQAID_IDIRECT3DMOBILEINDEXBUFFER_BASE)
#define D3DQAID_IB_GETDEVICE                           ( 4 + D3DQAID_IDIRECT3DMOBILEINDEXBUFFER_BASE)
#define D3DQAID_IB_SETPRIORITY                         ( 5 + D3DQAID_IDIRECT3DMOBILEINDEXBUFFER_BASE)
#define D3DQAID_IB_GETPRIORITY                         ( 6 + D3DQAID_IDIRECT3DMOBILEINDEXBUFFER_BASE)
#define D3DQAID_IB_PRELOAD                             ( 7 + D3DQAID_IDIRECT3DMOBILEINDEXBUFFER_BASE)
#define D3DQAID_IB_GETTYPE                             ( 8 + D3DQAID_IDIRECT3DMOBILEINDEXBUFFER_BASE)
#define D3DQAID_IB_LOCK                                ( 9 + D3DQAID_IDIRECT3DMOBILEINDEXBUFFER_BASE)
#define D3DQAID_IB_UNLOCK                              (10 + D3DQAID_IDIRECT3DMOBILEINDEXBUFFER_BASE)
#define D3DQAID_IB_GETDESC                             (11 + D3DQAID_IDIRECT3DMOBILEINDEXBUFFER_BASE)
   
//
// Test IDs for IDirect3DMobileSurface interface tests
//
#define D3DQAID_SRF_QUERYINTERFACE                     ( 1 + D3DQAID_IDIRECT3DMOBILESURFACE_BASE)
#define D3DQAID_SRF_ADDREF                             ( 2 + D3DQAID_IDIRECT3DMOBILESURFACE_BASE)
#define D3DQAID_SRF_RELEASE                            ( 3 + D3DQAID_IDIRECT3DMOBILESURFACE_BASE)
#define D3DQAID_SRF_GETDEVICE                          ( 4 + D3DQAID_IDIRECT3DMOBILESURFACE_BASE)
#define D3DQAID_SRF_GETCONTAINER                       ( 5 + D3DQAID_IDIRECT3DMOBILESURFACE_BASE)
#define D3DQAID_SRF_GETDESC                            ( 6 + D3DQAID_IDIRECT3DMOBILESURFACE_BASE)
#define D3DQAID_SRF_LOCKRECT                           ( 7 + D3DQAID_IDIRECT3DMOBILESURFACE_BASE)
#define D3DQAID_SRF_UNLOCKRECT                         ( 8 + D3DQAID_IDIRECT3DMOBILESURFACE_BASE)
#define D3DQAID_SRF_GETDC                              ( 9 + D3DQAID_IDIRECT3DMOBILESURFACE_BASE)
#define D3DQAID_SRF_RELEASEDC                          (10 + D3DQAID_IDIRECT3DMOBILESURFACE_BASE)


//
// Test IDs for IDirect3DMobileTexture interface tests
//
#define D3DQAID_TEX_QUERYINTERFACE                     ( 1 + D3DQAID_IDIRECT3DMOBILETEXTURE_BASE)
#define D3DQAID_TEX_ADDREF                             ( 2 + D3DQAID_IDIRECT3DMOBILETEXTURE_BASE)
#define D3DQAID_TEX_RELEASE                            ( 3 + D3DQAID_IDIRECT3DMOBILETEXTURE_BASE)
#define D3DQAID_TEX_GETDEVICE                          ( 4 + D3DQAID_IDIRECT3DMOBILETEXTURE_BASE)
#define D3DQAID_TEX_SETPRIORITY                        ( 5 + D3DQAID_IDIRECT3DMOBILETEXTURE_BASE)
#define D3DQAID_TEX_GETPRIORITY                        ( 6 + D3DQAID_IDIRECT3DMOBILETEXTURE_BASE)
#define D3DQAID_TEX_PRELOAD                            ( 7 + D3DQAID_IDIRECT3DMOBILETEXTURE_BASE)
#define D3DQAID_TEX_GETTYPE                            ( 8 + D3DQAID_IDIRECT3DMOBILETEXTURE_BASE)
#define D3DQAID_TEX_SETLOD                             ( 9 + D3DQAID_IDIRECT3DMOBILETEXTURE_BASE)
#define D3DQAID_TEX_GETLOD                             (10 + D3DQAID_IDIRECT3DMOBILETEXTURE_BASE)
#define D3DQAID_TEX_GETLEVELCOUNT                      (11 + D3DQAID_IDIRECT3DMOBILETEXTURE_BASE)
#define D3DQAID_TEX_GETLEVELDESC                       (12 + D3DQAID_IDIRECT3DMOBILETEXTURE_BASE)
#define D3DQAID_TEX_GETSURFACELEVEL                    (13 + D3DQAID_IDIRECT3DMOBILETEXTURE_BASE)
#define D3DQAID_TEX_LOCKRECT                           (14 + D3DQAID_IDIRECT3DMOBILETEXTURE_BASE)
#define D3DQAID_TEX_UNLOCKRECT                         (15 + D3DQAID_IDIRECT3DMOBILETEXTURE_BASE)
#define D3DQAID_TEX_ADDDIRTYRECT                       (16 + D3DQAID_IDIRECT3DMOBILETEXTURE_BASE)
#define D3DQAID_TEX_SRFQUERYINTERFACE                  (17 + D3DQAID_IDIRECT3DMOBILETEXTURE_BASE)
#define D3DQAID_TEX_SRFADDREF                          (18 + D3DQAID_IDIRECT3DMOBILETEXTURE_BASE)
#define D3DQAID_TEX_SRFRELEASE                         (19 + D3DQAID_IDIRECT3DMOBILETEXTURE_BASE)
#define D3DQAID_TEX_SRFGETDEVICE                       (20 + D3DQAID_IDIRECT3DMOBILETEXTURE_BASE)
#define D3DQAID_TEX_SRFGETCONTAINER                    (21 + D3DQAID_IDIRECT3DMOBILETEXTURE_BASE)
#define D3DQAID_TEX_SRFGETDESC                         (22 + D3DQAID_IDIRECT3DMOBILETEXTURE_BASE)
#define D3DQAID_TEX_SRFLOCKRECT                        (23 + D3DQAID_IDIRECT3DMOBILETEXTURE_BASE)
#define D3DQAID_TEX_SRFUNLOCKRECT                      (24 + D3DQAID_IDIRECT3DMOBILETEXTURE_BASE)
#define D3DQAID_TEX_SRFGETDC                           (25 + D3DQAID_IDIRECT3DMOBILETEXTURE_BASE)
#define D3DQAID_TEX_SRFRELEASEDC                       (26 + D3DQAID_IDIRECT3DMOBILETEXTURE_BASE)
#define D3DQAID_TEX_SRFSTRETCHRECT                     (27 + D3DQAID_IDIRECT3DMOBILETEXTURE_BASE)
#define D3DQAID_TEX_SRFCOLORFILL                       (28 + D3DQAID_IDIRECT3DMOBILETEXTURE_BASE)
   
   
//
// Test IDs for IDirect3DMobileVertexBuffer interface tests
//
#define D3DQAID_VB_QUERYINTERFACE                      ( 1 + D3DQAID_IDIRECT3DMOBILEVERTEXBUFFER_BASE)
#define D3DQAID_VB_ADDREF                              ( 2 + D3DQAID_IDIRECT3DMOBILEVERTEXBUFFER_BASE)
#define D3DQAID_VB_RELEASE                             ( 3 + D3DQAID_IDIRECT3DMOBILEVERTEXBUFFER_BASE)
#define D3DQAID_VB_GETDEVICE                           ( 4 + D3DQAID_IDIRECT3DMOBILEVERTEXBUFFER_BASE)
#define D3DQAID_VB_SETPRIORITY                         ( 5 + D3DQAID_IDIRECT3DMOBILEVERTEXBUFFER_BASE)
#define D3DQAID_VB_GETPRIORITY                         ( 6 + D3DQAID_IDIRECT3DMOBILEVERTEXBUFFER_BASE)
#define D3DQAID_VB_PRELOAD                             ( 7 + D3DQAID_IDIRECT3DMOBILEVERTEXBUFFER_BASE)
#define D3DQAID_VB_GETTYPE                             ( 8 + D3DQAID_IDIRECT3DMOBILEVERTEXBUFFER_BASE)
#define D3DQAID_VB_LOCK                                ( 9 + D3DQAID_IDIRECT3DMOBILEVERTEXBUFFER_BASE)
#define D3DQAID_VB_UNLOCK                              (10 + D3DQAID_IDIRECT3DMOBILEVERTEXBUFFER_BASE)
#define D3DQAID_VB_GETDESC                             (11 + D3DQAID_IDIRECT3DMOBILEVERTEXBUFFER_BASE)
