//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// This source code is licensed under Microsoft Shared Source License
// Version 1.0 for Windows CE.
// For a copy of the license visit http://go.microsoft.com/fwlink/?LinkId=3223.
//
#ifndef __RASCLISRV_H_
#define __RASCLISRV_H_

// Include files

#include <winsock.h>
#include <windows.h>
#include <tchar.h>
#include <stressutils.h>
#include <ras.h>
#include <raserror.h>
#include <tapi.h>
#include <ipexport.h>				 // for ICMP structure and error code definitions
#include <icmpapi.h>							// for declarations of ICMP functions

#include "tapiinfo.h"
#include <unimodem.h>

//
// The following values will be written to the registry so that CEStress
// can pick it up.
//
// The values will be updated in registry after every iteration
//
typedef struct _regReportValues_t
{
	//
	// The following will be collected and maintained by the module
	//
	DWORD dwConnects;
	DWORD dwDisconnects;
	DWORD dwErrors;
	DWORD dwTCPData;
	DWORD dwUDPData;
	DWORD dwICMPPings;

	//
	// The following will be collected from RAS APIs (RasGetLinkStatistics, via RAS_STATS structure)
	//
	DWORD dwBytesXmited;
	DWORD dwBytesRcved;
	DWORD dwFramesXmited;
	DWORD dwFramesRcved;
	DWORD dwCrcErr;
	DWORD dwTimeoutErr;
	DWORD dwAlignmentErr;
	DWORD dwHardwareOverrunErr;
	DWORD dwFramingErr;
	DWORD dwBufferOverrunErr;	
}
RegReportTypes_t;

#define RAS_REPORT_VALUES_REG_KEY_PPP TEXT("COMM\\CESTRESS\\RAS\\PPP")
#define RAS_REPORT_VALUES_REG_KEY_PPTP TEXT("COMM\\CESTRESS\\RAS\\PPTP")
#define RAS_REPORT_VALUES_REG_KEY_L2TP TEXT("COMM\\CESTRESS\\RAS\\L2TP")
#define RAS_REPORT_VALUES_REG_KEY_PPPoE TEXT("COMM\\CESTRESS\\RAS\\PPPoE")

#define CONNECTS_REG L"dwConnects"
#define DISCONNECTS_REG L"dwDisconnects"
#define ERRORS_REG L"dwErrors"
#define TCP_DATA_REG L"dwTCPData"
#define UDP_DATA_REG L"dwUDPData"
#define ICMP_PINGS_REG L"dwIcmpPings"
#define BYTES_XMITTED_REG L"dwBytesXmited"
#define BYTES_RECVD_REG L"dwBytesRcved"
#define FRAMES_XMITED_REG L"dwFramesXmited"
#define FRAMES_RECVD_REG L"dwFramesRcved"
#define CRC_ERR_REG L"dwCrcErr"
#define TIMEOUT_ERR_REG L"dwTimeoutErr"
#define ALIGNMENT_ERR_REG L"dwAlignmentErr"
#define HARDWARE_OVERRUN_ERR_REG L"dwHardwareOverrunErr"
#define FRAMING_ERR_REG L"dwFramingErr"
#define BUFFER_OVERRUN_ERR_REG L"dwBufferOverrunErr"

// Macros etc
#define STABILIZATION_PERIOD	5000

#define RCVSIZE  			1024
#define SENDSIZE   			32

#define	DEFAULT_RETRIES		5
#define ENTRYBUFSIZE     	5000
#define BUFSIZE   			240

#define DEFAULT_PORT		11122

#define MAX_PARAMS			10
#define	MAX_CMD_LINE		256
#define	MAX_PARAM_LENGTH	256
#define	MAX_USER_NAME_PW	64
#define	DEFAULT_PACKET_SIZE 1024

#define DEFAULT_SLEEP		2500

#define DEFAULT_DEVICE_ID	2
#define DEFAULT_BAUDRATE	57600
#define DEFAULT_SENDS		10

#define UNIMODEM_SERIAL_DEVICE   0
#define UNIMODEM_HAYES_DEVICE    1
#define UNIMODEM_PCMCIA_DEVICE   3
#define UNIMODEM_IR_DEVICE       6

#define DEVCAPSSIZE			1024

typedef enum _RASConnection {	RAS_VPN_PPTP, 
								RAS_VPN_L2TP, 
								RAS_DCC_MODEM, 
								RAS_PPP_MODEM, 
								RAS_PPP_PPPoE} RASConnection;

// Function declarations
bool RunConnectStress();
DWORD	NumParams(LPTSTR);
bool GetRasStats();
bool WriteRegValues();
bool InitReportValuesFromReg();
bool DetermineRasLinkToRunStress();
bool CreatePhoneBookEntry();
bool ConnectRasConnection();
bool DisconnectRasConnection();
bool SendData(int);
DWORD GetRasDeviceNum(LPTSTR, DWORD&);
DWORD RasLinkSetBaudrate(LPTSTR, DWORD, BYTE, BYTE, float);
DWORD GetRasDeviceName(LPTSTR, DWORD);
DWORD GetRasDeviceType(LPTSTR, DWORD);
DWORD GetUnimodemDevConfig(LPTSTR, LPVARSTRING);
DWORD GetUnimodemDeviceName(LPTSTR, LPTSTR);
void CALLBACK lineCallbackFunc(DWORD, DWORD,DWORD, DWORD, DWORD, DWORD);
DWORD PingLink(char *, DWORD);
	
#define DEVCONFIGSIZE   684
#define DEVCONFIGOFFSET sizeof(VARSTRING)
#define DEVBUFSIZE      DEVCONFIGSIZE + DEVCONFIGOFFSET

// Global variables
DWORD	dwBaudrate = DEFAULT_BAUDRATE;
DWORD	dwNumSends = DEFAULT_SENDS;
DWORD	dwPacketSize = DEFAULT_PACKET_SIZE;
BOOL	bDataTransfer=FALSE;
RASConnection eRasConnection=RAS_VPN_PPTP;
DWORD	dwDeviceNum;

#define DEFAULT_PPTP_SERVER TEXT("localhost")
#define DEFAULT_USERNAME TEXT("Guest")
#define DEFAULT_PASSWORD TEXT("Guest")
#define DEFAULT_DOMAIN TEXT("")
#define DEFAULT_CE_DOMAIN TEXT("")

TCHAR	strPhoneNum[MAX_USER_NAME_PW+1]=DEFAULT_PPTP_SERVER;
TCHAR	strUserName[UNLEN+1]=DEFAULT_USERNAME;
TCHAR	strPassword[PWLEN+1]=DEFAULT_PASSWORD;
TCHAR	strDomain[DNLEN+1]=DEFAULT_CE_DOMAIN;

TCHAR	strEntryName[MAX_PARAM_LENGTH+1];

const LPTSTR lpszRasError[] =
{
	TEXT("PENDING"),
	TEXT("ERROR_INVALID_PORT_HANDLE"),
	TEXT("ERROR_PORT_ALREADY_OPEN"),
	TEXT("ERROR_BUFFER_TOO_SMALL"),
	TEXT("ERROR_WRONG_INFO_SPECIFIED"),
	TEXT("ERROR_CANNOT_SET_PORT_INFO"),
	TEXT("ERROR_PORT_NOT_CONNECTED"),
	TEXT("ERROR_EVENT_INVALID"),
	TEXT("ERROR_DEVICE_DOES_NOT_EXIST"),
	TEXT("ERROR_DEVICETYPE_DOES_NOT_EXIST"),
	TEXT("ERROR_BUFFER_INVALID"),
	TEXT("ERROR_ROUTE_NOT_AVAILABLE"),
	TEXT("ERROR_ROUTE_NOT_ALLOCATED"),
	TEXT("ERROR_INVALID_COMPRESSION_SPECIFIED"),
	TEXT("ERROR_OUT_OF_BUFFERS"),
	TEXT("ERROR_PORT_NOT_FOUND"),
	TEXT("ERROR_ASYNC_REQUEST_PENDING"),
	TEXT("ERROR_ALREADY_DISCONNECTING"),
	TEXT("ERROR_PORT_NOT_OPEN"),
	TEXT("ERROR_PORT_DISCONNECTED"),
	TEXT("ERROR_NO_ENDPOINTS"),
	TEXT("ERROR_CANNOT_OPEN_PHONEBOOK"),
	TEXT("ERROR_CANNOT_LOAD_PHONEBOOK"),
	TEXT("ERROR_CANNOT_FIND_PHONEBOOK_ENTRY"),
	TEXT("ERROR_CANNOT_WRITE_PHONEBOOK"),
	TEXT("ERROR_CORRUPT_PHONEBOOK"),
	TEXT("ERROR_CANNOT_LOAD_STRING"),
	TEXT("ERROR_KEY_NOT_FOUND"),
	TEXT("ERROR_DISCONNECTION"),
	TEXT("ERROR_REMOTE_DISCONNECTION"),
	TEXT("ERROR_HARDWARE_FAILURE"),
	TEXT("ERROR_USER_DISCONNECTION"),
	TEXT("ERROR_INVALID_SIZE"),
	TEXT("ERROR_PORT_NOT_AVAILABLE"),
	TEXT("ERROR_CANNOT_PROJECT_CLIENT"),
	TEXT("ERROR_UNKNOWN"),
	TEXT("ERROR_WRONG_DEVICE_ATTACHED"),
	TEXT("ERROR_BAD_STRING"),
	TEXT("ERROR_REQUEST_TIMEOUT"),
	TEXT("ERROR_CANNOT_GET_LANA"),
	TEXT("ERROR_NETBIOS_ERROR"),
	TEXT("ERROR_SERVER_OUT_OF_RESOURCES"),
	TEXT("ERROR_NAME_EXISTS_ON_NET"),
	TEXT("ERROR_SERVER_GENERAL_NET_FAILURE"),
	TEXT("WARNING_MSG_ALIAS_NOT_ADDED"),
	TEXT("ERROR_AUTH_INTERNAL"),
	TEXT("ERROR_RESTRICTED_LOGON_HOURS"),
	TEXT("ERROR_ACCT_DISABLED"),
	TEXT("ERROR_PASSWD_EXPIRED"),
	TEXT("ERROR_NO_DIALIN_PERMISSION"),
	TEXT("ERROR_SERVER_NOT_RESPONDING"),
	TEXT("ERROR_FROM_DEVICE"),
	TEXT("ERROR_UNRECOGNIZED_RESPONSE"),
	TEXT("ERROR_MACRO_NOT_FOUND"),
	TEXT("ERROR_MACRO_NOT_DEFINED"),
	TEXT("ERROR_MESSAGE_MACRO_NOT_FOUND"),
	TEXT("ERROR_DEFAULTOFF_MACRO_NOT_FOUND"),
	TEXT("ERROR_FILE_COULD_NOT_BE_OPENED"),
	TEXT("ERROR_DEVICENAME_TOO_LONG"),
	TEXT("ERROR_DEVICENAME_NOT_FOUND"),
	TEXT("ERROR_NO_RESPONSES"),
	TEXT("ERROR_NO_COMMAND_FOUND"),
	TEXT("ERROR_WRONG_KEY_SPECIFIED"),
	TEXT("ERROR_UNKNOWN_DEVICE_TYPE"),
	TEXT("ERROR_ALLOCATING_MEMORY"),
	TEXT("ERROR_PORT_NOT_CONFIGURED"),
	TEXT("ERROR_DEVICE_NOT_READY"),
	TEXT("ERROR_READING_INI_FILE"),
	TEXT("ERROR_NO_CONNECTION"),
	TEXT("ERROR_BAD_USAGE_IN_INI_FILE"),
	TEXT("ERROR_READING_SECTIONNAME"),
	TEXT("ERROR_READING_DEVICETYPE"),
	TEXT("ERROR_READING_DEVICENAME"),
	TEXT("ERROR_READING_USAGE"),
	TEXT("ERROR_READING_MAXCONNECTBPS"),
	TEXT("ERROR_READING_MAXCARRIERBPS"),
	TEXT("ERROR_LINE_BUSY"),
	TEXT("ERROR_VOICE_ANSWER"),
	TEXT("ERROR_NO_ANSWER"),
	TEXT("ERROR_NO_CARRIER"),
	TEXT("ERROR_NO_DIALTONE"),
	TEXT("ERROR_IN_COMMAND"),
	TEXT("ERROR_WRITING_SECTIONNAME"),
	TEXT("ERROR_WRITING_DEVICETYPE"),
	TEXT("ERROR_WRITING_DEVICENAME"),
	TEXT("ERROR_WRITING_MAXCONNECTBPS"),
	TEXT("ERROR_WRITING_MAXCARRIERBPS"),
	TEXT("ERROR_WRITING_USAGE"),
	TEXT("ERROR_WRITING_DEFAULTOFF"),
	TEXT("ERROR_READING_DEFAULTOFF"),
	TEXT("ERROR_EMPTY_INI_FILE"),
	TEXT("ERROR_AUTHENTICATION_FAILURE"),
	TEXT("ERROR_PORT_OR_DEVICE"),
	TEXT("ERROR_NOT_BINARY_MACRO"),
	TEXT("ERROR_DCB_NOT_FOUND"),
	TEXT("ERROR_STATE_MACHINES_NOT_STARTED"),
	TEXT("ERROR_STATE_MACHINES_ALREADY_STARTED"),
	TEXT("ERROR_PARTIAL_RESPONSE_LOOPING"),
	TEXT("ERROR_UNKNOWN_RESPONSE_KEY"),
	TEXT("ERROR_RECV_BUF_FULL"),
	TEXT("ERROR_CMD_TOO_LONG"),
	TEXT("ERROR_UNSUPPORTED_BPS"),
	TEXT("ERROR_UNEXPECTED_RESPONSE"),
	TEXT("ERROR_INTERACTIVE_MODE"),
	TEXT("ERROR_BAD_CALLBACK_NUMBER"),
	TEXT("ERROR_INVALID_AUTH_STATE"),
	TEXT("ERROR_WRITING_INITBPS"),
	TEXT("ERROR_X25_DIAGNOSTIC"),
	TEXT("ERROR_ACCT_EXPIRED"),
	TEXT("ERROR_CHANGING_PASSWORD"),
	TEXT("ERROR_OVERRUN"),
	TEXT("ERROR_RASMAN_CANNOT_INITIALIZE"),
	TEXT("ERROR_BIPLEX_PORT_NOT_AVAILABLE"),
	TEXT("ERROR_NO_ACTIVE_ISDN_LINES"),
	TEXT("ERROR_NO_ISDN_CHANNELS_AVAILABLE"),
	TEXT("ERROR_TOO_MANY_LINE_ERRORS"),
	TEXT("ERROR_IP_CONFIGURATION"),
	TEXT("ERROR_NO_IP_ADDRESSES"),
	TEXT("ERROR_PPP_TIMEOUT"),
	TEXT("ERROR_PPP_REMOTE_TERMINATED"),
	TEXT("ERROR_PPP_NO_PROTOCOLS_CONFIGURED"),
	TEXT("ERROR_PPP_NO_RESPONSE"),
	TEXT("ERROR_PPP_INVALID_PACKET"),
	TEXT("ERROR_PHONE_NUMBER_TOO_LONG"),
	TEXT("ERROR_IPXCP_NO_DIALOUT_CONFIGURED"),
	TEXT("ERROR_IPXCP_NO_DIALIN_CONFIGURED"),
	TEXT("ERROR_IPXCP_DIALOUT_ALREADY_ACTIVE"),
	TEXT("ERROR_ACCESSING_TCPCFGDLL"),
	TEXT("ERROR_NO_IP_RAS_ADAPTER"),
	TEXT("ERROR_SLIP_REQUIRES_IP"),
	TEXT("ERROR_PROJECTION_NOT_COMPLETE"),
	TEXT("ERROR_PROTOCOL_NOT_CONFIGURED"),
	TEXT("ERROR_PPP_NOT_CONVERGING"),
	TEXT("ERROR_PPP_CP_REJECTED"),
	TEXT("ERROR_PPP_LCP_TERMINATED"),
	TEXT("ERROR_PPP_REQUIRED_ADDRESS_REJECTED"),
	TEXT("ERROR_PPP_NCP_TERMINATED"),
	TEXT("ERROR_PPP_LOOPBACK_DETECTED"),
	TEXT("ERROR_PPP_NO_ADDRESS_ASSIGNED"),
	TEXT("ERROR_CANNOT_USE_LOGON_CREDENTIALS"),
	TEXT("ERROR_TAPI_CONFIGURATION"),
	TEXT("ERROR_NO_LOCAL_ENCRYPTION"),
	TEXT("ERROR_NO_REMOTE_ENCRYPTION"),
	TEXT("ERROR_REMOTE_REQUIRES_ENCRYPTION"),
	TEXT("ERROR_IPXCP_NET_NUMBER_CONFLICT"),
	TEXT("ERROR_INVALID_SMM"),
	TEXT("ERROR_SMM_UNINITIALIZED"),
	TEXT("ERROR_NO_MAC_FOR_PORT"),
	TEXT("ERROR_SMM_TIMEOUT"),
	TEXT("ERROR_BAD_PHONE_NUMBER"),
	TEXT("ERROR_WRONG_MODULE"),
	TEXT("ERROR_PPP_MAC"),
	TEXT("ERROR_PPP_LCP"),
	TEXT("ERROR_PPP_AUTH"),
	TEXT("ERROR_PPP_NCP"),
	TEXT("ERROR_POWER_OFF"),
	TEXT("ERROR_POWER_OFF_CD")
};

#endif
