//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft shared
// source or premium shared source license agreement under which you licensed
// this source code. If you did not accept the terms of the license agreement,
// you are not authorized to use this source code. For the terms of the license,
// please see the license agreement between you and Microsoft or, if applicable,
// see the SOURCE.RTF on your install media or the root of your tools installation.
// THE SOURCE CODE IS PROVIDED "AS IS", WITH NO WARRANTIES OR INDEMNITIES.
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
// PARTICULAR PURPOSE.
//
// Copyright 1998-2004  Microsoft Corporation.  All Rights Reserved.
//
// Module Name:
//
//     kbddef.h
// 
// Abstract:
// 
//  This file contains the declaration of the keybard mapping related definition
//

#pragma once

#define KEYSTATE_TOGGLEBIT  0x0001      // bit set when key is toggled

//
// Define keyboards that we want to test and other
// information so we can find/match them in the OS
// image.
//
// To add a keyboard for testing, add its HKL to
// the below list of defines, then add the individual
// test key sequences to a new KBDTests_XXX structure
// above.  Lastly, add the keyboard information as a
// new record to the TestKeyboards[] structure.
//

#define KEYBOARD_NOTESTDATA 0xFFFF

#define HKL_KBD_JAPANESE1  ((HKL) 0xE0010411)
#define HKL_KBD_JAPANESE2  ((HKL) 0xE0020404)

#ifdef UNDER_CE
#define HKL_KBD_US_QWERTY  ((HKL) 0x00000409)
#define HKL_KBD_US_DVORAK  ((HKL) 0x00010409)   // PS #68371
#define HKL_KBD_FRENCH     ((HKL) 0x0000040C)   // French (france) keyboard
#define HKL_KBD_KOREAN     ((HKL) 0x00000412)
#define HKL_KBD_HINDI      ((HKL) 0x00010439)   // Hindi Traditional
#define HKL_KBD_HEBREW     ((HKL) 0x0000040D)   // Hebrew
#define HKL_KBD_GUJARATI   ((HKL) 0x00000447)   // Gujarati
#define HKL_KBD_TAMIL      ((HKL) 0x00000449)   // Tamil
#define HKL_KBD_KANNADA    ((HKL) 0x0000044B)   // Kannada
#define HKL_KBD_MARATHI    ((HKL) 0x0000044E)   // Marath
#define HKL_KBD_PUNJABI    ((HKL) 0x00000446)   // Punjab
#define HKL_KBD_TELUGU     ((HKL) 0x0000044A)   // Telugu
#define HKL_KBD_ARABIC     ((HKL) 0x00000401)   // Saudi Arabia (101)
#define HKL_KBD_ARABIC_102 ((HKL) 0x00010401)   // Saudi Arabia (102)
#define HKL_KBD_THAI       ((HKL) 0x0000041E)   // Thai Kedmanee
#else
#define HKL_KBD_US_QWERTY  ((HKL) 0x04090409)   // diff on XP
#define HKL_KBD_US_DVORAK  ((HKL) 0xF0020409)
#define HKL_KBD_FRENCH     ((HKL) 0x040C040C)
#define HKL_KBD_KOREAN     ((HKL) 0x04120412)
#define HKL_KBD_HINDI      ((HKL) 0xF00C0439)
#define HKL_KBD_GUJARATI   ((HKL) 0x04470447)
#define HKL_KBD_TAMIL      ((HKL) 0x04490449)
#define HKL_KBD_KANNADA    ((HKL) 0x044B044B)
#define HKL_KBD_MARATHI    ((HKL) 0x044B044E)
#define HKL_KBD_PUNJABI    ((HKL) 0x04460446)
#define HKL_KBD_TELUGU     ((HKL) 0x044A044A)
#define HKL_KBD_HEBREW     ((HKL) 0x040D040D)
#define HKL_KBD_ARABIC     ((HKL) 0x04010401)
#define HKL_KBD_ARABIC_102 ((HKL) 0xF0280401)
#define HKL_KBD_THAI       ((HKL) 0x041E041E)
#endif

//
// This is the maximum number of keystrokes required
// to produce a character.  This includes the number
// of deadkeys to press but *not* the number of state
// keys.  
//
// number of VK_KEYs required to create a WM_CHAR.
// MAX_SEQUENCE_LENGTH must fit within the bits defined
// by STATE_NUMMASK as part of KEYBOARDSTATE.
//

#define MAX_SEQUENCE_LENGTH        4
#define MAX_NUM_GEN_CHARS          4 // Max possible amount of chars generated by keystroke, it could be only 2
// It must be greater or equal than testSequence.nNumUnicodeChars
//
// Keyboard states - pressing one of these keys
// causes the keyboard to change states when used
// for some keyboard layouts.
//

#define STATE_CAPSLOCK      0x10
#define STATE_SHIFT         0x40
#define STATE_ALTRIGHT      0x80
#define STATE_ALTLEFT       0x80
#define STATE_ALL           (STATE_CAPSLOCK & STATE_SHIFT & STATE_ALTRIGHT & STATE_ALTLEFT)

//
// structure of a single key test.  Includes the
// VK_KEYS, expected unicode codepoint, keyboard
// states to turn on etc..etc..
//

#define STATE_STATEMASK     0xF0        // hi-byte is key states
#define STATE_NUMMASK       0x0F        // low byte is number of keys

typedef WORD KEYBOARDSTATE;

//
// Define a single test sequence as well as a test
// keyboard
//

typedef struct
{
    KEYBOARDSTATE nNumVirtualKeys;
    BYTE byaVirtualKeys[MAX_SEQUENCE_LENGTH];
    INT nNumUnicodeChars;
    WCHAR wcaUnicodeChars[MAX_NUM_GEN_CHARS];
} testSequence;

typedef struct
{
    HKL InputLocale;
    testSequence *pKeyMaps;
    WORD numKeyMaps;
} testKeyboard;

struct keyinfo
{
    UINT8 Vkey;
    UINT16 Scancode;
    UINT8 kbd;

};
