//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft shared
// source or premium shared source license agreement under which you licensed
// this source code. If you did not accept the terms of the license agreement,
// you are not authorized to use this source code. For the terms of the license,
// please see the license agreement between you and Microsoft or, if applicable,
// see the SOURCE.RTF on your install media or the root of your tools installation.
// THE SOURCE CODE IS PROVIDED "AS IS", WITH NO WARRANTIES OR INDEMNITIES.
//

#pragma warning(disable:4007) // 'DllMain' : must be '__stdcall'
#pragma warning(disable:4995) // disable "banned API" warning

#ifdef _M_IX86
#define HELPERFNAPI __stdcall
#define CALLTYPE __thiscall
#else
#define HELPERFNAPI __cdecl
#define CALLTYPE __cdecl
#endif

extern "C" {
void HELPERFNAPI
#if defined(_M_IX86)
_CxxThrowException
#else
__CxxThrowException
#endif
(void*, _ThrowInfo*) {}

void * __RTCastToVoid(void * p) { return 0; }
void * __RTDynamicCast(void * p, long, void *, void *, int) { return 0; }
void * __RTtypeid(void * p) { return 0; }
int _purecall(void) { return 0; }
}

namespace std
{
class exception
{
public: exception(exception const &);
public: exception(char const *);
public: exception(void);
public: exception & operator=(exception const &e);
public: virtual ~exception(void);
public: virtual char const * what(void)const;
};
exception::exception(exception const &) {}
exception::exception(char const *) {}
exception::exception(void) {}
exception & exception::operator=(exception const &e) { return *this; }
exception::~exception(void) {}
char const * exception::what(void)const { return 0; }

struct nothrow_t {};
extern const nothrow_t nothrow;
const nothrow_t nothrow;

void terminate(void) {}
bool uncaught_exception(void) { return false; }
void unexpected(void) {}
void (*set_terminate(void (*)(void)))(void) { return 0; }
void (*set_unexpected(void (*)(void)))(void) { return 0; }
void _Nomemory(void) {}
void _Xlen(void) {}
void _Xran(void) {}
};

class type_info
{
private: type_info(class type_info const &);
private: type_info & operator=(type_info const &t);
public: virtual ~type_info(void);
public: int operator==(class type_info const &t)const;
public: int operator!=(class type_info const &t)const;
public: char const * type_info::name(void)const;
public: char const * type_info::raw_name(void)const;
public: int before(class type_info const &)const;
};
type_info::type_info(class type_info const &) {}
type_info & type_info::operator=(type_info const &t) { return *this; }
type_info::~type_info(void) {}
int type_info::operator==(class type_info const &t)const { return 0; }
int type_info::operator!=(class type_info const &t)const { return 0; }
char const * type_info::name(void)const { return 0; }
char const * type_info::raw_name(void)const { return 0; }
int type_info::before(class type_info const &)const { return 0; }

void * operator new(unsigned int) { return 0; }
void * operator new(unsigned int,struct std::nothrow_t const &) { return 0; }
void operator delete(void *) {}
void operator delete(void *,struct std::nothrow_t const &) {}
void * operator new[](unsigned int) { return 0; }
void * operator new[](unsigned int,struct std::nothrow_t const &) { return 0; }
void operator delete[](void *) {}
void operator delete[](void *,struct std::nothrow_t const &) {}

void (*__set_inconsistency(void (*)(void)))(void) { return 0; }
void _inconsistency(void) {}
int (*_query_new_handler(void))(unsigned int) { return 0; }
int (*_set_new_handler(int (*)(unsigned int)))(unsigned int) { return 0; }
int _query_new_mode(void) { return 0; }
int _set_new_mode(int) { return 0; }
void (*set_new_handler(void (*)(void)))(void) { return 0; }

void HELPERFNAPI __ehvec_dtor        (void *,       unsigned int,int,void (CALLTYPE*)(void *       )                         ) {}
void HELPERFNAPI __ehvec_ctor        (void *,       unsigned int,int,void (CALLTYPE*)(void *       ),void (CALLTYPE*)(void *)) {}
void HELPERFNAPI __ehvec_ctor_vb     (void *,       unsigned int,int,void (CALLTYPE*)(void *       ),void (CALLTYPE*)(void *)) {}
void HELPERFNAPI __ehvec_copy_ctor   (void *,void *,unsigned int,int,void (CALLTYPE*)(void *,void *),void (CALLTYPE*)(void *)) {}
void HELPERFNAPI __ehvec_copy_ctor_vb(void *,void *,unsigned int,int,void (CALLTYPE*)(void *,void *),void (CALLTYPE*)(void *)) {}

#define DUMMY(fn) \
    extern "C" void* fn(void * d, const void * s, size_t n) { return d; }

DUMMY(DllMain)
DUMMY(_CountLeadingOnes)
DUMMY(_CountLeadingOnes64)
DUMMY(_CountLeadingSigns)
DUMMY(_CountLeadingSigns64)
DUMMY(_CountLeadingZeros)
DUMMY(_CountLeadingZeros64)
DUMMY(_CountOneBits)
DUMMY(_CountOneBits64)
DUMMY(_HUGE)
DUMMY(_InitStdioLib)
DUMMY(_MulHigh)
DUMMY(_MulUnsignedHigh)
DUMMY(_XcptFilter)
DUMMY(__C_specific_handler)
DUMMY(__CxxFrameHandler)
DUMMY(__CxxFrameHandler3)
DUMMY(__report_gsfailure)
DUMMY(__security_gen_cookie)
DUMMY(__security_gen_cookie2)
DUMMY(__security_gen_cookie_cgr)
DUMMY(__strgtold12)
DUMMY(_abs64)
DUMMY(_atodbl)
DUMMY(_atoflt)
DUMMY(_atoi64)
DUMMY(bsearch)
DUMMY(bsearch_s)
DUMMY(_byteswap_uint64)
DUMMY(_byteswap_ulong)
DUMMY(_byteswap_ushort)
DUMMY(_cabs)
DUMMY(_chgsign)
DUMMY(_clearfp)
DUMMY(_controlfp)
DUMMY(_controlfp_s)
DUMMY(_copysign)
DUMMY(_ecvt)
DUMMY(_ecvt_s)
DUMMY(_fcloseall)
DUMMY(_fcvt)
DUMMY(_fcvt_s)
DUMMY(_fileno)
DUMMY(_finite)
DUMMY(_fltused)
DUMMY(_flushall)
DUMMY(_fpclass)
DUMMY(_fpieee_flt)
DUMMY(_fpreset)
DUMMY(_frnd)
DUMMY(_fsqrt)
DUMMY(_gcvt)
DUMMY(_gcvt_s)
DUMMY(_get_invalid_parameter_handler)
DUMMY(_get_printf_count_output)
DUMMY(_getstdfilex)
DUMMY(_getws)
DUMMY(_getws_s)
DUMMY(_hypot)
DUMMY(_invalid_parameter)
DUMMY(_isctype)
DUMMY(_isnan)
DUMMY(_isnanf)
DUMMY(_isunordered)
DUMMY(_isunorderedf)
DUMMY(_itoa)
DUMMY(_itoa_s)
DUMMY(_itow)
DUMMY(_itow_s)
DUMMY(_j0)
DUMMY(_j1)
DUMMY(_jn)
DUMMY(_ld12tod)
DUMMY(_ld12tof)
DUMMY(_logb)
DUMMY(_lrotl)
DUMMY(_lrotr)
DUMMY(_ltoa)
DUMMY(_ltoa_s)
DUMMY(_ltow)
DUMMY(_ltow_s)
DUMMY(_memccpy)
DUMMY(_memicmp)
DUMMY(_msize)
DUMMY(_nextafter)
DUMMY(_putws)
DUMMY(_recalloc)
DUMMY(_rotl)
DUMMY(_rotl64)
DUMMY(_rotr)
DUMMY(_rotr64)
DUMMY(_scalb)
DUMMY(_scprintf)
DUMMY(_scwprintf)
DUMMY(_set_invalid_parameter_handler)
DUMMY(_set_printf_count_output)
DUMMY(_setmode)
DUMMY(_snprintf)
DUMMY(_snprintf_s)
DUMMY(_snwprintf)
DUMMY(_snwprintf_s)
DUMMY(_statusfp)
DUMMY(_strdup)
DUMMY(_stricmp)
DUMMY(_strtoi64)
DUMMY(_strtoui64)
DUMMY(_strlwr)
DUMMY(_strlwr_s)
DUMMY(_strnicmp)
DUMMY(_strnset)
DUMMY(_strnset_s)
DUMMY(_strrev)
DUMMY(_strset)
DUMMY(_strset_s)
DUMMY(_strupr)
DUMMY(_strupr_s)
DUMMY(_swab)
DUMMY(_ultoa)
DUMMY(_ultoa_s)
DUMMY(_ultow)
DUMMY(_ultow_s)
DUMMY(_vscprintf)
DUMMY(_vscwprintf)
DUMMY(_vsnprintf)
DUMMY(_vsnprintf_s)
DUMMY(_vsnwprintf)
DUMMY(_vsnwprintf_s)
DUMMY(_wcsdup)
DUMMY(_wcsicmp)
DUMMY(_wcslwr)
DUMMY(_wcslwr_s)
DUMMY(_wcsnicmp)
DUMMY(_wcsnset)
DUMMY(_wcsnset_s)
DUMMY(_wcsrev)
DUMMY(_wcsset)
DUMMY(_wcsset_s)
DUMMY(_wcstoi64)
DUMMY(_wcstoui64)
DUMMY(_wcsupr)
DUMMY(_wcsupr_s)
DUMMY(_wfdopen)
DUMMY(_wfopen)
DUMMY(_wfopen_s)
DUMMY(_wfreopen)
DUMMY(_wfreopen_s)
DUMMY(_wtoi)
DUMMY(_wtoi64)
DUMMY(_wtof)
DUMMY(_wtol)
DUMMY(_y0)
DUMMY(_y1)
DUMMY(_yn)
DUMMY(abs)
DUMMY(acos)
DUMMY(asin)
DUMMY(atan)
DUMMY(atan2)
DUMMY(atof)
DUMMY(atoi)
DUMMY(atol)
DUMMY(calloc)
DUMMY(ceil)
DUMMY(ceilf)
DUMMY(clearerr)
DUMMY(clearerr_s)
DUMMY(cos)
DUMMY(cosh)
DUMMY(difftime)
DUMMY(div)
DUMMY(exp)
DUMMY(fabs)
DUMMY(fabsf)
DUMMY(fclose)
DUMMY(feof)
DUMMY(ferror)
DUMMY(fflush)
DUMMY(fgetc)
DUMMY(fgetpos)
DUMMY(fgets)
DUMMY(fgetwc)
DUMMY(fgetws)
DUMMY(floor)
DUMMY(floorf)
DUMMY(fmod)
DUMMY(fmodf)
DUMMY(fopen)
DUMMY(fopen_s)
DUMMY(fprintf)
DUMMY(fprintf_s)
DUMMY(fputc)
DUMMY(fputs)
DUMMY(fputwc)
DUMMY(fputws)
DUMMY(fread)
DUMMY(fread_s)
DUMMY(free)
DUMMY(frexp)
DUMMY(fscanf)
DUMMY(fscanf_s)
DUMMY(fseek)
DUMMY(fsetpos)
DUMMY(ftell)
DUMMY(fwprintf)
DUMMY(fwprintf_s)
DUMMY(fwrite)
DUMMY(fwscanf)
DUMMY(fwscanf_s)
DUMMY(getchar)
DUMMY(gets)
DUMMY(gets_s)
DUMMY(getwchar)
DUMMY(iswctype)
DUMMY(labs)
DUMMY(ldexp)
DUMMY(ldiv)
DUMMY(log)
DUMMY(log10)
DUMMY(longjmp)
DUMMY(malloc)
DUMMY(mbstowcs)
DUMMY(mbstowcs_s)
DUMMY(memchr)
DUMMY(memcmp)
DUMMY(memcpy)
DUMMY(memcpy_s)
DUMMY(memmove)
DUMMY(memmove_s)
DUMMY(memset)
DUMMY(modf)
DUMMY(pow)
DUMMY(printf)
DUMMY(printf_s)
DUMMY(putchar)
DUMMY(puts)
DUMMY(putwchar)
DUMMY(qsort)
DUMMY(qsort_s)
DUMMY(rand)
DUMMY(rand_s)
DUMMY(realloc)
DUMMY(scanf)
DUMMY(scanf_s)
DUMMY(setvbuf)
DUMMY(sin)
DUMMY(sinh)
DUMMY(sprintf)
DUMMY(sprintf_s)
DUMMY(sqrt)
DUMMY(sqrtf)
DUMMY(srand)
DUMMY(sscanf)
DUMMY(sscanf_s)
DUMMY(strcat)
DUMMY(strcat_s)
DUMMY(strchr)
DUMMY(strcmp)
DUMMY(strcpy)
DUMMY(strcpy_s)
DUMMY(strcspn)
DUMMY(strlen)
DUMMY(strncat)
DUMMY(strncat_s)
DUMMY(strncmp)
DUMMY(strncpy)
DUMMY(strncpy_s)
DUMMY(strnlen)
DUMMY(strpbrk)
DUMMY(strrchr)
DUMMY(strspn)
DUMMY(strstr)
DUMMY(strtod)
DUMMY(strtok)
DUMMY(strtok_s)
DUMMY(strtol)
DUMMY(strtoul)
DUMMY(swprintf)
DUMMY(swprintf_s)
DUMMY(swscanf)
DUMMY(swscanf_s)
DUMMY(tan)
DUMMY(tanh)
DUMMY(tolower)
DUMMY(toupper)
DUMMY(towlower)
DUMMY(towupper)
DUMMY(ungetc)
DUMMY(ungetwc)
DUMMY(vfprintf)
DUMMY(vfprintf_s)
DUMMY(vfwprintf)
DUMMY(vfwprintf_s)
DUMMY(vprintf)
DUMMY(vprintf_s)
DUMMY(vsprintf)
DUMMY(vsprintf_s)
DUMMY(vswprintf)
DUMMY(vswprintf_s)
DUMMY(vwprintf)
DUMMY(vwprintf_s)
DUMMY(wcscat)
DUMMY(wcscat_s)
DUMMY(wcschr)
DUMMY(wcscmp)
DUMMY(wcscpy)
DUMMY(wcscpy_s)
DUMMY(wcscspn)
DUMMY(wcslen)
DUMMY(wcsncat)
DUMMY(wcsncat_s)
DUMMY(wcsncmp)
DUMMY(wcsncpy)
DUMMY(wcsncpy_s)
DUMMY(wcsnlen)
DUMMY(wcspbrk)
DUMMY(wcsrchr)
DUMMY(wcsspn)
DUMMY(wcsstr)
DUMMY(wcstod)
DUMMY(wcstok)
DUMMY(wcstok_s)
DUMMY(wcstol)
DUMMY(wcstombs)
DUMMY(wcstombs_s)
DUMMY(wcstoul)
DUMMY(wprintf)
DUMMY(wprintf_s)
DUMMY(wscanf)
DUMMY(wscanf_s)

#if defined(_M_ARM)

DUMMY(__addd)
DUMMY(__adds)
DUMMY(__divd)
DUMMY(__divs)
DUMMY(__dtoi)
DUMMY(__dtoi64)
DUMMY(__dtos)
DUMMY(__dtou)
DUMMY(__dtou64)
DUMMY(__eqd)
DUMMY(__eqs)
DUMMY(__ged)
DUMMY(__ges)
DUMMY(__gtd)
DUMMY(__gts)
DUMMY(__i64tod)
DUMMY(__i64tos)
DUMMY(__itod)
DUMMY(__itos)
DUMMY(__led)
DUMMY(__les)
DUMMY(__ltd)
DUMMY(__lts)
DUMMY(__muld)
DUMMY(__muls)
DUMMY(__ned)
DUMMY(__negd)
DUMMY(__negs)
DUMMY(__nes)
DUMMY(__rt_sdiv)
DUMMY(__rt_sdiv10)
DUMMY(__rt_sdiv64by64)
DUMMY(__rt_srem64by64)
DUMMY(__rt_srsh)
DUMMY(__rt_udiv)
DUMMY(__rt_udiv10)
DUMMY(__rt_udiv64by64)
DUMMY(__rt_urem64by64)
DUMMY(__rt_ursh)
DUMMY(__stod)
DUMMY(__stoi)
DUMMY(__stoi64)
DUMMY(__stou)
DUMMY(__stou64)
DUMMY(__subd)
DUMMY(__subs)
DUMMY(__u64tod)
DUMMY(__u64tos)
DUMMY(__utod)
DUMMY(__utos)
DUMMY(_mbmemset)
DUMMY(setjmp)

#elif defined(_M_IX86)

DUMMY(_CIacos)
DUMMY(_CIasin)
DUMMY(_CIatan)
DUMMY(_CIatan2)
DUMMY(_CIcos)
DUMMY(_CIcosh)
DUMMY(_CIexp)
DUMMY(_CIfmod)
DUMMY(_CIlog)
DUMMY(_CIlog10)
DUMMY(_CIpow)
DUMMY(_CIsin)
DUMMY(_CIsinh)
DUMMY(_CIsqrt)
DUMMY(_CItan)
DUMMY(_CItanh)
DUMMY(_EH_prolog)
DUMMY(_EH_prolog2)
DUMMY(_SEH_epilog)
DUMMY(_SEH_prolog)
DUMMY(__abnormal_termination)
DUMMY(_alldiv)
DUMMY(_alldvrm)
DUMMY(_allmul)
DUMMY(_alloca_probe)
DUMMY(_alloca_probe_16)
DUMMY(_alloca_probe_8)
DUMMY(_allrem)
DUMMY(_allshl)
DUMMY(_allshr)
DUMMY(_aulldiv)
DUMMY(_aulldvrm)
DUMMY(_aullrem)
DUMMY(_aullshr)
DUMMY(_chkstk)
DUMMY(_except_handler3)
DUMMY(_except_handler4_common)
DUMMY(_fload)
DUMMY(_ftol)
DUMMY(_ftol2)
DUMMY(_ftol2_sse)
DUMMY(_ftol2_sse_excpt)
DUMMY(_local_unwind2)
DUMMY(_local_unwind4)
DUMMY(_setjmp3)

extern "C" {
char _inp;
char _inpd;
char _inpw;
char _outp;
char _outpd;
char _outpw;
}

#elif defined(_M_MRX000)

DUMMY(_RtlCheckStack)
DUMMY(__d_to_ll)
DUMMY(__d_to_ull)
DUMMY(__dpadd)
DUMMY(__dpcmp)
DUMMY(__dpdiv)
DUMMY(__dpmul)
DUMMY(__dpsub)
DUMMY(__dptofp)
DUMMY(__dptoli)
DUMMY(__dptoul)
DUMMY(__eqd)
DUMMY(__eqs)
DUMMY(__f_to_ll)
DUMMY(__f_to_ull)
DUMMY(__fpadd)
DUMMY(__fpcmp)
DUMMY(__fpdiv)
DUMMY(__fpmul)
DUMMY(__fpsub)
DUMMY(__fptodp)
DUMMY(__fptoli)
DUMMY(__fptoul)
DUMMY(__ged)
DUMMY(__ges)
DUMMY(__gtd)
DUMMY(__gts)
DUMMY(__led)
DUMMY(__les)
DUMMY(__litodp)
DUMMY(__litofp)
DUMMY(__ll_bit_extract)
DUMMY(__ll_bit_insert)
DUMMY(__ll_div)
DUMMY(__ll_lshift)
DUMMY(__ll_mul)
DUMMY(__ll_rem)
DUMMY(__ll_rshift)
DUMMY(__ll_to_d)
DUMMY(__ll_to_f)
DUMMY(__ltd)
DUMMY(__lts)
DUMMY(__ned)
DUMMY(__nes)
DUMMY(__ull_bit_extract)
DUMMY(__ull_bit_insert)
DUMMY(__ull_div)
DUMMY(__ull_rem)
DUMMY(__ull_rshift)
DUMMY(__ull_to_d)
DUMMY(__ull_to_f)
DUMMY(__ultodp)
DUMMY(__ultofp)

#elif defined(_M_SH)

DUMMY(_addd)
DUMMY(_addi64)
DUMMY(_adds)
DUMMY(_addui64)
DUMMY(_bandi64)
DUMMY(_bcompi64)
DUMMY(_bori64)
DUMMY(_bxori64)
DUMMY(_divd)
DUMMY(_divi64)
DUMMY(_divls)
DUMMY(_divlu)
DUMMY(_divs)
DUMMY(_divui64)
DUMMY(_dtoi)
DUMMY(_dtoi64)
DUMMY(_dtos)
DUMMY(_dtou)
DUMMY(_dtoui64)
DUMMY(_eqd)
DUMMY(_eqi64)
DUMMY(_eqs)
DUMMY(_ged)
DUMMY(_gei64)
DUMMY(_ges)
DUMMY(_geui64)
DUMMY(_gtd)
DUMMY(_gti64)
DUMMY(_gts)
DUMMY(_gtui64)
DUMMY(_i64fetch)
DUMMY(_i64store)
DUMMY(_i64tod)
DUMMY(_i64toi)
DUMMY(_i64tos)
DUMMY(_i64toui)
DUMMY(_itod)
DUMMY(_itoi64)
DUMMY(_itos)
DUMMY(_itoui64)
DUMMY(_led)
DUMMY(_lei64)
DUMMY(_les)
DUMMY(_leui64)
DUMMY(_lshi16eq)
DUMMY(_lshi32)
DUMMY(_lshi32eq)
DUMMY(_lshi64)
DUMMY(_lshi8eq)
DUMMY(_ltd)
DUMMY(_lti64)
DUMMY(_lts)
DUMMY(_ltui64)
DUMMY(_modi64)
DUMMY(_modls)
DUMMY(_modlu)
DUMMY(_modui64)
DUMMY(_muld)
DUMMY(_muli64)
DUMMY(_muls)
DUMMY(_mului64)
DUMMY(_ned)
DUMMY(_negd)
DUMMY(_negi64)
DUMMY(_negs)
DUMMY(_nei64)
DUMMY(_nes)
DUMMY(_noti64)
DUMMY(_poai64)
DUMMY(_poaui64)
DUMMY(_posi64)
DUMMY(_posui64)
DUMMY(_rshi16eq)
DUMMY(_rshi32)
DUMMY(_rshi32eq)
DUMMY(_rshi64)
DUMMY(_rshi8eq)
DUMMY(_rshui16eq)
DUMMY(_rshui32)
DUMMY(_rshui32eq)
DUMMY(_rshui64)
DUMMY(_rshui8eq)
DUMMY(_stod)
DUMMY(_stoi)
DUMMY(_stoi64)
DUMMY(_stou)
DUMMY(_stoui64)
DUMMY(_subd)
DUMMY(_subi64)
DUMMY(_subs)
DUMMY(_subui64)
DUMMY(_ui64fetch)
DUMMY(_ui64tod)
DUMMY(_ui64toi)
DUMMY(_ui64tos)
DUMMY(_ui64toui)
DUMMY(_uitoi64)
DUMMY(_uitoui64)
DUMMY(_utod)
DUMMY(_utos)

#endif

