//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft shared
// source or premium shared source license agreement under which you licensed
// this source code. If you did not accept the terms of the license agreement,
// you are not authorized to use this source code. For the terms of the license,
// please see the license agreement between you and Microsoft or, if applicable,
// see the SOURCE.RTF on your install media or the root of your tools installation.
// THE SOURCE CODE IS PROVIDED "AS IS", WITH NO WARRANTIES.
//
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
// PARTICULAR PURPOSE.
//
// Copyright  1998-2004  Microsoft Corporation.  All Rights Reserved.
//
// Module Name:
//
//   testSequence.cpp  
// 
// Abstract:
// 
//   This file contains the test procdures for each key mapping.  The tests
//   prove VK_KEY to WM_CHAR unicode mappings.
//
// Authors:
//  unknown     unknown
//  11/24/04    chetl   added support for multiple states, testing all keyboards in an image.
//  12/01/04    chetl   added support for many Intl keyboards, expanded key sequences.
//

#include <windows.h>

#include "testSequences.h"
#include "keyengin.h"
#include "TuxMain.h"

#define countof(x) (sizeof(x)/sizeof(x[0]))


#define KEYSTATE_TOGGLEBIT  0x0001      // bit set when key is toggled

// 
// Define individual tests for a given keyboard
//
// See InputLang.h for a more detailed discussion of keyboard/input language basics.
// Alt-Gr key must be simulated as two keystrokes in order to work.  For example:
// {3, {VK_CONTROL, VK_MENU, 0x32}, 0x20AA}   // Alt+Gr + '4' key
//
// Keyboards should start and end from their base state.  Ie expect CAPS lock to be
// turned off etc.  KEYVIEW2 in Chapter 6 of Petzold's Programming Windows book can
// be used to see what VK_KEYs generate WM_CHARS for different keyboards on XP/NT.
//


// ****************************************************
// US English DVORAK keyboard 
//
//  Num  VK1   VK2	  Num	Unicode
testSequence KBDTests_USDVORAK[] =
{
	{1,	{0x20, 0x00}, 1,	0x20},		// ' '
    {2,	{0x10, 0x51}, 1,	0x44},      // 'D'
    {2,	{0x10, 0x57}, 1,	0x56},      // 'V'
	{2,	{0x10, 0x45}, 1,	0x4F},      // 'O'
    {2,	{0x10, 0x54}, 1,	0x52},      // 'R'

    {1,	{0x50, 0x00}, 1,	0x64},      // 'd'
};


// ****************************************************
// US English QWERTY keyboard 
//
//  Num  VK1   VK2	  Num	Unicode
testSequence KBDTests_USEnglish[] = 
{
	{1,	{0x20, 0x00}, 1,	0x20},		// ' '
	{2,	{0x10, 0x31}, 1,	0x21},		// '!'  PS #60468 on SMDK
	{2,	{0x10, 0xDE}, 1,	0x22},		// '"'
	{2,	{0x10, 0x33}, 1,	0x23},      // '#'
    {2,	{0x10, 0x34}, 1,	0x24},      // '$'
    {2,	{0x10, 0x35}, 1,	0x25},      // '%'
    {2,	{0x10, 0x37}, 1,	0x26},      // '&'
    {1,	{0xDE, 0x00}, 1,	0x27},      // '''
    {2,	{0x10, 0x39}, 1,	0x28},      // '('
    {2,	{0x10, 0x30}, 1,	0x29},      // ')'
    {2,	{0x10, 0x38}, 1,	0x2A},	    // '*'
    {2,	{0x10, 0xBB}, 1,	0x2B},      // '+'
    {1,	{0xBC, 0x00}, 1,	0x2C},      // ','
    {1,	{0xBD, 0x00}, 1,	0x2D},      // '-'
    {1,	{0xBE, 0x00}, 1,	0x2E},      // '.'
    {1,	{0xBF, 0x00}, 1,	0X2F},      // '/'
	{1,	{0x30, 0x00}, 1,	0x30},      // '0'
    {1,	{0x31, 0x00}, 1,	0x31},      // '1'
    {1,	{0x32, 0x00}, 1,	0x32},      // '2'
    {1,	{0x33, 0x00}, 1,	0X33},      // '3'
	{1,	{0x34, 0x00}, 1,	0x34},      // '4'
    {1,	{0x35, 0x00}, 1,	0x35},      // '5'
    {1,	{0x36, 0x00}, 1,	0x36},      // '6'
    {1,	{0x37, 0x00}, 1,	0X37},      // '7'
	{1,	{0x38, 0x00}, 1,	0x38},      // '8'
    {1,	{0x39, 0x00}, 1,	0X39},      // '9'
	{2, {0x10, 0xBA}, 1,	0X3A},      // ':'
    {1, {0xBA, 0x00}, 1,	0X3B},      // ';'
    {2, {0x10, 0xBC}, 1,	0X3C},      // '<'
    {1, {0xBB, 0x00}, 1,	0X3D},      // '='
    {2, {0x10, 0xBE}, 1,	0X3E},      // '>'
    {2, {0x10, 0xBF}, 1,	0X3F},      // '?'
	{2,	{0x10, 0x41}, 1,	0x41},      // 'A'
    {2,	{0x10, 0x42}, 1,	0x42},      // 'B'
    {2,	{0x10, 0x43}, 1,	0x43},      // 'C'
    {2,	{0x10, 0x44}, 1,	0x44},      // 'D'
	{2,	{0x10, 0x45}, 1,	0x45},      // 'E'
    {2,	{0x10, 0x46}, 1,	0x46},      // 'F'
    {2,	{0x10, 0x47}, 1,	0x47},      // 'G'
    {2,	{0x10, 0x48}, 1,	0x48},      // 'H'
	{2,	{0x10, 0x49}, 1,	0x49},      // 'I'
    {2,	{0x10, 0x4A}, 1,	0x4A},      // 'J'
	{2,	{0x10, 0x4B}, 1,	0x4B},      // 'K'
    {2,	{0x10, 0x4C}, 1,	0x4C},      // 'L'
    {2,	{0x10, 0x4D}, 1,	0x4D},      // 'M'
    {2,	{0x10, 0x4E}, 1,	0x4E},      // 'N'
	{2,	{0x10, 0x4F}, 1,	0x4F},      // 'O'
    {2,	{0x10, 0x50}, 1,	0x50},      // 'P'
    {2,	{0x10, 0x51}, 1,	0x51},      // 'Q'
    {2,	{0x10, 0x52}, 1,	0x52},      // 'R'
	{2,	{0x10, 0x53}, 1,	0x53},      // 'S'
    {2,	{0x10, 0x54}, 1,	0x54},      // 'T'
	{2,	{0x10, 0x55}, 1,	0x55},      // 'U'
    {2,	{0x10, 0x56}, 1,	0x56},      // 'V'
    {2,	{0x10, 0x57}, 1,	0x57},      // 'W'
    {2,	{0x10, 0x58}, 1,	0x58},      // 'X'
	{2,	{0x10, 0x59}, 1,	0x59},      // 'Y'
    {2,	{0x10, 0x5A}, 1,	0x5A},      // 'Z'
    {1, {0xDB, 0x00}, 1,	0X5B},      // '['
    {1, {0xDC, 0x00}, 1,	0X5C},      // '\'
    {1, {0xDD, 0x00}, 1,	0X5D},      // ']'
    {2, {0x10, 0x36}, 1,	0X5E},      // '^'
    {2, {0x10, 0xBD}, 1,	0X5F},      // '_'
    {1, {0xC0, 0x00}, 1,	0X60},      // '`'
    {1,	{0x41, 0x00}, 1,	0x61},      // 'a'
    {1,	{0x42, 0x00}, 1,	0x62},      // 'b'
    {1,	{0x43, 0x00}, 1,	0x63},      // 'c'
    {1,	{0x44, 0x00}, 1,	0x64},      // 'd'
	{1,	{0x45, 0x00}, 1,	0x65},      // 'e'
    {1,	{0x46, 0x00}, 1,	0x66},      // 'f'
    {1,	{0x47, 0x00}, 1,	0x67},      // 'g'
    {1,	{0x48, 0x00}, 1,	0x68},      // 'h'
	{1,	{0x49, 0x00}, 1,	0x69},      // 'i'
    {1,	{0x4A, 0x00}, 1,	0x6A},      // 'j'
	{1,	{0x4B, 0x00}, 1,	0x6B},      // 'k'
    {1,	{0x4C, 0x00}, 1,	0x6C},      // 'l'
    {1,	{0x4D, 0x00}, 1,	0x6D},      // 'm'
    {1,	{0x4E, 0x00}, 1,	0x6E},      // 'n'
	{1,	{0x4F, 0x00}, 1,	0x6F},      // 'o'
    {1,	{0x50, 0x00}, 1,	0x70},      // 'p'
    {1,	{0x51, 0x00}, 1,	0x71},      // 'q'
    {1,	{0x52, 0x00}, 1,	0x72},      // 'r'
	{1,	{0x53, 0x00}, 1,	0x73},      // 's'
    {1,	{0x54, 0x00}, 1,	0x74},      // 't'
	{1,	{0x55, 0x00}, 1,	0x75},      // 'u'
    {1,	{0x56, 0x00}, 1,	0x76},      // 'v'
    {1,	{0x57, 0x00}, 1,	0x77},      // 'w'
    {1,	{0x58, 0x00}, 1,	0x78},      // 'x'
	{1,	{0x59, 0x00}, 1,	0x79},      // 'y'
    {1,	{0x5A, 0x00}, 1,	0x7A},      // 'z'
	{2, {0x10, 0xDB}, 1,	0X7B},      // '{'
    {2, {0x10, 0xDC}, 1,	0X7C},      // '|'
    {2, {0x10, 0xDD}, 1,	0X7D},      // '}'
    {2, {0x10, 0xC0}, 1,	0X7E},      // '~'

// Control chars with CAPSLOCK OFF
// Row ZXCVBNM 
 	{2, {0x11, 90 }, 1, 0x1A },          // Ctrl Z
	{2, {0x11, 88 }, 1,  0x18 },			// Ctrl X
	{2, {0x11, 67 }, 1,  0x03 },			// Ctrl C
	{2, {0x11, 86 }, 1,  0x16 },			// Ctrl V
	{2, {0x11, 66 }, 1,  0x02 },			// Ctrl B
    {2, {0x11, 78 }, 1,  0x0E },			// Ctrl N
	{2, {0x11, 77 }, 1,  0x0D},			// Ctrl M
//Row ASDFG
	{2, {0x11, 65 }, 1, 0x01 },			// Ctrl A
	{2, {0x11, 83 }, 1, 0x13 },			// Ctrl S
	{2, {0x11, 68 }, 1, 0x04 },			// Ctrl D
	{2, {0x11, 70 }, 1, 0x06 },			// Ctrl F
	{2, {0x11, 71 }, 1, 0x07 },			// Ctrl G
    {2, {0x11, 72 }, 1, 0x08 },			// Ctrl H
	{2, {0x11, 74 }, 1, 0x0A },			// Ctrl J
	{2, {0x11, 75 }, 1, 0x0B },			// Ctrl K
	{2, {0x11, 76 }, 1, 0x0C },			// Ctrl L
// Row QWERTY
	{2, {0x11, 81 }, 1, 0x11 },			// Ctrl Q
	{2, {0x11, 87 }, 1, 0x17 },			// Ctrl W
	{2, {0x11, 69 }, 1, 0x05 },			// Ctrl E
	{2, {0x11, 82 }, 1, 0x12 },			// Ctrl R
	{2, {0x11, 84 }, 1, 0x14 },			// Ctrl T
	{2, {0x11, 89 }, 1, 0x19 },			// Ctrl Y
	{2, {0x11, 85 }, 1, 0x15 },			// Ctrl U
	{2, {0x11, 73 }, 1, 0x09 },			// Ctrl I
	{2, {0x11, 79 }, 1, 0x0F },			// Ctrl O
	{2, {0x11, 80 }, 1, 0x10 },			// Ctrl P



//Turn CAPSLOCK ON
    {STATE_CAPSLOCK, {0x10, 0x14 }, 0,  0},

	
// With CAPS ON 

	{1,	{0x20, 0x00}, 1,	0x20},		// ' '
	{2,	{0x10, 0x31}, 1,	0x21},		// '!'  PS #59965
	{2,	{0x10, 0xDE}, 1,	0x22},		// '"'
	{2,	{0x10, 0x33}, 1,	0x23},      // '#'
    {2,	{0x10, 0x34}, 1,	0x24},      // '$'
    {2,	{0x10, 0x35}, 1,	0x25},      // '%'
    {2,	{0x10, 0x37}, 1,	0x26},      // '&'
    {1,	{0xDE, 0x00}, 1,	0x27},      // '''
    {2,	{0x10, 0x39}, 1,	0x28},      // '('
    {2,	{0x10, 0x30}, 1,	0x29},      // ')'
    {2,	{0x10, 0x38}, 1,	0x2A},	    // '*'
    {2,	{0x10, 0xBB}, 1,	0x2B},      // '+'
    {1,	{0xBC, 0x00}, 1,	0x2C},      // ','
    {1,	{0xBD, 0x00}, 1,	0x2D},      // '-'
    {1,	{0xBE, 0x00}, 1,	0x2E},      // '.'
    {1,	{0xBF, 0x00}, 1,	0X2F},      // '/'
	{1,	{0x30, 0x00}, 1,	0x30},      // '0'
    {1,	{0x31, 0x00}, 1,	0x31},      // '1'
    {1,	{0x32, 0x00}, 1,	0x32},      // '2'
    {1,	{0x33, 0x00}, 1,	0X33},      // '3'
	{1,	{0x34, 0x00}, 1,	0x34},      // '4'
    {1,	{0x35, 0x00}, 1,	0x35},      // '5'
    {1,	{0x36, 0x00}, 1,	0x36},      // '6'
    {1,	{0x37, 0x00}, 1,	0X37},      // '7'
	{1,	{0x38, 0x00}, 1,	0x38},      // '8'
    {1,	{0x39, 0x00}, 1,	0X39},      // '9'
	{2, {0x10, 0xBA}, 1,	0X3A},      // ':'
    {1, {0xBA, 0x00}, 1,	0X3B},      // ';'
    {2, {0x10, 0xBC}, 1,	0X3C},      // '<'
    {1, {0xBB, 0x00}, 1,	0X3D},      // '='
    {2, {0x10, 0xBE}, 1,	0X3E},      // '>'
    {2, {0x10, 0xBF}, 1,	0X3F},      // '?'
	{2,	{0x10, 0x41}, 1,	0x61},      // 'a'  CAPS+shift = unshifted
    {2,	{0x10, 0x42}, 1,	0x62},      // 'b'  PS #59965
    {2,	{0x10, 0x43}, 1,	0x63},      // 'c'
    {2,	{0x10, 0x44}, 1,	0x64},      // 'd'
	{2,	{0x10, 0x45}, 1,	0x65},      // 'e'
    {2,	{0x10, 0x46}, 1,	0x66},      // 'f'
    {2,	{0x10, 0x47}, 1,	0x67},      // 'g'
    {2,	{0x10, 0x48}, 1,	0x68},      // 'h'
	{2,	{0x10, 0x49}, 1,	0x69},      // 'i'
    {2,	{0x10, 0x4A}, 1,	0x6A},      // 'j'
	{2,	{0x10, 0x4B}, 1,	0x6B},      // 'k'
    {2,	{0x10, 0x4C}, 1,	0x6C},      // 'l'
    {2,	{0x10, 0x4D}, 1,	0x6D},      // 'm'
    {2,	{0x10, 0x4E}, 1,	0x6E},      // 'n'
	{2,	{0x10, 0x4F}, 1,	0x6F},      // 'o'
    {2,	{0x10, 0x50}, 1,	0x70},      // 'p'
    {2,	{0x10, 0x51}, 1,	0x71},      // 'q'
    {2,	{0x10, 0x52}, 1,	0x72},      // 'r'
	{2,	{0x10, 0x53}, 1,	0x73},      // 's'
    {2,	{0x10, 0x54}, 1,	0x74},      // 't'
	{2,	{0x10, 0x55}, 1,	0x75},      // 'u'
    {2,	{0x10, 0x56}, 1,	0x76},      // 'v'
    {2,	{0x10, 0x57}, 1,	0x77},      // 'w'
    {2,	{0x10, 0x58}, 1,	0x78},      // 'x'
	{2,	{0x10, 0x59}, 1,	0x79},      // 'y'
    {2,	{0x10, 0x5A}, 1,	0x7A},      // 'z'
    {1, {0xDB, 0x00}, 1,	0X5B},      // '['
    {1, {0xDC, 0x00}, 1,	0X5C},      // '\'
    {1, {0xDD, 0x00}, 1,	0X5D},      // ']'
    {2, {0x10, 0x36}, 1,	0X5E},      // '^'
    {2, {0x10, 0xBD}, 1,	0X5F},      // '_'
    {1, {0xC0, 0x00}, 1,	0X60},      // '`'
    {1,	{0x41, 0x00}, 1,	0x41},      // 'A'
    {1,	{0x42, 0x00}, 1,	0x42},      // 'B'
    {1,	{0x43, 0x00}, 1,	0x43},      // 'C'
    {1,	{0x44, 0x00}, 1,	0x44},      // 'D'
	{1,	{0x45, 0x00}, 1,	0x45},      // 'E'
    {1,	{0x46, 0x00}, 1,	0x46},      // 'F'
    {1,	{0x47, 0x00}, 1,	0x47},      // 'G'
    {1,	{0x48, 0x00}, 1,	0x48},      // 'H'
	{1,	{0x49, 0x00}, 1,	0x49},      // 'I'
    {1,	{0x4A, 0x00}, 1,	0x4A},      // 'J'
	{1,	{0x4B, 0x00}, 1,	0x4B},      // 'K'
    {1,	{0x4C, 0x00}, 1,	0x4C},      // 'L'
    {1,	{0x4D, 0x00}, 1,	0x4D},      // 'M'
    {1,	{0x4E, 0x00}, 1,	0x4E},      // 'N'
	{1,	{0x4F, 0x00}, 1,	0x4F},      // 'O'
    {1,	{0x50, 0x00}, 1,	0x50},      // 'P'
    {1,	{0x51, 0x00}, 1,	0x51},      // 'Q'
    {1,	{0x52, 0x00}, 1,	0x52},      // 'R'
	{1,	{0x53, 0x00}, 1,	0x53},      // 'S'
    {1,	{0x54, 0x00}, 1,	0x54},      // 'T'
	{1,	{0x55, 0x00}, 1,	0x55},      // 'U'
    {1,	{0x56, 0x00}, 1,	0x56},      // 'V'
    {1,	{0x57, 0x00}, 1,	0x57},      // 'W'
    {1,	{0x58, 0x00}, 1,	0x58},      // 'X'
	{1,	{0x59, 0x00}, 1,	0x59},      // 'Y'
    {1,	{0x5A, 0x00}, 1,	0x5A},      // 'Z'
	{2, {0x10, 0xDB}, 1,	0X7B},      // '{'
    {2, {0x10, 0xDC}, 1,	0X7C},      // '|'
    {2, {0x10, 0xDD}, 1,	0X7D},      // '}'
    {2, {0x10, 0xC0}, 1,	0X7E},      // '~'
	{1, {13,   0   }, 1,	13  },      // ENTER
	{1, {27,   0   }, 1,	27 },       // Escape key

// Control chars  with CAPSLOCK on
// Row ZXCVBNM 
 	{2, {0x11, 90 }, 1, 0x1A },
	{2, {0x11, 88 }, 1, 0x18 },
	{2, {0x11, 67 }, 1, 0x03 },
	{2, {0x11, 86 }, 1, 0x16 },
	{2, {0x11, 66 }, 1, 0x02 },
    {2, {0x11, 78 }, 1, 0x0E },
	{2, {0x11, 77 }, 1, 0x0D},
//Row ASDFG
	{2, {0x11, 65 }, 1, 0x01 },
	{2, {0x11, 83 }, 1, 0x13 },
	{2, {0x11, 68 }, 1, 0x04 },
	{2, {0x11, 70 }, 1, 0x06 },
	{2, {0x11, 71 }, 1, 0x07 },
    {2, {0x11, 72 }, 1, 0x08 },
	{2, {0x11, 74 }, 1, 0x0A },
	{2, {0x11, 75 }, 1, 0x0B },
	{2, {0x11, 76 }, 1, 0x0C },
// Row QWERTY
	{2, {0x11, 81 }, 1, 0x11 },
	{2, {0x11, 87 }, 1, 0x17 },
	{2, {0x11, 69 }, 1, 0x05 },
	{2, {0x11, 82 }, 1, 0x12 },
	{2, {0x11, 84 }, 1, 0x14 },
	{2, {0x11, 89 }, 1, 0x19 },
	{2, {0x11, 85 }, 1, 0x15 },
	{2, {0x11, 73 }, 1, 0x09 },
	{2, {0x11, 79 }, 1, 0x0F },
	{2, {0x11, 80 }, 1, 0x10 },

//Turn CAPSLOCK OFF
    {STATE_CAPSLOCK, {0x10, 0x14 }, 0,  0},
};  // end US Keyboard


// ****************************************************
// Japanese keyboard
//
//  Num  VK1   VK2		Unicode
testSequence KBDTests_Japanese1[] = 
{
	{1, { 49 ,0}, 1, '1'},
	{1, { 50, 0}, 1, '2'},
	{1, { 51, 0}, 1, '3'},
	{1, { 52 ,0}, 1, '4'},
	{1, { 53 ,0}, 1, '5'},
	{1, { 54, 0}, 1, '6'},
	{1, { 55, 0}, 1, '7'},
	{1, { 56, 0}, 1, '8'},
	{1, { 57, 0}, 1, '9'},
	{1, { 48, 0}, 1, '0'},
	{1, {189, 0}, 1, '-'},
	{1, {187, 0}, 1, '^'},

	{2, {0x10, 49}, 1, '!'},
	{2, {0x10, 50}, 1, '\"'},
	{2, {0x10, 51}, 1, '#'},
	{2, {0x10, 52}, 1, '$'},
	{2, {0x10, 53}, 1, '%'},
	{2, {0x10, 54}, 1, '&'},
	{2, {0x10, 55}, 1, '\''},
	{2, {0x10, 56}, 1, '('},
	{2, {0x10, 57}, 1, ')'},
	{2, {0x10, 48}, 1, '~'}, // Bug 154413 - Windows CE .NET
	{2, {0x10, 189},1, '='},
	{2, {0x10, 187},1, '_'}, // Bug 154412 - Windows CE .NET
    {1, { 8,  0 },  1,  8 },

	{1, { 9,  0 }, 1,  9},
	{1, { 81, 0 }, 1, 'q'},
	{1, { 87, 0 }, 1, 'w'},
	{1, { 69, 0 }, 1, 'e'},
	{1, { 82, 0 }, 1, 'r'},
	{1, { 84, 0 }, 1, 't'},
	{1, { 89,  0}, 1, 'y'},
	{1, { 85,  0}, 1, 'u'},
	{1, { 73,  0}, 1, 'i'},
	{1, { 79,  0}, 1, 'o'},
	{1, { 80,  0}, 1, 'p'},
	{1, {192,  0}, 1, '@'},
	{1, {219,  0}, 1, '['},
    {1, {221,  0}, 1, ']'},

	{2, {0x10,  9 }, 1,   9},
	{2, {0x10, 81 }, 1, 'Q'},
	{2, {0x10, 87 }, 1, 'W'},
	{2, {0x10, 69 }, 1, 'E'},
	{2, {0x10, 82 }, 1, 'R'},
	{2, {0x10, 84 }, 1, 'T'},
	{2, {0x10, 89 }, 1, 'Y'},
	{2, {0x10, 85 }, 1, 'U'},
	{2, {0x10, 73 }, 1, 'I'},
	{2, {0x10, 79 }, 1, 'O'},
	{2, {0x10, 80 }, 1, 'P'},
	{2, {0x10,192 }, 1, '`'},
	{2, {0x10,219 }, 1, '{'},
    {2, {0x10,221 }, 1, '}'},

	{1, { 65 , 0 }, 1, 'a' },
	{1, { 83 , 0 }, 1, 's' },
	{1, { 68 , 0 }, 1, 'd' },
	{1, { 70 , 0 }, 1, 'f' },
	{1, { 71 , 0 }, 1, 'g' },
    {1, { 72 , 0 }, 1, 'h' },
	{1, { 74 , 0 }, 1, 'j' },
	{1, { 75 , 0 }, 1, 'k' },
	{1, { 76 , 0 }, 1, 'l' },
	{1, { 186 , 0}, 1, ';' },
	{1, { 222 , 0}, 1, ':' },
	{1, { 13 ,  0}, 1, 13  },      // ENTER

	{2, { 0x10, 65 }, 1, 'A' },
	{2, { 0x10, 83 }, 1, 'S' },
	{2, { 0x10, 68 }, 1, 'D' },
	{2, { 0x10, 70 }, 1, 'F' },
	{2, { 0x10, 71 }, 1, 'G' },
    {2, { 0x10, 72 }, 1, 'H' },
	{2, { 0x10, 74 }, 1, 'J' },
	{2, { 0x10, 75 }, 1, 'K' },
	{2, { 0x10, 76 }, 1, 'L' },
	{2, { 0x10,186 }, 1, '+' },
	{2, { 0x10,222 }, 1, '*' },
	{2, { 0x10, 13 }, 1, 13  },


	{1, {  90, 0 }, 1, 'z' },
	{1, {  88, 0 }, 1, 'x' },
	{1, {  67, 0 }, 1, 'c' },
	{1, {  86, 0 }, 1, 'v' },
	{1, {  66, 0 }, 1, 'b' },
    {1, {  78, 0 }, 1, 'n' },
	{1, {  77, 0 }, 1, 'm' },
	{1, { 188 , 0}, 1, ',' },
	{1, { 190 , 0}, 1, '.' },
	{1, { 191 , 0}, 1, '/' },


	{2, { 0x10, 90 }, 1, 'Z' },
	{2, { 0x10, 88 }, 1, 'X' },
	{2, { 0x10, 67 }, 1, 'C' },
	{2, { 0x10, 86 }, 1, 'V' },
	{2, { 0x10, 66 }, 1, 'B' },
    {2, { 0x10, 78 }, 1, 'N' },
	{2, { 0x10, 77 }, 1, 'M' },
	{2, { 0x10, 188}, 1, '<' },
	{2, { 0x10, 190}, 1, '>' },
	{2, { 0x10, 191}, 1, '?' },

    {1, {0x1B,   0 }, 1, 0x1B},
	{1, { 226,   0 }, 1, '\\'}, // \ key
	{2, { 0x10, 226}, 1, '_' },
	{2, { 0x10, 220}, 1, '|' },

  // Control chars
// Row ZXCVBNM 
 	{2, { 0x11, 90 }, 1,  0x1A },
	{2, { 0x11, 88 }, 1,  0x18 },
	{2, { 0x11, 67 }, 1,  0x03 },
	{2, { 0x11, 86 }, 1,  0x16 },
	{2, { 0x11, 66 }, 1,  0x02 },
    {2, { 0x11, 78 }, 1,  0x0E },
	{2, { 0x11, 77 }, 1,  0x0D},
//Row ASDFG
	{2, { 0x11, 65 }, 1, 0x01 },
	{2, { 0x11, 83 }, 1, 0x13 },
	{2, { 0x11, 68 }, 1, 0x04 },
	{2, { 0x11, 70 }, 1, 0x06 },
	{2, { 0x11, 71 }, 1, 0x07 },
    {2, { 0x11, 72 }, 1, 0x08 },
	{2, { 0x11, 74 }, 1, 0x0A },
	{2, { 0x11, 75 }, 1, 0x0B },
	{2, { 0x11, 76 }, 1, 0x0C },
// Row QWERTY
	{2, {0x11, 81 }, 1, 0x11 },
	{2, {0x11, 87 }, 1, 0x17 },
	{2, {0x11, 69 }, 1, 0x05 },
	{2, {0x11, 82 }, 1, 0x12 },
	{2, {0x11, 84 }, 1, 0x14 },
	{2, {0x11, 89 }, 1, 0x19 },
	{2, {0x11, 85 }, 1, 0x15 },
	{2, {0x11, 73 }, 1, 0x09 },
	{2, {0x11, 79 }, 1, 0x0F },
	{2, {0x11, 80 }, 1, 0x10 },
  
// CAPSLOCK
    {STATE_CAPSLOCK, {0x10, 0x14 }, 0, 0 },
	
	{1, { 49 ,0}, 1, '1'},
	{1, { 50, 0}, 1, '2'},
	{1, { 51, 0}, 1, '3'},
	{1, { 52 ,0}, 1, '4'},
	{1, { 53 ,0}, 1, '5'},
	{1, { 54, 0}, 1, '6'},
	{1, { 55, 0}, 1, '7'},
	{1, { 56, 0}, 1, '8'},
	{1, { 57, 0}, 1, '9'},
	{1, { 48, 0}, 1, '0'},
	{1, {189, 0}, 1, '-'},
	{1, {187, 0}, 1, '^'},

	{2, {0x10, 49 }, 1, '!' },
	{2, {0x10, 50 }, 1, '\"'},
	{2, {0x10, 51 }, 1, '#' },
	{2, {0x10, 52 }, 1, '$' },
	{2, {0x10, 53 }, 1, '%' },
	{2, {0x10, 54 }, 1, '&' },
	{2, {0x10, 55 }, 1, '\''},
	{2, {0x10, 56 }, 1, '(' },
	{2, {0x10, 57 }, 1, ')' },
	{2, {0x10, 48 }, 1, '~' },
	{2, {0x10, 189}, 1, '=' },
    {1, {8,    0  }, 1,   8 },


	{1, { 9,  0 }, 1,  9 },
	{1, { 81, 0 }, 1, 'Q'},
	{1, { 87, 0 }, 1, 'W'},
	{1, { 69, 0 }, 1, 'E'},
	{1, { 82, 0 }, 1, 'R'},
	{1, { 84, 0 }, 1, 'T'},
	{1, { 89,  0}, 1, 'Y'},
	{1, { 85,  0}, 1, 'U'},
	{1, { 73,  0}, 1, 'I'},
	{1, { 79,  0}, 1, 'O'},
	{1, { 80,  0}, 1, 'P'},
	{1, {192,  0}, 1, '@'},
	{1, {219,  0}, 1, '['},
    {1, {221,  0}, 1, ']'},
	

	{2, {0x10,  9 }, 1,   9},
	{2, {0x10, 81 }, 1, 'q'},
	{2, {0x10, 87 }, 1, 'w'},
	{2, {0x10, 69 }, 1, 'e'},
	{2, {0x10, 82 }, 1, 'r'},
	{2, {0x10, 84 }, 1, 't'},
	{2, {0x10, 89 }, 1, 'y'},
	{2, {0x10, 85 }, 1, 'u'},
	{2, {0x10, 73 }, 1, 'i'},
	{2, {0x10, 79 }, 1, 'o'},
	{2, {0x10, 80 }, 1, 'p'},
	{2, {0x10,192 }, 1, '`'},
	{2, {0x10,219 }, 1, '{'},
    {2, {0x10,221 }, 1, '}'},  

	{1, {  90, 0 }, 1, 'Z' },
	{1, {  88, 0 }, 1, 'X' },
	{1, {  67, 0 }, 1, 'C' },
	{1, {  86, 0 }, 1, 'V' },
	{1, {  66, 0 }, 1, 'B' },
    {1, {  78, 0 }, 1, 'N' },
	{1, {  77, 0 }, 1, 'M' },

	{2, { 0x10, 90 }, 1, 'z' },
	{2, { 0x10, 88 }, 1, 'x' },
	{2, { 0x10, 67 }, 1, 'c' },
	{2, { 0x10, 86 }, 1, 'v' },
	{2, { 0x10, 66 }, 1, 'b' },
    {2, { 0x10, 78 }, 1, 'n' },
	{2, { 0x10, 77 }, 1, 'm' },
	{2, { 0x10, 188}, 1, '<' },
	{2, { 0x10, 190}, 1, '>' },
	{2, { 0x10, 191}, 1, '?' },

	{1, { 65 , 0 }, 1, 'A' },
	{1, { 83 , 0 }, 1, 'S' },
	{1, { 68 , 0 }, 1, 'D' },
	{1, { 70 , 0 }, 1, 'F' },
	{1, { 71 , 0 }, 1, 'G' },
    {1, { 72 , 0 }, 1, 'H' },
	{1, { 74 , 0 }, 1, 'J' },
	{1, { 75 , 0 }, 1, 'K' },
	{1, { 76 , 0 }, 1, 'L' },
	{1, { 186 , 0}, 1, ';' },
	{1, { 222 , 0}, 1, ':' },
	{1, { 13 ,  0}, 1, 13  },      // ENTER

	{2, { 0x10, 65 }, 1,'a'  },
	{2, { 0x10, 83 }, 1, 's' },
	{2, { 0x10, 68 }, 1, 'd' },
	{2, { 0x10, 70 }, 1, 'f' },
	{2, { 0x10, 71 }, 1, 'g' },
    {2, { 0x10, 72 }, 1, 'h' },
	{2, { 0x10, 74 }, 1, 'j' },
	{2, { 0x10, 75 }, 1, 'k' },
	{2, { 0x10, 76 }, 1, 'l' },
	{2, { 0x10,186 }, 1, '+' },
	{2, { 0x10,222 }, 1, '*' },
	{2, { 0x10, 13 }, 1, 13  },
	{1, { 226,   0 }, 1, '\\'}, // \ key
	{2, { 0x10, 226}, 1, '_' },
	{2, { 0x10, 220}, 1, '|' },
  // Control chars
// Row ZXCVBNM 
 	{2, { 0x11, 90 }, 1,  0x1A },
	{2, { 0x11, 88 }, 1,  0x18 },
	{2, { 0x11, 67 }, 1,  0x03 },
	{2, { 0x11, 86 }, 1,  0x16 },
	{2, { 0x11, 66 }, 1,  0x02 },
    {2, { 0x11, 78 }, 1,  0x0E },
	{2, { 0x11, 77 }, 1,  0x0D},
//Row ASDFG
	{2, { 0x11, 65 }, 1, 0x01 },
	{2, { 0x11, 83 }, 1, 0x13 },
	{2, { 0x11, 68 }, 1, 0x04 },
	{2, { 0x11, 70 }, 1, 0x06 },
	{2, { 0x11, 71 }, 1, 0x07 },
    {2, { 0x11, 72 }, 1, 0x08 },
	{2, { 0x11, 74 }, 1, 0x0A },
	{2, { 0x11, 75 }, 1, 0x0B },
	{2, { 0x11, 76 }, 1, 0x0C },
// Row QWERTY
	{2, {0x11, 81 }, 1, 0x11 },
	{2, {0x11, 87 }, 1, 0x17 },
	{2, {0x11, 69 }, 1, 0x05 },
	{2, {0x11, 82 }, 1, 0x12 },
	{2, {0x11, 84 }, 1, 0x14 },
	{2, {0x11, 89 }, 1, 0x19 },
	{2, {0x11, 85 }, 1, 0x15 },
	{2, {0x11, 73 }, 1, 0x09 },
	{2, {0x11, 79 }, 1, 0x0F },
	{2, {0x11, 80 }, 1, 0x10 },
// Alt keys

//   {2, {0x12, 81 }, 1, 'Q'},

//Turn CAPSLOCK OFF
    {STATE_CAPSLOCK, {0x10, 0x14 }, 0, 0},

// Test Japanese keyboard states...
// Move to Hiragana
//    {STATE_KANA, {0x00}, 0, 0},    // move to Japanese
//    {STATE_HIRAGANA, {0x00}, 0, 0}, // move to Hiragana
//
//// Move to Katakana
//    {STATE_


};      // end japanese keyboard


// ****************************************************
// Hindi keyboard
//
// Hindi and other Indic keyboards can compose multiple
// keystrokes into composed characters so be careful!
//
//  Num  VK1   VK2    Num	Unicode
testSequence KBDTests_Hindi[] = 
{
// Without VK_SHIFT
	{1,	{0x20, 0x00}, 1,	0x0020}, // Space key
	{1,	{0x1B, 0x00}, 1,	0x001B}, // Esc key
	{1,	{0x08, 0x00}, 1,	0x0008}, // BackSpace key
	{1,	{0x0D, 0x00}, 1,	0x000D}, // Enter key
	{1,	{0x09, 0x00}, 1,	0x0009}, // Tab key
	/* Keys 1234567890-= */
	{1,	{0x31, 0x00}, 1,	0x0031},      
    {1,	{0x32, 0x00}, 1,	0x0032},      
    {1,	{0x33, 0x00}, 1,	0x0033},      
	{1,	{0x34, 0x00}, 1,	0x0034},      
    {1,	{0x35, 0x00}, 1,	0x0035},      
    {1,	{0x36, 0x00}, 1,	0x0036},      
    {1,	{0x37, 0x00}, 1,	0x0037},      
	{1,	{0x38, 0x00}, 1,	0x0038},      
    {1,	{0x39, 0x00}, 1,	0X0039},      
	{1,	{0x30, 0x00}, 1,	0x0030},      
	{1,	{0xBD, 0x00}, 1,	0x002D},      
	{1,	{0xBB, 0x00}, 1,	0x0943},      
	/* Keys qwertyuiop[]\ */
	{1, {0x51, 0x00}, 1,	0x094C},			
	{1, {0x57, 0x00}, 1,	0x0948},			
	{1, {0x45, 0x00}, 1,	0x093E},			
	{1, {0x52, 0x00}, 1,	0x0940},			
	{1, {0x54, 0x00}, 1,	0x0942},			
	{1, {0x59, 0x00}, 1,	0x092C},			
	{1, {0x55, 0x00}, 1,	0x0939},			
	{1, {0x49, 0x00}, 1,	0x0917},			
	{1, {0x4F, 0x00}, 1,	0x0926},			
	{1, {0x50, 0x00}, 1,	0x091C},			
	{1, {0xDB, 0x00}, 1,	0x0921},            
	{1, {0xDD, 0x00}, 1,	0x093C},			
	{1, {0xDC, 0x00}, 1,	0x0949},			
	/* Keys asdfghjkl;' */
	{1, {0x41, 0x00}, 1,	0x094B},			
	{1, {0x53, 0x00}, 1,	0x0947},			
	{1, {0x44, 0x00}, 1,	0x094D},			
	{1, {0x46, 0x00}, 1,	0x093F},			
	{1, {0x47, 0x00}, 1,	0x0941},			
    {1, {0x48, 0x00}, 1,	0x092A},			
	{1, {0x4A, 0x00}, 1,	0x0930},			
	{1, {0x4B, 0x00}, 1,	0x0915},			
	{1, {0x4C, 0x00}, 1,	0x0924},			
	{1, {0xBA, 0x00}, 1,	0x091A},      
	{1,	{0xDE, 0x00}, 1,	0x091F},      
	/* Keys xcvbnm,./ */
	{1, {0x58, 0x00}, 1,	0x0902},			
	{1, {0x43, 0x00}, 1,	0x092E},			
	{1, {0x56, 0x00}, 1,	0x0928},
	{1, {0x42, 0x00}, 1,	0x0935},
    {1, {0x4E, 0x00}, 1,	0x0932},			
	{1, {0x4D, 0x00}, 1,	0x0938},			
	{1,	{0xBC, 0x00}, 1,	0x002C},      
	{1,	{0xBE, 0x00}, 1,	0x002E},      
	{1,	{0xBF, 0x00}, 1,	0x092F},      
// With VK_SHIFT
	/* Keys 1290-= */
	{2,	{0x10, 0x31}, 1,	0x090D},      
    {2,	{0x10, 0x32}, 1,	0x0945},     
    {2,	{0x10, 0x39}, 1,	0x0028},     
	{2,	{0x10, 0x30}, 1,	0x0029},      
	{2,	{0x10, 0xBD}, 1,	0x0903},     
	{2,	{0x10, 0xBB}, 1,	0x090B},      
	/* Keys qwertyuiop[]\ */
	{2, {0x10, 0x51}, 1,	0x0914},			
	{2, {0x10, 0x57}, 1,	0x0910},			
	{2, {0x10, 0x45}, 1,	0x0906},		
	{2, {0x10, 0x52}, 1,	0x0908},			
	{2, {0x10, 0x54}, 1,	0x090A},
	{2, {0x10, 0x59}, 1,	0x092D},			
	{2, {0x10, 0x55}, 1,	0x0919},			
	{2, {0x10, 0x49}, 1,	0x0918},			
	{2, {0x10, 0x4F}, 1,	0x0927},			
	{2, {0x10, 0x50}, 1,	0x091D},			
	{2, {0x10, 0xDB}, 1,	0x0922},            
	{2, {0x10, 0xDD}, 1,	0x091E},		
	{2, {0x10, 0xDC}, 1,	0x0911},			
	/* Keys asdfghjkl;' */
	{2, {0x10, 0x41}, 1,	0x0913},			
	{2, {0x10, 0x53}, 1,	0x090F},			
	{2, {0x10, 0x44}, 1,	0x0905},			
	{2, {0x10, 0x46}, 1,	0x0907},			
	{2, {0x10, 0x47}, 1,	0x0909},
    {2, {0x10, 0x48}, 1,	0x092B},			
	{2, {0x10, 0x4A}, 1,	0x0931},			
	{2, {0x10, 0x4B}, 1,	0x0916},			
	{2, {0x10, 0x4C}, 1,	0x0925},			
	{2, {0x10, 0xBA}, 1,	0x091B},    
	{2,	{0x10, 0xDE}, 1,	0x0920},     
	/* Keys xcnm,./ */          
	{2, {0x10, 0x58}, 1,	0x0901},			
	{2, {0x10, 0x43}, 1,	0x0923},						
    {2, {0x10, 0x4E}, 1,	0x0933},			
	{2, {0x10, 0x4D}, 1,	0x0936},			
	{2,	{0x10, 0xBC}, 1,	0x0937},     
	{2,	{0x10, 0xBE}, 1,	0x0964},      
	{2,	{0x10, 0xBF}, 1,	0x095F},
// Control chars
	// Row ZXCV
 	{2, {0x11, 90}, 1, 0x1A},			// Ctrl Z
	{2, {0x11, 88}, 1, 0x18},			// Ctrl X
	{2, {0x11, 67}, 1, 0x03},			// Ctrl C
	{2, {0x11, 86}, 1, 0x16},			// Ctrl V
	{2, {0x11, 66}, 1, 0x02},			// Ctrl B
    {2, {0x11, 78}, 1, 0x0E},			// Ctrl N
	{2, {0x11, 77}, 1, 0x0D},			// Ctrl M
	//Row ASDF
	{2, {0x11, 65}, 1, 0x01},			// Ctrl A
	{2, {0x11, 83}, 1, 0x13},			// Ctrl S
	{2, {0x11, 68}, 1, 0x04},			// Ctrl D
	{2, {0x11, 70}, 1, 0x06},			// Ctrl F
	{2, {0x11, 71}, 1, 0x07},			// Ctrl G
    {2, {0x11, 72}, 1, 0x08},			// Ctrl H
	{2, {0x11, 74}, 1, 0x0A},			// Ctrl J
	{2, {0x11, 75}, 1, 0x0B},			// Ctrl K
	{2, {0x11, 76}, 1, 0x0C},			// Ctrl L
	// Row QWER
	{2, {0x11, 81}, 1, 0x11},			// Ctrl Q
	{2, {0x11, 87}, 1, 0x17},			// Ctrl W
	{2, {0x11, 69}, 1, 0x05},			// Ctrl E
	{2, {0x11, 82}, 1, 0x12},			// Ctrl R
	{2, {0x11, 84}, 1, 0x14},			// Ctrl T
	{2, {0x11, 89}, 1, 0x19},			// Ctrl Y
	{2, {0x11, 85}, 1, 0x15},			// Ctrl U
	{2, {0x11, 73}, 1, 0x09},			// Ctrl I
	{2, {0x11, 79}, 1, 0x0F},			// Ctrl O
	{2, {0x11, 80}, 1, 0x10},			// Ctrl P
// With ALT-Gr key (VK_CONTROL, VK_MENU)
	/*keys `1234567890-= */
	{3, {0x0011, 0x0012, 0x00C0}, 1, 0x0060},
	{3, {0x0011, 0x0012, 0x0031}, 1, 0x0967},
	{3, {0x0011, 0x0012, 0x0032}, 1, 0x0968},
	{3, {0x0011, 0x0012, 0x0033}, 1, 0x0969},
	{3, {0x0011, 0x0012, 0x0034}, 1, 0x096A},
	{3, {0x0011, 0x0012, 0x0035}, 1, 0x096B},
	{3, {0x0011, 0x0012, 0x0036}, 1, 0x096C},
	{3, {0x0011, 0x0012, 0x0037}, 1, 0x096D},
	{3, {0x0011, 0x0012, 0x0038}, 1, 0x096E},
	{3, {0x0011, 0x0012, 0x0039}, 1, 0x096F},
	{3, {0x0011, 0x0012, 0x0030}, 1, 0x0966},
	/* Keys qwertyuiop[]\ */
	{3, {0x0011, 0x0012, 0x0051}, 0, 0x0000},
	{3, {0x0011, 0x0012, 0x0057}, 0, 0x0000},
	{3, {0x0011, 0x0012, 0x0045}, 0, 0x0000},
	{3, {0x0011, 0x0012, 0x0052}, 0, 0x0000},
	{3, {0x0011, 0x0012, 0x0054}, 0, 0x0000},
	{3, {0x0011, 0x0012, 0x0059}, 0, 0x0000},
	{3, {0x0011, 0x0012, 0x0055}, 0, 0x0000},
	{3, {0x0011, 0x0012, 0x0049}, 0, 0x0000},
	{3, {0x0011, 0x0012, 0x004F}, 0, 0x0000},
	{3, {0x0011, 0x0012, 0x0050}, 0, 0x0000},
	{3, {0x0011, 0x0012, 0x00DB}, 1, 0x005B},
	{3, {0x0011, 0x0012, 0x00DD}, 1, 0x005D},
	{3, {0x0011, 0x0012, 0x00DC}, 1, 0x005C},
	/* Keys asdfghjkl;' */
	{3, {0x0011, 0x0012, 0x0041}, 0, 0x0000},
	{3, {0x0011, 0x0012, 0x0053}, 0, 0x0000},
	{3, {0x0011, 0x0012, 0x0044}, 0, 0x0000},
	{3, {0x0011, 0x0012, 0x0046}, 0, 0x0000},
	{3, {0x0011, 0x0012, 0x0047}, 0, 0x0000},
	{3, {0x0011, 0x0012, 0x0048}, 0, 0x0000},
	{3, {0x0011, 0x0012, 0x004A}, 0, 0x0000},
	{3, {0x0011, 0x0012, 0x004B}, 0, 0x0000},
	{3, {0x0011, 0x0012, 0x004C}, 0, 0x0000},
	{3, {0x0011, 0x0012, 0x00BA}, 1, 0x003B},
	{3, {0x0011, 0x0012, 0x00DE}, 1, 0x0027},
	/* Keys zxcvbnm,./ */
	{3, {0x0011, 0x0012, 0x005A}, 0, 0x0000},
	{3, {0x0011, 0x0012, 0x0058}, 0, 0x0000},
	{3, {0x0011, 0x0012, 0x0043}, 0, 0x0000},
	{3, {0x0011, 0x0012, 0x0056}, 0, 0x0000},
	{3, {0x0011, 0x0012, 0x0042}, 0, 0x0000},
	{3, {0x0011, 0x0012, 0x004E}, 0, 0x0000},
	{3, {0x0011, 0x0012, 0x004D}, 0, 0x0000},
	{3, {0x0011, 0x0012, 0x00BC}, 1, 0x002C},
	{3, {0x0011, 0x0012, 0x00BE}, 1, 0x002E},
	{3, {0x0011, 0x0012, 0x00BF}, 1, 0x002F},
// With ALT-Gr + VK_SHIFT
	/*keys `1234567890-= */
	{4, {0x0010, 0x0011, 0x0012, 0x00C0}, 1, 0x007E},
	{4, {0x0010, 0x0011, 0x0012, 0x0031}, 1, 0x0021},
	{4, {0x0010, 0x0011, 0x0012, 0x0032}, 1, 0x0040},
	{4, {0x0010, 0x0011, 0x0012, 0x0033}, 1, 0x0023},
	{4, {0x0010, 0x0011, 0x0012, 0x0034}, 1, 0x0024},
	{4, {0x0010, 0x0011, 0x0012, 0x0035}, 1, 0x0025},
	{4, {0x0010, 0x0011, 0x0012, 0x0036}, 1, 0x005E},
	{4, {0x0010, 0x0011, 0x0012, 0x0037}, 1, 0x0026},
	{4, {0x0010, 0x0011, 0x0012, 0x0038}, 1, 0x002A},
	{4, {0x0010, 0x0011, 0x0012, 0x0039}, 1, 0x0028},
	{4, {0x0010, 0x0011, 0x0012, 0x0030}, 1, 0x0029},
	{4, {0x0010, 0x0011, 0x0012, 0x00BD}, 1, 0x005F},
	{4, {0x0010, 0x0011, 0x0012, 0x00BB}, 1, 0x002B},
	/* Keys qwertyuiop[]\ */
	{4, {0x0010, 0x0011, 0x0012, 0x0051}, 0, 0x0000},
	{4, {0x0010, 0x0011, 0x0012, 0x0057}, 0, 0x0000},
	{4, {0x0010, 0x0011, 0x0012, 0x0045}, 0, 0x0000},
	{4, {0x0010, 0x0011, 0x0012, 0x0052}, 0, 0x0000},
	{4, {0x0010, 0x0011, 0x0012, 0x0054}, 0, 0x0000},
	{4, {0x0010, 0x0011, 0x0012, 0x0059}, 0, 0x0000},
	{4, {0x0010, 0x0011, 0x0012, 0x0055}, 0, 0x0000},
	{4, {0x0010, 0x0011, 0x0012, 0x0049}, 0, 0x0000},
	{4, {0x0010, 0x0011, 0x0012, 0x004F}, 0, 0x0000},
	{4, {0x0010, 0x0011, 0x0012, 0x0050}, 0, 0x0000},
	{4, {0x0010, 0x0011, 0x0012, 0x00DB}, 1, 0x007B},
	{4, {0x0010, 0x0011, 0x0012, 0x00DD}, 1, 0x007D},
	{4, {0x0010, 0x0011, 0x0012, 0x00DC}, 1, 0x007C},
	/* Keys asdfghjkl;' */
	{4, {0x0010, 0x0011, 0x0012, 0x0041}, 0, 0x0000},
	{4, {0x0010, 0x0011, 0x0012, 0x0053}, 0, 0x0000},
	{4, {0x0010, 0x0011, 0x0012, 0x0044}, 0, 0x0000},
	{4, {0x0010, 0x0011, 0x0012, 0x0046}, 0, 0x0000},
	{4, {0x0010, 0x0011, 0x0012, 0x0047}, 0, 0x0000},
	{4, {0x0010, 0x0011, 0x0012, 0x0048}, 0, 0x0000},
	{4, {0x0010, 0x0011, 0x0012, 0x004A}, 0, 0x0000},
	{4, {0x0010, 0x0011, 0x0012, 0x004B}, 0, 0x0000},
	{4, {0x0010, 0x0011, 0x0012, 0x004C}, 0, 0x0000},
	{4, {0x0010, 0x0011, 0x0012, 0x00BA}, 1, 0x003A},
	{4, {0x0010, 0x0011, 0x0012, 0x00DE}, 1, 0x0022},
	/* Keys zxcvbnm,./ */
	{4, {0x0010, 0x0011, 0x0012, 0x005A}, 0, 0x0000},
	{4, {0x0010, 0x0011, 0x0012, 0x0058}, 1, 0x0950},
	{4, {0x0010, 0x0011, 0x0012, 0x0043}, 0, 0x0000},
	{4, {0x0010, 0x0011, 0x0012, 0x0056}, 0, 0x0000},
	{4, {0x0010, 0x0011, 0x0012, 0x0042}, 0, 0x0000},
	{4, {0x0010, 0x0011, 0x0012, 0x004E}, 0, 0x0000},
	{4, {0x0010, 0x0011, 0x0012, 0x004D}, 0, 0x0000},
	{4, {0x0010, 0x0011, 0x0012, 0x00BC}, 1, 0x003C},
	{4, {0x0010, 0x0011, 0x0012, 0x00BE}, 1, 0x003E},
	{4, {0x0010, 0x0011, 0x0012, 0x00BF}, 1, 0x003F},
// Keystrokes that generate multiple chars
  // With VK_SHIFT
	/*Keys 345678 */
	{2,	{0x10, 0x33}, 2, {0x094D, 0x0930        }},      
	{2,	{0x10, 0x34}, 2, {0x0930, 0x094D        }},      
    {2,	{0x10, 0x35}, 3, {0x091C, 0x094D, 0x091E}},      
    {2,	{0x10, 0x36}, 3, {0x0924, 0x094D, 0x0930}},     
    {2,	{0x10, 0x37}, 3, {0x0915, 0x094D, 0x0937}},     
	{2,	{0x10, 0x38}, 3, {0x0936, 0x094D, 0x0930}}, 
}; // end Hindi keyboard

// ****************************************************
// Hebrew keyboard
//
//  Num  VK1   VK2	  Num	Unicode
testSequence KBDTests_Hebrew[] = 
{
// With CAPSLOCK OFF
  // Without VK_SHIFT
	{1,	{0x20, 0x00}, 1,	0x0020}, // Space key
	{1,	{0x1B, 0x00}, 1,	0x001B}, // Esc key
	{1,	{0x08, 0x00}, 1,	0x0008}, // BackSpace key
	{1,	{0x0D, 0x00}, 1,	0x000D}, // Enter key
	{1,	{0x09, 0x00}, 1,	0x0009}, // Tab key
	/* Keys `1234567890-= */
	{1, {0xC0, 0x00}, 1,	0x003B},      
	{1, {0x31, 0x00}, 1,	0x0031},      
    {1,	{0x32, 0x00}, 1,	0x0032},      
   	{1,	{0x33, 0x00}, 1,	0x0033},      
	{1,	{0x34, 0x00}, 1,	0x0034},      
    {1,	{0x35, 0x00}, 1,	0x0035},      
    {1,	{0x36, 0x00}, 1,	0x0036},      
    {1,	{0x37, 0x00}, 1,	0x0037},      
	{1,	{0x38, 0x00}, 1,	0x0038},      
    {1,	{0x39, 0x00}, 1,	0X0039},      
	{1,	{0x30, 0x00}, 1,	0x0030},      
	{1,	{0xBD, 0x00}, 1,	0x002D},      
	{1,	{0xBB, 0x00}, 1,	0x003D},      
	/* Keys qwertyuiop[]\ */
	{1, {0x51, 0x00}, 1,	0x002F},			
	{1, {0x57, 0x00}, 1,	0x0027},			
	{1, {0x45, 0x00}, 1,	0x05E7},			
	{1, {0x52, 0x00}, 1,	0x05E8},			
	{1, {0x54, 0x00}, 1,	0x05D0},			
	{1, {0x59, 0x00}, 1,	0x05D8},			
	{1, {0x55, 0x00}, 1,	0x05D5},			
	{1, {0x49, 0x00}, 1,	0x05DF},			
	{1, {0x4F, 0x00}, 1,	0x05DD},			
	{1, {0x50, 0x00}, 1,	0x05E4},			
	{1, {0xDB, 0x00}, 1,	0x005D},            
	{1, {0xDD, 0x00}, 1,	0x005B},			
	{1, {0xDC, 0x00}, 1,	0x005C},			
	/* Keys asdfghjkl;' */
	{1, {0x41, 0x00}, 1,	0x05E9},			
	{1, {0x53, 0x00}, 1,	0x05D3},			
	{1, {0x44, 0x00}, 1,	0x05D2},			
	{1, {0x46, 0x00}, 1,	0x05DB},			
	{1, {0x47, 0x00}, 1,	0x05E2},			
    {1, {0x48, 0x00}, 1,	0x05D9},			
	{1, {0x4A, 0x00}, 1,	0x05D7},			
	{1, {0x4B, 0x00}, 1,	0x05DC},			
	{1, {0x4C, 0x00}, 1,	0x05DA},			
	{1, {0xBA, 0x00}, 1,	0x05E3},      
	{1, {0xDE, 0x00}, 1,	0x002C},      
	/* Keys zxcvbnm,./ */
	{1, {0x5A, 0x00}, 1,	0x05D6},          
	{1, {0x58, 0x00}, 1,	0x05E1},			
	{1, {0x43, 0x00}, 1,	0x05D1},			
	{1, {0x56, 0x00}, 1,	0x05D4},
	{1, {0x42, 0x00}, 1,	0x05E0},			
	{1, {0x4E, 0x00}, 1,	0x05DE},			
	{1, {0x4D, 0x00}, 1,	0x05E6},      
	{1, {0xBC, 0x00}, 1,	0x05EA},
	{1, {0xBE, 0x00}, 1,	0x05E5},      
	{1, {0xBF, 0x00}, 1,	0x002E},
  // With VK_SHIFT
	/* Keys `1234567890-= */
	{2, {0x10, 0xC0}, 1,	0x007E},     
	{2,	{0x10, 0x31}, 1,	0x0021},      
    {2,	{0x10, 0x32}, 1,	0x0040},     
    {2,	{0x10, 0x33}, 1,	0x0023},      
	{2,	{0x10, 0x34}, 1,	0x0024},      
    {2,	{0x10, 0x35}, 1,	0x0025},      
    {2,	{0x10, 0x36}, 1,	0x005E},     
    {2,	{0x10, 0x37}, 1,	0x0026},     
	{2,	{0x10, 0x38}, 1,	0x002A},     
    {2,	{0x10, 0x39}, 1,	0x0029},     
	{2,	{0x10, 0x30}, 1,	0x0028},      
	{2,	{0x10, 0xBD}, 1,	0x005F},     
	{2,	{0x10, 0xBB}, 1,	0x002B},      
	/* Keys qwertyuiop[]\ */
	{2, {0x10, 0x51}, 1,	0x0051},			
	{2, {0x10, 0x57}, 1,	0x0057},			
	{2, {0x10, 0x45}, 1,	0x0045},		
	{2, {0x10, 0x52}, 1,	0x0052},			
	{2, {0x10, 0x54}, 1,	0x0054},
	{2, {0x10, 0x59}, 1,	0x0059},			
	{2, {0x10, 0x55}, 1,	0x0055},			
	{2, {0x10, 0x49}, 1,	0x0049},			
	{2, {0x10, 0x4F}, 1,	0x004F},			
	{2, {0x10, 0x50}, 1,	0x0050},			
	{2, {0x10, 0xDB}, 1,	0x007D},            
	{2, {0x10, 0xDD}, 1,	0x007B},		
	{2, {0x10, 0xDC}, 1,	0x007C},			
	/* Keys asdfhjkl;' */
	{2, {0x10, 0x41}, 1,	0x0041},			
	{2, {0x10, 0x53}, 1,	0x0053},			
	{2, {0x10, 0x44}, 1,	0x0044},			
	{2, {0x10, 0x46}, 1,	0x0046},
	{2, {0x10, 0x47}, 1,	0x0047},			
    {2, {0x10, 0x48}, 1,	0x0048},			
	{2, {0x10, 0x4A}, 1,	0x004A},			
	{2, {0x10, 0x4B}, 1,	0x004B},			
	{2, {0x10, 0x4C}, 1,	0x004C},			
	{2, {0x10, 0xBA}, 1,	0x003A},    
	{2, {0x10, 0xDE}, 1,	0x0022},     
	/* Keys zxcvbnm,./ */
	{2, {0x10, 0x5A}, 1,	0x005A},          
	{2, {0x10, 0x58}, 1,	0x0058},			
	{2, {0x10, 0x43}, 1,	0x0043},			
	{2, {0x10, 0x56}, 1,	0x0056},			
	{2, {0x10, 0x42}, 1,	0x0042},
    {2, {0x10, 0x4E}, 1,	0x004E},			
	{2, {0x10, 0x4D}, 1,	0x004D},			
	{2, {0x10, 0xBC}, 1,	0x003E},     
	{2, {0x10, 0xBE}, 1,	0x003C},      
	{2, {0x10, 0xBF}, 1,	0x003F},
  // Control chars (with VK_CONTROL)
	// Row ZXCV
 	{2, {0x11, 90}, 1, 0x1A},			// Ctrl Z
	{2, {0x11, 88}, 1, 0x18},			// Ctrl X
	{2, {0x11, 67}, 1, 0x03},			// Ctrl C
	{2, {0x11, 86}, 1, 0x16},			// Ctrl V
	{2, {0x11, 66}, 1, 0x02},			// Ctrl B
    {2, {0x11, 78}, 1, 0x0E},			// Ctrl N
	{2, {0x11, 77}, 1, 0x0D},			// Ctrl M
	//Row ASDF
	{2, {0x11, 65}, 1, 0x01},			// Ctrl A
	{2, {0x11, 83}, 1, 0x13},			// Ctrl S
	{2, {0x11, 68}, 1, 0x04},			// Ctrl D
	{2, {0x11, 70}, 1, 0x06},			// Ctrl F
	{2, {0x11, 71}, 1, 0x07},			// Ctrl G
    {2, {0x11, 72}, 1, 0x08},			// Ctrl H
	{2, {0x11, 74}, 1, 0x0A},			// Ctrl J
	{2, {0x11, 75}, 1, 0x0B},			// Ctrl K
	{2, {0x11, 76}, 1, 0x0C},			// Ctrl L
	// Row QWER
	{2, {0x11, 81}, 1, 0x11},			// Ctrl Q
	{2, {0x11, 87}, 1, 0x17},			// Ctrl W
	{2, {0x11, 69}, 1, 0x05},			// Ctrl E
	{2, {0x11, 82}, 1, 0x12},			// Ctrl R
	{2, {0x11, 84}, 1, 0x14},			// Ctrl T
	{2, {0x11, 89}, 1, 0x19},			// Ctrl Y
	{2, {0x11, 85}, 1, 0x15},			// Ctrl U
	{2, {0x11, 73}, 1, 0x09},			// Ctrl I
	{2, {0x11, 79}, 1, 0x0F},			// Ctrl O
	{2, {0x11, 80}, 1, 0x10},			// Ctrl P
  // With ALT-Gr key (VK_CONTROL, VK_MENU)
	{3, {0x0011, 0x0012, 0x0034}, 1, 0x20AA}, // Ctrl + Alt + 4
	{3, {0x0011, 0x0012, 0x0045}, 1, 0x20AC}, // Ctrl + Alt + E
	{3, {0x0011, 0x0012, 0x0055}, 1, 0x05F0}, // Ctrl + Alt + U
	{3, {0x0011, 0x0012, 0x0048}, 1, 0x05F2}, // Ctrl + Alt + H
	{3, {0x0011, 0x0012, 0x004A}, 1, 0x05F1}, // Ctrl + Alt + J
	// Keystrokes that do not generate WM_CHARs
	/* Keys `123567890= */
	{3, {0x0011, 0x0012, 0xC0}, 0, 0},
	{3, {0x0011, 0x0012, 0x31}, 0, 0},
	{3, {0x0011, 0x0012, 0x32}, 0, 0},
	{3, {0x0011, 0x0012, 0x33}, 0, 0},
	{3, {0x0011, 0x0012, 0x35}, 0, 0},
	{3, {0x0011, 0x0012, 0x36}, 0, 0},
	{3, {0x0011, 0x0012, 0x37}, 0, 0},
	{3, {0x0011, 0x0012, 0x38}, 0, 0},
	{3, {0x0011, 0x0012, 0x39}, 0, 0},
	{3, {0x0011, 0x0012, 0x30}, 0, 0},
	{3, {0x0011, 0x0012, 0xBB}, 0, 0},
	/* Keys qwrtyiop[]\ */
	{3, {0x0011, 0x0012, 0x51}, 0, 0},
	{3, {0x0011, 0x0012, 0x57}, 0, 0},
	{3, {0x0011, 0x0012, 0x52}, 0, 0},
	{3, {0x0011, 0x0012, 0x54}, 0, 0},
	{3, {0x0011, 0x0012, 0x59}, 0, 0},
	{3, {0x0011, 0x0012, 0x49}, 0, 0},
	{3, {0x0011, 0x0012, 0x4F}, 0, 0},
	{3, {0x0011, 0x0012, 0x50}, 0, 0},
	{3, {0x0011, 0x0012, 0xDB}, 0, 0},
	{3, {0x0011, 0x0012, 0xDD}, 0, 0},
	{3, {0x0011, 0x0012, 0xDC}, 0, 0},
	/* Keys asdfgkl;' */
	{3, {0x0011, 0x0012, 0x41}, 0, 0},
	{3, {0x0011, 0x0012, 0x53}, 0, 0},
	{3, {0x0011, 0x0012, 0x44}, 0, 0},
	{3, {0x0011, 0x0012, 0x46}, 0, 0},
	{3, {0x0011, 0x0012, 0x47}, 0, 0},
	{3, {0x0011, 0x0012, 0x4B}, 0, 0},
	{3, {0x0011, 0x0012, 0x4C}, 0, 0},
	{3, {0x0011, 0x0012, 0xBA}, 0, 0},
	{3, {0x0011, 0x0012, 0xDE}, 0, 0},
	/* Keys zxcvbnm,./ */
	{3, {0x0011, 0x0012, 0x5A}, 0, 0},
	{3, {0x0011, 0x0012, 0x58}, 0, 0},
	{3, {0x0011, 0x0012, 0x43}, 0, 0},
	{3, {0x0011, 0x0012, 0x56}, 0, 0},
	{3, {0x0011, 0x0012, 0x42}, 0, 0},
	{3, {0x0011, 0x0012, 0x4E}, 0, 0},
	{3, {0x0011, 0x0012, 0x4D}, 0, 0},
	{3, {0x0011, 0x0012, 0xBC}, 0, 0},
	{3, {0x0011, 0x0012, 0xBE}, 0, 0},
	{3, {0x0011, 0x0012, 0xBF}, 0, 0},

// Turn CAPSLOCK ON
	{STATE_CAPSLOCK, {0x10, 0x14}, 0, 0},

// With CAPSLOCK ON
  // Without VK_SHIFT
	{1,	{0x20, 0x00}, 1,	0x0020}, // Space key
	{1,	{0x1B, 0x00}, 1,	0x001B}, // Esc key
	{1,	{0x08, 0x00}, 1,	0x0008}, // BackSpace key
	{1,	{0x0D, 0x00}, 1,	0x000D}, // Enter key
	{1,	{0x09, 0x00}, 1,	0x0009}, // Tab key
	/* Keys `1234567890-= */
	{1, {0xC0, 0x00}, 1,	0x003B},      
	{1, {0x31, 0x00}, 1,	0x0031},      
    {1,	{0x32, 0x00}, 1,	0x0032},      
   	{1,	{0x33, 0x00}, 1,	0x0033},      
	{1,	{0x34, 0x00}, 1,	0x0034},      
    {1,	{0x35, 0x00}, 1,	0x0035},      
    {1,	{0x36, 0x00}, 1,	0x0036},      
    {1,	{0x37, 0x00}, 1,	0x0037},      
	{1,	{0x38, 0x00}, 1,	0x0038},      
    {1,	{0x39, 0x00}, 1,	0X0039},      
	{1,	{0x30, 0x00}, 1,	0x0030},      
	{1,	{0xBD, 0x00}, 1,	0x002D},      
	{1,	{0xBB, 0x00}, 1,	0x003D},      
	/* Keys qwertyuiop[]\ */
	{1, {0x51, 0x00}, 1,	0x0051},			
	{1, {0x57, 0x00}, 1,	0x0057},			
	{1, {0x45, 0x00}, 1,	0x0045},			
	{1, {0x52, 0x00}, 1,	0x0052},			
	{1, {0x54, 0x00}, 1,	0x0054},			
	{1, {0x59, 0x00}, 1,	0x0059},			
	{1, {0x55, 0x00}, 1,	0x0055},			
	{1, {0x49, 0x00}, 1,	0x0049},			
	{1, {0x4F, 0x00}, 1,	0x004F},			
	{1, {0x50, 0x00}, 1,	0x0050},			
	{1, {0xDB, 0x00}, 1,	0x005B},            
	{1, {0xDD, 0x00}, 1,	0x005D},			
	{1, {0xDC, 0x00}, 1,	0x005C},			
	/* Keys asdfghjkl;' */
	{1, {0x41, 0x00}, 1,	0x0041},			
	{1, {0x53, 0x00}, 1,	0x0053},			
	{1, {0x44, 0x00}, 1,	0x0044},			
	{1, {0x46, 0x00}, 1,	0x0046},			
	{1, {0x47, 0x00}, 1,	0x0047},			
    {1, {0x48, 0x00}, 1,	0x0048},			
	{1, {0x4A, 0x00}, 1,	0x004A},			
	{1, {0x4B, 0x00}, 1,	0x004B},			
	{1, {0x4C, 0x00}, 1,	0x004C},			
	{1, {0xBA, 0x00}, 1,	0x003B},      
	{1, {0xDE, 0x00}, 1,	0x0027},      
	/* Keys zxcvbnm,./ */
	{1, {0x5A, 0x00}, 1,	0x005A},          
	{1, {0x58, 0x00}, 1,	0x0058},			
	{1, {0x43, 0x00}, 1,	0x0043},			
	{1, {0x56, 0x00}, 1,	0x0056},
	{1, {0x42, 0x00}, 1,	0x0042},			
	{1, {0x4E, 0x00}, 1,	0x004E},
	{1, {0x4D, 0x00}, 1,	0x004D},      
	{1, {0xBC, 0x00}, 1,	0x002C},
	{1, {0xBE, 0x00}, 1,	0x002E},      
	{1, {0xBF, 0x00}, 1,	0x002F},
  // With VK_SHIFT
	/* Keys `1234567890-= */
	{2, {0x10, 0xC0}, 1,	0x05B0},     
	{2,	{0x10, 0x31}, 1,	0x05B1},      
    {2,	{0x10, 0x32}, 1,	0x05B2},     
    {2,	{0x10, 0x33}, 1,	0x05B3},      
	{2,	{0x10, 0x34}, 1,	0x05B4},      
    {2,	{0x10, 0x35}, 1,	0x05B5},      
    {2,	{0x10, 0x36}, 1,	0x05B6},     
    {2,	{0x10, 0x37}, 1,	0x05B7},     
	{2,	{0x10, 0x38}, 1,	0x05B8},     
    {2,	{0x10, 0x39}, 1,	0x05C2},     
	{2,	{0x10, 0x30}, 1,	0x05C1},      
	{2,	{0x10, 0xBD}, 1,	0x05B9},     
	{2,	{0x10, 0xBB}, 1,	0x05BC},      
	/* Keys qwertyuiop[]\ */
	{2, {0x10, 0x51}, 1,	0x002F},			
	{2, {0x10, 0x57}, 1,	0x0027},			
	{2, {0x10, 0x45}, 1,	0x05E7},		
	{2, {0x10, 0x52}, 1,	0x05E8},			
	{2, {0x10, 0x54}, 1,	0x05D0},
	{2, {0x10, 0x59}, 1,	0x05D8},			
	{2, {0x10, 0x55}, 1,	0x05D5},			
	{2, {0x10, 0x49}, 1,	0x05DF},			
	{2, {0x10, 0x4F}, 1,	0x05DD},			
	{2, {0x10, 0x50}, 1,	0x05E4},			
	{2, {0x10, 0xDB}, 1,	0x005D},            
	{2, {0x10, 0xDD}, 1,	0x005B},		
	{2, {0x10, 0xDC}, 1,	0x05BB},			
	/* Keys asdfhjkl;' */
	{2, {0x10, 0x41}, 1,	0x05E9},			
	{2, {0x10, 0x53}, 1,	0x05D3},			
	{2, {0x10, 0x44}, 1,	0x05D2},			
	{2, {0x10, 0x46}, 1,	0x05DB},
	{2, {0x10, 0x47}, 1,	0x05E2},			
    {2, {0x10, 0x48}, 1,	0x05D9},			
	{2, {0x10, 0x4A}, 1,	0x05D7},			
	{2, {0x10, 0x4B}, 1,	0x05DC},			
	{2, {0x10, 0x4C}, 1,	0x05DA},			
	{2, {0x10, 0xBA}, 1,	0x05E3},    
	{2, {0x10, 0xDE}, 1,	0x002C},     
	/* Keys zxcvbnm,./ */
	{2, {0x10, 0x5A}, 1,	0x05D6},          
	{2, {0x10, 0x58}, 1,	0x05E1},			
	{2, {0x10, 0x43}, 1,	0x05D1},			
	{2, {0x10, 0x56}, 1,	0x05D4},			
	{2, {0x10, 0x42}, 1,	0x05E0},
    {2, {0x10, 0x4E}, 1,	0x05DE},			
	{2, {0x10, 0x4D}, 1,	0x05E6},			
	{2, {0x10, 0xBC}, 1,	0x05EA},     
	{2, {0x10, 0xBE}, 1,	0x05E5},      
	{2, {0x10, 0xBF}, 1,	0x002E},
  // Control chars (with VK_CONTROL)
	// Row ZXCV
 	{2, {0x11, 90}, 1, 0x1A},          // Ctrl Z
	{2, {0x11, 88}, 1, 0x18},			// Ctrl X
	{2, {0x11, 67}, 1, 0x03},			// Ctrl C
	{2, {0x11, 86}, 1, 0x16},			// Ctrl V
	{2, {0x11, 66}, 1, 0x02},			// Ctrl B
    {2, {0x11, 78}, 1, 0x0E},			// Ctrl N
	{2, {0x11, 77}, 1, 0x0D},			// Ctrl M
	//Row ASDF
	{2, {0x11, 65}, 1, 0x01},			// Ctrl A
	{2, {0x11, 83}, 1, 0x13},			// Ctrl S
	{2, {0x11, 68}, 1, 0x04},			// Ctrl D
	{2, {0x11, 70}, 1, 0x06},			// Ctrl F
	{2, {0x11, 71}, 1, 0x07},			// Ctrl G
    {2, {0x11, 72}, 1, 0x08},			// Ctrl H
	{2, {0x11, 74}, 1, 0x0A},			// Ctrl J
	{2, {0x11, 75}, 1, 0x0B},			// Ctrl K
	{2, {0x11, 76}, 1, 0x0C},			// Ctrl L
	// Row QWER
	{2, {0x11, 81}, 1, 0x11},			// Ctrl Q
	{2, {0x11, 87}, 1, 0x17},			// Ctrl W
	{2, {0x11, 69}, 1, 0x05},			// Ctrl E
	{2, {0x11, 82}, 1, 0x12},			// Ctrl R
	{2, {0x11, 84}, 1, 0x14},			// Ctrl T
	{2, {0x11, 89}, 1, 0x19},			// Ctrl Y
	{2, {0x11, 85}, 1, 0x15},			// Ctrl U
	{2, {0x11, 73}, 1, 0x09},			// Ctrl I
	{2, {0x11, 79}, 1, 0x0F},			// Ctrl O
	{2, {0x11, 80}, 1, 0x10},

//Turn CAPSLOCK OFF
    {STATE_CAPSLOCK, {0x10, 0x14}, 0,  0},
}; // end Hebrew keyboard

// ****************************************************
// Saudi Arabia keyboard (101)
//
//  Num  VK1   VK2	  Num	Unicode
testSequence KBDTests_Arabic[] = 
{
// Without VK_SHIFT
	{1,	{0x20, 0x00}, 1,	0x0020}, // Space key
	{1,	{0x1B, 0x00}, 1,	0x001B}, // Esc key
	{1,	{0x08, 0x00}, 1,	0x0008}, // BackSpace key
	{1,	{0x0D, 0x00}, 1,	0x000D}, // Enter key
	{1,	{0x09, 0x00}, 1,	0x0009}, // Tab key
	/* Keys `1234567890-= */
	{1, {0xC0, 0x00}, 1,	0x0630},      
	{1,	{0x31, 0x00}, 1,	0x0031},      
    {1,	{0x32, 0x00}, 1,	0x0032},      
    {1,	{0x33, 0x00}, 1,	0x0033},      
	{1,	{0x34, 0x00}, 1,	0x0034},      
    {1,	{0x35, 0x00}, 1,	0x0035},      
    {1,	{0x36, 0x00}, 1,	0x0036},      
    {1,	{0x37, 0x00}, 1,	0x0037},      
	{1,	{0x38, 0x00}, 1,	0x0038},      
    {1,	{0x39, 0x00}, 1,	0X0039},      
	{1,	{0x30, 0x00}, 1,	0x0030},      
	{1,	{0xBD, 0x00}, 1,	0x002D},      
	{1,	{0xBB, 0x00}, 1,	0x003D},      
	/* Keys qwertyuiop[]\ */
	{1, {0x51, 0x00}, 1,	0x0636},			
	{1, {0x57, 0x00}, 1,	0x0635},			
	{1, {0x45, 0x00}, 1,	0x062B},			
	{1, {0x52, 0x00}, 1,	0x0642},			
	{1, {0x54, 0x00}, 1,	0x0641},			
	{1, {0x59, 0x00}, 1,	0x063A},			
	{1, {0x55, 0x00}, 1,	0x0639},			
	{1, {0x49, 0x00}, 1,	0x0647},			
	{1, {0x4F, 0x00}, 1,	0x062E},			
	{1, {0x50, 0x00}, 1,	0x062D},			
	{1, {0xDB, 0x00}, 1,	0x062C},            
	{1, {0xDD, 0x00}, 1,	0x062F},			
	{1, {0xDC, 0x00}, 1,	0x005C},			
	/* Keys asdfghjkl;' */
	{1, {0x41, 0x00}, 1,	0x0634},			
	{1, {0x53, 0x00}, 1,	0x0633},			
	{1, {0x44, 0x00}, 1,	0x064A},			
	{1, {0x46, 0x00}, 1,	0x0628},			
	{1, {0x47, 0x00}, 1,	0x0644},			
    {1, {0x48, 0x00}, 1,	0x0627},			
	{1, {0x4A, 0x00}, 1,	0x062A},			
	{1, {0x4B, 0x00}, 1,	0x0646},			
	{1, {0x4C, 0x00}, 1,	0x0645},			
	{1, {0xBA, 0x00}, 1,	0x0643},      
	{1,	{0xDE, 0x00}, 1,	0x0637},      
	/* Keys zxcvnm,./ */
	{1, {0x5A, 0x00}, 1,	0x0626},          
	{1, {0x58, 0x00}, 1,	0x0621},			
	{1, {0x43, 0x00}, 1,	0x0624},			
	{1, {0x56, 0x00}, 1,	0x0631},			
    {1, {0x4E, 0x00}, 1,	0x0649},			
	{1, {0x4D, 0x00}, 1,	0x0629},			
	{1,	{0xBC, 0x00}, 1,	0x0648},      
	{1,	{0xBE, 0x00}, 1,	0x0632},      
	{1,	{0xBF, 0x00}, 1,	0x0638},      
// With VK_SHIFT
	/* Keys `1234567890-= */
	{2, {0x10, 0xC0}, 1,	0x0651},     
	{2,	{0x10, 0x31}, 1,	0x0021},      
    {2,	{0x10, 0x32}, 1,	0x0040},     
    {2,	{0x10, 0x33}, 1,	0x0023},      
	{2,	{0x10, 0x34}, 1,	0x0024},      
    {2,	{0x10, 0x35}, 1,	0x0025},      
    {2,	{0x10, 0x36}, 1,	0x005E},     
    {2,	{0x10, 0x37}, 1,	0x0026},     
	{2,	{0x10, 0x38}, 1,	0x002A},     
    {2,	{0x10, 0x39}, 1,	0x0029},     
	{2,	{0x10, 0x30}, 1,	0x0028},      
	{2,	{0x10, 0xBD}, 1,	0x005F},     
	{2,	{0x10, 0xBB}, 1,	0x002B},      
	/* Keys qweryuiop[]\ */
	{2, {0x10, 0x51}, 1,	0x064E},			
	{2, {0x10, 0x57}, 1,	0x064B},			
	{2, {0x10, 0x45}, 1,	0x064F},		
	{2, {0x10, 0x52}, 1,	0x064C},			
	{2, {0x10, 0x59}, 1,	0x0625},			
	{2, {0x10, 0x55}, 1,	0x2018},			
	{2, {0x10, 0x49}, 1,	0x00F7},			
	{2, {0x10, 0x4F}, 1,	0x00D7},			
	{2, {0x10, 0x50}, 1,	0x061B},			
	{2, {0x10, 0xDB}, 1,	0x003C},            
	{2, {0x10, 0xDD}, 1,	0x003E},		
	{2, {0x10, 0xDC}, 1,	0x007C},			
	/* Keys asdfhjkl;' */
	{2, {0x10, 0x41}, 1,	0x0650},			
	{2, {0x10, 0x53}, 1,	0x064D},			
	{2, {0x10, 0x44}, 1,	0x005D},			
	{2, {0x10, 0x46}, 1,	0x005B},			
    {2, {0x10, 0x48}, 1,	0x0623},			
	{2, {0x10, 0x4A}, 1,	0x0640},			
	{2, {0x10, 0x4B}, 1,	0x060C},			
	{2, {0x10, 0x4C}, 1,	0x002F},			
	{2, {0x10, 0xBA}, 1,	0x003A},    
	{2,	{0x10, 0xDE}, 1,	0x0022},     
	/* Keys zxcvnm,./ */
	{2, {0x10, 0x5A}, 1,	0x007E},          
	{2, {0x10, 0x58}, 1,	0x0652},			
	{2, {0x10, 0x43}, 1,	0x007D},			
	{2, {0x10, 0x56}, 1,	0x007B},			
    {2, {0x10, 0x4E}, 1,	0x0622},			
	{2, {0x10, 0x4D}, 1,	0x2019},			
	{2,	{0x10, 0xBC}, 1,	0x002C},     
	{2,	{0x10, 0xBE}, 1,	0x002E},      
	{2,	{0x10, 0xBF}, 1,	0x061F},
// Control chars
	// Row ZXCV
 	{2, {0x11, 90}, 1, 0x1A},			// Ctrl Z
	{2, {0x11, 88}, 1, 0x18},			// Ctrl X
	{2, {0x11, 67}, 1, 0x03},			// Ctrl C
	{2, {0x11, 86}, 1, 0x16},			// Ctrl V
	{2, {0x11, 66}, 1, 0x02},			// Ctrl B
    {2, {0x11, 78}, 1, 0x0E},			// Ctrl N
	{2, {0x11, 77}, 1, 0x0D},			// Ctrl M
	//Row ASDF
	{2, {0x11, 65}, 1, 0x01},			// Ctrl A
	{2, {0x11, 83}, 1, 0x13},			// Ctrl S
	{2, {0x11, 68}, 1, 0x04},			// Ctrl D
	{2, {0x11, 70}, 1, 0x06},			// Ctrl F
	{2, {0x11, 71}, 1, 0x07},			// Ctrl G
    {2, {0x11, 72}, 1, 0x08},			// Ctrl H
	{2, {0x11, 74}, 1, 0x0A},			// Ctrl J
	{2, {0x11, 75}, 1, 0x0B},			// Ctrl K
	{2, {0x11, 76}, 1, 0x0C},			// Ctrl L
	// Row QWER
	{2, {0x11, 81}, 1, 0x11},			// Ctrl Q
	{2, {0x11, 87}, 1, 0x17},			// Ctrl W
	{2, {0x11, 69}, 1, 0x05},			// Ctrl E
	{2, {0x11, 82}, 1, 0x12},			// Ctrl R
	{2, {0x11, 84}, 1, 0x14},			// Ctrl T
	{2, {0x11, 89}, 1, 0x19},			// Ctrl Y
	{2, {0x11, 85}, 1, 0x15},			// Ctrl U
	{2, {0x11, 73}, 1, 0x09},			// Ctrl I
	{2, {0x11, 79}, 1, 0x0F},			// Ctrl O
	{2, {0x11, 80}, 1, 0x10},			// Ctrl P
// Keystrokes that generate multiple chars
	{1, {0x42, 0x00}, 2,	{0x0644, 0x0627}}, // Key B
	{2, {0x10, 0x54}, 2,	{0x0644, 0x0625}}, // Keys Shift + T
	{2, {0x10, 0x47}, 2,	{0x0644, 0x0623}}, // Keys Shift + G
	{2, {0x10, 0x42}, 2,	{0x0644, 0x0622}}, // Keys Shift + B
}; // end Arabic (101) keyboard

// ****************************************************
// Saudi Arabia keyboard (102)
//
// The keystrokes, not generate WM_CHARs, are not added yet.
// While ARA 102 is built into image, they should be included.
//
//  Num  VK1   VK2	  Num	Unicode
testSequence KBDTests_Arabic_102[] = 
{
// Without VK_SHIFT
	{1,	{0x20, 0x00}, 1,	0x0020}, // Space key
	{1,	{0x1B, 0x00}, 1,	0x001B}, // Esc key
	{1,	{0x08, 0x00}, 1,	0x0008}, // BackSpace key
	{1,	{0x0D, 0x00}, 1,	0x000D}, // Enter key
	/* Keys `1234567890-= */
	{1, {0xC0, 0x00}, 1,	0x003E},      
	{1, {0x31, 0x00}, 1,	0x0031},      
    {1,	{0x32, 0x00}, 1,	0x0032},      
   	{1,	{0x33, 0x00}, 1,	0x0033},      
	{1,	{0x34, 0x00}, 1,	0x0034},      
    {1,	{0x35, 0x00}, 1,	0x0035},      
    {1,	{0x36, 0x00}, 1,	0x0036},      
    {1,	{0x37, 0x00}, 1,	0x0037},      
	{1,	{0x38, 0x00}, 1,	0x0038},      
    {1,	{0x39, 0x00}, 1,	0X0039},      
	{1,	{0x30, 0x00}, 1,	0x0030},      
	{1,	{0xBD, 0x00}, 1,	0x002D},      
	{1,	{0xBB, 0x00}, 1,	0x003D},      
	/* Keys qwertyuiop[]\ */
	{1, {0x51, 0x00}, 1,	0x0636},			
	{1, {0x57, 0x00}, 1,	0x0635},			
	{1, {0x45, 0x00}, 1,	0x062B},			
	{1, {0x52, 0x00}, 1,	0x0642},			
	{1, {0x54, 0x00}, 1,	0x0641},			
	{1, {0x59, 0x00}, 1,	0x063A},			
	{1, {0x55, 0x00}, 1,	0x0639},			
	{1, {0x49, 0x00}, 1,	0x0647},			
	{1, {0x4F, 0x00}, 1,	0x062E},			
	{1, {0x50, 0x00}, 1,	0x062D},			
	{1, {0xDB, 0x00}, 1,	0x062C},            
	{1, {0xDD, 0x00}, 1,	0x062F},			
	{1, {0xDC, 0x00}, 1,	0x0630},			
	/* Keys asdfghjkl;' */
	{1, {0x41, 0x00}, 1,	0x0634},			
	{1, {0x53, 0x00}, 1,	0x0633},			
	{1, {0x44, 0x00}, 1,	0x064A},			
	{1, {0x46, 0x00}, 1,	0x0628},			
	{1, {0x47, 0x00}, 1,	0x0644},			
    {1, {0x48, 0x00}, 1,	0x0627},			
	{1, {0x4A, 0x00}, 1,	0x062A},			
	{1, {0x4B, 0x00}, 1,	0x0646},			
	{1, {0x4C, 0x00}, 1,	0x0645},			
	{1, {0xBA, 0x00}, 1,	0x0643},      
	{1, {0xDE, 0x00}, 1,	0x0637},      
	/* Keys zxcvnm,./ */
	{1, {0x5A, 0x00}, 1,	0x0626},          
	{1, {0x58, 0x00}, 1,	0x0621},			
	{1, {0x43, 0x00}, 1,	0x0624},			
	{1, {0x56, 0x00}, 1,	0x0631},			
	{1, {0x4E, 0x00}, 1,	0x0649},			
	{1, {0x4D, 0x00}, 1,	0x0629},      
	{1, {0xBC, 0x00}, 1,	0x0648},
	{1, {0xBE, 0x00}, 1,	0x0632},      
	{1, {0xBF, 0x00}, 1,	0x0638},      
// With VK_SHIFT
	/* Keys `1234567890-= */
	{2, {0x10, 0xC0}, 1,	0x003C},     
	{2,	{0x10, 0x31}, 1,	0x0021},      
    {2,	{0x10, 0x32}, 1,	0x0040},     
    {2,	{0x10, 0x33}, 1,	0x0023},      
	{2,	{0x10, 0x34}, 1,	0x0024},      
    {2,	{0x10, 0x35}, 1,	0x0025},      
    {2,	{0x10, 0x36}, 1,	0x005E},     
    {2,	{0x10, 0x37}, 1,	0x0026},     
	{2,	{0x10, 0x38}, 1,	0x002A},     
    {2,	{0x10, 0x39}, 1,	0x0029},     
	{2,	{0x10, 0x30}, 1,	0x0028},      
	{2,	{0x10, 0xBD}, 1,	0x005F},     
	{2,	{0x10, 0xBB}, 1,	0x002B},      
	/* Keys qweryuiop[]\ */
	{2, {0x10, 0x51}, 1,	0x064E},			
	{2, {0x10, 0x57}, 1,	0x064B},			
	{2, {0x10, 0x45}, 1,	0x064F},		
	{2, {0x10, 0x52}, 1,	0x064C},			
	{2, {0x10, 0x59}, 1,	0x0625},			
	{2, {0x10, 0x55}, 1,	0x2018},			
	{2, {0x10, 0x49}, 1,	0x00F7},			
	{2, {0x10, 0x4F}, 1,	0x00D7},			
	{2, {0x10, 0x50}, 1,	0x061B},			
	{2, {0x10, 0xDB}, 1,	0x007D},            
	{2, {0x10, 0xDD}, 1,	0x007B},		
	{2, {0x10, 0xDC}, 1,	0x0651},			
	/* Keys asdfhjkl;' */
	{2, {0x10, 0x41}, 1,	0x005C},			
	{2, {0x10, 0x53}, 1,	0x0000},			
	{2, {0x10, 0x44}, 1,	0x005D},			
	{2, {0x10, 0x46}, 1,	0x005B},			
    {2, {0x10, 0x48}, 1,	0x0623},			
	{2, {0x10, 0x4A}, 1,	0x0640},			
	{2, {0x10, 0x4B}, 1,	0x060C},			
	{2, {0x10, 0x4C}, 1,	0x002F},			
	{2, {0x10, 0xBA}, 1,	0x003A},    
	{2, {0x10, 0xDE}, 1,	0x0022},     
	/* Keys zxcvnm,./ */
	{2, {0x10, 0x5A}, 1,	0x007E},          
	{2, {0x10, 0x58}, 1,	0x0652},			
	{2, {0x10, 0x43}, 1,	0x0650},			
	{2, {0x10, 0x56}, 1,	0x064D},			
    {2, {0x10, 0x4E}, 1,	0x0622},			
	{2, {0x10, 0x4D}, 1,	0x2019},			
	{2, {0x10, 0xBC}, 1,	0x002C},     
	{2, {0x10, 0xBE}, 1,	0x002E},      
	{2, {0x10, 0xBF}, 1,	0x061F},
// Control chars (With VK_CONTROL)
	// Row ZXCV
 	{2, {0x11, 90}, 1, 0x1A},          // Ctrl Z
	{2, {0x11, 88}, 1, 0x18},			// Ctrl X
	{2, {0x11, 67}, 1, 0x03},			// Ctrl C
	{2, {0x11, 86}, 1, 0x16},			// Ctrl V
	{2, {0x11, 66}, 1, 0x02},			// Ctrl B
    {2, {0x11, 78}, 1, 0x0E},			// Ctrl N
	{2, {0x11, 77}, 1, 0x0D},			// Ctrl M
	//Row ASDF
	{2, {0x11, 65}, 1, 0x01},			// Ctrl A
	{2, {0x11, 83}, 1, 0x13},			// Ctrl S
	{2, {0x11, 68}, 1, 0x04},			// Ctrl D
	{2, {0x11, 70}, 1, 0x06},			// Ctrl F
	{2, {0x11, 71}, 1, 0x07},			// Ctrl G
    {2, {0x11, 72}, 1, 0x08},			// Ctrl H
	{2, {0x11, 74}, 1, 0x0A},			// Ctrl J
	{2, {0x11, 75}, 1, 0x0B},			// Ctrl K
	{2, {0x11, 76}, 1, 0x0C},			// Ctrl L
	// Row QWER
	{2, {0x11, 81}, 1, 0x11},			// Ctrl Q
	{2, {0x11, 87}, 1, 0x17},			// Ctrl W
	{2, {0x11, 69}, 1, 0x05},			// Ctrl E
	{2, {0x11, 82}, 1, 0x12},			// Ctrl R
	{2, {0x11, 84}, 1, 0x14},			// Ctrl T
	{2, {0x11, 89}, 1, 0x19},			// Ctrl Y
	{2, {0x11, 85}, 1, 0x15},			// Ctrl U
	{2, {0x11, 73}, 1, 0x09},			// Ctrl I
	{2, {0x11, 79}, 1, 0x0F},			// Ctrl O
	{2, {0x11, 80}, 1, 0x10},			// Ctrl P
// With ALT-Gr key (VK_CONTROL, VK_MENU)
	{3, {0x0011, 0x0012, 0x0034}, 1, 0x00A4}, // Ctrl + Alt + 4
// Keystrokes that generate multiple chars
	{1, {0x42, 0x00      },	2,	{0x0644, 0x0627}}, // Key B
	{2, {0x10, 0x54      }, 2,	{0x0644, 0x0625}}, // Keys Shift + T
	{2, {0x10, 0x47      }, 2,	{0x0644, 0x0623}}, // Keys Shift + G
	{2, {0x10, 0x42      }, 2,	{0x0644, 0x0622}}, // Keys Shift + B
	{3, {0x11, 0x12, 0x51}, 2,	{0x0651, 0x064E}}, // Ctrl + Alt + Q
	{3, {0x11, 0x12, 0x57}, 2,	{0x0651, 0x064B}}, // Ctrl + Alt + W
	{3, {0x11, 0x12, 0x45}, 2,	{0x0651, 0x064F}}, // Ctrl + Alt + E
	{3, {0x11, 0x12, 0x52}, 2,	{0x0651, 0x064C}}, // Ctrl + Alt + R
	{3, {0x11, 0x12, 0x56}, 2,	{0x0651, 0x064D}}, // Ctrl + Alt + V
}; // end Arabic (102) keyboard

// ****************************************************
// Thai keyboard - Kedmanee
//
//  Num  VK1   VK2	  Num	Unicode
testSequence KBDTests_Thai[] = 
{
// With CAPSLOCK OFF
  // Without VK_SHIFT
	{1,	{0x20, 0x00}, 1,	0x0020}, // Space key
	{1,	{0x1B, 0x00}, 1,	0x001B}, // Esc key
	{1,	{0x08, 0x00}, 1,	0x0008}, // BackSpace key
	{1,	{0x0D, 0x00}, 1,	0x000D}, // Enter key
	{1,	{0x09, 0x00}, 1,	0x0009}, // Tab key
	/* Keys `1234567890-= */
	{1, {0xC0, 0x00}, 1,	0x005F},      
	{1, {0x31, 0x00}, 1,	0x0E45},      
    {1,	{0x32, 0x00}, 1,	0x002F},      
   	{1,	{0x33, 0x00}, 1,	0x002D},      
	{1,	{0x34, 0x00}, 1,	0x0E20},      
    {1,	{0x35, 0x00}, 1,	0x0E16},      
    {1,	{0x36, 0x00}, 1,	0x0E38},      
    {1,	{0x37, 0x00}, 1,	0x0E36},      
	{1,	{0x38, 0x00}, 1,	0x0E04},      
    {1,	{0x39, 0x00}, 1,	0X0E15},      
	{1,	{0x30, 0x00}, 1,	0x0E08},      
	{1,	{0xBD, 0x00}, 1,	0x0E02},      
	{1,	{0xBB, 0x00}, 1,	0x0E0A},      
	/* Keys qwertyuiop[]\ */
	{1, {0x51, 0x00}, 1,	0x0E46},			
	{1, {0x57, 0x00}, 1,	0x0E44},			
	{1, {0x45, 0x00}, 1,	0x0E33},			
	{1, {0x52, 0x00}, 1,	0x0E1E},			
	{1, {0x54, 0x00}, 1,	0x0E30},			
	{1, {0x59, 0x00}, 1,	0x0E31},			
	{1, {0x55, 0x00}, 1,	0x0E35},			
	{1, {0x49, 0x00}, 1,	0x0E23},			
	{1, {0x4F, 0x00}, 1,	0x0E19},			
	{1, {0x50, 0x00}, 1,	0x0E22},			
	{1, {0xDB, 0x00}, 1,	0x0E1A},            
	{1, {0xDD, 0x00}, 1,	0x0E25},			
	{1, {0xDC, 0x00}, 1,	0x0E03},			
	/* Keys asdfghjkl;' */
	{1, {0x41, 0x00}, 1,	0x0E1F},			
	{1, {0x53, 0x00}, 1,	0x0E2B},			
	{1, {0x44, 0x00}, 1,	0x0E01},			
	{1, {0x46, 0x00}, 1,	0x0E14},			
	{1, {0x47, 0x00}, 1,	0x0E40},			
    {1, {0x48, 0x00}, 1,	0x0E49},			
	{1, {0x4A, 0x00}, 1,	0x0E48},			
	{1, {0x4B, 0x00}, 1,	0x0E32},			
	{1, {0x4C, 0x00}, 1,	0x0E2A},			
	{1, {0xBA, 0x00}, 1,	0x0E27},      
	{1, {0xDE, 0x00}, 1,	0x0E07},      
	/* Keys zxcvbnm,./ */
	{1, {0x5A, 0x00}, 1,	0x0E1C},          
	{1, {0x58, 0x00}, 1,	0x0E1B},			
	{1, {0x43, 0x00}, 1,	0x0E41},			
	{1, {0x56, 0x00}, 1,	0x0E2D},
	{1, {0x42, 0x00}, 1,	0x0E34},			
	{1, {0x4E, 0x00}, 1,	0x0E37},			
	{1, {0x4D, 0x00}, 1,	0x0E17},      
	{1, {0xBC, 0x00}, 1,	0x0E21},
	{1, {0xBE, 0x00}, 1,	0x0E43},      
	{1, {0xBF, 0x00}, 1,	0x0E1D},
  // With VK_SHIFT
	/* Keys `1234567890-= */
	{2, {0x10, 0xC0}, 1,	0x0025},     
	{2,	{0x10, 0x31}, 1,	0x002B},      
    {2,	{0x10, 0x32}, 1,	0x0E51},     
    {2,	{0x10, 0x33}, 1,	0x0E52},      
	{2,	{0x10, 0x34}, 1,	0x0E53},      
    {2,	{0x10, 0x35}, 1,	0x0E54},      
    {2,	{0x10, 0x36}, 1,	0x0E39},     
    {2,	{0x10, 0x37}, 1,	0x0E3F},     
	{2,	{0x10, 0x38}, 1,	0x0E55},     
    {2,	{0x10, 0x39}, 1,	0x0E56},     
	{2,	{0x10, 0x30}, 1,	0x0E57},      
	{2,	{0x10, 0xBD}, 1,	0x0E58},     
	{2,	{0x10, 0xBB}, 1,	0x0E59},      
	/* Keys qwertyuiop[]\ */
	{2, {0x10, 0x51}, 1,	0x0E50},			
	{2, {0x10, 0x57}, 1,	0x0022},			
	{2, {0x10, 0x45}, 1,	0x0E0E},		
	{2, {0x10, 0x52}, 1,	0x0E11},			
	{2, {0x10, 0x54}, 1,	0x0E18},
	{2, {0x10, 0x59}, 1,	0x0E4D},			
	{2, {0x10, 0x55}, 1,	0x0E4A},			
	{2, {0x10, 0x49}, 1,	0x0E13},			
	{2, {0x10, 0x4F}, 1,	0x0E2F},			
	{2, {0x10, 0x50}, 1,	0x0E0D},			
	{2, {0x10, 0xDB}, 1,	0x0E10},            
	{2, {0x10, 0xDD}, 1,	0x002C},		
	{2, {0x10, 0xDC}, 1,	0x0E05},			
	/* Keys asdfhjkl;' */
	{2, {0x10, 0x41}, 1,	0x0E24},			
	{2, {0x10, 0x53}, 1,	0x0E06},			
	{2, {0x10, 0x44}, 1,	0x0E0F},			
	{2, {0x10, 0x46}, 1,	0x0E42},
	{2, {0x10, 0x47}, 1,	0x0E0C},			
    {2, {0x10, 0x48}, 1,	0x0E47},			
	{2, {0x10, 0x4A}, 1,	0x0E4B},			
	{2, {0x10, 0x4B}, 1,	0x0E29},			
	{2, {0x10, 0x4C}, 1,	0x0E28},			
	{2, {0x10, 0xBA}, 1,	0x0E0B},    
	{2, {0x10, 0xDE}, 1,	0x002E},     
	/* Keys zxcvbnm,./ */
	{2, {0x10, 0x5A}, 1,	0x0028},          
	{2, {0x10, 0x58}, 1,	0x0029},			
	{2, {0x10, 0x43}, 1,	0x0E09},			
	{2, {0x10, 0x56}, 1,	0x0E2E},			
	{2, {0x10, 0x42}, 1,	0x0E3A},
    {2, {0x10, 0x4E}, 1,	0x0E4C},			
	{2, {0x10, 0x4D}, 1,	0x003F},			
	{2, {0x10, 0xBC}, 1,	0x0E12},     
	{2, {0x10, 0xBE}, 1,	0x0E2C},      
	{2, {0x10, 0xBF}, 1,	0x0E26},
  // Control chars (with VK_CONTROL)
	// Row ZXCV
 	{2, {0x11, 90}, 1, 0x1A},			// Ctrl Z
	{2, {0x11, 88}, 1, 0x18},			// Ctrl X
	{2, {0x11, 67}, 1, 0x03},			// Ctrl C
	{2, {0x11, 86}, 1, 0x16},			// Ctrl V
	{2, {0x11, 66}, 1, 0x02},			// Ctrl B
    {2, {0x11, 78}, 1, 0x0E},			// Ctrl N
	{2, {0x11, 77}, 1, 0x0D},			// Ctrl M
	//Row ASDF
	{2, {0x11, 65}, 1,0x01},			// Ctrl A
	{2, {0x11, 83}, 1, 0x13},			// Ctrl S
	{2, {0x11, 68}, 1, 0x04},			// Ctrl D
	{2, {0x11, 70}, 1, 0x06},			// Ctrl F
	{2, {0x11, 71}, 1, 0x07},			// Ctrl G
    {2, {0x11, 72}, 1, 0x08},			// Ctrl H
	{2, {0x11, 74}, 1, 0x0A},			// Ctrl J
	{2, {0x11, 75}, 1, 0x0B},			// Ctrl K
	{2, {0x11, 76}, 1, 0x0C},			// Ctrl L
	// Row QWER
	{2, {0x11, 81}, 1, 0x11},			// Ctrl Q
	{2, {0x11, 87}, 1, 0x17},			// Ctrl W
	{2, {0x11, 69}, 1, 0x05},			// Ctrl E
	{2, {0x11, 82}, 1, 0x12},			// Ctrl R
	{2, {0x11, 84}, 1, 0x14},			// Ctrl T
	{2, {0x11, 89}, 1, 0x19},			// Ctrl Y
	{2, {0x11, 85}, 1, 0x15},			// Ctrl U
	{2, {0x11, 73}, 1, 0x09},			// Ctrl I
	{2, {0x11, 79}, 1, 0x0F},			// Ctrl O
	{2, {0x11, 80}, 1, 0x10},			// Ctrl P

// Turn CAPSLOCK ON
	{STATE_CAPSLOCK, {0x10, 0x14}, 0, 0},

// With CAPSLOCK ON
  // Without VK_SHIFT
	{1,	{0x20, 0x00}, 1,	0x0020}, // Space key
	{1,	{0x1B, 0x00}, 1,	0x001B}, // Esc key
	{1,	{0x08, 0x00}, 1,	0x0008}, // BackSpace key
	{1,	{0x0D, 0x00}, 1,	0x000D}, // Enter key
	{1,	{0x09, 0x00}, 1,	0x0009}, // Tab key
	/* Keys `1234567890-= */
	{1, {0xC0, 0x00}, 1,	0x0025},      
	{1, {0x31, 0x00}, 1,	0x002B},      
    {1,	{0x32, 0x00}, 1,	0x0E51},      
   	{1,	{0x33, 0x00}, 1,	0x0E52},      
	{1,	{0x34, 0x00}, 1,	0x0E53},      
    {1,	{0x35, 0x00}, 1,	0x0E54},      
    {1,	{0x36, 0x00}, 1,	0x0E39},      
    {1,	{0x37, 0x00}, 1,	0x0E3f},      
	{1,	{0x38, 0x00}, 1,	0x0E55},      
    {1,	{0x39, 0x00}, 1,	0x0E56},      
	{1,	{0x30, 0x00}, 1,	0x0E57},      
	{1,	{0xBD, 0x00}, 1,	0x0E58},      
	{1,	{0xBB, 0x00}, 1,	0x0E59},      
	/* Keys qwertyuiop[]\ */
	{1, {0x51, 0x00}, 1,	0x0E50},			
	{1, {0x57, 0x00}, 1,	0x0022},			
	{1, {0x45, 0x00}, 1,	0x0E0E},			
	{1, {0x52, 0x00}, 1,	0x0E11},			
	{1, {0x54, 0x00}, 1,	0x0E18},			
	{1, {0x59, 0x00}, 1,	0x0E4D},			
	{1, {0x55, 0x00}, 1,	0x0E4A},			
	{1, {0x49, 0x00}, 1,	0x0E13},			
	{1, {0x4F, 0x00}, 1,	0x0E2F},			
	{1, {0x50, 0x00}, 1,	0x0E0D},			
	{1, {0xDB, 0x00}, 1,	0x0E10},            
	{1, {0xDD, 0x00}, 1,	0x002C},			
	{1, {0xDC, 0x00}, 1,	0x0E05},			
	/* Keys asdfghjkl;' */
	{1, {0x41, 0x00}, 1,	0x0E24},			
	{1, {0x53, 0x00}, 1,	0x0E06},			
	{1, {0x44, 0x00}, 1,	0x0E0F},			
	{1, {0x46, 0x00}, 1,	0x0E42},			
	{1, {0x47, 0x00}, 1,	0x0E0C},			
    {1, {0x48, 0x00}, 1,	0x0E47},			
	{1, {0x4A, 0x00}, 1,	0x0E4B},			
	{1, {0x4B, 0x00}, 1,	0x0E29},			
	{1, {0x4C, 0x00}, 1,	0x0E28},			
	{1, {0xBA, 0x00}, 1,	0x0E0B},      
	{1, {0xDE, 0x00}, 1,	0x002E},      
	/* Keys zxcvbnm,./ */
	{1, {0x5A, 0x00}, 1,	0x0028},          
	{1, {0x58, 0x00}, 1,	0x0029},			
	{1, {0x43, 0x00}, 1,	0x0E09},			
	{1, {0x56, 0x00}, 1,	0x0E2E},
	{1, {0x42, 0x00}, 1,	0x0E3A},			
	{1, {0x4E, 0x00}, 1,	0x0E4C},
	{1, {0x4D, 0x00}, 1,	0x003F},      
	{1, {0xBC, 0x00}, 1,	0x0E12},
	{1, {0xBE, 0x00}, 1,	0x0E2C},      
	{1, {0xBF, 0x00}, 1,	0x0E26},
  // With VK_SHIFT
	/* Keys `1234567890-= */
	{2, {0x10, 0xC0}, 1,	0x005F},     
	{2,	{0x10, 0x31}, 1,	0x0E45},      
    {2,	{0x10, 0x32}, 1,	0x002F},     
    {2,	{0x10, 0x33}, 1,	0x002D},      
	{2,	{0x10, 0x34}, 1,	0x0E20},      
    {2,	{0x10, 0x35}, 1,	0x0E16},      
    {2,	{0x10, 0x36}, 1,	0x0E38},     
    {2,	{0x10, 0x37}, 1,	0x0E36},     
	{2,	{0x10, 0x38}, 1,	0x0E04},     
    {2,	{0x10, 0x39}, 1,	0x0E15},     
	{2,	{0x10, 0x30}, 1,	0x0E08},      
	{2,	{0x10, 0xBD}, 1,	0x0E02},     
	{2,	{0x10, 0xBB}, 1,	0x0E0A},      
	/* Keys qwertyuiop[]\ */
	{2, {0x10, 0x51}, 1,	0x0E46},			
	{2, {0x10, 0x57}, 1,	0x0E44},			
	{2, {0x10, 0x45}, 1,	0x0E33},		
	{2, {0x10, 0x52}, 1,	0x0E1E},			
	{2, {0x10, 0x54}, 1,	0x0E30},
	{2, {0x10, 0x59}, 1,	0x0E31},			
	{2, {0x10, 0x55}, 1,	0x0E35},			
	{2, {0x10, 0x49}, 1,	0x0E23},			
	{2, {0x10, 0x4F}, 1,	0x0E19},			
	{2, {0x10, 0x50}, 1,	0x0E22},			
	{2, {0x10, 0xDB}, 1,	0x0E1A},            
	{2, {0x10, 0xDD}, 1,	0x0E25},		
	{2, {0x10, 0xDC}, 1,	0x0E03},			
	/* Keys asdfhjkl;' */
	{2, {0x10, 0x41}, 1,	0x0E1F},			
	{2, {0x10, 0x53}, 1,	0x0E2B},			
	{2, {0x10, 0x44}, 1,	0x0E01},			
	{2, {0x10, 0x46}, 1,	0x0E14},
	{2, {0x10, 0x47}, 1,	0x0E40},			
    {2, {0x10, 0x48}, 1,	0x0E49},			
	{2, {0x10, 0x4A}, 1,	0x0E48},			
	{2, {0x10, 0x4B}, 1,	0x0E32},			
	{2, {0x10, 0x4C}, 1,	0x0E2A},			
	{2, {0x10, 0xBA}, 1,	0x0E27},    
	{2, {0x10, 0xDE}, 1,	0x0E07},     
	/* Keys zxcvbnm,./ */
	{2, {0x10, 0x5A}, 1,	0x0E1C},          
	{2, {0x10, 0x58}, 1,	0x0E1B},			
	{2, {0x10, 0x43}, 1,	0x0E41},			
	{2, {0x10, 0x56}, 1,	0x0E2D},			
	{2, {0x10, 0x42}, 1,	0x0E34},
    {2, {0x10, 0x4E}, 1,	0x0E37},			
	{2, {0x10, 0x4D}, 1,	0x0E17},			
	{2, {0x10, 0xBC}, 1,	0x0E21},     
	{2, {0x10, 0xBE}, 1,	0x0E43},      
	{2, {0x10, 0xBF}, 1,	0x0E1D},
  // Control chars (with VK_CONTROL)
	// Row ZXCV
 	{2, {0x11, 90}, 1, 0x1A},          // Ctrl Z
	{2, {0x11, 88}, 1, 0x18},			// Ctrl X
	{2, {0x11, 67}, 1, 0x03},			// Ctrl C
	{2, {0x11, 86}, 1, 0x16},			// Ctrl V
	{2, {0x11, 66}, 1, 0x02},			// Ctrl B
    {2, {0x11, 78}, 1, 0x0E},			// Ctrl N
	{2, {0x11, 77}, 1, 0x0D},			// Ctrl M
	//Row ASDF
	{2, {0x11, 65}, 1, 0x01},			// Ctrl A
	{2, {0x11, 83}, 1, 0x13},			// Ctrl S
	{2, {0x11, 68}, 1, 0x04},			// Ctrl D
	{2, {0x11, 70}, 1, 0x06},			// Ctrl F
	{2, {0x11, 71}, 1, 0x07},			// Ctrl G
    {2, {0x11, 72}, 1, 0x08},			// Ctrl H
	{2, {0x11, 74}, 1, 0x0A},			// Ctrl J
	{2, {0x11, 75}, 1, 0x0B},			// Ctrl K
	{2, {0x11, 76}, 1, 0x0C},			// Ctrl L
	// Row QWER
	{2, {0x11, 81}, 1, 0x11},			// Ctrl Q
	{2, {0x11, 87}, 1, 0x17},			// Ctrl W
	{2, {0x11, 69}, 1, 0x05},			// Ctrl E
	{2, {0x11, 82}, 1, 0x12},			// Ctrl R
	{2, {0x11, 84}, 1, 0x14},			// Ctrl T
	{2, {0x11, 89}, 1, 0x19},			// Ctrl Y
	{2, {0x11, 85}, 1, 0x15},			// Ctrl U
	{2, {0x11, 73}, 1, 0x09},			// Ctrl I
	{2, {0x11, 79}, 1, 0x0F},			// Ctrl O
	{2, {0x11, 80}, 1, 0x10},			// Ctrl P

//Turn CAPSLOCK OFF
    {STATE_CAPSLOCK, {0x10, 0x14}, 0,  0},
}; // end Thai keyboard


// ****************************************************
// French keyboard
//
// Simple demo keyboard with deadkeys
//
//  Num  VK1   VK2	  Num	Unicode
testSequence KBDTests_French[] = 
{
	{1,	{0x20, 0x00}, 1,	0x20},		// spacekey results in ' '
    {1, {0x51 }, 1, 0x71},             // 'a' key on US keyboards is the 'q' key on French keyboards.

    {1, {0x31}, 1, 0x26},              // '1' key displays '&' in french keyboard :)
    {2, {VK_SHIFT, 0x31}, 1, 0x31},    // shift + '1' results in '1' on french keyboard
    
    {1, {0x32}, 1, 0xE9},              // '2' key displays 'e' w/ accent on top
    {2, {VK_SHIFT, 0x32}, 1, 0x32},    // shift + '2' results in '2'

    // try out a dead key...
    //{3, {VK_CONTROL, VK_MENU, 0x32}, 1, 0x73}, // ALT-Gr key + '2' results in tilde dead key
	{3, {VK_CONTROL, VK_MENU, 0x32}, 0, 0}, // dead key generate WM_DEADCHAR but not WM_CHAR
    {1, {0x41, }, 1, 0xE3},            // press 'a' key and result is 'a'+tilde

    //{3, {VK_CONTROL, VK_MENU, 0x32}, 1, 0x73}, // ALT-Gr key + '2' results in tilde dead key
	{3, {VK_CONTROL, VK_MENU, 0x32}, 0, 0}, // dead key generate WM_DEADCHAR but not WM_CHAR
	{1, {0x51}, 2, {0x7E, 0x71}},           // dead key doesn't effect 'q'... this keystroke generates two WM_CHARs
}; // end French keyboard


//
// Define keyboards that we want to test and other
// information so we can find/match them in the OS
// image.
//
// To add a keyboard for testing, add its HKL to
// the below list of defines, then add the individual
// test key sequences to a new KBDTests_XXX structure
// above.  Lastly, add the keyboard information as a
// new record to the TestKeyboards[] structure.
//

#define KEYBOARD_NOTESTDATA 0xFFFF

#define HKL_KBD_JAPANESE1  ((HKL) 0xE0010411)
#define HKL_KBD_JAPANESE2  ((HKL) 0xE0020404)

#ifdef UNDER_CE
	#define HKL_KBD_US_QWERTY  ((HKL) 0x00000409)
	#define HKL_KBD_US_DVORAK  ((HKL) 0x00010409)   // PS #68371
	#define HKL_KBD_FRENCH     ((HKL) 0x0000040C)   // French (france) keyboard
	#define HKL_KBD_KOREAN     ((HKL) 0x00000412)
	#define HKL_KBD_HINDI      ((HKL) 0x00010439)   // Hindi Traditional
	#define HKL_KBD_HEBREW     ((HKL) 0x0000040D)   // Hebrew
	#define HKL_KBD_ARABIC     ((HKL) 0x00000401)   // Saudi Arabia (101)
	#define HKL_KBD_ARABIC_102 ((HKL) 0x00010401)   // Saudi Arabia (102)
	#define HKL_KBD_THAI       ((HKL) 0x0000041E)   // Thai Kedmanee
#else
	#define HKL_KBD_US_QWERTY  ((HKL) 0x04090409)   // diff on XP
	#define HKL_KBD_US_DVORAK  ((HKL) 0xF0020409)
	#define HKL_KBD_FRENCH     ((HKL) 0x040C040C)
	#define HKL_KBD_KOREAN     ((HKL) 0x04120412)
	#define HKL_KBD_HINDI      ((HKL) 0xF00C0439)
	#define HKL_KBD_HEBREW     ((HKL) 0x040D040D)
	#define HKL_KBD_ARABIC     ((HKL) 0x04010401)
	#define HKL_KBD_ARABIC_102 ((HKL) 0xF0280401)
	#define HKL_KBD_THAI       ((HKL) 0x041E041E)
#endif

testKeyboard TestKeyboards[] = {
    { HKL_KBD_US_QWERTY,  KBDTests_USEnglish,  countof(KBDTests_USEnglish)},
    { HKL_KBD_US_DVORAK,  KBDTests_USDVORAK,   countof(KBDTests_USDVORAK)},
    { HKL_KBD_JAPANESE1,  KBDTests_Japanese1,  countof(KBDTests_Japanese1)},
    { HKL_KBD_HINDI,      KBDTests_Hindi,      countof(KBDTests_Hindi)},
    { HKL_KBD_HEBREW,     KBDTests_Hebrew,     countof(KBDTests_Hebrew)},
    { HKL_KBD_ARABIC,     KBDTests_Arabic,     countof(KBDTests_Arabic)},
	{ HKL_KBD_ARABIC_102, KBDTests_Arabic_102, countof(KBDTests_Arabic_102)},
    { HKL_KBD_THAI,       KBDTests_Thai,       countof(KBDTests_Thai)},
    { HKL_KBD_FRENCH,     KBDTests_French,     countof(KBDTests_French)},
    
};

//
// GetXXX
//
// The next few functions hide details on how we have arranged
// the test matrix data structure.  Use these functions instead
// of directly accessing the structures so we can change things
// later on easily.  -chetl 11/30/04
//

inline KEYBOARDSTATE GetState(testSequence testSeq[], WORD ndx)
{
    KEYBOARDSTATE newstate = testSeq[ndx].nNumVirtualKeys;
    return (newstate & STATE_STATEMASK);
}

inline VOID GetExpected(testSequence testSeq[], WORD ndx, WCHAR wcaUnicodeChars[])
{
	for(INT i = 0; i < testSeq[ndx].nNumUnicodeChars; i++)
		wcaUnicodeChars[i] = testSeq[ndx].wcaUnicodeChars[i];
    return;
}

inline LPBYTE GetKeys(testSequence testSeq[], WORD ndx)
{
    return testSeq[ndx].byaVirtualKeys;
}

inline WORD GetNumberOfKeys(testSequence testSeq[], WORD ndx)
{
    KEYBOARDSTATE newstate = testSeq[ndx].nNumVirtualKeys;
    return (newstate & STATE_NUMMASK);
}

inline INT GetNumberOfChars(testSequence testSeq[], WORD ndx)
{
   return testSeq[ndx].nNumUnicodeChars;
}
//
// Get_KeyboardTestNdx
//
// Finds a keyboard based on its HKL and returns the index
// for the test data.
//
// Return
//  0xFFFF  no keyboard test data
//  0-200   index into Keyboard test structures
//

inline WORD Get_KeyboardTestNdx(HKL Keyboard)
{
    for(int ndx = 0; ndx < countof(TestKeyboards); ndx++)
    {
        if(TestKeyboards[ndx].InputLocale == Keyboard)
            return ndx;
    }
    return KEYBOARD_NOTESTDATA;
}

//****************************************************************************************
// 
// performKeyMapTest:
// 
//   This function tests the virtual key to unicode mapping in the test sequence
//	 through the keyboard driver.
// 
//Arguments:
// 
//	 struct testSequence * testSeq :  The mapping to be tested
// 
//Return Value:
// 
//	 TUX return value:  TPR_PASS or TPR_FAIL
//
//Notes:
//  The keyboard tests are executed in order, so to test keys in a given state
//  add 1st add a test that puts the keyboard in the state then add tests that
//  test each key, lastly a test that turns off the state.  See keyboard structure
//  at top of file for some examples.
//

TESTPROCAPI performKeyMapTest(testKeyboard *pTestKeyboard) 
{
	testSequence *testSeq = pTestKeyboard->pKeyMaps;
	WORD dwNumberTestCases = pTestKeyboard->numKeyMaps;
	HWND	hTestWnd = NULL;
	DWORD	dwResult = TPR_PASS;
	bool	State_Caps;

    // Following was introduced to make the CAPSLOCK to off. by a-rajtha 10/2/98
    // This works for both US and Japanese keyboards
    BOOL CState=GetKeyState(VK_CAPITAL);
	if(CState) 
    {
		keybd_event(VK_SHIFT,0,0,0);        // why was shift here? -chetl
		keybd_event(VK_CAPITAL, 0, 0, 0 );
		keybd_event(VK_CAPITAL, 0, KEYEVENTF_KEYUP, 0 ); 
		keybd_event(VK_SHIFT, 0, KEYEVENTF_KEYUP,0);
		g_pKato->Log(LOG_DETAIL,TEXT("CapsLOCK turned OFF"));
	}
    else
		g_pKato->Log(LOG_DETAIL,TEXT("CapsLOCK is OFF"));
	State_Caps = false;		// caps lock is toggled off

	hTestWnd = CreateKeyMapTestWindow(g_spsShellInfo.hLib, g_pKato);
	ChangeKeyboard(hTestWnd, pTestKeyboard->InputLocale);

    // loop for each key to test
	for(WORD ndx = 0; ndx < dwNumberTestCases; ndx++) 
    {
		g_pKato->Log(LOG_DETAIL, TEXT("Testing case number %d"), ndx+1);

		// Check if the next char causes keyboard to enter or leave a state.
        // If it is toggle the key... 
		KEYBOARDSTATE newstate = GetState(testSeq, ndx);
        if(newstate)
            switch(newstate)
            {
                case STATE_CAPSLOCK: 
                    {
			            keybd_event (VK_SHIFT,NULL,0,0);        // why shift keys here -chetl
			            keybd_event( VK_CAPITAL, NULL, 0, 0 );
			            keybd_event( VK_CAPITAL, NULL, KEYEVENTF_KEYUP, 0 ); 
			            keybd_event (VK_SHIFT, NULL, KEYEVENTF_KEYUP,0);
			            g_pKato->Log(LOG_DETAIL, TEXT("        ****  CAPS LOCK PRESSED *****"));

                        // Can't use GetKeyState as its state
                        // changes only after the previous messages are processed.
                        // probably have to keep track with our own internal flags -chetl.
                        State_Caps = !State_Caps;
                        if(State_Caps)
                            g_pKato->Log(LOG_DETAIL, TEXT(" CAPSLOCK is now ON"));
			            else 
                            g_pKato->Log(LOG_DETAIL, TEXT(" CAPSLOCK is now OFF"));
                    }
                    break;
                default:
                    g_pKato->Log(LOG_DETAIL, TEXT(" TEST ERROR - Unknown state/toggle pressed"));
                    break;
            }
        else        
        {           // othewise, we are just a series of keystrokes so test them...
			WORD wNumKeys = GetNumberOfKeys(testSeq, ndx);
			LPBYTE pKeys = GetKeys(testSeq, ndx);
			INT nNumChars = GetNumberOfChars(testSeq, ndx);
			WCHAR wcaExpecteds[MAX_NUM_GEN_CHARS];
			GetExpected(testSeq, ndx, wcaExpecteds);
			if(!TestKeyMapChar(g_pKato, hTestWnd, pKeys, wNumKeys, wcaExpecteds, nNumChars))
					dwResult = TPR_FAIL;
        }
	}
	
	RemoveTestWindow(hTestWnd); 

    // warn if a newly added table left the keyboard in a non-default state as that
    // will screw up the next keyboard tested...
    if(State_Caps)
        g_pKato->Log(LOG_DETAIL, TEXT("TEST ERROR - internal keyboard table left CAPS toggled on"));

	//restoring the orignal CAPS lock state. If the caps lock was on leave it on else turn it off. 
	if(CState)
	{
        keybd_event(VK_SHIFT,0,0,0);      // chetl - why shift keys here?
		keybd_event(VK_CAPITAL, 0, 0, 0 );
		keybd_event(VK_CAPITAL, 0, KEYEVENTF_KEYUP, 0 ); 
		keybd_event(VK_SHIFT, 0, KEYEVENTF_KEYUP,0);
        g_pKato->Log(LOG_DETAIL, TEXT(" CAPSLOCK left ON"));
    }

    if(dwResult == TPR_PASS)
        g_pKato->Log(LOG_DETAIL, TEXT(" Tests Passed"));
    else
        g_pKato->Log(LOG_DETAIL, TEXT(" Tests Failed"));

    return dwResult;
}

//
// test_PreHelp
//
// macro that takes care of common TUX tasks for a test procedure.  We may be
// called for number of threads needed for the test or some other reason.  The
// do/while loop forces the macro to act like a statement/function call with a
// required semicolon.  -ctl 11/30/04
//

#define test_PreHelp(uMsg, tpParam)         \
do{                                         \
	if( uMsg == TPM_QUERY_THREAD_COUNT )    \
	{                                       \
		((LPTPS_QUERY_THREAD_COUNT)tpParam)->dwThreadCount = 0; \
		return SPR_HANDLED;                 \
	}                                       \
	else if (uMsg != TPM_EXECUTE)           \
	{                                       \
		return TPR_NOT_HANDLED;             \
	}                                       \
}while(false) 


//
// IsKeyboardInImage
//
// Looks for a given keyboard in the OS Image
//
// Return Code
//  true    if keyboard is included in the OS Image
//  false   otherwise
//

bool IsKeyboardInImage(HKL FindKeyboard)
{
    // Get number of keyboards in the OS image
    // then allocate memory to hold their identifiers and then get
    // the actual input locale identifiers.
    UINT numKeyboards = GetKeyboardLayoutList(0, NULL);
    // if no keyboards (maybe we are a phone etc..) then we are done
    if(numKeyboards == 0)
    {
    	g_pKato->Log(LOG_DETAIL, TEXT("GetKeyboardLayoutList reports no keyboards in image"));
        return false;
    }

    HKL *pKeyboardList = new HKL[numKeyboards];
    if(!pKeyboardList)
    {
        g_pKato->Log(LOG_DETAIL, TEXT("test error: could not allocate memory"));
        return false;
    }

    GetKeyboardLayoutList(numKeyboards, pKeyboardList);

    for(WORD ndx = 0; ndx < numKeyboards; ndx++)
        if(pKeyboardList[ndx] == FindKeyboard)
            return true;

    return false;
}

//
// startKeyMapTest, helper function designed for cleaning up test functions
//
TESTPROCAPI startKeyMapTest(HKL InputLocaleID)
{
	WORD wResult = TPR_PASS;

	if(!IsKeyboardInImage(InputLocaleID))
    {
    	g_pKato->Log(LOG_DETAIL, TEXT("Keyboard is not installed/active in OS image, skipping test"));
        return TPR_SKIP;
    }
    // if we have test data on this keyboard, then test it
    WORD wTestndx = Get_KeyboardTestNdx(InputLocaleID);
    if(wTestndx != KEYBOARD_NOTESTDATA)
    	wResult = performKeyMapTest(&TestKeyboards[wTestndx]);
    else
        g_pKato->Log(LOG_DETAIL, TEXT("*** TEST ERROR *** No data for the keyboard"));

	return wResult;
}

//****************************************************************************************

TESTPROCAPI testUSKeyMapping( UINT uMsg, TPPARAM tpParam, LPFUNCTION_TABLE_ENTRY lpFTE )
{
    test_PreHelp(uMsg, tpParam);

	g_pKato->Log(LOG_DETAIL, TEXT("Beginning US English keyboard mapping test"));

    return startKeyMapTest(HKL_KBD_US_QWERTY);
}


TESTPROCAPI testJapKeyMapping( UINT uMsg, TPPARAM tpParam, LPFUNCTION_TABLE_ENTRY lpFTE )
{
    test_PreHelp(uMsg, tpParam);

	g_pKato->Log(LOG_DETAIL, TEXT("Beginning Japanese-English keyboard mapping test"));

	return startKeyMapTest(HKL_KBD_JAPANESE1);
}
//
// test_AllKeyboardsinImage
//
// finds each keyboard stored in the CE OS image and then test it provided
// we have information on that keyboard.
//

TESTPROCAPI test_AllKeyboardsinImage( UINT uMsg, TPPARAM tpParam, LPFUNCTION_TABLE_ENTRY lpFTE )
{
    WORD wResult = TPR_PASS;
    static TCHAR CurrKeyboardName[KL_NAMELENGTH];
    test_PreHelp(uMsg, tpParam);

    // Remember old active keyboard layout 
    HKL oldLayout = GetKeyboardLayout(NULL);

    // Get number of keyboards in the OS image that we need to test
    // then allocate memory to hold their identifiers and then get
    // the actual input locale identifiers.
    UINT numKeyboards = GetKeyboardLayoutList(0, NULL);
    g_pKato->Log(LOG_DETAIL, TEXT("Found %d keyboard(s) to test"), numKeyboards);

    // if no keyboards (maybe we are a phone etc..) then
    // skip this test...
    if(numKeyboards == 0)
        return TPR_SKIP;

    HKL *pKeyboardList = new HKL[numKeyboards];
    if(!pKeyboardList)
        return TPR_FAIL;
    GetKeyboardLayoutList(numKeyboards, pKeyboardList);

    // test each keyboard in image
    for(UINT ndx = 0; ndx < numKeyboards; ndx++)
    {
        // Get name of each keyboard
        HKL CurrHKL = pKeyboardList[ndx];
        ActivateKeyboardLayout(CurrHKL, NULL);
        GetKeyboardLayoutName(CurrKeyboardName);
        g_pKato->Log(LOG_DETAIL, TEXT("Test keyboard with HKL 0x%04x named %s"), CurrHKL, CurrKeyboardName);

        // if we have test data on this keyboard, then test it
        WORD wTestndx = Get_KeyboardTestNdx(CurrHKL);
        if(wTestndx != KEYBOARD_NOTESTDATA)
        {
	        g_pKato->Log(LOG_DETAIL, TEXT("Beginning %s keyboard mapping test"), CurrKeyboardName);

	        if(performKeyMapTest(&TestKeyboards[wTestndx]) != TPR_PASS)
            {
    	        g_pKato->Log(LOG_DETAIL, TEXT("** FAILED ** test failed on keyboard"));
                wResult = TPR_FAIL;
            }
        } 
        else    // othewise notify user we skipped this keyboard
        {
   	        g_pKato->Log(LOG_DETAIL, TEXT("No test data for keyboard"));
         
        }
    }

    delete [] pKeyboardList;        // throw away list of keyboards
    pKeyboardList = NULL;

    // reset active keyboard layout to be whatever was active prior to our test
    ActivateKeyboardLayout(oldLayout, NULL);

    return wResult;
}

//
// testARAKeyMapping
//
TESTPROCAPI testARAKeyMapping( UINT uMsg, TPPARAM tpParam, LPFUNCTION_TABLE_ENTRY lpFTE )
{
    test_PreHelp(uMsg, tpParam);

	g_pKato->Log(LOG_DETAIL, TEXT("Beginning ARA (101) keyboard mapping test"));

	return startKeyMapTest(HKL_KBD_ARABIC);
}

//
// testARA102KeyMapping
//
TESTPROCAPI testARA102KeyMapping( UINT uMsg, TPPARAM tpParam, LPFUNCTION_TABLE_ENTRY lpFTE )
{
    test_PreHelp(uMsg, tpParam);

	g_pKato->Log(LOG_DETAIL, TEXT("Beginning ARA (102) keyboard mapping test"));

	return startKeyMapTest(HKL_KBD_ARABIC_102);
}

// 
// testHEBKeyMapping
//
TESTPROCAPI testHEBKeyMapping(UINT uMsg, TPPARAM tpParam, LPFUNCTION_TABLE_ENTRY lpFTE)
{
    test_PreHelp(uMsg, tpParam);

	g_pKato->Log(LOG_DETAIL, TEXT("Beginning Hebrew keyboard mapping test"));

	return startKeyMapTest(HKL_KBD_HEBREW);
}

// 
// testHINKeyMapping
//
TESTPROCAPI testHINKeyMapping(UINT uMsg, TPPARAM tpParam, LPFUNCTION_TABLE_ENTRY lpFTE)
{
    test_PreHelp(uMsg, tpParam);

	g_pKato->Log(LOG_DETAIL, TEXT("Beginning Hindi keyboard mapping test"));

	return startKeyMapTest(HKL_KBD_HINDI);
}

// 
// testTHAKeyMapping
//
TESTPROCAPI testTHAKeyMapping(UINT uMsg, TPPARAM tpParam, LPFUNCTION_TABLE_ENTRY lpFTE)
{
    test_PreHelp(uMsg, tpParam);

	g_pKato->Log(LOG_DETAIL, TEXT("Beginning Thai keyboard mapping test"));

	return startKeyMapTest(HKL_KBD_THAI);
}