//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft shared
// source or premium shared source license agreement under which you licensed
// this source code. If you did not accept the terms of the license agreement,
// you are not authorized to use this source code. For the terms of the license,
// please see the license agreement between you and Microsoft or, if applicable,
// see the SOURCE.RTF on your install media or the root of your tools installation.
// THE SOURCE CODE IS PROVIDED "AS IS", WITH NO WARRANTIES.
//
/**************************************************************************


Module Name:

   rgnData.h 

Abstract:

   Code used by region tests

***************************************************************************/
#ifndef __RGNDATA_H__
#define __RGNDATA_H__

// for logging output
static TCHAR *rRectNames[] = {
      TEXT("Top Left"),
      TEXT("Top Center"),
      TEXT("Top Right"),
      TEXT("Cente RightLeft"),
      TEXT("Cente RightCenter"),
      TEXT("Cente RightRight"),
      TEXT("Bottom Left"),
      TEXT("Bottom Center"),
      TEXT("Bottom Right"),
      TEXT("Side by Side"),
      TEXT("Share a point LT"),
      TEXT("Share a point RT"),
      TEXT("Share a point LB"),
      TEXT("Share a point RB"),
      TEXT("Identical"),
};


static int unionMode[] = {
      RGN_AND,          // same as RGN_MIN
      RGN_COPY,         // same as RGN_MAX	
      RGN_DIFF,	
      RGN_OR,	
      RGN_XOR,	
};

extern RECT center;
extern void setTestRectRgn(void);

// calc number of tests
static int   uTests = sizeof(unionMode)/sizeof(int);


// references to predefined arrays 
static int passArray[3][3] = {  
   // test index, union index, result         
   {  9,          0,             NULLREGION     },   
   {  0,          0,             SIMPLEREGION   },
   {  0,          2,             COMPLEXREGION  },
};


// what NT came up with for region testing
static RECT NTResults[75][5] = {
   {{  1,   0,   0,   0},{  50,  50,  75,  75},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  1,   0,   0,   0},{  75,  50, 125,  75},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  1,   0,   0,   0},{ 125,  50, 150,  75},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  1,   0,   0,   0},{  50,  75,  75, 125},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  1,   0,   0,   0},{  75,  75, 125, 125},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  1,   0,   0,   0},{ 125,  75, 150, 125},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  1,   0,   0,   0},{  50, 125,  75, 150},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  1,   0,   0,   0},{  75, 125, 125, 150},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  1,   0,   0,   0},{ 125, 125, 150, 150},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  1,   0,   0,   0},{  50,  50,  51,  51},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  1,   0,   0,   0},{ 149,  50, 150,  51},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  1,   0,   0,   0},{  50, 149,  51, 150},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  1,   0,   0,   0},{ 149, 149, 150, 150},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  1,   0,   0,   0},{  50,  50, 150, 150},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  1,   0,   0,   0},{  25,  25,  75,  75},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  1,   0,   0,   0},{  75,  25, 125,  75},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  1,   0,   0,   0},{ 125,  25, 175,  75},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  1,   0,   0,   0},{  25,  75,  75, 125},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  1,   0,   0,   0},{  75,  75, 125, 125},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  1,   0,   0,   0},{ 125,  75, 175, 125},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  1,   0,   0,   0},{  25, 125,  75, 175},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  1,   0,   0,   0},{  75, 125, 125, 175},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  1,   0,   0,   0},{ 125, 125, 175, 175},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  1,   0,   0,   0},{ 175,  50, 275, 150},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  1,   0,   0,   0},{  25,  25,  51,  51},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  1,   0,   0,   0},{ 149,  25, 175,  51},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  1,   0,   0,   0},{  25, 149,  51, 175},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  1,   0,   0,   0},{ 149, 149, 175, 175},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  1,   0,   0,   0},{  50,  50, 150, 150},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  2,   0,   0,   0},{  25,  25,  75,  50},{  25,  50,  50,  75},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  1,   0,   0,   0},{  75,  25, 125,  50},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  2,   0,   0,   0},{ 125,  25, 175,  50},{ 150,  50, 175,  75},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  1,   0,   0,   0},{  25,  75,  50, 125},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  1,   0,   0,   0},{ 150,  75, 175, 125},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  2,   0,   0,   0},{  25, 125,  50, 150},{  25, 150,  75, 175},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  1,   0,   0,   0},{  75, 150, 125, 175},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  2,   0,   0,   0},{ 150, 125, 175, 150},{ 125, 150, 175, 175},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  1,   0,   0,   0},{ 175,  50, 275, 150},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  2,   0,   0,   0},{  25,  25,  51,  50},{  25,  50,  50,  51},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  2,   0,   0,   0},{ 149,  25, 175,  50},{ 150,  50, 175,  51},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  2,   0,   0,   0},{  25, 149,  50, 150},{  25, 150,  51, 175},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  2,   0,   0,   0},{ 150, 149, 175, 150},{ 149, 150, 175, 175},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  3,   0,   0,   0},{  25,  25,  75,  50},{  25,  50, 150,  75},{  50,  75, 150, 150},{   0,   0,   0,   0},},
   {{  2,   0,   0,   0},{  75,  25, 125,  50},{  50,  50, 150, 150},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  3,   0,   0,   0},{ 125,  25, 175,  50},{  50,  50, 175,  75},{  50,  75, 150, 150},{   0,   0,   0,   0},},
   {{  3,   0,   0,   0},{  50,  50, 150,  75},{  25,  75, 150, 125},{  50, 125, 150, 150},{   0,   0,   0,   0},},
   {{  1,   0,   0,   0},{  50,  50, 150, 150},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  3,   0,   0,   0},{  50,  50, 150,  75},{  50,  75, 175, 125},{  50, 125, 150, 150},{   0,   0,   0,   0},},
   {{  3,   0,   0,   0},{  50,  50, 150, 125},{  25, 125, 150, 150},{  25, 150,  75, 175},{   0,   0,   0,   0},},
   {{  2,   0,   0,   0},{  50,  50, 150, 150},{  75, 150, 125, 175},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  3,   0,   0,   0},{  50,  50, 150, 125},{  50, 125, 175, 150},{ 125, 150, 175, 175},{   0,   0,   0,   0},},
   {{  2,   0,   0,   0},{  50,  50, 150, 150},{ 175,  50, 275, 150},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  3,   0,   0,   0},{  25,  25,  51,  50},{  25,  50, 150,  51},{  50,  51, 150, 150},{   0,   0,   0,   0},},
   {{  3,   0,   0,   0},{ 149,  25, 175,  50},{  50,  50, 175,  51},{  50,  51, 150, 150},{   0,   0,   0,   0},},
   {{  3,   0,   0,   0},{  50,  50, 150, 149},{  25, 149, 150, 150},{  25, 150,  51, 175},{   0,   0,   0,   0},},
   {{  3,   0,   0,   0},{  50,  50, 150, 149},{  50, 149, 175, 150},{ 149, 150, 175, 175},{   0,   0,   0,   0},},
   {{  1,   0,   0,   0},{  50,  50, 150, 150},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  4,   0,   0,   0},{  25,  25,  75,  50},{  25,  50,  50,  75},{  75,  50, 150,  75},{  50,  75, 150, 150},},
   {{  4,   0,   0,   0},{  75,  25, 125,  50},{  50,  50,  75,  75},{ 125,  50, 150,  75},{  50,  75, 150, 150},},
   {{  4,   0,   0,   0},{ 125,  25, 175,  50},{  50,  50, 125,  75},{ 150,  50, 175,  75},{  50,  75, 150, 150},},
   {{  4,   0,   0,   0},{  50,  50, 150,  75},{  25,  75,  50, 125},{  75,  75, 150, 125},{  50, 125, 150, 150},},
   {{  4,   0,   0,   0},{  50,  50, 150,  75},{  50,  75,  75, 125},{ 125,  75, 150, 125},{  50, 125, 150, 150},},
   {{  4,   0,   0,   0},{  50,  50, 150,  75},{  50,  75, 125, 125},{ 150,  75, 175, 125},{  50, 125, 150, 150},},
   {{  4,   0,   0,   0},{  50,  50, 150, 125},{  25, 125,  50, 150},{  75, 125, 150, 150},{  25, 150,  75, 175},},
   {{  4,   0,   0,   0},{  50,  50, 150, 125},{  50, 125,  75, 150},{ 125, 125, 150, 150},{  75, 150, 125, 175},},
   {{  4,   0,   0,   0},{  50,  50, 150, 125},{  50, 125, 125, 150},{ 150, 125, 175, 150},{ 125, 150, 175, 175},},
   {{  2,   0,   0,   0},{  50,  50, 150, 150},{ 175,  50, 275, 150},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  4,   0,   0,   0},{  25,  25,  51,  50},{  25,  50,  50,  51},{  51,  50, 150,  51},{  50,  51, 150, 150},},
   {{  4,   0,   0,   0},{ 149,  25, 175,  50},{  50,  50, 149,  51},{ 150,  50, 175,  51},{  50,  51, 150, 150},},
   {{  4,   0,   0,   0},{  50,  50, 150, 149},{  25, 149,  50, 150},{  51, 149, 150, 150},{  25, 150,  51, 175},},
   {{  4,   0,   0,   0},{  50,  50, 150, 149},{  50, 149, 149, 150},{ 150, 149, 175, 150},{ 149, 150, 175, 175},},
   {{  0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
};


static RECT NTExcludeClip[15][5] = {
   {{  2,   0,   0,   0},{  75,  50, 150,  75},{  50,  75, 150, 150},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  3,   0,   0,   0},{  50,  50,  75,  75},{ 125,  50, 150,  75},{  50,  75, 150, 150},{   0,   0,   0,   0},},
   {{  2,   0,   0,   0},{  50,  50, 125,  75},{  50,  75, 150, 150},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  3,   0,   0,   0},{  50,  50, 150,  75},{  75,  75, 150, 125},{  50, 125, 150, 150},{   0,   0,   0,   0},},
   {{  4,   0,   0,   0},{  50,  50, 150,  75},{  50,  75,  75, 125},{ 125,  75, 150, 125},{  50, 125, 150, 150},},
   {{  3,   0,   0,   0},{  50,  50, 150,  75},{  50,  75, 125, 125},{  50, 125, 150, 150},{   0,   0,   0,   0},},
   {{  2,   0,   0,   0},{  50,  50, 150, 125},{  75, 125, 150, 150},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  3,   0,   0,   0},{  50,  50, 150, 125},{  50, 125,  75, 150},{ 125, 125, 150, 150},{   0,   0,   0,   0},},
   {{  2,   0,   0,   0},{  50,  50, 150, 125},{  50, 125, 125, 150},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  1,   0,   0,   0},{  50,  50, 150, 150},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  2,   0,   0,   0},{  51,  50, 150,  51},{  50,  51, 150, 150},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  2,   0,   0,   0},{  50,  50, 149,  51},{  50,  51, 150, 150},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  2,   0,   0,   0},{  50,  50, 150, 149},{  51, 149, 150, 150},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  2,   0,   0,   0},{  50,  50, 150, 149},{  50, 149, 149, 150},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
};


static RECT NTIntersectClip[15][5] = {
   {{  1,   0,   0,   0},{  50,  50,  75,  75},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  1,   0,   0,   0},{  75,  50, 125,  75},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  1,   0,   0,   0},{ 125,  50, 150,  75},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  1,   0,   0,   0},{  50,  75,  75, 125},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  1,   0,   0,   0},{  75,  75, 125, 125},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  1,   0,   0,   0},{ 125,  75, 150, 125},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  1,   0,   0,   0},{  50, 125,  75, 150},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  1,   0,   0,   0},{  75, 125, 125, 150},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  1,   0,   0,   0},{ 125, 125, 150, 150},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  1,   0,   0,   0},{  50,  50,  51,  51},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  1,   0,   0,   0},{ 149,  50, 150,  51},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  1,   0,   0,   0},{  50, 149,  51, 150},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  1,   0,   0,   0},{ 149, 149, 150, 150},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
   {{  1,   0,   0,   0},{  50,  50, 150, 150},{   0,   0,   0,   0},{   0,   0,   0,   0},{   0,   0,   0,   0},},
};

#endif // header protection
