//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft shared
// source or premium shared source license agreement under which you licensed
// this source code. If you did not accept the terms of the license agreement,
// you are not authorized to use this source code. For the terms of the license,
// please see the license agreement between you and Microsoft or, if applicable,
// see the SOURCE.RTF on your install media or the root of your tools installation.
// THE SOURCE CODE IS PROVIDED "AS IS", WITH NO WARRANTIES.
//
#pragma once
#include "qamath.h"
#include "TestCases.h"

//
// Description of table's index ranges
//

//546
#define ROTATE_TABLE_MIN       0
#define ROTATE_TABLE_MAX     575

//180
#define SCALE_TABLE_MIN      576
#define SCALE_TABLE_MAX      769

//60
#define SHEAR_TABLE_MIN      770
#define SHEAR_TABLE_MAX      841

//180
#define TRANSLATE_TABLE_MIN  842
#define TRANSLATE_TABLE_MAX 1035

typedef struct _TRANS_TESTS {
	union {
		DWORD               dwGeneric;
		D3DQA_ROTTYPE       RotType;
		D3DQA_SCALETYPE     ScaleType;
		D3DQA_SHEARTYPE     ShearType;
		D3DQA_TRANSLATETYPE TranslateType;
	};
	D3DMTRANSFORMSTATETYPE TransType;
	UINT uiFrameNum;
	D3DMFORMAT Format;  // Fixed or Float
} TRANS_TESTS;



//
// Number of frames is dependent on number of nested iterators used the test case.
//
// Due to an implementation detail:
//
//    * Tests with two iterators must have a number of frames that has an integer square root
//    * Tests with three iterators must have a number of frames that has an integer cube root
//
 __declspec(selectany) UINT NumTransformFramesByIters[4] = {0,   //
                                                            5,   // One-axis test cases generate this many frames
                                                            16,  // Two-axis test cases generate this many frames
                                                            27}; // Three-axis test cases generate this many frames



__declspec(selectany) TRANS_TESTS TransformTestCases[D3DMQA_TRANSFORMTEST_COUNT] = {
//         Transform Type                          Matrix          Frame #          Fixed or Float?
	{ (DWORD)D3DQA_ROTTYPE_X                   , D3DMTS_WORLD  ,       0,       D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_X                   , D3DMTS_WORLD  ,       1,       D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_X                   , D3DMTS_WORLD  ,       2,       D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_X                   , D3DMTS_WORLD  ,       3,       D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_X                   , D3DMTS_WORLD  ,       4,       D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_ROTTYPE_Y                   , D3DMTS_WORLD  ,       0,       D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_Y                   , D3DMTS_WORLD  ,       1,       D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_Y                   , D3DMTS_WORLD  ,       2,       D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_Y                   , D3DMTS_WORLD  ,       3,       D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_Y                   , D3DMTS_WORLD  ,       4,       D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_ROTTYPE_Z                   , D3DMTS_WORLD  ,       0,       D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_Z                   , D3DMTS_WORLD  ,       1,       D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_Z                   , D3DMTS_WORLD  ,       2,       D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_Z                   , D3DMTS_WORLD  ,       3,       D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_Z                   , D3DMTS_WORLD  ,       4,       D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_ROTTYPE_XY                  , D3DMTS_WORLD  ,       0,       D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XY                  , D3DMTS_WORLD  ,       1,       D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XY                  , D3DMTS_WORLD  ,       2,       D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XY                  , D3DMTS_WORLD  ,       3,       D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XY                  , D3DMTS_WORLD  ,       4,       D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XY                  , D3DMTS_WORLD  ,       5,       D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XY                  , D3DMTS_WORLD  ,       6,       D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XY                  , D3DMTS_WORLD  ,       7,       D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XY                  , D3DMTS_WORLD  ,       8,       D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XY                  , D3DMTS_WORLD  ,       9,       D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XY                  , D3DMTS_WORLD  ,      10,       D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XY                  , D3DMTS_WORLD  ,      11,       D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XY                  , D3DMTS_WORLD  ,      12,       D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XY                  , D3DMTS_WORLD  ,      13,       D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XY                  , D3DMTS_WORLD  ,      14,       D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XY                  , D3DMTS_WORLD  ,      15,       D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_ROTTYPE_XZ                  , D3DMTS_WORLD  ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZ                  , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZ                  , D3DMTS_WORLD  ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZ                  , D3DMTS_WORLD  ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZ                  , D3DMTS_WORLD  ,       4,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZ                  , D3DMTS_WORLD  ,       5,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZ                  , D3DMTS_WORLD  ,       6,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZ                  , D3DMTS_WORLD  ,       7,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZ                  , D3DMTS_WORLD  ,       8,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZ                  , D3DMTS_WORLD  ,       9,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZ                  , D3DMTS_WORLD  ,      10,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZ                  , D3DMTS_WORLD  ,      11,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZ                  , D3DMTS_WORLD  ,      12,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZ                  , D3DMTS_WORLD  ,      13,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZ                  , D3DMTS_WORLD  ,      14,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZ                  , D3DMTS_WORLD  ,      15,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_ROTTYPE_YX                  , D3DMTS_WORLD  ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YX                  , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YX                  , D3DMTS_WORLD  ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YX                  , D3DMTS_WORLD  ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YX                  , D3DMTS_WORLD  ,       4,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YX                  , D3DMTS_WORLD  ,       5,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YX                  , D3DMTS_WORLD  ,       6,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YX                  , D3DMTS_WORLD  ,       7,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YX                  , D3DMTS_WORLD  ,       8,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YX                  , D3DMTS_WORLD  ,       9,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YX                  , D3DMTS_WORLD  ,      10,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YX                  , D3DMTS_WORLD  ,      11,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YX                  , D3DMTS_WORLD  ,      12,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YX                  , D3DMTS_WORLD  ,      13,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YX                  , D3DMTS_WORLD  ,      14,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YX                  , D3DMTS_WORLD  ,      15,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_ROTTYPE_YZ                  , D3DMTS_WORLD  ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZ                  , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZ                  , D3DMTS_WORLD  ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZ                  , D3DMTS_WORLD  ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZ                  , D3DMTS_WORLD  ,       4,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZ                  , D3DMTS_WORLD  ,       5,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZ                  , D3DMTS_WORLD  ,       6,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZ                  , D3DMTS_WORLD  ,       7,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZ                  , D3DMTS_WORLD  ,       8,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZ                  , D3DMTS_WORLD  ,       9,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZ                  , D3DMTS_WORLD  ,      10,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZ                  , D3DMTS_WORLD  ,      11,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZ                  , D3DMTS_WORLD  ,      12,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZ                  , D3DMTS_WORLD  ,      13,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZ                  , D3DMTS_WORLD  ,      14,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZ                  , D3DMTS_WORLD  ,      15,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_ROTTYPE_ZX                  , D3DMTS_WORLD  ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZX                  , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZX                  , D3DMTS_WORLD  ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZX                  , D3DMTS_WORLD  ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZX                  , D3DMTS_WORLD  ,       4,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZX                  , D3DMTS_WORLD  ,       5,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZX                  , D3DMTS_WORLD  ,       6,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZX                  , D3DMTS_WORLD  ,       7,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZX                  , D3DMTS_WORLD  ,       8,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZX                  , D3DMTS_WORLD  ,       9,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZX                  , D3DMTS_WORLD  ,      10,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZX                  , D3DMTS_WORLD  ,      11,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZX                  , D3DMTS_WORLD  ,      12,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZX                  , D3DMTS_WORLD  ,      13,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZX                  , D3DMTS_WORLD  ,      14,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZX                  , D3DMTS_WORLD  ,      15,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_ROTTYPE_ZY                  , D3DMTS_WORLD  ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZY                  , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZY                  , D3DMTS_WORLD  ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZY                  , D3DMTS_WORLD  ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZY                  , D3DMTS_WORLD  ,       4,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZY                  , D3DMTS_WORLD  ,       5,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZY                  , D3DMTS_WORLD  ,       6,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZY                  , D3DMTS_WORLD  ,       7,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZY                  , D3DMTS_WORLD  ,       8,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZY                  , D3DMTS_WORLD  ,       9,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZY                  , D3DMTS_WORLD  ,      10,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZY                  , D3DMTS_WORLD  ,      11,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZY                  , D3DMTS_WORLD  ,      12,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZY                  , D3DMTS_WORLD  ,      13,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZY                  , D3DMTS_WORLD  ,      14,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZY                  , D3DMTS_WORLD  ,      15,        D3DMFMT_D3DMVALUE_FLOAT},
	
	{ (DWORD)D3DQA_ROTTYPE_XYZ                 , D3DMTS_WORLD  ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XYZ                 , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XYZ                 , D3DMTS_WORLD  ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XYZ                 , D3DMTS_WORLD  ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XYZ                 , D3DMTS_WORLD  ,       4,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XYZ                 , D3DMTS_WORLD  ,       5,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XYZ                 , D3DMTS_WORLD  ,       6,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XYZ                 , D3DMTS_WORLD  ,       7,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XYZ                 , D3DMTS_WORLD  ,       8,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XYZ                 , D3DMTS_WORLD  ,       9,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XYZ                 , D3DMTS_WORLD  ,      10,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XYZ                 , D3DMTS_WORLD  ,      11,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XYZ                 , D3DMTS_WORLD  ,      12,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XYZ                 , D3DMTS_WORLD  ,      13,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XYZ                 , D3DMTS_WORLD  ,      14,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XYZ                 , D3DMTS_WORLD  ,      15,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XYZ                 , D3DMTS_WORLD  ,      16,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XYZ                 , D3DMTS_WORLD  ,      17,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XYZ                 , D3DMTS_WORLD  ,      18,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XYZ                 , D3DMTS_WORLD  ,      19,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XYZ                 , D3DMTS_WORLD  ,      20,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XYZ                 , D3DMTS_WORLD  ,      21,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XYZ                 , D3DMTS_WORLD  ,      22,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XYZ                 , D3DMTS_WORLD  ,      23,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XYZ                 , D3DMTS_WORLD  ,      24,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XYZ                 , D3DMTS_WORLD  ,      25,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XYZ                 , D3DMTS_WORLD  ,      26,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_ROTTYPE_XZY                 , D3DMTS_WORLD  ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZY                 , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZY                 , D3DMTS_WORLD  ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZY                 , D3DMTS_WORLD  ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZY                 , D3DMTS_WORLD  ,       4,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZY                 , D3DMTS_WORLD  ,       5,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZY                 , D3DMTS_WORLD  ,       6,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZY                 , D3DMTS_WORLD  ,       7,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZY                 , D3DMTS_WORLD  ,       8,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZY                 , D3DMTS_WORLD  ,       9,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZY                 , D3DMTS_WORLD  ,      10,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZY                 , D3DMTS_WORLD  ,      11,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZY                 , D3DMTS_WORLD  ,      12,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZY                 , D3DMTS_WORLD  ,      13,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZY                 , D3DMTS_WORLD  ,      14,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZY                 , D3DMTS_WORLD  ,      15,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZY                 , D3DMTS_WORLD  ,      16,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZY                 , D3DMTS_WORLD  ,      17,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZY                 , D3DMTS_WORLD  ,      18,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZY                 , D3DMTS_WORLD  ,      19,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZY                 , D3DMTS_WORLD  ,      20,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZY                 , D3DMTS_WORLD  ,      21,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZY                 , D3DMTS_WORLD  ,      22,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZY                 , D3DMTS_WORLD  ,      23,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZY                 , D3DMTS_WORLD  ,      24,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZY                 , D3DMTS_WORLD  ,      25,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZY                 , D3DMTS_WORLD  ,      26,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_ROTTYPE_YXZ                 , D3DMTS_WORLD  ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YXZ                 , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YXZ                 , D3DMTS_WORLD  ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YXZ                 , D3DMTS_WORLD  ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YXZ                 , D3DMTS_WORLD  ,       4,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YXZ                 , D3DMTS_WORLD  ,       5,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YXZ                 , D3DMTS_WORLD  ,       6,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YXZ                 , D3DMTS_WORLD  ,       7,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YXZ                 , D3DMTS_WORLD  ,       8,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YXZ                 , D3DMTS_WORLD  ,       9,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YXZ                 , D3DMTS_WORLD  ,      10,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YXZ                 , D3DMTS_WORLD  ,      11,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YXZ                 , D3DMTS_WORLD  ,      12,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YXZ                 , D3DMTS_WORLD  ,      13,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YXZ                 , D3DMTS_WORLD  ,      14,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YXZ                 , D3DMTS_WORLD  ,      15,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YXZ                 , D3DMTS_WORLD  ,      16,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YXZ                 , D3DMTS_WORLD  ,      17,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YXZ                 , D3DMTS_WORLD  ,      18,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YXZ                 , D3DMTS_WORLD  ,      19,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YXZ                 , D3DMTS_WORLD  ,      20,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YXZ                 , D3DMTS_WORLD  ,      21,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YXZ                 , D3DMTS_WORLD  ,      22,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YXZ                 , D3DMTS_WORLD  ,      23,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YXZ                 , D3DMTS_WORLD  ,      24,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YXZ                 , D3DMTS_WORLD  ,      25,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YXZ                 , D3DMTS_WORLD  ,      26,        D3DMFMT_D3DMVALUE_FLOAT},
	
	{ (DWORD)D3DQA_ROTTYPE_YZX                 , D3DMTS_WORLD  ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZX                 , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZX                 , D3DMTS_WORLD  ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZX                 , D3DMTS_WORLD  ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZX                 , D3DMTS_WORLD  ,       4,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZX                 , D3DMTS_WORLD  ,       5,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZX                 , D3DMTS_WORLD  ,       6,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZX                 , D3DMTS_WORLD  ,       7,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZX                 , D3DMTS_WORLD  ,       8,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZX                 , D3DMTS_WORLD  ,       9,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZX                 , D3DMTS_WORLD  ,      10,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZX                 , D3DMTS_WORLD  ,      11,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZX                 , D3DMTS_WORLD  ,      12,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZX                 , D3DMTS_WORLD  ,      13,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZX                 , D3DMTS_WORLD  ,      14,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZX                 , D3DMTS_WORLD  ,      15,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZX                 , D3DMTS_WORLD  ,      16,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZX                 , D3DMTS_WORLD  ,      17,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZX                 , D3DMTS_WORLD  ,      18,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZX                 , D3DMTS_WORLD  ,      19,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZX                 , D3DMTS_WORLD  ,      20,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZX                 , D3DMTS_WORLD  ,      21,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZX                 , D3DMTS_WORLD  ,      22,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZX                 , D3DMTS_WORLD  ,      23,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZX                 , D3DMTS_WORLD  ,      24,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZX                 , D3DMTS_WORLD  ,      25,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZX                 , D3DMTS_WORLD  ,      26,        D3DMFMT_D3DMVALUE_FLOAT},
	
	{ (DWORD)D3DQA_ROTTYPE_ZXY                 , D3DMTS_WORLD  ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZXY                 , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZXY                 , D3DMTS_WORLD  ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZXY                 , D3DMTS_WORLD  ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZXY                 , D3DMTS_WORLD  ,       4,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZXY                 , D3DMTS_WORLD  ,       5,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZXY                 , D3DMTS_WORLD  ,       6,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZXY                 , D3DMTS_WORLD  ,       7,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZXY                 , D3DMTS_WORLD  ,       8,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZXY                 , D3DMTS_WORLD  ,       9,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZXY                 , D3DMTS_WORLD  ,      10,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZXY                 , D3DMTS_WORLD  ,      11,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZXY                 , D3DMTS_WORLD  ,      12,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZXY                 , D3DMTS_WORLD  ,      13,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZXY                 , D3DMTS_WORLD  ,      14,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZXY                 , D3DMTS_WORLD  ,      15,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZXY                 , D3DMTS_WORLD  ,      16,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZXY                 , D3DMTS_WORLD  ,      17,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZXY                 , D3DMTS_WORLD  ,      18,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZXY                 , D3DMTS_WORLD  ,      19,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZXY                 , D3DMTS_WORLD  ,      20,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZXY                 , D3DMTS_WORLD  ,      21,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZXY                 , D3DMTS_WORLD  ,      22,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZXY                 , D3DMTS_WORLD  ,      23,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZXY                 , D3DMTS_WORLD  ,      24,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZXY                 , D3DMTS_WORLD  ,      25,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZXY                 , D3DMTS_WORLD  ,      26,        D3DMFMT_D3DMVALUE_FLOAT},
	
	{ (DWORD)D3DQA_ROTTYPE_ZYX                 , D3DMTS_WORLD  ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZYX                 , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZYX                 , D3DMTS_WORLD  ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZYX                 , D3DMTS_WORLD  ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZYX                 , D3DMTS_WORLD  ,       4,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZYX                 , D3DMTS_WORLD  ,       5,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZYX                 , D3DMTS_WORLD  ,       6,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZYX                 , D3DMTS_WORLD  ,       7,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZYX                 , D3DMTS_WORLD  ,       8,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZYX                 , D3DMTS_WORLD  ,       9,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZYX                 , D3DMTS_WORLD  ,      10,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZYX                 , D3DMTS_WORLD  ,      11,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZYX                 , D3DMTS_WORLD  ,      12,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZYX                 , D3DMTS_WORLD  ,      13,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZYX                 , D3DMTS_WORLD  ,      14,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZYX                 , D3DMTS_WORLD  ,      15,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZYX                 , D3DMTS_WORLD  ,      16,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZYX                 , D3DMTS_WORLD  ,      17,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZYX                 , D3DMTS_WORLD  ,      18,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZYX                 , D3DMTS_WORLD  ,      19,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZYX                 , D3DMTS_WORLD  ,      20,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZYX                 , D3DMTS_WORLD  ,      21,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZYX                 , D3DMTS_WORLD  ,      22,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZYX                 , D3DMTS_WORLD  ,      23,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZYX                 , D3DMTS_WORLD  ,      24,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZYX                 , D3DMTS_WORLD  ,      25,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZYX                 , D3DMTS_WORLD  ,      26,        D3DMFMT_D3DMVALUE_FLOAT},
	
	{ (DWORD)D3DQA_ROTTYPE_X                   , D3DMTS_VIEW   ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_X                   , D3DMTS_VIEW   ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_X                   , D3DMTS_VIEW   ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_X                   , D3DMTS_VIEW   ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_X                   , D3DMTS_VIEW   ,       4,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_ROTTYPE_Y                   , D3DMTS_VIEW   ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_Y                   , D3DMTS_VIEW   ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_Y                   , D3DMTS_VIEW   ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_Y                   , D3DMTS_VIEW   ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_Y                   , D3DMTS_VIEW   ,       4,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_ROTTYPE_Z                   , D3DMTS_VIEW   ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_Z                   , D3DMTS_VIEW   ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_Z                   , D3DMTS_VIEW   ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_Z                   , D3DMTS_VIEW   ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_Z                   , D3DMTS_VIEW   ,       4,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_ROTTYPE_XY                  , D3DMTS_VIEW   ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XY                  , D3DMTS_VIEW   ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XY                  , D3DMTS_VIEW   ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XY                  , D3DMTS_VIEW   ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XY                  , D3DMTS_VIEW   ,       4,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XY                  , D3DMTS_VIEW   ,       5,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XY                  , D3DMTS_VIEW   ,       6,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XY                  , D3DMTS_VIEW   ,       7,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XY                  , D3DMTS_VIEW   ,       8,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XY                  , D3DMTS_VIEW   ,       9,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XY                  , D3DMTS_VIEW   ,      10,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XY                  , D3DMTS_VIEW   ,      11,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XY                  , D3DMTS_VIEW   ,      12,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XY                  , D3DMTS_VIEW   ,      13,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XY                  , D3DMTS_VIEW   ,      14,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XY                  , D3DMTS_VIEW   ,      15,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_ROTTYPE_XZ                  , D3DMTS_VIEW   ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZ                  , D3DMTS_VIEW   ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZ                  , D3DMTS_VIEW   ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZ                  , D3DMTS_VIEW   ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZ                  , D3DMTS_VIEW   ,       4,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZ                  , D3DMTS_VIEW   ,       5,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZ                  , D3DMTS_VIEW   ,       6,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZ                  , D3DMTS_VIEW   ,       7,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZ                  , D3DMTS_VIEW   ,       8,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZ                  , D3DMTS_VIEW   ,       9,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZ                  , D3DMTS_VIEW   ,      10,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZ                  , D3DMTS_VIEW   ,      11,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZ                  , D3DMTS_VIEW   ,      12,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZ                  , D3DMTS_VIEW   ,      13,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZ                  , D3DMTS_VIEW   ,      14,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZ                  , D3DMTS_VIEW   ,      15,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_ROTTYPE_YX                  , D3DMTS_VIEW   ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YX                  , D3DMTS_VIEW   ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YX                  , D3DMTS_VIEW   ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YX                  , D3DMTS_VIEW   ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YX                  , D3DMTS_VIEW   ,       4,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YX                  , D3DMTS_VIEW   ,       5,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YX                  , D3DMTS_VIEW   ,       6,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YX                  , D3DMTS_VIEW   ,       7,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YX                  , D3DMTS_VIEW   ,       8,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YX                  , D3DMTS_VIEW   ,       9,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YX                  , D3DMTS_VIEW   ,      10,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YX                  , D3DMTS_VIEW   ,      11,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YX                  , D3DMTS_VIEW   ,      12,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YX                  , D3DMTS_VIEW   ,      13,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YX                  , D3DMTS_VIEW   ,      14,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YX                  , D3DMTS_VIEW   ,      15,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_ROTTYPE_YZ                  , D3DMTS_VIEW   ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZ                  , D3DMTS_VIEW   ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZ                  , D3DMTS_VIEW   ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZ                  , D3DMTS_VIEW   ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZ                  , D3DMTS_VIEW   ,       4,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZ                  , D3DMTS_VIEW   ,       5,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZ                  , D3DMTS_VIEW   ,       6,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZ                  , D3DMTS_VIEW   ,       7,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZ                  , D3DMTS_VIEW   ,       8,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZ                  , D3DMTS_VIEW   ,       9,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZ                  , D3DMTS_VIEW   ,      10,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZ                  , D3DMTS_VIEW   ,      11,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZ                  , D3DMTS_VIEW   ,      12,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZ                  , D3DMTS_VIEW   ,      13,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZ                  , D3DMTS_VIEW   ,      14,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZ                  , D3DMTS_VIEW   ,      15,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_ROTTYPE_ZX                  , D3DMTS_VIEW   ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZX                  , D3DMTS_VIEW   ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZX                  , D3DMTS_VIEW   ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZX                  , D3DMTS_VIEW   ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZX                  , D3DMTS_VIEW   ,       4,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZX                  , D3DMTS_VIEW   ,       5,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZX                  , D3DMTS_VIEW   ,       6,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZX                  , D3DMTS_VIEW   ,       7,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZX                  , D3DMTS_VIEW   ,       8,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZX                  , D3DMTS_VIEW   ,       9,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZX                  , D3DMTS_VIEW   ,      10,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZX                  , D3DMTS_VIEW   ,      11,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZX                  , D3DMTS_VIEW   ,      12,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZX                  , D3DMTS_VIEW   ,      13,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZX                  , D3DMTS_VIEW   ,      14,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZX                  , D3DMTS_VIEW   ,      15,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_ROTTYPE_ZY                  , D3DMTS_VIEW   ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZY                  , D3DMTS_VIEW   ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZY                  , D3DMTS_VIEW   ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZY                  , D3DMTS_VIEW   ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZY                  , D3DMTS_VIEW   ,       4,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZY                  , D3DMTS_VIEW   ,       5,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZY                  , D3DMTS_VIEW   ,       6,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZY                  , D3DMTS_VIEW   ,       7,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZY                  , D3DMTS_VIEW   ,       8,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZY                  , D3DMTS_VIEW   ,       9,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZY                  , D3DMTS_VIEW   ,      10,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZY                  , D3DMTS_VIEW   ,      11,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZY                  , D3DMTS_VIEW   ,      12,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZY                  , D3DMTS_VIEW   ,      13,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZY                  , D3DMTS_VIEW   ,      14,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZY                  , D3DMTS_VIEW   ,      15,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_ROTTYPE_XYZ                 , D3DMTS_VIEW   ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XYZ                 , D3DMTS_VIEW   ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XYZ                 , D3DMTS_VIEW   ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XYZ                 , D3DMTS_VIEW   ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XYZ                 , D3DMTS_VIEW   ,       4,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XYZ                 , D3DMTS_VIEW   ,       5,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XYZ                 , D3DMTS_VIEW   ,       6,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XYZ                 , D3DMTS_VIEW   ,       7,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XYZ                 , D3DMTS_VIEW   ,       8,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XYZ                 , D3DMTS_VIEW   ,       9,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XYZ                 , D3DMTS_VIEW   ,      10,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XYZ                 , D3DMTS_VIEW   ,      11,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XYZ                 , D3DMTS_VIEW   ,      12,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XYZ                 , D3DMTS_VIEW   ,      13,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XYZ                 , D3DMTS_VIEW   ,      14,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XYZ                 , D3DMTS_VIEW   ,      15,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XYZ                 , D3DMTS_VIEW   ,      16,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XYZ                 , D3DMTS_VIEW   ,      17,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XYZ                 , D3DMTS_VIEW   ,      18,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XYZ                 , D3DMTS_VIEW   ,      19,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XYZ                 , D3DMTS_VIEW   ,      20,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XYZ                 , D3DMTS_VIEW   ,      21,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XYZ                 , D3DMTS_VIEW   ,      22,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XYZ                 , D3DMTS_VIEW   ,      23,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XYZ                 , D3DMTS_VIEW   ,      24,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XYZ                 , D3DMTS_VIEW   ,      25,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XYZ                 , D3DMTS_VIEW   ,      26,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_ROTTYPE_XZY                 , D3DMTS_VIEW   ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZY                 , D3DMTS_VIEW   ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZY                 , D3DMTS_VIEW   ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZY                 , D3DMTS_VIEW   ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZY                 , D3DMTS_VIEW   ,       4,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZY                 , D3DMTS_VIEW   ,       5,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZY                 , D3DMTS_VIEW   ,       6,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZY                 , D3DMTS_VIEW   ,       7,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZY                 , D3DMTS_VIEW   ,       8,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZY                 , D3DMTS_VIEW   ,       9,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZY                 , D3DMTS_VIEW   ,      10,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZY                 , D3DMTS_VIEW   ,      11,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZY                 , D3DMTS_VIEW   ,      12,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZY                 , D3DMTS_VIEW   ,      13,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZY                 , D3DMTS_VIEW   ,      14,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZY                 , D3DMTS_VIEW   ,      15,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZY                 , D3DMTS_VIEW   ,      16,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZY                 , D3DMTS_VIEW   ,      17,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZY                 , D3DMTS_VIEW   ,      18,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZY                 , D3DMTS_VIEW   ,      19,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZY                 , D3DMTS_VIEW   ,      20,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZY                 , D3DMTS_VIEW   ,      21,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZY                 , D3DMTS_VIEW   ,      22,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZY                 , D3DMTS_VIEW   ,      23,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZY                 , D3DMTS_VIEW   ,      24,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZY                 , D3DMTS_VIEW   ,      25,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_XZY                 , D3DMTS_VIEW   ,      26,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_ROTTYPE_YXZ                 , D3DMTS_VIEW   ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YXZ                 , D3DMTS_VIEW   ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YXZ                 , D3DMTS_VIEW   ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YXZ                 , D3DMTS_VIEW   ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YXZ                 , D3DMTS_VIEW   ,       4,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YXZ                 , D3DMTS_VIEW   ,       5,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YXZ                 , D3DMTS_VIEW   ,       6,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YXZ                 , D3DMTS_VIEW   ,       7,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YXZ                 , D3DMTS_VIEW   ,       8,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YXZ                 , D3DMTS_VIEW   ,       9,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YXZ                 , D3DMTS_VIEW   ,      10,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YXZ                 , D3DMTS_VIEW   ,      11,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YXZ                 , D3DMTS_VIEW   ,      12,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YXZ                 , D3DMTS_VIEW   ,      13,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YXZ                 , D3DMTS_VIEW   ,      14,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YXZ                 , D3DMTS_VIEW   ,      15,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YXZ                 , D3DMTS_VIEW   ,      16,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YXZ                 , D3DMTS_VIEW   ,      17,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YXZ                 , D3DMTS_VIEW   ,      18,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YXZ                 , D3DMTS_VIEW   ,      19,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YXZ                 , D3DMTS_VIEW   ,      20,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YXZ                 , D3DMTS_VIEW   ,      21,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YXZ                 , D3DMTS_VIEW   ,      22,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YXZ                 , D3DMTS_VIEW   ,      23,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YXZ                 , D3DMTS_VIEW   ,      24,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YXZ                 , D3DMTS_VIEW   ,      25,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YXZ                 , D3DMTS_VIEW   ,      26,        D3DMFMT_D3DMVALUE_FLOAT},
	
	{ (DWORD)D3DQA_ROTTYPE_YZX                 , D3DMTS_VIEW   ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZX                 , D3DMTS_VIEW   ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZX                 , D3DMTS_VIEW   ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZX                 , D3DMTS_VIEW   ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZX                 , D3DMTS_VIEW   ,       4,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZX                 , D3DMTS_VIEW   ,       5,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZX                 , D3DMTS_VIEW   ,       6,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZX                 , D3DMTS_VIEW   ,       7,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZX                 , D3DMTS_VIEW   ,       8,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZX                 , D3DMTS_VIEW   ,       9,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZX                 , D3DMTS_VIEW   ,      10,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZX                 , D3DMTS_VIEW   ,      11,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZX                 , D3DMTS_VIEW   ,      12,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZX                 , D3DMTS_VIEW   ,      13,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZX                 , D3DMTS_VIEW   ,      14,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZX                 , D3DMTS_VIEW   ,      15,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZX                 , D3DMTS_VIEW   ,      16,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZX                 , D3DMTS_VIEW   ,      17,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZX                 , D3DMTS_VIEW   ,      18,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZX                 , D3DMTS_VIEW   ,      19,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZX                 , D3DMTS_VIEW   ,      20,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZX                 , D3DMTS_VIEW   ,      21,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZX                 , D3DMTS_VIEW   ,      22,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZX                 , D3DMTS_VIEW   ,      23,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZX                 , D3DMTS_VIEW   ,      24,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZX                 , D3DMTS_VIEW   ,      25,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_YZX                 , D3DMTS_VIEW   ,      26,        D3DMFMT_D3DMVALUE_FLOAT},
	
	{ (DWORD)D3DQA_ROTTYPE_ZXY                 , D3DMTS_VIEW   ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZXY                 , D3DMTS_VIEW   ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZXY                 , D3DMTS_VIEW   ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZXY                 , D3DMTS_VIEW   ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZXY                 , D3DMTS_VIEW   ,       4,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZXY                 , D3DMTS_VIEW   ,       5,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZXY                 , D3DMTS_VIEW   ,       6,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZXY                 , D3DMTS_VIEW   ,       7,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZXY                 , D3DMTS_VIEW   ,       8,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZXY                 , D3DMTS_VIEW   ,       9,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZXY                 , D3DMTS_VIEW   ,      10,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZXY                 , D3DMTS_VIEW   ,      11,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZXY                 , D3DMTS_VIEW   ,      12,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZXY                 , D3DMTS_VIEW   ,      13,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZXY                 , D3DMTS_VIEW   ,      14,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZXY                 , D3DMTS_VIEW   ,      15,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZXY                 , D3DMTS_VIEW   ,      16,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZXY                 , D3DMTS_VIEW   ,      17,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZXY                 , D3DMTS_VIEW   ,      18,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZXY                 , D3DMTS_VIEW   ,      19,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZXY                 , D3DMTS_VIEW   ,      20,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZXY                 , D3DMTS_VIEW   ,      21,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZXY                 , D3DMTS_VIEW   ,      22,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZXY                 , D3DMTS_VIEW   ,      23,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZXY                 , D3DMTS_VIEW   ,      24,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZXY                 , D3DMTS_VIEW   ,      25,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZXY                 , D3DMTS_VIEW   ,      26,        D3DMFMT_D3DMVALUE_FLOAT},
	
	{ (DWORD)D3DQA_ROTTYPE_ZYX                 , D3DMTS_VIEW   ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZYX                 , D3DMTS_VIEW   ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZYX                 , D3DMTS_VIEW   ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZYX                 , D3DMTS_VIEW   ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZYX                 , D3DMTS_VIEW   ,       4,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZYX                 , D3DMTS_VIEW   ,       5,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZYX                 , D3DMTS_VIEW   ,       6,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZYX                 , D3DMTS_VIEW   ,       7,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZYX                 , D3DMTS_VIEW   ,       8,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZYX                 , D3DMTS_VIEW   ,       9,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZYX                 , D3DMTS_VIEW   ,      10,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZYX                 , D3DMTS_VIEW   ,      11,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZYX                 , D3DMTS_VIEW   ,      12,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZYX                 , D3DMTS_VIEW   ,      13,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZYX                 , D3DMTS_VIEW   ,      14,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZYX                 , D3DMTS_VIEW   ,      15,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZYX                 , D3DMTS_VIEW   ,      16,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZYX                 , D3DMTS_VIEW   ,      17,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZYX                 , D3DMTS_VIEW   ,      18,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZYX                 , D3DMTS_VIEW   ,      19,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZYX                 , D3DMTS_VIEW   ,      20,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZYX                 , D3DMTS_VIEW   ,      21,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZYX                 , D3DMTS_VIEW   ,      22,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZYX                 , D3DMTS_VIEW   ,      23,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZYX                 , D3DMTS_VIEW   ,      24,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZYX                 , D3DMTS_VIEW   ,      25,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_ROTTYPE_ZYX                 , D3DMTS_VIEW   ,      26,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_ROTTYPE_X                   , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_ROTTYPE_Y                   , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_ROTTYPE_Z                   , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_ROTTYPE_XY                  , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_ROTTYPE_XZ                  , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_ROTTYPE_YX                  , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_ROTTYPE_YZ                  , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_ROTTYPE_ZX                  , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_ROTTYPE_ZY                  , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_ROTTYPE_XYZ                 , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_ROTTYPE_XZY                 , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_ROTTYPE_YXZ                 , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_ROTTYPE_YZX                 , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_ROTTYPE_ZXY                 , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_ROTTYPE_ZYX                 , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_ROTTYPE_X                   ,  D3DMTS_VIEW  ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_ROTTYPE_Y                   ,  D3DMTS_VIEW  ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_ROTTYPE_Z                   ,  D3DMTS_VIEW  ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_ROTTYPE_XY                  ,  D3DMTS_VIEW  ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_ROTTYPE_XZ                  ,  D3DMTS_VIEW  ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_ROTTYPE_YX                  ,  D3DMTS_VIEW  ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_ROTTYPE_YZ                  ,  D3DMTS_VIEW  ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_ROTTYPE_ZX                  ,  D3DMTS_VIEW  ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_ROTTYPE_ZY                  ,  D3DMTS_VIEW  ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_ROTTYPE_XYZ                 ,  D3DMTS_VIEW  ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_ROTTYPE_XZY                 ,  D3DMTS_VIEW  ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_ROTTYPE_YXZ                 ,  D3DMTS_VIEW  ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_ROTTYPE_YZX                 ,  D3DMTS_VIEW  ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_ROTTYPE_ZXY                 ,  D3DMTS_VIEW  ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_ROTTYPE_ZYX                 ,  D3DMTS_VIEW  ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	
	{ (DWORD)D3DQA_SCALETYPE_X                 , D3DMTS_WORLD  ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_X                 , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_X                 , D3DMTS_WORLD  ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_X                 , D3DMTS_WORLD  ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_X                 , D3DMTS_WORLD  ,       4,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_SCALETYPE_Y                 , D3DMTS_WORLD  ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_Y                 , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_Y                 , D3DMTS_WORLD  ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_Y                 , D3DMTS_WORLD  ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_Y                 , D3DMTS_WORLD  ,       4,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_SCALETYPE_Z                 , D3DMTS_WORLD  ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_Z                 , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_Z                 , D3DMTS_WORLD  ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_Z                 , D3DMTS_WORLD  ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_Z                 , D3DMTS_WORLD  ,       4,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_SCALETYPE_XY                , D3DMTS_WORLD  ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XY                , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XY                , D3DMTS_WORLD  ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XY                , D3DMTS_WORLD  ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XY                , D3DMTS_WORLD  ,       4,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XY                , D3DMTS_WORLD  ,       5,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XY                , D3DMTS_WORLD  ,       6,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XY                , D3DMTS_WORLD  ,       7,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XY                , D3DMTS_WORLD  ,       8,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XY                , D3DMTS_WORLD  ,       9,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XY                , D3DMTS_WORLD  ,      10,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XY                , D3DMTS_WORLD  ,      11,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XY                , D3DMTS_WORLD  ,      12,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XY                , D3DMTS_WORLD  ,      13,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XY                , D3DMTS_WORLD  ,      14,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XY                , D3DMTS_WORLD  ,      15,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_SCALETYPE_XZ                , D3DMTS_WORLD  ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XZ                , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XZ                , D3DMTS_WORLD  ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XZ                , D3DMTS_WORLD  ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XZ                , D3DMTS_WORLD  ,       4,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XZ                , D3DMTS_WORLD  ,       5,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XZ                , D3DMTS_WORLD  ,       6,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XZ                , D3DMTS_WORLD  ,       7,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XZ                , D3DMTS_WORLD  ,       8,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XZ                , D3DMTS_WORLD  ,       9,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XZ                , D3DMTS_WORLD  ,      10,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XZ                , D3DMTS_WORLD  ,      11,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XZ                , D3DMTS_WORLD  ,      12,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XZ                , D3DMTS_WORLD  ,      13,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XZ                , D3DMTS_WORLD  ,      14,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XZ                , D3DMTS_WORLD  ,      15,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_SCALETYPE_YZ                , D3DMTS_WORLD  ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_YZ                , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_YZ                , D3DMTS_WORLD  ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_YZ                , D3DMTS_WORLD  ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_YZ                , D3DMTS_WORLD  ,       4,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_YZ                , D3DMTS_WORLD  ,       5,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_YZ                , D3DMTS_WORLD  ,       6,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_YZ                , D3DMTS_WORLD  ,       7,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_YZ                , D3DMTS_WORLD  ,       8,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_YZ                , D3DMTS_WORLD  ,       9,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_YZ                , D3DMTS_WORLD  ,      10,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_YZ                , D3DMTS_WORLD  ,      11,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_YZ                , D3DMTS_WORLD  ,      12,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_YZ                , D3DMTS_WORLD  ,      13,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_YZ                , D3DMTS_WORLD  ,      14,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_YZ                , D3DMTS_WORLD  ,      15,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_SCALETYPE_XYZ               , D3DMTS_WORLD  ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XYZ               , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XYZ               , D3DMTS_WORLD  ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XYZ               , D3DMTS_WORLD  ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XYZ               , D3DMTS_WORLD  ,       4,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XYZ               , D3DMTS_WORLD  ,       5,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XYZ               , D3DMTS_WORLD  ,       6,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XYZ               , D3DMTS_WORLD  ,       7,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XYZ               , D3DMTS_WORLD  ,       8,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XYZ               , D3DMTS_WORLD  ,       9,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XYZ               , D3DMTS_WORLD  ,      10,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XYZ               , D3DMTS_WORLD  ,      11,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XYZ               , D3DMTS_WORLD  ,      12,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XYZ               , D3DMTS_WORLD  ,      13,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XYZ               , D3DMTS_WORLD  ,      14,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XYZ               , D3DMTS_WORLD  ,      15,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XYZ               , D3DMTS_WORLD  ,      16,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XYZ               , D3DMTS_WORLD  ,      17,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XYZ               , D3DMTS_WORLD  ,      18,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XYZ               , D3DMTS_WORLD  ,      19,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XYZ               , D3DMTS_WORLD  ,      20,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XYZ               , D3DMTS_WORLD  ,      21,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XYZ               , D3DMTS_WORLD  ,      22,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XYZ               , D3DMTS_WORLD  ,      23,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XYZ               , D3DMTS_WORLD  ,      24,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XYZ               , D3DMTS_WORLD  ,      25,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XYZ               , D3DMTS_WORLD  ,      26,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_SCALETYPE_X                 , D3DMTS_VIEW   ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_X                 , D3DMTS_VIEW   ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_X                 , D3DMTS_VIEW   ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_X                 , D3DMTS_VIEW   ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_X                 , D3DMTS_VIEW   ,       4,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_SCALETYPE_Y                 , D3DMTS_VIEW   ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_Y                 , D3DMTS_VIEW   ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_Y                 , D3DMTS_VIEW   ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_Y                 , D3DMTS_VIEW   ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_Y                 , D3DMTS_VIEW   ,       4,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_SCALETYPE_Z                 , D3DMTS_VIEW   ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_Z                 , D3DMTS_VIEW   ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_Z                 , D3DMTS_VIEW   ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_Z                 , D3DMTS_VIEW   ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_Z                 , D3DMTS_VIEW   ,       4,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_SCALETYPE_XY                , D3DMTS_VIEW   ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XY                , D3DMTS_VIEW   ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XY                , D3DMTS_VIEW   ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XY                , D3DMTS_VIEW   ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XY                , D3DMTS_VIEW   ,       4,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XY                , D3DMTS_VIEW   ,       5,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XY                , D3DMTS_VIEW   ,       6,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XY                , D3DMTS_VIEW   ,       7,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XY                , D3DMTS_VIEW   ,       8,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XY                , D3DMTS_VIEW   ,       9,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XY                , D3DMTS_VIEW   ,      10,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XY                , D3DMTS_VIEW   ,      11,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XY                , D3DMTS_VIEW   ,      12,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XY                , D3DMTS_VIEW   ,      13,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XY                , D3DMTS_VIEW   ,      14,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XY                , D3DMTS_VIEW   ,      15,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_SCALETYPE_XZ                , D3DMTS_VIEW   ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XZ                , D3DMTS_VIEW   ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XZ                , D3DMTS_VIEW   ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XZ                , D3DMTS_VIEW   ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XZ                , D3DMTS_VIEW   ,       4,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XZ                , D3DMTS_VIEW   ,       5,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XZ                , D3DMTS_VIEW   ,       6,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XZ                , D3DMTS_VIEW   ,       7,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XZ                , D3DMTS_VIEW   ,       8,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XZ                , D3DMTS_VIEW   ,       9,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XZ                , D3DMTS_VIEW   ,      10,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XZ                , D3DMTS_VIEW   ,      11,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XZ                , D3DMTS_VIEW   ,      12,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XZ                , D3DMTS_VIEW   ,      13,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XZ                , D3DMTS_VIEW   ,      14,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XZ                , D3DMTS_VIEW   ,      15,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_SCALETYPE_YZ                , D3DMTS_VIEW   ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_YZ                , D3DMTS_VIEW   ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_YZ                , D3DMTS_VIEW   ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_YZ                , D3DMTS_VIEW   ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_YZ                , D3DMTS_VIEW   ,       4,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_YZ                , D3DMTS_VIEW   ,       5,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_YZ                , D3DMTS_VIEW   ,       6,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_YZ                , D3DMTS_VIEW   ,       7,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_YZ                , D3DMTS_VIEW   ,       8,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_YZ                , D3DMTS_VIEW   ,       9,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_YZ                , D3DMTS_VIEW   ,      10,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_YZ                , D3DMTS_VIEW   ,      11,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_YZ                , D3DMTS_VIEW   ,      12,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_YZ                , D3DMTS_VIEW   ,      13,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_YZ                , D3DMTS_VIEW   ,      14,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_YZ                , D3DMTS_VIEW   ,      15,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_SCALETYPE_XYZ               , D3DMTS_VIEW   ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XYZ               , D3DMTS_VIEW   ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XYZ               , D3DMTS_VIEW   ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XYZ               , D3DMTS_VIEW   ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XYZ               , D3DMTS_VIEW   ,       4,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XYZ               , D3DMTS_VIEW   ,       5,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XYZ               , D3DMTS_VIEW   ,       6,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XYZ               , D3DMTS_VIEW   ,       7,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XYZ               , D3DMTS_VIEW   ,       8,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XYZ               , D3DMTS_VIEW   ,       9,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XYZ               , D3DMTS_VIEW   ,      10,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XYZ               , D3DMTS_VIEW   ,      11,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XYZ               , D3DMTS_VIEW   ,      12,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XYZ               , D3DMTS_VIEW   ,      13,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XYZ               , D3DMTS_VIEW   ,      14,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XYZ               , D3DMTS_VIEW   ,      15,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XYZ               , D3DMTS_VIEW   ,      16,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XYZ               , D3DMTS_VIEW   ,      17,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XYZ               , D3DMTS_VIEW   ,      18,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XYZ               , D3DMTS_VIEW   ,      19,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XYZ               , D3DMTS_VIEW   ,      20,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XYZ               , D3DMTS_VIEW   ,      21,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XYZ               , D3DMTS_VIEW   ,      22,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XYZ               , D3DMTS_VIEW   ,      23,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XYZ               , D3DMTS_VIEW   ,      24,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XYZ               , D3DMTS_VIEW   ,      25,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SCALETYPE_XYZ               , D3DMTS_VIEW   ,      26,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_SCALETYPE_X                 , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_SCALETYPE_Y                 , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_SCALETYPE_Z                 , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_SCALETYPE_XY                , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_SCALETYPE_XZ                , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_SCALETYPE_YZ                , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_SCALETYPE_XYZ               , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_SCALETYPE_X                 , D3DMTS_VIEW   ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_SCALETYPE_Y                 , D3DMTS_VIEW   ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_SCALETYPE_Z                 , D3DMTS_VIEW   ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_SCALETYPE_XY                , D3DMTS_VIEW   ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_SCALETYPE_XZ                , D3DMTS_VIEW   ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_SCALETYPE_YZ                , D3DMTS_VIEW   ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_SCALETYPE_XYZ               , D3DMTS_VIEW   ,       1,        D3DMFMT_D3DMVALUE_FIXED},

	{ (DWORD)D3DQA_SHEARTYPE_XY                , D3DMTS_WORLD  ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SHEARTYPE_XY                , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SHEARTYPE_XY                , D3DMTS_WORLD  ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SHEARTYPE_XY                , D3DMTS_WORLD  ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SHEARTYPE_XY                , D3DMTS_WORLD  ,       4,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_SHEARTYPE_XZ                , D3DMTS_WORLD  ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SHEARTYPE_XZ                , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SHEARTYPE_XZ                , D3DMTS_WORLD  ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SHEARTYPE_XZ                , D3DMTS_WORLD  ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SHEARTYPE_XZ                , D3DMTS_WORLD  ,       4,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_SHEARTYPE_YX                , D3DMTS_WORLD  ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SHEARTYPE_YX                , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SHEARTYPE_YX                , D3DMTS_WORLD  ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SHEARTYPE_YX                , D3DMTS_WORLD  ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SHEARTYPE_YX                , D3DMTS_WORLD  ,       4,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_SHEARTYPE_YZ                , D3DMTS_WORLD  ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SHEARTYPE_YZ                , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SHEARTYPE_YZ                , D3DMTS_WORLD  ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SHEARTYPE_YZ                , D3DMTS_WORLD  ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SHEARTYPE_YZ                , D3DMTS_WORLD  ,       4,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_SHEARTYPE_ZX                , D3DMTS_WORLD  ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SHEARTYPE_ZX                , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SHEARTYPE_ZX                , D3DMTS_WORLD  ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SHEARTYPE_ZX                , D3DMTS_WORLD  ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SHEARTYPE_ZX                , D3DMTS_WORLD  ,       4,        D3DMFMT_D3DMVALUE_FLOAT},
	
	{ (DWORD)D3DQA_SHEARTYPE_ZY                , D3DMTS_WORLD  ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SHEARTYPE_ZY                , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SHEARTYPE_ZY                , D3DMTS_WORLD  ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SHEARTYPE_ZY                , D3DMTS_WORLD  ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SHEARTYPE_ZY                , D3DMTS_WORLD  ,       4,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_SHEARTYPE_XY                , D3DMTS_VIEW   ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SHEARTYPE_XY                , D3DMTS_VIEW   ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SHEARTYPE_XY                , D3DMTS_VIEW   ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SHEARTYPE_XY                , D3DMTS_VIEW   ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SHEARTYPE_XY                , D3DMTS_VIEW   ,       4,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_SHEARTYPE_XZ                , D3DMTS_VIEW   ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SHEARTYPE_XZ                , D3DMTS_VIEW   ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SHEARTYPE_XZ                , D3DMTS_VIEW   ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SHEARTYPE_XZ                , D3DMTS_VIEW   ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SHEARTYPE_XZ                , D3DMTS_VIEW   ,       4,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_SHEARTYPE_YX                , D3DMTS_VIEW   ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SHEARTYPE_YX                , D3DMTS_VIEW   ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SHEARTYPE_YX                , D3DMTS_VIEW   ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SHEARTYPE_YX                , D3DMTS_VIEW   ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SHEARTYPE_YX                , D3DMTS_VIEW   ,       4,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_SHEARTYPE_YZ                , D3DMTS_VIEW   ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SHEARTYPE_YZ                , D3DMTS_VIEW   ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SHEARTYPE_YZ                , D3DMTS_VIEW   ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SHEARTYPE_YZ                , D3DMTS_VIEW   ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SHEARTYPE_YZ                , D3DMTS_VIEW   ,       4,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_SHEARTYPE_ZX                , D3DMTS_VIEW   ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SHEARTYPE_ZX                , D3DMTS_VIEW   ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SHEARTYPE_ZX                , D3DMTS_VIEW   ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SHEARTYPE_ZX                , D3DMTS_VIEW   ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SHEARTYPE_ZX                , D3DMTS_VIEW   ,       4,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_SHEARTYPE_ZY                , D3DMTS_VIEW   ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SHEARTYPE_ZY                , D3DMTS_VIEW   ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SHEARTYPE_ZY                , D3DMTS_VIEW   ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SHEARTYPE_ZY                , D3DMTS_VIEW   ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_SHEARTYPE_ZY                , D3DMTS_VIEW   ,       4,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_SHEARTYPE_XY                , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_SHEARTYPE_XZ                , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_SHEARTYPE_YX                , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_SHEARTYPE_YZ                , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_SHEARTYPE_ZX                , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_SHEARTYPE_ZY                , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_SHEARTYPE_XY                , D3DMTS_VIEW   ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_SHEARTYPE_XZ                , D3DMTS_VIEW   ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_SHEARTYPE_YX                , D3DMTS_VIEW   ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_SHEARTYPE_YZ                , D3DMTS_VIEW   ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_SHEARTYPE_ZX                , D3DMTS_VIEW   ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_SHEARTYPE_ZY                , D3DMTS_VIEW   ,       1,        D3DMFMT_D3DMVALUE_FIXED},

	{ (DWORD)D3DQA_TRANSLATETYPE_X             , D3DMTS_WORLD  ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_X             , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_X             , D3DMTS_WORLD  ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_X             , D3DMTS_WORLD  ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_X             , D3DMTS_WORLD  ,       4,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_TRANSLATETYPE_Y             , D3DMTS_WORLD  ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_Y             , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_Y             , D3DMTS_WORLD  ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_Y             , D3DMTS_WORLD  ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_Y             , D3DMTS_WORLD  ,       4,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_TRANSLATETYPE_Z             , D3DMTS_WORLD  ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_Z             , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_Z             , D3DMTS_WORLD  ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_Z             , D3DMTS_WORLD  ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_Z             , D3DMTS_WORLD  ,       4,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_TRANSLATETYPE_XY            , D3DMTS_WORLD  ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XY            , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XY            , D3DMTS_WORLD  ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XY            , D3DMTS_WORLD  ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XY            , D3DMTS_WORLD  ,       4,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XY            , D3DMTS_WORLD  ,       5,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XY            , D3DMTS_WORLD  ,       6,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XY            , D3DMTS_WORLD  ,       7,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XY            , D3DMTS_WORLD  ,       8,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XY            , D3DMTS_WORLD  ,       9,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XY            , D3DMTS_WORLD  ,      10,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XY            , D3DMTS_WORLD  ,      11,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XY            , D3DMTS_WORLD  ,      12,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XY            , D3DMTS_WORLD  ,      13,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XY            , D3DMTS_WORLD  ,      14,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XY            , D3DMTS_WORLD  ,      15,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_TRANSLATETYPE_XZ            , D3DMTS_WORLD  ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XZ            , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XZ            , D3DMTS_WORLD  ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XZ            , D3DMTS_WORLD  ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XZ            , D3DMTS_WORLD  ,       4,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XZ            , D3DMTS_WORLD  ,       5,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XZ            , D3DMTS_WORLD  ,       6,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XZ            , D3DMTS_WORLD  ,       7,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XZ            , D3DMTS_WORLD  ,       8,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XZ            , D3DMTS_WORLD  ,       9,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XZ            , D3DMTS_WORLD  ,      10,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XZ            , D3DMTS_WORLD  ,      11,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XZ            , D3DMTS_WORLD  ,      12,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XZ            , D3DMTS_WORLD  ,      13,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XZ            , D3DMTS_WORLD  ,      14,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XZ            , D3DMTS_WORLD  ,      15,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_TRANSLATETYPE_YZ            , D3DMTS_WORLD  ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_YZ            , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_YZ            , D3DMTS_WORLD  ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_YZ            , D3DMTS_WORLD  ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_YZ            , D3DMTS_WORLD  ,       4,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_YZ            , D3DMTS_WORLD  ,       5,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_YZ            , D3DMTS_WORLD  ,       6,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_YZ            , D3DMTS_WORLD  ,       7,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_YZ            , D3DMTS_WORLD  ,       8,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_YZ            , D3DMTS_WORLD  ,       9,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_YZ            , D3DMTS_WORLD  ,      10,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_YZ            , D3DMTS_WORLD  ,      11,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_YZ            , D3DMTS_WORLD  ,      12,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_YZ            , D3DMTS_WORLD  ,      13,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_YZ            , D3DMTS_WORLD  ,      14,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_YZ            , D3DMTS_WORLD  ,      15,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_TRANSLATETYPE_XYZ           , D3DMTS_WORLD  ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XYZ           , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XYZ           , D3DMTS_WORLD  ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XYZ           , D3DMTS_WORLD  ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XYZ           , D3DMTS_WORLD  ,       4,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XYZ           , D3DMTS_WORLD  ,       5,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XYZ           , D3DMTS_WORLD  ,       6,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XYZ           , D3DMTS_WORLD  ,       7,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XYZ           , D3DMTS_WORLD  ,       8,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XYZ           , D3DMTS_WORLD  ,       9,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XYZ           , D3DMTS_WORLD  ,      10,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XYZ           , D3DMTS_WORLD  ,      11,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XYZ           , D3DMTS_WORLD  ,      12,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XYZ           , D3DMTS_WORLD  ,      13,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XYZ           , D3DMTS_WORLD  ,      14,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XYZ           , D3DMTS_WORLD  ,      15,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XYZ           , D3DMTS_WORLD  ,      16,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XYZ           , D3DMTS_WORLD  ,      17,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XYZ           , D3DMTS_WORLD  ,      18,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XYZ           , D3DMTS_WORLD  ,      19,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XYZ           , D3DMTS_WORLD  ,      20,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XYZ           , D3DMTS_WORLD  ,      21,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XYZ           , D3DMTS_WORLD  ,      22,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XYZ           , D3DMTS_WORLD  ,      23,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XYZ           , D3DMTS_WORLD  ,      24,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XYZ           , D3DMTS_WORLD  ,      25,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XYZ           , D3DMTS_WORLD  ,      26,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_TRANSLATETYPE_X             , D3DMTS_VIEW   ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_X             , D3DMTS_VIEW   ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_X             , D3DMTS_VIEW   ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_X             , D3DMTS_VIEW   ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_X             , D3DMTS_VIEW   ,       4,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_TRANSLATETYPE_Y             , D3DMTS_VIEW   ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_Y             , D3DMTS_VIEW   ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_Y             , D3DMTS_VIEW   ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_Y             , D3DMTS_VIEW   ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_Y             , D3DMTS_VIEW   ,       4,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_TRANSLATETYPE_Z             , D3DMTS_VIEW   ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_Z             , D3DMTS_VIEW   ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_Z             , D3DMTS_VIEW   ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_Z             , D3DMTS_VIEW   ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_Z             , D3DMTS_VIEW   ,       4,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_TRANSLATETYPE_XY            , D3DMTS_VIEW   ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XY            , D3DMTS_VIEW   ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XY            , D3DMTS_VIEW   ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XY            , D3DMTS_VIEW   ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XY            , D3DMTS_VIEW   ,       4,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XY            , D3DMTS_VIEW   ,       5,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XY            , D3DMTS_VIEW   ,       6,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XY            , D3DMTS_VIEW   ,       7,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XY            , D3DMTS_VIEW   ,       8,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XY            , D3DMTS_VIEW   ,       9,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XY            , D3DMTS_VIEW   ,      10,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XY            , D3DMTS_VIEW   ,      11,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XY            , D3DMTS_VIEW   ,      12,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XY            , D3DMTS_VIEW   ,      13,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XY            , D3DMTS_VIEW   ,      14,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XY            , D3DMTS_VIEW   ,      15,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_TRANSLATETYPE_XZ            , D3DMTS_VIEW   ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XZ            , D3DMTS_VIEW   ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XZ            , D3DMTS_VIEW   ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XZ            , D3DMTS_VIEW   ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XZ            , D3DMTS_VIEW   ,       4,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XZ            , D3DMTS_VIEW   ,       5,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XZ            , D3DMTS_VIEW   ,       6,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XZ            , D3DMTS_VIEW   ,       7,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XZ            , D3DMTS_VIEW   ,       8,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XZ            , D3DMTS_VIEW   ,       9,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XZ            , D3DMTS_VIEW   ,      10,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XZ            , D3DMTS_VIEW   ,      11,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XZ            , D3DMTS_VIEW   ,      12,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XZ            , D3DMTS_VIEW   ,      13,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XZ            , D3DMTS_VIEW   ,      14,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XZ            , D3DMTS_VIEW   ,      15,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_TRANSLATETYPE_YZ            , D3DMTS_VIEW   ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_YZ            , D3DMTS_VIEW   ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_YZ            , D3DMTS_VIEW   ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_YZ            , D3DMTS_VIEW   ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_YZ            , D3DMTS_VIEW   ,       4,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_YZ            , D3DMTS_VIEW   ,       5,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_YZ            , D3DMTS_VIEW   ,       6,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_YZ            , D3DMTS_VIEW   ,       7,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_YZ            , D3DMTS_VIEW   ,       8,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_YZ            , D3DMTS_VIEW   ,       9,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_YZ            , D3DMTS_VIEW   ,      10,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_YZ            , D3DMTS_VIEW   ,      11,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_YZ            , D3DMTS_VIEW   ,      12,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_YZ            , D3DMTS_VIEW   ,      13,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_YZ            , D3DMTS_VIEW   ,      14,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_YZ            , D3DMTS_VIEW   ,      15,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_TRANSLATETYPE_XYZ           , D3DMTS_VIEW   ,       0,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XYZ           , D3DMTS_VIEW   ,       1,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XYZ           , D3DMTS_VIEW   ,       2,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XYZ           , D3DMTS_VIEW   ,       3,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XYZ           , D3DMTS_VIEW   ,       4,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XYZ           , D3DMTS_VIEW   ,       5,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XYZ           , D3DMTS_VIEW   ,       6,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XYZ           , D3DMTS_VIEW   ,       7,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XYZ           , D3DMTS_VIEW   ,       8,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XYZ           , D3DMTS_VIEW   ,       9,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XYZ           , D3DMTS_VIEW   ,      10,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XYZ           , D3DMTS_VIEW   ,      11,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XYZ           , D3DMTS_VIEW   ,      12,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XYZ           , D3DMTS_VIEW   ,      13,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XYZ           , D3DMTS_VIEW   ,      14,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XYZ           , D3DMTS_VIEW   ,      15,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XYZ           , D3DMTS_VIEW   ,      16,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XYZ           , D3DMTS_VIEW   ,      17,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XYZ           , D3DMTS_VIEW   ,      18,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XYZ           , D3DMTS_VIEW   ,      19,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XYZ           , D3DMTS_VIEW   ,      20,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XYZ           , D3DMTS_VIEW   ,      21,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XYZ           , D3DMTS_VIEW   ,      22,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XYZ           , D3DMTS_VIEW   ,      23,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XYZ           , D3DMTS_VIEW   ,      24,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XYZ           , D3DMTS_VIEW   ,      25,        D3DMFMT_D3DMVALUE_FLOAT},
	{ (DWORD)D3DQA_TRANSLATETYPE_XYZ           , D3DMTS_VIEW   ,      26,        D3DMFMT_D3DMVALUE_FLOAT},

	{ (DWORD)D3DQA_TRANSLATETYPE_X             , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_TRANSLATETYPE_Y             , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_TRANSLATETYPE_Z             , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_TRANSLATETYPE_XY            , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_TRANSLATETYPE_XZ            , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_TRANSLATETYPE_YZ            , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_TRANSLATETYPE_XYZ           , D3DMTS_WORLD  ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_TRANSLATETYPE_X             , D3DMTS_VIEW   ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_TRANSLATETYPE_Y             , D3DMTS_VIEW   ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_TRANSLATETYPE_Z             , D3DMTS_VIEW   ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_TRANSLATETYPE_XY            , D3DMTS_VIEW   ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_TRANSLATETYPE_XZ            , D3DMTS_VIEW   ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_TRANSLATETYPE_YZ            , D3DMTS_VIEW   ,       1,        D3DMFMT_D3DMVALUE_FIXED},
	{ (DWORD)D3DQA_TRANSLATETYPE_XYZ           , D3DMTS_VIEW   ,       1,        D3DMFMT_D3DMVALUE_FIXED},

};

