//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft shared
// source or premium shared source license agreement under which you licensed
// this source code. If you did not accept the terms of the license agreement,
// you are not authorized to use this source code. For the terms of the license,
// please see the license agreement between you and Microsoft or, if applicable,
// see the SOURCE.RTF on your install media or the root of your tools installation.
// THE SOURCE CODE IS PROVIDED "AS IS", WITH NO WARRANTIES OR INDEMNITIES.
//
////////////////////////////////////////////////////////////////////////////////
//
//  TUXTEST TUX DLL
//  Copyright (c) Microsoft Corporation
//
//  Module: JPN,h
//          
//
//  Revision History:changed #define values:
//
////////////////////////////////////////////////////////////////////////////////

#include "..\kbddef.h"

// ****************************************************
// Japanese keyboard
//
//  Num  VK1   VK2      Unicode
testSequence KBDTests_Japanese1[] = 
{
    {1, { 49 ,0}, 1, '1'},
    {1, { 50, 0}, 1, '2'},
    {1, { 51, 0}, 1, '3'},
    {1, { 52 ,0}, 1, '4'},
    {1, { 53 ,0}, 1, '5'},
    {1, { 54, 0}, 1, '6'},
    {1, { 55, 0}, 1, '7'},
    {1, { 56, 0}, 1, '8'},
    {1, { 57, 0}, 1, '9'},
    {1, { 48, 0}, 1, '0'},
    {1, {189, 0}, 1, '-'},
    {1, {187, 0}, 1, '^'},

    {2, {0x10, 49}, 1, '!'},
    {2, {0x10, 50}, 1, '\"'},
    {2, {0x10, 51}, 1, '#'},
    {2, {0x10, 52}, 1, '$'},
    {2, {0x10, 53}, 1, '%'},
    {2, {0x10, 54}, 1, '&'},
    {2, {0x10, 55}, 1, '\''},
    {2, {0x10, 56}, 1, '('},
    {2, {0x10, 57}, 1, ')'},
    {2, {0x10, 48}, 1, '~'}, // Bug 154413 - Windows CE .NET
    {2, {0x10, 189},1, '='},
    {2, {0x10, 187},1, '_'}, // Bug 154412 - Windows CE .NET
    {1, { 8,  0 },  1,  8 },

    {1, { 9,  0 }, 1,  9},
    {1, { 81, 0 }, 1, 'q'},
    {1, { 87, 0 }, 1, 'w'},
    {1, { 69, 0 }, 1, 'e'},
    {1, { 82, 0 }, 1, 'r'},
    {1, { 84, 0 }, 1, 't'},
    {1, { 89,  0}, 1, 'y'},
    {1, { 85,  0}, 1, 'u'},
    {1, { 73,  0}, 1, 'i'},
    {1, { 79,  0}, 1, 'o'},
    {1, { 80,  0}, 1, 'p'},
    {1, {192,  0}, 1, '@'},
    {1, {219,  0}, 1, '['},
    {1, {221,  0}, 1, ']'},

    {2, {0x10,  9 }, 1,   9},
    {2, {0x10, 81 }, 1, 'Q'},
    {2, {0x10, 87 }, 1, 'W'},
    {2, {0x10, 69 }, 1, 'E'},
    {2, {0x10, 82 }, 1, 'R'},
    {2, {0x10, 84 }, 1, 'T'},
    {2, {0x10, 89 }, 1, 'Y'},
    {2, {0x10, 85 }, 1, 'U'},
    {2, {0x10, 73 }, 1, 'I'},
    {2, {0x10, 79 }, 1, 'O'},
    {2, {0x10, 80 }, 1, 'P'},
    {2, {0x10,192 }, 1, '`'},
    {2, {0x10,219 }, 1, '{'},
    {2, {0x10,221 }, 1, '}'},

    {1, { 65 , 0 }, 1, 'a' },
    {1, { 83 , 0 }, 1, 's' },
    {1, { 68 , 0 }, 1, 'd' },
    {1, { 70 , 0 }, 1, 'f' },
    {1, { 71 , 0 }, 1, 'g' },
    {1, { 72 , 0 }, 1, 'h' },
    {1, { 74 , 0 }, 1, 'j' },
    {1, { 75 , 0 }, 1, 'k' },
    {1, { 76 , 0 }, 1, 'l' },
    {1, { 186 , 0}, 1, ';' },
    {1, { 222 , 0}, 1, ':' },
    {1, { 13 ,  0}, 1, 13  },      // ENTER

    {2, { 0x10, 65 }, 1, 'A' },
    {2, { 0x10, 83 }, 1, 'S' },
    {2, { 0x10, 68 }, 1, 'D' },
    {2, { 0x10, 70 }, 1, 'F' },
    {2, { 0x10, 71 }, 1, 'G' },
    {2, { 0x10, 72 }, 1, 'H' },
    {2, { 0x10, 74 }, 1, 'J' },
    {2, { 0x10, 75 }, 1, 'K' },
    {2, { 0x10, 76 }, 1, 'L' },
    {2, { 0x10,186 }, 1, '+' },
    {2, { 0x10,222 }, 1, '*' },
    {2, { 0x10, 13 }, 1, 13  },


    {1, {  90, 0 }, 1, 'z' },
    {1, {  88, 0 }, 1, 'x' },
    {1, {  67, 0 }, 1, 'c' },
    {1, {  86, 0 }, 1, 'v' },
    {1, {  66, 0 }, 1, 'b' },
    {1, {  78, 0 }, 1, 'n' },
    {1, {  77, 0 }, 1, 'm' },
    {1, { 188 , 0}, 1, ',' },
    {1, { 190 , 0}, 1, '.' },
    {1, { 191 , 0}, 1, '/' },


    {2, { 0x10, 90 }, 1, 'Z' },
    {2, { 0x10, 88 }, 1, 'X' },
    {2, { 0x10, 67 }, 1, 'C' },
    {2, { 0x10, 86 }, 1, 'V' },
    {2, { 0x10, 66 }, 1, 'B' },
    {2, { 0x10, 78 }, 1, 'N' },
    {2, { 0x10, 77 }, 1, 'M' },
    {2, { 0x10, 188}, 1, '<' },
    {2, { 0x10, 190}, 1, '>' },
    {2, { 0x10, 191}, 1, '?' },

    {1, {0x1B,   0 }, 1, 0x1B},
    {1, { 226,   0 }, 1, '\\'}, // \ key
    {2, { 0x10, 226}, 1, '_' },
    {2, { 0x10, 220}, 1, '|' },

    // Control chars
    // Row ZXCVBNM 
    {2, { 0x11, 90 }, 1,  0x1A },
    {2, { 0x11, 88 }, 1,  0x18 },
    {2, { 0x11, 67 }, 1,  0x03 },
    {2, { 0x11, 86 }, 1,  0x16 },
    {2, { 0x11, 66 }, 1,  0x02 },
    {2, { 0x11, 78 }, 1,  0x0E },
    {2, { 0x11, 77 }, 1,  0x0D},
    //Row ASDFG
    {2, { 0x11, 65 }, 1, 0x01 },
    {2, { 0x11, 83 }, 1, 0x13 },
    {2, { 0x11, 68 }, 1, 0x04 },
    {2, { 0x11, 70 }, 1, 0x06 },
    {2, { 0x11, 71 }, 1, 0x07 },
    {2, { 0x11, 72 }, 1, 0x08 },
    {2, { 0x11, 74 }, 1, 0x0A },
    {2, { 0x11, 75 }, 1, 0x0B },
    {2, { 0x11, 76 }, 1, 0x0C },
    // Row QWERTY
    {2, {0x11, 81 }, 1, 0x11 },
    {2, {0x11, 87 }, 1, 0x17 },
    {2, {0x11, 69 }, 1, 0x05 },
    {2, {0x11, 82 }, 1, 0x12 },
    {2, {0x11, 84 }, 1, 0x14 },
    {2, {0x11, 89 }, 1, 0x19 },
    {2, {0x11, 85 }, 1, 0x15 },
    {2, {0x11, 73 }, 1, 0x09 },
    {2, {0x11, 79 }, 1, 0x0F },
    {2, {0x11, 80 }, 1, 0x10 },

    // CAPSLOCK
    {STATE_CAPSLOCK, {0x10, 0x14 }, 0, 0 },

    {1, { 49 ,0}, 1, '1'},
    {1, { 50, 0}, 1, '2'},
    {1, { 51, 0}, 1, '3'},
    {1, { 52 ,0}, 1, '4'},
    {1, { 53 ,0}, 1, '5'},
    {1, { 54, 0}, 1, '6'},
    {1, { 55, 0}, 1, '7'},
    {1, { 56, 0}, 1, '8'},
    {1, { 57, 0}, 1, '9'},
    {1, { 48, 0}, 1, '0'},
    {1, {189, 0}, 1, '-'},
    {1, {187, 0}, 1, '^'},

    {2, {0x10, 49 }, 1, '!' },
    {2, {0x10, 50 }, 1, '\"'},
    {2, {0x10, 51 }, 1, '#' },
    {2, {0x10, 52 }, 1, '$' },
    {2, {0x10, 53 }, 1, '%' },
    {2, {0x10, 54 }, 1, '&' },
    {2, {0x10, 55 }, 1, '\''},
    {2, {0x10, 56 }, 1, '(' },
    {2, {0x10, 57 }, 1, ')' },
    {2, {0x10, 48 }, 1, '~' },
    {2, {0x10, 189}, 1, '=' },
    {1, {8,    0  }, 1,   8 },


    {1, { 9,  0 }, 1,  9 },
    {1, { 81, 0 }, 1, 'Q'},
    {1, { 87, 0 }, 1, 'W'},
    {1, { 69, 0 }, 1, 'E'},
    {1, { 82, 0 }, 1, 'R'},
    {1, { 84, 0 }, 1, 'T'},
    {1, { 89,  0}, 1, 'Y'},
    {1, { 85,  0}, 1, 'U'},
    {1, { 73,  0}, 1, 'I'},
    {1, { 79,  0}, 1, 'O'},
    {1, { 80,  0}, 1, 'P'},
    {1, {192,  0}, 1, '@'},
    {1, {219,  0}, 1, '['},
    {1, {221,  0}, 1, ']'},


    {2, {0x10,  9 }, 1,   9},
    {2, {0x10, 81 }, 1, 'q'},
    {2, {0x10, 87 }, 1, 'w'},
    {2, {0x10, 69 }, 1, 'e'},
    {2, {0x10, 82 }, 1, 'r'},
    {2, {0x10, 84 }, 1, 't'},
    {2, {0x10, 89 }, 1, 'y'},
    {2, {0x10, 85 }, 1, 'u'},
    {2, {0x10, 73 }, 1, 'i'},
    {2, {0x10, 79 }, 1, 'o'},
    {2, {0x10, 80 }, 1, 'p'},
    {2, {0x10,192 }, 1, '`'},
    {2, {0x10,219 }, 1, '{'},
    {2, {0x10,221 }, 1, '}'},  

    {1, {  90, 0 }, 1, 'Z' },
    {1, {  88, 0 }, 1, 'X' },
    {1, {  67, 0 }, 1, 'C' },
    {1, {  86, 0 }, 1, 'V' },
    {1, {  66, 0 }, 1, 'B' },
    {1, {  78, 0 }, 1, 'N' },
    {1, {  77, 0 }, 1, 'M' },

    {2, { 0x10, 90 }, 1, 'z' },
    {2, { 0x10, 88 }, 1, 'x' },
    {2, { 0x10, 67 }, 1, 'c' },
    {2, { 0x10, 86 }, 1, 'v' },
    {2, { 0x10, 66 }, 1, 'b' },
    {2, { 0x10, 78 }, 1, 'n' },
    {2, { 0x10, 77 }, 1, 'm' },
    {2, { 0x10, 188}, 1, '<' },
    {2, { 0x10, 190}, 1, '>' },
    {2, { 0x10, 191}, 1, '?' },

    {1, { 65 , 0 }, 1, 'A' },
    {1, { 83 , 0 }, 1, 'S' },
    {1, { 68 , 0 }, 1, 'D' },
    {1, { 70 , 0 }, 1, 'F' },
    {1, { 71 , 0 }, 1, 'G' },
    {1, { 72 , 0 }, 1, 'H' },
    {1, { 74 , 0 }, 1, 'J' },
    {1, { 75 , 0 }, 1, 'K' },
    {1, { 76 , 0 }, 1, 'L' },
    {1, { 186 , 0}, 1, ';' },
    {1, { 222 , 0}, 1, ':' },
    {1, { 13 ,  0}, 1, 13  },      // ENTER

    {2, { 0x10, 65 }, 1,'a'  },
    {2, { 0x10, 83 }, 1, 's' },
    {2, { 0x10, 68 }, 1, 'd' },
    {2, { 0x10, 70 }, 1, 'f' },
    {2, { 0x10, 71 }, 1, 'g' },
    {2, { 0x10, 72 }, 1, 'h' },
    {2, { 0x10, 74 }, 1, 'j' },
    {2, { 0x10, 75 }, 1, 'k' },
    {2, { 0x10, 76 }, 1, 'l' },
    {2, { 0x10,186 }, 1, '+' },
    {2, { 0x10,222 }, 1, '*' },
    {2, { 0x10, 13 }, 1, 13  },
    {1, { 226,   0 }, 1, '\\'}, // \ key
    {2, { 0x10, 226}, 1, '_' },
    {2, { 0x10, 220}, 1, '|' },
    // Control chars
    // Row ZXCVBNM 
    {2, { 0x11, 90 }, 1,  0x1A },
    {2, { 0x11, 88 }, 1,  0x18 },
    {2, { 0x11, 67 }, 1,  0x03 },
    {2, { 0x11, 86 }, 1,  0x16 },
    {2, { 0x11, 66 }, 1,  0x02 },
    {2, { 0x11, 78 }, 1,  0x0E },
    {2, { 0x11, 77 }, 1,  0x0D},
    //Row ASDFG
    {2, { 0x11, 65 }, 1, 0x01 },
    {2, { 0x11, 83 }, 1, 0x13 },
    {2, { 0x11, 68 }, 1, 0x04 },
    {2, { 0x11, 70 }, 1, 0x06 },
    {2, { 0x11, 71 }, 1, 0x07 },
    {2, { 0x11, 72 }, 1, 0x08 },
    {2, { 0x11, 74 }, 1, 0x0A },
    {2, { 0x11, 75 }, 1, 0x0B },
    {2, { 0x11, 76 }, 1, 0x0C },
    // Row QWERTY
    {2, {0x11, 81 }, 1, 0x11 },
    {2, {0x11, 87 }, 1, 0x17 },
    {2, {0x11, 69 }, 1, 0x05 },
    {2, {0x11, 82 }, 1, 0x12 },
    {2, {0x11, 84 }, 1, 0x14 },
    {2, {0x11, 89 }, 1, 0x19 },
    {2, {0x11, 85 }, 1, 0x15 },
    {2, {0x11, 73 }, 1, 0x09 },
    {2, {0x11, 79 }, 1, 0x0F },
    {2, {0x11, 80 }, 1, 0x10 },
    // Alt keys

    //   {2, {0x12, 81 }, 1, 'Q'},

    //Turn CAPSLOCK OFF
    {STATE_CAPSLOCK, {0x10, 0x14 }, 0, 0},

    // Test Japanese keyboard states...
    // Move to Hiragana
    //    {STATE_KANA, {0x00}, 0, 0},    // move to Japanese
    //    {STATE_HIRAGANA, {0x00}, 0, 0}, // move to Hiragana
    //
    //// Move to Katakana
    //    {STATE_


};      // end japanese keyboard
