//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft shared
// source or premium shared source license agreement under which you licensed
// this source code. If you did not accept the terms of the license agreement,
// you are not authorized to use this source code. For the terms of the license,
// please see the license agreement between you and Microsoft or, if applicable,
// see the SOURCE.RTF on your install media or the root of your tools installation.
// THE SOURCE CODE IS PROVIDED "AS IS", WITH NO WARRANTIES OR INDEMNITIES.
//
#pragma once

//
// DeviceIOControl dwIoControlCode values for Wave In devices
//
#define IOCTL_WAVE_IN_ADD_BUFFER         CTL_CODE(FILE_DEVICE_WAVE_IN, 1, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_WAVE_IN_CLOSE              CTL_CODE(FILE_DEVICE_WAVE_IN, 2, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_WAVE_IN_GET_DEV_CAPS       CTL_CODE(FILE_DEVICE_WAVE_IN, 3, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_WAVE_IN_GET_ERROR_TEXT     CTL_CODE(FILE_DEVICE_WAVE_IN, 4, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_WAVE_IN_GET_ID             CTL_CODE(FILE_DEVICE_WAVE_IN, 5, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_WAVE_IN_GET_NUM_DEVS       CTL_CODE(FILE_DEVICE_WAVE_IN, 6, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_WAVE_IN_GET_POSITION       CTL_CODE(FILE_DEVICE_WAVE_IN, 7, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_WAVE_IN_MESSAGE            CTL_CODE(FILE_DEVICE_WAVE_IN, 8, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_WAVE_IN_OPEN               CTL_CODE(FILE_DEVICE_WAVE_IN, 9, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_WAVE_IN_PREPARE_HEADER     CTL_CODE(FILE_DEVICE_WAVE_IN,10, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_WAVE_IN_RESET              CTL_CODE(FILE_DEVICE_WAVE_IN,11, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_WAVE_IN_START              CTL_CODE(FILE_DEVICE_WAVE_IN,12, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_WAVE_IN_STOP               CTL_CODE(FILE_DEVICE_WAVE_IN,13, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_WAVE_IN_UNPREPARE_HEADER   CTL_CODE(FILE_DEVICE_WAVE_IN,14, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_WAVE_IN_SET_PROPS          CTL_CODE(FILE_DEVICE_WAVE_IN,15, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_WAVE_IN_GET_PROPS          CTL_CODE(FILE_DEVICE_WAVE_IN,16, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_WAVE_OUT_BREAK_LOOP        CTL_CODE(FILE_DEVICE_WAVE_OUT, 1, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_WAVE_OUT_CLOSE             CTL_CODE(FILE_DEVICE_WAVE_OUT, 2, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_WAVE_OUT_GET_DEV_CAPS      CTL_CODE(FILE_DEVICE_WAVE_OUT, 3, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_WAVE_OUT_GET_ERROR_TEXT    CTL_CODE(FILE_DEVICE_WAVE_OUT, 4, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_WAVE_OUT_GET_ID            CTL_CODE(FILE_DEVICE_WAVE_OUT, 5, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_WAVE_OUT_GET_NUM_DEVS      CTL_CODE(FILE_DEVICE_WAVE_OUT, 6, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_WAVE_OUT_GET_PITCH         CTL_CODE(FILE_DEVICE_WAVE_OUT, 7, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_WAVE_OUT_GET_PLAYBACK_RATE CTL_CODE(FILE_DEVICE_WAVE_OUT, 8, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_WAVE_OUT_GET_POSITION      CTL_CODE(FILE_DEVICE_WAVE_OUT, 9, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_WAVE_OUT_GET_VOLUME        CTL_CODE(FILE_DEVICE_WAVE_OUT,10, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_WAVE_OUT_MESSAGE           CTL_CODE(FILE_DEVICE_WAVE_OUT,11, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_WAVE_OUT_OPEN              CTL_CODE(FILE_DEVICE_WAVE_OUT,12, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_WAVE_OUT_PAUSE             CTL_CODE(FILE_DEVICE_WAVE_OUT,13, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_WAVE_OUT_PREPARE_HEADER    CTL_CODE(FILE_DEVICE_WAVE_OUT,14, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_WAVE_OUT_RESET             CTL_CODE(FILE_DEVICE_WAVE_OUT,15, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_WAVE_OUT_RESTART           CTL_CODE(FILE_DEVICE_WAVE_OUT,16, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_WAVE_OUT_SET_PITCH         CTL_CODE(FILE_DEVICE_WAVE_OUT,17, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_WAVE_OUT_SET_PLAYBACK_RATE CTL_CODE(FILE_DEVICE_WAVE_OUT,18, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_WAVE_OUT_SET_VOLUME        CTL_CODE(FILE_DEVICE_WAVE_OUT,19, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_WAVE_OUT_UNPREPARE_HEADER  CTL_CODE(FILE_DEVICE_WAVE_OUT,20, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_WAVE_OUT_WRITE             CTL_CODE(FILE_DEVICE_WAVE_OUT,21, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_WAVE_OUT_SET_PROPS         CTL_CODE(FILE_DEVICE_WAVE_OUT,22, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_WAVE_OUT_GET_PROPS         CTL_CODE(FILE_DEVICE_WAVE_OUT,23, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_SND_PLAY_SOUND             CTL_CODE(FILE_DEVICE_SOUND,    1, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_PLAY_SOUND                 CTL_CODE(FILE_DEVICE_SOUND,    2, METHOD_BUFFERED, FILE_ANY_ACCESS)

// For sending messages to the "WAV" device audio driver (wavedev.dll)
// defined publically for backcompat
// #define IOCTL_WAV_MESSAGE                CTL_CODE(FILE_DEVICE_SOUND,    3, METHOD_BUFFERED, FILE_ANY_ACCESS)

// Specify message queue for callbacks
#define IOCTL_WAV_SETMSGQUEUE               CTL_CODE(FILE_DEVICE_SOUND,    4, METHOD_BUFFERED, FILE_ANY_ACCESS)

//
// IOCTL values for Win32 ACM Functions sent to waveapi.dll
//
#define IOCTL_ACM_DRIVER_ADD                CTL_CODE(FILE_DEVICE_SOUND,  110, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_ACM_DRIVER_CLOSE              CTL_CODE(FILE_DEVICE_SOUND,  111, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_ACM_DRIVER_DETAILS            CTL_CODE(FILE_DEVICE_SOUND,  112, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_ACM_DRIVER_ENUM               CTL_CODE(FILE_DEVICE_SOUND,  113, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_ACM_DRIVER_ID                 CTL_CODE(FILE_DEVICE_SOUND,  114, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_ACM_DRIVER_MESSAGE            CTL_CODE(FILE_DEVICE_SOUND,  115, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_ACM_DRIVER_OPEN               CTL_CODE(FILE_DEVICE_SOUND,  116, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_ACM_DRIVER_PRIORITY           CTL_CODE(FILE_DEVICE_SOUND,  117, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_ACM_DRIVER_REMOVE             CTL_CODE(FILE_DEVICE_SOUND,  118, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_ACM_FILTER_CHOOSE             CTL_CODE(FILE_DEVICE_SOUND,  120, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_ACM_FILTER_DETAILS            CTL_CODE(FILE_DEVICE_SOUND,  121, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_ACM_FILTER_ENUM               CTL_CODE(FILE_DEVICE_SOUND,  122, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_ACM_FILTER_TAG_DETAILS        CTL_CODE(FILE_DEVICE_SOUND,  123, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_ACM_FILTER_TAG_ENUM           CTL_CODE(FILE_DEVICE_SOUND,  124, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_ACM_FORMAT_CHOOSE             CTL_CODE(FILE_DEVICE_SOUND,  130, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_ACM_FORMAT_DETAILS            CTL_CODE(FILE_DEVICE_SOUND,  131, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_ACM_FORMAT_ENUM               CTL_CODE(FILE_DEVICE_SOUND,  132, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_ACM_FORMAT_SUGGEST            CTL_CODE(FILE_DEVICE_SOUND,  133, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_ACM_FORMAT_TAG_DETAILS        CTL_CODE(FILE_DEVICE_SOUND,  134, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_ACM_FORMAT_TAG_ENUM           CTL_CODE(FILE_DEVICE_SOUND,  135, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_ACM_STREAM_CLOSE              CTL_CODE(FILE_DEVICE_SOUND,  140, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_ACM_STREAM_CONVERT            CTL_CODE(FILE_DEVICE_SOUND,  141, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_ACM_STREAM_MESSAGE            CTL_CODE(FILE_DEVICE_SOUND,  142, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_ACM_STREAM_OPEN               CTL_CODE(FILE_DEVICE_SOUND,  143, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_ACM_STREAM_PREPARE_HEADER     CTL_CODE(FILE_DEVICE_SOUND,  144, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_ACM_STREAM_RESET              CTL_CODE(FILE_DEVICE_SOUND,  145, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_ACM_STREAM_SIZE               CTL_CODE(FILE_DEVICE_SOUND,  146, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_ACM_STREAM_UNPREPARE_HEADER   CTL_CODE(FILE_DEVICE_SOUND,  147, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_ACM_GET_VERSION               CTL_CODE(FILE_DEVICE_SOUND,  150, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_ACM_METRICS                   CTL_CODE(FILE_DEVICE_SOUND,  151, METHOD_BUFFERED, FILE_ANY_ACCESS)
//
// IOCTL values for Win32 Mixer API Functions sent to waveapi.dll
//
#define IOCTL_MIXER_GETCONTROLDETAILS       CTL_CODE(FILE_DEVICE_SOUND,  200, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_MIXER_GETDEVCAPS              CTL_CODE(FILE_DEVICE_SOUND,  201, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_MIXER_GETID                   CTL_CODE(FILE_DEVICE_SOUND,  202, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_MIXER_GETLINECONTROLS         CTL_CODE(FILE_DEVICE_SOUND,  203, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_MIXER_GETLINEINFO             CTL_CODE(FILE_DEVICE_SOUND,  204, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_MIXER_GET_NUM_DEVS            CTL_CODE(FILE_DEVICE_SOUND,  205, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_MIXER_MESSAGE                 CTL_CODE(FILE_DEVICE_SOUND,  206, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_MIXER_OPEN                    CTL_CODE(FILE_DEVICE_SOUND,  207, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_MIXER_SETCONTROLDETAILS       CTL_CODE(FILE_DEVICE_SOUND,  208, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_MIXER_CLOSE                   CTL_CODE(FILE_DEVICE_SOUND,  209, METHOD_BUFFERED, FILE_ANY_ACCESS)


// client stub sets up a MsgQueuue that receives WAVECALLBACKMSG structures
typedef struct
{
    UINT  uMsg;         // Message
    DWORD dwInstance;   // pProxy
    DWORD dwParam1;
    DWORD dwParam2;
    DWORD dwParam3;     // Currently only used for dwBytesRecorded
} WAVECALLBACKMSG, *PWAVECALLBACKMSG;

#define DRVM_MAPPER             0x2000
#define DRVM_MAPPER_PREFERRED_GET (DRVM_MAPPER+21)
#define DRVM_MAPPER_PREFERRED_SET (DRVM_MAPPER+22)


#define WAVECALLBACK_MSG_SYNC (-1)     // Magic msg to wait just set sync event
#define WAVECALLBACK_MSG_UPDATESETTINGS (-2)
