/***
*switches.hxx - Compile switches for Silver
*
*  Copyright (C) 1990, Microsoft Corporation.  All Rights Reserved.
*  Information Contained Herein Is Proprietary and Confidential.
*
*Purpose:
*  This file contains all the conditional compilation switches used
*  by Silver.  For making version-specific changes, see version.hxx.
*
*Revision History:
*
* 24-Aug-90 petergo: Created
*       10-May-91 ilanc:   add ID_TEST
*       14-Jun-91 petergo: Added Kanji/Unicode switches
*       06-Mar-92 tomc:    Added several switches, generate switches.inc
* 10-Dec-92 ilanc:   Added EI_OB and EI_OLE2.
* 25-Jan-93 jeffrob: Corrected WIN32 HP_I386 and added OE_WIN32MT
* 12-Mar-93 kazusy:  Added BLD_FEVER switch
*       05-May-93 jeffrob: Added ID_PROFILE
*       04-Oct-93 w-marioc Added support for MIPS
* 02-Jan-94 gburns:  Added EI_VBARUN.
*
*****************************************************************************/

#ifndef SWITCHES_HXX_INCLUDED
#define SWITCHES_HXX_INCLUDED

#include "ebvers.h"
#include "version.hxx"

// Unless explicitly defined otherwise in version.hxx, we assume
// that we are not using CFRONT:
#ifndef ID_CFRONT
  #define ID_CFRONT       0
#endif 

// Need to define some constants to 0 that weren't defined or
// mrc will choke on them:
#ifndef BLD_WIN16
#define  BLD_WIN16      0
#endif 

#ifndef BLD_WIN32
#define  BLD_WIN32      0
#endif 

#ifndef BLD_WLM
#define  BLD_WLM      0
#endif 

#ifndef BLD_MAC
#define  BLD_MAC      0
#endif 

#ifndef BLD_FEVER
#define  BLD_FEVER      0
#endif 

#ifndef HE_WIN32
#define  HE_WIN32     0 // [jwc] undone:  Right now, mac os/2 toolset & NT toolset have
#endif 
          // coexistance of both builds

// Unlike ID_PROFILE, BLD_PROFILE indicates that the build was built with
// profiling stubs (-Gh cl68 & c8/32) to collecting timing information.
// Currently, this must be set by hand either in a special version.hxx or on the
// compile line.
#ifndef BLD_PROFILE
#define  BLD_PROFILE      0
#endif 


// ID_TEST - This is used to surround test code that will not be
// part of the released build.  This is assumed to be equal ID_DEBUG.
// However, in the test build (twinc7), ID_TEST is turned on, but ID_DEBUG
// is off.
//
#ifndef ID_TEST
  #define ID_TEST       ID_DEBUG
#endif 


// ID_PROFILE - This is used to surround test code that collects profiling
// data.  Currently, it is defined to equal ID_DEBUG but could be turned
// on in the release build, if desired.
//
#ifndef ID_PROFILE
  #define ID_PROFILE        ID_DEBUG
#endif 


// ID_SWAPTUNE - This is used to surround code that collects segment swapping info.
// Currently, it is always set off, and must be set on by hand.  This need
// not be tied to either debug or release builds, so assume that code under
// this switch could be turned on for either.
#ifndef ID_SWAPTUNE
  #define ID_SWAPTUNE     0
#endif 


// HC switches: relate to the Host Compiler or Compiler version
// Use this to accomodate syntactic differences between compilers
//
#if defined (_MSC_VER)
#if (_MSC_VER >= 800)
#define HC_MSC8

// Both these are versions of C8 or C9
#ifdef _M_M68K
#define HC_MSC68K
#elif defined (_M_MPPC)
#define HC_MSCPPC
#else 
// REVIEW:  Probably need to check for C8/32 vs. C8/16
#define HC_MSC832
#endif 

#else 
#if (_MSC_VER == 700)
#define HC_MSC7
#else 
#define HC_MSC6
#endif 
#endif 

#else 
//  UNDONE:  rc uses a c-preprocessor that doesn't define _MSC_VER...
//  need to figure out what to do here.
//#error Unsupported Compiler! 
#endif 



//OE switches: relate to the Operating Environment, or
//API set used by the program

// If TRUE, OE_WIN indicates we are using one of the variant of the
// Windows API sets.  This is set for all of our released versions,
// except the native Mac build.
// It not set only for the OS/2 internal build, or for the DOS tools build.
// It is set for the Mac WLM build (provided for WLM clients).
//

#if BLD_WIN16 || BLD_WIN32 || BLD_WLM
#define OE_WIN      1
#else 
#define OE_WIN      0
#define OE_WIN16    0
#define OE_WIN32    0
#define OE_WLM      0
#define OE_WIN32S   0
#define OE_WIN32F   0
#define OE_NT     0
#endif 


//If OE_WIN is set, exactly one of the following 3 switches is set,
//indicate which variant of the Windows API is being used.

#if OE_WIN

#if BLD_WLM
    #define OE_WLM  1
        //Indicates we are running the Windows Library for the Mac.
        //This should only be used for those few cases that depend on
  //differences in function signatures between WLM.H and WINDOWS.H.
#else 
    #define OE_WLM   0
#endif 

#if BLD_WIN16
    #define OE_WIN16  1
  //Indicates we are using the Windows 3.0/3.1 API set.  Should
        //be used when using features specific to Windows 3.0/3.1.  You
        //can assume protected mode only with this switch; we never have
  //and never will support Real mode Windows.
#else 
    #define OE_WIN16  0
#endif 

#if BLD_WIN32
    #define OE_WIN32  1
        //Indicates we are using the Win32 API set, on either NT or
  //DOS.  On for both Win32/NT, Win32/DOS, and Win32S.
#else 
    #define OE_WIN32  0
#endif 

#endif 

// If OE_WIN32 is set, the following switches indicate which subvariant
// of the Win32 API is being used.  These should be rarely needed,
// if at all.  NOTE: currently there are no builds which turns these
// on.

#if OE_WIN32
  #define OE_WIN32S    0
        //Indicates we are using the Win32S API subset.

  #define OE_WIN32F    0
        //Indicates we are using the full Win32 API, under either
        //DOS or NT.  Should be used to control use of APIs
        //not in the Win32S subset.

  #define OE_NT        0
        //Indicates we are running under NT, as opposed to Win32/DOS.
        //Should be used only to control NT specific features, like
  //calling an NT API directly.

  #define OE_WIN32MT   0
        //Indicates we support multiple WIN32 threads within a single
        //process.  (Version 1.0 of OB only supports one thread so
        //we've optimized some code paths with this in mind.)

#endif 

// OE_RISC is used to specify if the portable engine code is to be used
// instead of the intel specific assembly
#ifndef OE_RISC
  #define OE_RISC  0
#endif 

//OS/2 is no longer a target in any of the builds.
#define OE_OS2      0


// OE_MAC indicates that we are targetting the Macintosh.  This
// is set for both the WLM build and the native Mac build.
#if BLD_WLM || BLD_MAC
#define OE_MAC      1
#else 
#define OE_MAC      0
#endif 

  #define OE_MACAPI   0
  #define OE_MSYS7ONLY    0
  #define OE_MSYS6COMPAT  0
  #define OE_MAC68K   0
  #define OE_MACPPC   0
  #define ID_SWAPPABLE    0


// OE_DLL: True for versions in which Object Basic code is linked into a DLL.
//         When TRUE, host routines are in a separate DLL or EXE.  For now,
//         this is only TRUE for Windows versions, but future Macintosh
//         versions will likely have this set TRUE.
//
#if (BLD_WIN16 || BLD_WIN32 || defined (OE_DLL)) && !defined (VBARUNBLD)
  #define OE_DLL      1
#else 
  #define OE_DLL      0
#endif 


// DOS build. (Probably should be called OE_DOS, but isn't.)
// There is no dos build.  This is always off.
#define OE_REALMODE     0

//HP switches:  relate to the Hardware Processor.
// The hardware switches indicate what kind of processor we are running
// on.  These switches should be used when you need to do specific thing
// depending on the hardware you are running on.
//
// Switches that indicate general characteristic of the processor
//(16bit/32bit, etc).
// HP switches are for Hardware Processor.  If possible, do not use
// the specific processor type switches, but instead use the following
// switches pertaining to various characteristic of the processors.
// This makes porting to a new processor easier.
//
//  HP_16BIT        = Using a 16-bit register processor
//  HP_32BIT        = Using a 32-bit register processor
//  HP_BIGENDIAN      = Using a big-endian machine
//                      least significant byte of a word is
//                      at the highest byte address.
//  HP_MUSTALIGN      = Must load/store objects from natural alignments.
//                      indicates that 2byte words must be read/written
//                      from a two byte boundary, 4byte words must be
//                      read/written from a 4 byte boundary, 8 byte word
//                      must be read/written from an 8 byte boundary.

#if BLD_WIN16
  #define HP_16BIT         1
#else 
  #define HP_16BIT         0
#endif 

#if BLD_WIN32 || BLD_MAC || BLD_WLM
  #define HP_32BIT         1
#else 
  #define HP_32BIT         0
#endif 

#if BLD_MAC || BLD_WLM
  #define HP_BIGENDIAN            1
#else 
  #define HP_BIGENDIAN            0
#endif 

#if BLD_MAC || BLD_WLM
  #define HP_MUSTALIGN         0
#endif 

// Switches that indicate the exact chip family:
// (It is preferable to use the above switches since they are more
//  general than the following switches.)
//
//  HP_I286          = Intel 286 AND ABOVE, running in 16 bit mode
//                               --- -----
//  HP_I386          = Intel 386 and above, running in 32 bit mode
//  HP_M68000        = Motorola 680x0
//  HP_R4000 MIPS    = R4000
//  HP_ALPHA         = DEC/AXP
//  HP_SPARC       = SPARC
//

#if BLD_WIN16
#define HP_I286        1
#else 
#define HP_I286        0
#endif 

#if BLD_WIN32

#ifdef _M_MRX000
#define HP_ALPHA             0
#define HP_R4000             1
#define HP_I386              0
#else 
#ifdef _M_ALPHA
#define HP_ALPHA             1
#define HP_R4000             0
#define HP_I386        0
#else 
#define HP_ALPHA             0
#define HP_R4000             0
#define HP_I386        1
#endif 
#endif 

#else 
#define HP_ALPHA             0
#define HP_R4000             0
#define HP_I386        0
#endif 

#if BLD_MAC || BLD_WLM
#ifdef _M_MPPC
#define HP_POWERPC       1
#define HP_M68000      0
#else 
#define HP_POWERPC       0
#define HP_M68000      1
#endif 

#else 
#define HP_POWERPC       0
#define HP_M68000      0
#endif 

#define HP_SPARC       0

// The following switches distinguish between an OB specific build, 
// a build of a run-time only version of OB, and an OLE2 "generic" build.
//
#undef EI_OB
#undef EI_OLE
#undef EI_VBARUN

#define EI_VBA  1 // This differentiates between VBA and hosts which
                  // may use VBA header files.

// Runtime switches:
//   EI_VBARUN:      Used for code that will be in any version of the
//                   runtime (not specific to any product).
//   EI_VBARUN_VB:   Used for code that is specific to the VB version of the
//                   runtime.  Implies !OE_DLL since VBRUN has an exe 
//                   associated with it.
//   EI_VBARUN_JET:  Used for code that is specific to the JET version of the
//                   runtime, i.e., the VBARUN.DLL produced to support 
//                   Expression Services.  Implies OE_DLL since VBARUN.DLL is
//                   standalone.

#ifdef OLEBLD
  #define EI_OB         0
  #define EI_OLE        1
  #define EI_VBARUN     0
  #define EI_VBARUN_VB  0
  #define EI_VBARUN_JET 0
#else 
  #define EI_OLE 0
  #define EI_OB  1
#if defined (VBARUNBLD)
    // Build VB version of runtime.
    #define EI_VBARUN     1
    #define EI_VBARUN_VB  1
    #define EI_VBARUN_JET 0
#elif defined (VBARUNJETBLD)
    // Build JET version of runtime.
    #define EI_VBARUN     1
    #define EI_VBARUN_VB  0
    #define EI_VBARUN_JET 1
#else 
    // Build IDE.
    #define EI_VBARUN     0
    #define EI_VBARUN_VB  0
    #define EI_VBARUN_JET 0
#endif 
#endif 


// Base processor alignment values.
// HP_ALIGNMENT is used is the sheapmgr to align data.  Currently non-risc
// set to 1.
// HP_ALIGNMENT_MAX is used by OB in conjunction with the g_rgcbAlignment table
// (in clutil.cxx) as a 'capping' value - used by typelib when laying out
// a typeinfo.
//
#if OE_RISC
#if HP_R4000 || HP_POWERPC || HP_ALPHA
#define HP_ALIGNMENT       8
#define HP_ALIGNMENT_MAX     8
#elif HP_I386
#define HP_ALIGNMENT       4
#define HP_ALIGNMENT_MAX     4
#else 
#error !Unsupported Platform -- [Add Processor Alignment Value here.]
#endif 

#else 
#define HP_ALIGNMENT       1

#if HP_I286
#define HP_ALIGNMENT_MAX     1
#elif HP_M68000
#define HP_ALIGNMENT_MAX     2
#elif HP_I386
#define HP_ALIGNMENT_MAX     4
#else 
#error !Unsupported Platform
#endif 

#endif 


// Switches for code system.

#if COMMONCS
#define FV_DBCS     1   // Double-byte char set (Kanji/Korean)
#define FV_UNICODE  0   // No unicode char set
#else 
#define FV_DBCS     1   // Double-byte char set (Kanji/Korean)
#define FV_UNICODE  0   // No unicode char set
#endif 

//The following switch defines whether we are using the FE specific
//feature or not.

#if !BLD_FEVER
#define EI_FE     0   // Doesn't include FE specific features
#else 
#define EI_FE     1   // Includes FE specific features
#endif 


//The following switch defines whether we are using the Macro Manager
//subset of OB or the whole OB language.
#define LANGUAGE_IS_SILVER  1

// Turn off automatic text format saves inside project files.
#define  ID_SAVETEXT      0

// Turn off automatic text format loads of old-format project files.
#define  ID_LOADTEXT      0

#define FV_MAKEEXE 1

#define FV_THREADED 0

#define FV_ANSI_TO_UNICODE 0

#endif 
