
//=============================================================================
//  Microsoft (R) Bloodhound (tm). Copyright (C) 1991-1992.
//
//  MODULE: bherr.h
//
//  This is the top-level include file for all BLOODHOUND error codes
//=============================================================================

#if !defined(_BHERR_)

#define _BHERR_

//=============================================================================
//  The operation succeeded.
//=============================================================================

#define BHERR_SUCCESS                        0

//=============================================================================
//  An error occured creating a memory-mapped file.
//=============================================================================

#define BHERR_MEMORY_MAPPED_FILE_ERROR       1

//=============================================================================
//  The handle to a filter is invalid.
//=============================================================================

#define BHERR_INVALID_HFILTER                2

//=============================================================================
//  Capturing has already been started.
//=============================================================================

#define BHERR_CAPTURING                      3

//=============================================================================
//  Capturing has not been started.
//=============================================================================

#define BHERR_NOT_CAPTURING                  4

//=============================================================================
//  The are no frames available.
//=============================================================================

#define BHERR_NO_MORE_FRAMES                 5

//=============================================================================
//  The buffer is too small to complete the operation.
//=============================================================================

#define BHERR_BUFFER_TOO_SMALL               6

//=============================================================================
//  No protocol was able to recognize the frame.
//=============================================================================

#define BHERR_FRAME_NOT_RECOGNIZED           7

//=============================================================================
//  The file already exists.
//=============================================================================

#define BHERR_FILE_ALREADY_EXISTS            8

//=============================================================================
//  A needed device driver was not found or is not loaded.
//=============================================================================

#define BHERR_DRIVER_NOT_FOUND               9

//=============================================================================
//  This address aready exists in the database.
//=============================================================================

#define BHERR_ADDRESS_ALREADY_EXISTS         10

//=============================================================================
//  The frame handle is invalid.
//=============================================================================

#define BHERR_INVALID_HFRAME                 11

//=============================================================================
//  The protocol handle is invalid.
//=============================================================================

#define BHERR_INVALID_HPROTOCOL              12

//=============================================================================
//  The property handle is invalid.
//=============================================================================

#define BHERR_INVALID_HPROPERTY              13

//=============================================================================
//  The the object has been locked.  
//=============================================================================

#define BHERR_LOCKED                         14

//=============================================================================
//  A pop operation was attempted on an empty stack.
//=============================================================================

#define BHERR_STACK_EMPTY                    15

//=============================================================================
//  A push operation was attempted on an full stack.
//=============================================================================

#define BHERR_STACK_OVERFLOW                 16

//=============================================================================
//  There are too many protocols active.
//=============================================================================

#define BHERR_TOO_MANY_PROTOCOLS             17

//=============================================================================
//  The file was not found.
//=============================================================================

#define BHERR_FILE_NOT_FOUND                 18

//=============================================================================
//  No memory was available.  Shut down windows to free up resources.
//=============================================================================

#define BHERR_OUT_OF_MEMORY                  19

//=============================================================================
//  The capture is already in the paused state.
//=============================================================================

#define BHERR_CAPTURE_PAUSED                 20

//=============================================================================
//  There are no buffers available or present.
//=============================================================================

#define BHERR_NO_BUFFERS                     21

//=============================================================================
//  There are already buffers present.
//=============================================================================

#define BHERR_BUFFERS_ALREADY_EXIST          22

//=============================================================================
//  The object is not locked.
//=============================================================================

#define BHERR_NOT_LOCKED                     23

//=============================================================================
//  A integer type was out of range.
//=============================================================================

#define BHERR_OUT_OF_RANGE                   24

//=============================================================================
//  An object was locked too many times.
//=============================================================================

#define BHERR_LOCK_NESTING_TOO_DEEP          25

//=============================================================================
//  A parser failed to load.
//=============================================================================

#define BHERR_LOAD_PARSER_FAILED             26

//=============================================================================
//  A parser failed to unload.
//=============================================================================

#define BHERR_UNLOAD_PARSER_FAILED          27

//=============================================================================
//  The address database handle is invalid.
//=============================================================================

#define BHERR_INVALID_HADDRESSDB             28

//=============================================================================
//  The MAC address was not found in the database.
//=============================================================================

#define BHERR_ADDRESS_NOT_FOUND              29

//=============================================================================
//  The network software was not found in the system.
//=============================================================================

#define BHERR_NETWORK_NOT_PRESENT            30

//=============================================================================
//  There is no property database for a protocol.
//=============================================================================

#define BHERR_NO_PROPERTY_DATABASE           31

//=============================================================================
//  A property was not found in the database.
//=============================================================================

#define BHERR_PROPERTY_NOT_FOUND             32

//=============================================================================
//  The property database handle is in valid.
//=============================================================================

#define BHERR_INVALID_HPROPERTYDB            33

//=============================================================================
//  The protocol has not been enabled.
//=============================================================================

#define BHERR_PROTOCOL_NOT_ENABLED          34

//=============================================================================
//  The protocol DLL could not be found.
//=============================================================================

#define BHERR_PROTOCOL_NOT_FOUND            35

//=============================================================================
//  The parser DLL is not valid.
//=============================================================================

#define BHERR_INVALID_PARSER_DLL            36

//=============================================================================
//  There are no properties attached.
//=============================================================================

#define BHERR_NO_ATTACHED_PROPERTIES         37

//=============================================================================
//  There are no frames in the buffer.
//=============================================================================

#define BHERR_NO_FRAMES                      38

//=============================================================================
//  The capture file format is not valid.
//=============================================================================

#define BHERR_INVALID_FILE_FORMAT            39

//=============================================================================
//  The OS could not create a temporary file.
//=============================================================================

#define BHERR_COULD_NOT_CREATE_TEMPFILE      40

//=============================================================================
//  There is not enough MS-DOS memory available.
//=============================================================================

#define BHERR_OUT_OF_DOS_MEMORY              41

//=============================================================================
//  There are no protocols enabled.
//=============================================================================

#define BHERR_NO_PROTOCOLS_ENABLED           42

//=============================================================================
//  The MAC type is invalid or unsupported.
//=============================================================================

#define BHERR_UNKNOWN_MACTYPE                46

//=============================================================================
//  There is no routing information present in the MAC frame.
//=============================================================================

#define BHERR_ROUTING_INFO_NOT_PRESENT       47

//=============================================================================
//  The network handle is invalid.
//=============================================================================

#define BHERR_INVALID_HNETWORK               48

//=============================================================================
//  The network is already open.
//=============================================================================

#define BHERR_NETWORK_ALREADY_OPENED         49

//=============================================================================
//  The network is not open.
//=============================================================================

#define BHERR_NETWORK_NOT_OPENED             50

//=============================================================================
//  The frame was not found in the buffer.
//=============================================================================

#define BHERR_FRAME_NOT_FOUND                51

//=============================================================================
//  There are no handles available.
//=============================================================================

#define BHERR_NO_HANDLES                     53

//=============================================================================
//  The network ID is invalid.
//=============================================================================

#define BHERR_INVALID_NETWORK_ID             54

//=============================================================================
//  The capture handle is invalid.
//=============================================================================

#define BHERR_INVALID_HCAPTURE               55

//=============================================================================
//  The protocol has already been enabled.
//=============================================================================

#define BHERR_PROTOCOL_ALREADY_ENABLED       56

//=============================================================================
//  The filter expression is invalid.
//=============================================================================

#define BHERR_FILTER_INVALID_EXPRESSION      57

//=============================================================================
//  A transmit error occured.
//=============================================================================

#define BHERR_TRANSMIT_ERROR                 58

//=============================================================================
//  The buffer handle is invalid.
//=============================================================================

#define BHERR_INVALID_HBUFFER                59

//=============================================================================
//  The specified data is unknown or invalid.
//=============================================================================

#define BHERR_INVALID_DATA                   60

//=============================================================================
//  The MS-DOS/NDIS 2.0 network driver is not loaded.
//=============================================================================

#define BHERR_MSDOS_DRIVER_NOT_LOADED        61

//=============================================================================
//  The Windows VxD/NDIS 3.0 network driver is not loaded.
//=============================================================================

#define BHERR_WINDOWS_DRIVER_NOT_LOADED      62

//=============================================================================
//  The MS-DOS/NDIS 2.0 driver had an init-time failure.
//=============================================================================

#define BHERR_MSDOS_DRIVER_INIT_FAILURE      63

//=============================================================================
//  The Windows/NDIS 3.0 driver had an init-time failure.
//=============================================================================

#define BHERR_WINDOWS_DRIVER_INIT_FAILURE    64

//=============================================================================
//  The network driver is busy and cannot handle requests.
//=============================================================================

#define BHERR_NETWORK_BUSY                   65

//=============================================================================
//  The capture is not paused.
//=============================================================================

#define BHERR_CAPTURE_NOT_PAUSED             66

//=============================================================================
//  The frame/packet length is not valid.
//=============================================================================

#define BHERR_INVALID_PACKET_LENGTH          67

//=============================================================================
//  An internal exception occured.
//=============================================================================

#define BHERR_INTERNAL_EXCEPTION             69

//=============================================================================
//  The MAC driver does not support promiscious mode.
//=============================================================================

#define BHERR_PROMISCUOUS_MODE_NOT_SUPPORTED 70

//=============================================================================
//  The MAC driver failed to open.
//=============================================================================

#define BHERR_MAC_DRIVER_OPEN_FAILURE        71

//=============================================================================
//  The protocol went off the end of the frame.
//=============================================================================

#define BHERR_RUNAWAY_PROTOCOL               72

//=============================================================================
//  An asynchronous operation is still pending.
//=============================================================================

#define BHERR_PENDING                        73

//=============================================================================
//  Access is denied.
//=============================================================================

#define BHERR_ACCESS_DENIED                  74

//=============================================================================
//  The password handle is invalid.
//=============================================================================

#define BHERR_INVALID_HPASSWORD              75

//=============================================================================
//  A bad parameter was detected.
//=============================================================================

#define BHERR_INVALID_PARAMETER              76

//=============================================================================
//  An error occured reading the file.
//=============================================================================

#define BHERR_FILE_READ_ERROR                77

//=============================================================================
//  An error occured writing to the file.
//=============================================================================

#define BHERR_FILE_WRITE_ERROR               78

//=============================================================================
//  The protocol has not been registered
//=============================================================================

#define BHERR_PROTOCOL_NOT_REGISTERED        79

//=============================================================================
//  The frame does not contain an IP address.
//=============================================================================

#define BHERR_IP_ADDRESS_NOT_FOUND           80

//=============================================================================
//  The transmit request was cancelled.
//=============================================================================

#define BHERR_TRANSMIT_CANCELLED             81

//=============================================================================
//  The operation cannot be performed on a capture with 1 or more locked frames.
//=============================================================================

#define BHERR_LOCKED_FRAMES                  82

//=============================================================================
//  A cancel transmit request was submitted but there were no transmits pending.
//=============================================================================

#define BHERR_NO_TRANSMITS_PENDING           83

//=============================================================================
//  Path not found.
//=============================================================================

#define BHERR_PATH_NOT_FOUND                 84

//=============================================================================
//  A windows error has occured.
//=============================================================================

#define BHERR_WINDOWS_ERROR                  85

//=============================================================================
//  The handle to the frame has no frame number.
//=============================================================================

#define BHERR_NO_FRAME_NUMBER                86

//=============================================================================
//  The frame is not associated with any capture.
//=============================================================================

#define BHERR_FRAME_HAS_NO_CAPTURE           87

//=============================================================================
//  The frame is already associated with a capture.
//=============================================================================

#define BHERR_FRAME_ALREADY_HAS_CAPTURE      88

//=============================================================================
//  The NAL is not remotable.
//=============================================================================

#define BHERR_NAL_IS_NOT_REMOTE              89

//=============================================================================
//  The API is not supported
//=============================================================================

#define BHERR_NOT_SUPPORTED                  90

//=============================================================================
//  Bloodhound should discard the current frame. This error code is only used
//  duing a filterd SaveCapture() API call.
//=============================================================================

#define BHERR_DISCARD_FRAME                  91

//=============================================================================
//  Bloodhound should cancel the current save. This error code is only used
//  duing a filterd SaveCapture() API call.
//=============================================================================

#define BHERR_CANCEL_SAVE_CAPTURE            92

//=============================================================================
//  The connection to the remote machine has been lost
//=============================================================================

#define BHERR_LOST_CONNECTION                93

//=============================================================================
//  The media/mac type is not valid.
//=============================================================================

#define BHERR_INVALID_MEDIA_TYPE             94

//=============================================================================
//  The Remote Agent is currently in use
//=============================================================================

#define BHERR_AGENT_IN_USE                   95

//=============================================================================
//  The request has timed out
//=============================================================================

#define BHERR_TIMEOUT                        96

//=============================================================================
//  The remote agent has been disconnected
//=============================================================================

#define BHERR_DISCONNECTED                   97

//=============================================================================
//  A timer required for operation failed creation
//=============================================================================

#define BHERR_SETTIMER_FAILED                98

//=============================================================================
//  A network error occured.
//=============================================================================

#define BHERR_NETWORK_ERROR                  99

#endif
