/*++

Copyright (c) 1992  Microsoft Corporation

Module Name:

    ExpDel.c

Abstract:

    NetrReplExportDirDel is the local worker for the NetReplExportDirDel API.

Author:

    John Rogers (JohnRo) 07-Jan-1992

Environment:

    Runs under Windows NT.
    Requires ANSI C extensions: slash-slash comments, long external names.

Revision History:

    07-Jan-1992 JohnRo
        Created.
    20-Jan-1992 JohnRo
        Netr prototypes are now generated by MIDL and put in repl.h.
    24-Jan-1992 JohnRo
        Changed to use LPTSTR etc.
    15-Mar-1992 JohnRo
        Update registry with new values.
    22-Jul-1992 JohnRo
        RAID 2274: repl svc should impersonate caller.
    13-Nov-1992 JohnRo
        RAID 1537: Repl APIs in wrong role kill svc.

--*/


// These must be included first:

#include <windef.h>             // IN, VOID, LPTSTR, etc.
#include <lmcons.h>             // NET_API_STATUS, PARM equates, etc.
#include <repldefs.h>           // ReplIsIntegrityValid(), etc.
#include <master.h>             // PMASTER_LIST_REC.
#include <rpc.h>                // Needed by <repl.h>.

// These can be in any order:

#include <dirname.h>            // ReplIsDirNameValid().
#include <expdir.h>             // ExportDirDeleteConfigData().
#include <lmrepl.h>             // LPREPL_EDIR_INFO_1, REPL_EXTENT_ stuff, etc.
#include <masproto.h>           // RemoveMasterRecForDirName().
#include <netlock.h>            // ACQUIRE_LOCK(), etc.
#include <repl.h>               // My prototype (in MIDL-generated .h file).
#include <replgbl.h>    // ReplConfigLock, ReplConfigRole.
#include <rpcutil.h>    // NetpImpersonateClient(), NetpRevertToSelf().
#include <winerror.h>           // ERROR_ equates, NO_ERROR.


NET_API_STATUS
NetrReplExportDirDel (
    IN LPTSTR UncServerName OPTIONAL,
    IN LPTSTR DirName
    )

/*++

Routine Description:

    Same as NetReplExportDirDel.

Arguments:

    Same as NetReplExportDirDel.

Return Value:

    Same as NetReplExportDirDel.

--*/

{
    NET_API_STATUS ApiStatus;
    BOOL ConfigLocked = FALSE;
    BOOL Impersonated = FALSE;
    BOOL ListLocked = FALSE;

    if (ReplIsDirNameValid( DirName ) == FALSE) {
        return (ERROR_INVALID_PARAMETER);
    }

    //
    // Impersonate caller, so security check (write to registry) reflects
    // the client's process, not the repl service process.
    //
    ApiStatus = NetpImpersonateClient();
    if (ApiStatus != NO_ERROR) {
        goto Cleanup;
    }
    Impersonated = TRUE;

    //
    // We'll need shared lock on config data, so we can find out if export half
    // is actually running.
    //
    ACQUIRE_LOCK_SHARED( ReplConfigLock );
    ConfigLocked = TRUE;

    //
    // Call somebody to delete from registry.
    // This has the side-effect of doing a security check.
    //
    ApiStatus = ExportDirDeleteConfigData( UncServerName, DirName );
    if (ApiStatus != NO_ERROR) {
        goto Cleanup;   // Don't forget to release lock...
    }

    if ( ReplRoleIncludesExport( ReplConfigRole ) ) {
	//
	// Get lock on global list (RemoveMasterRecForDirName needs this).
	// This same lock protects export data in the registry.
	//

	ACQUIRE_LOCK( RMGlobalListLock );
	ListLocked = TRUE;

        //
        // Remove from in-memory data being used by service.
        //
        ApiStatus = RemoveMasterRecForDirName( DirName );
        // BUGBUG: registry and service out-of-sync if ApiStatus != NO_ERROR.
    }

    // BUGBUG: Is just removing the record from list enough or do we need
    // to notify anybody?

Cleanup:

    if (Impersonated) {
        (VOID) NetpRevertToSelf();
    }

    if (ListLocked) {
        RELEASE_LOCK( RMGlobalListLock );
    }

    if (ConfigLocked) {
        RELEASE_LOCK( ReplConfigLock );
    }

    return (ApiStatus);

}
