/*++

Copyright (c) 1992-1993  Microsoft Corporation

Module Name:

    ImpGet.c

Abstract:

    This file contains NetrReplImportDirGetInfo.

Author:

    John Rogers (JohnRo) 12-Jan-1992

Environment:

    Runs under Windows NT.
    Requires ANSI C extensions: slash-slash comments, long external names.

Revision History:

    12-Jan-1992 JohnRo
        Created.
    20-Jan-1992 JohnRo
        Netr prototypes are now generated by MIDL and put in repl.h.
    20-Jan-1992 JohnRo
        Corrected name of this routine.
        Changed prototype to match MIDL requirements.
    27-Jan-1992 JohnRo
        Changed to use LPTSTR etc.
    28-Jul-1992 JohnRo
        Fixed an error path where bad record pointer was being used.
        Corrected type of ApiRecord.
        Added error checking.
    12-Nov-1992 JohnRo
        RAID 1537: repl APIs in wrong role kill service.
    02-Apr-1993 JohnRo
        Use NetpKdPrint() where possible.

--*/


// These must be included first:

#include <windef.h>             // IN, VOID, LPTSTR, etc.
#include <lmcons.h>             // NET_API_STATUS, PARM equates, etc.
#include <rap.h>                // Needed by <strucinf.h>.
#include <repldefs.h>           // ReplIsIntegrityValid(), etc.
#include <rpc.h>                // Needed by <repl.h>.

// These can be in any order:

#include <client.h>             // RC globals, ReplGetClientRecord(), etc.
#include <dirname.h>            // ReplIsDirNameValid().
#include <impdir.h>     // ImportDirBuildApiRecord(), etc.
#include <lmapibuf.h>           // NetApiBufferAllocate().
#include <lmerr.h>              // ERROR_ and NERR_ equates; NO_ERROR.
#include <lmrepl.h>             // LPREPL_IDIR_INFO_1, REPL_EXTENT_ stuff, etc.
#include <netdebug.h>   // NetpAssert(), NetpKdPrint(), etc.
#include <netlib.h>             // NetpPointerPlusSomeBytes().
#include <netlock.h>            // ACQUIRE_LOCK_SHARED(), RELEASE_LOCK().
#include <prefix.h>     // PREFIX_ equates.
#include <repl.h>               // My prototype (in MIDL-generated .h file).
#include <replgbl.h>    // ReplConfigLock, ReplConfigRole.
#include <strucinf.h>           // Netp{various}StructureInfo().


NET_API_STATUS
NetrReplImportDirGetInfo (
    IN LPTSTR UncServerName OPTIONAL,
    IN LPTSTR DirName,
    IN DWORD Level,
    OUT LPIMPORT_CONTAINER BufPtr       // RPC container (union)
    )

/*++

Routine Description:

    Same as NetReplImportDirGetInfo.

Arguments:

    Same as NetReplImportDirGetInfo.

Return Value:

    Same as NetReplImportDirGetInfo.

--*/

{
    LPREPL_IDIR_INFO_1 ApiRecord = NULL;
    NET_API_STATUS ApiStatus;
    LPCLIENT_LIST_REC ClientRecord;
    BOOL LockedClientList = FALSE;
    BOOL LockedConfigData = FALSE;
    DWORD OutputSize;
    LPVOID StringLocation;

    UNREFERENCED_PARAMETER(UncServerName);

    IF_DEBUG( IMPAPI ) {
        NetpKdPrint(( PREFIX_REPL
                "NetrReplImportDirGetInfo: union at " FORMAT_LPVOID ".\n",
                (LPVOID) BufPtr ));
    }

    //
    // Check for caller errors.
    //
    if (BufPtr == NULL) {
        return (ERROR_INVALID_PARAMETER);
    }

    BufPtr->Info0 = NULL;  // Don't confuse caller about possible alloc'ed data.

    if (ReplIsDirNameValid( DirName ) == FALSE) {
        return (ERROR_INVALID_PARAMETER);
    }

    //
    // Check role and handle call if import half of service is not running.
    //
    ACQUIRE_LOCK_SHARED( ReplConfigLock );
    LockedConfigData = TRUE;

    if ( !ReplRoleIncludesImport( ReplConfigRole  ) ) {

        ApiStatus = ImportDirGetApiRecord(
                UncServerName,
                DirName,
                Level,
                (LPBYTE *) (LPVOID) &ApiRecord );
        goto Cleanup;
    }

    //
    //
    // Compute size of output area (and check caller's Level too).
    //
    ApiStatus = NetpReplImportDirStructureInfo (
            Level,
            PARMNUM_ALL,
            TRUE,  // want native sizes
            NULL,  // don't need DataDesc16
            NULL,  // don't need DataDesc32
            NULL,  // don't need DataDescSmb
            & OutputSize,  // need max size of structure
            NULL,  // don't need FixedSize
            NULL); // don't need StringSize
    if (ApiStatus != NO_ERROR) {
        // Don't forget to release lock...
        goto Cleanup;
    }
    NetpAssert( OutputSize > 0 );

    //
    // Get read-only lock on client list.
    //
    ACQUIRE_LOCK_SHARED( RCGlobalClientListLock );
    LockedClientList = TRUE;

    //
    // Find the client record for this dir name.
    //
    ClientRecord = (LPCLIENT_LIST_REC) ReplGetClientRec(
            DirName,
            NULL);   // BUGBUG: no master name?

    if (ClientRecord == NULL) {   // Not found.

        ApiStatus = NERR_UnknownDevDir;
        // Don't forget to release lock...

    } else {   // Found.

        //
        // Allocate the output area.
        //
        ApiStatus = NetApiBufferAllocate(
                OutputSize,
                (LPVOID *) & ApiRecord);
        if (ApiStatus != NO_ERROR) {

            // ApiStatus is already set to return error to caller.
            // Don't forget to release lock...
            NetpAssert( ApiRecord == NULL );

        } else {
            NetpAssert( ApiRecord != NULL );

            //
            // Build ApiRecord!
            //
            StringLocation = NetpPointerPlusSomeBytes( ApiRecord, OutputSize );
            ApiStatus = ImportDirBuildApiRecord (
                    Level,
                    ClientRecord->dir_name,
                    ClientRecord->state,
                    ClientRecord->master,
                    ClientRecord->timestamp, // Last update, secs since '70.
                    ClientRecord->lockcount,
                    ClientRecord->time_of_first_lock, // Seconds since 1970.
                    ApiRecord,
                    (LPBYTE *) (LPVOID) & StringLocation);
            NetpAssert( ApiStatus == NO_ERROR );  // We checked all parms.
            NetpAssert( ImportDirIsApiRecordValid (Level, ApiRecord, NULL ) );

            // Don't forget to release lock...

        }

    }

    //
    // Release lock and tell caller how everything went.
    //

Cleanup:

    if (LockedClientList) {
        RELEASE_LOCK( RCGlobalClientListLock );
    }

    if (LockedConfigData) {
        RELEASE_LOCK( ReplConfigLock );
    }

    BufPtr->Info0 = (LPVOID) ApiRecord;  // Pretend info level 0.
    return (ApiStatus);

}
