/**********************************************************************/
/**                       Microsoft Windows NT                       **/
/**                Copyright(c) Microsoft Corp., 1992                **/
/**********************************************************************/

/*
    alertdlg.hxx

    This file contains the class definition of the ALERTS_DIALOG



    FILE HISTORY:
        Johnl   13-Apr-1992     Created
        KeithMo 12-Nov-1992     Now uses subclassed SLE_STRLB_GROUP.

*/

#ifndef _ALERTDLG_HXX_
#define _ALERTDLG_HXX_


/*************************************************************************

    NAME:       ALERTS_STRLB_GROUP

    SYNOPSIS:   Adds minor parameter validation to SLE_STRLB_GROUP.

    PARENT:     SLE_STRLB_GROUP

    NOTES:      See SLE_STRLB_GROUP for details.

    HISTORY:
        KeithMo 12-Nov-1992     Created.
        KeithMo 18-Jan-1993     Added OnUserAction virtual.

**************************************************************************/
class ALERTS_STRLB_GROUP : public SLE_STRLB_GROUP
{
private:
    OWNER_WINDOW * _powin;

protected:
    virtual APIERR W_Add( const TCHAR * psz );

    virtual APIERR OnUserAction( CONTROL_WINDOW      * pcwin,
                                 const CONTROL_EVENT & e );

public:
    ALERTS_STRLB_GROUP( OWNER_WINDOW   * powin,
                        SLE            * sleInput,
                        STRING_LISTBOX * pStrLB,
                        PUSH_BUTTON    * pbuttonAdd,
                        PUSH_BUTTON    * pbuttonRemove );

    ~ALERTS_STRLB_GROUP( VOID );

    VOID SetDefaultButton( VOID );

};   // class ALERTS_STRLB_GROUP


/*************************************************************************

    NAME:       ALERTS_DIALOG

    SYNOPSIS:   This class allows the user to set which computers will
                recieve alerts generated by NT.  The list is stored in
                the registry.

    INTERFACE:  Constructor

        GetComputerListFromRegistry
        SetComputerListInRegistry
            Read and write (and lock and unlock) the list of computer names
            stored in the registry.

        LockServicesDatabase
        UnlockServicesDatabase
            Attempts to take the lock on the services database.


    PARENT:     DIALOG_WINDOW

    USES:       PUSH_BUTTON, STRING_LISTBOX, SLE, SLE_STRLB_GROUP

    CAVEATS:    If ERROR_LOCK_FAILED is returned from construction then we
                were unable to lock the services database.  Note that the
                user will already have been notified of this.


    NOTES:      The lock on the services database is not maintained while the
                dialog is displayed (i.e., we relock the database when we
                go to write the computer names).

    HISTORY:
        JohnL   13-Apr-1992     Created
        KeithMo 03-Aug-1992     Now handles downlevel case.

**************************************************************************/

class ALERTS_DIALOG : public DIALOG_WINDOW
{
public:
    ALERTS_DIALOG( HWND hDlg, SERVER_2 * pServer2  ) ;
    ~ALERTS_DIALOG() ;

    VOID MakeOKButtonDefault( VOID )
        { _pbOK.MakeDefault(); }

protected:
    virtual ULONG QueryHelpContext( void ) ;
    virtual BOOL OnOK( void ) ;
    virtual BOOL OnCommand( const CONTROL_EVENT & event );

    APIERR GetComputerList( STRLIST     * pstrlistComputers,
                            const TCHAR * pszFocusServer  ) ;
    APIERR SetComputerList( STRING_LISTBOX * plbComputerNames,
                            const TCHAR    * pszFocusServer   ) ;

    APIERR GetComputerListFromRegistry( STRLIST     * pstrlistComputers,
                                        const TCHAR * pszFocusServer  ) ;
    APIERR SetComputerListInRegistry( STRING_LISTBOX * plbComputerNames,
                                      const TCHAR    * pszFocusServer   ) ;

    APIERR GetComputerListFromLanmanIni( STRLIST     * pstrlistComputers,
                                         const TCHAR * pszFocusServer  ) ;
    APIERR SetComputerListInLanmanIni( STRING_LISTBOX * plbComputerNames,
                                       const TCHAR    * pszFocusServer   ) ;

    APIERR LockServiceDatabase( const TCHAR * pszFocusServer,
                                 BOOL * pfIsLocked ) ;
    APIERR UnlockServiceDatabase( void ) ;
    VOID   DisplayDBLockMessage( MSGID msgidDBLockedMessage ) ;

private:
    STRING_LISTBOX _lbComputerNames ;
    SLE            _sleInput ;
    PUSH_BUTTON    _pbAdd ;
    PUSH_BUTTON    _pbRemove ;
    PUSH_BUTTON    _pbOK;

    ALERTS_STRLB_GROUP _StrLBGroup ;
    SERVER_2 *      _pServer2 ;

    SC_HANDLE       _hscServices ;
    SC_LOCK         _hlockServices ;
} ;

#endif //_ALERTDLG_HXX_
