;/*++ BUILD Version: 0005    // Increment this if a change has global effects
;
;Copyright (c) 1991-1993  Microsoft Corporation
;
;Module Name:
;
;    ntstatus.h
;
;Abstract:
;
;    Constant definitions for the NTSTATUS values.
;
;Author:
;
;    Portable Systems Group 30-Mar-1989
;
;Revision History:
;
;Notes:
;
;    This file is generated by the MC tool from the winerror.msg file.
;
;    Please add new error values to the end of the file.  To do otherwise
;    will jumble the error values.
;
;--*/
;
;#ifndef _NTSTATUS_
;#define _NTSTATUS_
;
;/*lint -save -e767 */  // Don't complain about different definitions // winnt

MessageIdTypedef=NTSTATUS

SeverityNames=(Success=0x0:STATUS_SEVERITY_SUCCESS
               Informational=0x1:STATUS_SEVERITY_INFORMATIONAL
               Warning=0x2:STATUS_SEVERITY_WARNING
               Error=0x3:STATUS_SEVERITY_ERROR
              )

FacilityNames=(System=0x0
               RpcRuntime=0x2:FACILITY_RPC_RUNTIME
               RpcStubs=0x3:FACILITY_RPC_STUBS
               Io=0x4:FACILITY_IO_ERROR_CODE
              )


;
;/////////////////////////////////////////////////////////////////////////
;//
;// Standard Success values
;//
;//
;/////////////////////////////////////////////////////////////////////////
;
;
;//
;// The success status codes 0 - 63 are reserved for wait completion status.
;//
;#define STATUS_SUCCESS                          ((NTSTATUS)0x00000000L)
;

MessageId=0x0000 Facility=System Severity=Success SymbolicName=STATUS_WAIT_0                    ;// winnt
Language=English
.


MessageId=0x0001 Facility=System Severity=Success SymbolicName=STATUS_WAIT_1
Language=English
.


MessageId=0x0002 Facility=System Severity=Success SymbolicName=STATUS_WAIT_2
Language=English
.


MessageId=0x0003 Facility=System Severity=Success SymbolicName=STATUS_WAIT_3
Language=English
.


MessageId=0x003F Facility=System Severity=Success SymbolicName=STATUS_WAIT_63
Language=English
.

;
;//
;// The success status codes 128 - 191 are reserved for wait completion
;// status with an abandoned mutant object.
;//
;#define STATUS_ABANDONED                        ((NTSTATUS)0x00000080L)
;

MessageId=0x0080 Facility=System Severity=Success SymbolicName=STATUS_ABANDONED_WAIT_0          ;// winnt
Language=English
.


MessageId=0x00BF Facility=System Severity=Success SymbolicName=STATUS_ABANDONED_WAIT_63
Language=English
.



MessageId=0x00C0 Facility=System Severity=Success SymbolicName=STATUS_USER_APC                  ;// winnt
Language=English
The success status codes 256, 257, 258, and 258 are reserved for
User APC, Kernel APC, Alerted, and Timeout.
.


MessageId=0x0100 Facility=System Severity=Success SymbolicName=STATUS_KERNEL_APC
Language=English
The success status codes 256, 257, 258, and 258 are reserved for
User APC, Kernel APC, Alerted, and Timeout.
.


MessageId=0x0101 Facility=System Severity=Success SymbolicName=STATUS_ALERTED
Language=English
The success status codes 256, 257, 258, and 258 are reserved for
User APC, Kernel APC, Alerted, and Timeout.
.


MessageId=0x0102 Facility=System Severity=Success SymbolicName=STATUS_TIMEOUT                   ;// winnt
Language=English
The success status codes 256, 257, 258, and 258 are reserved for
User APC, Kernel APC, Alerted, and Timeout.
.


MessageId=0x0103 Facility=System Severity=Success SymbolicName=STATUS_PENDING                   ;// winnt
Language=English
The operation that was requested is pending completion.
.


MessageId=0x0104 Facility=System Severity=Success SymbolicName=STATUS_REPARSE
Language=English
A reparse should be performed by the Object Manager since the name of the
file resulted in a symbolic link.
.




MessageId=0x0105 Facility=System Severity=Success SymbolicName=STATUS_MORE_ENTRIES
Language=English
Returned by enumeration APIs to indicate more information is available
to successive calls.
.


MessageId=0x0106 Facility=System Severity=Success SymbolicName=STATUS_NOT_ALL_ASSIGNED
Language=English
Indicates not all privileges referenced are assigned to the caller.
This allows, for example, all privileges to be disabled without having
to know exactly which privileges are assigned.
.


MessageId=0x0107 Facility=System Severity=Success SymbolicName=STATUS_SOME_NOT_MAPPED
Language=English
Some of the information to be translated has not been translated.
.


MessageId=0x0108 Facility=System Severity=Success SymbolicName=STATUS_OPLOCK_BREAK_IN_PROGRESS
Language=English
An open/create operation completed while an oplock break is
underway.
.


MessageId=0x0109 Facility=System Severity=Success SymbolicName=STATUS_VOLUME_MOUNTED
Language=English
A new volume has been mounted by a file system.
.



MessageId=0x010A Facility=System Severity=Success SymbolicName=STATUS_RXACT_COMMITTED
Language=English
This success level status indicates that the transaction state already
exists for the registry sub-tree, but that a transaction commit was
previously aborted.  The commit has now been completed.
This status value is returned by the runtime library (RTL) registry
transaction package (RXact).
.


MessageId=0x010B Facility=System Severity=Success SymbolicName=STATUS_NOTIFY_CLEANUP
Language=English
This indicates that a notify change request has been completed due to
closing the handle which made the notify change request.
.


MessageId=0x010C Facility=System Severity=Success SymbolicName=STATUS_NOTIFY_ENUM_DIR
Language=English
This indicates that a notify change request is being completed and that the
information is not being returned in the caller's buffer.  The caller now
needs to enumerate the files to find the changes.
.


MessageId=0x010D Facility=System Severity=Success SymbolicName=STATUS_NO_QUOTAS_FOR_ACCOUNT
Language=English
{No Quotas}
No system quota limits are specifically set for this account.
.

MessageId=0x010E Facility=System Severity=Success SymbolicName=STATUS_PRIMARY_TRANSPORT_CONNECT_FAILED
Language=English
{Connect Failure on Primary Transport}
An attempt was made to connect to the remote server %s on the primary transport, but the
connection failed.  The computer WAS able to connect on a secondary transport.
.

MessageId=0x0110 Facility=System Severity=Success SymbolicName=STATUS_PAGE_FAULT_TRANSITION
Language=English
Page fault was a transition fault.
.

MessageId=0x0111 Facility=System Severity=Success SymbolicName=STATUS_PAGE_FAULT_DEMAND_ZERO
Language=English
Page fault was a demand zero fault.
.

MessageId=0x0112 Facility=System Severity=Success SymbolicName=STATUS_PAGE_FAULT_COPY_ON_WRITE
Language=English
Page fault was a demand zero fault.
.

MessageId=0x0113 Facility=System Severity=Success SymbolicName=STATUS_PAGE_FAULT_GUARD_PAGE
Language=English
Page fault was a demand zero fault.
.

MessageId=0x0114 Facility=System Severity=Success SymbolicName=STATUS_PAGE_FAULT_PAGING_FILE
Language=English
Page fault was a satisfied by reading from a secondary storage device.
.

MessageId=0x0115 Facility=System Severity=Success SymbolicName=STATUS_CACHE_PAGE_LOCKED
Language=English
Cached page was locked during operation.
.

MessageId=0x0116 Facility=System Severity=Success SymbolicName=STATUS_CRASH_DUMP
Language=English
Crash dump exists in paging file.
.

MessageId=0x0117 Facility=System Severity=Success SymbolicName=STATUS_BUFFER_ALL_ZEROS
Language=English
Specified buffer contains all zeros.
.

;
;

;/////////////////////////////////////////////////////////////////////////
;//
;// Standard Information values
;//
;/////////////////////////////////////////////////////////////////////////
;

MessageId=0x0000 Facility=System Severity=Informational SymbolicName=STATUS_OBJECT_NAME_EXISTS
Language=English
{Object Exists}
An attempt was made to create an object and the object name already existed.
.


MessageId=0x0001 Facility=System Severity=Informational SymbolicName=STATUS_THREAD_WAS_SUSPENDED
Language=English
{Thread Suspended}
A thread termination occurred while the thread was suspended. The
thread was resumed, and termination proceeded.
.


MessageId=0x0002 Facility=System Severity=Informational SymbolicName=STATUS_WORKING_SET_LIMIT_RANGE
Language=English
{Working Set Range Error}
An attempt was made to set the working set minimum or maximum
to values which are outside of the allowable range.
.


MessageId=0x0003 Facility=System Severity=Informational SymbolicName=STATUS_IMAGE_NOT_AT_BASE
Language=English
{Image Relocated}
An image file could not be mapped at the address specified in
the image file.  Local fixups must be performed on this image.
.


MessageId=0x0004 Facility=System Severity=Informational SymbolicName=STATUS_RXACT_STATE_CREATED
Language=English
This informational level status indicates that a specified registry
sub-tree transaction state did not yet exist and had to be created.
This status value is returned by the runtime library (RTL) registry
transaction package (RXact).
.


MessageId=0x0005 Facility=System Severity=Informational SymbolicName=STATUS_SEGMENT_NOTIFICATION
Language=English
{Segment Load}
A virtual DOS machine (VDM) is loading, unloading, or moving an MS-DOS
or Win16 program segment image. An exception is raised so a debugger can
load, unload or track symbols and breakpoints within these 16-bit segments.
.


MessageId=0x0006 Facility=System Severity=Informational SymbolicName=STATUS_LOCAL_USER_SESSION_KEY
Language=English
{Local Session Key}
A user session key was requested for a local RPC connection. The session key
returned is a constant value and not unique to this connection.
.


MessageId=0x0007 Facility=System Severity=Informational SymbolicName=STATUS_BAD_CURRENT_DIRECTORY
Language=English
{Invalid Current Directory}
The process can not switch to the startup current directory %s.
Select OK to set current directory to %s, or select CANCEL
to exit.
.

MessageId=0x0008 Facility=System Severity=Informational SymbolicName=STATUS_SERIAL_MORE_WRITES
Language=English
{Serial IOCTL Complete}
A serial I/O operation was completed by another write to a serial port.
(The IOCTL_SERIAL_XOFF_COUNTER reached zero.)
.

MessageId=0x0009 Facility=System Severity=Informational SymbolicName=STATUS_REGISTRY_RECOVERED
Language=English
{Registry Recovery}
One of the files containing the system's Registry data had to be recovered
by use of a log or alternate copy.  The recovery was successful.
.

MessageId=0x000A Facility=System Severity=Informational SymbolicName=STATUS_FT_READ_RECOVERY_FROM_BACKUP
Language=English
{Redundant Read}
To satisfy a read request, the NT fault-tolerant file system successfully
read the requested data from a redundant copy. This was done because
the file system encountered a failure on a member of the fault-tolerant
volume, but was unable to reassign the failing area of the device.
.

MessageId=0x000B Facility=System Severity=Informational SymbolicName=STATUS_FT_WRITE_RECOVERY
Language=English
{Redundant Write}
To satisfy a write request, the NT fault-tolerant file system successfully
wrote a redundant copy of the information. This was done because the
file system encountered a failure on a member of the fault-tolerant
volume, but was not able to reassign the failing area of the device.
.

MessageId=0x000C Facility=System Severity=Informational SymbolicName=STATUS_SERIAL_COUNTER_TIMEOUT
Language=English
{Serial IOCTL Timeout}
A serial I/O operation completed because the time-out period expired.
(The IOCTL_SERIAL_XOFF_COUNTER had not reached zero.)
.

MessageId=0x000D Facility=System Severity=Informational SymbolicName=STATUS_NULL_LM_PASSWORD
Language=English
{Password Too Complex}
The NT password is too complex to be converted to a LAN Manager password.
The LAN Manager password returned is a NULL string.
.

MessageId=0x000E Facility=System Severity=Informational SymbolicName=STATUS_IMAGE_MACHINE_TYPE_MISMATCH
Language=English
The specified image file is valid, but is for a machine type other than
the current machine.
.

MessageId=0x000F Facility=System Severity=Informational SymbolicName=STATUS_RECEIVE_PARTIAL
Language=English
{Partial Data Received}
The network transport returned partial data to its client. The remaining
data will be sent later.
.

MessageId=0x0010 Facility=System Severity=Informational SymbolicName=STATUS_RECEIVE_EXPEDITED
Language=English
{Expedited Data Received}
The network transport returned data to its client that was marked as
expedited by the remote system.
.

MessageId=0x0011 Facility=System Severity=Informational SymbolicName=STATUS_RECEIVE_PARTIAL_EXPEDITED
Language=English
{Partial Expedited Data Received}
The network transport returned partial data to its client and this data
was marked as expedited by the remote system. The remaining data will
be sent later.
.

MessageId=0x0012 Facility=System Severity=Informational SymbolicName=STATUS_EVENT_DONE
Language=English
{TDI Event Done}
The TDI indication has completed successfully.
.

MessageId=0x0013 Facility=System Severity=Informational SymbolicName=STATUS_EVENT_PENDING
Language=English
{TDI Event Pending}
The TDI indication has entered the pending state.
.

MessageId=0x0014 Facility=System Severity=Informational SymbolicName=STATUS_CHECKING_FILE_SYSTEM
Language=English
Checking file system on %wZ
.

MessageId=0x0015 Facility=System Severity=Informational SymbolicName=STATUS_FATAL_APP_EXIT
Language=English
{Fatal Application Exit}
%s
.

MessageId=0x0016 Facility=System Severity=Informational SymbolicName=STATUS_PREDEFINED_HANDLE
Language=English
The specified registry key is referenced by a predefined handle.
.

MessageId=0x0017 Facility=System Severity=Informational SymbolicName=STATUS_WAS_UNLOCKED
Language=English
{Page Unlocked}
The page protection of a locked page was changed to 'No Access'
and the page was unlocked from memory and from the process.
.

MessageId=0x0018 Facility=System Severity=Informational SymbolicName=STATUS_SERVICE_NOTIFICATION
Language=English
%s
.

MessageId=0x0019 Facility=System Severity=Informational SymbolicName=STATUS_WAS_LOCKED
Language=English
{Page Locked}
One of the pages to lock was already locked.
.

MessageId=0x001a Facility=System Severity=Informational SymbolicName=STATUS_LOG_HARD_ERROR
Language=English
Application popup: %1 : %2
.


;
;

;/////////////////////////////////////////////////////////////////////////
;//
;// Standard Warning values
;//
;//
;// Note:  Do NOT use the value 0x80000000L, as this is a non-portable value
;//        for the NT_SUCCESS macro.  Warning values start with a code of 1.
;//
;/////////////////////////////////////////////////////////////////////////
;

MessageId=0x0001 Facility=System Severity=Warning SymbolicName=STATUS_GUARD_PAGE_VIOLATION     ;// winnt
Language=English
{EXCEPTION}
Guard Page Exception
A page of memory that marks the end of a data structure, such as a stack
or an array, has been accessed.
.


MessageId=0x0002 Facility=System Severity=Warning SymbolicName=STATUS_DATATYPE_MISALIGNMENT    ;// winnt
Language=English
{EXCEPTION}
Alignment Fault
A datatype misalignment was detected in a load or store instruction.
.


MessageId=0x0003 Facility=System Severity=Warning SymbolicName=STATUS_BREAKPOINT               ;// winnt
Language=English
{EXCEPTION}
Breakpoint
A breakpoint has been reached.
.


MessageId=0x0004 Facility=System Severity=Warning SymbolicName=STATUS_SINGLE_STEP              ;// winnt
Language=English
{EXCEPTION}
Single Step
A single step or trace operation has just been completed.
.


MessageId=0x0005 Facility=System Severity=Warning SymbolicName=STATUS_BUFFER_OVERFLOW
Language=English
{Buffer Overflow}
The data was too large to fit into the specified buffer.
.


MessageId=0x0006 Facility=System Severity=Warning SymbolicName=STATUS_NO_MORE_FILES
Language=English
{No More Files}
No more files were found which match the file specification.
.


MessageId=0x0007 Facility=System Severity=Warning SymbolicName=STATUS_WAKE_SYSTEM_DEBUGGER
Language=English
{Kernel Debugger Awakened}
the system debugger was awakened by an interrupt.
.



MessageId=0x000A Facility=System Severity=Warning SymbolicName=STATUS_HANDLES_CLOSED
Language=English
{Handles Closed}
Handles to objects have been automatically closed as a result of the
requested operation.
.


MessageId=0x000B Facility=System Severity=Warning SymbolicName=STATUS_NO_INHERITANCE
Language=English
{Non-Inheritable ACL}
An access control list (ACL) contains no components that can be inherited.
.


MessageId=0x000C Facility=System Severity=Warning SymbolicName=STATUS_GUID_SUBSTITUTION_MADE
Language=English
{GUID Substitution}
During the translation of an HPFS global identifier (GUID) to a Windows NT
security ID (SID), no administratively-defined GUID prefix was found.
A substitute prefix was used, which will not compromise system security.
However, this may provide a more restrictive access than intended.
.


MessageId=0x000D Facility=System Severity=Warning SymbolicName=STATUS_PARTIAL_COPY
Language=English
{Partial Copy}
Due to protection conflicts not all the requested bytes could be
copied.
.


MessageId=0x000E Facility=System Severity=Warning SymbolicName=STATUS_DEVICE_PAPER_EMPTY
Language=English
{Out of Paper}
The printer is out of paper.
.


MessageId=0x000F Facility=System Severity=Warning SymbolicName=STATUS_DEVICE_POWERED_OFF
Language=English
{Device Power Is Off}
The printer power has been turned off.
.


MessageId=0x0010 Facility=System Severity=Warning SymbolicName=STATUS_DEVICE_OFF_LINE
Language=English
{Device Offline}
The printer has been taken offline.
.


MessageId=0x0011 Facility=System Severity=Warning SymbolicName=STATUS_DEVICE_BUSY
Language=English
{Device Busy}
The device is currently busy.
.


MessageId=0x0012 Facility=System Severity=Warning SymbolicName=STATUS_NO_MORE_EAS
Language=English
{No More EAs}
No more extended attributes (EAs) were found for the file.
.


MessageId=0x0013 Facility=System Severity=Warning SymbolicName=STATUS_INVALID_EA_NAME
Language=English
{Illegal EA}
The specified extended attribute (EA) name contains at least one illegal
character.
.


MessageId=0x0014 Facility=System Severity=Warning SymbolicName=STATUS_EA_LIST_INCONSISTENT
Language=English
{Inconsistent EA List}
The extended attribute (EA) list is inconsistent.
.


MessageId=0x0015 Facility=System Severity=Warning SymbolicName=STATUS_INVALID_EA_FLAG
Language=English
{Invalid EA Flag}
An invalid extended attribute (EA) flag was set.
.


MessageId=0x0016 Facility=System Severity=Warning SymbolicName=STATUS_VERIFY_REQUIRED
Language=English
{Verifying Disk}
The media has changed and a verify operation is in progress so no
reads or writes may be performed to the device, except those used in
the verify operation.
.


MessageId=0x0017 Facility=System Severity=Warning SymbolicName=STATUS_EXTRANEOUS_INFORMATION
Language=English
{Too Much Information}
The specified access control list (ACL) contained more information than
was expected.
.



MessageId=0x0018 Facility=System Severity=Warning SymbolicName=STATUS_RXACT_COMMIT_NECESSARY
Language=English
This warning level status indicates that the transaction state already
exists for the registry sub-tree, but that a transaction commit was
previously aborted.  The commit has NOT been completed, but has not been
rolled back either (so it may still be committed if desired).
This status value is returned by the runtime library (RTL) registry
transaction package (RXact).
.


MessageId=0x001A Facility=System Severity=Warning SymbolicName=STATUS_NO_MORE_ENTRIES
Language=English
{No More Entries}
No more entries are available from an enumeration operation.
.

MessageId=0x001B Facility=System Severity=Warning SymbolicName=STATUS_FILEMARK_DETECTED
Language=English
{Filemark Found}
A filemark was detected.
.

MessageId=0x001C Facility=System Severity=Warning SymbolicName=STATUS_MEDIA_CHANGED
Language=English
{Media Changed}
The media may have changed.
.

MessageId=0x001D Facility=System Severity=Warning SymbolicName=STATUS_BUS_RESET
Language=English
{I/O Bus Reset}
An I/O bus reset was detected.
.

MessageId=0x001E Facility=System Severity=Warning SymbolicName=STATUS_END_OF_MEDIA
Language=English
{End of Media}
The end of the media was encountered.
.

MessageId=0x001F Facility=System Severity=Warning SymbolicName=STATUS_BEGINNING_OF_MEDIA
Language=English
Beginning of tape or partition has been detected.
.

MessageId=0x0020 Facility=System Severity=Warning SymbolicName=STATUS_MEDIA_CHECK
Language=English
{Media Changed}
The media may have changed.
.

MessageId=0x0021 Facility=System Severity=Warning SymbolicName=STATUS_SETMARK_DETECTED
Language=English
A tape access reached a setmark.
.

MessageId=0x0022 Facility=System Severity=Warning SymbolicName=STATUS_NO_DATA_DETECTED
Language=English
During a tape access, the end of the data written is reached.
.

MessageId=0x0023 Facility=System Severity=Warning SymbolicName=STATUS_REDIRECTOR_HAS_OPEN_HANDLES
Language=English
The redirector is in use and cannot be unloaded.
.

MessageId=0x0024 Facility=System Severity=Warning SymbolicName=STATUS_SERVER_HAS_OPEN_HANDLES
Language=English
The server is in use and cannot be unloaded.
.

MessageId=0x0025 Facility=System Severity=Warning SymbolicName=STATUS_ALREADY_DISCONNECTED
Language=English
The specified connection has already been disconnected.
.

MessageId=0x0026 Facility=System Severity=Warning SymbolicName=STATUS_LONGJUMP
Language=English
A long jump has been executed.
.

;
;

;/////////////////////////////////////////////////////////////////////////
;//
;//  Standard Error values
;//
;/////////////////////////////////////////////////////////////////////////
;

MessageId=0x0001 Facility=System Severity=Error SymbolicName=STATUS_UNSUCCESSFUL
Language=English
{Operation Failed}
The requested operation was unsuccessful.
.


MessageId=0x0002 Facility=System Severity=Error SymbolicName=STATUS_NOT_IMPLEMENTED
Language=English
{Not Implemented}
The requested operation is not implemented.
.


MessageId=0x0003 Facility=System Severity=Error SymbolicName=STATUS_INVALID_INFO_CLASS
Language=English
{Invalid Parameter}
The specified information class is not a valid information class for
the specified object.
.


MessageId=0x0004 Facility=System Severity=Error SymbolicName=STATUS_INFO_LENGTH_MISMATCH
Language=English
The specified information record length does not match the length
required for the specified information class.
.


MessageId=0x0005 Facility=System Severity=Error SymbolicName=STATUS_ACCESS_VIOLATION         ;// winnt
Language=English
The instruction at "0x%08lx" referenced memory at "0x%08lx". The memory
could not be "%s".
.

MessageId=0x0006 Facility=System Severity=Error SymbolicName=STATUS_IN_PAGE_ERROR            ;// winnt
Language=English
The instruction at "0x%08lx" referenced memory at "0x%08lx". The required
data was not placed into memory because of an I/O error status of "0x%08lx".
.


MessageId=0x0007 Facility=System Severity=Error SymbolicName=STATUS_PAGEFILE_QUOTA
Language=English
The pagefile quota for the process has been exhausted.
.


MessageId=0x0008 Facility=System Severity=Error SymbolicName=STATUS_INVALID_HANDLE
Language=English
An invalid HANDLE was specified.
.


MessageId=0x0009 Facility=System Severity=Error SymbolicName=STATUS_BAD_INITIAL_STACK
Language=English
An invalid initial stack was specified in a call to NtCreateThread.
.


MessageId=0x000A Facility=System Severity=Error SymbolicName=STATUS_BAD_INITIAL_PC
Language=English
An invalid initial start address was specified in a call to NtCreateThread.
.


MessageId=0x000B Facility=System Severity=Error SymbolicName=STATUS_INVALID_CID
Language=English
An invalid Client ID was specified.
.


MessageId=0x000C Facility=System Severity=Error SymbolicName=STATUS_TIMER_NOT_CANCELED
Language=English
An attempt was made to cancel or set a timer that has an associated APC
and the subject thread is not the thread that originally set the timer
with an associated APC routine.
.


MessageId=0x000D Facility=System Severity=Error SymbolicName=STATUS_INVALID_PARAMETER
Language=English
An invalid parameter was passed to the a service or function.
.


MessageId=0x000E Facility=System Severity=Error SymbolicName=STATUS_NO_SUCH_DEVICE
Language=English
A device which does not exist was specified.
.


MessageId=0x000F Facility=System Severity=Error SymbolicName=STATUS_NO_SUCH_FILE
Language=English
{File Not Found}
The file %s does not exist.
.


MessageId=0x0010 Facility=System Severity=Error SymbolicName=STATUS_INVALID_DEVICE_REQUEST
Language=English
The specified request is not a valid operation for the target device.
.


MessageId=0x0011 Facility=System Severity=Error SymbolicName=STATUS_END_OF_FILE
Language=English
The end-of-file marker has been reached.  There is no valid data in the
file beyond this marker.
.


MessageId=0x0012 Facility=System Severity=Error SymbolicName=STATUS_WRONG_VOLUME
Language=English
{Wrong Volume}
The wrong volume is in the drive.
Please insert volume %s into drive %s.
.


MessageId=0x0013 Facility=System Severity=Error SymbolicName=STATUS_NO_MEDIA_IN_DEVICE
Language=English
{No Disk}
There is no disk in the drive.
Please insert a disk into drive %s.
.


MessageId=0x0014 Facility=System Severity=Error SymbolicName=STATUS_UNRECOGNIZED_MEDIA
Language=English
{Unknown Disk Format}
The disk in drive %s is not formatted properly.
Please check the disk, and reformat if necessary.
.


MessageId=0x0015 Facility=System Severity=Error SymbolicName=STATUS_NONEXISTENT_SECTOR
Language=English
{Sector Not Found}
The specified sector does not exist.
.


MessageId=0x0016 Facility=System Severity=Error SymbolicName=STATUS_MORE_PROCESSING_REQUIRED
Language=English
{Still Busy}
The specified I/O request packet (IRP) cannot be disposed of because the
I/O operation is not complete.
.


MessageId=0x0017 Facility=System Severity=Error SymbolicName=STATUS_NO_MEMORY ;// winnt
Language=English
{Not Enough Quota}
Not enough virtual memory or paging file quota is available to complete
the specified operation.
.


MessageId=0x0018 Facility=System Severity=Error SymbolicName=STATUS_CONFLICTING_ADDRESSES
Language=English
{Conflicting Address Range}
The specified address range conflicts with the address space.
.


MessageId=0x0019 Facility=System Severity=Error SymbolicName=STATUS_NOT_MAPPED_VIEW
Language=English
Address range to unmap is not a mapped view.
.


MessageId=0x001A Facility=System Severity=Error SymbolicName=STATUS_UNABLE_TO_FREE_VM
Language=English
Virtual memory cannot be freed.
.


MessageId=0x001B Facility=System Severity=Error SymbolicName=STATUS_UNABLE_TO_DELETE_SECTION
Language=English
Specified section cannot be deleted.
.


MessageId=0x001C Facility=System Severity=Error SymbolicName=STATUS_INVALID_SYSTEM_SERVICE
Language=English
An invalid system service was specified in a system service call.
.


MessageId=0x001D Facility=System Severity=Error SymbolicName=STATUS_ILLEGAL_INSTRUCTION ;// winnt
Language=English
{EXCEPTION}
Illegal Instruction
An attempt was made to execute an illegal instruction.
.


MessageId=0x001E Facility=System Severity=Error SymbolicName=STATUS_INVALID_LOCK_SEQUENCE
Language=English
{Invalid Lock Sequence}
An attempt was made to execute an invalid lock sequence.
.


MessageId=0x001F Facility=System Severity=Error SymbolicName=STATUS_INVALID_VIEW_SIZE
Language=English
{Invalid Mapping}
An attempt was made to create a view for a section which is bigger
than the section.
.


MessageId=0x0020 Facility=System Severity=Error SymbolicName=STATUS_INVALID_FILE_FOR_SECTION
Language=English
{Bad File}
The attributes of the specified mapping file for a section of memory
cannot be read.
.


MessageId=0x0021 Facility=System Severity=Error SymbolicName=STATUS_ALREADY_COMMITTED
Language=English
{Already Committed}
The specified address range is already committed.
.


MessageId=0x0022 Facility=System Severity=Error SymbolicName=STATUS_ACCESS_DENIED
Language=English
{Access Denied}
A process has requested access to an object, but has not been granted
those access rights.
.


MessageId=0x0023 Facility=System Severity=Error SymbolicName=STATUS_BUFFER_TOO_SMALL
Language=English
{Buffer Too Small}
The buffer is too small to contain the entry.  No information has been
written to the buffer.
.


MessageId=0x0024 Facility=System Severity=Error SymbolicName=STATUS_OBJECT_TYPE_MISMATCH
Language=English
{Wrong Type}
There is a mismatch between the type of object required by the requested
operation and the type of object that is specified in the request.
.


MessageId=0x0025 Facility=System Severity=Error SymbolicName=STATUS_NONCONTINUABLE_EXCEPTION ;// winnt
Language=English
{EXCEPTION}
Cannot Continue
Windows NT cannot continue from this exception.
.


MessageId=0x0026 Facility=System Severity=Error SymbolicName=STATUS_INVALID_DISPOSITION ;// winnt
Language=English
An invalid exception disposition was returned by an exception handler.
.


MessageId=0x0027 Facility=System Severity=Error SymbolicName=STATUS_UNWIND
Language=English
Unwind exception code.
.


MessageId=0x0028 Facility=System Severity=Error SymbolicName=STATUS_BAD_STACK
Language=English
An invalid or unaligned stack was encountered during an unwind operation.
.


MessageId=0x0029 Facility=System Severity=Error SymbolicName=STATUS_INVALID_UNWIND_TARGET
Language=English
An invalid unwind target was encountered during an unwind operation.
.


MessageId=0x002A Facility=System Severity=Error SymbolicName=STATUS_NOT_LOCKED
Language=English
An attempt was made to unlock a page of memory which was not locked.
.


MessageId=0x002B Facility=System Severity=Error SymbolicName=STATUS_PARITY_ERROR
Language=English
Device parity error on I/O operation.
.


MessageId=0x002C Facility=System Severity=Error SymbolicName=STATUS_UNABLE_TO_DECOMMIT_VM
Language=English
An attempt was made to decommit uncommitted virtual memory.
.


MessageId=0x002D Facility=System Severity=Error SymbolicName=STATUS_NOT_COMMITTED
Language=English
An attempt was made to change the attributes on memory that
has not been committed.
.


MessageId=0x002E Facility=System Severity=Error SymbolicName=STATUS_INVALID_PORT_ATTRIBUTES
Language=English
Invalid Object Attributes specified to NtCreatePort or invalid
Port Attributes specified to NtConnectPort
.


MessageId=0x002F Facility=System Severity=Error SymbolicName=STATUS_PORT_MESSAGE_TOO_LONG
Language=English
Length of message passed to NtRequestPort or NtRequestWaitReplyPort
was longer than the maximum message allowed by the port.
.


MessageId=0x0030 Facility=System Severity=Error SymbolicName=STATUS_INVALID_PARAMETER_MIX
Language=English
An invalid combination of parameters was specified
.


MessageId=0x0031 Facility=System Severity=Error SymbolicName=STATUS_INVALID_QUOTA_LOWER
Language=English
An attempt was made to lower a quota limit below the current usage.
.


MessageId=0x0032 Facility=System Severity=Error SymbolicName=STATUS_DISK_CORRUPT_ERROR
Language=English
{Corrupt Disk}
The file system structure on the disk is corrupt and unusable.
Please run the Chkdsk utility on the volume %s.
.


MessageId=0x0033 Facility=System Severity=Error SymbolicName=STATUS_OBJECT_NAME_INVALID
Language=English
Object Name invalid
.


MessageId=0x0034 Facility=System Severity=Error SymbolicName=STATUS_OBJECT_NAME_NOT_FOUND
Language=English
Object Name not found
.


MessageId=0x0035 Facility=System Severity=Error SymbolicName=STATUS_OBJECT_NAME_COLLISION
Language=English
Object Name already exists
.


MessageId=0x0037 Facility=System Severity=Error SymbolicName=STATUS_PORT_DISCONNECTED
Language=English
Attempt the send a message to a disconnected communication port
.


MessageId=0x0038 Facility=System Severity=Error SymbolicName=STATUS_DEVICE_ALREADY_ATTACHED
Language=English
An attempt was made to attach to a device that was already attached to
another device.
.


MessageId=0x0039 Facility=System Severity=Error SymbolicName=STATUS_OBJECT_PATH_INVALID
Language=English
Object Path Component was not a directory object
.


MessageId=0x003A Facility=System Severity=Error SymbolicName=STATUS_OBJECT_PATH_NOT_FOUND
Language=English
{Path Not Found}
The path %s does not exist.
.


MessageId=0x003B Facility=System Severity=Error SymbolicName=STATUS_OBJECT_PATH_SYNTAX_BAD
Language=English
Object Path Component was not a directory object
.


MessageId=0x003C Facility=System Severity=Error SymbolicName=STATUS_DATA_OVERRUN
Language=English
{Data Overrun}
A data overrun error occurred.
.


MessageId=0x003D Facility=System Severity=Error SymbolicName=STATUS_DATA_LATE_ERROR
Language=English
{Data Late}
A data late error occurred.
.


MessageId=0x003E Facility=System Severity=Error SymbolicName=STATUS_DATA_ERROR
Language=English
{Data Error}
An error in reading or writing data occurred.
.


MessageId=0x003F Facility=System Severity=Error SymbolicName=STATUS_CRC_ERROR
Language=English
{Bad CRC}
A cyclic redundancy check (CRC) checksum error occurred.
.


MessageId=0x0040 Facility=System Severity=Error SymbolicName=STATUS_SECTION_TOO_BIG
Language=English
{Section Too Large}
The specified section is too big to map the file.
.


MessageId=0x0041 Facility=System Severity=Error SymbolicName=STATUS_PORT_CONNECTION_REFUSED
Language=English
The NtConnectPort request is refused.
.


MessageId=0x0042 Facility=System Severity=Error SymbolicName=STATUS_INVALID_PORT_HANDLE
Language=English
The type of port handle is invalid for the operation requested.
.


MessageId=0x0043 Facility=System Severity=Error SymbolicName=STATUS_SHARING_VIOLATION
Language=English
A file cannot be opened because the share access flags are
incompatible.
.


MessageId=0x0044 Facility=System Severity=Error SymbolicName=STATUS_QUOTA_EXCEEDED
Language=English
Insufficient quota exists to complete the operation
.


MessageId=0x0045 Facility=System Severity=Error SymbolicName=STATUS_INVALID_PAGE_PROTECTION
Language=English
The specified page protection was not valid.
.


MessageId=0x0046 Facility=System Severity=Error SymbolicName=STATUS_MUTANT_NOT_OWNED
Language=English
An attempt to release a mutant object was made by a thread that was not the
owner of the mutant object.
.


MessageId=0x0047 Facility=System Severity=Error SymbolicName=STATUS_SEMAPHORE_LIMIT_EXCEEDED
Language=English
An attempt was made to release a semaphore such that its maximum count
would have been exceeded.
.


MessageId=0x0048 Facility=System Severity=Error SymbolicName=STATUS_PORT_ALREADY_SET
Language=English
An attempt to set a processes DebugPort or ExceptionPort was made,
but a port already exists in the process.
.


MessageId=0x0049 Facility=System Severity=Error SymbolicName=STATUS_SECTION_NOT_IMAGE
Language=English
An attempt was made to query image information on a section
which does not map an image.
.


MessageId=0x004A Facility=System Severity=Error SymbolicName=STATUS_SUSPEND_COUNT_EXCEEDED
Language=English
An attempt was made to suspend a thread whose suspend count
was at its maximum
.


MessageId=0x004B Facility=System Severity=Error SymbolicName=STATUS_THREAD_IS_TERMINATING
Language=English
An attempt was made to suspend a thread that has begun
termination.
.


MessageId=0x004C Facility=System Severity=Error SymbolicName=STATUS_BAD_WORKING_SET_LIMIT
Language=English
An attempt was made to set the working set limit to an
invalid value (minimum greater than maximum, etc).
.


MessageId=0x004D Facility=System Severity=Error SymbolicName=STATUS_INCOMPATIBLE_FILE_MAP
Language=English
A section was created to map a file which is not compatible
to an already existing section which maps the same file.
.


MessageId=0x004E Facility=System Severity=Error SymbolicName=STATUS_SECTION_PROTECTION
Language=English
A view to a section specifies a protection which is incompatible
with the initial views protection.
.


MessageId=0x004F Facility=System Severity=Error SymbolicName=STATUS_EAS_NOT_SUPPORTED
Language=English
An operation involving EAs failed because the file system does not
support EAs.
.


MessageId=0x0050 Facility=System Severity=Error SymbolicName=STATUS_EA_TOO_LARGE
Language=English
An EA operation failed because ea set is too large
.


MessageId=0x0051 Facility=System Severity=Error SymbolicName=STATUS_NONEXISTENT_EA_ENTRY
Language=English
An EA operation failed because the name or ea index is invalid
.


MessageId=0x0052 Facility=System Severity=Error SymbolicName=STATUS_NO_EAS_ON_FILE
Language=English
The file for which EAs were requested has no EAs.
.


MessageId=0x0053 Facility=System Severity=Error SymbolicName=STATUS_EA_CORRUPT_ERROR
Language=English
The EA is corrupt and non-readable
.


MessageId=0x0054 Facility=System Severity=Error SymbolicName=STATUS_FILE_LOCK_CONFLICT
Language=English
A requested read/write cannot be granted due to a conflicting file lock
.


MessageId=0x0055 Facility=System Severity=Error SymbolicName=STATUS_LOCK_NOT_GRANTED
Language=English
A requested file lock cannot be granted due to other existing locks
.


MessageId=0x0056 Facility=System Severity=Error SymbolicName=STATUS_DELETE_PENDING
Language=English
A non close operation has been requested of a file object with a
delete pending
.


MessageId=0x0057 Facility=System Severity=Error SymbolicName=STATUS_CTL_FILE_NOT_SUPPORTED
Language=English
An attempt was made to set the control attribute on a file.  This
attribute is not supported in the target file system.
.


MessageId=0x0058 Facility=System Severity=Error SymbolicName=STATUS_UNKNOWN_REVISION
Language=English
Indicates a revision number encountered or specified is not one
known by the service.  It may be a more recent revision than the
service is aware of.
.


MessageId=0x0059 Facility=System Severity=Error SymbolicName=STATUS_REVISION_MISMATCH
Language=English
Indicates two revision levels are incompatible.
.


MessageId=0x005A Facility=System Severity=Error SymbolicName=STATUS_INVALID_OWNER
Language=English
Indicates a particular Security ID may not be assigned as the
owner of an object.
.


MessageId=0x005B Facility=System Severity=Error SymbolicName=STATUS_INVALID_PRIMARY_GROUP
Language=English
Indicates a particular Security ID may not be assigned as the
primary group of an object.
.


MessageId=0x005C Facility=System Severity=Error SymbolicName=STATUS_NO_IMPERSONATION_TOKEN
Language=English
An attempt has been made to operate on an impersonation token
by a thread that is not currently impersonating a client.
.


MessageId=0x005D Facility=System Severity=Error SymbolicName=STATUS_CANT_DISABLE_MANDATORY
Language=English
A mandatory group may not be disabled.
.


MessageId=0x005E Facility=System Severity=Error SymbolicName=STATUS_NO_LOGON_SERVERS
Language=English
There are currently no logon servers available to service the logon
request.
.


MessageId=0x005F Facility=System Severity=Error SymbolicName=STATUS_NO_SUCH_LOGON_SESSION
Language=English
 A specified logon session does not exist.  It may already have
 been terminated.
.


MessageId=0x0060 Facility=System Severity=Error SymbolicName=STATUS_NO_SUCH_PRIVILEGE
Language=English
 A specified privilege does not exist.
.


MessageId=0x0061 Facility=System Severity=Error SymbolicName=STATUS_PRIVILEGE_NOT_HELD
Language=English
 A required privilege is not held by the client.
.


MessageId=0x0062 Facility=System Severity=Error SymbolicName=STATUS_INVALID_ACCOUNT_NAME
Language=English
The name provided is not a properly formed account name.
.


MessageId=0x0063 Facility=System Severity=Error SymbolicName=STATUS_USER_EXISTS
Language=English
The specified user already exists.
.


MessageId=0x0064 Facility=System Severity=Error SymbolicName=STATUS_NO_SUCH_USER
Language=English
The specified user does not exist.
.


MessageId=0x0065 Facility=System Severity=Error SymbolicName=STATUS_GROUP_EXISTS
Language=English
The specified group already exists.
.


MessageId=0x0066 Facility=System Severity=Error SymbolicName=STATUS_NO_SUCH_GROUP
Language=English
The specified group does not exist.
.


MessageId=0x0067 Facility=System Severity=Error SymbolicName=STATUS_MEMBER_IN_GROUP
Language=English
The specified user account is already in the specified group account.
Also used to indicate a group can not be deleted because it contains
a member.
.


MessageId=0x0068 Facility=System Severity=Error SymbolicName=STATUS_MEMBER_NOT_IN_GROUP
Language=English
The specified user account is not a member of the specified group account.
.


MessageId=0x0069 Facility=System Severity=Error SymbolicName=STATUS_LAST_ADMIN
Language=English
Indicates the requested operation would disable or delete the last
remaining administration account.  This is not allowed to prevent
creating a situation in which the system cannot be administrated.
.


MessageId=0x006A Facility=System Severity=Error SymbolicName=STATUS_WRONG_PASSWORD
Language=English
When trying to update a password, this return status indicates that
the value provided as the current password is not correct.
.


MessageId=0x006B Facility=System Severity=Error SymbolicName=STATUS_ILL_FORMED_PASSWORD
Language=English
When trying to update a password, this return status indicates that
the value provided for the new password contains values that are
not allowed in passwords.
.

MessageId=0x006C Facility=System Severity=Error SymbolicName=STATUS_PASSWORD_RESTRICTION
Language=English
When trying to update a password, this status indicates that some
password update rule has been violated.  For example, the password
may not meet length criteria.
.


MessageId=0x006D Facility=System Severity=Error SymbolicName=STATUS_LOGON_FAILURE
Language=English
The attempted logon is invalid.  This is either due to a bad username
or authentication information.
.

MessageId=0x006E Facility=System Severity=Error SymbolicName=STATUS_ACCOUNT_RESTRICTION
Language=English
Indicates a referenced user name and authentication information are
valid, but some user account restriction has prevented successful
authentication (such as time-of-day restrictions).
.


MessageId=0x006F Facility=System Severity=Error SymbolicName=STATUS_INVALID_LOGON_HOURS
Language=English
The user account has time restrictions and may not be logged onto
at this time.
.


MessageId=0x0070 Facility=System Severity=Error SymbolicName=STATUS_INVALID_WORKSTATION
Language=English
The user account is restricted such that it may not be used to
log on from the source workstation.
.


MessageId=0x0071 Facility=System Severity=Error SymbolicName=STATUS_PASSWORD_EXPIRED
Language=English
The user account's password has expired.
.


MessageId=0x0072 Facility=System Severity=Error SymbolicName=STATUS_ACCOUNT_DISABLED
Language=English
The referenced account is currently disabled and may not be logged on to.
.


MessageId=0x0073 Facility=System Severity=Error SymbolicName=STATUS_NONE_MAPPED
Language=English
None of the information to be translated has been translated.
.


MessageId=0x0074 Facility=System Severity=Error SymbolicName=STATUS_TOO_MANY_LUIDS_REQUESTED
Language=English
The number of LUIDs requested may not be allocated with a single
allocation.
.


MessageId=0x0075 Facility=System Severity=Error SymbolicName=STATUS_LUIDS_EXHAUSTED
Language=English
Indicates there are no more LUIDs to allocate.
.


MessageId=0x0076 Facility=System Severity=Error SymbolicName=STATUS_INVALID_SUB_AUTHORITY
Language=English
Indicates the sub-authority value is invalid for the particular use.
.


MessageId=0x0077 Facility=System Severity=Error SymbolicName=STATUS_INVALID_ACL
Language=English
Indicates the ACL structure is not valid.
.


MessageId=0x0078 Facility=System Severity=Error SymbolicName=STATUS_INVALID_SID
Language=English
Indicates the SID structure is not valid.
.


MessageId=0x0079 Facility=System Severity=Error SymbolicName=STATUS_INVALID_SECURITY_DESCR
Language=English
Indicates the SECURITY_DESCRIPTOR structure is not valid.
.


MessageId=0x007A Facility=System Severity=Error SymbolicName=STATUS_PROCEDURE_NOT_FOUND
Language=English
Indicates the specified procedure address can not be found in the
DLL
.


MessageId=0x007B Facility=System Severity=Error SymbolicName=STATUS_INVALID_IMAGE_FORMAT
Language=English
{Bad Image}
The application or DLL %s is not a valid Windows NT image.
Please check this against your installation diskette.
.


MessageId=0x007C Facility=System Severity=Error SymbolicName=STATUS_NO_TOKEN
Language=English
An attempt was made to reference a token that doesn't exist was made.
This is typically done by referencing the token associated with a thread
when the thread is not impersonating a client.
.


MessageId=0x007D Facility=System Severity=Error SymbolicName=STATUS_BAD_INHERITANCE_ACL
Language=English
Indicates that an attempt to build either an inherited ACL or ACE
was not successful.
This can be caused by a number of things.  One of the more probable
causes is the replacement of a CreatorId with an SID that didn't fit
into the ACE or ACL.
.


MessageId=0x007E Facility=System Severity=Error SymbolicName=STATUS_RANGE_NOT_LOCKED
Language=English
The range specified in NtUnlockFile was not locked.
.


MessageId=0x007F Facility=System Severity=Error SymbolicName=STATUS_DISK_FULL
Language=English
An operation failed because the disk was full.
.


MessageId=0x0080 Facility=System Severity=Error SymbolicName=STATUS_SERVER_DISABLED
Language=English
The GUID allocation server is [already] disabled at the moment.
.


MessageId=0x0081 Facility=System Severity=Error SymbolicName=STATUS_SERVER_NOT_DISABLED
Language=English
The GUID allocation server is [already] enabled at the moment.
.


MessageId=0x0082 Facility=System Severity=Error SymbolicName=STATUS_TOO_MANY_GUIDS_REQUESTED
Language=English
Too many GUIDs were requested from the allocation server at once.
.


MessageId=0x0083 Facility=System Severity=Error SymbolicName=STATUS_GUIDS_EXHAUSTED
Language=English
The GUIDs could not be allocated because the Authority Agent was
exhausted.
.


MessageId=0x0084 Facility=System Severity=Error SymbolicName=STATUS_INVALID_ID_AUTHORITY
Language=English
The value provided was an invalid value for an identifier authority.
.


MessageId=0x0085 Facility=System Severity=Error SymbolicName=STATUS_AGENTS_EXHAUSTED
Language=English
There are no more authority agent values available for the given
identifier authority value.
.


MessageId=0x0086 Facility=System Severity=Error SymbolicName=STATUS_INVALID_VOLUME_LABEL
Language=English
An invalid volume label has been specified
.


MessageId=0x0087 Facility=System Severity=Error SymbolicName=STATUS_SECTION_NOT_EXTENDED
Language=English
A mapped section could not be extended.
.


MessageId=0x0088 Facility=System Severity=Error SymbolicName=STATUS_NOT_MAPPED_DATA
Language=English
Specified section to flush does not map a data file.
.


MessageId=0x0089 Facility=System Severity=Error SymbolicName=STATUS_RESOURCE_DATA_NOT_FOUND
Language=English
Indicates the specified image file did not contain a resource
section.
.


MessageId=0x008A Facility=System Severity=Error SymbolicName=STATUS_RESOURCE_TYPE_NOT_FOUND
Language=English
Indicates the specified resource type can not be found in the
image file.
.


MessageId=0x008B Facility=System Severity=Error SymbolicName=STATUS_RESOURCE_NAME_NOT_FOUND
Language=English
Indicates the specified resource name can not be found in the
image file.
.


MessageId=0x008C Facility=System Severity=Error SymbolicName=STATUS_ARRAY_BOUNDS_EXCEEDED ;// winnt
Language=English
{EXCEPTION}
Array bounds exceeded.
.


MessageId=0x008D Facility=System Severity=Error SymbolicName=STATUS_FLOAT_DENORMAL_OPERAND ;// winnt
Language=English
{EXCEPTION}
Floating-point denormal operand.
.


MessageId=0x008E Facility=System Severity=Error SymbolicName=STATUS_FLOAT_DIVIDE_BY_ZERO  ;// winnt
Language=English
{EXCEPTION}
Floating-point division by zero.
.


MessageId=0x008F Facility=System Severity=Error SymbolicName=STATUS_FLOAT_INEXACT_RESULT  ;// winnt
Language=English
{EXCEPTION}
Floating-point inexact result.
.


MessageId=0x0090 Facility=System Severity=Error SymbolicName=STATUS_FLOAT_INVALID_OPERATION ;// winnt
Language=English
{EXCEPTION}
Floating-point invalid operation.
.


MessageId=0x0091 Facility=System Severity=Error SymbolicName=STATUS_FLOAT_OVERFLOW          ;// winnt
Language=English
{EXCEPTION}
Floating-point overflow.
.


MessageId=0x0092 Facility=System Severity=Error SymbolicName=STATUS_FLOAT_STACK_CHECK       ;// winnt
Language=English
{EXCEPTION}
Floating-point stack check.
.


MessageId=0x0093 Facility=System Severity=Error SymbolicName=STATUS_FLOAT_UNDERFLOW         ;// winnt
Language=English
{EXCEPTION}
Floating-point underflow.
.


MessageId=0x0094 Facility=System Severity=Error SymbolicName=STATUS_INTEGER_DIVIDE_BY_ZERO  ;// winnt
Language=English
{EXCEPTION}
Integer division by zero.
.


MessageId=0x0095 Facility=System Severity=Error SymbolicName=STATUS_INTEGER_OVERFLOW        ;// winnt
Language=English
{EXCEPTION}
Integer overflow.
.


MessageId=0x0096 Facility=System Severity=Error SymbolicName=STATUS_PRIVILEGED_INSTRUCTION  ;// winnt
Language=English
{EXCEPTION}
Privileged instruction.
.


MessageId=0x0097 Facility=System Severity=Error SymbolicName=STATUS_TOO_MANY_PAGING_FILES
Language=English
An attempt was made to install more paging files than the
system supports.
.


MessageId=0x0098 Facility=System Severity=Error SymbolicName=STATUS_FILE_INVALID
Language=English
The volume for a file has been externally altered such that the
opened file is no longer valid.
.


MessageId=0x0099 Facility=System Severity=Error SymbolicName=STATUS_ALLOTTED_SPACE_EXCEEDED
Language=English
When a block of memory is allotted for future updates, such as the memory
allocated to hold discretionary access control and primary group information,
successive updates may exceed the amount of memory originally allotted.
Since quota may already have been charged to several processes which have
handles to the object, it is not reasonable to alter the size of the
allocated memory.  Instead, a request that requires more memory than has
been allotted must fail and the STATUS_ALLOTED_SPACE_EXCEEDED error returned.
.


MessageId=0x009A Facility=System Severity=Error SymbolicName=STATUS_INSUFFICIENT_RESOURCES
Language=English
Insufficient system resources exist to complete the API
.


MessageId=0x009B Facility=System Severity=Error SymbolicName=STATUS_DFS_EXIT_PATH_FOUND
Language=English
An attempt has been made to open a DFS exit path control file
.


MessageId=0x009C Facility=System Severity=Error SymbolicName=STATUS_DEVICE_DATA_ERROR
Language=English
.


MessageId=0x009D Facility=System Severity=Error SymbolicName=STATUS_DEVICE_NOT_CONNECTED
Language=English
.


MessageId=0x009E Facility=System Severity=Error SymbolicName=STATUS_DEVICE_POWER_FAILURE
Language=English
.


MessageId=0x009F Facility=System Severity=Error SymbolicName=STATUS_FREE_VM_NOT_AT_BASE
Language=English
Virtual memory cannot be freed as base address is not the base
of the region and a region size of zero was specified.
.


MessageId=0x00A0 Facility=System Severity=Error SymbolicName=STATUS_MEMORY_NOT_ALLOCATED
Language=English
An attempt was made to free virtual memory which is not allocated.
.


MessageId=0x00A1 Facility=System Severity=Error SymbolicName=STATUS_WORKING_SET_QUOTA
Language=English
The working set is not big enough to allow the requested pages to be
locked.
.


MessageId=0x00A2 Facility=System Severity=Error SymbolicName=STATUS_MEDIA_WRITE_PROTECTED
Language=English
{Write Protect Error}
The disk cannot be written to because it is write protected.
Please remove the write protection from the volume %s in drive %s.
.


MessageId=0x00A3 Facility=System Severity=Error SymbolicName=STATUS_DEVICE_NOT_READY
Language=English
{Drive Not Ready}
The drive is not ready for use; its door may be open.
Please check drive %s and make sure that a disk is inserted
and that the drive door is closed.
.


MessageId=0x00A4 Facility=System Severity=Error SymbolicName=STATUS_INVALID_GROUP_ATTRIBUTES
Language=English
The specified attributes are invalid, or incompatible with the
attributes for the group as a whole.
.


MessageId=0x00A5 Facility=System Severity=Error SymbolicName=STATUS_BAD_IMPERSONATION_LEVEL
Language=English
A specified impersonation level is invalid.
Also used to indicate a required impersonation level was not provided.
.


MessageId=0x00A6 Facility=System Severity=Error SymbolicName=STATUS_CANT_OPEN_ANONYMOUS
Language=English
An attempt was made to open an Anonymous level token.
Anonymous tokens may not be opened.
.


MessageId=0x00A7 Facility=System Severity=Error SymbolicName=STATUS_BAD_VALIDATION_CLASS
Language=English
The validation information class requested was invalid.
.


MessageId=0x00A8 Facility=System Severity=Error SymbolicName=STATUS_BAD_TOKEN_TYPE
Language=English
The type of a token object is inappropriate for its attempted use.
.


MessageId=0x00A9 Facility=System Severity=Error SymbolicName=STATUS_BAD_MASTER_BOOT_RECORD
Language=English
The type of a token object is inappropriate for its attempted use.
.


MessageId=0x00AA Facility=System Severity=Error SymbolicName=STATUS_INSTRUCTION_MISALIGNMENT
Language=English
An attempt was made to execute an instruction at an unaligned address
and the host system does not support unaligned instruction references.
.


MessageId=0x00AB Facility=System Severity=Error SymbolicName=STATUS_INSTANCE_NOT_AVAILABLE
Language=English
The maximum named pipe instance count has been reached
.


MessageId=0x00AC Facility=System Severity=Error SymbolicName=STATUS_PIPE_NOT_AVAILABLE
Language=English
An instance of a named pipe cannot be found in the listening state
.


MessageId=0x00AD Facility=System Severity=Error SymbolicName=STATUS_INVALID_PIPE_STATE
Language=English
The named pipe is not in the connected or closing state
.


MessageId=0x00AE Facility=System Severity=Error SymbolicName=STATUS_PIPE_BUSY
Language=English
The specified pipe is set to complete operations and there are current
I/O operations queued so it cannot be changed to queue operations.
.


MessageId=0x00AF Facility=System Severity=Error SymbolicName=STATUS_ILLEGAL_FUNCTION
Language=English
The specified handle is not open to the server end of the named pipe
.


MessageId=0x00B0 Facility=System Severity=Error SymbolicName=STATUS_PIPE_DISCONNECTED
Language=English
The specified named pipe is in the disconnected state
.


MessageId=0x00B1 Facility=System Severity=Error SymbolicName=STATUS_PIPE_CLOSING
Language=English
The specified named pipe is in the closing state
.


MessageId=0x00B2 Facility=System Severity=Error SymbolicName=STATUS_PIPE_CONNECTED
Language=English
The specified named pipe is in the connected state
.


MessageId=0x00B3 Facility=System Severity=Error SymbolicName=STATUS_PIPE_LISTENING
Language=English
The specified named pipe is in the listening state
.


MessageId=0x00B4 Facility=System Severity=Error SymbolicName=STATUS_INVALID_READ_MODE
Language=English
The specified named pipe is not in message mode
.


MessageId=0x00B5 Facility=System Severity=Error SymbolicName=STATUS_IO_TIMEOUT
Language=English
{Device Timeout}
The specified I/O operation on %s was not completed before the time-out
period expired.
.


MessageId=0x00B6 Facility=System Severity=Error SymbolicName=STATUS_FILE_FORCED_CLOSED
Language=English
The specified file has been closed by another process
.


MessageId=0x00B7 Facility=System Severity=Error SymbolicName=STATUS_PROFILING_NOT_STARTED
Language=English
Profiling not started.
.


MessageId=0x00B8 Facility=System Severity=Error SymbolicName=STATUS_PROFILING_NOT_STOPPED
Language=English
Profiling not stopped.
.


MessageId=0x00B9 Facility=System Severity=Error SymbolicName=STATUS_COULD_NOT_INTERPRET
Language=English
The passed ACL did not contain the minimum required information
.


MessageId=0x00BA Facility=System Severity=Error SymbolicName=STATUS_FILE_IS_A_DIRECTORY
Language=English
The file that was specified as a target is a directory and the caller
specified that it could be anything but a directory.
.



;//
;// Network specific errors.
;//
;//

MessageId=0x00BB Facility=System Severity=Error SymbolicName=STATUS_NOT_SUPPORTED
Language=English
The network request is not supported.
.


MessageId=0x00BC Facility=System Severity=Error SymbolicName=STATUS_REMOTE_NOT_LISTENING
Language=English
This remote computer is not listening.
.


MessageId=0x00BD Facility=System Severity=Error SymbolicName=STATUS_DUPLICATE_NAME
Language=English
A duplicate name exists on the network.
.


MessageId=0x00BE Facility=System Severity=Error SymbolicName=STATUS_BAD_NETWORK_PATH
Language=English
The network path cannot be located.
.


MessageId=0x00BF Facility=System Severity=Error SymbolicName=STATUS_NETWORK_BUSY
Language=English
The network is busy.
.


MessageId=0x00C0 Facility=System Severity=Error SymbolicName=STATUS_DEVICE_DOES_NOT_EXIST
Language=English
This device does not exist.
.


MessageId=0x00C1 Facility=System Severity=Error SymbolicName=STATUS_TOO_MANY_COMMANDS
Language=English
The network BIOS command limit has been reached.
.


MessageId=0x00C2 Facility=System Severity=Error SymbolicName=STATUS_ADAPTER_HARDWARE_ERROR
Language=English
An I/O adapter hardware error has occurred.
.


MessageId=0x00C3 Facility=System Severity=Error SymbolicName=STATUS_INVALID_NETWORK_RESPONSE
Language=English
The network responded incorrectly.
.


MessageId=0x00C4 Facility=System Severity=Error SymbolicName=STATUS_UNEXPECTED_NETWORK_ERROR
Language=English
An unexpected network error occurred.
.


MessageId=0x00C5 Facility=System Severity=Error SymbolicName=STATUS_BAD_REMOTE_ADAPTER
Language=English
The remote adapter is not compatible.
.


MessageId=0x00C6 Facility=System Severity=Error SymbolicName=STATUS_PRINT_QUEUE_FULL
Language=English
The printer queue is full.
.


MessageId=0x00C7 Facility=System Severity=Error SymbolicName=STATUS_NO_SPOOL_SPACE
Language=English
Space to store the file waiting to be printed is not available on the server.
.


MessageId=0x00C8 Facility=System Severity=Error SymbolicName=STATUS_PRINT_CANCELLED
Language=English
The requested print file has been canceled.
.


MessageId=0x00C9 Facility=System Severity=Error SymbolicName=STATUS_NETWORK_NAME_DELETED
Language=English
The network name was deleted.
.


MessageId=0x00CA Facility=System Severity=Error SymbolicName=STATUS_NETWORK_ACCESS_DENIED
Language=English
Network access is denied.
.


MessageId=0x00CB Facility=System Severity=Error SymbolicName=STATUS_BAD_DEVICE_TYPE
Language=English
{Incorrect Network Resource Type}
The specified device type (LPT, for example) conflicts with the actual
device type on the remote resource.
.


MessageId=0x00CC Facility=System Severity=Error SymbolicName=STATUS_BAD_NETWORK_NAME
Language=English
{Network Name Not Found}
The specified share name cannot be found on the remote server.
.


MessageId=0x00CD Facility=System Severity=Error SymbolicName=STATUS_TOO_MANY_NAMES
Language=English
The name limit for the local computer network adapter card was exceeded.
.


MessageId=0x00CE Facility=System Severity=Error SymbolicName=STATUS_TOO_MANY_SESSIONS
Language=English
The network BIOS session limit was exceeded.
.


MessageId=0x00CF Facility=System Severity=Error SymbolicName=STATUS_SHARING_PAUSED
Language=English
File sharing has been temporarily paused.
.


MessageId=0x00D0 Facility=System Severity=Error SymbolicName=STATUS_REQUEST_NOT_ACCEPTED
Language=English
No more connections can be made to this remote computer at this time
because there are already as many connections as the computer can accept.
.


MessageId=0x00D1 Facility=System Severity=Error SymbolicName=STATUS_REDIRECTOR_PAUSED
Language=English
Print or disk redirection is temporarily paused.
.


MessageId=0x00D2 Facility=System Severity=Error SymbolicName=STATUS_NET_WRITE_FAULT
Language=English
A network data fault occurred.
.


MessageId=0x00D3 Facility=System Severity=Error SymbolicName=STATUS_PROFILING_AT_LIMIT
Language=English
The number of active profiling objects is at the maximum and no more may be started.
.


MessageId=0x00D4 Facility=System Severity=Error SymbolicName=STATUS_NOT_SAME_DEVICE
Language=English
{Incorrect Volume}
The target file of a rename request is located on a different device
than the source of the rename request.
.


MessageId=0x00D5 Facility=System Severity=Error SymbolicName=STATUS_FILE_RENAMED
Language=English
The file specified has been renamed and thus cannot be modified.
.


MessageId=0x00D6 Facility=System Severity=Error SymbolicName=STATUS_VIRTUAL_CIRCUIT_CLOSED
Language=English
{Network Request Timeout}
The session with a remote server has been disconnected because the time-out
interval for a request has expired.
.


MessageId=0x00D7 Facility=System Severity=Error SymbolicName=STATUS_NO_SECURITY_ON_OBJECT
Language=English
Indicates an attempt was made to operate on the security of
an object that does not have security associated with it.
.


MessageId=0x00D8 Facility=System Severity=Error SymbolicName=STATUS_CANT_WAIT
Language=English
Used to indicate that an operation cannot continue without blocking
for I/O
.


MessageId=0x00D9 Facility=System Severity=Error SymbolicName=STATUS_PIPE_EMPTY
Language=English
Used to indicate that a read operation was done on an empty pipe.
.


MessageId=0x00DA Facility=System Severity=Error SymbolicName=STATUS_CANT_ACCESS_DOMAIN_INFO
Language=English
Indicates a Windows NT Server could not be contacted or that
objects within the domain are protected such that necessary
information could not be retrieved.
.


MessageId=0x00DB Facility=System Severity=Error SymbolicName=STATUS_CANT_TERMINATE_SELF
Language=English
Indicates that a thread attempted to terminate itself by default
(called NtTerminateThread with NULL) and it was the last thread
in the current process.
.


MessageId=0x00DC Facility=System Severity=Error SymbolicName=STATUS_INVALID_SERVER_STATE
Language=English
Indicates the Sam Server was in the wrong state to
perform the desired operation.
.


MessageId=0x00DD Facility=System Severity=Error SymbolicName=STATUS_INVALID_DOMAIN_STATE
Language=English
Indicates the Domain was in the wrong state to
perform the desired operation.
.


MessageId=0x00DE Facility=System Severity=Error SymbolicName=STATUS_INVALID_DOMAIN_ROLE
Language=English
This operation is only allowed for the Primary Domain Controller of the domain.
.


MessageId=0x00DF Facility=System Severity=Error SymbolicName=STATUS_NO_SUCH_DOMAIN
Language=English
The specified Domain did not exist.
.


MessageId=0x00E0 Facility=System Severity=Error SymbolicName=STATUS_DOMAIN_EXISTS
Language=English
The specified Domain already exists.
.


MessageId=0x00E1 Facility=System Severity=Error SymbolicName=STATUS_DOMAIN_LIMIT_EXCEEDED
Language=English
An attempt to exceed the limit on the number of domains per server
for this release.
.


MessageId=0x00E2 Facility=System Severity=Error SymbolicName=STATUS_OPLOCK_NOT_GRANTED
Language=English
 Error status returned when oplock request is denied
.


MessageId=0x00E3 Facility=System Severity=Error SymbolicName=STATUS_INVALID_OPLOCK_PROTOCOL
Language=English
 Error status returned when an invalid oplock acknowledgment
 is received by a file system
.


MessageId=0x00E4 Facility=System Severity=Error SymbolicName=STATUS_INTERNAL_DB_CORRUPTION
Language=English
This error indicates that the requested operation cannot be
completed due to a catastrophic media failure or on-disk data
structure corruption
.


MessageId=0x00E5 Facility=System Severity=Error SymbolicName=STATUS_INTERNAL_ERROR
Language=English
This error indicates that the SAM server has encountered an
internal consistency error in its database.  This catastrophic
failure will prevent further operation of SAM
.


MessageId=0x00E6 Facility=System Severity=Error SymbolicName=STATUS_GENERIC_NOT_MAPPED
Language=English
Indicates generic access types were contained in an access mask
which should already be mapped to non-generic access types.
.


MessageId=0x00E7 Facility=System Severity=Error SymbolicName=STATUS_BAD_DESCRIPTOR_FORMAT
Language=English
Indicates a security descriptor is not in the necessary format (absolute
or self-relative).
.


;//
;// Status codes raised by the Cache Manager which must be considered as
;// "expected" by its callers.
;//


MessageId=0x00E8 Facility=System Severity=Error SymbolicName=STATUS_INVALID_USER_BUFFER
Language=English
An access to a user buffer failed at an "expected" point in time.
This code is defined since the caller does not want to accept
STATUS_ACCESS_VIOLATION in its filter.
.


MessageId=0x00E9 Facility=System Severity=Error SymbolicName=STATUS_UNEXPECTED_IO_ERROR
Language=English
If an I/O error is returned which is not defined in the standard FsRtl filter,
it is converted to the following error which is guaranteed to be in the
filter.  In this case information is lost, however, the filter correctly
handles the exception.
.


MessageId=0x00EA Facility=System Severity=Error SymbolicName=STATUS_UNEXPECTED_MM_CREATE_ERR
Language=English
If an MM error is returned which is not defined in the standard FsRtl filter,
it is converted to one of the following errors which is guaranteed to be in the
filter.  In this case information is lost, however, the filter correctly
handles the exception.
.


MessageId=0x00EB Facility=System Severity=Error SymbolicName=STATUS_UNEXPECTED_MM_MAP_ERROR
Language=English
If an MM error is returned which is not defined in the standard FsRtl filter,
it is converted to one of the following errors which is guaranteed to be in the
filter.  In this case information is lost, however, the filter correctly
handles the exception.
.


MessageId=0x00EC Facility=System Severity=Error SymbolicName=STATUS_UNEXPECTED_MM_EXTEND_ERR
Language=English
If an MM error is returned which is not defined in the standard FsRtl filter,
it is converted to one of the following errors which is guaranteed to be in the
filter.  In this case information is lost, however, the filter correctly
handles the exception.
.


MessageId=0x00ED Facility=System Severity=Error SymbolicName=STATUS_NOT_LOGON_PROCESS
Language=English
The requested action is restricted for use by logon processes
only.  The calling process has not registered as a logon process.
.


MessageId=0x00EE Facility=System Severity=Error SymbolicName=STATUS_LOGON_SESSION_EXISTS
Language=English
A attempt has been made to start a new session manager or
LSA logon session with an ID that is already in use.
.


MessageId=0x00EF Facility=System Severity=Error SymbolicName=STATUS_INVALID_PARAMETER_1
Language=English
An invalid parameter was passed to the a service or function as
the first argument
.


MessageId=0x00F0 Facility=System Severity=Error SymbolicName=STATUS_INVALID_PARAMETER_2
Language=English
An invalid parameter was passed to the a service or function as
the second argument
.


MessageId=0x00F1 Facility=System Severity=Error SymbolicName=STATUS_INVALID_PARAMETER_3
Language=English
An invalid parameter was passed to the a service or function as
the third argument
.


MessageId=0x00F2 Facility=System Severity=Error SymbolicName=STATUS_INVALID_PARAMETER_4
Language=English
An invalid parameter was passed to the a service or function as
the fourth argument
.


MessageId=0x00F3 Facility=System Severity=Error SymbolicName=STATUS_INVALID_PARAMETER_5
Language=English
An invalid parameter was passed to the a service or function as
the fifth argument
.


MessageId=0x00F4 Facility=System Severity=Error SymbolicName=STATUS_INVALID_PARAMETER_6
Language=English
An invalid parameter was passed to the a service or function as
the sixth argument
.


MessageId=0x00F5 Facility=System Severity=Error SymbolicName=STATUS_INVALID_PARAMETER_7
Language=English
An invalid parameter was passed to the a service or function as
the seventh argument
.


MessageId=0x00F6 Facility=System Severity=Error SymbolicName=STATUS_INVALID_PARAMETER_8
Language=English
An invalid parameter was passed to the a service or function as
the eighth argument
.


MessageId=0x00F7 Facility=System Severity=Error SymbolicName=STATUS_INVALID_PARAMETER_9
Language=English
An invalid parameter was passed to the a service or function as
the ninth argument
.


MessageId=0x00F8 Facility=System Severity=Error SymbolicName=STATUS_INVALID_PARAMETER_10
Language=English
An invalid parameter was passed to the a service or function as
the tenth argument
.


MessageId=0x00F9 Facility=System Severity=Error SymbolicName=STATUS_INVALID_PARAMETER_11
Language=English
An invalid parameter was passed to the a service or function as
the eleventh argument
.


MessageId=0x00FA Facility=System Severity=Error SymbolicName=STATUS_INVALID_PARAMETER_12
Language=English
An invalid parameter was passed to the a service or function as
the twelfth argument
.


MessageId=0x00FB Facility=System Severity=Error SymbolicName=STATUS_REDIRECTOR_NOT_STARTED
Language=English
 An attempt was made to access a network file, but the network software
 was not yet started.
.


MessageId=0x00FC Facility=System Severity=Error SymbolicName=STATUS_REDIRECTOR_STARTED
Language=English
 An attempt was made to start the redirector, but the redirector
 has already been started.
.


MessageId=0x00FD Facility=System Severity=Error SymbolicName=STATUS_STACK_OVERFLOW ;// winnt
Language=English
A new guard page for the stack cannot be created.
.


MessageId=0x00FE Facility=System Severity=Error SymbolicName=STATUS_NO_SUCH_PACKAGE
Language=English
A specified authentication package is unknown
.


MessageId=0x00FF Facility=System Severity=Error SymbolicName=STATUS_BAD_FUNCTION_TABLE
Language=English
A malformed function table was encountered during an unwind operation.
.


MessageId=0x0100 Facility=System Severity=Error SymbolicName=STATUS_VARIABLE_NOT_FOUND
Language=English
Indicates the specified environment variable name was not found
in the specified environment block.
.


MessageId=0x0101 Facility=System Severity=Error SymbolicName=STATUS_DIRECTORY_NOT_EMPTY
Language=English
Indicates that the directory trying to be deleted is not empty
.


MessageId=0x0102 Facility=System Severity=Error SymbolicName=STATUS_FILE_CORRUPT_ERROR
Language=English
{Corrupt File}
The file or directory %s is corrupt and unreadable.
Please run the Chkdsk utility.
.


MessageId=0x0103 Facility=System Severity=Error SymbolicName=STATUS_NOT_A_DIRECTORY
Language=English
A requested opened file is not a directory
.


MessageId=0x0104 Facility=System Severity=Error SymbolicName=STATUS_BAD_LOGON_SESSION_STATE
Language=English
The logon session is not in a state that is consistent with the
requested operation.
.


MessageId=0x0105 Facility=System Severity=Error SymbolicName=STATUS_LOGON_SESSION_COLLISION
Language=English
An internal LSA error has occurred.  An authentication package has
requested the creation of a Logon Session but the ID of an already
existing Logon Session has been specified.
.


MessageId=0x0106 Facility=System Severity=Error SymbolicName=STATUS_NAME_TOO_LONG
Language=English
A specified name string is too long for its intended use.
.


MessageId=0x0107 Facility=System Severity=Error SymbolicName=STATUS_FILES_OPEN
Language=English
The user attempted to force close the files on a redirected
drive, but there were opened files on the drive, and the user
did not specify a sufficient level of force.
.


MessageId=0x0108 Facility=System Severity=Error SymbolicName=STATUS_CONNECTION_IN_USE
Language=English
The user attempted to force close the files on a redirected
drive, but there were opened directories on the drive, and the user
did not specify a sufficient level of force.
.


MessageId=0x0109 Facility=System Severity=Error SymbolicName=STATUS_MESSAGE_NOT_FOUND
Language=English
RtlFindMessage could not locate the requested message Id in the
message table resource.
.


MessageId=0x010A Facility=System Severity=Error SymbolicName=STATUS_PROCESS_IS_TERMINATING
Language=English
An attempt was made to duplicate an object handle into or out
of an exiting process
.


MessageId=0x010B Facility=System Severity=Error SymbolicName=STATUS_INVALID_LOGON_TYPE
Language=English
Indicates an invalid value has been provided for LogonType has been
requested.
.


MessageId=0x010C Facility=System Severity=Error SymbolicName=STATUS_NO_GUID_TRANSLATION
Language=English
Indicates that an attempt was made to assign protection to an HPFS
file system file or directory and one of the SIDs in the security
descriptor could not be translated into a GUID that could be stored
in HPFS.
This causes the protection attempt to fail, which may cause a file
creation attempt to fail.
.


MessageId=0x010D Facility=System Severity=Error SymbolicName=STATUS_CANNOT_IMPERSONATE
Language=English
Indicates that an attempt has been made to impersonate via a named
pipe that has not yet been read from.
.


MessageId=0x010E Facility=System Severity=Error SymbolicName=STATUS_IMAGE_ALREADY_LOADED
Language=English
Indicates that the specified image is already loaded.
.


;
;//
;// ============================================================
;// NOTE: The following ABIOS error code should be reserved on
;//       non ABIOS kernel.  Eventually, I will remove the ifdef
;//       ABIOS.
;// ============================================================
;//


MessageId=0x010F Facility=System Severity=Error SymbolicName=STATUS_ABIOS_NOT_PRESENT
Language=English
.

MessageId=0x0110 Facility=System Severity=Error SymbolicName=STATUS_ABIOS_LID_NOT_EXIST
Language=English
.


MessageId=0x0111 Facility=System Severity=Error SymbolicName=STATUS_ABIOS_LID_ALREADY_OWNED
Language=English
.


MessageId=0x0112 Facility=System Severity=Error SymbolicName=STATUS_ABIOS_NOT_LID_OWNER
Language=English
.


MessageId=0x0113 Facility=System Severity=Error SymbolicName=STATUS_ABIOS_INVALID_COMMAND
Language=English
.


MessageId=0x0114 Facility=System Severity=Error SymbolicName=STATUS_ABIOS_INVALID_LID
Language=English
.


MessageId=0x0115 Facility=System Severity=Error SymbolicName=STATUS_ABIOS_SELECTOR_NOT_AVAILABLE
Language=English
.


MessageId=0x0116 Facility=System Severity=Error SymbolicName=STATUS_ABIOS_INVALID_SELECTOR
Language=English
.


MessageId=0x0117 Facility=System Severity=Error SymbolicName=STATUS_NO_LDT
Language=English
Indicates that an attempt was made to change the size of the LDT for
a process that has no LDT
.


MessageId=0x0118 Facility=System Severity=Error SymbolicName=STATUS_INVALID_LDT_SIZE
Language=English
Indicates that an attempt was made to grow an LDT by setting its size,
or that the size was not an even number of selectors
.


MessageId=0x0119 Facility=System Severity=Error SymbolicName=STATUS_INVALID_LDT_OFFSET
Language=English
Indicates that the starting value for the LDT information was not
an integral multiple of the selector size
.


MessageId=0x011A Facility=System Severity=Error SymbolicName=STATUS_INVALID_LDT_DESCRIPTOR
Language=English
Indicates that the user supplied an invalid descriptor when trying
to set up Ldt descriptors
.


MessageId=0x011B Facility=System Severity=Error SymbolicName=STATUS_INVALID_IMAGE_NE_FORMAT
Language=English
The specified image file did not have the correct format, it
appears to be NE format.
.




MessageId=0x011C Facility=System Severity=Error SymbolicName=STATUS_RXACT_INVALID_STATE
Language=English
Indicates that the transaction state of a registry sub-tree is
incompatible with the requested operation.
For example, a request has been made to start a new transaction with
one already in progress, or a request to apply a transaction when one
is not currently in progress.
This status value is returned by the runtime library (RTL) registry
transaction package (RXact).
.



MessageId=0x011D Facility=System Severity=Error SymbolicName=STATUS_RXACT_COMMIT_FAILURE
Language=English
Indicates an error has occurred during a registry transaction commit.
The database has been left in an unknown, but probably inconsistent,
state.  The state of the registry transaction is left as COMMITTING.
This status value is returned by the runtime library (RTL) registry
transaction package (RXact).
.


MessageId=0x011E Facility=System Severity=Error SymbolicName=STATUS_MAPPED_FILE_SIZE_ZERO
Language=English
An attempt was made to map a file of size zero with the
maximum size specified as zero.
.


MessageId=0x011F Facility=System Severity=Error SymbolicName=STATUS_TOO_MANY_OPENED_FILES
Language=English
Too many files are opened on a remote server.  This error should only
be returned by the NT redirector on a remote drive.
.


MessageId=0x0120 Facility=System Severity=Error SymbolicName=STATUS_CANCELLED
Language=English
The I/O request was canceled.
.


MessageId=0x0121 Facility=System Severity=Error SymbolicName=STATUS_CANNOT_DELETE
Language=English
An attempt has been made to remove a file or directory that cannot
be deleted.
.


MessageId=0x0122 Facility=System Severity=Error SymbolicName=STATUS_INVALID_COMPUTER_NAME
Language=English
Indicates a name specified as a remote computer name is syntactically
invalid.
.


MessageId=0x0123 Facility=System Severity=Error SymbolicName=STATUS_FILE_DELETED
Language=English
An I/O request other than close was performed on a file after it has
been deleted, which can only happen to a request which did not complete
before the last handle was closed via NtClose.
.


MessageId=0x0124 Facility=System Severity=Error SymbolicName=STATUS_SPECIAL_ACCOUNT
Language=English
Indicates an operation has been attempted on a built-in (special)
SAM account which is incompatible with built-in accounts.  For
example, built-in accounts can not be deleted.
.


MessageId=0x0125 Facility=System Severity=Error SymbolicName=STATUS_SPECIAL_GROUP
Language=English
The operation requested may not be performed on the specified
group because it is a built-in special group.
.


MessageId=0x0126 Facility=System Severity=Error SymbolicName=STATUS_SPECIAL_USER
Language=English
The operation requested may not be performed on the specified
user  because it is a built-in special user.
.


MessageId=0x0127 Facility=System Severity=Error SymbolicName=STATUS_MEMBERS_PRIMARY_GROUP
Language=English
Indicates a member can not be removed from a group because the
group is currently the member's primary group.
.


MessageId=0x0128 Facility=System Severity=Error SymbolicName=STATUS_FILE_CLOSED
Language=English
An I/O request other than close and several other special case
operations was attempted using a file object that had already been
closed.
.


MessageId=0x0129 Facility=System Severity=Error SymbolicName=STATUS_TOO_MANY_THREADS
Language=English
Indicates a process has too many threads to perform the requested
action.  For example, assignment of a primary token may only be
performed when a process has zero or one threads.
.


MessageId=0x012A Facility=System Severity=Error SymbolicName=STATUS_THREAD_NOT_IN_PROCESS
Language=English
An attempt was made to operate on a thread within a specific process,
but the thread specified is not in the process specified.
.


MessageId=0x012B Facility=System Severity=Error SymbolicName=STATUS_TOKEN_ALREADY_IN_USE
Language=English
An attempt was made to establish a token for use as a primary token
but the token is already in use.  A token can only be the primary token
of one process at a time.
.

MessageId=0x012C Facility=System Severity=Error SymbolicName=STATUS_PAGEFILE_QUOTA_EXCEEDED
Language=English
Page file quota was exceeded.
.


MessageId=0x012D Facility=System Severity=Error SymbolicName=STATUS_COMMITMENT_LIMIT
Language=English
{Out of Virtual Memory}
Your system is running low on virtual memory.  Please close some
applications.  You can then start the System option in the Control Panel
and choose the Virtual Memory button to create an additional paging file
or to increase the size of your current paging file.
.


MessageId=0x012E Facility=System Severity=Error SymbolicName=STATUS_INVALID_IMAGE_LE_FORMAT
Language=English
The specified image file did not have the correct format, it
appears to be LE format.
.


MessageId=0x012F Facility=System Severity=Error SymbolicName=STATUS_INVALID_IMAGE_NOT_MZ
Language=English
The specified image file did not have the correct format, it
did not have an initial MZ.
.


MessageId=0x0130 Facility=System Severity=Error SymbolicName=STATUS_INVALID_IMAGE_PROTECT
Language=English
The specified image file did not have the correct format, it
did not have a proper e_lfarlc in the MZ header.
.


MessageId=0x0131 Facility=System Severity=Error SymbolicName=STATUS_INVALID_IMAGE_WIN_16
Language=English
The specified image file did not have the correct format, it
looks like a 16-bit windows image.
.


MessageId=0x0132 Facility=System Severity=Error SymbolicName=STATUS_LOGON_SERVER_CONFLICT
Language=English
The Netlogon service cannot start because another Netlogon service running
in the domain conflicts with the specified role.
.


MessageId=0x0133 Facility=System Severity=Error SymbolicName=STATUS_TIME_DIFFERENCE_AT_DC
Language=English
The time at the Primary Domain Controller is different then the
time at the Backup Domain Controller or member server by too large
an amount.
.


MessageId=0x0134 Facility=System Severity=Error SymbolicName=STATUS_SYNCHRONIZATION_REQUIRED
Language=English
The SAM database on a Windows NT Server is
significantly out of synchronization with the copy on the Domain
Controller.  A complete synchronization is required.
.

MessageId=0x0135 Facility=System Severity=Error SymbolicName=STATUS_DLL_NOT_FOUND
Language=English
{Unable To Locate DLL}
The dynamic link library %s could not be found in the specified path %s.
.

MessageId=0x0136 Facility=System Severity=Error SymbolicName=STATUS_OPEN_FAILED
Language=English
The NtCreateFile API failed.  This error should never be returned to an
application, it is a place holder for the NT Lan Manager Redirector to
use in its internal error mapping routines.
.

MessageId=0x0137 Facility=System Severity=Error SymbolicName=STATUS_IO_PRIVILEGE_FAILED
Language=English
{Privilege Failed}
The I/O permissions for the process could not be changed.
.

MessageId=0x0138 Facility=System Severity=Error SymbolicName=STATUS_ORDINAL_NOT_FOUND
Language=English
{Ordinal Not Found}
The ordinal %ld could not be located in the dynamic link library %s.
.

MessageId=0x0139 Facility=System Severity=Error SymbolicName=STATUS_ENTRYPOINT_NOT_FOUND
Language=English
{Entry Point Not Found}
The procedure entry point %s could not be located in the dynamic link library %s.
.

MessageId=0x013A Facility=System Severity=Error SymbolicName=STATUS_CONTROL_C_EXIT ;// winnt
Language=English
{Application Exit by CTRL+C}
The application terminated as a result of a CTRL+C.
.

MessageId=0x013B Facility=System Severity=Error SymbolicName=STATUS_LOCAL_DISCONNECT
Language=English
{Virtual Circuit Closed}
The network transport on your computer has closed a network
connection. There may or may not be I/O requests outstanding.
.


MessageId=0x013C Facility=System Severity=Error SymbolicName=STATUS_REMOTE_DISCONNECT
Language=English
{Virtual Circuit Closed}
The network transport on a remote computer has closed a network
connection. There may or may not be I/O requests outstanding.
.


MessageId=0x013D Facility=System Severity=Error SymbolicName=STATUS_REMOTE_RESOURCES
Language=English
{Insufficient Resources on Remote Computer}
The remote computer has insufficient resources to complete the
network request. For instance, there may not be enough memory
available on the remote computer to carry out the request at
this time.
.


MessageId=0x013E Facility=System Severity=Error SymbolicName=STATUS_LINK_FAILED
Language=English
{Virtual Circuit Closed}
An existing connection (virtual circuit) has been broken at the
remote computer. There is probably something wrong with the
network software protocol or the network hardware on the
remote computer.
.


MessageId=0x013F Facility=System Severity=Error SymbolicName=STATUS_LINK_TIMEOUT
Language=English
{Virtual Circuit Closed}
The network transport on your computer has closed a network
connection because it had to wait too long for a response
from the remote computer.
.


MessageId=0x0140 Facility=System Severity=Error SymbolicName=STATUS_INVALID_CONNECTION
Language=English
The connection handle given to the transport was invalid.
.


MessageId=0x0141 Facility=System Severity=Error SymbolicName=STATUS_INVALID_ADDRESS
Language=English
The address handle given to the transport was invalid.
.

MessageId=0x0142 Facility=System Severity=Error SymbolicName=STATUS_DLL_INIT_FAILED
Language=English
{DLL Initialization Failed}
Initialization of the dynamic link library %s failed. The process is
terminating abnormally.
.

MessageId=0x0143 Facility=System Severity=Error SymbolicName=STATUS_MISSING_SYSTEMFILE
Language=English
{Missing System File}
The required system file %s is bad or missing.
.

MessageId=0x0144 Facility=System Severity=Error SymbolicName=STATUS_UNHANDLED_EXCEPTION
Language=English
{Application Error}
The exception %s (0x%08lx) occurred in the application at location 0x%08lx.
.

MessageId=0x0145 Facility=System Severity=Error SymbolicName=STATUS_APP_INIT_FAILURE
Language=English
{Application Error}
The application failed to initialize properly (0x%lx).  Click on OK to
terminate the application.
.

MessageId=0x0146 Facility=System Severity=Error SymbolicName=STATUS_PAGEFILE_CREATE_FAILED
Language=English
{Unable to Create Paging File}
The creation of the paging file %s failed (%lx). The requested size was %ld.
.

MessageId=0x0147 Facility=System Severity=Error SymbolicName=STATUS_NO_PAGEFILE
Language=English
{No Paging File Specified}
No paging file was specified in the system configuration.
.

MessageId=0x0148 Facility=System Severity=Error SymbolicName=STATUS_INVALID_LEVEL
Language=English
{Incorrect System Call Level}
An invalid level was passed into the specified system call.
.

MessageId=0x0149 Facility=System Severity=Error SymbolicName=STATUS_WRONG_PASSWORD_CORE
Language=English
{Incorrect Password to LAN Manager Server}
You specified an incorrect password to a LAN Manager 2.x or MS-NET server.
.

MessageId=0x014A Facility=System Severity=Error SymbolicName=STATUS_ILLEGAL_FLOAT_CONTEXT
Language=English
{EXCEPTION}
A real-mode application issued a floating-point instruction and floating-point
hardware is not present.
.

MessageId=0x014B Facility=System Severity=Error SymbolicName=STATUS_PIPE_BROKEN
Language=English
The pipe operation has failed because the other end of the pipe has been
closed.
.

MessageId=0x014C Facility=System Severity=Error SymbolicName=STATUS_REGISTRY_CORRUPT
Language=English
{The Registry Is Corrupt}
The structure of one of the files that contains Registry data is corrupt, or
the image of the file in memory is corrupt, or the file could not
be recovered because the alternate copy or log was absent or corrupt.
.

MessageId=0x014d Facility=System Severity=Error
SymbolicName=STATUS_REGISTRY_IO_FAILED
Language=English
An I/O operation initiated by the Registry failed unrecoverably.
The Registry could not read in, or write out, or flush, one of the files
that contain the system's image of the Registry.
.

MessageId=0x014e Facility=System Severity=Error
SymbolicName=STATUS_NO_EVENT_PAIR
Language=English
An event pair synchronization operation was performed using the thread
specific client/server event pair object, but no event pair object was
associated with the thread.
.

MessageId=0x014f Facility=System Severity=Error
SymbolicName=STATUS_UNRECOGNIZED_VOLUME
Language=English
The volume does not contain a recognized file system.
Please make sure that all required file system drivers are loaded and that the
volume is not corrupt.
.

MessageId=0x0150 Facility=System Severity=Error
SymbolicName=STATUS_SERIAL_NO_DEVICE_INITED
Language=English
No serial device was successfully initialized.  The serial driver will unload.
.

MessageId=0x0151 Facility=System Severity=Error SymbolicName=STATUS_NO_SUCH_ALIAS
Language=English
The specified local group does not exist.
.


MessageId=0x0152 Facility=System Severity=Error SymbolicName=STATUS_MEMBER_NOT_IN_ALIAS
Language=English
The specified account name is not a member of the local group.
.


MessageId=0x0153 Facility=System Severity=Error SymbolicName=STATUS_MEMBER_IN_ALIAS
Language=English
The specified account name is already a member of the local group.
.

MessageId=0x0154 Facility=System Severity=Error SymbolicName=STATUS_ALIAS_EXISTS
Language=English
The specified local group already exists.
.

MessageId=0x0155 Facility=System Severity=Error SymbolicName=STATUS_LOGON_NOT_GRANTED
Language=English
A requested type of logon (e.g., Interactive, Network, Service) is not
granted by the target system's local security policy.  Please ask the
system administrator to grant the necessary form of logon.
.

MessageId=0x0156 Facility=System Severity=Error SymbolicName=STATUS_TOO_MANY_SECRETS
Language=English
The maximum number of secrets that may be stored in a single system has been
exceeded.  The length and number of secrets is limited to satisfy United
States State Department export restrictions.
.

MessageId=0x0157 Facility=System Severity=Error SymbolicName=STATUS_SECRET_TOO_LONG
Language=English
The length of a secret exceeds the maximum length allowed.  The length and
number of secrets is limited to satisfy United States State Department
export restrictions.
.

MessageId=0x0158 Facility=System Severity=Error SymbolicName=STATUS_INTERNAL_DB_ERROR
Language=English
The Local Security Authority (LSA) database contains in internal inconsistency.
.

MessageId=0x0159 Facility=System Severity=Error SymbolicName=STATUS_FULLSCREEN_MODE
Language=English
The requested operation cannot be performed in fullscreen mode.
.

MessageId=0x015A Facility=System Severity=Error SymbolicName=STATUS_TOO_MANY_CONTEXT_IDS
Language=English
During a logon attempt, the user's security context accumulated too many
security IDs.  This is a very unusual situation.  Remove the user from
some global or local groups to reduce the number of security ids to
incorporate into the security context.
.

MessageId=0x015B Facility=System Severity=Error SymbolicName=STATUS_LOGON_TYPE_NOT_GRANTED
Language=English
A user has requested a type of logon (e.g., interactive or network) that
has not be granted.  An administrator has control over who may logon
interactively and through the network.
.

MessageId=0x015C Facility=System Severity=Error SymbolicName=STATUS_NOT_REGISTRY_FILE
Language=English
The system has attempted to load or restore a file into the registry, and the
specified file is not in the format of a registry file.
.

MessageId=0x015D Facility=System Severity=Error SymbolicName=STATUS_NT_CROSS_ENCRYPTION_REQUIRED
Language=English
An attempt was made to change a user password in the security account manager
without providing the necessary NT cross-encrypted password.
.

MessageId=0x015E Facility=System Severity=Error SymbolicName=STATUS_DOMAIN_CTRLR_CONFIG_ERROR
Language=English
A Windows NT Server has incorrect configuration.
.

MessageId=0x015F Facility=System Severity=Error SymbolicName=STATUS_FT_MISSING_MEMBER
Language=English
An attempt was made to explicitly access the secondary copy of information
via a device control to the Fault Tolerance driver and the secondary copy
is not present in the system.
.

MessageId=0x0160 Facility=System Severity=Error SymbolicName=STATUS_ILL_FORMED_SERVICE_ENTRY
Language=English
A configuration registry node representing a driver service entry was ill-formed
and did not contain required value entries.
.

MessageId=0x0161 Facility=System Severity=Error SymbolicName=STATUS_ILLEGAL_CHARACTER
Language=English
An illegal character was encountered.  For a multi-byte character set this
includes a lead byte without a succeeding trail byte.  For the Unicode character set
this includes the characters 0xFFFF and 0xFFFE.
.

MessageId=0x0162 Facility=System Severity=Error SymbolicName=STATUS_UNMAPPABLE_CHARACTER
Language=English
No mapping for the Unicode character exists in the target multi-byte code page.
.

MessageId=0x0163 Facility=System Severity=Error SymbolicName=STATUS_UNDEFINED_CHARACTER
Language=English
The Unicode character is not defined in the Unicode character set installed on
the system.
.

MessageId=0x0164 Facility=System Severity=Error SymbolicName=STATUS_FLOPPY_VOLUME
Language=English
The paging file cannot be created on a floppy diskette.
.

MessageId=0x0165 Facility=System Severity=ERROR SymbolicName=STATUS_FLOPPY_ID_MARK_NOT_FOUND
Language=English
{Floppy Disk Error}
While accessing a floppy disk, an ID address mark was not found.
.

MessageId=0x0166 Facility=System Severity=ERROR SymbolicName=STATUS_FLOPPY_WRONG_CYLINDER
Language=English
{Floppy Disk Error}
While accessing a floppy disk, the track address from the sector ID field
was found to be different than the track address maintained by the controller.
.

MessageId=0x0167 Facility=System Severity=ERROR SymbolicName=STATUS_FLOPPY_UNKNOWN_ERROR
Language=English
{Floppy Disk Error}
The floppy disk controller reported an error that is not recognized by the
floppy disk driver.
.

MessageId=0x0168 Facility=System Severity=ERROR SymbolicName=STATUS_FLOPPY_BAD_REGISTERS
Language=English
{Floppy Disk Error}
While accessing a floppy-disk, the controller returned inconsistent results
via its registers.
.

MessageId=0x0169 Facility=System Severity=ERROR SymbolicName=STATUS_DISK_RECALIBRATE_FAILED
Language=English
{Hard Disk Error}
While accessing the hard disk, a recalibrate operation failed, even after retries.
.

MessageId=0x016A Facility=System Severity=ERROR SymbolicName=STATUS_DISK_OPERATION_FAILED
Language=English
{Hard Disk Error}
While accessing the hard disk, a disk operation failed even after retries.
.

MessageId=0x016B Facility=System Severity=ERROR SymbolicName=STATUS_DISK_RESET_FAILED
Language=English
{Hard Disk Error}
While accessing the hard disk, a disk controller reset was needed, but even that failed.
.

MessageId=0x016C Facility=System Severity=ERROR SymbolicName=STATUS_SHARED_IRQ_BUSY
Language=English
An attempt was made to open a device that was sharing an IRQ with other devices.
At least one other device that uses that IRQ was already opened.  Two concurrent
opens of devices that share an IRQ and only work via interrupts is not supported
for the particular bus type that the devices use.
.

MessageId=0x016D Facility=System Severity=ERROR SymbolicName=STATUS_FT_ORPHANING
Language=English
{FT Orphaning}
A disk that is part of a fault-tolerant volume can no longer be accessed.
.

MessageId=0x016E Facility=System Severity=ERROR SymbolicName=STATUS_BIOS_FAILED_TO_CONNECT_INTERRUPT
Language=English
The system bios failed to connect a system interrupt to the device or bus for
which the device is connected.
.

MessageId=0x0172 Facility=System Severity=ERROR SymbolicName=STATUS_PARTITION_FAILURE
Language=English
Tape could not be partitioned.
.

MessageId=0x0173 Facility=System Severity=ERROR SymbolicName=STATUS_INVALID_BLOCK_LENGTH
Language=English
When accessing a new tape of a multivolume partition, the current
blocksize is incorrect.
.

MessageId=0x0174 Facility=System Severity=ERROR SymbolicName=STATUS_DEVICE_NOT_PARTITIONED
Language=English
Tape partition information could not be found when loading a tape.
.

MessageId=0x0175 Facility=System Severity=ERROR SymbolicName=STATUS_UNABLE_TO_LOCK_MEDIA
Language=English
Attempt to lock the eject media mechanism fails.
.

MessageId=0x0176 Facility=System Severity=ERROR SymbolicName=STATUS_UNABLE_TO_UNLOAD_MEDIA
Language=English
Unload media fails.
.

MessageId=0x0177 Facility=System Severity=ERROR SymbolicName=STATUS_EOM_OVERFLOW
Language=English
Physical end of tape was detected.
.

MessageId=0x0178 Facility=System Severity=Error SymbolicName=STATUS_NO_MEDIA
Language=English
{No Media}
There is no media in the drive.
Please insert media into drive %s.
.


MessageId=0x017A Facility=System Severity=ERROR SymbolicName=STATUS_NO_SUCH_MEMBER
Language=English
A new member could not be added to a local group because the member does
not exist.
.

MessageId=0x017B Facility=System Severity=ERROR SymbolicName=STATUS_INVALID_MEMBER
Language=English
A new member could not be added to a local group because the member has the
wrong account type.
.

MessageId=0x017C Facility=System Severity=ERROR SymbolicName=STATUS_KEY_DELETED
Language=English
Illegal operation attempted on a registry key which has been marked for deletion.
.

MessageId=0x017D Facility=System Severity=ERROR SymbolicName=STATUS_NO_LOG_SPACE
Language=English
System could not allocate required space in a registry log.
.

MessageId=0x017E Facility=System Severity=ERROR SymbolicName=STATUS_TOO_MANY_SIDS
Language=English
Too many Sids have been specified.
.

MessageId=0x017F Facility=System Severity=Error SymbolicName=STATUS_LM_CROSS_ENCRYPTION_REQUIRED
Language=English
An attempt was made to change a user password in the security account manager
without providing the necessary LM cross-encrypted password.
.

MessageId=0x0180 Facility=System Severity=Error SymbolicName=STATUS_KEY_HAS_CHILDREN
Language=English
An attempt was made to create a symbolic link in a registry key that already
has subkeys or values.
.

MessageId=0x0181 Facility=System Severity=Error SymbolicName=STATUS_CHILD_MUST_BE_VOLATILE
Language=English
An attempt was made to create a Stable subkey under a Volatile parent key.
.

MessageId=0x0182 Facility=System Severity=Error SymbolicName=STATUS_DEVICE_CONFIGURATION_ERROR
Language=English
The I/O device is configured incorrectly or the configuration parameters to the
driver are incorrect.
.

MessageId=0x0183 Facility=System Severity=Error SymbolicName=STATUS_DRIVER_INTERNAL_ERROR
Language=English
An error was detected between two drivers or within an I/O driver.
.

MessageId=0x0184 Facility=System Severity=Error SymbolicName=STATUS_INVALID_DEVICE_STATE
Language=English
The device is not in a valid state to perform this request.
.

MessageId=0x0185 Facility=System Severity=Error SymbolicName=STATUS_IO_DEVICE_ERROR
Language=English
The I/O device reported an I/O error.
.

MessageId=0x0186 Facility=System Severity=Error SymbolicName=STATUS_DEVICE_PROTOCOL_ERROR
Language=English
A protocol error was detected between the driver and the device.
.

MessageId=0x0187 Facility=System Severity=Error SymbolicName=STATUS_BACKUP_CONTROLLER
Language=English
This operation is only allowed for the Primary Domain Controller of the domain.
.

MessageId=0x0188 Facility=System Severity=Error SymbolicName=STATUS_LOG_FILE_FULL
Language=English
Log file space is insufficient to support this operation
.

MessageId=0x0189 Facility=System Severity=Error SymbolicName=STATUS_TOO_LATE
Language=English
A write operation was attempted to a volume after it was shutdown.
.

MessageId=0x018A Facility=System Severity=Error SymbolicName=STATUS_NO_TRUST_LSA_SECRET
Language=English
The workstation does not have a trust secret for the primary domain in
local LSA database.
.

MessageId=0x018B Facility=System Severity=Error SymbolicName=STATUS_NO_TRUST_SAM_ACCOUNT
Language=English
The SAM database on the Windows NT Server does not have a computer
account for this workstation trust relationship.
.

MessageId=0x018C Facility=System Severity=Error SymbolicName=STATUS_TRUSTED_DOMAIN_FAILURE
Language=English
The logon request failed because the trust relationship between the
primary domain and the trusted domain failed.
.

MessageId=0x018D Facility=System Severity=Error SymbolicName=STATUS_TRUSTED_RELATIONSHIP_FAILURE
Language=English
The logon request failed because the trust relationship between this
workstation and the primary domain failed.
.

MessageId=0x018E Facility=System Severity=Error SymbolicName=STATUS_EVENTLOG_FILE_CORRUPT
Language=English
The Eventlog logfile is corrupt.
.

MessageId=0x18F Facility=System Severity=Error SymbolicName=STATUS_EVENTLOG_CANT_START
Language=English
No Eventlog log file could be opened.  The Eventlog service did not start.
.

MessageId=0x0190 Facility=System Severity=Error SymbolicName=STATUS_TRUST_FAILURE
Language=English
The network logon failed. This may be due the validation authority can't
be reached
.

MessageId=0x0191 Facility=System Severity=Error SymbolicName=STATUS_MUTANT_LIMIT_EXCEEDED
Language=English
An attempt was made to acquire a mutant such that its maximum count
would have been exceeded.
.

MessageId=0x0192 Facility=System Severity=Error SymbolicName=STATUS_NETLOGON_NOT_STARTED
Language=English
 An attempt was made to logon, but the netlogon service was not started.
.

MessageId=0x0193 Facility=System Severity=Error SymbolicName=STATUS_ACCOUNT_EXPIRED
Language=English
The user's account has expired.
.

MessageId=0x0194 Facility=System Severity=Error SymbolicName=STATUS_POSSIBLE_DEADLOCK
Language=English
{EXCEPTION}
Possible deadlock condition.
.

MessageId=0x0195 Facility=System Severity=Error SymbolicName=STATUS_NETWORK_CREDENTIAL_CONFLICT
Language=English
The credentials supplied conflict with an existing set of credentials.
.
MessageId=0x0196 Facility=System Severity=Error SymbolicName=STATUS_REMOTE_SESSION_LIMIT
Language=English
An attempt was made to establish a session to a network server, but there
are already too many sessions established to that server.
.

MessageId=0x0197 Facility=System Severity=Error SymbolicName=STATUS_EVENTLOG_FILE_CHANGED
Language=English
The logfile has changed between reads.
.

MessageId=0x0198 Facility=System Severity=Error SymbolicName=STATUS_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT
Language=English
The account used is an Interdomain Trust account.  Use your global user account or local user account to access this server.
.

MessageId=0x0199 Facility=System Severity=Error SymbolicName=STATUS_NOLOGON_WORKSTATION_TRUST_ACCOUNT
Language=English
The account used is a Computer Account.  Use your global user account or local user account to access this server.
.

MessageId=0x019A Facility=System Severity=Error SymbolicName=STATUS_NOLOGON_SERVER_TRUST_ACCOUNT
Language=English
The account used is an Server Trust account.  Use your global user account or local user account to access this server.
.

MessageId=0x019B Facility=System Severity=Error SymbolicName=STATUS_DOMAIN_TRUST_INCONSISTENT
Language=English
The name or SID of the domain specified is inconsistent with the trust information for that domain.
.

MessageId=0x019C Facility=System Severity=Error SymbolicName=STATUS_FS_DRIVER_REQUIRED
Language=English
A volume has been accessed for which a file system driver is required that has not yet been loaded.
.

MessageId=0x0202 Facility=System Severity=Error SymbolicName=STATUS_NO_USER_SESSION_KEY
Language=English
There is no user session key for the specified logon session.
.

MessageId=0x0203 Facility=System Severity=Error SymbolicName=STATUS_USER_SESSION_DELETED
Language=English
The remote user session has been deleted.
.

MessageId=0x0204 Facility=System Severity=Error SymbolicName=STATUS_RESOURCE_LANG_NOT_FOUND
Language=English
Indicates the specified resource language Id can not be found in the
image file.
.

MessageId=0x0205 Facility=System Severity=Error SymbolicName=STATUS_INSUFF_SERVER_RESOURCES
Language=English
Insufficient server resources exist to complete the request.
.

MessageId=0x0206 Facility=System Severity=Error SymbolicName=STATUS_INVALID_BUFFER_SIZE
Language=English
The size of the buffer is invalid for the specified operation.
.

MessageId=0x0207 Facility=System Severity=Error SymbolicName=STATUS_INVALID_ADDRESS_COMPONENT
Language=English
The transport rejected the network address specified as invalid.
.

MessageId=0x0208 Facility=System Severity=Error SymbolicName=STATUS_INVALID_ADDRESS_WILDCARD
Language=English
The transport rejected the network address specified due to an
invalid use of a wildcard.
.

MessageId=0x0209 Facility=System Severity=Error SymbolicName=STATUS_TOO_MANY_ADDRESSES
Language=English
The transport address could not be opened because all the available
addresses are in use.
.

MessageId=0x020A Facility=System Severity=Error SymbolicName=STATUS_ADDRESS_ALREADY_EXISTS
Language=English
The transport address could not be opened because it already exists.
.

MessageId=0x020B Facility=System Severity=Error SymbolicName=STATUS_ADDRESS_CLOSED
Language=English
The transport address is now closed.
.

MessageId=0x020C Facility=System Severity=Error SymbolicName=STATUS_CONNECTION_DISCONNECTED
Language=English
The transport connection is now disconnected.
.

MessageId=0x020D Facility=System Severity=Error SymbolicName=STATUS_CONNECTION_RESET
Language=English
The transport connection has been reset.
.

MessageId=0x020E Facility=System Severity=Error SymbolicName=STATUS_TOO_MANY_NODES
Language=English
The transport cannot dynamically acquire any more nodes.
.

MessageId=0x020F Facility=System Severity=Error SymbolicName=STATUS_TRANSACTION_ABORTED
Language=English
The transport aborted a pending transaction.
.

MessageId=0x0210 Facility=System Severity=Error SymbolicName=STATUS_TRANSACTION_TIMED_OUT
Language=English
The transport timed out a request waiting for a response.
.

MessageId=0x0211 Facility=System Severity=Error SymbolicName=STATUS_TRANSACTION_NO_RELEASE
Language=English
The transport did not receive a release for a pending response
.

MessageId=0x0212 Facility=System Severity=Error SymbolicName=STATUS_TRANSACTION_NO_MATCH
Language=English
The transport did not find a transaction matching the specific
token.
.

MessageId=0x0213 Facility=System Severity=Error SymbolicName=STATUS_TRANSACTION_RESPONDED
Language=English
The transport had previously responded to a transaction request.
.

MessageId=0x0214 Facility=System Severity=Error SymbolicName=STATUS_TRANSACTION_INVALID_ID
Language=English
The transport does not recognized the transaction request
identifier specified.
.

MessageId=0x0215 Facility=System Severity=Error SymbolicName=STATUS_TRANSACTION_INVALID_TYPE
Language=English
The transport does not recognize the transaction request
type specified.
.

MessageId=0x0216 Facility=System Severity=Error SymbolicName=STATUS_NOT_SERVER_SESSION
Language=English
The transport can only process the specified request on
the server side of a session.
.

MessageId=0x0217 Facility=System Severity=Error SymbolicName=STATUS_NOT_CLIENT_SESSION
Language=English
The transport can only process the specified request on
the client side of a session.
.

MessageId=0x0218 Facility=System Severity=Error SymbolicName=STATUS_CANNOT_LOAD_REGISTRY_FILE
Language=English
{Registry File Failure}
The registry cannot load the hive (file):
%s
or its log or alternate.
It is corrupt, absent, or not writeable.
.

MessageId=0x0219 Facility=System Severity=Error SymbolicName=STATUS_DEBUG_ATTACH_FAILED
Language=English
{Unexpected Failure in DebugActiveProcess}
An unexpected failure occured while processing a DebugActiveProcess API
request.  You may choose OK to terminate the process, or Cancel to
ignore the error.
.

MessageId=0x021A Facility=System Severity=Error SymbolicName=STATUS_SYSTEM_PROCESS_TERMINATED
Language=English
{Fatal System Error}
The %s system process terminated unexpectedly
with a status of 0x%08x (0x%08x 0x%08x).
The system has been shutdown.
.

MessageId=0x021B Facility=System Severity=Error SymbolicName=STATUS_DATA_NOT_ACCEPTED
Language=English
{Data Not Accepted}
The TDI client could not handle the data received during an
indication.
.

MessageId=0x021C Facility=System Severity=Error SymbolicName=STATUS_NO_BROWSER_SERVERS_FOUND
Language=English
{Unable to Retrieve Browser Server List}
The list of servers for this workgroup is not currently available.
.

MessageId=0x021D Facility=System Severity=Error SymbolicName=STATUS_VDM_HARD_ERROR
Language=English
NTVDM encountered a hard error.
.

MessageId=0x021E Facility=System Severity=Error SymbolicName=STATUS_DRIVER_CANCEL_TIMEOUT
Language=English
{Cancel Timeout}
The driver %s failed to complete a cancelled I/O request in the allotted time.
.

MessageId=0x021F Facility=System Severity=Error SymbolicName=STATUS_REPLY_MESSAGE_MISMATCH
Language=English
{Reply Message Mismatch}
An attempt was made to reply to an LPC message, but the thread specified
by the client Id in the message was not waiting on that message.
.

MessageId=0x0220 Facility=System Severity=Error SymbolicName=STATUS_MAPPED_ALIGNMENT
Language=English
{Mapped View Aligment Incorrect}
An attempt was made to map a view of a file, but either the specified base
address or the offset into the file were not aligned on the proper
allocation granularity.
.

MessageId=0x0221 Facility=System Severity=Error SymbolicName=STATUS_IMAGE_CHECKSUM_MISMATCH
Language=English
{Bad Image Checksum}
The image %s is possibly corrupt. The header checksum does not
match the computed checksum.
.

MessageId=0x0222 Facility=System Severity=Error SymbolicName=STATUS_LOST_WRITEBEHIND_DATA
Language=English
{Lost Delayed-Write Data}
The system was attempting to transfer file data from buffers to %s.
The write operation failed, and only some of the data may have been
written to the file.
.

MessageId=0x0223 Facility=System Severity=Error SymbolicName=STATUS_CLIENT_SERVER_PARAMETERS_INVALID
Language=English
The parameter(s) passed to the server in the client/server shared memory
window were invalid. Too much data may have been put in the shared memory
window.
.

MessageId=0x0224 Facility=System Severity=Error SymbolicName=STATUS_PASSWORD_MUST_CHANGE
Language=English
The user must change his password before he logs on the first time.
.

MessageId=0x0225 Facility=System Severity=Error SymbolicName=STATUS_NOT_FOUND
Language=English
The object was not found.
.

MessageId=0x0226 Facility=System Severity=Error SymbolicName=STATUS_NOT_TINY_STREAM
Language=English
The steam is not a tiny stream.
.

MessageId=0x0227 Facility=System Severity=Error SymbolicName=STATUS_RECOVERY_FAILURE
Language=English
A transaction recover failed.
.

MessageId=0x0228 Facility=System Severity=Error SymbolicName=STATUS_STACK_OVERFLOW_READ
Language=English
The request must be handled by the stack overflow code.
.

MessageId=0x0229 Facility=System Severity=Error SymbolicName=STATUS_FAIL_CHECK
Language=English
A consistancy check failed.
.

MessageId=0x022a Facility=System Severity=Error SymbolicName=STATUS_DUPLICATE_OBJECTID
Language=English
The attempt to insert the id in the index failed because the
id is already in the index.
.

MessageId=0x022b Facility=System Severity=Error SymbolicName=STATUS_OBJECTID_EXISTS
Language=English
The attempt to set the object's id failed because the object
already has an id.
.

MessageId=0x022c Facility=System Severity=Error SymbolicName=STATUS_CONVERT_TO_LARGE
Language=English
Internal OFS status codes indicating how an allocation operation is
handled.  Either it is retried after the containing onode is moved
or the extent stream is converted to a large stream
.

MessageId=0x022d Facility=System Severity=Error SymbolicName=STATUS_RETRY
Language=English
The request needs to be retried.
.

MessageId=0x022e Facility=System Severity=Error SymbolicName=STATUS_FOUND_OUT_OF_SCOPE
Language=English
The attempt to find the object found an object matching by id
on the volume but it is out of the scope of the handle used
to send the fsctl.
.

MessageId=0x022f Facility=System Severity=Error SymbolicName=STATUS_ALLOCATE_BUCKET
Language=English
The bucket array must be grown.  Retry transaction after doing so
.

MessageId=0x0230 Facility=System Severity=Error SymbolicName=STATUS_PROPSET_NOT_FOUND
Language=English
the property set specified does not exist on the object
.

MessageId=0x0231 Facility=System Severity=Error SymbolicName=STATUS_MARSHALL_OVERFLOW
Language=English
the user/kernel marshalling buffer has overflowed
.

MessageId=0x0232 Facility=System Severity=Error SymbolicName=STATUS_INVALID_VARIANT
Language=English
the supplied variant structure contains invalid data
.

MessageId=0x0233 Facility=System Severity=Error SymbolicName=STATUS_DOMAIN_CONTROLLER_NOT_FOUND
Language=English
Could not find a domain controller for this domain.
.

MessageId=0x0234 Facility=System Severity=Error SymbolicName=STATUS_ACCOUNT_LOCKED_OUT
Language=English
The user acocount has been automatically locked because too many invalid logon attempts or password change attempts have been requested.
.

MessageId=0x0235 Facility=System Severity=Error SymbolicName=STATUS_HANDLE_NOT_CLOSABLE
Language=English
NtClose was called on a handle that was protected from close via NtSetInformationObject.
.

MessageId=0x0236 Facility=System Severity=Error SymbolicName=STATUS_CONNECTION_REFUSED
Language=English
The transport connection attempt was refused by the remote system.
.

MessageId=0x0237 Facility=System Severity=Error SymbolicName=STATUS_GRACEFUL_DISCONNECT
Language=English
The transport connection was gracefully closed.
.

MessageId=0x0238 Facility=System Severity=Error SymbolicName=STATUS_ADDRESS_ALREADY_ASSOCIATED
Language=English
The transport endpoint already has an address associated with it.
.

MessageId=0x0239 Facility=System Severity=Error SymbolicName=STATUS_ADDRESS_NOT_ASSOCIATED
Language=English
An address has not yet been associated with the transport endpoint.
.

MessageId=0x023a Facility=System Severity=Error SymbolicName=STATUS_CONNECTION_INVALID
Language=English
An operation was attempted on a non-existent transport connection.
.

MessageId=0x023b Facility=System Severity=Error SymbolicName=STATUS_CONNECTION_ACTIVE
Language=English
An invalid operation was attempted on an active transport connection.
.

MessageId=0x023c Facility=System Severity=Error SymbolicName=STATUS_NETWORK_UNREACHABLE
Language=English
The remote network is not reachable by the transport.
.

MessageId=0x023d Facility=System Severity=Error SymbolicName=STATUS_HOST_UNREACHABLE
Language=English
The remote system is not reachable by the transport.
.

MessageId=0x023e Facility=System Severity=Error SymbolicName=STATUS_PROTOCOL_UNREACHABLE
Language=English
The remote system does not support the transport protocol.
.

MessageId=0x023f Facility=System Severity=Error SymbolicName=STATUS_PORT_UNREACHABLE
Language=English
No service is operating at the destination port of the transport
on the remote system.
.

MessageId=0x0240 Facility=System Severity=Error SymbolicName=STATUS_REQUEST_ABORTED
Language=English
The request was aborted.
.

MessageId=0x0241 Facility=System Severity=Error SymbolicName=STATUS_CONNECTION_ABORTED
Language=English
The transport connection was aborted by the local system.
.

MessageId=0x0242 Facility=System Severity=Error SymbolicName=STATUS_BAD_COMPRESSION_BUFFER
Language=English
The specified buffer contains ill-formed data.
.

MessageId=0x0243 Facility=System Severity=Error SymbolicName=STATUS_USER_MAPPED_FILE
Language=English
The requested operation cannot be performed on a file with a user mapped section open.
.

MessageId=0x0244 Facility=System Severity=Error SymbolicName=STATUS_AUDIT_FAILED
Language=English
{Audit Failed}
An attempt to generate a security audit failed.
.

MessageId=0x0245 Facility=System Severity=Error SymbolicName=STATUS_TIMER_RESOLUTION_NOT_SET
Language=English
The timer resolution was not previously set by the current process.
.

MessageId=0x0246 Facility=System Severity=Error SymbolicName=STATUS_CONNECTION_COUNT_LIMIT
Language=English
A connection to the server could not be made because the limit on the number of
concurrent connections for this account has been reached.
.

MessageId=0x0247 Facility=System Severity=Error SymbolicName=STATUS_LOGIN_TIME_RESTRICTION
Language=English
Attempting to login during an unauthorized time of day for this account.
.

MessageId=0x0248 Facility=System Severity=Error SymbolicName=STATUS_LOGIN_WKSTA_RESTRICTION
Language=English
The account is not authorized to login from this station.
.

MessageId=0x0249 Facility=System Severity=Error SymbolicName=STATUS_IMAGE_MP_UP_MISMATCH
Language=English
{UP/MP Image Mismatch}
The image %s has been modified for use on a uni-processor system,
but you are running it on a multi-processor machine.
Please reinstall the image file.
.

MessageId=0x0250 Facility=System Severity=Error SymbolicName=STATUS_INSUFFICIENT_LOGON_INFO
Language=English
There is insufficient account information to log you on.
.

MessageId=0x0251 Facility=System Severity=Error SymbolicName=STATUS_BAD_DLL_ENTRYPOINT
Language=English
{Invalid DLL Entrypoint}
The dynamic link library %s is not written correctly. The stack pointer has been left in an inconsistent state.
The entrypoint should be declared as WINAPI or STDCALL. Select YES to fail the DLL load. Select NO to continue
execution. Selecting NO may cause the application to operate incorrectly.
.

MessageId=0x0252 Facility=System Severity=Error SymbolicName=STATUS_BAD_SERVICE_ENTRYPOINT
Language=English
{Invalid Service Callback Entrypoint}
The %s service is not written correctly. The stack pointer has been left in an inconsistent state.
The callback entrypoint should be declared as WINAPI or STDCALL. Selecting OK will cause the
service to continue operation. However, the service process may operate incorrectly.
.


MessageId=0x0253 Facility=System Severity=Error SymbolicName=STATUS_LPC_REPLY_LOST
Language=English
The server received the messages but did not send a reply.
.


MessageId=0x0254  Facility=System Severity=Error  SymbolicName=STATUS_IP_ADDRESS_CONFLICT1
Language=English
The system has detected an IP address conflict with another system on the
network. The local interface has been disabled. More details are available in
the system event log. Consult your network administrator to resolve the
conflict.
.

MessageId=0x0255  Facility=System Severity=Error  SymbolicName=STATUS_IP_ADDRESS_CONFLICT2
Language=English
The system has detected an IP address conflict with another system on the
network. Network operations on this system may be disrupted as a result.
More details are available in the system event log. Consult your network
administrator immediately to resolve the conflict.
.

MessageId=0x0001 Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_INVALID_STRING_BINDING
Language=English
The string binding is invalid.
.

MessageId=0x0002 Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_WRONG_KIND_OF_BINDING Language=English
The binding handle is not the correct type.
.

MessageId=0x0003 Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_INVALID_BINDING
Language=English
The binding handle is invalid.
.

MessageId=0x0004 Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_PROTSEQ_NOT_SUPPORTED
Language=English
The Rpc protocol sequence is not supported.
.

MessageId=0x0005 Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_INVALID_RPC_PROTSEQ
Language=English
The rpc protocol sequence is invalid.
.

MessageId=0x0006 Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_INVALID_STRING_UUID
Language=English
The string uuid is invalid.
.

MessageId=0x0007 Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_INVALID_ENDPOINT_FORMAT
Language=English
The endpoint format is invalid.
.

MessageId=0x0008 Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_INVALID_NET_ADDR
Language=English
The network address is invalid.
.

MessageId=0x0009 Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_NO_ENDPOINT_FOUND
Language=English
No endpoint was found.
.

MessageId=0x000A Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_INVALID_TIMEOUT
Language=English
The timeout value is invalid.
.

MessageId=0x000B Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_OBJECT_NOT_FOUND
Language=English
The object uuid was not found.
.

MessageId=0x000C Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_ALREADY_REGISTERED
Language=English
The object uuid has already been registered.
.

MessageId=0x000D Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_TYPE_ALREADY_REGISTERED
Language=English
The type uuid has already been registered.
.

MessageId=0x000E Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_ALREADY_LISTENING
Language=English
The rpc server is already listening.
.

MessageId=0x000F Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_NO_PROTSEQS_REGISTERED
Language=English
No protocol sequences have been registered.
.

MessageId=0x0010 Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_NOT_LISTENING
Language=English
The rpc server is not listening.
.

MessageId=0x0011 Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_UNKNOWN_MGR_TYPE
Language=English
The manager type is unknown.
.

MessageId=0x0012 Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_UNKNOWN_IF
Language=English
The interface is unknown.
.

MessageId=0x0013 Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_NO_BINDINGS
Language=English
There are no bindings.
.

MessageId=0x0014 Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_NO_PROTSEQS
Language=English
There are no protocol sequences.
.

MessageId=0x0015 Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_CANT_CREATE_ENDPOINT
Language=English
The endpoint can not be created.
.

MessageId=0x0016 Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_OUT_OF_RESOURCES
Language=English
Not enough resources are available to complete this operation.
.

MessageId=0x0017 Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_SERVER_UNAVAILABLE
Language=English
The rpc server is unavailable.
.

MessageId=0x0018 Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_SERVER_TOO_BUSY
Language=English
The rpc server is too busy to complete this operation.
.

MessageId=0x0019 Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_INVALID_NETWORK_OPTIONS
Language=English
The network options are invalid.
.

MessageId=0x001A Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_NO_CALL_ACTIVE
Language=English
There is not a remote procedure call active in this thread.
.

MessageId=0x001B Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_CALL_FAILED
Language=English
The remote procedure call failed.
.

MessageId=0x001C Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_CALL_FAILED_DNE
Language=English
The remote procedure call failed and did not execute.
.

MessageId=0x001D Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_PROTOCOL_ERROR
Language=English
An rpc protocol error occurred.
.

MessageId=0x001F Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_UNSUPPORTED_TRANS_SYN
Language=English
The transfer syntax is not supported by the rpc server.
.

MessageId=0x0021 Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_UNSUPPORTED_TYPE
Language=English
The type uuid is not supported.
.

MessageId=0x0022 Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_INVALID_TAG
Language=English
The tag is invalid.
.

MessageId=0x0023 Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_INVALID_BOUND
Language=English
The array bounds are invalid.
.

MessageId=0x0024 Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_NO_ENTRY_NAME
Language=English
The binding does not contain an entry name.
.

MessageId=0x0025 Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_INVALID_NAME_SYNTAX
Language=English
The name syntax is invalid.
.

MessageId=0x0026 Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_UNSUPPORTED_NAME_SYNTAX
Language=English
The name syntax is not supported.
.

MessageId=0x0028 Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_UUID_NO_ADDRESS
Language=English
No network address is available to use to construct a uuid.
.

MessageId=0x0029 Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_DUPLICATE_ENDPOINT
Language=English
The endpoint is a duplicate.
.

MessageId=0x002A Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_UNKNOWN_AUTHN_TYPE
Language=English
The authentication type is unknown.
.

MessageId=0x002B Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_MAX_CALLS_TOO_SMALL
Language=English
The maximum number of calls is too small.
.

MessageId=0x002C Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_STRING_TOO_LONG
Language=English
The string is too long.
.

MessageId=0x002D Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_PROTSEQ_NOT_FOUND
Language=English
The rpc protocol sequence was not found.
.

MessageId=0x002E Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_PROCNUM_OUT_OF_RANGE
Language=English
The procedure number is out of range.
.

MessageId=0x002F Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_BINDING_HAS_NO_AUTH
Language=English
The binding does not contain any authentication information.
.

MessageId=0x0030 Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_UNKNOWN_AUTHN_SERVICE
Language=English
The authentication service is unknown.
.

MessageId=0x0031 Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_UNKNOWN_AUTHN_LEVEL
Language=English
The authentication level is unknown.
.

MessageId=0x0032 Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_INVALID_AUTH_IDENTITY
Language=English
The security context is invalid.
.

MessageId=0x0033 Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_UNKNOWN_AUTHZ_SERVICE
Language=English
The authorization service is unknown.
.

MessageId=0x0034 Facility=RpcRuntime Severity=Error SymbolicName=EPT_NT_INVALID_ENTRY
Language=English
The entry is invalid.
.

MessageId=0x0035 Facility=RpcRuntime Severity=Error SymbolicName=EPT_NT_CANT_PERFORM_OP
Language=English
The operation can not be performed.
.

MessageId=0x0036 Facility=RpcRuntime Severity=Error SymbolicName=EPT_NT_NOT_REGISTERED
Language=English
There are not more endpoints available from the endpoint mapper.
.

MessageId=0x0037 Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_NOTHING_TO_EXPORT
Language=English
No interfaces have been exported.
.

MessageId=0x0038 Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_INCOMPLETE_NAME
Language=English
The entry name is incomplete.
.

MessageId=0x0039 Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_INVALID_VERS_OPTION
Language=English
The version option is invalid.
.

MessageId=0x003A Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_NO_MORE_MEMBERS
Language=English
There are no more members.
.

MessageId=0x003B Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_NOT_ALL_OBJS_UNEXPORTED
Language=English
There is nothing to unexport.
.

MessageId=0x003C Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_INTERFACE_NOT_FOUND
Language=English
The interface was not found.
.

MessageId=0x003D Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_ENTRY_ALREADY_EXISTS
Language=English
The entry already exists.
.

MessageId=0x003E Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_ENTRY_NOT_FOUND
Language=English
The entry is not found.
.

MessageId=0x003F Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_NAME_SERVICE_UNAVAILABLE
Language=English
The name service is unavailable.
.

MessageId=0x0040 Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_INVALID_NAF_ID
Language=English
The network address family is invalid.
.

MessageId=0x0041 Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_CANNOT_SUPPORT
Language=English
The requested operation is not supported.
.

MessageId=0x0042 Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_NO_CONTEXT_AVAILABLE
Language=English
No security context is available to allow impersonation.
.

MessageId=0x0043 Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_INTERNAL_ERROR
Language=English
An internal error occurred in rpc.
.

MessageId=0x0044 Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_ZERO_DIVIDE
Language=English
The rpc server attempted an integer divide by zero.
.

MessageId=0x0045 Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_ADDRESS_ERROR
Language=English
An addressing error occurred in the rpc server.
.

MessageId=0x0046 Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_FP_DIV_ZERO
Language=English
A floating point operation at the rpc server caused a divide by zero.
.

MessageId=0x0047 Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_FP_UNDERFLOW
Language=English
A floating point underflow occurred at the rpc server.
.

MessageId=0x0048 Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_FP_OVERFLOW
Language=English
A floating point overflow occurred at the rpc server.
.

MessageId=0x0001 Facility=RpcStubs Severity=Error SymbolicName=RPC_NT_NO_MORE_ENTRIES Language=English
The list of rpc servers available for auto_handle binding has been exhausted.
.

MessageId=0x0002 Facility=RpcStubs Severity=Error SymbolicName=RPC_NT_SS_CHAR_TRANS_OPEN_FAIL Language=English
The file designated by DCERPCCHARTRANS cannot be opened.
.

MessageId=0x0003 Facility=RpcStubs Severity=Error SymbolicName=RPC_NT_SS_CHAR_TRANS_SHORT_FILE Language=English
The file containing the character translation table has fewer than
512 bytes.
.

MessageId=0x0004 Facility=RpcStubs Severity=Error SymbolicName=RPC_NT_SS_IN_NULL_CONTEXT Language=English
A null context handle is passed as an [in] parameter.
.

MessageId=0x0005 Facility=RpcStubs Severity=Error SymbolicName=RPC_NT_SS_CONTEXT_MISMATCH Language=English
The context handle does not match any known context handles.
.

MessageId=0x0006 Facility=RpcStubs Severity=Error SymbolicName=RPC_NT_SS_CONTEXT_DAMAGED Language=English
The context handle changed during a call.
.

MessageId=0x0007 Facility=RpcStubs Severity=Error SymbolicName=RPC_NT_SS_HANDLES_MISMATCH Language=English
The binding handles passed to a remote procedure call do not match.
.

MessageId=0x0008 Facility=RpcStubs Severity=Error SymbolicName=RPC_NT_SS_CANNOT_GET_CALL_HANDLE Language=English
The stub is unable to get the call handle.
.

MessageId=0x0009 Facility=RpcStubs Severity=Error SymbolicName=RPC_NT_NULL_REF_POINTER Language=English
A null reference pointer was passed to the stub.
.

MessageId=0x000A Facility=RpcStubs Severity=Error SymbolicName=RPC_NT_ENUM_VALUE_OUT_OF_RANGE Language=English
The enumeration value is out of range.
.

MessageId=0x000B Facility=RpcStubs Severity=Error SymbolicName=RPC_NT_BYTE_COUNT_TOO_SMALL Language=English
The byte count is too small
.

MessageId=0x000C Facility=RpcStubs Severity=Error SymbolicName=RPC_NT_BAD_STUB_DATA Language=English
The stub received bad data.
.

MessageId=0x0049 Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_CALL_IN_PROGRESS Language=English
A remote procedure call is already in progress for this thread.
.

MessageId=0x004A Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_NO_MORE_BINDINGS
Language=English
There are no more bindings.
.


MessageId=0x004B Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_GROUP_MEMBER_NOT_FOUND
Language=English
The group member was not found.
.

MessageId=0x004C Facility=RpcRuntime Severity=Error SymbolicName=EPT_NT_CANT_CREATE
Language=English
The endpoint mapper database could not be created.
.

MessageId=0x004D Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_INVALID_OBJECT
Language=English
The object uuid is the nil uuid.
.

MessageId=0x004F Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_NO_INTERFACES
Language=English
No interfaces have been registered.
.

MessageId=0x0050 Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_CALL_CANCELLED
Language=English
The server was altered while processing this call.
.

MessageId=0x0051 Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_BINDING_INCOMPLETE
Language=English
The binding handle does not contain all required information.
.

MessageId=0x0052 Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_COMM_FAILURE
Language=English
Communications failure.
.

MessageId=0x0053 Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_UNSUPPORTED_AUTHN_LEVEL
Language=English
The requested authentication level is not supported.
.

MessageId=0x0054 Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_NO_PRINC_NAME
Language=English
No principal name registered.
.

MessageId=0x0055 Facility=RpcRuntime Severity=Error SymbolicName=RPC_NT_NOT_RPC_ERROR
Language=English
The error specified is not a valid Windows NT RPC error code.
.

MessageId=0x0056  Facility=RpcRuntime Severity=Informational SymbolicName=RPC_NT_UUID_LOCAL_ONLY
Language=English
A Uuid that is valid only on this computer has been allocated.
.

MessageId=0x0057  Facility=RpcRuntime Severity=Error  SymbolicName=RPC_NT_SEC_PKG_ERROR
Language=English
A security package specific error occured.
.

MessageId=0x0058  Facility=RpcRuntime Severity=Error  SymbolicName=RPC_NT_NOT_CANCELLED
Language=English
Thread is not cancelled.
.

MessageId=0x0059  Facility=RpcStubs Severity=Error  SymbolicName=RPC_NT_INVALID_ES_ACTION
Language=English
Invalid operation on the encoding/decoding handle.
.

MessageId=0x005A  Facility=RpcStubs Severity=Error  SymbolicName=RPC_NT_WRONG_ES_VERSION
Language=English
Incompatible version of the serializing package.
.

MessageId=0x005B  Facility=RpcStubs Severity=Error  SymbolicName=RPC_NT_WRONG_STUB_VERSION
Language=English
Incompatible version of the RPC stub.
.

;/*lint -restore */  // Resume checking for different macro definitions // winnt
;
;
;#endif // _NTSTATUS_
