/*++

Copyright (c) 1990  Microsoft Corporation

Module Name:

    kulookup.c

Abstract:

    The module implements the code necessary to lookup user mode entry points
    in the system DLL for exception dispatching and APC delivery.

Author:

    David N. Cutler (davec) 8-Oct-90

Revision History:

--*/

#include    "psp.h"

NTSTATUS
PspLookupKernelUserEntryPoints (
    VOID
    )

/*++

Routine Description:

    The function locates the address of the exception dispatch and user APC
    delivery routine in the system DLL and stores the respective addresses
    in the PCR.

Arguments:

    None.

Return Value:

    NTSTATUS

--*/

{

    NTSTATUS Status;
    PSZ EntryName;

    //
    //  Lookup the user mode "trampoline" code for exception dispatching
    //

    EntryName = "KiUserExceptionDispatcher";
    Status = PspLookupSystemDllEntryPoint(EntryName,
                                          (PVOID *)&KeUserExceptionDispatcher);
    if (NT_SUCCESS(Status) == FALSE) {
#if DBG
        DbgPrint("Ps: Cannot find user exception dispatcher address\n");
#endif
        return Status;
    }

    //
    //  Lookup the user mode "trampoline" code for APC dispatching
    //

    EntryName = "KiUserApcDispatcher";
    Status = PspLookupSystemDllEntryPoint(EntryName,
                                          (PVOID *)&KeUserApcDispatcher);
    if (NT_SUCCESS(Status) == FALSE) {
#if DBG
        DbgPrint("Ps: Cannot find user apc dispatcher address\n");
#endif
        return Status;
    }

#if defined(R3000) && !defined(R4000)

    //
    //  Lookup the user mode lock range start address
    //

    EntryName = "RtlpLockRangeStart";
    Status = PspLookupSystemDllEntryPoint(EntryName,
                                          (PVOID *)&PCR->RtlpLockRangeStart);
    if (NT_SUCCESS(Status) == FALSE) {
#if DBG
        DbgPrint("Ps: Cannot find user mode lock range start address\n");
#endif
        return Status;
    }

    //
    //  Lookup the user mode lock range end address
    //

    EntryName = "RtlpLockRangeEnd";
    Status = PspLookupSystemDllEntryPoint(EntryName,
                                          (PVOID *)&PCR->RtlpLockRangeEnd);
    if (NT_SUCCESS(Status) == FALSE) {
#if DBG
        DbgPrint("Ps: Cannot find user mode lock range end address\n");
#endif
        return Status;
    }

#endif // defined(R3000) && !defined(R4000)

    return Status;
}
