/*++

Copyright (c) 1989-1993  Microsoft Corporation

Module Name:

    spxdev.h

Abstract:

    This module contains definitions specific to the
    SPX module of the ISN transport.

Author:

	Adam   Barr		 (adamba ) Original Version
    Nikhil Kamkolkar (nikhilk) 17-November-1993

Environment:

    Kernel mode

Revision History:

--*/


// Hash buckets for SPX_ADDR done using socket number
#define	NUM_SPXADDR_HASH_BUCKETS	8
#define	NUM_SPXADDR_HASH_MASK		7
#define	NUM_SPXCONN_HASH_BUCKETS	8
#define	NUM_SPXCONN_HASH_MASK		7

// This structure defines the per-device structure for SPX
// (one of these is allocated globally).
#define DREF_CREATE   0
#define DREF_LOADED   1
#define DREF_ADAPTER  2
#define DREF_ADDRESS  3
#define DREF_ORPHAN	  4

#define DREF_TOTAL    5

typedef struct _DEVICE {

    DEVICE_OBJECT   dev_DevObj;				// the I/O system's device object.

#if DBG
    ULONG           dev_RefTypes[DREF_TOTAL];
#endif

    CSHORT          dev_Type;               // type of this structure
    USHORT          dev_Size;               // size of this structure

#if DBG
    UCHAR 			dev_Signature1[4];		// contains "SPX1"
#endif

    // activity count/this provider.
    LONG 			dev_RefCount;
    UCHAR 			dev_State;

    // number of adapters IPX is bound to.
    USHORT          dev_Adapters;

	// GLOBAL lock for reference count (used in ExInterlockedXxx calls).
    CTELock 		dev_Interlock;			
    CTELock 		dev_Lock;

	//	Hash table of lists of addresses opened on this device
	struct	_SPX_ADDR		* 	dev_AddrHashTable[NUM_SPXADDR_HASH_BUCKETS];

	//	List of all active connections, later this be a tree.
	struct  _SPX_CONN_FILE	* 	dev_GlobalActiveConnList[NUM_SPXCONN_HASH_BUCKETS];
	USHORT						dev_NextConnId;

    // Other configuration parameters.
    // Where the current socket allocation is.
    USHORT 			dev_CurrentSocket;

    // Our node and network.
    UCHAR 			dev_Network[4];
    UCHAR 			dev_Node[6];

	//	Pointer to the config information from registry
	PCONFIG			dev_ConfigInfo;

	//	Control channel identifier
	ULONG			dev_CcId;

    // These are kept around for error logging, and stored right
    // after this structure.
    PWCHAR          dev_DeviceName;
    ULONG           dev_DeviceNameLen;

#if DBG
    UCHAR 			dev_Signature2[4];      // contains "SPX2"
#endif

	//	Handle to ndis buffer pool for spx stack.
	NDIS_HANDLE		dev_NdisBufferPoolHandle;

    // This interlock is used to guard access to the statistics
    // define below.
    KSPIN_LOCK 		dev_StatInterlock;	   	// for ULONG quantities
    KSPIN_LOCK 		dev_StatSpinLock;   	// for LARGE_INTEGER quantities

    // Counters for most of the statistics that SPX maintains;
    // some of these are kept elsewhere. Including the structure
    // itself wastes a little space but ensures that the alignment
    // inside the structure is correct.
    TDI_PROVIDER_STATISTICS dev_Stat;

    // This resource guards access to the ShareAccess
    // and SecurityDescriptor fields in addresses.
    ERESOURCE 		dev_AddrResource;

    // The following structure contains statistics counters for use
    // by TdiQueryInformation and TdiSetInformation.  They should not
    // be used for maintenance of internal data structures.
    TDI_PROVIDER_INFO dev_ProviderInfo;     // information about this provider.

} DEVICE, * PDEVICE;

// device state definitions
#define DEVICE_STATE_CLOSED   0x00
#define DEVICE_STATE_OPEN     0x01
#define DEVICE_STATE_STOPPING 0x02


//  SPX device name
#define SPX_DEVICE_NAME         L"\\Device\\NwlnkSpx"

#define SPX_TDI_RESOURCES     9


//	MACROS
#if DBG

#define SpxReferenceDevice(_Device, _Type) 				\
		{												\
			(VOID)ExInterlockedAddUlong ( 				\
				&(_Device)->dev_RefTypes[_Type], 		\
				1, 										\
				&SpxGlobalInterlock); 					\
														\
			(VOID)ExInterlockedIncrementLong (			\
					  &(_Device)->dev_RefCount,	 		\
					  &(_Device)->dev_Interlock);		\
		}

#define SpxDereferenceDevice(_Device, _Type) 			\
		{												\
			(VOID)ExInterlockedAddUlong ( 				\
				&(_Device)->dev_RefTypes[_Type], 		\
				(ULONG)-1, 								\
				&SpxGlobalInterlock); 					\
			SpxDerefDevice (_Device);					\
		}

#else

#define SpxReferenceDevice(_Device, _Type) 				\
		{												\
			(VOID)ExInterlockedIncrementLong (			\
					  &(_Device)->dev_RefCount,	 		\
					  &(_Device)->dev_Interlock);		\
		}

#define SpxDereferenceDevice(_Device, _Type) 			\
			SpxDerefDevice (_Device)

#endif

//  EXPORTED ROUTINES

VOID
SpxDestroyDevice(
    IN PDEVICE Device);

VOID
SpxDerefDevice(
    IN PDEVICE Device);

NTSTATUS
SpxInitCreateDevice(
    IN PDRIVER_OBJECT DriverObject,
    IN PUNICODE_STRING DeviceName,
    IN OUT PDEVICE *DevicePtr);
