/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 Copyright (c) 1989 Microsoft Corporation

 Module Name:
	
	ptrcls.hxx

 Abstract:

	Contains definitions for base type related code generation class
	definitions.

 Notes:


 History:

	GregJen		Sep-30-1993		Created.
 ----------------------------------------------------------------------------*/
#ifndef __PTRCLS_HXX__
#define __PTRCLS_HXX__

#include "nulldefs.h"

extern "C"
	{
	#include <stdio.h>
	#include <assert.h>
	}

#include "ndrcls.hxx"
#include "arraycls.hxx"

/////////////////////////////////////////////////////////////////////////////
// the pointer type code generation classes.
/////////////////////////////////////////////////////////////////////////////

//
// This class corresponds to a vanilla pointer type. 
//

class CG_POINTER	: public CG_NDR
	{
private:

	unsigned long			fPointerShouldFree	: 1;
	unsigned long			fIsInMultiSized	: 1;

	// the kind of the pointer (ref, unique or full)

	PTRTYPE					PtrKind;

	//
	// allocate attributes (defined in acfattr.hxx)
	//

	short					AllocateDetails;

	//
	// For Ndr format string generation.  The offset of the pointee in the
	// format string.  We can't just get the pointee's offset in the format
	// string by asking the CG_POINTER's child it's offset into the format
	// string, because size and length pointers produce their pointee format
	// string by creating temporary array CG classes.  Thus their real CG
	// child will not have the correct offset in the format string, we must
	// record it here instead.
	//
	long					PointeeFormatStringOffset;

public:
	
	//
	// The constructor.
	//

							CG_POINTER(
									 node_skl * pBT,
									 PTRTYPE	p,
									 short		AD ) : 
								CG_NDR( pBT, (unsigned short) 4 )
								{
								SetPtrType( p );
								PointeeFormatStringOffset = -1;
								SetAllocateDetails( AD );
								SetPointerShouldFree( 1 );
                                SetIsInMultiSized( FALSE );
								}

	virtual
	ID_CG					GetCGID()
								{
								return ID_CG_PTR;
								}

	//
	// Get and Set methods.
	//

	PTRTYPE					GetPtrType()
								{
								return PtrKind;
								}

	PTRTYPE					SetPtrType( PTRTYPE p )
								{
								return (PtrKind = p);
								}

	short					GetAllocateDetails()
								{
								return AllocateDetails;
								}

	short					SetAllocateDetails( short AD )
								{
								return (AllocateDetails = AD);
								}

	//
	// individual synthesized queries
	//

	BOOL					IsAllocateAllNodes()
								{
								return (BOOL) 
										(IS_ALLOCATE(AllocateDetails,
													ALLOCATE_ALL_NODES) );
								}

	BOOL					IsAllocateDontFree()
								{
								return (BOOL) 
										(IS_ALLOCATE(AllocateDetails, 
													ALLOCATE_DONT_FREE ) );
								}

	void					SetPointerShouldFree( unsigned long Flag )
								{
								fPointerShouldFree = Flag;
								}

	BOOL					ShouldPointerFree()
								{
								return (BOOL)(fPointerShouldFree == 1);
								}

	BOOL					IsRef()
								{
								return (PtrKind == PTR_REF);
								}

	BOOL					IsUnique()
								{
								return (PtrKind == PTR_UNIQUE);
								}

	BOOL					IsFull()
								{
								return (PtrKind == PTR_FULL);
								}

	virtual
	BOOL					IsPointer()
								{
								return TRUE;
								}

	//
	// Common shortcuts.
	//

	BOOL					IsPointerToBaseType();

	BOOL					IsPointerToPointer();

    //
    // Is this a sized pointer of sized pointers.
    //
    BOOL                    IsMultiSize();

    void                    SetIsInMultiSized( BOOL fSet )
                                {
                                fIsInMultiSized = fSet;
                                }

    BOOL                    IsInMultiSized()
                                {
                                return fIsInMultiSized;
                                }

    //
    // Get number of dimensions if this is a sized pointer of sized pointers.
    //
    long                    SizedDimensions();

	virtual
	CG_STATUS				GenSizing( CCB * pCCB );

	virtual
	CG_STATUS				GenFollowerSizing( CCB * pCCB )
								{
								return GenCorePteSizing( pCCB );
								}

	virtual
	CG_STATUS				GenMarshall( CCB * pCCB );

	virtual
	CG_STATUS				GenUnMarshall( CCB * pCCB );

	CG_STATUS				GenPtrMarshall( CCB * pCCB );

	CG_STATUS				GenPteMarshall( CCB * pCCB );

	virtual
	CG_STATUS				GenCorePteMarshall( CCB * pCCB )
								{
								return ((CG_NDR*)GetChild())->GenMarshall( pCCB );
								}
	virtual
	CG_STATUS				GenCorePteSizing( CCB * pCCB )
								{
								return ((CG_NDR*)GetChild())->GenSizing( pCCB );
								}

	CG_STATUS				GenPtrUnMarshall( CCB * pCCB );

	CG_STATUS				GenPteUnMarshall( CCB * pCCB );

	virtual
	CG_STATUS				GenCorePteUnMarshall( CCB * pCCB )
								{
								return CG_OK;
								}

	virtual
	CG_STATUS				GenFollowerMarshall( CCB * pCCB );

	virtual
	CG_STATUS				GenFollowerUnMarshall( CCB * pCCB )
								{
								return GenBasicUnMarshall( pCCB );
								}


	// server side stuff.

	virtual
	CG_STATUS				S_GenInitOutLocals( CCB * pCCB );

	// 
	// Ndr format string generation method.
	//
	virtual
	void 					GenNdrFormat( CCB * pCCB );

	//
	// Generate the description of the pointer when imbeded.  Shared by 	
	// all classes which inherit CG_POINTER.
	//
	void					GenNdrFormatEmbedded( CCB * pCCB )
								{
    							SetFormatStringOffset( 
								  pCCB->GetFormatString()->GetCurrentOffset() );

								GenNdrFormatAlways( pCCB ); 
								}

	//
	// This routine always generates the format string for a pointer.  Used
	// by GenNdrFormat and GenNdrImbededFormat().  
	//
	virtual
	void					GenNdrFormatAlways( CCB * pCCB );

    //
    // This method is called to generate offline portions of a types
    // format string.
    //
    virtual
    void                    GenNdrParamOffline( CCB * pCCB );

	//
	// Ndr format string generation for the pointee.  
	//
	virtual
	void					GenNdrFormatPointee( CCB * pCCB );

	//
	// Prolog stuff for all classes which inherit CG_POINTER 
	//
	void					GenNdrPointerType( CCB * pCCB );

    virtual
    BOOL                    ShouldFreeOffline();

    virtual
    void                    GenFreeInline( CCB * pCCB );

	//
	// Get and Set methods for the PointeeFormatStringOffset member.
	//
	void					SetPointeeFormatStringOffset( long offset )
								{
								PointeeFormatStringOffset = offset;
								}

	long					GetPointeeFormatStringOffset()
								{
								return PointeeFormatStringOffset;
								}


	//////////////////////////////////////////////////////////////////

	virtual
	CG_STATUS				BufferAnalysis( ANALYSIS_INFO * pAna )
								{
								UNUSED( pAna );
								return CG_OK;
								}

	virtual
	CG_STATUS				MarshallAnalysis( ANALYSIS_INFO * pAna );

	virtual
	CG_STATUS				SizeAnalysis( ANALYSIS_INFO * pAna )
								{
								UNUSED( pAna );
								return CG_OK;
								}

	virtual
	CG_STATUS				UnMarshallAnalysis( ANALYSIS_INFO * pAna );

	virtual
	CG_STATUS				S_OutLocalAnalysis( ANALYSIS_INFO * pAna );

	virtual
	_expr_node			*	GenBindOrUnBindExpression( CCB * pCCB, BOOL fBind );

	CG_STATUS				PtrMarshallAnalysis( ANALYSIS_INFO * pAna );

	CG_STATUS				PteMarshallAnalysis( ANALYSIS_INFO * pAna );

	virtual
	CG_STATUS				CorePteMarshallAnalysis( ANALYSIS_INFO * pAna )
								{
								return ((CG_NDR *)GetChild())->MarshallAnalysis( pAna );
								}

	CG_STATUS				PtrUnMarshallAnalysis( ANALYSIS_INFO * pAna );

	CG_STATUS				PteUnMarshallAnalysis( ANALYSIS_INFO * pAna );

	virtual
	CG_STATUS				FollowerMarshallAnalysis( ANALYSIS_INFO * pAna );

	virtual
	CG_STATUS				FollowerUnMarshallAnalysis( ANALYSIS_INFO * pAna );

	virtual
	CG_STATUS				GenConfVarianceEtcUnMarshall( CCB * pCCB )
								{
								return CG_OK;
								}

	virtual
	CG_STATUS				CorePteUnMarshallAnalysis( ANALYSIS_INFO * pAna )
								{
								return ((CG_NDR *)GetChild())->UnMarshallAnalysis( pAna );
								}

	virtual
	U_ACTION				RecommendUAction( SIDE		CurrentSide,
											  BOOL		fMemoryAllocated,
											  BOOL		fRefAllocated,
											  BOOL		fBufferReUsePossible,
											  UAFLAGS	AdditionalFlags );

	void					RecommendAlignmentAdjustment(
									ALIGNMENT_PROPERTY	AlBeforePteMarshall,
									ALIGNMENT_PROPERTY	AlAfterPteMarshall,
									ALIGNMENT_PROPERTY	TargetAlignment,
									STM_ACTION	*		ActionInIfClause,
									STM_ACTION	*		ActionInElseClause,
									STM_ACTION	*		ActionOutSideIfClause);


	virtual
	CG_STATUS				GenFree( CCB * pCCB );

	BOOL					IsQualifiedPointer()
								{
								return (GetCGID() != ID_CG_PTR );
								}

	virtual
	CG_STATUS				GenAllocateForUnMarshall( CCB * pCCB );

	virtual
	CG_STATUS				GenBasicUnMarshall( CCB * pCCB );

	void					PointerChecks( CCB * pCCB );

	void					EndPointerChecks( CCB * pCCB );

	_expr_node	*			FinalSizeExpression( CCB * pCCB );

	_expr_node	*			FinalLengthExpression( CCB * pCCB );

	_expr_node	*			FinalFirstExpression( CCB * pCCB );

	virtual
	CG_STATUS				GenRefChecks( CCB * pCCB );

	virtual
	CG_STATUS				InLocalAnalysis( ANALYSIS_INFO * pAna );

	virtual
	CG_STATUS				S_GenInitInLocals( CCB * pCCB );

    virtual
    void                    SetNextNdrAlignment( CCB * pCCB );
	};

//
// This class corresponds to a byte_counted pointer type. 
//

class CG_BYTE_COUNT_POINTER	: public CG_POINTER
	{
private:
	// the byte count param

	node_param	*			pByteCountParam;

public:
	
	//
	// The constructor.
	//

							CG_BYTE_COUNT_POINTER(
												 node_skl * pBT,
												 PTRTYPE	p,
												 node_param *	pParam ) : 
								CG_POINTER( pBT, p, 0 )
								{
								SetByteCountParam( pParam );
								}

	virtual
	ID_CG					GetCGID()
								{
								return ID_CG_BC_PTR;
								}

	void					GenNdrFormat( CCB * pCCB );

	//
	// Get and Set methods.
	//

	node_param *			GetByteCountParam()
								{
								return pByteCountParam;
								}

	node_param *			SetByteCountParam( node_param * p )
								{
								return (pByteCountParam = p);
								}
	};

//
// This class corresponds to an [ignore]'d pointer type.
// It derives from CG_NDR, but is really just a filler, with memsize but
// no wiresize 
//

class CG_IGNORED_POINTER	: public CG_NDR
	{
private:
public:
	
	//
	// The constructor.
	//

							CG_IGNORED_POINTER(
												 node_skl * pBT ) : 
								CG_NDR( pBT, (unsigned short) 1 )
								{
								}

	virtual
	ID_CG					GetCGID()
								{
								return ID_CG_IGN_PTR;
								}

	// 
	// Ndr format string generation method.
	//
	virtual
	void 					GenNdrFormat( CCB * pCCB )
								{
								pCCB->GetFormatString()->
									  PushFormatChar( FC_IGNORE );
								}

	};


////////////////////////////////////////////////////////////////////////////
// This class corresponds to a string pointer type. 
////////////////////////////////////////////////////////////////////////////

class CG_QUALIFIED_POINTER	: public CG_POINTER
	{
private:
	RESOURCE			*	pSizeResource;
	RESOURCE			*	pLengthResource;
	RESOURCE			*	pFirstResource;
	RESOURCE			*	pMinResource;
	unsigned long			fUsedInArray;
    long                    Dimension;
public:

							CG_QUALIFIED_POINTER( node_skl * pBT,
												  PTRTYPE	 p,
												  short 	 AD ) :
												  CG_POINTER( pBT, p, AD )
								{
								pSizeResource	= 0;
								pLengthResource	= 0;
								pFirstResource	= 0;
								pMinResource	= 0;
								fUsedInArray	= 0;
                                SetDimension(0);
								}

							CG_QUALIFIED_POINTER( 
									CG_QUALIFIED_POINTER * pNode ) :
								CG_POINTER( pNode->GetType(),
											pNode->GetPtrType(),
											pNode->GetAllocateDetails() )
								{
								*this = *pNode;
								}

	void					SetUsedInArray()
								{
								fUsedInArray = 1;
								}
	BOOL					IsUsedInArray()
								{
								return (BOOL)(fUsedInArray == 1);
								}

	RESOURCE			*	SetSizeResource( RESOURCE * pR )
								{
								return pSizeResource = pR;
								}

	RESOURCE			*	GetSizeResource()
								{
								return pSizeResource;
								}

	RESOURCE			*	SetLengthResource( RESOURCE * pR )
								{
								return pLengthResource = pR;
								}

	RESOURCE			*	GetLengthResource()
								{
								return pLengthResource;
								}

	RESOURCE			*	SetFirstResource( RESOURCE * pR )
								{
								return pFirstResource = pR;
								}

	RESOURCE			*	GetFirstResource()
								{
								return pFirstResource;
								}

    void                    SetDimension( long Dim )
                                {
                                Dimension = Dim;
                                }

    long                    GetDimension()
                                {
                                return Dimension;
                                }

	virtual
	CG_STATUS				CorePteMarshallAnalysis( ANALYSIS_INFO * pAna );

	virtual
	CG_STATUS				CorePteUnMarshallAnalysis( ANALYSIS_INFO * pAna );

	virtual
	CG_STATUS				GenCorePteSizing( CCB * pCCB );

	virtual
	BOOL					NeedsMaxCountMarshall()
								{
								return FALSE;
								}

	virtual
	BOOL					NeedsFirstAndLengthMarshall()
								{
								return FALSE;
								}
	virtual
	BOOL					NeedsExplicitFirst()
								{
								return TRUE;
								}

	virtual
	_expr_node			*	GetQPFirstIsExpression()
								{
								return pFirstResource;
								}
	virtual
	_expr_node			*	GetQPLengthIsExpression()
								{
								return pLengthResource;
								}

	virtual
	_expr_node			*	GetQPMinIsExpression()
								{
								return pMinResource;
								}
	virtual
	_expr_node			*	GetQPSizeIsExpression()
								{
								return pSizeResource;
								}

	virtual
	CG_STATUS				GenCorePteMarshall( CCB * pCCB );

	virtual
	CG_STATUS				GenBasicUnMarshall( CCB * pCCB );

	virtual
	CG_STATUS				GenQPMarshall( CCB * pCCB );

	virtual
	CG_STATUS				GenQPUnMarshall( CCB * pCCB );
	};

class CG_STRING_POINTER	: public CG_QUALIFIED_POINTER
	{
public:
	
	//
	// The constructor.
	//

							CG_STRING_POINTER(
											 node_skl * pBT,
											 PTRTYPE	p,
									 		 short		AD  ) : 
									CG_QUALIFIED_POINTER( pBT, p, AD )
								{
								}

							CG_STRING_POINTER( CG_STRING_POINTER * pNode ) :
									CG_QUALIFIED_POINTER( pNode )
								{
								*this = *pNode;
								}

	virtual
	ID_CG					GetCGID()
								{
                                //
                                // For regular string pointers only (not for
                                // sized string pointers), we have a different
                                // CG id for string structs.  This is for all
                                // of the places that we check for a GetCGID()
                                // of ID_CG_STRING_PTR when it shouldn't apply
                                // for stringable structs.
                                //
								return IsStringableStruct() ? 
                                            ID_CG_STRUCT_STRING_PTR : 
                                            ID_CG_STRING_PTR;
								}

    BOOL                    IsStringableStruct()
                                {
                                CG_NDR * pChild = (CG_NDR *) GetChild();
                                return (pChild->GetCGID() != ID_CG_BT);
								}

	// 
	// Ndr format string generation method.
	//

	virtual
	void 					GenNdrFormat( CCB * pCCB );

	//
	// This routine always generates the format string for a pointer.  Used
	// by GenNdrFormat and GenNdrImbededFormat().  
	//
	virtual
	void					GenNdrFormatAlways( CCB * pCCB );

	//
	// Ndr format string generation for the pointee.  
	//
	virtual
	void					GenNdrFormatPointee( CCB * pCCB );

	virtual
	CG_STATUS				GenConfVarianceEtcUnMarshall( CCB * pCCB );

	virtual
	BOOL					NeedsMaxCountMarshall()
								{
								return TRUE;
								}

	virtual
	_expr_node			*	GetQPFirstIsExpression()
								{
								return new _expr_constant( 0L );
								}
	virtual
	_expr_node			*	GetQPMinIsExpression()
								{
								return new _expr_constant( 0L );
								}
	virtual
	BOOL					NeedsFirstAndLengthMarshall()
								{
								return TRUE;
								}
	virtual
	BOOL					NeedsExplicitFirst()
								{
								return FALSE;
								}
	virtual
	_expr_node			*	PresentedSizeExpression( CCB * pCCB );

	virtual
	_expr_node			*	PresentedLengthExpression( CCB * pCCB );

	virtual
	_expr_node			*	PresentedFirstExpression( CCB * pCCB )
								{
								return new _expr_constant(0L);
								}
					
	virtual
	CG_STATUS				GenCorePteMarshall( CCB * pCCB );

	virtual
	CG_STATUS				GenBasicUnMarshall( CCB * pCCB );

	virtual
	CG_STATUS				GenCorePteSizing( CCB * pCCB );

    virtual
    void                    SetNextNdrAlignment( CCB * pCCB );
	};

//
// This class corresponds to a sized string pointer type. 
//

class CG_SIZE_STRING_POINTER	: public CG_STRING_POINTER,
								  public CG_CONF_ATTRIBUTE
	{
private:
public:
	
	//
	// The constructor.
	//

							CG_SIZE_STRING_POINTER(
													 node_skl * pBT,
													 PTRTYPE	p,
									 				 short		AD , 
													 FIELD_ATTR_INFO * pFA ) : 
									CG_STRING_POINTER( pBT, p, AD ),
									CG_CONF_ATTRIBUTE( pFA )
								{
								}

							CG_SIZE_STRING_POINTER( 
									CG_SIZE_STRING_POINTER * pNode ) :
								CG_STRING_POINTER( pNode ),
								CG_CONF_ATTRIBUTE( pNode )
								{
								*this = *pNode;
								}

	virtual
	ID_CG					GetCGID()
								{
								return ID_CG_SIZE_STRING_PTR;
								}

	CG_SIZE_STRING_POINTER * 
							Clone()
								{
								return new CG_SIZE_STRING_POINTER( this );
								}

	// 
	// Ndr format string generation method.
	//
	virtual
	void 					GenNdrFormat( CCB * pCCB );

	//
	// This routine always generates the format string for a pointer.  Used
	// by GenNdrFormat and GenNdrImbededFormat().  
	//
	virtual
	void					GenNdrFormatAlways( CCB * pCCB );

	//
	// Ndr format string generation for the pointee.  
	//
	virtual
	void					GenNdrFormatPointee( CCB * pCCB );

	virtual
	_expr_node			*	GetQPFirstIsExpression()
								{
								return new _expr_constant(0L);
								}
	virtual
	_expr_node			*	GetQPMinIsExpression()
								{
								return new _expr_constant(0L);
								}
	virtual
	_expr_node			*	PresentedSizeExpression( CCB * pCCB );
					
	virtual
	CG_STATUS				GenCorePteMarshall( CCB * pCCB );

	virtual
	CG_STATUS				GenCorePteUnMarshall( CCB * pCCB )
								{
								return ((CG_QUALIFIED_POINTER *)this)->GenBasicUnMarshall( pCCB );
								}
	virtual
	CG_STATUS				GenBasicUnMarshall( CCB * pCCB );
	};

//
// This class corresponds to a sized pointer type. 
//

class CG_SIZE_POINTER	: public CG_QUALIFIED_POINTER, 
						  public CG_CONF_ATTRIBUTE
	{
private:
public:
	
	//
	// The constructor.
	//

							CG_SIZE_POINTER(
											 node_skl * pBT,
											 PTRTYPE	p,
									 		 short		AD ,
											 FIELD_ATTR_INFO * pFA ) : 
									CG_QUALIFIED_POINTER( pBT, p, AD ),
									CG_CONF_ATTRIBUTE( pFA )
								{
								}

							CG_SIZE_POINTER( CG_SIZE_POINTER * pNode ) :
								CG_QUALIFIED_POINTER( pNode ),
								CG_CONF_ATTRIBUTE( pNode )
								{
								*this = *pNode;
								}

	virtual
	ID_CG					GetCGID()
								{
								return ID_CG_SIZE_PTR;
								}

	CG_SIZE_POINTER *		Clone()
								{
								return new CG_SIZE_POINTER( this );
								}

	//
	// Sized pointers use inherited CG_POINTER GenNdrFormat virtual method.
	//

	//
	// Ndr format string generation for the pointee.
	//
	void 					GenNdrFormatPointee( CCB * pCCB );

	virtual
	BOOL					NeedsMaxCountMarshall()
								{
								return TRUE;
								}

	virtual
	BOOL					NeedsFirstAndLengthMarshall()
								{
								return FALSE;
								}

	virtual
	_expr_node			*	GetQPFirstIsExpression()
								{
								return new _expr_constant(0L);
								}
	virtual
	_expr_node			*	GetQPLengthIsExpression()
								{
								return new _expr_constant(0L);
								}

	virtual
	_expr_node			*	GetQPMinIsExpression()
								{
								return GetMinIsExpr();
								}
	virtual
	_expr_node			*	GetQPSizeIsExpression()
								{
								return GetSizeIsExpr();
								}
	virtual
	_expr_node			*	PresentedSizeExpression( CCB * pCCB );
					
	virtual
	_expr_node			*	PresentedFirstExpression( CCB * pCCB )
								{
								return new _expr_constant( 0L );
								}
	};

//
// This class corresponds to a lengthed pointer type. 
//

class CG_LENGTH_POINTER	: public CG_QUALIFIED_POINTER, 
						  public CG_VARY_ATTRIBUTE
	{
private:
public:
	
	//
	// The constructor.
	//

							CG_LENGTH_POINTER(
											 node_skl * pBT,
											 PTRTYPE	p,
									 		 short		AD ,
											 FIELD_ATTR_INFO * pFA ) : 
									CG_QUALIFIED_POINTER( pBT, p, AD ),
									CG_VARY_ATTRIBUTE( pFA )
								{
								}

	virtual
	ID_CG					GetCGID()
								{
								return ID_CG_LENGTH_PTR;
								}


	virtual
	BOOL					NeedsMaxCountMarshall()
								{
								return FALSE;
								}

	virtual
	BOOL					NeedsFirstAndLengthMarshall()
								{
								return TRUE;
								}

	virtual
	_expr_node			*	GetQPFirstIsExpression()
								{
								return GetFirstIsExpr();
								}
	virtual
	_expr_node			*	GetQPLengthIsExpression()
								{
								return GetLengthIsExpr();
								}

	virtual
	_expr_node			*	GetQPMinIsExpression()
								{
								return new _expr_constant(0L);
								}

	virtual
	_expr_node			*	GetQPSizeIsExpression()
								{
								return new _expr_constant(0L);
								}
	virtual
	_expr_node			*	PresentedLengthExpression( CCB * pCCB );
					
	virtual
	_expr_node			*	PresentedFirstExpression( CCB * pCCB );
	};

//
// This class corresponds to a sized and lengthed pointer type. 
//

class CG_SIZE_LENGTH_POINTER	: public CG_QUALIFIED_POINTER, 
								  public CG_CONF_ATTRIBUTE,
								  public CG_VARY_ATTRIBUTE
	{
private:
public:
	
	//
	// The constructor.
	//

							CG_SIZE_LENGTH_POINTER(
												 node_skl * pBT,
												 PTRTYPE	p,
									 			 short		AD,
												 FIELD_ATTR_INFO * pFA ) : 
									CG_QUALIFIED_POINTER( pBT, p, AD ),
									CG_CONF_ATTRIBUTE( pFA ),
									CG_VARY_ATTRIBUTE( pFA )
								{
								}

							CG_SIZE_LENGTH_POINTER( 
									CG_SIZE_LENGTH_POINTER * pNode ) :
								CG_QUALIFIED_POINTER( pNode ),
								CG_CONF_ATTRIBUTE( pNode ),
								CG_VARY_ATTRIBUTE( pNode )
								{
								*this = *pNode;
								}

	virtual
	ID_CG					GetCGID()
								{
								return ID_CG_SIZE_LENGTH_PTR;
								}

	CG_SIZE_LENGTH_POINTER * 
							Clone()
								{
								return new CG_SIZE_LENGTH_POINTER( this );
								}

	//
	// Size-Length pointers use inherited CG_POINTER GenNdrFormat 
	// virtual method.
	//

	//
	// Ndr format string generation for the pointee.
	//
	void 					GenNdrFormatPointee( CCB * pCCB );

	virtual
	BOOL					NeedsMaxCountMarshall()
								{
								return TRUE;
								}

	virtual
	BOOL					NeedsFirstAndLengthMarshall()
								{
								return TRUE;
								}
	virtual
	_expr_node			*	GetQPFirstIsExpression()
								{
								return GetFirstIsExpr();
								}
	virtual
	_expr_node			*	GetQPLengthIsExpression()
								{
								return GetLengthIsExpr();
								}

	virtual
	_expr_node			*	GetQPMinIsExpression()
								{
								return GetMinIsExpr();
								}
	virtual
	_expr_node			*	GetQPSizeIsExpression()
								{
								return GetSizeIsExpr();
								}
	virtual
	_expr_node			*	PresentedSizeExpression( CCB * pCCB );
					
	virtual
	_expr_node			*	PresentedLengthExpression( CCB * pCCB );
					
	virtual
	_expr_node			*	PresentedFirstExpression( CCB * pCCB );
	};


//
// This class corresponds to an interface pointer type. 
//

class CG_INTERFACE_POINTER	: public CG_POINTER
	{
private:

	expr_node		*	pIIDExpr;
	node_interface	*	pMyIntf;

public:
	
	//
	// The constructor.
	//

							CG_INTERFACE_POINTER(node_skl * pBT,
												 node_skl * pInt, 
												 expr_node * pIIDEx) : 
								CG_POINTER( pBT, PTR_REF, 0 )
								{
								SetIIDExpr( pIIDEx );
								SetTheInterface( pInt );
								}

	virtual
	ID_CG					GetCGID()
								{
								return ID_CG_INTERFACE_PTR;
								}

	void					GenNdrFormat( CCB * pCCB );

	// This routine always generates the format string for a pointer.  Used
	// by GenNdrFormat and GenNdrImbededFormat().  
	//
	virtual
	void					GenNdrFormatAlways( CCB * pCCB );

	//
	// Inherited from CG_NDR.
	//
    BOOL                    ShouldFreeOffline()
								{
								return TRUE;
								}

	//
	// Get and Set methods.
	//
	
	expr_node			*	SetIIDExpr( expr_node * pE )
								{
								return ( pIIDExpr = pE );
								}

	expr_node			*	GetIIDExpr()
								{
								return pIIDExpr;
								}

	node_interface		*	SetTheInterface( node_skl * pI )
								{
								return ( pMyIntf = (node_interface *) pI );
								}

	node_interface		*	GetTheInterface()
								{
								return pMyIntf;
								}

	virtual
	CG_STATUS				S_OutLocalAnalysis( ANALYSIS_INFO * pAna );

	virtual
	CG_STATUS               MarshallAnalysis( ANALYSIS_INFO * pAna );

    virtual
    CG_STATUS               UnMarshallAnalysis( ANALYSIS_INFO * pAna )
                                {
                                UNUSED( pAna );
                                return CG_OK;
                                }
    virtual
    CG_STATUS               RefCheckAnalysis( ANALYSIS_INFO * pAna )
                                {
                                UNUSED( pAna );
                                return CG_OK;
                                }
	virtual
	CG_STATUS				InLocalAnalysis( ANALYSIS_INFO * pAna )
	                            {
	                            UNUSED( pAna );
	                            return CG_OK;
	                            }
	virtual
	CG_STATUS				S_GenInitOutLocals( CCB * pCCB );

	virtual
	CG_STATUS				S_GenInitInLocals( CCB * pCCB )
	                            {
	                            UNUSED( pCCB );
	                            return CG_OK;
	                            }

	virtual
	CG_STATUS               GenRefChecks( CCB * pCCB )
	                            {
	                            UNUSED( pCCB );
	                            return CG_OK;
	                            }
	//
	// Ndr format string generation for the pointee.  
	//
	virtual
	void					GenNdrFormatPointee( CCB * pCCB )
	                            {
	                            }
	};

#endif // __PTRCLS_HXX__
