//
// CRASHDUMP: This program dumps the header of a memory dump file
//            generated by the Windows NT crashdump facility.
//
// AUTHOR: Mike Glass (mglass)
//
// DATE: June 4, 1994
//

#include <nt.h>
#include <ntrtl.h>
#include <nturtl.h>
#include <ntiodump.h>

#include <windows.h>
#include <stdio.h>
#include <process.h>
#include <stdlib.h>

//
// The following two structure definitions were copied from MM.H.
//

typedef struct _PHYSICAL_MEMORY_RUN {
    ULONG BasePage;
    ULONG PageCount;
} PHYSICAL_MEMORY_RUN, *PPHYSICAL_MEMORY_RUN;

typedef struct _PHYSICAL_MEMORY_DESCRIPTOR {
    ULONG NumberOfRuns;
    ULONG NumberOfPages;
    PHYSICAL_MEMORY_RUN Run[1];
} PHYSICAL_MEMORY_DESCRIPTOR, *PPHYSICAL_MEMORY_DESCRIPTOR;

int _CRTAPI1
main( int argc, char **argv )
{
    HANDLE handle;
    ULONG bytesRead;
    ULONG i;
    PDUMP_HEADER header;
    PPHYSICAL_MEMORY_DESCRIPTOR descriptor;
    PPHYSICAL_MEMORY_RUN memoryRun;
    char *fileName = argv[1];
    PULONG buffer[0x400];

    if (argc < 2) {
        printf ("usage: crashdump memory.dmp\n");
        exit (1);
    }

    //
    // Do some filename preprocessing that I blindly stole from Ken Reneris's
    // hex edit program.
    //

    if ((strncmp(argv[1], "\\\\.\\", 4)) == 0) {
        char *cp;
        int   index;

        // Insure there is a backslash on the DosName being opened.
        for (cp = argv[1], index = 0; *cp; *cp++, index++) {
            // action in for loop
        }
        cp--;
        if (*cp != '\\') {

            // Need to add backslash to name.

            fileName = GlobalAlloc (0,index + 4);
            for (cp = argv[1], index = 0; fileName[index] = *cp; *cp++, index++) {
                // action in for loop
            }
            fileName[index] = '\\';
            fileName[index + 1] = '\0';
        }
    }

    //
    // Display banner.
    //

    printf("\nWindows NT CRASHDUMP Memory Header Dump\n");

    //
    // Open memory dump file.
    //

    handle = CreateFile(fileName,
                        GENERIC_READ | GENERIC_WRITE,
                        FILE_SHARE_READ | FILE_SHARE_WRITE,
                        NULL,
                        OPEN_EXISTING,
                        0,
                        NULL);

    if (handle == INVALID_HANDLE_VALUE) {
        printf("Can't open %s (%x)\n",
               fileName,
               GetLastError());
        exit(4);
    }

    printf("\nMemory dump file: %s\n",
           fileName);

    //
    // Read memory dump file.
    //

    if (!ReadFile(handle,
                  buffer,
                  0x1000,
                  &bytesRead,
                  NULL)) {

        printf("Can't read %s (%x)\n",
               fileName,
               GetLastError());
        exit(4);
    }

    //
    // Display memory header information.
    //

    header = (PDUMP_HEADER)&buffer[0];

    if (header->ValidDump != 'PMUD') {
        printf("%s is not a valid memory dump\n",
               fileName);
        exit(4);
    }

    //
    // Display version numbers.
    //

    printf("Major version: %x\n",
           header->MajorVersion);
    printf("Minor version: %x\n",
           header->MinorVersion);

    //
    // Display memory machine type.
    //

    printf("\nMachine image type: ");
    switch (header->MachineImageType) {
    case IMAGE_FILE_MACHINE_I386:
        printf("X86\n");
        break;
    case IMAGE_FILE_MACHINE_R4000:
        printf("Mips\n");
        break;
    case IMAGE_FILE_MACHINE_ALPHA:
        printf("Alpha\n");
        break;
    default:
        printf("Unknown\n");
        break;
    }

    printf("Number of processors: %x\n",
           header->NumberProcessors);

    //
    // Display miscellaneous spooge.
    //

    printf("\nDirectory table base: %x\n",
           header->DirectoryTableBase);
    printf("PFN data base: %x\n",
           header->PfnDataBase);
    printf("Loaded module list: %x\n",
           header->PsLoadedModuleList);
    printf("Active process head: %x\n",
           header->PsActiveProcessHead);

    //
    // Display bug check data.
    //

    printf("\nBug check code: %x\n",
           header->BugCheckCode);
    printf("Bug check parameter 1: %x\n",
           header->BugCheckParameter1);
    printf("Bug check parameter 2: %x\n",
           header->BugCheckParameter2);
    printf("Bug check parameter 3: %x\n",
           header->BugCheckParameter3);
    printf("Bug check parameter 4: %x\n",
           header->BugCheckParameter4);

    //
    // Display physical memory information.
    //

    descriptor =
        (PPHYSICAL_MEMORY_DESCRIPTOR)&buffer[DH_PHYSICAL_MEMORY_BLOCK];

    printf("\nNumber of memory runs: %x\n",
           descriptor->NumberOfRuns);
    printf("Number of pages: %x\n",
           descriptor->NumberOfPages);

    for (i = 0; i < descriptor->NumberOfRuns; i++) {
        memoryRun = (PPHYSICAL_MEMORY_RUN)&descriptor->Run[0];
        printf("\nMemory run %x:\n",
               i);
        printf("    Starting page %x\n",
               memoryRun->BasePage);
        printf("    Number of pages %x\n",
               memoryRun->PageCount);
    }

    return(0);
}


