#include <windows.h>
#include <stdarg.h>
#include <string.h>
#include "saverest.h"
#include "logger.h"

/*
** Some C functions which are not generated by the trace30.tt template
*/

LONG FAR PASCAL MesgProc(
    HWND    hWnd,
    WORD    wMsg,
    WORD    wParam,
    LONG    lParam,
    FARPROC fp,
    WORD    AX
) {
    LONG    l;

    SaveRegs() ;
    LogIn( (LPSTR)"MSGCALL:FARPROC+HWND+MSGNUM+WORD+LONG+",
        fp, hWnd, wMsg, wParam, lParam );

    RestoreRegs() ;
    GrovelDS();
    l = HookCall( hWnd, wMsg, wParam, lParam, fp, AX );
    UnGrovelDS() ;

    SaveRegs() ;
    LogOut( (LPSTR)"MSGRET:LONG+FARPROC+MSGNUM+WORD+LONG+",
        l, fp, hWnd, wMsg, wParam, lParam );
    RestoreRegs() ;

    return( l );
}

int FAR PASCAL DlgMesgProc(
    HWND    hWnd,
    WORD    wMsg,
    WORD    wParam,
    LONG    lParam,
    FARPROC fp,
    WORD    AX
) {
    int     i;

    SaveRegs() ;
    LogIn( (LPSTR)"MSGCALL:FARPROC+HWND+MSGNUM+WORD+LONG+",
        fp, hWnd, wMsg, wParam, lParam );

    RestoreRegs() ;
    GrovelDS();
    i = HookCall( hWnd, wMsg, wParam, lParam, fp, AX );
    UnGrovelDS();
    SaveRegs() ;

    LogOut( (LPSTR)"MSGRET:LONG+FARPROC+MSGNUM+WORD+LONG+",
        (LONG)i, fp, hWnd, wMsg, wParam, lParam );

    RestoreRegs() ;
    return( i );
}


BOOL far pascal zRegisterClass( LPWNDCLASS pp1 )
{
    BOOL r;
    WNDCLASS wc;

    SaveRegs() ;
    /*
    ** Log IN Parameters (No Create/Destroy Checking Yet!)
    */
    LogIn( (LPSTR)"APICALL:RegisterClass LPWNDCLASS+",
        pp1 );

    wc = *pp1;

    wc.lpfnWndProc = (LONG (FAR PASCAL *)())
                     HookAdd( (void far *)MesgProc,
                              (void far *)pp1->lpfnWndProc );
    /*
    ** Call the API!
    */
    RestoreRegs() ;

    GrovelDS();
    r = RegisterClass( (LPWNDCLASS)&wc );
    UnGrovelDS();
    SaveRegs() ;

    /*
    ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
    */
    LogOut( (LPSTR)"APIRET:RegisterClass ATOM++",
        r, (short)0 );

    RestoreRegs() ;
    return( r );
}


HWND far pascal zCreateDialog( HANDLE pp1, LPSTR pp2, HWND pp3, FARPROC pp4 )
{
    HWND r;
    FARPROC fp ;

    SaveRegs();

    fp = pp4 ;

    if (fp) {
        pp4 = (FARPROC)HookAdd( (void far *)DlgMesgProc,
            (void far *)fp );
    }

    /*
    ** Log IN Parameters (No Create/Destroy Checking Yet!)
    */
    LogIn( (LPSTR)"APICALL:CreateDialog HANDLE+LPSTR+HWND+FARPROC+",
        pp1, pp2, pp3, pp4 );

    /*
    ** Call the API!
    */
    RestoreRegs();
    GrovelDS();
    r = CreateDialog(pp1,pp2,pp3,pp4);
    UnGrovelDS();
    SaveRegs();
    /*
    ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
    */
    LogOut( (LPSTR)"APIRET:CreateDialog HWND+++++",
        r, (short)0, (short)0, (short)0, (short)0 );

    RestoreRegs();
    return( r );
}

HWND far pascal zCreateDialogIndirect( HANDLE pp1, LPSTR pp2, HWND pp3, FARPROC pp4 )
{
    HWND r;
    FARPROC fp ;

    SaveRegs();

    fp = pp4 ;

    /*
        Changed 6-12-91 by BobK- if WNDPROC is null, don't hook it- it's
        already hooked at a higher level!
    */
    if  (pp4) {
      pp4 = (FARPROC)HookAdd( (void far *)DlgMesgProc,
            (void far *)fp );
    }

    /*
    ** Log IN Parameters (No Create/Destroy Checking Yet!)
    */
    LogIn( (LPSTR)"APICALL:CreateDialogIndirect HANDLE+LPSTR+HWND+FARPROC+",
        pp1, pp2, pp3, pp4 );

    /*
    ** Call the API!
    */
    RestoreRegs();
    GrovelDS();
    r = CreateDialogIndirect(pp1,pp2,pp3,pp4);
    UnGrovelDS();
    SaveRegs();
    /*
    ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
    */
    LogOut( (LPSTR)"APIRET:CreateDialogIndirect HWND+++++",
        r, (short)0, (short)0, (short)0, (short)0 );

    RestoreRegs();
    return( r );
}

HWND far pascal zCreateDialogIndirectParam( HANDLE pp1, LPSTR pp2, HWND pp3, FARPROC pp4, long pp5 )
{
    HWND r;
    FARPROC fp ;

    SaveRegs();

    fp = pp4 ;

    if (fp) {
        pp4 = (FARPROC)HookAdd( (void far *)DlgMesgProc,
            (void far *)fp );
    }

    /*
    ** Log IN Parameters (No Create/Destroy Checking Yet!)
    */
    LogIn( (LPSTR)"APICALL:CreateDialogIndirectParam HANDLE+LPSTR+HWND+FARPROC+long+",
        pp1, pp2, pp3, pp4, pp5 );

    /*
    ** Call the API!
    */
    RestoreRegs();
    GrovelDS();
    r = CreateDialogIndirectParam(pp1,pp2,pp3,pp4,pp5);
    UnGrovelDS();
    SaveRegs();
    /*
    ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
    */
    LogOut( (LPSTR)"APIRET:CreateDialogIndirectParam HWND++++++",
        r, (short)0, (short)0, (short)0, (short)0, (short)0 );

    RestoreRegs();
    return( r );
}

HWND far pascal zCreateDialogParam( HANDLE pp1, LPSTR pp2, HWND pp3, FARPROC pp4, long pp5 )
{
    HWND r;
    FARPROC fp ;

    SaveRegs();

    fp = pp4 ;

    if (fp) {
        pp4 = (FARPROC)HookAdd( (void far *)DlgMesgProc,
                (void far *)fp );
    }

    /*
    ** Log IN Parameters (No Create/Destroy Checking Yet!)
    */
    LogIn( (LPSTR)"APICALL:CreateDialogParam HANDLE+LPSTR+HWND+FARPROC+long+",
        pp1, pp2, pp3, pp4, pp5 );

    /*
    ** Call the API!
    */
    RestoreRegs();
    GrovelDS();
    r = CreateDialogParam(pp1,pp2,pp3,pp4,pp5);
    UnGrovelDS();
    SaveRegs();
    /*
    ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
    */
    LogOut( (LPSTR)"APIRET:CreateDialogParam HWND++++++",
        r, (short)0, (short)0, (short)0, (short)0, (short)0 );

    RestoreRegs();
    return( r );
}


int far pascal zDialogBox( HANDLE pp1, LPSTR pp2, HWND pp3, FARPROC pp4 )
{
    int r;
    FARPROC fp ;

    SaveRegs();

    fp = pp4 ;

    if (fp) {
        pp4 = (FARPROC)HookAdd( (void far *)DlgMesgProc,
            (void far *)fp );
    }

    /*
    ** Log IN Parameters (No Create/Destroy Checking Yet!)
    */
    LogIn( (LPSTR)"APICALL:DialogBox HANDLE+LPSTR+HWND+FARPROC+",
        pp1, pp2, pp3, pp4 );

    /*
    ** Call the API!
    */
    RestoreRegs();
    GrovelDS();
    r = DialogBox(pp1,pp2,pp3,pp4);
    UnGrovelDS();
    SaveRegs();
    /*
    ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
    */
    LogOut( (LPSTR)"APIRET:DialogBox int+++++",
        r, (short)0, (short)0, (short)0, (short)0 );

    RestoreRegs();
    return( r );
}

int far pascal zDialogBoxIndirect( HANDLE pp1, HANDLE pp2, HWND pp3, FARPROC pp4 )
{
    int r;
    FARPROC fp ;

    SaveRegs();

    fp = pp4 ;

    if (fp) {
        pp4 = (FARPROC)HookAdd( (void far *)DlgMesgProc,
            (void far *)fp );
    }

    /*
    ** Log IN Parameters (No Create/Destroy Checking Yet!)
    */
    LogIn( (LPSTR)"APICALL:DialogBoxIndirect HANDLE+HANDLE+HWND+FARPROC+",
        pp1, pp2, pp3, pp4 );

    /*
    ** Call the API!
    */
    RestoreRegs();
    GrovelDS();
    r = DialogBoxIndirect(pp1,pp2,pp3,pp4);
    UnGrovelDS();
    SaveRegs();
    /*
    ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
    */
    LogOut( (LPSTR)"APIRET:DialogBoxIndirect int+++++",
        r, (short)0, (short)0, (short)0, (short)0 );

    RestoreRegs();
    return( r );
}

int far pascal zDialogBoxIndirectParam( HANDLE pp1, HANDLE pp2, HWND pp3, FARPROC pp4, long pp5 )
{
    int r;
    FARPROC fp ;

    SaveRegs();
   
    fp = pp4 ;

    if (fp) {
        pp4 = (FARPROC)HookAdd( (void far *)DlgMesgProc,
                (void far *)fp );
    }

    /*
    ** Log IN Parameters (No Create/Destroy Checking Yet!)
    */
    LogIn( (LPSTR)"APICALL:DialogBoxIndirectParam HANDLE+HANDLE+HWND+FARPROC+long+",
        pp1, pp2, pp3, pp4, pp5 );

    /*
    ** Call the API!
    */
    RestoreRegs();
    GrovelDS();
    r = DialogBoxIndirectParam(pp1,pp2,pp3,pp4,pp5);
    UnGrovelDS();
    SaveRegs();
    /*
    ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
    */
    LogOut( (LPSTR)"APIRET:DialogBoxIndirectParam int++++++",
        r, (short)0, (short)0, (short)0, (short)0, (short)0 );

    RestoreRegs();
    return( r );
}

int far pascal zDialogBoxParam( HANDLE pp1, LPSTR pp2, HWND pp3, FARPROC pp4, long pp5 )
{
    int r;
    FARPROC fp ;

    SaveRegs();

    fp = pp4 ;

    if (fp) {
        pp4 = (FARPROC)HookAdd( (void far *)DlgMesgProc,
                (void far *)fp );
    }

    /*
    ** Log IN Parameters (No Create/Destroy Checking Yet!)
    */
    LogIn( (LPSTR)"APICALL:DialogBoxParam HANDLE+LPSTR+HWND+FARPROC+long+",
        pp1, pp2, pp3, pp4, pp5 );

    /*
    ** Call the API!
    */
    RestoreRegs();
    GrovelDS();
    r = DialogBoxParam(pp1,pp2,pp3,pp4,pp5);
    UnGrovelDS();
    SaveRegs();
    /*
    ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
    */
    LogOut( (LPSTR)"APIRET:DialogBoxParam int++++++",
        r, (short)0, (short)0, (short)0, (short)0, (short)0 );

    RestoreRegs();
    return( r );
}




/*
**
** HOOK STUFF
**
*/

LONG FAR PASCAL WH_CALLWNDPROCHook(
   int nCode, 
   WORD    wParam,
   LONG    lParam, 
   FARPROC fp,
   WORD    AX )
{
    LONG    l;

    SaveRegs() ;
    LogIn( (LPSTR)"HOOKCALL:WH_CALLWNDPROC FARPROC+int+WORD+LONG+",
        fp, nCode, wParam, lParam );

    RestoreRegs() ;
    GrovelDS();
    l = HookCall( nCode, wParam, lParam, fp, AX );
    UnGrovelDS();
    SaveRegs() ;

    LogOut( (LPSTR)"HOOKRET:WH_CALLWNDPROC LONG+FARPROC+int+WORD+LONG+",
        l, fp, nCode, wParam, lParam );

    RestoreRegs() ;
    return( l );
}


LONG FAR PASCAL WH_GETMESSAGEHook(
   int     nCode, 
   WORD    wParam,
   LONG    lParam,
   FARPROC fp,
   WORD    AX )
{
    LONG    l;

    SaveRegs() ;
    LogIn( (LPSTR)"HOOKCALL:WH_GETMESSAGE FARPROC+int+WORD+LPMSG+",
        fp, nCode, wParam, lParam );

    RestoreRegs() ;
    GrovelDS();
    l = HookCall( nCode, wParam, lParam, fp, AX );
    UnGrovelDS();
    SaveRegs() ;

    LogOut( (LPSTR)"HOOKRET:WH_GETMESSAGE LONG+FARPROC+int+WORD+LPMSG+",
        l, fp, nCode, wParam, lParam );

    RestoreRegs() ;
    return( l );
}


LONG FAR PASCAL WH_JOURNALPLAYBACKHook(
   int     nCode, 
   WORD    wParam,
   LONG    lParam,
   FARPROC fp,
   WORD    AX )
{
    LONG    l;

    SaveRegs() ;
    LogIn( (LPSTR)"HOOKCALL:WH_JOURNALPLAYBACK FARPROC+int+WORD+LPMSG+",
        fp, nCode, wParam, lParam );

    RestoreRegs() ;
    GrovelDS();
    l = HookCall( nCode, wParam, lParam, fp, AX );
    UnGrovelDS();
    SaveRegs() ;

    LogOut( (LPSTR)"HOOKRET:WH_JOURNALPLAYBACK LONG+FARPROC+int+WORD+LPMSG+",
        l, fp, nCode, wParam, lParam );

    RestoreRegs() ;
    return( l );
}


LONG FAR PASCAL WH_JOURNALRECORDHook(
   int     nCode, 
   WORD    wParam,
   LONG    lParam,
   FARPROC fp,
   WORD    AX )
{
    LONG    l;

    SaveRegs() ;
    LogIn( (LPSTR)"HOOKCALL:WH_JOURNALRECORD FARPROC+int+WORD+LPMSG+",
        fp, nCode, wParam, lParam );

    RestoreRegs() ;
    GrovelDS();
    l = HookCall( nCode, wParam, lParam, fp, AX );
    UnGrovelDS();

    SaveRegs() ;
    LogOut( (LPSTR)"HOOKRET:WH_JOURNALRECORD LONG+FARPROC+int+WORD+LPMSG+",
        l, fp, nCode, wParam, lParam );

    RestoreRegs() ;
    return( l );
}


LONG FAR PASCAL WH_KEYBOARDHook(
   int     nCode, 
   WORD    wParam,
   LONG    lParam,
   FARPROC fp,
   WORD    AX )
{
    LONG    l;

    SaveRegs() ;
    LogIn( (LPSTR)"HOOKCALL:WH_KEYBOARD FARPROC+int+WORD+LONG+",
        fp, nCode, wParam, lParam );

    RestoreRegs() ;
    GrovelDS();
    l = HookCall( nCode, wParam, lParam, fp, AX );
    UnGrovelDS();

    SaveRegs() ;
    LogOut( (LPSTR)"HOOKRET:WH_KEYBOARD LONG+FARPROC+int+WORD+LONG+",
        l, fp, nCode, wParam, lParam );
    RestoreRegs() ;

    return( l );
}


LONG FAR PASCAL WH_MSGFILTERHook(
   int     nCode, 
   WORD    wParam,
   LONG    lParam,
   FARPROC fp,
   WORD    AX )
{
    LONG    l;

    SaveRegs() ;
    LogIn( (LPSTR)"HOOKCALL:WH_MSGFILTER FARPROC+int+WORD+LPMSG+",
        fp, nCode, wParam, lParam );

    RestoreRegs() ;
    GrovelDS();
    l = HookCall( nCode, wParam, lParam, fp, AX );
    UnGrovelDS();
    SaveRegs() ;

    LogOut( (LPSTR)"HOOKRET:WH_MSGFILTER LONG+FARPROC+int+WORD+LPMSG+",
        l, fp, nCode, wParam, lParam );

    RestoreRegs() ;
    return( l );
}


LONG FAR PASCAL WH_SYSMSGFILTERHook(
   int     nCode, 
   WORD    wParam,
   LONG    lParam,
   FARPROC fp,
   WORD    AX )
{
    LONG    l;

    SaveRegs() ;
    LogIn( (LPSTR)"HOOKCALL:WH_SYSMSGFILTER FARPROC+int+WORD+LPMSG+",
        fp, nCode, wParam, lParam );

    RestoreRegs() ;
    GrovelDS();
    l = HookCall( nCode, wParam, lParam, fp, AX );
    UnGrovelDS();
    SaveRegs() ;

    LogOut( (LPSTR)"HOOKRET:WH_SYSMSGFILTER LONG+FARPROC+int+WORD+LPMSG+",
        l, fp, nCode, wParam, lParam );

    RestoreRegs() ;
    return( l );
}

LONG FAR PASCAL WH_CBTHook(
   int     nCode, 
   WORD    wParam,
   LONG    lParam,
   FARPROC fp,
   WORD    AX )
{
    LONG    l;

    SaveRegs() ;
    LogIn( (LPSTR)"HOOKCALL:WH_CBT FARPROC+int+WORD+LONG+",
        fp, nCode, wParam, lParam );

    RestoreRegs() ;
    GrovelDS();
    l = HookCall( nCode, wParam, lParam, fp, AX );
    UnGrovelDS();

    SaveRegs() ;
    LogOut( (LPSTR)"HOOKRET:WH_CBT LONG+FARPROC+int+WORD+LONG+",
        l, fp, nCode, wParam, lParam );

    RestoreRegs() ;
    return( l );
}

LONG FAR PASCAL WH_MOUSEHook(
   int     nCode, 
   WORD    wParam,
   LONG    lParam,
   FARPROC fp,
   WORD    AX )
{
    LONG    l;

    SaveRegs() ;
    LogIn( (LPSTR)"HOOKCALL:WH_MOUSE FARPROC+int+WORD+LONG+",
        fp, nCode, wParam, lParam );

    RestoreRegs() ;
    GrovelDS();
    l = HookCall( nCode, wParam, lParam, fp, AX );
    UnGrovelDS();

    SaveRegs() ;
    LogOut( (LPSTR)"HOOKRET:WH_MOUSE LONG+FARPROC+int+WORD+LONG+",
        l, fp, nCode, wParam, lParam );

    RestoreRegs() ;
    return( l );
}

LONG FAR PASCAL WH_DEBUGHook(
   int     nCode, 
   WORD    wParam,
   LONG    lParam,
   FARPROC fp,
   WORD    AX )
{
    LONG    l;

    SaveRegs() ;
    LogIn( (LPSTR)"HOOKCALL:WH_DEBUG FARPROC+int+WORD+LONG+",
        fp, nCode, wParam, lParam );

    RestoreRegs() ;
    GrovelDS();
    l = HookCall( nCode, wParam, lParam, fp, AX );
    UnGrovelDS();

    SaveRegs() ;
    LogOut( (LPSTR)"HOOKRET:WH_DEBUG LONG+FARPROC+int+WORD+LONG+",
        l, fp, nCode, wParam, lParam );

    RestoreRegs() ;
    return( l );
}



FARPROC far pascal zSetWindowsHook( int pp1, FARPROC pp2 )
{
   FARPROC  r;
   FARPROC  fp = pp2 ;
   BOOL     fUsable;

   SaveRegs();
   /*
   ** Log IN Parameters (No Create/Destroy Checking Yet!)
   */
   LogIn( (LPSTR)"APICALL:SetWindowsHook int+FARPROC+",
       pp1, pp2 );
   fUsable = TRUE;

   switch( pp1 )
   {
      case WH_CALLWNDPROC:
         fp = (FARPROC)HookAdd( (void far *)WH_CALLWNDPROCHook,
            (void far *)pp2 ) ;
         break ;

      case WH_GETMESSAGE:
         fp = (FARPROC)HookAdd( (void far *)WH_GETMESSAGEHook, 
            (void far *)pp2 ) ;
         break  ;

      case WH_JOURNALPLAYBACK:
         fp = (FARPROC)HookAdd( (void far *)WH_JOURNALPLAYBACKHook,
            (void far *)pp2 ) ;
         break ;

      case WH_JOURNALRECORD:
         fp = (FARPROC)HookAdd( (void far *)WH_JOURNALRECORDHook,
            (void far *)pp2 ) ;
         break ;

      case WH_KEYBOARD:
         fp = (FARPROC)HookAdd( (void far *)WH_KEYBOARDHook, 
            (void far *)pp2 ) ;
         break ;

      case WH_MSGFILTER:
         fp = (FARPROC)HookAdd( (void far *)WH_MSGFILTERHook, 
            (void far *)pp2 ) ;
         break ;

      case WH_SYSMSGFILTER:
         fp = (FARPROC)HookAdd( (void far *)WH_SYSMSGFILTERHook, 
            (void far *)pp2 ) ;
         break ;
      case WH_CBT:
         fp = (FARPROC)HookAdd( (void far *)WH_CBTHook,
            (void far *)pp2 ) ;
         break ;
      case WH_MOUSE:
         fp = (FARPROC)HookAdd( (void far *)WH_MOUSEHook,
            (void far *)pp2 ) ;
         break ;
      case WH_DEBUG:
         fp = (FARPROC)HookAdd( (void far *)WH_DEBUGHook,
            (void far *)pp2 ) ;
         break ;
      default:
        fUsable = FALSE;
        break;
   }

   /*
   ** Call the API!
   */
   RestoreRegs();
   GrovelDS();
   r = SetWindowsHook(pp1,fp);
   UnGrovelDS();
   SaveRegs();

   /*
   ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
   */
   if ( fUsable ) {
       LogOut( (LPSTR)"APIRET:SetWindowsHook FARPROC+++",
           r, (short)0, (short)0 );
   } else {
       LogOut( (LPSTR)"APIRET:SetWindowsHook FARPROC+++LPSTR+",
           r, (short)0, (short)0, (LPSTR)"WARNING! HOOK TYPE NOT KNOWN!!!" );
   }

   RestoreRegs();
   return( r );
}


BOOL far pascal zUnhookWindowsHook( int pp1, FARPROC pp2 )
{
    BOOL r;
    FARPROC fp ;

    SaveRegs();
    /*
    ** Log IN Parameters (No Create/Destroy Checking Yet!)
    */
    LogIn( (LPSTR)"APICALL:UnhookWindowsHook int+FARPROC+",
        pp1, pp2 );

    fp = (FARPROC)HookFind( (void far *)pp2 ) ;
    if ( fp == NULL ) {     /* Unhooking an unknown hook type */
        fp = pp2;
    }

    /*
    ** Call the API!
    */
    RestoreRegs();
    GrovelDS();
    r = UnhookWindowsHook(pp1,fp);
    UnGrovelDS();
    SaveRegs();
    /*
    ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
    */
    LogOut( (LPSTR)"APIRET:UnhookWindowsHook BOOL+++",
        r, (short)0, (short)0 );

    RestoreRegs();
    return( r );
}


/*
**
** Enum Functions
**
*/

int FAR PASCAL EnumPens(
   char FAR *lpLogObject,
   char FAR *lpData,
   FARPROC   fp,
   WORD      AX )
{
    int    l;

    SaveRegs() ;
    LogIn( (LPSTR)"ENUMCALL:EnumObjects(PEN) FARPROC+LPLOGPEN+LPSTR+",
        fp, lpLogObject, lpData ) ;

    RestoreRegs() ;
    GrovelDS();
    l = HookCall( lpLogObject, lpData, fp, AX );
    UnGrovelDS();

    SaveRegs() ;
    LogOut( (LPSTR)"ENUMRET:EnumObjects(PEN) int+FARPROC+LPLOGPEN+LPSTR+",
        l, fp, lpLogObject, lpData ) ;

    RestoreRegs() ;
    return( l );

}


int FAR PASCAL EnumBrushes(
   char FAR *lpLogObject,
   char FAR *lpData,
   FARPROC   fp,
   WORD      AX )
{
    int    l;

    SaveRegs() ;
    LogIn( (LPSTR)"ENUMCALL:EnumObjects(BRUSH) FARPROC+LPLOGPEN+LPSTR+",
        fp, lpLogObject, lpData ) ;

    RestoreRegs() ;
    GrovelDS();
    l = HookCall( lpLogObject, lpData, fp, AX );
    UnGrovelDS();

    SaveRegs() ;
    LogOut( (LPSTR)"ENUMRET:EnumObjects(BRUSH) int+FARPROC+LPLOGPEN+LPSTR+",
        l, fp, lpLogObject, lpData ) ;

    RestoreRegs() ;
    return( l );

}


int far pascal zEnumObjects( HDC pp1, int pp2, FARPROC pp3, LPSTR pp4 )
{
    int r;
    FARPROC fp ;

    SaveRegs();
    /*
    ** Log IN Parameters (No Create/Destroy Checking Yet!)
    */
    LogIn( (LPSTR)"APICALL:EnumObjects HDC+int+FARPROC+LPSTR+",
        pp1, pp2, pp3, pp4 );

    if( pp2 == OBJ_PEN )
      fp = (FARPROC)HookAdd( (void far *)EnumPens, (void far *)pp3 ) ;
    else
      fp = (FARPROC)HookAdd( (void far *)EnumBrushes, (void far *)pp3 ) ;

    /*
    ** Call the API!
    */
    RestoreRegs();
    GrovelDS();
    r = EnumObjects(pp1,pp2,fp,pp4);
    UnGrovelDS();
    SaveRegs();
    /*
    ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
    */
    LogOut( (LPSTR)"APIRET:EnumObjects int+++++",
        r, (short)0, (short)0, (short)0, (short)0 );

    RestoreRegs();
    return( r );
}

/*
    9-11-1991   BobK    Added EnumFonts Hook/Callback
*/

int FAR PASCAL FontCounter(
   char FAR *lpLogFont,
   char FAR *lpTextMetrics,
   short nFontType,
   char FAR *lpData,
   FARPROC   fp,
   WORD      AX )
{
    int    l;

    SaveRegs() ;
    LogIn( (LPSTR)"ENUMCALL:EnumFonts FARPROC+LPLOGFONT+LPTEXTMETRIC+int+DWORD+",
        fp, lpLogFont, lpTextMetrics, nFontType, lpData ) ;

    RestoreRegs() ;
    GrovelDS();
    l = HookCall( lpLogFont, lpTextMetrics, nFontType, lpData, fp, AX );
    UnGrovelDS();

    SaveRegs() ;
    LogOut( (LPSTR)"ENUMRET:EnumFonts int+FARPROC+LPLOGFONT+LPTEXTMETRIC+int+DWORD+",
        l, fp, lpLogFont, lpTextMetrics, nFontType, lpData ) ;

    RestoreRegs() ;
    return( l );

}


int far pascal zEnumFonts( HDC pp1, LPSTR pp2, FARPROC pp3, LPSTR pp4 )
{
    int r;
    FARPROC fpCentslessTaker;

    SaveRegs();
    /*
    ** Log IN Parameters (No Create/Destroy Checking Yet!)
    */
    LogIn( (LPSTR)"APICALL:EnumFonts HDC+LPSTR+FARPROC+DWORD+",
        pp1, pp2, pp3, pp4 );

    /*
        Hook the callback function (a census taker) with our own little twist
    */

    fpCentslessTaker = (FARPROC) HookAdd((void far *)FontCounter,
          (void far *) pp3);

    /*
    ** Call the API!
    */
    RestoreRegs();
    GrovelDS();
    r = EnumFonts(pp1, pp2, fpCentslessTaker, pp4);
    UnGrovelDS();
    SaveRegs();
    /*
    ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
    */
    LogOut( (LPSTR)"APIRET:EnumFonts int+++++",
        r, (short)0, (short)0, (short)0, (short)0 );

    RestoreRegs();
    return( r );
}

int FAR PASCAL FamilyCounter(
   char FAR *lpLogFont,
   char FAR *lpTextMetrics,
   short nFontType,
   char FAR *lpData,
   FARPROC   fp,
   WORD      AX )
{
    int    l;

    SaveRegs() ;
    LogIn( (LPSTR)"ENUMCALL:EnumFontFamilies FARPROC+LPLOGFONT+LPTEXTMETRIC+int+DWORD+",
        fp, lpLogFont, lpTextMetrics, nFontType, lpData ) ;

    RestoreRegs() ;
    GrovelDS();
    l = HookCall( lpLogFont, lpTextMetrics, nFontType, lpData, fp, AX );
    UnGrovelDS();

    SaveRegs() ;
    LogOut( (LPSTR)"ENUMRET:EnumFontFamilies int+FARPROC+LPLOGFONT+LPTEXTMETRIC+int+DWORD+",
        l, fp, lpLogFont, lpTextMetrics, nFontType, lpData ) ;

    RestoreRegs() ;
    return( l );

}

int FAR PASCAL zEnumFontFamilies( HDC pp1, LPCSTR pp2, FONTENUMPROC pp3, LPSTR pp4 )
{
    int r;
    FARPROC fpCentslessTaker;

    SaveRegs();
    /*
    ** Log IN Parameters (No Create/Destroy Checking Yet!)
    */
    LogIn( (LPSTR)"APICALL:EnumFontFamilies ++++",
        (short)0, (short)0, (short)0, (short)0 );

    /*
        Hook the callback function (a census taker) with our own little twist
    */

    fpCentslessTaker = (FARPROC) HookAdd((void far *)FamilyCounter,
          (void far *) pp3);

    /*
    ** Call the API!
    */
    RestoreRegs();
    GrovelDS();
    r = EnumFontFamilies(pp1,pp2,fpCentslessTaker,pp4);
    UnGrovelDS();
    SaveRegs();
    /*
    ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
    */
    LogOut( (LPSTR)"APIRET:EnumFontFamilies int+++++",
        r, (short)0, (short)0, (short)0, (short)0 );

    RestoreRegs();
    return( r );
}


BOOL FAR PASCAL EnumTaskWin(
   HWND    hwnd,
   DWORD   lParam,
   FARPROC fp,
   WORD    AX )
{
    BOOL   l;

    SaveRegs() ;
    LogIn( (LPSTR)"ENUMCALL:EnumTaskWindows FARPROC+HWND+DWORD+",
        fp, hwnd, lParam ) ;

    RestoreRegs() ;
    GrovelDS();
    l = HookCall( hwnd, lParam, fp, AX );
    UnGrovelDS();

    SaveRegs() ;
    LogOut( (LPSTR)"ENUMRET:EnumTaskWindows BOOL+FARPROC+HWND+DWORD+",
        l, fp, hwnd, lParam ) ;

    RestoreRegs() ;
    return( l );

}

BOOL far pascal zEnumTaskWindows( HANDLE pp1, FARPROC pp2, long pp3 )
{
    BOOL r;

    SaveRegs();
    /*
    ** Log IN Parameters (No Create/Destroy Checking Yet!)
    */
    LogIn( (LPSTR)"APICALL:EnumTaskWindows HANDLE+FARPROC+long+",
        pp1, pp2, pp3 );

    pp2 = (FARPROC) HookAdd( (void far *)EnumTaskWin, (void far *)pp2 ) ;

    /*
    ** Call the API!
    */
    RestoreRegs();
    GrovelDS();
    r = EnumTaskWindows(pp1,pp2,pp3);
    UnGrovelDS();
    SaveRegs();
    /*
    ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
    */
    LogOut( (LPSTR)"APIRET:EnumTaskWindows BOOL++++",
        r, (short)0, (short)0, (short)0 );

    RestoreRegs();
    return( r );
}

long far pascal zSetWindowLong( HWND pp1, int pp2, long pp3 )
{
    long r;
    long l;
    FARPROC fp ;

    SaveRegs();
    /*
    ** Log IN Parameters (No Create/Destroy Checking Yet!)
    */
    LogIn( (LPSTR)"APICALL:SetWindowLong HWND+int+long+",
        pp1, pp2, pp3 );

    if( pp2 == GWL_WNDPROC ) {
        pp3 = (long)((FARPROC)HookAdd( (void far *)MesgProc, (void far *)pp3 ));
    }
    /*
    ** Call the API!
    */
    RestoreRegs();
    GrovelDS();
    r = SetWindowLong(pp1,pp2,pp3);
    UnGrovelDS();
    SaveRegs();
    /*
    ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
    */
    LogOut( (LPSTR)"APIRET:SetWindowLong long++++",
        r, (short)0, (short)0, (short)0 );

    RestoreRegs();
    return( r );
}

/*
** TIMER STUFF
**
*/
WORD FAR PASCAL TimerRtn(
    HWND    hwnd,
    WORD    uMsg,
    int     nId,
    DWORD   dwTime,
    FARPROC fp,
    WORD    AX )
{
    WORD    rc;

    SaveRegs() ;
    LogIn( (LPSTR)"TIMECALL:SetTimer FARPROC+HWND+WORD+int+DWORD+",
        fp, hwnd, uMsg, nId, dwTime ) ;

    RestoreRegs() ;
    GrovelDS();
    rc = HookCall( hwnd, uMsg, nId, dwTime, fp, AX );
    UnGrovelDS();

    SaveRegs() ;
    LogOut( (LPSTR)"TIMERET:SetTimer WORD+FARPROC+HWND+WORD+int+DWORD+",
        rc, fp, hwnd, uMsg, nId, dwTime ) ;

    RestoreRegs() ;
    return( rc );
}

WORD far pascal zSetTimer( HWND pp1, int pp2, WORD pp3, FARPROC pp4 )
{
    WORD r;

    SaveRegs();
    /*
    ** Log IN Parameters (No Create/Destroy Checking Yet!)
    */
    LogIn( (LPSTR)"APICALL:SetTimer HWND+int+WORD+FARPROC+",
        pp1, pp2, pp3, pp4 );

    if ( pp4 != NULL ) {
        pp4 = (FARPROC) HookAdd( (void far *)TimerRtn, (void far *)pp4 );
    }

    /*
    ** Call the API!
    */
    RestoreRegs();
    GrovelDS();
    r = SetTimer(pp1,pp2,pp3,pp4);
    UnGrovelDS();
    SaveRegs();
    /*
    ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
    */
    LogOut( (LPSTR)"APIRET:SetTimer WORD+++++",
        r, (short)0, (short)0, (short)0, (short)0 );

    RestoreRegs();
    return( r );
}

/******************************************************************************

    The following were added by BobK in June, 1991

    They are hacks required to ensure logging of printing activity is done
    in such a manner that it can be played back on NT.  The primary problems
    are removal of support for almost every Escape call (fine, since Escape
    had come to mean writing device-dependent printing code in a nominally
    device-independent system), and (as well) elimination of application
    banding when printing.

    This requires intervention- massive intervention in the Escape call,
    and a little bit of it in GetDeviceCaps.  The reason this intervention
    is done in logging, is that many apps use Escapes to trigger special
    printer features (such as pattern-filling), instead of using GDI calls.
    We don't want these logged, since the NT versions of the drivers are
    to use such features automatically, thus making them available for all
    apps.

    Change History:

    06-14-1991  BobK    Initial Escape modifications debugged.
    06-15-1991  BobK    GetDeviceCaps interception added
    07-08-1991  BobK    Added changes for specialized Escape Logging

*******************************************************************************/

int far pascal zEscape( HDC hDC, int nEscape, int nCount, LPSTR lpInData,
                        LPSTR lpOutData)
{
    int     r;
    FARPROC fp ;

    SaveRegs();
    switch(nEscape)
      {
        static BOOL bNewFrame = FALSE;

        /*
            The NEXTBAND escape is intercepted, and the printer is made to
            look like a page-at-a-time printer.  We actually call NEWFRAME
            to print the page.  This effectively kills application banding
            at the source.
        */

        case    NEXTBAND:

          /*
            If this is the second of a pair of calls, do a NEWFRAME Escape,
            and return its results, along with an empty rectangle, to the
            caller.
          */

          if    (bNewFrame)
            {
              LogIn( (LPSTR)"APICALL:Escape HDC+int+int+LPSTR++",
                    hDC, NEWFRAME, 0, NULL, (short) 0);

              RestoreRegs();
              GrovelDS();
              r = Escape(hDC, NEWFRAME, 0, NULL, NULL);
              SetRectEmpty((LPRECT) lpOutData);
              UnGrovelDS();
              SaveRegs();
              LogOut( (LPSTR)"APIRET:Escape int+int+LPSTR+", r, NEWFRAME,
                    lpOutData );
            }
          else
          /*
            If this is the first of a pair of calls, determine the media
            size from the HDC via GetDeviceCaps, and return a rectangle the
            size of the page.
          */

            {
              LogIn( (LPSTR)"APICALL:Escape(Intercepted) HDC+int+int+LPSTR++",
                    hDC, nEscape, nCount, lpInData, (short) 0);
              RestoreRegs();
              GrovelDS();
              r = TRUE;
              SetRect((LPRECT) lpOutData, 0, 0, GetDeviceCaps(hDC, HORZRES),
                    GetDeviceCaps(hDC, VERTRES));
              UnGrovelDS();
              SaveRegs();
              LogOut( "APIRET:Escape(Intercepted) int+++++LPRECT+", r,
                    (short) 0, (short) 0, (short) 0, (short) 0, lpOutData );

            }

          bNewFrame = ! bNewFrame;
          RestoreRegs();
          return    r;

        case    QUERYESCSUPPORT:

          switch(*(LPINT) lpInData)
            {
              case  NEWFRAME:
              case  ABORTDOC:
              case  SETCOLORTABLE:
              case  GETCOLORTABLE:
              case  SETABORTPROC:
              case  STARTDOC:
              case  ENDDOC:
              case  QUERYESCSUPPORT:

                break;

              default:

                LogIn("APICALL:Escape(QueryBlocked) HDC+int+int+LPSTR++",
                      hDC, nEscape, nCount, lpInData, (short) 0);
                LogOut( (LPSTR)"APIRET:Escape(QueryBlocked) int+++++", 0,
                      (short)0, (short)0, (short)0, (short)0);
                RestoreRegs();
                return  0;
            }

          /*    NOTE: QUERYESCSUPPORT calls we think are OK drop through,
                here (hence they are not blocked).  So don't add any code
                before the 'case NEWFRAME' statement.  The following escapes
                have equivalent support in NT.
          */

        case    NEWFRAME:
        case    ABORTDOC:
        case    SETCOLORTABLE:
        case    GETCOLORTABLE:
        case    SETABORTPROC:
        case    STARTDOC:
        case    ENDDOC:

        /*
            The following escapes are allowed, although we deny they exist,
            when queried.  This is because some apps (like a high-volume
            spreadhseet produced by a company in Redmond, WA that will not
            be named herein) simply refuse to print if a printer doesn't
            respond to these escapes, even though they're optional.
        */

        case    GETPHYSPAGESIZE:
        case    GETSCALINGFACTOR:
        case    GETPRINTINGOFFSET:

          if    (nEscape == SETABORTPROC)
            LogIn("APICALL:Escape HDC+int+int+FARPROC++",
                  hDC, nEscape, nCount, lpInData, (short) 0);
          else
            LogIn("APICALL:Escape HDC+int+int+LPSTR++",
                  hDC, nEscape, nCount, lpInData, (short) 0);
          RestoreRegs();
          GrovelDS();
          r = Escape(hDC, nEscape, nCount, lpInData, lpOutData);
          UnGrovelDS();
          SaveRegs();

          LogOut( (LPSTR)"APIRET:Escape int+int+LPSTR+", r, nEscape, lpOutData );

          RestoreRegs();
          return    r;

        case  GETSETPRINTORIENT:
          r = -1;

          LogIn("APICALL:Escape(blocked) HDC+int+int+LPSTR++",
                hDC, nEscape, nCount, lpInData, (short) 0);
          RestoreRegs();
          GrovelDS();
          r = Escape(hDC, nEscape, nCount, lpInData, lpOutData);
          UnGrovelDS();
          SaveRegs();
          LogOut( (LPSTR)"APIRET:Escape(blocked) int+++++", r,
                (short)0, (short)0, (short)0, (short)0);
          RestoreRegs();
          return    r;

        default:
          LogIn("APICALL:Escape(blocked) HDC+int+int+LPSTR++",
                hDC, nEscape, nCount, lpInData, (short) 0);
          RestoreRegs();
          GrovelDS();
          r = Escape(hDC, nEscape, nCount, lpInData, lpOutData);
          UnGrovelDS();
          SaveRegs();
          LogOut( (LPSTR)"APIRET:Escape(blocked) int+++++", r,
                (short)0, (short)0, (short)0, (short)0);
          RestoreRegs();
          return    0;
      }

}

int far pascal zGetDeviceCaps( HDC pp1, int pp2 )
{
    int r;

    SaveRegs();
    /*
    ** Log IN Parameters (No Create/Destroy Checking Yet!)
    */
    LogIn( (LPSTR)"APICALL:GetDeviceCaps HDC+int+",
        pp1, pp2 );

    /*
    ** Call the API!
    */
    RestoreRegs();
    GrovelDS();
    r = GetDeviceCaps(pp1,pp2);
    UnGrovelDS();
    SaveRegs();

    /*
        This is the extent of our interception- if the device claims to be
        a banding device, don't let the caller know.
    */

    if  (pp2 == RASTERCAPS)
      r &= ~(RC_BANDING);

    /*
    ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
    */
    LogOut( (LPSTR)"APIRET:GetDeviceCaps int+++",
        r, (short)0, (short)0 );

    RestoreRegs();
    return( r );
}


HDC far pascal zCreateDC( LPSTR pp1, LPSTR pp2, LPSTR pp3, LPSTR pp4 )
{
    HDC r;

    SaveRegs();
    /*
    ** Log IN Parameters (No Create/Destroy Checking Yet!)
    */
    LogIn( (LPSTR)"APICALL:CreateDC LPSTR+LPSTR+LPSTR+LPDEVMODE+",
        pp1, pp2, pp3, pp4 );

    /*
    ** Call the API!
    */
    RestoreRegs();
    GrovelDS();
    r = CreateDC(pp1,pp2,pp3,pp4);
    UnGrovelDS();
    SaveRegs();
    /*
    ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
    */
    LogOut( (LPSTR)"APIRET:CreateDC HDC+++++",
        r, (short)0, (short)0, (short)0, (short)0 );

    RestoreRegs();
    return( r );
}

HDC far pascal zCreateIC( LPSTR pp1, LPSTR pp2, LPSTR pp3, LPSTR pp4 )
{
    HDC r;

    SaveRegs();
    /*
    ** Log IN Parameters (No Create/Destroy Checking Yet!)
    */
    LogIn( (LPSTR)"APICALL:CreateIC LPSTR+LPSTR+LPSTR+LPDEVMODE+",
        pp1, pp2, pp3, pp4 );

    /*
    ** Call the API!
    */
    RestoreRegs();
    GrovelDS();
    r = CreateIC(pp1,pp2,pp3,pp4);
    UnGrovelDS();
    SaveRegs();
    /*
    ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
    */
    LogOut( (LPSTR)"APIRET:CreateIC HDC+++++",
        r, (short)0, (short)0, (short)0, (short)0 );

    RestoreRegs();
    return( r );
}

long far pascal zSetBitmapBits( HBITMAP pp1, DWORD pp2, LPSTR pp3 )
{
    long r;

    SaveRegs();
    /*
    ** Log IN Parameters (No Create/Destroy Checking Yet!)
    */
    LogIn( (LPSTR)"APICALL:SetBitmapBits HBITMAP+DWORD+FixedString+",
        pp1, pp2, pp3, pp2 );

    /*
    ** Call the API!
    */
    RestoreRegs();
    GrovelDS();
    r = SetBitmapBits(pp1,pp2,pp3);
    UnGrovelDS();
    SaveRegs();
    /*
    ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
    */
    LogOut( (LPSTR)"APIRET:SetBitmapBits long++++",
        r, (short)0, (short)0, (short)0 );

    RestoreRegs();
    return( r );
}

void far pascal zGetKeyboardState( BYTE far* pp1 )
{

    SaveRegs();
    /*
    ** Log IN Parameters (No Create/Destroy Checking Yet!)
    */
    LogIn( (LPSTR)"APICALL:GetKeyboardState +",
        (short)0 );

    /*
    ** Call the API!
    */
    RestoreRegs();
    GrovelDS();
    GetKeyboardState(pp1);
    UnGrovelDS();
    SaveRegs();
    /*
    ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
    */
    LogOut( (LPSTR)"APIRET:GetKeyboardState FixedString+",
        pp1, (DWORD) 256 );

    RestoreRegs();
    return;
}

void far pascal zSetKeyboardState( BYTE far* pp1 )
{

    SaveRegs();
    /*
    ** Log IN Parameters (No Create/Destroy Checking Yet!)
    */
    LogIn( (LPSTR)"APICALL:SetKeyboardState FixedString+",
        pp1, (DWORD) 256 );

    /*
    ** Call the API!
    */
    RestoreRegs();
    GrovelDS();
    SetKeyboardState(pp1);
    UnGrovelDS();
    SaveRegs();
    /*
    ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
    */
    LogOut( (LPSTR)"APIRET:SetKeyboardState +",
        (short)0 );

    RestoreRegs();
    return;
}

BOOL far pascal zGetCharWidth( HDC pp1, UINT pp2, UINT pp3, LPINT pp4 )
{
    BOOL r;

    SaveRegs();
    /*
    ** Log IN Parameters (No Create/Destroy Checking Yet!)
    */
    LogIn( (LPSTR)"APICALL:GetCharWidth HDC+UINT+UINT++",
        pp1, pp2, pp3, (short)0 );

    /*
    ** Call the API!
    */
    RestoreRegs();
    GrovelDS();
    r = GetCharWidth(pp1,pp2,pp3,pp4);
    UnGrovelDS();
    SaveRegs();
    /*
    ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
    */
    LogOut( (LPSTR)"APIRET:GetCharWidth BOOL++++ARRAYINT+",
        r, (short)0, (short)0, (short)0, pp4, 1 + pp3 - pp2 );

    RestoreRegs();
    return( r );
}

BOOL far pascal zExtTextOut( HDC pp1, int pp2, int pp3, WORD pp4, LPRECT pp5, LPSTR pp6, WORD pp7, LPINT pp8 )
{
    BOOL r;

    SaveRegs();
    /*
    ** Log IN Parameters (No Create/Destroy Checking Yet!)
    */
    LogIn( (LPSTR)"APICALL:ExtTextOut HDC+int+int+WORD+LPRECT+LPSTR+WORD+ARRAYINT+",
        pp1, pp2, pp3, pp4, pp5, pp6, pp7, pp8, pp7 );

    /*
    ** Call the API!
    */
    RestoreRegs();
    GrovelDS();
    r = ExtTextOut(pp1,pp2,pp3,pp4,pp5,pp6,pp7,pp8);
    UnGrovelDS();
    SaveRegs();
    /*
    ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
    */
    LogOut( (LPSTR)"APIRET:ExtTextOut BOOL+++++++++",
        r, (short)0, (short)0, (short)0, (short)0, (short)0, (short)0, (short)0, (short)0 );

    RestoreRegs();
    return( r );
}

HDC far pascal ResetDC(HDC pp1, LPSTR pp2);

HDC far pascal zResetDC(HDC pp1, LPSTR pp2)
{
    HDC r;

    SaveRegs();
    /*
    ** Log IN Parameters (No Create/Destroy Checking Yet!)
    */
    LogIn( (LPSTR)"APICALL:ResetDC HDC+LPDEVMODE+",
        pp1, pp2 );

    /*
    ** Call the API!
    */
    RestoreRegs();
    GrovelDS();
    r = ResetDC(pp1,pp2);
    UnGrovelDS();
    SaveRegs();
    /*
    ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
    */
    LogOut( (LPSTR)"APIRET:ResetDC HDC+++",
        r, (short)0, (short)0 );

    RestoreRegs();
    return( r );
}

long far pascal zCallWindowProc( FARPROC pp1, HWND pp2, WORD pp3, WORD pp4, long pp5 )
{
    long r;
    FARPROC  fp;

    SaveRegs();
    /*
    ** Log IN Parameters (No Create/Destroy Checking Yet!)
    */
    LogIn( (LPSTR)"APICALL:CallWindowProc FARPROC+HWND+WORD+WORD+long+",
        pp1, pp2, pp3, pp4, pp5 );


    fp = (FARPROC)HookFind( (void far *)pp1 );
    if ( fp != NULL )
    {
       pp1 = fp;
    }

    /*
    ** Call the API!
    */
    RestoreRegs();
    GrovelDS();
    r = CallWindowProc(pp1,pp2,pp3,pp4,pp5);
    UnGrovelDS();
    SaveRegs();
    /*
    ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
    */
    LogOut( (LPSTR)"APIRET:CallWindowProc long++++++",
        r, (short)0, (short)0, (short)0, (short)0, (short)0 );

    RestoreRegs();
    return( r );
}
