/* asmtabtb.c -- microsoft 80x86 assembler
**
** microsoft (r) macro assembler
** copyright (c) microsoft corp 1986.  all rights reserved
**
** randy nevin
**
** 10/90 - Quick conversion to 32 bit by Jeff Spencer
*/

#include <stdio.h>
#include "asm86.h"
#include "asmfcn.h"
#include "asmopcod.h"
#include "asmctype.h"
#include "asmindex.h"
#include "asmtab.h"	/* common between asmtab.c and asmtabtb.c */

#ifndef V386

#define P386 0
#endif

/* first token table */

struct pseudo FAR dir1tok[] = {
	/* I_TASSUME */		{ TASSUME,	NL	},
	/* I_TCOMMENT */	{ TCOMMENT,	NL	},
	/* I_TDB */		{ TDB,		NL	},
	/* I_TDD */		{ TDD,		NL	},
	/* I_TDQ */		{ TDQ,		NL	},
	/* I_TDT */		{ TDT,		NL	},
	/* I_TDW */		{ TDW,		NL	},
	/* I_TELSE */		{ TELSE,	CONDBEG	},
	/* I_TEND */		{ TEND,		NL	},
	/* I_TENDIF */		{ TENDIF,	CONDBEG },
	/* I_TENDM */		{ TENDM,	NL	},
	/* I_TERR */		{ TERR,		NL	},
	/* I_TERR1 */		{ TERR1,	NL	},
	/* I_TERR2 */		{ TERR2,	NL	},
	/* I_TERRB */		{ TERRB,	NL	},
	/* I_TERRDEF */		{ TERRDEF,	NL	},
	/* I_TERRDIF */		{ TERRDIF,	NL	},
	/* I_TERRE */		{ TERRE,	NL	},
	/* I_TERRNZ */		{ TERRNZ,	NL	},
	/* I_TERRIDN */		{ TERRIDN,	NL	},
	/* I_TERRNB */		{ TERRNB,	NL	},
	/* I_TERRNDEF */	{ TERRNDEF,	NL	},
	/* I_TEVEN */		{ TEVEN,	NL	},
	/* I_TEXITM */		{ TEXITM,	NL	},
	/* I_TEXTRN */		{ TEXTRN,	NL	},
	/* I_TIF */		{ TIF,		CONDBEG	},
	/* I_TIF1 */		{ TIF1,		CONDBEG	},
	/* I_TIF2 */		{ TIF2,		CONDBEG	},
	/* I_TIFB */		{ TIFB,		CONDBEG	},
	/* I_TIFDEF */		{ TIFDEF,	CONDBEG	},
	/* I_TIFDIF */		{ TIFDIF,	CONDBEG	},
	/* I_TIFE */		{ TIFE,		CONDBEG	},
	/* I_TIFIDN */		{ TIFIDN,	CONDBEG	},
	/* I_TIFNB */		{ TIFNB,	CONDBEG	},
	/* I_TIFNDEF */		{ TIFNDEF,	CONDBEG	},
	/* I_TINCLUDE */	{ TINCLUDE,	NL	},
	/* I_TIRP */		{ TIRP,		BLKBEG	},
	/* I_TIRPC */		{ TIRPC,	BLKBEG	},
	/* I_TLOCAL */		{ TLOCAL,	NL	},
	/* I_TNAME */		{ TNAME,	NL	},
	/* I_TORG */		{ TORG,		NL	},
	/* I_TPAGE */		{ TPAGE,	NL	},
	/* I_TPUBLIC */		{ TPUBLIC,	NL	},
	/* I_TPURGE */		{ TPURGE,	NL	},
	/* I_TREPT */		{ TREPT,	BLKBEG	},
	/* I_TSUBTTL */		{ TSUBTTL,	NL	},
	/* I_TTITLE */		{ TTITLE,	NL	},
	/* I_TCREF */		{ TCREF,	NL	},
	/* I_TLALL */		{ TLALL,	NL	},
	/* I_TLFCOND */		{ TLFCOND,	NL	},
	/* I_TLIST */		{ TLIST,	NL	},
	/* I_TRADIX */		{ TRADIX,	NL	},
	/* I_TSALL */		{ TSALL,	NL	},
	/* I_TSFCOND */		{ TSFCOND,	NL	},
	/* I_TTFCOND */		{ TTFCOND,	NL	},
	/* I_TXALL */		{ TXALL,	NL	},
	/* I_TXCREF */		{ TXCREF,	NL	},
	/* I_TXLIST */		{ TXLIST,	NL	},
	/* I_TOUT */		{ TOUT,		NL	},
	/* I_TALIGN */		{ TALIGN,	NL	},
	/* I_T8086 */		{ T8086,	NL	},
	/* I_T8087 */		{ T8087,	NL	},
	/* I_T287 */		{ T287,		NL	},
	/* I_T186 */		{ T186,		NL	},
	/* I_T286C */		{ T286C,	NL	},
	/* I_T286P */		{ T286P,	NL	},

	/* I_TINCLIB */ 	{ TINCLIB,	NL	},
	/* I_TMSTACK */ 	{ TMSTACK,	NL	},
	/* I_TDOSSEG */ 	{ TDOSSEG,	NL	},
	/* I_TMODEL  */ 	{ TMODEL,	NL	},
	/* I_TCODE    */	{ TMSEG,	0	},
	/* I_TDATA    */	{ TMSEG,	1	},
	/* I_TDATAQ   */	{ TMSEG,	2	},
	/* I_TCONST   */	{ TMSEG,	3	},
	/* I_TFARDATA */	{ TMSEG,	5	},
	/* I_TFARDATAQ*/	{ TMSEG,	6	},

	/* I_TSEQ	*/	{ TSEQ,		NL	},
	/* I_TALPHA	*/	{ TALPHA,	NL	},
	/* I_TCOMM  */		{ TCOMM,	NL	},
	/* I_TIFDIFI */ 	{ TIFDIF,	CONDBEG | IGNORECASE},
	/* I_TIFIDNI */ 	{ TIFIDN,	CONDBEG | IGNORECASE},
	/* I_TERRDIFI */	{ TERRDIF,	NL	| IGNORECASE},
	/* I_TERRIDNI */	{ TERRIDN,	NL	| IGNORECASE},
	/* I_TELSEIF */ 	{ TIF,		CONDBEG | CONDCONT },
	/* I_TELSEIF1 */	{ TIF1, 	CONDBEG | CONDCONT },
	/* I_TELSEIF2 */	{ TIF2, 	CONDBEG | CONDCONT },
	/* I_TELSEIFB */	{ TIFB, 	CONDBEG | CONDCONT },
	/* I_TELSEIFDEF */	{ TIFDEF,	CONDBEG | CONDCONT },
	/* I_TELSEIFDIF */	{ TIFDIF,	CONDBEG | CONDCONT },
	/* I_TELSEIFE */	{ TIFE, 	CONDBEG | CONDCONT },
	/* I_TELSEIFIDN */	{ TIFIDN,	CONDBEG | CONDCONT },
	/* I_TELSEIFNB */	{ TIFNB,	CONDBEG | CONDCONT },
	/* I_TELSEIFNDEF */	{ TIFNDEF,	CONDBEG | CONDCONT },
	/* I_TELSEIFDIFI */	{ TIFDIF,	CONDBEG | CONDCONT | IGNORECASE},
	/* I_TELSEIFIDNI */	{ TIFIDN,	CONDBEG | CONDCONT | IGNORECASE},

#ifdef V386
	/* I_T386C */		{ T386C,	NL	},
	/* I_T386P */		{ T386P,	NL	},
	/* I_T387 */		{ T387, 	NL	},
	/* I_TDF */		{ TDF,		NL	},
#endif

    /* I_TFPO */        { TFPO,     NL }, 
};


/* second token table */

struct pseudo FAR dir2tok[] = {
	/* I2_TDB */		{ TDB,		NL	},
	/* I2_TDD */		{ TDD,		NL	},
	/* I2_TDQ */		{ TDQ,		NL	},
	/* I2_TDT */		{ TDT,		NL	},
	/* I2_TDW */		{ TDW,		NL	},
	/* I2_TENDP */		{ TENDP,	NL	},
	/* I2_TENDS */		{ TENDS,	NL	},
	/* I2_TEQU */		{ TEQU,		NL	},
	/* I2_TSUBSTR */	{ TSUBSTR,	NL	},
	/* I2_TCATSTR */	{ TCATSTR,	NL	},
	/* I2_TSIZESTR */	{ TSIZESTR,	NL	},
	/* I2_TINSTR */ 	{ TINSTR,	NL	},
	/* I2_TGROUP */		{ TGROUP,	NL	},
	/* I2_TLABEL */		{ TLABEL,	NL	},
	/* I2_TMACRO */ 	{ TMACRO,	BLKBEG	},
	/* I2_TPROC */		{ TPROC,	NL	},
	/* I2_TRECORD */	{ TRECORD,	NL	},
	/* I2_TSEGMENT */	{ TSEGMENT,	NL	},
	/* I2_TSTRUC */		{ TSTRUC,	NL	},

#ifdef V386
	/* I2_TDF */		{ TDF,		NL	},
#endif
};


/* precedence tables */

UCHAR opprec[] = {
	11, 11, 11, 11, 9, 9, 9,
	1, 9, 8, 8, 4, 1,
	3, 5, 5, 5, 5, 5, 7, 5, 2, 9,
	7, 7, 2, 0, 0,
	11, 11, 11, 11, 11, 11, 10, 10, 7, 7, 6, 6
};


/* segment parameter names */


/* opcode table */

struct opcentry FAR opctab[] = {  /* order must match I_xxx in asmindex.h */
	{ O_AAA,     0, 	PNOARGS,       P86|P186|P286|P386 },
	{ O_AAD,     R_AAD,	PNOARGS,       P86|P186|P286|P386 },
	{ O_AAM,     R_AAM,	PNOARGS,       P86|P186|P286|P386 },
	{ O_AAS,     0, 	PNOARGS,       P86|P186|P286|P386 },
	{ O_ADC,     0, 	PGENARG,   F_W|P86|P186|P286|P386 },
	{ O_ADD,     0, 	PGENARG,   F_W|P86|P186|P286|P386 },
	{ O_AND,     0, 	PGENARG,   F_W|P86|P186|P286|P386 },
	{ O_CALL,    0, 	PCALL,	       P86|P186|P286|P386 },
	{ O_CBW,     2, 	PNOARGS,       P86|P186|P286|P386 },
	{ O_CLC,     0, 	PNOARGS,       P86|P186|P286|P386 },
	{ O_CLD,     0, 	PNOARGS,       P86|P186|P286|P386 },
	{ O_CLI,     0, 	PNOARGS,       P86|P186|P286|P386 },
	{ O_CMC,     0, 	PNOARGS,       P86|P186|P286|P386 },
	{ O_CMP,     0, 	PGENARG,       P86|P186|P286|P386 },
	{ O_CMPS,    0, 	PSTR,	       P86|P186|P286|P386 },
	{ O_CMPSB,   0, 	PNOARGS,       P86|P186|P286|P386 },
	{ O_CMPSW,   2, 	PNOARGS,       P86|P186|P286|P386 },
	{ O_CWD,     2, 	PNOARGS,       P86|P186|P286|P386 },
	{ O_DAA,     0, 	PNOARGS,       P86|P186|P286|P386 },
	{ O_DAS,     0, 	PNOARGS,       P86|P186|P286|P386 },
	{ O_DEC,     0, 	PINCDEC,   F_W|P86|P186|P286|P386 },
	{ O_DIV,     R_DIV,	PARITH,        P86|P186|P286|P386 },
	{ O_ESC,     0, 	PESC,	       P86|P186|P286|P386 },
	{ O_HLT,     0, 	PNOARGS,       P86|P186|P286|P386 },
	{ O_IDIV,    R_IDIV,	PARITH,        P86|P186|P286|P386 },
	{ O_IMUL,    R_IMUL,	PARITH,        P86|P186|P286|P386 },
	{ O_IN,      0, 	PINOUT,        P86|P186|P286|P386 },
	{ O_INC,     0, 	PINCDEC,   F_W|P86|P186|P286|P386 },
	{ O_INT,     0, 	PINT,	       P86|P186|P286|P386 },
	{ O_INTO,    0, 	PNOARGS,       P86|P186|P286|P386 },
	{ O_IRET,    2, 	PNOARGS,       P86|P186|P286|P386 },
	{ O_JA,      0, 	PRELJMP,       P86|P186|P286|P386 },
	{ O_JAE,     0, 	PRELJMP,       P86|P186|P286|P386 },
	{ O_JB,      0, 	PRELJMP,       P86|P186|P286|P386 },
	{ O_JBE,     0, 	PRELJMP,       P86|P186|P286|P386 },
	{ O_JC,      0, 	PRELJMP,       P86|P186|P286|P386 },
	{ O_JCXZ,    2, 	PRELJMP,       P86|P186|P286|P386 },
	{ O_JE,      0, 	PRELJMP,       P86|P186|P286|P386 },
	{ O_JG,      0, 	PRELJMP,       P86|P186|P286|P386 },
	{ O_JGE,     0, 	PRELJMP,       P86|P186|P286|P386 },
	{ O_JL,      0, 	PRELJMP,       P86|P186|P286|P386 },
	{ O_JLE,     0, 	PRELJMP,       P86|P186|P286|P386 },
	{ O_JMP,     0, 	PJUMP,	       P86|P186|P286|P386 },
	{ O_JNA,     0, 	PRELJMP,       P86|P186|P286|P386 },
	{ O_JNAE,    0, 	PRELJMP,       P86|P186|P286|P386 },
	{ O_JNB,     0, 	PRELJMP,       P86|P186|P286|P386 },
	{ O_JNBE,    0, 	PRELJMP,       P86|P186|P286|P386 },
	{ O_JNC,     0, 	PRELJMP,       P86|P186|P286|P386 },
	{ O_JNE,     0, 	PRELJMP,       P86|P186|P286|P386 },
	{ O_JNG,     0, 	PRELJMP,       P86|P186|P286|P386 },
	{ O_JNGE,    0, 	PRELJMP,       P86|P186|P286|P386 },
	{ O_JNL,     0, 	PRELJMP,       P86|P186|P286|P386 },
	{ O_JNLE,    0, 	PRELJMP,       P86|P186|P286|P386 },
	{ O_JNO,     0, 	PRELJMP,       P86|P186|P286|P386 },
	{ O_JNP,     0, 	PRELJMP,       P86|P186|P286|P386 },
	{ O_JNS,     0, 	PRELJMP,       P86|P186|P286|P386 },
	{ O_JNZ,     0, 	PRELJMP,       P86|P186|P286|P386 },
	{ O_JO,      0, 	PRELJMP,       P86|P186|P286|P386 },
	{ O_JP,      0, 	PRELJMP,       P86|P186|P286|P386 },
	{ O_JPE,     0, 	PRELJMP,       P86|P186|P286|P386 },
	{ O_JPO,     0, 	PRELJMP,       P86|P186|P286|P386 },
	{ O_JS,      0, 	PRELJMP,       P86|P186|P286|P386 },
	{ O_JZ,      0, 	PRELJMP,       P86|P186|P286|P386 },
	{ O_LAHF,    0, 	PNOARGS,       P86|P186|P286|P386 },
	{ O_LEA,     0, 	PLOAD,	       P86|P186|P286|P386 },
	{ O_LES,     0, 	PLOAD,	       P86|P186|P286|P386 },
	{ O_LDS,     0, 	PLOAD,	       P86|P186|P286|P386 },
	{ O_LOCK,    0, 	PREPEAT,       P86|P186|P286|P386 },
	{ O_LODS,    0, 	PSTR,	       P86|P186|P286|P386 },
	{ O_LODSB,   0, 	PNOARGS,       P86|P186|P286|P386 },
	{ O_LODSW,   2, 	PNOARGS,       P86|P186|P286|P386 },
	{ O_LOOP,    0, 	PRELJMP,       P86|P186|P286|P386 },
	{ O_LOOPE,   0, 	PRELJMP,       P86|P186|P286|P386 },
	{ O_LOOPNE,  0, 	PRELJMP,       P86|P186|P286|P386 },
	{ O_LOOPNZ,  0, 	PRELJMP,       P86|P186|P286|P386 },
	{ O_LOOPZ,   0, 	PRELJMP,       P86|P186|P286|P386 },
	{ O_MOV,     0, 	PMOV,	   F_W|P86|P186|P286|P386 },
	{ O_MOVS,    0, 	PSTR,	       P86|P186|P286|P386 },
	{ O_MOVSB,   0, 	PNOARGS,       P86|P186|P286|P386 },
	{ O_MOVSW,   2, 	PNOARGS,       P86|P186|P286|P386 },
	{ O_MUL,     R_MUL,	PARITH,        P86|P186|P286|P386 },
	{ O_NEG,     R_NEG,	PARITH,    F_W|P86|P186|P286|P386 },
	{ O_NOP,     0, 	PNOARGS,       P86|P186|P286|P386 },
	{ O_NOT,     R_NOT,	PARITH,    F_W|P86|P186|P286|P386 },
	{ O_OR,      0, 	PGENARG,   F_W|P86|P186|P286|P386 },
	{ O_OUT,     0, 	PINOUT,        P86|P186|P286|P386 },
	{ O_POP,     0, 	PSTACK,    F_W|P86|P186|P286|P386 },
	{ O_POPF,    2, 	PNOARGS,       P86|P186|P286|P386 },
	{ O_PUSH,    0, 	PSTACK,        P86|P186|P286|P386 },
	{ O_PUSHF,   2, 	PNOARGS,       P86|P186|P286|P386 },
	{ O_RCL,     R_RCL,	PSHIFT,    F_W|P86|P186|P286|P386 },
	{ O_RCR,     R_RCR,	PSHIFT,    F_W|P86|P186|P286|P386 },
	{ O_REP,     0, 	PREPEAT,       P86|P186|P286|P386 },
	{ O_REPE,    0, 	PREPEAT,       P86|P186|P286|P386 },
	{ O_REPNE,   0, 	PREPEAT,       P86|P186|P286|P386 },
	{ O_REPNZ,   0, 	PREPEAT,       P86|P186|P286|P386 },
	{ O_REPZ,    0, 	PREPEAT,       P86|P186|P286|P386 },
	{ O_RET,     0, 	PRETURN,       P86|P186|P286|P386 },
	{ O_ROL,     R_ROL,	PSHIFT,    F_W|P86|P186|P286|P386 },
	{ O_ROR,     R_ROR,	PSHIFT,    F_W|P86|P186|P286|P386 },
	{ O_SAHF,    0, 	PNOARGS,       P86|P186|P286|P386 },
	{ O_SAL,     R_SAL,	PSHIFT,    F_W|P86|P186|P286|P386 },
	{ O_SAR,     R_SAR,	PSHIFT,    F_W|P86|P186|P286|P386 },
	{ O_SBB,     0, 	PGENARG,   F_W|P86|P186|P286|P386 },
	{ O_SCAS,    0, 	PSTR,	       P86|P186|P286|P386 },
	{ O_SCASB,   0, 	PNOARGS,       P86|P186|P286|P386 },
	{ O_SCASW,   2, 	PNOARGS,       P86|P186|P286|P386 },
	{ O_SHL,     R_SHL,	PSHIFT,    F_W|P86|P186|P286|P386 },
	{ O_SHR,     R_SHR,	PSHIFT,    F_W|P86|P186|P286|P386 },
	{ O_STC,     0, 	PNOARGS,       P86|P186|P286|P386 },
	{ O_STD,     0, 	PNOARGS,       P86|P186|P286|P386 },
	{ O_STI,     0, 	PNOARGS,       P86|P186|P286|P386 },
	{ O_STOS,    0, 	PSTR,	       P86|P186|P286|P386 },
	{ O_STOSB,   0, 	PNOARGS,       P86|P186|P286|P386 },
	{ O_STOSW,   2, 	PNOARGS,       P86|P186|P286|P386 },
	{ O_SUB,     0, 	PGENARG,   F_W|P86|P186|P286|P386 },
	{ O_TEST,    0, 	PGENARG,       P86|P186|P286|P386 },
	{ O_WAIT,    0, 	PNOARGS,       P86|P186|P286|P386 },
	{ O_XCHG,    0, 	PXCHG, F_W|S_W|P86|P186|P286|P386 },
	{ O_XLAT,    0, 	PXLAT,	       P86|P186|P286|P386 },
	{ O_XLATB,   0, 	PXLAT,	       P86|P186|P286|P386 },
	{ O_XOR,     0, 	PGENARG,   F_W|P86|P186|P286|P386 },
	{ O_ARPL,    0, 	PARPL,	   F_W| 	P286|P386|PROT },
	{ O_BOUND,   0, 	PBOUND, 	   P186|P286|P386 },
	{ O_CLTS,    R_CLTS,	PCLTS,			P286|P386|PROT },
	{ O_ENTER,   0, 	PENTER, 	   P186|P286|P386 },
	{ O_INS,     0, 	PSTR,		   P186|P286|P386 },
	{ O_INSB,    0, 	PNOARGS,	   P186|P286|P386 },
	{ O_INSW,    2, 	PNOARGS,	   P186|P286|P386 },
	{ O_LAR,     R_LAR,	PARSL,			P286|P386|PROT },
	{ O_LEAVE,   0, 	PNOARGS,	   P186|P286|P386 },
	{ O_LGDT,    R_LGDT,	PDESCRTBL,		P286|P386|PROT },
	{ O_LIDT,    R_LIDT,	PDESCRTBL,		P286|P386|PROT },
	{ O_LLDT,    R_LLDT,	PDTTRSW,		P286|P386|PROT },
	{ O_LMSW,    R_LMSW,	PDTTRSW,		P286|P386|PROT },
	{ O_LSL,     R_LSL,	PARSL,			P286|P386|PROT },
	{ O_LTR,     R_LTR,	PDTTRSW,		P286|P386|PROT },
	{ O_OUTS,    0, 	PSTR,		   P186|P286|P386 },
	{ O_OUTSB,   0, 	PNOARGS,	   P186|P286|P386 },
	{ O_OUTSW,   2, 	PNOARGS,	   P186|P286|P386 },
	{ O_POPA,    2, 	PNOARGS,   F_W|    P186|P286|P386 },
	{ O_PUSHA,   2, 	PNOARGS,	   P186|P286|P386 },
	{ O_SGDT,    R_SGDT,	PDESCRTBL, F_W| 	P286|P386|PROT },
	{ O_SIDT,    R_SIDT,	PDESCRTBL, F_W| 	P286|P386|PROT },
	{ O_SLDT,    R_SLDT,	PDTTRSW,   F_W| 	P286|P386|PROT },
	{ O_SMSW,    R_SMSW,	PDTTRSW,   F_W| 	P286|P386|PROT },
	{ O_STR,     R_STR,	PDTTRSW,   F_W| 	P286|P386|PROT },
	{ O_VERR,    R_VERR,	PVER,			P286|P386|PROT },
	{ O_VERW,    R_VERW,	PVER,			P286|P386|PROT },

	{ O_F2XM1,   R_F2XM1,	FNOARGS,       P86|P186|P286|P386 },
	{ O_FABS,    R_FABS,	FNOARGS,       P86|P186|P286|P386 },
	{ O_FADD,    R_FADD,	F2MEMSTK,      P86|P186|P286|P386 },
	{ O_FADDP,   R_FADDP,	FSTKS,	       P86|P186|P286|P386 },
	{ O_FBLD,    R_FBLD,	FBCDMEM,       P86|P186|P286|P386 },
	{ O_FBSTP,   R_FBSTP,	FBCDMEM,   F_W|P86|P186|P286|P386 },
	{ O_FCHS,    R_FCHS,	FNOARGS,       P86|P186|P286|P386 },
	{ O_FCLEX,   R_FCLEX,	FNOARGS,       FORCEWAIT|P86|P186|P286|P386 },
	{ O_FCOM,    R_FCOM,	FMEMSTK,       P86|P186|P286|P386 },
	{ O_FCOMP,   R_FCOMP,	FMEMSTK,       P86|P186|P286|P386 },
	{ O_FCOMPP,  R_FCOMPP,	FNOARGS,       P86|P186|P286|P386 },
	{ O_FDECSTP, R_FDECSTP, FNOARGS,       FORCEWAIT|P86|P186|P286|P386 },
	{ O_FDISI,   R_FDISI,	FNOARGS,       P86|P186|P286|P386 },
	{ O_FDIV,    R_FDIV,	F2MEMSTK,      P86|P186|P286|P386 },
	{ O_FDIVP,   R_FDIVP,	FSTKS,	       P86|P186|P286|P386 },
	{ O_FDIVR,   R_FDIVR,	F2MEMSTK,      P86|P186|P286|P386 },
	{ O_FDIVRP,  R_FDIVRP,	FSTKS,	       P86|P186|P286|P386 },
	{ O_FENI,    R_FENI,	FNOARGS,       P86|P186|P286|P386 },
	{ O_FFREE,   R_FFREE,	FSTK,	       FORCEWAIT|P86|P186|P286|P386 },
	{ O_FIADD,   R_FIADD,	FMEM42,        P86|P186|P286|P386 },
	{ O_FICOM,   R_FICOM,	FMEM42,        P86|P186|P286|P386 },
	{ O_FICOMP,  R_FICOMP,	FMEM42,        P86|P186|P286|P386 },
	{ O_FIDIV,   R_FIDIV,	FMEM42,        P86|P186|P286|P386 },
	{ O_FIDIVR,  R_FIDIVR,	FMEM42,        P86|P186|P286|P386 },
	{ O_FILD,    R_FILD,	FMEM842,       P86|P186|P286|P386 },
	{ O_FIMUL,   R_FIMUL,	FMEM42,        P86|P186|P286|P386 },
	{ O_FINCSTP, R_FINCSTP, FNOARGS,       FORCEWAIT|P86|P186|P286|P386 },
	{ O_FINIT,   R_FINIT,	FNOARGS,       FORCEWAIT|P86|P186|P286|P386 },
	{ O_FIST,    R_FIST,	FMEM42,    F_W|P86|P186|P286|P386 },
	{ O_FISTP,   R_FISTP,	FMEM842,   F_W|P86|P186|P286|P386 },
	{ O_FISUB,   R_FISUB,	FMEM42,        P86|P186|P286|P386 },
	{ O_FISUBR,  R_FISUBR,	FMEM42,        P86|P186|P286|P386 },
	{ O_FLD,     R_FLD,	FMEM4810,      P86|P186|P286|P386 },
	{ O_FLD1,    R_FLD1,	FNOARGS,       P86|P186|P286|P386 },
	{ O_FLDCW,   R_FLDCW,	FMEM2,	       FORCEWAIT|P86|P186|P286|P386 },
	{ O_FLDENV,  R_FLDENV,	FMEM14,        FORCEWAIT|P86|P186|P286|P386 },
	{ O_FLDL2E,  R_FLDL2E,	FNOARGS,       P86|P186|P286|P386 },
	{ O_FLDL2T,  R_FLDL2T,	FNOARGS,       P86|P186|P286|P386 },
	{ O_FLDLG2,  R_FLDLG2,	FNOARGS,       P86|P186|P286|P386 },
	{ O_FLDLN2,  R_FLDLN2,	FNOARGS,       P86|P186|P286|P386 },
	{ O_FLDPI,   R_FLDPI,	FNOARGS,       P86|P186|P286|P386 },
	{ O_FLDZ,    R_FLDZ,	FNOARGS,       P86|P186|P286|P386 },
	{ O_FMUL,    R_FMUL,	F2MEMSTK,      P86|P186|P286|P386 },
	{ O_FMULP,   R_FMULP,	FSTKS,	       P86|P186|P286|P386 },
	{ O_FNCLEX,  R_FNCLEX,	FNOARGS,       P86|P186|P286|P386 },
	{ O_FNDISI,  R_FNDISI,	FNOARGS,       P86|P186|P286|P386 },
	{ O_FNENI,   R_FNENI,	FNOARGS,       P86|P186|P286|P386 },
	{ O_FNINIT,  R_FNINIT,	FNOARGS,       P86|P186|P286|P386 },
	{ O_FNOP,    R_FNOP,	FNOARGS,       FORCEWAIT|P86|P186|P286|P386 },
	{ O_FNSAVE,  R_FNSAVE,	FMEM94,    F_W|P86|P186|P286|P386 },
	{ O_FNSTCW,  R_FNSTCW,	FMEM2,	   F_W|P86|P186|P286|P386 },
	{ O_FNSTENV, R_FNSTENV, FMEM14,    F_W|P86|P186|P286|P386 },
	{ O_FNSTSW,  R_FNSTSW,	FMEM2,	   F_W|P86|P186|P286|P386 },
	{ O_FPATAN,  R_FPATAN,	FNOARGS,       P86|P186|P286|P386 },
	{ O_FPREM,   R_FPREM,	FNOARGS,       P86|P186|P286|P386 },
	{ O_FPTAN,   R_FPTAN,	FNOARGS,       P86|P186|P286|P386 },
	{ O_FRNDINT, R_FRNDINT, FNOARGS,       P86|P186|P286|P386 },
	{ O_FRSTOR,  R_FRSTOR,	FMEM94,        FORCEWAIT|P86|P186|P286|P386 },
	{ O_FSAVE,   R_FSAVE,	FMEM94,    F_W|FORCEWAIT|P86|P186|P286|P386 },
	{ O_FSCALE,  R_FSCALE,	FNOARGS,       P86|P186|P286|P386 },
	{ O_FSQRT,   R_FSQRT,	FNOARGS,       P86|P186|P286|P386 },
	{ O_FST,     R_FST,	FMEMSTK,   F_W|P86|P186|P286|P386 },
	{ O_FSTCW,   R_FSTCW,	FMEM2,	   F_W|FORCEWAIT|P86|P186|P286|P386 },
	{ O_FSTENV,  R_FSTENV,	FMEM14,    F_W|FORCEWAIT|P86|P186|P286|P386 },
	{ O_FSTP,    R_FSTP,	FMEM4810,  F_W|P86|P186|P286|P386 },
	{ O_FSTSW,   R_FSTSW,	FMEM2,	   F_W|FORCEWAIT|P86|P186|P286|P386 },
	{ O_FSETPM,  R_FSETPM,	FNOARGS,       FORCEWAIT|P286|P386|PROT },
	{ O_FSUB,    R_FSUB,	F2MEMSTK,      P86|P186|P286|P386 },
	{ O_FSUBP,   R_FSUBP,	FSTKS,	       P86|P186|P286|P386 },
	{ O_FSUBR,   R_FSUBR,	F2MEMSTK,      P86|P186|P286|P386 },
	{ O_FSUBRP,  R_FSUBRP,	FSTKS,	       P86|P186|P286|P386 },
	{ O_FTST,    R_FTST,	FNOARGS,       P86|P186|P286|P386 },
	{ O_FWAIT,   R_FWAIT,	FWAIT,	       FORCEWAIT|P86|P186|P286|P386 },
	{ O_FXAM,    R_FXAM,	FNOARGS,       P86|P186|P286|P386 },
	{ O_FXCH,    R_FXCH,	FSTK,	       P86|P186|P286|P386 },
	{ O_FXTRACT, R_FXTRACT, FNOARGS,       P86|P186|P286|P386 },
	{ O_FYL2X,   R_FYL2X,	FNOARGS,       P86|P186|P286|P386 },
	{ O_FYL2XP1, R_FYL2XP1, FNOARGS,       P86|P186|P286|P386 },
	{ O_FNRSTOR, R_FNRSTOR, FMEM94,        P86|P186|P286|P386 },

#ifdef V386
	{ O_MOVSX,   4, 	PMOVX,	       P386 },
	{ O_MOVZX,   4, 	PMOVX,	       P386 },
	{ O_CWDE,    4, 	PNOARGS,       P386 },
	{ O_CDQ,     4, 	PNOARGS,       P386 },
	{ O_LFS,     0, 	PLOAD,	       P386 },
	{ O_LGS,     0, 	PLOAD,	       P386 },
	{ O_LSS,     0, 	PLOAD,	       P386 },
	{ O_SHLD,    0, 	PSHIFT,    F_W|P386 },
	{ O_SHRD,    0, 	PSHIFT,    F_W|P386 },
	{ O_CMPSD,   4, 	PNOARGS,       P386 },
	{ O_INSD,    4, 	PNOARGS,       P386 },
	{ O_LODSD,   4, 	PNOARGS,       P386 },
	{ O_MOVSD,   4, 	PNOARGS,       P386 },
	{ O_OUTSD,   4, 	PNOARGS,       P386 },
	{ O_SCASD,   4, 	PNOARGS,       P386 },
	{ O_STOSD,   4, 	PNOARGS,       P386 },
	{ O_BSF,     0xBC,	PBITSCAN,      P386 },
	{ O_BSR,     0xBD,	PBITSCAN,      P386 },
	{ O_BT,      R_BT,	PBIT,	       P386 },
	{ O_BTC,     R_BTC,	PBIT,	   F_W|P386 },
	{ O_BTR,     R_BTR,	PBIT,	   F_W|P386 },
	{ O_BTS,     R_BTS,	PBIT,	   F_W|P386 },
	{ O_IBTS,    0, 	PNOARGS,       P386 },
	{ O_XBTS,    0, 	PNOARGS,       P386 },
	{ O_JECXZ,   4, 	PRELJMP,       P386 },
	{ O_SETO,    R_SETO,	PSETCC,    F_W|P386 },
	{ O_SETNO,   R_SETNO,	PSETCC,    F_W|P386 },
	{ O_SETB,    R_SETB,	PSETCC,    F_W|P386 },
	{ O_SETNAE,  R_SETNAE,	PSETCC,    F_W|P386 },
	{ O_SETNB,   R_SETNB,	PSETCC,    F_W|P386 },
	{ O_SETAE,   R_SETAE,	PSETCC,    F_W|P386 },
	{ O_SETE,    R_SETE,	PSETCC,    F_W|P386 },
	{ O_SETZ,    R_SETZ,	PSETCC,    F_W|P386 },
	{ O_SETNE,   R_SETNE,	PSETCC,    F_W|P386 },
	{ O_SETNZ,   R_SETNZ,	PSETCC,    F_W|P386 },
	{ O_SETBE,   R_SETBE,	PSETCC,    F_W|P386 },
	{ O_SETNA,   R_SETNA,	PSETCC,    F_W|P386 },
	{ O_SETNBE,  R_SETNBE,	PSETCC,    F_W|P386 },
	{ O_SETA,    R_SETA,	PSETCC,    F_W|P386 },
	{ O_SETS,    R_SETS,	PSETCC,    F_W|P386 },
	{ O_SETNS,   R_SETNS,	PSETCC,    F_W|P386 },
	{ O_SETP,    R_SETP,	PSETCC,    F_W|P386 },
	{ O_SETPE,   R_SETPE,	PSETCC,    F_W|P386 },
	{ O_SETNP,   R_SETNP,	PSETCC,    F_W|P386 },
	{ O_SETPO,   R_SETPO,	PSETCC,    F_W|P386 },
	{ O_SETL,    R_SETL,	PSETCC,    F_W|P386 },
	{ O_SETNGE,  R_SETNGE,	PSETCC,    F_W|P386 },
	{ O_SETC,    R_SETC,	PSETCC,    F_W|P386 },
	{ O_SETNC,   R_SETNC,	PSETCC,    F_W|P386 },
	{ O_SETLE,   R_SETLE,	PSETCC,    F_W|P386 },
	{ O_SETNG,   R_SETNG,	PSETCC,    F_W|P386 },
	{ O_SETNL,   R_SETNL,	PSETCC,    F_W|P386 },
	{ O_SETGE,   R_SETGE,	PSETCC,    F_W|P386 },
	{ O_SETNLE,  R_SETNLE,	PSETCC,    F_W|P386 },
	{ O_SETG,    R_SETG,	PSETCC,    F_W|P386 },
	{ O_PUSHAD,  4, 	PNOARGS,       P386 },
	{ O_POPAD,   4, 	PNOARGS,       P386 },
	{ O_POPFD,   4, 	PNOARGS,       P386 },
	{ O_PUSHFD,  4, 	PNOARGS,       P386 },
	{ O_IRETD,   4, 	PNOARGS,       P386 },

	{ O_FUCOM,   R_FUCOM,	FSTK,	       P386 },
	{ O_FUCOMP,  R_FUCOMP,	FSTK,	       P386 },
	{ O_FUCOMPP, R_FUCOMPP, FNOARGS,       P386 },
	{ O_FPREM1,  R_FPREM1,	FNOARGS,       P386 },
	{ O_FCOS,    R_FCOS,	FNOARGS,       P386 },
	{ O_FSIN,    R_FSIN,	FNOARGS,       P386 },
	{ O_FSINCOS, R_FSINCOS, FNOARGS,       P386 },
#endif
	{ O_RETN,    1, 	PRETURN,       P86|P186|P286|P386 },
	{ O_RETF,    1, 	PRETURN,       P86|P186|P286|P386 }
};
