/*++

Copyright (c) 1992 Microsoft Corporation

Module Name:

    rwcache.hxx

Abstract:

    This class implements a read write cache.

Author:

    Norbert Kusters (norbertk) 23-Apr-92

--*/


#if !defined(_READ_WRITE_CACHE_DEFN_)

#define _READ_WRITE_CACHE_DEFN_

#include "dcache.hxx"
#include "hmem.hxx"
#include "numset.hxx"


struct RW_CACHE_BLOCK {
    BOOLEAN InUse;
    BOOLEAN IsDirty;
    ULONG   Age;
    BIG_INT SectorNumber;
    HMEM    SectorBuffer;
};
DEFINE_POINTER_TYPES(RW_CACHE_BLOCK);


DECLARE_CLASS(READ_WRITE_CACHE);

class READ_WRITE_CACHE : public DRIVE_CACHE {

    public:

        DECLARE_CONSTRUCTOR( READ_WRITE_CACHE );

        VIRTUAL
        ~READ_WRITE_CACHE(
            );

        NONVIRTUAL
        BOOLEAN
        Initialize(
            IN OUT  PIO_DP_DRIVE    Drive,
            IN      ULONG           NumberOfCacheBlocks
            );

        VIRTUAL
		BOOLEAN
		Read(
			IN  BIG_INT     StartingSector,
			IN  SECTORCOUNT NumberOfSectors,
			OUT PVOID       Buffer
			);

        VIRTUAL
		BOOLEAN
		Write(
			IN  BIG_INT     StartingSector,
			IN  SECTORCOUNT NumberOfSectors,
			IN  PVOID       Buffer
            );

        VIRTUAL
        BOOLEAN
        Flush(
            );

    private:

        NONVIRTUAL
        PRW_CACHE_BLOCK
        GetSectorCacheBlock(
            IN  BIG_INT SectorNumber
            );

        NONVIRTUAL
        PRW_CACHE_BLOCK
        GetNextAvailbleCacheBlock(
            );

        NONVIRTUAL
        VOID
        FlushThisCacheBlock(
            IN OUT  PRW_CACHE_BLOCK Block
            );

        NONVIRTUAL
        VOID
        FlushJustThisCacheBlock(
            IN OUT  PRW_CACHE_BLOCK Block
            );

        NONVIRTUAL
		VOID
		Construct(
			);

        NONVIRTUAL
        VOID
        Destroy(
            );

        NUMBER_SET          _sectors_cached;
        PRW_CACHE_BLOCK*    _cache_blocks;
        ULONG               _num_blocks;
        HMEM                _write_buffer;
        ULONG               _sector_size;
        BOOLEAN             _error_occurred;
        ULONG               _next_age;

};


#endif
