/******************************Module*Header*******************************\
* Module Name: ftfill.c
*
* Filling tests
*
* Created: 26-May-1991 13:07:35
* Author: Patrick Haluptzok patrickh
*
* Copyright (c) 1990 Microsoft Corporation
\**************************************************************************/

#include "precomp.h"
#pragma hdrstop

typedef struct _BITMAPINFOPAT
{
    BITMAPINFOHEADER                 bmiHeader;
    RGBQUAD                          bmiColors[16];
} BITMAPINFOPAT;

BITMAPINFOPAT bmi4 =
{
    {
        sizeof(BITMAPINFOHEADER),
        64,
        64,
        1,
	4,
        BI_RGB,
	(64 * 64) / 2,
        0,
        0,
        16,
        16
    },
    {                               // B    G    R
        { 0,   0,   0,   0 },       // 0
        { 0,   0,   0x80,0 },       // 1
        { 0,   0x80,0,   0 },       // 2
        { 0,   0x80,0x80,0 },       // 3
        { 0x80,0,   0,   0 },       // 4
        { 0x80,0,   0x80,0 },       // 5
        { 0x80,0x80,0,   0 },       // 6
        { 0xC0,0xC0,0xC0,0 },       // 7

        { 0x80,0x80,0x80,0 },       // 8
        { 0,   0,   0xFF,0 },       // 9
        { 0,   0xFF,0,   0 },       // 10
        { 0,   0xFF,0xFF,0 },       // 11
        { 0xFF,0,   0,   0 },       // 12
        { 0xFF,0,   0xFF,0 },       // 13
        { 0xFF,0xFF,0,   0 },       // 14
        { 0xFF,0xFF,0xFF,0 }        // 15
    }
};

BYTE abColorLinesFill[64 * 64 / 2] =
{
// 0
     0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,

     0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
// 8
     0xAA,0xAA,0xAA,0xAA,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,

     0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,
// 16
     0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,

     0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xCC,0xCC,0xCC,0xCC,0xCC,0xAA,0xAA,0xAA,0xAA,0xCC,0xCC,0xCC,0xCC,0xCC,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xCC,0xCC,0xCC,0xCC,0xCC,0xAA,0xAA,0xAA,0xAA,0xCC,0xCC,0xCC,0xCC,0xCC,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,
// 24
     0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,

     0xAA,0xAA,0xAA,0xAA,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,
// 32
     0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,

     0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,
// 40
     0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,

     0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,
// 48
     0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,

     0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xCC,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xAA,0xAA,0xAA,0xAA,

// 56
     0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,

     0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
// 64
};


VOID vTestFilling(HWND hwnd, HDC hdc, RECT* prcl)
{
    HBRUSH hbrushRed, hbrushCyan, hbrushYellow, hbrushPink, hbrushOld;
    HBRUSH hbrSave;
    HDC hdcComp;
    HBITMAP hbm,hbmDefault;
    ULONG ScreenWidth, ScreenHeight;
    POINT ptl[20];
    int   aint[10];

// Create the brush

    ScreenWidth  = GetDeviceCaps(hdc, HORZRES);
    ScreenHeight = GetDeviceCaps(hdc, VERTRES);

    BitBlt(hdc, 0, 0, ScreenWidth, ScreenHeight, (HDC) 0, 0, 0, WHITENESS);

    hbrushRed = CreateSolidBrush(RGB(0xff,0x00,0x00));
    hbrushCyan = CreateSolidBrush(RGB(0x00,0xff,0xff));
    hbrushYellow = CreateSolidBrush(RGB(0xff,0xff,0x00));
    hbrushPink = CreateSolidBrush(RGB(0xff,0x00,0xff));

    hbm = CreateDIBitmap(hdc,
                        (LPBITMAPINFOHEADER)&bmi4,
			CBM_INIT,
			abColorLinesFill,
                        (LPBITMAPINFO)&bmi4,
                        DIB_RGB_COLORS);

    hdcComp = CreateCompatibleDC(hdc);
    hbmDefault = SelectObject(hdcComp, hbm);

    BitBlt(hdc, 100, 100, 64, 64, hdcComp, 0, 0, SRCCOPY);

// Red: 0xFF, Blue 0xFF0000

    hbrushOld = SelectObject(hdcComp,hbrushRed);
    FloodFill(hdcComp, 23, 46, 0x0FF0000);
    BitBlt(hdc, 200, 100, 64, 64, hdcComp, 0, 0, SRCCOPY);

    SelectObject(hdcComp,hbrushYellow);
    ExtFloodFill(hdcComp, 23, 46, 0x0FF, FLOODFILLSURFACE);
    BitBlt(hdc, 300, 100, 64, 64, hdcComp, 0, 0, SRCCOPY);

    SelectObject(hdcComp,hbrushCyan);
    ExtFloodFill(hdcComp, 23, 46, 0x0FF0000, FLOODFILLBORDER);
    BitBlt(hdc, 400, 100, 64, 64, hdcComp, 0, 0, SRCCOPY);

    hbrSave = SelectObject(hdc,hbrushPink);

    ptl[0].x = 100;
    ptl[0].y = 200;
    ptl[1].x = 100+70;
    ptl[1].y = 200;
    ptl[2].x = 100;
    ptl[2].y = 200+70;
    ptl[3].x = 100+80;
    ptl[3].y = 200+80;
    ptl[4].x = 100;
    ptl[4].y = 200;

    ptl[5].x = 130;
    ptl[5].y = 210;
    ptl[6].x = 130+20;
    ptl[6].y = 210;
    ptl[7].x = 130-10;
    ptl[7].y = 210+50;
    ptl[8].x = 130+10;
    ptl[8].y = 210+50;
    ptl[9].x = 130;
    ptl[9].y = 210;

    aint[0] = 5;
    aint[1] = 5;

    PolyPolygon(hdc, (LPPOINT)&ptl, (LPINT)&aint, 2);

    Ellipse(hdc, 200, 200, 300, 250);

    ptl[0].x = 400;
    ptl[0].y = 200;
    ptl[1].x = 400-40;
    ptl[1].y = 200+40;
    ptl[2].x = 400+40;
    ptl[2].y = 200+35;
    ptl[3].x = 400-30;
    ptl[3].y = 200+5;
    ptl[4].x = 400-5;
    ptl[4].y = 200+80;

    Polygon(hdc, (LPPOINT)&ptl, 5);

    ptl[0].x = 500;
    ptl[0].y = 200;
    ptl[1].x = 500-40;
    ptl[1].y = 200+40;
    ptl[2].x = 500+40;
    ptl[2].y = 200+35;
    ptl[3].x = 500-30;
    ptl[3].y = 200+5;
    ptl[4].x = 500-5;
    ptl[4].y = 200+80;

    SetPolyFillMode(hdc, WINDING);
    Polygon(hdc, (LPPOINT)&ptl, 5);

    SelectObject(hdc,hbrSave);
    SelectObject(hdcComp,hbrushOld);
    DeleteObject(hbrushRed);
    DeleteObject(hbrushPink);
    DeleteObject(hbrushCyan);
    DeleteObject(hbrushYellow);

    return;
}
