/***************************************************************************\
*
*  CS.C
*
*  Copyright (C) Microsoft Corporation 1991.
*  All Rights reserved.
*
*****************************************************************************
*
*  Module Intent
*
*  Functions for mapping characters between character sets.
*  This file is in the layer directory because it is expected that
*  this is something that could best be done in assembly language.
*  Feel free to move it if you know better.
*
*****************************************************************************
*
*  Testing Notes
*
*****************************************************************************
*
*  Created 14-Apr-1991 by JohnSc
*
*****************************************************************************
*
*  Released by Development:  00-Ooo-0000
*
*****************************************************************************
*
*  Current Owner:  JohnSc
*
\***************************************************************************/

#define H_ASSERT
#define H_CS
#include <help.h>

NszAssert()

/***************************************************************************\
*                                                                           *
*                            Static Variables                               *
*                                                                           *
\***************************************************************************/

/* These tables map the top half of the ANSI and MAC character
** sets into each other.  (Note that ANSI and MAC both match ANSII
** for the low half.)
** The important characters to map are the "foreign" letters.
**
** Question:  what's more important, that the mappings be "symmetric", i.e.
**  given F : ansi -> mac, G : mac -> ansi
**  F(G(c)) == c and G(F(c)) == c should hold for all c.
**
** or that they be "pragmatic", i.e. closest match found?
** e.g. U-hat(ansi) mapped to U(mac)
**
** Current status: functions not symmetric, not pragmatic.
** cspriv.h is generated by the cstest program.
*/

#include "cspriv.h"


/***************************************************************************\
*
- Function:     MapCharacterSet( qch, cch, csDst, csSrc )
-
* Purpose:      Convert characters between character sets
*
* ASSUMES
*   args IN:    qch           - buffer to be converted
*               cch           - count of characters to convert
*               csSrc, csDst  - source and destination character sets
*
* PROMISES
*   args OUT:   qch           - characters converted in place
*
* Side Effects: 
*
* Notes:        Do we need conversion both ways?  Or just foreign -> native?
*
* Bugs:         The interface to this function doesn't take DBCS or
*               UNICODE character sets into account because it doesn't
*               allow for size change.
* +++
*
* Notes:        LONG count is bogus because FAR != HUGE.
*
\***************************************************************************/
void MapCharacterSet( QCH qch, LONG cch, CS csDst, CS csSrc )
  {
  unsigned char *mpchch, uch;


  if ( csSrc == csDst )
    {
    /* Don't call this function unless csSrc differs from csDst */
    NotReached();
    return;
    }

  if ( csDst == csAnsi )
    {
    AssertF( csSrc == csMac );
    mpchch = mpchchAnsiFromMac;
    }
  else
    {
    AssertF( csDst == csMac && csSrc == csAnsi );
    mpchch = mpchchMacFromAnsi;
    }

  /* MAC and ANSI character sets only differ in the high bit half */

  for ( uch = *qch; cch > 0; --cch, uch = *++qch )
    {
    if ( uch & 0x80 )
      {
      *qch = mpchch[ uch & 0x7F ];
      }
    }
  }


/* EOF */
