/***************************************************************************\
*
*  CS.H
*
*  Copyright (C) Microsoft Corporation 1991.
*  All Rights reserved.
*
*****************************************************************************
*
*  Module Intent
*
*  Interface to character set mapping functions.
*
*****************************************************************************
*
*  Testing Notes
*
*****************************************************************************
*
*  Created 14-Apr-1991 by JohnSc
*
*****************************************************************************
*
*  Released by Development:  00-Ooo-0000
*
*****************************************************************************
*
*  Current Owner:  JohnSc
*
\***************************************************************************/

/***************************************************************************\
*                                                                           *
*                               Defines                                     *
*                                                                           *
\***************************************************************************/

/* Character set:  i.e. ANSI or Mac */

#define csAnsi  ((CS)0)
#define csMac   ((CS)1)

/* csRuntime is the native character set for the runtime's platform */

#ifdef MAC
#define csRuntime csMac
#else
#define csRuntime csAnsi
#endif

/***************************************************************************\
*                                                                           *
*                                Macros                                     *
*                                                                           *
\***************************************************************************/
/* do we need one-at-a-time character mapping macros? */

/***************************************************************************\
*                                                                           *
*                               Typedefs                                    *
*                                                                           *
\***************************************************************************/

typedef char CS;

/***************************************************************************\
*                                                                           *
*                            Static Variables                               *
*                                                                           *
\***************************************************************************/

/* do we need visible mapping tables? */

/***************************************************************************\
*                                                                           *
*                               Prototypes                                  *
*                                                                           *
\***************************************************************************/

void MapCharacterSet( QCH qch, LONG cch, CS csDst, CS csSrc );

/* EOF */
