#ifndef _Nano_c_h
#define _Nano_c_h
#define nanoInstrument (0)
#define BYTE_SIZED (0)
#define WORD_SIZED (1)
#define LONG_SIZED (2)
#define ES_CODE (0)
#define CS_CODE (1)
#define SS_CODE (2)
#define DS_CODE (3)
#define FS_CODE (4)
#define GS_CODE (5)
#define EAX_CODE (0)
#define ECX_CODE (1)
#define EDX_CODE (2)
#define EBX_CODE (3)
#define ESP_CODE (4)
#define EBP_CODE (5)
#define ESI_CODE (6)
#define EDI_CODE (7)
#define MEM_CODE (8)
#define JUMP (0)
#define FALLTHROUGH (1)
#define TRUNCATION (2)
#define LEAVING (3)
#define NOT_APPLICABLE (4)
#define COMPILE_BLOCK (1)
#define LOG_SF_BREAK (2)
#define LOG_NORMAL_FLOW (3)
#define LOG_ABNORMAL_FLOW (4)
#define PARSE_AHEAD (5)
#define MONITOR_DS_CHANGE (6)
#define MONITOR_DS_USE (7)
#define BLOCK_LENGTH_CHANGE (8)
#define EAX_FORM_16 (0)
#define EAX_FORM_8 (1)
#define EBX_FORM_16 (2)
#define EBX_FORM_8 (3)
#define ECX_FORM_16 (4)
#define ECX_FORM_8 (5)
#define EDX_FORM_16 (6)
#define EDX_FORM_8 (7)
#define EBP_FORM_16 (8)
#define ESI_FORM_16 (9)
#define EDI_FORM_16 (10)
#define DF_BIT (11)
#define PROT_BIT (12)
#define V86_BIT (13)
#define BIG_CODE_BIT (14)
#define BIG_STACK_BIT (15)
#define DS_DEFAULT_SEG_BOT (16)
#define DS_DEFAULT_SEG_TOP (18)
#define SS_DEFAULT_SEG_BOT (19)
#define SS_DEFAULT_SEG_TOP (21)
#define ADDRESS_SIZE_TOGGLE_BIT (22)
#define OPERAND_SIZE_TOGGLE_BIT (23)
#define RESTORE_ESP_ON_EXCEPTION_BIT (24)
#define REP_E_BIT (25)
#define REP_NE_BIT (26)
#define EAX_BITMAP_BIT (0)
#define ECX_BITMAP_BIT (1)
#define EDX_BITMAP_BIT (2)
#define EBX_BITMAP_BIT (3)
#define ESP_BITMAP_BIT (4)
#define EBP_BITMAP_BIT (5)
#define ESI_BITMAP_BIT (6)
#define EDI_BITMAP_BIT (7)
#define ES_BITMAP_BIT (8)
#define CS_BITMAP_BIT (9)
#define SS_BITMAP_BIT (10)
#define DS_BITMAP_BIT (11)
#define FS_BITMAP_BIT (12)
#define GS_BITMAP_BIT (13)
#define HAS_AN_EA_REC_BIT (14)
#define INSTR_CONTINUATION_BIT (15)
#define NOTHING_BASE (1)
#define AX_BASE (2)
#define CX_BASE (3)
#define DX_BASE (4)
#define BX_BASE (5)
#define SP_BASE (6)
#define BP_BASE (7)
#define SI_BASE (8)
#define DI_BASE (9)
#define EAX_BASE (10)
#define ECX_BASE (11)
#define EDX_BASE (12)
#define EBX_BASE (13)
#define ESP_BASE (14)
#define EBP_BASE (15)
#define ESI_BASE (16)
#define EDI_BASE (17)
#define NOTHING_INDEX (0)
#define AX_INDEX (64)
#define CX_INDEX (96)
#define DX_INDEX (128)
#define BX_INDEX (160)
#define SP_INDEX (192)
#define BP_INDEX (224)
#define SI_INDEX (256)
#define DI_INDEX (288)
#define EAX_INDEX (320)
#define ECX_INDEX (352)
#define EDX_INDEX (384)
#define EBX_INDEX (416)
#define ESP_INDEX (448)
#define EBP_INDEX (480)
#define ESI_INDEX (512)
#define EDI_INDEX (544)
#define ES_SEGFORM (0)
#define CS_SEGFORM (1024)
#define SS_SEGFORM (2048)
#define DS_SEGFORM (3072)
#define FS_SEGFORM (4096)
#define GS_SEGFORM (5120)
#define NOTHING_MUL (0)
#define MUL_2 (8192)
#define MUL_4 (16384)
#define MUL_8 (24576)
#define READ_ACCESS_BIT (0)
#define WRITE_ACCESS_BIT (1)
#define ACCESS_LENGTH_BOT (2)
#define ACCESS_LENGTH_TOP (7)
#define NDBG_TRACE (1)
#define NDBG_PROMPT (2)
#define NDBG_CALLPRINT (4)
#define NDBG_COMPILE (8)
#define NDBG_VERBCOMPILE (16)
#define NDBG_YODA (32)
#define NDBG_UNIVCHECK (64)
#define DEAD_CONSTRAINTS (-1)
#define COUNT_TOP (7)
#define COUNT_BOT (4)
#define DEST_COUNT_TOP (3)
#define DEST_COUNT_BOT (0)
#define GET_AXBX_FORM (0)
#define GET_CXDX_FORM (16)
#define GET_BPSIDI_FORM (32)
#define PUT_AXBX_FORM (40)
#define PUT_CXDX_FORM (56)
#define PUT_BPSIDI_FORM (72)
#define READ_OP1 (80)
#define WRITE_OP1 (107)
#define READ_SEG_OP1 (134)
#define WRITE_SEG_OP1 (142)
#define WRITE_SEG_OP2 (150)
#define WRITE_OP2 (158)
#define READ_OP1_RETURN (185)
#define WRITE_OP1_BYTE_RETURN (212)
#define PUSH_OP1 (221)
#define POP_OP1 (223)
#define EA_OPERATIONS (225)
#define SIB_BASE_FUNCTIONS (281)
#define SIB_INDEX_FUNCTIONS (305)
#define ADD_OPERATIONS (337)
#define TEST_OPERATIONS (553)
#define JCC_OPERATIONS (580)
#define INC_OPERATIONS (596)
#define DEC_OPERATIONS (623)
#define NEG_OPERATIONS (650)
#define NOT_OPERATIONS (677)
#define MUL_OPERATIONS (704)
#define IMUL_OPERATIONS (707)
#define DIV_OPERATIONS (710)
#define IDIV_OPERATIONS (713)
#define IMUL3_OPERATIONS (716)
#define IMUL2_OPERATIONS (734)
#define SHIFT_OPERATIONS (752)
#define ARPL_OPERATIONS (968)
#define SETCC_OPERATIONS (977)
#define SHLD_OPERATIONS (993)
#define SHRD_OPERATIONS (1011)
#define BT_OPERATIONS (1029)
#define BTS_OPERATIONS (1047)
#define BTR_OPERATIONS (1065)
#define BTC_OPERATIONS (1083)
struct EntryPointREC
{
	IU16 hashNext;
	IU16 codeSeg;
	IU32 linearAddress;
	IU32 constraints;
	IS32 hostAddress;
};
struct BLOCK_RECORD
{
	IU16 hashNext;
	IU8 intelLength;
	IU8 extraBits;
	IU32 linearAddress;
	IU32 constraints;
	IS16 dsSelector;
	IU16 destBlock;
};
struct NI_BLOCK_RECORD
{
	IUH ni_State;
	IU32 ni_Checksum;
};
enum ni_StateValues
{
	ni_BlockFree = 0,
	ni_BlockVirgin = 1,
	ni_BlockActive = 2
};
#endif /* ! _Nano_c_h */
