/* Copyright (c) 1993, Microsoft Corporation, all rights reserved
**
** raserror.h
** Remote Access external Win16 API
** RAS specific error codes
**
** Note: The constant names have been truncated at 31 characters to keep C6.0a
**       happy.  If there's a switch to get it to accept longer constants it
**       should be used.  I didn't find it.
*/

#ifndef _RASERROR_H_
#define _RASERROR_H_

#ifndef ERROR_INVALID_HANDLE
#define ERROR_INVALID_HANDLE 6
#endif

#ifndef ERROR_NOT_ENOUGH_MEMORY
#define ERROR_NOT_ENOUGH_MEMORY 8
#endif

#define RASBASE 600

#define SUCCESS 0

#define PENDING                         (RASBASE+0)
#define ERROR_INVALID_PORT_HANDLE       (RASBASE+1)
#define ERROR_PORT_ALREADY_OPEN         (RASBASE+2)
#define ERROR_BUFFER_TOO_SMALL          (RASBASE+3)
#define ERROR_WRONG_INFO_SPECIFIED      (RASBASE+4)
#define ERROR_CANNOT_SET_PORT_INFO      (RASBASE+5)
#define ERROR_PORT_NOT_CONNECTED        (RASBASE+6)
#define ERROR_EVENT_INVALID             (RASBASE+7)
#define ERROR_DEVICE_DOES_NOT_EXIST     (RASBASE+8)
#define ERROR_DEVICETYPE_DOES_NOT_EXIST (RASBASE+9)
#define ERROR_INVALID_BUFFER            (RASBASE+10)
#define ERROR_ROUTE_NOT_AVAILABLE       (RASBASE+11)
#define ERROR_ROUTE_NOT_ALLOCATED       (RASBASE+12)
#define ERROR_INVALID_COMPRESSION_SPECI (RASBASE+13)
#define ERROR_OUT_OF_BUFFERS            (RASBASE+14)
#define ERROR_PORT_NOT_FOUND            (RASBASE+15)
#define ERROR_ASYNC_REQUEST_PENDING     (RASBASE+16)
#define ERROR_ALREADY_DISCONNECTING     (RASBASE+17)
#define ERROR_PORT_NOT_OPEN             (RASBASE+18)
#define ERROR_PORT_DISCONNECTED         (RASBASE+19)
#define ERROR_NO_ENDPOINTS              (RASBASE+20)
#define ERROR_CANNOT_OPEN_PHONEBOOK     (RASBASE+21)
#define ERROR_CANNOT_LOAD_PHONEBOOK     (RASBASE+22)
#define ERROR_CANNOT_FIND_PHONEBOOK_ENT (RASBASE+23)
#define ERROR_CANNOT_WRITE_PHONEBOOK    (RASBASE+24)
#define ERROR_CORRUPT_PHONEBOOK         (RASBASE+25)
#define ERROR_CANNOT_LOAD_STRING        (RASBASE+26)
#define ERROR_KEY_NOT_FOUND             (RASBASE+27)
#define ERROR_DISCONNECTION             (RASBASE+28)
#define ERROR_REMOTE_DISCONNECTION      (RASBASE+29)
#define ERROR_HARDWARE_FAILURE          (RASBASE+30)
#define ERROR_USER_DISCONNECTION        (RASBASE+31)
#define ERROR_INVALID_SIZE              (RASBASE+32)
#define ERROR_PORT_NOT_AVAILABLE        (RASBASE+33)
#define ERROR_CANNOT_PROJECT_CLIENT     (RASBASE+34)
#define ERROR_UNKNOWN                   (RASBASE+35)
#define ERROR_WRONG_DEVICE_ATTACHED     (RASBASE+36)
#define ERROR_BAD_STRING                (RASBASE+37)
#define ERROR_REQUEST_TIMEOUT           (RASBASE+38)
#define ERROR_CANNOT_GET_LANA           (RASBASE+39)
#define ERROR_NETBIOS_ERROR             (RASBASE+40)
#define ERROR_SERVER_OUT_OF_RESOURCES   (RASBASE+41)
#define ERROR_NAME_EXISTS_ON_NET        (RASBASE+42)
#define ERROR_SERVER_GENERAL_NET_FAILUR (RASBASE+43)
#define WARNING_MSG_ALIAS_NOT_ADDED     (RASBASE+44)
#define ERROR_AUTH_INTERNAL             (RASBASE+45)
#define ERROR_RESTRICTED_LOGON_HOURS    (RASBASE+46)
#define ERROR_ACCT_DISABLED             (RASBASE+47)
#define ERROR_PASSWD_EXPIRED            (RASBASE+48)
#define ERROR_NO_DIALIN_PERMISSION      (RASBASE+49)
#define ERROR_SERVER_NOT_RESPONDING     (RASBASE+50)
#define ERROR_FROM_DEVICE               (RASBASE+51)
#define ERROR_UNRECOGNIZED_RESPONSE     (RASBASE+52)
#define ERROR_MACRO_NOT_FOUND           (RASBASE+53)
#define ERROR_MACRO_NOT_DEFINED         (RASBASE+54)
#define ERROR_MESSAGE_MACRO_NOT_FOUND   (RASBASE+55)
#define ERROR_DEFAULTOFF_MACRO_NOT_FOUN (RASBASE+56)
#define ERROR_FILE_COULD_NOT_BE_OPENED  (RASBASE+57)
#define ERROR_DEVICENAME_TOO_LONG       (RASBASE+58)
#define ERROR_DEVICENAME_NOT_FOUND      (RASBASE+59)
#define ERROR_NO_RESPONSES              (RASBASE+60)
#define ERROR_NO_COMMAND_FOUND          (RASBASE+61)
#define ERROR_WRONG_KEY_SPECIFIED       (RASBASE+62)
#define ERROR_UNKNOWN_DEVICE_TYPE       (RASBASE+63)
#define ERROR_ALLOCATING_MEMORY         (RASBASE+64)
#define ERROR_PORT_NOT_CONFIGURED       (RASBASE+65)
#define ERROR_DEVICE_NOT_READY          (RASBASE+66)
#define ERROR_READING_INI_FILE          (RASBASE+67)
#define ERROR_NO_CONNECTION             (RASBASE+68)
#define ERROR_BAD_USAGE_IN_INI_FILE     (RASBASE+69)
#define ERROR_READING_SECTIONNAME       (RASBASE+70)
#define ERROR_READING_DEVICETYPE        (RASBASE+71)
#define ERROR_READING_DEVICENAME        (RASBASE+72)
#define ERROR_READING_USAGE             (RASBASE+73)
#define ERROR_READING_MAXCONNECTBPS     (RASBASE+74)
#define ERROR_READING_MAXCARRIERBPS     (RASBASE+75)
#define ERROR_LINE_BUSY                 (RASBASE+76)
#define ERROR_VOICE_ANSWER              (RASBASE+77)
#define ERROR_NO_ANSWER                 (RASBASE+78)
#define ERROR_NO_CARRIER                (RASBASE+79)
#define ERROR_NO_DIALTONE               (RASBASE+80)
#define ERROR_IN_COMMAND                (RASBASE+81)
#define ERROR_WRITING_SECTIONNAME       (RASBASE+82)
#define ERROR_WRITING_DEVICETYPE        (RASBASE+83)
#define ERROR_WRITING_DEVICENAME        (RASBASE+84)
#define ERROR_WRITING_MAXCONNECTBPS     (RASBASE+85)
#define ERROR_WRITING_MAXCARRIERBPS     (RASBASE+86)
#define ERROR_WRITING_USAGE             (RASBASE+87)
#define ERROR_WRITING_DEFAULTOFF        (RASBASE+88)
#define ERROR_READING_DEFAULTOFF        (RASBASE+89)
#define ERROR_EMPTY_INI_FILE            (RASBASE+90)
#define ERROR_AUTHENTICATION_FAILURE    (RASBASE+91)
#define ERROR_PORT_OR_DEVICE            (RASBASE+92)
#define ERROR_NOT_BINARY_MACRO          (RASBASE+93)
#define ERROR_DCB_NOT_FOUND             (RASBASE+94)
#define ERROR_STATE_MACHINES_NOT_STARTE (RASBASE+95)
#define ERROR_STATE_MACHINES_ALREADY_ST (RASBASE+96)
#define ERROR_PARTIAL_RESPONSE_LOOPING  (RASBASE+97)
#define ERROR_UNKNOWN_RESPONSE_KEY      (RASBASE+98)
#define ERROR_RECV_BUF_FULL             (RASBASE+99)
#define ERROR_CMD_TOO_LONG              (RASBASE+100)
#define ERROR_UNSUPPORTED_BPS           (RASBASE+101)
#define ERROR_UNEXPECTED_RESPONSE       (RASBASE+102)
#define ERROR_INTERACTIVE_MODE          (RASBASE+103)
#define ERROR_BAD_CALLBACK_NUMBER       (RASBASE+104)
#define ERROR_INVALID_AUTH_STATE        (RASBASE+105)
#define ERROR_WRITING_INITBPS           (RASBASE+106)
#define ERROR_INVALID_WIN_HANDLE        (RASBASE+107)
#define ERROR_NO_PASSWORD               (RASBASE+108)
#define ERROR_NO_USERNAME               (RASBASE+109)
#define ERROR_CANNOT_START_STATE_MACHIN (RASBASE+110)
#define ERROR_GETTING_COMMSTATE         (RASBASE+111)
#define ERROR_SETTING_COMMSTATE         (RASBASE+112)
#define ERROR_COMM_FUNCTION             (RASBASE+113)
#define ERROR_CONFIGURATION_PROBLEM     (RASBASE+114)
#define ERROR_X25_DIAGNOSTIC            (RASBASE+115)
#define ERROR_TOO_MANY_LINE_ERRORS      (RASBASE+116)
#define ERROR_OVERRUN                   (RASBASE+117)
#define ERROR_ACCT_EXPIRED              (RASBASE+118)
#define ERROR_CHANGING_PASSWORD         (RASBASE+119)
#define ERROR_NO_ACTIVE_ISDN_LINES      (RASBASE+120)
#define ERROR_NO_ISDN_CHANNELS_AVAILABL (RASBASE+121)

#define RASBASEEND                           (RASBASE+121)


#endif // _RASERROR_H_
