/*++
 *
 *  WOW v1.0
 *
 *  Copyright (c) 1991, Microsoft Corporation
 *
 *  WMTBL32.C
 *  WOW32 32-bit message thunk tables
 *
 *  History:
 *  Created 19-Feb-1992 by Chandan Chauhan (ChandanC)
 *  Changed 12-May-1992 by Mike Tricker (MikeTri) Added MultiMedia calls - 3A0 to 3CF
 *  Changed 30-Apr-1995 by Dave Hart updated with new/changed messages, removed
 *                         message numbers from name text, replaced "EMPTY!0x02A7" with
 *                         NULL and changed lookup code to display message number when
 *                         NULL.
--*/
#include "precomp.h"
#pragma hdrstop

MODNAME(wmtbl32.c);

//
// Note: If any of the message thunks is changed from a 'validthunk' to
//       WM32NoThunking  make sure that 16->32 messages  are not affected
//       (see thunkwmmsg16/unthunkwmmsg16 in msg16.c).  If a 16->32 thunk
//       does exist for the message in question you must use W32Thunk16To32
//       instead of WM32NoThunking.
//                                                     - nanduri

//
// The message names present in the checked build of this table are used by
// GetWMMsgName, which is called in lots of places on checked builds.
//
//                                                     - davehart
//

M32 aw32Msg[] = {
    {W32MSGFUN(WM32NoThunking,        "WM_NULL")},
    {W32MSGFUN(WM32Create,            "WM_CREATE")},
    {W32MSGFUN(WM32Destroy,           "WM_DESTROY")},
    {W32MSGFUN(WM32NoThunking,        "WM_MOVE")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_SIZEWAIT")},
    {W32MSGFUN(WM32NoThunking,        "WM_SIZE")},
    {W32MSGFUN(WM32Activate,          "WM_ACTIVATE")},
    {W32MSGFUN(WM32SetFocus,          "WM_SETFOCUS")},

    // 0x8
    {W32MSGFUN(WM32SetFocus,          "WM_KILLFOCUS")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_SETVISIBLE")},
    {W32MSGFUN(WM32NoThunking,        "WM_ENABLE")},
    {W32MSGFUN(WM32Thunk16To32,       "WM_SETREDRAW")},
    {W32MSGFUN(WM32SetText,           "WM_SETTEXT")},
    {W32MSGFUN(WM32GetText,           "WM_GETTEXT")},
    {W32MSGFUN(WM32NoThunking,        "WM_GETTEXTLENGTH")},
    {W32MSGFUN(WM32NCPaint,           "WM_PAINT")},

    // 0x10
    {W32MSGFUN(WM32NoThunking,        "WM_CLOSE")},
    {W32MSGFUN(WM32NoThunking,        "WM_QUERYENDSESSION")},
    {W32MSGFUN(WM32NoThunking,        "WM_QUIT")},
    {W32MSGFUN(WM32NoThunking,        "WM_QUERYOPEN")},
    {W32MSGFUN(WM32EraseBkGnd,        "WM_ERASEBKGND")},
    {W32MSGFUN(WM32NoThunking,        "WM_SYSCOLORCHANGE")},
    {W32MSGFUN(WM32NoThunking,        "WM_ENDSESSION")},
    {W32MSGFUN(WM32NoThunking,        "WM_SYSTEMERROR")},

    // 0x18
    {W32MSGFUN(WM32NoThunking,        "WM_SHOWWINDOW")},
    {W32MSGFUN(WM32CtlColor,          "WM_CTLCOLOR")},
    {W32MSGFUN(WM32SetText,           "WM_WININICHANGE")},
    {W32MSGFUN(WM32SetText,           "WM_DEVMODECHANGE")},
    {W32MSGFUN(WM32ActivateApp,       "WM_ACTIVATEAPP")},
    {W32MSGFUN(WM32NoThunking,        "WM_FONTCHANGE")},
    {W32MSGFUN(WM32NoThunking,        "WM_TIMECHANGE")},
    {W32MSGFUN(WM32NoThunking,        "WM_CANCELMODE")},

    // 0x20
    {W32MSGFUN(WM32SetFocus,          "WM_SETCURSOR")},
    {W32MSGFUN(WM32SetFocus,          "WM_MOUSEACTIVATE")},
    {W32MSGFUN(WM32NoThunking,        "WM_CHILDACTIVATE")},
    {W32MSGFUN(WM32NoThunking,        "WM_QUEUESYNC")},
    {W32MSGFUN(WM32GetMinMaxInfo,     "WM_GETMINMAXINFO")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_LOGOFF")},
    {W32MSGFUN(WM32NoThunking,        "WM_PAINTICON")},
    {W32MSGFUN(WM32EraseBkGnd,        "WM_ICONERASEBKGND")},

    // 0x28
    {W32MSGFUN(WM32NextDlgCtl,        "WM_NEXTDLGCTL")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_ALTTABACTIVE")},
    {W32MSGFUN(WM32NoThunking,        "WM_SPOOLERSTATUS")},
    {W32MSGFUN(WM32DrawItem,          "WM_DRAWITEM")},
    {W32MSGFUN(WM32MeasureItem,       "WM_MEASUREITEM")},
    {W32MSGFUN(WM32DeleteItem,        "WM_DELETEITEM")},
    {W32MSGFUN(WM32VKeyToItem,        "WM_VKEYTOITEM")},
    {W32MSGFUN(WM32VKeyToItem,        "WM_CHARTOITEM")},

    // 0x30
    {W32MSGFUN(WM32SetFont,           "WM_SETFONT")},
    {W32MSGFUN(WM32GetFont,           "WM_GETFONT")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_SETHOTKEY")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_GETHOTKEY")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_FILESYSCHANGE")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_ISACTIVEICON")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_QUERYPARKICON")},
    {W32MSGFUN(WM32QueryDragIcon,     "WM_QUERYDRAGICON")},

    // 0x38
    {W32MSGFUN(WM32WinHelp,           "WM_WINHELP")},
    {W32MSGFUN(WM32CompareItem,       "WM_COMPAREITEM")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_FULLSCREEN")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_CLIENTSHUTDOWN")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_DDEMLEVENT")},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32MMCalcScroll,      "MM_CALCSCROLL")},

    // 0x40
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_TESTING")},
    {W32MSGFUN(WM32NoThunking,        "WM_COMPACTING")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_OTHERWINDOWCREATED")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_OTHERWINDOWDESTROYED")},
    {W32MSGFUN(WM32NoThunking,        "WM_COMMNOTIFY")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_HOTKEYEVENT")},
    {W32MSGFUN(WM32WindowPosChanging, "WM_WINDOWPOSCHANGING")},
    {W32MSGFUN(WM32WindowPosChanging, "WM_WINDOWPOSCHANGED")},

    // 0x48
    {W32MSGFUN(WM32NoThunking,        "WM_POWER")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_COPYGLOBALDATA")},
    {W32MSGFUN(WM32CopyData,          "WM_COPYDATA")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_CANCELJOURNAL")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_LOGONNOTIFY")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_KEYF1")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_NOTIFY")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_ACCESS_WINDOW")},

    // 0x50
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_INPUTLANGCHANGEREQUEST")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_INPUTLANGCHANGE")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_TCARD")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_HELP")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_USERCHANGED")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_NOTIFYFORMAT")},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x58
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x60
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x68
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x70
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_FINALDESTROY")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_MEASUREITEM_CLIENTDATA")},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x78
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_CONTEXTMENU")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_STYLECHANGING")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_STYLECHANGED")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_DISPLAYCHANGE")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_GETICON")},

    // 0x80
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_SETICON")},
    {W32MSGFUN(WM32Create,            "WM_NCCREATE")},
    {W32MSGFUN(WM32NoThunking,        "WM_NCDESTROY")},
    {W32MSGFUN(WM32NCCalcSize,        "WM_NCCALCSIZE")},
    {W32MSGFUN(WM32NoThunking,        "WM_NCHITTEST")},
    {W32MSGFUN(WM32NCPaint,           "WM_NCPAINT")},
    {W32MSGFUN(WM32Activate,          "WM_NCACTIVATE")},
    {W32MSGFUN(WM32GetDlgCode,        "WM_GETDLGCODE")},

    // 0x88
    {W32MSGFUN(WM32NoThunking,        "WM_SYNCPAINT")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_SYNCTASK")},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_KLUDGEMINRECT")},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x90
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x98
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0xA0
    {W32MSGFUN(WM32NoThunking,        "WM_NCMOUSEMOVE")},
    {W32MSGFUN(WM32NoThunking,        "WM_NCLBUTTONDOWN")},
    {W32MSGFUN(WM32NoThunking,        "WM_NCLBUTTONUP")},
    {W32MSGFUN(WM32NoThunking,        "WM_NCLBUTTONDBLCLK")},
    {W32MSGFUN(WM32NoThunking,        "WM_NCRBUTTONDOWN")},
    {W32MSGFUN(WM32NoThunking,        "WM_NCRBUTTONUP")},
    {W32MSGFUN(WM32NoThunking,        "WM_NCRBUTTONDBLCLK")},
    {W32MSGFUN(WM32NoThunking,        "WM_NCMBUTTONDOWN")},

    // 0xA8
    {W32MSGFUN(WM32NoThunking,        "WM_NCMBUTTONUP")},
    {W32MSGFUN(WM32NoThunking,        "WM_NCMBUTTONDBLCLK")},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0xB0
    {W32MSGFUN(WM32EMControl,         "EM_GETSEL")},
    {W32MSGFUN(WM32EMSetSel,          "EM_SETSEL")},
    {W32MSGFUN(WM32EMGetRect,         "EM_GETRECT")},
    {W32MSGFUN(WM32EMSetRect,         "EM_SETRECT")},
    {W32MSGFUN(WM32EMSetRect,         "EM_SETRECTNP")},
    {W32MSGFUN(WM32EMControl,         "EM_SCROLL")},
    {W32MSGFUN(WM32EMLineScroll,      "EM_LINESCROLL")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EM_SCROLLCARET")},

    // 0xB8
    {W32MSGFUN(WM32EMControl,         "EM_GETMODIFY")},
    {W32MSGFUN(WM32EMControl,         "EM_SETMODIFY")},
    {W32MSGFUN(WM32EMControl,         "EM_GETLINECOUNT")},
    {W32MSGFUN(WM32EMControl,         "EM_LINEINDEX")},
    {W32MSGFUN(WM32EMControl,         "EM_SETHANDLE")},
    {W32MSGFUN(WM32EMControl,         "EM_GETHANDLE")},
    {W32MSGFUN(WM32EMControl,         "EM_GETTHUMB")},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0xC0
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32EMControl,         "EM_LINELENGTH")},
    {W32MSGFUN(WM32EMReplaceSel,      "EM_REPLACESEL")},
    {W32MSGFUN(WM32SetFont,           "EM_SETFONT")},
    {W32MSGFUN(WM32EMGetLine,         "EM_GETLINE")},
    {W32MSGFUN(WM32EMControl,         "EM_LIMITTEXT")},
    {W32MSGFUN(WM32EMControl,         "EM_CANUNDO")},
    {W32MSGFUN(WM32EMControl,         "EM_UNDO")},

    // 0xC8
    {W32MSGFUN(WM32EMControl,         "EM_FMTLINES")},
    {W32MSGFUN(WM32EMControl,         "EM_LINEFROMCHAR")},
    {W32MSGFUN(WM32EMControl,         "EM_SETWORDBREAK")},
    {W32MSGFUN(WM32EMSetTabStops,     "EM_SETTABSTOPS")},
    {W32MSGFUN(WM32EMControl,         "EM_SETPASSWORDCHAR")},
    {W32MSGFUN(WM32EMControl,         "EM_EMPTYUNDOBUFFER")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EM_GETFIRSTVISIBLELINE")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EM_SETREADONLY")},

    // 0xD0
    {W32MSGFUN(WM32EMSetWordBreakProc,"EM_SETWORDBREAKPROC")},
    {W32MSGFUN(WM32EMGetWordBreakProc,"EM_GETWORDBREAKPROC")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EM_GETPASSWORDCHAR")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EM_SETMARGINS")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EM_GETMARGINS")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EM_GETLIMITTEXT")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EM_POSFROMCHAR")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "EM_CHARFROMPOS")},

    // 0xD8
    {W32MSGFUN(WM32UNDOCUMENTED,      "EM_MSGMAX")},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0xE0
    {W32MSGFUN(WM32SBMControl,        "SBM_SETPOS")},
    {W32MSGFUN(WM32SBMControl,        "SBM_GETPOS")},
    {W32MSGFUN(WM32SBMSetRange,       "SBM_SETRANGE")},
    {W32MSGFUN(WM32SBMGetRange,       "SBM_GETRANGE")},
    {W32MSGFUN(WM32SBMControl,        "SBM_ENABLE_ARROWS")},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32SBMSetRange,       "SBM_SETRANGEREDRAW")},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0xE8
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "SBM_SETSCROLLINFO")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "SBM_GETSCROLLINFO")},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0xF0
    {W32MSGFUN(WM32BMControl,         "BM_GETCHECK")},
    {W32MSGFUN(WM32BMControl,         "BM_SETCHECK")},
    {W32MSGFUN(WM32BMControl,         "BM_GETSTATE")},
    {W32MSGFUN(WM32BMControl,         "BM_SETSTATE")},
    {W32MSGFUN(WM32BMControl,         "BM_SETSTYLE")},
    {W32MSGFUN(WM32BMClick,           "BM_CLICK")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "BM_GETIMAGE")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "BM_SETIMAGE")},

    // 0xF8
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x100
    {W32MSGFUN(WM32NoThunking,        "WM_KEYDOWN")},
    {W32MSGFUN(WM32NoThunking,        "WM_KEYUP")},
    {W32MSGFUN(WM32NoThunking,        "WM_CHAR")},
    {W32MSGFUN(WM32NoThunking,        "WM_DEADCHAR")},
    {W32MSGFUN(WM32NoThunking,        "WM_SYSKEYDOWN")},
    {W32MSGFUN(WM32NoThunking,        "WM_SYSKEYUP")},
    {W32MSGFUN(WM32NoThunking,        "WM_SYSCHAR")},
    {W32MSGFUN(WM32NoThunking,        "WM_SYSDEADCHAR")},

    // 0x108
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_YOMICHAR/WM_CONVERTREQUESTEX")},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_CONVERTREQUEST")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_CONVERTRESULT")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_INTERIM")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_IME_STARTCOMPOSITION")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_IME_ENDCOMPOSITION")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_IME_COMPOSITION")},

    // 0x110
    {W32MSGFUN(WM32SetFocus  ,        "WM_INITDIALOG")},
    {W32MSGFUN(WM32Command,           "WM_COMMAND")},
    {W32MSGFUN(WM32Thunk16To32,       "WM_SYSCOMMAND")},
    {W32MSGFUN(WM32Timer,             "WM_TIMER")},
    {W32MSGFUN(WM32HScroll,           "WM_HSCROLL")},
    {W32MSGFUN(WM32HScroll,           "WM_VSCROLL")},
    {W32MSGFUN(WM32InitMenu,          "WM_INITMENU")},
    {W32MSGFUN(WM32InitMenu,          "WM_INITMENUPOPUP")},

    // 0x118
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_SYSTIMER")},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32MenuSelect,        "WM_MENUSELECT")},

    // 0x120
    {W32MSGFUN(WM32MenuChar,          "WM_MENUCHAR")},
    {W32MSGFUN(WM32EnterIdle,         "WM_ENTERIDLE")},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x128
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x130
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_LBTRACKPOINT")},
    {W32MSGFUN(WM32CtlColor,          "WM_CTLCOLORMSGBOX")},
    {W32MSGFUN(WM32CtlColor,          "WM_CTLCOLOREDIT")},
    {W32MSGFUN(WM32CtlColor,          "WM_CTLCOLORLISTBOX")},
    {W32MSGFUN(WM32CtlColor,          "WM_CTLCOLORBTN")},
    {W32MSGFUN(WM32CtlColor,          "WM_CTLCOLORDLG")},
    {W32MSGFUN(WM32CtlColor,          "WM_CTLCOLORSCROLLBAR")},

    // 0x138
    {W32MSGFUN(WM32CtlColor,          "WM_CTLCOLORSTATIC")},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x140
    {W32MSGFUN(WM32CBControl,         "CB_GETEDITSEL")},
    {W32MSGFUN(WM32CBControl,         "CB_LIMITTEXT")},
    {W32MSGFUN(WM32CBControl,         "CB_SETEDITSEL")},
    {W32MSGFUN(WM32CBAddString,       "CB_ADDSTRING")},
    {W32MSGFUN(WM32CBControl,         "CB_DELETESTRING")},
    {W32MSGFUN(WM32CBDir,             "CB_DIR")},
    {W32MSGFUN(WM32CBControl,         "CB_GETCOUNT")},
    {W32MSGFUN(WM32CBControl,         "CB_GETCURSEL")},

    // 0x148
    {W32MSGFUN(WM32CBGetLBText,       "CB_GETLBTEXT")},
    {W32MSGFUN(WM32CBControl,         "CB_GETLBTEXTLEN")},
    {W32MSGFUN(WM32CBAddString,       "CB_INSERTSTRING")},
    {W32MSGFUN(WM32CBControl,         "CB_RESETCONTENT")},
    {W32MSGFUN(WM32CBAddString,       "CB_FINDSTRING")},
    {W32MSGFUN(WM32CBAddString,       "CB_SELECTSTRING")},
    {W32MSGFUN(WM32CBControl,         "CB_SETCURSEL")},
    {W32MSGFUN(WM32CBControl,         "CB_SHOWDROPDOWN")},

    // 0x150
    {W32MSGFUN(WM32CBControl,         "CB_GETITEMDATA")},
    {W32MSGFUN(WM32CBControl,         "CB_SETITEMDATA")},
    {W32MSGFUN(WM32CBGetDropDownControlRect,"CB_GETDROPDOWNCONTROLRECT")},
    {W32MSGFUN(WM32CBControl,         "CB_SETITEMHEIGHT")},
    {W32MSGFUN(WM32CBControl,         "CB_GETITEMHEIGHT")},
    {W32MSGFUN(WM32CBControl,         "CB_SETEXTENDEDUI")},
    {W32MSGFUN(WM32CBControl,         "CB_GETEXTENDEDUI")},
    {W32MSGFUN(WM32CBControl,         "CB_GETDROPPEDSTATE")},

    // 0x158
    {W32MSGFUN(WM32CBAddString,       "CB_FINDSTRINGEXACT")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "CB_SETLOCALE")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "CB_GETLOCALE")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "CB_GETTOPINDEX")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "CB_SETTOPINDEX")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "CB_GETHORIZONTALEXTENT")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "CB_SETHORIZONTALEXTENT")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "CB_GETDROPPEDWIDTH")},

    // 0x160
    {W32MSGFUN(WM32UNDOCUMENTED,      "CB_SETDROPPEDWIDTH")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "CB_INITSTORAGE")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "CB_MSGMAX")},
    {W32MSGFUN(WM32CBComboFocus,      "CBEC_SETCOMBOFOCUS")},
    {W32MSGFUN(WM32CBComboFocus,      "CBEC_KILLCOMBOFOCUS")},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x168
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x170
    {W32MSGFUN(WM32STMControl,        "STM_SETICON")},
    {W32MSGFUN(WM32STMControl,        "STM_GETICON")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "STM_SETIMAGE")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "STM_GETIMAGE")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "STM_MSGMAX")},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x178
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x180
    {W32MSGFUN(WM32LBAddString,       "LB_ADDSTRING")},
    {W32MSGFUN(WM32LBAddString,       "LB_INSERTSTRING")},
    {W32MSGFUN(WM32LBControl,         "LB_DELETESTRING")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "LB_SELITEMRANGEEX")},
    {W32MSGFUN(WM32LBControl,         "LB_RESETCONTENT")},
    {W32MSGFUN(WM32LBSetSel,          "LB_SETSEL")},
    {W32MSGFUN(WM32LBControl,         "LB_SETCURSEL")},
    {W32MSGFUN(WM32LBControl,         "LB_GETSEL")},

    // 0x188
    {W32MSGFUN(WM32LBControl,         "LB_GETCURSEL")},
    {W32MSGFUN(WM32LBGetText,         "LB_GETTEXT")},
    {W32MSGFUN(WM32LBGetTextLen,      "LB_GETTEXTLEN")},
    {W32MSGFUN(WM32LBControl,         "LB_GETCOUNT")},
    {W32MSGFUN(WM32LBAddString,       "LB_SELECTSTRING")},
    {W32MSGFUN(WM32LBDir,             "LB_DIR")},
    {W32MSGFUN(WM32LBControl,         "LB_GETTOPINDEX")},
    {W32MSGFUN(WM32LBAddString,       "LB_FINDSTRING")},

    // 0x190
    {W32MSGFUN(WM32LBControl,         "LB_GETSELCOUNT")},
    {W32MSGFUN(WM32LBGetSelItems,     "LB_GETSELITEMS")},
    {W32MSGFUN(WM32LBSetTabStops,     "LB_SETTABSTOPS")},
    {W32MSGFUN(WM32LBControl,         "LB_GETHORIZONTALEXTENT")},
    {W32MSGFUN(WM32LBControl,         "LB_SETHORIZONTALEXTENT")},
    {W32MSGFUN(WM32LBControl,         "LB_SETCOLUMNWIDTH")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "LB_ADDFILE")},
    {W32MSGFUN(WM32LBControl,         "LB_SETTOPINDEX")},

    // 0x198
    {W32MSGFUN(WM32LBGetItemRect,     "LB_GETITEMRECT")},
    {W32MSGFUN(WM32LBControl,         "LB_GETITEMDATA")},
    {W32MSGFUN(WM32LBControl,         "LB_SETITEMDATA")},
    {W32MSGFUN(WM32LBControl,         "LB_SELITEMRANGE")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "LB_SETANCHORINDEX")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "LB_GETANCHORINDEX")},
    {W32MSGFUN(WM32LBControl,         "LB_SETCARETINDEX")},
    {W32MSGFUN(WM32LBControl,         "LB_GETCARETINDEX")},

    // 0x1A0
    {W32MSGFUN(WM32LBControl,         "LB_SETITEMHEIGHT")},
    {W32MSGFUN(WM32LBControl,         "LB_GETITEMHEIGHT")},
    {W32MSGFUN(WM32LBAddString,       "LB_FINDSTRINGEXACT")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "LBCB_CARETON")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "LBCB_CARETOFF")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "LB_SETLOCALE")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "LB_GETLOCALE")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "LB_SETCOUNT")},

    // 0x1A8
    {W32MSGFUN(WM32UNDOCUMENTED,      "LB_INITSTORAGE")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "LB_ITEMFROMPOINT")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "LB_INSERTSTRINGUPPER")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "LB_INSERTSTRINGLOWER")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "LB_ADDSTRINGUPPER")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "LB_ADDSTRINGLOWER")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "LBCB_STARTTRACK")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "LBCB_ENDTRACK")},

    // 0x1B0
    {W32MSGFUN(WM32UNDOCUMENTED,      "LB_MSGMAX")},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x1B8
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x1C0
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x1C8
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x1D0
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x1D8
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x1E0
    {W32MSGFUN(WM32UNDOCUMENTED,      "MN_SETHMENU")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "MN_GETHMENU")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "MN_SIZEWINDOW")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "MN_OPENHIERARCHY")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "MN_CLOSEHIERARCHY")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "MN_SELECTITEM")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "MN_CANCELMENUS")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "MN_SELECTFIRSTVALIDITEM")},

    // 0x1E8
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "MN_GETPPOPUPMENU")},
    {W32MSGFUN(WM32MNFindMenuWindow,  "MN_FINDMENUWINDOWFROMPOINT")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "MN_SHOWPOPUPWINDOW")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "MN_BUTTONDOWN")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "MN_MOUSEMOVE")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "MN_BUTTONUP")},

    // 0x1F0
    {W32MSGFUN(WM32UNDOCUMENTED,      "MN_SETTIMERTOOPENHIERARCHY")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "MN_DBLCLK")},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x1F8
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x200
    {W32MSGFUN(WM32NoThunking,        "WM_MOUSEMOVE")},
    {W32MSGFUN(WM32NoThunking,        "WM_LBUTTONDOWN")},
    {W32MSGFUN(WM32NoThunking,        "WM_LBUTTONUP")},
    {W32MSGFUN(WM32NoThunking,        "WM_LBUTTONDBLCLK")},
    {W32MSGFUN(WM32NoThunking,        "WM_RBUTTONDOWN")},
    {W32MSGFUN(WM32NoThunking,        "WM_RBUTTONUP")},
    {W32MSGFUN(WM32NoThunking,        "WM_RBUTTONDBLCLK")},
    {W32MSGFUN(WM32NoThunking,        "WM_MBUTTONDOWN")},

    // 0x208
    {W32MSGFUN(WM32NoThunking,        "WM_MBUTTONUP")},
    {W32MSGFUN(WM32NoThunking,        "WM_MBUTTONDBLCLK")},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x210
    {W32MSGFUN(WM32ParentNotify,      "WM_PARENTNOTIFY")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_ENTERMENULOOP")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_EXITMENULOOP")},
    {W32MSGFUN(WM32NextMenu,          "WM_NEXTMENU")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_SIZING")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_CAPTURECHANGED")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_MOVING")},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x218
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_POWERBROADCAST")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_DEVICECHANGE")},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x220
    {W32MSGFUN(WM32MDICreate,         "WM_MDICREATE")},
    {W32MSGFUN(WM32SetFocus,          "WM_MDIDESTROY")},
    {W32MSGFUN(WM32MDIActivate,       "WM_MDIACTIVATE")},
    {W32MSGFUN(WM32SetFocus,          "WM_MDIRESTORE")},
    {W32MSGFUN(WM32SetFocus,          "WM_MDINEXT")},
    {W32MSGFUN(WM32SetFocus,          "WM_MDIMAXIMIZE")},
    {W32MSGFUN(WM32Thunk16To32,       "WM_MDITILE")},
    {W32MSGFUN(WM32Thunk16To32,       "WM_MDICASCADE")},

    // 0x228
    {W32MSGFUN(WM32NoThunking,        "WM_MDIICONARRANGE")},
    {W32MSGFUN(WM32MDIGetActive,      "WM_MDIGETACTIVE")},
    {W32MSGFUN(WM32DropObject,        "WM_DROPOBJECT")},
    {W32MSGFUN(WM32DropObject,        "WM_QUERYDROPOBJECT")},
    {W32MSGFUN(WM32Thunk16To32,       "WM_BEGINDRAG")},
    {W32MSGFUN(WM32DropObject,        "WM_DRAGLOOP")},
    {W32MSGFUN(WM32DropObject,        "WM_DRAGSELECT")},
    {W32MSGFUN(WM32DropObject,        "WM_DRAGMOVE")},

    // 0x230
    {W32MSGFUN(WM32MDISetMenu,        "WM_MDISETMENU")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_ENTERSIZEMOVE")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_EXITSIZEMOVE")},
    {W32MSGFUN(WM32DropFiles,         "WM_DROPFILES")},
    {W32MSGFUN(WM32MDISetMenu,        "WM_MDIREFRESHMENU")},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x238
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x240
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x248
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x250
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x258
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x260
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x268
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x270
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x278
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x280
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_KANJIFIRST")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_IME_SETCONTEXT")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_IME_NOTIFY")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_IME_CONTROL")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_IME_COMPOSITIONFULL")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_IME_SELECT")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_IME_CHAR")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_IME_SYSTEM")},

    // 0x288
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x290
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_IME_KEYDOWN")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_IME_KEYUP")},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x298
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_KANJILAST")},

    // 0x2A0
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x2A8
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x2B0
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x2B8
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x2C0
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x2C8
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x2D0
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x2D8
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x2E0
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x2E8
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x2F0
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x2F8
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x300
    {W32MSGFUN(WM32NoThunking,        "WM_CUT")},
    {W32MSGFUN(WM32NoThunking,        "WM_COPY")},
    {W32MSGFUN(WM32NoThunking,        "WM_PASTE")},
    {W32MSGFUN(WM32NoThunking,        "WM_CLEAR")},
    {W32MSGFUN(WM32NoThunking,        "WM_UNDO")},
    {W32MSGFUN(WM32NoThunking,        "WM_RENDERFORMAT")},
    {W32MSGFUN(WM32NoThunking,        "WM_RENDERALLFORMATS")},
    {W32MSGFUN(WM32NoThunking,        "WM_DESTROYCLIPBOARD")},

    // 0x308
    {W32MSGFUN(WM32NoThunking,        "WM_DRAWCLIPBOARD")},
    {W32MSGFUN(WM32SizeClipBoard,     "WM_PAINTCLIPBOARD")},
    {W32MSGFUN(WM32SetFocus,          "WM_VSCROLLCLIPBOARD")},
    {W32MSGFUN(WM32SizeClipBoard,     "WM_SIZECLIPBOARD")},
    {W32MSGFUN(WM32AskCBFormatName,   "WM_ASKCBFORMATNAME")},
    {W32MSGFUN(WM32ChangeCBChain,     "WM_CHANGECBCHAIN")},
    {W32MSGFUN(WM32SetFocus,          "WM_HSCROLLCLIPBOARD")},
    {W32MSGFUN(WM32NoThunking,        "WM_QUERYNEWPALETTE")},

    // 0x310
    {W32MSGFUN(WM32SetFocus,          "WM_PALETTEISCHANGING")},
    {W32MSGFUN(WM32SetFocus,          "WM_PALETTECHANGED")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_HOTKEY")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_SYSMENU")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_HOOKMSG")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_EXITPROCESS")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_WAKETHREAD")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_PRINT")},

    // 0x318
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_PRINTCLIENT")},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x320
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x328
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x330
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x338
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x340
    {W32MSGFUN(WM32NotifyWow,         "WM_NOTIFYWOW")},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x348
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x350
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x358
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_HANDHELDFIRST")},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_HANDHELDLAST")},

    // 0x360
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_AFXFIRST")},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x368
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x370
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x378
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_AFXLAST")},

    // 0x380
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_PENWINFIRST")},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x388
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_PENWINLAST")},

    // 0x390
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_COALESCE_FIRST")},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x398
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_COALESCE_LAST")},

    // 0x3A0
    {W32MSGFUN(WM32NoThunking,        "MM_JOY1MOVE")},
    {W32MSGFUN(WM32NoThunking,        "MM_JOY2MOVE")},
    {W32MSGFUN(WM32NoThunking,        "MM_JOY1ZMOVE")},
    {W32MSGFUN(WM32NoThunking,        "MM_JOY2ZMOVE")},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x3A8
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x3B0
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32NoThunking,        "MM_JOY1BUTTONDOWN")},
    {W32MSGFUN(WM32NoThunking,        "MM_JOY2BUTTONDOWN")},
    {W32MSGFUN(WM32NoThunking,        "MM_JOY1BUTTONUP")},

    // 0x3B8
    {W32MSGFUN(WM32NoThunking,        "MM_JOY2BUTTONUP")},
    {W32MSGFUN(WM32NoThunking,        "MM_MCINOTIFY")},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32NoThunking,        "MM_WOM_OPEN")},
    {W32MSGFUN(WM32NoThunking,        "MM_WOM_CLOSE")},
    {W32MSGFUN(WM32NoThunking,        "MM_WOM_DONE")},
    {W32MSGFUN(WM32NoThunking,        "MM_WIM_OPEN")},
    {W32MSGFUN(WM32NoThunking,        "MM_WIM_CLOSE")},

    // 0x3C0
    {W32MSGFUN(WM32NoThunking,        "MM_WIM_DATA")},
    {W32MSGFUN(WM32NoThunking,        "MM_MIM_OPEN")},
    {W32MSGFUN(WM32NoThunking,        "MM_MIM_CLOSE")},
    {W32MSGFUN(WM32NoThunking,        "MM_MIM_DATA")},
    {W32MSGFUN(WM32NoThunking,        "MM_MIM_LONGDATA")},
    {W32MSGFUN(WM32NoThunking,        "MM_MIM_ERROR")},
    {W32MSGFUN(WM32NoThunking,        "MM_MIM_LONGERROR")},
    {W32MSGFUN(WM32NoThunking,        "MM_MOM_OPEN")},

    // 0x3C8
    {W32MSGFUN(WM32NoThunking,        "MM_MOM_CLOSE")},
    {W32MSGFUN(WM32NoThunking,        "MM_MOM_DONE")},
    {W32MSGFUN(WM32UNDOCUMENTED,      "MM_MCISYSTEM_STRING")},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x3D0
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x3D8
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x3E0
    {W32MSGFUN(WM32DDEInitiate,       "WM_DDE_INITIATE")},
    {W32MSGFUN(WM32DDERequest,        "WM_DDE_TERMINATE")},
    {W32MSGFUN(WM32DDEAdvise,         "WM_DDE_ADVISE")},
    {W32MSGFUN(WM32DDERequest,        "WM_DDE_UNADVISE")},
    {W32MSGFUN(WM32DDEAck,            "WM_DDE_ACK")},
    {W32MSGFUN(WM32DDEData,           "WM_DDE_DATA")},
    {W32MSGFUN(WM32DDERequest,        "WM_DDE_REQUEST")},
    {W32MSGFUN(WM32DDEPoke,           "WM_DDE_POKE")},

    // 0x3E8
    {W32MSGFUN(WM32DDEExecute,        "WM_DDE_EXECUTE")},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x3F0
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_CBT_RESERVED_FIRST")},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},

    // 0x3F8
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      NULL)},
    {W32MSGFUN(WM32UNDOCUMENTED,      "WM_CBT_RESERVED_LAST")},
};


#ifdef DEBUG_OR_WOWPROFILE
INT  iMsgMax  = NUMEL(aw32Msg);
PM32 paw32Msg = aw32Msg;
#endif

