/********************************************************************/
/**                     Microsoft LAN Manager                      **/
/**               Copyright(c) Microsoft Corp., 1990-1991          **/
/********************************************************************/

//***
//
// Filename:	asyerror.h
//
// Description:
//
// History:
//               3/ 1/91  Thomas Dimitri  - OS/2 version
//               4/25/91  Steve Cobb      - DiAdmin dependency comments
//

// This is the base for all errors generated by dialin module
// THis is done so that there is not conflict with OS/2 errors
//
#define	    ASYBASE		600

#define     OK			0

//****************** WAN LAYER RETURN CODES ********************************

// NOTE: The DiAdmin program displays error messages for those errors
//       that may be returned from the Admin API, currently ASYBASE+10
//       thru ASYBASE+35.  If you make changes to the codes or meanings
//       of these errors or add new errors which may reach the Admin
//       API, be sure to update the ASYERROR.STR file in DiAdmin as well.
//       (C-SteveC 3/25/91)

#define     ERR_SYSTEM		ASYBASE+1 // the device is already opened or connecting
#define     ERR_CONFIG		ASYBASE+3 // an invalid config param
#define     ERR_INV_PARAM	ASYBASE+4 // an invalid param
#define     ERR_BUFF_TOO_SMALL	ASYBASE+5 // as it says
#define     ERR_NO_RESOURCE	ASYBASE+6 // no more available CCBs

//This is not an error, but an indication that a disc has been done
// following the user's request
#define ERR_DISCONNECT_REQUEST	 ASYBASE+30

//Timeout while trying to establish a connection
#define ERR_CONNECTION_TIMEOUT	 ASYBASE+31

//The remote side disconnected
#define ERR_REMOTE_DISCONNECTED  ASYBASE+32

//Hardware (modem most probably) failure
#define ERR_HARDWARE_FAILURE	 ASYBASE+33

//******************* OS/2 LAYER ********************************************

// SEE NOTE ABOVE before changing these codes.

//This error occurs when a WpdConnect is called but you are
//already connected.
#define ERR_CONNECTION_FAILURE	 ASYBASE+34

//The TimerQ is full and cannot post a time event
#define ERR_NOTIMERQ		ASYBASE+10

//The ActionQ is full and cannot post an immediate action event
#define	ERR_NOACTIONQ	ASYBASE+11

//The port is already in use
#define ERR_USEDPORT	ASYBASE+12

//Can not open the device driver
#define ERR_OPENDEVICE	ASYBASE+13

//Can not set line control for port (data, parity, bps)
#define ERR_LINECONTROL	ASYBASE+14

//Can not set baud rate for port
#define ERR_BADBAUD		ASYBASE+15

//Can not set DCBInfo struct correctly (my fault)
#define ERR_SETDCB		ASYBASE+16

//Can not set DTR bit on modem output control (do you have a modem attached?)
#define ERR_SETDTR		ASYBASE+17

//Can not allocate a thread stack with DosAllocSeg (buy more memory)
#define ERR_ALLOC		ASYBASE+18

//Can not create thread (maybe set THREADS= in config.sys to bigger num)
#define ERR_CREATETHREAD	ASYBASE+19

//The port is already in use
#define ERR_NOPORT		ASYBASE+20

//The MAC device driver is not loaded
#define ERR_NOMAC		ASYBASE+21

//The MAC device driver is loaded, but doesn't like my IOCTL command
#define ERR_NOMACIOCTL	ASYBASE+22

//The MAC device driver is loaded, but it's worker died
#define ERR_MACWORKERDIED	ASYBASE+23

//The protocol.ini file has bad params for Maxframesize or binds to none
#define ERR_BADCONFIG	ASYBASE+24

//The protocol.ini file has bad params for Maxframesize or binds to none
#define ERR_BADFRAMESIZE	ASYBASE+25

//A call was made with a bad handle
#define ERR_BADHANDLE	ASYBASE+26

//Tried to close a handle that was already closed
#define ERR_ALREADYCLOSED	ASYBASE+27

//Could not complete a DosWrite to the com port (returned premature)
#define ERR_WRITETOCOMPORT	ASYBASE+28

// there is no NET bound to the ASYBEUI$ driver (i.e. fix lanman.ini)
#define ERR_NOLANA	ASYBASE+36

// tried to create a system semaphore and it failed (some other proc has sem)
#define ERR_CANTCREATETIMERSEM	ASYBASE+37

// tried to reallocate the size of my ring 2 stack - failed (more memory?)
#define ERR_CANTCREATERING2STACK ASYBASE+38

// all the Async NETS have been used up - thus refuse to open up a ccb.
#define ERR_NOFREENET ASYBASE+39

// The modem did not echo back the string or did not respond to the
// string with something like "OK".
#define ERR_MODEM_NOT_RESPONDING ASYBASE+40

// internal error cause by the async worker process being spawned incorrectly
// or the OS/2 machine is so fucking slow (piece of shit 286) that the
// worker has not responded in time (25 secs)
#define ERR_WORKER_NOT_RESPONDING ASYBASE+41

// Information was requested for a port that does not belong to
// the dialin service
//
#define ERR_NO_SUCH_DEVICE				ASYBASE+35

// modems layer return codes. They are self-explainatory
//
#define	ERR_MODEMS_INI_FILE_CORRUPTED	ASYBASE+42
#define ERR_UNEXPECTED_MODEM_STRING	ASYBASE+43
#define ERR_COULD_NOT_OPEN_MODEMS_INI 	ASYBASE+44
#define ERR_INVALID_MODEM_COMMAND 	ASYBASE+45
#define ERR_NULL_PHONENUMBER		ASYBASE+46
#define ERR_ILLEGAL_FUNCTION_ID 	ASYBASE+47


// Return codes for the dial command and the remote UI
//
#define ERR_SYNTAX_ERROR				ASYBASE+48
#define HELP_MSG					ASYBASE+49
#define ERR_ILLEGAL_SWITCH_VALUE			ASYBASE+50
#define ERR_DEVICE_INACTIVE				ASYBASE+51
#define ERR_WANTSR_NOT_LOADED				ASYBASE+52
#define ERR_INVALID_USERNAME				ASYBASE+53
#define ERR_INVALID_PASSWORD				ASYBASE+54
#define ERR_AMBIGIOUS_SWITCH_ERROR  			ASYBASE+55
#define ERR_UNKNOWN_SWITCH_ERROR			ASYBASE+56
#define ERR_MULTIPLE_SWITCH_ERROR			ASYBASE+57	
#define ERR_SIGHAND_INSTALL_ERROR			ASYBASE+58
#define ERR_ASSEMBLE_NAMES_ERROR			ASYBASE+60
#define ERR_NO_ACTIVE_CONNECTIONS			ASYBASE+61
#define ERR_CANNOT_OPEN_TRANSPORT   			ASYBASE+62
#define ERR_ENCRYPT_ERROR 				ASYBASE+63
#define ERR_WKSTA_NOT_STARTED 				ASYBASE+64
#define ERR_PHONEBOOK_EMPTY 				ASYBASE+65
#define ERR_AUTH_NET_ERROR				ASYBASE+66
#define ERR_UNEXPECTED_AMB				ASYBASE+67
#define ERR_INVALID_PHONE_NUMBER			ASYBASE+68
#define ERR_CANNOT_GET_LANA				ASYBASE+69
#define ERR_CANNOT_BIND_LANA				ASYBASE+70
#define ERR_CANNOT_UNBIND_LANA				ASYBASE+71
#define ERR_NOT_AUTHENTICATED				ASYBASE+72
#define ERR_NOT_AUTHENTICATED_RETRY			ASYBASE+74

// Codes returned by WAN primitives and support routines.
//
#define ERR_COULD_NOT_OPEN_COMDEV_INI 			ASYBASE+75
#define ERR_COULD_NOT_OPEN_PHONE_INI 			ASYBASE+76
#define ERR_CORRUPT_COMDEVINI_ENTRY			ASYBASE+77
#define ERR_CORRUPT_PHONEINI_ENTRY			ASYBASE+78
#define ERR_MEMORY_ALLOC_ERROR 				ASYBASE+79
#define ERR_NO_DEVICES_AVAILABLE 			ASYBASE+80
#define ERR_NO_ENTRY_POINT				ASYBASE+81
#define ERR_ENTRY_NOT_FOUND				ASYBASE+82
#define ERR_CORRUPT_COMDEVINI				ASYBASE+83
#define ERR_CONNECTION_EXISTS				ASYBASE+84
#define ERR_SERVER_NOT_RESPONDING			ASYBASE+85
#define ERR_TOO_MANY_INITIAL_NAMES			ASYBASE+86
#define ERR_CANNOT_GET_COMPUTERNAME			ASYBASE+87
#define ERR_DEVICE_NOT_CONFIGURED			ASYBASE+88
#define ERR_MSG_ALIAS_NOT_ADDED				ASYBASE+89
#define ERR_NAME_OUT_OF_RESOURCES			ASYBASE+90
#define ERR_NAME_NET_FAILURE				ASYBASE+91
#define ERR_NAME_ADD_CONFLICT		 		ASYBASE+92

#define ERR_NO_DIALIN_PERM				ASYBASE+94
#define ERR_LISTEN_TIMEOUT				ASYBASE+95


// The modem reponse codes
//
#define MODEM_RC_OK 			ASYBASE+100
#define MODEM_RC_NO_CARRIER 		ASYBASE+101
#define MODEM_RC_NO_DIALTONE 		ASYBASE+102
#define MODEM_RC_NO_ANSWER 		ASYBASE+103
#define MODEM_RC_BUSY			ASYBASE+104
#define MODEM_RC_LOOP			ASYBASE+105
#define MODEM_RC_ERROR 			ASYBASE+106	
#define MODEM_RC_CONNECT 		ASYBASE+107
#define MODEM_RC_CONNECT_REL 		ASYBASE+108

// Error code returned by the DOS Async primitives WpdConnectInit and
// WpdConnectComplete if the current connection state is such that the
// primitive can not be completed. For instance, trying to init a
// connection when the state is not DISCONNECTED or trying to set the
// CONNECTED state for a DISCONNECTED or DISCONNECTING connection.

#define ERR_CONNECTION_STATE				  ASYBASE+110


// This is not an error, but it needs to be distinguished from all
// the other return codes. This code indicated that the authentication
// is not completed and needs to be called again. Used by the UI's.
//
#define RAS_CONTINUE_AUTHENTICATION			ASYBASE+111


#define	ERR_CANNOT_OPEN_PAD_INI 	ASYBASE+112
#define	ERR_PAD_INI_FILE_CORRUPTED	ASYBASE+113
#define ERR_UNEXPECTED_PAD_STRING	ASYBASE+114
#define ERR_PAD_NOT_RESPONDING		ASYBASE+115
#define ERR_NULL_X25ADD 		ASYBASE+116
#define PAD_RC_ERROR			ASYBASE+117
