/* Copyright (c) 1996, Microsoft Corporation, all rights reserved
**
** loaddlls.h
** RAS DLL load public header
**
** 02/17/96 Steve Cobb
*/

#ifndef _LOADDLLS_H_
#define _LOADDLLS_H_


#include <ras.h>    // Win32 RAS APIs
#include <rasdlg.h> // Win32 RAS UI APIs
#include <rasman.h> // RAS connection manager service
#include <rasppp.h> // PPP structure definitions


/*----------------------------------------------------------------------------
** Datatypes and global declarations (defined in loaddlls.c)
**----------------------------------------------------------------------------
*/

/* RASAPI32.DLL entry points.
*/
extern HINSTANCE g_hRasapi32Dll;

typedef DWORD (APIENTRY * PRASCONNECTIONNOTIFICATION)( HRASCONN, HANDLE, DWORD );
extern PRASCONNECTIONNOTIFICATION g_pRasConnectionNotification;

typedef DWORD (APIENTRY * PRASDELETEENTRY)( LPTSTR, LPTSTR );
extern PRASDELETEENTRY g_pRasDeleteEntry;

typedef DWORD (APIENTRY * PRASDIAL)( LPRASDIALEXTENSIONS, LPTSTR, LPRASDIALPARAMS, DWORD, LPVOID, LPHRASCONN );
extern PRASDIAL g_pRasDial;

typedef DWORD (APIENTRY * PRASENUMENTRIES)( LPTSTR, LPTSTR, LPRASENTRYNAME, LPDWORD, LPDWORD );
extern PRASENUMENTRIES g_pRasEnumEntries;

typedef DWORD (APIENTRY * PRASENUMCONNECTIONS)( LPRASCONN, LPDWORD, LPDWORD );
extern PRASENUMCONNECTIONS g_pRasEnumConnections;

typedef DWORD (APIENTRY * PRASGETCONNECTSTATUS)( HRASCONN, LPRASCONNSTATUS );
extern PRASGETCONNECTSTATUS g_pRasGetConnectStatus;

typedef VOID (APIENTRY * PRASGETCONNECTRESPONSE)( HRASCONN, CHAR* );
extern PRASGETCONNECTRESPONSE g_pRasGetConnectResponse;

typedef DWORD (APIENTRY * PRASGETCREDENTIALS)( LPTSTR, LPTSTR, LPRASCREDENTIALS );
extern PRASGETCREDENTIALS g_pRasGetCredentials;

typedef DWORD (APIENTRY * PRASGETENTRYDIALPARAMS)( LPTSTR, LPRASDIALPARAMS, LPBOOL );
extern PRASGETENTRYDIALPARAMS g_pRasGetEntryDialParams;

typedef DWORD (APIENTRY * PRASGETERRORSTRING)( UINT, LPTSTR, DWORD );
extern PRASGETERRORSTRING g_pRasGetErrorString;

typedef DWORD (APIENTRY * PRASHANGUP)( HRASCONN );
extern PRASHANGUP g_pRasHangUp;

typedef DWORD (APIENTRY * PRASGETAUTODIALENABLE)( DWORD, LPBOOL );
extern PRASGETAUTODIALENABLE g_pRasGetAutodialEnable;

typedef DWORD (APIENTRY * PRASGETAUTODIALPARAM)( DWORD, LPVOID, LPDWORD );
extern PRASGETAUTODIALPARAM g_pRasGetAutodialParam;

typedef DWORD (APIENTRY * PRASGETPROJECTIONINFO)( HRASCONN, RASPROJECTION, LPVOID, LPDWORD );
extern PRASGETPROJECTIONINFO g_pRasGetProjectionInfo;

typedef DWORD (APIENTRY * PRASSETAUTODIALENABLE)( DWORD, BOOL );
extern PRASSETAUTODIALENABLE g_pRasSetAutodialEnable;

typedef DWORD (APIENTRY * PRASSETAUTODIALPARAM)( DWORD, LPVOID, DWORD );
extern PRASSETAUTODIALPARAM g_pRasSetAutodialParam;

typedef DWORD (APIENTRY * PRASGETSUBENTRYHANDLE)( HRASCONN, DWORD, LPHRASCONN );
extern PRASGETSUBENTRYHANDLE g_pRasGetSubEntryHandle;

typedef HPORT (APIENTRY * PRASGETHPORT)( HRASCONN );
extern PRASGETHPORT g_pRasGetHport;

typedef DWORD (APIENTRY * PRASSETCREDENTIALS)( LPTSTR, LPTSTR, LPRASCREDENTIALS, BOOL );
extern PRASSETCREDENTIALS g_pRasSetCredentials;

typedef DWORD (APIENTRY * PRASSETOLDPASSWORD)( HRASCONN, CHAR* );
extern PRASSETOLDPASSWORD g_pRasSetOldPassword;


/* RASDLG.DLL entry points
*/
extern HINSTANCE g_hRasdlgDll;

typedef DWORD (APIENTRY * PRASPHONEBOOKDLG)( LPTSTR, LPTSTR, LPRASPBDLG );
extern PRASPHONEBOOKDLG g_pRasPhonebookDlg;

typedef DWORD (APIENTRY * PRASENTRYDLG)( LPTSTR, LPTSTR, LPRASENTRYDLG );
extern PRASENTRYDLG g_pRasEntryDlg;

typedef DWORD (APIENTRY * PRASDIALDLG)( LPTSTR, LPTSTR, LPTSTR, LPRASDIALDLG );
extern PRASDIALDLG g_pRasDialDlg;

typedef DWORD (APIENTRY * PRASMONITORDLG)( LPTSTR, LPRASMONITORDLG );
extern PRASMONITORDLG g_pRasMonitorDlg;


/* RASMAN.DLL entry points
*/
extern HINSTANCE g_hRasmanDll;

typedef DWORD (APIENTRY * PRASPORTCLEARSTATISTICS)( HPORT );
extern PRASPORTCLEARSTATISTICS g_pRasPortClearStatistics;

typedef DWORD (APIENTRY * PRASBUNDLECLEARSTATISTICS)( HPORT );
extern PRASBUNDLECLEARSTATISTICS g_pRasBundleClearStatistics;

typedef DWORD (APIENTRY * PRASDEVICEENUM)( PCHAR, PBYTE, PWORD, PWORD );
extern PRASDEVICEENUM g_pRasDeviceEnum;

typedef DWORD (APIENTRY * PRASDEVICEGETINFO)( HPORT, PCHAR, PCHAR, PBYTE, PWORD );
extern PRASDEVICEGETINFO g_pRasDeviceGetInfo;

typedef DWORD (APIENTRY * PRASFREEBUFFER)( PBYTE );
extern PRASFREEBUFFER g_pRasFreeBuffer;

typedef DWORD (APIENTRY * PRASGETBUFFER)( PBYTE*, PWORD );
extern PRASGETBUFFER g_pRasGetBuffer;

typedef DWORD (APIENTRY * PRASPORTGETFRAMINGEX)( HPORT, RAS_FRAMING_INFO* );
extern PRASPORTGETFRAMINGEX g_pRasPortGetFramingEx;

typedef DWORD (APIENTRY * PRASGETINFO)( HPORT, RASMAN_INFO* );
extern PRASGETINFO g_pRasGetInfo;

typedef DWORD (APIENTRY * PRASINITIALIZE)();
extern PRASINITIALIZE g_pRasInitialize;

typedef DWORD (APIENTRY * PRASPORTCANCELRECEIVE)( HPORT );
extern PRASPORTCANCELRECEIVE g_pRasPortCancelReceive;

typedef DWORD (APIENTRY * PRASPORTENUM)( PBYTE, PWORD, PWORD );
extern PRASPORTENUM g_pRasPortEnum;

typedef DWORD (APIENTRY * PRASPORTGETINFO)( HPORT, PBYTE, PWORD );
extern PRASPORTGETINFO g_pRasPortGetInfo;

typedef DWORD (APIENTRY * PRASPORTGETSTATISTICS)( HPORT, PBYTE, PWORD );
extern PRASPORTGETSTATISTICS g_pRasPortGetStatistics;

typedef DWORD (APIENTRY * PRASBUNDLEGETSTATISTICS)( HPORT, PBYTE, PWORD );
extern PRASBUNDLEGETSTATISTICS g_pRasBundleGetStatistics;

typedef DWORD (APIENTRY * PRASPORTRECEIVE)( HPORT, PBYTE, PWORD, DWORD, HANDLE );
extern PRASPORTRECEIVE g_pRasPortReceive;

typedef DWORD (APIENTRY * PRASPORTSEND)( HPORT, PBYTE, WORD );
extern PRASPORTSEND g_pRasPortSend;

typedef DWORD (APIENTRY * PRASPORTGETBUNDLE)( HPORT, HBUNDLE* );
extern PRASPORTGETBUNDLE g_pRasPortGetBundle;

typedef DWORD (APIENTRY * PRASGETDEVCONFIG)( HPORT, PCHAR, PBYTE, DWORD* );
extern PRASGETDEVCONFIG g_pRasGetDevConfig;

typedef DWORD (APIENTRY * PRASSETDEVCONFIG)( HPORT, PCHAR, PBYTE, DWORD );
extern PRASSETDEVCONFIG g_pRasSetDevConfig;

typedef DWORD (APIENTRY * PRASPORTOPEN)(PCHAR, HPORT*, HANDLE);
extern PRASPORTOPEN g_pRasPortOpen;

typedef DWORD (APIENTRY * PRASPORTREGISTERSLIP)(HPORT, DWORD, WCHAR*, BOOL, WCHAR*, WCHAR*, WCHAR*, WCHAR*);
extern PRASPORTREGISTERSLIP g_pRasPortRegisterSlip;

typedef DWORD (APIENTRY * PRASALLOCATEROUTE)(HPORT, RAS_PROTOCOLTYPE, BOOL, RASMAN_ROUTEINFO*);
extern PRASALLOCATEROUTE g_pRasAllocateRoute;

typedef DWORD (APIENTRY * PRASACTIVATEROUTE)(HPORT, RAS_PROTOCOLTYPE, RASMAN_ROUTEINFO*, PROTOCOL_CONFIG_INFO*);
extern PRASACTIVATEROUTE g_pRasActivateRoute;

typedef DWORD (APIENTRY * PRASACTIVATEROUTEEX)(HPORT, RAS_PROTOCOLTYPE, DWORD, RASMAN_ROUTEINFO*, PROTOCOL_CONFIG_INFO*);
extern PRASACTIVATEROUTEEX g_pRasActivateRouteEx;

typedef DWORD (APIENTRY * PRASDEVICESETINFO)(HPORT, PCHAR, PCHAR, RASMAN_DEVICEINFO*);
extern PRASDEVICESETINFO g_pRasDeviceSetInfo;

typedef DWORD (APIENTRY * PRASDEVICECONNECT)(HPORT, PCHAR, PCHAR, DWORD, HANDLE);
extern PRASDEVICECONNECT g_pRasDeviceConnect;

typedef DWORD (APIENTRY * PRASPORTSETINFO)(HPORT, RASMAN_PORTINFO*);
extern PRASPORTSETINFO g_pRasPortSetInfo;

typedef DWORD (APIENTRY * PRASPORTCLOSE)(HPORT);
extern PRASPORTCLOSE g_pRasPortClose;

typedef DWORD (APIENTRY * PRASPORTLISTEN)(HPORT, DWORD, HANDLE);
extern PRASPORTLISTEN g_pRasPortListen;

typedef DWORD (APIENTRY * PRASPORTCONNECTCOMPLETE)(HPORT);
extern PRASPORTCONNECTCOMPLETE g_pRasPortConnectComplete;

typedef DWORD (APIENTRY * PRASPORTDISCONNECT)(HPORT, HANDLE);
extern PRASPORTDISCONNECT g_pRasPortDisconnect;

typedef DWORD (APIENTRY * PRASREQUESTNOTIFICATION)(HPORT, HANDLE);
extern PRASREQUESTNOTIFICATION g_pRasRequestNotification;

typedef DWORD (APIENTRY * PRASPORTENUMPROTOCOLS)(HPORT, RAS_PROTOCOLS*, PWORD);
extern PRASPORTENUMPROTOCOLS g_pRasPortEnumProtocols;

typedef DWORD (APIENTRY * PRASPORTSETFRAMING)(HPORT, RAS_FRAMING, RASMAN_PPPFEATURES*, RASMAN_PPPFEATURES*);
extern PRASPORTSETFRAMING g_pRasPortSetFraming;

typedef DWORD (APIENTRY * PRASPORTSETFRAMINGEX)(HPORT, RAS_FRAMING_INFO*);
extern PRASPORTSETFRAMINGEX g_pRasPortSetFramingEx;

typedef DWORD (APIENTRY * PRASSETCACHEDCREDENTIALS)(PCHAR, PCHAR, PCHAR);
extern PRASSETCACHEDCREDENTIALS g_pRasSetCachedCredentials;

typedef DWORD (APIENTRY * PRASGETDIALPARAMS)(DWORD, LPDWORD, PRAS_DIALPARAMS);
extern PRASGETDIALPARAMS g_pRasGetDialParams;

typedef DWORD (APIENTRY * PRASSETDIALPARAMS)(DWORD, DWORD, PRAS_DIALPARAMS, BOOL);
extern PRASSETDIALPARAMS g_pRasSetDialParams;

typedef DWORD (APIENTRY * PRASCREATECONNECTION)(HCONN*);
extern PRASCREATECONNECTION g_pRasCreateConnection;

typedef DWORD (APIENTRY * PRASDESTROYCONNECTION)(HCONN);
extern PRASDESTROYCONNECTION g_pRasDestroyConnection;

typedef DWORD (APIENTRY * PRASCONNECTIONENUM)(HCONN*, LPDWORD, LPDWORD);
extern PRASCONNECTIONENUM g_pRasConnectionEnum;

typedef DWORD (APIENTRY * PRASADDCONNECTIONPORT)(HCONN, HPORT, DWORD);
extern PRASADDCONNECTIONPORT g_pRasAddConnectionPort;

typedef DWORD (APIENTRY * PRASENUMCONNECTIONPORTS)(HCONN, RASMAN_PORT*, LPDWORD, LPDWORD);
extern PRASENUMCONNECTIONPORTS g_pRasEnumConnectionPorts;

typedef DWORD (APIENTRY * PRASGETCONNECTIONPARAMS)(HCONN, PRAS_CONNECTIONPARAMS);
extern PRASGETCONNECTIONPARAMS g_pRasGetConnectionParams;

typedef DWORD (APIENTRY * PRASSETCONNECTIONPARAMS)(HCONN, PRAS_CONNECTIONPARAMS);
extern PRASSETCONNECTIONPARAMS g_pRasSetConnectionParams;

typedef DWORD (APIENTRY * PRASGETCONNECTIONUSERDATA)(HCONN, DWORD, PBYTE, LPDWORD);
extern PRASGETCONNECTIONUSERDATA g_pRasGetConnectionUserData;

typedef DWORD (APIENTRY * PRASSETCONNECTIONUSERDATA)(HCONN, DWORD, PBYTE, DWORD);
extern PRASSETCONNECTIONUSERDATA g_pRasSetConnectionUserData;

typedef DWORD (APIENTRY * PRASGETPORTUSERDATA)(HCONN, DWORD, PBYTE, LPDWORD);
extern PRASGETPORTUSERDATA g_pRasGetPortUserData;

typedef DWORD (APIENTRY * PRASSETPORTUSERDATA)(HCONN, DWORD, PBYTE, DWORD);
extern PRASSETPORTUSERDATA g_pRasSetPortUserData;

typedef DWORD (APIENTRY * PRASADDNOTIFICATION)(HCONN, HANDLE, DWORD);
extern PRASADDNOTIFICATION g_pRasAddNotification;

typedef DWORD (APIENTRY * PRASSIGNALNEWCONNECTION)(HCONN);
extern PRASSIGNALNEWCONNECTION g_pRasSignalNewConnection;

typedef DWORD (APIENTRY * PRASPPPSTOP)(HPORT);
extern PRASPPPSTOP g_pRasPppStop;

typedef DWORD (APIENTRY * PRASPPPCALLBACK)(HPORT, CHAR*);
extern PRASPPPCALLBACK g_pRasPppCallback;

typedef DWORD (APIENTRY * PRASPPPCHANGEPASSWORD)(HPORT, CHAR*, CHAR*, CHAR*);
extern PRASPPPCHANGEPASSWORD g_pRasPppChangePassword;

typedef DWORD (APIENTRY * PRASPPPGETINFO)(HPORT, PPP_MESSAGE*);
extern PRASPPPGETINFO g_pRasPppGetInfo;

typedef DWORD (APIENTRY * PRASPPPRETRY)(HPORT, CHAR*, CHAR*, CHAR*);
extern PRASPPPRETRY g_pRasPppRetry;

typedef DWORD (APIENTRY *PRASPPPSTART)(HPORT, CHAR*, CHAR*, CHAR*, LUID*,
                                       PPP_CONFIG_INFO*, LPVOID, CHAR*,
                                       BOOL, HANDLE, DWORD);
extern PRASPPPSTART g_pRasPppStart;

/*----------------------------------------------------------------------------
** Prototypes
**----------------------------------------------------------------------------
*/

BOOL
IsRasmanServiceRunning(
    void );

DWORD
LoadRasapi32Dll(
    void );

DWORD
LoadRasdlgDll(
    void );

DWORD
LoadRasmanDll(
    void );

VOID
UnloadRasapi32Dll(
    void );

VOID
UnloadRasdlgDll(
    void );

VOID
UnloadRasmanDll(
    void );


#endif // _LOADDLLS_H_
