/*
 * Copyright (c) 1989,90 Microsoft Corporation
 */
/**********************************************************************
 * This file contains routines to save a trapezoid as new clippath or
 * stroe in command buffer for performing scan conversion and rendering
 * rendering the image by the lower level graphics primitives.
 *
 *      Name:       savetpzd.c
 *
 *      Purpose:
 *
 *      Developer:  S.C.Chen
 *
 *      History:
 *      Version     Date        Comments
 *      3.0         8/13/88     Scan conversion enhancement :
 *                              This file is to replace the original "gfill.c"
 *                              for scan conversion enhancement.
 *                  10/18/88    source file reorganization for saving trapezoids
 *                              in command buffer instead of scanlines, i.e.
 *                              defer scan conversion at lower level graphics
 *                              primitives:
 *                              split scanconv.c => savetpzd.c & fillgb.c
 *                              savetpzd -- save trapezoid in command buffer
 *                              fillgb   -- perform scan conversion
 *                  11/09/88    modify save_tpzd for checking if the format of
 *                              the trapezoid is correct; Temp. solution, should
 *                              be revised later
 *                  1/12/89     modify save_tpzd(): not need to truncate
 *                              endpoints to pixels
 *                  1/25/89     save_tpzd(): expand bounding box of trapezoid :
 *                              get floor of topy & ceil of btmy
 *                  11/19/91    upgrade for higher resolution @RESO_UPGR
 **********************************************************************/


// DJC added global include
#include "psglobal.h"



#include        <math.h>
#include        <stdio.h>
#include "global.ext"
#include "graphics.h"
#include "graphics.ext"
#include "font.h"
#include "font.ext"

static struct  tpzd_info near fill_info;

/* ********** static function declartion ********** */

#ifdef LINT_ARGS
/* for type checks of the parameters in function declarations */
static void near add_clip (struct tpzd FAR *);

#else
/* for no type checks of the parameters in function declarations */
static void near add_clip ();
#endif


/***********************************************************************
 * According to the type(fill_destination), this routine appends the input
 * trapezoid to current clip path, or calls lower level graphics primitives
 * fill_tpzd to render it to appropriate destination(cache, page, mask, or
 * seed pattern).
 *
 * TITLE:       save_tpzd
 *
 * CALL:        save_tpzd(tpzd)
 *
 * PARAMETERS:
 *              tpzd: a trapezoid
 *
 *              global variable: fill_destination
 *                      F_TO_CACHE -- fill to cache memory
 *                      F_TO_PAGE  -- fill to page
 *                      F_TO_CLIP  -- fill to clip mask
 *                      F_TO_IMAGE -- fill for image(build seed pattern)
 *                      SAVE_CLIP  -- save the tpzd as a new clip path
 *
 * INTERFACE:
 *
 * CALLS:       fill_tpzd
 *
 * RETURN:      None
 **********************************************************************/
void save_tpzd(tpzd)
struct tpzd FAR *tpzd;
{

        /* fix     lx, ux; */
        sfix_t  lx, ux; /* @RESO_UPGR */

#ifdef DBG
        printf("save_tpzd(): dest=%d\n\ttpzd=\n", fill_destination);
        printf("topy=%f, topxl=%f, topxr=%f\n", SFX2F(tpzd->topy),
                SFX2F(tpzd->topxl), SFX2F(tpzd->topxr));
        printf("btmy=%f, btmxl=%f, btmxr=%f\n", SFX2F(tpzd->btmy),
                SFX2F(tpzd->btmxl), SFX2F(tpzd->btmxr));
#endif

        /* modify trapezoid if it is generated by shape_reduction incorrectly.
         * for error recovery
         */
        if (tpzd->topxl > tpzd->topxr) {
#ifdef DBGwarn
                printf("\07save_tpzd() error!");
                printf("topy=%f, topxl=%f, topxr=%f\n", SFX2F(tpzd->topy),
                        SFX2F(tpzd->topxl), SFX2F(tpzd->topxr));
                printf("btmy=%f, btmxl=%f, btmxr=%f\n", SFX2F(tpzd->btmy),
                        SFX2F(tpzd->btmxl), SFX2F(tpzd->btmxr));
#endif
                tpzd->topxl = tpzd->topxr;
        }

        /* save to current clip path */
        if (fill_destination == SAVE_CLIP) {
                add_clip(tpzd);
                return;
        }

        /* set bounding box of the trapezoid, used for lower level graphics
         * primitives
         */
        if (fill_destination == F_TO_CACHE) {
                /* bounding box is defined by cache mechanism */
                fill_info.BMAP = cache_info->bitmap;
                fill_info.box_w = cache_info->box_w;
                fill_info.box_h = cache_info->box_h;
        } else {
                lx = (tpzd->topxl < tpzd->btmxl) ? tpzd->topxl : tpzd->btmxl;
                ux = (tpzd->topxr > tpzd->btmxr) ? tpzd->topxr : tpzd->btmxr;
                lx = SFX2I_T(lx);  /* be consistent with gp_scanconv 2/12/92 */
                ux = SFX2I_T(ux);  /* be consistent with gp_scanconv 2/12/92 */
                fill_info.BOX_X = ALIGN_L(lx);
                fill_info.BOX_Y = SFX2I_T(tpzd->topy);  /* 1/25/89 */
                fill_info.box_w = ALIGN_R(ux) - fill_info.BOX_X + 1;
                /* fill_info.box_h = SFX2I(tpzd->btmy - tpzd->topy) + 1; */
                fill_info.box_h = SFX2I_T(tpzd->btmy + ONE_SFX - 1)
                                  - fill_info.BOX_Y + 1; /* 1/25/89 */
        }

        fill_tpzd (fill_destination, &fill_info, tpzd);

}


/***********************************************************************
 * Appends the input trapezoid to the new_clip structure. The new_clip is a
 * global variable, initialized by op_clip and op_eoclip, and will be set as
 * the new clip path in the graphics state after it has been set up.
 *
 * TITLE:       add_clip
 *
 * CALL:        add_clip(tpzd)
 *
 * PARAMETERS:
 *              tpzd: a trapezoid
 *
 *              global variable: new_clip, to save the new clip path
 *
 * INTERFACE:   Save_tpzd
 *
 * CALLS:       None
 *
 * RETURN:      None
 **********************************************************************/
static void near add_clip (tpzd)
struct tpzd FAR *tpzd;
{
        CP_IDX edge;
        struct nd_hdr FAR *ep;

        /* get a node */
        edge = get_node();
        if(edge == NULLP) {     /* 05/07/91, Out of node table */
                ERROR(LIMITCHECK);
                return;
        }
        ep = &node_table[edge];

        /* set up a new clip trapezoid */
        ep->CP_TOPY = tpzd->topy;
        ep->CP_TOPXL = tpzd->topxl;
        ep->CP_TOPXR = tpzd->topxr;
        ep->CP_BTMY = tpzd->btmy;
        ep->CP_BTMXL = tpzd->btmxl;
        ep->CP_BTMXR = tpzd->btmxr;
        if(new_clip.head == NULLP)
                new_clip.head = edge;
        else
                node_table[new_clip.tail].next = edge;
        new_clip.tail = edge;

        /* update bounding box of new_clip */
        if (ep->CP_TOPY < new_clip.bb_ly)
                new_clip.bb_ly = ep->CP_TOPY;
        if (ep->CP_TOPXL < new_clip.bb_lx)
                new_clip.bb_lx = ep->CP_TOPXL;
        if (ep->CP_TOPXR > new_clip.bb_ux)
                new_clip.bb_ux = ep->CP_TOPXR;
        if (ep->CP_BTMY > new_clip.bb_uy)
                new_clip.bb_uy = ep->CP_BTMY;
        if (ep->CP_BTMXL < new_clip.bb_lx)
                new_clip.bb_lx = ep->CP_BTMXL;
        if (ep->CP_BTMXR > new_clip.bb_ux)
                new_clip.bb_ux = ep->CP_BTMXR;

}

