/*++

Copyright (c) 1991-1996  Microsoft Corporation

Module Name:

    dfsstub.c

Abstract:

    These are the server service API RPC client stubs for DFS operations

Environment:

    User Mode - Win32

--*/

//
// INCLUDES
//

#include <nt.h>         // DbgPrint prototype

#include <ntrtl.h>      // DbgPrint
#include <rpc.h>        // DataTypes and runtime APIs

#include <srvsvc.h>     // generated by the MIDL complier
#include <lmcons.h>     // NET_API_STATUS
#include <debuglib.h>   // (needed by netrpc.h)
#include <lmsvc.h>      // (needed by netrpc.h)
#include <netdebug.h>   // (needed by netrpc.h)
#include <lmerr.h>      // NetError codes
#include <netrpc.h>     // NET_REMOTE_ macros.


NET_API_STATUS NET_API_FUNCTION
I_NetDfsGetVersion(
    IN  LPWSTR  servername,
    OUT LPDWORD Version)
{
    NET_API_STATUS apiStatus;

    NET_REMOTE_TRY_RPC

        apiStatus = NetrDfsGetVersion( servername, Version );

    NET_REMOTE_RPC_FAILED(
            "I_NetDfsGetVersion",
            servername,
            apiStatus,
            NET_REMOTE_FLAG_NORMAL,
            SERVICE_SERVER)

        apiStatus = ERROR_NOT_SUPPORTED;

    NET_REMOTE_END

    return(apiStatus);

}


NET_API_STATUS NET_API_FUNCTION
I_NetDfsCreateLocalPartition (
    IN  LPWSTR                          servername,
    IN  LPWSTR                          ShareName,
    IN  LPGUID                          EntryUid,
    IN  LPWSTR                          EntryPrefix,
    IN  LPWSTR                          ShortName,
    IN  LPNET_DFS_ENTRY_ID_CONTAINER    RelationInfo,
    IN  BOOL                            Force
    )
{
    NET_API_STATUS  apiStatus;

    NET_REMOTE_TRY_RPC

        apiStatus = NetrDfsCreateLocalPartition (
                        servername,
                        ShareName,
                        EntryUid,
                        EntryPrefix,
                        ShortName,
                        RelationInfo,
                        Force
                        );

    NET_REMOTE_RPC_FAILED(
            "NetDfsCreateLocalPartition",
            servername,
            apiStatus,
            NET_REMOTE_FLAG_NORMAL,
            SERVICE_SERVER)

        apiStatus = ERROR_NOT_SUPPORTED;

    NET_REMOTE_END

    return(apiStatus);

}

NET_API_STATUS NET_API_FUNCTION
I_NetDfsDeleteLocalPartition (
    IN  LPWSTR  servername OPTIONAL,
    IN  LPGUID  Uid,
    IN  LPWSTR  Prefix
    )
{
    NET_API_STATUS  apiStatus;

    NET_REMOTE_TRY_RPC

        apiStatus = NetrDfsDeleteLocalPartition (
                        servername,
                        Uid,
                        Prefix
                        );

    NET_REMOTE_RPC_FAILED(
            "NetDfsDeleteLocalPartition",
            servername,
            apiStatus,
            NET_REMOTE_FLAG_NORMAL,
            SERVICE_SERVER)

        apiStatus = ERROR_NOT_SUPPORTED;

    NET_REMOTE_END;

    return apiStatus;
}

NET_API_STATUS NET_API_FUNCTION
I_NetDfsSetLocalVolumeState (
    IN  LPWSTR  servername OPTIONAL,
    IN  LPGUID  Uid,
    IN  LPWSTR  Prefix,
    IN  ULONG   State
    )
{
    NET_API_STATUS  apiStatus;

    NET_REMOTE_TRY_RPC

        apiStatus = NetrDfsSetLocalVolumeState (
                        servername,
                        Uid,
                        Prefix,
                        State
                        );

    NET_REMOTE_RPC_FAILED(
            "NetDfsSetLocalVolumeState",
            servername,
            apiStatus,
            NET_REMOTE_FLAG_NORMAL,
            SERVICE_SERVER)

        apiStatus = ERROR_NOT_SUPPORTED;

    NET_REMOTE_END;

    return apiStatus;
}

NET_API_STATUS NET_API_FUNCTION
I_NetDfsSetServerInfo (
    IN  LPWSTR  servername OPTIONAL,
    IN  LPGUID  Uid,
    IN  LPWSTR  Prefix
    )
{
    NET_API_STATUS  apiStatus;

    NET_REMOTE_TRY_RPC

        apiStatus = NetrDfsSetServerInfo (
                        servername,
                        Uid,
                        Prefix
                        );

    NET_REMOTE_RPC_FAILED(
            "NetDfsSetServerInfo",
            servername,
            apiStatus,
            NET_REMOTE_FLAG_NORMAL,
            SERVICE_SERVER)

        apiStatus = ERROR_NOT_SUPPORTED;

    NET_REMOTE_END;

    return apiStatus;
}

NET_API_STATUS NET_API_FUNCTION
I_NetDfsCreateExitPoint (
    IN  LPWSTR  servername OPTIONAL,
    IN  LPGUID  Uid,
    IN  LPWSTR  Prefix,
    IN  ULONG   Type,
    IN  ULONG   ShortPrefixSize,
    OUT LPWSTR  ShortPrefix
    )
{
    NET_API_STATUS  apiStatus;

    NET_REMOTE_TRY_RPC

        apiStatus = NetrDfsCreateExitPoint (
                        servername,
                        Uid,
                        Prefix,
                        Type,
                        ShortPrefixSize,
                        ShortPrefix
                        );

    NET_REMOTE_RPC_FAILED(
            "NetDfsCreateExitPoint",
            servername,
            apiStatus,
            NET_REMOTE_FLAG_NORMAL,
            SERVICE_SERVER)

        apiStatus = ERROR_NOT_SUPPORTED;

    NET_REMOTE_END;

    return apiStatus;
}

NET_API_STATUS NET_API_FUNCTION
I_NetDfsDeleteExitPoint (
    IN  LPWSTR  servername OPTIONAL,
    IN  LPGUID  Uid,
    IN  LPWSTR  Prefix,
    IN  ULONG   Type
    )
{
    NET_API_STATUS  apiStatus;

    NET_REMOTE_TRY_RPC

        apiStatus = NetrDfsDeleteExitPoint (
                        servername,
                        Uid,
                        Prefix,
                        Type
                        );

    NET_REMOTE_RPC_FAILED(
            "NetDfsDeleteExitPoint",
            servername,
            apiStatus,
            NET_REMOTE_FLAG_NORMAL,
            SERVICE_SERVER)

        apiStatus = ERROR_NOT_SUPPORTED;

    NET_REMOTE_END;

    return apiStatus;
}

NET_API_STATUS NET_API_FUNCTION
I_NetDfsModifyPrefix (
    IN  LPWSTR  servername OPTIONAL,
    IN  LPGUID  Uid,
    IN  LPWSTR  Prefix
    )
{
    NET_API_STATUS  apiStatus;

    NET_REMOTE_TRY_RPC

        apiStatus = NetrDfsModifyPrefix (
                        servername,
                        Uid,
                        Prefix
                        );

    NET_REMOTE_RPC_FAILED(
            "NetDfsModifyPrefix",
            servername,
            apiStatus,
            NET_REMOTE_FLAG_NORMAL,
            SERVICE_SERVER)

        apiStatus = ERROR_NOT_SUPPORTED;

    NET_REMOTE_END;

    return apiStatus;
}

NET_API_STATUS NET_API_FUNCTION
I_NetDfsFixLocalVolume (
    IN  LPWSTR                          servername OPTIONAL,
    IN  LPWSTR                          VolumeName,
    IN  ULONG                           EntryType,
    IN  ULONG                           ServiceType,
    IN  LPWSTR                          StgId,
    IN  LPGUID                          EntryUid,       // unique id for this partition
    IN  LPWSTR                          EntryPrefix,    // path prefix for this partition
    IN  LPNET_DFS_ENTRY_ID_CONTAINER    RelationInfo,
    IN  ULONG                           CreateDisposition
    )
{
    NET_API_STATUS  apiStatus;

    NET_REMOTE_TRY_RPC

        apiStatus = NetrDfsFixLocalVolume (
                        servername,
                        VolumeName,
                        EntryType,
                        ServiceType,
                        StgId,
                        EntryUid,
                        EntryPrefix,
                        RelationInfo,
                        CreateDisposition
                        );

    NET_REMOTE_RPC_FAILED(
            "NetDfsFixLocalVolume",
            servername,
            apiStatus,
            NET_REMOTE_FLAG_NORMAL,
            SERVICE_SERVER)

        apiStatus = ERROR_NOT_SUPPORTED;

    NET_REMOTE_END;

    return apiStatus;
}

