/*++

Copyright (c) 1990-1995  Microsoft Corporation

Module Name:

	pragma.h

Abstract:

	Pragma definitions for pageable/init/section-pageable NDIS Wrapper routines.

Author:


Environment:

	Kernel mode, FSD

Revision History:

	Feb-96  Jameel Hyder	Moved from individual source files
--*/

#ifndef	_PRAGMA_
#define	_PRAGMA_

#ifdef ALLOC_PRAGMA
#ifdef NDIS_NT

#pragma alloc_text(INIT, DriverEntry)
#pragma alloc_text(INIT, ndisReadRegistry)
#pragma alloc_text(INIT, ndisAddMediaTypeToArray)
#pragma alloc_text(INIT, ndisReadParameters)

#pragma alloc_text(PAGENPNP, ndisDispatchRequest)
#pragma alloc_text(PAGENPNP, ndisHandlePnPRequest)
#pragma alloc_text(PAGENPNP, ndisHandleLoadDriver)
#pragma alloc_text(PAGENPNP, ndisHandleUnloadDriver)
#pragma alloc_text(PAGENPNP, ndisHandleTranslateName)
#pragma alloc_text(PAGENPNP, ndisHandleProtocolNotification)
#pragma alloc_text(PAGENPNP, ndisReferenceAdapterOrMiniportByName)
#pragma alloc_text(PAGENPNP, ndisHandleLegacyTransport)
#pragma alloc_text(PAGENPNP, ndisInitializeBindings)
#pragma alloc_text(PAGENPNP, NdisCompleteBindAdapter)
#pragma alloc_text(PAGENPNP, ndisQueuedProtocolNotification)
#pragma alloc_text(PAGENPNP, NdisCompleteUnbindAdapter)
#pragma alloc_text(PAGENPNP, NdisRegisterTdiCallBack)
#pragma alloc_text(PAGENPNP, ndisInitializePackage)
#pragma alloc_text(PAGENPNP, NdisOpenFile)
#pragma alloc_text(PAGENPNP, NdisCloseFile)
#pragma alloc_text(PAGENPNP, NdisQueryMapRegisterCount)
#pragma alloc_text(PAGENPNP, ndisUnloadMiniport)
#pragma alloc_text(PAGENPNP, ndisTranslateMiniportName)
#pragma alloc_text(PAGENPNP, ndisUnloadMac)
#pragma alloc_text(PAGENPNP, ndisTranslateMacName)
#pragma alloc_text(PAGENPNP, ndisCreateIrpHandler)
#pragma alloc_text(PAGENPNP, ndisDeviceControlIrpHandler)
#pragma alloc_text(PAGENPNP, ndisSuccessIrpHandler)

#pragma alloc_text(PAGENDSI, ndisInitializeAllAdapterInstances)
#pragma alloc_text(PAGENDSI, ndisInitializeAdapter)
#pragma alloc_text(PAGENDSI, ndisMInitializeAdapter)
#pragma alloc_text(PAGENDSI, ndisQueuedBindNotification)
#pragma alloc_text(PAGENDSI, NdisIMInitializeDeviceInstance)
#pragma alloc_text(PAGENDSI, NdisIMDeInitializeDeviceInstance)
#pragma alloc_text(PAGENDSI, ndisValidatePcmciaDriver)
#pragma alloc_text(PAGENDSI, ndisCheckIfPcmciaCardPresent)
#pragma alloc_text(PAGENDSI, ndisFixBusInformation)
#pragma alloc_text(PAGENDSI, ndisAddBusInformation)
#pragma alloc_text(PAGENDSI, ndisSearchGlobalDb)
#pragma alloc_text(PAGENDSI, ndisAddGlobalDb)
#pragma alloc_text(PAGENDSI, ndisDeleteGlobalDb)
#pragma alloc_text(PAGENDSI, ndisCheckProtocolBinding)
#pragma alloc_text(PAGENDSI, ndisProtocolAlreadyBound)
#pragma alloc_text(PAGENDSI, ndisUpdateDriverInstance)
#pragma alloc_text(PAGENDSI, NdisOpenConfiguration)
#pragma alloc_text(PAGENDSI, NdisOpenGlobalConfiguration)
#pragma alloc_text(PAGENDSI, NdisOpenConfigurationKeyByName)
#pragma alloc_text(PAGENDSI, NdisOpenConfigurationKeyByIndex)
#pragma alloc_text(PAGENDSI, NdisReadConfiguration)
#pragma alloc_text(PAGENDSI, NdisWriteConfiguration)
#pragma alloc_text(PAGENDSI, NdisCloseConfiguration)
#pragma alloc_text(PAGENDSI, NdisReadBindingInformation)
#pragma alloc_text(PAGENDSI, NdisReadNetworkAddress)
#pragma alloc_text(PAGENDSI, NdisConvertStringToAtmAddress)
#pragma alloc_text(PAGENDSI, ndisSaveLinkage)
#pragma alloc_text(PAGENDSI, ndisSaveParameters)
#pragma alloc_text(PAGENDSI, ndisCheckRoute)
#pragma alloc_text(PAGENDSI, ndisCheckPortUsage)
#pragma alloc_text(PAGENDSI, ndisStartMapping)
#pragma alloc_text(PAGENDSI, ndisEndMapping)
#pragma alloc_text(PAGENDSI, NdisImmediateReadPortUchar)
#pragma alloc_text(PAGENDSI, NdisImmediateReadPortUshort)
#pragma alloc_text(PAGENDSI, NdisImmediateReadPortUlong)
#pragma alloc_text(PAGENDSI, NdisImmediateWritePortUchar)
#pragma alloc_text(PAGENDSI, NdisImmediateWritePortUshort)
#pragma alloc_text(PAGENDSI, NdisImmediateWritePortUlong)
#pragma alloc_text(PAGENDSI, ndisCheckMemoryUsage)
#pragma alloc_text(PAGENDSI, NdisImmediateReadSharedMemory)
#pragma alloc_text(PAGENDSI, NdisImmediateWriteSharedMemory)
#pragma alloc_text(PAGENDSI, NdisInitializeWrapper)
#pragma alloc_text(PAGENDSI, NdisRegisterAdapterShutdownHandler)
#pragma alloc_text(PAGENDSI, NdisRegisterMac)
#pragma alloc_text(PAGENDSI, NdisRegisterAdapter)
#pragma alloc_text(PAGENDSI, NdisMapIoSpace)
#pragma alloc_text(PAGENDSI, NdisPciAssignResources)
#pragma alloc_text(PAGENDSI, NdisAllocateDmaChannel)
#pragma alloc_text(PAGENDSI, NdisMAllocateMapRegisters)
#pragma alloc_text(PAGENDSI, NdisMSetAttributes)
#pragma alloc_text(PAGENDSI, NdisMSetAttributesEx)
#pragma alloc_text(PAGENDSI, NdisReadEisaSlotInformationEx)
#pragma alloc_text(PAGENDSI, NdisReadEisaSlotInformation)
#pragma alloc_text(PAGENDSI, NdisReadMcaPosInformation)
#pragma alloc_text(PAGENDSI, NdisImmediateReadPciSlotInformation)
#pragma alloc_text(PAGENDSI, NdisImmediateWritePciSlotInformation)
#pragma alloc_text(PAGENDSI, NdisOverrideBusNumber)
#pragma alloc_text(PAGENDSI, NdisInitializeInterrupt)

#pragma alloc_text(PAGENDSM, NdisMRegisterMiniport)
#pragma alloc_text(PAGENDSM, NdisIMRegisterLayeredMiniport)
#pragma alloc_text(PAGENDSM, NdisMDeregisterIoPortRange)
#pragma alloc_text(PAGENDSM, NdisMRegisterIoPortRange)
#pragma alloc_text(PAGENDSM, NdisMMapIoSpace)
#pragma alloc_text(PAGENDSM, NdisMUnmapIoSpace)
#pragma alloc_text(PAGENDSM, NdisMRegisterDmaChannel)
#pragma alloc_text(PAGENDSM, NdisMDeregisterDmaChannel)
#pragma alloc_text(PAGENDSM, NdisMAllocateSharedMemory)
#pragma alloc_text(PAGENDSM, NdisMFreeSharedMemory)
#pragma alloc_text(PAGENDSM, NdisMReadDmaCounter)
#pragma alloc_text(PAGENDSM, NdisMFreeMapRegisters)
#pragma alloc_text(PAGENDSM, NdisMRegisterAdapterShutdownHandler)
#pragma alloc_text(PAGENDSM, NdisMDeregisterAdapterShutdownHandler)
#pragma alloc_text(PAGENDSM, NdisMPciAssignResources)
#pragma alloc_text(PAGENDSM, NdisMInitializeTimer)
#pragma alloc_text(PAGENDSM, NdisMCancelTimer)
#pragma alloc_text(PAGENDSM, NdisMDeregisterInterrupt)
#pragma alloc_text(PAGENDSM, NdisMRegisterInterrupt)
#pragma alloc_text(PAGENDSM, NdisMSynchronizeWithInterrupt)
#pragma alloc_text(PAGENDSM, ndisMIsr)
#pragma alloc_text(PAGENDSM, ndisMDpc)
#pragma alloc_text(PAGENDSM, ndisMWakeUpDpc)
#pragma alloc_text(PAGENDSM, ndisMDpcTimer)
#pragma alloc_text(PAGENDSM, ndisMTimerDpc)
#pragma alloc_text(PAGENDSM, ndisMDeferredTimerDpc)
#pragma alloc_text(PAGENDSM, ndisMDeQueueWorkItem)
#pragma alloc_text(PAGENDSM, ndisMDeQueueWorkItemFullDuplex)
#pragma alloc_text(PAGENDSM, ndisMQueueWorkItem)
#pragma alloc_text(PAGENDSM, ndisMQueueWorkItemFullDuplex)
#pragma alloc_text(PAGENDSM, ndisMQueueNewWorkItem)
#pragma alloc_text(PAGENDSM, ndisMQueueNewWorkItemFullDuplex)
#pragma alloc_text(PAGENDSM, ndisMProcessDeferredFullDuplex)
#pragma alloc_text(PAGENDSM, ndisMProcessDeferred)
#if _SEND_PRIORITY
#pragma alloc_text(PAGENDSM, ndisMProcessDeferredFullDuplexPrioritySends)
#pragma alloc_text(PAGENDSM, ndisMProcessDeferredPrioritySends)
#endif
#pragma alloc_text(PAGENDSM, ndisMProcessResetRequested)
#pragma alloc_text(PAGENDSM, NdisMIndicateStatus)
#pragma alloc_text(PAGENDSM, NdisMIndicateStatusComplete)
#pragma alloc_text(PAGENDSM, NdisMWanIndicateReceive)
#pragma alloc_text(PAGENDSM, NdisMWanIndicateReceiveComplete)
#pragma alloc_text(PAGENDSM, NdisQueryReceiveInformation)
#pragma alloc_text(PAGENDSM, NdisReturnPackets)
#pragma alloc_text(PAGENDSM, ndisMIndicatePacket)
#pragma alloc_text(PAGENDSM, ndisMLazyReturnPackets)
#pragma alloc_text(PAGENDSM, NdisMTransferDataComplete)
#pragma alloc_text(PAGENDSM, ndisMTransferDataSync)
#pragma alloc_text(PAGENDSM, ndisMTransferData)
#pragma alloc_text(PAGENDSM, ndisMDummyTransferData)
#pragma alloc_text(PAGENDSM, ndisMAbortPacketsAndRequests)
#pragma alloc_text(PAGENDSM, ndisMResetCompleteCommonStep2)
#pragma alloc_text(PAGENDSM, ndisMResetCompleteCommonStep1)
#pragma alloc_text(PAGENDSM, ndisMProcessResetRequested)
#pragma alloc_text(PAGENDSM, ndisMResetCompleteFullDuplex)
#pragma alloc_text(PAGENDSM, NdisMResetComplete)
#pragma alloc_text(PAGENDSM, ndisMResetFullDuplex)
#pragma alloc_text(PAGENDSM, ndisMReset)
#pragma alloc_text(PAGENDSM, ndisMResetSend)
#pragma alloc_text(PAGENDSM, ndisMResetSendPackets)
#pragma alloc_text(PAGENDSM, ndisMFinishClose)
#pragma alloc_text(PAGENDSM, ndisMKillOpen)
#pragma alloc_text(PAGENDSM, ndisDeQueueOpenOnMiniport)
#pragma alloc_text(PAGENDSM, ndisDequeueMiniportOnDriver)
#pragma alloc_text(PAGENDSM, ndisQueueMiniportOnDriver)
#pragma alloc_text(PAGENDSM, ndisDereferenceMiniport)
#pragma alloc_text(PAGENDSM, ndisDereferenceDriver)
#pragma alloc_text(PAGENDSM, ndisMHaltMiniport)
#pragma alloc_text(PAGENDSM, ndisMUnload)
#pragma alloc_text(PAGENDSM, ndisMShutdown)
#pragma alloc_text(PAGENDSM, ndisMRequest)
#pragma alloc_text(PAGENDSI, ndisMUndoBogusFilters)
#pragma alloc_text(PAGENDSI, ndisMDoMiniportOp)
#pragma alloc_text(PAGENDSM, ndisMRequestQueryInformationPost)
#pragma alloc_text(PAGENDSM, ndisMSyncQueryInformationComplete)
#pragma alloc_text(PAGENDSM, NdisMQueryInformationComplete)
#pragma alloc_text(PAGENDSM, ndisMRequestSetInformationPost)
#pragma alloc_text(PAGENDSM, ndisMSyncSetInformationComplete)
#pragma alloc_text(PAGENDSM, NdisMSetInformationComplete)
#pragma alloc_text(PAGENDSM, ndisMAbortQueryStatisticsRequest)
#pragma alloc_text(PAGENDSM, ndisMSetPacketFilter)
#pragma alloc_text(PAGENDSM, ndisMSetCurrentLookahead)
#pragma alloc_text(PAGENDSM, ndisMSetMulticastList)
#pragma alloc_text(PAGENDSM, ndisMSetFunctionalAddress)
#pragma alloc_text(PAGENDSM, ndisMSetGroupAddress)
#pragma alloc_text(PAGENDSM, ndisMSetFddiMulticastList)
#pragma alloc_text(PAGENDSM, ndisMSetInformation)
#pragma alloc_text(PAGENDSM, ndisMQueryCurrentPacketFilter)
#pragma alloc_text(PAGENDSM, ndisMQueryMediaSupported)
#pragma alloc_text(PAGENDSM, ndisMQueryEthernetMulticastList)
#pragma alloc_text(PAGENDSM, ndisMQueryLongMulticastList)
#pragma alloc_text(PAGENDSM, ndisMQueryShortMulticastList)
#pragma alloc_text(PAGENDSM, ndisMQueryMaximumFrameSize)
#pragma alloc_text(PAGENDSM, ndisMQueryMaximumTotalSize)
#pragma alloc_text(PAGENDSM, ndisMQueryNetworkAddress)
#pragma alloc_text(PAGENDSM, ndisMQueryInformation)
#pragma alloc_text(PAGENDSM, ndisMDoRequests)
#pragma alloc_text(PAGENDSM, ndisMAllocateRequest)
#pragma alloc_text(PAGENDSM, ndisMQueueRequest)
#pragma alloc_text(PAGENDSM, ndisMRestoreFilterSettings)
#pragma alloc_text(PAGENDSM, ndisMFilterOutStatisticsOids)
#pragma alloc_text(PAGENDSM, ndisMQueryOidList)
#pragma alloc_text(PAGENDSM, ndisMChangeFddiAddresses)
#pragma alloc_text(PAGENDSM, ndisMChangeFunctionalAddress)
#pragma alloc_text(PAGENDSM, ndisMChangeGroupAddress)
#pragma alloc_text(PAGENDSM, ndisMCloseAction)
#pragma alloc_text(PAGENDSM, ndisMChangeClass)
#pragma alloc_text(PAGENDSM, ndisMChangeEthAddresses)
#pragma alloc_text(PAGENDSM, ndisMCopyFromPacketToBuffer)
#pragma alloc_text(PAGENDSM, ndisMIndicateLoopback)
#pragma alloc_text(PAGENDSM, ndisMIsLoopbackPacket)
#pragma alloc_text(PAGENDSM, ndisMStartSendPacketsFullDuplex)
#pragma alloc_text(PAGENDSM, ndisMStartSendsFullDuplex)
#pragma alloc_text(PAGENDSM, ndisMStartSendPackets)
#pragma alloc_text(PAGENDSM, ndisMStartSends)
#pragma alloc_text(PAGENDSM, ndisMSyncSend)
#pragma alloc_text(PAGENDSM, ndisMWanSend)
#pragma alloc_text(PAGENDSM, NdisMSendComplete)
#pragma alloc_text(PAGENDSM, ndisMSendCompleteFullDuplex)
#pragma alloc_text(PAGENDSM, NdisMWanSendComplete)
#pragma alloc_text(PAGENDSM, ndisMSendResourcesAvailableFullDuplex)
#pragma alloc_text(PAGENDSM, NdisMSendResourcesAvailable)
#pragma alloc_text(PAGENDSM, ndisMSendFullDuplex)
#pragma alloc_text(PAGENDSM, ndisMSend)
#pragma alloc_text(PAGENDSM, NdisMStartBufferPhysicalMapping)
#pragma alloc_text(PAGENDSM, NdisMCompleteBufferPhysicalMapping)

#pragma alloc_text(PAGENDSP, ndisMOpenAdapter)
#pragma alloc_text(PAGENDSP, ndisMSendFullDuplexToSendPackets)
#pragma alloc_text(PAGENDSP, ndisMSendPacketsFullDuplex)
#pragma alloc_text(PAGENDSP, ndisMSendToSendPackets)
#pragma alloc_text(PAGENDSP, ndisMSendPackets)
#pragma alloc_text(PAGENDSP, ndisMSendPacketsFullDuplexToSend)
#pragma alloc_text(PAGENDSP, ndisMSendPacketsToSend)
#pragma alloc_text(PAGENDSP, NdisRegisterProtocol)
#pragma alloc_text(PAGENDSP, NdisDeregisterProtocol)
#pragma alloc_text(PAGENDSP, NdisOpenAdapter)
#pragma alloc_text(PAGENDSP, NdisCloseAdapter)
#pragma alloc_text(PAGENDSP, NdisSetProtocolFilter)
#pragma alloc_text(PAGENDSP, NdisGetDriverHandle)
#pragma alloc_text(PAGENDSP, ndisDereferenceProtocol)
#pragma alloc_text(PAGENDSP, NdisOpenProtocolConfiguration)
#pragma alloc_text(PAGENDSP, ndisQueueOpenOnProtocol)
#pragma alloc_text(PAGENDSP, ndisDeQueueOpenOnProtocol)
#pragma alloc_text(PAGENDSP, NdisWriteEventLogEntry)

#pragma alloc_text(PAGENDSW, NdisDeregisterMac)
#pragma alloc_text(PAGENDSW, ndisDpc)
#pragma alloc_text(PAGENDSW, ndisIsr)
#pragma alloc_text(PAGENDSW, ndisDereferenceMac)
#pragma alloc_text(PAGENDSW, ndisDereferenceAdapter)
#pragma alloc_text(PAGENDSW, ndisKillAdapter)
#pragma alloc_text(PAGENDSW, ndisQueueOpenOnAdapter)
#pragma alloc_text(PAGENDSW, ndisDeQueueOpenOnAdapter)
#pragma alloc_text(PAGENDSW, ndisDeQueueAdapterOnMac)
#pragma alloc_text(PAGENDSW, ndisQueueAdapterOnMac)
#pragma alloc_text(PAGENDSW, ndisKillOpen)
#pragma alloc_text(PAGENDSW, ndisKillOpenAndNotifyProtocol)
#pragma alloc_text(PAGENDSW, ndisCloseIrpHandler)
#pragma alloc_text(PAGENDSW, NdisCompleteQueryStatistics)
#pragma alloc_text(PAGENDSW, ndisQueryOidList)
#pragma alloc_text(PAGENDSW, NdisFinishOpen)
#pragma alloc_text(PAGENDSW, NdisCompleteOpenAdapter)
#pragma alloc_text(PAGENDSW, ndisQueuedCompleteOpenAdapter)
#pragma alloc_text(PAGENDSW, NdisCompleteCloseAdapter)
#pragma alloc_text(PAGENDSW, ndisQueuedCompleteCloseAdapter)
#pragma alloc_text(PAGENDSW, ndisMacReceiveCompleteHandler)
#pragma alloc_text(PAGENDSW, ndisMacReceiveHandler)
#pragma alloc_text(PAGENDSW, ndisGetOpenBlockFromProtocolBindingContext)
#pragma alloc_text(PAGENDSW, ndisShutdown)
#pragma alloc_text(PAGENDSW, ndisUnload)

#pragma alloc_text(PAGENDSE, ethRemoveBindingFromLists)
#pragma alloc_text(PAGENDSE, ethRemoveAndFreeBinding)
#pragma alloc_text(PAGENDSE, EthCreateFilter)
#pragma alloc_text(PAGENDSE, EthDeleteFilter)
#pragma alloc_text(PAGENDSE, EthNoteFilterOpenAdapter)
#pragma alloc_text(PAGENDSE, EthDeleteFilterOpenAdapter)
#pragma alloc_text(PAGENDSE, ethUndoChangeFilterAddresses)
#pragma alloc_text(PAGENDSE, EthChangeFilterAddresses)
#pragma alloc_text(PAGENDSE, ethUpdateDirectedBindingList)
#pragma alloc_text(PAGENDSE, ethUpdateBroadcastBindingList)
#pragma alloc_text(PAGENDSE, ethUpdateSpecificBindingLists)
#pragma alloc_text(PAGENDSE, ethUndoFilterAdjust)
#pragma alloc_text(PAGENDSE, EthFilterAdjust)
#pragma alloc_text(PAGENDSE, EthNumberOfOpenFilterAddresses)
#pragma alloc_text(PAGENDSE, EthQueryOpenFilterAddresses)
#pragma alloc_text(PAGENDSE, EthQueryGlobalFilterAddresses)
#pragma alloc_text(PAGENDSE, EthFilterIndicateReceiveComplete)
#pragma alloc_text(PAGENDSE, EthFilterDprIndicateReceiveComplete)
#pragma alloc_text(PAGENDSE, EthFilterDprIndicateReceiveCompleteFullMac)
#pragma alloc_text(PAGENDSE, EthFilterIndicateReceive)
#pragma alloc_text(PAGENDSE, EthFilterDprIndicateReceive)
#pragma alloc_text(PAGENDSE, EthFilterDprIndicateReceiveFullMac)
#pragma alloc_text(PAGENDSE, EthFilterDprIndicateReceivePacket)
#pragma alloc_text(PAGENDSE, EthFindMulticast)
#pragma alloc_text(PAGENDSE, EthShouldAddressLoopBack)

#pragma alloc_text(PAGENDST, trRemoveBindingFromLists)
#pragma alloc_text(PAGENDST, trRemoveAndFreeBinding)
#pragma alloc_text(PAGENDST, TrCreateFilter)
#pragma alloc_text(PAGENDST, TrDeleteFilter)
#pragma alloc_text(PAGENDST, TrNoteFilterOpenAdapter)
#pragma alloc_text(PAGENDST, TrDeleteFilterOpenAdapter)
#pragma alloc_text(PAGENDST, trUndoChangeFunctionalAddress)
#pragma alloc_text(PAGENDST, TrChangeFunctionalAddress)
#pragma alloc_text(PAGENDST, trUndoChangeGroupAddress)
#pragma alloc_text(PAGENDST, trCompleteChangeGroupAddress)
#pragma alloc_text(PAGENDST, TrChangeGroupAddress)
#pragma alloc_text(PAGENDST, trUpdateDirectedBindingList)
#pragma alloc_text(PAGENDST, trUpdateBroadcastBindingList)
#pragma alloc_text(PAGENDST, trUpdateSpecificBindingLists)
#pragma alloc_text(PAGENDST, trUndoFilterAdjust)
#pragma alloc_text(PAGENDST, TrFilterAdjust)
#pragma alloc_text(PAGENDST, TrFilterIndicateReceive)
#pragma alloc_text(PAGENDST, TrFilterDprIndicateReceive)
#pragma alloc_text(PAGENDST, TrFilterDprIndicateReceiveFullMac)
#pragma alloc_text(PAGENDST, TrFilterDprIndicateReceivePacket)
#pragma alloc_text(PAGENDST, TrFilterIndicateReceiveComplete)
#pragma alloc_text(PAGENDST, TrFilterDprIndicateReceiveComplete)
#pragma alloc_text(PAGENDST, TrFilterDprIndicateReceiveCompleteFullMac)
#pragma alloc_text(PAGENDST, TrShouldAddressLoopBack)

#pragma alloc_text(PAGENDSF, fddiRemoveBindingFromLists)
#pragma alloc_text(PAGENDSF, fddiRemoveAndFreeBinding)
#pragma alloc_text(PAGENDSF, FddiCreateFilter)
#pragma alloc_text(PAGENDSF, FddiDeleteFilter)
#pragma alloc_text(PAGENDSF, FddiNoteFilterOpenAdapter)
#pragma alloc_text(PAGENDSF, FddiDeleteFilterOpenAdapter)
#pragma alloc_text(PAGENDSF, fddiUndoChangeFilterLongAddresses)
#pragma alloc_text(PAGENDSF, FddiChangeFilterLongAddresses)
#pragma alloc_text(PAGENDSF, fddiUndoChangeFilterShortAddresses)
#pragma alloc_text(PAGENDSF, FddiChangeFilterShortAddresses)
#pragma alloc_text(PAGENDSF, fddiUpdateDirectedBindingList)
#pragma alloc_text(PAGENDSF, fddiUpdateBroadcastBindingList)
#pragma alloc_text(PAGENDSF, fddiUpdateSpecificBindingLists)
#pragma alloc_text(PAGENDSF, fddiUndoFilterAdjust)
#pragma alloc_text(PAGENDSF, FddiFilterAdjust)
#pragma alloc_text(PAGENDSF, FddiNumberOfOpenFilterLongAddresses)
#pragma alloc_text(PAGENDSF, FddiNumberOfOpenFilterShortAddresses)
#pragma alloc_text(PAGENDSF, FddiQueryOpenFilterLongAddresses)
#pragma alloc_text(PAGENDSF, FddiQueryOpenFilterShortAddresses)
#pragma alloc_text(PAGENDSF, FddiQueryGlobalFilterLongAddresses)
#pragma alloc_text(PAGENDSF, FddiQueryGlobalFilterShortAddresses)
#pragma alloc_text(PAGENDSF, FddiFilterIndicateReceive)
#pragma alloc_text(PAGENDSF, FddiFilterDprIndicateReceive)
#pragma alloc_text(PAGENDSF, FddiFilterDprIndicateReceiveFullMac)
#pragma alloc_text(PAGENDSF, FddiFilterDprIndicateReceivePacket)
#pragma alloc_text(PAGENDSF, FddiFilterIndicateReceiveComplete)
#pragma alloc_text(PAGENDSF, FddiFilterDprIndicateReceiveComplete)
#pragma alloc_text(PAGENDSF, FddiFilterDprIndicateReceiveCompleteFullMac)
#pragma alloc_text(PAGENDSF, FddiFindMulticastLongAddress)
#pragma alloc_text(PAGENDSF, FddiFindMulticastShortAddress)
#pragma alloc_text(PAGENDSF, FddiShouldAddressLoopBack)

#pragma alloc_text(PAGENDSA, ArcAllocateBuffers)
#pragma alloc_text(PAGENDSA, ArcAllocatePackets)
#pragma alloc_text(PAGENDSA, ArcDiscardPacketBuffers)
#pragma alloc_text(PAGENDSA, ArcFreeNdisPacket)
#pragma alloc_text(PAGENDSA, ArcDestroyPacket)
#pragma alloc_text(PAGENDSA, ArcConvertToNdisPacket)
#pragma alloc_text(PAGENDSA, ArcFilterDprIndicateReceive)
#pragma alloc_text(PAGENDSA, ArcCreateFilter)
#pragma alloc_text(PAGENDSA, ArcDeleteFilter)
#pragma alloc_text(PAGENDSA, ArcNoteFilterOpenAdapter)
#pragma alloc_text(PAGENDSA, ArcDeleteFilterOpenAdapter)
#pragma alloc_text(PAGENDSA, ArcFilterAdjust)
#pragma alloc_text(PAGENDSA, ArcFilterDoIndication)
#pragma alloc_text(PAGENDSA, ArcFilterDprIndicateReceiveComplete)
#pragma alloc_text(PAGENDSA, ArcConvertOidListToEthernet)
#pragma alloc_text(PAGENDSA, ndisMArcCopyFromBufferToPacket)
#pragma alloc_text(PAGENDSA, ndisMArcnetSend)
#pragma alloc_text(PAGENDSA, ndisMArcTransferData)
#pragma alloc_text(PAGENDSA, ndisMArcIndicateEthEncapsulatedReceive)
#pragma alloc_text(PAGENDSA, ndisMBuildArcnetHeader)
#pragma alloc_text(PAGENDSA, ndisMFreeArcnetHeader)
#pragma alloc_text(PAGENDSA, ndisMArcnetSendLoopback)

#pragma alloc_text(PAGENDCO, NdisCmRegisterAddressFamily)
#pragma alloc_text(PAGENDCO, NdisClOpenAddressFamily)
#pragma alloc_text(PAGENDCO, NdisCmOpenAddressFamilyComplete)
#pragma alloc_text(PAGENDCO, NdisClCloseAddressFamily)
#pragma alloc_text(PAGENDCO, NdisCmCloseAddressFamilyComplete)
#pragma alloc_text(PAGENDCO, NdisClRegisterSap)
#pragma alloc_text(PAGENDCO, NdisCmRegisterSapComplete)
#pragma alloc_text(PAGENDCO, NdisClDeregisterSap)
#pragma alloc_text(PAGENDCO, NdisCmDeregisterSapComplete)
#pragma alloc_text(PAGENDCO, NdisClMakeCall)
#pragma alloc_text(PAGENDCO, NdisCmMakeCallComplete)
#pragma alloc_text(PAGENDCO, NdisCmDispatchIncomingCall)
#pragma alloc_text(PAGENDCO, NdisClIncomingCallComplete)
#pragma alloc_text(PAGENDCO, NdisCmDispatchCallConnected)
#pragma alloc_text(PAGENDCO, NdisClModifyCallQoS)
#pragma alloc_text(PAGENDCO, NdisCmModifyCallQoSComplete)
#pragma alloc_text(PAGENDCO, NdisCmDispatchIncomingCallQoSChange)
#pragma alloc_text(PAGENDCO, NdisClCloseCall)
#pragma alloc_text(PAGENDCO, NdisCmCloseCallComplete)
#pragma alloc_text(PAGENDCO, NdisCmDispatchIncomingCloseCall)
#pragma alloc_text(PAGENDCO, NdisClAddParty)
#pragma alloc_text(PAGENDCO, NdisCmAddPartyComplete)
#pragma alloc_text(PAGENDCO, NdisClDropParty)
#pragma alloc_text(PAGENDCO, NdisCmDropPartyComplete)
#pragma alloc_text(PAGENDCO, NdisCmDispatchIncomingDropParty)
#pragma alloc_text(PAGENDCO, NdisCoCreateVc)
#pragma alloc_text(PAGENDCO, NdisCoDeleteVc)
#pragma alloc_text(PAGENDCO, NdisCmActivateVc)
#pragma alloc_text(PAGENDCO, NdisMCoActivateVcComplete)
#pragma alloc_text(PAGENDCO, NdisCmDeactivateVc)
#pragma alloc_text(PAGENDCO, NdisMCoDeactivateVcComplete)
#pragma alloc_text(PAGENDCO, NdisCoRequest)
#pragma alloc_text(PAGENDCO, NdisCoRequestComplete)
#pragma alloc_text(PAGENDCO, NdisMCoIndicateReceivePacket)
#pragma alloc_text(PAGENDCO, NdisMCoReceiveComplete)
#pragma alloc_text(PAGENDCO, NdisCoSendPackets)
#pragma alloc_text(PAGENDCO, NdisMCoSendComplete)
#pragma alloc_text(PAGENDCO, NdisMCoIndicateStatus)
#pragma alloc_text(PAGENDCO, NdisMCmRegisterAddressFamily)
#pragma alloc_text(PAGENDCO, NdisMCmCreateVc)
// #pragma alloc_text(PAGENDCO, NdisMCmDeleteVc)
#pragma alloc_text(PAGENDCO, NdisMCmActivateVc)
#pragma alloc_text(PAGENDCO, NdisMCmDeactivateVc)
#pragma alloc_text(PAGENDCO, ndisMNotifyAfRegistration)
#pragma alloc_text(PAGENDCO, ndisReferenceAf)
#pragma alloc_text(PAGENDCO, ndisDereferenceAf)
#pragma alloc_text(PAGENDCO, ndisReferenceSap)
#pragma alloc_text(PAGENDCO, ndisDereferenceSap)
#pragma alloc_text(PAGENDSM, ndisMCoFreeResources)
#pragma alloc_text(PAGENDCO, ndisReferenceVc)
#pragma alloc_text(PAGENDCO, ndisDereferenceVc)
#pragma alloc_text(PAGENDCO, ndisMRejectSend)
#pragma alloc_text(PAGENDCO, ndisMRejectSendPackets)
#pragma alloc_text(PAGENDCO, ndisMCoDpc)
#pragma alloc_text(PAGENDCO, ndisMCoDpcTimer)

#else	// NDIS_WIN

#pragma NDIS_PAGEABLE_FUNCTION(NdisMInitializeTimer)
#pragma NDIS_LOCKED_FUNCTION(NdisMCancelTimer)
#pragma NDIS_PAGEABLE_FUNCTION(NdisMDeregisterInterrupt)
#pragma NDIS_PAGEABLE_FUNCTION(NdisMRegisterInterrupt)
#pragma NDIS_LOCKED_FUNCTION(NdisMSynchronizeWithInterrupt)
#pragma NDIS_LOCKED_FUNCTION(ndisMIsr)
#pragma NDIS_LOCKED_FUNCTION(ndisMDpc)
#pragma NDIS_LOCKED_FUNCTION(ndisMWakeUpDpc)
#pragma NDIS_LOCKED_FUNCTION(ndisMDpcTimer)
#pragma NDIS_LOCKED_FUNCTION(ndisMTimerDpc)
#pragma NDIS_LOCKED_FUNCTION(ndisMDeferredTimerDpc)
#pragma NDIS_LOCKED_FUNCTION(ndisMDeQueueWorkItem)
#pragma NDIS_LOCKED_FUNCTION(ndisMDeQueueWorkItemFullDuplex)
#pragma NDIS_LOCKED_FUNCTION(ndisMQueueWorkItem)
#pragma NDIS_LOCKED_FUNCTION(ndisMQueueWorkItemFullDuplex)
#pragma NDIS_LOCKED_FUNCTION(ndisMQueueNewWorkItem)
#pragma NDIS_LOCKED_FUNCTION(ndisMQueueNewWorkItemFullDuplex)
#pragma NDIS_LOCKED_FUNCTION(ndisMProcessDeferredFullDuplex)
#pragma NDIS_LOCKED_FUNCTION(ndisMProcessDeferred)
#if _SEND_PRIORITY
#pragma NDIS_LOCKED_FUNCTION(PAGENDSM, ndisMProcessDeferredFullDuplexPrioritySends)
#pragma NDIS_LOCKED_FUNCTION(PAGENDSM, ndisMProcessDeferredPrioritySends)
#endif
#pragma NDIS_PAGEABLE_FUNCTION(ndisMProcessResetRequested)
#pragma NDIS_LOCKED_FUNCTION(NdisMIndicateStatus)
#pragma NDIS_LOCKED_FUNCTION(NdisMIndicateStatusComplete)
#pragma NDIS_LOCKED_FUNCTION(NdisMWanIndicateReceive)
#pragma NDIS_LOCKED_FUNCTION(NdisMWanIndicateReceiveComplete)
#pragma NDIS_LOCKED_FUNCTION(NdisQueryReceiveInformation)
#pragma NDIS_LOCKED_FUNCTION(NdisReturnPackets)
#pragma NDIS_LOCKED_FUNCTION(ndisMIndicatePacket)
#pragma NDIS_LOCKED_FUNCTION(ndisMLazyReturnPackets)
#pragma NDIS_LOCKED_FUNCTION(NdisMTransferDataComplete)
#pragma NDIS_LOCKED_FUNCTION(ndisMTransferDataSync)
#pragma NDIS_LOCKED_FUNCTION(ndisMTransferData)
#pragma NDIS_LOCKED_FUNCTION(ndisMDummyTransferData)
#pragma NDIS_LOCKED_FUNCTION(ndisMAbortPacketsAndRequests)
#pragma NDIS_PAGEABLE_FUNCTION(ndisMResetCompleteCommonStep2)
#pragma NDIS_PAGEABLE_FUNCTION(ndisMResetCompleteCommonStep1)
#pragma NDIS_PAGEABLE_FUNCTION(ndisMProcessResetRequested)
#pragma NDIS_PAGEABLE_FUNCTION(ndisMResetCompleteFullDuplex)
#pragma NDIS_PAGEABLE_FUNCTION(NdisMResetComplete)
#pragma NDIS_PAGEABLE_FUNCTION(ndisMResetFullDuplex)
#pragma NDIS_PAGEABLE_FUNCTION(ndisMReset)
#pragma NDIS_LOCKED_FUNCTION(ndisMResetSend)
#pragma NDIS_LOCKED_FUNCTION(ndisMResetSendPackets)
#pragma NDIS_LOCKED_FUNCTION(NdisIMSwitchToMiniport)
#pragma NDIS_LOCKED_FUNCTION(NdisIMRevertBack)
#pragma NDIS_LOCKED_FUNCTION(NdisIMQueueMiniportCallback)
#pragma NDIS_LOCKED_FUNCTION(ndisIMQueueWorkItem)
#pragma NDIS_LOCKED_FUNCTION(ndisIMQueueWorkItemFullDuplex)
#pragma NDIS_LOCKED_FUNCTION(ndisIMQueueNewWorkItem)
#pragma NDIS_LOCKED_FUNCTION(ndisIMQueueNewWorkItemFullDuplex)
#pragma NDIS_PAGEABLE_FUNCTION(ndisMRequest)
#pragma NDIS_PAGEABLE_FUNCTION(ndisMUndoBogusFilters)
#pragma NDIS_PAGEABLE_FUNCTION(ndisMDoMiniportOp)
#pragma NDIS_PAGEABLE_FUNCTION(ndisMRequestQueryInformationPost)
#pragma NDIS_PAGEABLE_FUNCTION(ndisMSyncQueryInformationComplete)
#pragma NDIS_PAGEABLE_FUNCTION(NdisMQueryInformationComplete)
#pragma NDIS_PAGEABLE_FUNCTION(ndisMRequestSetInformationPost)
#pragma NDIS_PAGEABLE_FUNCTION(ndisMSyncSetInformationComplete)
#pragma NDIS_PAGEABLE_FUNCTION(NdisMSetInformationComplete)
#pragma NDIS_PAGEABLE_FUNCTION(ndisMAbortQueryStatisticsRequest)
#pragma NDIS_PAGEABLE_FUNCTION(ndisMSetPacketFilter)
#pragma NDIS_PAGEABLE_FUNCTION(ndisMSetCurrentLookahead)
#pragma NDIS_PAGEABLE_FUNCTION(ndisMSetMulticastList)
#pragma NDIS_PAGEABLE_FUNCTION(ndisMSetFunctionalAddress)
#pragma NDIS_PAGEABLE_FUNCTION(ndisMSetGroupAddress)
#pragma NDIS_PAGEABLE_FUNCTION(ndisMSetFddiMulticastList)
#pragma NDIS_PAGEABLE_FUNCTION(ndisMSetInformation)
#pragma NDIS_PAGEABLE_FUNCTION(ndisMQueryCurrentPacketFilter)
#pragma NDIS_PAGEABLE_FUNCTION(ndisMQueryMediaSupported)
#pragma NDIS_PAGEABLE_FUNCTION(ndisMQueryEthernetMulticastList)
#pragma NDIS_PAGEABLE_FUNCTION(ndisMQueryLongMulticastList)
#pragma NDIS_PAGEABLE_FUNCTION(ndisMQueryShortMulticastList)
#pragma NDIS_PAGEABLE_FUNCTION(ndisMQueryMaximumFrameSize)
#pragma NDIS_PAGEABLE_FUNCTION(ndisMQueryMaximumTotalSize)
#pragma NDIS_PAGEABLE_FUNCTION(ndisMQueryNetworkAddress)
#pragma NDIS_PAGEABLE_FUNCTION(ndisMQueryInformation)
#pragma NDIS_PAGEABLE_FUNCTION(ndisMDoRequests)
#pragma NDIS_PAGEABLE_FUNCTION(ndisMAllocateRequest)
#pragma NDIS_PAGEABLE_FUNCTION(ndisMQueueRequest)
#pragma NDIS_PAGEABLE_FUNCTION(ndisMRestoreFilterSettings)
#pragma NDIS_PAGEABLE_FUNCTION(ndisMFilterOutStatisticsOids)
#pragma NDIS_PAGEABLE_FUNCTION(ndisMQueryOidList)
#pragma NDIS_PAGEABLE_FUNCTION(ndisMChangeFddiAddresses)
#pragma NDIS_PAGEABLE_FUNCTION(ndisMChangeFunctionalAddress)
#pragma NDIS_PAGEABLE_FUNCTION(ndisMChangeGroupAddress)
#pragma NDIS_PAGEABLE_FUNCTION(ndisMCloseAction)
#pragma NDIS_PAGEABLE_FUNCTION(ndisMChangeClass)
#pragma NDIS_PAGEABLE_FUNCTION(ndisMChangeEthAddresses)
#pragma NDIS_LOCKED_FUNCTION(ndisMCopyFromPacketToBuffer)
#pragma NDIS_LOCKED_FUNCTION(ndisMIndicateLoopback)
#pragma NDIS_LOCKED_FUNCTION(ndisMIsLoopbackPacket)
#pragma NDIS_LOCKED_FUNCTION(ndisMStartSendPacketsFullDuplex)
#pragma NDIS_LOCKED_FUNCTION(ndisMStartSendsFullDuplex)
#pragma NDIS_LOCKED_FUNCTION(ndisMStartSendPackets)
#pragma NDIS_LOCKED_FUNCTION(ndisMStartSends)
#pragma NDIS_LOCKED_FUNCTION(ndisMSyncSend)
#pragma NDIS_LOCKED_FUNCTION(ndisMWanSend)
#pragma NDIS_LOCKED_FUNCTION(NdisMSendComplete)
#pragma NDIS_LOCKED_FUNCTION(ndisMSendCompleteFullDuplex)
#pragma NDIS_LOCKED_FUNCTION(NdisMWanSendComplete)
#pragma NDIS_LOCKED_FUNCTION(ndisMSendResourcesAvailableFullDuplex)
#pragma NDIS_LOCKED_FUNCTION(NdisMSendResourcesAvailable)
#pragma NDIS_LOCKED_FUNCTION(ndisMSendFullDuplexToSendPackets)
#pragma NDIS_LOCKED_FUNCTION(ndisMSendPacketsFullDuplex)
#pragma NDIS_LOCKED_FUNCTION(ndisMSendToSendPackets)
#pragma NDIS_LOCKED_FUNCTION(ndisMSendPackets)
#pragma NDIS_LOCKED_FUNCTION(ndisMSendPacketsFullDuplexToSend)
#pragma NDIS_LOCKED_FUNCTION(ndisMSendFullDuplex)
#pragma NDIS_LOCKED_FUNCTION(ndisMSendPacketsToSend)
#pragma NDIS_LOCKED_FUNCTION(ndisMSend)

#pragma NDIS_PAGEABLE_FUNCTION(ethRemoveBindingFromLists)
#pragma NDIS_PAGEABLE_FUNCTION(ethRemoveAndFreeBinding)
#pragma NDIS_PAGEABLE_FUNCTION(EthCreateFilter)
#pragma NDIS_PAGEABLE_FUNCTION(EthDeleteFilter)
#pragma NDIS_PAGEABLE_FUNCTION(EthNoteFilterOpenAdapter)
#pragma NDIS_PAGEABLE_FUNCTION(EthDeleteFilterOpenAdapter)
#pragma NDIS_PAGEABLE_FUNCTION(ethUndoChangeFilterAddresses)
#pragma NDIS_PAGEABLE_FUNCTION(EthChangeFilterAddresses)
#pragma NDIS_PAGEABLE_FUNCTION(ethUpdateDirectedBindingList)
#pragma NDIS_PAGEABLE_FUNCTION(ethUpdateBroadcastBindingList)
#pragma NDIS_PAGEABLE_FUNCTION(ethUpdateSpecificBindingLists)
#pragma NDIS_PAGEABLE_FUNCTION(ethUndoFilterAdjust)
#pragma NDIS_PAGEABLE_FUNCTION(EthFilterAdjust)
#pragma NDIS_PAGEABLE_FUNCTION(EthNumberOfOpenFilterAddresses)
#pragma NDIS_PAGEABLE_FUNCTION(EthQueryOpenFilterAddresses)
#pragma NDIS_PAGEABLE_FUNCTION(EthQueryGlobalFilterAddresses)
#pragma NDIS_LOCKED_FUNCTION(EthFilterIndicateReceiveComplete)
#pragma NDIS_LOCKED_FUNCTION(EthFilterDprIndicateReceiveComplete)
#pragma NDIS_LOCKED_FUNCTION(EthFilterDprIndicateReceiveCompleteFullMac)
#pragma NDIS_LOCKED_FUNCTION(EthFilterIndicateReceive)
#pragma NDIS_LOCKED_FUNCTION(EthFilterDprIndicateReceive)
#pragma NDIS_LOCKED_FUNCTION(EthFilterDprIndicateReceiveFullMac)
#pragma NDIS_LOCKED_FUNCTION(EthFilterDprIndicateReceivePacket)
#pragma NDIS_LOCKED_FUNCTION(EthFindMulticast)
#pragma NDIS_LOCKED_FUNCTION(EthShouldAddressLoopBack)

#pragma NDIS_PAGEABLE_FUNCTION(trRemoveBindingFromLists)
#pragma NDIS_PAGEABLE_FUNCTION(trRemoveAndFreeBinding)
#pragma NDIS_PAGEABLE_FUNCTION(TrCreateFilter)
#pragma NDIS_PAGEABLE_FUNCTION(TrDeleteFilter)
#pragma NDIS_PAGEABLE_FUNCTION(TrNoteFilterOpenAdapter)
#pragma NDIS_PAGEABLE_FUNCTION(TrDeleteFilterOpenAdapter)
#pragma NDIS_PAGEABLE_FUNCTION(trUndoChangeFunctionalAddress)
#pragma NDIS_PAGEABLE_FUNCTION(TrChangeFunctionalAddress)
#pragma NDIS_PAGEABLE_FUNCTION(trUndoChangeGroupAddress)
#pragma NDIS_PAGEABLE_FUNCTION(trCompleteChangeGroupAddress)
#pragma NDIS_PAGEABLE_FUNCTION(TrChangeGroupAddress)
#pragma NDIS_PAGEABLE_FUNCTION(trUpdateDirectedBindingList)
#pragma NDIS_PAGEABLE_FUNCTION(trUpdateBroadcastBindingList)
#pragma NDIS_PAGEABLE_FUNCTION(trUpdateSpecificBindingLists)
#pragma NDIS_PAGEABLE_FUNCTION(trUndoFilterAdjust)
#pragma NDIS_PAGEABLE_FUNCTION(TrFilterAdjust)
#pragma NDIS_LOCKED_FUNCTION(TrFilterIndicateReceive)
#pragma NDIS_LOCKED_FUNCTION(TrFilterDprIndicateReceive)
#pragma NDIS_LOCKED_FUNCTION(TrFilterDprIndicateReceiveFullMac)
#pragma NDIS_LOCKED_FUNCTION(TrFilterDprIndicateReceivePacket)
#pragma NDIS_LOCKED_FUNCTION(TrFilterIndicateReceiveComplete)
#pragma NDIS_LOCKED_FUNCTION(TrFilterDprIndicateReceiveComplete)
#pragma NDIS_LOCKED_FUNCTION(TrFilterDprIndicateReceiveCompleteFullMac)
#pragma NDIS_LOCKED_FUNCTION(TrShouldAddressLoopBack)

#pragma NDIS_PAGEABLE_FUNCTION(fddiRemoveBindingFromLists)
#pragma NDIS_PAGEABLE_FUNCTION(fddiRemoveAndFreeBinding)
#pragma NDIS_PAGEABLE_FUNCTION(FddiCreateFilter)
#pragma NDIS_PAGEABLE_FUNCTION(FddiDeleteFilter)
#pragma NDIS_PAGEABLE_FUNCTION(FddiNoteFilterOpenAdapter)
#pragma NDIS_PAGEABLE_FUNCTION(FddiDeleteFilterOpenAdapter)
#pragma NDIS_PAGEABLE_FUNCTION(fddiUndoChangeFilterLongAddresses)
#pragma NDIS_PAGEABLE_FUNCTION(FddiChangeFilterLongAddresses)
#pragma NDIS_PAGEABLE_FUNCTION(fddiUndoChangeFilterShortAddresses)
#pragma NDIS_PAGEABLE_FUNCTION(FddiChangeFilterShortAddresses)
#pragma NDIS_PAGEABLE_FUNCTION(fddiUpdateDirectedBindingList)
#pragma NDIS_PAGEABLE_FUNCTION(fddiUpdateBroadcastBindingList)
#pragma NDIS_PAGEABLE_FUNCTION(fddiUpdateSpecificBindingLists)
#pragma NDIS_PAGEABLE_FUNCTION(fddiUndoFilterAdjust)
#pragma NDIS_PAGEABLE_FUNCTION(FddiFilterAdjust)
#pragma NDIS_PAGEABLE_FUNCTION(FddiNumberOfOpenFilterLongAddresses)
#pragma NDIS_PAGEABLE_FUNCTION(FddiNumberOfOpenFilterShortAddresses)
#pragma NDIS_PAGEABLE_FUNCTION(FddiQueryOpenFilterLongAddresses)
#pragma NDIS_PAGEABLE_FUNCTION(FddiQueryOpenFilterShortAddresses)
#pragma NDIS_PAGEABLE_FUNCTION(FddiQueryGlobalFilterLongAddresses)
#pragma NDIS_PAGEABLE_FUNCTION(FddiQueryGlobalFilterShortAddresses)
#pragma NDIS_LOCKED_FUNCTION(FddiFilterIndicateReceive)
#pragma NDIS_LOCKED_FUNCTION(FddiFilterDprIndicateReceive)
#pragma NDIS_LOCKED_FUNCTION(FddiFilterDprIndicateReceiveFullMac)
#pragma NDIS_LOCKED_FUNCTION(FddiFilterDprIndicateReceivePacket)
#pragma NDIS_LOCKED_FUNCTION(FddiFilterIndicateReceiveComplete)
#pragma NDIS_LOCKED_FUNCTION(FddiFilterDprIndicateReceiveComplete)
#pragma NDIS_LOCKED_FUNCTION(FddiFilterDprIndicateReceiveCompleteFullMac)
#pragma NDIS_LOCKED_FUNCTION(FddiFindMulticastLongAddress)
#pragma NDIS_LOCKED_FUNCTION(FddiFindMulticastShortAddress)
#pragma NDIS_LOCKED_FUNCTION(FddiShouldAddressLoopBack)

#pragma NDIS_LOCKED_FUNCTION(ArcAllocateBuffers)
#pragma NDIS_LOCKED_FUNCTION(ArcAllocatePackets)
#pragma NDIS_LOCKED_FUNCTION(ArcDiscardPacketBuffers)
#pragma NDIS_LOCKED_FUNCTION(ArcFreeNdisPacket)
#pragma NDIS_LOCKED_FUNCTION(ArcDestroyPacket)
#pragma NDIS_LOCKED_FUNCTION(ArcConvertToNdisPacket)
#pragma NDIS_LOCKED_FUNCTION(ArcFilterDprIndicateReceive)
#pragma NDIS_PAGEABLE_FUNCTION(ArcCreateFilter)
#pragma NDIS_PAGEABLE_FUNCTION(ArcDeleteFilter)
#pragma NDIS_PAGEABLE_FUNCTION(ArcNoteFilterOpenAdapter)
#pragma NDIS_PAGEABLE_FUNCTION(ArcDeleteFilterOpenAdapter)
#pragma NDIS_PAGEABLE_FUNCTION(ArcFilterAdjust)
#pragma NDIS_LOCKED_FUNCTION(ArcFilterDoIndication)
#pragma NDIS_LOCKED_FUNCTION(ArcFilterDprIndicateReceiveComplete)
#pragma NDIS_PAGEABLE_FUNCTION(ArcConvertOidListToEthernet)
#pragma NDIS_LOCKED_FUNCTION(ndisMArcCopyFromBufferToPacket)
#pragma NDIS_LOCKED_FUNCTION(ndisMArcnetSend)
#pragma NDIS_LOCKED_FUNCTION(ndisMArcTransferData)
#pragma NDIS_LOCKED_FUNCTION(ndisMArcIndicateEthEncapsulatedReceive)
#pragma NDIS_LOCKED_FUNCTION(ndisMBuildArcnetHeader)
#pragma NDIS_LOCKED_FUNCTION(ndisMFreeArcnetHeader)
#pragma NDIS_LOCKED_FUNCTION(ndisMArcnetSendLoopback)


#pragma NDIS_PAGEABLE_FUNCTION(NdisCmRegisterAddressFamily)
#pragma NDIS_PAGEABLE_FUNCTION(NdisClOpenAddressFamily)
#pragma NDIS_PAGEABLE_FUNCTION(NdisCmOpenAddressFamilyComplete)
#pragma NDIS_PAGEABLE_FUNCTION(ndisMNotifyAfRegistration)
#pragma NDIS_PAGEABLE_FUNCTION(NdisClCloseAddressFamily)
#pragma NDIS_PAGEABLE_FUNCTION(NdisCmCloseAddressFamilyComplete)
#pragma NDIS_PAGEABLE_FUNCTION(NdisClRegisterSap)
#pragma NDIS_PAGEABLE_FUNCTION(NdisCmRegisterSapComplete)
#pragma NDIS_PAGEABLE_FUNCTION(NdisClDeregisterSap)
#pragma NDIS_PAGEABLE_FUNCTION(NdisCmDeregisterSapComplete)
#pragma NDIS_PAGEABLE_FUNCTION(NdisClMakeCall)
#pragma NDIS_PAGEABLE_FUNCTION(NdisCmMakeCallComplete)
#pragma NDIS_PAGEABLE_FUNCTION(NdisCmDispatchIncomingCall)
#pragma NDIS_PAGEABLE_FUNCTION(NdisClIncomingCallComplete)
#pragma NDIS_PAGEABLE_FUNCTION(NdisCmDispatchCallConnected)
#pragma NDIS_PAGEABLE_FUNCTION(NdisClModifyCallQoS)
#pragma NDIS_PAGEABLE_FUNCTION(NdisCmModifyCallQoSComplete)
#pragma NDIS_PAGEABLE_FUNCTION(NdisCmDispatchIncomingCallQoSChange)
#pragma NDIS_PAGEABLE_FUNCTION(NdisClCloseCall)
#pragma NDIS_PAGEABLE_FUNCTION(NdisCmCloseCallComplete)
#pragma NDIS_PAGEABLE_FUNCTION(NdisCmDispatchIncomingCloseCall)
#pragma NDIS_PAGEABLE_FUNCTION(NdisClAddParty)
#pragma NDIS_PAGEABLE_FUNCTION(NdisCmAddPartyComplete)
#pragma NDIS_PAGEABLE_FUNCTION(NdisClDropParty)
#pragma NDIS_PAGEABLE_FUNCTION(NdisCmDropPartyComplete)
#pragma NDIS_PAGEABLE_FUNCTION(NdisCmDispatchIncomingDropParty)
#pragma NDIS_PAGEABLE_FUNCTION(NdisCoCreateVc)
#pragma NDIS_PAGEABLE_FUNCTION(NdisCoDeleteVc)
#pragma NDIS_PAGEABLE_FUNCTION(NdisCmActivateVc)
#pragma NDIS_PAGEABLE_FUNCTION(NdisMCoActivateVcComplete)
#pragma NDIS_PAGEABLE_FUNCTION(NdisCmDeactivateVc)
#pragma NDIS_PAGEABLE_FUNCTION(NdisMCoDeactivateVcComplete)
#pragma NDIS_PAGEABLE_FUNCTION(NdisCoRequest)
#pragma NDIS_PAGEABLE_FUNCTION(NdisCoRequestComplete)
#pragma NDIS_LOCKED_FUNCTION(NdisMCoIndicateReceivePacket)
#pragma NDIS_LOCKED_FUNCTION(NdisMCoReceiveComplete)
#pragma NDIS_LOCKED_FUNCTION(NdisCoSendPackets)
#pragma NDIS_LOCKED_FUNCTION(NdisMCoSendComplete)
#pragma NDIS_PAGEABLE_FUNCTION(NdisMCoIndicateStatus)
#pragma NDIS_PAGEABLE_FUNCTION(NdisMCmRegisterAddressFamily)
#pragma NDIS_PAGEABLE_FUNCTION(NdisMCoRequestComplete)
#pragma NDIS_PAGEABLE_FUNCTION(ndisReferenceAf)
#pragma NDIS_PAGEABLE_FUNCTION(ndisDereferenceAf)
#pragma NDIS_PAGEABLE_FUNCTION(ndisReferenceSap)
#pragma NDIS_PAGEABLE_FUNCTION(ndisDereferenceSap)
#pragma NDIS_PAGEABLE_FUNCTION(ndisMCoFreeResources)
#pragma NDIS_PAGEABLE_FUNCTION(ndisReferenceVc)
#pragma NDIS_PAGEABLE_FUNCTION(ndisDereferenceVc)
#pragma NDIS_LOCKED_FUNCTION(ndisMRejectSend)
#pragma NDIS_LOCKED_FUNCTION(ndisMRejectSendPackets)
#pragma NDIS_LOCKED_FUNCTION(ndisMCoDpc)
#pragma NDIS_LOCKED_FUNCTION(ndisMCoDpcTimer)
#endif	// NDIS_NT
#endif	// ALLOC_PRAGMA

#endif	// _PRAGMA_
