/*++

Copyright (c) 1995  DeskStation Technology

Module Name:

    apoc.h

Abstract:

    This file contains definitions specific to the Apocalypse (ALPHA EV5)
    and Rogue (ALPHA EV4) processor modules.

Author:

    Michael D. Kinney 1-May-1995

Environment:

    Kernel mode

Revision History:


--*/

#define DTI_QVA_ENABLE    (0x80000000)	// Identify VA as a QVA
#define DTI_QVA_SELECTORS (0xc0000000)	// QVA identification mask

#define IO_BIT_SHIFT    0x05		// Bits to shift QVA

#define IO_BYTE_OFFSET  0x20		// Offset to next byte
#define IO_SHORT_OFFSET 0x40		// Offset to next short
#define IO_LONG_OFFSET  0x80		// Offset to next long

#define IO_BYTE_LEN     0x00		// Byte length
#define IO_WORD_LEN     0x08            // Word length
#define IO_TRIBYTE_LEN  0x10            // TriByte length
#define IO_LONG_LEN     0x18            // Longword length

//
// Constant used by dense space I/O routines
//

#define APOC1_PCI_DENSE_BASE_PHYSICAL_SUPERPAGE ((ULONGLONG)0xfffffcfb00000000)
#define APOC2_PCI_DENSE_BASE_PHYSICAL_SUPERPAGE ((ULONGLONG)0xfffffcfe00000000)
#define ROGUE_PCI_DENSE_BASE_PHYSICAL_SUPERPAGE ((ULONGLONG)0xfffffc0100000000)

//
// Noncached Dense Memory address spaces.
//

#define APOC1_NONCACHED_DENSE_BASE_PHYSICAL_SUPERPAGE ((ULONGLONG)0xfffffcfb00000000)
#define APOC2_NONCACHED_DENSE_BASE_PHYSICAL_SUPERPAGE ((ULONGLONG)0xfffffcfb00000000)
#define ROGUE_NONCACHED_DENSE_BASE_PHYSICAL_SUPERPAGE ((ULONGLONG)0xfffffc0100000000)

//
// QVA
// HAL_MAKE_QVA(
//     ULONGLONG PhysicalAddress
//     )
//
// Routine Description:
//
//    This macro returns the Qva for a physical address in system space.
//
// Arguments:
//
//    PhysicalAddress - Supplies a 64-bit physical address.
//
// Return Value:
//
//    The Qva associated with the physical address.
//

#define HAL_MAKE_QVA(PA)    \
    ( (PVOID)( DTI_QVA_ENABLE | (ULONG)((PA) >> IO_BIT_SHIFT) & ~(DTI_QVA_SELECTORS) ) )



//
// Define physical address spaces for Apocalypse
//

#define TREB1_APOC1_ISA_IO_BASE_PHYSICAL            ((ULONGLONG)0x0c00000000)
#define TREB1_APOC1_ISA_MEMORY_BASE_PHYSICAL        ((ULONGLONG)0x0a00000000)
#define TREB1_APOC1_ISA1_IO_BASE_PHYSICAL           ((ULONGLONG)0x0d00000000)
#define TREB1_APOC1_ISA1_MEMORY_BASE_PHYSICAL       ((ULONGLONG)0x0900000000)
#define TREB1_APOC1_PCI_IO_BASE_PHYSICAL            ((ULONGLONG)0x0d00000000)
#define TREB1_APOC1_PCI_MEMORY_BASE_PHYSICAL        ((ULONGLONG)0x0900000000)
#define TREB1_APOC1_PCI_HIGH_MEMORY_BASE_PHYSICAL   ((ULONGLONG)0x0800000000)

#define TREB1_APOC2_ISA_IO_BASE_PHYSICAL            ((ULONGLONG)0x0c00000000)
#define TREB1_APOC2_ISA_MEMORY_BASE_PHYSICAL        ((ULONGLONG)0x0a00000000)
#define TREB1_APOC2_ISA1_IO_BASE_PHYSICAL           ((ULONGLONG)0x0d00000000)
#define TREB1_APOC2_ISA1_MEMORY_BASE_PHYSICAL       ((ULONGLONG)0x0900000000)
#define TREB1_APOC2_PCI_IO_BASE_PHYSICAL            ((ULONGLONG)0x0d00000000)
#define TREB1_APOC2_PCI_MEMORY_BASE_PHYSICAL        ((ULONGLONG)0x0900000000)
#define TREB1_APOC2_PCI_HIGH_MEMORY_BASE_PHYSICAL   ((ULONGLONG)0x0800000000)

#define TREB2_APOC1_ISA_IO_BASE_PHYSICAL            ((ULONGLONG)0x0d00000000)
#define TREB2_APOC1_ISA_MEMORY_BASE_PHYSICAL        ((ULONGLONG)0x0900000000)
#define TREB2_APOC1_ISA1_IO_BASE_PHYSICAL           ((ULONGLONG)0x0c00000000)
#define TREB2_APOC1_ISA1_MEMORY_BASE_PHYSICAL       ((ULONGLONG)0x0a00000000)
#define TREB2_APOC1_PCI_IO_BASE_PHYSICAL            ((ULONGLONG)0x0d00000000)
#define TREB2_APOC1_PCI_MEMORY_BASE_PHYSICAL        ((ULONGLONG)0x0900000000)
#define TREB2_APOC1_PCI1_IO_BASE_PHYSICAL           ((ULONGLONG)0x0c00000000)
#define TREB2_APOC1_PCI1_MEMORY_BASE_PHYSICAL       ((ULONGLONG)0x0a00000000)
#define TREB2_APOC1_PCI_HIGH_MEMORY_BASE_PHYSICAL   ((ULONGLONG)0x0800000000)

#define TREB2_APOC2_ISA_IO_BASE_PHYSICAL            ((ULONGLONG)0x0d00000000)
#define TREB2_APOC2_ISA_MEMORY_BASE_PHYSICAL        ((ULONGLONG)0x0900000000)
#define TREB2_APOC2_ISA1_IO_BASE_PHYSICAL           ((ULONGLONG)0x0c00000000)
#define TREB2_APOC2_ISA1_MEMORY_BASE_PHYSICAL       ((ULONGLONG)0x0a00000000)
#define TREB2_APOC2_PCI_IO_BASE_PHYSICAL            ((ULONGLONG)0x0d00000000)
#define TREB2_APOC2_PCI_MEMORY_BASE_PHYSICAL        ((ULONGLONG)0x0900000000)
#define TREB2_APOC2_PCI1_IO_BASE_PHYSICAL           ((ULONGLONG)0x0c00000000)
#define TREB2_APOC2_PCI1_MEMORY_BASE_PHYSICAL       ((ULONGLONG)0x0a00000000)
#define TREB2_APOC2_PCI_HIGH_MEMORY_BASE_PHYSICAL   ((ULONGLONG)0x0800000000)

#define APOC1_PCI_CONFIG_BASE_PHYSICAL              ((ULONGLONG)0xfffffcfe00000000)
#define APOC1_PCI_CONFIG0_BASE_PHYSICAL             ((ULONGLONG)0xfffffcfe00000000)
#define APOC1_PCI_CONFIG1_BASE_PHYSICAL             ((ULONGLONG)0xfffffcff00000000)
#define APOC1_PCI_DENSE_BASE_PHYSICAL               ((ULONGLONG)0x0b00000000)

#define APOC2_PCI_CONFIG_BASE_PHYSICAL              ((ULONGLONG)0xfffffcb800000000)
#define APOC2_PCI_CONFIG0_BASE_PHYSICAL             ((ULONGLONG)0xfffffcb800000000)
#define APOC2_PCI_CONFIG1_BASE_PHYSICAL             ((ULONGLONG)0xfffffcd800000000)
#define APOC2_PCI_DENSE_BASE_PHYSICAL               ((ULONGLONG)0x0e00000000)
#define APOC2_TRANSLATED_MEMORY_BASE_PHYSICAL       ((ULONGLONG)0x0f00000000)

#define APOC_DMA_CACHE_BASE_PHYSICAL                ((ULONGLONG)0x0b007c0000)
#define APOC_CACHE_FLUSH_BASE_PHYSICAL              ((ULONGLONG)0x003fe00000)
#define APOC_DMA_CACHE_SIZE                         0x00040000 
#define APOC_CACHE_FLUSH_SIZE                       0x00200000 

//
// Define physical address spaces for Rogue
//

#define ROGUE_TRANSLATED_BASE_PHYSICAL             ((ULONGLONG)0x0a00000000)

#define TREB1_ROGUE_ISA_IO_BASE_PHYSICAL           ((ULONGLONG)0x0000000000)
#define TREB1_ROGUE_ISA_MEMORY_BASE_PHYSICAL       ((ULONGLONG)0x0040000000)
#define TREB1_ROGUE_ISA1_IO_BASE_PHYSICAL          ((ULONGLONG)0x0080000000)
#define TREB1_ROGUE_ISA1_MEMORY_BASE_PHYSICAL      ((ULONGLONG)0x00c0000000)
#define TREB1_ROGUE_PCI_IO_BASE_PHYSICAL           ((ULONGLONG)0x0080000000)
#define TREB1_ROGUE_PCI_MEMORY_BASE_PHYSICAL       ((ULONGLONG)0x00c0000000)
#define TREB1_ROGUE_PCI_HIGH_MEMORY_BASE_PHYSICAL  ((ULONGLONG)0x0100000000)

#define TREB2_ROGUE_ISA_IO_BASE_PHYSICAL           ((ULONGLONG)0x0080000000)
#define TREB2_ROGUE_ISA_MEMORY_BASE_PHYSICAL       ((ULONGLONG)0x00c0000000)
#define TREB2_ROGUE_ISA1_IO_BASE_PHYSICAL          ((ULONGLONG)0x0000000000)
#define TREB2_ROGUE_ISA1_MEMORY_BASE_PHYSICAL      ((ULONGLONG)0x0040000000)
#define TREB2_ROGUE_PCI_IO_BASE_PHYSICAL           ((ULONGLONG)0x0080000000)
#define TREB2_ROGUE_PCI_MEMORY_BASE_PHYSICAL       ((ULONGLONG)0x00c0000000)
#define TREB2_ROGUE_PCI1_IO_BASE_PHYSICAL          ((ULONGLONG)0x0000000000)
#define TREB2_ROGUE_PCI1_MEMORY_BASE_PHYSICAL      ((ULONGLONG)0x0040000000)
#define TREB2_ROGUE_PCI_HIGH_MEMORY_BASE_PHYSICAL  ((ULONGLONG)0x0100000000)

#define ROGUE_PCI_CONFIG0_BASE_PHYSICAL            ((ULONGLONG)0x0200000000)
#define ROGUE_PCI_CONFIG1_BASE_PHYSICAL            ((ULONGLONG)0x03c0000000)
#define ROGUE_PCI_DENSE_BASE_PHYSICAL              ((ULONGLONG)0x0100000000)
#define ROGUE_DMA_CACHE_BASE_PHYSICAL              ((ULONGLONG)0x01007c0000)
#define ROGUE_CACHE_FLUSH_BASE_PHYSICAL            ((ULONGLONG)0x003fc00000)
#define ROGUE_DMA_CACHE_SIZE                       0x00040000 
#define ROGUE_CACHE_FLUSH_SIZE                     0x00400000 
