/*++

Copyright (c) 1994  Microsoft Corporation

Module Name:

    x86test.c

Abstract:

    This module implements a series of tests for the x86 ROM Bios emulator.

Author:

    David N. Cutler (davec) 13-Sep-1994

Environment:

    Kernel mode only.

Revision History:

--*/

#include "nthal.h"
#include "stdio.h"
#include "string.h"
#include "memory.h"
#include "emulate.h"

//
// Define global instruction execution data.
//

UCHAR CodeStream[] = {0xeb, 0x07,                   // jmp .+7
                      0xc3,                         // ret (near)
                      0xcb,                         // ret (far)
                      0x66, 0xc3,                   // ret (near)
                      0x66, 0xcb,                   // ret (far)
                      0xcf,                         // iret
                      0xe9, 0x00, 0x00,             // jmp .+1
                      0x66, 0xe9, 0x00, 0x00, 0x00, 0x00, // jmp .+1
                      0xea, 0x17, 0x00, 0x00, 0x20, // jmp 0x0017:0x2000
                      0x66, 0xea, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x20, // jmp 0x0000001f:0x2000
                      0x66, 0xb8, 0x2e, 0x00, 0x00, 0x20, // mov eax, 0x2000002e
                      0x66, 0x89, 0x06, 0x04, 0x00, // mov ds:0x0004, eax
                      0xff, 0x26, 0x04, 0x00,       // jmp ds:0x0004
                      0x66, 0xb8, 0x3d, 0x00, 0x00, 0x20, // mov eax, 0x2000003d
                      0x66, 0x89, 0x06, 0x04, 0x00, // mov ds:0x0004, eax
                      0xff, 0x2e, 0x04, 0x00,       // jmp ds:0x0004
                      0x9b,                         // wait (nop)
/*                      0x00, 0xc0,                   // add al, al
                      0x00, 0xc9,                   // add cl, cl
                      0x00, 0xd2,                   // add dl, dl
                      0x00, 0xdb,                   // add bl, bl
                      0x00, 0xe4,                   // add ah, ah
                      0x00, 0xed,                   // add ch, ch
                      0x00, 0xf6,                   // add dh, dh
                      0x00, 0xff,                   // add bh, bh
                      0x01, 0xc0,                   // add ax, ax
                      0x01, 0xc9,                   // add cx, cx
                      0x01, 0xd2,                   // add dx, dx
                      0x01, 0xdb,                   // add bx, bx
                      0x01, 0xed,                   // add bp, bp
                      0x01, 0xf6,                   // add si, si
                      0x01, 0xff,                   // add di, di
                      0x66, 0x01, 0xc0,             // add eax, eax
                      0x66, 0x01, 0xc9,             // add ecx, ecx
                      0x66, 0x01, 0xd2,             // add edx, edx
                      0x66, 0x01, 0xdb,             // add ebx, ebx
                      0x66, 0x01, 0xed,             // add ebp, ebp
                      0x66, 0x01, 0xf6,             // add esi, esi
                      0x66, 0x01, 0xff,             // add edi, edi
                      0x66, 0x31, 0xc0,             // xor eax, eax
                      0x66, 0x31, 0xc9,             // xor ecx, ecx
                      0x66, 0x31, 0xd2,             // xor edx, edx
                      0x66, 0x31, 0xdb,             // xor ebx, ebx
                      0x66, 0x31, 0xed,             // xor ebp, ebp
                      0x66, 0x31, 0xf6,             // xor esi, esi
                      0x66, 0x31, 0xff,             // xor edi, edi
                      0x04, 0xf0,                   // add al, 0xf0
                      0x41,                         // inc CX
                      0x41,                         // inc CX
                      0xc0, 0xc0, 0x05,             // rol al, 0x05
                      0xd0, 0xc0,                   // rol al, 1
                      0xd2, 0xc0,                   // rol al, CL
                      0x05, 0x0f, 0x00,             // add ax, 0x000f
                      0xc1, 0xc0, 0x0d,             // rol ax, 0x0d
                      0xd1, 0xc0,                   // rol ax, 1
                      0xd3, 0xc0,                   // rol ax, CL
                      0x05, 0x00, 0xff,             // add ax, 0xff00
                      0x66, 0xc1, 0xc0, 0x1d,       // rol eax, 0x1d
                      0x66, 0xd1, 0xc0,             // rol eax, 1
                      0x66, 0xd3, 0xc0,             // rol eax, CL
                      0xf8,                         // clc
                      0xf9,                         // stc
                      0xf8,                         // clc
                      0xf5,                         // cmc
                      0xf5,                         // cmc
                      0xfa,                         // cli
                      0xfb,                         // sti
                      0xfc,                         // cld
                      0xfd,                         // std
                      0xfc,                         // cld
                      0x66, 0x31, 0xc0,             // xor eax, eax
                      0x66, 0x31, 0xc9,             // xor ecx, ecx
                      0x66, 0x31, 0xd2,             // xor edx, edx
                      0x66, 0x31, 0xdb,             // xor ebx, ebx
                      0x66, 0x31, 0xed,             // xor ebp, ebp
                      0x66, 0x31, 0xf6,             // xor esi, esi
                      0x66, 0x31, 0xff,             // xor edi, edi
                      0x66, 0x05, 0xf0, 0x3c, 0x0f, 0x0f, // add eax, 0x0f0f3cf0
                      0x66, 0x89, 0xc2,             // mov edx,eax
                      0x31, 0xd2,                   // xor dx, dx
                      0x88, 0xc3,                   // mov bl, al
                      0x88, 0xe7,                   // mov bh, ah
                      0x89, 0xda,                   // mov dx, bx
                      0x66, 0x89, 0xc6,             // mov esi, eax
                      0x66, 0x31, 0xc0,             // xor eax, eax
                      0x66, 0x8b, 0xc6,             // mov eax, esi
                      0x66, 0x31, 0xc0,             // xor eax, eax
                      0x66, 0x31, 0xc9,             // xor ecx, ecx
                      0x66, 0x31, 0xd2,             // xor edx, edx
                      0x66, 0x31, 0xdb,             // xor ebx, ebx
                      0x66, 0x31, 0xed,             // xor ebp, ebp
                      0x66, 0x31, 0xf6,             // xor esi, esi
                      0x66, 0x31, 0xff,             // xor edi, edi
                      0x66, 0xb8, 0x11, 0x11, 0x11, 0x11, // mov EAX, 0x11111111
                      0x66, 0xb9, 0x22, 0x22, 0x22, 0x22, // mov ECX, 0x22222222
                      0x66, 0xba, 0x33, 0x33, 0x33, 0x33, // mov EDX, 0x33333333
                      0x66, 0xbb, 0x44, 0x44, 0x44, 0x44, // mov EBX, 0x44444444
                      0x66, 0xbd, 0x66, 0x66, 0x66, 0x66, // mov EBP, 0x66666666
                      0x66, 0xbe, 0x77, 0x77, 0x77, 0x77, // mov ESI, 0x77777777
                      0x66, 0xbf, 0x88, 0x88, 0x88, 0x88, // mov EDI, 0x88888888
                      0xb8, 0x08, 0x01,             // mov AX, 0x0108
                      0xb9, 0x09, 0x02,             // mov CX, 0x0209
                      0xba, 0x0a, 0x03,             // mov DX, 0x030a
                      0xbb, 0x0b, 0x04,             // mov BX, 0x040b
                      0xbd, 0x0d, 0x06,             // mov BP, 0x060d
                      0xbe, 0x0e, 0x07,             // mov SI, 0x070e
                      0xbf, 0x0f, 0x08,             // mov DI, 0x080f
                      0xb0, 0x01,                   // mov al, 0x01
                      0xb1, 0x02,                   // mov cl, 0x02
                      0xb2, 0x03,                   // mov dl, 0x03
                      0xb3, 0x04,                   // mov bl, 0x04
                      0xb4, 0x05,                   // mov ah, 0x05
                      0xb5, 0x06,                   // mov ch, 0x06
                      0xb6, 0x07,                   // mov dh, 0x07
                      0xb7, 0x08,                   // mov bh, 0x08
                      0x91,                         // xchg cx, ax
                      0x92,                         // xchg dx, ax
                      0x93,                         // xchg bx, ax
                      0x95,                         // xchg bp, ax
                      0x96,                         // xchg si, ax
                      0x97,                         // xchg di, ax
                      0x66, 0x91,                   // xchg ecx, eax
                      0x66, 0x92,                   // xchg edx, eax
                      0x66, 0x93,                   // xchg ebx, eax
                      0x66, 0x95,                   // xchg ebp, eax
                      0x66, 0x96,                   // xchg esi, eax
                      0x66, 0x97,                   // xchg edi, eax
                      0x86, 0xd9,                   // xchg bl, cl
                      0x87, 0xd9,                   // xchg bx, cx
                      0x66, 0x87, 0xd9,             // xchg ebx, ecx
                      0xb0, 0x7f,                   // mov al, 0x7f
                      0x98,                         // cbw
                      0xb0, 0x83,                   // mov al, 0x83
                      0x98,                         // cbw
                      0xb8, 0x01, 0x08,             // mov AX, 0x0801
                      0x99,                         // cwd
                      0xb8, 0x01, 0x80,             // mov AX, 0x8001
                      0x99,                         // cwd
                      0xb4, 0xfd,                   // mov ah, 0xfd
                      0x9e,                         // sahf
                      0xb4, 0x77,                   // mov ah, 0x77
                      0x9f,                         // lahf
                      0xc6, 0xc0, 0xed,             // mov al, 0xed
                      0xc6, 0xc4, 0xde,             // mov ah, 0xde
                      0xc7, 0xc0, 0xcc, 0xdd,       // mov ax, 0xddcc
                      0x66, 0xc7, 0xc0, 0xdd, 0xcc, 0xbb, 0xaa, // mov eax, 0xaabbccdd
                      0xb0, 0x83,                   // mov al, 0x83
                      0x0f, 0x90, 0xc0,             // seto al
                      0xb0, 0x83,                   // mov al, 0x83
                      0x0f, 0x91, 0xc0,             // setno al
                      0xb0, 0x83,                   // mov al, 0x83
                      0x0f, 0x92, 0xc0,             // setb al
                      0xb0, 0x83,                   // mov al, 0x83
                      0x0f, 0x93, 0xc0,             // setnb al
                      0xb0, 0x83,                   // mov al, 0x83
                      0x0f, 0x94, 0xc0,             // setz al
                      0xb0, 0x83,                   // mov al, 0x83
                      0x0f, 0x95, 0xc0,             // setnz al
                      0xb0, 0x83,                   // mov al, 0x83
                      0x0f, 0x96, 0xc0,             // setbe al
                      0xb0, 0x83,                   // mov al, 0x83
                      0x0f, 0x97, 0xc0,             // setnbe al
                      0xb0, 0x83,                   // mov al, 0x83
                      0x0f, 0x98, 0xc0,             // sets al
                      0xb0, 0x83,                   // mov al, 0x83
                      0x0f, 0x99, 0xc0,             // setns al
                      0xb0, 0x83,                   // mov al, 0x83
                      0x0f, 0x9a, 0xc0,             // setp al
                      0xb0, 0x83,                   // mov al, 0x83
                      0x0f, 0x9b, 0xc0,             // setnp al
                      0xb0, 0x83,                   // mov al, 0x83
                      0x0f, 0x9c, 0xc0,             // setl al
                      0xb0, 0x83,                   // mov al, 0x83
                      0x0f, 0x9d, 0xc0,             // setnl al
                      0xb0, 0x83,                   // mov al, 0x83
                      0x0f, 0x9e, 0xc0,             // setle al
                      0xb0, 0x83,                   // mov al, 0x83
                      0x0f, 0x9f, 0xc0,             // setnle al
                      0x66, 0xb8, 0xfe, 0xff, 0x01, 0x00, // mov eax, 0x0001fffe
                      0x40,                         // inc ax
                      0x66, 0x40,                   // inc eax
                      0x66, 0x48,                   // dec eax
                      0x48,                         // dec ax
                      0x66, 0xb9, 0xfe, 0xff, 0x01, 0x00, // mov ecx, 0x0001fffe
                      0x41,                         // inc cx
                      0x66, 0x41,                   // inc ecx
                      0x66, 0x49,                   // dec ecxx
                      0x49,                         // dec cx
                      0x66, 0xba, 0xfe, 0xff, 0x01, 0x00, // mov edx, 0x0001fffe
                      0x42,                         // inc dx
                      0x66, 0x42,                   // inc edx
                      0x66, 0x4a,                   // dec edx
                      0x4a,                         // dec dx
                      0x66, 0xbb, 0xfe, 0xff, 0x01, 0x00, // mov ebx, 0x0001fffe
                      0x43,                         // inc bx
                      0x66, 0x43,                   // inc ebx
                      0x66, 0x4b,                   // dec ebx
                      0x4b,                         // dec bx
                      0x66, 0xbd, 0xfe, 0xff, 0x01, 0x00, // mov ebp, 0x0001fffe
                      0x45,                         // inc bp
                      0x66, 0x45,                   // inc ebp
                      0x66, 0x4d,                   // dec ebp
                      0x4d,                         // dec bp
                      0x66, 0xbe, 0xfe, 0xff, 0x01, 0x00, // mov esi, 0x0001fffe
                      0x46,                         // inc si
                      0x66, 0x46,                   // inc esi
                      0x66, 0x4e,                   // dec esix
                      0x4e,                         // dec si
                      0x66, 0xbf, 0xfe, 0xff, 0x01, 0x00, // mov edi, 0x0001fffe
                      0x47,                         // inc di
                      0x66, 0x47,                   // inc edi
                      0x66, 0x4f,                   // dec edix
                      0x4f,                         // dec di
                      0x26, 0x90,                   // ES: nop
                      0x2e, 0x90,                   // CS: nop
                      0x36, 0x90,                   // SS: nop
                      0x3e, 0x90,                   // DS: nop
                      0x64, 0x90,                   // FS: nop
                      0x65, 0x90,                   // GS: nop
                      0xb8, 0xb8, 0xb8,             // mov ax, 0xb8b8
                      0xb9, 0xb9, 0xb9,             // mov cx, 0xb9b9
                      0xba, 0xba, 0xba,             // mov dx, 0xbaba
                      0xbb, 0xbb, 0xbb,             // mov bx, 0xbbbb
                      0xbd, 0xbd, 0xbd,             // mov bp, 0xbdbd
                      0xbe, 0xbe, 0xbe,             // mov si, 0xbebe
                      0xbf, 0xbf, 0xbf,             // mov di, 0xbfbf
                      0x66, 0x50,                   // push eax
                      0x66, 0x51,                   // push ecx
                      0x66, 0x52,                   // push edx
                      0x66, 0x53,                   // push ebx
                      0x66, 0x54,                   // push esp
                      0x66, 0x55,                   // push ebp
                      0x66, 0x56,                   // push esi
                      0x66, 0x57,                   // push edi
                      0x50,                         // push ax
                      0x51,                         // push cx
                      0x52,                         // push dx
                      0x53,                         // push bx
                      0x54,                         // push sp
                      0x55,                         // push bp
                      0x56,                         // push si
                      0x57,                         // push di
                      0xb8, 0x00, 0x00,             // mov ax, 0x0000
                      0xb9, 0x00, 0x00,             // mov cx, 0x0000
                      0xba, 0x00, 0x00,             // mov dx, 0x0000
                      0xbb, 0x00, 0x00,             // mov bx, 0x0000
                      0xbd, 0x00, 0x00,             // mov bp, 0x0000
                      0xbe, 0x00, 0x00,             // mov si, 0x0000
                      0xbf, 0x00, 0x00,             // mov di, 0x0000
                      0x5f,                         // pop di
                      0x5e,                         // pop si
                      0x5d,                         // pop bp
                      0x5c,                         // pop sp
                      0x5b,                         // pop bx
                      0x5a,                         // pop dx
                      0x59,                         // pop cx
                      0x58,                         // pop ax
                      0xb8, 0x00, 0x00,             // mov ax, 0x0000
                      0xb9, 0x00, 0x00,             // mov cx, 0x0000
                      0xba, 0x00, 0x00,             // mov dx, 0x0000
                      0xbb, 0x00, 0x00,             // mov bx, 0x0000
                      0xbd, 0x00, 0x00,             // mov bp, 0x0000
                      0xbe, 0x00, 0x00,             // mov si, 0x0000
                      0xbf, 0x00, 0x00,             // mov di, 0x0000
                      0x66, 0x5f,                   // pop edi
                      0x66, 0x5e,                   // pop esi
                      0x66, 0x5d,                   // pop ebp
                      0x66, 0x5c,                   // pop esp
                      0x66, 0x5b,                   // pop ebx
                      0x66, 0x5a,                   // pop edx
                      0x66, 0x59,                   // pop ecx
                      0x66, 0x58,                   // pop eax
                      0x06,                         // push ES
                      0x0e,                         // push CS
                      0x16,                         // push SS
                      0x1e,                         // push DS
                      0x0f, 0xa0,                   // push FS
                      0x0f, 0xa8,                   // push GS
                      0x0f, 0xa9,                   // pop GS
                      0x0f, 0xa1,                   // pop FS
                      0x1f,                         // pop DS
                      0x17,                         // pop SS
                      0x58,                         // pop ax
                      0x07,                         // pop ES
                      0x90,                         // nop
                      0xb0, 0x81,                   // mov al, 0x81
                      0xb1, 0xff,                   // mov cl, 0xff
                      0x20, 0xc1,                   // and cl, al
                      0xb0, 0x55,                   // mov al, 0x55
                      0xb1, 0xff,                   // mov cl, 0xff
                      0x20, 0xc1,                   // and cl, al
                      0xb0, 0x81,                   // mov al, 0x81
                      0xb1, 0x7e,                   // mov cl, 0x7e
                      0x20, 0xc1,                   // and cl, al
                      0xb8, 0x81, 0x81,             // mov ax, 0x8181
                      0xb9, 0xff, 0xff,             // mov cx, 0xffff
                      0x21, 0xc1,                   // and cx, ax
                      0xb8, 0x55, 0x55,             // mov ax, 0x5555
                      0xb9, 0xff, 0xff,             // mov cx, 0xffff
                      0x21, 0xc1,                   // and cx, ax
                      0xb8, 0x81, 0x81,             // mov ax, 0x8181
                      0xb9, 0x7e, 0x7e,             // mov cx, 0x7e7e
                      0x21, 0xc1,                   // and cx, ax
                      0x66, 0xb8, 0x80, 0x81, 0x81, 0x81, // mov eax, 0x81818181
                      0x66, 0xb9, 0xff, 0xff, 0xff, 0xff, // mov ecx, 0xffffffff
                      0x66, 0x21, 0xc1,             // and ecx, eax
                      0x66, 0xb8, 0x55, 0x55, 0x55, 0x55, // mov eax, 0x55555555
                      0x66, 0xb9, 0xff, 0xff, 0xff, 0xff, // mov ecx, 0xffffffff
                      0x66, 0x21, 0xc1,             // and ecx, eax
                      0x66, 0xb8, 0x81, 0x81, 0x81, 0x81, // mov eax, 0x81818181
                      0x66, 0xb9, 0x7e, 0x7e, 0x7e, 0x7e, // mov ecx, 0x7e7e7e7e
                      0x66, 0x21, 0xc1,             // and ecx, eax
                      0xb1, 0x80,                   // mov cl, 0x80
                      0x80, 0xe1, 0xff,             // and cl, 0xff
                      0xb9, 0x55, 0x55,             // mov cx, 0x5555
                      0x81, 0xe1, 0xff, 0xff,       // and cx, 0xffff
                      0x66, 0xb9, 0x80, 0x81, 0x81, 0x81, // mov ecx, 0x81818181
                      0x66, 0x81, 0xe1, 0xff, 0xff, 0xff, 0xff, // and ecx, 0xffffffff
                      0xb9, 0x55, 0x55,             // mov cx, 0x5555
                      0x83, 0xe1, 0x7f,             // and cx, (sign)0xff
                      0x66, 0xb9, 0x80, 0x81, 0x81, 0x81, // mov ecx, 0x81818181
                      0x66, 0x83, 0xe1, 0x7f,       // and ecx, (sign)0xff
                      0xb9, 0x55, 0x55,             // mov cx, 0x5555
                      0x83, 0xe1, 0xf7,             // and cx, (sign)0xff
                      0x66, 0xb9, 0x80, 0x81, 0x81, 0x81, // mov ecx, 0x81818181
                      0x66, 0x83, 0xe1, 0xf7,       // and ecx, (sign)0xff
                      0xb0, 0x81,                   // mov al, 0x81
                      0xb1, 0xff,                   // mov cl, 0xff
                      0x08, 0xc1,                   // or cl, al
                      0xb0, 0x55,                   // mov al, 0x55
                      0xb1, 0xff,                   // mov cl, 0xff
                      0x08, 0xc1,                   // or cl, al
                      0xb0, 0x81,                   // mov al, 0x81
                      0xb1, 0x7e,                   // mov cl, 0x7e
                      0x08, 0xc1,                   // or cl, al
                      0xb8, 0x81, 0x81,             // mov ax, 0x8181
                      0xb9, 0xff, 0xff,             // mov cx, 0xffff
                      0x09, 0xc1,                   // or cx, ax
                      0xb8, 0x55, 0x55,             // mov ax, 0x5555
                      0xb9, 0xff, 0xff,             // mov cx, 0xffff
                      0x09, 0xc1,                   // or cx, ax
                      0xb8, 0x81, 0x81,             // mov ax, 0x8181
                      0xb9, 0x7e, 0x7e,             // mov cx, 0x7e7e
                      0x09, 0xc1,                   // or cx, ax
                      0x66, 0xb8, 0x80, 0x81, 0x81, 0x81, // mov eax, 0x81818181
                      0x66, 0xb9, 0xff, 0xff, 0xff, 0xff, // mov ecx, 0xffffffff
                      0x66, 0x09, 0xc1,             // or ecx, eax
                      0x66, 0xb8, 0x55, 0x55, 0x55, 0x55, // mov eax, 0x55555555
                      0x66, 0xb9, 0xff, 0xff, 0xff, 0xff, // mov ecx, 0xffffffff
                      0x66, 0x09, 0xc1,             // or ecx, eax
                      0x66, 0xb8, 0x81, 0x81, 0x81, 0x81, // mov eax, 0x81818181
                      0x66, 0xb9, 0x7e, 0x7e, 0x7e, 0x7e, // mov ecx, 0x7e7e7e7e
                      0x66, 0x09, 0xc1,             // or ecx, eax
                      0xb1, 0x80,                   // mov cl, 0x80
                      0x80, 0xc9, 0xff,             // or cl, 0xff
                      0xb9, 0x55, 0x55,             // mov cx, 0x5555
                      0x81, 0xc9, 0xff, 0xff,       // or cx, 0xffff
                      0x66, 0xb9, 0x80, 0x81, 0x81, 0x81, // mov ecx, 0x81818181
                      0x66, 0x81, 0xc9, 0xff, 0xff, 0xff, 0xff, // or ecx, 0xffffffff
                      0xb9, 0x55, 0x55,             // mov cx, 0x5555
                      0x83, 0xc9, 0x7f,             // or cx, (sign)0xff
                      0x66, 0xb9, 0x80, 0x81, 0x81, 0x81, // mov ecx, 0x81818181
                      0x66, 0x83, 0xc9, 0x7f,       // or ecx, (sign)0xff
                      0xb9, 0x55, 0x55,             // mov cx, 0x5555
                      0x83, 0xc9, 0xf7,             // or cx, (sign)0xff
                      0x66, 0xb9, 0x80, 0x81, 0x81, 0x81, // mov ecx, 0x81818181
                      0x66, 0x83, 0xc9, 0xf7,       // or ecx, (sign)0xff
                      0xb0, 0x81,                   // mov al, 0x81
                      0xb1, 0xff,                   // mov cl, 0xff
                      0x30, 0xc1,                   // xor cl, al
                      0xb0, 0x55,                   // mov al, 0x55
                      0xb1, 0xff,                   // mov cl, 0xff
                      0x30, 0xc1,                   // xor cl, al
                      0xb0, 0x81,                   // mov al, 0x81
                      0xb1, 0x7e,                   // mov cl, 0x7e
                      0x30, 0xc1,                   // xor cl, al
                      0xb8, 0x81, 0x81,             // mov ax, 0x8181
                      0xb9, 0xff, 0xff,             // mov cx, 0xffff
                      0x31, 0xc1,                   // xor cx, ax
                      0xb8, 0x55, 0x55,             // mov ax, 0x5555
                      0xb9, 0xff, 0xff,             // mov cx, 0xffff
                      0x31, 0xc1,                   // xor cx, ax
                      0xb8, 0x81, 0x81,             // mov ax, 0x8181
                      0xb9, 0x7e, 0x7e,             // mov cx, 0x7e7e
                      0x31, 0xc1,                   // xor cx, ax
                      0x66, 0xb8, 0x80, 0x81, 0x81, 0x81, // mov eax, 0x81818181
                      0x66, 0xb9, 0xff, 0xff, 0xff, 0xff, // mov ecx, 0xffffffff
                      0x66, 0x31, 0xc1,             // xor ecx, eax
                      0x66, 0xb8, 0x55, 0x55, 0x55, 0x55, // mov eax, 0x55555555
                      0x66, 0xb9, 0xff, 0xff, 0xff, 0xff, // mov ecx, 0xffffffff
                      0x66, 0x31, 0xc1,             // xor ecx, eax
                      0x66, 0xb8, 0x81, 0x81, 0x81, 0x81, // mov eax, 0x81818181
                      0x66, 0xb9, 0x7e, 0x7e, 0x7e, 0x7e, // mov ecx, 0x7e7e7e7e
                      0x66, 0x31, 0xc1,             // xor ecx, eax
                      0xb1, 0x80,                   // mov cl, 0x80
                      0x80, 0xf1, 0xff,             // xor cl, 0xff
                      0xb9, 0x55, 0x55,             // mov cx, 0x5555
                      0x81, 0xf1, 0xff, 0xff,       // xor cx, 0xffff
                      0x66, 0xb9, 0x80, 0x81, 0x81, 0x81, // mov ecx, 0x81818181
                      0x66, 0x81, 0xf1, 0xff, 0xff, 0xff, 0xff, // xor ecx, 0xffffffff
                      0xb9, 0x55, 0x55,             // mov cx, 0x5555
                      0x83, 0xf1, 0x7f,             // xor cx, (sign)0xff
                      0x66, 0xb9, 0x80, 0x81, 0x81, 0x81, // mov ecx, 0x81818181
                      0x66, 0x83, 0xf1, 0x7f,       // xor ecx, (sign)0xff
                      0xb9, 0x55, 0x55,             // mov cx, 0x5555
                      0x83, 0xf1, 0xf7,             // xor cx, (sign)0xff
                      0x66, 0xb9, 0x80, 0x81, 0x81, 0x81, // mov ecx, 0x81818181
                      0x66, 0x83, 0xf1, 0xf7,       // xor ecx, (sign)0xff
                      0xb0, 0x81,                   // mov al, 0x81
                      0xa8, 0xff,                   // test al, 0xff
                      0xb0, 0x55,                   // mov al, 0x55
                      0xa8, 0xff,                   // test al, 0xff
                      0xb0, 0x81,                   // mov al, 0x81
                      0xa8, 0x7e,                   // test al, 0x7e
                      0xb8, 0x81, 0x81,             // mov ax, 0x8181
                      0xa9, 0xff, 0xff,             // test ax, 0xffff
                      0xb8, 0x55, 0x55,             // mov ax, 0x5555
                      0xa9, 0xff, 0xff,             // test ax, 0xffff
                      0xb8, 0x81, 0x81,             // mov ax, 0x8181
                      0xa9, 0x7e, 0x7e,             // test ax, 0x7e7e
                      0x66, 0xb8, 0x80, 0x81, 0x81, 0x81, // mov eax, 0x81818181
                      0x66, 0xa9, 0xff, 0xff, 0xff, 0xff, // test ecx, 0xffffffff
                      0x66, 0xb8, 0x55, 0x55, 0x55, 0x55, // mov eax, 0x55555555
                      0x66, 0xa9, 0xff, 0xff, 0xff, 0xff, // test eax, 0xffffffff
                      0x66, 0xb8, 0x81, 0x81, 0x81, 0x81, // mov eax, 0x81818181
                      0x66, 0xa9, 0x7e, 0x7e, 0x7e, 0x7e, // test eax, 0x7e7e7e7e
                      0xb2, 0x81,                    // mov dl, 0x81
                      0xf6, 0xd2,                    // not dl
                      0xba, 0x7e, 0x7e,              // mov dx, 0xfe7e
                      0xf7, 0xd2,                    // not dx
                      0x66, 0xba, 0x5a, 0xa5, 0x5a, 0xa5, // mov edx, 0xa55aa55a
                      0x66, 0xf7, 0xd2,              // not edx
                      0xb1, 0x81,                   // mov cl, 0x81
                      0xf6, 0xc1, 0xff,             // test cl, 0xff
                      0xb1, 0x55,                   // mov cl, 0x55
                      0xf6, 0xc1, 0xff,             // test cl, 0xff
                      0xb1, 0x81,                   // mov cl, 0x81
                      0xf6, 0xc1, 0x7e,             // test cl, 0x7e
                      0xb9, 0x81, 0x81,             // mov cx, 0x8181
                      0xf7, 0xc1, 0xff, 0xff,       // test cx, 0xffff
                      0xb9, 0x55, 0x55,             // mov cx, 0x5555
                      0xf7, 0xc1, 0xff, 0xff,       // test cx, 0xffff
                      0xb9, 0x81, 0x81,             // mov cx, 0x8181
                      0xf7, 0xc1, 0x7e, 0x7e,       // test cx, 0x7e7e
                      0x66, 0xb9, 0x81, 0x81, 0x81, 0x81, // mov ecx, 0x81818181
                      0x66, 0xf7, 0xc1, 0xff, 0xff, 0xff, 0xff, // test ecx, 0xffffffff
                      0x66, 0xb9, 0x55, 0x55, 0x55, 0x55, // mov ecx, 0x55555555
                      0x66, 0xf7, 0xc1, 0xff, 0xff, 0xff, 0xff, // test ecx, 0xffffffff
                      0x66, 0xb9, 0x81, 0x81, 0x81, 0x81, // mov ecx, 0x81818181
                      0x66, 0xf7, 0xc1, 0x7e, 0x7e, 0x7e, 0x7e, // test ecx, 0x7e7e7e7e
                      0xb2, 0x81,                    // mov dl, 0x81
                      0xf6, 0xda,                    // neg dl
                      0xba, 0x7e, 0xfe,              // mov dx, 0xfe7e
                      0xf7, 0xda,                    // neg dx
                      0x66, 0xba, 0x5a, 0xa5, 0x5a, 0xa5, // mov edx, 0xa55aa55a
                      0x66, 0xf7, 0xda,              // neg edx
                      0xb2, 0x7f,                    // mov dl, 0x7f
                      0xf6, 0xda,                    // neg dl
                      0xba, 0x7e, 0x7e,              // mov dx, 0x7e7e
                      0xf7, 0xda,                    // neg dx
                      0x66, 0xba, 0xa5, 0x5a, 0xa5, 0x5a, // mov edx, 0x5aa55aa5
                      0x66, 0xf7, 0xda,              // neg edx
                      0xb0, 0x7f,                   // mov al, 0x7f
                      0x98,                         // cbw
                      0xb0, 0x83,                   // mov al, 0x83
                      0x98,                         // cbw
                      0xb8, 0x01, 0x08,             // mov ax, 0x0801
                      0x99,                         // cwd
                      0xb8, 0x01, 0x80,             // mov ax, 0x8001
                      0x99,                         // cwd
                      0xb8, 0x7f, 0x7f,             // mov ax, 0x7f7f
                      0x66, 0x98,                   // cwde
                      0xb8, 0x83, 0x83,             // mov ax, 0x8383
                      0x66, 0x98,                   // cwde
                      0x66, 0xb8, 0x01, 0x08, 0x01, 0x08, // mov eax, 0x08010801
                      0x66, 0x99,                   // cdq
                      0x66, 0xb8, 0x01, 0x80, 0x01, 0x80, // mov eax, 0x80018001
                      0x66, 0x99,                   // cdq
                      0x66, 0x9c,                   // pushaf
                      0x9c,                         // pushf
                      0x66, 0xb8, 0xd7, 0x0c, 0x06, 0x00, // mov eax, 0x00060cd7
                      0x66, 0x50,                   // push eax
                      0x50,                         // push ax
                      0x9d,                         // popf
                      0x66, 0x9d,                   // popaf
                      0x9d,                         // popf
                      0x66, 0x9d,                   // popaf
                      0x68, 0xef, 0xfe,             // push 0xfeef
                      0x68, 0x11, 0x11,             // push 0x1111
                      0x66, 0x68, 0xef, 0xfe, 0xef, 0xfe, // push 0xfeeffeef
                      0x6a, 0xfe,                   // push 0xfe -> 0xfffe
                      0x6a, 0x7f,                   // push 0x7f -> 0x007f
                      0x66, 0x6a, 0xfe,             // push 0xfe -> 0xfffffffe
                      0x66, 0x6a, 0x7f,             // push 0x7f -> 0x0000007f
                      0x66, 0x9d,                   // popaf
                      0x66, 0x9d,                   // popaf
                      0x9d,                         // popf
                      0x9d,                         // popf
                      0x66, 0x9d,                   // popaf
                      0x9d,                         // popf
                      0x9d,                         // popf
                      0x60,                         // pusha
                      0x66, 0x60,                   // pushad
                      0x66, 0x31, 0xc0,             // xor eax, eax
                      0x66, 0x31, 0xc9,             // xor ecx, ecx
                      0x66, 0x31, 0xd2,             // xor edx, edx
                      0x66, 0x31, 0xdb,             // xor ebx, ebx
                      0x66, 0x31, 0xed,             // xor ebp, ebp
                      0x66, 0x31, 0xf6,             // xor esi, esi
                      0x66, 0x31, 0xff,             // xor edi, edi
                      0x66, 0x61,                   // popad
                      0x66, 0x31, 0xc0,             // xor eax, eax
                      0x66, 0x31, 0xc9,             // xor ecx, ecx
                      0x66, 0x31, 0xd2,             // xor edx, edx
                      0x66, 0x31, 0xdb,             // xor ebx, ebx
                      0x66, 0x31, 0xed,             // xor ebp, ebp
                      0x66, 0x31, 0xf6,             // xor esi, esi
                      0x66, 0x31, 0xff,             // xor edi, edi
                      0x61,                         // popa
                      0xb4, 0x40,                   // mov ah, 0x40 (ZF)
                      0x9e,                         // sahf
                      0x74, 0x00,                   // jz Ib .+1
                      0x75, 0x00,                   // jnz Ib .+1
                      0x0f, 0x84, 0x00, 0x00,       // jz Iv .+1
                      0x0f, 0x85, 0x00, 0x00,       // jnz Iv .+1
                      0x66, 0x0f, 0x84, 0x00, 0x00, 0x00, 0x00,  // jz Iv .+1
                      0x66, 0x0f, 0x85, 0x00, 0x00, 0x00, 0x00,  // jnz Iv .+1
                      0xb4, 0x01,                   // mov ah, 0x01 (CF)
                      0x9e,                         // sahf
                      0x72, 0x00,                   // jb Ib .+1
                      0x73, 0x00,                   // jnb Ib .+1
                      0x0f, 0x82, 0x00, 0x00,       // jb Iv .+1
                      0x0f, 0x83, 0x00, 0x00,       // jnb Iv .+1
                      0x66, 0x0f, 0x82, 0x00, 0x00, 0x00, 0x00,  // jb Iv .+1
                      0x66, 0x0f, 0x83, 0x00, 0x00, 0x00, 0x00,  // jnb Iv .+1
                      0xb4, 0x41,                   // mov ah, 0x41 (ZF-CF)
                      0x9e,                         // sahf
                      0x76, 0x00,                   // jbe Ib .+1
                      0x77, 0x00,                   // jnbe Ib .+1
                      0x0f, 0x86, 0x00, 0x00,       // jbe Iv .+1
                      0x0f, 0x87, 0x00, 0x00,       // jnbe Iv .+1
                      0x66, 0x0f, 0x86, 0x00, 0x00, 0x00, 0x00,  // jbe Iv .+1
                      0x66, 0x0f, 0x87, 0x00, 0x00, 0x00, 0x00,  // jnbe Iv .+1
                      0xb4, 0x80,                   // mov ah, 0x80 (SF)
                      0x9e,                         // sahf
                      0x78, 0x00,                   // js Ib .+1
                      0x79, 0x00,                   // jns Ib .+1
                      0x0f, 0x88, 0x00, 0x00,       // js Iv .+1
                      0x0f, 0x89, 0x00, 0x00,       // jns Iv .+1
                      0x66, 0x0f, 0x88, 0x00, 0x00, 0x00, 0x00,  // js Iv .+1
                      0x66, 0x0f, 0x89, 0x00, 0x00, 0x00, 0x00,  // jns Iv .+1
                      0xb4, 0x04,                   // mov ah, 0x04 (PF)
                      0x9e,                         // sahf
                      0x7a, 0x00,                   // jp Ib .+1
                      0x7b, 0x00,                   // jnp Ib .+1
                      0x0f, 0x8a, 0x00, 0x00,       // jp Iv .+1
                      0x0f, 0x8b, 0x00, 0x00,       // jnp Iv .+1
                      0x66, 0x0f, 0x8a, 0x00, 0x00, 0x00, 0x00,  // jp Iv .+1
                      0x66, 0x0f, 0x8b, 0x00, 0x00, 0x00, 0x00,  // jnp Iv .+1
                      0xb4, 0x80,                   // mov ah, 0x80 (SF)
                      0x9e,                         // sahf
                      0x7c, 0x00,                   // jl Ib .+1
                      0x7d, 0x00,                   // jnl Ib .+1
                      0x0f, 0x8c, 0x00, 0x00,       // jl Iv .+1
                      0x0f, 0x8d, 0x00, 0x00,       // jnl Iv .+1
                      0x66, 0x0f, 0x8c, 0x00, 0x00, 0x00, 0x00,  // jl Iv .+1
                      0x66, 0x0f, 0x8d, 0x00, 0x00, 0x00, 0x00,  // jnl Iv .+1
                      0xb4, 0xc0,                   // mov ah, 0xc0 (SF-ZF)
                      0x9e,                         // sahf
                      0x7e, 0x00,                   // jle Ib .+1
                      0x7f, 0x00,                   // jnle Ib .+1
                      0x0f, 0x8e, 0x00, 0x00,       // jle Iv .+1
                      0x0f, 0x8f, 0x00, 0x00,       // jnle Iv .+1
                      0x66, 0x0f, 0x8e, 0x00, 0x00, 0x00, 0x00,  // jle Iv .+1
                      0x66, 0x0f, 0x8f, 0x00, 0x00, 0x00, 0x00,  // jnle Iv .+1
                      0xb0, 0x80,                   // mov al, 0x80
                      0xd0, 0xc0,                   // rol al, 1
                      0x70, 0x00,                   // jo Ib .+1
                      0x71, 0x00,                   // jno Ib .+1
                      0x0f, 0x80, 0x00, 0x00,       // jo Iv .+1
                      0x0f, 0x81, 0x00, 0x00,       // jno Iv .+1
                      0x66, 0x0f, 0x80, 0x00, 0x00, 0x00, 0x00,  // jo Iv .+1
                      0x66, 0x0f, 0x81, 0x00, 0x00, 0x00, 0x00,  // jno Iv .+1
                      0xb8, 0x00, 0x00,             // mov ax, 0x0000
                      0xb9, 0x02, 0x00,             // mov cx, 0x0002
                      0x40,                         // inc ax
                      0xe2, 0xfd,                   // loop .-3
                      0x66, 0xb8, 0x00, 0x00, 0x00, 0x00, // mov eax, 0x00000000
                      0x66, 0xb9, 0x02, 0x00, 0x00, 0x00, // mov ecx, 0x00000001
                      0x66, 0x40,                   // inc eax
                      0x67, 0xe2, 0xfb,             // loop .-5
                      0xb8, 0x00, 0x00,             // mov ax, 0x0000
                      0xb9, 0x02, 0x00,             // mov cx, 0x0002
                      0x40,                         // inc ax
                      0xe1, 0xfd,                   // loopz .-3
                      0xb8, 0x00, 0x00,             // mov ax, 0x0000
                      0xb9, 0x02, 0x00,             // mov cx, 0x0002
                      0x40,                         // inc ax
                      0xe0, 0xfd,                   // loopnz .-3
                      0x31, 0xc0,                   // xor ax, ax
                      0xb9, 0x02, 0x00,             // mov cx, 0x0002
                      0x40,                         // inc ax
                      0xe0, 0xfd,                   // loopnz .-3
                      0x31, 0xc0,                   // xor ax, ax
                      0xb9, 0x02, 0x00,             // mov cx, 0x0002
                      0x90,                         // nop
                      0xe1, 0xfd,                   // loopz .-3
                      0xeb, 0x00,                   // jmp .+1
                      0xe9, 0x00, 0x00,             // jmp .+1
                      0x66, 0xe9, 0x00, 0x00, 0x00, 0x00, // jmp .+1
                      0xb0, 0x7f,                   // mov al, 0x7f
                      0x0f, 0xb6, 0xc8,             // movzb cx,al
                      0x0f, 0xbe, 0xc8,             // movsb cx,al
                      0xb0, 0x8f,                   // mov al, 0x8f
                      0x0f, 0xb6, 0xc8,             // movzb cx,al
                      0x0f, 0xbe, 0xc8,             // movsb cx,al
                      0xb0, 0x7f,                   // mov al, 0x7f
                      0x66, 0x0f, 0xb6, 0xc8,       // movzb ecx,al
                      0x66, 0x0f, 0xbe, 0xc8,       // movsb ecx,al
                      0xb0, 0x8f,                   // mov al, 0x8f
                      0x66, 0x0f, 0xb6, 0xc8,       // movzb ecx,al
                      0x66, 0x0f, 0xbe, 0xc8,       // movsb ecx,al
                      0xb8, 0x00, 0x7f,             // mov ax, 0x7f00
                      0x0f, 0xb7, 0xc8,             // movzw cx,ax
                      0x0f, 0xbf, 0xc8,             // movsw cx,ax
                      0xb8, 0x00, 0x8f,             // mov ax, 0x8f00
                      0x66, 0x0f, 0xb7, 0xc8,       // movzw ecx,ax
                      0x66, 0x0f, 0xbf, 0xc8,       // movsw ecx,ax
                      0xb8, 0x55, 0xaa,             // mov ax, 0xaa55
                      0x8e, 0xe0,                   // mov fs, ax
                      0x8c, 0xe1,                   // mov cx, fs
                      0x8e, 0xe9,                   // mov gs, cx
                      0x68, 0xef, 0xfe,             // push 0xfeef
                      0x68, 0x11, 0x11,             // push 0x1111
                      0x66, 0x68, 0xef, 0xfe, 0xef, 0xfe, // push 0xfeeffeef
                      0x66, 0x8f, 0xc1,             // pop ecx
                      0x8f, 0xc1,                   // pop cx
                      0x8f, 0xc2,                   // pop dx
                      0xb0, 0x03,                   // mov al, 0x03
                      0xb1, 0x05,                   // mov cl, 0x05
                      0xf6, 0xe1,                   // mul al, cl
                      0xb0, 0xff,                   // mov al, 0xff
                      0xb1, 0x10,                   // mov cl, 0x10
                      0xf6, 0xe1,                   // mul al, cl
                      0xb8, 0x03, 0x00,             // mov ax, 0x03
                      0xb9, 0x05, 0x00,             // mov cx, 0x05
                      0xf7, 0xe1,                   // mul ax, cx
                      0xb8, 0x00, 0xff,             // mov ax, 0xff00
                      0xb9, 0x10, 0x00,             // mov cx, 0x0010
                      0xf7, 0xe1,                   // mul ax, cx
                      0x66, 0xb8, 0x03, 0x00, 0x00, 0x00, // mov eax, 0x00000003
                      0x66, 0xb9, 0x05, 0x00, 0x00, 0x00, // mov ecx, 0x00000005
                      0x66, 0xf7, 0xe1,             // mul eax, ecx
                      0x66, 0xb8, 0x00, 0x00, 0x00, 0xff, // mov eax, 0xff000000
                      0x66, 0xb9, 0x10, 0x00, 0x00, 0x00, // mov ecx, 0x00000010
                      0x66, 0xf7, 0xe1,             // mul eax, ecx
                      0xb0, 0x03,                   // mov al, 0x03
                      0xb1, 0x05,                   // mov cl, 0x05
                      0xf6, 0xe9,                   // imul al, cl
                      0xb0, 0xff,                   // mov al, 0xff
                      0xb1, 0x10,                   // mov cl, 0x10
                      0xf6, 0xe9,                   // imul al, cl
                      0xb8, 0x03, 0x00,             // mov ax, 0x03
                      0xb9, 0x05, 0x00,             // mov cx, 0x05
                      0xf7, 0xe9,                   // imul ax, cx
                      0xb8, 0xff, 0xff,             // mov ax, 0xffff
                      0xb9, 0x10, 0x00,             // mov cx, 0x0010
                      0xf7, 0xe9,                   // imul ax, cx
                      0xb8, 0x00, 0xf0,             // mov ax, 0xf000
                      0xb9, 0x10, 0x00,             // mov cx, 0x0010
                      0xf7, 0xe9,                   // imul ax, cx
                      0x66, 0xb8, 0x03, 0x00, 0x00, 0x00, // mov eax, 0x00000003
                      0x66, 0xb9, 0x05, 0x00, 0x00, 0x00, // mov ecx, 0x00000005
                      0x66, 0xf7, 0xe9,             // imul eax, ecx
                      0x66, 0xb8, 0x00, 0x00, 0x00, 0xf0, // mov eax, 0xf0000000
                      0x66, 0xb9, 0x10, 0x00, 0x00, 0x00, // mov ecx, 0x00000010
                      0x66, 0xf7, 0xe9,             // imul eax, ecx
                      0xb8, 0x03, 0x00,             // mov ax, 0x0003
                      0x6b, 0xc8, 0x05,             // imul cx, ax, 0x05
                      0xb8, 0x00, 0xff,             // mov ax, 0xff00
                      0x6b, 0xc8, 0x10,             // imul cx, ax, 0x10
                      0xb8, 0x00, 0xf0,             // mov ax, 0xf000
                      0x6b, 0xc8, 0x10,             // imul cx, ax, 0x10
                      0xb8, 0x00, 0x10,             // mov ax, 0x1000
                      0x6b, 0xc8, 0xf0,             // imul cx, ax, 0xf0
                      0x66, 0xb8, 0x03, 0x00, 0x00, 0x00, // mov eax, 0x00000003
                      0x66, 0x6b, 0xc8, 0x05,             // imul ecx, eax, 0x05
                      0x66, 0xb8, 0x00, 0x00, 0x00, 0xff, // mov eax, 0xff000000
                      0x66, 0x6b, 0xc8, 0x10,             // imul ecx, eax, 0x10
                      0x66, 0xb8, 0x00, 0x00, 0x00, 0xf0, // mov eax, 0xf0000000
                      0x66, 0x6b, 0xc8, 0x10,             // imul ecx, eax, 0x10
                      0x66, 0xb8, 0x00, 0x00, 0x00, 0x10, // mov eax, 0x1000
                      0x66, 0x6b, 0xc8, 0xf0,             // imul ecx, eax, 0xf0
                      0xb8, 0x03, 0x00,             // mov ax, 0x0003
                      0x69, 0xc8, 0x05, 0x00,       // imul cx, ax, 0x0005
                      0xb8, 0x00, 0xff,             // mov ax, 0xff00
                      0x69, 0xc8, 0x10, 0x00,       // imul cx, ax, 0x0010
                      0xb8, 0x00, 0xf0,             // mov ax, 0xf000
                      0x69, 0xc8, 0x10, 0x00,       // imul cx, ax, 0x0010
                      0xb8, 0x00, 0x10,             // mov ax, 0x1000
                      0x69, 0xc8, 0x00, 0xf0,       // imul cx, ax, 0xf000
                      0x66, 0xb8, 0x03, 0x00, 0x00, 0x00, // mov eax, 0x00000003
                      0x66, 0x69, 0xc8, 0x05, 0x00, 0x00, 0x00, // imul ecx, eax, 0x00000005
                      0x66, 0xb8, 0x00, 0x00, 0x00, 0xff, // mov eax, 0xff000000
                      0x66, 0x69, 0xc8, 0x10, 0x00, 0x00, 0x00, // imul ecx, eax, 0x00000010
                      0x66, 0xb8, 0x00, 0x00, 0x00, 0xf0, // mov eax, 0xf0000000
                      0x66, 0x69, 0xc8, 0x10, 0x00, 0x00, 0x00, // imul ecx, eax, 0x00000010
                      0x66, 0xb8, 0x00, 0x00, 0x00, 0x10, // mov eax, 0x10000000
                      0x66, 0x69, 0xc8, 0xf0, 0xff, 0xff, 0xff, // imul ecx, eax, 0xfffffff0
                      0xb8, 0x03, 0x00,             // mov ax, 0x0003
                      0xb9, 0x05, 0x00,             // mov cx, 0x0005
                      0x0f, 0xaf, 0xc8,             // imul cx, ax
                      0xb8, 0x00, 0xff,             // mov ax, 0xff00
                      0xb9, 0x10, 0x00,             // mov cx, 0x0010
                      0x0f, 0xaf, 0xc8,             // imul cx,ax
                      0xb8, 0x00, 0xf0,             // mov ax, 0xf000
                      0xb9, 0x10, 0x00,             // mov cx, 0x0010
                      0x0f, 0xaf, 0xc8,             // imul cx,ax
                      0xb8, 0x00, 0x10,             // mov ax, 0x1000
                      0xb9, 0x00, 0xf0,             // mov cx, 0xf000
                      0x0f, 0xaf, 0xc8,             // imul cx,ax
                      0x66, 0xb8, 0x03, 0x00, 0x00, 0x00, // mov eax, 0x00000003
                      0x66, 0xb9, 0x05, 0x00, 0x00, 0x00, // mov ecx, 0x00000005
                      0x66, 0x0f, 0xaf, 0xc8,       // imul ecx, eax
                      0x66, 0xb8, 0x00, 0x00, 0x00, 0xff, // mov eax, 0xff000000
                      0x66, 0xb9, 0x10, 0x00, 0x00, 0x00, // mov ecx, 0x00000010
                      0x66, 0x0f, 0xaf, 0xc8,       // imul ecx, eax
                      0x66, 0xb8, 0x00, 0x00, 0x00, 0xf0, // mov eax, 0xf0000000
                      0x66, 0xb9, 0x10, 0x00, 0x00, 0x00, // mov ecx, 0x00000010
                      0x66, 0x0f, 0xaf, 0xc8,       // imul ecx, eax
                      0x66, 0xb8, 0x00, 0x00, 0x00, 0x10, // mov eax, 0x10000000
                      0x66, 0xb9, 0xf0, 0xff, 0xff, 0xff, // mov ecx, 0xfffffff0
                      0x66, 0x0f, 0xaf, 0xc8,       // imul ecx, eax
                      0xb1, 0xfe,                   // mov cl, 0xfe
                      0xfe, 0xc1,                   // inc cl
                      0xfe, 0xc1,                   // inc cl
                      0xfe, 0xc9,                   // dec cl
                      0xfe, 0xc9,                   // dec cl
                      0xb9, 0xfe, 0xff,             // mov cx, 0xfffe
                      0xff, 0xc1,                   // inc cx
                      0xff, 0xc1,                   // inc cx
                      0xff, 0xc9,                   // dec cx
                      0xff, 0xc9,                   // dec cx
                      0x66, 0xb9, 0xfe, 0xff, 0xff, 0xff, // mov ecx, 0xfffffffe
                      0x66, 0xff, 0xc1,             // inc ecx
                      0x66, 0xff, 0xc1,             // inc ecx
                      0x66, 0xff, 0xc9,             // dec ecx
                      0x66, 0xff, 0xc9,             // dec ecx
                      0xff, 0xf2,                   // push dx
                      0x8f, 0xc3,                   // pop bx
                      0x66, 0xff, 0xf5,             // push ebp
                      0x66, 0x8f, 0xc6,             // pop esi
                      0xb8, 0x7f, 0x00,             // mov ax, 0x007f
                      0xb1, 0x04,                   // mov cl, 0x04
                      0xf6, 0xf1,                   // div ah:al, cl
                      0xb8, 0x80, 0x00,             // mov ax, 0x0080
                      0xb1, 0x10,                   // mov cl, 0x10
                      0xf6, 0xf1,                   // div ah:al, cl
                      0xb8, 0x0f, 0x7f,             // mov ax, 0x7f0f
                      0xba, 0x00, 0x00,             // mov dx, 0x0000
                      0xb9, 0x04, 0x00,             // mov cx, 0x04
                      0xf7, 0xf1,                   // div dx:ax, cx
                      0xb8, 0x00, 0x80,             // mov ax, 0x8000
                      0xba, 0x00, 0x00,             // mov dx, 0x0000
                      0xb9, 0x10, 0x00,             // mov cx, 0x10
                      0xf7, 0xf1,                   // div dx:ax, cx
                      0x66, 0xb8, 0x0f, 0x00, 0x00, 0x7f, // mov eax, 0x7f00000f
                      0x66, 0xba, 0x00, 0x00, 0x00, 0x00, // mov edx, 0x00000000
                      0x66, 0xb9, 0x04, 0x00, 0x00, 0x00, // mov ecx, 0x00000004
                      0x66, 0xf7, 0xf1,                   // div edx:eax, ecx
                      0x66, 0xb8, 0x00, 0x00, 0x00, 0x80, // mov eax, 0x80000000
                      0x66, 0xba, 0x00, 0x00, 0x00, 0x00, // mov edx, 0x00000000
                      0x66, 0xb9, 0x10, 0x00, 0x00, 0x00, // mov ecx, 0x00000010
                      0x66, 0xf7, 0xf1,                   // div edx:eax, ecx
                      0xb8, 0x7f, 0x00,             // mov ax, 0x007f
                      0xb1, 0x04,                   // mov cl, 0x04
                      0xf6, 0xf9,                   // idiv ah:al, cl
                      0xb8, 0x81, 0xff,             // mov ax, 0xff81
                      0xb1, 0x10,                   // mov cl, 0x10
                      0xf6, 0xf9,                   // idiv ah:al, cl
                      0xb8, 0x0f, 0x7f,             // mov ax, 0x7f0f
                      0xba, 0x00, 0x00,             // mov dx, 0x0000
                      0xb9, 0x04, 0x00,             // mov cx, 0x04
                      0xf7, 0xf9,                   // idiv dx:ax, cx
                      0xb8, 0x01, 0x80,             // mov ax, 0x8001
                      0xba, 0xff, 0xff,             // mov dx, 0xffff
                      0xb9, 0x10, 0x00,             // mov cx, 0x10
                      0xf7, 0xf9,                   // idiv dx:ax, cx
                      0x66, 0xb8, 0x0f, 0x00, 0x00, 0x7f, // mov eax, 0x7f00000f
                      0x66, 0xba, 0x00, 0x00, 0x00, 0x00, // mov edx, 0x00000000
                      0x66, 0xb9, 0x04, 0x00, 0x00, 0x00, // mov ecx, 0x00000004
                      0x66, 0xf7, 0xf9,                   // idiv edx:eax, ecx
                      0x66, 0xb8, 0x01, 0x00, 0x00, 0x80, // mov eax, 0x80000001
                      0x66, 0xba, 0xff, 0xff, 0xff, 0xff, // mov edx, 0xffffffff
                      0x66, 0xb9, 0x10, 0x00, 0x00, 0x00, // mov ecx, 0x00000010
                      0x66, 0xf7, 0xf9,                   // idiv edx:eax, ecx
                      0x66, 0xb8, 0x05, 0x50, 0x0a, 0xa0, // mov eax, 0xa00a5005
                      0xa2, 0x00, 0x00,             // mov 0x0000, al
                      0x67, 0xa2, 0x04, 0x00, 0x00, 0x00, // mov 0x00000004, al
                      0xa3, 0x08, 0x00,             // mov 0x0008, ax
                      0x67, 0xa3, 0x0c, 0x00, 0x00, 0x00, // mov 0x0000000c, ax
                      0x66, 0xa3, 0x10, 0x00,             // mov 0x0010, eax
                      0x66, 0x67, 0xa3, 0x14, 0x00, 0x00, 0x00, // mov 0x00000014, eax
                      0x66, 0xb8, 0x00, 0x00, 0x00, 0x00, // mov eax, 0x00000000
                      0xa0, 0x00, 0x00,             // mov al, ds:0x0000
                      0xb0, 0x00,                   // mov al, 0x00
                      0x67, 0xa0, 0x04, 0x00, 0x00, 0x00, // al, mov ds:0x00000004
                      0xb0, 0x00,                   // mov al, 0x00
                      0xa1, 0x08, 0x00,             // mov ax, ds:0x0008
                      0xb8, 0x00, 0x00,             // mov ax, 0x0000
                      0x67, 0xa1, 0x0c, 0x00, 0x00, 0x00, // mov ax, ds:0x0000000c
                      0xb8, 0x00, 0x00,             // mov ax, 0x0000
                      0x66, 0xa1, 0x10, 0x00,       // mov eax, ds:0x0010
                      0x66, 0xb8, 0x00, 0x00, 0x00, 0x00, // mov eax, 0x00000000
                      0x66, 0x67, 0xa1, 0x14, 0x00, 0x00, 0x00, // eax, ds:mov 0x00000014
                      0x66, 0xb9, 0x00, 0x00, 0x10, 0x10, // mov ecx, 0x10100000
                      0xe3, 0x00,                   // jcxz .+1
                      0xb9, 0x01, 0x01,             // mov cx, 0x0101
                      0xe3, 0x00,                   // jcxz .+1
                      0x66, 0xe3, 0x00,             // jecxz .+1
                      0x66, 0xb9, 0x00, 0x00, 0x00, 0x00, // mov ecx, 0x00000000
                      0x66, 0xe3, 0x00,             // jecxz .+1
                      0xb8, 0x01, 0x00,             // mov ax, 0x0001
                      0xb9, 0x02, 0x00,             // mov cx, 0x0002
                      0xba, 0x03, 0x00,             // mov dx, 0x0003
                      0xbb, 0x04, 0x00,             // mov bx, 0x0004
                      0xbd, 0x06, 0x00,             // mov bp, 0x0006
                      0xbe, 0x07, 0x00,             // mov si, 0x0007
                      0xbf, 0x08, 0x00,             // mov di, 0x0008
                      0x66, 0x8d, 0x80, 0x10, 0x10, // lea eax,[bx + si + 0x1010]
                      0x66, 0x8d, 0x81, 0x10, 0x10, // lea eax,[bx + di + 0x1010]
                      0x66, 0x8d, 0x82, 0x10, 0x10, // lea eax,[bp + si + 0x1010]
                      0x66, 0x8d, 0x83, 0x10, 0x10, // lea eax,[bp + di + 0x1010]
                      0x66, 0x8d, 0x84, 0x10, 0x10, // lea eax,[si + 0x1010]
                      0x66, 0x8d, 0x85, 0x10, 0x10, // lea eax,[di + 0x1010]
                      0x66, 0x8d, 0x86, 0x10, 0x10, // lea eax,[bp + 0x1010]
                      0x66, 0x8d, 0x87, 0x10, 0x10, // lea eax,[bx + 0x1010]
                      0x66, 0x8d, 0x40, 0x10,       // lea eax,[bx + si + 0x10]
                      0x66, 0x8d, 0x41, 0x10,       // lea eax,[bx + di + 0x10]
                      0x66, 0x8d, 0x42, 0x10,       // lea eax,[bp + si + 0x10]
                      0x66, 0x8d, 0x43, 0x10,       // lea eax,[bp + di + 0x10]
                      0x66, 0x8d, 0x44, 0x10,       // lea eax,[si + 0x10]
                      0x66, 0x8d, 0x45, 0x10,       // lea eax,[di + 0x10]
                      0x66, 0x8d, 0x46, 0x10,       // lea eax,[bp + 0x10]
                      0x66, 0x8d, 0x47, 0x10,       // lea eax,[bx + 0x10]
                      0x66, 0x8d, 0x00,             // lea eax,[bx + si]
                      0x66, 0x8d, 0x01,             // lea eax,[bx + di]
                      0x66, 0x8d, 0x02,             // lea eax,[bp + si]
                      0x66, 0x8d, 0x03,             // lea eax,[bp + di]
                      0x66, 0x8d, 0x04,             // lea eax,[si]
                      0x66, 0x8d, 0x05,             // lea eax,[di]
                      0x66, 0x8d, 0x06, 0xff, 0xee, // lea eax,[0xffee]
                      0x66, 0x8d, 0x07,             // lea eax,[bx]
                      0x8d, 0x80, 0x10, 0x10,       // lea ax,[bx + si + 0x1010]
                      0x8d, 0x81, 0x10, 0x10,       // lea ax,[bx + di + 0x1010]
                      0x8d, 0x82, 0x10, 0x10,       // lea ax,[bp + si + 0x1010]
                      0x8d, 0x83, 0x10, 0x10,       // lea ax,[bp + di + 0x1010]
                      0x8d, 0x84, 0x10, 0x10,       // lea ax,[si + 0x1010]
                      0x8d, 0x85, 0x10, 0x10,       // lea ax,[di + 0x1010]
                      0x8d, 0x86, 0x10, 0x10,       // lea ax,[bp + 0x1010]
                      0x8d, 0x87, 0x10, 0x10,       // lea ax,[bx + 0x1010]
                      0x8d, 0x40, 0x10,             // lea ax,[bx + si + 0x10]
                      0x8d, 0x41, 0x10,             // lea ax,[bx + di + 0x10]
                      0x8d, 0x42, 0x10,             // lea ax,[bp + si + 0x10]
                      0x8d, 0x43, 0x10,             // lea ax,[bp + di + 0x10]
                      0x8d, 0x44, 0x10,             // lea ax,[si + 0x10]
                      0x8d, 0x45, 0x10,             // lea ax,[di + 0x10]
                      0x8d, 0x46, 0x10,             // lea ax,[bp + 0x10]
                      0x8d, 0x47, 0x10,             // lea ax,[bx + 0x10]
                      0x8d, 0x00,                   // lea ax,[bx + si]
                      0x8d, 0x01,                   // lea ax,[bx + di]
                      0x8d, 0x02,                   // lea ax,[bp + si]
                      0x8d, 0x03,                   // lea ax,[bp + di]
                      0x8d, 0x04,                   // lea ax,[si]
                      0x8d, 0x05,                   // lea ax,[di]
                      0x8d, 0x06, 0xff, 0xee,       // lea ax,[0xffee]
                      0x8d, 0x07,                   // lea ax,[bx]
                      0xb8, 0x01, 0x00,             // mov ax, 0x0001
                      0xb9, 0x02, 0x00,             // mov cx, 0x0002
                      0xba, 0x03, 0x00,             // mov dx, 0x0003
                      0xbb, 0x04, 0x00,             // mov bx, 0x0004
                      0xbd, 0x06, 0x00,             // mov bp, 0x0006
                      0xbe, 0x07, 0x00,             // mov si, 0x0007
                      0xbf, 0x08, 0x00,             // mov di, 0x0008
                      0x67, 0x8d, 0x00,             // lea ax,[eax]
                      0x67, 0x8d, 0x01,             // lea ax,[ecx]
                      0x67, 0x8d, 0x02,             // lea ax,[edx]
                      0x67, 0x8d, 0x03,             // lea ax,[ebx]
                      0x67, 0x8d, 0x05, 0xff, 0xee, 0xdd, 0xcc, // lea ax,[0xccddeeff]
                      0x67, 0x8d, 0x06,             // lea ax,[esi]
                      0x67, 0x8d, 0x07,             // lea ax,[edi]
                      0x67, 0x8d, 0x40, 0x10,       // lea ax,[eax + 0x10]
                      0x67, 0x8d, 0x41, 0x10,       // lea ax,[ecx + 0x10]
                      0x67, 0x8d, 0x42, 0x10,       // lea ax,[edx + 0x10]
                      0x67, 0x8d, 0x43, 0x10,       // lea ax,[ebx + 0x10]
                      0x67, 0x8d, 0x45, 0x10,       // lea ax,[ebp + 0x10]
                      0x67, 0x8d, 0x46, 0x10,       // lea ax,[esi + 0x10]
                      0x67, 0x8d, 0x47, 0x10,       // lea ax,[edi + 0x10]
                      0x67, 0x8d, 0x80, 0x10, 0x10, 0x10, 0x10, // lea ax,[eax + 0x10101010]
                      0x67, 0x8d, 0x81, 0x10, 0x10, 0x10, 0x10, // lea ax,[ecx + 0x10101010]
                      0x67, 0x8d, 0x82, 0x10, 0x10, 0x10, 0x10, // lea ax,[edx + 0x10101010]
                      0x67, 0x8d, 0x83, 0x10, 0x10, 0x10, 0x10, // lea ax,[ebx + 0x10101010]
                      0x67, 0x8d, 0x85, 0x10, 0x10, 0x10, 0x10, // lea ax,[ebp + 0x10101010]
                      0x67, 0x8d, 0x86, 0x10, 0x10, 0x10, 0x10, // lea ax,[esi + 0x10101010]
                      0x67, 0x8d, 0x87, 0x10, 0x10, 0x10, 0x10, // lea ax,[edi + 0x10101010]
                      0x66, 0x67, 0x8d, 0x00,       // lea eax,[eax]
                      0x66, 0x67, 0x8d, 0x01,       // lea eax,[ecx]
                      0x66, 0x67, 0x8d, 0x02,       // lea eax,[edx]
                      0x66, 0x67, 0x8d, 0x03,       // lea eax,[ebx]
                      0x66, 0x67, 0x8d, 0x05, 0x10, 0x10, 0x10, 0x10, // lea eax,[0x10101010]
                      0x66, 0x67, 0x8d, 0x06,       // lea eax,[esi]
                      0x66, 0x67, 0x8d, 0x07,       // lea eax,[edi]
                      0x66, 0x67, 0x8d, 0x40, 0x10, // lea eax,[eax + 0x10]
                      0x66, 0x67, 0x8d, 0x41, 0x10, // lea eax,[ecx + 0x10]
                      0x66, 0x67, 0x8d, 0x42, 0x10, // lea eax,[edx + 0x10]
                      0x66, 0x67, 0x8d, 0x43, 0x10, // lea eax,[ebx + 0x10]
                      0x66, 0x67, 0x8d, 0x45, 0x10, // lea eax,[ebp + 0x10]
                      0x66, 0x67, 0x8d, 0x46, 0x10, // lea eax,[esi + 0x10]
                      0x66, 0x67, 0x8d, 0x47, 0x10, // lea eax,[edi + 0x10]
                      0x66, 0x67, 0x8d, 0x80, 0x10, 0x10, 0x10, 0x10, // lea eax,[eax + 0x10101010]
                      0x66, 0x67, 0x8d, 0x81, 0x10, 0x10, 0x10, 0x10, // lea eax,[ecx + 0x10101010]
                      0x66, 0x67, 0x8d, 0x82, 0x10, 0x10, 0x10, 0x10, // lea eax,[edx + 0x10101010]
                      0x66, 0x67, 0x8d, 0x83, 0x10, 0x10, 0x10, 0x10, // lea eax,[ebx + 0x10101010]
                      0x66, 0x67, 0x8d, 0x85, 0x10, 0x10, 0x10, 0x10, // lea eax,[ebp + 0x10101010]
                      0x66, 0x67, 0x8d, 0x86, 0x10, 0x10, 0x10, 0x10, // lea eax,[esi + 0x10101010]
                      0x66, 0x67, 0x8d, 0x87, 0x10, 0x10, 0x10, 0x10, // lea eax,[edi + 0x10101010]
                      0x66, 0xb8, 0x02, 0x00, 0xff, 0x00, // mov eax, 0x00ff0002
                      0x67, 0x8d, 0x04, 0x80,       // lea ax,[eax + eax * 2]
                      0x66, 0xb8, 0x02, 0x00, 0xff, 0x00, // mov eax, 0x00ff0002
                      0x67, 0x8d, 0x04, 0x81,       // lea ax,[ecx + eax * 2]
                      0x66, 0xb8, 0x02, 0x00, 0xff, 0x00, // mov eax, 0x00ff0002
                      0x67, 0x8d, 0x04, 0x82,       // lea ax,[edx + eax * 2]
                      0x66, 0xb8, 0x02, 0x00, 0xff, 0x00, // mov eax, 0x00ff0002
                      0x67, 0x8d, 0x04, 0x83,       // lea ax,[ebx + eax * 2]
                      0x66, 0xb8, 0x02, 0x00, 0xff, 0x00, // mov eax, 0x00ff0002
                      0x67, 0x8d, 0x04, 0x84,       // lea ax,[esp + eax * 2]
                      0x66, 0xb8, 0x02, 0x00, 0xff, 0x00, // mov eax, 0x00ff0002
                      0x67, 0x8d, 0x04, 0x85, 0x10, 0x10, 0x10, 0x10, // lea ax,[0x10101010 + eax * 2]
                      0x66, 0xb8, 0x02, 0x00, 0xff, 0x00, // mov eax, 0x00ff0002
                      0x67, 0x8d, 0x04, 0x86,       // lea ax,[esi + eax * 2]
                      0x66, 0xb8, 0x02, 0x00, 0xff, 0x00, // mov eax, 0x00ff0002
                      0x67, 0x8d, 0x04, 0x87,       // lea ax,[edi + eax * 2]
                      0x66, 0xb8, 0x02, 0x00, 0xff, 0x00, // mov eax, 0x00ff0002
                      0x67, 0x66, 0x8d, 0x04, 0x80,       // lea eax,[eax + eax * 2]
                      0x66, 0xb8, 0x02, 0x00, 0xff, 0x00, // mov eax, 0x00ff0002
                      0x67, 0x66, 0x8d, 0x04, 0x81,       // lea eax,[ecx + eax * 2]
                      0x66, 0xb8, 0x02, 0x00, 0xff, 0x00, // mov eax, 0x00ff0002
                      0x67, 0x66, 0x8d, 0x04, 0x82,       // lea eax,[edx + eax * 2]
                      0x66, 0xb8, 0x02, 0x00, 0xff, 0x00, // mov eax, 0x00ff0002
                      0x67, 0x66, 0x8d, 0x04, 0x83,       // lea eax,[ebx + eax * 2]
                      0x66, 0xb8, 0x02, 0x00, 0xff, 0x00, // mov eax, 0x00ff0002
                      0x67, 0x66, 0x8d, 0x04, 0x84,       // lea eax,[esp + eax * 2]
                      0x66, 0xb8, 0x02, 0x00, 0xff, 0x00, // mov eax, 0x00ff0002
                      0x67, 0x66, 0x8d, 0x04, 0x85, 0x10, 0x10, 0x10, 0x10, // lea eax,[0x10101010 + eax * 2]
                      0x66, 0xb8, 0x02, 0x00, 0xff, 0x00, // mov eax, 0x00ff0002
                      0x67, 0x66, 0x8d, 0x04, 0x86,       // lea eax,[esi + eax * 2]
                      0x66, 0xb8, 0x02, 0x00, 0xff, 0x00, // mov eax, 0x00ff0002
                      0x67, 0x66, 0x8d, 0x04, 0x87,       // lea eax,[edi + eax * 2]
                      0x66, 0xb8, 0x02, 0x00, 0x00, 0x00, // mov eax, 0x00000002
                      0x66, 0x67, 0x8d, 0x44, 0x80, 0x10, // lea eax,[eax + eax * 2 + 0x10]
                      0x66, 0xb8, 0x02, 0x00, 0x00, 0x00, // mov eax, 0x00000002
                      0x66, 0x67, 0x8d, 0x44, 0x81, 0x10, // lea eax,[ecx + eax * 2 + 0x10]
                      0x66, 0xb8, 0x02, 0x00, 0x00, 0x00, // mov eax, 0x00000002
                      0x66, 0x67, 0x8d, 0x44, 0x82, 0x10, // lea eax,[edx + eax * 2 + 0x10]
                      0x66, 0xb8, 0x02, 0x00, 0x00, 0x00, // mov eax, 0x00000002
                      0x66, 0x67, 0x8d, 0x44, 0x83, 0x10, // lea eax,[ebx + eax * 2 + 0x10]
                      0x66, 0xb8, 0x02, 0x00, 0x00, 0x00, // mov eax, 0x00000002
                      0x66, 0x67, 0x8d, 0x44, 0x84, 0x10, // lea eax,[esp + eax * 2 + 0x10]
                      0x66, 0xb8, 0x02, 0x00, 0x00, 0x00, // mov eax, 0x00000002
                      0x66, 0x67, 0x8d, 0x44, 0x85, 0x10, // lea eax,[ebp + eax * 2 + 0x10]
                      0x66, 0xb8, 0x02, 0x00, 0x00, 0x00, // mov eax, 0x00000002
                      0x66, 0x67, 0x8d, 0x44, 0x86, 0x10, // lea eax,[esi + eax * 2 + 0x10]
                      0x66, 0xb8, 0x02, 0x00, 0x00, 0x00, // mov eax, 0x00000002
                      0x66, 0x67, 0x8d, 0x44, 0x87, 0x10, // lea eax,[edi + eax * 2 + 0x10]
                      0x66, 0xb8, 0x02, 0x00, 0x00, 0x00, // mov eax, 0x00000002
                      0x66, 0x67, 0x8d, 0x84, 0x80, 0x10, 0x00, 0x00, 0x10, // lea eax,[eax + eax * 2 + 0x10000010]
                      0x66, 0xb8, 0x02, 0x00, 0x00, 0x00, // mov eax, 0x00000002
                      0x66, 0x67, 0x8d, 0x84, 0x81, 0x10, 0x00, 0x00, 0x10, // lea eax,[ecx + eax * 2 + 0x10000010]
                      0x66, 0xb8, 0x02, 0x00, 0x00, 0x00, // mov eax, 0x00000002
                      0x66, 0x67, 0x8d, 0x84, 0x82, 0x10, 0x00, 0x00, 0x10, // lea eax,[edx + eax * 2 + 0x10000010]
                      0x66, 0xb8, 0x02, 0x00, 0x00, 0x00, // mov eax, 0x00000002
                      0x66, 0x67, 0x8d, 0x84, 0x83, 0x10, 0x00, 0x00, 0x10, // lea eax,[ebx + eax * 2 + 0x10000010]
                      0x66, 0xb8, 0x02, 0x00, 0x00, 0x00, // mov eax, 0x00000002
                      0x66, 0x67, 0x8d, 0x84, 0x84, 0x10, 0x00, 0x00, 0x10, // lea eax,[esp + eax * 2 + 0x10000010]
                      0x66, 0xb8, 0x02, 0x00, 0x00, 0x00, // mov eax, 0x00000002
                      0x66, 0x67, 0x8d, 0x84, 0x85, 0x10, 0x00, 0x00, 0x10, // lea eax,[ebp + eax * 2 + 0x10000010]
                      0x66, 0xb8, 0x02, 0x00, 0x00, 0x00, // mov eax, 0x00000002
                      0x66, 0x67, 0x8d, 0x84, 0x86, 0x10, 0x00, 0x00, 0x10, // lea eax,[esi + eax * 2 + 0x10000010]
                      0x66, 0xb8, 0x02, 0x00, 0x00, 0x00, // mov eax, 0x00000002
                      0x66, 0x67, 0x8d, 0x84, 0x87, 0x10, 0x00, 0x00, 0x10, // lea eax,[edi + eax * 2 + 0x10000010]
                      0x90,                         // nop
                      0xfc,                         // cld
                      0xbe, 0x00, 0x00,             // mov si, 0x0000
                      0xbf, 0x02, 0x00,             // mov di, 0x0002
                      0xa4,                         // movsb
                      0x66, 0xb8, 0xaa, 0x55, 0xf0, 0x0f, // mov eax, 0x0ff055aa
                      0xbf, 0x00, 0x00,             // mov di, 0x0000
                      0xaa,                         // stosb
                      0xaa,                         // stosb
                      0xab,                         // stosw
                      0x66, 0xab,                   // stosd
                      0xb9, 0x04, 0x00,             // mov cx, 0x0004
                      0xf3, 0x66, 0xab,             // rep stosd
                      0x66, 0xb8, 0x5a, 0xa5, 0x00, 0xff, // mov eax, 0x0ff055aa
                      0xb9, 0x06, 0x00,             // mov cx, 0x0006
                      0xbf, 0x2c, 0x00,             // mov di, 0x002c
                      0xfd,                         // std
                      0xf3, 0x66, 0xab,             // rep stosd
                      0xc8, 0x00, 0x02, 0x00,       // enter 0x0200, 0x00
                      0xc9,                         // leave
                      0xc8, 0x00, 0x02, 0x01,       // enter 0x0200, 0x01
                      0xc9,                         // leave
                      0x66, 0xc8, 0x00, 0x02, 0x00, // enter 0x0200, 0x00
                      0x66, 0xc9,                   // leave
                      0x66, 0xc8, 0x00, 0x02, 0x01, // enter 0x0200, 0x01
                      0x66, 0xc9,                   // leave
                      0x66, 0xb8, 0x02, 0x00, 0xfe, 0xfe, // mov eax, 0xfefe0002
                      0x66, 0x89, 0x06, 0x04, 0x00, // mov ds:0x0004, eax
                      0x66, 0x89, 0x06, 0x08, 0x00, // mov ds:0x0008, eax
                      0xc4, 0x06, 0x04, 0x00,       // les ax,d:0x0004
                      0x0f, 0xb4, 0x0e, 0x04, 0x00, // lfs cx,d:0x0004
                      0x0f, 0xb5, 0x16, 0x04, 0x00, // lgs dx,d:0x0004
                      0x66, 0xc4, 0x1e, 0x04, 0x00, // les ebx,d:0x0004
                      0x66, 0x0f, 0xb4, 0x36, 0x04, 0x00, // lfs esi,d:0x0004
                      0x66, 0x0f, 0xb5, 0x3e, 0x04, 0x00, // lgs edi,d:0x0004
                      0xb8, 0x03, 0x00,             // mov ax, 0x0003
                      0x68, 0x10, 0x00,             // push 0x0010
                      0x9d,                         // popf
                      0x37,                         // aaa
                      0xd5, 0x0a,                   // aad
                      0xd4, 0x0a,                   // aam
                      0x27,                         // daa
                      0x2f,                         // das
                      0xb8, 0x03, 0x00,             // mov ax, 0x0003
                      0x68, 0x01, 0x00,             // push 0x0001
                      0x9d,                         // popf
                      0x37,                         // aaa
                      0xb8, 0x03, 0x00,             // mov ax, 0x0003
                      0x68, 0x10, 0x00,             // push 0x0010
                      0x9d,                         // popf
                      0x3f,                         // aas
                      0xd5, 0x0a,                   // aad
                      0xd4, 0x0a,                   // aam
                      0xb8, 0x03, 0x00,             // mov ax, 0x0003
                      0x68, 0x01, 0x00,             // push 0x0001
                      0x9d,                         // popf
                      0x3f,                         // aas
                      0xb8, 0x05, 0x00,             // mov ax, 0x0005
                      0xb9, 0x20, 0x00,             // mov cx, 0x0020
                      0xf8,                         // clc
                      0x0f, 0xa3, 0xc1,             // bt cx, ax
                      0xf8,                         // clc
                      0x0f, 0xb3, 0xc1,             // btr cx, ax
                      0xf9,                         // stc
                      0x0f, 0xab, 0xc1,             // bts cx, ax
                      0xf8,                         // clc
                      0x0f, 0xbb, 0xc1,             // btc cx, ax
                      0x66, 0xb8, 0x15, 0x00, 0x00, 0x00, // mov eax, 0x00000015
                      0x66, 0xb9, 0x00, 0x00, 0x20, 0x00, // mov ecx, 0x00200000
                      0xf8,                         // clc
                      0x66, 0x0f, 0xa3, 0xc1,       // bt ecx, eax
                      0xf8,                         // clc
                      0x66, 0x0f, 0xb3, 0xc1,       // btr ecx, eax
                      0xf9,                         // stc
                      0x66, 0x0f, 0xab, 0xc1,       // bts ecx, eax
                      0xf8,                         // clc
                      0x66, 0x0f, 0xbb, 0xc1,       // btc ecx, eax
                      0xb9, 0x20, 0x00,             // mov cx, 0x0020
                      0xf8,                         // clc
                      0x0f, 0xba, 0xe1, 0x05,       // bt cx, 0x05
                      0xf8,                         // clc
                      0x0f, 0xba, 0xf1, 0x05,       // btr cx, 0x05
                      0xf9,                         // stc
                      0x0f, 0xba, 0xe9, 0x05,       // bts cx, 0x05
                      0xf8,                         // clc
                      0x0f, 0xba, 0xf9, 0x05,       // btc cx, 0x05
                      0x66, 0xb9, 0x00, 0x00, 0x20, 0x00, // mov ecx, 0x00200000
                      0xf8,                         // clc
                      0x66, 0x0f, 0xba, 0xe1, 0x15, // bt ecx, 0x15
                      0xf8,                         // clc
                      0x66, 0x0f, 0xba, 0xf1, 0x15, // btr ecx, 0x15
                      0xf9,                         // stc
                      0x66, 0x0f, 0xba, 0xe9, 0x15, // bts ecx, 0x15
                      0xf8,                         // clc
                      0x66, 0x0f, 0xba, 0xf9, 0x15, // btc ecx, 0x15
                      0x66, 0xb8, 0x20, 0x00, 0x00, 0x00, // mov eax, 0x00000020
                      0x66, 0x89, 0x06, 0x08, 0x00, // mov ds:0x0008, eax
                      0xb8, 0x45, 0x00,             // mov ax, 0x0045
                      0xf8,                         // clc
                      0x0f, 0xa3, 0x06, 0x00, 0x00, // bt ds:0x0000, ax
                      0xf8,                         // clc
                      0x0f, 0xb3, 0x06, 0x00, 0x00, // btr ds:0x0000, ax
                      0xf9,                         // stc
                      0x0f, 0xab, 0x06, 0x00, 0x00, // bts ds:0x0000, ax
                      0xf8,                         // clc
                      0x0f, 0xbb, 0x06, 0x00, 0x00, // btc ds:0x0000, ax
                      0x66, 0xb8, 0x00, 0x00, 0x20, 0x00, // mov eax, 0x00200000
                      0x66, 0x89, 0x06, 0x08, 0x00, // mov ds:0x0008, eax
                      0x66, 0xb8, 0x55, 0x00, 0x00, 0x00, // mov eax, 0x00000055
                      0xf8,                         // clc
                      0x66, 0x0f, 0xa3, 0x06, 0x00, 0x00, // bt ds:0x0000, eax
                      0xf8,                         // clc
                      0x66, 0x0f, 0xb3, 0x06, 0x00, 0x00, // btr ds:0x0000, eax
                      0xf9,                         // stc
                      0x66, 0x0f, 0xab, 0x06, 0x00, 0x00, // bts ds:0x0000, eax
                      0xf8,                         // clc
                      0x66, 0x0f, 0xbb, 0x06, 0x00, 0x00, // btc ds:0x0000, eax
                      0xb8, 0xab, 0xab,             // mov ax, 0xabab
                      0xb9, 0x08, 0x00,             // mov cx, 0x0008
                      0xba, 0xfe, 0xfe,             // mov dx, 0xfefe
                      0x0f, 0xa4, 0xc2, 0x04,       // shld dx, ax, 0x04
                      0x0f, 0xa5, 0xc2,             // shld dx, ax, cl
                      0x66, 0xb8, 0xab, 0xab, 0xa5, 0x5a, // mov eax, 0x5aa5abab
                      0xb9, 0x08, 0x00,             // mov cx, 0x0008
                      0x66, 0xba, 0xfe, 0xfe, 0x12, 0x21, // mov edx, 0x2112fefe
                      0x66, 0x0f, 0xa4, 0xc2, 0x04, // shld edx, eax, 0x04
                      0x66, 0x0f, 0xa5, 0xc2,       // shld edx, eax, cl
                      0xb8, 0xab, 0xab,             // mov ax, 0xabab
                      0xb9, 0x08, 0x00,             // mov cx, 0x0008
                      0xba, 0xfe, 0xfe,             // mov dx, 0xfefe
                      0x0f, 0xac, 0xd0, 0x04,       // shld ax, dx, 0x04
                      0x0f, 0xad, 0xd0,             // shld ax, dx, cl
                      0x66, 0xb8, 0xab, 0xab, 0xa5, 0x5a, // mov eax, 0x5aa5abab
                      0xb9, 0x08, 0x00,             // mov cx, 0x0008
                      0x66, 0xba, 0xfe, 0xfe, 0x12, 0x21, // mov edx, 0x2112fefe
                      0x66, 0x0f, 0xac, 0xd0, 0x04, // shld eax, edx, 0x04
                      0x66, 0x0f, 0xad, 0xd0,       // shld eax, edx, cl
                      0xb0, 0xaa,                   // mov al, 0xaa
                      0xc0, 0xe0, 0x02,             // shl al, 0x02
                      0xb0, 0xaa,                   // mov al, 0xaa
                      0xc0, 0xe8, 0x03,             // shl al, 0x03
                      0xb0, 0xaa,                   // mov al, 0xaa
                      0xc0, 0xf8, 0x04,             // shl al, 0x04
//                      0xe8, 0x02, 0x00,             // call 0x0002
                      0x9a, 0x03, 0x00, 0x00, 0x20, // call 0x0003:0x2000
//                      0x66, 0xe8, 0x04, 0x00, 0x00, 0x00, // call 0x00000004
                      0x66, 0x9a, 0x06, 0x00, 0x00, 0x00, 0x00, 0x20, // call 0x00000006:0x2000
                      0x66, 0xb8, 0x02, 0x00, 0x00, 0x20, // mov eax, 0x20000002
                      0x66, 0x89, 0x06, 0x04, 0x00, // mov ds:0x0004, eax
                      0xff, 0x16, 0x04, 0x00,       // call ds:0x0004
                      0x66, 0xb8, 0x03, 0x00, 0x00, 0x20, // mov eax, 0x20000003
                      0x66, 0x89, 0x06, 0x04, 0x00, // mov ds:0x0004, eax
                      0xff, 0x1e, 0x04, 0x00,       // call ds:0x0004
                      0xb8, 0xaa, 0xaa,             // mov ax, 0xaaaa
                      0xc1, 0xe0, 0x02,             // shl ax, 0x02
                      0xb8, 0xaa, 0xaa,             // mov ax, 0xaaaa
                      0xc1, 0xe8, 0x03,             // shl ax, 0x03
                      0xb8, 0xaa, 0xaa,             // mov ax, 0xaaaa
                      0xc1, 0xf8, 0x04,             // shl ax, 0x04
                      0x66, 0xb8, 0xaa, 0xaa, 0xaa, 0xaa, // mov eax, 0xaaaaaaaa
                      0x66, 0xc1, 0xe0, 0x02,       // shl eax, 0x02
                      0x66, 0xb8, 0xaa, 0xaa, 0xaa, 0xaa, // mov eax, 0xaaaaaaaa
                      0x66, 0xc1, 0xe8, 0x03,       // shl eax, 0x03
                      0x66, 0xb8, 0xaa, 0xaa, 0xaa, 0xaa, // mov eax, 0xaaaaaaaa
                      0x66, 0xc1, 0xf8, 0x04,       // shl eax, 0x04
                      0xf0, 0x90,                   // lock nop
                      0x66, 0xb8, 0x12, 0x34, 0x56, 0x78, // mov eax, 0x78563412
                      0xe6, 0x04,                   // outb 0x04, al
                      0xe7, 0x08,                   // outw 0x09, ax
                      0x66, 0xe7, 0x0c,             // outd 0x0c, eax
                      0xba, 0x40, 0x00,             // mov dx, 0x0040
                      0xee,                         // outb dx, al
                      0x42,                         // inc dx
                      0x42,                         // inc dx
                      0xef,                         // outw dx, ax
                      0x42,                         // inc dx
                      0x42,                         // inc dx
                      0x66, 0xef,                   // outd dx, eax
                      0x66, 0xb8, 0x00, 0x00, 0x00, 0x00, // mov eax, 0x00000000
                      0xe4, 0x04,                   // inb al, 0x04
                      0xe5, 0x08,                   // inw ax, 0x08
                      0x66, 0xe5, 0x0c,             // ind eax, 0x0c
                      0x66, 0xb8, 0x00, 0x00, 0x00, 0x00, // mov eax, 0x00000000
                      0xba, 0x40, 0x00,             // mov dx, 0x0040
                      0xec,                         // inb al, dx
                      0x42,                         // inc dx
                      0x42,                         // inc dx
                      0xed,                         // inw ax, dx
                      0x42,                         // inc dx
                      0x42,                         // inc dx
                      0x66, 0xed,                   // ind eax, dx
//                      0xf4,                         // hlt (nop)
                      0xb8, 0x00, 0x00,              // mov ax, 0x0000
                      0x0f,0xbc, 0xc8,              // bsf cx, ax
                      0xb8, 0x00, 0x10,             // mov ax, 0x1000
                      0x0f,0xbc, 0xc8,              // bsf cx, ax
                      0xb8, 0x00, 0x00,             // mov ax, 0x0000
                      0x0f,0xbd, 0xc8,              // bsr cx, ax
                      0xb8, 0x10, 0x10,             // mov ax, 0x1010
                      0x0f,0xbd, 0xc8,              // bsr cx, ax
                      0x66, 0xb8, 0x00, 0x00, 0x00, 0x00, // mov eax, 0x00000000
                      0x66, 0x0f,0xbc, 0xc8,        // bsf ecx, eax
                      0x66, 0xb8, 0x00, 0x10, 0x00, 0x00, // mov eax, 0x00001000
                      0x66, 0x0f,0xbc, 0xc8,        // bsf ecx, eax
                      0x66, 0xb8, 0x00, 0x00, 0x00, 0x00, // mov eax, 0x00000000
                      0x66, 0x0f,0xbd, 0xc8,        // bsr ecx, eax
                      0x66, 0xb8, 0x10, 0x10, 0x00, 0x00, // mov eax, 0x00001010
                      0x66, 0x0f,0xbd, 0xc8,        // bsr ecx, eax
                      0xcc,                         // int 3
                      0xcd, 0x04,                   // int 0x04
                      0xcd, 0x05,                   // int 0x05
*/                      0x90,                         // nop
                      0x66, 0xb8, 0x11, 0x22, 0x33, 0x44, // mov eax, 0x44332211
                      0x66, 0x89, 0x06, 0x04, 0x00, // mov ds:0x0004, eax
                      0xb0, 0x01,                   // mov al, 0x01
                      0xbb, 0x03, 0x00,             // mov bx, 0x0003
                      0xd7,                         // xlat
                      0xb0, 0x02,                   // mov al, 0x01
                      0x66, 0xbb, 0x04, 0x00, 0x00, 0x00,  // mov ebx, 0x00000004
                      0x67, 0xd7,                   // xlat
                      0x66, 0xb8, 0x04, 0x00, 0x08, 0x00, // mov eax, 0x00080004
                      0x66, 0x89, 0x06, 0x04, 0x00, // mov ds:0x0004, eax
                      0x66, 0xb8, 0x04, 0x00, 0x08, 0x01, // mov eax, 0x01080004
                      0x66, 0x89, 0x06, 0x08, 0x00, // mov ds:0x0008, eax
                      0xb9, 0x04, 0x00,             // mov cx, 0x0004
                      0x62, 0x0e, 0x04, 0x00,       // bound cx, ds:0x0004
                      0x66, 0xb9, 0x04, 0x00, 0x08, 0x01, // mov ecx, 0x01080004
                      0x66, 0x62, 0x0e, 0x04, 0x00, // bound ecx, ds:0x0004
                      0x66, 0xb8, 0x11, 0x22, 0x33, 0x44, // mov eax, 0x44332211
                      0x0f, 0xc8, 0xc0,             // bswap ax
                      0x66, 0xb8, 0x11, 0x22, 0x33, 0x44, // mov eax, 0x44332211
                      0x66, 0x0f, 0xc8, 0xc0,       // bswap eax
                      0xb0, 0x01,                   // mov al, 0x01
                      0xb1, 0x01,                   // mov cl, 0x01
                      0xb2, 0xff,                   // mov dl, 0xff
                      0x0f, 0xb0, 0xd1,             // cmpxchg cl,dl
                      0xb0, 0x01,                   // mov al, 0x01
                      0xb1, 0x02,                   // mov cl, 0x02
                      0xb2, 0xff,                   // mov dl, 0xff
                      0x0f, 0xb0, 0xd1,             // cmpxchg cl,dl
                      0xb8, 0x01, 0x00,             // mov ax, 0x01
                      0xb9, 0x01, 0x00,             // mov cx, 0x01
                      0xba, 0xff, 0x00,             // mov dx, 0xff
                      0x0f, 0xb1, 0xd1,             // cmpxchg cx,dx
                      0xb8, 0x01, 0x00,             // mov ax, 0x01
                      0xb9, 0x02, 0x00,             // mov cx, 0x02
                      0xba, 0xff, 0x00,             // mov dx, 0xff
                      0x0f, 0xb1, 0xd1,             // cmpxchg cx,dx
                      0x66, 0xb8, 0x01, 0x00, 0x00, 0x00, // mov eax, 0x00000001
                      0x66, 0xb9, 0x01, 0x00, 0x00, 0x00, // mov ecx, 0x00000001
                      0x66, 0xba, 0xff, 0x00, 0x00, 0x00, // mov edx, 0x000000ff
                      0x66, 0x0f, 0xb1, 0xd1,             // cmpxchg ecx,edx
                      0x66, 0xb8, 0x01, 0x00, 0x00, 0x00, // mov eax, 0x00000001
                      0x66, 0xb9, 0x02, 0x00, 0x00, 0x00, // mov ecx, 0x00000002
                      0x66, 0xba, 0xff, 0x00, 0x00, 0x00, // mov edx, 0x000000ff
                      0x66, 0x0f, 0xb1, 0xd1,             // cmpxchg ecx,edx
                      0xb0, 0x01,                   // mov al, 0x01
                      0xb1, 0x02,                   // mov cl, 0x02
                      0x0f, 0xc0, 0xc8,             // xadd al,cl
                      0xb8, 0x01, 0x01,             // mov ax, 0x0101
                      0xb9, 0x02, 0x02,             // mov cx, 0x0202
                      0x0f, 0xc1, 0xc8,             // xadd ax,cx
                      0x66, 0xb8, 0x01, 0x01, 0x01, 0x01, // mov eax, 0x01010101
                      0x66, 0xb9, 0x02, 0x02, 0x02, 0x02, // mov ecx, 0x02020202
                      0x66, 0x0f, 0xc1, 0xc8,             // xadd eax,ecx
                      0xb8, 0x03, 0x00,             // mov ax, 0x0003
                      0x68, 0x10, 0x00,             // push 0x0010
                      0x9d,                         // popf
                      0x37,                         // aaa
                      0xd5, 0x0a,                   // aad
                      0xd4, 0x0a,                   // aam
                      0x27,                         // daa
                      0x2f,                         // das
                      0xb8, 0x03, 0x00,             // mov ax, 0x0003
                      0x68, 0x01, 0x00,             // push 0x0001
                      0x9d,                         // popf
                      0x37,                         // aaa
                      0xb8, 0x03, 0x00,             // mov ax, 0x0003
                      0x68, 0x10, 0x00,             // push 0x0010
                      0x9d,                         // popf
                      0x3f,                         // aas
                      0xd5, 0x0a,                   // aad
                      0xd4, 0x0a,                   // aam
                      0xb8, 0x03, 0x00,             // mov ax, 0x0003
                      0x68, 0x01, 0x00,             // push 0x0001
                      0x9d,                         // popf
                      0x3f,                         // aas
                      0xb0, 0x83,                   // mov al, 0x83
                      0x0f, 0x90, 0xc0,             // seto al
                      0xb0, 0x83,                   // mov al, 0x83
                      0x0f, 0x91, 0xc0,             // setno al
                      0x66, 0xb8, 0x00, 0x00, 0x00, 0x80, // mov eax, 0x80000000
                      0x66, 0xb9, 0x00, 0x00, 0x00, 0x80, // mov ecx, 0x80000000
                      0x66, 0x01, 0xc1,             // add ecx, eax
                      0x66, 0xb8, 0x00, 0x00, 0x00, 0x80, // mov eax, 0x80000000
                      0x66, 0xb9, 0x00, 0x00, 0x00, 0x80, // mov ecx, 0x80000000
                      0x66, 0x29, 0xc1,             // sub ecx, eax
                      0x66, 0xb8, 0x00, 0x00, 0x00, 0xb0, // mov eax, 0xb0000000
                      0x66, 0xb9, 0x00, 0x00, 0x00, 0x50, // mov ecx, 0x50000000
                      0x66, 0x01, 0xc1,             // add ecx, eax
                      0x66, 0xb8, 0xac, 0x08, 0x02, 0x08, // mov eax, 0x080208ac
                      0x66, 0xb9, 0x9b, 0x2a, 0xa4, 0xc8, // mov ecx, 0xc8a42a9b
                      0xf9,                         // stc
                      0x66, 0x1b, 0xc1,             // sbb eax, ecx
                      0x66, 0xb8, 0xcf, 0x33, 0xeb, 0xaf, // mov eax, 0xafeb33cf
                      0x66, 0xb9, 0x85, 0xed, 0xa5, 0xd0, // mov ecx, 0xd0a5ed85
                      0x66, 0x09, 0xc1,             // or ecx, eax
                      0xb4, 0xb3,                   // mov ah, 0xb3
                      0xb5, 0x0e,                   // mov ch, 0x0e
                      0x28, 0xe5,                   // sub ch, ah
                      0x66, 0xbf, 0x64, 0x4b, 0x7d, 0xdc, // mov edi, 0xdc7d4b64
                      0x66, 0xd1, 0xc7,             // rol edi, 1
                      0x66, 0xbe, 0xe7, 0x8b, 0x26, 0x34, // mov esi, 0x34268be7
                      0x66, 0xb9, 0x88, 0x00, 0x00, 0x00, // mov ecx, 0x00000088
                      0x66, 0xbf, 0x64, 0x4b, 0x7d, 0x8c, // mov edi, 0x8c7d4b64
                      0x66, 0xd1, 0xc7,             // rol edi, 1
                      0x66, 0x0f, 0xa4, 0xce, 0x1b, // shld esi, ecx, 0x1b
                      0x66, 0xbe, 0x98, 0x07, 0xe1, 0xeb, // mov esi, 0xebe10798
                      0x66, 0xb9, 0xa6, 0x50, 0x9b, 0xee, // mov ecx, 0xee9b50a6
                      0x66, 0xbf, 0x64, 0x4b, 0x7d, 0xdc, // mov edi, 0xdc7d4b64
                      0x66, 0xd1, 0xc7,             // rol edi, 1
                      0x66, 0x0f, 0xac, 0xce, 0x17, // shrd esi, ecx, 0x17
                      0xb0, 0x01,                   // mov al, 0x01
                      0xb7, 0x04,                   // mov bh, 0x04
                      0x0f, 0xb0, 0xc7,             // cmpxchg bh, al
                      0xcf,                         // iret
                      0xff};

//
// Define stack storage space.
//

ULONG StackSpace[4096 / 4];
ULONG DataSpace[4096 / 4];
ULONG IoSpace[4096 / 4];

//
// Define read and write I/O space functions.
//

ULONG
ReadIoSpace (
    IN XM_OPERATION_DATATYPE DataType,
    IN USHORT PortNumber
    )

{
    if (DataType == BYTE_DATA) {
        return *((UCHAR UNALIGNED *)((PUCHAR)(&IoSpace) + PortNumber));

    } else if (DataType == LONG_DATA) {
        return *((ULONG UNALIGNED *)((PUCHAR)(&IoSpace) + PortNumber));

    } else {
        return *((USHORT UNALIGNED *)((PUCHAR)(&IoSpace) + PortNumber));
    }
}

VOID
WriteIoSpace (
    IN XM_OPERATION_DATATYPE DataType,
    IN USHORT PortNumber,
    IN ULONG Value
    )

{

    if (DataType == BYTE_DATA) {
        *((UCHAR UNALIGNED *)((PUCHAR)(&IoSpace) + PortNumber)) = (UCHAR)Value;

    } else if (DataType == LONG_DATA) {
        *((ULONG UNALIGNED *)((PUCHAR)(&IoSpace) + PortNumber)) = Value;

    } else {
        *((USHORT UNALIGNED *)((PUCHAR)(&IoSpace) + PortNumber)) = (USHORT)Value;
    }

    return;
}

//
// Define address translation routine.
//

PVOID
TranslateAddress (
    IN USHORT Segment,
    IN USHORT Offset
    )

{

    ULONG Value;

    //
    // Case on high hex digit of segment.
    //

    Value = Offset + (Segment << 4);
    Offset = (USHORT)Value;
    Value &= 0xf0000;
    switch ((Value >> 16) & 0xf) {

        //
        // Interrupt vector/stack space.
        //

    case 0x0:
        return (PVOID)((PUCHAR)&StackSpace + Offset);

        //
        // Data space.
        //

    case 0x1:
        return (PVOID)((PUCHAR)&DataSpace + Offset);

        //
        // Code space.
        //

    case 0x2:
        return (PVOID)((PUCHAR)&CodeStream + Offset);

        //
        // No valid translation.
        //

    default:
        return NULL;
    }
}

VOID
__cdecl
main(
    int argc,
    char *argv[]
    )

{

    XM86_CONTEXT Context;
    PULONG Vector = &StackSpace[0];

    //
    // Initialize the emulator.
    //

    XmInitializeEmulator(0,
                         0x1000,
                         ReadIoSpace,
                         WriteIoSpace,
                         TranslateAddress);

    //
    // Initialize vector 255 and emulate an interrupt through that
    // vector.
    //

    Vector[3] = (0x2000 << 16) | 0x0008;
    Vector[4] = (0x2000 << 16) | 0x0008;
    Vector[5] = (0x2000 << 16) | 0x0008;
    Vector[255] = (0x2000 << 16) | 0x0000;
    Context.Eax = 0;
    Context.Ecx = 0;
    Context.Edx = 0;
    Context.Ebx = 0;
    Context.Ebp = 0;
    Context.Esi = 0;
    Context.Edi = 0;
    XmContext.SegmentRegister[DS] = 0x1000;
    XmEmulateInterrupt(255, &Context);
    return;
}
