/*++

Copyright (c) 1992  Digital Equipment Corporation

Module Name:

    qvdata.h

Abstract:

    This module contains all global mode settings used by the QVision driver.

Environment:

    Kernel mode

Revision History:


--*/


#include "dderror.h"
#include "devioctl.h"
#include "miniport.h"

#include "ntddvdeo.h"
#include "video.h"
#include "qv.h"

//
// Video mode table - Lists the information about each individual mode
//

QV_VIDEO_MODES QVModes[] = {

//  60 Hz modes (Monitor class 3)  

{
  MODE_32,                          // QVision Video mode
  MONITOR_CLASS_3,                  // QVision monitor class for 60 Hz
  {
      sizeof(VIDEO_MODE_INFORMATION), // Size of the mode informtion structure
      0,
      640,                          // X Resolution, in pixels
      480,                          // Y Resolution, in pixels
      1024,                    // Screen stride, in bytes (distance
                                    // between the start point of two
                                    // consecutive scan lines, in bytes)
      1,                            // Number of video memory planes
      8,                            // Number of bits per plane
      60,                             // Screen Frequency, in Hertz
      320,                          // Horizontal size of screen in millimeters
      240,                          // Vertical size of screen in millimeters
      8,                            // Number Red pixels in DAC
      8,                            // Number Green pixels in DAC
      8,                            // Number Blue pixels in DAC
      0x00000000,                   // Mask for Red Pixels in non-palette modes
      0x00000000,                   // Mask for Green Pixels in non-palette modes
      0x00000000,                   // Mask for Blue Pixels in non-palette modes
      VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS | VIDEO_MODE_PALETTE_DRIVEN |
          VIDEO_MODE_MANAGED_PALETTE,  // Mode description flags.
      1024,                         // Video Memory Bitmap Width
      1024                          // Video Memory Bitmap Height

    }
},
{
  MODE_34,                          // QVision Video mode
  MONITOR_CLASS_3,                  // QVision monitor class for 60 Hz
  {
      sizeof(VIDEO_MODE_INFORMATION),
      0,
      800,
      600,
      1024,
      1,
      8,
      60,
      320,
      240,
      8,
      8,
      8,
      0x00000000,
      0x00000000,
      0x00000000,
      VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS | VIDEO_MODE_PALETTE_DRIVEN |
          VIDEO_MODE_MANAGED_PALETTE,
      1024,                         // Video Memory Bitmap Width
      1024                          // Video Memory Bitmap Height
    }
},
{
  MODE_38,                          // QVision Video mode
  MONITOR_CLASS_3,                  // QVision monitor class for 60 Hz
  {
      sizeof(VIDEO_MODE_INFORMATION),
      0,
      1024,
      768,
      1024,
      1,
      8,
      60,
      320,
      240,
      8,
      8,
      8,
      0x00000000,
      0x00000000,
      0x00000000,
      VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS | VIDEO_MODE_PALETTE_DRIVEN |
          VIDEO_MODE_MANAGED_PALETTE,
      1024,                         // Video Memory Bitmap Width
      1024                          // Video Memory Bitmap Height

    }
},

//  75/72 Hz modes (Monitor class 2)

{
  MODE_32,                          // QVision Video mode
  MONITOR_CLASS_2,                  // QVision monitor class for  75Hz
  {
      sizeof(VIDEO_MODE_INFORMATION), // Size of the mode informtion structure
      0,
      640,                          // X Resolution, in pixels
      480,                          // Y Resolution, in pixels
      1024,                         // Screen stride, in bytes (distance
                                    // between the start point of two
                                    // consecutive scan lines, in bytes)
      1,                            // Number of video memory planes
      8,                            // Number of bits per plane
      75,                           // Screen Frequency, in Hertz
      320,                          // Horizontal size of screen in millimeters
      240,                          // Vertical size of screen in millimeters
      8,                            // Number Red pixels in DAC
      8,                            // Number Green pixels in DAC
      8,                            // Number Blue pixels in DAC
      0x00000000,                   // Mask for Red Pixels in non-palette modes
      0x00000000,                   // Mask for Green Pixels in non-palette modes
      0x00000000,                   // Mask for Blue Pixels in non-palette modes
      VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS | VIDEO_MODE_PALETTE_DRIVEN |
          VIDEO_MODE_MANAGED_PALETTE, // Mode description flags.
      1024,                         // Video Memory Bitmap Width
      1024                          // Video Memory Bitmap Height
    }
},
{
  MODE_34,                          // QVision Video mode
  MONITOR_CLASS_2,                  // QVision monitor class for  72Hz
  {
      sizeof(VIDEO_MODE_INFORMATION),
      0,
      800,
      600,
      1024,
      1,
      8,
      72,
      320,
      240,
      8,
      8,
      8,
      0x00000000,
      0x00000000,
      0x00000000,
      VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS | VIDEO_MODE_PALETTE_DRIVEN |
          VIDEO_MODE_MANAGED_PALETTE,
      1024,                         // Video Memory Bitmap Width
      1024                          // Video Memory Bitmap Height
    }
},
{
  MODE_38,                          // QVision Video mode
  MONITOR_CLASS_2,                  // QVision monitor class for  72Hz
  {
      sizeof(VIDEO_MODE_INFORMATION),
      0,
      1024,
      768,
      1024,
      1,
      8,
      72,
      320,
      240,
      8,
      8,
      8,
      0x00000000,
      0x00000000,
      0x00000000,
      VIDEO_MODE_COLOR | VIDEO_MODE_GRAPHICS | VIDEO_MODE_PALETTE_DRIVEN |
          VIDEO_MODE_MANAGED_PALETTE,
      1024,                         // Video Memory Bitmap Width
      1024                          // Video Memory Bitmap Height
    }
}

};

ULONG NumVideoModes = sizeof(QVModes) / sizeof(QV_VIDEO_MODES);

/*************************************************************************
 * SetMode register values
 *
 * The following data tables are used by the SetMode function to load
 * the appropriate register values for a video mode switch.  Each table
 * contains 8 entries which can be either a single value or another table.
 * These entries correspond to register values for one of the eight new
 * Triton video modes as follows:
 *
 *            Video Mode       Mode Type         Table Index
 *            ----------       ----------             -----------
 *                32            640x480x8             0
 *                34            800x600x8             1
 *                38           1024x768x8             2
 *                3B           512x480x16             3
 *                3C           640x400x16             4
 *                3E           640x480x16             5
 *                4D           512x480x32             6
 *                4E           640x400x32             7
 *
 *
 * The first group of tables below contain one set of values which apply
 * to all classes of monitors.  For these tables, the first index selects
 * the video mode and the second (if applicable) selects the port index.
 * The second group of tables contain a set of values for each monitor
 * class.  For these tables, the first index selects the monitor class,
 * the second selects the video mode, and the third (if applicable) selects
 * the port index.  Four monitor classes are currently defined (see the
 * SetMode header) but more may be added by simply appending a new set of
 * register values for the new monitor class to the appropriate data tables
 * below and incrementing the #define constant, MON_CLASS_CNT.   Note that
 * monitor class 3 is a special case in that its true register values are
 * loaded at run time.
 *
 *************************************************************************/


/*************************************************************************
 * The following tables have only one set of values which apply to all
 * monitor classes.
 *************************************************************************/

/* Sequencer register values (3C5.00 - 3C5.04) */
UCHAR abSeq[MODE_CNT][SEQ_CNT] = {
   { 0x01, 0x01, 0xff, 0x00, 0x0e },
   { 0x03, 0x01, 0xff, 0x00, 0x0e }, // MODE_34
   { 0x01, 0x01, 0xff, 0x00, 0x0e },
   { 0x01, 0x01, 0xff, 0x00, 0x0e },
   { 0x01, 0x01, 0xff, 0x00, 0x0e },
   { 0x01, 0x01, 0xff, 0x00, 0x0e },
   { 0x01, 0x01, 0xff, 0x00, 0x0e },
   { 0x01, 0x01, 0xff, 0x00, 0x0e }  };

/* Attribute Controller register values (3C0.00 - 3C0.13h) */
UCHAR abAttr[MODE_CNT][ATTR_CNT] = {
   { 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a,
     0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x41, 0x00, 0x0f, 0x00 },
   { 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a,
     0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x41, 0x00, 0x0f, 0x00 },
   { 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a,
     0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x41, 0x00, 0x0f, 0x00 },
   { 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a,
     0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x41, 0x00, 0x0f, 0x00 },
   { 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a,
     0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x41, 0x00, 0x0f, 0x00 },
   { 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a,
     0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x41, 0x00, 0x0f, 0x00 },
   { 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a,
     0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x41, 0x00, 0x0f, 0x00 },
   { 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a,
     0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x41, 0x00, 0x0f, 0x00 } };

/* Graphics Controller register values (3CF.00 - 3CF.08) */
UCHAR abGraphics[MODE_CNT][GRFX_CNT] = {
   { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0f, 0xff },
   { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0f, 0xff },
   { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0f, 0xff },
   { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0f, 0xff },
   { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0f, 0xff },
   { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0f, 0xff },
   { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0f, 0xff },
   { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0f, 0xff } };

/* Control Register 1 values (63CA) */
UCHAR abCtrlReg1[MODE_CNT] =
   { 0x03, 0x03, 0x03, 0x05, 0x05, 0x05, 0x07, 0x07 };

/* DAC Command Register 1 values (13C8) */
UCHAR abDacCmd1[MODE_CNT] =
   { 0x40, 0x40, 0x40, 0x20, 0x20, 0x20, 0x00, 0x00 };

/* Overflow Register 1 values (3CF.42h) */
UCHAR abOverflow1[MODE_CNT] =
   { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01 };


/*************************************************************************
 * The following tables have a different set of values for each monitor
 * class.
 *************************************************************************/

/* CRTC register values (3D5.00 - 3D5.18h) */
UCHAR abCrtc[MON_CLASS_CNT][MODE_CNT][CRTC_CNT] = {
        {
   /* CRTC register values for monitor class 0 */
   { 0x5f, 0x4f, 0x50, 0x81, 0x53, 0x9f, 0x0b, 0x3e, 0x00, 0x40, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0x8c, 0xdf, 0x80, 0x00, 0xe5,
     0x03, 0xe3, 0xff },
   { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
     0x00, 0x00, 0x00 },
   { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
     0x00, 0x00, 0x00 },
   { 0x4a, 0x3f, 0x3f, 0x8d, 0x42, 0x0c, 0x0e, 0x3e, 0x00, 0x40, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x00, 0xec, 0x8e, 0xdf, 0x80, 0x00, 0xe5,
     0x06, 0xe3, 0xff },
   { 0x5f, 0x4f, 0x50, 0x81, 0x53, 0x9f, 0x0b, 0x3e, 0x00, 0x40, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x00, 0xc2, 0x84, 0x8f, 0xa0, 0x00, 0x95,
     0x03, 0xe3, 0xff },
   { 0x5f, 0x4f, 0x50, 0x81, 0x53, 0x9f, 0x0b, 0x3e, 0x00, 0x40, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0x8c, 0xdf, 0xa0, 0x00, 0xe5,
     0x03, 0xe3, 0xff },
   { 0x4a, 0x3f, 0x3f, 0x8d, 0x42, 0x0c, 0x0e, 0x3e, 0x00, 0x40, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x00, 0xec, 0x8e, 0xdf, 0x00, 0x00, 0xe5,
     0x06, 0xe3, 0xff },
   { 0x5f, 0x4f, 0x50, 0x81, 0x53, 0x9f, 0x0b, 0x3e, 0x00, 0x40, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x00, 0xc2, 0x84, 0x8f, 0x40, 0x00, 0x95,
     0x03, 0xe3, 0xff }
   },
        {
   /* CRTC register values for monitor class 1 */
   { 0x5f, 0x4f, 0x50, 0x81, 0x53, 0x9f, 0x0b, 0x3e, 0x00, 0x40, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0x8c, 0xdf, 0x80, 0x00, 0xe5,
     0x03, 0xe3, 0xff },
   { 0xa1, 0x7f, 0x7f, 0x84, 0x87, 0x9d, 0x2e, 0xf5, 0x00, 0x60, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x8b, 0xff, 0x40, 0x00, 0xff,
     0x2e, 0xe3, 0xff },
   { 0xa1, 0x7f, 0x7f, 0x84, 0x85, 0x9b, 0x2e, 0xf5, 0x00, 0x60, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x8b, 0xff, 0x80, 0x00, 0xff,
     0x2e, 0xe3, 0xff },
   { 0x4a, 0x3f, 0x3f, 0x8d, 0x42, 0x0c, 0x0e, 0x3e, 0x00, 0x40, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x00, 0xec, 0x8e, 0xdf, 0x80, 0x00, 0xe5,
     0x06, 0xe3, 0xff },
   { 0x5f, 0x4f, 0x50, 0x81, 0x53, 0x9f, 0x0b, 0x3e, 0x00, 0x40, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x00, 0xc2, 0x84, 0x8f, 0xa0, 0x00, 0x95,
     0x03, 0xe3, 0xff },
   { 0x5f, 0x4f, 0x50, 0x81, 0x53, 0x9f, 0x0b, 0x3e, 0x00, 0x40, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0x8c, 0xdf, 0xa0, 0x00, 0xe5,
     0x03, 0xe3, 0xff },
   { 0x4a, 0x3f, 0x3f, 0x8d, 0x42, 0x0c, 0x0e, 0x3e, 0x00, 0x40, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x00, 0xec, 0x8e, 0xdf, 0x00, 0x00, 0xe5,
     0x06, 0xe3, 0xff },
   { 0x5f, 0x4f, 0x50, 0x81, 0x53, 0x9f, 0x0b, 0x3e, 0x00, 0x40, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x00, 0xc2, 0x84, 0x8f, 0x40, 0x00, 0x95,
     0x03, 0xe3, 0xff }
   },
   {
   /* CRTC register values for monitor class 2 */
   { 0x69, 0x4f, 0x55, 0x86, 0x58, 0x80, 0x56, 0xb2, 0x00, 0x60, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x83, 0xdf, 0x80, 0x00, 0x01,
     0x32, 0xe3, 0xff }, // MODE_32
   { 0x8b, 0x63, 0x66, 0x8b, 0x6d, 0x1d, 0xe9, 0xf0, 0x00, 0x60, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x00, 0x87, 0x8a, 0x57, 0x80, 0x00, 0x6e,
     0xd1, 0xe3, 0xff }, // MODE_34
   { 0x9e, 0x7f, 0x7f, 0x81, 0x83, 0x93, 0x1e, 0xf1, 0x00, 0x60, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x83, 0xff, 0x80, 0x00, 0xff,
     0x1e, 0xe3, 0xff }, // MODE_38
   { 0x54, 0x3f, 0x44, 0x92, 0x47, 0x0d, 0x56, 0xb2, 0x00, 0x60, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x83, 0xdf, 0x80, 0x00, 0x01,
     0x32, 0xe3, 0xff },
   { 0x5f, 0x4f, 0x50, 0x82, 0x54, 0x80, 0xbf, 0x1f, 0x00, 0x40, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0x8e, 0x8f, 0x50, 0x00, 0x96,
     0xb9, 0xe3, 0xff },
   { 0x69, 0x4f, 0x55, 0x86, 0x58, 0x80, 0x56, 0xb2, 0x00, 0x60, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x83, 0xdf, 0xa0, 0x00, 0x01,
     0x32, 0xe3, 0xff },
   { 0x54, 0x3f, 0x44, 0x92, 0x47, 0x0d, 0x56, 0xb2, 0x00, 0x60, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x83, 0xdf, 0x00, 0x00, 0x01,
     0x32, 0xe3, 0xff },
   { 0x5f, 0x4f, 0x50, 0x82, 0x54, 0x80, 0xbf, 0x1f, 0x00, 0x40, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x00, 0x9c, 0x8e, 0x8f, 0x50, 0x00, 0x96,
     0xb9, 0xe3, 0xff }
   },
   {
   /* CRTC register array for monitor class 3 (3rd party) */
   { 0x5f, 0x4f, 0x50, 0x81, 0x53, 0x9f, 0x0b, 0x3e, 0x00, 0x40, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x00, 0xea, 0x8c, 0xdf, 0x80, 0x00, 0xe5,
     0x03, 0xe3, 0xff }, // MODE_32
   { 0x7f, 0x63, 0x64, 0x80, 0x68, 0x19, 0x73, 0xf0, 0x00, 0x60, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x00, 0x58, 0x8c, 0x57, 0x80, 0x00, 0x58,
     0x72, 0xe3, 0xff }, // MODE_34
   { 0x9b, 0x7f, 0x7f, 0x9e, 0x87, 0x17, 0x31, 0xf5, 0x00, 0x60, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x94, 0xff, 0x80, 0x00, 0xff,
     0x31, 0xe3, 0xff }, // MODE_38
   { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
     0x00, 0x00, 0x00 },
   { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
     0x00, 0x00, 0x00 },
   { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
     0x00, 0x00, 0x00 },
   { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
     0x00, 0x00, 0x00 },
   { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
     0x00, 0x00, 0x00 }
   } };

/* Miscellaneous Output Reg. values (3C2) */
UCHAR abMiscOut[MON_CLASS_CNT][MODE_CNT] =
   {
   /* Monitor class 0 */
   { 0xef, 0x00, 0x00, 0xf7, 0x6f, 0xef, 0xf7, 0x6f },

   /* Monitor class 1 */
   { 0xef, 0x27, 0x27, 0xf7, 0x6f, 0xef, 0xf7, 0x6f },

   /* Monitor class 2 */
   { 0xf3, 0x23, 0x2b, 0xfb, 0x6f, 0xf3, 0xfb, 0x6f }, // mode 32, 34, 38...

   /* Monitor class 3 (loaded later) */
   { 0xef, 0xf3, 0xe3, 0x00, 0x00, 0x00, 0x00, 0x00 }  // mode 32, 34, 38...
   };

/* Overflow Register 2 values (3CF.51h) */
UCHAR abOverflow2[MON_CLASS_CNT][MODE_CNT] =
   {
   /* Monitor class 0 */
   { 0x08, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08 },

   /* Monitor class 1 */
   { 0x08, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08 },

   /* Monitor class 2 */
   { 0x28, 0x20, 0x00, 0x08, 0x28, 0x28, 0x08, 0x28 }, // [1] = MODE_34

   /* Monitor class 3 (loaded later) */
   { 0x08, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }  // [1] = MODE_34
   };
